/*
 * Decompiled with CFR 0.152.
 */
package pdftk.com.lowagie.text;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import pdftk.com.lowagie.text.DocListener;
import pdftk.com.lowagie.text.DocumentException;
import pdftk.com.lowagie.text.Element;
import pdftk.com.lowagie.text.ExceptionConverter;
import pdftk.com.lowagie.text.Header;
import pdftk.com.lowagie.text.Meta;
import pdftk.com.lowagie.text.PageSize;
import pdftk.com.lowagie.text.Rectangle;

public class Document
implements DocListener {
    private static final String ITEXT_VERSION = "itext-paulo-155 (itextpdf.sf.net - lowagie.com)";
    public static boolean compress = true;
    private ArrayList listeners = new ArrayList();
    protected boolean open;
    protected boolean close;
    protected Rectangle pageSize;
    protected float marginLeft = 0.0f;
    protected float marginRight = 0.0f;
    protected float marginTop = 0.0f;
    protected float marginBottom = 0.0f;
    protected boolean marginMirroring = false;
    protected String javaScript_onLoad = null;
    protected String javaScript_onUnLoad = null;
    protected String htmlStyleClass = null;
    protected int pageN = 0;

    public Document() {
        this(PageSize.A4);
    }

    public Document(Rectangle pageSize) {
        this(pageSize, 36.0f, 36.0f, 36.0f, 36.0f);
    }

    public Document(Rectangle pageSize, float marginLeft, float marginRight, float marginTop, float marginBottom) {
        this.pageSize = pageSize;
        this.marginLeft = marginLeft;
        this.marginRight = marginRight;
        this.marginTop = marginTop;
        this.marginBottom = marginBottom;
    }

    public void addDocListener(DocListener listener) {
        this.listeners.add(listener);
    }

    public void removeDocListener(DocListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public boolean add(Element element) throws DocumentException {
        if (this.close) {
            throw new DocumentException("The document has been closed. You can't add any Elements.");
        }
        int type = element.type();
        if (this.open) {
            if (type != 10 && type != 11 && type != 12 && type != 22 && type != 23 && type != 40 && type != 17 && type != 29 && type != 16 && type != 13 && type != 14 && type != 15 && type != 30 && type != 32 && type != 34 && type != 35 && type != 39) {
                throw new DocumentException("The document is open; you can only add Elements with content.");
            }
        } else if (type != 0 && type != 1 && type != 2 && type != 3 && type != 4 && type != 5 && type != 7 && type != 6) {
            throw new DocumentException("The document is not open yet; you can only add Meta information.");
        }
        boolean success = false;
        for (DocListener listener : this.listeners) {
            success |= listener.add(element);
        }
        return success;
    }

    @Override
    public void open() {
        if (!this.close) {
            this.open = true;
        }
        for (DocListener listener : this.listeners) {
            listener.setPageSize(this.pageSize);
            listener.setMargins(this.marginLeft, this.marginRight, this.marginTop, this.marginBottom);
            listener.open();
        }
    }

    @Override
    public boolean setPageSize(Rectangle pageSize) {
        this.pageSize = pageSize;
        for (DocListener listener : this.listeners) {
            listener.setPageSize(pageSize);
        }
        return true;
    }

    @Override
    public boolean setMargins(float marginLeft, float marginRight, float marginTop, float marginBottom) {
        this.marginLeft = marginLeft;
        this.marginRight = marginRight;
        this.marginTop = marginTop;
        this.marginBottom = marginBottom;
        for (DocListener listener : this.listeners) {
            listener.setMargins(marginLeft, marginRight, marginTop, marginBottom);
        }
        return true;
    }

    @Override
    public boolean newPage() throws DocumentException {
        if (!this.open || this.close) {
            return false;
        }
        for (DocListener listener : this.listeners) {
            listener.newPage();
        }
        return true;
    }

    @Override
    public void resetPageCount() {
        this.pageN = 0;
        for (DocListener listener : this.listeners) {
            listener.resetPageCount();
        }
    }

    @Override
    public void setPageCount(int pageN) {
        this.pageN = pageN;
        for (DocListener listener : this.listeners) {
            listener.setPageCount(pageN);
        }
    }

    public int getPageNumber() {
        return this.pageN;
    }

    @Override
    public void close() {
        if (!this.close) {
            this.open = false;
            this.close = true;
        }
        for (DocListener listener : this.listeners) {
            listener.close();
        }
    }

    public boolean addHeader(String name, String content) {
        try {
            return this.add(new Header(name, content));
        }
        catch (DocumentException de) {
            throw new ExceptionConverter(de);
        }
    }

    public boolean addTitle(String title) {
        try {
            return this.add(new Meta(1, title));
        }
        catch (DocumentException de) {
            throw new ExceptionConverter(de);
        }
    }

    public boolean addSubject(String subject) {
        try {
            return this.add(new Meta(2, subject));
        }
        catch (DocumentException de) {
            throw new ExceptionConverter(de);
        }
    }

    public boolean addKeywords(String keywords) {
        try {
            return this.add(new Meta(3, keywords));
        }
        catch (DocumentException de) {
            throw new ExceptionConverter(de);
        }
    }

    public boolean addAuthor(String author) {
        try {
            return this.add(new Meta(4, author));
        }
        catch (DocumentException de) {
            throw new ExceptionConverter(de);
        }
    }

    public boolean addCreator(String creator) {
        try {
            return this.add(new Meta(7, creator));
        }
        catch (DocumentException de) {
            throw new ExceptionConverter(de);
        }
    }

    public boolean addProducer() {
        try {
            return this.add(new Meta(5, "iText by lowagie.com"));
        }
        catch (DocumentException de) {
            throw new ExceptionConverter(de);
        }
    }

    public boolean addCreationDate() {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
            return this.add(new Meta(6, sdf.format(new Date())));
        }
        catch (DocumentException de) {
            throw new ExceptionConverter(de);
        }
    }

    public float leftMargin() {
        return this.marginLeft;
    }

    public float rightMargin() {
        return this.marginRight;
    }

    public float topMargin() {
        return this.marginTop;
    }

    public float bottomMargin() {
        return this.marginBottom;
    }

    public float left() {
        return this.pageSize.left(this.marginLeft);
    }

    public float right() {
        return this.pageSize.right(this.marginRight);
    }

    public float top() {
        return this.pageSize.top(this.marginTop);
    }

    public float bottom() {
        return this.pageSize.bottom(this.marginBottom);
    }

    public float left(float margin) {
        return this.pageSize.left(this.marginLeft + margin);
    }

    public float right(float margin) {
        return this.pageSize.right(this.marginRight + margin);
    }

    public float top(float margin) {
        return this.pageSize.top(this.marginTop + margin);
    }

    public float bottom(float margin) {
        return this.pageSize.bottom(this.marginBottom + margin);
    }

    public Rectangle getPageSize() {
        return this.pageSize;
    }

    public boolean isOpen() {
        return this.open;
    }

    public static final String getVersion() {
        return ITEXT_VERSION;
    }

    public void setJavaScript_onLoad(String code) {
        this.javaScript_onLoad = code;
    }

    public String getJavaScript_onLoad() {
        return this.javaScript_onLoad;
    }

    public void setJavaScript_onUnLoad(String code) {
        this.javaScript_onUnLoad = code;
    }

    public String getJavaScript_onUnLoad() {
        return this.javaScript_onUnLoad;
    }

    public void setHtmlStyleClass(String htmlStyleClass) {
        this.htmlStyleClass = htmlStyleClass;
    }

    public String getHtmlStyleClass() {
        return this.htmlStyleClass;
    }

    @Override
    public void clearTextWrap() throws DocumentException {
        if (this.open && !this.close) {
            for (DocListener listener : this.listeners) {
                listener.clearTextWrap();
            }
        }
    }

    @Override
    public boolean setMarginMirroring(boolean marginMirroring) {
        this.marginMirroring = marginMirroring;
        for (DocListener listener : this.listeners) {
            listener.setMarginMirroring(marginMirroring);
        }
        return true;
    }

    public boolean isMarginMirroring() {
        return this.marginMirroring;
    }
}

