/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.security;

import com.sun.jmx.remote.security.FileLoginModule;
import com.sun.jmx.remote.util.ClassLogger;
import com.sun.jmx.remote.util.EnvHelp;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.management.remote.JMXAuthenticator;
import javax.security.auth.AuthPermission;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public final class JMXPluggableAuthenticator
implements JMXAuthenticator {
    private LoginContext loginContext;
    private String username;
    private String password;
    private static final String LOGIN_CONFIG_PROP = "jmx.remote.x.login.config";
    private static final String LOGIN_CONFIG_NAME = "JMXPluggableAuthenticator";
    private static final String PASSWORD_FILE_PROP = "jmx.remote.x.password.file";
    private static final ClassLogger logger = new ClassLogger("javax.management.remote.misc", "JMXPluggableAuthenticator");

    public JMXPluggableAuthenticator(Map<?, ?> env) {
        block8: {
            String loginConfigName = null;
            String passwordFile = null;
            if (env != null) {
                loginConfigName = (String)env.get(LOGIN_CONFIG_PROP);
                passwordFile = (String)env.get(PASSWORD_FILE_PROP);
            }
            try {
                if (loginConfigName != null) {
                    this.loginContext = new LoginContext(loginConfigName, new JMXCallbackHandler());
                    break block8;
                }
                SecurityManager sm = System.getSecurityManager();
                if (sm != null) {
                    sm.checkPermission(new AuthPermission("createLoginContext.JMXPluggableAuthenticator"));
                }
                final String pf = passwordFile;
                try {
                    this.loginContext = AccessController.doPrivileged(new PrivilegedExceptionAction<LoginContext>(){

                        @Override
                        public LoginContext run() throws LoginException {
                            return new LoginContext(JMXPluggableAuthenticator.LOGIN_CONFIG_NAME, null, new JMXCallbackHandler(), new FileLoginConfig(pf));
                        }
                    });
                }
                catch (PrivilegedActionException pae) {
                    throw (LoginException)pae.getException();
                }
            }
            catch (LoginException le) {
                JMXPluggableAuthenticator.authenticationFailure("authenticate", le);
            }
            catch (SecurityException se) {
                JMXPluggableAuthenticator.authenticationFailure("authenticate", se);
            }
        }
    }

    @Override
    public Subject authenticate(Object credentials) {
        String message;
        String[] aCredentials;
        if (!(credentials instanceof String[])) {
            if (credentials == null) {
                JMXPluggableAuthenticator.authenticationFailure("authenticate", "Credentials required");
            }
            String message2 = "Credentials should be String[] instead of " + credentials.getClass().getName();
            JMXPluggableAuthenticator.authenticationFailure("authenticate", message2);
        }
        if ((aCredentials = (String[])credentials).length != 2) {
            message = "Credentials should have 2 elements not " + aCredentials.length;
            JMXPluggableAuthenticator.authenticationFailure("authenticate", message);
        }
        this.username = aCredentials[0];
        this.password = aCredentials[1];
        if (this.username == null || this.password == null) {
            message = "Username or password is null";
            JMXPluggableAuthenticator.authenticationFailure("authenticate", "Username or password is null");
        }
        try {
            this.loginContext.login();
            final Subject subject = this.loginContext.getSubject();
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    subject.setReadOnly();
                    return null;
                }
            });
            return subject;
        }
        catch (LoginException le) {
            JMXPluggableAuthenticator.authenticationFailure("authenticate", le);
            return null;
        }
    }

    private static void authenticationFailure(String method, String message) throws SecurityException {
        String msg = "Authentication failed! " + message;
        SecurityException e = new SecurityException(msg);
        JMXPluggableAuthenticator.logException(method, msg, e);
        throw e;
    }

    private static void authenticationFailure(String method, Exception exception) throws SecurityException {
        SecurityException se;
        String msg;
        if (exception instanceof SecurityException) {
            msg = exception.getMessage();
            se = (SecurityException)exception;
        } else {
            msg = "Authentication failed! " + exception.getMessage();
            SecurityException e = new SecurityException(msg);
            EnvHelp.initCause(e, exception);
            se = e;
        }
        JMXPluggableAuthenticator.logException(method, msg, se);
        throw se;
    }

    private static void logException(String method, String message, Exception e) {
        if (logger.traceOn()) {
            logger.trace(method, message);
        }
        if (logger.debugOn()) {
            logger.debug(method, e);
        }
    }

    private static class FileLoginConfig
    extends Configuration {
        private AppConfigurationEntry[] entries;
        private static final String FILE_LOGIN_MODULE = FileLoginModule.class.getName();
        private static final String PASSWORD_FILE_OPTION = "passwordFile";

        public FileLoginConfig(String passwordFile) {
            Map<String, String> options;
            if (passwordFile != null) {
                options = new HashMap(1);
                options.put(PASSWORD_FILE_OPTION, passwordFile);
            } else {
                options = Collections.emptyMap();
            }
            this.entries = new AppConfigurationEntry[]{new AppConfigurationEntry(FILE_LOGIN_MODULE, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            return name.equals(JMXPluggableAuthenticator.LOGIN_CONFIG_NAME) ? this.entries : null;
        }

        @Override
        public void refresh() {
        }
    }

    private final class JMXCallbackHandler
    implements CallbackHandler {
        private JMXCallbackHandler() {
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (int i = 0; i < callbacks.length; ++i) {
                if (callbacks[i] instanceof NameCallback) {
                    ((NameCallback)callbacks[i]).setName(JMXPluggableAuthenticator.this.username);
                    continue;
                }
                if (callbacks[i] instanceof PasswordCallback) {
                    ((PasswordCallback)callbacks[i]).setPassword(JMXPluggableAuthenticator.this.password.toCharArray());
                    continue;
                }
                throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
            }
        }
    }
}

