/*
 * Decompiled with CFR 0.152.
 */
package sun.security.tools.policytool;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import sun.security.provider.PolicyParser;
import sun.security.tools.policytool.PolicyTool;
import sun.security.tools.policytool.TaggedList;
import sun.security.tools.policytool.ToolDialog;
import sun.security.tools.policytool.ToolWindow;

class NewPolicyPermOKButtonListener
implements ActionListener {
    private PolicyTool tool;
    private ToolWindow tw;
    private ToolDialog listDialog;
    private ToolDialog infoDialog;
    private boolean edit;

    NewPolicyPermOKButtonListener(PolicyTool tool, ToolWindow tw, ToolDialog listDialog, ToolDialog infoDialog, boolean edit) {
        this.tool = tool;
        this.tw = tw;
        this.listDialog = listDialog;
        this.infoDialog = infoDialog;
        this.edit = edit;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            PolicyParser.PermissionEntry pppe = this.infoDialog.getPermFromDialog();
            try {
                this.tool.verifyPermission(pppe.permission, pppe.name, pppe.action);
            }
            catch (ClassNotFoundException cnfe) {
                MessageFormat form = new MessageFormat(PolicyTool.rb.getString("Warning.Class.not.found.class"));
                Object[] source = new Object[]{pppe.permission};
                this.tool.warnings.addElement(form.format(source));
                this.tw.displayStatusDialog(this.infoDialog, form.format(source));
            }
            TaggedList permList = (TaggedList)this.listDialog.getComponent(8);
            String permString = ToolDialog.PermissionEntryToUserFriendlyString(pppe);
            if (this.edit) {
                int which = permList.getSelectedIndex();
                permList.replaceTaggedItem(permString, pppe, which);
            } else {
                permList.addTaggedItem(permString, pppe);
            }
            this.infoDialog.dispose();
        }
        catch (InvocationTargetException ite) {
            this.tw.displayErrorDialog((Window)this.infoDialog, ite.getTargetException());
        }
        catch (Exception ee) {
            this.tw.displayErrorDialog((Window)this.infoDialog, ee);
        }
    }
}

