/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.views.environment;

import org.graalvm.visualvm.core.ui.DataSourceView;
import org.graalvm.visualvm.core.ui.DataSourceViewProvider;
import org.graalvm.visualvm.jfr.JFRSnapshot;
import org.graalvm.visualvm.jfr.model.JFREventChecker;
import org.graalvm.visualvm.jfr.views.environment.JFRSnapshotEnvironmentView;

public class JFRSnapshotEnvironmentViewProvider
extends DataSourceViewProvider<JFRSnapshot> {
    static final String EVENT_CPU_INFO = "jdk.CPUInformation";
    static final String EVENT_PHYSICAL_MEMORY = "jdk.PhysicalMemory";
    static final String EVENT_OS_INFO = "jdk.OSInformation";
    static final String EVENT_CPU_LOAD = "jdk.CPULoad";
    static final String EVENT_NETWORK_UTILIZATION = "jdk.NetworkUtilization";
    static final String EVENT_ENVIRONMENT_VARIABLE = "jdk.InitialEnvironmentVariable";
    static final String EVENT_SYSTEM_PROCESS = "jdk.SystemProcess";

    protected boolean supportsViewFor(JFRSnapshot jfrSnapshot) {
        return true;
    }

    protected DataSourceView createView(JFRSnapshot jfrSnapshot) {
        return new JFRSnapshotEnvironmentView(jfrSnapshot);
    }

    public static final class EventChecker
    extends JFREventChecker {
        public EventChecker() {
            super(EventChecker.checkedTypes());
        }

        static String[] checkedTypes() {
            return new String[]{JFRSnapshotEnvironmentViewProvider.EVENT_CPU_INFO, JFRSnapshotEnvironmentViewProvider.EVENT_PHYSICAL_MEMORY, JFRSnapshotEnvironmentViewProvider.EVENT_OS_INFO, JFRSnapshotEnvironmentViewProvider.EVENT_CPU_LOAD, JFRSnapshotEnvironmentViewProvider.EVENT_NETWORK_UTILIZATION, JFRSnapshotEnvironmentViewProvider.EVENT_ENVIRONMENT_VARIABLE, JFRSnapshotEnvironmentViewProvider.EVENT_SYSTEM_PROCESS};
        }
    }
}

