/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.transport.nio;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.sql.Timestamp;
import org.apache.catalina.tribes.ChannelMessage;
import org.apache.catalina.tribes.RemoteProcessException;
import org.apache.catalina.tribes.UniqueId;
import org.apache.catalina.tribes.io.BufferPool;
import org.apache.catalina.tribes.io.ChannelData;
import org.apache.catalina.tribes.io.ListenCallback;
import org.apache.catalina.tribes.io.ObjectReader;
import org.apache.catalina.tribes.transport.AbstractRxTask;
import org.apache.catalina.tribes.transport.Constants;
import org.apache.catalina.tribes.transport.nio.NioReceiver;
import org.apache.catalina.tribes.util.Logs;
import org.apache.catalina.tribes.util.StringManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class NioReplicationTask
extends AbstractRxTask {
    private static final Log log = LogFactory.getLog(NioReplicationTask.class);
    protected static final StringManager sm = StringManager.getManager(NioReplicationTask.class);
    private ByteBuffer buffer = null;
    private SelectionKey key;
    private int rxBufSize;
    private final NioReceiver receiver;

    public NioReplicationTask(ListenCallback listenCallback, NioReceiver nioReceiver) {
        super(listenCallback);
        this.receiver = nioReceiver;
    }

    @Override
    public synchronized void run() {
        if (this.buffer == null) {
            int n = this.getRxBufSize();
            if (this.key.channel() instanceof DatagramChannel) {
                n = 65535;
            }
            this.buffer = (this.getOptions() & 4) == 4 ? ByteBuffer.allocateDirect(n) : ByteBuffer.allocate(n);
        } else {
            this.buffer.clear();
        }
        if (this.key == null) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Servicing key:" + this.key));
        }
        try {
            ObjectReader objectReader = (ObjectReader)this.key.attachment();
            if (objectReader == null) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("No object reader, cancelling:" + this.key));
                }
                this.cancelKey(this.key);
            } else {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Draining channel:" + this.key));
                }
                this.drainChannel(this.key, objectReader);
            }
        }
        catch (Exception exception) {
            if (!(exception instanceof CancelledKeyException)) {
                if (exception instanceof IOException) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("IOException in replication worker, unable to drain channel. Probable cause: Keep alive socket closed[" + exception.getMessage() + "]."), (Throwable)exception);
                    } else {
                        log.warn((Object)sm.getString("nioReplicationTask.unable.drainChannel.ioe", exception.getMessage()));
                    }
                } else if (log.isErrorEnabled()) {
                    log.error((Object)sm.getString("nioReplicationTask.exception.drainChannel"), (Throwable)exception);
                }
            }
            this.cancelKey(this.key);
        }
        this.key = null;
        this.getTaskPool().returnWorker(this);
    }

    public synchronized void serviceChannel(SelectionKey selectionKey) {
        ObjectReader objectReader;
        if (log.isTraceEnabled()) {
            log.trace((Object)("About to service key:" + selectionKey));
        }
        if ((objectReader = (ObjectReader)selectionKey.attachment()) != null) {
            objectReader.setLastAccess(System.currentTimeMillis());
        }
        this.key = selectionKey;
        selectionKey.interestOps(selectionKey.interestOps() & 0xFFFFFFFE);
        selectionKey.interestOps(selectionKey.interestOps() & 0xFFFFFFFB);
    }

    protected void drainChannel(SelectionKey selectionKey, ObjectReader objectReader) throws Exception {
        objectReader.access();
        ReadableByteChannel readableByteChannel = (ReadableByteChannel)((Object)selectionKey.channel());
        int n = -1;
        this.buffer.clear();
        SocketAddress socketAddress = null;
        if (readableByteChannel instanceof SocketChannel) {
            while ((n = readableByteChannel.read(this.buffer)) > 0) {
                this.buffer.flip();
                if (this.buffer.hasArray()) {
                    objectReader.append(this.buffer.array(), 0, n, false);
                } else {
                    objectReader.append(this.buffer, n, false);
                }
                this.buffer.clear();
                if (!objectReader.hasPackage()) continue;
                break;
            }
        } else if (readableByteChannel instanceof DatagramChannel) {
            DatagramChannel datagramChannel = (DatagramChannel)readableByteChannel;
            socketAddress = datagramChannel.receive(this.buffer);
            this.buffer.flip();
            if (this.buffer.hasArray()) {
                objectReader.append(this.buffer.array(), 0, this.buffer.limit() - this.buffer.position(), false);
            } else {
                objectReader.append(this.buffer, this.buffer.limit() - this.buffer.position(), false);
            }
            this.buffer.clear();
            n = objectReader.hasPackage() ? 1 : -1;
        }
        int n2 = objectReader.count();
        if (n < 0 && n2 == 0) {
            this.remoteEof(selectionKey);
            return;
        }
        ChannelMessage[] channelMessageArray = n2 == 0 ? ChannelData.EMPTY_DATA_ARRAY : objectReader.execute();
        this.registerForRead(selectionKey, objectReader);
        for (ChannelMessage channelMessage : channelMessageArray) {
            block22: {
                if (ChannelData.sendAckAsync(channelMessage.getOptions())) {
                    this.sendAck(selectionKey, (WritableByteChannel)((Object)readableByteChannel), Constants.ACK_COMMAND, socketAddress);
                }
                try {
                    if (Logs.MESSAGES.isTraceEnabled()) {
                        try {
                            Logs.MESSAGES.trace((Object)("NioReplicationThread - Received msg:" + new UniqueId(channelMessage.getUniqueId()) + " at " + new Timestamp(System.currentTimeMillis())));
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    this.getCallback().messageDataReceived(channelMessage);
                    if (ChannelData.sendAckSync(channelMessage.getOptions())) {
                        this.sendAck(selectionKey, (WritableByteChannel)((Object)readableByteChannel), Constants.ACK_COMMAND, socketAddress);
                    }
                }
                catch (RemoteProcessException remoteProcessException) {
                    if (log.isDebugEnabled()) {
                        log.error((Object)sm.getString("nioReplicationTask.process.clusterMsg.failed"), (Throwable)remoteProcessException);
                    }
                    if (ChannelData.sendAckSync(channelMessage.getOptions())) {
                        this.sendAck(selectionKey, (WritableByteChannel)((Object)readableByteChannel), Constants.FAIL_ACK_COMMAND, socketAddress);
                    }
                }
                catch (Exception exception) {
                    log.error((Object)sm.getString("nioReplicationTask.process.clusterMsg.failed"), (Throwable)exception);
                    if (!ChannelData.sendAckSync(channelMessage.getOptions())) break block22;
                    this.sendAck(selectionKey, (WritableByteChannel)((Object)readableByteChannel), Constants.FAIL_ACK_COMMAND, socketAddress);
                }
            }
            if (!this.getUseBufferPool()) continue;
            BufferPool.getBufferPool().returnBuffer(channelMessage.getMessage());
            channelMessage.setMessage(null);
        }
        if (n < 0) {
            this.remoteEof(selectionKey);
            return;
        }
    }

    private void remoteEof(SelectionKey selectionKey) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Channel closed on the remote end, disconnecting");
        }
        this.cancelKey(selectionKey);
    }

    protected void registerForRead(final SelectionKey selectionKey, ObjectReader objectReader) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Adding key for read event:" + selectionKey));
        }
        objectReader.finish();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    if (selectionKey.isValid()) {
                        selectionKey.selector().wakeup();
                        int n = selectionKey.interestOps() | 1;
                        selectionKey.interestOps(n);
                        if (log.isTraceEnabled()) {
                            log.trace((Object)("Registering key for read:" + selectionKey));
                        }
                    }
                }
                catch (CancelledKeyException cancelledKeyException) {
                    NioReceiver.cancelledKey(selectionKey);
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("CKX Cancelling key:" + selectionKey));
                    }
                }
                catch (Exception exception) {
                    log.error((Object)sm.getString("nioReplicationTask.error.register.key", selectionKey), (Throwable)exception);
                }
            }
        };
        this.receiver.addEvent(runnable);
    }

    private void cancelKey(final SelectionKey selectionKey) {
        ObjectReader objectReader;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Adding key for cancel event:" + selectionKey));
        }
        if ((objectReader = (ObjectReader)selectionKey.attachment()) != null) {
            objectReader.setCancelled(true);
            objectReader.finish();
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Cancelling key:" + selectionKey));
                }
                NioReceiver.cancelledKey(selectionKey);
            }
        };
        this.receiver.addEvent(runnable);
    }

    protected void sendAck(SelectionKey selectionKey, WritableByteChannel writableByteChannel, byte[] byArray, SocketAddress socketAddress) {
        try {
            int n;
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            if (writableByteChannel instanceof DatagramChannel) {
                DatagramChannel datagramChannel = (DatagramChannel)writableByteChannel;
                for (n = 0; n < byArray.length; n += datagramChannel.send(byteBuffer, socketAddress)) {
                }
            } else {
                while (n < byArray.length) {
                    n += writableByteChannel.write(byteBuffer);
                }
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("ACK sent to " + (writableByteChannel instanceof SocketChannel ? ((SocketChannel)writableByteChannel).socket().getInetAddress() : ((DatagramChannel)writableByteChannel).socket().getInetAddress())));
            }
        }
        catch (IOException iOException) {
            log.warn((Object)sm.getString("nioReplicationTask.unable.ack", iOException.getMessage()));
        }
    }

    public void setRxBufSize(int n) {
        this.rxBufSize = n;
    }

    public int getRxBufSize() {
        return this.rxBufSize;
    }
}

