/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.application.type;

import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.application.jvm.Jvm;
import org.graalvm.visualvm.application.jvm.JvmFactory;
import org.graalvm.visualvm.application.type.ApplicationType;
import org.graalvm.visualvm.application.type.JavaPluginApplicationType;
import org.graalvm.visualvm.core.model.AbstractModelProvider;

public class JavaPluginApplicationTypeFactory
extends AbstractModelProvider<ApplicationType, Application> {
    private static final String JAVA_PLUGIN = "-Djavaplugin.version=";
    private static final String JAVA_PLUGIN2_MAIN = "sun.plugin2.main.client.PluginMain";

    public ApplicationType createModelFor(Application application) {
        Jvm jvm = JvmFactory.getJVMFor(application);
        if (jvm.isBasicInfoSupported()) {
            String args = jvm.getJvmArgs();
            int plugin_index = args.indexOf(JAVA_PLUGIN);
            if (plugin_index != -1) {
                int version_index = plugin_index + JAVA_PLUGIN.length();
                int space_index = args.indexOf(32, version_index);
                String version = space_index != -1 ? args.substring(version_index, space_index) : args.substring(version_index);
                return new JavaPluginApplicationType(version);
            }
            if (JAVA_PLUGIN2_MAIN.equals(jvm.getMainClass())) {
                return new JavaPluginApplicationType("2");
            }
        }
        return null;
    }
}

