/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.image;

import java.util.List;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.PrimitiveArrayInstance;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.image.FieldAccessor;

abstract class InstanceBuilder<T> {
    public static final InstanceBuilder<String> STRING_BUILDER = new InstanceBuilder<String>(String.class){

        @Override
        public String convert(FieldAccessor accessor, Instance instance) throws FieldAccessor.InvalidFieldException {
            return accessor.toString(instance);
        }
    };
    public static final InstanceBuilder<int[]> INT_ARRAY_BUILDER = new InstanceBuilder<int[]>(int[].class){

        @Override
        public int[] convert(FieldAccessor accessor, Instance instance) throws FieldAccessor.InvalidFieldException {
            if (instance == null) {
                return null;
            }
            PrimitiveArrayInstance array = FieldAccessor.castValue(instance, PrimitiveArrayInstance.class);
            List list = array.getValues();
            int[] result = new int[list.size()];
            for (int i = 0; i < result.length; ++i) {
                try {
                    result[i] = Integer.parseInt((String)list.get(i));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new FieldAccessor.InvalidFieldException("invalid format of int at index %d: %s", i, list.get(i));
                }
            }
            return result;
        }
    };
    public static final InstanceBuilder<byte[]> BYTE_ARRAY_BUILDER = new InstanceBuilder<byte[]>(byte[].class){

        @Override
        public byte[] convert(FieldAccessor accessor, Instance instance) throws FieldAccessor.InvalidFieldException {
            if (instance == null) {
                return null;
            }
            PrimitiveArrayInstance array = FieldAccessor.castValue(instance, PrimitiveArrayInstance.class);
            List list = array.getValues();
            byte[] result = new byte[list.size()];
            for (int i = 0; i < result.length; ++i) {
                try {
                    result[i] = Byte.parseByte((String)list.get(i));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new FieldAccessor.InvalidFieldException("invalid format of byte at index %d: %s", i, list.get(i));
                }
            }
            return result;
        }
    };
    public static final InstanceBuilder<short[]> SHORT_ARRAY_BUILDER = new InstanceBuilder<short[]>(short[].class){

        @Override
        public short[] convert(FieldAccessor accessor, Instance instance) throws FieldAccessor.InvalidFieldException {
            if (instance == null) {
                return null;
            }
            PrimitiveArrayInstance array = FieldAccessor.castValue(instance, PrimitiveArrayInstance.class);
            List list = array.getValues();
            short[] result = new short[list.size()];
            for (int i = 0; i < result.length; ++i) {
                try {
                    result[i] = Short.parseShort((String)list.get(i));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new FieldAccessor.InvalidFieldException("invalid format of short at index %d: %s", i, list.get(i));
                }
            }
            return result;
        }
    };
    public static final InstanceBuilder<Instance> IDENTITY_BUILDER = new InstanceBuilder<Instance>(Instance.class){

        @Override
        public Instance convert(FieldAccessor accessor, Instance instance) throws FieldAccessor.InvalidFieldException {
            return instance;
        }
    };
    private final Class<T> type;

    public InstanceBuilder(Class<T> type) {
        this.type = type;
    }

    Class<T> getType() {
        return this.type;
    }

    public abstract T convert(FieldAccessor var1, Instance var2) throws FieldAccessor.InvalidFieldException;

    public static class ReferringInstanceBuilder<T>
    extends InstanceBuilder<T> {
        private final String[] path;

        public ReferringInstanceBuilder(Class<T> type, String ... path) {
            super(type);
            this.path = path;
        }

        @Override
        public T convert(FieldAccessor fa, Instance instance) throws FieldAccessor.InvalidFieldException {
            for (int i = 0; i < this.path.length - 1 && instance != null; ++i) {
                instance = fa.getInstance(instance, this.path[i], false);
            }
            if (instance == null) {
                return null;
            }
            return fa.build(instance, this.path[this.path.length - 1], this.getType(), false);
        }
    }
}

