/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.coredump.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.FilenameFilter;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.core.VisualVM;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.datasource.DataSourceRepository;
import org.graalvm.visualvm.core.datasource.Storage;
import org.graalvm.visualvm.core.datasource.descriptor.DataSourceDescriptorFactory;
import org.graalvm.visualvm.core.datasupport.Utils;
import org.graalvm.visualvm.core.explorer.ExplorerSupport;
import org.graalvm.visualvm.coredump.CoreDumpSupport;
import org.graalvm.visualvm.coredump.CoreDumpsContainer;
import org.graalvm.visualvm.coredump.impl.CoreDumpImpl;
import org.graalvm.visualvm.lib.ui.SwingWorker;
import org.graalvm.visualvm.tools.sa.SaModel;
import org.graalvm.visualvm.tools.sa.SaModelFactory;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class CoreDumpProvider {
    private static final Logger LOGGER = Logger.getLogger(CoreDumpProvider.class.getName());
    private static final String SNAPSHOT_VERSION = "snapshot_version";
    private static final String SNAPSHOT_VERSION_DIVIDER = ".";
    private static final String CURRENT_SNAPSHOT_VERSION_MAJOR = "1";
    private static final String CURRENT_SNAPSHOT_VERSION_MINOR = "0";
    private static final String CURRENT_SNAPSHOT_VERSION = "1.0";
    private static final String PROPERTY_JAVA_HOME = "prop_java_home";

    static void createCoreDump(final String coreDumpFile, final String displayName, final String jdkHome, final boolean deleteCoreDump) {
        VisualVM.getInstance().runTask(new Runnable(){

            @Override
            public void run() {
                CoreDumpProvider.createCoreDumpImpl(coreDumpFile, displayName, jdkHome, deleteCoreDump);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createCoreDumpImpl(String coreDumpFile, final String displayName, String jdkHome, boolean deleteCoreDump) {
        final CoreDumpImpl knownCoreDump = CoreDumpProvider.getCoreDumpByFile(new File(coreDumpFile));
        if (knownCoreDump != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ExplorerSupport.sharedInstance().selectDataSource((DataSource)knownCoreDump);
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(CoreDumpProvider.class, (String)"MSG_Core_dump_already_added", (Object[])new Object[]{displayName, DataSourceDescriptorFactory.getDescriptor((DataSource)knownCoreDump).getName()}), 0));
                }
            });
            return;
        }
        if (deleteCoreDump) {
            ProgressHandle pHandleF;
            ProgressHandle pHandle = null;
            try {
                pHandle = ProgressHandle.createHandle((String)NbBundle.getMessage(CoreDumpProvider.class, (String)"MSG_Adding", (Object)displayName));
                pHandle.setInitialDelay(0);
                pHandle.start();
                File file = new File(coreDumpFile);
                File copy = Utils.getUniqueFile((File)CoreDumpSupport.getStorageDirectory(), (String)file.getName());
                if (Utils.copyFile((File)file, (File)copy)) {
                    coreDumpFile = copy.getAbsolutePath();
                    if (!file.delete()) {
                        file.deleteOnExit();
                    }
                }
                pHandleF = pHandle;
            }
            catch (Throwable throwable) {
                ProgressHandle pHandleF2 = pHandle;
                SwingUtilities.invokeLater(new Runnable(pHandleF2){
                    final /* synthetic */ ProgressHandle val$pHandleF;
                    {
                        this.val$pHandleF = progressHandle;
                    }

                    @Override
                    public void run() {
                        if (this.val$pHandleF != null) {
                            this.val$pHandleF.finish();
                        }
                    }
                });
                throw throwable;
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }
        String[] propNames = new String[]{SNAPSHOT_VERSION, "prop_file", "prop_name", PROPERTY_JAVA_HOME};
        String[] propValues = new String[]{CURRENT_SNAPSHOT_VERSION, coreDumpFile, displayName, jdkHome};
        File customPropertiesStorage = Utils.getUniqueFile((File)CoreDumpSupport.getStorageDirectory(), (String)new File(coreDumpFile).getName(), (String)".properties");
        Storage storage = new Storage(customPropertiesStorage.getParentFile(), customPropertiesStorage.getName());
        try {
            CoreDumpImpl newCoreDump = new CoreDumpImpl(new File(coreDumpFile), new File(jdkHome), storage);
            if (newCoreDump != null) {
                new CoreDumpAdder(newCoreDump, storage, propNames, propValues).execute();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error creating coredump", e);
            return;
        }
    }

    private static CoreDumpImpl getCoreDumpByFile(File file) {
        if (!file.isFile()) {
            return null;
        }
        Set knownCoredumps = DataSourceRepository.sharedInstance().getDataSources(CoreDumpImpl.class);
        for (CoreDumpImpl knownCoredump : knownCoredumps) {
            if (!knownCoredump.getFile().equals(file)) continue;
            return knownCoredump;
        }
        return null;
    }

    private void initPersistedCoreDumps() {
        if (!CoreDumpSupport.storageDirectoryExists()) {
            return;
        }
        File[] files = CoreDumpSupport.getStorageDirectory().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".properties");
            }
        });
        HashSet<File> unresolvedCoreDumpsF = new HashSet<File>();
        HashSet<String> unresolvedCoreDumpsS = new HashSet<String>();
        HashSet<CoreDumpImpl> coredumps = new HashSet<CoreDumpImpl>();
        for (File file : files) {
            String[] propNames;
            Storage storage = new Storage(file.getParentFile(), file.getName());
            String[] propValues = storage.getCustomProperties(propNames = new String[]{"prop_file", PROPERTY_JAVA_HOME});
            if (propValues[0] == null || propValues[1] == null) continue;
            CoreDumpImpl persistedCoredump = null;
            try {
                persistedCoredump = new CoreDumpImpl(new File(propValues[0]), new File(propValues[1]), storage);
            }
            catch (Exception e) {
                LOGGER.log(Level.INFO, "Error loading persisted coredump", e);
                unresolvedCoreDumpsF.add(file);
                unresolvedCoreDumpsS.add(propValues[0]);
            }
            if (persistedCoredump == null) continue;
            coredumps.add(persistedCoredump);
        }
        if (!unresolvedCoreDumpsF.isEmpty()) {
            CoreDumpProvider.notifyUnresolvedCoreDumps(unresolvedCoreDumpsF, unresolvedCoreDumpsS);
        }
        if (!coredumps.isEmpty()) {
            CoreDumpsContainer.sharedInstance().getRepository().addDataSources(coredumps);
        }
    }

    private static void notifyUnresolvedCoreDumps(final Set<File> unresolvedCoreDumpsF, final Set<String> unresolvedCoreDumpsS) {
        VisualVM.getInstance().runTask(new Runnable(){

            @Override
            public void run() {
                JPanel messagePanel = new JPanel(new BorderLayout(5, 5));
                messagePanel.add((Component)new JLabel(NbBundle.getMessage(CoreDumpProvider.class, (String)"MSG_Unresolved_CoreDumps")), "North");
                JList<Object> list = new JList<Object>(unresolvedCoreDumpsS.toArray());
                list.setVisibleRowCount(4);
                messagePanel.add((Component)new JScrollPane(list), "Center");
                NotifyDescriptor dd = new NotifyDescriptor((Object)messagePanel, NbBundle.getMessage(CoreDumpProvider.class, (String)"Title_Unresolved_CoreDumps"), 0, 0, null, NotifyDescriptor.YES_OPTION);
                if (DialogDisplayer.getDefault().notify(dd) == NotifyDescriptor.NO_OPTION) {
                    for (File file : unresolvedCoreDumpsF) {
                        Utils.delete((File)file, (boolean)true);
                    }
                }
                unresolvedCoreDumpsF.clear();
                unresolvedCoreDumpsS.clear();
            }
        }, 1000);
    }

    CoreDumpProvider() {
    }

    public static void register() {
        final CoreDumpProvider provider = new CoreDumpProvider();
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            @Override
            public void run() {
                VisualVM.getInstance().runTask(new Runnable(){

                    @Override
                    public void run() {
                        provider.initPersistedCoreDumps();
                    }
                });
            }
        });
    }

    private static class CoreDumpAdder
    extends SwingWorker {
        private volatile ProgressHandle ph = null;
        private volatile boolean success = false;
        private CoreDumpImpl newCoreDump;
        private Storage storage;
        private String[] propNames;
        private String[] propValues;

        public CoreDumpAdder(CoreDumpImpl newCoreDump, Storage storage, String[] propNames, String[] propValues) {
            this.newCoreDump = newCoreDump;
            this.storage = storage;
            this.propValues = propValues;
            this.propNames = propNames;
        }

        protected void doInBackground() {
            SaModel model = SaModelFactory.getSAAgentFor((DataSource)this.newCoreDump);
            if (model != null) {
                this.storage.setCustomProperties(this.propNames, this.propValues);
                CoreDumpsContainer.sharedInstance().getRepository().addDataSource((DataSource)this.newCoreDump);
                this.success = true;
            }
        }

        protected void nonResponding() {
            this.ph = ProgressHandle.createHandle((String)NbBundle.getMessage(CoreDumpProvider.class, (String)"LBL_Inspecting_core_dump"));
            this.ph.start();
        }

        protected void done() {
            if (this.ph != null) {
                this.ph.finish();
            }
            if (!this.success) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(CoreDumpProvider.class, (String)"MSG_not_valid_core_dump", (Object)this.newCoreDump.getFile().getAbsolutePath())));
            }
        }
    }
}

