/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jvmstat.application;

import java.awt.Component;
import java.util.EventObject;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

class ConnectionsTable
extends JTable {
    public ConnectionsTable(TableModel model, TableCellRenderer cellRenderer, TableCellEditor cellEditor) {
        super(model);
        this.setDefaultRenderer(Object.class, cellRenderer);
        this.setDefaultEditor(Object.class, new CellEditor(cellEditor));
        this.setSelectionMode(0);
        this.getSelectionModel().addListSelectionListener(new SelectionListener(this));
        this.setTableHeader(null);
    }

    @Override
    public void columnMarginChanged(ChangeEvent e) {
        this.resizeAndRepaint();
    }

    @Override
    public void editingStopped(ChangeEvent e) {
    }

    private void doEditingStopped(ChangeEvent e) {
        super.editingStopped(e);
        super.removeEditor();
    }

    @Override
    public void editingCanceled(ChangeEvent e) {
    }

    @Override
    public void removeEditor() {
    }

    private static class CellEditor
    extends JPanel
    implements TableCellEditor {
        private final TableCellEditor impl;

        public CellEditor(TableCellEditor impl) {
            this.impl = impl;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            Component editor = this.impl.getTableCellEditorComponent(table, value, isSelected, row, column);
            table.setRowHeight(row, editor.getPreferredSize().height);
            return editor;
        }

        @Override
        public Object getCellEditorValue() {
            return this.impl.getCellEditorValue();
        }

        @Override
        public boolean stopCellEditing() {
            return this.impl.stopCellEditing();
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return this.impl.isCellEditable(anEvent);
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return this.impl.shouldSelectCell(anEvent);
        }

        @Override
        public void cancelCellEditing() {
            this.impl.cancelCellEditing();
        }

        @Override
        public void addCellEditorListener(CellEditorListener l) {
            this.impl.addCellEditorListener(l);
        }

        @Override
        public void removeCellEditorListener(CellEditorListener l) {
            this.impl.removeCellEditorListener(l);
        }
    }

    private static class SelectionListener
    implements ListSelectionListener {
        private final ConnectionsTable table;
        private int lastRow = -1;

        public SelectionListener(ConnectionsTable table) {
            this.table = table;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int row = this.table.getSelectedRow();
            if (this.lastRow == row) {
                return;
            }
            if (this.lastRow != -1) {
                this.table.setRowHeight(this.lastRow, this.table.getRowHeight());
            }
            if (row != -1) {
                this.table.editCellAt(row, 0, null);
                if (this.table.isShowing()) {
                    this.table.requestFocusInWindow();
                }
            } else {
                this.table.doEditingStopped(null);
            }
            this.lastRow = row;
        }
    }
}

