/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.sampler;

import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.application.jvm.JvmFactory;
import org.graalvm.visualvm.core.ui.DataSourceView;
import org.graalvm.visualvm.core.ui.DataSourceWindowManager;
import org.graalvm.visualvm.sampler.ApplicationSamplerViewProvider;

public final class SamplerSupport {
    private static SamplerSupport instance;
    private ApplicationSamplerViewProvider samplerViewProvider = new ApplicationSamplerViewProvider();

    public static synchronized SamplerSupport getInstance() {
        if (instance == null) {
            instance = new SamplerSupport();
        }
        return instance;
    }

    boolean supportsProfiling(Application application) {
        if (application.getState() != 1) {
            return false;
        }
        return JvmFactory.getJVMFor((Application)application).isBasicInfoSupported();
    }

    void selectSamplerView(Application application) {
        if (application == null) {
            return;
        }
        DataSourceView activeView = this.samplerViewProvider.view(application);
        if (activeView == null) {
            return;
        }
        DataSourceWindowManager.sharedInstance().selectView(activeView);
    }

    private SamplerSupport() {
        this.samplerViewProvider.initialize();
    }
}

