package Lire::UI::PolyListWidget;

use strict;

use base qw/ Lire::UI::CompoundListWidget /;

# List API
sub add_contained_widgets {
    my $self = $_[0];

    $self->add( 'type_widget', 'Curses::UI::Popupmenu' );
    $self->update_type_popupmenu();
    $self->SUPER::add_contained_widgets();

    return;
}

sub extra_widget_height {
    return 1;
}

sub layout_contained_objects {
    my $self = $_[0];

    my $popup = $self->getobj( 'type_widget' );
    return $self unless $popup;

    $popup->{'-width'} = $self->canvaswidth() - 2;
    $popup->{'-x'} = 1;
    $popup->{'-y'} = $self->canvasheight() - 2;

    return $self->SUPER::layout_contained_objects();
}

sub update_type_popupmenu {
    my $self = $_[0];

    my %menu = ();
    foreach my $comp ( $self->{'value'}->spec()->components() ) {
        $menu{ $comp->summary() } = $comp;
    }

    my $popup = $self->getobj( 'type_widget' );
    $popup->{'-values'} = [ map { $menu{$_} } sort keys %menu ];
    $popup->{'-labels'} = { map { $menu{$_} => $_ } sort keys %menu };

    return;
}

sub new_value {
    my $self = $_[0];

    my $spec = $self->getobj( 'type_widget' )->get();
    return $spec ? $spec->instance() : undef;
}

1;
