/*
 * Decompiled with CFR 0.152.
 */
package ext.plantuml.com.at.gadermaier.argon2;

import ext.plantuml.com.at.gadermaier.argon2.Argon2;
import ext.plantuml.com.at.gadermaier.argon2.exception.Argon2InvalidParameterException;

class Validation {
    Validation() {
    }

    static void validateInput(Argon2 argon2) {
        String message = null;
        if (argon2.getLanes() < 1) {
            message = "degree of parallelism cannot be smaller than one";
        } else if (argon2.getLanes() > 0x1000000) {
            message = "parallelism cannot be greater than 16777216";
        } else if (argon2.getMemory() < 2 * argon2.getLanes()) {
            message = "memory too small";
        } else if (argon2.getIterations() < 1) {
            message = "number of iterations cannot be less than one";
        } else if (argon2.getIterations() > Integer.MAX_VALUE) {
            message = "number of iterations too high";
        } else if (argon2.getPasswordLength() < 0) {
            message = "password too short";
        } else if (argon2.getPasswordLength() > Integer.MAX_VALUE) {
            message = "password too long";
        } else if (argon2.getSaltLength() < 0) {
            message = "salt too short";
        } else if (argon2.getSaltLength() > Integer.MAX_VALUE) {
            message = "salt too long";
        } else if (argon2.getSecretLength() > Integer.MAX_VALUE) {
            message = "secret too long";
        } else if (argon2.getAdditionalLength() > Integer.MAX_VALUE) {
            message = "additional data too long";
        }
        if (message != null) {
            throw new Argon2InvalidParameterException(message);
        }
    }
}

