/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.da.comp.writer2xhtml;

import com.sun.star.awt.XContainerWindowEventHandler;
import com.sun.star.awt.XDialog;
import com.sun.star.awt.XWindow;
import com.sun.star.beans.XPropertySet;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lib.uno.helper.WeakBase;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.util.XChangesBatch;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.openoffice.da.comp.w2lcommon.helper.DialogAccess;
import org.openoffice.da.comp.w2lcommon.helper.FilePicker;
import org.openoffice.da.comp.w2lcommon.helper.RegistryHelper;
import org.openoffice.da.comp.w2lcommon.helper.XPropertySetHelper;

public final class ToolbarSettingsDialog
extends WeakBase
implements XServiceInfo,
XContainerWindowEventHandler {
    public static final String REGISTRY_PATH = "/org.openoffice.da.Writer2xhtml.toolbar.ToolbarOptions/Settings";
    private XComponentContext xContext;
    private FilePicker filePicker;
    public static String __serviceName = "org.openoffice.da.writer2xhtml.ToolbarSettingsDialog";
    public static String __implementationName = "org.openoffice.da.comp.writer2xhtml.ToolbarSettingsDialog";

    public ToolbarSettingsDialog(XComponentContext xContext) {
        this.xContext = xContext;
        this.filePicker = new FilePicker(xContext);
    }

    public boolean callHandlerMethod(XWindow xWindow, Object event, String sMethod) throws WrappedTargetException {
        XDialog xDialog = (XDialog)UnoRuntime.queryInterface(XDialog.class, (Object)xWindow);
        DialogAccess dlg = new DialogAccess(xDialog);
        try {
            if (sMethod.equals("external_event")) {
                return this.handleExternalEvent(dlg, event);
            }
            if (sMethod.equals("XhtmlFormatChange")) {
                return true;
            }
            if (sMethod.equals("XhtmlViewChange")) {
                return this.xhtmlViewChange(dlg);
            }
            if (sMethod.equals("XhtmlBrowseClick")) {
                return this.xhtmlBrowseClick(dlg);
            }
            if (sMethod.equals("EpubFormatChange")) {
                return true;
            }
            if (sMethod.equals("EpubViewChange")) {
                return this.epubViewChange(dlg);
            }
            if (sMethod.equals("EpubBrowseClick")) {
                return this.epubBrowseClick(dlg);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WrappedTargetException(sMethod, (Object)this, (Object)e);
        }
        return false;
    }

    public String[] getSupportedMethodNames() {
        String[] sNames = new String[]{"external_event", "XhtmlFormatChange", "XhtmlViewChange", "XhtmlBrowseClick", "EpupFormatChange", "EpubViewChange", "EpubBrowseClick"};
        return sNames;
    }

    public boolean supportsService(String sServiceName) {
        return sServiceName.equals(__serviceName);
    }

    public String getImplementationName() {
        return __implementationName;
    }

    public String[] getSupportedServiceNames() {
        String[] sSupportedServiceNames = new String[]{__serviceName};
        return sSupportedServiceNames;
    }

    private boolean handleExternalEvent(DialogAccess dlg, Object aEventObject) throws Exception {
        try {
            String sMethod = AnyConverter.toString((Object)aEventObject);
            if (sMethod.equals("ok")) {
                this.saveConfiguration(dlg);
                return true;
            }
            if (sMethod.equals("back") || sMethod.equals("initialize")) {
                this.loadConfiguration(dlg);
                this.enableXhtmlExecutable(dlg);
                this.enableEpubExecutable(dlg);
                return true;
            }
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Method external_event requires a string in the event object argument.", (Object)this, -1);
        }
        return false;
    }

    private void loadConfiguration(DialogAccess dlg) {
        RegistryHelper registry = new RegistryHelper(this.xContext);
        try {
            Object view = registry.getRegistryView(REGISTRY_PATH, false);
            XPropertySet xProps = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)view);
            dlg.setListBoxSelectedItem("XhtmlFormat", XPropertySetHelper.getPropertyValueAsShort(xProps, "XhtmlFormat"));
            dlg.setListBoxSelectedItem("XhtmlView", XPropertySetHelper.getPropertyValueAsShort(xProps, "XhtmlView"));
            dlg.setTextFieldText("XhtmlExecutable", XPropertySetHelper.getPropertyValueAsString(xProps, "XhtmlExecutable"));
            dlg.setListBoxSelectedItem("EpubFormat", XPropertySetHelper.getPropertyValueAsShort(xProps, "EpubFormat"));
            dlg.setListBoxSelectedItem("EpubView", XPropertySetHelper.getPropertyValueAsShort(xProps, "EpubView"));
            dlg.setTextFieldText("EpubExecutable", XPropertySetHelper.getPropertyValueAsString(xProps, "EpubExecutable"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void saveConfiguration(DialogAccess dlg) {
        RegistryHelper registry = new RegistryHelper(this.xContext);
        try {
            Object view = registry.getRegistryView(REGISTRY_PATH, true);
            XPropertySet xProps = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)view);
            XPropertySetHelper.setPropertyValue(xProps, "XhtmlFormat", dlg.getListBoxSelectedItem("XhtmlFormat"));
            XPropertySetHelper.setPropertyValue(xProps, "XhtmlView", dlg.getListBoxSelectedItem("XhtmlView"));
            XPropertySetHelper.setPropertyValue(xProps, "XhtmlExecutable", dlg.getTextFieldText("XhtmlExecutable"));
            XPropertySetHelper.setPropertyValue(xProps, "EpubFormat", dlg.getListBoxSelectedItem("EpubFormat"));
            XPropertySetHelper.setPropertyValue(xProps, "EpubView", dlg.getListBoxSelectedItem("EpubView"));
            XPropertySetHelper.setPropertyValue(xProps, "EpubExecutable", dlg.getTextFieldText("EpubExecutable"));
            XChangesBatch xUpdateContext = (XChangesBatch)UnoRuntime.queryInterface(XChangesBatch.class, (Object)view);
            try {
                xUpdateContext.commitChanges();
            }
            catch (Exception exception) {
                // empty catch block
            }
            registry.disposeRegistryView(view);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean xhtmlViewChange(DialogAccess dlg) {
        this.enableXhtmlExecutable(dlg);
        return true;
    }

    private void enableXhtmlExecutable(DialogAccess dlg) {
        short nItem = dlg.getListBoxSelectedItem("XhtmlView");
        dlg.setControlEnabled("XhtmlExecutable", nItem == 2);
        dlg.setControlEnabled("XhtmlBrowseButton", nItem == 2);
    }

    private boolean xhtmlBrowseClick(DialogAccess dlg) {
        this.browseForExecutable(dlg, "XhtmlExecutable");
        return true;
    }

    private boolean epubViewChange(DialogAccess dlg) {
        this.enableEpubExecutable(dlg);
        return true;
    }

    private void enableEpubExecutable(DialogAccess dlg) {
        short nItem = dlg.getListBoxSelectedItem("EpubView");
        dlg.setControlEnabled("EpubExecutable", nItem == 2);
        dlg.setControlEnabled("EpubBrowseButton", nItem == 2);
    }

    private boolean epubBrowseClick(DialogAccess dlg) {
        this.browseForExecutable(dlg, "EpubExecutable");
        return true;
    }

    private boolean browseForExecutable(DialogAccess dlg, String sControlName) {
        String sPath = this.filePicker.getPath();
        if (sPath != null) {
            try {
                dlg.setComboBoxText(sControlName, new File(new URI(sPath)).getCanonicalPath());
            }
            catch (IOException iOException) {
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return true;
    }
}

