/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.epub;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import writer2latex.api.ConverterResult;
import writer2latex.api.OutputFile;
import writer2latex.epub.ContainerWriter;
import writer2latex.epub.NCXWriter;
import writer2latex.epub.NavigationWriter;
import writer2latex.epub.OPFWriter;
import writer2latex.util.Misc;
import writer2latex.xhtml.XhtmlConfig;

public class EPUBWriter
implements OutputFile {
    private static final byte[] mimeBytes = new byte[]{97, 112, 112, 108, 105, 99, 97, 116, 105, 111, 110, 47, 101, 112, 117, 98, 43, 122, 105, 112};
    private ConverterResult xhtmlResult;
    private String sFileName;
    private int nVersion;
    private XhtmlConfig config;

    public EPUBWriter(ConverterResult xhtmlResult, String sFileName, int nVersion, XhtmlConfig config) {
        this.xhtmlResult = xhtmlResult;
        this.sFileName = Misc.removeExtension(sFileName);
        this.nVersion = nVersion;
        this.config = config;
    }

    @Override
    public String getFileName() {
        return this.sFileName + ".epub";
    }

    @Override
    public String getMIMEType() {
        return "application/epub+zip";
    }

    @Override
    public boolean isMasterDocument() {
        return true;
    }

    @Override
    public boolean containsMath() {
        return this.nVersion == 3;
    }

    @Override
    public void write(OutputStream os) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(os);
        ZipEntry mimeEntry = new ZipEntry("mimetype");
        mimeEntry.setMethod(0);
        mimeEntry.setCrc(749429103L);
        mimeEntry.setSize(mimeBytes.length);
        zos.putNextEntry(mimeEntry);
        zos.write(mimeBytes, 0, mimeBytes.length);
        zos.closeEntry();
        ContainerWriter containerWriter = new ContainerWriter();
        ZipEntry containerEntry = new ZipEntry("META-INF/container.xml");
        zos.putNextEntry(containerEntry);
        this.writeZipEntry(containerWriter, zos);
        zos.closeEntry();
        OPFWriter manifest = new OPFWriter(this.xhtmlResult, this.sFileName, this.nVersion, this.config);
        ZipEntry manifestEntry = new ZipEntry("OEBPS/book.opf");
        zos.putNextEntry(manifestEntry);
        this.writeZipEntry(manifest, zos);
        zos.closeEntry();
        if (this.nVersion == 3) {
            NavigationWriter navigation = new NavigationWriter(this.xhtmlResult);
            ZipEntry navigationEntry = new ZipEntry("OEBPS/nav.xhtml");
            zos.putNextEntry(navigationEntry);
            this.writeZipEntry(navigation, zos);
            zos.closeEntry();
        }
        if (this.nVersion != 3 || this.config.includeNCX()) {
            NCXWriter ncx = new NCXWriter(this.xhtmlResult, manifest.getUid());
            ZipEntry ncxEntry = new ZipEntry("OEBPS/book.ncx");
            zos.putNextEntry(ncxEntry);
            this.writeZipEntry(ncx, zos);
            zos.closeEntry();
        }
        Iterator<OutputFile> iter = this.xhtmlResult.iterator();
        while (iter.hasNext()) {
            OutputFile file = iter.next();
            ZipEntry entry = new ZipEntry("OEBPS/" + file.getFileName());
            zos.putNextEntry(entry);
            this.writeZipEntry(file, zos);
            zos.closeEntry();
        }
        zos.close();
    }

    private void writeZipEntry(OutputFile file, ZipOutputStream zos) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        file.write(baos);
        byte[] content = baos.toByteArray();
        zos.write(content, 0, content.length);
    }
}

