/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import java.util.List;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Javadoc;
import org.eclipse.jdt.internal.compiler.ast.Receiver;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilationUnit;
import org.eclipse.jdt.internal.compiler.problem.AbortMethod;
import org.eclipse.jdt.internal.compiler.problem.AbortType;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.problem.ProblemSeverities;
import org.eclipse.jdt.internal.compiler.util.Util;

public abstract class AbstractMethodDeclaration
extends ASTNode
implements ProblemSeverities,
ReferenceContext {
    public MethodScope scope;
    public char[] selector;
    public int declarationSourceStart;
    public int declarationSourceEnd;
    public int modifiers;
    public int modifiersSourceStart;
    public Annotation[] annotations;
    public Receiver receiver;
    public Argument[] arguments;
    public TypeReference[] thrownExceptions;
    public Statement[] statements;
    public int explicitDeclarations;
    public MethodBinding binding;
    public boolean ignoreFurtherInvestigation = false;
    public Javadoc javadoc;
    public int bodyStart;
    public int bodyEnd = -1;
    public CompilationResult compilationResult;

    AbstractMethodDeclaration(CompilationResult compilationResult) {
        this.compilationResult = compilationResult;
    }

    @Override
    public void abort(int n, CategorizedProblem categorizedProblem) {
        switch (n) {
            case 2: {
                throw new AbortCompilation(this.compilationResult, categorizedProblem);
            }
            case 4: {
                throw new AbortCompilationUnit(this.compilationResult, categorizedProblem);
            }
            case 8: {
                throw new AbortType(this.compilationResult, categorizedProblem);
            }
        }
        throw new AbortMethod(this.compilationResult, categorizedProblem);
    }

    public void createArgumentBindings() {
        AbstractMethodDeclaration.createArgumentBindings(this.arguments, this.binding, this.scope);
    }

    static void createArgumentBindings(Argument[] argumentArray, MethodBinding methodBinding, MethodScope methodScope) {
        boolean bl = methodScope.environment().usesNullTypeAnnotations();
        if (argumentArray != null && methodBinding != null) {
            int n = argumentArray.length;
            for (int i = 0; i < n; ++i) {
                long l;
                Argument argument = argumentArray[i];
                methodBinding.parameters[i] = argument.createBinding(methodScope, methodBinding.parameters[i]);
                if (bl || (l = argument.binding.tagBits & 0x180000000000000L) == 0L) continue;
                if (methodBinding.parameterNonNullness == null) {
                    methodBinding.parameterNonNullness = new Boolean[argumentArray.length];
                    methodBinding.tagBits |= 0x1000L;
                }
                methodBinding.parameterNonNullness[i] = l == 0x100000000000000L;
            }
        }
    }

    public void bindArguments() {
        if (this.arguments != null) {
            if (this.binding == null) {
                int n = this.arguments.length;
                for (int i = 0; i < n; ++i) {
                    this.arguments[i].bind(this.scope, null, true);
                }
                return;
            }
            boolean bl = this.binding.isAbstract() || this.binding.isNative();
            AnnotationBinding[][] annotationBindingArray = null;
            int n = this.arguments.length;
            for (int i = 0; i < n; ++i) {
                Argument argument = this.arguments[i];
                this.binding.parameters[i] = argument.bind(this.scope, this.binding.parameters[i], bl);
                if (argument.annotations != null) {
                    if (annotationBindingArray == null) {
                        annotationBindingArray = new AnnotationBinding[n][];
                        for (int j = 0; j < i; ++j) {
                            annotationBindingArray[j] = Binding.NO_ANNOTATIONS;
                        }
                    }
                    annotationBindingArray[i] = argument.binding.getAnnotations();
                    continue;
                }
                if (annotationBindingArray == null) continue;
                annotationBindingArray[i] = Binding.NO_ANNOTATIONS;
            }
            if (annotationBindingArray != null) {
                this.binding.setParameterAnnotations(annotationBindingArray);
            }
        }
    }

    public void bindThrownExceptions() {
        block5: {
            if (this.thrownExceptions == null || this.binding == null || this.binding.thrownExceptions == null) break block5;
            int n = this.binding.thrownExceptions.length;
            int n2 = this.thrownExceptions.length;
            if (n == n2) {
                for (int i = 0; i < n; ++i) {
                    this.thrownExceptions[i].resolvedType = this.binding.thrownExceptions[i];
                }
            } else {
                int n3 = 0;
                for (int i = 0; i < n2 && n3 < n; ++i) {
                    TypeReference typeReference = this.thrownExceptions[i];
                    ReferenceBinding referenceBinding = this.binding.thrownExceptions[n3];
                    char[][] cArray = referenceBinding.compoundName;
                    if (cArray == null) continue;
                    if (typeReference instanceof SingleTypeReference) {
                        int n4 = cArray.length;
                        char[] cArray2 = typeReference.getTypeName()[0];
                        if (!CharOperation.equals(cArray2, cArray[n4 - 1])) continue;
                        typeReference.resolvedType = referenceBinding;
                        ++n3;
                        continue;
                    }
                    if (!CharOperation.equals(typeReference.getTypeName(), cArray)) continue;
                    typeReference.resolvedType = referenceBinding;
                    ++n3;
                }
            }
        }
    }

    static void analyseArguments(LookupEnvironment lookupEnvironment, FlowInfo flowInfo, Argument[] argumentArray, MethodBinding methodBinding) {
        if (argumentArray != null) {
            boolean bl = lookupEnvironment.usesNullTypeAnnotations();
            int n = Math.min(methodBinding.parameters.length, argumentArray.length);
            for (int i = 0; i < n; ++i) {
                Boolean bl2;
                if (bl) {
                    long l = methodBinding.parameters[i].tagBits & 0x180000000000000L;
                    if (l == 0x100000000000000L) {
                        flowInfo.markAsDefinitelyNonNull(argumentArray[i].binding);
                    } else if (l == 0x80000000000000L) {
                        flowInfo.markPotentiallyNullBit(argumentArray[i].binding);
                    } else if (methodBinding.parameters[i].isFreeTypeVariable()) {
                        flowInfo.markNullStatus(argumentArray[i].binding, 48);
                    }
                } else if (methodBinding.parameterNonNullness != null && (bl2 = methodBinding.parameterNonNullness[i]) != null) {
                    if (bl2.booleanValue()) {
                        flowInfo.markAsDefinitelyNonNull(argumentArray[i].binding);
                    } else {
                        flowInfo.markPotentiallyNullBit(argumentArray[i].binding);
                    }
                }
                flowInfo.markAsDefinitelyAssigned(argumentArray[i].binding);
            }
        }
    }

    @Override
    public CompilationResult compilationResult() {
        return this.compilationResult;
    }

    public void generateCode(ClassScope classScope, ClassFile classFile) {
        TypeDeclaration typeDeclaration;
        classFile.codeStream.wideMode = false;
        if (this.ignoreFurtherInvestigation) {
            if (this.binding == null) {
                return;
            }
            CategorizedProblem[] categorizedProblemArray = this.scope.referenceCompilationUnit().compilationResult.getProblems();
            int n = categorizedProblemArray.length;
            CategorizedProblem[] categorizedProblemArray2 = new CategorizedProblem[n];
            System.arraycopy(categorizedProblemArray, 0, categorizedProblemArray2, 0, n);
            classFile.addProblemMethod(this, this.binding, categorizedProblemArray2);
            return;
        }
        int n = 0;
        CompilationResult compilationResult = null;
        int n2 = 0;
        if (classScope != null && (typeDeclaration = classScope.referenceContext) != null) {
            compilationResult = typeDeclaration.compilationResult();
            n2 = compilationResult.problemCount;
        }
        boolean bl = false;
        boolean bl2 = false;
        do {
            try {
                n = classFile.contentsOffset;
                this.generateCode(classFile);
                bl = false;
            }
            catch (AbortMethod abortMethod) {
                if (abortMethod.compilationResult == CodeStream.RESTART_IN_WIDE_MODE) {
                    classFile.contentsOffset = n;
                    --classFile.methodCount;
                    classFile.codeStream.resetInWideMode();
                    if (compilationResult != null) {
                        compilationResult.problemCount = n2;
                    }
                    bl = true;
                    continue;
                }
                if (abortMethod.compilationResult == CodeStream.RESTART_CODE_GEN_FOR_UNUSED_LOCALS_MODE) {
                    classFile.contentsOffset = n;
                    --classFile.methodCount;
                    classFile.codeStream.resetForCodeGenUnusedLocals();
                    if (compilationResult != null) {
                        compilationResult.problemCount = n2;
                    }
                    bl = true;
                    continue;
                }
                bl = false;
                bl2 = true;
            }
        } while (bl);
        if (bl2) {
            CategorizedProblem[] categorizedProblemArray = this.scope.referenceCompilationUnit().compilationResult.getAllProblems();
            int n3 = categorizedProblemArray.length;
            CategorizedProblem[] categorizedProblemArray3 = new CategorizedProblem[n3];
            System.arraycopy(categorizedProblemArray, 0, categorizedProblemArray3, 0, n3);
            classFile.addProblemMethod(this, this.binding, categorizedProblemArray3, n);
        }
    }

    public void generateCode(ClassFile classFile) {
        classFile.generateMethodInfoHeader(this.binding);
        int n = classFile.contentsOffset;
        int n2 = classFile.generateMethodInfoAttributes(this.binding);
        if (!this.binding.isNative() && !this.binding.isAbstract()) {
            int n3;
            int n4;
            int n5 = classFile.contentsOffset;
            classFile.generateCodeAttributeHeader();
            CodeStream codeStream = classFile.codeStream;
            codeStream.reset(this, classFile);
            this.scope.computeLocalVariablePositions(this.binding.isStatic() ? 0 : 1, codeStream);
            if (this.arguments != null) {
                n4 = this.arguments.length;
                for (n3 = 0; n3 < n4; ++n3) {
                    LocalVariableBinding localVariableBinding = this.arguments[n3].binding;
                    codeStream.addVisibleLocalVariable(localVariableBinding);
                    localVariableBinding.recordInitializationStartPC(0);
                }
            }
            if (this.statements != null) {
                n4 = this.statements.length;
                for (n3 = 0; n3 < n4; ++n3) {
                    this.statements[n3].generateCode(this.scope, codeStream);
                }
            }
            if (this.ignoreFurtherInvestigation) {
                throw new AbortMethod(this.scope.referenceCompilationUnit().compilationResult, null);
            }
            if ((this.bits & 0x40) != 0) {
                codeStream.return_();
            }
            codeStream.exitUserScope(this.scope);
            codeStream.recordPositionsFrom(0, this.declarationSourceEnd);
            try {
                classFile.completeCodeAttribute(n5);
            }
            catch (NegativeArraySizeException negativeArraySizeException) {
                throw new AbortMethod(this.scope.referenceCompilationUnit().compilationResult, null);
            }
            ++n2;
        } else {
            this.checkArgumentsSize();
        }
        classFile.completeMethodInfo(this.binding, n, n2);
    }

    public void getAllAnnotationContexts(int n, List list) {
    }

    private void checkArgumentsSize() {
        TypeBinding[] typeBindingArray = this.binding.parameters;
        int n = 1;
        int n2 = typeBindingArray.length;
        for (int i = 0; i < n2; ++i) {
            switch (typeBindingArray[i].id) {
                case 7: 
                case 8: {
                    n += 2;
                    break;
                }
                default: {
                    ++n;
                }
            }
            if (n <= 255) continue;
            this.scope.problemReporter().noMoreAvailableSpaceForArgument(this.scope.locals[i], this.scope.locals[i].declaration);
        }
    }

    @Override
    public CompilationUnitDeclaration getCompilationUnitDeclaration() {
        if (this.scope != null) {
            return this.scope.compilationUnitScope().referenceContext;
        }
        return null;
    }

    @Override
    public boolean hasErrors() {
        return this.ignoreFurtherInvestigation;
    }

    public boolean isAbstract() {
        if (this.binding != null) {
            return this.binding.isAbstract();
        }
        return (this.modifiers & 0x400) != 0;
    }

    public boolean isAnnotationMethod() {
        return false;
    }

    public boolean isClinit() {
        return false;
    }

    public boolean isConstructor() {
        return false;
    }

    public boolean isDefaultConstructor() {
        return false;
    }

    public boolean isDefaultMethod() {
        return false;
    }

    public boolean isInitializationMethod() {
        return false;
    }

    public boolean isMethod() {
        return false;
    }

    public boolean isNative() {
        if (this.binding != null) {
            return this.binding.isNative();
        }
        return (this.modifiers & 0x100) != 0;
    }

    public boolean isStatic() {
        if (this.binding != null) {
            return this.binding.isStatic();
        }
        return (this.modifiers & 8) != 0;
    }

    public abstract void parseStatements(Parser var1, CompilationUnitDeclaration var2);

    @Override
    public StringBuffer print(int n, StringBuffer stringBuffer) {
        int n2;
        TypeParameter[] typeParameterArray;
        if (this.javadoc != null) {
            this.javadoc.print(n, stringBuffer);
        }
        AbstractMethodDeclaration.printIndent(n, stringBuffer);
        AbstractMethodDeclaration.printModifiers(this.modifiers, stringBuffer);
        if (this.annotations != null) {
            AbstractMethodDeclaration.printAnnotations(this.annotations, stringBuffer);
            stringBuffer.append(' ');
        }
        if ((typeParameterArray = this.typeParameters()) != null) {
            stringBuffer.append('<');
            n2 = typeParameterArray.length - 1;
            for (int i = 0; i < n2; ++i) {
                typeParameterArray[i].print(0, stringBuffer);
                stringBuffer.append(", ");
            }
            typeParameterArray[n2].print(0, stringBuffer);
            stringBuffer.append('>');
        }
        this.printReturnType(0, stringBuffer).append(this.selector).append('(');
        if (this.receiver != null) {
            this.receiver.print(0, stringBuffer);
        }
        if (this.arguments != null) {
            for (n2 = 0; n2 < this.arguments.length; ++n2) {
                if (n2 > 0 || this.receiver != null) {
                    stringBuffer.append(", ");
                }
                this.arguments[n2].print(0, stringBuffer);
            }
        }
        stringBuffer.append(')');
        if (this.thrownExceptions != null) {
            stringBuffer.append(" throws ");
            for (n2 = 0; n2 < this.thrownExceptions.length; ++n2) {
                if (n2 > 0) {
                    stringBuffer.append(", ");
                }
                this.thrownExceptions[n2].print(0, stringBuffer);
            }
        }
        this.printBody(n + 1, stringBuffer);
        return stringBuffer;
    }

    public StringBuffer printBody(int n, StringBuffer stringBuffer) {
        if (this.isAbstract() || (this.modifiers & 0x1000000) != 0) {
            return stringBuffer.append(';');
        }
        stringBuffer.append(" {");
        if (this.statements != null) {
            for (int i = 0; i < this.statements.length; ++i) {
                stringBuffer.append('\n');
                this.statements[i].printStatement(n, stringBuffer);
            }
        }
        stringBuffer.append('\n');
        AbstractMethodDeclaration.printIndent(n == 0 ? 0 : n - 1, stringBuffer).append('}');
        return stringBuffer;
    }

    public StringBuffer printReturnType(int n, StringBuffer stringBuffer) {
        return stringBuffer;
    }

    public void resolve(ClassScope classScope) {
        if (this.binding == null) {
            this.ignoreFurtherInvestigation = true;
        }
        try {
            this.bindArguments();
            this.resolveReceiver();
            this.bindThrownExceptions();
            this.resolveJavadoc();
            AbstractMethodDeclaration.resolveAnnotations(this.scope, this.annotations, this.binding, this.isConstructor());
            long l = this.scope.compilerOptions().sourceLevel;
            if (l < 0x340000L) {
                this.validateNullAnnotations(this.scope.environment().usesNullTypeAnnotations());
            }
            this.resolveStatements();
            if (this.binding != null && (this.binding.getAnnotationTagBits() & 0x400000000000L) == 0L && (this.binding.modifiers & 0x100000) != 0 && l >= 0x310000L) {
                this.scope.problemReporter().missingDeprecatedAnnotationForMethod(this);
            }
        }
        catch (AbortMethod abortMethod) {
            this.ignoreFurtherInvestigation = true;
        }
    }

    public void resolveReceiver() {
        char[][] cArray;
        if (this.receiver == null) {
            return;
        }
        if (this.receiver.modifiers != 0) {
            this.scope.problemReporter().illegalModifiers(this.receiver.declarationSourceStart, this.receiver.declarationSourceEnd);
        }
        TypeBinding typeBinding = this.receiver.type.resolvedType;
        if (this.binding == null || typeBinding == null || !typeBinding.isValidBinding()) {
            return;
        }
        ReferenceBinding referenceBinding = this.binding.declaringClass;
        if (this.isStatic() || referenceBinding.isAnonymousType()) {
            this.scope.problemReporter().disallowedThisParameter(this.receiver);
            return;
        }
        ReferenceBinding referenceBinding2 = this.scope.enclosingReceiverType();
        if (this.isConstructor()) {
            if (referenceBinding.isStatic() || (referenceBinding.tagBits & 0x18L) == 0L) {
                this.scope.problemReporter().disallowedThisParameter(this.receiver);
                return;
            }
            referenceBinding2 = referenceBinding2.enclosingType();
        }
        char[][] cArray2 = cArray = this.receiver.qualifyingName == null ? (char[][])null : this.receiver.qualifyingName.getName();
        if (this.isConstructor()) {
            if (cArray == null || cArray.length > 1 || !CharOperation.equals(referenceBinding2.sourceName(), cArray[0])) {
                this.scope.problemReporter().illegalQualifierForExplicitThis(this.receiver, referenceBinding2);
                this.receiver.qualifyingName = null;
            }
        } else if (cArray != null && cArray.length > 0) {
            this.scope.problemReporter().illegalQualifierForExplicitThis2(this.receiver);
            this.receiver.qualifyingName = null;
        }
        if (TypeBinding.notEquals(referenceBinding2, typeBinding)) {
            this.scope.problemReporter().illegalTypeForExplicitThis(this.receiver, referenceBinding2);
        }
        if (this.receiver.type.hasNullTypeAnnotation(TypeReference.AnnotationPosition.ANY)) {
            this.scope.problemReporter().nullAnnotationUnsupportedLocation(this.receiver.type);
        }
    }

    public void resolveJavadoc() {
        if (this.binding == null) {
            return;
        }
        if (this.javadoc != null) {
            this.javadoc.resolve(this.scope);
            return;
        }
        if (this.binding.declaringClass != null && !this.binding.declaringClass.isLocalType()) {
            int n = this.binding.modifiers & 7;
            ClassScope classScope = this.scope.classScope();
            ProblemReporter problemReporter = this.scope.problemReporter();
            int n2 = problemReporter.computeSeverity(-1610612250);
            if (n2 != 256) {
                if (classScope != null) {
                    n = Util.computeOuterMostVisibility(classScope.referenceType(), n);
                }
                int n3 = this.binding.modifiers & 0xFFFFFFF8 | n;
                problemReporter.javadocMissing(this.sourceStart, this.sourceEnd, n2, n3);
            }
        }
    }

    public void resolveStatements() {
        if (this.statements != null) {
            int n = this.statements.length;
            for (int i = 0; i < n; ++i) {
                this.statements[i].resolve(this.scope);
            }
        } else if (!((this.bits & 8) == 0 || this.isConstructor() && this.arguments == null)) {
            this.scope.problemReporter().undocumentedEmptyBlock(this.bodyStart - 1, this.bodyEnd + 1);
        }
    }

    @Override
    public void tagAsHavingErrors() {
        this.ignoreFurtherInvestigation = true;
    }

    @Override
    public void tagAsHavingIgnoredMandatoryErrors(int n) {
    }

    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
    }

    public TypeParameter[] typeParameters() {
        return null;
    }

    void validateNullAnnotations(boolean bl) {
        block4: {
            block3: {
                if (this.binding == null) {
                    return;
                }
                if (bl) break block3;
                if (this.binding.parameterNonNullness == null) break block4;
                int n = this.binding.parameters.length;
                for (int i = 0; i < n; ++i) {
                    long l;
                    if (this.binding.parameterNonNullness[i] == null) continue;
                    long l2 = l = this.binding.parameterNonNullness[i] != false ? 0x100000000000000L : 0x80000000000000L;
                    if (this.scope.validateNullAnnotation(l, this.arguments[i].type, this.arguments[i].annotations)) continue;
                    this.binding.parameterNonNullness[i] = null;
                }
                break block4;
            }
            int n = this.binding.parameters.length;
            for (int i = 0; i < n; ++i) {
                this.scope.validateNullAnnotation(this.binding.parameters[i].tagBits, this.arguments[i].type, this.arguments[i].annotations);
            }
        }
    }
}

