/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.heapwalk.ui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.profiler.heapwalk.ClassPresenterPanel;
import org.graalvm.visualvm.lib.profiler.heapwalk.InstancesController;
import org.graalvm.visualvm.lib.profiler.heapwalk.LegendPanel;
import org.graalvm.visualvm.lib.profiler.heapwalk.model.BrowserUtils;
import org.graalvm.visualvm.lib.profiler.heapwalk.ui.Bundle;
import org.graalvm.visualvm.lib.ui.components.HTMLTextArea;
import org.graalvm.visualvm.lib.ui.components.JExtendedSplitPane;

public class InstancesControllerUI
extends JPanel {
    private static final String DATA = "Data";
    private static final String NO_DATA = "No data";
    private AbstractButton presenter;
    private CardLayout contents;
    private InstancesController instancesController;
    private JPanel dataPanel;
    private JPanel noDataPanel;
    private JSplitPane browsersSplit;
    private JSplitPane contentsSplit;
    private LegendPanel legendPanel;

    public InstancesControllerUI(InstancesController instancesController) {
        this.instancesController = instancesController;
        this.initComponents();
    }

    public AbstractButton getPresenter() {
        if (this.presenter == null) {
            this.presenter = new Presenter();
        }
        return this.presenter;
    }

    public void update() {
        if (this.contents != null) {
            if (this.instancesController.getSelectedClass() == null) {
                this.contents.show(this, NO_DATA);
            } else {
                this.contents.show(this, DATA);
            }
        }
    }

    private void initComponents() {
        JPanel fieldsBrowserPanel = this.instancesController.getFieldsBrowserController().getPanel();
        JPanel referencesBrowserPanel = this.instancesController.getReferencesBrowserController().getPanel();
        JPanel instancesListPanel = this.instancesController.getInstancesListController().getPanel();
        this.browsersSplit = new JExtendedSplitPane(0, (Component)fieldsBrowserPanel, (Component)referencesBrowserPanel);
        this.tweakSplitPaneUI(this.browsersSplit);
        this.browsersSplit.setResizeWeight(0.5);
        this.contentsSplit = new JExtendedSplitPane(1, (Component)instancesListPanel, (Component)this.browsersSplit);
        this.tweakSplitPaneUI(this.contentsSplit);
        this.contentsSplit.setDividerLocation(instancesListPanel.getPreferredSize().width);
        ClassPresenterPanel classPresenterPanel = this.instancesController.getClassPresenterPanel();
        classPresenterPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 3, 0, this.getBackground()), classPresenterPanel.getBorder()));
        this.legendPanel = new LegendPanel(true);
        this.dataPanel = new JPanel(new BorderLayout());
        this.dataPanel.setOpaque(false);
        this.dataPanel.add((Component)classPresenterPanel, "North");
        this.dataPanel.add((Component)this.contentsSplit, "Center");
        this.dataPanel.add((Component)this.legendPanel, "South");
        this.noDataPanel = new JPanel(new BorderLayout());
        this.noDataPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        HTMLTextArea hintArea = new HTMLTextArea(){

            protected void showURL(URL url) {
                InstancesControllerUI.this.instancesController.getHeapFragmentWalker().switchToClassesView();
            }
        };
        hintArea.setBorder(BorderFactory.createEmptyBorder(10, 8, 8, 8));
        String classesRes = Icons.getResource((String)"LanguageIcons.Class");
        String hintText = Bundle.InstancesControllerUI_NoClassDefinedMsg("<a href='#'><img border='0' align='bottom' src='nbresloc:/" + classesRes + "'></a>");
        hintArea.setText(hintText);
        this.noDataPanel.add((Component)hintArea, "Center");
        this.contents = new CardLayout();
        this.setLayout(this.contents);
        this.add((Component)this.noDataPanel, NO_DATA);
        this.add((Component)this.dataPanel, DATA);
        LegendUpdater legendUpdater = new LegendUpdater();
        fieldsBrowserPanel.addHierarchyListener(legendUpdater);
        referencesBrowserPanel.addHierarchyListener(legendUpdater);
    }

    private void tweakSplitPaneUI(JSplitPane splitPane) {
        splitPane.setOpaque(false);
        splitPane.setBorder(null);
        splitPane.setDividerSize(3);
        if (!(splitPane.getUI() instanceof BasicSplitPaneUI)) {
            return;
        }
        BasicSplitPaneDivider divider = ((BasicSplitPaneUI)splitPane.getUI()).getDivider();
        if (divider != null) {
            divider.setBorder(null);
        }
    }

    private class LegendUpdater
    implements HierarchyListener {
        private LegendUpdater() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            JPanel fieldsBrowserPanel = InstancesControllerUI.this.instancesController.getFieldsBrowserController().getPanel();
            JPanel referencesBrowserPanel = InstancesControllerUI.this.instancesController.getReferencesBrowserController().getPanel();
            if ((e.getChangeFlags() & 4L) != 0L) {
                InstancesControllerUI.this.legendPanel.setGCRootVisible(referencesBrowserPanel.isShowing());
                InstancesControllerUI.this.legendPanel.setVisible(fieldsBrowserPanel.isShowing() || referencesBrowserPanel.isShowing());
            }
        }
    }

    private static class Presenter
    extends JToggleButton {
        public Presenter() {
            this.setText(Bundle.InstancesControllerUI_ViewCaption());
            this.setToolTipText(Bundle.InstancesControllerUI_ViewDescr());
            this.setIcon(BrowserUtils.ICON_INSTANCE);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            d.width += 4;
            return d;
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }
    }
}

