/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.time.Instant;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.UncheckedParseException;
import org.openstreetmap.josm.tools.date.DateUtils;

public class ChangesetClosedException
extends OsmTransferException {
    public static final String ERROR_HEADER_PATTERN = "The changeset (\\d+) was closed at (.*)";
    private long changesetId;
    private Instant closedOn;
    private Source source;

    public static boolean errorHeaderMatchesPattern(String errorHeader) {
        if (errorHeader == null) {
            return false;
        }
        Pattern p = Pattern.compile(ERROR_HEADER_PATTERN);
        Matcher m = p.matcher(errorHeader);
        return m.matches();
    }

    protected final void parseErrorHeader(String errorHeader) {
        Pattern p = Pattern.compile(ERROR_HEADER_PATTERN);
        Matcher m = p.matcher(errorHeader);
        if (m.matches()) {
            this.changesetId = Long.parseLong(m.group(1));
            try {
                this.closedOn = DateUtils.parseInstant(m.group(2));
            }
            catch (UncheckedParseException ex) {
                Logging.error(I18n.tr("Failed to parse date ''{0}'' replied by server.", m.group(2)));
                Logging.error(ex);
            }
        } else {
            Logging.error(I18n.tr("Unexpected format of error header for conflict in changeset update. Got ''{0}''", errorHeader));
        }
    }

    public ChangesetClosedException(String errorHeader) {
        super(errorHeader);
        this.parseErrorHeader(errorHeader);
        this.source = Source.UNSPECIFIED;
    }

    public ChangesetClosedException(String errorHeader, Source source) {
        this(errorHeader, source, null);
    }

    public ChangesetClosedException(String errorHeader, Source source, Throwable cause) {
        super(errorHeader, cause);
        this.parseErrorHeader(errorHeader);
        this.source = source == null ? Source.UNSPECIFIED : source;
    }

    public ChangesetClosedException(long changesetId, Instant closedOn, Source source) {
        super("");
        this.source = source == null ? Source.UNSPECIFIED : source;
        this.changesetId = changesetId;
        this.closedOn = closedOn;
    }

    public long getChangesetId() {
        return this.changesetId;
    }

    public Instant getClosedOn() {
        return this.closedOn;
    }

    public Source getSource() {
        return this.source;
    }

    public void setSource(Source source) {
        this.source = source == null ? Source.UNSPECIFIED : source;
    }

    public static enum Source {
        UPDATE_CHANGESET,
        UPLOAD_DATA,
        UNSPECIFIED;

    }
}

