/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UseStyle;
import net.sourceforge.plantuml.activitydiagram3.Branch;
import net.sourceforge.plantuml.activitydiagram3.ForkStyle;
import net.sourceforge.plantuml.activitydiagram3.Instruction;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.PositionedNote;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyle;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.Rainbow;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class FtileFactoryDelegator
implements FtileFactory {
    private final FtileFactory factory;
    private final Rose rose = new Rose();

    public final StyleSignature getDefaultStyleDefinitionActivity() {
        return StyleSignature.of(SName.root, SName.element, SName.activityDiagram, SName.activity);
    }

    public final StyleSignature getDefaultStyleDefinitionDiamond() {
        return StyleSignature.of(SName.root, SName.element, SName.activityDiagram, SName.activity, SName.diamond);
    }

    public final StyleSignature getDefaultStyleDefinitionArrow() {
        return StyleSignature.of(SName.root, SName.element, SName.activityDiagram, SName.arrow);
    }

    protected final Rainbow getInLinkRenderingColor(Ftile tile) {
        Rainbow color;
        LinkRendering linkRendering = tile.getInLinkRendering();
        if (linkRendering == null) {
            if (UseStyle.useBetaStyle()) {
                Style style = this.getDefaultStyleDefinitionArrow().getMergedStyle(this.skinParam().getCurrentStyleBuilder());
                return Rainbow.build(style, this.skinParam().getIHtmlColorSet(), this.skinParam().getThemeStyle());
            }
            color = Rainbow.build(this.skinParam());
        } else {
            color = linkRendering.getRainbow();
        }
        if (color.size() == 0) {
            if (UseStyle.useBetaStyle()) {
                Style style = this.getDefaultStyleDefinitionArrow().getMergedStyle(this.skinParam().getCurrentStyleBuilder());
                return Rainbow.build(style, this.skinParam().getIHtmlColorSet(), this.skinParam().getThemeStyle());
            }
            color = Rainbow.build(this.skinParam());
        }
        return color;
    }

    protected final TextBlock getTextBlock(Display display) {
        FontConfiguration fontConfiguration;
        if (Display.isNull(display)) {
            return null;
        }
        if (UseStyle.useBetaStyle()) {
            Style style = this.getDefaultStyleDefinitionArrow().getMergedStyle(this.skinParam().getCurrentStyleBuilder());
            fontConfiguration = style.getFontConfiguration(this.skinParam().getThemeStyle(), this.skinParam().getIHtmlColorSet());
        } else {
            fontConfiguration = new FontConfiguration(this.skinParam(), FontParam.ARROW, null);
        }
        return display.create7(fontConfiguration, HorizontalAlignment.LEFT, this.skinParam(), CreoleMode.SIMPLE_LINE);
    }

    protected Display getInLinkRenderingDisplay(Ftile tile) {
        LinkRendering linkRendering = tile.getInLinkRendering();
        if (linkRendering == null) {
            return Display.NULL;
        }
        return linkRendering.getDisplay();
    }

    public FtileFactoryDelegator(FtileFactory factory) {
        this.factory = factory;
    }

    @Override
    public Ftile start(Swimlane swimlane) {
        return this.factory.start(swimlane);
    }

    @Override
    public Ftile end(Swimlane swimlane) {
        return this.factory.end(swimlane);
    }

    @Override
    public Ftile stop(Swimlane swimlane) {
        return this.factory.stop(swimlane);
    }

    @Override
    public Ftile spot(Swimlane swimlane, String spot, HColor color) {
        return this.factory.spot(swimlane, spot, color);
    }

    @Override
    public Ftile activity(Display label, Swimlane swimlane, BoxStyle style, Colors colors, Stereotype stereotype) {
        return this.factory.activity(label, swimlane, style, colors, stereotype);
    }

    @Override
    public Ftile addNote(Ftile ftile, Swimlane swimlane, Collection<PositionedNote> notes) {
        return this.factory.addNote(ftile, swimlane, notes);
    }

    @Override
    public Ftile addUrl(Ftile ftile, Url url) {
        return this.factory.addUrl(ftile, url);
    }

    @Override
    public Ftile decorateIn(Ftile ftile, LinkRendering linkRendering) {
        return this.factory.decorateIn(ftile, Objects.requireNonNull(linkRendering));
    }

    @Override
    public Ftile decorateOut(Ftile ftile, LinkRendering linkRendering) {
        return this.factory.decorateOut(ftile, Objects.requireNonNull(linkRendering));
    }

    @Override
    public Ftile assembly(Ftile tile1, Ftile tile2) {
        return this.factory.assembly(tile1, tile2);
    }

    @Override
    public Ftile repeat(BoxStyle boxStyleIn, Swimlane swimlane, Swimlane swimlaneOut, Display startLabel, Ftile repeat, Display test, Display yes, Display out, Colors colors, Ftile backward, boolean noOut, LinkRendering incoming1, LinkRendering incoming2) {
        return this.factory.repeat(boxStyleIn, swimlane, swimlaneOut, startLabel, repeat, test, yes, out, colors, backward, noOut, incoming1, incoming2);
    }

    @Override
    public Ftile createWhile(LinkRendering outColor, Swimlane swimlane, Ftile whileBlock, Display test, Display yes, HColor color, Instruction specialOut, Ftile back, LinkRendering incoming1, LinkRendering incoming2) {
        return this.factory.createWhile(outColor, swimlane, whileBlock, test, yes, color, specialOut, back, incoming1, incoming2);
    }

    @Override
    public Ftile createIf(Swimlane swimlane, List<Branch> thens, Branch elseBranch, LinkRendering afterEndwhile, LinkRendering topInlinkRendering, Url url) {
        return this.factory.createIf(swimlane, thens, elseBranch, afterEndwhile, topInlinkRendering, url);
    }

    @Override
    public Ftile createSwitch(Swimlane swimlane, List<Branch> branches, LinkRendering afterEndwhile, LinkRendering topInlinkRendering, Display labelTest) {
        return this.factory.createSwitch(swimlane, branches, afterEndwhile, topInlinkRendering, labelTest);
    }

    @Override
    public Ftile createParallel(List<Ftile> all, ForkStyle style, String label, Swimlane in, Swimlane out) {
        return this.factory.createParallel(all, style, label, in, out);
    }

    @Override
    public Ftile createGroup(Ftile list, Display name, HColor backColor, HColor titleColor, PositionedNote note, HColor borderColor, USymbol type, double roundCorner) {
        return this.factory.createGroup(list, name, backColor, titleColor, note, borderColor, type, roundCorner);
    }

    @Override
    public StringBounder getStringBounder() {
        return this.factory.getStringBounder();
    }

    protected final Rose getRose() {
        return this.rose;
    }

    @Override
    public final ISkinParam skinParam() {
        return this.factory.skinParam();
    }

    protected FtileFactory getFactory() {
        return this.factory;
    }
}

