/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic.color;

import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamColors;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.ThemeStyle;
import net.sourceforge.plantuml.UseStyle;
import net.sourceforge.plantuml.cucadiagram.LinkStyle;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorSet;
import net.sourceforge.plantuml.ugraphic.color.NoSuchColorException;

public class Colors {
    private final Map<ColorType, HColor> map = new EnumMap<ColorType, HColor>(ColorType.class);
    private LinkStyle lineStyle = null;
    private Boolean shadowing = null;

    public String toString() {
        return this.map.toString() + " " + this.lineStyle;
    }

    public static Colors empty() {
        return new Colors();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    private Colors copy() {
        Colors result = new Colors();
        result.map.putAll(this.map);
        result.lineStyle = this.lineStyle;
        return result;
    }

    private Colors() {
    }

    public Colors(ThemeStyle themeStyle, String data, HColorSet set, ColorType mainType) throws NoSuchColorException {
        data = StringUtils.goLowerCase(data);
        StringTokenizer st = new StringTokenizer(data, "#;");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            int x = s.indexOf(58);
            if (x == -1) {
                if (s.contains(".")) continue;
                this.map.put(mainType, set.getColor(themeStyle, s));
                continue;
            }
            String name = s.substring(0, x);
            String value = s.substring(x + 1);
            if (name.equalsIgnoreCase("shadowing")) {
                this.shadowing = value.equalsIgnoreCase("true");
                continue;
            }
            ColorType key = ColorType.getType(name);
            HColor color = set.getColor(themeStyle, value);
            this.map.put(key, color);
        }
        if (data.contains("line.dashed")) {
            this.lineStyle = LinkStyle.DASHED();
        } else if (data.contains("line.dotted")) {
            this.lineStyle = LinkStyle.DOTTED();
        } else if (data.contains("line.bold")) {
            this.lineStyle = LinkStyle.BOLD();
        }
    }

    public HColor getColor(ColorType key) {
        return this.map.get((Object)Objects.requireNonNull(key));
    }

    public HColor getColor(ColorType key1, ColorType key2) {
        HColor result = this.getColor(key1);
        if (result != null) {
            return result;
        }
        return this.getColor(key2);
    }

    public UStroke getSpecificLineStroke() {
        if (this.lineStyle == null) {
            return null;
        }
        return this.lineStyle.getStroke3();
    }

    public Colors add(ColorType type, HColor color) {
        if (color == null) {
            return this;
        }
        Colors result = this.copy();
        result.map.put(type, color);
        return result;
    }

    private Colors add(ColorType colorType, Colors other) {
        Colors result = this.copy();
        result.map.putAll(other.map);
        if (other.lineStyle != null) {
            result.lineStyle = other.lineStyle;
        }
        return result;
    }

    public final LinkStyle getLineStyle() {
        return this.lineStyle;
    }

    public ISkinParam mute(ISkinParam skinParam) {
        return new SkinParamColors(skinParam, this);
    }

    public Colors addLegacyStroke(String s) {
        Colors result = this.copy();
        result.lineStyle = LinkStyle.fromString1(StringUtils.goUpperCase(Objects.requireNonNull(s)));
        return result;
    }

    public static UGraphic applyStroke(UGraphic ug, Colors colors) {
        if (colors == null) {
            return ug;
        }
        if (colors.lineStyle == null) {
            return ug;
        }
        return ug.apply(colors.lineStyle.getStroke3());
    }

    public Colors applyStereotype(Stereotype stereotype, ISkinParam skinParam, ColorParam param) throws NoSuchColorException {
        Objects.requireNonNull(stereotype);
        ColorType colorType = Objects.requireNonNull(Objects.requireNonNull(param).getColorType());
        if (this.getColor(colorType) != null) {
            return this;
        }
        Colors colors = skinParam.getColors(param, stereotype);
        return this.add(colorType, colors);
    }

    private Colors applyFontParamStereotype(Stereotype stereotype, ISkinParam skinParam, FontParam param) {
        Objects.requireNonNull(stereotype);
        if (param == null) {
            return this;
        }
        ColorType colorType = ColorType.TEXT;
        if (this.getColor(colorType) != null) {
            return this;
        }
        if (UseStyle.useBetaStyle()) {
            return this;
        }
        HColor col = skinParam.getFontHtmlColor(stereotype, param);
        return this.add(colorType, col);
    }

    public Colors applyStereotypeForNote(Stereotype stereotype, ISkinParam skinParam, FontParam fontParam, ColorParam ... params) throws NoSuchColorException {
        Objects.requireNonNull(stereotype);
        Colors result = this;
        for (ColorParam param : Objects.requireNonNull(params)) {
            result = result.applyStereotype(stereotype, skinParam, param);
        }
        result = result.applyFontParamStereotype(stereotype, skinParam, fontParam);
        result.shadowing = skinParam.shadowingForNote(stereotype);
        return result;
    }

    public Boolean getShadowing() {
        return this.shadowing;
    }

    public UStroke muteStroke(UStroke stroke) {
        if (this.lineStyle == null) {
            return stroke;
        }
        return this.lineStyle.muteStroke(stroke);
    }
}

