/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.util.EnumSet;

public enum USegmentType {
    SEG_MOVETO(0),
    SEG_LINETO(1),
    SEG_QUADTO(2),
    SEG_CUBICTO(3),
    SEG_CLOSE(4),
    SEG_ARCTO(4321);

    private final int code;

    private USegmentType(int code) {
        this.code = code;
    }

    public int getNbPoints() {
        switch (this) {
            case SEG_MOVETO: {
                return 1;
            }
            case SEG_LINETO: {
                return 1;
            }
            case SEG_CUBICTO: {
                return 3;
            }
            case SEG_CLOSE: {
                return 0;
            }
        }
        throw new UnsupportedOperationException();
    }

    public static USegmentType getByCode(int code) {
        for (USegmentType p : EnumSet.allOf(USegmentType.class)) {
            if (p.code != code) continue;
            return p;
        }
        throw new IllegalArgumentException();
    }
}

