import camelCase from 'camelcase';

/*! *****************************************************************************
Copyright (c) Microsoft Corporation. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License"); you may not use
this file except in compliance with the License. You may obtain a copy of the
License at http://www.apache.org/licenses/LICENSE-2.0

THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED
WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
MERCHANTABLITY OR NON-INFRINGEMENT.

See the Apache Version 2.0 License for specific language governing permissions
and limitations under the License.
***************************************************************************** */
/* global Reflect, Promise */

var extendStatics = function(d, b) {
    extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return extendStatics(d, b);
};

function __extends(d, b) {
    extendStatics(d, b);
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
}

var __assign = function() {
    __assign = Object.assign || function __assign(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};

function __awaiter(thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
}

function __generator(thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
}

var CommonError = /** @class */ (function (_super) {
    __extends(CommonError, _super);
    function CommonError(_a) {
        var type = _a.type, message = _a.message, stack = _a.stack, reqId = _a.reqId, displayMsg = _a.displayMsg, code = _a.code;
        var _this = _super.call(this, message) || this;
        _this.type = type;
        if (stack) {
            _this.stack = stack;
        }
        if (reqId) {
            _this.reqId = reqId;
        }
        if (code) {
            _this.code = code;
        }
        _this.displayMsg = displayMsg !== null && displayMsg !== void 0 ? displayMsg : message;
        return _this;
    }
    return CommonError;
}(Error));

var ServiceType;
(function (ServiceType) {
    /** API 网关服务 (apigateway) */
    ServiceType["apigateway"] = "apigateway";
    ServiceType["apigw"] = "apigw";
    /** 云函数服务 (SCF) */
    ServiceType["faas"] = "scf";
    /** 视频处理服务 (MPS) */
    ServiceType["mps"] = "mps";
    /** 资源标签服务 (TAG) */
    ServiceType["tag"] = "tag";
    /** 内容分发 (CDN) */
    ServiceType["cdn"] = "cdn";
    /** 文件存储 (CFS) */
    ServiceType["cfs"] = "cfs";
    /** 域名解析服务 (CNS) */
    ServiceType["cns"] = "cns";
    /**  */
    ServiceType["domain"] = "domain";
    /** MySQL 数据库 (CynosDB) */
    ServiceType["cynosdb"] = "cynosdb";
    /** Postgres 数据库 (Postgres) */
    ServiceType["postgres"] = "postgres";
    /** 私有网络 (VPC) */
    ServiceType["vpc"] = "vpc";
    /* 访问管理 （CAM）  */
    ServiceType["cam"] = "cam";
    // 负载均衡 （CLB）*/
    ServiceType["clb"] = "clb";
    // 监控 */
    ServiceType["monitor"] = "monitor";
})(ServiceType || (ServiceType = {}));

/**
 * simple deep clone object
 * @param {object} obj object
 */
function deepClone(obj) {
    return JSON.parse(JSON.stringify(obj));
}
/**
 * return variable real type
 * @param {any} obj input variable
 */
function getRealType(obj) {
    return Object.prototype.toString.call(obj).slice(8, -1);
}
/**
 * is array
 * @param obj object
 */
function isArray(obj) {
    return getRealType(obj) === 'Array';
}
/**
 * is object
 * @param obj object
 */
function isObject(obj) {
    return getRealType(obj) === 'Object';
}
function isEmpty(val) {
    return (val === undefined || val === null || (typeof val === 'number' && isNaN(val)));
}
function cleanEmptyValue(obj) {
    var newObj = {};
    for (var key in obj) {
        var val = obj[key];
        if (!isEmpty(val)) {
            newObj[key] = val;
        }
    }
    return newObj;
}
function ApiFactory(_a) {
    var _this = this;
    var _b = _a.debug, debug = _b === void 0 ? false : _b, _c = _a.isV3, isV3 = _c === void 0 ? false : _c, actions = _a.actions, serviceType = _a.serviceType, host = _a.host, path = _a.path, version = _a.version, customHandler = _a.customHandler, _d = _a.responseHandler, responseHandler = _d === void 0 ? function (res) { return res; } : _d, errorHandler = _a.errorHandler, _e = _a.requestClient, requestClient = _e === void 0 ? 'TencentSdk' : _e;
    var APIS = {};
    actions.forEach(function (action) {
        APIS[action] = function (capi, inputs) { return __awaiter(_this, void 0, void 0, function () {
            var reqData, res, Response_1, e_1;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        inputs = deepClone(inputs);
                        reqData = cleanEmptyValue(__assign({ Action: action, Version: version }, inputs));
                        inputs = cleanEmptyValue(inputs);
                        _a.label = 1;
                    case 1:
                        _a.trys.push([1, 3, , 4]);
                        return [4 /*yield*/, capi.request(reqData, {
                                isV3: isV3,
                                debug: debug,
                                RequestClient: requestClient,
                                host: host || serviceType + ".tencentcloudapi.com",
                                path: path || '/',
                            })];
                    case 2:
                        res = _a.sent();
                        // Customize response handler
                        if (customHandler) {
                            return [2 /*return*/, customHandler(action, res)];
                        }
                        Response_1 = res.Response;
                        if (Response_1 && Response_1.Error && Response_1.Error.Code) {
                            if (errorHandler) {
                                return [2 /*return*/, errorHandler(action, Response_1)];
                            }
                            throw new CommonError({
                                type: "API_" + serviceType.toUpperCase() + "_" + action,
                                message: Response_1.Error.Message + " (reqId: " + Response_1.RequestId + ")",
                                reqId: Response_1.RequestId,
                                code: Response_1.Error.Code,
                            });
                        }
                        return [2 /*return*/, responseHandler(Response_1)];
                    case 3:
                        e_1 = _a.sent();
                        throw new CommonError({
                            type: "API_" + serviceType.toUpperCase() + "_" + action,
                            message: e_1.message,
                            stack: e_1.stack,
                            reqId: e_1.reqId,
                            code: e_1.code,
                        });
                    case 4: return [2 /*return*/];
                }
            });
        }); };
    });
    return APIS;
}
function camelCaseProps(obj, pascalCase) {
    if (pascalCase === void 0) { pascalCase = false; }
    var res = {};
    if (isObject(obj)) {
        res = {};
        Object.keys(obj).forEach(function (key) {
            var val = obj[key];
            var k = camelCase(key, { pascalCase: pascalCase });
            res[k] =
                isObject(val) || isArray(val) ? camelCaseProps(val, pascalCase) : val;
        });
    }
    if (isArray(obj)) {
        res = [];
        obj.forEach(function (item) {
            res.push(isObject(item) || isArray(item)
                ? camelCaseProps(item, pascalCase)
                : item);
        });
    }
    return res;
}
function pascalCaseProps(obj) {
    return camelCaseProps(obj, true);
}

export { deepClone, getRealType, isArray, isObject, isEmpty, cleanEmptyValue, ApiFactory, camelCaseProps, pascalCaseProps, ServiceType, CommonError };
//# sourceMappingURL=index.esm.js.map
