"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.pullTask = void 0;
const parse_pull_1 = require("../parsers/parse-pull");
function pullTask(remote, branch, customArgs) {
    const commands = ['pull', ...customArgs];
    if (remote && branch) {
        commands.splice(1, 0, remote, branch);
    }
    return {
        commands,
        format: 'utf-8',
        parser(stdOut, stdErr) {
            return parse_pull_1.parsePullResult(stdOut, stdErr);
        }
    };
}
exports.pullTask = pullTask;
//# sourceMappingURL=pull.js.map