/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.lang.instrument.ClassDefinition;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.WeakSet;

final class NbInstrumentation
implements Instrumentation {
    private static final Logger LOG = Logger.getLogger(NbInstrumentation.class.getName());
    private static final Object LOCK = new Object();
    private static volatile Collection<NbInstrumentation> ACTIVE;
    private final List<ClassFileTransformer> transformers = new CopyOnWriteArrayList<ClassFileTransformer>();
    private static final ThreadLocal<Boolean> IN;

    NbInstrumentation() {
    }

    static NbInstrumentation registerAgent(ClassLoader classLoader, String string) {
        try {
            return NbInstrumentation.registerImpl(string, classLoader);
        }
        catch (Throwable throwable) {
            LOG.log(Level.WARNING, "Cannot register " + string, throwable);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void unregisterAgent(NbInstrumentation nbInstrumentation) {
        Object object = LOCK;
        synchronized (object) {
            if (ACTIVE != null) {
                WeakSet weakSet = new WeakSet(ACTIVE);
                weakSet.remove(nbInstrumentation);
                ACTIVE = weakSet;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static NbInstrumentation registerImpl(String string, ClassLoader classLoader) throws ClassNotFoundException, IllegalArgumentException, NoSuchMethodException, SecurityException, IllegalAccessException, InvocationTargetException {
        NbInstrumentation nbInstrumentation = new NbInstrumentation();
        Class<?> clazz = LOCK;
        synchronized (clazz) {
            ACTIVE = ACTIVE == null ? new WeakSet() : new WeakSet(ACTIVE);
            ACTIVE.add(nbInstrumentation);
        }
        clazz = Class.forName(string, true, classLoader);
        try {
            Method method = clazz.getMethod("agentmain", String.class, Instrumentation.class);
            method.invoke(null, "", nbInstrumentation);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Method method = clazz.getMethod("agentmain", String.class);
            method.invoke(null, "");
        }
        return nbInstrumentation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] patchByteCode(ClassLoader classLoader, String string, ProtectionDomain protectionDomain, byte[] byArray) throws IllegalClassFormatException {
        if (ACTIVE == null) {
            return byArray;
        }
        if (Boolean.TRUE.equals(IN.get())) {
            return byArray;
        }
        try {
            IN.set(Boolean.TRUE);
            for (NbInstrumentation nbInstrumentation : ACTIVE) {
                for (ClassFileTransformer classFileTransformer : nbInstrumentation.transformers) {
                    byArray = classFileTransformer.transform(classLoader, string, null, protectionDomain, byArray);
                }
            }
        }
        finally {
            IN.set(null);
        }
        return byArray;
    }

    @Override
    public void addTransformer(ClassFileTransformer classFileTransformer, boolean bl) {
        this.transformers.add(classFileTransformer);
    }

    @Override
    public void addTransformer(ClassFileTransformer classFileTransformer) {
        this.transformers.add(classFileTransformer);
    }

    @Override
    public boolean removeTransformer(ClassFileTransformer classFileTransformer) {
        return this.transformers.remove(classFileTransformer);
    }

    @Override
    public boolean isRetransformClassesSupported() {
        return false;
    }

    @Override
    public void retransformClasses(Class<?> ... classArray) throws UnmodifiableClassException {
        throw new UnmodifiableClassException();
    }

    @Override
    public boolean isRedefineClassesSupported() {
        return false;
    }

    @Override
    public void redefineClasses(ClassDefinition ... classDefinitionArray) throws ClassNotFoundException, UnmodifiableClassException {
        throw new UnmodifiableClassException();
    }

    @Override
    public boolean isModifiableClass(Class<?> clazz) {
        return false;
    }

    @Override
    public Class[] getAllLoadedClasses() {
        return new Class[0];
    }

    @Override
    public Class[] getInitiatedClasses(ClassLoader classLoader) {
        return new Class[0];
    }

    @Override
    public long getObjectSize(Object object) {
        return 42L;
    }

    @Override
    public void appendToBootstrapClassLoaderSearch(JarFile jarFile) {
    }

    @Override
    public void appendToSystemClassLoaderSearch(JarFile jarFile) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isNativeMethodPrefixSupported() {
        return false;
    }

    @Override
    public void setNativeMethodPrefix(ClassFileTransformer classFileTransformer, String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void redefineModule(Module module, Set<Module> set, Map<String, Set<Module>> map, Map<String, Set<Module>> map2, Set<Class<?>> set2, Map<Class<?>, List<Class<?>>> map3) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isModifiableModule(Module module) {
        return false;
    }

    static {
        IN = new ThreadLocal();
    }
}

