import { Method } from 'got';
export interface AnyObject {
    [prop: string]: any;
}
export interface ClsOptions {
    baseHost?: string;
    region: string;
    secretId: string;
    secretKey: string;
    token?: string;
    debug?: boolean;
    timeout?: number;
    expire?: number;
}
export interface RequestOptions {
    debug?: boolean;
    path: string;
    method: Method;
    query?: AnyObject;
    data?: AnyObject;
    headers?: AnyObject;
    options?: ClsOptions;
}
export interface ApiError {
    message: string;
}
export interface ApiResponse {
    error?: ApiError;
    [prop: string]: any;
}
export interface TopicExtractRule {
    time_key?: string;
    time_format?: string;
    delimiter?: string;
    log_regex?: string;
    beginning_regex?: string;
    keys?: string[];
    filter_keys?: string[];
    filter_regex?: string[];
}
export interface CreateTopicData {
    logset_id: string;
    topic_name: string;
    partition_count?: number;
    path?: string;
    wild_path?: string;
    log_type?: string;
    extract_rule?: TopicExtractRule;
}
export interface UpdateTopicData extends CreateTopicData {
    topic_id: string;
}
export interface IndexFullTextRule {
    case_sensitive: boolean;
    tokenizer?: string;
}
export interface IndexKeyValueRule {
    case_sensitive: boolean;
    keys: string[];
    types: string[];
    tokenizers?: string[];
}
export interface IndexRule {
    full_text?: IndexFullTextRule;
    key_value?: IndexKeyValueRule;
}
export interface UpdateIndexData {
    topic_id: string;
    effective: boolean;
    rule?: IndexRule;
}
export interface SearchLogData {
    logset_id: string;
    topic_ids: string;
    start_time: string;
    end_time: string;
    query_string: string;
    limit: number;
    context?: string;
    sort?: string;
}
//# sourceMappingURL=index.d.ts.map