/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.security.AlgorithmConstraints;
import java.security.AlgorithmParameters;
import java.security.CryptoPrimitive;
import java.security.Key;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.bouncycastle.jsse.java.security.BCAlgorithmConstraints;
import org.bouncycastle.jsse.java.security.BCCryptoPrimitive;
import org.bouncycastle.jsse.provider.JsseUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
abstract class JsseUtils_7
extends JsseUtils {
    static final Set<CryptoPrimitive> KEY_AGREEMENT_CRYPTO_PRIMITIVES = Collections.unmodifiableSet(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT));
    static final Set<CryptoPrimitive> KEY_ENCAPSULATION_CRYPTO_PRIMITIVES = Collections.unmodifiableSet(EnumSet.of(CryptoPrimitive.KEY_ENCAPSULATION));
    static final Set<CryptoPrimitive> SIGNATURE_CRYPTO_PRIMITIVES = Collections.unmodifiableSet(EnumSet.of(CryptoPrimitive.SIGNATURE));
    static final AlgorithmConstraints DEFAULT_ALGORITHM_CONSTRAINTS = new ExportAlgorithmConstraints(DEFAULT_ALGORITHM_CONSTRAINTS_BC);

    JsseUtils_7() {
    }

    static AlgorithmConstraints exportAlgorithmConstraints(BCAlgorithmConstraints bCAlgorithmConstraints) {
        if (DEFAULT_ALGORITHM_CONSTRAINTS_BC == bCAlgorithmConstraints) {
            return DEFAULT_ALGORITHM_CONSTRAINTS;
        }
        if (bCAlgorithmConstraints == null) {
            return null;
        }
        if (bCAlgorithmConstraints instanceof ImportAlgorithmConstraints) {
            return ((ImportAlgorithmConstraints)bCAlgorithmConstraints).unwrap();
        }
        return new ExportAlgorithmConstraints(bCAlgorithmConstraints);
    }

    static Object exportAlgorithmConstraintsDynamic(BCAlgorithmConstraints bCAlgorithmConstraints) {
        return JsseUtils_7.exportAlgorithmConstraints(bCAlgorithmConstraints);
    }

    static CryptoPrimitive exportCryptoPrimitive(BCCryptoPrimitive bCCryptoPrimitive) {
        switch (bCCryptoPrimitive) {
            case MESSAGE_DIGEST: {
                return CryptoPrimitive.MESSAGE_DIGEST;
            }
            case SECURE_RANDOM: {
                return CryptoPrimitive.SECURE_RANDOM;
            }
            case BLOCK_CIPHER: {
                return CryptoPrimitive.BLOCK_CIPHER;
            }
            case STREAM_CIPHER: {
                return CryptoPrimitive.STREAM_CIPHER;
            }
            case MAC: {
                return CryptoPrimitive.MAC;
            }
            case KEY_WRAP: {
                return CryptoPrimitive.KEY_WRAP;
            }
            case PUBLIC_KEY_ENCRYPTION: {
                return CryptoPrimitive.PUBLIC_KEY_ENCRYPTION;
            }
            case SIGNATURE: {
                return CryptoPrimitive.SIGNATURE;
            }
            case KEY_ENCAPSULATION: {
                return CryptoPrimitive.KEY_ENCAPSULATION;
            }
            case KEY_AGREEMENT: {
                return CryptoPrimitive.KEY_AGREEMENT;
            }
        }
        return null;
    }

    static Set<CryptoPrimitive> exportCryptoPrimitives(Set<BCCryptoPrimitive> set) {
        if (SIGNATURE_CRYPTO_PRIMITIVES_BC == set) {
            return SIGNATURE_CRYPTO_PRIMITIVES;
        }
        if (KEY_AGREEMENT_CRYPTO_PRIMITIVES_BC == set) {
            return KEY_AGREEMENT_CRYPTO_PRIMITIVES;
        }
        if (KEY_ENCAPSULATION_CRYPTO_PRIMITIVES_BC == set) {
            return KEY_ENCAPSULATION_CRYPTO_PRIMITIVES;
        }
        HashSet<CryptoPrimitive> hashSet = new HashSet<CryptoPrimitive>();
        for (BCCryptoPrimitive bCCryptoPrimitive : set) {
            hashSet.add(JsseUtils_7.exportCryptoPrimitive(bCCryptoPrimitive));
        }
        return hashSet;
    }

    static BCAlgorithmConstraints importAlgorithmConstraints(AlgorithmConstraints algorithmConstraints) {
        if (null == algorithmConstraints) {
            return null;
        }
        if (algorithmConstraints instanceof ExportAlgorithmConstraints) {
            return ((ExportAlgorithmConstraints)algorithmConstraints).unwrap();
        }
        return new ImportAlgorithmConstraints(algorithmConstraints);
    }

    static BCAlgorithmConstraints importAlgorithmConstraintsDynamic(Object object) {
        return JsseUtils_7.importAlgorithmConstraints((AlgorithmConstraints)object);
    }

    static BCCryptoPrimitive importCryptoPrimitive(CryptoPrimitive cryptoPrimitive) {
        switch (cryptoPrimitive) {
            case MESSAGE_DIGEST: {
                return BCCryptoPrimitive.MESSAGE_DIGEST;
            }
            case SECURE_RANDOM: {
                return BCCryptoPrimitive.SECURE_RANDOM;
            }
            case BLOCK_CIPHER: {
                return BCCryptoPrimitive.BLOCK_CIPHER;
            }
            case STREAM_CIPHER: {
                return BCCryptoPrimitive.STREAM_CIPHER;
            }
            case MAC: {
                return BCCryptoPrimitive.MAC;
            }
            case KEY_WRAP: {
                return BCCryptoPrimitive.KEY_WRAP;
            }
            case PUBLIC_KEY_ENCRYPTION: {
                return BCCryptoPrimitive.PUBLIC_KEY_ENCRYPTION;
            }
            case SIGNATURE: {
                return BCCryptoPrimitive.SIGNATURE;
            }
            case KEY_ENCAPSULATION: {
                return BCCryptoPrimitive.KEY_ENCAPSULATION;
            }
            case KEY_AGREEMENT: {
                return BCCryptoPrimitive.KEY_AGREEMENT;
            }
        }
        return null;
    }

    static Set<BCCryptoPrimitive> importCryptoPrimitives(Set<CryptoPrimitive> set) {
        if (SIGNATURE_CRYPTO_PRIMITIVES == set) {
            return SIGNATURE_CRYPTO_PRIMITIVES_BC;
        }
        if (KEY_AGREEMENT_CRYPTO_PRIMITIVES == set) {
            return KEY_AGREEMENT_CRYPTO_PRIMITIVES_BC;
        }
        if (KEY_ENCAPSULATION_CRYPTO_PRIMITIVES == set) {
            return KEY_ENCAPSULATION_CRYPTO_PRIMITIVES_BC;
        }
        HashSet<BCCryptoPrimitive> hashSet = new HashSet<BCCryptoPrimitive>();
        for (CryptoPrimitive cryptoPrimitive : set) {
            hashSet.add(JsseUtils_7.importCryptoPrimitive(cryptoPrimitive));
        }
        return hashSet;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class ExportAlgorithmConstraints
    implements AlgorithmConstraints {
        private final BCAlgorithmConstraints constraints;

        ExportAlgorithmConstraints(BCAlgorithmConstraints bCAlgorithmConstraints) {
            this.constraints = bCAlgorithmConstraints;
        }

        @Override
        public boolean permits(Set<CryptoPrimitive> set, Key key) {
            return this.constraints.permits(JsseUtils_7.importCryptoPrimitives(set), key);
        }

        @Override
        public boolean permits(Set<CryptoPrimitive> set, String string, AlgorithmParameters algorithmParameters) {
            return this.constraints.permits(JsseUtils_7.importCryptoPrimitives(set), string, algorithmParameters);
        }

        @Override
        public boolean permits(Set<CryptoPrimitive> set, String string, Key key, AlgorithmParameters algorithmParameters) {
            return this.constraints.permits(JsseUtils_7.importCryptoPrimitives(set), string, key, algorithmParameters);
        }

        BCAlgorithmConstraints unwrap() {
            return this.constraints;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class ImportAlgorithmConstraints
    implements BCAlgorithmConstraints {
        private final AlgorithmConstraints constraints;

        ImportAlgorithmConstraints(AlgorithmConstraints algorithmConstraints) {
            this.constraints = algorithmConstraints;
        }

        @Override
        public boolean permits(Set<BCCryptoPrimitive> set, Key key) {
            return this.constraints.permits(JsseUtils_7.exportCryptoPrimitives(set), key);
        }

        @Override
        public boolean permits(Set<BCCryptoPrimitive> set, String string, AlgorithmParameters algorithmParameters) {
            return this.constraints.permits(JsseUtils_7.exportCryptoPrimitives(set), string, algorithmParameters);
        }

        @Override
        public boolean permits(Set<BCCryptoPrimitive> set, String string, Key key, AlgorithmParameters algorithmParameters) {
            return this.constraints.permits(JsseUtils_7.exportCryptoPrimitives(set), string, key, algorithmParameters);
        }

        AlgorithmConstraints unwrap() {
            return this.constraints;
        }
    }
}

