import { Capi } from '@tencent-sdk/capi';
import { Cls } from '@tencent-sdk/cls';
import { ActionType } from './apis';
import { Monitor } from './monitor';
import { Credentials, FaasOptions, FaasBaseConfig, FunctionInfo, GetFaasOptions, GetLogOptions, GetLogDetailOptions, ClsConfig, SearchLogItem, SearchLogDetailItem, InvokeOptions, InvokeResult, GetMonitorDataOptions, MonitorData, FormatedMonitorData } from './typings';
export * from './typings';
export * from './monitor';
export declare class FaaS {
    credentials: Credentials;
    region: string;
    capi: Capi;
    cls: Cls;
    monitor: Monitor;
    clsConfigCache: {
        [prop: string]: {
            logsetId: string;
            topicId: string;
        };
    };
    constructor({ secretId, secretKey, token, region, debug, }: FaasOptions);
    /**
     * 设置当前地域
     * @param {string} region 地区
     */
    setRegion(region: string): void;
    /**
     * 获取当前地域
     * @returns {string} 地域
     */
    getRegion(): string;
    request({ Action, ...data }: {
        Action: ActionType;
        [key: string]: any;
    }): Promise<any>;
    /**
     *  获取 faas 详情
     * @param {GetFaasOptions} options 参数
     * @returns {Promise<FunctionInfo | null>} 函数详情，如果不存在则返回 null
     */
    get({ name, namespace, qualifier, showCode, showTriggers, }: GetFaasOptions): Promise<FunctionInfo | null>;
    /**
     * 调用函数
     * @param {InvokeOptions} options 参数
     * @returns {Promise<InvokeResult>} 函数执行结果
     */
    invoke({ name, namespace, qualifier, event, logType, invokeType, }: InvokeOptions): Promise<InvokeResult>;
    /**
     * 获取 faas 的 CLS 配置
     * @param {FaasBaseConfig} options 参数
     * @returns {Promise<ClsConfig>} 函数 CLS 配置
     */
    getClsConfig({ name, namespace, qualifier, }: FaasBaseConfig): Promise<ClsConfig>;
    /**
     * 获取函数日志列表，默认 近1个小时
     * 注意如果同时定义了 startTime 和 endTime，interval 参数将不起作用
     * @param {GetLogOptions} options 参数
     * @returns {Promise<SearchLogItem[]>} 日志列表
     */
    getLogList({ name, namespace, qualifier, status, endTime, interval, limit, startTime, }: GetLogOptions): Promise<SearchLogItem[]>;
    /**
     * 获取请求 ID日志详情，包含多条日志（流式日志），需要自定义拼接
     * @param {GetLogDetailOptions} options 参数
     * @returns {Promise<SearchLogDetailItem[]>} 日志详情列表
     */
    getLogDetail({ startTime, logsetId, topicId, reqId, endTime, }: GetLogDetailOptions): Promise<SearchLogDetailItem[]>;
    /**
     * 通过请求 ID 获取日志详情
     * @param {GetLogOptions} options 参数
     * @returns {Promise<SearchLogItem>} 单条日志详情
     */
    getLogByReqId({ name, namespace, qualifier, endTime, reqId, }: GetLogOptions): Promise<SearchLogItem>;
    /**
     * 获取监控数据，默认获取 Invocation 指标
     * @param {GetMonitorDataOptions} options 参数
     * @returns
     */
    getMetric({ metric, ...rest }: GetMonitorDataOptions): Promise<FormatedMonitorData[] | MonitorData[]>;
}
//# sourceMappingURL=index.d.ts.map