/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import javax.swing.filechooser.FileFilter;

public class DialogFileFilter
extends FileFilter {
    private String description;
    private List<String> extensions;

    public DialogFileFilter(String description) {
        if (description == null) {
            Logger.getLogger(DialogFileFilter.class.getName()).throwing(this.getClass().getName(), "constructor", new NullPointerException("Description cannot be null."));
        }
        this.description = description;
        this.extensions = new ArrayList<String>();
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory() || this.extensions.isEmpty()) {
            return true;
        }
        String fileName = file.getName().toLowerCase();
        for (String extension : this.extensions) {
            if (!fileName.endsWith(extension)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDescription() {
        StringBuffer buffer = new StringBuffer(this.description);
        buffer.append(" (");
        for (String extension : this.extensions) {
            buffer.append("*" + extension).append(" ");
        }
        buffer.deleteCharAt(buffer.length() - 1);
        return buffer.append(")").toString();
    }

    public void setDescription(String description) {
        if (description == null) {
            Logger.getLogger(DialogFileFilter.class.getName()).throwing(this.getClass().getName(), "setDescription", new NullPointerException("Description cannot be null."));
        }
        this.description = description;
    }

    public void addExtension(String extension) {
        if (extension == null) {
            Logger.getLogger(DialogFileFilter.class.getName()).throwing(this.getClass().getName(), "addExtension", new NullPointerException("Description cannot be null."));
        }
        this.extensions.add(extension);
    }

    public void addExtensions(String[] extension) {
        if (extension == null) {
            Logger.getLogger(DialogFileFilter.class.getName()).throwing(this.getClass().getName(), "addExtensions", new NullPointerException("Description cannot be null."));
        }
        for (int i = 0; i < extension.length; ++i) {
            this.extensions.add(extension[i]);
        }
    }

    public void removeExtension(String extension) {
        this.extensions.remove(extension);
    }

    public void clearExtensions() {
        this.extensions.clear();
    }

    public List<String> getExtensions() {
        return this.extensions;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DialogFileFilter other = (DialogFileFilter)obj;
        if (!Objects.equals(this.description, other.description)) {
            return false;
        }
        return Objects.equals(this.extensions, other.extensions);
    }

    public int hashCode() {
        int hash = 3;
        hash = 43 * hash + Objects.hashCode(this.description);
        hash = 43 * hash + Objects.hashCode(this.extensions);
        return hash;
    }
}

