/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.heapwalk.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.profiler.heapwalk.SummaryController;
import org.graalvm.visualvm.lib.profiler.heapwalk.ui.Bundle;
import org.graalvm.visualvm.lib.ui.components.JExtendedSplitPane;

public class SummaryControllerUI
extends JPanel {
    private SummaryController summaryController;
    private Presenter presenter;

    public SummaryControllerUI(SummaryController summaryController) {
        this.summaryController = summaryController;
        this.initComponents();
    }

    public AbstractButton getPresenter() {
        if (this.presenter == null) {
            this.presenter = new Presenter();
        }
        return this.presenter;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        JPanel hintsPanel = this.summaryController.getHintsController().getPanel();
        JExtendedSplitPane contentsSplit = new JExtendedSplitPane(1, (Component)this.summaryController.getOverViewController().getPanel(), (Component)hintsPanel);
        contentsSplit.setResizeWeight(0.75);
        this.tweakSplitPaneUI((JSplitPane)contentsSplit);
        this.add((Component)contentsSplit, "Center");
    }

    private void tweakSplitPaneUI(JSplitPane splitPane) {
        splitPane.setOpaque(false);
        splitPane.setBorder(null);
        splitPane.setDividerSize(3);
        if (!(splitPane.getUI() instanceof BasicSplitPaneUI)) {
            return;
        }
        BasicSplitPaneDivider divider = ((BasicSplitPaneUI)splitPane.getUI()).getDivider();
        if (divider != null) {
            divider.setBorder(null);
        }
    }

    private static class Presenter
    extends JToggleButton {
        private static Icon ICON_INFO = Icons.getIcon((String)"GeneralIcons.Info");

        public Presenter() {
            this.setText(Bundle.SummaryControllerUI_ViewTitle());
            this.setToolTipText(Bundle.SummaryControllerUI_ViewDescr());
            this.setIcon(ICON_INFO);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            d.width += 4;
            return d;
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }
    }
}

