/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.extension.svg;

import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.RenderContext;
import org.apache.batik.ext.awt.image.LinearTransfer;
import org.apache.batik.ext.awt.image.TransferFunction;
import org.apache.batik.ext.awt.image.renderable.AbstractColorInterpolationRable;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.rendered.ComponentTransferRed;
import org.apache.batik.extension.svg.BatikHistogramNormalizationFilter;
import org.apache.batik.extension.svg.HistogramRed;

public class BatikHistogramNormalizationFilter8Bit
extends AbstractColorInterpolationRable
implements BatikHistogramNormalizationFilter {
    private float trim = 0.01f;
    protected int[] histo = null;
    protected float slope;
    protected float intercept;

    @Override
    public void setSource(Filter src) {
        this.init(src, null);
    }

    @Override
    public Filter getSource() {
        return (Filter)this.getSources().get(0);
    }

    @Override
    public float getTrim() {
        return this.trim;
    }

    @Override
    public void setTrim(float trim) {
        this.trim = trim;
        this.touch();
    }

    public BatikHistogramNormalizationFilter8Bit(Filter src, float trim) {
        this.setSource(src);
        this.setTrim(trim);
    }

    public void computeHistogram(RenderContext rc) {
        int i;
        float yscale;
        if (this.histo != null) {
            return;
        }
        Filter src = this.getSource();
        float scale = 100.0f / src.getWidth();
        if (scale > (yscale = 100.0f / src.getHeight())) {
            scale = yscale;
        }
        AffineTransform at = AffineTransform.getScaleInstance(scale, scale);
        rc = new RenderContext(at, rc.getRenderingHints());
        RenderedImage histRI = this.getSource().createRendering(rc);
        this.histo = new HistogramRed(this.convertSourceCS(histRI)).getHistogram();
        int t = (int)((double)((float)(histRI.getWidth() * histRI.getHeight()) * this.trim) + 0.5);
        int c = 0;
        for (i = 0; i < 255 && (c += this.histo[i]) < t; ++i) {
        }
        int low = i;
        c = 0;
        for (i = 255; i > 0 && (c += this.histo[i]) < t; --i) {
        }
        int hi = i;
        this.slope = 255.0f / (float)(hi - low);
        this.intercept = this.slope * (float)(-low) / 255.0f;
    }

    @Override
    public RenderedImage createRendering(RenderContext rc) {
        RenderedImage srcRI = this.getSource().createRendering(rc);
        if (srcRI == null) {
            return null;
        }
        this.computeHistogram(rc);
        SampleModel sm = srcRI.getSampleModel();
        int bands = sm.getNumBands();
        TransferFunction[] tfs = new TransferFunction[bands];
        LinearTransfer tf = new LinearTransfer(this.slope, this.intercept);
        for (int i = 0; i < tfs.length; ++i) {
            tfs[i] = tf;
        }
        return new ComponentTransferRed(this.convertSourceCS(srcRI), tfs, null);
    }
}

