/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.tools;

import eu.hansolo.tilesfx.tools.Point;

public class CatmullRom {
    private CatmullRomSpline splineXValues;
    private CatmullRomSpline splineYValues;

    public CatmullRom(Point P0, Point P1, Point P2, Point P3) {
        assert (P0 != null) : "p0 cannot be null";
        assert (P1 != null) : "p1 cannot be null";
        assert (P2 != null) : "p2 cannot be null";
        assert (P3 != null) : "p3 cannot be null";
        this.splineXValues = new CatmullRomSpline(P0.getX(), P1.getX(), P2.getX(), P3.getX());
        this.splineYValues = new CatmullRomSpline(P0.getY(), P1.getY(), P2.getY(), P3.getY());
    }

    public Point q(double T) {
        return new Point(this.splineXValues.q(T), this.splineYValues.q(T));
    }

    class CatmullRomSpline {
        private double p0;
        private double p1;
        private double p2;
        private double p3;

        protected CatmullRomSpline(double P0, double P1, double P2, double P3) {
            this.p0 = P0;
            this.p1 = P1;
            this.p2 = P2;
            this.p3 = P3;
        }

        protected double q(double T) {
            return 0.5 * (2.0 * this.p1 + (this.p2 - this.p0) * T + (2.0 * this.p0 - 5.0 * this.p1 + 4.0 * this.p2 - this.p3) * T * T + (3.0 * this.p1 - this.p0 - 3.0 * this.p2 + this.p3) * T * T * T);
        }
    }
}

