/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.plus.download;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.osmand.map.OsmandRegions;
import net.osmand.map.WorldRegion;
import net.osmand.plus.download.DownloadActivityType;
import net.osmand.plus.download.DownloadOsmandIndexesHelper;
import net.osmand.plus.download.DownloadResourceGroup;
import net.osmand.plus.download.IndexItem;
import net.sourceforge.offroad.OsmWindow;

public class DownloadResources
extends DownloadResourceGroup {
    public boolean isDownloadedFromInternet = false;
    public boolean downloadFromInternetFailed = false;
    public boolean mapVersionIsIncreased = false;
    public OsmWindow app;
    private Map<String, String> indexFileNames = new LinkedHashMap<String, String>();
    private Map<String, String> indexActivatedFileNames = new LinkedHashMap<String, String>();
    private List<IndexItem> rawResources;
    private Map<WorldRegion, List<IndexItem>> groupByRegion;
    private List<IndexItem> itemsToUpdate = new ArrayList<IndexItem>();
    public static final String WORLD_SEAMARKS_KEY = "world_seamarks_basemap";

    public DownloadResources(OsmWindow app) {
        super(null, DownloadResourceGroup.DownloadResourceGroupType.WORLD, "");
        this.region = app.getRegions().getWorldRegion();
        this.app = app;
    }

    public List<IndexItem> getItemsToUpdate() {
        return this.itemsToUpdate;
    }

    public IndexItem getWorldBaseMapItem() {
        List<IndexItem> list;
        DownloadResourceGroup worldMaps = this.getSubGroupById(DownloadResourceGroup.DownloadResourceGroupType.WORLD_MAPS.getDefaultId());
        IndexItem worldMap = null;
        if (worldMaps != null && (list = worldMaps.getIndividualResources()) != null) {
            for (IndexItem ii : list) {
                if (!ii.getBasename().equalsIgnoreCase("world_basemap")) continue;
                worldMap = ii;
                break;
            }
        }
        return worldMap;
    }

    public IndexItem getIndexItem(String fileName) {
        IndexItem res = null;
        if (this.rawResources == null) {
            return null;
        }
        for (IndexItem item : this.rawResources) {
            if (!fileName.equals(item.getFileName())) continue;
            res = item;
            break;
        }
        return res;
    }

    public List<IndexItem> getIndexItems(WorldRegion region) {
        List<IndexItem> res;
        if (this.groupByRegion != null && (res = this.groupByRegion.get(region)) != null) {
            return res;
        }
        return new LinkedList<IndexItem>();
    }

    public void updateLoadedFiles() {
        this.initAlreadyLoadedFiles();
        this.prepareFilesToUpdate();
    }

    private void initAlreadyLoadedFiles() {
        DateFormat dateFormat = this.app.getResourceManager().getDateFormat();
        Map<String, String> indexActivatedFileNames = this.app.getResourceManager().getIndexFileNames();
        this.listWithAlternatives(dateFormat, this.app.getAppPath(""), ".extra", indexActivatedFileNames);
        Map<String, String> indexFileNames = this.app.getResourceManager().getIndexFileNames();
        this.listWithAlternatives(dateFormat, this.app.getAppPath(""), ".extra", indexFileNames);
        this.listWithAlternatives(dateFormat, this.app.getAppPath("tiles/"), ".sqlitedb", indexFileNames);
        this.app.getResourceManager().getBackupIndexes(indexFileNames);
        this.indexFileNames = indexFileNames;
        this.indexActivatedFileNames = indexActivatedFileNames;
    }

    public boolean checkIfItemOutdated(IndexItem item, DateFormat format) {
        boolean outdated = false;
        String sfName = item.getTargetFileName();
        String indexActivatedDate = this.indexActivatedFileNames.get(sfName);
        String indexFilesDate = this.indexFileNames.get(sfName);
        item.setDownloaded(false);
        item.setOutdated(false);
        if (indexActivatedDate == null && indexFilesDate == null) {
            return false;
        }
        item.setDownloaded(true);
        String date = item.getDate(format);
        boolean parsed = false;
        if (indexActivatedDate != null) {
            try {
                item.setLocalTimestamp(format.parse(indexActivatedDate).getTime());
                parsed = true;
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if (!parsed && indexFilesDate != null) {
            try {
                item.setLocalTimestamp(format.parse(indexFilesDate).getTime());
                parsed = true;
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if (date != null && !date.equals(indexActivatedDate) && !date.equals(indexFilesDate)) {
            if (item.getType() == DownloadActivityType.NORMAL_FILE && !item.extra || item.getType() == DownloadActivityType.ROADS_FILE || item.getType() == DownloadActivityType.WIKIPEDIA_FILE || item.getType() == DownloadActivityType.SRTM_COUNTRY_FILE) {
                outdated = true;
            } else {
                long itemSize = item.getContentSize();
                long oldItemSize = 0L;
                if (item.getType() == DownloadActivityType.VOICE_FILE) {
                    if (item instanceof DownloadOsmandIndexesHelper.AssetIndexItem) {
                        File file = new File(((DownloadOsmandIndexesHelper.AssetIndexItem)item).getDestFile());
                        oldItemSize = file.length();
                    } else {
                        File fl = new File(item.getType().getDownloadFolder(this.app, item), sfName + "/_config.p");
                        if (fl.exists()) {
                            oldItemSize = fl.length();
                            try {
                                FileInputStream is = new FileInputStream("voice/" + sfName + "/config.p");
                                if (is != null) {
                                    itemSize = ((InputStream)is).available();
                                    ((InputStream)is).close();
                                }
                            }
                            catch (IOException iOException) {}
                        }
                    }
                } else {
                    oldItemSize = this.app.getAppPath(item.getTargetFileName()).length();
                }
                if (itemSize != oldItemSize) {
                    outdated = true;
                }
            }
        }
        item.setOutdated(outdated);
        return outdated;
    }

    protected void updateFilesToUpdate() {
        this.initAlreadyLoadedFiles();
        this.recalculateFilesToUpdate();
    }

    private void recalculateFilesToUpdate() {
        ArrayList<IndexItem> stillUpdate = new ArrayList<IndexItem>();
        for (IndexItem item : this.itemsToUpdate) {
            DateFormat format = this.app.getResourceManager().getDateFormat();
            this.checkIfItemOutdated(item, format);
            if (!item.isOutdated()) continue;
            stillUpdate.add(item);
        }
        this.itemsToUpdate = stillUpdate;
    }

    private Map<String, String> listWithAlternatives(final DateFormat dateFormat, File file, final String ext, final Map<String, String> files) {
        if (file.isDirectory()) {
            file.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String filename) {
                    if (filename.endsWith(ext)) {
                        String date = dateFormat.format(DownloadResources.this.findFileInDir(new File(dir, filename)).lastModified());
                        files.put(filename, date);
                        return true;
                    }
                    return false;
                }
            });
        }
        return files;
    }

    private File findFileInDir(File file) {
        File[] lf;
        if (file.isDirectory() && (lf = file.listFiles()) != null) {
            for (File f : lf) {
                if (!f.isFile()) continue;
                return f;
            }
        }
        return file;
    }

    private void prepareFilesToUpdate() {
        List<IndexItem> filtered = this.rawResources;
        if (filtered != null) {
            this.itemsToUpdate.clear();
            DateFormat format = this.app.getResourceManager().getDateFormat();
            for (IndexItem item : filtered) {
                boolean outdated = this.checkIfItemOutdated(item, format);
                if (!outdated || !this.indexActivatedFileNames.containsKey(item.getTargetFileName())) continue;
                this.itemsToUpdate.add(item);
            }
        }
    }

    protected boolean prepareData(List<IndexItem> resources) {
        this.rawResources = resources;
        DownloadResourceGroup otherMapsGroup = new DownloadResourceGroup(this, DownloadResourceGroup.DownloadResourceGroupType.OTHER_MAPS_GROUP);
        DownloadResourceGroup otherMapsScreen = new DownloadResourceGroup(otherMapsGroup, DownloadResourceGroup.DownloadResourceGroupType.OTHER_MAPS);
        DownloadResourceGroup otherMaps = new DownloadResourceGroup(otherMapsGroup, DownloadResourceGroup.DownloadResourceGroupType.OTHER_MAPS_HEADER);
        otherMapsScreen.addGroup(otherMaps);
        otherMapsGroup.addGroup(otherMapsScreen);
        DownloadResourceGroup voiceGroup = new DownloadResourceGroup(this, DownloadResourceGroup.DownloadResourceGroupType.VOICE_GROUP);
        DownloadResourceGroup voiceScreenTTS = new DownloadResourceGroup(voiceGroup, DownloadResourceGroup.DownloadResourceGroupType.VOICE_TTS);
        DownloadResourceGroup voiceScreenRec = new DownloadResourceGroup(voiceGroup, DownloadResourceGroup.DownloadResourceGroupType.VOICE_REC);
        DownloadResourceGroup voiceTTS = new DownloadResourceGroup(voiceGroup, DownloadResourceGroup.DownloadResourceGroupType.VOICE_HEADER_TTS);
        DownloadResourceGroup voiceRec = new DownloadResourceGroup(voiceGroup, DownloadResourceGroup.DownloadResourceGroupType.VOICE_HEADER_REC);
        DownloadResourceGroup worldMaps = new DownloadResourceGroup(this, DownloadResourceGroup.DownloadResourceGroupType.WORLD_MAPS);
        LinkedHashMap<WorldRegion, List<IndexItem>> groupByRegion = new LinkedHashMap<WorldRegion, List<IndexItem>>();
        OsmandRegions regs = this.app.getRegions();
        for (IndexItem ii : resources) {
            if (ii.getType() == DownloadActivityType.VOICE_FILE) {
                if (ii.getFileName().endsWith(".ttsvoice.zip")) {
                    voiceTTS.addItem(ii);
                    continue;
                }
                voiceRec.addItem(ii);
                continue;
            }
            String basename = ii.getBasename().toLowerCase();
            WorldRegion wg = regs.getRegionDataByDownloadName(basename);
            if (wg != null) {
                if (!groupByRegion.containsKey(wg)) {
                    groupByRegion.put(wg, new ArrayList());
                }
                ((List)groupByRegion.get(wg)).add(ii);
                continue;
            }
            if (ii.getFileName().startsWith("World_")) {
                worldMaps.addItem(ii);
                continue;
            }
            otherMaps.addItem(ii);
        }
        this.groupByRegion = groupByRegion;
        LinkedList<WorldRegion> queue = new LinkedList<WorldRegion>();
        LinkedList<DownloadResourceGroup> parent = new LinkedList<DownloadResourceGroup>();
        DownloadResourceGroup worldSubregions = new DownloadResourceGroup(this, DownloadResourceGroup.DownloadResourceGroupType.SUBREGIONS);
        this.addGroup(worldSubregions);
        for (WorldRegion rg : this.region.getSubregions()) {
            queue.add(rg);
            parent.add(worldSubregions);
        }
        while (!queue.isEmpty()) {
            WorldRegion reg = (WorldRegion)queue.pollFirst();
            DownloadResourceGroup parentGroup = (DownloadResourceGroup)parent.pollFirst();
            List<WorldRegion> subregions = reg.getSubregions();
            DownloadResourceGroup mainGrp = new DownloadResourceGroup(parentGroup, DownloadResourceGroup.DownloadResourceGroupType.REGION, reg.getRegionId());
            mainGrp.region = reg;
            parentGroup.addGroup(mainGrp);
            List list = (List)groupByRegion.get(reg);
            if (list != null) {
                DownloadResourceGroup flatFiles = new DownloadResourceGroup(mainGrp, DownloadResourceGroup.DownloadResourceGroupType.REGION_MAPS);
                for (IndexItem ii : list) {
                    flatFiles.addItem(ii);
                }
                mainGrp.addGroup(flatFiles);
            }
            DownloadResourceGroup subRegions = new DownloadResourceGroup(mainGrp, DownloadResourceGroup.DownloadResourceGroupType.SUBREGIONS);
            mainGrp.addGroup(subRegions);
            for (WorldRegion rg : subregions) {
                queue.add(rg);
                parent.add(subRegions);
            }
        }
        this.addGroup(worldMaps);
        if (otherMaps.size() > 0) {
            this.addGroup(otherMapsGroup);
        }
        voiceScreenTTS.addGroup(voiceTTS);
        voiceScreenRec.addGroup(voiceRec);
        voiceGroup.addGroup(voiceScreenTTS);
        voiceGroup.addGroup(voiceScreenRec);
        this.addGroup(voiceGroup);
        this.createHillshadeSRTMGroups();
        this.trimEmptyGroups();
        this.updateLoadedFiles();
        return true;
    }
}

