/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.resolver.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.repository.Repository;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.resolver.util.ResolvedResource;
import org.apache.ivy.util.Message;

public final class ResolverHelper {
    public static String[] listTokenValues(Repository repository, String string, String object) {
        String string2;
        String string3 = repository.getFileSeparator();
        int n = (string = repository.standardize(string)).indexOf(string2 = IvyPatternHelper.getTokenString((String)object));
        if (n == -1) {
            Message.verbose("unable to list " + (String)object + " in " + string + ": token not found in pattern");
            return null;
        }
        if ((string.length() <= n + string2.length() || string3.equals(string.substring(n + string2.length(), n + string2.length() + 1))) && (n == 0 || string3.equals(string.substring(n - 1, n)))) {
            string2 = string.substring(0, n);
            return ResolverHelper.listAll(repository, string2);
        }
        int n2 = string.substring(0, n).lastIndexOf(string3);
        String string4 = n2 == -1 ? "" : string.substring(0, n2);
        try {
            Message.debug("\tusing " + repository + " to list all in " + string4);
            List list = repository.list(string4);
            if (list != null) {
                Message.debug("\t\tfound " + list.size() + " urls");
                ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
                int n3 = string.indexOf(string3, n2 + 1);
                Object object2 = n3 != -1 ? string.substring(n2 + 1, n3) : string.substring(n2 + 1);
                object2 = ((String)object2).replaceAll("\\.", "\\\\.");
                object2 = IvyPatternHelper.substituteToken((String)object2, (String)object, "(.+)");
                object = Pattern.compile((String)object2);
                for (Object object3 : list) {
                    if (!((Matcher)(object3 = ((Pattern)object).matcher(((String)object3).substring(string4.length() + 1)))).matches()) continue;
                    object3 = ((Matcher)object3).group(1);
                    arrayList.add(object3);
                }
                Message.debug("\t\t" + arrayList.size() + " matched " + string);
                ArrayList<Object> arrayList2 = arrayList;
                return arrayList2.toArray(new String[arrayList2.size()]);
            }
            return null;
        }
        catch (IOException iOException) {
            Message.verbose("problem while listing resources in " + string4 + " with " + repository + ":");
            Message.verbose("  " + iOException.getClass().getName() + " " + iOException.getMessage());
            return null;
        }
        catch (Exception exception) {
            Message.warn("problem while listing resources in " + string4 + " with " + repository + ":");
            Message.warn("  " + exception.getClass().getName() + " " + exception.getMessage());
            return null;
        }
    }

    public static String[] listAll(Repository repository, String string) {
        try {
            String string2 = repository.getFileSeparator();
            Message.debug("\tusing " + repository + " to list all in " + string);
            Object object = repository.list(string);
            if (object != null) {
                Message.debug("\t\tfound " + object.size() + " resources");
                ArrayList<String> arrayList = new ArrayList<String>(object.size());
                object = object.iterator();
                while (object.hasNext()) {
                    String string3 = (String)object.next();
                    if (string3.endsWith(string2)) {
                        string3 = string3.substring(0, string3.length() - 1);
                    }
                    int n = string3.lastIndexOf(string2);
                    arrayList.add(string3.substring(n + 1));
                }
                ArrayList<String> arrayList2 = arrayList;
                return arrayList2.toArray(new String[arrayList2.size()]);
            }
            Message.debug("\t\tno resources found");
            return null;
        }
        catch (IOException iOException) {
            Message.verbose("problem while listing resources in " + string + " with " + repository + ":");
            Message.verbose("  " + iOException.getClass().getName() + " " + iOException.getMessage());
            return null;
        }
        catch (Exception exception) {
            Message.warn("problem while listing resources in " + string + " with " + repository + ":");
            Message.warn("  " + exception.getClass().getName() + " " + exception.getMessage());
            return null;
        }
    }

    public static ResolvedResource[] findAll(Repository repository, ModuleRevisionId object, String stringArray, Artifact arrayList) {
        object = IvyPatternHelper.substitute((String)stringArray, ModuleRevisionId.newInstance((ModuleRevisionId)object, IvyPatternHelper.getTokenString("revision")), (Artifact)((Object)arrayList));
        Message.debug("\tlisting all in " + (String)object);
        stringArray = ResolverHelper.listTokenValues(repository, (String)object, "revision");
        if (stringArray != null) {
            Message.debug("\tfound revs: " + Arrays.asList(stringArray));
            arrayList = new ArrayList<ResolvedResource>(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                String string = IvyPatternHelper.substituteToken((String)object, "revision", stringArray[i]);
                try {
                    Resource resource = repository.getResource(string);
                    if (resource == null) continue;
                    arrayList.add(new ResolvedResource(resource, stringArray[i]));
                    continue;
                }
                catch (IOException iOException) {
                    Message.warn("impossible to get resource from name listed by repository: " + string + ": " + iOException.getMessage());
                }
            }
            if (stringArray.length != arrayList.size()) {
                Message.debug("\tfound resolved res: " + arrayList);
            }
            ArrayList<ResolvedResource> arrayList2 = arrayList;
            return arrayList2.toArray(new ResolvedResource[arrayList2.size()]);
        }
        if (((String)object).indexOf("[revision]") == -1) {
            try {
                arrayList = repository.getResource((String)object);
                if (arrayList.exists()) {
                    Message.debug("\tonly one resource found without real listing: using and defining it as working@" + repository.getName() + " revision: " + arrayList.getName());
                    return new ResolvedResource[]{new ResolvedResource((Resource)((Object)arrayList), "working@" + repository.getName())};
                }
            }
            catch (IOException iOException) {
                Message.debug("\timpossible to get resource from name listed by repository: " + (String)object + ": " + iOException.getMessage());
            }
            Message.debug("\tno revision found");
        }
        return null;
    }
}

