import { ClsOptions, ApiResponse, CreateTopicData, UpdateTopicData, UpdateIndexData, SearchLogData, RequestOptions } from './typings';
export { tencentSign } from './utils';
export declare class Cls {
    options: ClsOptions;
    constructor(options: ClsOptions);
    /**
     * get logsets list
     */
    getLogsetList(): Promise<ApiResponse>;
    /**
     * get logset detail
     * @param logset_id string
     */
    getLogset(data: {
        logset_id: string;
    }): Promise<ApiResponse>;
    /**
     * create logset
     * @param data
     */
    createLogset(data: {
        logset_name: string;
        period: number;
    }): Promise<ApiResponse>;
    /**
     * update logset
     * @param data
     */
    updateLogset(data: {
        logset_id: string;
        logset_name: string;
        period: number;
    }): Promise<ApiResponse>;
    /**
     * dalete logset
     * @param data
     */
    deleteLogset(data: {
        logset_id: string;
    }): Promise<ApiResponse>;
    /**
     * create topic
     * @param data
     */
    createTopic(data: CreateTopicData): Promise<ApiResponse>;
    /**
     * get topic
     * @param data
     */
    getTopic(data: {
        topic_id: string;
    }): Promise<ApiResponse>;
    /**
     * get topic
     * @param data
     */
    getTopicList(data: {
        logset_id: string;
    }): Promise<ApiResponse>;
    /**
     * update topic
     * @param data
     */
    updateTopic(data: UpdateTopicData): Promise<ApiResponse>;
    /**
     * delete topic
     * @param data
     */
    deleteTopic(data: {
        topic_id: string;
    }): Promise<ApiResponse>;
    getIndex(data: {
        topic_id: string;
    }): Promise<ApiResponse>;
    /**
     * update index
     * @param data
     */
    updateIndex(data: UpdateIndexData): Promise<ApiResponse>;
    searchLog(data: SearchLogData): Promise<ApiResponse>;
    request({ method, path, query, data, }: RequestOptions): Promise<ApiResponse>;
}
//# sourceMappingURL=index.d.ts.map