/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.mapviewer;

import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public class TileCache {
    private static final Logger LOG = Logger.getLogger(TileCache.class.getName());
    private final Object mutex = new Object();
    private File diskCacheDir = null;
    private final Map<String, UnCompressed> uncompressedCache = new HashMap<String, UnCompressed>();
    private final LinkedList<String> uncompressedCacheAccessQueue = new LinkedList();
    private int uncompressedCacheSize = 0;
    private final Map<String, Compressed> compressedCache = new HashMap<String, Compressed>();
    private final LinkedList<String> compressedCacheAccessQueue = new LinkedList();
    private int compressedCacheSize = 0;
    private final Map<String, Long> imageDate = new HashMap<String, Long>();
    private int maxSizeCompressedCache = 25000000;
    private int maxSizeUncompressedCache = 50000000;
    private final int MINCACHESIZE = 10000000;

    public void setDiskCacheDir(File cacheDir) {
        this.diskCacheDir = cacheDir;
    }

    private File getCacheFile(String key) {
        if (this.diskCacheDir != null) {
            return new File(this.diskCacheDir, key);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String key, byte[] bimg, BufferedImage img) {
        Object object = this.mutex;
        synchronized (object) {
            this.addToCompressedCache(key, bimg);
            this.addToUncompressedCache(key, img);
            this.imageDate.put(key, System.currentTimeMillis());
        }
        this.addToDiskCache(key, bimg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage get(String key) {
        block18: {
            try {
                BufferedImage img;
                Object img2;
                byte[] b = null;
                Object object = this.mutex;
                synchronized (object) {
                    if (this.uncompressedCache.containsKey(key)) {
                        this.uncompressedCacheAccessQueue.remove(key);
                        this.uncompressedCacheAccessQueue.addLast(key);
                        img2 = this.uncompressedCache.get(key);
                        if (img2 != null) {
                            BufferedImage i = ((UnCompressed)img2).getImage();
                            if (i != null) {
                                return i;
                            }
                            this.checkEntries();
                        }
                    }
                    if (this.compressedCache.containsKey(key)) {
                        this.compressedCacheAccessQueue.remove(key);
                        this.compressedCacheAccessQueue.addLast(key);
                        b = this.compressedCache.get(key).getBytes();
                        if (b == null) {
                            this.checkEntries();
                        }
                    }
                }
                if (b != null && (img = ImageIO.read(new ByteArrayInputStream(b))) != null) {
                    img2 = this.mutex;
                    synchronized (img2) {
                        this.addToUncompressedCache(key, img);
                    }
                    return img;
                }
                File cacheFile = this.getCacheFile(key);
                if (cacheFile == null) break block18;
                if (!cacheFile.exists()) {
                    return null;
                }
                FileInputStream fis = new FileInputStream(cacheFile);
                byte[] bimg = new byte[(int)cacheFile.length()];
                fis.read(bimg);
                fis.close();
                fis = null;
                BufferedImage img3 = ImageIO.read(new ByteArrayInputStream(bimg));
                if (img3 == null) break block18;
                Object object2 = this.mutex;
                synchronized (object2) {
                    this.addToCompressedCache(key, bimg);
                    this.addToUncompressedCache(key, img3);
                }
                this.imageDate.put(key, cacheFile.lastModified());
                return img3;
            }
            catch (Exception e) {
                LOG.log(Level.INFO, "Couldn't load cached image: " + key, e);
            }
        }
        LOG.log(Level.INFO, "Couldn't find cached image: " + key);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getImageDate(String key) {
        Object object = this.mutex;
        synchronized (object) {
            return this.imageDate.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToUncompressedCache(String key, BufferedImage img) {
        if (img == null) {
            return;
        }
        Object object = this.mutex;
        synchronized (object) {
            while (this.uncompressedCacheSize > this.maxSizeUncompressedCache) {
                String oldKey = this.uncompressedCacheAccessQueue.removeFirst();
                UnCompressed oldimg = this.uncompressedCache.remove(oldKey);
                if (oldimg == null) {
                    LOG.severe("TileCache.addToImageCache: couldn't find oldimg for key: " + oldKey);
                    continue;
                }
                this.uncompressedCacheSize -= oldimg.size;
            }
            UnCompressed oldimgr = this.uncompressedCache.get(key);
            if (oldimgr != null) {
                this.uncompressedCacheSize -= oldimgr.size;
                oldimgr = null;
            }
            UnCompressed newimgr = new UnCompressed(img);
            this.uncompressedCache.put(key, newimgr);
            this.uncompressedCacheSize += newimgr.size;
            this.uncompressedCacheAccessQueue.remove(key);
            this.uncompressedCacheAccessQueue.addLast(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToCompressedCache(String key, byte[] bimg) {
        if (bimg == null) {
            return;
        }
        Object object = this.mutex;
        synchronized (object) {
            while (this.compressedCacheSize > this.maxSizeCompressedCache) {
                String oldKey = this.compressedCacheAccessQueue.removeFirst();
                Compressed oldbimg = this.compressedCache.remove(oldKey);
                this.compressedCacheSize -= oldbimg.size;
            }
            Compressed oldbimg = this.compressedCache.get(key);
            if (oldbimg != null && oldbimg.getBytes() != null) {
                this.compressedCacheSize -= oldbimg.size;
                oldbimg = null;
            }
            this.compressedCache.put(key, new Compressed(bimg));
            this.compressedCacheSize += bimg.length;
            this.compressedCacheAccessQueue.remove(key);
            this.compressedCacheAccessQueue.addLast(key);
        }
    }

    private void addToDiskCache(String key, byte[] bimg) {
        File cacheFile = this.getCacheFile(key);
        if (cacheFile != null) {
            try {
                File dir = new File(cacheFile.getParent());
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(cacheFile));
                bos.write(bimg);
                bos.flush();
                bos.close();
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "TileCache.put: Couldn't write image to file: " + cacheFile.getAbsolutePath(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adjustCacheSize() {
        Object object = this.mutex;
        synchronized (object) {
            int total = this.compressedCacheSize + this.uncompressedCacheSize;
            if (total < 10000000) {
                total = 10000000;
            }
            this.maxSizeCompressedCache = total / 3;
            this.maxSizeUncompressedCache = total - this.maxSizeCompressedCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkEntries() {
        try {
            Object object = this.mutex;
            synchronized (object) {
                for (String key : this.compressedCacheAccessQueue) {
                    Compressed oldbimg = this.compressedCache.get(key);
                    if (oldbimg.getBytes() != null) continue;
                    this.compressedCacheAccessQueue.remove(key);
                    this.compressedCache.remove(key);
                    this.compressedCacheSize -= oldbimg.size;
                    this.adjustCacheSize();
                }
                for (String key : this.uncompressedCacheAccessQueue) {
                    UnCompressed oldimg = this.uncompressedCache.get(key);
                    if (oldimg.getImage() != null) continue;
                    this.uncompressedCacheAccessQueue.remove(key);
                    this.uncompressedCache.remove(key);
                    this.uncompressedCacheSize -= oldimg.size;
                    this.adjustCacheSize();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        LOG.setLevel(Level.SEVERE);
    }

    private static class UnCompressed {
        int size;
        SoftReference<BufferedImage> b;

        public UnCompressed(BufferedImage by) {
            this.size = by.getWidth() * by.getHeight() * 4;
            this.b = new SoftReference<BufferedImage>(by);
        }

        public BufferedImage getImage() {
            return this.b.get();
        }
    }

    private static class Compressed {
        int size;
        SoftReference<byte[]> b;

        public Compressed(byte[] by) {
            this.size = by.length;
            this.b = new SoftReference<byte[]>(by);
        }

        public byte[] getBytes() {
            return this.b.get();
        }
    }
}

