/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.context;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.NumberFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.gephi.desktop.context.ContextRefreshThread;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphModel;
import org.openide.util.NbBundle;

public class ContextPanel
extends JPanel {
    private GraphModel model;
    private NumberFormat formatter;
    private ContextRefreshThread consumerThread;
    private JToolBar commandToolbar;
    private JLabel edgeLabel;
    private JLabel graphTypeLabel;
    private JLabel labelEdges;
    private JLabel labelNodes;
    private JLabel nodeLabel;

    public ContextPanel() {
        this.initComponents();
        this.initDesign();
        this.refreshModel(null);
    }

    private void initDesign() {
        this.labelNodes.setFont(this.labelNodes.getFont().deriveFont(1));
        this.labelEdges.setFont(this.labelEdges.getFont().deriveFont(1));
        this.formatter = NumberFormat.getPercentInstance();
        this.formatter.setMaximumFractionDigits(2);
    }

    public void refreshModel(GraphModel model) {
        if (this.consumerThread != null) {
            this.consumerThread.shutdown();
        }
        this.model = model;
        this.setEnable(model != null);
        if (this.model != null) {
            this.consumerThread = new ContextRefreshThread(model, new RefreshRunnable());
        }
    }

    private void setEnable(boolean enable) {
        this.labelNodes.setEnabled(enable);
        this.labelEdges.setEnabled(enable);
        this.nodeLabel.setEnabled(enable);
        this.edgeLabel.setEnabled(enable);
        if (!enable) {
            this.nodeLabel.setText("");
            this.edgeLabel.setText("");
            this.graphTypeLabel.setText("");
        }
    }

    private void initComponents() {
        this.commandToolbar = new JToolBar();
        this.labelNodes = new JLabel();
        this.nodeLabel = new JLabel();
        this.labelEdges = new JLabel();
        this.edgeLabel = new JLabel();
        this.graphTypeLabel = new JLabel();
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.commandToolbar.setFloatable(false);
        this.commandToolbar.setOrientation(1);
        this.commandToolbar.setRollover(true);
        this.commandToolbar.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.commandToolbar, gridBagConstraints);
        this.labelNodes.setText(NbBundle.getMessage(ContextPanel.class, (String)"ContextPanel.labelNodes.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 7, 0, 5);
        this.add((Component)this.labelNodes, gridBagConstraints);
        this.nodeLabel.setText(NbBundle.getMessage(ContextPanel.class, (String)"ContextPanel.nodeLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(7, 4, 0, 3);
        this.add((Component)this.nodeLabel, gridBagConstraints);
        this.labelEdges.setText(NbBundle.getMessage(ContextPanel.class, (String)"ContextPanel.labelEdges.text"));
        this.labelEdges.setToolTipText("Number of edges, without meta-edges");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 7, 0, 5);
        this.add((Component)this.labelEdges, gridBagConstraints);
        this.edgeLabel.setText(NbBundle.getMessage(ContextPanel.class, (String)"ContextPanel.edgeLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 4, 0, 3);
        this.add((Component)this.edgeLabel, gridBagConstraints);
        this.graphTypeLabel.setText(NbBundle.getMessage(ContextPanel.class, (String)"ContextPanel.graphTypeLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 7, 5, 5);
        this.add((Component)this.graphTypeLabel, gridBagConstraints);
    }

    private class RefreshRunnable
    implements Runnable {
        private RefreshRunnable() {
        }

        @Override
        public void run() {
            Graph visibleGraph = ContextPanel.this.model.getGraphVisible();
            Graph fullGraph = ContextPanel.this.model.getGraph();
            final int nodesFull = fullGraph.getNodeCount();
            final int nodesVisible = visibleGraph.getNodeCount();
            final int edgesFull = fullGraph.getEdgeCount();
            final int edgesVisible = visibleGraph.getEdgeCount();
            final GraphType graphType = ContextPanel.this.model.isDirected() ? GraphType.DIRECTED : (ContextPanel.this.model.isUndirected() ? GraphType.UNDIRECTED : GraphType.MIXED);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    String visible = NbBundle.getMessage(ContextPanel.class, (String)"ContextPanel.visible");
                    String nodeText = String.valueOf(nodesVisible);
                    String edgeText = String.valueOf(edgesVisible);
                    if (nodesFull != nodesVisible || edgesFull != edgesVisible) {
                        nodeText = nodeText + (nodesFull > 0 ? " (" + ContextPanel.this.formatter.format((double)nodesVisible / (double)nodesFull) + " " + visible + ")" : "");
                        edgeText = edgeText + (edgesFull > 0 ? " (" + ContextPanel.this.formatter.format((double)edgesVisible / (double)edgesFull) + " " + visible + ")" : "");
                    }
                    ContextPanel.this.nodeLabel.setText(nodeText);
                    ContextPanel.this.edgeLabel.setText(edgeText);
                    ContextPanel.this.graphTypeLabel.setText(graphType.type);
                }
            });
        }
    }

    private static enum GraphType {
        DIRECTED(NbBundle.getMessage(ContextPanel.class, (String)"ContextPanel.graphType.directed")),
        UNDIRECTED(NbBundle.getMessage(ContextPanel.class, (String)"ContextPanel.graphType.undirected")),
        MIXED(NbBundle.getMessage(ContextPanel.class, (String)"ContextPanel.graphType.mixed"));

        protected final String type;

        private GraphType(String type) {
            this.type = type;
        }
    }
}

