/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.updater;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XMLUtil {
    static final Logger LOG = Logger.getLogger(XMLUtil.class.getPackage().getName());

    public static Document parse(InputSource input, boolean validate, boolean namespaceAware, ErrorHandler errorHandler, EntityResolver entityResolver) throws IOException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(validate);
        factory.setNamespaceAware(namespaceAware);
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new SAXException(ex);
        }
        if (errorHandler != null) {
            builder.setErrorHandler(errorHandler);
        }
        if (entityResolver != null) {
            builder.setEntityResolver(entityResolver);
        }
        assert (input != null) : "InputSource cannot be null";
        try {
            return builder.parse(input);
        }
        catch (SAXException ex) {
            StringBuilder msg = new StringBuilder();
            msg.append("Cannot parse");
            msg.append("Thread.cCL: ").append(Thread.currentThread().getContextClassLoader());
            throw new SAXException(msg.toString(), ex);
        }
    }

    public static Document createDocument(String rootQName) throws DOMException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            return factory.newDocumentBuilder().getDOMImplementation().createDocument(null, rootQName, null);
        }
        catch (ParserConfigurationException ex) {
            throw (DOMException)new DOMException(9, "Cannot create parser").initCause(ex);
        }
    }

    public static void write(Document doc, OutputStream out) throws IOException {
        ClassLoader orig = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return new ClassLoader(ClassLoader.getSystemClassLoader().getParent()){

                    @Override
                    public InputStream getResourceAsStream(String name) {
                        if (name.startsWith("META-INF/services/")) {
                            return new ByteArrayInputStream(new byte[0]);
                        }
                        return super.getResourceAsStream(name);
                    }
                };
            }
        }));
        Transformer t = null;
        try {
            t = TransformerFactory.newInstance().newTransformer();
            LOG.info("Use XML Transformer: " + t);
            DocumentType dt = doc.getDoctype();
            if (dt != null) {
                String pub = dt.getPublicId();
                if (pub != null) {
                    t.setOutputProperty("doctype-public", pub);
                }
                t.setOutputProperty("doctype-system", dt.getSystemId());
            }
            t.setOutputProperty("encoding", "UTF-8");
            t.setOutputProperty("indent", "yes");
            t.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(out);
            t.transform(source, result);
        }
        catch (Exception e) {
            throw new IOException("XML Transformer: " + t, e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new IOException("XML Transformer: " + t, e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(orig);
        }
    }

    public static EntityResolver createAUResolver() {
        return new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicID, String systemID) throws IOException, SAXException {
                if ("-//NetBeans//DTD Autoupdate Catalog 1.0//EN".equals(publicID)) {
                    return new InputSource(XMLUtil.class.getResource("resources/autoupdate-catalog-1_0.dtd").toString());
                }
                if ("-//NetBeans//DTD Autoupdate Module Info 1.0//EN".equals(publicID)) {
                    return new InputSource(XMLUtil.class.getResource("resources/autoupdate-info-1_0.dtd").toString());
                }
                if ("-//NetBeans//DTD Autoupdate Catalog 2.0//EN".equals(publicID)) {
                    return new InputSource(XMLUtil.class.getResource("resources/autoupdate-catalog-2_0.dtd").toString());
                }
                if ("-//NetBeans//DTD Autoupdate Module Info 2.0//EN".equals(publicID)) {
                    return new InputSource(XMLUtil.class.getResource("resources/autoupdate-info-2_0.dtd").toString());
                }
                if ("-//NetBeans//DTD Autoupdate Catalog 2.2//EN".equals(publicID)) {
                    return new InputSource(XMLUtil.class.getResource("resources/autoupdate-catalog-2_2.dtd").toString());
                }
                if ("-//NetBeans//DTD Autoupdate Module Info 2.2//EN".equals(publicID)) {
                    return new InputSource(XMLUtil.class.getResource("resources/autoupdate-info-2_2.dtd").toString());
                }
                if ("-//NetBeans//DTD Autoupdate Catalog 2.3//EN".equals(publicID)) {
                    return new InputSource(XMLUtil.class.getResource("resources/autoupdate-catalog-2_3.dtd").toString());
                }
                if ("-//NetBeans//DTD Autoupdate Module Info 2.3//EN".equals(publicID)) {
                    return new InputSource(XMLUtil.class.getResource("resources/autoupdate-info-2_3.dtd").toString());
                }
                if ("-//NetBeans//DTD Autoupdate Catalog 2.4//EN".equals(publicID)) {
                    return new InputSource(XMLUtil.class.getResource("resources/autoupdate-catalog-2_4.dtd").toString());
                }
                if ("-//NetBeans//DTD Autoupdate Module Info 2.4//EN".equals(publicID)) {
                    return new InputSource(XMLUtil.class.getResource("resources/autoupdate-info-2_4.dtd").toString());
                }
                if ("-//NetBeans//DTD Autoupdate Catalog 2.5//EN".equals(publicID)) {
                    return new InputSource(XMLUtil.class.getResource("resources/autoupdate-catalog-2_5.dtd").toString());
                }
                if ("-//NetBeans//DTD Autoupdate Module Info 2.5//EN".equals(publicID)) {
                    return new InputSource(XMLUtil.class.getResource("resources/autoupdate-info-2_5.dtd").toString());
                }
                if ("-//NetBeans//DTD Autoupdate Catalog 2.6//EN".equals(publicID)) {
                    return new InputSource(XMLUtil.class.getResource("resources/autoupdate-catalog-2_6.dtd").toString());
                }
                if ("-//NetBeans//DTD Autoupdate Catalog 2.7//EN".equals(publicID)) {
                    return new InputSource(XMLUtil.class.getResource("resources/autoupdate-catalog-2_7.dtd").toString());
                }
                if ("-//NetBeans//DTD Autoupdate Module Info 2.7//EN".equals(publicID)) {
                    return new InputSource(XMLUtil.class.getResource("resources/autoupdate-info-2_7.dtd").toString());
                }
                if (systemID.endsWith(".dtd")) {
                    return new InputSource(new ByteArrayInputStream(new byte[0]));
                }
                URL u = new URL(systemID);
                URLConnection oc = u.openConnection();
                oc.setConnectTimeout(5000);
                return new InputSource(oc.getInputStream());
            }
        };
    }
}

