/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.core.snapshot.options;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Timer;
import javax.swing.filechooser.FileFilter;
import org.graalvm.visualvm.core.snapshot.RegisteredSnapshotCategories;
import org.graalvm.visualvm.core.snapshot.SnapshotCategoriesListener;
import org.graalvm.visualvm.core.snapshot.SnapshotCategory;
import org.netbeans.api.sendopts.CommandException;
import org.netbeans.spi.sendopts.Env;
import org.netbeans.spi.sendopts.Option;
import org.netbeans.spi.sendopts.OptionProcessor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public final class Openfile
extends OptionProcessor {
    private Option openfile = Option.shortDescription((Option)this.openfile, (String)"org.graalvm.visualvm.core.snapshot.options.Bundle", (String)"MSG_OPENFILE");
    private static final int TIMEOUT = 5000;

    protected Set<Option> getOptions() {
        return Collections.singleton(this.openfile);
    }

    protected void process(Env env, Map<Option, String[]> optionValues) throws CommandException {
        RegisteredSnapshotCategories cats;
        List<SnapshotCategory> snapshotList;
        String[] files = optionValues.get(this.openfile);
        String fileStr = files[0];
        File file = new File(fileStr);
        if (!file.isAbsolute()) {
            file = new File(env.getCurrentDirectory(), fileStr);
        }
        if (this.openSnapshot(file, snapshotList = (cats = RegisteredSnapshotCategories.sharedInstance()).getOpenSnapshotCategories())) {
            return;
        }
        Listener l = new Listener(file);
        cats.addCategoriesListener(l);
    }

    private boolean openSnapshot(File file, List<SnapshotCategory> snapshots) {
        if (file.isFile()) {
            for (SnapshotCategory s : snapshots) {
                FileFilter filter = s.getFileFilter();
                if (!filter.accept(file)) continue;
                s.openSnapshot(file);
                return true;
            }
        }
        return false;
    }

    private class Listener
    implements SnapshotCategoriesListener,
    ActionListener {
        private final File file;
        private volatile boolean removed;
        private final Timer timer;

        private Listener(File f) {
            this.file = f;
            this.timer = new Timer(5000, this);
            this.timer.start();
        }

        @Override
        public synchronized void actionPerformed(ActionEvent e) {
            if (!this.removed) {
                RegisteredSnapshotCategories.sharedInstance().removeCategoriesListener(this);
                this.removed = true;
                String msg = NbBundle.getMessage(Openfile.class, (String)"MSG_NO_CATEGORY_FILE", (Object[])new Object[]{this.file.getAbsolutePath()});
                NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)msg, 2);
                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)desc);
            }
        }

        @Override
        public void categoryRegistered(SnapshotCategory category) {
            if (Openfile.this.openSnapshot(this.file, Collections.singletonList(category)) && !this.removed) {
                RegisteredSnapshotCategories.sharedInstance().removeCategoriesListener(this);
                this.removed = true;
                this.timer.stop();
            }
        }

        @Override
        public void categoryUnregistered(SnapshotCategory category) {
        }
    }
}

