/// <reference types="node" />
import { BinaryLike } from 'crypto';
export interface AnyObject {
    [prop: string]: any;
}
export interface Payload {
    Region?: string;
    SecretId?: string;
    Timestamp?: number | string;
    Nonce?: number;
    [propName: string]: any;
}
export interface HostParams {
    ServiceType: string;
    Region: string;
    host: string | undefined;
    baseHost: string | undefined;
    path?: string;
    protocol?: string;
}
export interface TencentSignResult {
    url: string;
    payload: Payload;
    Host: string;
    Authorization: string;
    Timestamp: number | string;
}
export declare function logger(topic: string, content: string): void;
export declare function getUnixTime(date: Date): number;
export declare function getDate(date: Date): string;
/**
 * is array
 * @param obj object
 */
export declare function isArray(obj: any): boolean;
/**
 * is object
 * @param obj object
 */
export declare function isObject(obj: any): boolean;
/**
 * iterate object or array
 * @param obj object or array
 * @param iterator iterator function
 */
export declare function _forEach(obj: object | any[], iterator: (value: any, index: number | string, array: any) => void): void;
/**
 * flatter request parameter
 * @param obj target object or array
 */
export declare function flatten(obj: {
    [propName: string]: any;
}): {
    [propName: string]: any;
};
interface ParsedUrlQueryInput {
    [key: string]: any;
}
export declare function querystring(obj?: ParsedUrlQueryInput): string;
export declare function sha1(str: string, key: BinaryLike): string;
export declare function hash(str: string, algorithm: string): string;
interface GenerateSignatureOptions {
    secretId: string;
    secretKey: string;
    method: string;
    path: string;
    parameters: AnyObject;
    headers: AnyObject;
    expire: number;
}
export declare function tencentSign({ secretId, secretKey, method, path, parameters, headers, expire, }: GenerateSignatureOptions): string;
export {};
//# sourceMappingURL=utils.d.ts.map