export interface AnyObject {
    [prop: string]: any;
}
export declare type GetFaasOptions = {
    showCode?: boolean;
    showTriggers?: boolean;
} & FaasBaseConfig;
export interface FaasBaseConfig {
    name: string;
    namespace?: string;
    qualifier?: string;
}
export interface Credentials {
    secretId: string;
    secretKey: string;
    token?: string;
}
export declare type FaasOptions = {
    region?: string;
    debug?: boolean;
} & Credentials;
export declare type MonitorOptions = {
    region?: string;
    debug?: boolean;
} & Credentials;
export interface Tag {
    Key: string;
    Value: string;
}
export interface FunctionInfo {
    FunctionName: string;
    Namespace: string;
    Timeout: number;
    MemorySize: number;
    Handler: string;
    Runtime: string;
    Status: string;
    LastVersion: string;
    StatusReasons: {
        ErrorMessage: string;
    }[];
    Traffic?: number;
    ConfigTrafficVersion?: string;
    Tags: Tag[];
    ClsLogsetId: string;
    ClsTopicId: string;
}
export interface StatusSqlMap {
    success: string;
    fail: string;
    retry: string;
    interrupt: string;
    timeout: string;
    exceed: string;
    codeError: string;
}
export interface GetLogOptions {
    name: string;
    namespace?: string;
    qualifier?: string;
    startTime?: number | string;
    endTime?: number | string;
    reqId?: string;
    status?: keyof StatusSqlMap | '';
    interval?: number;
    limit?: number;
}
export interface ClsConfig {
    logsetId: string;
    topicId: string;
}
export interface LogContent {
    SCF_FunctionName: string;
    SCF_Namespace: string;
    SCF_StartTime: string;
    SCF_RequestId: string;
    SCF_Duration: string;
    SCF_Alias: string;
    SCF_Qualifier: string;
    SCF_LogTime: string;
    SCF_RetryNum: string;
    SCF_MemUsage: string;
    SCF_Level: string;
    SCF_Message: string;
    SCF_Type: string;
    SCF_StatusCode: string;
}
export declare type GetLogDetailOptions = {
    logsetId: string;
    topicId: string;
    reqId: string;
    startTime?: string;
    endTime?: string;
};
export interface SearchLogItem {
    requestId: string;
    retryNum: number;
    startTime: string;
    memoryUsage: string;
    duration: string;
    message: string;
}
export interface SearchLogDetailItem {
    content: string;
    filename: string;
    pkg_id: string;
    pkg_logid: string;
    source: string;
    time: number;
    timestamp: string;
    topic_id: string;
    topic_name: string;
}
export declare enum LogType {
    none = "None",
    tail = "Tail"
}
export declare enum InvokeType {
    request = "RequestResponse",
    event = "Event"
}
export interface InvokeOptions {
    name: string;
    namespace: string;
    qualifier: string;
    event?: Record<string, any>;
    logType?: LogType;
    invokeType?: InvokeType;
}
export interface InvokeResult {
    billDuration: number;
    duration: number;
    errMsg: string;
    memUsage: number;
    functionRequestId: string;
    invokeResult: number;
    log: string;
    retMsg: string;
}
export interface GetMonitorDataOptions {
    metric: string;
    name: string;
    namespace?: string;
    alias?: string;
    interval?: number;
    period?: number;
    startTime?: string;
    endTime?: string;
    isRaw?: boolean;
}
export interface DataPoint {
    Timestamps: number[];
    Values: any[];
    Dimensions: any[];
}
export interface MonitorData {
    StartTime: string;
    EndTime: string;
    Period: number;
    MetricName: string;
    DataPoints: DataPoint[];
    RequestId: string;
}
export interface FormatedMonitorData {
    time: string;
    value: any;
    timestamp: number;
}
//# sourceMappingURL=index.d.ts.map