/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import javax.servlet.ServletContext;
import org.apache.catalina.Context;
import org.apache.catalina.Loader;
import org.apache.catalina.Session;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.session.StoreBase;
import org.apache.catalina.util.FileUtil;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public final class FileStore
extends StoreBase {
    private static final Log log = LogFactory.getLog(FileStore.class);
    private static final StringManager sm = StringManager.getManager(FileStore.class);
    private static final String FILE_EXT = ".session";
    private String directory = ".";
    private File directoryFile = null;
    private static final String info = "FileStore/1.0";
    private static final String storeName = "fileStore";
    private static final String threadName = "FileStore";

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String string) {
        String string2 = this.directory;
        this.directory = string;
        this.directoryFile = null;
        this.support.firePropertyChange("directory", string2, this.directory);
    }

    @Override
    public String getInfo() {
        return info;
    }

    public String getThreadName() {
        return threadName;
    }

    @Override
    public String getStoreName() {
        return storeName;
    }

    @Override
    public int getSize() throws IOException {
        File file = this.directory();
        if (file == null) {
            return 0;
        }
        String[] stringArray = file.list();
        int n = 0;
        if (stringArray != null) {
            for (String string : stringArray) {
                if (!string.endsWith(FILE_EXT)) continue;
                ++n;
            }
        }
        return n;
    }

    @Override
    public void clear() throws IOException {
        String[] stringArray;
        for (String string : stringArray = this.keys()) {
            this.remove(string);
        }
    }

    @Override
    public String[] keys() throws IOException {
        File file = this.directory();
        if (file == null) {
            return new String[0];
        }
        String[] stringArray = file.list();
        if (stringArray == null || stringArray.length < 1) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = FILE_EXT.length();
        for (String string : stringArray) {
            if (!string.endsWith(FILE_EXT)) continue;
            arrayList.add(string.substring(0, string.length() - n));
        }
        return arrayList.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Session load(String string) throws ClassNotFoundException, IOException {
        File file = this.file(string);
        if (file == null || !file.exists()) {
            return null;
        }
        Context context = (Context)this.getManager().getContainer();
        Log log = context.getLogger();
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString(this.getStoreName() + ".loading", new Object[]{string, file.getAbsolutePath()}));
        }
        FileInputStream fileInputStream = null;
        ObjectInputStream objectInputStream = null;
        Loader loader = null;
        ClassLoader classLoader = null;
        ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
        try {
            fileInputStream = new FileInputStream(file.getAbsolutePath());
            loader = context.getLoader();
            if (loader != null) {
                classLoader = loader.getClassLoader();
            }
            if (classLoader != null) {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
            objectInputStream = this.getObjectInputStream(fileInputStream);
            StandardSession standardSession = (StandardSession)this.manager.createEmptySession();
            standardSession.readObjectData(objectInputStream);
            standardSession.setManager(this.manager);
            StandardSession standardSession2 = standardSession;
            return standardSession2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No persisted data file found");
            }
            Session session = null;
            return session;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (objectInputStream != null) {
                try {
                    objectInputStream.close();
                }
                catch (IOException iOException) {}
            }
            Thread.currentThread().setContextClassLoader(classLoader2);
        }
    }

    @Override
    public void remove(String string) throws IOException {
        File file = this.file(string);
        if (file == null) {
            return;
        }
        if (this.manager.getContainer().getLogger().isDebugEnabled()) {
            this.manager.getContainer().getLogger().debug((Object)sm.getString(this.getStoreName() + ".removing", new Object[]{string, file.getAbsolutePath()}));
        }
        if (file.exists() && !file.delete()) {
            throw new IOException(sm.getString("fileStore.deleteSessionFailed", new Object[]{file}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(Session session) throws IOException {
        File file = this.file(session.getIdInternal());
        if (file == null) {
            return;
        }
        if (this.manager.getContainer().getLogger().isDebugEnabled()) {
            this.manager.getContainer().getLogger().debug((Object)sm.getString(this.getStoreName() + ".saving", new Object[]{session.getIdInternal(), file.getAbsolutePath()}));
        }
        FileOutputStream fileOutputStream = null;
        ObjectOutputStream objectOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file.getAbsolutePath());
            objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(fileOutputStream));
        }
        catch (IOException iOException) {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
            }
            throw iOException;
        }
        try {
            ((StandardSession)session).writeObjectData(objectOutputStream);
        }
        finally {
            objectOutputStream.close();
        }
    }

    private File directory() throws IOException {
        if (this.directory == null) {
            return null;
        }
        if (this.directoryFile != null) {
            return this.directoryFile;
        }
        File file = new File(this.directory);
        if (!file.isAbsolute()) {
            Context context = (Context)this.manager.getContainer();
            ServletContext servletContext = context.getServletContext();
            File file2 = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
            file = new File(file2, this.directory);
        }
        if (!file.exists() || !file.isDirectory()) {
            if (!file.delete() && file.exists()) {
                throw new IOException(sm.getString("fileStore.deleteFailed", new Object[]{file}));
            }
            if (!file.mkdirs() && !file.isDirectory()) {
                throw new IOException(sm.getString("fileStore.createFailed", new Object[]{file}));
            }
        }
        this.directoryFile = file;
        return file;
    }

    private File file(String string) throws IOException {
        File file = this.directory();
        if (file == null) {
            return null;
        }
        FileUtil fileUtil = new FileUtil(file);
        String string2 = string + FILE_EXT;
        File file2 = new File(file, string2);
        if (!fileUtil.isParentOf(file2)) {
            log.warn((Object)sm.getString("fileStore.invalid", new Object[]{file2.getPath(), string}));
            return null;
        }
        return file2;
    }
}

