/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.api.java;

import java.util.Comparator;
import java.util.Set;
import java.util.regex.Pattern;
import org.graalvm.visualvm.lib.profiler.api.java.SourceMethodInfo;
import org.openide.filesystems.FileObject;

public abstract class SourceClassInfo {
    public static final Comparator<SourceClassInfo> COMPARATOR = new Comparator<SourceClassInfo>(){

        @Override
        public int compare(SourceClassInfo o1, SourceClassInfo o2) {
            return o1.getVMName().compareTo(o2.getVMName());
        }
    };
    private static final Pattern anonymousInnerClassPattern = Pattern.compile(".*?\\$[0-9]*$");
    private String simpleName;
    private String qualName;
    private String vmName;

    public SourceClassInfo(String name, String fqn, String vmName) {
        this.simpleName = name;
        this.qualName = fqn;
        this.vmName = vmName;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SourceClassInfo other = (SourceClassInfo)obj;
        return !(this.vmName == null ? other.vmName != null : !this.vmName.equals(other.vmName));
    }

    public int hashCode() {
        int hash = 5;
        hash = 53 * hash + (this.vmName != null ? this.vmName.hashCode() : 0);
        return hash;
    }

    public final String getSimpleName() {
        return this.simpleName;
    }

    public final String getQualifiedName() {
        return this.qualName;
    }

    public final String getVMName() {
        return this.vmName;
    }

    public boolean isAnonymous() {
        return this.isAnonymous(this.qualName);
    }

    public abstract FileObject getFile();

    public abstract Set<SourceMethodInfo> getMethods(boolean var1);

    public abstract Set<SourceClassInfo> getSubclasses();

    public abstract Set<SourceClassInfo> getInnerClases();

    public abstract Set<SourceMethodInfo> getConstructors();

    public abstract SourceClassInfo getSuperType();

    public abstract Set<SourceClassInfo> getInterfaces();

    protected final boolean isAnonymous(String className) {
        return anonymousInnerClassPattern.matcher(className).matches();
    }
}

