/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.multitabs.impl;

import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.basic.BasicTableUI;
import org.netbeans.core.multitabs.impl.TabTable;

final class TabTableUI
extends BasicTableUI {
    static final boolean IS_AQUA = "Aqua".equals(UIManager.getLookAndFeel().getID());

    TabTableUI() {
    }

    static Border createTabBorder(JTable jTable, int n) {
        if (IS_AQUA) {
            return BorderFactory.createMatteBorder(1, 0, 0, 0, jTable.getGridColor());
        }
        if (n != 1 && !UIManager.getBoolean("nb.multitabs.noTabBorder")) {
            return BorderFactory.createMatteBorder(1, 0, 0, 0, jTable.getGridColor());
        }
        return BorderFactory.createEmptyBorder();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        String string = UIManager.getLookAndFeel().getID();
        if ("Windows".equals(string)) {
            Color color = UIManager.getColor("TabbedPane.background");
            Color color2 = UIManager.getColor("TabbedPane.highlight");
            if (null != color && null != color2) {
                this.table.setBackground(new Color(Math.max(color.getRed() - 16, 0), Math.max(color.getGreen() - 16, 0), Math.max(color.getBlue() - 16, 0)));
                this.table.setSelectionBackground(color2);
                this.table.setSelectionForeground(this.table.getForeground());
            }
        } else if ("Metal".equals(string)) {
            Color color = UIManager.getColor("inactiveCaption");
            Color color3 = UIManager.getColor("activeCaption");
            if (null != color && null != color3) {
                this.table.setBackground(color);
                this.table.setSelectionBackground(color3);
                this.table.setSelectionForeground(this.table.getForeground());
            }
        } else if ("Nimbus".equals(string) || "GTK".equals(string)) {
            Color color = UIManager.getColor("TabbedPane.highlight");
            Color color4 = UIManager.getColor("TabbedPane.background");
            if (null != color4 && null != color) {
                this.table.setBackground(new Color(color4.getRGB()));
                this.table.setSelectionBackground(new Color(color.getRGB()));
                this.table.setSelectionForeground(new Color(this.table.getForeground().getRGB()));
                Color color5 = UIManager.getColor("InternalFrame.borderShadow");
                if (null == color5) {
                    color5 = UIManager.getColor("controlDkShadow");
                }
                if (null != color5) {
                    this.table.setGridColor(new Color(color5.getRGB()));
                }
            }
            this.table.setShowGrid(true);
        } else if ("Aqua".equals(string)) {
            this.table.setShowGrid(true);
            this.table.setBackground(new Color(178, 178, 178));
            this.table.setSelectionBackground(new Color(226, 226, 226));
            this.table.setSelectionForeground(this.table.getForeground());
            this.table.setGridColor(new Color(49, 49, 49));
            Font font = (Font)UIManager.get("windowTitleFont");
            if (font == null) {
                font = new Font("Dialog", 0, 11);
            } else if (font.isBold()) {
                font = new Font(font.getName(), 0, font.getSize());
            }
            this.table.setFont(font);
        } else {
            Color color = UIManager.getColor("nb.multitabs.background");
            Color color6 = UIManager.getColor("nb.multitabs.foreground");
            Color color7 = UIManager.getColor("nb.multitabs.selectedBackground");
            Color color8 = UIManager.getColor("nb.multitabs.selectedForeground");
            Color color9 = UIManager.getColor("nb.multitabs.gridColor");
            if (color != null) {
                this.table.setBackground(color);
            }
            if (color6 != null) {
                this.table.setForeground(color6);
            }
            if (color7 != null) {
                this.table.setSelectionBackground(color7);
            }
            if (color8 != null) {
                this.table.setSelectionForeground(color8);
            }
            if (color9 != null) {
                this.table.setGridColor(color9);
            }
        }
    }

    @Override
    protected void installKeyboardActions() {
    }

    @Override
    protected MouseInputListener createMouseInputListener() {
        final MouseInputListener mouseInputListener = super.createMouseInputListener();
        return new MouseInputListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                mouseInputListener.mouseClicked(mouseEvent);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                TabTable tabTable = (TabTable)TabTableUI.this.table;
                Point point = mouseEvent.getPoint();
                int n = TabTableUI.this.table.rowAtPoint(point);
                int n2 = TabTableUI.this.table.columnAtPoint(point);
                if (n >= 0 && n2 >= 0 && tabTable.isCloseButtonHighlighted(n, n2)) {
                    return;
                }
                mouseInputListener.mousePressed(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                mouseInputListener.mouseReleased(mouseEvent);
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                mouseInputListener.mouseEntered(mouseEvent);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                mouseInputListener.mouseExited(mouseEvent);
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                mouseInputListener.mouseDragged(mouseEvent);
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                mouseInputListener.mouseMoved(mouseEvent);
            }
        };
    }
}

