/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.threaddump;

import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.application.jvm.JvmFactory;
import org.graalvm.visualvm.core.datasource.descriptor.DataSourceDescriptorFactory;
import org.graalvm.visualvm.core.model.ModelProvider;
import org.graalvm.visualvm.core.snapshot.RegisteredSnapshotCategories;
import org.graalvm.visualvm.core.snapshot.SnapshotCategory;
import org.graalvm.visualvm.core.ui.PluggableDataSourceViewProvider;
import org.graalvm.visualvm.coredump.CoreDump;
import org.graalvm.visualvm.threaddump.ThreadDump;
import org.graalvm.visualvm.threaddump.impl.ThreadDumpCategory;
import org.graalvm.visualvm.threaddump.impl.ThreadDumpDescriptorProvider;
import org.graalvm.visualvm.threaddump.impl.ThreadDumpProvider;
import org.graalvm.visualvm.threaddump.impl.ThreadDumpViewProvider;

public final class ThreadDumpSupport {
    private static ThreadDumpSupport instance;
    private final SnapshotCategory category = new ThreadDumpCategory();
    private final ThreadDumpProvider threadDumpProvider;
    private final ThreadDumpViewProvider threadDumpViewProvider;

    public static synchronized ThreadDumpSupport getInstance() {
        if (instance == null) {
            instance = new ThreadDumpSupport();
        }
        return instance;
    }

    public SnapshotCategory getCategory() {
        return this.category;
    }

    public boolean supportsThreadDump(Application application) {
        if (application.getState() != 1) {
            return false;
        }
        return JvmFactory.getJVMFor((Application)application).isTakeThreadDumpSupported();
    }

    public void takeThreadDump(Application application, boolean openView) {
        this.threadDumpProvider.createThreadDump(application, openView);
    }

    public void takeThreadDump(CoreDump coreDump, boolean openView) {
        this.threadDumpProvider.createThreadDump(coreDump, openView);
    }

    public PluggableDataSourceViewProvider<ThreadDump> getThreadDumpView() {
        return this.threadDumpViewProvider;
    }

    private ThreadDumpSupport() {
        DataSourceDescriptorFactory.getDefault().registerProvider((ModelProvider)new ThreadDumpDescriptorProvider());
        this.threadDumpProvider = new ThreadDumpProvider();
        this.threadDumpProvider.initialize();
        this.threadDumpViewProvider = new ThreadDumpViewProvider();
        RegisteredSnapshotCategories.sharedInstance().registerCategory(this.category);
        this.threadDumpViewProvider.initialize();
    }
}

