/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.charts.xy;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

final class ColorIcon
implements Icon {
    private Color borderColor = Color.BLACK;
    private Color color = Color.BLACK;
    private int height = 5;
    private int width = 5;

    public ColorIcon() {
    }

    public ColorIcon(Color color) {
        this();
        this.setColor(color);
    }

    public ColorIcon(Color color, int width, int height) {
        this(color);
        this.setIconWidth(width);
        this.setIconHeight(height);
    }

    public ColorIcon(Color color, Color borderColor, int width, int height) {
        this(color, width, height);
        this.setBorderColor(borderColor);
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public void setIconHeight(int height) {
        this.height = height;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    public void setIconWidth(int width) {
        this.width = width;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.color != null) {
            g.setColor(this.color);
            g.fillRect(x, y, this.width, this.height);
        }
        if (this.borderColor != null) {
            g.setColor(this.borderColor);
            g.drawRect(x, y, this.width - 1, this.height - 1);
        }
    }
}

