/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.heap;

import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.graalvm.visualvm.lib.jfluid.heap.HprofByteBuffer;
import org.graalvm.visualvm.lib.jfluid.heap.HprofHeap;
import org.graalvm.visualvm.lib.jfluid.heap.LongHashMap;
import org.graalvm.visualvm.lib.jfluid.heap.TagBounds;

class StringSegment
extends TagBounds {
    private final int UTF8CharsOffset;
    private final int lengthOffset;
    private final int stringIDOffset;
    private final int timeOffset;
    private LongHashMap stringIDMap;
    private HprofHeap hprofHeap;
    private Map<Long, String> stringCache = Collections.synchronizedMap(new StringCache());

    StringSegment(HprofHeap heap, long start, long end) {
        super(1, start, end);
        int idSize = heap.dumpBuffer.getIDSize();
        this.hprofHeap = heap;
        this.timeOffset = 1;
        this.lengthOffset = this.timeOffset + 4;
        this.stringIDOffset = this.lengthOffset + 4;
        this.UTF8CharsOffset = this.stringIDOffset + idSize;
    }

    String getStringByID(long stringID) {
        Long stringIDObj = new Long(stringID);
        String string = this.stringCache.get(stringIDObj);
        if (string == null) {
            string = this.createStringByID(stringID);
            this.stringCache.put(stringIDObj, string);
        }
        return string;
    }

    private String createStringByID(long stringID) {
        return this.getString(this.getStringOffsetByID(stringID));
    }

    private String getString(long start) {
        HprofByteBuffer dumpBuffer = this.getDumpBuffer();
        if (start == -1L) {
            return "<unknown string>";
        }
        int len = dumpBuffer.getInt(start + (long)this.lengthOffset);
        byte[] chars = new byte[len - dumpBuffer.getIDSize()];
        dumpBuffer.get(start + (long)this.UTF8CharsOffset, chars);
        String s = "Error";
        try {
            s = new String(chars, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
        }
        return s;
    }

    private synchronized long getStringOffsetByID(long stringID) {
        if (this.stringIDMap == null) {
            this.stringIDMap = new LongHashMap(32768);
            long[] offset = new long[]{this.startOffset};
            while (offset[0] < this.endOffset) {
                long start = offset[0];
                long sID = this.readStringTag(offset);
                if (sID == 0L) continue;
                this.stringIDMap.put(sID, start);
            }
        }
        if (stringID == 0L) {
            return -1L;
        }
        return this.stringIDMap.get(stringID);
    }

    private HprofByteBuffer getDumpBuffer() {
        HprofByteBuffer dumpBuffer = this.hprofHeap.dumpBuffer;
        return dumpBuffer;
    }

    private long readStringTag(long[] offset) {
        long start = offset[0];
        if (this.hprofHeap.readTag(offset) != 1) {
            return 0L;
        }
        return this.getDumpBuffer().getID(start + (long)this.stringIDOffset);
    }

    private static class StringCache
    extends LinkedHashMap {
        private static final int SIZE = 1000;

        StringCache() {
            super(1000, 0.75f, true);
        }

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 1000;
        }
    }
}

