import { Message } from "./parse_message";
interface CapabilitiesSet {
    caps: Set<string>;
    saslTypes?: Set<string>;
}
/**
 * A helper class to handle capabilities sent by the IRCd.
 */
export declare class IrcCapabilities {
    private readonly onCapsList;
    private readonly onCapsConfirmed;
    static parseCapabilityString(caps: string): CapabilitiesSet;
    constructor(onCapsList: () => void, onCapsConfirmed: () => void);
    get capsReady(): boolean;
    get supportsSasl(): boolean;
    /**
     * Check if the IRCD supports a given Sasl method.
     * @param method The method of SASL (e.g. 'PLAIN', 'EXTERNAL') to check support for. Case insensitive.
     * @param allowNoMethods Not all implementations support explicitly mentioning SASL methods,
     * so optionally we can return true here.
     * @returns True if supported, false otherwise.
     * @throws If the capabilites have not returned yet.
     */
    supportsSaslMethod(method: string, allowNoMethods?: boolean): boolean;
    private serverCapabilites?;
    private userCapabilites?;
    /**
     * Handle an incoming `CAP` message.
     */
    onCap(message: Message): void;
}
export {};
