/*
 * Decompiled with CFR 0.152.
 */
package ext.plantuml.com.at.gadermaier.argon2.algorithm;

import ext.plantuml.com.at.gadermaier.argon2.algorithm.FillSegment;
import ext.plantuml.com.at.gadermaier.argon2.model.Instance;
import ext.plantuml.com.at.gadermaier.argon2.model.Position;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class FillMemory {
    public static void fillMemoryBlocks(Instance instance) {
        if (instance.getLanes() == 1) {
            FillMemory.fillMemoryBlockSingleThreaded(instance);
        } else {
            FillMemory.fillMemoryBlockMultiThreaded(instance);
        }
    }

    private static void fillMemoryBlockSingleThreaded(Instance instance) {
        for (int i = 0; i < instance.getIterations(); ++i) {
            for (int j = 0; j < 4; ++j) {
                Position position = new Position(i, 0, j, 0);
                FillSegment.fillSegment(instance, position);
            }
        }
    }

    private static void fillMemoryBlockMultiThreaded(final Instance instance) {
        ExecutorService service = Executors.newFixedThreadPool(instance.getLanes());
        ArrayList futures = new ArrayList();
        for (int i = 0; i < instance.getIterations(); ++i) {
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < instance.getLanes(); ++k) {
                    final Position position = new Position(i, k, j, 0);
                    Future<?> future = service.submit(new Runnable(){

                        @Override
                        public void run() {
                            FillSegment.fillSegment(instance, position);
                        }
                    });
                    futures.add(future);
                }
                FillMemory.joinThreads(instance, futures);
            }
        }
        service.shutdownNow();
    }

    private static void joinThreads(Instance instance, List<Future<?>> futures) {
        try {
            for (Future<?> f : futures) {
                f.get();
            }
        }
        catch (InterruptedException e) {
            instance.clear();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            instance.clear();
            throw new RuntimeException(e);
        }
    }
}

