/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.wire;

import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.InnerStrategy;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.wire.Spot;
import net.sourceforge.plantuml.wire.WArrowDirection;
import net.sourceforge.plantuml.wire.WBlock;
import net.sourceforge.plantuml.wire.WLinkHorizontal;
import net.sourceforge.plantuml.wire.WLinkType;
import net.sourceforge.plantuml.wire.WLinkVertical;

public class WireDiagram
extends UmlDiagram {
    private final WBlock root = new WBlock("", new UTranslate(), 0.0, 0.0, null);
    private final List<Spot> spots = new ArrayList<Spot>();
    private final List<WLinkHorizontal> hlinks = new ArrayList<WLinkHorizontal>();
    private final List<WLinkVertical> vlinks = new ArrayList<WLinkVertical>();

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("Wire Diagram");
    }

    public WireDiagram() {
        super(UmlDiagramType.WIRE);
    }

    @Override
    protected ImageData exportDiagramInternal(OutputStream os, int index, FileFormatOption fileFormatOption) throws IOException {
        return this.createImageBuilder(fileFormatOption).drawable(this.getTextBlock()).write(os);
    }

    private TextBlockBackcolored getTextBlock() {
        return new TextBlockBackcolored(){

            @Override
            public void drawU(UGraphic ug) {
                WireDiagram.this.drawMe(ug);
            }

            @Override
            public Rectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
                return null;
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                throw new UnsupportedOperationException();
            }

            @Override
            public MinMax getMinMax(StringBounder stringBounder) {
                throw new UnsupportedOperationException();
            }

            @Override
            public HColor getBackcolor() {
                return null;
            }
        };
    }

    private void drawMe(UGraphic ug) {
        this.root.drawMe(ug);
        for (Spot spot : this.spots) {
            spot.drawMe(ug);
        }
        for (WLinkHorizontal wLinkHorizontal : this.hlinks) {
            wLinkHorizontal.drawMe(ug);
        }
        for (WLinkVertical wLinkVertical : this.vlinks) {
            wLinkVertical.drawMe(ug);
        }
    }

    public CommandExecutionResult addComponent(String indent, String name, int width, int height, HColor color) {
        int level = this.computeIndentationLevel(indent);
        return this.root.addBlock(level, name, width, height, color);
    }

    public CommandExecutionResult newColumn(String indent) {
        int level = this.computeIndentationLevel(indent);
        return this.root.newColumn(level);
    }

    public CommandExecutionResult spot(String name, HColor color, String x, String y) {
        WBlock block = this.root.getBlock(name);
        if (block == null) {
            return CommandExecutionResult.error("No such element " + name);
        }
        Spot spot = new Spot(block, color, x, y);
        this.spots.add(spot);
        return CommandExecutionResult.ok();
    }

    public CommandExecutionResult wgoto(String indent, double x, double y) {
        int level = this.computeIndentationLevel(indent);
        return this.root.wgoto(level, x, y);
    }

    public CommandExecutionResult wmove(String indent, double x, double y) {
        int level = this.computeIndentationLevel(indent);
        return this.root.wmove(level, x, y);
    }

    public CommandExecutionResult print(String indent, String text) {
        int level = this.computeIndentationLevel(indent);
        StringBounder stringBounder = FileFormat.PNG.getDefaultStringBounder();
        return this.root.print(stringBounder, this.getSkinParam(), level, text);
    }

    private int computeIndentationLevel(String indent) {
        int level = indent.replace("    ", "\t").length();
        return level;
    }

    public CommandExecutionResult vlink(String name1, String x1, String y1, String name2, WLinkType type, WArrowDirection direction, HColor color, Display label) {
        WBlock block1 = this.root.getBlock(name1);
        if (block1 == null) {
            return CommandExecutionResult.error("No such element " + name1);
        }
        WBlock block2 = this.root.getBlock(name2);
        if (block2 == null) {
            return CommandExecutionResult.error("No such element " + name2);
        }
        UTranslate start = block1.getNextOutVertical(x1, y1, type);
        double destination = block2.getAbsolutePosition("0", "0").getDy();
        this.vlinks.add(new WLinkVertical(this.getSkinParam(), start, destination, type, direction, color, label));
        return CommandExecutionResult.ok();
    }

    public CommandExecutionResult hlink(String name1, String x1, String y1, String name2, WLinkType type, WArrowDirection direction, HColor color, Display label) {
        WBlock block1 = this.root.getBlock(name1);
        if (block1 == null) {
            return CommandExecutionResult.error("No such element " + name1);
        }
        WBlock block2 = this.root.getBlock(name2);
        if (block2 == null) {
            return CommandExecutionResult.error("No such element " + name2);
        }
        UTranslate start = block1.getNextOutHorizontal(x1, y1, type);
        double destination = block2.getAbsolutePosition("0", "0").getDx();
        this.hlinks.add(new WLinkHorizontal(this.getSkinParam(), start, destination, type, direction, color, label));
        return CommandExecutionResult.ok();
    }
}

