/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.viewcontroller;

import com.eteks.sweethome3d.model.AspectRatio;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomeEnvironment;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.Controller;
import com.eteks.sweethome3d.viewcontroller.View;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.WeakReference;

public abstract class AbstractPhotoController
implements Controller {
    private final Home home;
    private final View view3D;
    private final ContentManager contentManager;
    private final PropertyChangeSupport propertyChangeSupport;
    private AspectRatio aspectRatio;
    private int width;
    private int height;
    private int quality;
    private float view3DAspectRatio;
    private int ceilingLightColor;

    public AbstractPhotoController(Home home, UserPreferences userPreferences, View view, ContentManager contentManager) {
        this.home = home;
        this.view3D = view;
        this.contentManager = contentManager;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.view3DAspectRatio = 1.0f;
        EnvironmentChangeListener environmentChangeListener = new EnvironmentChangeListener(this);
        home.getEnvironment().addPropertyChangeListener(HomeEnvironment.Property.PHOTO_WIDTH, (PropertyChangeListener)environmentChangeListener);
        home.getEnvironment().addPropertyChangeListener(HomeEnvironment.Property.PHOTO_HEIGHT, (PropertyChangeListener)environmentChangeListener);
        home.getEnvironment().addPropertyChangeListener(HomeEnvironment.Property.PHOTO_ASPECT_RATIO, (PropertyChangeListener)environmentChangeListener);
        home.getEnvironment().addPropertyChangeListener(HomeEnvironment.Property.PHOTO_QUALITY, (PropertyChangeListener)environmentChangeListener);
        home.getEnvironment().addPropertyChangeListener(HomeEnvironment.Property.CEILING_LIGHT_COLOR, (PropertyChangeListener)environmentChangeListener);
        this.updateProperties();
    }

    public ContentManager getContentManager() {
        return this.contentManager;
    }

    public void addPropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(property.name(), propertyChangeListener);
    }

    public void removePropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(property.name(), propertyChangeListener);
    }

    protected void updateProperties() {
        HomeEnvironment homeEnvironment = this.home.getEnvironment();
        this.setAspectRatio(homeEnvironment.getPhotoAspectRatio());
        this.setWidth(homeEnvironment.getPhotoWidth(), false);
        this.setHeight(homeEnvironment.getPhotoHeight(), false);
        this.setQuality(homeEnvironment.getPhotoQuality());
        this.setCeilingLightColor(homeEnvironment.getCeillingLightColor());
    }

    public void setAspectRatio(AspectRatio aspectRatio) {
        if (this.aspectRatio != aspectRatio) {
            AspectRatio aspectRatio2 = this.aspectRatio;
            this.aspectRatio = aspectRatio;
            this.propertyChangeSupport.firePropertyChange(Property.ASPECT_RATIO.name(), (Object)aspectRatio2, (Object)aspectRatio);
            this.home.getEnvironment().setPhotoAspectRatio(this.aspectRatio);
            if (this.aspectRatio == AspectRatio.VIEW_3D_RATIO) {
                if (this.view3DAspectRatio != Float.POSITIVE_INFINITY) {
                    this.setHeight(Math.round((float)this.width / this.view3DAspectRatio), false);
                }
            } else if (this.aspectRatio.getValue() != null) {
                this.setHeight(Math.round((float)this.width / this.aspectRatio.getValue().floatValue()), false);
            }
        }
    }

    public AspectRatio getAspectRatio() {
        return this.aspectRatio;
    }

    public void setWidth(int n) {
        this.setWidth(n, true);
    }

    private void setWidth(int n, boolean bl) {
        if (this.width != n) {
            int n2 = this.width;
            this.width = n;
            this.propertyChangeSupport.firePropertyChange(Property.WIDTH.name(), n2, n);
            if (bl) {
                if (this.aspectRatio == AspectRatio.VIEW_3D_RATIO) {
                    if (this.view3DAspectRatio != Float.POSITIVE_INFINITY) {
                        this.setHeight(Math.round((float)n / this.view3DAspectRatio), false);
                    }
                } else if (this.aspectRatio.getValue() != null) {
                    this.setHeight(Math.round((float)n / this.aspectRatio.getValue().floatValue()), false);
                }
            }
            this.home.getEnvironment().setPhotoWidth(this.width);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public void setHeight(int n) {
        this.setHeight(n, true);
    }

    private void setHeight(int n, boolean bl) {
        if (this.height != n) {
            int n2 = this.height;
            this.height = n;
            this.propertyChangeSupport.firePropertyChange(Property.HEIGHT.name(), n2, n);
            if (bl) {
                if (this.aspectRatio == AspectRatio.VIEW_3D_RATIO) {
                    if (this.view3DAspectRatio != Float.POSITIVE_INFINITY) {
                        this.setWidth(Math.round((float)n * this.view3DAspectRatio), false);
                    }
                } else if (this.aspectRatio.getValue() != null) {
                    this.setWidth(Math.round((float)n * this.aspectRatio.getValue().floatValue()), false);
                }
            }
            this.home.getEnvironment().setPhotoHeight(this.height);
        }
    }

    public int getHeight() {
        return this.height;
    }

    public void setQuality(int n) {
        if (this.quality != n) {
            int n2 = this.quality;
            this.quality = Math.min(n, this.getQualityLevelCount() - 1);
            this.propertyChangeSupport.firePropertyChange(Property.QUALITY.name(), n2, n);
            this.home.getEnvironment().setPhotoQuality(this.quality);
        }
    }

    public int getQuality() {
        return this.quality;
    }

    public int getQualityLevelCount() {
        return 4;
    }

    public void setCeilingLightColor(int n) {
        if (this.ceilingLightColor != n) {
            int n2 = this.ceilingLightColor;
            this.ceilingLightColor = n;
            this.propertyChangeSupport.firePropertyChange(Property.CEILING_LIGHT_COLOR.name(), n2, n);
            this.home.getEnvironment().setCeillingLightColor(n);
        }
    }

    public int getCeilingLightColor() {
        return this.ceilingLightColor;
    }

    public void set3DViewAspectRatio(float f) {
        if (this.view3DAspectRatio != f) {
            float f2 = this.view3DAspectRatio;
            this.view3DAspectRatio = f;
            this.propertyChangeSupport.firePropertyChange(Property.ASPECT_RATIO.name(), Float.valueOf(f2), Float.valueOf(f));
            if (this.aspectRatio == AspectRatio.VIEW_3D_RATIO && this.view3DAspectRatio != Float.POSITIVE_INFINITY) {
                this.setHeight(Math.round((float)this.width / this.view3DAspectRatio), false);
            }
        }
    }

    public float get3DViewAspectRatio() {
        return this.view3DAspectRatio;
    }

    public View get3DView() {
        return this.view3D;
    }

    public void setVisualProperty(String string, Object object) {
        this.home.setVisualProperty(string, object);
    }

    public void setHomeProperty(String string, String string2) {
        this.home.setProperty(string, string2);
    }

    private static class EnvironmentChangeListener
    implements PropertyChangeListener {
        private WeakReference<AbstractPhotoController> photoController;

        public EnvironmentChangeListener(AbstractPhotoController abstractPhotoController) {
            this.photoController = new WeakReference<AbstractPhotoController>(abstractPhotoController);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            AbstractPhotoController abstractPhotoController = (AbstractPhotoController)this.photoController.get();
            if (abstractPhotoController == null) {
                ((HomeEnvironment)propertyChangeEvent.getSource()).removePropertyChangeListener(HomeEnvironment.Property.PHOTO_WIDTH, (PropertyChangeListener)this);
                ((HomeEnvironment)propertyChangeEvent.getSource()).removePropertyChangeListener(HomeEnvironment.Property.PHOTO_HEIGHT, (PropertyChangeListener)this);
                ((HomeEnvironment)propertyChangeEvent.getSource()).removePropertyChangeListener(HomeEnvironment.Property.PHOTO_ASPECT_RATIO, (PropertyChangeListener)this);
                ((HomeEnvironment)propertyChangeEvent.getSource()).removePropertyChangeListener(HomeEnvironment.Property.PHOTO_QUALITY, (PropertyChangeListener)this);
                ((HomeEnvironment)propertyChangeEvent.getSource()).removePropertyChangeListener(HomeEnvironment.Property.CEILING_LIGHT_COLOR, (PropertyChangeListener)this);
            } else if (HomeEnvironment.Property.PHOTO_WIDTH.name().equals(propertyChangeEvent.getPropertyName())) {
                abstractPhotoController.setWidth((Integer)propertyChangeEvent.getNewValue(), false);
            } else if (HomeEnvironment.Property.PHOTO_HEIGHT.name().equals(propertyChangeEvent.getPropertyName())) {
                abstractPhotoController.setHeight((Integer)propertyChangeEvent.getNewValue(), false);
            } else if (HomeEnvironment.Property.PHOTO_ASPECT_RATIO.name().equals(propertyChangeEvent.getPropertyName())) {
                abstractPhotoController.setAspectRatio((AspectRatio)((Object)propertyChangeEvent.getNewValue()));
            } else if (HomeEnvironment.Property.PHOTO_QUALITY.name().equals(propertyChangeEvent.getPropertyName())) {
                abstractPhotoController.setQuality((Integer)propertyChangeEvent.getNewValue());
            } else if (HomeEnvironment.Property.CEILING_LIGHT_COLOR.name().equals(propertyChangeEvent.getPropertyName())) {
                abstractPhotoController.setCeilingLightColor((Integer)propertyChangeEvent.getNewValue());
            }
        }
    }

    public static enum Property {
        ASPECT_RATIO,
        WIDTH,
        HEIGHT,
        QUALITY,
        VIEW_3D_ASPECT_RATIO,
        CEILING_LIGHT_COLOR;

    }
}

