// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from ATSAM3A8C.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/Atmel

// +build sam,atsam3a8c

// Atmel ATSAM3A8C Microcontroller
//

package sam

import (
	"runtime/interrupt"
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "ATSAM3A8C"
	CPU          = "CM3"
	FPUPresent   = false
	NVICPrioBits = 4
)

// Interrupt numbers.
const (
	// Power Management Controller
	IRQ_PMC = 5

	// Embedded Flash Controller 0
	IRQ_EFC0 = 6

	// Embedded Flash Controller 1
	IRQ_EFC1 = 7

	// Universal Asynchronous Receiver Transmitter
	IRQ_UART = 8

	// Parallel Input/Output Controller A
	IRQ_PIOA = 11

	// Parallel Input/Output Controller B
	IRQ_PIOB = 12

	// Universal Synchronous Asynchronous Receiver Transmitter 0
	IRQ_USART0 = 17

	// Universal Synchronous Asynchronous Receiver Transmitter 1
	IRQ_USART1 = 18

	// Universal Synchronous Asynchronous Receiver Transmitter 2
	IRQ_USART2 = 19

	// High Speed MultiMedia Card Interface
	IRQ_HSMCI = 21

	// Two-wire Interface 0
	IRQ_TWI0 = 22

	// Two-wire Interface 1
	IRQ_TWI1 = 23

	// Serial Peripheral Interface 0
	IRQ_SPI0 = 24

	// Synchronous Serial Controller
	IRQ_SSC = 26

	// Timer Counter 0
	IRQ_TC0 = 27

	// Timer Counter 0
	IRQ_TC1 = 28

	// Timer Counter 0
	IRQ_TC2 = 29

	// Timer Counter 1
	IRQ_TC3 = 30

	// Timer Counter 1
	IRQ_TC4 = 31

	// Timer Counter 1
	IRQ_TC5 = 32

	// Pulse Width Modulation Controller
	IRQ_PWM = 36

	// Analog-to-Digital Converter
	IRQ_ADC = 37

	// Digital-to-Analog Converter Controller
	IRQ_DACC = 38

	// DMA Controller
	IRQ_DMAC = 39

	// USB On-The-Go Interface
	IRQ_UOTGHS = 40

	// True Random Number Generator
	IRQ_TRNG = 41

	// Controller Area Network 0
	IRQ_CAN0 = 43

	// Controller Area Network 1
	IRQ_CAN1 = 44

	// Highest interrupt number on this device.
	IRQ_max = 44
)

// Map interrupt numbers to function names.
// These aren't real calls, they're removed by the compiler.
var (
	_ = interrupt.Register(IRQ_PMC, "PMC_IRQHandler")
	_ = interrupt.Register(IRQ_EFC0, "EFC0_IRQHandler")
	_ = interrupt.Register(IRQ_EFC1, "EFC1_IRQHandler")
	_ = interrupt.Register(IRQ_UART, "UART_IRQHandler")
	_ = interrupt.Register(IRQ_PIOA, "PIOA_IRQHandler")
	_ = interrupt.Register(IRQ_PIOB, "PIOB_IRQHandler")
	_ = interrupt.Register(IRQ_USART0, "USART0_IRQHandler")
	_ = interrupt.Register(IRQ_USART1, "USART1_IRQHandler")
	_ = interrupt.Register(IRQ_USART2, "USART2_IRQHandler")
	_ = interrupt.Register(IRQ_HSMCI, "HSMCI_IRQHandler")
	_ = interrupt.Register(IRQ_TWI0, "TWI0_IRQHandler")
	_ = interrupt.Register(IRQ_TWI1, "TWI1_IRQHandler")
	_ = interrupt.Register(IRQ_SPI0, "SPI0_IRQHandler")
	_ = interrupt.Register(IRQ_SSC, "SSC_IRQHandler")
	_ = interrupt.Register(IRQ_TC0, "TC0_IRQHandler")
	_ = interrupt.Register(IRQ_TC1, "TC1_IRQHandler")
	_ = interrupt.Register(IRQ_TC2, "TC2_IRQHandler")
	_ = interrupt.Register(IRQ_TC3, "TC3_IRQHandler")
	_ = interrupt.Register(IRQ_TC4, "TC4_IRQHandler")
	_ = interrupt.Register(IRQ_TC5, "TC5_IRQHandler")
	_ = interrupt.Register(IRQ_PWM, "PWM_IRQHandler")
	_ = interrupt.Register(IRQ_ADC, "ADC_IRQHandler")
	_ = interrupt.Register(IRQ_DACC, "DACC_IRQHandler")
	_ = interrupt.Register(IRQ_DMAC, "DMAC_IRQHandler")
	_ = interrupt.Register(IRQ_UOTGHS, "UOTGHS_IRQHandler")
	_ = interrupt.Register(IRQ_TRNG, "TRNG_IRQHandler")
	_ = interrupt.Register(IRQ_CAN0, "CAN0_IRQHandler")
	_ = interrupt.Register(IRQ_CAN1, "CAN1_IRQHandler")
)

// Peripherals.
var (
	// High Speed MultiMedia Card Interface
	HSMCI = (*HSMCI_Type)(unsafe.Pointer(uintptr(0x40000000)))

	// Synchronous Serial Controller
	SSC = (*SSC_Type)(unsafe.Pointer(uintptr(0x40004000)))

	// Serial Peripheral Interface 0
	SPI0 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40008000)))

	// Timer Counter 0
	TC0 = (*TC_Type)(unsafe.Pointer(uintptr(0x40080000)))

	// Timer Counter 1
	TC1 = (*TC_Type)(unsafe.Pointer(uintptr(0x40084000)))

	// Two-wire Interface 0
	TWI0 = (*TWI_Type)(unsafe.Pointer(uintptr(0x4008c000)))

	// Two-wire Interface 1
	TWI1 = (*TWI_Type)(unsafe.Pointer(uintptr(0x40090000)))

	// Pulse Width Modulation Controller
	PWM = (*PWM_Type)(unsafe.Pointer(uintptr(0x40094000)))

	// Universal Synchronous Asynchronous Receiver Transmitter 0
	USART0 = (*USART_Type)(unsafe.Pointer(uintptr(0x40098000)))

	// Universal Synchronous Asynchronous Receiver Transmitter 1
	USART1 = (*USART_Type)(unsafe.Pointer(uintptr(0x4009c000)))

	// Universal Synchronous Asynchronous Receiver Transmitter 2
	USART2 = (*USART_Type)(unsafe.Pointer(uintptr(0x400a0000)))

	// USB On-The-Go Interface
	UOTGHS = (*UOTGHS_Type)(unsafe.Pointer(uintptr(0x400ac000)))

	// Controller Area Network 0
	CAN0 = (*CAN_Type)(unsafe.Pointer(uintptr(0x400b4000)))

	// Controller Area Network 1
	CAN1 = (*CAN_Type)(unsafe.Pointer(uintptr(0x400b8000)))

	// True Random Number Generator
	TRNG = (*TRNG_Type)(unsafe.Pointer(uintptr(0x400bc000)))

	// Analog-to-Digital Converter
	ADC = (*ADC_Type)(unsafe.Pointer(uintptr(0x400c0000)))

	// DMA Controller
	DMAC = (*DMAC_Type)(unsafe.Pointer(uintptr(0x400c4000)))

	// Digital-to-Analog Converter Controller
	DACC = (*DACC_Type)(unsafe.Pointer(uintptr(0x400c8000)))

	// AHB Bus Matrix
	MATRIX = (*MATRIX_Type)(unsafe.Pointer(uintptr(0x400e0400)))

	// Power Management Controller
	PMC = (*PMC_Type)(unsafe.Pointer(uintptr(0x400e0600)))

	// Universal Asynchronous Receiver Transmitter
	UART = (*UART_Type)(unsafe.Pointer(uintptr(0x400e0800)))

	// Chip Identifier
	CHIPID = (*CHIPID_Type)(unsafe.Pointer(uintptr(0x400e0940)))

	// Embedded Flash Controller 0
	EFC0 = (*EFC_Type)(unsafe.Pointer(uintptr(0x400e0a00)))

	// Embedded Flash Controller 1
	EFC1 = (*EFC_Type)(unsafe.Pointer(uintptr(0x400e0c00)))

	// Parallel Input/Output Controller A
	PIOA = (*PIO_Type)(unsafe.Pointer(uintptr(0x400e0e00)))

	// Parallel Input/Output Controller B
	PIOB = (*PIO_Type)(unsafe.Pointer(uintptr(0x400e1000)))

	// Reset Controller
	RSTC = (*SYSC_Type)(unsafe.Pointer(uintptr(0x400e1a00)))

	// Supply Controller
	SUPC = (*SYSC_Type)(unsafe.Pointer(uintptr(0x400e1a10)))

	// Real-time Timer
	RTT = (*SYSC_Type)(unsafe.Pointer(uintptr(0x400e1a30)))

	// Watchdog Timer
	WDT = (*SYSC_Type)(unsafe.Pointer(uintptr(0x400e1a50)))

	// Real-time Clock
	RTC = (*SYSC_Type)(unsafe.Pointer(uintptr(0x400e1a60)))

	// General Purpose Backup Registers
	GPBR = (*SYSC_Type)(unsafe.Pointer(uintptr(0x400e1a90)))
)

// High Speed MultiMedia Card Interface
type HSMCI_Type struct {
	CR    volatile.Register32    // 0x0
	MR    volatile.Register32    // 0x4
	DTOR  volatile.Register32    // 0x8
	SDCR  volatile.Register32    // 0xC
	ARGR  volatile.Register32    // 0x10
	CMDR  volatile.Register32    // 0x14
	BLKR  volatile.Register32    // 0x18
	CSTOR volatile.Register32    // 0x1C
	RSPR  [4]volatile.Register32 // 0x20
	RDR   volatile.Register32    // 0x30
	TDR   volatile.Register32    // 0x34
	_     [8]byte
	SR    volatile.Register32 // 0x40
	IER   volatile.Register32 // 0x44
	IDR   volatile.Register32 // 0x48
	IMR   volatile.Register32 // 0x4C
	DMA   volatile.Register32 // 0x50
	CFG   volatile.Register32 // 0x54
	_     [140]byte
	WPMR  volatile.Register32 // 0xE4
	WPSR  volatile.Register32 // 0xE8
	_     [276]byte
	FIFO  [256]volatile.Register32 // 0x200
}

// Synchronous Serial Controller
type SSC_Type struct {
	CR   volatile.Register32 // 0x0
	CMR  volatile.Register32 // 0x4
	_    [8]byte
	RCMR volatile.Register32 // 0x10
	RFMR volatile.Register32 // 0x14
	TCMR volatile.Register32 // 0x18
	TFMR volatile.Register32 // 0x1C
	RHR  volatile.Register32 // 0x20
	THR  volatile.Register32 // 0x24
	_    [8]byte
	RSHR volatile.Register32 // 0x30
	TSHR volatile.Register32 // 0x34
	RC0R volatile.Register32 // 0x38
	RC1R volatile.Register32 // 0x3C
	SR   volatile.Register32 // 0x40
	IER  volatile.Register32 // 0x44
	IDR  volatile.Register32 // 0x48
	IMR  volatile.Register32 // 0x4C
	_    [148]byte
	WPMR volatile.Register32 // 0xE4
	WPSR volatile.Register32 // 0xE8
}

// Serial Peripheral Interface 0
type SPI_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	RDR  volatile.Register32 // 0x8
	TDR  volatile.Register32 // 0xC
	SR   volatile.Register32 // 0x10
	IER  volatile.Register32 // 0x14
	IDR  volatile.Register32 // 0x18
	IMR  volatile.Register32 // 0x1C
	_    [16]byte
	CSR  [4]volatile.Register32 // 0x30
	_    [164]byte
	WPMR volatile.Register32 // 0xE4
	WPSR volatile.Register32 // 0xE8
}

// Timer Counter 0
type TC_Type struct {
	CCR0  volatile.Register32 // 0x0
	CMR0  volatile.Register32 // 0x4
	SMMR0 volatile.Register32 // 0x8
	_     [4]byte
	CV0   volatile.Register32 // 0x10
	RA0   volatile.Register32 // 0x14
	RB0   volatile.Register32 // 0x18
	RC0   volatile.Register32 // 0x1C
	SR0   volatile.Register32 // 0x20
	IER0  volatile.Register32 // 0x24
	IDR0  volatile.Register32 // 0x28
	IMR0  volatile.Register32 // 0x2C
	_     [16]byte
	CCR1  volatile.Register32 // 0x40
	CMR1  volatile.Register32 // 0x44
	SMMR1 volatile.Register32 // 0x48
	_     [4]byte
	CV1   volatile.Register32 // 0x50
	RA1   volatile.Register32 // 0x54
	RB1   volatile.Register32 // 0x58
	RC1   volatile.Register32 // 0x5C
	SR1   volatile.Register32 // 0x60
	IER1  volatile.Register32 // 0x64
	IDR1  volatile.Register32 // 0x68
	IMR1  volatile.Register32 // 0x6C
	_     [16]byte
	CCR2  volatile.Register32 // 0x80
	CMR2  volatile.Register32 // 0x84
	SMMR2 volatile.Register32 // 0x88
	_     [4]byte
	CV2   volatile.Register32 // 0x90
	RA2   volatile.Register32 // 0x94
	RB2   volatile.Register32 // 0x98
	RC2   volatile.Register32 // 0x9C
	SR2   volatile.Register32 // 0xA0
	IER2  volatile.Register32 // 0xA4
	IDR2  volatile.Register32 // 0xA8
	IMR2  volatile.Register32 // 0xAC
	_     [16]byte
	BCR   volatile.Register32 // 0xC0
	BMR   volatile.Register32 // 0xC4
	QIER  volatile.Register32 // 0xC8
	QIDR  volatile.Register32 // 0xCC
	QIMR  volatile.Register32 // 0xD0
	QISR  volatile.Register32 // 0xD4
	FMR   volatile.Register32 // 0xD8
	_     [8]byte
	WPMR  volatile.Register32 // 0xE4
}

// Two-wire Interface 0
type TWI_Type struct {
	CR   volatile.Register32 // 0x0
	MMR  volatile.Register32 // 0x4
	SMR  volatile.Register32 // 0x8
	IADR volatile.Register32 // 0xC
	CWGR volatile.Register32 // 0x10
	_    [12]byte
	SR   volatile.Register32 // 0x20
	IER  volatile.Register32 // 0x24
	IDR  volatile.Register32 // 0x28
	IMR  volatile.Register32 // 0x2C
	RHR  volatile.Register32 // 0x30
	THR  volatile.Register32 // 0x34
	_    [200]byte
	RPR  volatile.Register32 // 0x100
	RCR  volatile.Register32 // 0x104
	TPR  volatile.Register32 // 0x108
	TCR  volatile.Register32 // 0x10C
	RNPR volatile.Register32 // 0x110
	RNCR volatile.Register32 // 0x114
	TNPR volatile.Register32 // 0x118
	TNCR volatile.Register32 // 0x11C
	PTCR volatile.Register32 // 0x120
	PTSR volatile.Register32 // 0x124
}

// Pulse Width Modulation Controller
type PWM_Type struct {
	CLK      volatile.Register32 // 0x0
	ENA      volatile.Register32 // 0x4
	DIS      volatile.Register32 // 0x8
	SR       volatile.Register32 // 0xC
	IER1     volatile.Register32 // 0x10
	IDR1     volatile.Register32 // 0x14
	IMR1     volatile.Register32 // 0x18
	ISR1     volatile.Register32 // 0x1C
	SCM      volatile.Register32 // 0x20
	_        [4]byte
	SCUC     volatile.Register32 // 0x28
	SCUP     volatile.Register32 // 0x2C
	SCUPUPD  volatile.Register32 // 0x30
	IER2     volatile.Register32 // 0x34
	IDR2     volatile.Register32 // 0x38
	IMR2     volatile.Register32 // 0x3C
	ISR2     volatile.Register32 // 0x40
	OOV      volatile.Register32 // 0x44
	OS       volatile.Register32 // 0x48
	OSS      volatile.Register32 // 0x4C
	OSC      volatile.Register32 // 0x50
	OSSUPD   volatile.Register32 // 0x54
	OSCUPD   volatile.Register32 // 0x58
	FMR      volatile.Register32 // 0x5C
	FSR      volatile.Register32 // 0x60
	FCR      volatile.Register32 // 0x64
	FPV      volatile.Register32 // 0x68
	FPE1     volatile.Register32 // 0x6C
	FPE2     volatile.Register32 // 0x70
	_        [8]byte
	ELMR     [2]volatile.Register32 // 0x7C
	_        [44]byte
	SMMR     volatile.Register32 // 0xB0
	_        [48]byte
	WPCR     volatile.Register32 // 0xE4
	WPSR     volatile.Register32 // 0xE8
	_        [28]byte
	TPR      volatile.Register32 // 0x108
	TCR      volatile.Register32 // 0x10C
	_        [8]byte
	TNPR     volatile.Register32 // 0x118
	TNCR     volatile.Register32 // 0x11C
	PTCR     volatile.Register32 // 0x120
	PTSR     volatile.Register32 // 0x124
	_        [8]byte
	CMPV0    volatile.Register32 // 0x130
	CMPVUPD0 volatile.Register32 // 0x134
	CMPM0    volatile.Register32 // 0x138
	CMPMUPD0 volatile.Register32 // 0x13C
	CMPV1    volatile.Register32 // 0x140
	CMPVUPD1 volatile.Register32 // 0x144
	CMPM1    volatile.Register32 // 0x148
	CMPMUPD1 volatile.Register32 // 0x14C
	CMPV2    volatile.Register32 // 0x150
	CMPVUPD2 volatile.Register32 // 0x154
	CMPM2    volatile.Register32 // 0x158
	CMPMUPD2 volatile.Register32 // 0x15C
	CMPV3    volatile.Register32 // 0x160
	CMPVUPD3 volatile.Register32 // 0x164
	CMPM3    volatile.Register32 // 0x168
	CMPMUPD3 volatile.Register32 // 0x16C
	CMPV4    volatile.Register32 // 0x170
	CMPVUPD4 volatile.Register32 // 0x174
	CMPM4    volatile.Register32 // 0x178
	CMPMUPD4 volatile.Register32 // 0x17C
	CMPV5    volatile.Register32 // 0x180
	CMPVUPD5 volatile.Register32 // 0x184
	CMPM5    volatile.Register32 // 0x188
	CMPMUPD5 volatile.Register32 // 0x18C
	CMPV6    volatile.Register32 // 0x190
	CMPVUPD6 volatile.Register32 // 0x194
	CMPM6    volatile.Register32 // 0x198
	CMPMUPD6 volatile.Register32 // 0x19C
	CMPV7    volatile.Register32 // 0x1A0
	CMPVUPD7 volatile.Register32 // 0x1A4
	CMPM7    volatile.Register32 // 0x1A8
	CMPMUPD7 volatile.Register32 // 0x1AC
	_        [80]byte
	CMR0     volatile.Register32 // 0x200
	CDTY0    volatile.Register32 // 0x204
	CDTYUPD0 volatile.Register32 // 0x208
	CPRD0    volatile.Register32 // 0x20C
	CPRDUPD0 volatile.Register32 // 0x210
	CCNT0    volatile.Register32 // 0x214
	DT0      volatile.Register32 // 0x218
	DTUPD0   volatile.Register32 // 0x21C
	CMR1     volatile.Register32 // 0x220
	CDTY1    volatile.Register32 // 0x224
	CDTYUPD1 volatile.Register32 // 0x228
	CPRD1    volatile.Register32 // 0x22C
	CPRDUPD1 volatile.Register32 // 0x230
	CCNT1    volatile.Register32 // 0x234
	DT1      volatile.Register32 // 0x238
	DTUPD1   volatile.Register32 // 0x23C
	CMR2     volatile.Register32 // 0x240
	CDTY2    volatile.Register32 // 0x244
	CDTYUPD2 volatile.Register32 // 0x248
	CPRD2    volatile.Register32 // 0x24C
	CPRDUPD2 volatile.Register32 // 0x250
	CCNT2    volatile.Register32 // 0x254
	DT2      volatile.Register32 // 0x258
	DTUPD2   volatile.Register32 // 0x25C
	CMR3     volatile.Register32 // 0x260
	CDTY3    volatile.Register32 // 0x264
	CDTYUPD3 volatile.Register32 // 0x268
	CPRD3    volatile.Register32 // 0x26C
	CPRDUPD3 volatile.Register32 // 0x270
	CCNT3    volatile.Register32 // 0x274
	DT3      volatile.Register32 // 0x278
	DTUPD3   volatile.Register32 // 0x27C
	CMR4     volatile.Register32 // 0x280
	CDTY4    volatile.Register32 // 0x284
	CDTYUPD4 volatile.Register32 // 0x288
	CPRD4    volatile.Register32 // 0x28C
	CPRDUPD4 volatile.Register32 // 0x290
	CCNT4    volatile.Register32 // 0x294
	DT4      volatile.Register32 // 0x298
	DTUPD4   volatile.Register32 // 0x29C
	CMR5     volatile.Register32 // 0x2A0
	CDTY5    volatile.Register32 // 0x2A4
	CDTYUPD5 volatile.Register32 // 0x2A8
	CPRD5    volatile.Register32 // 0x2AC
	CPRDUPD5 volatile.Register32 // 0x2B0
	CCNT5    volatile.Register32 // 0x2B4
	DT5      volatile.Register32 // 0x2B8
	DTUPD5   volatile.Register32 // 0x2BC
	CMR6     volatile.Register32 // 0x2C0
	CDTY6    volatile.Register32 // 0x2C4
	CDTYUPD6 volatile.Register32 // 0x2C8
	CPRD6    volatile.Register32 // 0x2CC
	CPRDUPD6 volatile.Register32 // 0x2D0
	CCNT6    volatile.Register32 // 0x2D4
	DT6      volatile.Register32 // 0x2D8
	DTUPD6   volatile.Register32 // 0x2DC
	CMR7     volatile.Register32 // 0x2E0
	CDTY7    volatile.Register32 // 0x2E4
	CDTYUPD7 volatile.Register32 // 0x2E8
	CPRD7    volatile.Register32 // 0x2EC
	CPRDUPD7 volatile.Register32 // 0x2F0
	CCNT7    volatile.Register32 // 0x2F4
	DT7      volatile.Register32 // 0x2F8
	DTUPD7   volatile.Register32 // 0x2FC
}

// Universal Synchronous Asynchronous Receiver Transmitter 0
type USART_Type struct {
	CR     volatile.Register32 // 0x0
	MR     volatile.Register32 // 0x4
	IER    volatile.Register32 // 0x8
	IDR    volatile.Register32 // 0xC
	IMR    volatile.Register32 // 0x10
	CSR    volatile.Register32 // 0x14
	RHR    volatile.Register32 // 0x18
	THR    volatile.Register32 // 0x1C
	BRGR   volatile.Register32 // 0x20
	RTOR   volatile.Register32 // 0x24
	TTGR   volatile.Register32 // 0x28
	_      [20]byte
	FIDI   volatile.Register32 // 0x40
	NER    volatile.Register32 // 0x44
	_      [4]byte
	IF     volatile.Register32 // 0x4C
	MAN    volatile.Register32 // 0x50
	LINMR  volatile.Register32 // 0x54
	LINIR  volatile.Register32 // 0x58
	LINBRR volatile.Register32 // 0x5C
	_      [132]byte
	WPMR   volatile.Register32 // 0xE4
	WPSR   volatile.Register32 // 0xE8
	_      [20]byte
	RPR    volatile.Register32 // 0x100
	RCR    volatile.Register32 // 0x104
	TPR    volatile.Register32 // 0x108
	TCR    volatile.Register32 // 0x10C
	RNPR   volatile.Register32 // 0x110
	RNCR   volatile.Register32 // 0x114
	TNPR   volatile.Register32 // 0x118
	TNCR   volatile.Register32 // 0x11C
	PTCR   volatile.Register32 // 0x120
	PTSR   volatile.Register32 // 0x124
}

// USB On-The-Go Interface
type UOTGHS_Type struct {
	DEVCTRL        volatile.Register32 // 0x0
	DEVISR         volatile.Register32 // 0x4
	DEVICR         volatile.Register32 // 0x8
	DEVIFR         volatile.Register32 // 0xC
	DEVIMR         volatile.Register32 // 0x10
	DEVIDR         volatile.Register32 // 0x14
	DEVIER         volatile.Register32 // 0x18
	DEVEPT         volatile.Register32 // 0x1C
	DEVFNUM        volatile.Register32 // 0x20
	_              [220]byte
	DEVEPTCFG      [10]volatile.Register32 // 0x100
	_              [8]byte
	DEVEPTISR      [10]volatile.Register32 // 0x130
	_              [8]byte
	DEVEPTICR      [10]volatile.Register32 // 0x160
	_              [8]byte
	DEVEPTIFR      [10]volatile.Register32 // 0x190
	_              [8]byte
	DEVEPTIMR      [10]volatile.Register32 // 0x1C0
	_              [8]byte
	DEVEPTIER      [10]volatile.Register32 // 0x1F0
	_              [8]byte
	DEVEPTIDR      [10]volatile.Register32 // 0x220
	_              [200]byte
	DEVDMANXTDSC1  volatile.Register32 // 0x310
	DEVDMAADDRESS1 volatile.Register32 // 0x314
	DEVDMACONTROL1 volatile.Register32 // 0x318
	DEVDMASTATUS1  volatile.Register32 // 0x31C
	DEVDMANXTDSC2  volatile.Register32 // 0x320
	DEVDMAADDRESS2 volatile.Register32 // 0x324
	DEVDMACONTROL2 volatile.Register32 // 0x328
	DEVDMASTATUS2  volatile.Register32 // 0x32C
	DEVDMANXTDSC3  volatile.Register32 // 0x330
	DEVDMAADDRESS3 volatile.Register32 // 0x334
	DEVDMACONTROL3 volatile.Register32 // 0x338
	DEVDMASTATUS3  volatile.Register32 // 0x33C
	DEVDMANXTDSC4  volatile.Register32 // 0x340
	DEVDMAADDRESS4 volatile.Register32 // 0x344
	DEVDMACONTROL4 volatile.Register32 // 0x348
	DEVDMASTATUS4  volatile.Register32 // 0x34C
	DEVDMANXTDSC5  volatile.Register32 // 0x350
	DEVDMAADDRESS5 volatile.Register32 // 0x354
	DEVDMACONTROL5 volatile.Register32 // 0x358
	DEVDMASTATUS5  volatile.Register32 // 0x35C
	DEVDMANXTDSC6  volatile.Register32 // 0x360
	DEVDMAADDRESS6 volatile.Register32 // 0x364
	DEVDMACONTROL6 volatile.Register32 // 0x368
	DEVDMASTATUS6  volatile.Register32 // 0x36C
	DEVDMANXTDSC7  volatile.Register32 // 0x370
	DEVDMAADDRESS7 volatile.Register32 // 0x374
	DEVDMACONTROL7 volatile.Register32 // 0x378
	DEVDMASTATUS7  volatile.Register32 // 0x37C
	_              [128]byte
	HSTCTRL        volatile.Register32 // 0x400
	HSTISR         volatile.Register32 // 0x404
	HSTICR         volatile.Register32 // 0x408
	HSTIFR         volatile.Register32 // 0x40C
	HSTIMR         volatile.Register32 // 0x410
	HSTIDR         volatile.Register32 // 0x414
	HSTIER         volatile.Register32 // 0x418
	HSTPIP         volatile.Register32 // 0x41C
	HSTFNUM        volatile.Register32 // 0x420
	HSTADDR1       volatile.Register32 // 0x424
	HSTADDR2       volatile.Register32 // 0x428
	HSTADDR3       volatile.Register32 // 0x42C
	_              [208]byte
	HSTPIPCFG      [10]volatile.Register32 // 0x500
	_              [8]byte
	HSTPIPISR      [10]volatile.Register32 // 0x530
	_              [8]byte
	HSTPIPICR      [10]volatile.Register32 // 0x560
	_              [8]byte
	HSTPIPIFR      [10]volatile.Register32 // 0x590
	_              [8]byte
	HSTPIPIMR      [10]volatile.Register32 // 0x5C0
	_              [8]byte
	HSTPIPIER      [10]volatile.Register32 // 0x5F0
	_              [8]byte
	HSTPIPIDR      [10]volatile.Register32 // 0x620
	_              [8]byte
	HSTPIPINRQ     [10]volatile.Register32 // 0x650
	_              [8]byte
	HSTPIPERR      [10]volatile.Register32 // 0x680
	_              [104]byte
	HSTDMANXTDSC1  volatile.Register32 // 0x710
	HSTDMAADDRESS1 volatile.Register32 // 0x714
	HSTDMACONTROL1 volatile.Register32 // 0x718
	HSTDMASTATUS1  volatile.Register32 // 0x71C
	HSTDMANXTDSC2  volatile.Register32 // 0x720
	HSTDMAADDRESS2 volatile.Register32 // 0x724
	HSTDMACONTROL2 volatile.Register32 // 0x728
	HSTDMASTATUS2  volatile.Register32 // 0x72C
	HSTDMANXTDSC3  volatile.Register32 // 0x730
	HSTDMAADDRESS3 volatile.Register32 // 0x734
	HSTDMACONTROL3 volatile.Register32 // 0x738
	HSTDMASTATUS3  volatile.Register32 // 0x73C
	HSTDMANXTDSC4  volatile.Register32 // 0x740
	HSTDMAADDRESS4 volatile.Register32 // 0x744
	HSTDMACONTROL4 volatile.Register32 // 0x748
	HSTDMASTATUS4  volatile.Register32 // 0x74C
	HSTDMANXTDSC5  volatile.Register32 // 0x750
	HSTDMAADDRESS5 volatile.Register32 // 0x754
	HSTDMACONTROL5 volatile.Register32 // 0x758
	HSTDMASTATUS5  volatile.Register32 // 0x75C
	HSTDMANXTDSC6  volatile.Register32 // 0x760
	HSTDMAADDRESS6 volatile.Register32 // 0x764
	HSTDMACONTROL6 volatile.Register32 // 0x768
	HSTDMASTATUS6  volatile.Register32 // 0x76C
	HSTDMANXTDSC7  volatile.Register32 // 0x770
	HSTDMAADDRESS7 volatile.Register32 // 0x774
	HSTDMACONTROL7 volatile.Register32 // 0x778
	HSTDMASTATUS7  volatile.Register32 // 0x77C
	_              [128]byte
	CTRL           volatile.Register32 // 0x800
	SR             volatile.Register32 // 0x804
	SCR            volatile.Register32 // 0x808
	SFR            volatile.Register32 // 0x80C
	_              [28]byte
	FSM            volatile.Register32 // 0x82C
}

// Controller Area Network 0
type CAN_Type struct {
	MR      volatile.Register32 // 0x0
	IER     volatile.Register32 // 0x4
	IDR     volatile.Register32 // 0x8
	IMR     volatile.Register32 // 0xC
	SR      volatile.Register32 // 0x10
	BR      volatile.Register32 // 0x14
	TIM     volatile.Register32 // 0x18
	TIMESTP volatile.Register32 // 0x1C
	ECR     volatile.Register32 // 0x20
	TCR     volatile.Register32 // 0x24
	ACR     volatile.Register32 // 0x28
	_       [184]byte
	WPMR    volatile.Register32 // 0xE4
	WPSR    volatile.Register32 // 0xE8
	_       [276]byte
	MMR0    volatile.Register32 // 0x200
	MAM0    volatile.Register32 // 0x204
	MID0    volatile.Register32 // 0x208
	MFID0   volatile.Register32 // 0x20C
	MSR0    volatile.Register32 // 0x210
	MDL0    volatile.Register32 // 0x214
	MDH0    volatile.Register32 // 0x218
	MCR0    volatile.Register32 // 0x21C
	MMR1    volatile.Register32 // 0x220
	MAM1    volatile.Register32 // 0x224
	MID1    volatile.Register32 // 0x228
	MFID1   volatile.Register32 // 0x22C
	MSR1    volatile.Register32 // 0x230
	MDL1    volatile.Register32 // 0x234
	MDH1    volatile.Register32 // 0x238
	MCR1    volatile.Register32 // 0x23C
	MMR2    volatile.Register32 // 0x240
	MAM2    volatile.Register32 // 0x244
	MID2    volatile.Register32 // 0x248
	MFID2   volatile.Register32 // 0x24C
	MSR2    volatile.Register32 // 0x250
	MDL2    volatile.Register32 // 0x254
	MDH2    volatile.Register32 // 0x258
	MCR2    volatile.Register32 // 0x25C
	MMR3    volatile.Register32 // 0x260
	MAM3    volatile.Register32 // 0x264
	MID3    volatile.Register32 // 0x268
	MFID3   volatile.Register32 // 0x26C
	MSR3    volatile.Register32 // 0x270
	MDL3    volatile.Register32 // 0x274
	MDH3    volatile.Register32 // 0x278
	MCR3    volatile.Register32 // 0x27C
	MMR4    volatile.Register32 // 0x280
	MAM4    volatile.Register32 // 0x284
	MID4    volatile.Register32 // 0x288
	MFID4   volatile.Register32 // 0x28C
	MSR4    volatile.Register32 // 0x290
	MDL4    volatile.Register32 // 0x294
	MDH4    volatile.Register32 // 0x298
	MCR4    volatile.Register32 // 0x29C
	MMR5    volatile.Register32 // 0x2A0
	MAM5    volatile.Register32 // 0x2A4
	MID5    volatile.Register32 // 0x2A8
	MFID5   volatile.Register32 // 0x2AC
	MSR5    volatile.Register32 // 0x2B0
	MDL5    volatile.Register32 // 0x2B4
	MDH5    volatile.Register32 // 0x2B8
	MCR5    volatile.Register32 // 0x2BC
	MMR6    volatile.Register32 // 0x2C0
	MAM6    volatile.Register32 // 0x2C4
	MID6    volatile.Register32 // 0x2C8
	MFID6   volatile.Register32 // 0x2CC
	MSR6    volatile.Register32 // 0x2D0
	MDL6    volatile.Register32 // 0x2D4
	MDH6    volatile.Register32 // 0x2D8
	MCR6    volatile.Register32 // 0x2DC
	MMR7    volatile.Register32 // 0x2E0
	MAM7    volatile.Register32 // 0x2E4
	MID7    volatile.Register32 // 0x2E8
	MFID7   volatile.Register32 // 0x2EC
	MSR7    volatile.Register32 // 0x2F0
	MDL7    volatile.Register32 // 0x2F4
	MDH7    volatile.Register32 // 0x2F8
	MCR7    volatile.Register32 // 0x2FC
}

// True Random Number Generator
type TRNG_Type struct {
	CR    volatile.Register32 // 0x0
	_     [12]byte
	IER   volatile.Register32 // 0x10
	IDR   volatile.Register32 // 0x14
	IMR   volatile.Register32 // 0x18
	ISR   volatile.Register32 // 0x1C
	_     [48]byte
	ODATA volatile.Register32 // 0x50
}

// Analog-to-Digital Converter
type ADC_Type struct {
	CR    volatile.Register32 // 0x0
	MR    volatile.Register32 // 0x4
	SEQR1 volatile.Register32 // 0x8
	SEQR2 volatile.Register32 // 0xC
	CHER  volatile.Register32 // 0x10
	CHDR  volatile.Register32 // 0x14
	CHSR  volatile.Register32 // 0x18
	_     [4]byte
	LCDR  volatile.Register32 // 0x20
	IER   volatile.Register32 // 0x24
	IDR   volatile.Register32 // 0x28
	IMR   volatile.Register32 // 0x2C
	ISR   volatile.Register32 // 0x30
	_     [8]byte
	OVER  volatile.Register32     // 0x3C
	EMR   volatile.Register32     // 0x40
	CWR   volatile.Register32     // 0x44
	CGR   volatile.Register32     // 0x48
	COR   volatile.Register32     // 0x4C
	CDR   [16]volatile.Register32 // 0x50
	_     [4]byte
	ACR   volatile.Register32 // 0x94
	_     [76]byte
	WPMR  volatile.Register32 // 0xE4
	WPSR  volatile.Register32 // 0xE8
	_     [20]byte
	RPR   volatile.Register32 // 0x100
	RCR   volatile.Register32 // 0x104
	_     [8]byte
	RNPR  volatile.Register32 // 0x110
	RNCR  volatile.Register32 // 0x114
	_     [8]byte
	PTCR  volatile.Register32 // 0x120
	PTSR  volatile.Register32 // 0x124
}

// DMA Controller
type DMAC_Type struct {
	GCFG   volatile.Register32 // 0x0
	EN     volatile.Register32 // 0x4
	SREQ   volatile.Register32 // 0x8
	CREQ   volatile.Register32 // 0xC
	LAST   volatile.Register32 // 0x10
	_      [4]byte
	EBCIER volatile.Register32 // 0x18
	EBCIDR volatile.Register32 // 0x1C
	EBCIMR volatile.Register32 // 0x20
	EBCISR volatile.Register32 // 0x24
	CHER   volatile.Register32 // 0x28
	CHDR   volatile.Register32 // 0x2C
	CHSR   volatile.Register32 // 0x30
	_      [8]byte
	SADDR0 volatile.Register32 // 0x3C
	DADDR0 volatile.Register32 // 0x40
	DSCR0  volatile.Register32 // 0x44
	CTRLA0 volatile.Register32 // 0x48
	CTRLB0 volatile.Register32 // 0x4C
	CFG0   volatile.Register32 // 0x50
	_      [16]byte
	SADDR1 volatile.Register32 // 0x64
	DADDR1 volatile.Register32 // 0x68
	DSCR1  volatile.Register32 // 0x6C
	CTRLA1 volatile.Register32 // 0x70
	CTRLB1 volatile.Register32 // 0x74
	CFG1   volatile.Register32 // 0x78
	_      [16]byte
	SADDR2 volatile.Register32 // 0x8C
	DADDR2 volatile.Register32 // 0x90
	DSCR2  volatile.Register32 // 0x94
	CTRLA2 volatile.Register32 // 0x98
	CTRLB2 volatile.Register32 // 0x9C
	CFG2   volatile.Register32 // 0xA0
	_      [16]byte
	SADDR3 volatile.Register32 // 0xB4
	DADDR3 volatile.Register32 // 0xB8
	DSCR3  volatile.Register32 // 0xBC
	CTRLA3 volatile.Register32 // 0xC0
	CTRLB3 volatile.Register32 // 0xC4
	CFG3   volatile.Register32 // 0xC8
	_      [16]byte
	SADDR4 volatile.Register32 // 0xDC
	DADDR4 volatile.Register32 // 0xE0
	DSCR4  volatile.Register32 // 0xE4
	CTRLA4 volatile.Register32 // 0xE8
	CTRLB4 volatile.Register32 // 0xEC
	CFG4   volatile.Register32 // 0xF0
	_      [16]byte
	SADDR5 volatile.Register32 // 0x104
	DADDR5 volatile.Register32 // 0x108
	DSCR5  volatile.Register32 // 0x10C
	CTRLA5 volatile.Register32 // 0x110
	CTRLB5 volatile.Register32 // 0x114
	CFG5   volatile.Register32 // 0x118
	_      [200]byte
	WPMR   volatile.Register32 // 0x1E4
	WPSR   volatile.Register32 // 0x1E8
}

// Digital-to-Analog Converter Controller
type DACC_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	_    [8]byte
	CHER volatile.Register32 // 0x10
	CHDR volatile.Register32 // 0x14
	CHSR volatile.Register32 // 0x18
	_    [4]byte
	CDR  volatile.Register32 // 0x20
	IER  volatile.Register32 // 0x24
	IDR  volatile.Register32 // 0x28
	IMR  volatile.Register32 // 0x2C
	ISR  volatile.Register32 // 0x30
	_    [96]byte
	ACR  volatile.Register32 // 0x94
	_    [76]byte
	WPMR volatile.Register32 // 0xE4
	WPSR volatile.Register32 // 0xE8
	_    [28]byte
	TPR  volatile.Register32 // 0x108
	TCR  volatile.Register32 // 0x10C
	_    [8]byte
	TNPR volatile.Register32 // 0x118
	TNCR volatile.Register32 // 0x11C
	PTCR volatile.Register32 // 0x120
	PTSR volatile.Register32 // 0x124
}

// AHB Bus Matrix
type MATRIX_Type struct {
	MATRIX_MCFG  [6]volatile.Register32 // 0x0
	_            [40]byte
	MATRIX_SCFG  [9]volatile.Register32 // 0x40
	_            [28]byte
	MATRIX_PRAS0 volatile.Register32 // 0x80
	_            [4]byte
	MATRIX_PRAS1 volatile.Register32 // 0x88
	_            [4]byte
	MATRIX_PRAS2 volatile.Register32 // 0x90
	_            [4]byte
	MATRIX_PRAS3 volatile.Register32 // 0x98
	_            [4]byte
	MATRIX_PRAS4 volatile.Register32 // 0xA0
	_            [4]byte
	MATRIX_PRAS5 volatile.Register32 // 0xA8
	_            [4]byte
	MATRIX_PRAS6 volatile.Register32 // 0xB0
	_            [4]byte
	MATRIX_PRAS7 volatile.Register32 // 0xB8
	_            [4]byte
	MATRIX_PRAS8 volatile.Register32 // 0xC0
	_            [60]byte
	MATRIX_MRCR  volatile.Register32 // 0x100
	_            [16]byte
	CCFG_SYSIO   volatile.Register32 // 0x114
	_            [204]byte
	MATRIX_WPMR  volatile.Register32 // 0x1E4
	MATRIX_WPSR  volatile.Register32 // 0x1E8
}

// Power Management Controller
type PMC_Type struct {
	PMC_SCER   volatile.Register32 // 0x0
	PMC_SCDR   volatile.Register32 // 0x4
	PMC_SCSR   volatile.Register32 // 0x8
	_          [4]byte
	PMC_PCER0  volatile.Register32 // 0x10
	PMC_PCDR0  volatile.Register32 // 0x14
	PMC_PCSR0  volatile.Register32 // 0x18
	CKGR_UCKR  volatile.Register32 // 0x1C
	CKGR_MOR   volatile.Register32 // 0x20
	CKGR_MCFR  volatile.Register32 // 0x24
	CKGR_PLLAR volatile.Register32 // 0x28
	_          [4]byte
	PMC_MCKR   volatile.Register32 // 0x30
	_          [4]byte
	PMC_USB    volatile.Register32 // 0x38
	_          [4]byte
	PMC_PCK    [3]volatile.Register32 // 0x40
	_          [20]byte
	PMC_IER    volatile.Register32 // 0x60
	PMC_IDR    volatile.Register32 // 0x64
	PMC_SR     volatile.Register32 // 0x68
	PMC_IMR    volatile.Register32 // 0x6C
	PMC_FSMR   volatile.Register32 // 0x70
	PMC_FSPR   volatile.Register32 // 0x74
	PMC_FOCR   volatile.Register32 // 0x78
	_          [104]byte
	PMC_WPMR   volatile.Register32 // 0xE4
	PMC_WPSR   volatile.Register32 // 0xE8
	_          [20]byte
	PMC_PCER1  volatile.Register32 // 0x100
	PMC_PCDR1  volatile.Register32 // 0x104
	PMC_PCSR1  volatile.Register32 // 0x108
	PMC_PCR    volatile.Register32 // 0x10C
}

// Universal Asynchronous Receiver Transmitter
type UART_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	IER  volatile.Register32 // 0x8
	IDR  volatile.Register32 // 0xC
	IMR  volatile.Register32 // 0x10
	SR   volatile.Register32 // 0x14
	RHR  volatile.Register32 // 0x18
	THR  volatile.Register32 // 0x1C
	BRGR volatile.Register32 // 0x20
	_    [220]byte
	RPR  volatile.Register32 // 0x100
	RCR  volatile.Register32 // 0x104
	TPR  volatile.Register32 // 0x108
	TCR  volatile.Register32 // 0x10C
	RNPR volatile.Register32 // 0x110
	RNCR volatile.Register32 // 0x114
	TNPR volatile.Register32 // 0x118
	TNCR volatile.Register32 // 0x11C
	PTCR volatile.Register32 // 0x120
	PTSR volatile.Register32 // 0x124
}

// Chip Identifier
type CHIPID_Type struct {
	CIDR volatile.Register32 // 0x0
	EXID volatile.Register32 // 0x4
}

// Embedded Flash Controller 0
type EFC_Type struct {
	FMR volatile.Register32 // 0x0
	FCR volatile.Register32 // 0x4
	FSR volatile.Register32 // 0x8
	FRR volatile.Register32 // 0xC
}

// Parallel Input/Output Controller A
type PIO_Type struct {
	PER    volatile.Register32 // 0x0
	PDR    volatile.Register32 // 0x4
	PSR    volatile.Register32 // 0x8
	_      [4]byte
	OER    volatile.Register32 // 0x10
	ODR    volatile.Register32 // 0x14
	OSR    volatile.Register32 // 0x18
	_      [4]byte
	IFER   volatile.Register32 // 0x20
	IFDR   volatile.Register32 // 0x24
	IFSR   volatile.Register32 // 0x28
	_      [4]byte
	SODR   volatile.Register32 // 0x30
	CODR   volatile.Register32 // 0x34
	ODSR   volatile.Register32 // 0x38
	PDSR   volatile.Register32 // 0x3C
	IER    volatile.Register32 // 0x40
	IDR    volatile.Register32 // 0x44
	IMR    volatile.Register32 // 0x48
	ISR    volatile.Register32 // 0x4C
	MDER   volatile.Register32 // 0x50
	MDDR   volatile.Register32 // 0x54
	MDSR   volatile.Register32 // 0x58
	_      [4]byte
	PUDR   volatile.Register32 // 0x60
	PUER   volatile.Register32 // 0x64
	PUSR   volatile.Register32 // 0x68
	_      [4]byte
	ABSR   volatile.Register32 // 0x70
	_      [12]byte
	SCIFSR volatile.Register32 // 0x80
	DIFSR  volatile.Register32 // 0x84
	IFDGSR volatile.Register32 // 0x88
	SCDR   volatile.Register32 // 0x8C
	_      [16]byte
	OWER   volatile.Register32 // 0xA0
	OWDR   volatile.Register32 // 0xA4
	OWSR   volatile.Register32 // 0xA8
	_      [4]byte
	AIMER  volatile.Register32 // 0xB0
	AIMDR  volatile.Register32 // 0xB4
	AIMMR  volatile.Register32 // 0xB8
	_      [4]byte
	ESR    volatile.Register32 // 0xC0
	LSR    volatile.Register32 // 0xC4
	ELSR   volatile.Register32 // 0xC8
	_      [4]byte
	FELLSR volatile.Register32 // 0xD0
	REHLSR volatile.Register32 // 0xD4
	FRLHSR volatile.Register32 // 0xD8
	_      [4]byte
	LOCKSR volatile.Register32 // 0xE0
	WPMR   volatile.Register32 // 0xE4
	WPSR   volatile.Register32 // 0xE8
}

// Reset Controller
type SYSC_Type struct {
	CR volatile.Register32 // 0x0
	SR volatile.Register32 // 0x4
	MR volatile.Register32 // 0x8
}

// Bitfields for HSMCI: High Speed MultiMedia Card Interface
const (
	// CR: Control Register
	// Position of MCIEN field.
	HSMCI_CR_MCIEN_Pos = 0x0
	// Bit mask of MCIEN field.
	HSMCI_CR_MCIEN_Msk = 0x1
	// Bit MCIEN.
	HSMCI_CR_MCIEN = 0x1
	// Position of MCIDIS field.
	HSMCI_CR_MCIDIS_Pos = 0x1
	// Bit mask of MCIDIS field.
	HSMCI_CR_MCIDIS_Msk = 0x2
	// Bit MCIDIS.
	HSMCI_CR_MCIDIS = 0x2
	// Position of PWSEN field.
	HSMCI_CR_PWSEN_Pos = 0x2
	// Bit mask of PWSEN field.
	HSMCI_CR_PWSEN_Msk = 0x4
	// Bit PWSEN.
	HSMCI_CR_PWSEN = 0x4
	// Position of PWSDIS field.
	HSMCI_CR_PWSDIS_Pos = 0x3
	// Bit mask of PWSDIS field.
	HSMCI_CR_PWSDIS_Msk = 0x8
	// Bit PWSDIS.
	HSMCI_CR_PWSDIS = 0x8
	// Position of SWRST field.
	HSMCI_CR_SWRST_Pos = 0x7
	// Bit mask of SWRST field.
	HSMCI_CR_SWRST_Msk = 0x80
	// Bit SWRST.
	HSMCI_CR_SWRST = 0x80

	// MR: Mode Register
	// Position of CLKDIV field.
	HSMCI_MR_CLKDIV_Pos = 0x0
	// Bit mask of CLKDIV field.
	HSMCI_MR_CLKDIV_Msk = 0xff
	// Position of PWSDIV field.
	HSMCI_MR_PWSDIV_Pos = 0x8
	// Bit mask of PWSDIV field.
	HSMCI_MR_PWSDIV_Msk = 0x700
	// Position of RDPROOF field.
	HSMCI_MR_RDPROOF_Pos = 0xb
	// Bit mask of RDPROOF field.
	HSMCI_MR_RDPROOF_Msk = 0x800
	// Bit RDPROOF.
	HSMCI_MR_RDPROOF = 0x800
	// Position of WRPROOF field.
	HSMCI_MR_WRPROOF_Pos = 0xc
	// Bit mask of WRPROOF field.
	HSMCI_MR_WRPROOF_Msk = 0x1000
	// Bit WRPROOF.
	HSMCI_MR_WRPROOF = 0x1000
	// Position of FBYTE field.
	HSMCI_MR_FBYTE_Pos = 0xd
	// Bit mask of FBYTE field.
	HSMCI_MR_FBYTE_Msk = 0x2000
	// Bit FBYTE.
	HSMCI_MR_FBYTE = 0x2000
	// Position of PADV field.
	HSMCI_MR_PADV_Pos = 0xe
	// Bit mask of PADV field.
	HSMCI_MR_PADV_Msk = 0x4000
	// Bit PADV.
	HSMCI_MR_PADV = 0x4000

	// DTOR: Data Timeout Register
	// Position of DTOCYC field.
	HSMCI_DTOR_DTOCYC_Pos = 0x0
	// Bit mask of DTOCYC field.
	HSMCI_DTOR_DTOCYC_Msk = 0xf
	// Position of DTOMUL field.
	HSMCI_DTOR_DTOMUL_Pos = 0x4
	// Bit mask of DTOMUL field.
	HSMCI_DTOR_DTOMUL_Msk = 0x70
	// DTOCYC
	HSMCI_DTOR_DTOMUL_1 = 0x0
	// DTOCYC x 16
	HSMCI_DTOR_DTOMUL_16 = 0x1
	// DTOCYC x 128
	HSMCI_DTOR_DTOMUL_128 = 0x2
	// DTOCYC x 256
	HSMCI_DTOR_DTOMUL_256 = 0x3
	// DTOCYC x 1024
	HSMCI_DTOR_DTOMUL_1024 = 0x4
	// DTOCYC x 4096
	HSMCI_DTOR_DTOMUL_4096 = 0x5
	// DTOCYC x 65536
	HSMCI_DTOR_DTOMUL_65536 = 0x6
	// DTOCYC x 1048576
	HSMCI_DTOR_DTOMUL_1048576 = 0x7

	// SDCR: SD/SDIO Card Register
	// Position of SDCSEL field.
	HSMCI_SDCR_SDCSEL_Pos = 0x0
	// Bit mask of SDCSEL field.
	HSMCI_SDCR_SDCSEL_Msk = 0x3
	// Slot A is selected.
	HSMCI_SDCR_SDCSEL_SLOTA = 0x0
	// SDCARD/SDIO Slot B selected
	HSMCI_SDCR_SDCSEL_SLOTB = 0x1
	// -
	HSMCI_SDCR_SDCSEL_SLOTC = 0x2
	// -
	HSMCI_SDCR_SDCSEL_SLOTD = 0x3
	// Position of SDCBUS field.
	HSMCI_SDCR_SDCBUS_Pos = 0x6
	// Bit mask of SDCBUS field.
	HSMCI_SDCR_SDCBUS_Msk = 0xc0
	// 1 bit
	HSMCI_SDCR_SDCBUS_1 = 0x0
	// 4 bits
	HSMCI_SDCR_SDCBUS_4 = 0x2
	// 8 bits
	HSMCI_SDCR_SDCBUS_8 = 0x3

	// ARGR: Argument Register
	// Position of ARG field.
	HSMCI_ARGR_ARG_Pos = 0x0
	// Bit mask of ARG field.
	HSMCI_ARGR_ARG_Msk = 0xffffffff

	// CMDR: Command Register
	// Position of CMDNB field.
	HSMCI_CMDR_CMDNB_Pos = 0x0
	// Bit mask of CMDNB field.
	HSMCI_CMDR_CMDNB_Msk = 0x3f
	// Position of RSPTYP field.
	HSMCI_CMDR_RSPTYP_Pos = 0x6
	// Bit mask of RSPTYP field.
	HSMCI_CMDR_RSPTYP_Msk = 0xc0
	// No response
	HSMCI_CMDR_RSPTYP_NORESP = 0x0
	// 48-bit response
	HSMCI_CMDR_RSPTYP_48_BIT = 0x1
	// 136-bit response
	HSMCI_CMDR_RSPTYP_136_BIT = 0x2
	// R1b response type
	HSMCI_CMDR_RSPTYP_R1B = 0x3
	// Position of SPCMD field.
	HSMCI_CMDR_SPCMD_Pos = 0x8
	// Bit mask of SPCMD field.
	HSMCI_CMDR_SPCMD_Msk = 0x700
	// Not a special CMD.
	HSMCI_CMDR_SPCMD_STD = 0x0
	// Initialization CMD: 74 clock cycles for initialization sequence.
	HSMCI_CMDR_SPCMD_INIT = 0x1
	// Synchronized CMD: Wait for the end of the current data block transfer before sending the pending command.
	HSMCI_CMDR_SPCMD_SYNC = 0x2
	// CE-ATA Completion Signal disable Command. The host cancels the ability for the device to return a command completion signal on the command line.
	HSMCI_CMDR_SPCMD_CE_ATA = 0x3
	// Interrupt command: Corresponds to the Interrupt Mode (CMD40).
	HSMCI_CMDR_SPCMD_IT_CMD = 0x4
	// Interrupt response: Corresponds to the Interrupt Mode (CMD40).
	HSMCI_CMDR_SPCMD_IT_RESP = 0x5
	// Boot Operation Request. Start a boot operation mode, the host processor can read boot data from the MMC device directly.
	HSMCI_CMDR_SPCMD_BOR = 0x6
	// End Boot Operation. This command allows the host processor to terminate the boot operation mode.
	HSMCI_CMDR_SPCMD_EBO = 0x7
	// Position of OPDCMD field.
	HSMCI_CMDR_OPDCMD_Pos = 0xb
	// Bit mask of OPDCMD field.
	HSMCI_CMDR_OPDCMD_Msk = 0x800
	// Bit OPDCMD.
	HSMCI_CMDR_OPDCMD = 0x800
	// Push pull command.
	HSMCI_CMDR_OPDCMD_PUSHPULL = 0x0
	// Open drain command.
	HSMCI_CMDR_OPDCMD_OPENDRAIN = 0x1
	// Position of MAXLAT field.
	HSMCI_CMDR_MAXLAT_Pos = 0xc
	// Bit mask of MAXLAT field.
	HSMCI_CMDR_MAXLAT_Msk = 0x1000
	// Bit MAXLAT.
	HSMCI_CMDR_MAXLAT = 0x1000
	// 5-cycle max latency.
	HSMCI_CMDR_MAXLAT_5 = 0x0
	// 64-cycle max latency.
	HSMCI_CMDR_MAXLAT_64 = 0x1
	// Position of TRCMD field.
	HSMCI_CMDR_TRCMD_Pos = 0x10
	// Bit mask of TRCMD field.
	HSMCI_CMDR_TRCMD_Msk = 0x30000
	// No data transfer
	HSMCI_CMDR_TRCMD_NO_DATA = 0x0
	// Start data transfer
	HSMCI_CMDR_TRCMD_START_DATA = 0x1
	// Stop data transfer
	HSMCI_CMDR_TRCMD_STOP_DATA = 0x2
	// Position of TRDIR field.
	HSMCI_CMDR_TRDIR_Pos = 0x12
	// Bit mask of TRDIR field.
	HSMCI_CMDR_TRDIR_Msk = 0x40000
	// Bit TRDIR.
	HSMCI_CMDR_TRDIR = 0x40000
	// Write.
	HSMCI_CMDR_TRDIR_WRITE = 0x0
	// Read.
	HSMCI_CMDR_TRDIR_READ = 0x1
	// Position of TRTYP field.
	HSMCI_CMDR_TRTYP_Pos = 0x13
	// Bit mask of TRTYP field.
	HSMCI_CMDR_TRTYP_Msk = 0x380000
	// MMC/SD Card Single Block
	HSMCI_CMDR_TRTYP_SINGLE = 0x0
	// MMC/SD Card Multiple Block
	HSMCI_CMDR_TRTYP_MULTIPLE = 0x1
	// MMC Stream
	HSMCI_CMDR_TRTYP_STREAM = 0x2
	// SDIO Byte
	HSMCI_CMDR_TRTYP_BYTE = 0x4
	// SDIO Block
	HSMCI_CMDR_TRTYP_BLOCK = 0x5
	// Position of IOSPCMD field.
	HSMCI_CMDR_IOSPCMD_Pos = 0x18
	// Bit mask of IOSPCMD field.
	HSMCI_CMDR_IOSPCMD_Msk = 0x3000000
	// Not an SDIO Special Command
	HSMCI_CMDR_IOSPCMD_STD = 0x0
	// SDIO Suspend Command
	HSMCI_CMDR_IOSPCMD_SUSPEND = 0x1
	// SDIO Resume Command
	HSMCI_CMDR_IOSPCMD_RESUME = 0x2
	// Position of ATACS field.
	HSMCI_CMDR_ATACS_Pos = 0x1a
	// Bit mask of ATACS field.
	HSMCI_CMDR_ATACS_Msk = 0x4000000
	// Bit ATACS.
	HSMCI_CMDR_ATACS = 0x4000000
	// Normal operation mode.
	HSMCI_CMDR_ATACS_NORMAL = 0x0
	// This bit indicates that a completion signal is expected within a programmed amount of time (HSMCI_CSTOR).
	HSMCI_CMDR_ATACS_COMPLETION = 0x1
	// Position of BOOT_ACK field.
	HSMCI_CMDR_BOOT_ACK_Pos = 0x1b
	// Bit mask of BOOT_ACK field.
	HSMCI_CMDR_BOOT_ACK_Msk = 0x8000000
	// Bit BOOT_ACK.
	HSMCI_CMDR_BOOT_ACK = 0x8000000

	// BLKR: Block Register
	// Position of BCNT field.
	HSMCI_BLKR_BCNT_Pos = 0x0
	// Bit mask of BCNT field.
	HSMCI_BLKR_BCNT_Msk = 0xffff
	// Position of BLKLEN field.
	HSMCI_BLKR_BLKLEN_Pos = 0x10
	// Bit mask of BLKLEN field.
	HSMCI_BLKR_BLKLEN_Msk = 0xffff0000

	// CSTOR: Completion Signal Timeout Register
	// Position of CSTOCYC field.
	HSMCI_CSTOR_CSTOCYC_Pos = 0x0
	// Bit mask of CSTOCYC field.
	HSMCI_CSTOR_CSTOCYC_Msk = 0xf
	// Position of CSTOMUL field.
	HSMCI_CSTOR_CSTOMUL_Pos = 0x4
	// Bit mask of CSTOMUL field.
	HSMCI_CSTOR_CSTOMUL_Msk = 0x70
	// CSTOCYC x 1
	HSMCI_CSTOR_CSTOMUL_1 = 0x0
	// CSTOCYC x 16
	HSMCI_CSTOR_CSTOMUL_16 = 0x1
	// CSTOCYC x 128
	HSMCI_CSTOR_CSTOMUL_128 = 0x2
	// CSTOCYC x 256
	HSMCI_CSTOR_CSTOMUL_256 = 0x3
	// CSTOCYC x 1024
	HSMCI_CSTOR_CSTOMUL_1024 = 0x4
	// CSTOCYC x 4096
	HSMCI_CSTOR_CSTOMUL_4096 = 0x5
	// CSTOCYC x 65536
	HSMCI_CSTOR_CSTOMUL_65536 = 0x6
	// CSTOCYC x 1048576
	HSMCI_CSTOR_CSTOMUL_1048576 = 0x7

	// RSPR: Response Register
	// Position of RSP field.
	HSMCI_RSPR_RSP_Pos = 0x0
	// Bit mask of RSP field.
	HSMCI_RSPR_RSP_Msk = 0xffffffff

	// RDR: Receive Data Register
	// Position of DATA field.
	HSMCI_RDR_DATA_Pos = 0x0
	// Bit mask of DATA field.
	HSMCI_RDR_DATA_Msk = 0xffffffff

	// TDR: Transmit Data Register
	// Position of DATA field.
	HSMCI_TDR_DATA_Pos = 0x0
	// Bit mask of DATA field.
	HSMCI_TDR_DATA_Msk = 0xffffffff

	// SR: Status Register
	// Position of CMDRDY field.
	HSMCI_SR_CMDRDY_Pos = 0x0
	// Bit mask of CMDRDY field.
	HSMCI_SR_CMDRDY_Msk = 0x1
	// Bit CMDRDY.
	HSMCI_SR_CMDRDY = 0x1
	// Position of RXRDY field.
	HSMCI_SR_RXRDY_Pos = 0x1
	// Bit mask of RXRDY field.
	HSMCI_SR_RXRDY_Msk = 0x2
	// Bit RXRDY.
	HSMCI_SR_RXRDY = 0x2
	// Position of TXRDY field.
	HSMCI_SR_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	HSMCI_SR_TXRDY_Msk = 0x4
	// Bit TXRDY.
	HSMCI_SR_TXRDY = 0x4
	// Position of BLKE field.
	HSMCI_SR_BLKE_Pos = 0x3
	// Bit mask of BLKE field.
	HSMCI_SR_BLKE_Msk = 0x8
	// Bit BLKE.
	HSMCI_SR_BLKE = 0x8
	// Position of DTIP field.
	HSMCI_SR_DTIP_Pos = 0x4
	// Bit mask of DTIP field.
	HSMCI_SR_DTIP_Msk = 0x10
	// Bit DTIP.
	HSMCI_SR_DTIP = 0x10
	// Position of NOTBUSY field.
	HSMCI_SR_NOTBUSY_Pos = 0x5
	// Bit mask of NOTBUSY field.
	HSMCI_SR_NOTBUSY_Msk = 0x20
	// Bit NOTBUSY.
	HSMCI_SR_NOTBUSY = 0x20
	// Position of SDIOIRQforSlotA field.
	HSMCI_SR_SDIOIRQforSlotA_Pos = 0x8
	// Bit mask of SDIOIRQforSlotA field.
	HSMCI_SR_SDIOIRQforSlotA_Msk = 0x100
	// Bit SDIOIRQforSlotA.
	HSMCI_SR_SDIOIRQforSlotA = 0x100
	// Position of SDIOIRQforSlotB field.
	HSMCI_SR_SDIOIRQforSlotB_Pos = 0x9
	// Bit mask of SDIOIRQforSlotB field.
	HSMCI_SR_SDIOIRQforSlotB_Msk = 0x200
	// Bit SDIOIRQforSlotB.
	HSMCI_SR_SDIOIRQforSlotB = 0x200
	// Position of SDIOWAIT field.
	HSMCI_SR_SDIOWAIT_Pos = 0xc
	// Bit mask of SDIOWAIT field.
	HSMCI_SR_SDIOWAIT_Msk = 0x1000
	// Bit SDIOWAIT.
	HSMCI_SR_SDIOWAIT = 0x1000
	// Position of CSRCV field.
	HSMCI_SR_CSRCV_Pos = 0xd
	// Bit mask of CSRCV field.
	HSMCI_SR_CSRCV_Msk = 0x2000
	// Bit CSRCV.
	HSMCI_SR_CSRCV = 0x2000
	// Position of RINDE field.
	HSMCI_SR_RINDE_Pos = 0x10
	// Bit mask of RINDE field.
	HSMCI_SR_RINDE_Msk = 0x10000
	// Bit RINDE.
	HSMCI_SR_RINDE = 0x10000
	// Position of RDIRE field.
	HSMCI_SR_RDIRE_Pos = 0x11
	// Bit mask of RDIRE field.
	HSMCI_SR_RDIRE_Msk = 0x20000
	// Bit RDIRE.
	HSMCI_SR_RDIRE = 0x20000
	// Position of RCRCE field.
	HSMCI_SR_RCRCE_Pos = 0x12
	// Bit mask of RCRCE field.
	HSMCI_SR_RCRCE_Msk = 0x40000
	// Bit RCRCE.
	HSMCI_SR_RCRCE = 0x40000
	// Position of RENDE field.
	HSMCI_SR_RENDE_Pos = 0x13
	// Bit mask of RENDE field.
	HSMCI_SR_RENDE_Msk = 0x80000
	// Bit RENDE.
	HSMCI_SR_RENDE = 0x80000
	// Position of RTOE field.
	HSMCI_SR_RTOE_Pos = 0x14
	// Bit mask of RTOE field.
	HSMCI_SR_RTOE_Msk = 0x100000
	// Bit RTOE.
	HSMCI_SR_RTOE = 0x100000
	// Position of DCRCE field.
	HSMCI_SR_DCRCE_Pos = 0x15
	// Bit mask of DCRCE field.
	HSMCI_SR_DCRCE_Msk = 0x200000
	// Bit DCRCE.
	HSMCI_SR_DCRCE = 0x200000
	// Position of DTOE field.
	HSMCI_SR_DTOE_Pos = 0x16
	// Bit mask of DTOE field.
	HSMCI_SR_DTOE_Msk = 0x400000
	// Bit DTOE.
	HSMCI_SR_DTOE = 0x400000
	// Position of CSTOE field.
	HSMCI_SR_CSTOE_Pos = 0x17
	// Bit mask of CSTOE field.
	HSMCI_SR_CSTOE_Msk = 0x800000
	// Bit CSTOE.
	HSMCI_SR_CSTOE = 0x800000
	// Position of BLKOVRE field.
	HSMCI_SR_BLKOVRE_Pos = 0x18
	// Bit mask of BLKOVRE field.
	HSMCI_SR_BLKOVRE_Msk = 0x1000000
	// Bit BLKOVRE.
	HSMCI_SR_BLKOVRE = 0x1000000
	// Position of DMADONE field.
	HSMCI_SR_DMADONE_Pos = 0x19
	// Bit mask of DMADONE field.
	HSMCI_SR_DMADONE_Msk = 0x2000000
	// Bit DMADONE.
	HSMCI_SR_DMADONE = 0x2000000
	// Position of FIFOEMPTY field.
	HSMCI_SR_FIFOEMPTY_Pos = 0x1a
	// Bit mask of FIFOEMPTY field.
	HSMCI_SR_FIFOEMPTY_Msk = 0x4000000
	// Bit FIFOEMPTY.
	HSMCI_SR_FIFOEMPTY = 0x4000000
	// Position of XFRDONE field.
	HSMCI_SR_XFRDONE_Pos = 0x1b
	// Bit mask of XFRDONE field.
	HSMCI_SR_XFRDONE_Msk = 0x8000000
	// Bit XFRDONE.
	HSMCI_SR_XFRDONE = 0x8000000
	// Position of ACKRCV field.
	HSMCI_SR_ACKRCV_Pos = 0x1c
	// Bit mask of ACKRCV field.
	HSMCI_SR_ACKRCV_Msk = 0x10000000
	// Bit ACKRCV.
	HSMCI_SR_ACKRCV = 0x10000000
	// Position of ACKRCVE field.
	HSMCI_SR_ACKRCVE_Pos = 0x1d
	// Bit mask of ACKRCVE field.
	HSMCI_SR_ACKRCVE_Msk = 0x20000000
	// Bit ACKRCVE.
	HSMCI_SR_ACKRCVE = 0x20000000
	// Position of OVRE field.
	HSMCI_SR_OVRE_Pos = 0x1e
	// Bit mask of OVRE field.
	HSMCI_SR_OVRE_Msk = 0x40000000
	// Bit OVRE.
	HSMCI_SR_OVRE = 0x40000000
	// Position of UNRE field.
	HSMCI_SR_UNRE_Pos = 0x1f
	// Bit mask of UNRE field.
	HSMCI_SR_UNRE_Msk = 0x80000000
	// Bit UNRE.
	HSMCI_SR_UNRE = 0x80000000

	// IER: Interrupt Enable Register
	// Position of CMDRDY field.
	HSMCI_IER_CMDRDY_Pos = 0x0
	// Bit mask of CMDRDY field.
	HSMCI_IER_CMDRDY_Msk = 0x1
	// Bit CMDRDY.
	HSMCI_IER_CMDRDY = 0x1
	// Position of RXRDY field.
	HSMCI_IER_RXRDY_Pos = 0x1
	// Bit mask of RXRDY field.
	HSMCI_IER_RXRDY_Msk = 0x2
	// Bit RXRDY.
	HSMCI_IER_RXRDY = 0x2
	// Position of TXRDY field.
	HSMCI_IER_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	HSMCI_IER_TXRDY_Msk = 0x4
	// Bit TXRDY.
	HSMCI_IER_TXRDY = 0x4
	// Position of BLKE field.
	HSMCI_IER_BLKE_Pos = 0x3
	// Bit mask of BLKE field.
	HSMCI_IER_BLKE_Msk = 0x8
	// Bit BLKE.
	HSMCI_IER_BLKE = 0x8
	// Position of DTIP field.
	HSMCI_IER_DTIP_Pos = 0x4
	// Bit mask of DTIP field.
	HSMCI_IER_DTIP_Msk = 0x10
	// Bit DTIP.
	HSMCI_IER_DTIP = 0x10
	// Position of NOTBUSY field.
	HSMCI_IER_NOTBUSY_Pos = 0x5
	// Bit mask of NOTBUSY field.
	HSMCI_IER_NOTBUSY_Msk = 0x20
	// Bit NOTBUSY.
	HSMCI_IER_NOTBUSY = 0x20
	// Position of SDIOIRQforSlotA field.
	HSMCI_IER_SDIOIRQforSlotA_Pos = 0x8
	// Bit mask of SDIOIRQforSlotA field.
	HSMCI_IER_SDIOIRQforSlotA_Msk = 0x100
	// Bit SDIOIRQforSlotA.
	HSMCI_IER_SDIOIRQforSlotA = 0x100
	// Position of SDIOIRQforSlotB field.
	HSMCI_IER_SDIOIRQforSlotB_Pos = 0x9
	// Bit mask of SDIOIRQforSlotB field.
	HSMCI_IER_SDIOIRQforSlotB_Msk = 0x200
	// Bit SDIOIRQforSlotB.
	HSMCI_IER_SDIOIRQforSlotB = 0x200
	// Position of SDIOWAIT field.
	HSMCI_IER_SDIOWAIT_Pos = 0xc
	// Bit mask of SDIOWAIT field.
	HSMCI_IER_SDIOWAIT_Msk = 0x1000
	// Bit SDIOWAIT.
	HSMCI_IER_SDIOWAIT = 0x1000
	// Position of CSRCV field.
	HSMCI_IER_CSRCV_Pos = 0xd
	// Bit mask of CSRCV field.
	HSMCI_IER_CSRCV_Msk = 0x2000
	// Bit CSRCV.
	HSMCI_IER_CSRCV = 0x2000
	// Position of RINDE field.
	HSMCI_IER_RINDE_Pos = 0x10
	// Bit mask of RINDE field.
	HSMCI_IER_RINDE_Msk = 0x10000
	// Bit RINDE.
	HSMCI_IER_RINDE = 0x10000
	// Position of RDIRE field.
	HSMCI_IER_RDIRE_Pos = 0x11
	// Bit mask of RDIRE field.
	HSMCI_IER_RDIRE_Msk = 0x20000
	// Bit RDIRE.
	HSMCI_IER_RDIRE = 0x20000
	// Position of RCRCE field.
	HSMCI_IER_RCRCE_Pos = 0x12
	// Bit mask of RCRCE field.
	HSMCI_IER_RCRCE_Msk = 0x40000
	// Bit RCRCE.
	HSMCI_IER_RCRCE = 0x40000
	// Position of RENDE field.
	HSMCI_IER_RENDE_Pos = 0x13
	// Bit mask of RENDE field.
	HSMCI_IER_RENDE_Msk = 0x80000
	// Bit RENDE.
	HSMCI_IER_RENDE = 0x80000
	// Position of RTOE field.
	HSMCI_IER_RTOE_Pos = 0x14
	// Bit mask of RTOE field.
	HSMCI_IER_RTOE_Msk = 0x100000
	// Bit RTOE.
	HSMCI_IER_RTOE = 0x100000
	// Position of DCRCE field.
	HSMCI_IER_DCRCE_Pos = 0x15
	// Bit mask of DCRCE field.
	HSMCI_IER_DCRCE_Msk = 0x200000
	// Bit DCRCE.
	HSMCI_IER_DCRCE = 0x200000
	// Position of DTOE field.
	HSMCI_IER_DTOE_Pos = 0x16
	// Bit mask of DTOE field.
	HSMCI_IER_DTOE_Msk = 0x400000
	// Bit DTOE.
	HSMCI_IER_DTOE = 0x400000
	// Position of CSTOE field.
	HSMCI_IER_CSTOE_Pos = 0x17
	// Bit mask of CSTOE field.
	HSMCI_IER_CSTOE_Msk = 0x800000
	// Bit CSTOE.
	HSMCI_IER_CSTOE = 0x800000
	// Position of BLKOVRE field.
	HSMCI_IER_BLKOVRE_Pos = 0x18
	// Bit mask of BLKOVRE field.
	HSMCI_IER_BLKOVRE_Msk = 0x1000000
	// Bit BLKOVRE.
	HSMCI_IER_BLKOVRE = 0x1000000
	// Position of DMADONE field.
	HSMCI_IER_DMADONE_Pos = 0x19
	// Bit mask of DMADONE field.
	HSMCI_IER_DMADONE_Msk = 0x2000000
	// Bit DMADONE.
	HSMCI_IER_DMADONE = 0x2000000
	// Position of FIFOEMPTY field.
	HSMCI_IER_FIFOEMPTY_Pos = 0x1a
	// Bit mask of FIFOEMPTY field.
	HSMCI_IER_FIFOEMPTY_Msk = 0x4000000
	// Bit FIFOEMPTY.
	HSMCI_IER_FIFOEMPTY = 0x4000000
	// Position of XFRDONE field.
	HSMCI_IER_XFRDONE_Pos = 0x1b
	// Bit mask of XFRDONE field.
	HSMCI_IER_XFRDONE_Msk = 0x8000000
	// Bit XFRDONE.
	HSMCI_IER_XFRDONE = 0x8000000
	// Position of ACKRCV field.
	HSMCI_IER_ACKRCV_Pos = 0x1c
	// Bit mask of ACKRCV field.
	HSMCI_IER_ACKRCV_Msk = 0x10000000
	// Bit ACKRCV.
	HSMCI_IER_ACKRCV = 0x10000000
	// Position of ACKRCVE field.
	HSMCI_IER_ACKRCVE_Pos = 0x1d
	// Bit mask of ACKRCVE field.
	HSMCI_IER_ACKRCVE_Msk = 0x20000000
	// Bit ACKRCVE.
	HSMCI_IER_ACKRCVE = 0x20000000
	// Position of OVRE field.
	HSMCI_IER_OVRE_Pos = 0x1e
	// Bit mask of OVRE field.
	HSMCI_IER_OVRE_Msk = 0x40000000
	// Bit OVRE.
	HSMCI_IER_OVRE = 0x40000000
	// Position of UNRE field.
	HSMCI_IER_UNRE_Pos = 0x1f
	// Bit mask of UNRE field.
	HSMCI_IER_UNRE_Msk = 0x80000000
	// Bit UNRE.
	HSMCI_IER_UNRE = 0x80000000

	// IDR: Interrupt Disable Register
	// Position of CMDRDY field.
	HSMCI_IDR_CMDRDY_Pos = 0x0
	// Bit mask of CMDRDY field.
	HSMCI_IDR_CMDRDY_Msk = 0x1
	// Bit CMDRDY.
	HSMCI_IDR_CMDRDY = 0x1
	// Position of RXRDY field.
	HSMCI_IDR_RXRDY_Pos = 0x1
	// Bit mask of RXRDY field.
	HSMCI_IDR_RXRDY_Msk = 0x2
	// Bit RXRDY.
	HSMCI_IDR_RXRDY = 0x2
	// Position of TXRDY field.
	HSMCI_IDR_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	HSMCI_IDR_TXRDY_Msk = 0x4
	// Bit TXRDY.
	HSMCI_IDR_TXRDY = 0x4
	// Position of BLKE field.
	HSMCI_IDR_BLKE_Pos = 0x3
	// Bit mask of BLKE field.
	HSMCI_IDR_BLKE_Msk = 0x8
	// Bit BLKE.
	HSMCI_IDR_BLKE = 0x8
	// Position of DTIP field.
	HSMCI_IDR_DTIP_Pos = 0x4
	// Bit mask of DTIP field.
	HSMCI_IDR_DTIP_Msk = 0x10
	// Bit DTIP.
	HSMCI_IDR_DTIP = 0x10
	// Position of NOTBUSY field.
	HSMCI_IDR_NOTBUSY_Pos = 0x5
	// Bit mask of NOTBUSY field.
	HSMCI_IDR_NOTBUSY_Msk = 0x20
	// Bit NOTBUSY.
	HSMCI_IDR_NOTBUSY = 0x20
	// Position of SDIOIRQforSlotA field.
	HSMCI_IDR_SDIOIRQforSlotA_Pos = 0x8
	// Bit mask of SDIOIRQforSlotA field.
	HSMCI_IDR_SDIOIRQforSlotA_Msk = 0x100
	// Bit SDIOIRQforSlotA.
	HSMCI_IDR_SDIOIRQforSlotA = 0x100
	// Position of SDIOIRQforSlotB field.
	HSMCI_IDR_SDIOIRQforSlotB_Pos = 0x9
	// Bit mask of SDIOIRQforSlotB field.
	HSMCI_IDR_SDIOIRQforSlotB_Msk = 0x200
	// Bit SDIOIRQforSlotB.
	HSMCI_IDR_SDIOIRQforSlotB = 0x200
	// Position of SDIOWAIT field.
	HSMCI_IDR_SDIOWAIT_Pos = 0xc
	// Bit mask of SDIOWAIT field.
	HSMCI_IDR_SDIOWAIT_Msk = 0x1000
	// Bit SDIOWAIT.
	HSMCI_IDR_SDIOWAIT = 0x1000
	// Position of CSRCV field.
	HSMCI_IDR_CSRCV_Pos = 0xd
	// Bit mask of CSRCV field.
	HSMCI_IDR_CSRCV_Msk = 0x2000
	// Bit CSRCV.
	HSMCI_IDR_CSRCV = 0x2000
	// Position of RINDE field.
	HSMCI_IDR_RINDE_Pos = 0x10
	// Bit mask of RINDE field.
	HSMCI_IDR_RINDE_Msk = 0x10000
	// Bit RINDE.
	HSMCI_IDR_RINDE = 0x10000
	// Position of RDIRE field.
	HSMCI_IDR_RDIRE_Pos = 0x11
	// Bit mask of RDIRE field.
	HSMCI_IDR_RDIRE_Msk = 0x20000
	// Bit RDIRE.
	HSMCI_IDR_RDIRE = 0x20000
	// Position of RCRCE field.
	HSMCI_IDR_RCRCE_Pos = 0x12
	// Bit mask of RCRCE field.
	HSMCI_IDR_RCRCE_Msk = 0x40000
	// Bit RCRCE.
	HSMCI_IDR_RCRCE = 0x40000
	// Position of RENDE field.
	HSMCI_IDR_RENDE_Pos = 0x13
	// Bit mask of RENDE field.
	HSMCI_IDR_RENDE_Msk = 0x80000
	// Bit RENDE.
	HSMCI_IDR_RENDE = 0x80000
	// Position of RTOE field.
	HSMCI_IDR_RTOE_Pos = 0x14
	// Bit mask of RTOE field.
	HSMCI_IDR_RTOE_Msk = 0x100000
	// Bit RTOE.
	HSMCI_IDR_RTOE = 0x100000
	// Position of DCRCE field.
	HSMCI_IDR_DCRCE_Pos = 0x15
	// Bit mask of DCRCE field.
	HSMCI_IDR_DCRCE_Msk = 0x200000
	// Bit DCRCE.
	HSMCI_IDR_DCRCE = 0x200000
	// Position of DTOE field.
	HSMCI_IDR_DTOE_Pos = 0x16
	// Bit mask of DTOE field.
	HSMCI_IDR_DTOE_Msk = 0x400000
	// Bit DTOE.
	HSMCI_IDR_DTOE = 0x400000
	// Position of CSTOE field.
	HSMCI_IDR_CSTOE_Pos = 0x17
	// Bit mask of CSTOE field.
	HSMCI_IDR_CSTOE_Msk = 0x800000
	// Bit CSTOE.
	HSMCI_IDR_CSTOE = 0x800000
	// Position of BLKOVRE field.
	HSMCI_IDR_BLKOVRE_Pos = 0x18
	// Bit mask of BLKOVRE field.
	HSMCI_IDR_BLKOVRE_Msk = 0x1000000
	// Bit BLKOVRE.
	HSMCI_IDR_BLKOVRE = 0x1000000
	// Position of DMADONE field.
	HSMCI_IDR_DMADONE_Pos = 0x19
	// Bit mask of DMADONE field.
	HSMCI_IDR_DMADONE_Msk = 0x2000000
	// Bit DMADONE.
	HSMCI_IDR_DMADONE = 0x2000000
	// Position of FIFOEMPTY field.
	HSMCI_IDR_FIFOEMPTY_Pos = 0x1a
	// Bit mask of FIFOEMPTY field.
	HSMCI_IDR_FIFOEMPTY_Msk = 0x4000000
	// Bit FIFOEMPTY.
	HSMCI_IDR_FIFOEMPTY = 0x4000000
	// Position of XFRDONE field.
	HSMCI_IDR_XFRDONE_Pos = 0x1b
	// Bit mask of XFRDONE field.
	HSMCI_IDR_XFRDONE_Msk = 0x8000000
	// Bit XFRDONE.
	HSMCI_IDR_XFRDONE = 0x8000000
	// Position of ACKRCV field.
	HSMCI_IDR_ACKRCV_Pos = 0x1c
	// Bit mask of ACKRCV field.
	HSMCI_IDR_ACKRCV_Msk = 0x10000000
	// Bit ACKRCV.
	HSMCI_IDR_ACKRCV = 0x10000000
	// Position of ACKRCVE field.
	HSMCI_IDR_ACKRCVE_Pos = 0x1d
	// Bit mask of ACKRCVE field.
	HSMCI_IDR_ACKRCVE_Msk = 0x20000000
	// Bit ACKRCVE.
	HSMCI_IDR_ACKRCVE = 0x20000000
	// Position of OVRE field.
	HSMCI_IDR_OVRE_Pos = 0x1e
	// Bit mask of OVRE field.
	HSMCI_IDR_OVRE_Msk = 0x40000000
	// Bit OVRE.
	HSMCI_IDR_OVRE = 0x40000000
	// Position of UNRE field.
	HSMCI_IDR_UNRE_Pos = 0x1f
	// Bit mask of UNRE field.
	HSMCI_IDR_UNRE_Msk = 0x80000000
	// Bit UNRE.
	HSMCI_IDR_UNRE = 0x80000000

	// IMR: Interrupt Mask Register
	// Position of CMDRDY field.
	HSMCI_IMR_CMDRDY_Pos = 0x0
	// Bit mask of CMDRDY field.
	HSMCI_IMR_CMDRDY_Msk = 0x1
	// Bit CMDRDY.
	HSMCI_IMR_CMDRDY = 0x1
	// Position of RXRDY field.
	HSMCI_IMR_RXRDY_Pos = 0x1
	// Bit mask of RXRDY field.
	HSMCI_IMR_RXRDY_Msk = 0x2
	// Bit RXRDY.
	HSMCI_IMR_RXRDY = 0x2
	// Position of TXRDY field.
	HSMCI_IMR_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	HSMCI_IMR_TXRDY_Msk = 0x4
	// Bit TXRDY.
	HSMCI_IMR_TXRDY = 0x4
	// Position of BLKE field.
	HSMCI_IMR_BLKE_Pos = 0x3
	// Bit mask of BLKE field.
	HSMCI_IMR_BLKE_Msk = 0x8
	// Bit BLKE.
	HSMCI_IMR_BLKE = 0x8
	// Position of DTIP field.
	HSMCI_IMR_DTIP_Pos = 0x4
	// Bit mask of DTIP field.
	HSMCI_IMR_DTIP_Msk = 0x10
	// Bit DTIP.
	HSMCI_IMR_DTIP = 0x10
	// Position of NOTBUSY field.
	HSMCI_IMR_NOTBUSY_Pos = 0x5
	// Bit mask of NOTBUSY field.
	HSMCI_IMR_NOTBUSY_Msk = 0x20
	// Bit NOTBUSY.
	HSMCI_IMR_NOTBUSY = 0x20
	// Position of SDIOIRQforSlotA field.
	HSMCI_IMR_SDIOIRQforSlotA_Pos = 0x8
	// Bit mask of SDIOIRQforSlotA field.
	HSMCI_IMR_SDIOIRQforSlotA_Msk = 0x100
	// Bit SDIOIRQforSlotA.
	HSMCI_IMR_SDIOIRQforSlotA = 0x100
	// Position of SDIOIRQforSlotB field.
	HSMCI_IMR_SDIOIRQforSlotB_Pos = 0x9
	// Bit mask of SDIOIRQforSlotB field.
	HSMCI_IMR_SDIOIRQforSlotB_Msk = 0x200
	// Bit SDIOIRQforSlotB.
	HSMCI_IMR_SDIOIRQforSlotB = 0x200
	// Position of SDIOWAIT field.
	HSMCI_IMR_SDIOWAIT_Pos = 0xc
	// Bit mask of SDIOWAIT field.
	HSMCI_IMR_SDIOWAIT_Msk = 0x1000
	// Bit SDIOWAIT.
	HSMCI_IMR_SDIOWAIT = 0x1000
	// Position of CSRCV field.
	HSMCI_IMR_CSRCV_Pos = 0xd
	// Bit mask of CSRCV field.
	HSMCI_IMR_CSRCV_Msk = 0x2000
	// Bit CSRCV.
	HSMCI_IMR_CSRCV = 0x2000
	// Position of RINDE field.
	HSMCI_IMR_RINDE_Pos = 0x10
	// Bit mask of RINDE field.
	HSMCI_IMR_RINDE_Msk = 0x10000
	// Bit RINDE.
	HSMCI_IMR_RINDE = 0x10000
	// Position of RDIRE field.
	HSMCI_IMR_RDIRE_Pos = 0x11
	// Bit mask of RDIRE field.
	HSMCI_IMR_RDIRE_Msk = 0x20000
	// Bit RDIRE.
	HSMCI_IMR_RDIRE = 0x20000
	// Position of RCRCE field.
	HSMCI_IMR_RCRCE_Pos = 0x12
	// Bit mask of RCRCE field.
	HSMCI_IMR_RCRCE_Msk = 0x40000
	// Bit RCRCE.
	HSMCI_IMR_RCRCE = 0x40000
	// Position of RENDE field.
	HSMCI_IMR_RENDE_Pos = 0x13
	// Bit mask of RENDE field.
	HSMCI_IMR_RENDE_Msk = 0x80000
	// Bit RENDE.
	HSMCI_IMR_RENDE = 0x80000
	// Position of RTOE field.
	HSMCI_IMR_RTOE_Pos = 0x14
	// Bit mask of RTOE field.
	HSMCI_IMR_RTOE_Msk = 0x100000
	// Bit RTOE.
	HSMCI_IMR_RTOE = 0x100000
	// Position of DCRCE field.
	HSMCI_IMR_DCRCE_Pos = 0x15
	// Bit mask of DCRCE field.
	HSMCI_IMR_DCRCE_Msk = 0x200000
	// Bit DCRCE.
	HSMCI_IMR_DCRCE = 0x200000
	// Position of DTOE field.
	HSMCI_IMR_DTOE_Pos = 0x16
	// Bit mask of DTOE field.
	HSMCI_IMR_DTOE_Msk = 0x400000
	// Bit DTOE.
	HSMCI_IMR_DTOE = 0x400000
	// Position of CSTOE field.
	HSMCI_IMR_CSTOE_Pos = 0x17
	// Bit mask of CSTOE field.
	HSMCI_IMR_CSTOE_Msk = 0x800000
	// Bit CSTOE.
	HSMCI_IMR_CSTOE = 0x800000
	// Position of BLKOVRE field.
	HSMCI_IMR_BLKOVRE_Pos = 0x18
	// Bit mask of BLKOVRE field.
	HSMCI_IMR_BLKOVRE_Msk = 0x1000000
	// Bit BLKOVRE.
	HSMCI_IMR_BLKOVRE = 0x1000000
	// Position of DMADONE field.
	HSMCI_IMR_DMADONE_Pos = 0x19
	// Bit mask of DMADONE field.
	HSMCI_IMR_DMADONE_Msk = 0x2000000
	// Bit DMADONE.
	HSMCI_IMR_DMADONE = 0x2000000
	// Position of FIFOEMPTY field.
	HSMCI_IMR_FIFOEMPTY_Pos = 0x1a
	// Bit mask of FIFOEMPTY field.
	HSMCI_IMR_FIFOEMPTY_Msk = 0x4000000
	// Bit FIFOEMPTY.
	HSMCI_IMR_FIFOEMPTY = 0x4000000
	// Position of XFRDONE field.
	HSMCI_IMR_XFRDONE_Pos = 0x1b
	// Bit mask of XFRDONE field.
	HSMCI_IMR_XFRDONE_Msk = 0x8000000
	// Bit XFRDONE.
	HSMCI_IMR_XFRDONE = 0x8000000
	// Position of ACKRCV field.
	HSMCI_IMR_ACKRCV_Pos = 0x1c
	// Bit mask of ACKRCV field.
	HSMCI_IMR_ACKRCV_Msk = 0x10000000
	// Bit ACKRCV.
	HSMCI_IMR_ACKRCV = 0x10000000
	// Position of ACKRCVE field.
	HSMCI_IMR_ACKRCVE_Pos = 0x1d
	// Bit mask of ACKRCVE field.
	HSMCI_IMR_ACKRCVE_Msk = 0x20000000
	// Bit ACKRCVE.
	HSMCI_IMR_ACKRCVE = 0x20000000
	// Position of OVRE field.
	HSMCI_IMR_OVRE_Pos = 0x1e
	// Bit mask of OVRE field.
	HSMCI_IMR_OVRE_Msk = 0x40000000
	// Bit OVRE.
	HSMCI_IMR_OVRE = 0x40000000
	// Position of UNRE field.
	HSMCI_IMR_UNRE_Pos = 0x1f
	// Bit mask of UNRE field.
	HSMCI_IMR_UNRE_Msk = 0x80000000
	// Bit UNRE.
	HSMCI_IMR_UNRE = 0x80000000

	// DMA: DMA Configuration Register
	// Position of OFFSET field.
	HSMCI_DMA_OFFSET_Pos = 0x0
	// Bit mask of OFFSET field.
	HSMCI_DMA_OFFSET_Msk = 0x3
	// Position of CHKSIZE field.
	HSMCI_DMA_CHKSIZE_Pos = 0x4
	// Bit mask of CHKSIZE field.
	HSMCI_DMA_CHKSIZE_Msk = 0x10
	// Bit CHKSIZE.
	HSMCI_DMA_CHKSIZE = 0x10
	// 1 data available
	HSMCI_DMA_CHKSIZE_1 = 0x0
	// 4 data available
	HSMCI_DMA_CHKSIZE_4 = 0x1
	// Position of DMAEN field.
	HSMCI_DMA_DMAEN_Pos = 0x8
	// Bit mask of DMAEN field.
	HSMCI_DMA_DMAEN_Msk = 0x100
	// Bit DMAEN.
	HSMCI_DMA_DMAEN = 0x100
	// Position of ROPT field.
	HSMCI_DMA_ROPT_Pos = 0xc
	// Bit mask of ROPT field.
	HSMCI_DMA_ROPT_Msk = 0x1000
	// Bit ROPT.
	HSMCI_DMA_ROPT = 0x1000

	// CFG: Configuration Register
	// Position of FIFOMODE field.
	HSMCI_CFG_FIFOMODE_Pos = 0x0
	// Bit mask of FIFOMODE field.
	HSMCI_CFG_FIFOMODE_Msk = 0x1
	// Bit FIFOMODE.
	HSMCI_CFG_FIFOMODE = 0x1
	// Position of FERRCTRL field.
	HSMCI_CFG_FERRCTRL_Pos = 0x4
	// Bit mask of FERRCTRL field.
	HSMCI_CFG_FERRCTRL_Msk = 0x10
	// Bit FERRCTRL.
	HSMCI_CFG_FERRCTRL = 0x10
	// Position of HSMODE field.
	HSMCI_CFG_HSMODE_Pos = 0x8
	// Bit mask of HSMODE field.
	HSMCI_CFG_HSMODE_Msk = 0x100
	// Bit HSMODE.
	HSMCI_CFG_HSMODE = 0x100
	// Position of LSYNC field.
	HSMCI_CFG_LSYNC_Pos = 0xc
	// Bit mask of LSYNC field.
	HSMCI_CFG_LSYNC_Msk = 0x1000
	// Bit LSYNC.
	HSMCI_CFG_LSYNC = 0x1000

	// WPMR: Write Protection Mode Register
	// Position of WPEN field.
	HSMCI_WPMR_WPEN_Pos = 0x0
	// Bit mask of WPEN field.
	HSMCI_WPMR_WPEN_Msk = 0x1
	// Bit WPEN.
	HSMCI_WPMR_WPEN = 0x1
	// Position of WPKEY field.
	HSMCI_WPMR_WPKEY_Pos = 0x8
	// Bit mask of WPKEY field.
	HSMCI_WPMR_WPKEY_Msk = 0xffffff00
	// Writing any other value in this field aborts the write operation of the WPEN bit.Always reads as 0.
	HSMCI_WPMR_WPKEY_PASSWD = 0x4d4349

	// WPSR: Write Protection Status Register
	// Position of WPVS field.
	HSMCI_WPSR_WPVS_Pos = 0x0
	// Bit mask of WPVS field.
	HSMCI_WPSR_WPVS_Msk = 0x1
	// Bit WPVS.
	HSMCI_WPSR_WPVS = 0x1
	// Position of WPVSRC field.
	HSMCI_WPSR_WPVSRC_Pos = 0x8
	// Bit mask of WPVSRC field.
	HSMCI_WPSR_WPVSRC_Msk = 0xffff00

	// FIFO: FIFO Memory Aperture0
	// Position of DATA field.
	HSMCI_FIFO_DATA_Pos = 0x0
	// Bit mask of DATA field.
	HSMCI_FIFO_DATA_Msk = 0xffffffff
)

// Bitfields for SSC: Synchronous Serial Controller
const (
	// CR: Control Register
	// Position of RXEN field.
	SSC_CR_RXEN_Pos = 0x0
	// Bit mask of RXEN field.
	SSC_CR_RXEN_Msk = 0x1
	// Bit RXEN.
	SSC_CR_RXEN = 0x1
	// Position of RXDIS field.
	SSC_CR_RXDIS_Pos = 0x1
	// Bit mask of RXDIS field.
	SSC_CR_RXDIS_Msk = 0x2
	// Bit RXDIS.
	SSC_CR_RXDIS = 0x2
	// Position of TXEN field.
	SSC_CR_TXEN_Pos = 0x8
	// Bit mask of TXEN field.
	SSC_CR_TXEN_Msk = 0x100
	// Bit TXEN.
	SSC_CR_TXEN = 0x100
	// Position of TXDIS field.
	SSC_CR_TXDIS_Pos = 0x9
	// Bit mask of TXDIS field.
	SSC_CR_TXDIS_Msk = 0x200
	// Bit TXDIS.
	SSC_CR_TXDIS = 0x200
	// Position of SWRST field.
	SSC_CR_SWRST_Pos = 0xf
	// Bit mask of SWRST field.
	SSC_CR_SWRST_Msk = 0x8000
	// Bit SWRST.
	SSC_CR_SWRST = 0x8000

	// CMR: Clock Mode Register
	// Position of DIV field.
	SSC_CMR_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SSC_CMR_DIV_Msk = 0xfff

	// RCMR: Receive Clock Mode Register
	// Position of CKS field.
	SSC_RCMR_CKS_Pos = 0x0
	// Bit mask of CKS field.
	SSC_RCMR_CKS_Msk = 0x3
	// Divided Clock
	SSC_RCMR_CKS_MCK = 0x0
	// TK Clock signal
	SSC_RCMR_CKS_TK = 0x1
	// RK pin
	SSC_RCMR_CKS_RK = 0x2
	// Position of CKO field.
	SSC_RCMR_CKO_Pos = 0x2
	// Bit mask of CKO field.
	SSC_RCMR_CKO_Msk = 0x1c
	// None, RK pin is an input
	SSC_RCMR_CKO_NONE = 0x0
	// Continuous Receive Clock, RK pin is an output
	SSC_RCMR_CKO_CONTINUOUS = 0x1
	// Receive Clock only during data transfers, RK pin is an output
	SSC_RCMR_CKO_TRANSFER = 0x2
	// Position of CKI field.
	SSC_RCMR_CKI_Pos = 0x5
	// Bit mask of CKI field.
	SSC_RCMR_CKI_Msk = 0x20
	// Bit CKI.
	SSC_RCMR_CKI = 0x20
	// Position of CKG field.
	SSC_RCMR_CKG_Pos = 0x6
	// Bit mask of CKG field.
	SSC_RCMR_CKG_Msk = 0xc0
	// None
	SSC_RCMR_CKG_CONTINUOUS = 0x0
	// Receive Clock enabled only if RF Low
	SSC_RCMR_CKG_EN_RF_LOW = 0x1
	// Receive Clock enabled only if RF High
	SSC_RCMR_CKG_EN_RF_HIGH = 0x2
	// Position of START field.
	SSC_RCMR_START_Pos = 0x8
	// Bit mask of START field.
	SSC_RCMR_START_Msk = 0xf00
	// Continuous, as soon as the receiver is enabled, and immediately after the end of transfer of the previous data.
	SSC_RCMR_START_CONTINUOUS = 0x0
	// Transmit start
	SSC_RCMR_START_TRANSMIT = 0x1
	// Detection of a low level on RF signal
	SSC_RCMR_START_RF_LOW = 0x2
	// Detection of a high level on RF signal
	SSC_RCMR_START_RF_HIGH = 0x3
	// Detection of a falling edge on RF signal
	SSC_RCMR_START_RF_FALLING = 0x4
	// Detection of a rising edge on RF signal
	SSC_RCMR_START_RF_RISING = 0x5
	// Detection of any level change on RF signal
	SSC_RCMR_START_RF_LEVEL = 0x6
	// Detection of any edge on RF signal
	SSC_RCMR_START_RF_EDGE = 0x7
	// Compare 0
	SSC_RCMR_START_CMP_0 = 0x8
	// Position of STOP field.
	SSC_RCMR_STOP_Pos = 0xc
	// Bit mask of STOP field.
	SSC_RCMR_STOP_Msk = 0x1000
	// Bit STOP.
	SSC_RCMR_STOP = 0x1000
	// Position of STTDLY field.
	SSC_RCMR_STTDLY_Pos = 0x10
	// Bit mask of STTDLY field.
	SSC_RCMR_STTDLY_Msk = 0xff0000
	// Position of PERIOD field.
	SSC_RCMR_PERIOD_Pos = 0x18
	// Bit mask of PERIOD field.
	SSC_RCMR_PERIOD_Msk = 0xff000000

	// RFMR: Receive Frame Mode Register
	// Position of DATLEN field.
	SSC_RFMR_DATLEN_Pos = 0x0
	// Bit mask of DATLEN field.
	SSC_RFMR_DATLEN_Msk = 0x1f
	// Position of LOOP field.
	SSC_RFMR_LOOP_Pos = 0x5
	// Bit mask of LOOP field.
	SSC_RFMR_LOOP_Msk = 0x20
	// Bit LOOP.
	SSC_RFMR_LOOP = 0x20
	// Position of MSBF field.
	SSC_RFMR_MSBF_Pos = 0x7
	// Bit mask of MSBF field.
	SSC_RFMR_MSBF_Msk = 0x80
	// Bit MSBF.
	SSC_RFMR_MSBF = 0x80
	// Position of DATNB field.
	SSC_RFMR_DATNB_Pos = 0x8
	// Bit mask of DATNB field.
	SSC_RFMR_DATNB_Msk = 0xf00
	// Position of FSLEN field.
	SSC_RFMR_FSLEN_Pos = 0x10
	// Bit mask of FSLEN field.
	SSC_RFMR_FSLEN_Msk = 0xf0000
	// Position of FSOS field.
	SSC_RFMR_FSOS_Pos = 0x14
	// Bit mask of FSOS field.
	SSC_RFMR_FSOS_Msk = 0x700000
	// None, RF pin is an input
	SSC_RFMR_FSOS_NONE = 0x0
	// Negative Pulse, RF pin is an output
	SSC_RFMR_FSOS_NEGATIVE = 0x1
	// Positive Pulse, RF pin is an output
	SSC_RFMR_FSOS_POSITIVE = 0x2
	// Driven Low during data transfer, RF pin is an output
	SSC_RFMR_FSOS_LOW = 0x3
	// Driven High during data transfer, RF pin is an output
	SSC_RFMR_FSOS_HIGH = 0x4
	// Toggling at each start of data transfer, RF pin is an output
	SSC_RFMR_FSOS_TOGGLING = 0x5
	// Position of FSEDGE field.
	SSC_RFMR_FSEDGE_Pos = 0x18
	// Bit mask of FSEDGE field.
	SSC_RFMR_FSEDGE_Msk = 0x1000000
	// Bit FSEDGE.
	SSC_RFMR_FSEDGE = 0x1000000
	// Positive Edge Detection
	SSC_RFMR_FSEDGE_POSITIVE = 0x0
	// Negative Edge Detection
	SSC_RFMR_FSEDGE_NEGATIVE = 0x1
	// Position of FSLEN_EXT field.
	SSC_RFMR_FSLEN_EXT_Pos = 0x1c
	// Bit mask of FSLEN_EXT field.
	SSC_RFMR_FSLEN_EXT_Msk = 0xf0000000

	// TCMR: Transmit Clock Mode Register
	// Position of CKS field.
	SSC_TCMR_CKS_Pos = 0x0
	// Bit mask of CKS field.
	SSC_TCMR_CKS_Msk = 0x3
	// Divided Clock
	SSC_TCMR_CKS_MCK = 0x0
	// RK Clock signal
	SSC_TCMR_CKS_RK = 0x1
	// TK pin
	SSC_TCMR_CKS_TK = 0x2
	// Position of CKO field.
	SSC_TCMR_CKO_Pos = 0x2
	// Bit mask of CKO field.
	SSC_TCMR_CKO_Msk = 0x1c
	// None, TK pin is an input
	SSC_TCMR_CKO_NONE = 0x0
	// Continuous Transmit Clock, TK pin is an output
	SSC_TCMR_CKO_CONTINUOUS = 0x1
	// Transmit Clock only during data transfers, TK pin is an output
	SSC_TCMR_CKO_TRANSFER = 0x2
	// Position of CKI field.
	SSC_TCMR_CKI_Pos = 0x5
	// Bit mask of CKI field.
	SSC_TCMR_CKI_Msk = 0x20
	// Bit CKI.
	SSC_TCMR_CKI = 0x20
	// Position of CKG field.
	SSC_TCMR_CKG_Pos = 0x6
	// Bit mask of CKG field.
	SSC_TCMR_CKG_Msk = 0xc0
	// None
	SSC_TCMR_CKG_CONTINUOUS = 0x0
	// Transmit Clock enabled only if TF Low
	SSC_TCMR_CKG_EN_TF_LOW = 0x1
	// Transmit Clock enabled only if TF High
	SSC_TCMR_CKG_EN_TF_HIGH = 0x2
	// Position of START field.
	SSC_TCMR_START_Pos = 0x8
	// Bit mask of START field.
	SSC_TCMR_START_Msk = 0xf00
	// Continuous, as soon as a word is written in the SSC_THR Register (if Transmit is enabled), and immediately after the end of transfer of the previous data
	SSC_TCMR_START_CONTINUOUS = 0x0
	// Receive start
	SSC_TCMR_START_RECEIVE = 0x1
	// Detection of a low level on TF signal
	SSC_TCMR_START_TF_LOW = 0x2
	// Detection of a high level on TF signal
	SSC_TCMR_START_TF_HIGH = 0x3
	// Detection of a falling edge on TF signal
	SSC_TCMR_START_TF_FALLING = 0x4
	// Detection of a rising edge on TF signal
	SSC_TCMR_START_TF_RISING = 0x5
	// Detection of any level change on TF signal
	SSC_TCMR_START_TF_LEVEL = 0x6
	// Detection of any edge on TF signal
	SSC_TCMR_START_TF_EDGE = 0x7
	// Position of STTDLY field.
	SSC_TCMR_STTDLY_Pos = 0x10
	// Bit mask of STTDLY field.
	SSC_TCMR_STTDLY_Msk = 0xff0000
	// Position of PERIOD field.
	SSC_TCMR_PERIOD_Pos = 0x18
	// Bit mask of PERIOD field.
	SSC_TCMR_PERIOD_Msk = 0xff000000

	// TFMR: Transmit Frame Mode Register
	// Position of DATLEN field.
	SSC_TFMR_DATLEN_Pos = 0x0
	// Bit mask of DATLEN field.
	SSC_TFMR_DATLEN_Msk = 0x1f
	// Position of DATDEF field.
	SSC_TFMR_DATDEF_Pos = 0x5
	// Bit mask of DATDEF field.
	SSC_TFMR_DATDEF_Msk = 0x20
	// Bit DATDEF.
	SSC_TFMR_DATDEF = 0x20
	// Position of MSBF field.
	SSC_TFMR_MSBF_Pos = 0x7
	// Bit mask of MSBF field.
	SSC_TFMR_MSBF_Msk = 0x80
	// Bit MSBF.
	SSC_TFMR_MSBF = 0x80
	// Position of DATNB field.
	SSC_TFMR_DATNB_Pos = 0x8
	// Bit mask of DATNB field.
	SSC_TFMR_DATNB_Msk = 0xf00
	// Position of FSLEN field.
	SSC_TFMR_FSLEN_Pos = 0x10
	// Bit mask of FSLEN field.
	SSC_TFMR_FSLEN_Msk = 0xf0000
	// Position of FSOS field.
	SSC_TFMR_FSOS_Pos = 0x14
	// Bit mask of FSOS field.
	SSC_TFMR_FSOS_Msk = 0x700000
	// None, RF pin is an input
	SSC_TFMR_FSOS_NONE = 0x0
	// Negative Pulse, RF pin is an output
	SSC_TFMR_FSOS_NEGATIVE = 0x1
	// Positive Pulse, RF pin is an output
	SSC_TFMR_FSOS_POSITIVE = 0x2
	// Driven Low during data transfer
	SSC_TFMR_FSOS_LOW = 0x3
	// Driven High during data transfer
	SSC_TFMR_FSOS_HIGH = 0x4
	// Toggling at each start of data transfer
	SSC_TFMR_FSOS_TOGGLING = 0x5
	// Position of FSDEN field.
	SSC_TFMR_FSDEN_Pos = 0x17
	// Bit mask of FSDEN field.
	SSC_TFMR_FSDEN_Msk = 0x800000
	// Bit FSDEN.
	SSC_TFMR_FSDEN = 0x800000
	// Position of FSEDGE field.
	SSC_TFMR_FSEDGE_Pos = 0x18
	// Bit mask of FSEDGE field.
	SSC_TFMR_FSEDGE_Msk = 0x1000000
	// Bit FSEDGE.
	SSC_TFMR_FSEDGE = 0x1000000
	// Positive Edge Detection
	SSC_TFMR_FSEDGE_POSITIVE = 0x0
	// Negative Edge Detection
	SSC_TFMR_FSEDGE_NEGATIVE = 0x1
	// Position of FSLEN_EXT field.
	SSC_TFMR_FSLEN_EXT_Pos = 0x1c
	// Bit mask of FSLEN_EXT field.
	SSC_TFMR_FSLEN_EXT_Msk = 0xf0000000

	// RHR: Receive Holding Register
	// Position of RDAT field.
	SSC_RHR_RDAT_Pos = 0x0
	// Bit mask of RDAT field.
	SSC_RHR_RDAT_Msk = 0xffffffff

	// THR: Transmit Holding Register
	// Position of TDAT field.
	SSC_THR_TDAT_Pos = 0x0
	// Bit mask of TDAT field.
	SSC_THR_TDAT_Msk = 0xffffffff

	// RSHR: Receive Sync. Holding Register
	// Position of RSDAT field.
	SSC_RSHR_RSDAT_Pos = 0x0
	// Bit mask of RSDAT field.
	SSC_RSHR_RSDAT_Msk = 0xffff

	// TSHR: Transmit Sync. Holding Register
	// Position of TSDAT field.
	SSC_TSHR_TSDAT_Pos = 0x0
	// Bit mask of TSDAT field.
	SSC_TSHR_TSDAT_Msk = 0xffff

	// RC0R: Receive Compare 0 Register
	// Position of CP0 field.
	SSC_RC0R_CP0_Pos = 0x0
	// Bit mask of CP0 field.
	SSC_RC0R_CP0_Msk = 0xffff

	// RC1R: Receive Compare 1 Register
	// Position of CP1 field.
	SSC_RC1R_CP1_Pos = 0x0
	// Bit mask of CP1 field.
	SSC_RC1R_CP1_Msk = 0xffff

	// SR: Status Register
	// Position of TXRDY field.
	SSC_SR_TXRDY_Pos = 0x0
	// Bit mask of TXRDY field.
	SSC_SR_TXRDY_Msk = 0x1
	// Bit TXRDY.
	SSC_SR_TXRDY = 0x1
	// Position of TXEMPTY field.
	SSC_SR_TXEMPTY_Pos = 0x1
	// Bit mask of TXEMPTY field.
	SSC_SR_TXEMPTY_Msk = 0x2
	// Bit TXEMPTY.
	SSC_SR_TXEMPTY = 0x2
	// Position of RXRDY field.
	SSC_SR_RXRDY_Pos = 0x4
	// Bit mask of RXRDY field.
	SSC_SR_RXRDY_Msk = 0x10
	// Bit RXRDY.
	SSC_SR_RXRDY = 0x10
	// Position of OVRUN field.
	SSC_SR_OVRUN_Pos = 0x5
	// Bit mask of OVRUN field.
	SSC_SR_OVRUN_Msk = 0x20
	// Bit OVRUN.
	SSC_SR_OVRUN = 0x20
	// Position of CP0 field.
	SSC_SR_CP0_Pos = 0x8
	// Bit mask of CP0 field.
	SSC_SR_CP0_Msk = 0x100
	// Bit CP0.
	SSC_SR_CP0 = 0x100
	// Position of CP1 field.
	SSC_SR_CP1_Pos = 0x9
	// Bit mask of CP1 field.
	SSC_SR_CP1_Msk = 0x200
	// Bit CP1.
	SSC_SR_CP1 = 0x200
	// Position of TXSYN field.
	SSC_SR_TXSYN_Pos = 0xa
	// Bit mask of TXSYN field.
	SSC_SR_TXSYN_Msk = 0x400
	// Bit TXSYN.
	SSC_SR_TXSYN = 0x400
	// Position of RXSYN field.
	SSC_SR_RXSYN_Pos = 0xb
	// Bit mask of RXSYN field.
	SSC_SR_RXSYN_Msk = 0x800
	// Bit RXSYN.
	SSC_SR_RXSYN = 0x800
	// Position of TXEN field.
	SSC_SR_TXEN_Pos = 0x10
	// Bit mask of TXEN field.
	SSC_SR_TXEN_Msk = 0x10000
	// Bit TXEN.
	SSC_SR_TXEN = 0x10000
	// Position of RXEN field.
	SSC_SR_RXEN_Pos = 0x11
	// Bit mask of RXEN field.
	SSC_SR_RXEN_Msk = 0x20000
	// Bit RXEN.
	SSC_SR_RXEN = 0x20000

	// IER: Interrupt Enable Register
	// Position of TXRDY field.
	SSC_IER_TXRDY_Pos = 0x0
	// Bit mask of TXRDY field.
	SSC_IER_TXRDY_Msk = 0x1
	// Bit TXRDY.
	SSC_IER_TXRDY = 0x1
	// Position of TXEMPTY field.
	SSC_IER_TXEMPTY_Pos = 0x1
	// Bit mask of TXEMPTY field.
	SSC_IER_TXEMPTY_Msk = 0x2
	// Bit TXEMPTY.
	SSC_IER_TXEMPTY = 0x2
	// Position of RXRDY field.
	SSC_IER_RXRDY_Pos = 0x4
	// Bit mask of RXRDY field.
	SSC_IER_RXRDY_Msk = 0x10
	// Bit RXRDY.
	SSC_IER_RXRDY = 0x10
	// Position of OVRUN field.
	SSC_IER_OVRUN_Pos = 0x5
	// Bit mask of OVRUN field.
	SSC_IER_OVRUN_Msk = 0x20
	// Bit OVRUN.
	SSC_IER_OVRUN = 0x20
	// Position of CP0 field.
	SSC_IER_CP0_Pos = 0x8
	// Bit mask of CP0 field.
	SSC_IER_CP0_Msk = 0x100
	// Bit CP0.
	SSC_IER_CP0 = 0x100
	// Position of CP1 field.
	SSC_IER_CP1_Pos = 0x9
	// Bit mask of CP1 field.
	SSC_IER_CP1_Msk = 0x200
	// Bit CP1.
	SSC_IER_CP1 = 0x200
	// Position of TXSYN field.
	SSC_IER_TXSYN_Pos = 0xa
	// Bit mask of TXSYN field.
	SSC_IER_TXSYN_Msk = 0x400
	// Bit TXSYN.
	SSC_IER_TXSYN = 0x400
	// Position of RXSYN field.
	SSC_IER_RXSYN_Pos = 0xb
	// Bit mask of RXSYN field.
	SSC_IER_RXSYN_Msk = 0x800
	// Bit RXSYN.
	SSC_IER_RXSYN = 0x800

	// IDR: Interrupt Disable Register
	// Position of TXRDY field.
	SSC_IDR_TXRDY_Pos = 0x0
	// Bit mask of TXRDY field.
	SSC_IDR_TXRDY_Msk = 0x1
	// Bit TXRDY.
	SSC_IDR_TXRDY = 0x1
	// Position of TXEMPTY field.
	SSC_IDR_TXEMPTY_Pos = 0x1
	// Bit mask of TXEMPTY field.
	SSC_IDR_TXEMPTY_Msk = 0x2
	// Bit TXEMPTY.
	SSC_IDR_TXEMPTY = 0x2
	// Position of RXRDY field.
	SSC_IDR_RXRDY_Pos = 0x4
	// Bit mask of RXRDY field.
	SSC_IDR_RXRDY_Msk = 0x10
	// Bit RXRDY.
	SSC_IDR_RXRDY = 0x10
	// Position of OVRUN field.
	SSC_IDR_OVRUN_Pos = 0x5
	// Bit mask of OVRUN field.
	SSC_IDR_OVRUN_Msk = 0x20
	// Bit OVRUN.
	SSC_IDR_OVRUN = 0x20
	// Position of CP0 field.
	SSC_IDR_CP0_Pos = 0x8
	// Bit mask of CP0 field.
	SSC_IDR_CP0_Msk = 0x100
	// Bit CP0.
	SSC_IDR_CP0 = 0x100
	// Position of CP1 field.
	SSC_IDR_CP1_Pos = 0x9
	// Bit mask of CP1 field.
	SSC_IDR_CP1_Msk = 0x200
	// Bit CP1.
	SSC_IDR_CP1 = 0x200
	// Position of TXSYN field.
	SSC_IDR_TXSYN_Pos = 0xa
	// Bit mask of TXSYN field.
	SSC_IDR_TXSYN_Msk = 0x400
	// Bit TXSYN.
	SSC_IDR_TXSYN = 0x400
	// Position of RXSYN field.
	SSC_IDR_RXSYN_Pos = 0xb
	// Bit mask of RXSYN field.
	SSC_IDR_RXSYN_Msk = 0x800
	// Bit RXSYN.
	SSC_IDR_RXSYN = 0x800

	// IMR: Interrupt Mask Register
	// Position of TXRDY field.
	SSC_IMR_TXRDY_Pos = 0x0
	// Bit mask of TXRDY field.
	SSC_IMR_TXRDY_Msk = 0x1
	// Bit TXRDY.
	SSC_IMR_TXRDY = 0x1
	// Position of TXEMPTY field.
	SSC_IMR_TXEMPTY_Pos = 0x1
	// Bit mask of TXEMPTY field.
	SSC_IMR_TXEMPTY_Msk = 0x2
	// Bit TXEMPTY.
	SSC_IMR_TXEMPTY = 0x2
	// Position of RXRDY field.
	SSC_IMR_RXRDY_Pos = 0x4
	// Bit mask of RXRDY field.
	SSC_IMR_RXRDY_Msk = 0x10
	// Bit RXRDY.
	SSC_IMR_RXRDY = 0x10
	// Position of OVRUN field.
	SSC_IMR_OVRUN_Pos = 0x5
	// Bit mask of OVRUN field.
	SSC_IMR_OVRUN_Msk = 0x20
	// Bit OVRUN.
	SSC_IMR_OVRUN = 0x20
	// Position of CP0 field.
	SSC_IMR_CP0_Pos = 0x8
	// Bit mask of CP0 field.
	SSC_IMR_CP0_Msk = 0x100
	// Bit CP0.
	SSC_IMR_CP0 = 0x100
	// Position of CP1 field.
	SSC_IMR_CP1_Pos = 0x9
	// Bit mask of CP1 field.
	SSC_IMR_CP1_Msk = 0x200
	// Bit CP1.
	SSC_IMR_CP1 = 0x200
	// Position of TXSYN field.
	SSC_IMR_TXSYN_Pos = 0xa
	// Bit mask of TXSYN field.
	SSC_IMR_TXSYN_Msk = 0x400
	// Bit TXSYN.
	SSC_IMR_TXSYN = 0x400
	// Position of RXSYN field.
	SSC_IMR_RXSYN_Pos = 0xb
	// Bit mask of RXSYN field.
	SSC_IMR_RXSYN_Msk = 0x800
	// Bit RXSYN.
	SSC_IMR_RXSYN = 0x800

	// WPMR: Write Protect Mode Register
	// Position of WPEN field.
	SSC_WPMR_WPEN_Pos = 0x0
	// Bit mask of WPEN field.
	SSC_WPMR_WPEN_Msk = 0x1
	// Bit WPEN.
	SSC_WPMR_WPEN = 0x1
	// Position of WPKEY field.
	SSC_WPMR_WPKEY_Pos = 0x8
	// Bit mask of WPKEY field.
	SSC_WPMR_WPKEY_Msk = 0xffffff00
	// Writing any other value in this field aborts the write operation of the WPEN bit.Always reads as 0.
	SSC_WPMR_WPKEY_PASSWD = 0x535343
)

// Bitfields for SPI0: Serial Peripheral Interface 0
const (
	// CR: Control Register
	// Position of SPIEN field.
	SPI_CR_SPIEN_Pos = 0x0
	// Bit mask of SPIEN field.
	SPI_CR_SPIEN_Msk = 0x1
	// Bit SPIEN.
	SPI_CR_SPIEN = 0x1
	// Position of SPIDIS field.
	SPI_CR_SPIDIS_Pos = 0x1
	// Bit mask of SPIDIS field.
	SPI_CR_SPIDIS_Msk = 0x2
	// Bit SPIDIS.
	SPI_CR_SPIDIS = 0x2
	// Position of SWRST field.
	SPI_CR_SWRST_Pos = 0x7
	// Bit mask of SWRST field.
	SPI_CR_SWRST_Msk = 0x80
	// Bit SWRST.
	SPI_CR_SWRST = 0x80
	// Position of LASTXFER field.
	SPI_CR_LASTXFER_Pos = 0x18
	// Bit mask of LASTXFER field.
	SPI_CR_LASTXFER_Msk = 0x1000000
	// Bit LASTXFER.
	SPI_CR_LASTXFER = 0x1000000

	// MR: Mode Register
	// Position of MSTR field.
	SPI_MR_MSTR_Pos = 0x0
	// Bit mask of MSTR field.
	SPI_MR_MSTR_Msk = 0x1
	// Bit MSTR.
	SPI_MR_MSTR = 0x1
	// Position of PS field.
	SPI_MR_PS_Pos = 0x1
	// Bit mask of PS field.
	SPI_MR_PS_Msk = 0x2
	// Bit PS.
	SPI_MR_PS = 0x2
	// Position of PCSDEC field.
	SPI_MR_PCSDEC_Pos = 0x2
	// Bit mask of PCSDEC field.
	SPI_MR_PCSDEC_Msk = 0x4
	// Bit PCSDEC.
	SPI_MR_PCSDEC = 0x4
	// Position of MODFDIS field.
	SPI_MR_MODFDIS_Pos = 0x4
	// Bit mask of MODFDIS field.
	SPI_MR_MODFDIS_Msk = 0x10
	// Bit MODFDIS.
	SPI_MR_MODFDIS = 0x10
	// Position of WDRBT field.
	SPI_MR_WDRBT_Pos = 0x5
	// Bit mask of WDRBT field.
	SPI_MR_WDRBT_Msk = 0x20
	// Bit WDRBT.
	SPI_MR_WDRBT = 0x20
	// Position of LLB field.
	SPI_MR_LLB_Pos = 0x7
	// Bit mask of LLB field.
	SPI_MR_LLB_Msk = 0x80
	// Bit LLB.
	SPI_MR_LLB = 0x80
	// Position of PCS field.
	SPI_MR_PCS_Pos = 0x10
	// Bit mask of PCS field.
	SPI_MR_PCS_Msk = 0xf0000
	// Position of DLYBCS field.
	SPI_MR_DLYBCS_Pos = 0x18
	// Bit mask of DLYBCS field.
	SPI_MR_DLYBCS_Msk = 0xff000000

	// RDR: Receive Data Register
	// Position of RD field.
	SPI_RDR_RD_Pos = 0x0
	// Bit mask of RD field.
	SPI_RDR_RD_Msk = 0xffff
	// Position of PCS field.
	SPI_RDR_PCS_Pos = 0x10
	// Bit mask of PCS field.
	SPI_RDR_PCS_Msk = 0xf0000

	// TDR: Transmit Data Register
	// Position of TD field.
	SPI_TDR_TD_Pos = 0x0
	// Bit mask of TD field.
	SPI_TDR_TD_Msk = 0xffff
	// Position of PCS field.
	SPI_TDR_PCS_Pos = 0x10
	// Bit mask of PCS field.
	SPI_TDR_PCS_Msk = 0xf0000
	// Position of LASTXFER field.
	SPI_TDR_LASTXFER_Pos = 0x18
	// Bit mask of LASTXFER field.
	SPI_TDR_LASTXFER_Msk = 0x1000000
	// Bit LASTXFER.
	SPI_TDR_LASTXFER = 0x1000000

	// SR: Status Register
	// Position of RDRF field.
	SPI_SR_RDRF_Pos = 0x0
	// Bit mask of RDRF field.
	SPI_SR_RDRF_Msk = 0x1
	// Bit RDRF.
	SPI_SR_RDRF = 0x1
	// Position of TDRE field.
	SPI_SR_TDRE_Pos = 0x1
	// Bit mask of TDRE field.
	SPI_SR_TDRE_Msk = 0x2
	// Bit TDRE.
	SPI_SR_TDRE = 0x2
	// Position of MODF field.
	SPI_SR_MODF_Pos = 0x2
	// Bit mask of MODF field.
	SPI_SR_MODF_Msk = 0x4
	// Bit MODF.
	SPI_SR_MODF = 0x4
	// Position of OVRES field.
	SPI_SR_OVRES_Pos = 0x3
	// Bit mask of OVRES field.
	SPI_SR_OVRES_Msk = 0x8
	// Bit OVRES.
	SPI_SR_OVRES = 0x8
	// Position of NSSR field.
	SPI_SR_NSSR_Pos = 0x8
	// Bit mask of NSSR field.
	SPI_SR_NSSR_Msk = 0x100
	// Bit NSSR.
	SPI_SR_NSSR = 0x100
	// Position of TXEMPTY field.
	SPI_SR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	SPI_SR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	SPI_SR_TXEMPTY = 0x200
	// Position of UNDES field.
	SPI_SR_UNDES_Pos = 0xa
	// Bit mask of UNDES field.
	SPI_SR_UNDES_Msk = 0x400
	// Bit UNDES.
	SPI_SR_UNDES = 0x400
	// Position of SPIENS field.
	SPI_SR_SPIENS_Pos = 0x10
	// Bit mask of SPIENS field.
	SPI_SR_SPIENS_Msk = 0x10000
	// Bit SPIENS.
	SPI_SR_SPIENS = 0x10000

	// IER: Interrupt Enable Register
	// Position of RDRF field.
	SPI_IER_RDRF_Pos = 0x0
	// Bit mask of RDRF field.
	SPI_IER_RDRF_Msk = 0x1
	// Bit RDRF.
	SPI_IER_RDRF = 0x1
	// Position of TDRE field.
	SPI_IER_TDRE_Pos = 0x1
	// Bit mask of TDRE field.
	SPI_IER_TDRE_Msk = 0x2
	// Bit TDRE.
	SPI_IER_TDRE = 0x2
	// Position of MODF field.
	SPI_IER_MODF_Pos = 0x2
	// Bit mask of MODF field.
	SPI_IER_MODF_Msk = 0x4
	// Bit MODF.
	SPI_IER_MODF = 0x4
	// Position of OVRES field.
	SPI_IER_OVRES_Pos = 0x3
	// Bit mask of OVRES field.
	SPI_IER_OVRES_Msk = 0x8
	// Bit OVRES.
	SPI_IER_OVRES = 0x8
	// Position of NSSR field.
	SPI_IER_NSSR_Pos = 0x8
	// Bit mask of NSSR field.
	SPI_IER_NSSR_Msk = 0x100
	// Bit NSSR.
	SPI_IER_NSSR = 0x100
	// Position of TXEMPTY field.
	SPI_IER_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	SPI_IER_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	SPI_IER_TXEMPTY = 0x200
	// Position of UNDES field.
	SPI_IER_UNDES_Pos = 0xa
	// Bit mask of UNDES field.
	SPI_IER_UNDES_Msk = 0x400
	// Bit UNDES.
	SPI_IER_UNDES = 0x400

	// IDR: Interrupt Disable Register
	// Position of RDRF field.
	SPI_IDR_RDRF_Pos = 0x0
	// Bit mask of RDRF field.
	SPI_IDR_RDRF_Msk = 0x1
	// Bit RDRF.
	SPI_IDR_RDRF = 0x1
	// Position of TDRE field.
	SPI_IDR_TDRE_Pos = 0x1
	// Bit mask of TDRE field.
	SPI_IDR_TDRE_Msk = 0x2
	// Bit TDRE.
	SPI_IDR_TDRE = 0x2
	// Position of MODF field.
	SPI_IDR_MODF_Pos = 0x2
	// Bit mask of MODF field.
	SPI_IDR_MODF_Msk = 0x4
	// Bit MODF.
	SPI_IDR_MODF = 0x4
	// Position of OVRES field.
	SPI_IDR_OVRES_Pos = 0x3
	// Bit mask of OVRES field.
	SPI_IDR_OVRES_Msk = 0x8
	// Bit OVRES.
	SPI_IDR_OVRES = 0x8
	// Position of NSSR field.
	SPI_IDR_NSSR_Pos = 0x8
	// Bit mask of NSSR field.
	SPI_IDR_NSSR_Msk = 0x100
	// Bit NSSR.
	SPI_IDR_NSSR = 0x100
	// Position of TXEMPTY field.
	SPI_IDR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	SPI_IDR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	SPI_IDR_TXEMPTY = 0x200
	// Position of UNDES field.
	SPI_IDR_UNDES_Pos = 0xa
	// Bit mask of UNDES field.
	SPI_IDR_UNDES_Msk = 0x400
	// Bit UNDES.
	SPI_IDR_UNDES = 0x400

	// IMR: Interrupt Mask Register
	// Position of RDRF field.
	SPI_IMR_RDRF_Pos = 0x0
	// Bit mask of RDRF field.
	SPI_IMR_RDRF_Msk = 0x1
	// Bit RDRF.
	SPI_IMR_RDRF = 0x1
	// Position of TDRE field.
	SPI_IMR_TDRE_Pos = 0x1
	// Bit mask of TDRE field.
	SPI_IMR_TDRE_Msk = 0x2
	// Bit TDRE.
	SPI_IMR_TDRE = 0x2
	// Position of MODF field.
	SPI_IMR_MODF_Pos = 0x2
	// Bit mask of MODF field.
	SPI_IMR_MODF_Msk = 0x4
	// Bit MODF.
	SPI_IMR_MODF = 0x4
	// Position of OVRES field.
	SPI_IMR_OVRES_Pos = 0x3
	// Bit mask of OVRES field.
	SPI_IMR_OVRES_Msk = 0x8
	// Bit OVRES.
	SPI_IMR_OVRES = 0x8
	// Position of NSSR field.
	SPI_IMR_NSSR_Pos = 0x8
	// Bit mask of NSSR field.
	SPI_IMR_NSSR_Msk = 0x100
	// Bit NSSR.
	SPI_IMR_NSSR = 0x100
	// Position of TXEMPTY field.
	SPI_IMR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	SPI_IMR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	SPI_IMR_TXEMPTY = 0x200
	// Position of UNDES field.
	SPI_IMR_UNDES_Pos = 0xa
	// Bit mask of UNDES field.
	SPI_IMR_UNDES_Msk = 0x400
	// Bit UNDES.
	SPI_IMR_UNDES = 0x400

	// CSR: Chip Select Register
	// Position of CPOL field.
	SPI_CSR_CPOL_Pos = 0x0
	// Bit mask of CPOL field.
	SPI_CSR_CPOL_Msk = 0x1
	// Bit CPOL.
	SPI_CSR_CPOL = 0x1
	// Position of NCPHA field.
	SPI_CSR_NCPHA_Pos = 0x1
	// Bit mask of NCPHA field.
	SPI_CSR_NCPHA_Msk = 0x2
	// Bit NCPHA.
	SPI_CSR_NCPHA = 0x2
	// Position of CSNAAT field.
	SPI_CSR_CSNAAT_Pos = 0x2
	// Bit mask of CSNAAT field.
	SPI_CSR_CSNAAT_Msk = 0x4
	// Bit CSNAAT.
	SPI_CSR_CSNAAT = 0x4
	// Position of CSAAT field.
	SPI_CSR_CSAAT_Pos = 0x3
	// Bit mask of CSAAT field.
	SPI_CSR_CSAAT_Msk = 0x8
	// Bit CSAAT.
	SPI_CSR_CSAAT = 0x8
	// Position of BITS field.
	SPI_CSR_BITS_Pos = 0x4
	// Bit mask of BITS field.
	SPI_CSR_BITS_Msk = 0xf0
	// 8 bits for transfer
	SPI_CSR_BITS_8_BIT = 0x0
	// 9 bits for transfer
	SPI_CSR_BITS_9_BIT = 0x1
	// 10 bits for transfer
	SPI_CSR_BITS_10_BIT = 0x2
	// 11 bits for transfer
	SPI_CSR_BITS_11_BIT = 0x3
	// 12 bits for transfer
	SPI_CSR_BITS_12_BIT = 0x4
	// 13 bits for transfer
	SPI_CSR_BITS_13_BIT = 0x5
	// 14 bits for transfer
	SPI_CSR_BITS_14_BIT = 0x6
	// 15 bits for transfer
	SPI_CSR_BITS_15_BIT = 0x7
	// 16 bits for transfer
	SPI_CSR_BITS_16_BIT = 0x8
	// Position of SCBR field.
	SPI_CSR_SCBR_Pos = 0x8
	// Bit mask of SCBR field.
	SPI_CSR_SCBR_Msk = 0xff00
	// Position of DLYBS field.
	SPI_CSR_DLYBS_Pos = 0x10
	// Bit mask of DLYBS field.
	SPI_CSR_DLYBS_Msk = 0xff0000
	// Position of DLYBCT field.
	SPI_CSR_DLYBCT_Pos = 0x18
	// Bit mask of DLYBCT field.
	SPI_CSR_DLYBCT_Msk = 0xff000000

	// WPMR: Write Protection Control Register
	// Position of WPEN field.
	SPI_WPMR_WPEN_Pos = 0x0
	// Bit mask of WPEN field.
	SPI_WPMR_WPEN_Msk = 0x1
	// Bit WPEN.
	SPI_WPMR_WPEN = 0x1
	// Position of WPKEY field.
	SPI_WPMR_WPKEY_Pos = 0x8
	// Bit mask of WPKEY field.
	SPI_WPMR_WPKEY_Msk = 0xffffff00
	// Writing any other value in this field aborts the write operation of the WPEN bit.Always reads as 0.
	SPI_WPMR_WPKEY_PASSWD = 0x535049

	// WPSR: Write Protection Status Register
	// Position of WPVS field.
	SPI_WPSR_WPVS_Pos = 0x0
	// Bit mask of WPVS field.
	SPI_WPSR_WPVS_Msk = 0x1
	// Bit WPVS.
	SPI_WPSR_WPVS = 0x1
	// Position of WPVSRC field.
	SPI_WPSR_WPVSRC_Pos = 0x8
	// Bit mask of WPVSRC field.
	SPI_WPSR_WPVSRC_Msk = 0xff00
)

// Bitfields for TC0: Timer Counter 0
const (
	// CCR0: Channel Control Register (channel = 0)
	// Position of CLKEN field.
	TC_CCR0_CLKEN_Pos = 0x0
	// Bit mask of CLKEN field.
	TC_CCR0_CLKEN_Msk = 0x1
	// Bit CLKEN.
	TC_CCR0_CLKEN = 0x1
	// Position of CLKDIS field.
	TC_CCR0_CLKDIS_Pos = 0x1
	// Bit mask of CLKDIS field.
	TC_CCR0_CLKDIS_Msk = 0x2
	// Bit CLKDIS.
	TC_CCR0_CLKDIS = 0x2
	// Position of SWTRG field.
	TC_CCR0_SWTRG_Pos = 0x2
	// Bit mask of SWTRG field.
	TC_CCR0_SWTRG_Msk = 0x4
	// Bit SWTRG.
	TC_CCR0_SWTRG = 0x4

	// CMR0: Channel Mode Register (channel = 0)
	// Position of TCCLKS field.
	TC_CMR0_TCCLKS_Pos = 0x0
	// Bit mask of TCCLKS field.
	TC_CMR0_TCCLKS_Msk = 0x7
	// Clock selected: TCLK1
	TC_CMR0_TCCLKS_TIMER_CLOCK1 = 0x0
	// Clock selected: TCLK2
	TC_CMR0_TCCLKS_TIMER_CLOCK2 = 0x1
	// Clock selected: TCLK3
	TC_CMR0_TCCLKS_TIMER_CLOCK3 = 0x2
	// Clock selected: TCLK4
	TC_CMR0_TCCLKS_TIMER_CLOCK4 = 0x3
	// Clock selected: TCLK5
	TC_CMR0_TCCLKS_TIMER_CLOCK5 = 0x4
	// Clock selected: XC0
	TC_CMR0_TCCLKS_XC0 = 0x5
	// Clock selected: XC1
	TC_CMR0_TCCLKS_XC1 = 0x6
	// Clock selected: XC2
	TC_CMR0_TCCLKS_XC2 = 0x7
	// Position of CLKI field.
	TC_CMR0_CLKI_Pos = 0x3
	// Bit mask of CLKI field.
	TC_CMR0_CLKI_Msk = 0x8
	// Bit CLKI.
	TC_CMR0_CLKI = 0x8
	// Position of BURST field.
	TC_CMR0_BURST_Pos = 0x4
	// Bit mask of BURST field.
	TC_CMR0_BURST_Msk = 0x30
	// The clock is not gated by an external signal.
	TC_CMR0_BURST_NONE = 0x0
	// XC0 is ANDed with the selected clock.
	TC_CMR0_BURST_XC0 = 0x1
	// XC1 is ANDed with the selected clock.
	TC_CMR0_BURST_XC1 = 0x2
	// XC2 is ANDed with the selected clock.
	TC_CMR0_BURST_XC2 = 0x3
	// Position of LDBSTOP field.
	TC_CMR0_LDBSTOP_Pos = 0x6
	// Bit mask of LDBSTOP field.
	TC_CMR0_LDBSTOP_Msk = 0x40
	// Bit LDBSTOP.
	TC_CMR0_LDBSTOP = 0x40
	// Position of LDBDIS field.
	TC_CMR0_LDBDIS_Pos = 0x7
	// Bit mask of LDBDIS field.
	TC_CMR0_LDBDIS_Msk = 0x80
	// Bit LDBDIS.
	TC_CMR0_LDBDIS = 0x80
	// Position of ETRGEDG field.
	TC_CMR0_ETRGEDG_Pos = 0x8
	// Bit mask of ETRGEDG field.
	TC_CMR0_ETRGEDG_Msk = 0x300
	// The clock is not gated by an external signal.
	TC_CMR0_ETRGEDG_NONE = 0x0
	// Rising edge
	TC_CMR0_ETRGEDG_RISING = 0x1
	// Falling edge
	TC_CMR0_ETRGEDG_FALLING = 0x2
	// Each edge
	TC_CMR0_ETRGEDG_EDGE = 0x3
	// Position of ABETRG field.
	TC_CMR0_ABETRG_Pos = 0xa
	// Bit mask of ABETRG field.
	TC_CMR0_ABETRG_Msk = 0x400
	// Bit ABETRG.
	TC_CMR0_ABETRG = 0x400
	// Position of CPCTRG field.
	TC_CMR0_CPCTRG_Pos = 0xe
	// Bit mask of CPCTRG field.
	TC_CMR0_CPCTRG_Msk = 0x4000
	// Bit CPCTRG.
	TC_CMR0_CPCTRG = 0x4000
	// Position of WAVE field.
	TC_CMR0_WAVE_Pos = 0xf
	// Bit mask of WAVE field.
	TC_CMR0_WAVE_Msk = 0x8000
	// Bit WAVE.
	TC_CMR0_WAVE = 0x8000
	// Position of LDRA field.
	TC_CMR0_LDRA_Pos = 0x10
	// Bit mask of LDRA field.
	TC_CMR0_LDRA_Msk = 0x30000
	// None
	TC_CMR0_LDRA_NONE = 0x0
	// Rising edge of TIOA
	TC_CMR0_LDRA_RISING = 0x1
	// Falling edge of TIOA
	TC_CMR0_LDRA_FALLING = 0x2
	// Each edge of TIOA
	TC_CMR0_LDRA_EDGE = 0x3
	// Position of LDRB field.
	TC_CMR0_LDRB_Pos = 0x12
	// Bit mask of LDRB field.
	TC_CMR0_LDRB_Msk = 0xc0000
	// None
	TC_CMR0_LDRB_NONE = 0x0
	// Rising edge of TIOA
	TC_CMR0_LDRB_RISING = 0x1
	// Falling edge of TIOA
	TC_CMR0_LDRB_FALLING = 0x2
	// Each edge of TIOA
	TC_CMR0_LDRB_EDGE = 0x3

	// CMR0_WAVE_EQ_1: Channel Mode Register (channel = 0)
	// Position of TCCLKS field.
	TC_CMR0_WAVE_EQ_1_TCCLKS_Pos = 0x0
	// Bit mask of TCCLKS field.
	TC_CMR0_WAVE_EQ_1_TCCLKS_Msk = 0x7
	// Clock selected: TCLK1
	TC_CMR0_WAVE_EQ_1_TCCLKS_TIMER_CLOCK1 = 0x0
	// Clock selected: TCLK2
	TC_CMR0_WAVE_EQ_1_TCCLKS_TIMER_CLOCK2 = 0x1
	// Clock selected: TCLK3
	TC_CMR0_WAVE_EQ_1_TCCLKS_TIMER_CLOCK3 = 0x2
	// Clock selected: TCLK4
	TC_CMR0_WAVE_EQ_1_TCCLKS_TIMER_CLOCK4 = 0x3
	// Clock selected: TCLK5
	TC_CMR0_WAVE_EQ_1_TCCLKS_TIMER_CLOCK5 = 0x4
	// Clock selected: XC0
	TC_CMR0_WAVE_EQ_1_TCCLKS_XC0 = 0x5
	// Clock selected: XC1
	TC_CMR0_WAVE_EQ_1_TCCLKS_XC1 = 0x6
	// Clock selected: XC2
	TC_CMR0_WAVE_EQ_1_TCCLKS_XC2 = 0x7
	// Position of CLKI field.
	TC_CMR0_WAVE_EQ_1_CLKI_Pos = 0x3
	// Bit mask of CLKI field.
	TC_CMR0_WAVE_EQ_1_CLKI_Msk = 0x8
	// Bit CLKI.
	TC_CMR0_WAVE_EQ_1_CLKI = 0x8
	// Position of BURST field.
	TC_CMR0_WAVE_EQ_1_BURST_Pos = 0x4
	// Bit mask of BURST field.
	TC_CMR0_WAVE_EQ_1_BURST_Msk = 0x30
	// The clock is not gated by an external signal.
	TC_CMR0_WAVE_EQ_1_BURST_NONE = 0x0
	// XC0 is ANDed with the selected clock.
	TC_CMR0_WAVE_EQ_1_BURST_XC0 = 0x1
	// XC1 is ANDed with the selected clock.
	TC_CMR0_WAVE_EQ_1_BURST_XC1 = 0x2
	// XC2 is ANDed with the selected clock.
	TC_CMR0_WAVE_EQ_1_BURST_XC2 = 0x3
	// Position of CPCSTOP field.
	TC_CMR0_WAVE_EQ_1_CPCSTOP_Pos = 0x6
	// Bit mask of CPCSTOP field.
	TC_CMR0_WAVE_EQ_1_CPCSTOP_Msk = 0x40
	// Bit CPCSTOP.
	TC_CMR0_WAVE_EQ_1_CPCSTOP = 0x40
	// Position of CPCDIS field.
	TC_CMR0_WAVE_EQ_1_CPCDIS_Pos = 0x7
	// Bit mask of CPCDIS field.
	TC_CMR0_WAVE_EQ_1_CPCDIS_Msk = 0x80
	// Bit CPCDIS.
	TC_CMR0_WAVE_EQ_1_CPCDIS = 0x80
	// Position of EEVTEDG field.
	TC_CMR0_WAVE_EQ_1_EEVTEDG_Pos = 0x8
	// Bit mask of EEVTEDG field.
	TC_CMR0_WAVE_EQ_1_EEVTEDG_Msk = 0x300
	// None
	TC_CMR0_WAVE_EQ_1_EEVTEDG_NONE = 0x0
	// Rising edge
	TC_CMR0_WAVE_EQ_1_EEVTEDG_RISING = 0x1
	// Falling edge
	TC_CMR0_WAVE_EQ_1_EEVTEDG_FALLING = 0x2
	// Each edge
	TC_CMR0_WAVE_EQ_1_EEVTEDG_EDGE = 0x3
	// Position of EEVT field.
	TC_CMR0_WAVE_EQ_1_EEVT_Pos = 0xa
	// Bit mask of EEVT field.
	TC_CMR0_WAVE_EQ_1_EEVT_Msk = 0xc00
	// TIOB
	TC_CMR0_WAVE_EQ_1_EEVT_TIOB = 0x0
	// XC0
	TC_CMR0_WAVE_EQ_1_EEVT_XC0 = 0x1
	// XC1
	TC_CMR0_WAVE_EQ_1_EEVT_XC1 = 0x2
	// XC2
	TC_CMR0_WAVE_EQ_1_EEVT_XC2 = 0x3
	// Position of ENETRG field.
	TC_CMR0_WAVE_EQ_1_ENETRG_Pos = 0xc
	// Bit mask of ENETRG field.
	TC_CMR0_WAVE_EQ_1_ENETRG_Msk = 0x1000
	// Bit ENETRG.
	TC_CMR0_WAVE_EQ_1_ENETRG = 0x1000
	// Position of WAVSEL field.
	TC_CMR0_WAVE_EQ_1_WAVSEL_Pos = 0xd
	// Bit mask of WAVSEL field.
	TC_CMR0_WAVE_EQ_1_WAVSEL_Msk = 0x6000
	// UP mode without automatic trigger on RC Compare
	TC_CMR0_WAVE_EQ_1_WAVSEL_UP = 0x0
	// UPDOWN mode without automatic trigger on RC Compare
	TC_CMR0_WAVE_EQ_1_WAVSEL_UPDOWN = 0x1
	// UP mode with automatic trigger on RC Compare
	TC_CMR0_WAVE_EQ_1_WAVSEL_UP_RC = 0x2
	// UPDOWN mode with automatic trigger on RC Compare
	TC_CMR0_WAVE_EQ_1_WAVSEL_UPDOWN_RC = 0x3
	// Position of WAVE field.
	TC_CMR0_WAVE_EQ_1_WAVE_Pos = 0xf
	// Bit mask of WAVE field.
	TC_CMR0_WAVE_EQ_1_WAVE_Msk = 0x8000
	// Bit WAVE.
	TC_CMR0_WAVE_EQ_1_WAVE = 0x8000
	// Position of ACPA field.
	TC_CMR0_WAVE_EQ_1_ACPA_Pos = 0x10
	// Bit mask of ACPA field.
	TC_CMR0_WAVE_EQ_1_ACPA_Msk = 0x30000
	// None
	TC_CMR0_WAVE_EQ_1_ACPA_NONE = 0x0
	// Set
	TC_CMR0_WAVE_EQ_1_ACPA_SET = 0x1
	// Clear
	TC_CMR0_WAVE_EQ_1_ACPA_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVE_EQ_1_ACPA_TOGGLE = 0x3
	// Position of ACPC field.
	TC_CMR0_WAVE_EQ_1_ACPC_Pos = 0x12
	// Bit mask of ACPC field.
	TC_CMR0_WAVE_EQ_1_ACPC_Msk = 0xc0000
	// None
	TC_CMR0_WAVE_EQ_1_ACPC_NONE = 0x0
	// Set
	TC_CMR0_WAVE_EQ_1_ACPC_SET = 0x1
	// Clear
	TC_CMR0_WAVE_EQ_1_ACPC_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVE_EQ_1_ACPC_TOGGLE = 0x3
	// Position of AEEVT field.
	TC_CMR0_WAVE_EQ_1_AEEVT_Pos = 0x14
	// Bit mask of AEEVT field.
	TC_CMR0_WAVE_EQ_1_AEEVT_Msk = 0x300000
	// None
	TC_CMR0_WAVE_EQ_1_AEEVT_NONE = 0x0
	// Set
	TC_CMR0_WAVE_EQ_1_AEEVT_SET = 0x1
	// Clear
	TC_CMR0_WAVE_EQ_1_AEEVT_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVE_EQ_1_AEEVT_TOGGLE = 0x3
	// Position of ASWTRG field.
	TC_CMR0_WAVE_EQ_1_ASWTRG_Pos = 0x16
	// Bit mask of ASWTRG field.
	TC_CMR0_WAVE_EQ_1_ASWTRG_Msk = 0xc00000
	// None
	TC_CMR0_WAVE_EQ_1_ASWTRG_NONE = 0x0
	// Set
	TC_CMR0_WAVE_EQ_1_ASWTRG_SET = 0x1
	// Clear
	TC_CMR0_WAVE_EQ_1_ASWTRG_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVE_EQ_1_ASWTRG_TOGGLE = 0x3
	// Position of BCPB field.
	TC_CMR0_WAVE_EQ_1_BCPB_Pos = 0x18
	// Bit mask of BCPB field.
	TC_CMR0_WAVE_EQ_1_BCPB_Msk = 0x3000000
	// None
	TC_CMR0_WAVE_EQ_1_BCPB_NONE = 0x0
	// Set
	TC_CMR0_WAVE_EQ_1_BCPB_SET = 0x1
	// Clear
	TC_CMR0_WAVE_EQ_1_BCPB_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVE_EQ_1_BCPB_TOGGLE = 0x3
	// Position of BCPC field.
	TC_CMR0_WAVE_EQ_1_BCPC_Pos = 0x1a
	// Bit mask of BCPC field.
	TC_CMR0_WAVE_EQ_1_BCPC_Msk = 0xc000000
	// None
	TC_CMR0_WAVE_EQ_1_BCPC_NONE = 0x0
	// Set
	TC_CMR0_WAVE_EQ_1_BCPC_SET = 0x1
	// Clear
	TC_CMR0_WAVE_EQ_1_BCPC_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVE_EQ_1_BCPC_TOGGLE = 0x3
	// Position of BEEVT field.
	TC_CMR0_WAVE_EQ_1_BEEVT_Pos = 0x1c
	// Bit mask of BEEVT field.
	TC_CMR0_WAVE_EQ_1_BEEVT_Msk = 0x30000000
	// None
	TC_CMR0_WAVE_EQ_1_BEEVT_NONE = 0x0
	// Set
	TC_CMR0_WAVE_EQ_1_BEEVT_SET = 0x1
	// Clear
	TC_CMR0_WAVE_EQ_1_BEEVT_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVE_EQ_1_BEEVT_TOGGLE = 0x3
	// Position of BSWTRG field.
	TC_CMR0_WAVE_EQ_1_BSWTRG_Pos = 0x1e
	// Bit mask of BSWTRG field.
	TC_CMR0_WAVE_EQ_1_BSWTRG_Msk = 0xc0000000
	// None
	TC_CMR0_WAVE_EQ_1_BSWTRG_NONE = 0x0
	// Set
	TC_CMR0_WAVE_EQ_1_BSWTRG_SET = 0x1
	// Clear
	TC_CMR0_WAVE_EQ_1_BSWTRG_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVE_EQ_1_BSWTRG_TOGGLE = 0x3

	// SMMR0: Stepper Motor Mode Register (channel = 0)
	// Position of GCEN field.
	TC_SMMR0_GCEN_Pos = 0x0
	// Bit mask of GCEN field.
	TC_SMMR0_GCEN_Msk = 0x1
	// Bit GCEN.
	TC_SMMR0_GCEN = 0x1
	// Position of DOWN field.
	TC_SMMR0_DOWN_Pos = 0x1
	// Bit mask of DOWN field.
	TC_SMMR0_DOWN_Msk = 0x2
	// Bit DOWN.
	TC_SMMR0_DOWN = 0x2

	// CV0: Counter Value (channel = 0)
	// Position of CV field.
	TC_CV0_CV_Pos = 0x0
	// Bit mask of CV field.
	TC_CV0_CV_Msk = 0xffffffff

	// RA0: Register A (channel = 0)
	// Position of RA field.
	TC_RA0_RA_Pos = 0x0
	// Bit mask of RA field.
	TC_RA0_RA_Msk = 0xffffffff

	// RB0: Register B (channel = 0)
	// Position of RB field.
	TC_RB0_RB_Pos = 0x0
	// Bit mask of RB field.
	TC_RB0_RB_Msk = 0xffffffff

	// RC0: Register C (channel = 0)
	// Position of RC field.
	TC_RC0_RC_Pos = 0x0
	// Bit mask of RC field.
	TC_RC0_RC_Msk = 0xffffffff

	// SR0: Status Register (channel = 0)
	// Position of COVFS field.
	TC_SR0_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_SR0_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_SR0_COVFS = 0x1
	// Position of LOVRS field.
	TC_SR0_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_SR0_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_SR0_LOVRS = 0x2
	// Position of CPAS field.
	TC_SR0_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_SR0_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_SR0_CPAS = 0x4
	// Position of CPBS field.
	TC_SR0_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_SR0_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_SR0_CPBS = 0x8
	// Position of CPCS field.
	TC_SR0_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_SR0_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_SR0_CPCS = 0x10
	// Position of LDRAS field.
	TC_SR0_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_SR0_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_SR0_LDRAS = 0x20
	// Position of LDRBS field.
	TC_SR0_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_SR0_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_SR0_LDRBS = 0x40
	// Position of ETRGS field.
	TC_SR0_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_SR0_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_SR0_ETRGS = 0x80
	// Position of CLKSTA field.
	TC_SR0_CLKSTA_Pos = 0x10
	// Bit mask of CLKSTA field.
	TC_SR0_CLKSTA_Msk = 0x10000
	// Bit CLKSTA.
	TC_SR0_CLKSTA = 0x10000
	// Position of MTIOA field.
	TC_SR0_MTIOA_Pos = 0x11
	// Bit mask of MTIOA field.
	TC_SR0_MTIOA_Msk = 0x20000
	// Bit MTIOA.
	TC_SR0_MTIOA = 0x20000
	// Position of MTIOB field.
	TC_SR0_MTIOB_Pos = 0x12
	// Bit mask of MTIOB field.
	TC_SR0_MTIOB_Msk = 0x40000
	// Bit MTIOB.
	TC_SR0_MTIOB = 0x40000

	// IER0: Interrupt Enable Register (channel = 0)
	// Position of COVFS field.
	TC_IER0_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IER0_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IER0_COVFS = 0x1
	// Position of LOVRS field.
	TC_IER0_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IER0_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IER0_LOVRS = 0x2
	// Position of CPAS field.
	TC_IER0_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IER0_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IER0_CPAS = 0x4
	// Position of CPBS field.
	TC_IER0_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IER0_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IER0_CPBS = 0x8
	// Position of CPCS field.
	TC_IER0_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IER0_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IER0_CPCS = 0x10
	// Position of LDRAS field.
	TC_IER0_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IER0_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IER0_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IER0_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IER0_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IER0_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IER0_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IER0_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IER0_ETRGS = 0x80

	// IDR0: Interrupt Disable Register (channel = 0)
	// Position of COVFS field.
	TC_IDR0_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IDR0_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IDR0_COVFS = 0x1
	// Position of LOVRS field.
	TC_IDR0_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IDR0_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IDR0_LOVRS = 0x2
	// Position of CPAS field.
	TC_IDR0_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IDR0_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IDR0_CPAS = 0x4
	// Position of CPBS field.
	TC_IDR0_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IDR0_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IDR0_CPBS = 0x8
	// Position of CPCS field.
	TC_IDR0_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IDR0_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IDR0_CPCS = 0x10
	// Position of LDRAS field.
	TC_IDR0_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IDR0_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IDR0_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IDR0_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IDR0_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IDR0_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IDR0_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IDR0_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IDR0_ETRGS = 0x80

	// IMR0: Interrupt Mask Register (channel = 0)
	// Position of COVFS field.
	TC_IMR0_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IMR0_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IMR0_COVFS = 0x1
	// Position of LOVRS field.
	TC_IMR0_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IMR0_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IMR0_LOVRS = 0x2
	// Position of CPAS field.
	TC_IMR0_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IMR0_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IMR0_CPAS = 0x4
	// Position of CPBS field.
	TC_IMR0_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IMR0_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IMR0_CPBS = 0x8
	// Position of CPCS field.
	TC_IMR0_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IMR0_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IMR0_CPCS = 0x10
	// Position of LDRAS field.
	TC_IMR0_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IMR0_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IMR0_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IMR0_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IMR0_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IMR0_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IMR0_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IMR0_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IMR0_ETRGS = 0x80

	// CCR1: Channel Control Register (channel = 1)
	// Position of CLKEN field.
	TC_CCR1_CLKEN_Pos = 0x0
	// Bit mask of CLKEN field.
	TC_CCR1_CLKEN_Msk = 0x1
	// Bit CLKEN.
	TC_CCR1_CLKEN = 0x1
	// Position of CLKDIS field.
	TC_CCR1_CLKDIS_Pos = 0x1
	// Bit mask of CLKDIS field.
	TC_CCR1_CLKDIS_Msk = 0x2
	// Bit CLKDIS.
	TC_CCR1_CLKDIS = 0x2
	// Position of SWTRG field.
	TC_CCR1_SWTRG_Pos = 0x2
	// Bit mask of SWTRG field.
	TC_CCR1_SWTRG_Msk = 0x4
	// Bit SWTRG.
	TC_CCR1_SWTRG = 0x4

	// CMR1: Channel Mode Register (channel = 1)
	// Position of TCCLKS field.
	TC_CMR1_TCCLKS_Pos = 0x0
	// Bit mask of TCCLKS field.
	TC_CMR1_TCCLKS_Msk = 0x7
	// Clock selected: TCLK1
	TC_CMR1_TCCLKS_TIMER_CLOCK1 = 0x0
	// Clock selected: TCLK2
	TC_CMR1_TCCLKS_TIMER_CLOCK2 = 0x1
	// Clock selected: TCLK3
	TC_CMR1_TCCLKS_TIMER_CLOCK3 = 0x2
	// Clock selected: TCLK4
	TC_CMR1_TCCLKS_TIMER_CLOCK4 = 0x3
	// Clock selected: TCLK5
	TC_CMR1_TCCLKS_TIMER_CLOCK5 = 0x4
	// Clock selected: XC0
	TC_CMR1_TCCLKS_XC0 = 0x5
	// Clock selected: XC1
	TC_CMR1_TCCLKS_XC1 = 0x6
	// Clock selected: XC2
	TC_CMR1_TCCLKS_XC2 = 0x7
	// Position of CLKI field.
	TC_CMR1_CLKI_Pos = 0x3
	// Bit mask of CLKI field.
	TC_CMR1_CLKI_Msk = 0x8
	// Bit CLKI.
	TC_CMR1_CLKI = 0x8
	// Position of BURST field.
	TC_CMR1_BURST_Pos = 0x4
	// Bit mask of BURST field.
	TC_CMR1_BURST_Msk = 0x30
	// The clock is not gated by an external signal.
	TC_CMR1_BURST_NONE = 0x0
	// XC0 is ANDed with the selected clock.
	TC_CMR1_BURST_XC0 = 0x1
	// XC1 is ANDed with the selected clock.
	TC_CMR1_BURST_XC1 = 0x2
	// XC2 is ANDed with the selected clock.
	TC_CMR1_BURST_XC2 = 0x3
	// Position of LDBSTOP field.
	TC_CMR1_LDBSTOP_Pos = 0x6
	// Bit mask of LDBSTOP field.
	TC_CMR1_LDBSTOP_Msk = 0x40
	// Bit LDBSTOP.
	TC_CMR1_LDBSTOP = 0x40
	// Position of LDBDIS field.
	TC_CMR1_LDBDIS_Pos = 0x7
	// Bit mask of LDBDIS field.
	TC_CMR1_LDBDIS_Msk = 0x80
	// Bit LDBDIS.
	TC_CMR1_LDBDIS = 0x80
	// Position of ETRGEDG field.
	TC_CMR1_ETRGEDG_Pos = 0x8
	// Bit mask of ETRGEDG field.
	TC_CMR1_ETRGEDG_Msk = 0x300
	// The clock is not gated by an external signal.
	TC_CMR1_ETRGEDG_NONE = 0x0
	// Rising edge
	TC_CMR1_ETRGEDG_RISING = 0x1
	// Falling edge
	TC_CMR1_ETRGEDG_FALLING = 0x2
	// Each edge
	TC_CMR1_ETRGEDG_EDGE = 0x3
	// Position of ABETRG field.
	TC_CMR1_ABETRG_Pos = 0xa
	// Bit mask of ABETRG field.
	TC_CMR1_ABETRG_Msk = 0x400
	// Bit ABETRG.
	TC_CMR1_ABETRG = 0x400
	// Position of CPCTRG field.
	TC_CMR1_CPCTRG_Pos = 0xe
	// Bit mask of CPCTRG field.
	TC_CMR1_CPCTRG_Msk = 0x4000
	// Bit CPCTRG.
	TC_CMR1_CPCTRG = 0x4000
	// Position of WAVE field.
	TC_CMR1_WAVE_Pos = 0xf
	// Bit mask of WAVE field.
	TC_CMR1_WAVE_Msk = 0x8000
	// Bit WAVE.
	TC_CMR1_WAVE = 0x8000
	// Position of LDRA field.
	TC_CMR1_LDRA_Pos = 0x10
	// Bit mask of LDRA field.
	TC_CMR1_LDRA_Msk = 0x30000
	// None
	TC_CMR1_LDRA_NONE = 0x0
	// Rising edge of TIOA
	TC_CMR1_LDRA_RISING = 0x1
	// Falling edge of TIOA
	TC_CMR1_LDRA_FALLING = 0x2
	// Each edge of TIOA
	TC_CMR1_LDRA_EDGE = 0x3
	// Position of LDRB field.
	TC_CMR1_LDRB_Pos = 0x12
	// Bit mask of LDRB field.
	TC_CMR1_LDRB_Msk = 0xc0000
	// None
	TC_CMR1_LDRB_NONE = 0x0
	// Rising edge of TIOA
	TC_CMR1_LDRB_RISING = 0x1
	// Falling edge of TIOA
	TC_CMR1_LDRB_FALLING = 0x2
	// Each edge of TIOA
	TC_CMR1_LDRB_EDGE = 0x3

	// CMR1_WAVE_EQ_1: Channel Mode Register (channel = 1)
	// Position of TCCLKS field.
	TC_CMR1_WAVE_EQ_1_TCCLKS_Pos = 0x0
	// Bit mask of TCCLKS field.
	TC_CMR1_WAVE_EQ_1_TCCLKS_Msk = 0x7
	// Clock selected: TCLK1
	TC_CMR1_WAVE_EQ_1_TCCLKS_TIMER_CLOCK1 = 0x0
	// Clock selected: TCLK2
	TC_CMR1_WAVE_EQ_1_TCCLKS_TIMER_CLOCK2 = 0x1
	// Clock selected: TCLK3
	TC_CMR1_WAVE_EQ_1_TCCLKS_TIMER_CLOCK3 = 0x2
	// Clock selected: TCLK4
	TC_CMR1_WAVE_EQ_1_TCCLKS_TIMER_CLOCK4 = 0x3
	// Clock selected: TCLK5
	TC_CMR1_WAVE_EQ_1_TCCLKS_TIMER_CLOCK5 = 0x4
	// Clock selected: XC0
	TC_CMR1_WAVE_EQ_1_TCCLKS_XC0 = 0x5
	// Clock selected: XC1
	TC_CMR1_WAVE_EQ_1_TCCLKS_XC1 = 0x6
	// Clock selected: XC2
	TC_CMR1_WAVE_EQ_1_TCCLKS_XC2 = 0x7
	// Position of CLKI field.
	TC_CMR1_WAVE_EQ_1_CLKI_Pos = 0x3
	// Bit mask of CLKI field.
	TC_CMR1_WAVE_EQ_1_CLKI_Msk = 0x8
	// Bit CLKI.
	TC_CMR1_WAVE_EQ_1_CLKI = 0x8
	// Position of BURST field.
	TC_CMR1_WAVE_EQ_1_BURST_Pos = 0x4
	// Bit mask of BURST field.
	TC_CMR1_WAVE_EQ_1_BURST_Msk = 0x30
	// The clock is not gated by an external signal.
	TC_CMR1_WAVE_EQ_1_BURST_NONE = 0x0
	// XC0 is ANDed with the selected clock.
	TC_CMR1_WAVE_EQ_1_BURST_XC0 = 0x1
	// XC1 is ANDed with the selected clock.
	TC_CMR1_WAVE_EQ_1_BURST_XC1 = 0x2
	// XC2 is ANDed with the selected clock.
	TC_CMR1_WAVE_EQ_1_BURST_XC2 = 0x3
	// Position of CPCSTOP field.
	TC_CMR1_WAVE_EQ_1_CPCSTOP_Pos = 0x6
	// Bit mask of CPCSTOP field.
	TC_CMR1_WAVE_EQ_1_CPCSTOP_Msk = 0x40
	// Bit CPCSTOP.
	TC_CMR1_WAVE_EQ_1_CPCSTOP = 0x40
	// Position of CPCDIS field.
	TC_CMR1_WAVE_EQ_1_CPCDIS_Pos = 0x7
	// Bit mask of CPCDIS field.
	TC_CMR1_WAVE_EQ_1_CPCDIS_Msk = 0x80
	// Bit CPCDIS.
	TC_CMR1_WAVE_EQ_1_CPCDIS = 0x80
	// Position of EEVTEDG field.
	TC_CMR1_WAVE_EQ_1_EEVTEDG_Pos = 0x8
	// Bit mask of EEVTEDG field.
	TC_CMR1_WAVE_EQ_1_EEVTEDG_Msk = 0x300
	// None
	TC_CMR1_WAVE_EQ_1_EEVTEDG_NONE = 0x0
	// Rising edge
	TC_CMR1_WAVE_EQ_1_EEVTEDG_RISING = 0x1
	// Falling edge
	TC_CMR1_WAVE_EQ_1_EEVTEDG_FALLING = 0x2
	// Each edge
	TC_CMR1_WAVE_EQ_1_EEVTEDG_EDGE = 0x3
	// Position of EEVT field.
	TC_CMR1_WAVE_EQ_1_EEVT_Pos = 0xa
	// Bit mask of EEVT field.
	TC_CMR1_WAVE_EQ_1_EEVT_Msk = 0xc00
	// TIOB
	TC_CMR1_WAVE_EQ_1_EEVT_TIOB = 0x0
	// XC0
	TC_CMR1_WAVE_EQ_1_EEVT_XC0 = 0x1
	// XC1
	TC_CMR1_WAVE_EQ_1_EEVT_XC1 = 0x2
	// XC2
	TC_CMR1_WAVE_EQ_1_EEVT_XC2 = 0x3
	// Position of ENETRG field.
	TC_CMR1_WAVE_EQ_1_ENETRG_Pos = 0xc
	// Bit mask of ENETRG field.
	TC_CMR1_WAVE_EQ_1_ENETRG_Msk = 0x1000
	// Bit ENETRG.
	TC_CMR1_WAVE_EQ_1_ENETRG = 0x1000
	// Position of WAVSEL field.
	TC_CMR1_WAVE_EQ_1_WAVSEL_Pos = 0xd
	// Bit mask of WAVSEL field.
	TC_CMR1_WAVE_EQ_1_WAVSEL_Msk = 0x6000
	// UP mode without automatic trigger on RC Compare
	TC_CMR1_WAVE_EQ_1_WAVSEL_UP = 0x0
	// UPDOWN mode without automatic trigger on RC Compare
	TC_CMR1_WAVE_EQ_1_WAVSEL_UPDOWN = 0x1
	// UP mode with automatic trigger on RC Compare
	TC_CMR1_WAVE_EQ_1_WAVSEL_UP_RC = 0x2
	// UPDOWN mode with automatic trigger on RC Compare
	TC_CMR1_WAVE_EQ_1_WAVSEL_UPDOWN_RC = 0x3
	// Position of WAVE field.
	TC_CMR1_WAVE_EQ_1_WAVE_Pos = 0xf
	// Bit mask of WAVE field.
	TC_CMR1_WAVE_EQ_1_WAVE_Msk = 0x8000
	// Bit WAVE.
	TC_CMR1_WAVE_EQ_1_WAVE = 0x8000
	// Position of ACPA field.
	TC_CMR1_WAVE_EQ_1_ACPA_Pos = 0x10
	// Bit mask of ACPA field.
	TC_CMR1_WAVE_EQ_1_ACPA_Msk = 0x30000
	// None
	TC_CMR1_WAVE_EQ_1_ACPA_NONE = 0x0
	// Set
	TC_CMR1_WAVE_EQ_1_ACPA_SET = 0x1
	// Clear
	TC_CMR1_WAVE_EQ_1_ACPA_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVE_EQ_1_ACPA_TOGGLE = 0x3
	// Position of ACPC field.
	TC_CMR1_WAVE_EQ_1_ACPC_Pos = 0x12
	// Bit mask of ACPC field.
	TC_CMR1_WAVE_EQ_1_ACPC_Msk = 0xc0000
	// None
	TC_CMR1_WAVE_EQ_1_ACPC_NONE = 0x0
	// Set
	TC_CMR1_WAVE_EQ_1_ACPC_SET = 0x1
	// Clear
	TC_CMR1_WAVE_EQ_1_ACPC_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVE_EQ_1_ACPC_TOGGLE = 0x3
	// Position of AEEVT field.
	TC_CMR1_WAVE_EQ_1_AEEVT_Pos = 0x14
	// Bit mask of AEEVT field.
	TC_CMR1_WAVE_EQ_1_AEEVT_Msk = 0x300000
	// None
	TC_CMR1_WAVE_EQ_1_AEEVT_NONE = 0x0
	// Set
	TC_CMR1_WAVE_EQ_1_AEEVT_SET = 0x1
	// Clear
	TC_CMR1_WAVE_EQ_1_AEEVT_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVE_EQ_1_AEEVT_TOGGLE = 0x3
	// Position of ASWTRG field.
	TC_CMR1_WAVE_EQ_1_ASWTRG_Pos = 0x16
	// Bit mask of ASWTRG field.
	TC_CMR1_WAVE_EQ_1_ASWTRG_Msk = 0xc00000
	// None
	TC_CMR1_WAVE_EQ_1_ASWTRG_NONE = 0x0
	// Set
	TC_CMR1_WAVE_EQ_1_ASWTRG_SET = 0x1
	// Clear
	TC_CMR1_WAVE_EQ_1_ASWTRG_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVE_EQ_1_ASWTRG_TOGGLE = 0x3
	// Position of BCPB field.
	TC_CMR1_WAVE_EQ_1_BCPB_Pos = 0x18
	// Bit mask of BCPB field.
	TC_CMR1_WAVE_EQ_1_BCPB_Msk = 0x3000000
	// None
	TC_CMR1_WAVE_EQ_1_BCPB_NONE = 0x0
	// Set
	TC_CMR1_WAVE_EQ_1_BCPB_SET = 0x1
	// Clear
	TC_CMR1_WAVE_EQ_1_BCPB_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVE_EQ_1_BCPB_TOGGLE = 0x3
	// Position of BCPC field.
	TC_CMR1_WAVE_EQ_1_BCPC_Pos = 0x1a
	// Bit mask of BCPC field.
	TC_CMR1_WAVE_EQ_1_BCPC_Msk = 0xc000000
	// None
	TC_CMR1_WAVE_EQ_1_BCPC_NONE = 0x0
	// Set
	TC_CMR1_WAVE_EQ_1_BCPC_SET = 0x1
	// Clear
	TC_CMR1_WAVE_EQ_1_BCPC_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVE_EQ_1_BCPC_TOGGLE = 0x3
	// Position of BEEVT field.
	TC_CMR1_WAVE_EQ_1_BEEVT_Pos = 0x1c
	// Bit mask of BEEVT field.
	TC_CMR1_WAVE_EQ_1_BEEVT_Msk = 0x30000000
	// None
	TC_CMR1_WAVE_EQ_1_BEEVT_NONE = 0x0
	// Set
	TC_CMR1_WAVE_EQ_1_BEEVT_SET = 0x1
	// Clear
	TC_CMR1_WAVE_EQ_1_BEEVT_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVE_EQ_1_BEEVT_TOGGLE = 0x3
	// Position of BSWTRG field.
	TC_CMR1_WAVE_EQ_1_BSWTRG_Pos = 0x1e
	// Bit mask of BSWTRG field.
	TC_CMR1_WAVE_EQ_1_BSWTRG_Msk = 0xc0000000
	// None
	TC_CMR1_WAVE_EQ_1_BSWTRG_NONE = 0x0
	// Set
	TC_CMR1_WAVE_EQ_1_BSWTRG_SET = 0x1
	// Clear
	TC_CMR1_WAVE_EQ_1_BSWTRG_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVE_EQ_1_BSWTRG_TOGGLE = 0x3

	// SMMR1: Stepper Motor Mode Register (channel = 1)
	// Position of GCEN field.
	TC_SMMR1_GCEN_Pos = 0x0
	// Bit mask of GCEN field.
	TC_SMMR1_GCEN_Msk = 0x1
	// Bit GCEN.
	TC_SMMR1_GCEN = 0x1
	// Position of DOWN field.
	TC_SMMR1_DOWN_Pos = 0x1
	// Bit mask of DOWN field.
	TC_SMMR1_DOWN_Msk = 0x2
	// Bit DOWN.
	TC_SMMR1_DOWN = 0x2

	// CV1: Counter Value (channel = 1)
	// Position of CV field.
	TC_CV1_CV_Pos = 0x0
	// Bit mask of CV field.
	TC_CV1_CV_Msk = 0xffffffff

	// RA1: Register A (channel = 1)
	// Position of RA field.
	TC_RA1_RA_Pos = 0x0
	// Bit mask of RA field.
	TC_RA1_RA_Msk = 0xffffffff

	// RB1: Register B (channel = 1)
	// Position of RB field.
	TC_RB1_RB_Pos = 0x0
	// Bit mask of RB field.
	TC_RB1_RB_Msk = 0xffffffff

	// RC1: Register C (channel = 1)
	// Position of RC field.
	TC_RC1_RC_Pos = 0x0
	// Bit mask of RC field.
	TC_RC1_RC_Msk = 0xffffffff

	// SR1: Status Register (channel = 1)
	// Position of COVFS field.
	TC_SR1_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_SR1_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_SR1_COVFS = 0x1
	// Position of LOVRS field.
	TC_SR1_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_SR1_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_SR1_LOVRS = 0x2
	// Position of CPAS field.
	TC_SR1_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_SR1_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_SR1_CPAS = 0x4
	// Position of CPBS field.
	TC_SR1_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_SR1_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_SR1_CPBS = 0x8
	// Position of CPCS field.
	TC_SR1_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_SR1_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_SR1_CPCS = 0x10
	// Position of LDRAS field.
	TC_SR1_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_SR1_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_SR1_LDRAS = 0x20
	// Position of LDRBS field.
	TC_SR1_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_SR1_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_SR1_LDRBS = 0x40
	// Position of ETRGS field.
	TC_SR1_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_SR1_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_SR1_ETRGS = 0x80
	// Position of CLKSTA field.
	TC_SR1_CLKSTA_Pos = 0x10
	// Bit mask of CLKSTA field.
	TC_SR1_CLKSTA_Msk = 0x10000
	// Bit CLKSTA.
	TC_SR1_CLKSTA = 0x10000
	// Position of MTIOA field.
	TC_SR1_MTIOA_Pos = 0x11
	// Bit mask of MTIOA field.
	TC_SR1_MTIOA_Msk = 0x20000
	// Bit MTIOA.
	TC_SR1_MTIOA = 0x20000
	// Position of MTIOB field.
	TC_SR1_MTIOB_Pos = 0x12
	// Bit mask of MTIOB field.
	TC_SR1_MTIOB_Msk = 0x40000
	// Bit MTIOB.
	TC_SR1_MTIOB = 0x40000

	// IER1: Interrupt Enable Register (channel = 1)
	// Position of COVFS field.
	TC_IER1_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IER1_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IER1_COVFS = 0x1
	// Position of LOVRS field.
	TC_IER1_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IER1_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IER1_LOVRS = 0x2
	// Position of CPAS field.
	TC_IER1_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IER1_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IER1_CPAS = 0x4
	// Position of CPBS field.
	TC_IER1_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IER1_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IER1_CPBS = 0x8
	// Position of CPCS field.
	TC_IER1_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IER1_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IER1_CPCS = 0x10
	// Position of LDRAS field.
	TC_IER1_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IER1_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IER1_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IER1_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IER1_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IER1_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IER1_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IER1_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IER1_ETRGS = 0x80

	// IDR1: Interrupt Disable Register (channel = 1)
	// Position of COVFS field.
	TC_IDR1_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IDR1_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IDR1_COVFS = 0x1
	// Position of LOVRS field.
	TC_IDR1_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IDR1_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IDR1_LOVRS = 0x2
	// Position of CPAS field.
	TC_IDR1_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IDR1_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IDR1_CPAS = 0x4
	// Position of CPBS field.
	TC_IDR1_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IDR1_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IDR1_CPBS = 0x8
	// Position of CPCS field.
	TC_IDR1_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IDR1_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IDR1_CPCS = 0x10
	// Position of LDRAS field.
	TC_IDR1_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IDR1_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IDR1_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IDR1_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IDR1_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IDR1_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IDR1_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IDR1_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IDR1_ETRGS = 0x80

	// IMR1: Interrupt Mask Register (channel = 1)
	// Position of COVFS field.
	TC_IMR1_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IMR1_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IMR1_COVFS = 0x1
	// Position of LOVRS field.
	TC_IMR1_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IMR1_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IMR1_LOVRS = 0x2
	// Position of CPAS field.
	TC_IMR1_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IMR1_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IMR1_CPAS = 0x4
	// Position of CPBS field.
	TC_IMR1_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IMR1_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IMR1_CPBS = 0x8
	// Position of CPCS field.
	TC_IMR1_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IMR1_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IMR1_CPCS = 0x10
	// Position of LDRAS field.
	TC_IMR1_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IMR1_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IMR1_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IMR1_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IMR1_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IMR1_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IMR1_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IMR1_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IMR1_ETRGS = 0x80

	// CCR2: Channel Control Register (channel = 2)
	// Position of CLKEN field.
	TC_CCR2_CLKEN_Pos = 0x0
	// Bit mask of CLKEN field.
	TC_CCR2_CLKEN_Msk = 0x1
	// Bit CLKEN.
	TC_CCR2_CLKEN = 0x1
	// Position of CLKDIS field.
	TC_CCR2_CLKDIS_Pos = 0x1
	// Bit mask of CLKDIS field.
	TC_CCR2_CLKDIS_Msk = 0x2
	// Bit CLKDIS.
	TC_CCR2_CLKDIS = 0x2
	// Position of SWTRG field.
	TC_CCR2_SWTRG_Pos = 0x2
	// Bit mask of SWTRG field.
	TC_CCR2_SWTRG_Msk = 0x4
	// Bit SWTRG.
	TC_CCR2_SWTRG = 0x4

	// CMR2: Channel Mode Register (channel = 2)
	// Position of TCCLKS field.
	TC_CMR2_TCCLKS_Pos = 0x0
	// Bit mask of TCCLKS field.
	TC_CMR2_TCCLKS_Msk = 0x7
	// Clock selected: TCLK1
	TC_CMR2_TCCLKS_TIMER_CLOCK1 = 0x0
	// Clock selected: TCLK2
	TC_CMR2_TCCLKS_TIMER_CLOCK2 = 0x1
	// Clock selected: TCLK3
	TC_CMR2_TCCLKS_TIMER_CLOCK3 = 0x2
	// Clock selected: TCLK4
	TC_CMR2_TCCLKS_TIMER_CLOCK4 = 0x3
	// Clock selected: TCLK5
	TC_CMR2_TCCLKS_TIMER_CLOCK5 = 0x4
	// Clock selected: XC0
	TC_CMR2_TCCLKS_XC0 = 0x5
	// Clock selected: XC1
	TC_CMR2_TCCLKS_XC1 = 0x6
	// Clock selected: XC2
	TC_CMR2_TCCLKS_XC2 = 0x7
	// Position of CLKI field.
	TC_CMR2_CLKI_Pos = 0x3
	// Bit mask of CLKI field.
	TC_CMR2_CLKI_Msk = 0x8
	// Bit CLKI.
	TC_CMR2_CLKI = 0x8
	// Position of BURST field.
	TC_CMR2_BURST_Pos = 0x4
	// Bit mask of BURST field.
	TC_CMR2_BURST_Msk = 0x30
	// The clock is not gated by an external signal.
	TC_CMR2_BURST_NONE = 0x0
	// XC0 is ANDed with the selected clock.
	TC_CMR2_BURST_XC0 = 0x1
	// XC1 is ANDed with the selected clock.
	TC_CMR2_BURST_XC1 = 0x2
	// XC2 is ANDed with the selected clock.
	TC_CMR2_BURST_XC2 = 0x3
	// Position of LDBSTOP field.
	TC_CMR2_LDBSTOP_Pos = 0x6
	// Bit mask of LDBSTOP field.
	TC_CMR2_LDBSTOP_Msk = 0x40
	// Bit LDBSTOP.
	TC_CMR2_LDBSTOP = 0x40
	// Position of LDBDIS field.
	TC_CMR2_LDBDIS_Pos = 0x7
	// Bit mask of LDBDIS field.
	TC_CMR2_LDBDIS_Msk = 0x80
	// Bit LDBDIS.
	TC_CMR2_LDBDIS = 0x80
	// Position of ETRGEDG field.
	TC_CMR2_ETRGEDG_Pos = 0x8
	// Bit mask of ETRGEDG field.
	TC_CMR2_ETRGEDG_Msk = 0x300
	// The clock is not gated by an external signal.
	TC_CMR2_ETRGEDG_NONE = 0x0
	// Rising edge
	TC_CMR2_ETRGEDG_RISING = 0x1
	// Falling edge
	TC_CMR2_ETRGEDG_FALLING = 0x2
	// Each edge
	TC_CMR2_ETRGEDG_EDGE = 0x3
	// Position of ABETRG field.
	TC_CMR2_ABETRG_Pos = 0xa
	// Bit mask of ABETRG field.
	TC_CMR2_ABETRG_Msk = 0x400
	// Bit ABETRG.
	TC_CMR2_ABETRG = 0x400
	// Position of CPCTRG field.
	TC_CMR2_CPCTRG_Pos = 0xe
	// Bit mask of CPCTRG field.
	TC_CMR2_CPCTRG_Msk = 0x4000
	// Bit CPCTRG.
	TC_CMR2_CPCTRG = 0x4000
	// Position of WAVE field.
	TC_CMR2_WAVE_Pos = 0xf
	// Bit mask of WAVE field.
	TC_CMR2_WAVE_Msk = 0x8000
	// Bit WAVE.
	TC_CMR2_WAVE = 0x8000
	// Position of LDRA field.
	TC_CMR2_LDRA_Pos = 0x10
	// Bit mask of LDRA field.
	TC_CMR2_LDRA_Msk = 0x30000
	// None
	TC_CMR2_LDRA_NONE = 0x0
	// Rising edge of TIOA
	TC_CMR2_LDRA_RISING = 0x1
	// Falling edge of TIOA
	TC_CMR2_LDRA_FALLING = 0x2
	// Each edge of TIOA
	TC_CMR2_LDRA_EDGE = 0x3
	// Position of LDRB field.
	TC_CMR2_LDRB_Pos = 0x12
	// Bit mask of LDRB field.
	TC_CMR2_LDRB_Msk = 0xc0000
	// None
	TC_CMR2_LDRB_NONE = 0x0
	// Rising edge of TIOA
	TC_CMR2_LDRB_RISING = 0x1
	// Falling edge of TIOA
	TC_CMR2_LDRB_FALLING = 0x2
	// Each edge of TIOA
	TC_CMR2_LDRB_EDGE = 0x3

	// CMR2_WAVE_EQ_1: Channel Mode Register (channel = 2)
	// Position of TCCLKS field.
	TC_CMR2_WAVE_EQ_1_TCCLKS_Pos = 0x0
	// Bit mask of TCCLKS field.
	TC_CMR2_WAVE_EQ_1_TCCLKS_Msk = 0x7
	// Clock selected: TCLK1
	TC_CMR2_WAVE_EQ_1_TCCLKS_TIMER_CLOCK1 = 0x0
	// Clock selected: TCLK2
	TC_CMR2_WAVE_EQ_1_TCCLKS_TIMER_CLOCK2 = 0x1
	// Clock selected: TCLK3
	TC_CMR2_WAVE_EQ_1_TCCLKS_TIMER_CLOCK3 = 0x2
	// Clock selected: TCLK4
	TC_CMR2_WAVE_EQ_1_TCCLKS_TIMER_CLOCK4 = 0x3
	// Clock selected: TCLK5
	TC_CMR2_WAVE_EQ_1_TCCLKS_TIMER_CLOCK5 = 0x4
	// Clock selected: XC0
	TC_CMR2_WAVE_EQ_1_TCCLKS_XC0 = 0x5
	// Clock selected: XC1
	TC_CMR2_WAVE_EQ_1_TCCLKS_XC1 = 0x6
	// Clock selected: XC2
	TC_CMR2_WAVE_EQ_1_TCCLKS_XC2 = 0x7
	// Position of CLKI field.
	TC_CMR2_WAVE_EQ_1_CLKI_Pos = 0x3
	// Bit mask of CLKI field.
	TC_CMR2_WAVE_EQ_1_CLKI_Msk = 0x8
	// Bit CLKI.
	TC_CMR2_WAVE_EQ_1_CLKI = 0x8
	// Position of BURST field.
	TC_CMR2_WAVE_EQ_1_BURST_Pos = 0x4
	// Bit mask of BURST field.
	TC_CMR2_WAVE_EQ_1_BURST_Msk = 0x30
	// The clock is not gated by an external signal.
	TC_CMR2_WAVE_EQ_1_BURST_NONE = 0x0
	// XC0 is ANDed with the selected clock.
	TC_CMR2_WAVE_EQ_1_BURST_XC0 = 0x1
	// XC1 is ANDed with the selected clock.
	TC_CMR2_WAVE_EQ_1_BURST_XC1 = 0x2
	// XC2 is ANDed with the selected clock.
	TC_CMR2_WAVE_EQ_1_BURST_XC2 = 0x3
	// Position of CPCSTOP field.
	TC_CMR2_WAVE_EQ_1_CPCSTOP_Pos = 0x6
	// Bit mask of CPCSTOP field.
	TC_CMR2_WAVE_EQ_1_CPCSTOP_Msk = 0x40
	// Bit CPCSTOP.
	TC_CMR2_WAVE_EQ_1_CPCSTOP = 0x40
	// Position of CPCDIS field.
	TC_CMR2_WAVE_EQ_1_CPCDIS_Pos = 0x7
	// Bit mask of CPCDIS field.
	TC_CMR2_WAVE_EQ_1_CPCDIS_Msk = 0x80
	// Bit CPCDIS.
	TC_CMR2_WAVE_EQ_1_CPCDIS = 0x80
	// Position of EEVTEDG field.
	TC_CMR2_WAVE_EQ_1_EEVTEDG_Pos = 0x8
	// Bit mask of EEVTEDG field.
	TC_CMR2_WAVE_EQ_1_EEVTEDG_Msk = 0x300
	// None
	TC_CMR2_WAVE_EQ_1_EEVTEDG_NONE = 0x0
	// Rising edge
	TC_CMR2_WAVE_EQ_1_EEVTEDG_RISING = 0x1
	// Falling edge
	TC_CMR2_WAVE_EQ_1_EEVTEDG_FALLING = 0x2
	// Each edge
	TC_CMR2_WAVE_EQ_1_EEVTEDG_EDGE = 0x3
	// Position of EEVT field.
	TC_CMR2_WAVE_EQ_1_EEVT_Pos = 0xa
	// Bit mask of EEVT field.
	TC_CMR2_WAVE_EQ_1_EEVT_Msk = 0xc00
	// TIOB
	TC_CMR2_WAVE_EQ_1_EEVT_TIOB = 0x0
	// XC0
	TC_CMR2_WAVE_EQ_1_EEVT_XC0 = 0x1
	// XC1
	TC_CMR2_WAVE_EQ_1_EEVT_XC1 = 0x2
	// XC2
	TC_CMR2_WAVE_EQ_1_EEVT_XC2 = 0x3
	// Position of ENETRG field.
	TC_CMR2_WAVE_EQ_1_ENETRG_Pos = 0xc
	// Bit mask of ENETRG field.
	TC_CMR2_WAVE_EQ_1_ENETRG_Msk = 0x1000
	// Bit ENETRG.
	TC_CMR2_WAVE_EQ_1_ENETRG = 0x1000
	// Position of WAVSEL field.
	TC_CMR2_WAVE_EQ_1_WAVSEL_Pos = 0xd
	// Bit mask of WAVSEL field.
	TC_CMR2_WAVE_EQ_1_WAVSEL_Msk = 0x6000
	// UP mode without automatic trigger on RC Compare
	TC_CMR2_WAVE_EQ_1_WAVSEL_UP = 0x0
	// UPDOWN mode without automatic trigger on RC Compare
	TC_CMR2_WAVE_EQ_1_WAVSEL_UPDOWN = 0x1
	// UP mode with automatic trigger on RC Compare
	TC_CMR2_WAVE_EQ_1_WAVSEL_UP_RC = 0x2
	// UPDOWN mode with automatic trigger on RC Compare
	TC_CMR2_WAVE_EQ_1_WAVSEL_UPDOWN_RC = 0x3
	// Position of WAVE field.
	TC_CMR2_WAVE_EQ_1_WAVE_Pos = 0xf
	// Bit mask of WAVE field.
	TC_CMR2_WAVE_EQ_1_WAVE_Msk = 0x8000
	// Bit WAVE.
	TC_CMR2_WAVE_EQ_1_WAVE = 0x8000
	// Position of ACPA field.
	TC_CMR2_WAVE_EQ_1_ACPA_Pos = 0x10
	// Bit mask of ACPA field.
	TC_CMR2_WAVE_EQ_1_ACPA_Msk = 0x30000
	// None
	TC_CMR2_WAVE_EQ_1_ACPA_NONE = 0x0
	// Set
	TC_CMR2_WAVE_EQ_1_ACPA_SET = 0x1
	// Clear
	TC_CMR2_WAVE_EQ_1_ACPA_CLEAR = 0x2
	// Toggle
	TC_CMR2_WAVE_EQ_1_ACPA_TOGGLE = 0x3
	// Position of ACPC field.
	TC_CMR2_WAVE_EQ_1_ACPC_Pos = 0x12
	// Bit mask of ACPC field.
	TC_CMR2_WAVE_EQ_1_ACPC_Msk = 0xc0000
	// None
	TC_CMR2_WAVE_EQ_1_ACPC_NONE = 0x0
	// Set
	TC_CMR2_WAVE_EQ_1_ACPC_SET = 0x1
	// Clear
	TC_CMR2_WAVE_EQ_1_ACPC_CLEAR = 0x2
	// Toggle
	TC_CMR2_WAVE_EQ_1_ACPC_TOGGLE = 0x3
	// Position of AEEVT field.
	TC_CMR2_WAVE_EQ_1_AEEVT_Pos = 0x14
	// Bit mask of AEEVT field.
	TC_CMR2_WAVE_EQ_1_AEEVT_Msk = 0x300000
	// None
	TC_CMR2_WAVE_EQ_1_AEEVT_NONE = 0x0
	// Set
	TC_CMR2_WAVE_EQ_1_AEEVT_SET = 0x1
	// Clear
	TC_CMR2_WAVE_EQ_1_AEEVT_CLEAR = 0x2
	// Toggle
	TC_CMR2_WAVE_EQ_1_AEEVT_TOGGLE = 0x3
	// Position of ASWTRG field.
	TC_CMR2_WAVE_EQ_1_ASWTRG_Pos = 0x16
	// Bit mask of ASWTRG field.
	TC_CMR2_WAVE_EQ_1_ASWTRG_Msk = 0xc00000
	// None
	TC_CMR2_WAVE_EQ_1_ASWTRG_NONE = 0x0
	// Set
	TC_CMR2_WAVE_EQ_1_ASWTRG_SET = 0x1
	// Clear
	TC_CMR2_WAVE_EQ_1_ASWTRG_CLEAR = 0x2
	// Toggle
	TC_CMR2_WAVE_EQ_1_ASWTRG_TOGGLE = 0x3
	// Position of BCPB field.
	TC_CMR2_WAVE_EQ_1_BCPB_Pos = 0x18
	// Bit mask of BCPB field.
	TC_CMR2_WAVE_EQ_1_BCPB_Msk = 0x3000000
	// None
	TC_CMR2_WAVE_EQ_1_BCPB_NONE = 0x0
	// Set
	TC_CMR2_WAVE_EQ_1_BCPB_SET = 0x1
	// Clear
	TC_CMR2_WAVE_EQ_1_BCPB_CLEAR = 0x2
	// Toggle
	TC_CMR2_WAVE_EQ_1_BCPB_TOGGLE = 0x3
	// Position of BCPC field.
	TC_CMR2_WAVE_EQ_1_BCPC_Pos = 0x1a
	// Bit mask of BCPC field.
	TC_CMR2_WAVE_EQ_1_BCPC_Msk = 0xc000000
	// None
	TC_CMR2_WAVE_EQ_1_BCPC_NONE = 0x0
	// Set
	TC_CMR2_WAVE_EQ_1_BCPC_SET = 0x1
	// Clear
	TC_CMR2_WAVE_EQ_1_BCPC_CLEAR = 0x2
	// Toggle
	TC_CMR2_WAVE_EQ_1_BCPC_TOGGLE = 0x3
	// Position of BEEVT field.
	TC_CMR2_WAVE_EQ_1_BEEVT_Pos = 0x1c
	// Bit mask of BEEVT field.
	TC_CMR2_WAVE_EQ_1_BEEVT_Msk = 0x30000000
	// None
	TC_CMR2_WAVE_EQ_1_BEEVT_NONE = 0x0
	// Set
	TC_CMR2_WAVE_EQ_1_BEEVT_SET = 0x1
	// Clear
	TC_CMR2_WAVE_EQ_1_BEEVT_CLEAR = 0x2
	// Toggle
	TC_CMR2_WAVE_EQ_1_BEEVT_TOGGLE = 0x3
	// Position of BSWTRG field.
	TC_CMR2_WAVE_EQ_1_BSWTRG_Pos = 0x1e
	// Bit mask of BSWTRG field.
	TC_CMR2_WAVE_EQ_1_BSWTRG_Msk = 0xc0000000
	// None
	TC_CMR2_WAVE_EQ_1_BSWTRG_NONE = 0x0
	// Set
	TC_CMR2_WAVE_EQ_1_BSWTRG_SET = 0x1
	// Clear
	TC_CMR2_WAVE_EQ_1_BSWTRG_CLEAR = 0x2
	// Toggle
	TC_CMR2_WAVE_EQ_1_BSWTRG_TOGGLE = 0x3

	// SMMR2: Stepper Motor Mode Register (channel = 2)
	// Position of GCEN field.
	TC_SMMR2_GCEN_Pos = 0x0
	// Bit mask of GCEN field.
	TC_SMMR2_GCEN_Msk = 0x1
	// Bit GCEN.
	TC_SMMR2_GCEN = 0x1
	// Position of DOWN field.
	TC_SMMR2_DOWN_Pos = 0x1
	// Bit mask of DOWN field.
	TC_SMMR2_DOWN_Msk = 0x2
	// Bit DOWN.
	TC_SMMR2_DOWN = 0x2

	// CV2: Counter Value (channel = 2)
	// Position of CV field.
	TC_CV2_CV_Pos = 0x0
	// Bit mask of CV field.
	TC_CV2_CV_Msk = 0xffffffff

	// RA2: Register A (channel = 2)
	// Position of RA field.
	TC_RA2_RA_Pos = 0x0
	// Bit mask of RA field.
	TC_RA2_RA_Msk = 0xffffffff

	// RB2: Register B (channel = 2)
	// Position of RB field.
	TC_RB2_RB_Pos = 0x0
	// Bit mask of RB field.
	TC_RB2_RB_Msk = 0xffffffff

	// RC2: Register C (channel = 2)
	// Position of RC field.
	TC_RC2_RC_Pos = 0x0
	// Bit mask of RC field.
	TC_RC2_RC_Msk = 0xffffffff

	// SR2: Status Register (channel = 2)
	// Position of COVFS field.
	TC_SR2_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_SR2_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_SR2_COVFS = 0x1
	// Position of LOVRS field.
	TC_SR2_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_SR2_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_SR2_LOVRS = 0x2
	// Position of CPAS field.
	TC_SR2_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_SR2_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_SR2_CPAS = 0x4
	// Position of CPBS field.
	TC_SR2_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_SR2_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_SR2_CPBS = 0x8
	// Position of CPCS field.
	TC_SR2_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_SR2_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_SR2_CPCS = 0x10
	// Position of LDRAS field.
	TC_SR2_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_SR2_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_SR2_LDRAS = 0x20
	// Position of LDRBS field.
	TC_SR2_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_SR2_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_SR2_LDRBS = 0x40
	// Position of ETRGS field.
	TC_SR2_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_SR2_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_SR2_ETRGS = 0x80
	// Position of CLKSTA field.
	TC_SR2_CLKSTA_Pos = 0x10
	// Bit mask of CLKSTA field.
	TC_SR2_CLKSTA_Msk = 0x10000
	// Bit CLKSTA.
	TC_SR2_CLKSTA = 0x10000
	// Position of MTIOA field.
	TC_SR2_MTIOA_Pos = 0x11
	// Bit mask of MTIOA field.
	TC_SR2_MTIOA_Msk = 0x20000
	// Bit MTIOA.
	TC_SR2_MTIOA = 0x20000
	// Position of MTIOB field.
	TC_SR2_MTIOB_Pos = 0x12
	// Bit mask of MTIOB field.
	TC_SR2_MTIOB_Msk = 0x40000
	// Bit MTIOB.
	TC_SR2_MTIOB = 0x40000

	// IER2: Interrupt Enable Register (channel = 2)
	// Position of COVFS field.
	TC_IER2_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IER2_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IER2_COVFS = 0x1
	// Position of LOVRS field.
	TC_IER2_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IER2_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IER2_LOVRS = 0x2
	// Position of CPAS field.
	TC_IER2_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IER2_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IER2_CPAS = 0x4
	// Position of CPBS field.
	TC_IER2_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IER2_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IER2_CPBS = 0x8
	// Position of CPCS field.
	TC_IER2_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IER2_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IER2_CPCS = 0x10
	// Position of LDRAS field.
	TC_IER2_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IER2_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IER2_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IER2_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IER2_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IER2_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IER2_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IER2_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IER2_ETRGS = 0x80

	// IDR2: Interrupt Disable Register (channel = 2)
	// Position of COVFS field.
	TC_IDR2_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IDR2_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IDR2_COVFS = 0x1
	// Position of LOVRS field.
	TC_IDR2_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IDR2_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IDR2_LOVRS = 0x2
	// Position of CPAS field.
	TC_IDR2_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IDR2_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IDR2_CPAS = 0x4
	// Position of CPBS field.
	TC_IDR2_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IDR2_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IDR2_CPBS = 0x8
	// Position of CPCS field.
	TC_IDR2_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IDR2_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IDR2_CPCS = 0x10
	// Position of LDRAS field.
	TC_IDR2_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IDR2_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IDR2_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IDR2_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IDR2_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IDR2_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IDR2_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IDR2_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IDR2_ETRGS = 0x80

	// IMR2: Interrupt Mask Register (channel = 2)
	// Position of COVFS field.
	TC_IMR2_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IMR2_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IMR2_COVFS = 0x1
	// Position of LOVRS field.
	TC_IMR2_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IMR2_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IMR2_LOVRS = 0x2
	// Position of CPAS field.
	TC_IMR2_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IMR2_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IMR2_CPAS = 0x4
	// Position of CPBS field.
	TC_IMR2_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IMR2_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IMR2_CPBS = 0x8
	// Position of CPCS field.
	TC_IMR2_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IMR2_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IMR2_CPCS = 0x10
	// Position of LDRAS field.
	TC_IMR2_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IMR2_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IMR2_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IMR2_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IMR2_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IMR2_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IMR2_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IMR2_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IMR2_ETRGS = 0x80

	// BCR: Block Control Register
	// Position of SYNC field.
	TC_BCR_SYNC_Pos = 0x0
	// Bit mask of SYNC field.
	TC_BCR_SYNC_Msk = 0x1
	// Bit SYNC.
	TC_BCR_SYNC = 0x1

	// BMR: Block Mode Register
	// Position of TC0XC0S field.
	TC_BMR_TC0XC0S_Pos = 0x0
	// Bit mask of TC0XC0S field.
	TC_BMR_TC0XC0S_Msk = 0x3
	// Signal connected to XC0: TCLK0
	TC_BMR_TC0XC0S_TCLK0 = 0x0
	// Signal connected to XC0: TIOA1
	TC_BMR_TC0XC0S_TIOA1 = 0x2
	// Signal connected to XC0: TIOA2
	TC_BMR_TC0XC0S_TIOA2 = 0x3
	// Position of TC1XC1S field.
	TC_BMR_TC1XC1S_Pos = 0x2
	// Bit mask of TC1XC1S field.
	TC_BMR_TC1XC1S_Msk = 0xc
	// Signal connected to XC1: TCLK1
	TC_BMR_TC1XC1S_TCLK1 = 0x0
	// Signal connected to XC1: TIOA0
	TC_BMR_TC1XC1S_TIOA0 = 0x2
	// Signal connected to XC1: TIOA2
	TC_BMR_TC1XC1S_TIOA2 = 0x3
	// Position of TC2XC2S field.
	TC_BMR_TC2XC2S_Pos = 0x4
	// Bit mask of TC2XC2S field.
	TC_BMR_TC2XC2S_Msk = 0x30
	// Signal connected to XC2: TCLK2
	TC_BMR_TC2XC2S_TCLK2 = 0x0
	// Signal connected to XC2: TIOA1
	TC_BMR_TC2XC2S_TIOA1 = 0x2
	// Signal connected to XC2: TIOA2
	TC_BMR_TC2XC2S_TIOA2 = 0x3
	// Position of QDEN field.
	TC_BMR_QDEN_Pos = 0x8
	// Bit mask of QDEN field.
	TC_BMR_QDEN_Msk = 0x100
	// Bit QDEN.
	TC_BMR_QDEN = 0x100
	// Position of POSEN field.
	TC_BMR_POSEN_Pos = 0x9
	// Bit mask of POSEN field.
	TC_BMR_POSEN_Msk = 0x200
	// Bit POSEN.
	TC_BMR_POSEN = 0x200
	// Position of SPEEDEN field.
	TC_BMR_SPEEDEN_Pos = 0xa
	// Bit mask of SPEEDEN field.
	TC_BMR_SPEEDEN_Msk = 0x400
	// Bit SPEEDEN.
	TC_BMR_SPEEDEN = 0x400
	// Position of QDTRANS field.
	TC_BMR_QDTRANS_Pos = 0xb
	// Bit mask of QDTRANS field.
	TC_BMR_QDTRANS_Msk = 0x800
	// Bit QDTRANS.
	TC_BMR_QDTRANS = 0x800
	// Position of EDGPHA field.
	TC_BMR_EDGPHA_Pos = 0xc
	// Bit mask of EDGPHA field.
	TC_BMR_EDGPHA_Msk = 0x1000
	// Bit EDGPHA.
	TC_BMR_EDGPHA = 0x1000
	// Position of INVA field.
	TC_BMR_INVA_Pos = 0xd
	// Bit mask of INVA field.
	TC_BMR_INVA_Msk = 0x2000
	// Bit INVA.
	TC_BMR_INVA = 0x2000
	// Position of INVB field.
	TC_BMR_INVB_Pos = 0xe
	// Bit mask of INVB field.
	TC_BMR_INVB_Msk = 0x4000
	// Bit INVB.
	TC_BMR_INVB = 0x4000
	// Position of INVIDX field.
	TC_BMR_INVIDX_Pos = 0xf
	// Bit mask of INVIDX field.
	TC_BMR_INVIDX_Msk = 0x8000
	// Bit INVIDX.
	TC_BMR_INVIDX = 0x8000
	// Position of SWAP field.
	TC_BMR_SWAP_Pos = 0x10
	// Bit mask of SWAP field.
	TC_BMR_SWAP_Msk = 0x10000
	// Bit SWAP.
	TC_BMR_SWAP = 0x10000
	// Position of IDXPHB field.
	TC_BMR_IDXPHB_Pos = 0x11
	// Bit mask of IDXPHB field.
	TC_BMR_IDXPHB_Msk = 0x20000
	// Bit IDXPHB.
	TC_BMR_IDXPHB = 0x20000
	// Position of FILTER field.
	TC_BMR_FILTER_Pos = 0x13
	// Bit mask of FILTER field.
	TC_BMR_FILTER_Msk = 0x80000
	// Bit FILTER.
	TC_BMR_FILTER = 0x80000
	// Position of MAXFILT field.
	TC_BMR_MAXFILT_Pos = 0x14
	// Bit mask of MAXFILT field.
	TC_BMR_MAXFILT_Msk = 0x3f00000

	// QIER: QDEC Interrupt Enable Register
	// Position of IDX field.
	TC_QIER_IDX_Pos = 0x0
	// Bit mask of IDX field.
	TC_QIER_IDX_Msk = 0x1
	// Bit IDX.
	TC_QIER_IDX = 0x1
	// Position of DIRCHG field.
	TC_QIER_DIRCHG_Pos = 0x1
	// Bit mask of DIRCHG field.
	TC_QIER_DIRCHG_Msk = 0x2
	// Bit DIRCHG.
	TC_QIER_DIRCHG = 0x2
	// Position of QERR field.
	TC_QIER_QERR_Pos = 0x2
	// Bit mask of QERR field.
	TC_QIER_QERR_Msk = 0x4
	// Bit QERR.
	TC_QIER_QERR = 0x4

	// QIDR: QDEC Interrupt Disable Register
	// Position of IDX field.
	TC_QIDR_IDX_Pos = 0x0
	// Bit mask of IDX field.
	TC_QIDR_IDX_Msk = 0x1
	// Bit IDX.
	TC_QIDR_IDX = 0x1
	// Position of DIRCHG field.
	TC_QIDR_DIRCHG_Pos = 0x1
	// Bit mask of DIRCHG field.
	TC_QIDR_DIRCHG_Msk = 0x2
	// Bit DIRCHG.
	TC_QIDR_DIRCHG = 0x2
	// Position of QERR field.
	TC_QIDR_QERR_Pos = 0x2
	// Bit mask of QERR field.
	TC_QIDR_QERR_Msk = 0x4
	// Bit QERR.
	TC_QIDR_QERR = 0x4

	// QIMR: QDEC Interrupt Mask Register
	// Position of IDX field.
	TC_QIMR_IDX_Pos = 0x0
	// Bit mask of IDX field.
	TC_QIMR_IDX_Msk = 0x1
	// Bit IDX.
	TC_QIMR_IDX = 0x1
	// Position of DIRCHG field.
	TC_QIMR_DIRCHG_Pos = 0x1
	// Bit mask of DIRCHG field.
	TC_QIMR_DIRCHG_Msk = 0x2
	// Bit DIRCHG.
	TC_QIMR_DIRCHG = 0x2
	// Position of QERR field.
	TC_QIMR_QERR_Pos = 0x2
	// Bit mask of QERR field.
	TC_QIMR_QERR_Msk = 0x4
	// Bit QERR.
	TC_QIMR_QERR = 0x4

	// QISR: QDEC Interrupt Status Register
	// Position of IDX field.
	TC_QISR_IDX_Pos = 0x0
	// Bit mask of IDX field.
	TC_QISR_IDX_Msk = 0x1
	// Bit IDX.
	TC_QISR_IDX = 0x1
	// Position of DIRCHG field.
	TC_QISR_DIRCHG_Pos = 0x1
	// Bit mask of DIRCHG field.
	TC_QISR_DIRCHG_Msk = 0x2
	// Bit DIRCHG.
	TC_QISR_DIRCHG = 0x2
	// Position of QERR field.
	TC_QISR_QERR_Pos = 0x2
	// Bit mask of QERR field.
	TC_QISR_QERR_Msk = 0x4
	// Bit QERR.
	TC_QISR_QERR = 0x4
	// Position of DIR field.
	TC_QISR_DIR_Pos = 0x8
	// Bit mask of DIR field.
	TC_QISR_DIR_Msk = 0x100
	// Bit DIR.
	TC_QISR_DIR = 0x100

	// FMR: Fault Mode Register
	// Position of ENCF0 field.
	TC_FMR_ENCF0_Pos = 0x0
	// Bit mask of ENCF0 field.
	TC_FMR_ENCF0_Msk = 0x1
	// Bit ENCF0.
	TC_FMR_ENCF0 = 0x1
	// Position of ENCF1 field.
	TC_FMR_ENCF1_Pos = 0x1
	// Bit mask of ENCF1 field.
	TC_FMR_ENCF1_Msk = 0x2
	// Bit ENCF1.
	TC_FMR_ENCF1 = 0x2

	// WPMR: Write Protect Mode Register
	// Position of WPEN field.
	TC_WPMR_WPEN_Pos = 0x0
	// Bit mask of WPEN field.
	TC_WPMR_WPEN_Msk = 0x1
	// Bit WPEN.
	TC_WPMR_WPEN = 0x1
	// Position of WPKEY field.
	TC_WPMR_WPKEY_Pos = 0x8
	// Bit mask of WPKEY field.
	TC_WPMR_WPKEY_Msk = 0xffffff00
	// Writing any other value in this field aborts the write operation of the WPEN bit.Always reads as 0.
	TC_WPMR_WPKEY_PASSWD = 0x54494d
)

// Bitfields for TWI0: Two-wire Interface 0
const (
	// CR: Control Register
	// Position of START field.
	TWI_CR_START_Pos = 0x0
	// Bit mask of START field.
	TWI_CR_START_Msk = 0x1
	// Bit START.
	TWI_CR_START = 0x1
	// Position of STOP field.
	TWI_CR_STOP_Pos = 0x1
	// Bit mask of STOP field.
	TWI_CR_STOP_Msk = 0x2
	// Bit STOP.
	TWI_CR_STOP = 0x2
	// Position of MSEN field.
	TWI_CR_MSEN_Pos = 0x2
	// Bit mask of MSEN field.
	TWI_CR_MSEN_Msk = 0x4
	// Bit MSEN.
	TWI_CR_MSEN = 0x4
	// Position of MSDIS field.
	TWI_CR_MSDIS_Pos = 0x3
	// Bit mask of MSDIS field.
	TWI_CR_MSDIS_Msk = 0x8
	// Bit MSDIS.
	TWI_CR_MSDIS = 0x8
	// Position of SVEN field.
	TWI_CR_SVEN_Pos = 0x4
	// Bit mask of SVEN field.
	TWI_CR_SVEN_Msk = 0x10
	// Bit SVEN.
	TWI_CR_SVEN = 0x10
	// Position of SVDIS field.
	TWI_CR_SVDIS_Pos = 0x5
	// Bit mask of SVDIS field.
	TWI_CR_SVDIS_Msk = 0x20
	// Bit SVDIS.
	TWI_CR_SVDIS = 0x20
	// Position of QUICK field.
	TWI_CR_QUICK_Pos = 0x6
	// Bit mask of QUICK field.
	TWI_CR_QUICK_Msk = 0x40
	// Bit QUICK.
	TWI_CR_QUICK = 0x40
	// Position of SWRST field.
	TWI_CR_SWRST_Pos = 0x7
	// Bit mask of SWRST field.
	TWI_CR_SWRST_Msk = 0x80
	// Bit SWRST.
	TWI_CR_SWRST = 0x80

	// MMR: Master Mode Register
	// Position of IADRSZ field.
	TWI_MMR_IADRSZ_Pos = 0x8
	// Bit mask of IADRSZ field.
	TWI_MMR_IADRSZ_Msk = 0x300
	// No internal device address
	TWI_MMR_IADRSZ_NONE = 0x0
	// One-byte internal device address
	TWI_MMR_IADRSZ_1_BYTE = 0x1
	// Two-byte internal device address
	TWI_MMR_IADRSZ_2_BYTE = 0x2
	// Three-byte internal device address
	TWI_MMR_IADRSZ_3_BYTE = 0x3
	// Position of MREAD field.
	TWI_MMR_MREAD_Pos = 0xc
	// Bit mask of MREAD field.
	TWI_MMR_MREAD_Msk = 0x1000
	// Bit MREAD.
	TWI_MMR_MREAD = 0x1000
	// Position of DADR field.
	TWI_MMR_DADR_Pos = 0x10
	// Bit mask of DADR field.
	TWI_MMR_DADR_Msk = 0x7f0000

	// SMR: Slave Mode Register
	// Position of SADR field.
	TWI_SMR_SADR_Pos = 0x10
	// Bit mask of SADR field.
	TWI_SMR_SADR_Msk = 0x7f0000

	// IADR: Internal Address Register
	// Position of IADR field.
	TWI_IADR_IADR_Pos = 0x0
	// Bit mask of IADR field.
	TWI_IADR_IADR_Msk = 0xffffff

	// CWGR: Clock Waveform Generator Register
	// Position of CLDIV field.
	TWI_CWGR_CLDIV_Pos = 0x0
	// Bit mask of CLDIV field.
	TWI_CWGR_CLDIV_Msk = 0xff
	// Position of CHDIV field.
	TWI_CWGR_CHDIV_Pos = 0x8
	// Bit mask of CHDIV field.
	TWI_CWGR_CHDIV_Msk = 0xff00
	// Position of CKDIV field.
	TWI_CWGR_CKDIV_Pos = 0x10
	// Bit mask of CKDIV field.
	TWI_CWGR_CKDIV_Msk = 0x70000

	// SR: Status Register
	// Position of TXCOMP field.
	TWI_SR_TXCOMP_Pos = 0x0
	// Bit mask of TXCOMP field.
	TWI_SR_TXCOMP_Msk = 0x1
	// Bit TXCOMP.
	TWI_SR_TXCOMP = 0x1
	// Position of RXRDY field.
	TWI_SR_RXRDY_Pos = 0x1
	// Bit mask of RXRDY field.
	TWI_SR_RXRDY_Msk = 0x2
	// Bit RXRDY.
	TWI_SR_RXRDY = 0x2
	// Position of TXRDY field.
	TWI_SR_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	TWI_SR_TXRDY_Msk = 0x4
	// Bit TXRDY.
	TWI_SR_TXRDY = 0x4
	// Position of SVREAD field.
	TWI_SR_SVREAD_Pos = 0x3
	// Bit mask of SVREAD field.
	TWI_SR_SVREAD_Msk = 0x8
	// Bit SVREAD.
	TWI_SR_SVREAD = 0x8
	// Position of SVACC field.
	TWI_SR_SVACC_Pos = 0x4
	// Bit mask of SVACC field.
	TWI_SR_SVACC_Msk = 0x10
	// Bit SVACC.
	TWI_SR_SVACC = 0x10
	// Position of GACC field.
	TWI_SR_GACC_Pos = 0x5
	// Bit mask of GACC field.
	TWI_SR_GACC_Msk = 0x20
	// Bit GACC.
	TWI_SR_GACC = 0x20
	// Position of OVRE field.
	TWI_SR_OVRE_Pos = 0x6
	// Bit mask of OVRE field.
	TWI_SR_OVRE_Msk = 0x40
	// Bit OVRE.
	TWI_SR_OVRE = 0x40
	// Position of NACK field.
	TWI_SR_NACK_Pos = 0x8
	// Bit mask of NACK field.
	TWI_SR_NACK_Msk = 0x100
	// Bit NACK.
	TWI_SR_NACK = 0x100
	// Position of ARBLST field.
	TWI_SR_ARBLST_Pos = 0x9
	// Bit mask of ARBLST field.
	TWI_SR_ARBLST_Msk = 0x200
	// Bit ARBLST.
	TWI_SR_ARBLST = 0x200
	// Position of SCLWS field.
	TWI_SR_SCLWS_Pos = 0xa
	// Bit mask of SCLWS field.
	TWI_SR_SCLWS_Msk = 0x400
	// Bit SCLWS.
	TWI_SR_SCLWS = 0x400
	// Position of EOSACC field.
	TWI_SR_EOSACC_Pos = 0xb
	// Bit mask of EOSACC field.
	TWI_SR_EOSACC_Msk = 0x800
	// Bit EOSACC.
	TWI_SR_EOSACC = 0x800
	// Position of ENDRX field.
	TWI_SR_ENDRX_Pos = 0xc
	// Bit mask of ENDRX field.
	TWI_SR_ENDRX_Msk = 0x1000
	// Bit ENDRX.
	TWI_SR_ENDRX = 0x1000
	// Position of ENDTX field.
	TWI_SR_ENDTX_Pos = 0xd
	// Bit mask of ENDTX field.
	TWI_SR_ENDTX_Msk = 0x2000
	// Bit ENDTX.
	TWI_SR_ENDTX = 0x2000
	// Position of RXBUFF field.
	TWI_SR_RXBUFF_Pos = 0xe
	// Bit mask of RXBUFF field.
	TWI_SR_RXBUFF_Msk = 0x4000
	// Bit RXBUFF.
	TWI_SR_RXBUFF = 0x4000
	// Position of TXBUFE field.
	TWI_SR_TXBUFE_Pos = 0xf
	// Bit mask of TXBUFE field.
	TWI_SR_TXBUFE_Msk = 0x8000
	// Bit TXBUFE.
	TWI_SR_TXBUFE = 0x8000

	// IER: Interrupt Enable Register
	// Position of TXCOMP field.
	TWI_IER_TXCOMP_Pos = 0x0
	// Bit mask of TXCOMP field.
	TWI_IER_TXCOMP_Msk = 0x1
	// Bit TXCOMP.
	TWI_IER_TXCOMP = 0x1
	// Position of RXRDY field.
	TWI_IER_RXRDY_Pos = 0x1
	// Bit mask of RXRDY field.
	TWI_IER_RXRDY_Msk = 0x2
	// Bit RXRDY.
	TWI_IER_RXRDY = 0x2
	// Position of TXRDY field.
	TWI_IER_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	TWI_IER_TXRDY_Msk = 0x4
	// Bit TXRDY.
	TWI_IER_TXRDY = 0x4
	// Position of SVACC field.
	TWI_IER_SVACC_Pos = 0x4
	// Bit mask of SVACC field.
	TWI_IER_SVACC_Msk = 0x10
	// Bit SVACC.
	TWI_IER_SVACC = 0x10
	// Position of GACC field.
	TWI_IER_GACC_Pos = 0x5
	// Bit mask of GACC field.
	TWI_IER_GACC_Msk = 0x20
	// Bit GACC.
	TWI_IER_GACC = 0x20
	// Position of OVRE field.
	TWI_IER_OVRE_Pos = 0x6
	// Bit mask of OVRE field.
	TWI_IER_OVRE_Msk = 0x40
	// Bit OVRE.
	TWI_IER_OVRE = 0x40
	// Position of NACK field.
	TWI_IER_NACK_Pos = 0x8
	// Bit mask of NACK field.
	TWI_IER_NACK_Msk = 0x100
	// Bit NACK.
	TWI_IER_NACK = 0x100
	// Position of ARBLST field.
	TWI_IER_ARBLST_Pos = 0x9
	// Bit mask of ARBLST field.
	TWI_IER_ARBLST_Msk = 0x200
	// Bit ARBLST.
	TWI_IER_ARBLST = 0x200
	// Position of SCL_WS field.
	TWI_IER_SCL_WS_Pos = 0xa
	// Bit mask of SCL_WS field.
	TWI_IER_SCL_WS_Msk = 0x400
	// Bit SCL_WS.
	TWI_IER_SCL_WS = 0x400
	// Position of EOSACC field.
	TWI_IER_EOSACC_Pos = 0xb
	// Bit mask of EOSACC field.
	TWI_IER_EOSACC_Msk = 0x800
	// Bit EOSACC.
	TWI_IER_EOSACC = 0x800
	// Position of ENDRX field.
	TWI_IER_ENDRX_Pos = 0xc
	// Bit mask of ENDRX field.
	TWI_IER_ENDRX_Msk = 0x1000
	// Bit ENDRX.
	TWI_IER_ENDRX = 0x1000
	// Position of ENDTX field.
	TWI_IER_ENDTX_Pos = 0xd
	// Bit mask of ENDTX field.
	TWI_IER_ENDTX_Msk = 0x2000
	// Bit ENDTX.
	TWI_IER_ENDTX = 0x2000
	// Position of RXBUFF field.
	TWI_IER_RXBUFF_Pos = 0xe
	// Bit mask of RXBUFF field.
	TWI_IER_RXBUFF_Msk = 0x4000
	// Bit RXBUFF.
	TWI_IER_RXBUFF = 0x4000
	// Position of TXBUFE field.
	TWI_IER_TXBUFE_Pos = 0xf
	// Bit mask of TXBUFE field.
	TWI_IER_TXBUFE_Msk = 0x8000
	// Bit TXBUFE.
	TWI_IER_TXBUFE = 0x8000

	// IDR: Interrupt Disable Register
	// Position of TXCOMP field.
	TWI_IDR_TXCOMP_Pos = 0x0
	// Bit mask of TXCOMP field.
	TWI_IDR_TXCOMP_Msk = 0x1
	// Bit TXCOMP.
	TWI_IDR_TXCOMP = 0x1
	// Position of RXRDY field.
	TWI_IDR_RXRDY_Pos = 0x1
	// Bit mask of RXRDY field.
	TWI_IDR_RXRDY_Msk = 0x2
	// Bit RXRDY.
	TWI_IDR_RXRDY = 0x2
	// Position of TXRDY field.
	TWI_IDR_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	TWI_IDR_TXRDY_Msk = 0x4
	// Bit TXRDY.
	TWI_IDR_TXRDY = 0x4
	// Position of SVACC field.
	TWI_IDR_SVACC_Pos = 0x4
	// Bit mask of SVACC field.
	TWI_IDR_SVACC_Msk = 0x10
	// Bit SVACC.
	TWI_IDR_SVACC = 0x10
	// Position of GACC field.
	TWI_IDR_GACC_Pos = 0x5
	// Bit mask of GACC field.
	TWI_IDR_GACC_Msk = 0x20
	// Bit GACC.
	TWI_IDR_GACC = 0x20
	// Position of OVRE field.
	TWI_IDR_OVRE_Pos = 0x6
	// Bit mask of OVRE field.
	TWI_IDR_OVRE_Msk = 0x40
	// Bit OVRE.
	TWI_IDR_OVRE = 0x40
	// Position of NACK field.
	TWI_IDR_NACK_Pos = 0x8
	// Bit mask of NACK field.
	TWI_IDR_NACK_Msk = 0x100
	// Bit NACK.
	TWI_IDR_NACK = 0x100
	// Position of ARBLST field.
	TWI_IDR_ARBLST_Pos = 0x9
	// Bit mask of ARBLST field.
	TWI_IDR_ARBLST_Msk = 0x200
	// Bit ARBLST.
	TWI_IDR_ARBLST = 0x200
	// Position of SCL_WS field.
	TWI_IDR_SCL_WS_Pos = 0xa
	// Bit mask of SCL_WS field.
	TWI_IDR_SCL_WS_Msk = 0x400
	// Bit SCL_WS.
	TWI_IDR_SCL_WS = 0x400
	// Position of EOSACC field.
	TWI_IDR_EOSACC_Pos = 0xb
	// Bit mask of EOSACC field.
	TWI_IDR_EOSACC_Msk = 0x800
	// Bit EOSACC.
	TWI_IDR_EOSACC = 0x800
	// Position of ENDRX field.
	TWI_IDR_ENDRX_Pos = 0xc
	// Bit mask of ENDRX field.
	TWI_IDR_ENDRX_Msk = 0x1000
	// Bit ENDRX.
	TWI_IDR_ENDRX = 0x1000
	// Position of ENDTX field.
	TWI_IDR_ENDTX_Pos = 0xd
	// Bit mask of ENDTX field.
	TWI_IDR_ENDTX_Msk = 0x2000
	// Bit ENDTX.
	TWI_IDR_ENDTX = 0x2000
	// Position of RXBUFF field.
	TWI_IDR_RXBUFF_Pos = 0xe
	// Bit mask of RXBUFF field.
	TWI_IDR_RXBUFF_Msk = 0x4000
	// Bit RXBUFF.
	TWI_IDR_RXBUFF = 0x4000
	// Position of TXBUFE field.
	TWI_IDR_TXBUFE_Pos = 0xf
	// Bit mask of TXBUFE field.
	TWI_IDR_TXBUFE_Msk = 0x8000
	// Bit TXBUFE.
	TWI_IDR_TXBUFE = 0x8000

	// IMR: Interrupt Mask Register
	// Position of TXCOMP field.
	TWI_IMR_TXCOMP_Pos = 0x0
	// Bit mask of TXCOMP field.
	TWI_IMR_TXCOMP_Msk = 0x1
	// Bit TXCOMP.
	TWI_IMR_TXCOMP = 0x1
	// Position of RXRDY field.
	TWI_IMR_RXRDY_Pos = 0x1
	// Bit mask of RXRDY field.
	TWI_IMR_RXRDY_Msk = 0x2
	// Bit RXRDY.
	TWI_IMR_RXRDY = 0x2
	// Position of TXRDY field.
	TWI_IMR_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	TWI_IMR_TXRDY_Msk = 0x4
	// Bit TXRDY.
	TWI_IMR_TXRDY = 0x4
	// Position of SVACC field.
	TWI_IMR_SVACC_Pos = 0x4
	// Bit mask of SVACC field.
	TWI_IMR_SVACC_Msk = 0x10
	// Bit SVACC.
	TWI_IMR_SVACC = 0x10
	// Position of GACC field.
	TWI_IMR_GACC_Pos = 0x5
	// Bit mask of GACC field.
	TWI_IMR_GACC_Msk = 0x20
	// Bit GACC.
	TWI_IMR_GACC = 0x20
	// Position of OVRE field.
	TWI_IMR_OVRE_Pos = 0x6
	// Bit mask of OVRE field.
	TWI_IMR_OVRE_Msk = 0x40
	// Bit OVRE.
	TWI_IMR_OVRE = 0x40
	// Position of NACK field.
	TWI_IMR_NACK_Pos = 0x8
	// Bit mask of NACK field.
	TWI_IMR_NACK_Msk = 0x100
	// Bit NACK.
	TWI_IMR_NACK = 0x100
	// Position of ARBLST field.
	TWI_IMR_ARBLST_Pos = 0x9
	// Bit mask of ARBLST field.
	TWI_IMR_ARBLST_Msk = 0x200
	// Bit ARBLST.
	TWI_IMR_ARBLST = 0x200
	// Position of SCL_WS field.
	TWI_IMR_SCL_WS_Pos = 0xa
	// Bit mask of SCL_WS field.
	TWI_IMR_SCL_WS_Msk = 0x400
	// Bit SCL_WS.
	TWI_IMR_SCL_WS = 0x400
	// Position of EOSACC field.
	TWI_IMR_EOSACC_Pos = 0xb
	// Bit mask of EOSACC field.
	TWI_IMR_EOSACC_Msk = 0x800
	// Bit EOSACC.
	TWI_IMR_EOSACC = 0x800
	// Position of ENDRX field.
	TWI_IMR_ENDRX_Pos = 0xc
	// Bit mask of ENDRX field.
	TWI_IMR_ENDRX_Msk = 0x1000
	// Bit ENDRX.
	TWI_IMR_ENDRX = 0x1000
	// Position of ENDTX field.
	TWI_IMR_ENDTX_Pos = 0xd
	// Bit mask of ENDTX field.
	TWI_IMR_ENDTX_Msk = 0x2000
	// Bit ENDTX.
	TWI_IMR_ENDTX = 0x2000
	// Position of RXBUFF field.
	TWI_IMR_RXBUFF_Pos = 0xe
	// Bit mask of RXBUFF field.
	TWI_IMR_RXBUFF_Msk = 0x4000
	// Bit RXBUFF.
	TWI_IMR_RXBUFF = 0x4000
	// Position of TXBUFE field.
	TWI_IMR_TXBUFE_Pos = 0xf
	// Bit mask of TXBUFE field.
	TWI_IMR_TXBUFE_Msk = 0x8000
	// Bit TXBUFE.
	TWI_IMR_TXBUFE = 0x8000

	// RHR: Receive Holding Register
	// Position of RXDATA field.
	TWI_RHR_RXDATA_Pos = 0x0
	// Bit mask of RXDATA field.
	TWI_RHR_RXDATA_Msk = 0xff

	// THR: Transmit Holding Register
	// Position of TXDATA field.
	TWI_THR_TXDATA_Pos = 0x0
	// Bit mask of TXDATA field.
	TWI_THR_TXDATA_Msk = 0xff

	// RPR: Receive Pointer Register
	// Position of RXPTR field.
	TWI_RPR_RXPTR_Pos = 0x0
	// Bit mask of RXPTR field.
	TWI_RPR_RXPTR_Msk = 0xffffffff

	// RCR: Receive Counter Register
	// Position of RXCTR field.
	TWI_RCR_RXCTR_Pos = 0x0
	// Bit mask of RXCTR field.
	TWI_RCR_RXCTR_Msk = 0xffff

	// TPR: Transmit Pointer Register
	// Position of TXPTR field.
	TWI_TPR_TXPTR_Pos = 0x0
	// Bit mask of TXPTR field.
	TWI_TPR_TXPTR_Msk = 0xffffffff

	// TCR: Transmit Counter Register
	// Position of TXCTR field.
	TWI_TCR_TXCTR_Pos = 0x0
	// Bit mask of TXCTR field.
	TWI_TCR_TXCTR_Msk = 0xffff

	// RNPR: Receive Next Pointer Register
	// Position of RXNPTR field.
	TWI_RNPR_RXNPTR_Pos = 0x0
	// Bit mask of RXNPTR field.
	TWI_RNPR_RXNPTR_Msk = 0xffffffff

	// RNCR: Receive Next Counter Register
	// Position of RXNCTR field.
	TWI_RNCR_RXNCTR_Pos = 0x0
	// Bit mask of RXNCTR field.
	TWI_RNCR_RXNCTR_Msk = 0xffff

	// TNPR: Transmit Next Pointer Register
	// Position of TXNPTR field.
	TWI_TNPR_TXNPTR_Pos = 0x0
	// Bit mask of TXNPTR field.
	TWI_TNPR_TXNPTR_Msk = 0xffffffff

	// TNCR: Transmit Next Counter Register
	// Position of TXNCTR field.
	TWI_TNCR_TXNCTR_Pos = 0x0
	// Bit mask of TXNCTR field.
	TWI_TNCR_TXNCTR_Msk = 0xffff

	// PTCR: Transfer Control Register
	// Position of RXTEN field.
	TWI_PTCR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	TWI_PTCR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	TWI_PTCR_RXTEN = 0x1
	// Position of RXTDIS field.
	TWI_PTCR_RXTDIS_Pos = 0x1
	// Bit mask of RXTDIS field.
	TWI_PTCR_RXTDIS_Msk = 0x2
	// Bit RXTDIS.
	TWI_PTCR_RXTDIS = 0x2
	// Position of TXTEN field.
	TWI_PTCR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	TWI_PTCR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	TWI_PTCR_TXTEN = 0x100
	// Position of TXTDIS field.
	TWI_PTCR_TXTDIS_Pos = 0x9
	// Bit mask of TXTDIS field.
	TWI_PTCR_TXTDIS_Msk = 0x200
	// Bit TXTDIS.
	TWI_PTCR_TXTDIS = 0x200

	// PTSR: Transfer Status Register
	// Position of RXTEN field.
	TWI_PTSR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	TWI_PTSR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	TWI_PTSR_RXTEN = 0x1
	// Position of TXTEN field.
	TWI_PTSR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	TWI_PTSR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	TWI_PTSR_TXTEN = 0x100
)

// Bitfields for PWM: Pulse Width Modulation Controller
const (
	// CLK: PWM Clock Register
	// Position of DIVA field.
	PWM_CLK_DIVA_Pos = 0x0
	// Bit mask of DIVA field.
	PWM_CLK_DIVA_Msk = 0xff
	// Position of PREA field.
	PWM_CLK_PREA_Pos = 0x8
	// Bit mask of PREA field.
	PWM_CLK_PREA_Msk = 0xf00
	// Position of DIVB field.
	PWM_CLK_DIVB_Pos = 0x10
	// Bit mask of DIVB field.
	PWM_CLK_DIVB_Msk = 0xff0000
	// Position of PREB field.
	PWM_CLK_PREB_Pos = 0x18
	// Bit mask of PREB field.
	PWM_CLK_PREB_Msk = 0xf000000

	// ENA: PWM Enable Register
	// Position of CHID0 field.
	PWM_ENA_CHID0_Pos = 0x0
	// Bit mask of CHID0 field.
	PWM_ENA_CHID0_Msk = 0x1
	// Bit CHID0.
	PWM_ENA_CHID0 = 0x1
	// Position of CHID1 field.
	PWM_ENA_CHID1_Pos = 0x1
	// Bit mask of CHID1 field.
	PWM_ENA_CHID1_Msk = 0x2
	// Bit CHID1.
	PWM_ENA_CHID1 = 0x2
	// Position of CHID2 field.
	PWM_ENA_CHID2_Pos = 0x2
	// Bit mask of CHID2 field.
	PWM_ENA_CHID2_Msk = 0x4
	// Bit CHID2.
	PWM_ENA_CHID2 = 0x4
	// Position of CHID3 field.
	PWM_ENA_CHID3_Pos = 0x3
	// Bit mask of CHID3 field.
	PWM_ENA_CHID3_Msk = 0x8
	// Bit CHID3.
	PWM_ENA_CHID3 = 0x8
	// Position of CHID4 field.
	PWM_ENA_CHID4_Pos = 0x4
	// Bit mask of CHID4 field.
	PWM_ENA_CHID4_Msk = 0x10
	// Bit CHID4.
	PWM_ENA_CHID4 = 0x10
	// Position of CHID5 field.
	PWM_ENA_CHID5_Pos = 0x5
	// Bit mask of CHID5 field.
	PWM_ENA_CHID5_Msk = 0x20
	// Bit CHID5.
	PWM_ENA_CHID5 = 0x20
	// Position of CHID6 field.
	PWM_ENA_CHID6_Pos = 0x6
	// Bit mask of CHID6 field.
	PWM_ENA_CHID6_Msk = 0x40
	// Bit CHID6.
	PWM_ENA_CHID6 = 0x40
	// Position of CHID7 field.
	PWM_ENA_CHID7_Pos = 0x7
	// Bit mask of CHID7 field.
	PWM_ENA_CHID7_Msk = 0x80
	// Bit CHID7.
	PWM_ENA_CHID7 = 0x80

	// DIS: PWM Disable Register
	// Position of CHID0 field.
	PWM_DIS_CHID0_Pos = 0x0
	// Bit mask of CHID0 field.
	PWM_DIS_CHID0_Msk = 0x1
	// Bit CHID0.
	PWM_DIS_CHID0 = 0x1
	// Position of CHID1 field.
	PWM_DIS_CHID1_Pos = 0x1
	// Bit mask of CHID1 field.
	PWM_DIS_CHID1_Msk = 0x2
	// Bit CHID1.
	PWM_DIS_CHID1 = 0x2
	// Position of CHID2 field.
	PWM_DIS_CHID2_Pos = 0x2
	// Bit mask of CHID2 field.
	PWM_DIS_CHID2_Msk = 0x4
	// Bit CHID2.
	PWM_DIS_CHID2 = 0x4
	// Position of CHID3 field.
	PWM_DIS_CHID3_Pos = 0x3
	// Bit mask of CHID3 field.
	PWM_DIS_CHID3_Msk = 0x8
	// Bit CHID3.
	PWM_DIS_CHID3 = 0x8
	// Position of CHID4 field.
	PWM_DIS_CHID4_Pos = 0x4
	// Bit mask of CHID4 field.
	PWM_DIS_CHID4_Msk = 0x10
	// Bit CHID4.
	PWM_DIS_CHID4 = 0x10
	// Position of CHID5 field.
	PWM_DIS_CHID5_Pos = 0x5
	// Bit mask of CHID5 field.
	PWM_DIS_CHID5_Msk = 0x20
	// Bit CHID5.
	PWM_DIS_CHID5 = 0x20
	// Position of CHID6 field.
	PWM_DIS_CHID6_Pos = 0x6
	// Bit mask of CHID6 field.
	PWM_DIS_CHID6_Msk = 0x40
	// Bit CHID6.
	PWM_DIS_CHID6 = 0x40
	// Position of CHID7 field.
	PWM_DIS_CHID7_Pos = 0x7
	// Bit mask of CHID7 field.
	PWM_DIS_CHID7_Msk = 0x80
	// Bit CHID7.
	PWM_DIS_CHID7 = 0x80

	// SR: PWM Status Register
	// Position of CHID0 field.
	PWM_SR_CHID0_Pos = 0x0
	// Bit mask of CHID0 field.
	PWM_SR_CHID0_Msk = 0x1
	// Bit CHID0.
	PWM_SR_CHID0 = 0x1
	// Position of CHID1 field.
	PWM_SR_CHID1_Pos = 0x1
	// Bit mask of CHID1 field.
	PWM_SR_CHID1_Msk = 0x2
	// Bit CHID1.
	PWM_SR_CHID1 = 0x2
	// Position of CHID2 field.
	PWM_SR_CHID2_Pos = 0x2
	// Bit mask of CHID2 field.
	PWM_SR_CHID2_Msk = 0x4
	// Bit CHID2.
	PWM_SR_CHID2 = 0x4
	// Position of CHID3 field.
	PWM_SR_CHID3_Pos = 0x3
	// Bit mask of CHID3 field.
	PWM_SR_CHID3_Msk = 0x8
	// Bit CHID3.
	PWM_SR_CHID3 = 0x8
	// Position of CHID4 field.
	PWM_SR_CHID4_Pos = 0x4
	// Bit mask of CHID4 field.
	PWM_SR_CHID4_Msk = 0x10
	// Bit CHID4.
	PWM_SR_CHID4 = 0x10
	// Position of CHID5 field.
	PWM_SR_CHID5_Pos = 0x5
	// Bit mask of CHID5 field.
	PWM_SR_CHID5_Msk = 0x20
	// Bit CHID5.
	PWM_SR_CHID5 = 0x20
	// Position of CHID6 field.
	PWM_SR_CHID6_Pos = 0x6
	// Bit mask of CHID6 field.
	PWM_SR_CHID6_Msk = 0x40
	// Bit CHID6.
	PWM_SR_CHID6 = 0x40
	// Position of CHID7 field.
	PWM_SR_CHID7_Pos = 0x7
	// Bit mask of CHID7 field.
	PWM_SR_CHID7_Msk = 0x80
	// Bit CHID7.
	PWM_SR_CHID7 = 0x80

	// IER1: PWM Interrupt Enable Register 1
	// Position of CHID0 field.
	PWM_IER1_CHID0_Pos = 0x0
	// Bit mask of CHID0 field.
	PWM_IER1_CHID0_Msk = 0x1
	// Bit CHID0.
	PWM_IER1_CHID0 = 0x1
	// Position of CHID1 field.
	PWM_IER1_CHID1_Pos = 0x1
	// Bit mask of CHID1 field.
	PWM_IER1_CHID1_Msk = 0x2
	// Bit CHID1.
	PWM_IER1_CHID1 = 0x2
	// Position of CHID2 field.
	PWM_IER1_CHID2_Pos = 0x2
	// Bit mask of CHID2 field.
	PWM_IER1_CHID2_Msk = 0x4
	// Bit CHID2.
	PWM_IER1_CHID2 = 0x4
	// Position of CHID3 field.
	PWM_IER1_CHID3_Pos = 0x3
	// Bit mask of CHID3 field.
	PWM_IER1_CHID3_Msk = 0x8
	// Bit CHID3.
	PWM_IER1_CHID3 = 0x8
	// Position of CHID4 field.
	PWM_IER1_CHID4_Pos = 0x4
	// Bit mask of CHID4 field.
	PWM_IER1_CHID4_Msk = 0x10
	// Bit CHID4.
	PWM_IER1_CHID4 = 0x10
	// Position of CHID5 field.
	PWM_IER1_CHID5_Pos = 0x5
	// Bit mask of CHID5 field.
	PWM_IER1_CHID5_Msk = 0x20
	// Bit CHID5.
	PWM_IER1_CHID5 = 0x20
	// Position of CHID6 field.
	PWM_IER1_CHID6_Pos = 0x6
	// Bit mask of CHID6 field.
	PWM_IER1_CHID6_Msk = 0x40
	// Bit CHID6.
	PWM_IER1_CHID6 = 0x40
	// Position of CHID7 field.
	PWM_IER1_CHID7_Pos = 0x7
	// Bit mask of CHID7 field.
	PWM_IER1_CHID7_Msk = 0x80
	// Bit CHID7.
	PWM_IER1_CHID7 = 0x80
	// Position of FCHID0 field.
	PWM_IER1_FCHID0_Pos = 0x10
	// Bit mask of FCHID0 field.
	PWM_IER1_FCHID0_Msk = 0x10000
	// Bit FCHID0.
	PWM_IER1_FCHID0 = 0x10000
	// Position of FCHID1 field.
	PWM_IER1_FCHID1_Pos = 0x11
	// Bit mask of FCHID1 field.
	PWM_IER1_FCHID1_Msk = 0x20000
	// Bit FCHID1.
	PWM_IER1_FCHID1 = 0x20000
	// Position of FCHID2 field.
	PWM_IER1_FCHID2_Pos = 0x12
	// Bit mask of FCHID2 field.
	PWM_IER1_FCHID2_Msk = 0x40000
	// Bit FCHID2.
	PWM_IER1_FCHID2 = 0x40000
	// Position of FCHID3 field.
	PWM_IER1_FCHID3_Pos = 0x13
	// Bit mask of FCHID3 field.
	PWM_IER1_FCHID3_Msk = 0x80000
	// Bit FCHID3.
	PWM_IER1_FCHID3 = 0x80000
	// Position of FCHID4 field.
	PWM_IER1_FCHID4_Pos = 0x14
	// Bit mask of FCHID4 field.
	PWM_IER1_FCHID4_Msk = 0x100000
	// Bit FCHID4.
	PWM_IER1_FCHID4 = 0x100000
	// Position of FCHID5 field.
	PWM_IER1_FCHID5_Pos = 0x15
	// Bit mask of FCHID5 field.
	PWM_IER1_FCHID5_Msk = 0x200000
	// Bit FCHID5.
	PWM_IER1_FCHID5 = 0x200000
	// Position of FCHID6 field.
	PWM_IER1_FCHID6_Pos = 0x16
	// Bit mask of FCHID6 field.
	PWM_IER1_FCHID6_Msk = 0x400000
	// Bit FCHID6.
	PWM_IER1_FCHID6 = 0x400000
	// Position of FCHID7 field.
	PWM_IER1_FCHID7_Pos = 0x17
	// Bit mask of FCHID7 field.
	PWM_IER1_FCHID7_Msk = 0x800000
	// Bit FCHID7.
	PWM_IER1_FCHID7 = 0x800000

	// IDR1: PWM Interrupt Disable Register 1
	// Position of CHID0 field.
	PWM_IDR1_CHID0_Pos = 0x0
	// Bit mask of CHID0 field.
	PWM_IDR1_CHID0_Msk = 0x1
	// Bit CHID0.
	PWM_IDR1_CHID0 = 0x1
	// Position of CHID1 field.
	PWM_IDR1_CHID1_Pos = 0x1
	// Bit mask of CHID1 field.
	PWM_IDR1_CHID1_Msk = 0x2
	// Bit CHID1.
	PWM_IDR1_CHID1 = 0x2
	// Position of CHID2 field.
	PWM_IDR1_CHID2_Pos = 0x2
	// Bit mask of CHID2 field.
	PWM_IDR1_CHID2_Msk = 0x4
	// Bit CHID2.
	PWM_IDR1_CHID2 = 0x4
	// Position of CHID3 field.
	PWM_IDR1_CHID3_Pos = 0x3
	// Bit mask of CHID3 field.
	PWM_IDR1_CHID3_Msk = 0x8
	// Bit CHID3.
	PWM_IDR1_CHID3 = 0x8
	// Position of CHID4 field.
	PWM_IDR1_CHID4_Pos = 0x4
	// Bit mask of CHID4 field.
	PWM_IDR1_CHID4_Msk = 0x10
	// Bit CHID4.
	PWM_IDR1_CHID4 = 0x10
	// Position of CHID5 field.
	PWM_IDR1_CHID5_Pos = 0x5
	// Bit mask of CHID5 field.
	PWM_IDR1_CHID5_Msk = 0x20
	// Bit CHID5.
	PWM_IDR1_CHID5 = 0x20
	// Position of CHID6 field.
	PWM_IDR1_CHID6_Pos = 0x6
	// Bit mask of CHID6 field.
	PWM_IDR1_CHID6_Msk = 0x40
	// Bit CHID6.
	PWM_IDR1_CHID6 = 0x40
	// Position of CHID7 field.
	PWM_IDR1_CHID7_Pos = 0x7
	// Bit mask of CHID7 field.
	PWM_IDR1_CHID7_Msk = 0x80
	// Bit CHID7.
	PWM_IDR1_CHID7 = 0x80
	// Position of FCHID0 field.
	PWM_IDR1_FCHID0_Pos = 0x10
	// Bit mask of FCHID0 field.
	PWM_IDR1_FCHID0_Msk = 0x10000
	// Bit FCHID0.
	PWM_IDR1_FCHID0 = 0x10000
	// Position of FCHID1 field.
	PWM_IDR1_FCHID1_Pos = 0x11
	// Bit mask of FCHID1 field.
	PWM_IDR1_FCHID1_Msk = 0x20000
	// Bit FCHID1.
	PWM_IDR1_FCHID1 = 0x20000
	// Position of FCHID2 field.
	PWM_IDR1_FCHID2_Pos = 0x12
	// Bit mask of FCHID2 field.
	PWM_IDR1_FCHID2_Msk = 0x40000
	// Bit FCHID2.
	PWM_IDR1_FCHID2 = 0x40000
	// Position of FCHID3 field.
	PWM_IDR1_FCHID3_Pos = 0x13
	// Bit mask of FCHID3 field.
	PWM_IDR1_FCHID3_Msk = 0x80000
	// Bit FCHID3.
	PWM_IDR1_FCHID3 = 0x80000
	// Position of FCHID4 field.
	PWM_IDR1_FCHID4_Pos = 0x14
	// Bit mask of FCHID4 field.
	PWM_IDR1_FCHID4_Msk = 0x100000
	// Bit FCHID4.
	PWM_IDR1_FCHID4 = 0x100000
	// Position of FCHID5 field.
	PWM_IDR1_FCHID5_Pos = 0x15
	// Bit mask of FCHID5 field.
	PWM_IDR1_FCHID5_Msk = 0x200000
	// Bit FCHID5.
	PWM_IDR1_FCHID5 = 0x200000
	// Position of FCHID6 field.
	PWM_IDR1_FCHID6_Pos = 0x16
	// Bit mask of FCHID6 field.
	PWM_IDR1_FCHID6_Msk = 0x400000
	// Bit FCHID6.
	PWM_IDR1_FCHID6 = 0x400000
	// Position of FCHID7 field.
	PWM_IDR1_FCHID7_Pos = 0x17
	// Bit mask of FCHID7 field.
	PWM_IDR1_FCHID7_Msk = 0x800000
	// Bit FCHID7.
	PWM_IDR1_FCHID7 = 0x800000

	// IMR1: PWM Interrupt Mask Register 1
	// Position of CHID0 field.
	PWM_IMR1_CHID0_Pos = 0x0
	// Bit mask of CHID0 field.
	PWM_IMR1_CHID0_Msk = 0x1
	// Bit CHID0.
	PWM_IMR1_CHID0 = 0x1
	// Position of CHID1 field.
	PWM_IMR1_CHID1_Pos = 0x1
	// Bit mask of CHID1 field.
	PWM_IMR1_CHID1_Msk = 0x2
	// Bit CHID1.
	PWM_IMR1_CHID1 = 0x2
	// Position of CHID2 field.
	PWM_IMR1_CHID2_Pos = 0x2
	// Bit mask of CHID2 field.
	PWM_IMR1_CHID2_Msk = 0x4
	// Bit CHID2.
	PWM_IMR1_CHID2 = 0x4
	// Position of CHID3 field.
	PWM_IMR1_CHID3_Pos = 0x3
	// Bit mask of CHID3 field.
	PWM_IMR1_CHID3_Msk = 0x8
	// Bit CHID3.
	PWM_IMR1_CHID3 = 0x8
	// Position of CHID4 field.
	PWM_IMR1_CHID4_Pos = 0x4
	// Bit mask of CHID4 field.
	PWM_IMR1_CHID4_Msk = 0x10
	// Bit CHID4.
	PWM_IMR1_CHID4 = 0x10
	// Position of CHID5 field.
	PWM_IMR1_CHID5_Pos = 0x5
	// Bit mask of CHID5 field.
	PWM_IMR1_CHID5_Msk = 0x20
	// Bit CHID5.
	PWM_IMR1_CHID5 = 0x20
	// Position of CHID6 field.
	PWM_IMR1_CHID6_Pos = 0x6
	// Bit mask of CHID6 field.
	PWM_IMR1_CHID6_Msk = 0x40
	// Bit CHID6.
	PWM_IMR1_CHID6 = 0x40
	// Position of CHID7 field.
	PWM_IMR1_CHID7_Pos = 0x7
	// Bit mask of CHID7 field.
	PWM_IMR1_CHID7_Msk = 0x80
	// Bit CHID7.
	PWM_IMR1_CHID7 = 0x80
	// Position of FCHID0 field.
	PWM_IMR1_FCHID0_Pos = 0x10
	// Bit mask of FCHID0 field.
	PWM_IMR1_FCHID0_Msk = 0x10000
	// Bit FCHID0.
	PWM_IMR1_FCHID0 = 0x10000
	// Position of FCHID1 field.
	PWM_IMR1_FCHID1_Pos = 0x11
	// Bit mask of FCHID1 field.
	PWM_IMR1_FCHID1_Msk = 0x20000
	// Bit FCHID1.
	PWM_IMR1_FCHID1 = 0x20000
	// Position of FCHID2 field.
	PWM_IMR1_FCHID2_Pos = 0x12
	// Bit mask of FCHID2 field.
	PWM_IMR1_FCHID2_Msk = 0x40000
	// Bit FCHID2.
	PWM_IMR1_FCHID2 = 0x40000
	// Position of FCHID3 field.
	PWM_IMR1_FCHID3_Pos = 0x13
	// Bit mask of FCHID3 field.
	PWM_IMR1_FCHID3_Msk = 0x80000
	// Bit FCHID3.
	PWM_IMR1_FCHID3 = 0x80000
	// Position of FCHID4 field.
	PWM_IMR1_FCHID4_Pos = 0x14
	// Bit mask of FCHID4 field.
	PWM_IMR1_FCHID4_Msk = 0x100000
	// Bit FCHID4.
	PWM_IMR1_FCHID4 = 0x100000
	// Position of FCHID5 field.
	PWM_IMR1_FCHID5_Pos = 0x15
	// Bit mask of FCHID5 field.
	PWM_IMR1_FCHID5_Msk = 0x200000
	// Bit FCHID5.
	PWM_IMR1_FCHID5 = 0x200000
	// Position of FCHID6 field.
	PWM_IMR1_FCHID6_Pos = 0x16
	// Bit mask of FCHID6 field.
	PWM_IMR1_FCHID6_Msk = 0x400000
	// Bit FCHID6.
	PWM_IMR1_FCHID6 = 0x400000
	// Position of FCHID7 field.
	PWM_IMR1_FCHID7_Pos = 0x17
	// Bit mask of FCHID7 field.
	PWM_IMR1_FCHID7_Msk = 0x800000
	// Bit FCHID7.
	PWM_IMR1_FCHID7 = 0x800000

	// ISR1: PWM Interrupt Status Register 1
	// Position of CHID0 field.
	PWM_ISR1_CHID0_Pos = 0x0
	// Bit mask of CHID0 field.
	PWM_ISR1_CHID0_Msk = 0x1
	// Bit CHID0.
	PWM_ISR1_CHID0 = 0x1
	// Position of CHID1 field.
	PWM_ISR1_CHID1_Pos = 0x1
	// Bit mask of CHID1 field.
	PWM_ISR1_CHID1_Msk = 0x2
	// Bit CHID1.
	PWM_ISR1_CHID1 = 0x2
	// Position of CHID2 field.
	PWM_ISR1_CHID2_Pos = 0x2
	// Bit mask of CHID2 field.
	PWM_ISR1_CHID2_Msk = 0x4
	// Bit CHID2.
	PWM_ISR1_CHID2 = 0x4
	// Position of CHID3 field.
	PWM_ISR1_CHID3_Pos = 0x3
	// Bit mask of CHID3 field.
	PWM_ISR1_CHID3_Msk = 0x8
	// Bit CHID3.
	PWM_ISR1_CHID3 = 0x8
	// Position of CHID4 field.
	PWM_ISR1_CHID4_Pos = 0x4
	// Bit mask of CHID4 field.
	PWM_ISR1_CHID4_Msk = 0x10
	// Bit CHID4.
	PWM_ISR1_CHID4 = 0x10
	// Position of CHID5 field.
	PWM_ISR1_CHID5_Pos = 0x5
	// Bit mask of CHID5 field.
	PWM_ISR1_CHID5_Msk = 0x20
	// Bit CHID5.
	PWM_ISR1_CHID5 = 0x20
	// Position of CHID6 field.
	PWM_ISR1_CHID6_Pos = 0x6
	// Bit mask of CHID6 field.
	PWM_ISR1_CHID6_Msk = 0x40
	// Bit CHID6.
	PWM_ISR1_CHID6 = 0x40
	// Position of CHID7 field.
	PWM_ISR1_CHID7_Pos = 0x7
	// Bit mask of CHID7 field.
	PWM_ISR1_CHID7_Msk = 0x80
	// Bit CHID7.
	PWM_ISR1_CHID7 = 0x80
	// Position of FCHID0 field.
	PWM_ISR1_FCHID0_Pos = 0x10
	// Bit mask of FCHID0 field.
	PWM_ISR1_FCHID0_Msk = 0x10000
	// Bit FCHID0.
	PWM_ISR1_FCHID0 = 0x10000
	// Position of FCHID1 field.
	PWM_ISR1_FCHID1_Pos = 0x11
	// Bit mask of FCHID1 field.
	PWM_ISR1_FCHID1_Msk = 0x20000
	// Bit FCHID1.
	PWM_ISR1_FCHID1 = 0x20000
	// Position of FCHID2 field.
	PWM_ISR1_FCHID2_Pos = 0x12
	// Bit mask of FCHID2 field.
	PWM_ISR1_FCHID2_Msk = 0x40000
	// Bit FCHID2.
	PWM_ISR1_FCHID2 = 0x40000
	// Position of FCHID3 field.
	PWM_ISR1_FCHID3_Pos = 0x13
	// Bit mask of FCHID3 field.
	PWM_ISR1_FCHID3_Msk = 0x80000
	// Bit FCHID3.
	PWM_ISR1_FCHID3 = 0x80000
	// Position of FCHID4 field.
	PWM_ISR1_FCHID4_Pos = 0x14
	// Bit mask of FCHID4 field.
	PWM_ISR1_FCHID4_Msk = 0x100000
	// Bit FCHID4.
	PWM_ISR1_FCHID4 = 0x100000
	// Position of FCHID5 field.
	PWM_ISR1_FCHID5_Pos = 0x15
	// Bit mask of FCHID5 field.
	PWM_ISR1_FCHID5_Msk = 0x200000
	// Bit FCHID5.
	PWM_ISR1_FCHID5 = 0x200000
	// Position of FCHID6 field.
	PWM_ISR1_FCHID6_Pos = 0x16
	// Bit mask of FCHID6 field.
	PWM_ISR1_FCHID6_Msk = 0x400000
	// Bit FCHID6.
	PWM_ISR1_FCHID6 = 0x400000
	// Position of FCHID7 field.
	PWM_ISR1_FCHID7_Pos = 0x17
	// Bit mask of FCHID7 field.
	PWM_ISR1_FCHID7_Msk = 0x800000
	// Bit FCHID7.
	PWM_ISR1_FCHID7 = 0x800000

	// SCM: PWM Sync Channels Mode Register
	// Position of SYNC0 field.
	PWM_SCM_SYNC0_Pos = 0x0
	// Bit mask of SYNC0 field.
	PWM_SCM_SYNC0_Msk = 0x1
	// Bit SYNC0.
	PWM_SCM_SYNC0 = 0x1
	// Position of SYNC1 field.
	PWM_SCM_SYNC1_Pos = 0x1
	// Bit mask of SYNC1 field.
	PWM_SCM_SYNC1_Msk = 0x2
	// Bit SYNC1.
	PWM_SCM_SYNC1 = 0x2
	// Position of SYNC2 field.
	PWM_SCM_SYNC2_Pos = 0x2
	// Bit mask of SYNC2 field.
	PWM_SCM_SYNC2_Msk = 0x4
	// Bit SYNC2.
	PWM_SCM_SYNC2 = 0x4
	// Position of SYNC3 field.
	PWM_SCM_SYNC3_Pos = 0x3
	// Bit mask of SYNC3 field.
	PWM_SCM_SYNC3_Msk = 0x8
	// Bit SYNC3.
	PWM_SCM_SYNC3 = 0x8
	// Position of SYNC4 field.
	PWM_SCM_SYNC4_Pos = 0x4
	// Bit mask of SYNC4 field.
	PWM_SCM_SYNC4_Msk = 0x10
	// Bit SYNC4.
	PWM_SCM_SYNC4 = 0x10
	// Position of SYNC5 field.
	PWM_SCM_SYNC5_Pos = 0x5
	// Bit mask of SYNC5 field.
	PWM_SCM_SYNC5_Msk = 0x20
	// Bit SYNC5.
	PWM_SCM_SYNC5 = 0x20
	// Position of SYNC6 field.
	PWM_SCM_SYNC6_Pos = 0x6
	// Bit mask of SYNC6 field.
	PWM_SCM_SYNC6_Msk = 0x40
	// Bit SYNC6.
	PWM_SCM_SYNC6 = 0x40
	// Position of SYNC7 field.
	PWM_SCM_SYNC7_Pos = 0x7
	// Bit mask of SYNC7 field.
	PWM_SCM_SYNC7_Msk = 0x80
	// Bit SYNC7.
	PWM_SCM_SYNC7 = 0x80
	// Position of UPDM field.
	PWM_SCM_UPDM_Pos = 0x10
	// Bit mask of UPDM field.
	PWM_SCM_UPDM_Msk = 0x30000
	// Manual write of double buffer registers and manual update of synchronous channels
	PWM_SCM_UPDM_MODE0 = 0x0
	// Manual write of double buffer registers and automatic update of synchronous channels
	PWM_SCM_UPDM_MODE1 = 0x1
	// Automatic write of duty-cycle update registers by the PDC and automatic update of synchronous channels
	PWM_SCM_UPDM_MODE2 = 0x2
	// Position of PTRM field.
	PWM_SCM_PTRM_Pos = 0x14
	// Bit mask of PTRM field.
	PWM_SCM_PTRM_Msk = 0x100000
	// Bit PTRM.
	PWM_SCM_PTRM = 0x100000
	// Position of PTRCS field.
	PWM_SCM_PTRCS_Pos = 0x15
	// Bit mask of PTRCS field.
	PWM_SCM_PTRCS_Msk = 0xe00000

	// SCUC: PWM Sync Channels Update Control Register
	// Position of UPDULOCK field.
	PWM_SCUC_UPDULOCK_Pos = 0x0
	// Bit mask of UPDULOCK field.
	PWM_SCUC_UPDULOCK_Msk = 0x1
	// Bit UPDULOCK.
	PWM_SCUC_UPDULOCK = 0x1

	// SCUP: PWM Sync Channels Update Period Register
	// Position of UPR field.
	PWM_SCUP_UPR_Pos = 0x0
	// Bit mask of UPR field.
	PWM_SCUP_UPR_Msk = 0xf
	// Position of UPRCNT field.
	PWM_SCUP_UPRCNT_Pos = 0x4
	// Bit mask of UPRCNT field.
	PWM_SCUP_UPRCNT_Msk = 0xf0

	// SCUPUPD: PWM Sync Channels Update Period Update Register
	// Position of UPRUPD field.
	PWM_SCUPUPD_UPRUPD_Pos = 0x0
	// Bit mask of UPRUPD field.
	PWM_SCUPUPD_UPRUPD_Msk = 0xf

	// IER2: PWM Interrupt Enable Register 2
	// Position of WRDY field.
	PWM_IER2_WRDY_Pos = 0x0
	// Bit mask of WRDY field.
	PWM_IER2_WRDY_Msk = 0x1
	// Bit WRDY.
	PWM_IER2_WRDY = 0x1
	// Position of ENDTX field.
	PWM_IER2_ENDTX_Pos = 0x1
	// Bit mask of ENDTX field.
	PWM_IER2_ENDTX_Msk = 0x2
	// Bit ENDTX.
	PWM_IER2_ENDTX = 0x2
	// Position of TXBUFE field.
	PWM_IER2_TXBUFE_Pos = 0x2
	// Bit mask of TXBUFE field.
	PWM_IER2_TXBUFE_Msk = 0x4
	// Bit TXBUFE.
	PWM_IER2_TXBUFE = 0x4
	// Position of UNRE field.
	PWM_IER2_UNRE_Pos = 0x3
	// Bit mask of UNRE field.
	PWM_IER2_UNRE_Msk = 0x8
	// Bit UNRE.
	PWM_IER2_UNRE = 0x8
	// Position of CMPM0 field.
	PWM_IER2_CMPM0_Pos = 0x8
	// Bit mask of CMPM0 field.
	PWM_IER2_CMPM0_Msk = 0x100
	// Bit CMPM0.
	PWM_IER2_CMPM0 = 0x100
	// Position of CMPM1 field.
	PWM_IER2_CMPM1_Pos = 0x9
	// Bit mask of CMPM1 field.
	PWM_IER2_CMPM1_Msk = 0x200
	// Bit CMPM1.
	PWM_IER2_CMPM1 = 0x200
	// Position of CMPM2 field.
	PWM_IER2_CMPM2_Pos = 0xa
	// Bit mask of CMPM2 field.
	PWM_IER2_CMPM2_Msk = 0x400
	// Bit CMPM2.
	PWM_IER2_CMPM2 = 0x400
	// Position of CMPM3 field.
	PWM_IER2_CMPM3_Pos = 0xb
	// Bit mask of CMPM3 field.
	PWM_IER2_CMPM3_Msk = 0x800
	// Bit CMPM3.
	PWM_IER2_CMPM3 = 0x800
	// Position of CMPM4 field.
	PWM_IER2_CMPM4_Pos = 0xc
	// Bit mask of CMPM4 field.
	PWM_IER2_CMPM4_Msk = 0x1000
	// Bit CMPM4.
	PWM_IER2_CMPM4 = 0x1000
	// Position of CMPM5 field.
	PWM_IER2_CMPM5_Pos = 0xd
	// Bit mask of CMPM5 field.
	PWM_IER2_CMPM5_Msk = 0x2000
	// Bit CMPM5.
	PWM_IER2_CMPM5 = 0x2000
	// Position of CMPM6 field.
	PWM_IER2_CMPM6_Pos = 0xe
	// Bit mask of CMPM6 field.
	PWM_IER2_CMPM6_Msk = 0x4000
	// Bit CMPM6.
	PWM_IER2_CMPM6 = 0x4000
	// Position of CMPM7 field.
	PWM_IER2_CMPM7_Pos = 0xf
	// Bit mask of CMPM7 field.
	PWM_IER2_CMPM7_Msk = 0x8000
	// Bit CMPM7.
	PWM_IER2_CMPM7 = 0x8000
	// Position of CMPU0 field.
	PWM_IER2_CMPU0_Pos = 0x10
	// Bit mask of CMPU0 field.
	PWM_IER2_CMPU0_Msk = 0x10000
	// Bit CMPU0.
	PWM_IER2_CMPU0 = 0x10000
	// Position of CMPU1 field.
	PWM_IER2_CMPU1_Pos = 0x11
	// Bit mask of CMPU1 field.
	PWM_IER2_CMPU1_Msk = 0x20000
	// Bit CMPU1.
	PWM_IER2_CMPU1 = 0x20000
	// Position of CMPU2 field.
	PWM_IER2_CMPU2_Pos = 0x12
	// Bit mask of CMPU2 field.
	PWM_IER2_CMPU2_Msk = 0x40000
	// Bit CMPU2.
	PWM_IER2_CMPU2 = 0x40000
	// Position of CMPU3 field.
	PWM_IER2_CMPU3_Pos = 0x13
	// Bit mask of CMPU3 field.
	PWM_IER2_CMPU3_Msk = 0x80000
	// Bit CMPU3.
	PWM_IER2_CMPU3 = 0x80000
	// Position of CMPU4 field.
	PWM_IER2_CMPU4_Pos = 0x14
	// Bit mask of CMPU4 field.
	PWM_IER2_CMPU4_Msk = 0x100000
	// Bit CMPU4.
	PWM_IER2_CMPU4 = 0x100000
	// Position of CMPU5 field.
	PWM_IER2_CMPU5_Pos = 0x15
	// Bit mask of CMPU5 field.
	PWM_IER2_CMPU5_Msk = 0x200000
	// Bit CMPU5.
	PWM_IER2_CMPU5 = 0x200000
	// Position of CMPU6 field.
	PWM_IER2_CMPU6_Pos = 0x16
	// Bit mask of CMPU6 field.
	PWM_IER2_CMPU6_Msk = 0x400000
	// Bit CMPU6.
	PWM_IER2_CMPU6 = 0x400000
	// Position of CMPU7 field.
	PWM_IER2_CMPU7_Pos = 0x17
	// Bit mask of CMPU7 field.
	PWM_IER2_CMPU7_Msk = 0x800000
	// Bit CMPU7.
	PWM_IER2_CMPU7 = 0x800000

	// IDR2: PWM Interrupt Disable Register 2
	// Position of WRDY field.
	PWM_IDR2_WRDY_Pos = 0x0
	// Bit mask of WRDY field.
	PWM_IDR2_WRDY_Msk = 0x1
	// Bit WRDY.
	PWM_IDR2_WRDY = 0x1
	// Position of ENDTX field.
	PWM_IDR2_ENDTX_Pos = 0x1
	// Bit mask of ENDTX field.
	PWM_IDR2_ENDTX_Msk = 0x2
	// Bit ENDTX.
	PWM_IDR2_ENDTX = 0x2
	// Position of TXBUFE field.
	PWM_IDR2_TXBUFE_Pos = 0x2
	// Bit mask of TXBUFE field.
	PWM_IDR2_TXBUFE_Msk = 0x4
	// Bit TXBUFE.
	PWM_IDR2_TXBUFE = 0x4
	// Position of UNRE field.
	PWM_IDR2_UNRE_Pos = 0x3
	// Bit mask of UNRE field.
	PWM_IDR2_UNRE_Msk = 0x8
	// Bit UNRE.
	PWM_IDR2_UNRE = 0x8
	// Position of CMPM0 field.
	PWM_IDR2_CMPM0_Pos = 0x8
	// Bit mask of CMPM0 field.
	PWM_IDR2_CMPM0_Msk = 0x100
	// Bit CMPM0.
	PWM_IDR2_CMPM0 = 0x100
	// Position of CMPM1 field.
	PWM_IDR2_CMPM1_Pos = 0x9
	// Bit mask of CMPM1 field.
	PWM_IDR2_CMPM1_Msk = 0x200
	// Bit CMPM1.
	PWM_IDR2_CMPM1 = 0x200
	// Position of CMPM2 field.
	PWM_IDR2_CMPM2_Pos = 0xa
	// Bit mask of CMPM2 field.
	PWM_IDR2_CMPM2_Msk = 0x400
	// Bit CMPM2.
	PWM_IDR2_CMPM2 = 0x400
	// Position of CMPM3 field.
	PWM_IDR2_CMPM3_Pos = 0xb
	// Bit mask of CMPM3 field.
	PWM_IDR2_CMPM3_Msk = 0x800
	// Bit CMPM3.
	PWM_IDR2_CMPM3 = 0x800
	// Position of CMPM4 field.
	PWM_IDR2_CMPM4_Pos = 0xc
	// Bit mask of CMPM4 field.
	PWM_IDR2_CMPM4_Msk = 0x1000
	// Bit CMPM4.
	PWM_IDR2_CMPM4 = 0x1000
	// Position of CMPM5 field.
	PWM_IDR2_CMPM5_Pos = 0xd
	// Bit mask of CMPM5 field.
	PWM_IDR2_CMPM5_Msk = 0x2000
	// Bit CMPM5.
	PWM_IDR2_CMPM5 = 0x2000
	// Position of CMPM6 field.
	PWM_IDR2_CMPM6_Pos = 0xe
	// Bit mask of CMPM6 field.
	PWM_IDR2_CMPM6_Msk = 0x4000
	// Bit CMPM6.
	PWM_IDR2_CMPM6 = 0x4000
	// Position of CMPM7 field.
	PWM_IDR2_CMPM7_Pos = 0xf
	// Bit mask of CMPM7 field.
	PWM_IDR2_CMPM7_Msk = 0x8000
	// Bit CMPM7.
	PWM_IDR2_CMPM7 = 0x8000
	// Position of CMPU0 field.
	PWM_IDR2_CMPU0_Pos = 0x10
	// Bit mask of CMPU0 field.
	PWM_IDR2_CMPU0_Msk = 0x10000
	// Bit CMPU0.
	PWM_IDR2_CMPU0 = 0x10000
	// Position of CMPU1 field.
	PWM_IDR2_CMPU1_Pos = 0x11
	// Bit mask of CMPU1 field.
	PWM_IDR2_CMPU1_Msk = 0x20000
	// Bit CMPU1.
	PWM_IDR2_CMPU1 = 0x20000
	// Position of CMPU2 field.
	PWM_IDR2_CMPU2_Pos = 0x12
	// Bit mask of CMPU2 field.
	PWM_IDR2_CMPU2_Msk = 0x40000
	// Bit CMPU2.
	PWM_IDR2_CMPU2 = 0x40000
	// Position of CMPU3 field.
	PWM_IDR2_CMPU3_Pos = 0x13
	// Bit mask of CMPU3 field.
	PWM_IDR2_CMPU3_Msk = 0x80000
	// Bit CMPU3.
	PWM_IDR2_CMPU3 = 0x80000
	// Position of CMPU4 field.
	PWM_IDR2_CMPU4_Pos = 0x14
	// Bit mask of CMPU4 field.
	PWM_IDR2_CMPU4_Msk = 0x100000
	// Bit CMPU4.
	PWM_IDR2_CMPU4 = 0x100000
	// Position of CMPU5 field.
	PWM_IDR2_CMPU5_Pos = 0x15
	// Bit mask of CMPU5 field.
	PWM_IDR2_CMPU5_Msk = 0x200000
	// Bit CMPU5.
	PWM_IDR2_CMPU5 = 0x200000
	// Position of CMPU6 field.
	PWM_IDR2_CMPU6_Pos = 0x16
	// Bit mask of CMPU6 field.
	PWM_IDR2_CMPU6_Msk = 0x400000
	// Bit CMPU6.
	PWM_IDR2_CMPU6 = 0x400000
	// Position of CMPU7 field.
	PWM_IDR2_CMPU7_Pos = 0x17
	// Bit mask of CMPU7 field.
	PWM_IDR2_CMPU7_Msk = 0x800000
	// Bit CMPU7.
	PWM_IDR2_CMPU7 = 0x800000

	// IMR2: PWM Interrupt Mask Register 2
	// Position of WRDY field.
	PWM_IMR2_WRDY_Pos = 0x0
	// Bit mask of WRDY field.
	PWM_IMR2_WRDY_Msk = 0x1
	// Bit WRDY.
	PWM_IMR2_WRDY = 0x1
	// Position of ENDTX field.
	PWM_IMR2_ENDTX_Pos = 0x1
	// Bit mask of ENDTX field.
	PWM_IMR2_ENDTX_Msk = 0x2
	// Bit ENDTX.
	PWM_IMR2_ENDTX = 0x2
	// Position of TXBUFE field.
	PWM_IMR2_TXBUFE_Pos = 0x2
	// Bit mask of TXBUFE field.
	PWM_IMR2_TXBUFE_Msk = 0x4
	// Bit TXBUFE.
	PWM_IMR2_TXBUFE = 0x4
	// Position of UNRE field.
	PWM_IMR2_UNRE_Pos = 0x3
	// Bit mask of UNRE field.
	PWM_IMR2_UNRE_Msk = 0x8
	// Bit UNRE.
	PWM_IMR2_UNRE = 0x8
	// Position of CMPM0 field.
	PWM_IMR2_CMPM0_Pos = 0x8
	// Bit mask of CMPM0 field.
	PWM_IMR2_CMPM0_Msk = 0x100
	// Bit CMPM0.
	PWM_IMR2_CMPM0 = 0x100
	// Position of CMPM1 field.
	PWM_IMR2_CMPM1_Pos = 0x9
	// Bit mask of CMPM1 field.
	PWM_IMR2_CMPM1_Msk = 0x200
	// Bit CMPM1.
	PWM_IMR2_CMPM1 = 0x200
	// Position of CMPM2 field.
	PWM_IMR2_CMPM2_Pos = 0xa
	// Bit mask of CMPM2 field.
	PWM_IMR2_CMPM2_Msk = 0x400
	// Bit CMPM2.
	PWM_IMR2_CMPM2 = 0x400
	// Position of CMPM3 field.
	PWM_IMR2_CMPM3_Pos = 0xb
	// Bit mask of CMPM3 field.
	PWM_IMR2_CMPM3_Msk = 0x800
	// Bit CMPM3.
	PWM_IMR2_CMPM3 = 0x800
	// Position of CMPM4 field.
	PWM_IMR2_CMPM4_Pos = 0xc
	// Bit mask of CMPM4 field.
	PWM_IMR2_CMPM4_Msk = 0x1000
	// Bit CMPM4.
	PWM_IMR2_CMPM4 = 0x1000
	// Position of CMPM5 field.
	PWM_IMR2_CMPM5_Pos = 0xd
	// Bit mask of CMPM5 field.
	PWM_IMR2_CMPM5_Msk = 0x2000
	// Bit CMPM5.
	PWM_IMR2_CMPM5 = 0x2000
	// Position of CMPM6 field.
	PWM_IMR2_CMPM6_Pos = 0xe
	// Bit mask of CMPM6 field.
	PWM_IMR2_CMPM6_Msk = 0x4000
	// Bit CMPM6.
	PWM_IMR2_CMPM6 = 0x4000
	// Position of CMPM7 field.
	PWM_IMR2_CMPM7_Pos = 0xf
	// Bit mask of CMPM7 field.
	PWM_IMR2_CMPM7_Msk = 0x8000
	// Bit CMPM7.
	PWM_IMR2_CMPM7 = 0x8000
	// Position of CMPU0 field.
	PWM_IMR2_CMPU0_Pos = 0x10
	// Bit mask of CMPU0 field.
	PWM_IMR2_CMPU0_Msk = 0x10000
	// Bit CMPU0.
	PWM_IMR2_CMPU0 = 0x10000
	// Position of CMPU1 field.
	PWM_IMR2_CMPU1_Pos = 0x11
	// Bit mask of CMPU1 field.
	PWM_IMR2_CMPU1_Msk = 0x20000
	// Bit CMPU1.
	PWM_IMR2_CMPU1 = 0x20000
	// Position of CMPU2 field.
	PWM_IMR2_CMPU2_Pos = 0x12
	// Bit mask of CMPU2 field.
	PWM_IMR2_CMPU2_Msk = 0x40000
	// Bit CMPU2.
	PWM_IMR2_CMPU2 = 0x40000
	// Position of CMPU3 field.
	PWM_IMR2_CMPU3_Pos = 0x13
	// Bit mask of CMPU3 field.
	PWM_IMR2_CMPU3_Msk = 0x80000
	// Bit CMPU3.
	PWM_IMR2_CMPU3 = 0x80000
	// Position of CMPU4 field.
	PWM_IMR2_CMPU4_Pos = 0x14
	// Bit mask of CMPU4 field.
	PWM_IMR2_CMPU4_Msk = 0x100000
	// Bit CMPU4.
	PWM_IMR2_CMPU4 = 0x100000
	// Position of CMPU5 field.
	PWM_IMR2_CMPU5_Pos = 0x15
	// Bit mask of CMPU5 field.
	PWM_IMR2_CMPU5_Msk = 0x200000
	// Bit CMPU5.
	PWM_IMR2_CMPU5 = 0x200000
	// Position of CMPU6 field.
	PWM_IMR2_CMPU6_Pos = 0x16
	// Bit mask of CMPU6 field.
	PWM_IMR2_CMPU6_Msk = 0x400000
	// Bit CMPU6.
	PWM_IMR2_CMPU6 = 0x400000
	// Position of CMPU7 field.
	PWM_IMR2_CMPU7_Pos = 0x17
	// Bit mask of CMPU7 field.
	PWM_IMR2_CMPU7_Msk = 0x800000
	// Bit CMPU7.
	PWM_IMR2_CMPU7 = 0x800000

	// ISR2: PWM Interrupt Status Register 2
	// Position of WRDY field.
	PWM_ISR2_WRDY_Pos = 0x0
	// Bit mask of WRDY field.
	PWM_ISR2_WRDY_Msk = 0x1
	// Bit WRDY.
	PWM_ISR2_WRDY = 0x1
	// Position of ENDTX field.
	PWM_ISR2_ENDTX_Pos = 0x1
	// Bit mask of ENDTX field.
	PWM_ISR2_ENDTX_Msk = 0x2
	// Bit ENDTX.
	PWM_ISR2_ENDTX = 0x2
	// Position of TXBUFE field.
	PWM_ISR2_TXBUFE_Pos = 0x2
	// Bit mask of TXBUFE field.
	PWM_ISR2_TXBUFE_Msk = 0x4
	// Bit TXBUFE.
	PWM_ISR2_TXBUFE = 0x4
	// Position of UNRE field.
	PWM_ISR2_UNRE_Pos = 0x3
	// Bit mask of UNRE field.
	PWM_ISR2_UNRE_Msk = 0x8
	// Bit UNRE.
	PWM_ISR2_UNRE = 0x8
	// Position of CMPM0 field.
	PWM_ISR2_CMPM0_Pos = 0x8
	// Bit mask of CMPM0 field.
	PWM_ISR2_CMPM0_Msk = 0x100
	// Bit CMPM0.
	PWM_ISR2_CMPM0 = 0x100
	// Position of CMPM1 field.
	PWM_ISR2_CMPM1_Pos = 0x9
	// Bit mask of CMPM1 field.
	PWM_ISR2_CMPM1_Msk = 0x200
	// Bit CMPM1.
	PWM_ISR2_CMPM1 = 0x200
	// Position of CMPM2 field.
	PWM_ISR2_CMPM2_Pos = 0xa
	// Bit mask of CMPM2 field.
	PWM_ISR2_CMPM2_Msk = 0x400
	// Bit CMPM2.
	PWM_ISR2_CMPM2 = 0x400
	// Position of CMPM3 field.
	PWM_ISR2_CMPM3_Pos = 0xb
	// Bit mask of CMPM3 field.
	PWM_ISR2_CMPM3_Msk = 0x800
	// Bit CMPM3.
	PWM_ISR2_CMPM3 = 0x800
	// Position of CMPM4 field.
	PWM_ISR2_CMPM4_Pos = 0xc
	// Bit mask of CMPM4 field.
	PWM_ISR2_CMPM4_Msk = 0x1000
	// Bit CMPM4.
	PWM_ISR2_CMPM4 = 0x1000
	// Position of CMPM5 field.
	PWM_ISR2_CMPM5_Pos = 0xd
	// Bit mask of CMPM5 field.
	PWM_ISR2_CMPM5_Msk = 0x2000
	// Bit CMPM5.
	PWM_ISR2_CMPM5 = 0x2000
	// Position of CMPM6 field.
	PWM_ISR2_CMPM6_Pos = 0xe
	// Bit mask of CMPM6 field.
	PWM_ISR2_CMPM6_Msk = 0x4000
	// Bit CMPM6.
	PWM_ISR2_CMPM6 = 0x4000
	// Position of CMPM7 field.
	PWM_ISR2_CMPM7_Pos = 0xf
	// Bit mask of CMPM7 field.
	PWM_ISR2_CMPM7_Msk = 0x8000
	// Bit CMPM7.
	PWM_ISR2_CMPM7 = 0x8000
	// Position of CMPU0 field.
	PWM_ISR2_CMPU0_Pos = 0x10
	// Bit mask of CMPU0 field.
	PWM_ISR2_CMPU0_Msk = 0x10000
	// Bit CMPU0.
	PWM_ISR2_CMPU0 = 0x10000
	// Position of CMPU1 field.
	PWM_ISR2_CMPU1_Pos = 0x11
	// Bit mask of CMPU1 field.
	PWM_ISR2_CMPU1_Msk = 0x20000
	// Bit CMPU1.
	PWM_ISR2_CMPU1 = 0x20000
	// Position of CMPU2 field.
	PWM_ISR2_CMPU2_Pos = 0x12
	// Bit mask of CMPU2 field.
	PWM_ISR2_CMPU2_Msk = 0x40000
	// Bit CMPU2.
	PWM_ISR2_CMPU2 = 0x40000
	// Position of CMPU3 field.
	PWM_ISR2_CMPU3_Pos = 0x13
	// Bit mask of CMPU3 field.
	PWM_ISR2_CMPU3_Msk = 0x80000
	// Bit CMPU3.
	PWM_ISR2_CMPU3 = 0x80000
	// Position of CMPU4 field.
	PWM_ISR2_CMPU4_Pos = 0x14
	// Bit mask of CMPU4 field.
	PWM_ISR2_CMPU4_Msk = 0x100000
	// Bit CMPU4.
	PWM_ISR2_CMPU4 = 0x100000
	// Position of CMPU5 field.
	PWM_ISR2_CMPU5_Pos = 0x15
	// Bit mask of CMPU5 field.
	PWM_ISR2_CMPU5_Msk = 0x200000
	// Bit CMPU5.
	PWM_ISR2_CMPU5 = 0x200000
	// Position of CMPU6 field.
	PWM_ISR2_CMPU6_Pos = 0x16
	// Bit mask of CMPU6 field.
	PWM_ISR2_CMPU6_Msk = 0x400000
	// Bit CMPU6.
	PWM_ISR2_CMPU6 = 0x400000
	// Position of CMPU7 field.
	PWM_ISR2_CMPU7_Pos = 0x17
	// Bit mask of CMPU7 field.
	PWM_ISR2_CMPU7_Msk = 0x800000
	// Bit CMPU7.
	PWM_ISR2_CMPU7 = 0x800000

	// OOV: PWM Output Override Value Register
	// Position of OOVH0 field.
	PWM_OOV_OOVH0_Pos = 0x0
	// Bit mask of OOVH0 field.
	PWM_OOV_OOVH0_Msk = 0x1
	// Bit OOVH0.
	PWM_OOV_OOVH0 = 0x1
	// Position of OOVH1 field.
	PWM_OOV_OOVH1_Pos = 0x1
	// Bit mask of OOVH1 field.
	PWM_OOV_OOVH1_Msk = 0x2
	// Bit OOVH1.
	PWM_OOV_OOVH1 = 0x2
	// Position of OOVH2 field.
	PWM_OOV_OOVH2_Pos = 0x2
	// Bit mask of OOVH2 field.
	PWM_OOV_OOVH2_Msk = 0x4
	// Bit OOVH2.
	PWM_OOV_OOVH2 = 0x4
	// Position of OOVH3 field.
	PWM_OOV_OOVH3_Pos = 0x3
	// Bit mask of OOVH3 field.
	PWM_OOV_OOVH3_Msk = 0x8
	// Bit OOVH3.
	PWM_OOV_OOVH3 = 0x8
	// Position of OOVH4 field.
	PWM_OOV_OOVH4_Pos = 0x4
	// Bit mask of OOVH4 field.
	PWM_OOV_OOVH4_Msk = 0x10
	// Bit OOVH4.
	PWM_OOV_OOVH4 = 0x10
	// Position of OOVH5 field.
	PWM_OOV_OOVH5_Pos = 0x5
	// Bit mask of OOVH5 field.
	PWM_OOV_OOVH5_Msk = 0x20
	// Bit OOVH5.
	PWM_OOV_OOVH5 = 0x20
	// Position of OOVH6 field.
	PWM_OOV_OOVH6_Pos = 0x6
	// Bit mask of OOVH6 field.
	PWM_OOV_OOVH6_Msk = 0x40
	// Bit OOVH6.
	PWM_OOV_OOVH6 = 0x40
	// Position of OOVH7 field.
	PWM_OOV_OOVH7_Pos = 0x7
	// Bit mask of OOVH7 field.
	PWM_OOV_OOVH7_Msk = 0x80
	// Bit OOVH7.
	PWM_OOV_OOVH7 = 0x80
	// Position of OOVL0 field.
	PWM_OOV_OOVL0_Pos = 0x10
	// Bit mask of OOVL0 field.
	PWM_OOV_OOVL0_Msk = 0x10000
	// Bit OOVL0.
	PWM_OOV_OOVL0 = 0x10000
	// Position of OOVL1 field.
	PWM_OOV_OOVL1_Pos = 0x11
	// Bit mask of OOVL1 field.
	PWM_OOV_OOVL1_Msk = 0x20000
	// Bit OOVL1.
	PWM_OOV_OOVL1 = 0x20000
	// Position of OOVL2 field.
	PWM_OOV_OOVL2_Pos = 0x12
	// Bit mask of OOVL2 field.
	PWM_OOV_OOVL2_Msk = 0x40000
	// Bit OOVL2.
	PWM_OOV_OOVL2 = 0x40000
	// Position of OOVL3 field.
	PWM_OOV_OOVL3_Pos = 0x13
	// Bit mask of OOVL3 field.
	PWM_OOV_OOVL3_Msk = 0x80000
	// Bit OOVL3.
	PWM_OOV_OOVL3 = 0x80000
	// Position of OOVL4 field.
	PWM_OOV_OOVL4_Pos = 0x14
	// Bit mask of OOVL4 field.
	PWM_OOV_OOVL4_Msk = 0x100000
	// Bit OOVL4.
	PWM_OOV_OOVL4 = 0x100000
	// Position of OOVL5 field.
	PWM_OOV_OOVL5_Pos = 0x15
	// Bit mask of OOVL5 field.
	PWM_OOV_OOVL5_Msk = 0x200000
	// Bit OOVL5.
	PWM_OOV_OOVL5 = 0x200000
	// Position of OOVL6 field.
	PWM_OOV_OOVL6_Pos = 0x16
	// Bit mask of OOVL6 field.
	PWM_OOV_OOVL6_Msk = 0x400000
	// Bit OOVL6.
	PWM_OOV_OOVL6 = 0x400000
	// Position of OOVL7 field.
	PWM_OOV_OOVL7_Pos = 0x17
	// Bit mask of OOVL7 field.
	PWM_OOV_OOVL7_Msk = 0x800000
	// Bit OOVL7.
	PWM_OOV_OOVL7 = 0x800000

	// OS: PWM Output Selection Register
	// Position of OSH0 field.
	PWM_OS_OSH0_Pos = 0x0
	// Bit mask of OSH0 field.
	PWM_OS_OSH0_Msk = 0x1
	// Bit OSH0.
	PWM_OS_OSH0 = 0x1
	// Position of OSH1 field.
	PWM_OS_OSH1_Pos = 0x1
	// Bit mask of OSH1 field.
	PWM_OS_OSH1_Msk = 0x2
	// Bit OSH1.
	PWM_OS_OSH1 = 0x2
	// Position of OSH2 field.
	PWM_OS_OSH2_Pos = 0x2
	// Bit mask of OSH2 field.
	PWM_OS_OSH2_Msk = 0x4
	// Bit OSH2.
	PWM_OS_OSH2 = 0x4
	// Position of OSH3 field.
	PWM_OS_OSH3_Pos = 0x3
	// Bit mask of OSH3 field.
	PWM_OS_OSH3_Msk = 0x8
	// Bit OSH3.
	PWM_OS_OSH3 = 0x8
	// Position of OSH4 field.
	PWM_OS_OSH4_Pos = 0x4
	// Bit mask of OSH4 field.
	PWM_OS_OSH4_Msk = 0x10
	// Bit OSH4.
	PWM_OS_OSH4 = 0x10
	// Position of OSH5 field.
	PWM_OS_OSH5_Pos = 0x5
	// Bit mask of OSH5 field.
	PWM_OS_OSH5_Msk = 0x20
	// Bit OSH5.
	PWM_OS_OSH5 = 0x20
	// Position of OSH6 field.
	PWM_OS_OSH6_Pos = 0x6
	// Bit mask of OSH6 field.
	PWM_OS_OSH6_Msk = 0x40
	// Bit OSH6.
	PWM_OS_OSH6 = 0x40
	// Position of OSH7 field.
	PWM_OS_OSH7_Pos = 0x7
	// Bit mask of OSH7 field.
	PWM_OS_OSH7_Msk = 0x80
	// Bit OSH7.
	PWM_OS_OSH7 = 0x80
	// Position of OSL0 field.
	PWM_OS_OSL0_Pos = 0x10
	// Bit mask of OSL0 field.
	PWM_OS_OSL0_Msk = 0x10000
	// Bit OSL0.
	PWM_OS_OSL0 = 0x10000
	// Position of OSL1 field.
	PWM_OS_OSL1_Pos = 0x11
	// Bit mask of OSL1 field.
	PWM_OS_OSL1_Msk = 0x20000
	// Bit OSL1.
	PWM_OS_OSL1 = 0x20000
	// Position of OSL2 field.
	PWM_OS_OSL2_Pos = 0x12
	// Bit mask of OSL2 field.
	PWM_OS_OSL2_Msk = 0x40000
	// Bit OSL2.
	PWM_OS_OSL2 = 0x40000
	// Position of OSL3 field.
	PWM_OS_OSL3_Pos = 0x13
	// Bit mask of OSL3 field.
	PWM_OS_OSL3_Msk = 0x80000
	// Bit OSL3.
	PWM_OS_OSL3 = 0x80000
	// Position of OSL4 field.
	PWM_OS_OSL4_Pos = 0x14
	// Bit mask of OSL4 field.
	PWM_OS_OSL4_Msk = 0x100000
	// Bit OSL4.
	PWM_OS_OSL4 = 0x100000
	// Position of OSL5 field.
	PWM_OS_OSL5_Pos = 0x15
	// Bit mask of OSL5 field.
	PWM_OS_OSL5_Msk = 0x200000
	// Bit OSL5.
	PWM_OS_OSL5 = 0x200000
	// Position of OSL6 field.
	PWM_OS_OSL6_Pos = 0x16
	// Bit mask of OSL6 field.
	PWM_OS_OSL6_Msk = 0x400000
	// Bit OSL6.
	PWM_OS_OSL6 = 0x400000
	// Position of OSL7 field.
	PWM_OS_OSL7_Pos = 0x17
	// Bit mask of OSL7 field.
	PWM_OS_OSL7_Msk = 0x800000
	// Bit OSL7.
	PWM_OS_OSL7 = 0x800000

	// OSS: PWM Output Selection Set Register
	// Position of OSSH0 field.
	PWM_OSS_OSSH0_Pos = 0x0
	// Bit mask of OSSH0 field.
	PWM_OSS_OSSH0_Msk = 0x1
	// Bit OSSH0.
	PWM_OSS_OSSH0 = 0x1
	// Position of OSSH1 field.
	PWM_OSS_OSSH1_Pos = 0x1
	// Bit mask of OSSH1 field.
	PWM_OSS_OSSH1_Msk = 0x2
	// Bit OSSH1.
	PWM_OSS_OSSH1 = 0x2
	// Position of OSSH2 field.
	PWM_OSS_OSSH2_Pos = 0x2
	// Bit mask of OSSH2 field.
	PWM_OSS_OSSH2_Msk = 0x4
	// Bit OSSH2.
	PWM_OSS_OSSH2 = 0x4
	// Position of OSSH3 field.
	PWM_OSS_OSSH3_Pos = 0x3
	// Bit mask of OSSH3 field.
	PWM_OSS_OSSH3_Msk = 0x8
	// Bit OSSH3.
	PWM_OSS_OSSH3 = 0x8
	// Position of OSSH4 field.
	PWM_OSS_OSSH4_Pos = 0x4
	// Bit mask of OSSH4 field.
	PWM_OSS_OSSH4_Msk = 0x10
	// Bit OSSH4.
	PWM_OSS_OSSH4 = 0x10
	// Position of OSSH5 field.
	PWM_OSS_OSSH5_Pos = 0x5
	// Bit mask of OSSH5 field.
	PWM_OSS_OSSH5_Msk = 0x20
	// Bit OSSH5.
	PWM_OSS_OSSH5 = 0x20
	// Position of OSSH6 field.
	PWM_OSS_OSSH6_Pos = 0x6
	// Bit mask of OSSH6 field.
	PWM_OSS_OSSH6_Msk = 0x40
	// Bit OSSH6.
	PWM_OSS_OSSH6 = 0x40
	// Position of OSSH7 field.
	PWM_OSS_OSSH7_Pos = 0x7
	// Bit mask of OSSH7 field.
	PWM_OSS_OSSH7_Msk = 0x80
	// Bit OSSH7.
	PWM_OSS_OSSH7 = 0x80
	// Position of OSSL0 field.
	PWM_OSS_OSSL0_Pos = 0x10
	// Bit mask of OSSL0 field.
	PWM_OSS_OSSL0_Msk = 0x10000
	// Bit OSSL0.
	PWM_OSS_OSSL0 = 0x10000
	// Position of OSSL1 field.
	PWM_OSS_OSSL1_Pos = 0x11
	// Bit mask of OSSL1 field.
	PWM_OSS_OSSL1_Msk = 0x20000
	// Bit OSSL1.
	PWM_OSS_OSSL1 = 0x20000
	// Position of OSSL2 field.
	PWM_OSS_OSSL2_Pos = 0x12
	// Bit mask of OSSL2 field.
	PWM_OSS_OSSL2_Msk = 0x40000
	// Bit OSSL2.
	PWM_OSS_OSSL2 = 0x40000
	// Position of OSSL3 field.
	PWM_OSS_OSSL3_Pos = 0x13
	// Bit mask of OSSL3 field.
	PWM_OSS_OSSL3_Msk = 0x80000
	// Bit OSSL3.
	PWM_OSS_OSSL3 = 0x80000
	// Position of OSSL4 field.
	PWM_OSS_OSSL4_Pos = 0x14
	// Bit mask of OSSL4 field.
	PWM_OSS_OSSL4_Msk = 0x100000
	// Bit OSSL4.
	PWM_OSS_OSSL4 = 0x100000
	// Position of OSSL5 field.
	PWM_OSS_OSSL5_Pos = 0x15
	// Bit mask of OSSL5 field.
	PWM_OSS_OSSL5_Msk = 0x200000
	// Bit OSSL5.
	PWM_OSS_OSSL5 = 0x200000
	// Position of OSSL6 field.
	PWM_OSS_OSSL6_Pos = 0x16
	// Bit mask of OSSL6 field.
	PWM_OSS_OSSL6_Msk = 0x400000
	// Bit OSSL6.
	PWM_OSS_OSSL6 = 0x400000
	// Position of OSSL7 field.
	PWM_OSS_OSSL7_Pos = 0x17
	// Bit mask of OSSL7 field.
	PWM_OSS_OSSL7_Msk = 0x800000
	// Bit OSSL7.
	PWM_OSS_OSSL7 = 0x800000

	// OSC: PWM Output Selection Clear Register
	// Position of OSCH0 field.
	PWM_OSC_OSCH0_Pos = 0x0
	// Bit mask of OSCH0 field.
	PWM_OSC_OSCH0_Msk = 0x1
	// Bit OSCH0.
	PWM_OSC_OSCH0 = 0x1
	// Position of OSCH1 field.
	PWM_OSC_OSCH1_Pos = 0x1
	// Bit mask of OSCH1 field.
	PWM_OSC_OSCH1_Msk = 0x2
	// Bit OSCH1.
	PWM_OSC_OSCH1 = 0x2
	// Position of OSCH2 field.
	PWM_OSC_OSCH2_Pos = 0x2
	// Bit mask of OSCH2 field.
	PWM_OSC_OSCH2_Msk = 0x4
	// Bit OSCH2.
	PWM_OSC_OSCH2 = 0x4
	// Position of OSCH3 field.
	PWM_OSC_OSCH3_Pos = 0x3
	// Bit mask of OSCH3 field.
	PWM_OSC_OSCH3_Msk = 0x8
	// Bit OSCH3.
	PWM_OSC_OSCH3 = 0x8
	// Position of OSCH4 field.
	PWM_OSC_OSCH4_Pos = 0x4
	// Bit mask of OSCH4 field.
	PWM_OSC_OSCH4_Msk = 0x10
	// Bit OSCH4.
	PWM_OSC_OSCH4 = 0x10
	// Position of OSCH5 field.
	PWM_OSC_OSCH5_Pos = 0x5
	// Bit mask of OSCH5 field.
	PWM_OSC_OSCH5_Msk = 0x20
	// Bit OSCH5.
	PWM_OSC_OSCH5 = 0x20
	// Position of OSCH6 field.
	PWM_OSC_OSCH6_Pos = 0x6
	// Bit mask of OSCH6 field.
	PWM_OSC_OSCH6_Msk = 0x40
	// Bit OSCH6.
	PWM_OSC_OSCH6 = 0x40
	// Position of OSCH7 field.
	PWM_OSC_OSCH7_Pos = 0x7
	// Bit mask of OSCH7 field.
	PWM_OSC_OSCH7_Msk = 0x80
	// Bit OSCH7.
	PWM_OSC_OSCH7 = 0x80
	// Position of OSCL0 field.
	PWM_OSC_OSCL0_Pos = 0x10
	// Bit mask of OSCL0 field.
	PWM_OSC_OSCL0_Msk = 0x10000
	// Bit OSCL0.
	PWM_OSC_OSCL0 = 0x10000
	// Position of OSCL1 field.
	PWM_OSC_OSCL1_Pos = 0x11
	// Bit mask of OSCL1 field.
	PWM_OSC_OSCL1_Msk = 0x20000
	// Bit OSCL1.
	PWM_OSC_OSCL1 = 0x20000
	// Position of OSCL2 field.
	PWM_OSC_OSCL2_Pos = 0x12
	// Bit mask of OSCL2 field.
	PWM_OSC_OSCL2_Msk = 0x40000
	// Bit OSCL2.
	PWM_OSC_OSCL2 = 0x40000
	// Position of OSCL3 field.
	PWM_OSC_OSCL3_Pos = 0x13
	// Bit mask of OSCL3 field.
	PWM_OSC_OSCL3_Msk = 0x80000
	// Bit OSCL3.
	PWM_OSC_OSCL3 = 0x80000
	// Position of OSCL4 field.
	PWM_OSC_OSCL4_Pos = 0x14
	// Bit mask of OSCL4 field.
	PWM_OSC_OSCL4_Msk = 0x100000
	// Bit OSCL4.
	PWM_OSC_OSCL4 = 0x100000
	// Position of OSCL5 field.
	PWM_OSC_OSCL5_Pos = 0x15
	// Bit mask of OSCL5 field.
	PWM_OSC_OSCL5_Msk = 0x200000
	// Bit OSCL5.
	PWM_OSC_OSCL5 = 0x200000
	// Position of OSCL6 field.
	PWM_OSC_OSCL6_Pos = 0x16
	// Bit mask of OSCL6 field.
	PWM_OSC_OSCL6_Msk = 0x400000
	// Bit OSCL6.
	PWM_OSC_OSCL6 = 0x400000
	// Position of OSCL7 field.
	PWM_OSC_OSCL7_Pos = 0x17
	// Bit mask of OSCL7 field.
	PWM_OSC_OSCL7_Msk = 0x800000
	// Bit OSCL7.
	PWM_OSC_OSCL7 = 0x800000

	// OSSUPD: PWM Output Selection Set Update Register
	// Position of OSSUPH0 field.
	PWM_OSSUPD_OSSUPH0_Pos = 0x0
	// Bit mask of OSSUPH0 field.
	PWM_OSSUPD_OSSUPH0_Msk = 0x1
	// Bit OSSUPH0.
	PWM_OSSUPD_OSSUPH0 = 0x1
	// Position of OSSUPH1 field.
	PWM_OSSUPD_OSSUPH1_Pos = 0x1
	// Bit mask of OSSUPH1 field.
	PWM_OSSUPD_OSSUPH1_Msk = 0x2
	// Bit OSSUPH1.
	PWM_OSSUPD_OSSUPH1 = 0x2
	// Position of OSSUPH2 field.
	PWM_OSSUPD_OSSUPH2_Pos = 0x2
	// Bit mask of OSSUPH2 field.
	PWM_OSSUPD_OSSUPH2_Msk = 0x4
	// Bit OSSUPH2.
	PWM_OSSUPD_OSSUPH2 = 0x4
	// Position of OSSUPH3 field.
	PWM_OSSUPD_OSSUPH3_Pos = 0x3
	// Bit mask of OSSUPH3 field.
	PWM_OSSUPD_OSSUPH3_Msk = 0x8
	// Bit OSSUPH3.
	PWM_OSSUPD_OSSUPH3 = 0x8
	// Position of OSSUPH4 field.
	PWM_OSSUPD_OSSUPH4_Pos = 0x4
	// Bit mask of OSSUPH4 field.
	PWM_OSSUPD_OSSUPH4_Msk = 0x10
	// Bit OSSUPH4.
	PWM_OSSUPD_OSSUPH4 = 0x10
	// Position of OSSUPH5 field.
	PWM_OSSUPD_OSSUPH5_Pos = 0x5
	// Bit mask of OSSUPH5 field.
	PWM_OSSUPD_OSSUPH5_Msk = 0x20
	// Bit OSSUPH5.
	PWM_OSSUPD_OSSUPH5 = 0x20
	// Position of OSSUPH6 field.
	PWM_OSSUPD_OSSUPH6_Pos = 0x6
	// Bit mask of OSSUPH6 field.
	PWM_OSSUPD_OSSUPH6_Msk = 0x40
	// Bit OSSUPH6.
	PWM_OSSUPD_OSSUPH6 = 0x40
	// Position of OSSUPH7 field.
	PWM_OSSUPD_OSSUPH7_Pos = 0x7
	// Bit mask of OSSUPH7 field.
	PWM_OSSUPD_OSSUPH7_Msk = 0x80
	// Bit OSSUPH7.
	PWM_OSSUPD_OSSUPH7 = 0x80
	// Position of OSSUPL0 field.
	PWM_OSSUPD_OSSUPL0_Pos = 0x10
	// Bit mask of OSSUPL0 field.
	PWM_OSSUPD_OSSUPL0_Msk = 0x10000
	// Bit OSSUPL0.
	PWM_OSSUPD_OSSUPL0 = 0x10000
	// Position of OSSUPL1 field.
	PWM_OSSUPD_OSSUPL1_Pos = 0x11
	// Bit mask of OSSUPL1 field.
	PWM_OSSUPD_OSSUPL1_Msk = 0x20000
	// Bit OSSUPL1.
	PWM_OSSUPD_OSSUPL1 = 0x20000
	// Position of OSSUPL2 field.
	PWM_OSSUPD_OSSUPL2_Pos = 0x12
	// Bit mask of OSSUPL2 field.
	PWM_OSSUPD_OSSUPL2_Msk = 0x40000
	// Bit OSSUPL2.
	PWM_OSSUPD_OSSUPL2 = 0x40000
	// Position of OSSUPL3 field.
	PWM_OSSUPD_OSSUPL3_Pos = 0x13
	// Bit mask of OSSUPL3 field.
	PWM_OSSUPD_OSSUPL3_Msk = 0x80000
	// Bit OSSUPL3.
	PWM_OSSUPD_OSSUPL3 = 0x80000
	// Position of OSSUPL4 field.
	PWM_OSSUPD_OSSUPL4_Pos = 0x14
	// Bit mask of OSSUPL4 field.
	PWM_OSSUPD_OSSUPL4_Msk = 0x100000
	// Bit OSSUPL4.
	PWM_OSSUPD_OSSUPL4 = 0x100000
	// Position of OSSUPL5 field.
	PWM_OSSUPD_OSSUPL5_Pos = 0x15
	// Bit mask of OSSUPL5 field.
	PWM_OSSUPD_OSSUPL5_Msk = 0x200000
	// Bit OSSUPL5.
	PWM_OSSUPD_OSSUPL5 = 0x200000
	// Position of OSSUPL6 field.
	PWM_OSSUPD_OSSUPL6_Pos = 0x16
	// Bit mask of OSSUPL6 field.
	PWM_OSSUPD_OSSUPL6_Msk = 0x400000
	// Bit OSSUPL6.
	PWM_OSSUPD_OSSUPL6 = 0x400000
	// Position of OSSUPL7 field.
	PWM_OSSUPD_OSSUPL7_Pos = 0x17
	// Bit mask of OSSUPL7 field.
	PWM_OSSUPD_OSSUPL7_Msk = 0x800000
	// Bit OSSUPL7.
	PWM_OSSUPD_OSSUPL7 = 0x800000

	// OSCUPD: PWM Output Selection Clear Update Register
	// Position of OSCUPH0 field.
	PWM_OSCUPD_OSCUPH0_Pos = 0x0
	// Bit mask of OSCUPH0 field.
	PWM_OSCUPD_OSCUPH0_Msk = 0x1
	// Bit OSCUPH0.
	PWM_OSCUPD_OSCUPH0 = 0x1
	// Position of OSCUPH1 field.
	PWM_OSCUPD_OSCUPH1_Pos = 0x1
	// Bit mask of OSCUPH1 field.
	PWM_OSCUPD_OSCUPH1_Msk = 0x2
	// Bit OSCUPH1.
	PWM_OSCUPD_OSCUPH1 = 0x2
	// Position of OSCUPH2 field.
	PWM_OSCUPD_OSCUPH2_Pos = 0x2
	// Bit mask of OSCUPH2 field.
	PWM_OSCUPD_OSCUPH2_Msk = 0x4
	// Bit OSCUPH2.
	PWM_OSCUPD_OSCUPH2 = 0x4
	// Position of OSCUPH3 field.
	PWM_OSCUPD_OSCUPH3_Pos = 0x3
	// Bit mask of OSCUPH3 field.
	PWM_OSCUPD_OSCUPH3_Msk = 0x8
	// Bit OSCUPH3.
	PWM_OSCUPD_OSCUPH3 = 0x8
	// Position of OSCUPH4 field.
	PWM_OSCUPD_OSCUPH4_Pos = 0x4
	// Bit mask of OSCUPH4 field.
	PWM_OSCUPD_OSCUPH4_Msk = 0x10
	// Bit OSCUPH4.
	PWM_OSCUPD_OSCUPH4 = 0x10
	// Position of OSCUPH5 field.
	PWM_OSCUPD_OSCUPH5_Pos = 0x5
	// Bit mask of OSCUPH5 field.
	PWM_OSCUPD_OSCUPH5_Msk = 0x20
	// Bit OSCUPH5.
	PWM_OSCUPD_OSCUPH5 = 0x20
	// Position of OSCUPH6 field.
	PWM_OSCUPD_OSCUPH6_Pos = 0x6
	// Bit mask of OSCUPH6 field.
	PWM_OSCUPD_OSCUPH6_Msk = 0x40
	// Bit OSCUPH6.
	PWM_OSCUPD_OSCUPH6 = 0x40
	// Position of OSCUPH7 field.
	PWM_OSCUPD_OSCUPH7_Pos = 0x7
	// Bit mask of OSCUPH7 field.
	PWM_OSCUPD_OSCUPH7_Msk = 0x80
	// Bit OSCUPH7.
	PWM_OSCUPD_OSCUPH7 = 0x80
	// Position of OSCUPL0 field.
	PWM_OSCUPD_OSCUPL0_Pos = 0x10
	// Bit mask of OSCUPL0 field.
	PWM_OSCUPD_OSCUPL0_Msk = 0x10000
	// Bit OSCUPL0.
	PWM_OSCUPD_OSCUPL0 = 0x10000
	// Position of OSCUPL1 field.
	PWM_OSCUPD_OSCUPL1_Pos = 0x11
	// Bit mask of OSCUPL1 field.
	PWM_OSCUPD_OSCUPL1_Msk = 0x20000
	// Bit OSCUPL1.
	PWM_OSCUPD_OSCUPL1 = 0x20000
	// Position of OSCUPL2 field.
	PWM_OSCUPD_OSCUPL2_Pos = 0x12
	// Bit mask of OSCUPL2 field.
	PWM_OSCUPD_OSCUPL2_Msk = 0x40000
	// Bit OSCUPL2.
	PWM_OSCUPD_OSCUPL2 = 0x40000
	// Position of OSCUPL3 field.
	PWM_OSCUPD_OSCUPL3_Pos = 0x13
	// Bit mask of OSCUPL3 field.
	PWM_OSCUPD_OSCUPL3_Msk = 0x80000
	// Bit OSCUPL3.
	PWM_OSCUPD_OSCUPL3 = 0x80000
	// Position of OSCUPL4 field.
	PWM_OSCUPD_OSCUPL4_Pos = 0x14
	// Bit mask of OSCUPL4 field.
	PWM_OSCUPD_OSCUPL4_Msk = 0x100000
	// Bit OSCUPL4.
	PWM_OSCUPD_OSCUPL4 = 0x100000
	// Position of OSCUPL5 field.
	PWM_OSCUPD_OSCUPL5_Pos = 0x15
	// Bit mask of OSCUPL5 field.
	PWM_OSCUPD_OSCUPL5_Msk = 0x200000
	// Bit OSCUPL5.
	PWM_OSCUPD_OSCUPL5 = 0x200000
	// Position of OSCUPL6 field.
	PWM_OSCUPD_OSCUPL6_Pos = 0x16
	// Bit mask of OSCUPL6 field.
	PWM_OSCUPD_OSCUPL6_Msk = 0x400000
	// Bit OSCUPL6.
	PWM_OSCUPD_OSCUPL6 = 0x400000
	// Position of OSCUPL7 field.
	PWM_OSCUPD_OSCUPL7_Pos = 0x17
	// Bit mask of OSCUPL7 field.
	PWM_OSCUPD_OSCUPL7_Msk = 0x800000
	// Bit OSCUPL7.
	PWM_OSCUPD_OSCUPL7 = 0x800000

	// FMR: PWM Fault Mode Register
	// Position of FPOL field.
	PWM_FMR_FPOL_Pos = 0x0
	// Bit mask of FPOL field.
	PWM_FMR_FPOL_Msk = 0xff
	// Position of FMOD field.
	PWM_FMR_FMOD_Pos = 0x8
	// Bit mask of FMOD field.
	PWM_FMR_FMOD_Msk = 0xff00
	// Position of FFIL field.
	PWM_FMR_FFIL_Pos = 0x10
	// Bit mask of FFIL field.
	PWM_FMR_FFIL_Msk = 0xff0000

	// FSR: PWM Fault Status Register
	// Position of FIV field.
	PWM_FSR_FIV_Pos = 0x0
	// Bit mask of FIV field.
	PWM_FSR_FIV_Msk = 0xff
	// Position of FS field.
	PWM_FSR_FS_Pos = 0x8
	// Bit mask of FS field.
	PWM_FSR_FS_Msk = 0xff00

	// FCR: PWM Fault Clear Register
	// Position of FCLR field.
	PWM_FCR_FCLR_Pos = 0x0
	// Bit mask of FCLR field.
	PWM_FCR_FCLR_Msk = 0xff

	// FPV: PWM Fault Protection Value Register
	// Position of FPVH0 field.
	PWM_FPV_FPVH0_Pos = 0x0
	// Bit mask of FPVH0 field.
	PWM_FPV_FPVH0_Msk = 0x1
	// Bit FPVH0.
	PWM_FPV_FPVH0 = 0x1
	// Position of FPVH1 field.
	PWM_FPV_FPVH1_Pos = 0x1
	// Bit mask of FPVH1 field.
	PWM_FPV_FPVH1_Msk = 0x2
	// Bit FPVH1.
	PWM_FPV_FPVH1 = 0x2
	// Position of FPVH2 field.
	PWM_FPV_FPVH2_Pos = 0x2
	// Bit mask of FPVH2 field.
	PWM_FPV_FPVH2_Msk = 0x4
	// Bit FPVH2.
	PWM_FPV_FPVH2 = 0x4
	// Position of FPVH3 field.
	PWM_FPV_FPVH3_Pos = 0x3
	// Bit mask of FPVH3 field.
	PWM_FPV_FPVH3_Msk = 0x8
	// Bit FPVH3.
	PWM_FPV_FPVH3 = 0x8
	// Position of FPVH4 field.
	PWM_FPV_FPVH4_Pos = 0x4
	// Bit mask of FPVH4 field.
	PWM_FPV_FPVH4_Msk = 0x10
	// Bit FPVH4.
	PWM_FPV_FPVH4 = 0x10
	// Position of FPVH5 field.
	PWM_FPV_FPVH5_Pos = 0x5
	// Bit mask of FPVH5 field.
	PWM_FPV_FPVH5_Msk = 0x20
	// Bit FPVH5.
	PWM_FPV_FPVH5 = 0x20
	// Position of FPVH6 field.
	PWM_FPV_FPVH6_Pos = 0x6
	// Bit mask of FPVH6 field.
	PWM_FPV_FPVH6_Msk = 0x40
	// Bit FPVH6.
	PWM_FPV_FPVH6 = 0x40
	// Position of FPVH7 field.
	PWM_FPV_FPVH7_Pos = 0x7
	// Bit mask of FPVH7 field.
	PWM_FPV_FPVH7_Msk = 0x80
	// Bit FPVH7.
	PWM_FPV_FPVH7 = 0x80
	// Position of FPVL0 field.
	PWM_FPV_FPVL0_Pos = 0x10
	// Bit mask of FPVL0 field.
	PWM_FPV_FPVL0_Msk = 0x10000
	// Bit FPVL0.
	PWM_FPV_FPVL0 = 0x10000
	// Position of FPVL1 field.
	PWM_FPV_FPVL1_Pos = 0x11
	// Bit mask of FPVL1 field.
	PWM_FPV_FPVL1_Msk = 0x20000
	// Bit FPVL1.
	PWM_FPV_FPVL1 = 0x20000
	// Position of FPVL2 field.
	PWM_FPV_FPVL2_Pos = 0x12
	// Bit mask of FPVL2 field.
	PWM_FPV_FPVL2_Msk = 0x40000
	// Bit FPVL2.
	PWM_FPV_FPVL2 = 0x40000
	// Position of FPVL3 field.
	PWM_FPV_FPVL3_Pos = 0x13
	// Bit mask of FPVL3 field.
	PWM_FPV_FPVL3_Msk = 0x80000
	// Bit FPVL3.
	PWM_FPV_FPVL3 = 0x80000
	// Position of FPVL4 field.
	PWM_FPV_FPVL4_Pos = 0x14
	// Bit mask of FPVL4 field.
	PWM_FPV_FPVL4_Msk = 0x100000
	// Bit FPVL4.
	PWM_FPV_FPVL4 = 0x100000
	// Position of FPVL5 field.
	PWM_FPV_FPVL5_Pos = 0x15
	// Bit mask of FPVL5 field.
	PWM_FPV_FPVL5_Msk = 0x200000
	// Bit FPVL5.
	PWM_FPV_FPVL5 = 0x200000
	// Position of FPVL6 field.
	PWM_FPV_FPVL6_Pos = 0x16
	// Bit mask of FPVL6 field.
	PWM_FPV_FPVL6_Msk = 0x400000
	// Bit FPVL6.
	PWM_FPV_FPVL6 = 0x400000
	// Position of FPVL7 field.
	PWM_FPV_FPVL7_Pos = 0x17
	// Bit mask of FPVL7 field.
	PWM_FPV_FPVL7_Msk = 0x800000
	// Bit FPVL7.
	PWM_FPV_FPVL7 = 0x800000

	// FPE1: PWM Fault Protection Enable Register 1
	// Position of FPE0 field.
	PWM_FPE1_FPE0_Pos = 0x0
	// Bit mask of FPE0 field.
	PWM_FPE1_FPE0_Msk = 0xff
	// Position of FPE1 field.
	PWM_FPE1_FPE1_Pos = 0x8
	// Bit mask of FPE1 field.
	PWM_FPE1_FPE1_Msk = 0xff00
	// Position of FPE2 field.
	PWM_FPE1_FPE2_Pos = 0x10
	// Bit mask of FPE2 field.
	PWM_FPE1_FPE2_Msk = 0xff0000
	// Position of FPE3 field.
	PWM_FPE1_FPE3_Pos = 0x18
	// Bit mask of FPE3 field.
	PWM_FPE1_FPE3_Msk = 0xff000000

	// FPE2: PWM Fault Protection Enable Register 2
	// Position of FPE4 field.
	PWM_FPE2_FPE4_Pos = 0x0
	// Bit mask of FPE4 field.
	PWM_FPE2_FPE4_Msk = 0xff
	// Position of FPE5 field.
	PWM_FPE2_FPE5_Pos = 0x8
	// Bit mask of FPE5 field.
	PWM_FPE2_FPE5_Msk = 0xff00
	// Position of FPE6 field.
	PWM_FPE2_FPE6_Pos = 0x10
	// Bit mask of FPE6 field.
	PWM_FPE2_FPE6_Msk = 0xff0000
	// Position of FPE7 field.
	PWM_FPE2_FPE7_Pos = 0x18
	// Bit mask of FPE7 field.
	PWM_FPE2_FPE7_Msk = 0xff000000

	// ELMR: PWM Event Line 0 Mode Register
	// Position of CSEL0 field.
	PWM_ELMR_CSEL0_Pos = 0x0
	// Bit mask of CSEL0 field.
	PWM_ELMR_CSEL0_Msk = 0x1
	// Bit CSEL0.
	PWM_ELMR_CSEL0 = 0x1
	// Position of CSEL1 field.
	PWM_ELMR_CSEL1_Pos = 0x1
	// Bit mask of CSEL1 field.
	PWM_ELMR_CSEL1_Msk = 0x2
	// Bit CSEL1.
	PWM_ELMR_CSEL1 = 0x2
	// Position of CSEL2 field.
	PWM_ELMR_CSEL2_Pos = 0x2
	// Bit mask of CSEL2 field.
	PWM_ELMR_CSEL2_Msk = 0x4
	// Bit CSEL2.
	PWM_ELMR_CSEL2 = 0x4
	// Position of CSEL3 field.
	PWM_ELMR_CSEL3_Pos = 0x3
	// Bit mask of CSEL3 field.
	PWM_ELMR_CSEL3_Msk = 0x8
	// Bit CSEL3.
	PWM_ELMR_CSEL3 = 0x8
	// Position of CSEL4 field.
	PWM_ELMR_CSEL4_Pos = 0x4
	// Bit mask of CSEL4 field.
	PWM_ELMR_CSEL4_Msk = 0x10
	// Bit CSEL4.
	PWM_ELMR_CSEL4 = 0x10
	// Position of CSEL5 field.
	PWM_ELMR_CSEL5_Pos = 0x5
	// Bit mask of CSEL5 field.
	PWM_ELMR_CSEL5_Msk = 0x20
	// Bit CSEL5.
	PWM_ELMR_CSEL5 = 0x20
	// Position of CSEL6 field.
	PWM_ELMR_CSEL6_Pos = 0x6
	// Bit mask of CSEL6 field.
	PWM_ELMR_CSEL6_Msk = 0x40
	// Bit CSEL6.
	PWM_ELMR_CSEL6 = 0x40
	// Position of CSEL7 field.
	PWM_ELMR_CSEL7_Pos = 0x7
	// Bit mask of CSEL7 field.
	PWM_ELMR_CSEL7_Msk = 0x80
	// Bit CSEL7.
	PWM_ELMR_CSEL7 = 0x80

	// SMMR: PWM Stepper Motor Mode Register
	// Position of GCEN0 field.
	PWM_SMMR_GCEN0_Pos = 0x0
	// Bit mask of GCEN0 field.
	PWM_SMMR_GCEN0_Msk = 0x1
	// Bit GCEN0.
	PWM_SMMR_GCEN0 = 0x1
	// Position of GCEN1 field.
	PWM_SMMR_GCEN1_Pos = 0x1
	// Bit mask of GCEN1 field.
	PWM_SMMR_GCEN1_Msk = 0x2
	// Bit GCEN1.
	PWM_SMMR_GCEN1 = 0x2
	// Position of GCEN2 field.
	PWM_SMMR_GCEN2_Pos = 0x2
	// Bit mask of GCEN2 field.
	PWM_SMMR_GCEN2_Msk = 0x4
	// Bit GCEN2.
	PWM_SMMR_GCEN2 = 0x4
	// Position of GCEN3 field.
	PWM_SMMR_GCEN3_Pos = 0x3
	// Bit mask of GCEN3 field.
	PWM_SMMR_GCEN3_Msk = 0x8
	// Bit GCEN3.
	PWM_SMMR_GCEN3 = 0x8
	// Position of DOWN0 field.
	PWM_SMMR_DOWN0_Pos = 0x10
	// Bit mask of DOWN0 field.
	PWM_SMMR_DOWN0_Msk = 0x10000
	// Bit DOWN0.
	PWM_SMMR_DOWN0 = 0x10000
	// Position of DOWN1 field.
	PWM_SMMR_DOWN1_Pos = 0x11
	// Bit mask of DOWN1 field.
	PWM_SMMR_DOWN1_Msk = 0x20000
	// Bit DOWN1.
	PWM_SMMR_DOWN1 = 0x20000
	// Position of DOWN2 field.
	PWM_SMMR_DOWN2_Pos = 0x12
	// Bit mask of DOWN2 field.
	PWM_SMMR_DOWN2_Msk = 0x40000
	// Bit DOWN2.
	PWM_SMMR_DOWN2 = 0x40000
	// Position of DOWN3 field.
	PWM_SMMR_DOWN3_Pos = 0x13
	// Bit mask of DOWN3 field.
	PWM_SMMR_DOWN3_Msk = 0x80000
	// Bit DOWN3.
	PWM_SMMR_DOWN3 = 0x80000

	// WPCR: PWM Write Protect Control Register
	// Position of WPCMD field.
	PWM_WPCR_WPCMD_Pos = 0x0
	// Bit mask of WPCMD field.
	PWM_WPCR_WPCMD_Msk = 0x3
	// Position of WPRG0 field.
	PWM_WPCR_WPRG0_Pos = 0x2
	// Bit mask of WPRG0 field.
	PWM_WPCR_WPRG0_Msk = 0x4
	// Bit WPRG0.
	PWM_WPCR_WPRG0 = 0x4
	// Position of WPRG1 field.
	PWM_WPCR_WPRG1_Pos = 0x3
	// Bit mask of WPRG1 field.
	PWM_WPCR_WPRG1_Msk = 0x8
	// Bit WPRG1.
	PWM_WPCR_WPRG1 = 0x8
	// Position of WPRG2 field.
	PWM_WPCR_WPRG2_Pos = 0x4
	// Bit mask of WPRG2 field.
	PWM_WPCR_WPRG2_Msk = 0x10
	// Bit WPRG2.
	PWM_WPCR_WPRG2 = 0x10
	// Position of WPRG3 field.
	PWM_WPCR_WPRG3_Pos = 0x5
	// Bit mask of WPRG3 field.
	PWM_WPCR_WPRG3_Msk = 0x20
	// Bit WPRG3.
	PWM_WPCR_WPRG3 = 0x20
	// Position of WPRG4 field.
	PWM_WPCR_WPRG4_Pos = 0x6
	// Bit mask of WPRG4 field.
	PWM_WPCR_WPRG4_Msk = 0x40
	// Bit WPRG4.
	PWM_WPCR_WPRG4 = 0x40
	// Position of WPRG5 field.
	PWM_WPCR_WPRG5_Pos = 0x7
	// Bit mask of WPRG5 field.
	PWM_WPCR_WPRG5_Msk = 0x80
	// Bit WPRG5.
	PWM_WPCR_WPRG5 = 0x80
	// Position of WPKEY field.
	PWM_WPCR_WPKEY_Pos = 0x8
	// Bit mask of WPKEY field.
	PWM_WPCR_WPKEY_Msk = 0xffffff00

	// WPSR: PWM Write Protect Status Register
	// Position of WPSWS0 field.
	PWM_WPSR_WPSWS0_Pos = 0x0
	// Bit mask of WPSWS0 field.
	PWM_WPSR_WPSWS0_Msk = 0x1
	// Bit WPSWS0.
	PWM_WPSR_WPSWS0 = 0x1
	// Position of WPSWS1 field.
	PWM_WPSR_WPSWS1_Pos = 0x1
	// Bit mask of WPSWS1 field.
	PWM_WPSR_WPSWS1_Msk = 0x2
	// Bit WPSWS1.
	PWM_WPSR_WPSWS1 = 0x2
	// Position of WPSWS2 field.
	PWM_WPSR_WPSWS2_Pos = 0x2
	// Bit mask of WPSWS2 field.
	PWM_WPSR_WPSWS2_Msk = 0x4
	// Bit WPSWS2.
	PWM_WPSR_WPSWS2 = 0x4
	// Position of WPSWS3 field.
	PWM_WPSR_WPSWS3_Pos = 0x3
	// Bit mask of WPSWS3 field.
	PWM_WPSR_WPSWS3_Msk = 0x8
	// Bit WPSWS3.
	PWM_WPSR_WPSWS3 = 0x8
	// Position of WPSWS4 field.
	PWM_WPSR_WPSWS4_Pos = 0x4
	// Bit mask of WPSWS4 field.
	PWM_WPSR_WPSWS4_Msk = 0x10
	// Bit WPSWS4.
	PWM_WPSR_WPSWS4 = 0x10
	// Position of WPSWS5 field.
	PWM_WPSR_WPSWS5_Pos = 0x5
	// Bit mask of WPSWS5 field.
	PWM_WPSR_WPSWS5_Msk = 0x20
	// Bit WPSWS5.
	PWM_WPSR_WPSWS5 = 0x20
	// Position of WPVS field.
	PWM_WPSR_WPVS_Pos = 0x7
	// Bit mask of WPVS field.
	PWM_WPSR_WPVS_Msk = 0x80
	// Bit WPVS.
	PWM_WPSR_WPVS = 0x80
	// Position of WPHWS0 field.
	PWM_WPSR_WPHWS0_Pos = 0x8
	// Bit mask of WPHWS0 field.
	PWM_WPSR_WPHWS0_Msk = 0x100
	// Bit WPHWS0.
	PWM_WPSR_WPHWS0 = 0x100
	// Position of WPHWS1 field.
	PWM_WPSR_WPHWS1_Pos = 0x9
	// Bit mask of WPHWS1 field.
	PWM_WPSR_WPHWS1_Msk = 0x200
	// Bit WPHWS1.
	PWM_WPSR_WPHWS1 = 0x200
	// Position of WPHWS2 field.
	PWM_WPSR_WPHWS2_Pos = 0xa
	// Bit mask of WPHWS2 field.
	PWM_WPSR_WPHWS2_Msk = 0x400
	// Bit WPHWS2.
	PWM_WPSR_WPHWS2 = 0x400
	// Position of WPHWS3 field.
	PWM_WPSR_WPHWS3_Pos = 0xb
	// Bit mask of WPHWS3 field.
	PWM_WPSR_WPHWS3_Msk = 0x800
	// Bit WPHWS3.
	PWM_WPSR_WPHWS3 = 0x800
	// Position of WPHWS4 field.
	PWM_WPSR_WPHWS4_Pos = 0xc
	// Bit mask of WPHWS4 field.
	PWM_WPSR_WPHWS4_Msk = 0x1000
	// Bit WPHWS4.
	PWM_WPSR_WPHWS4 = 0x1000
	// Position of WPHWS5 field.
	PWM_WPSR_WPHWS5_Pos = 0xd
	// Bit mask of WPHWS5 field.
	PWM_WPSR_WPHWS5_Msk = 0x2000
	// Bit WPHWS5.
	PWM_WPSR_WPHWS5 = 0x2000
	// Position of WPVSRC field.
	PWM_WPSR_WPVSRC_Pos = 0x10
	// Bit mask of WPVSRC field.
	PWM_WPSR_WPVSRC_Msk = 0xffff0000

	// TPR: Transmit Pointer Register
	// Position of TXPTR field.
	PWM_TPR_TXPTR_Pos = 0x0
	// Bit mask of TXPTR field.
	PWM_TPR_TXPTR_Msk = 0xffffffff

	// TCR: Transmit Counter Register
	// Position of TXCTR field.
	PWM_TCR_TXCTR_Pos = 0x0
	// Bit mask of TXCTR field.
	PWM_TCR_TXCTR_Msk = 0xffff

	// TNPR: Transmit Next Pointer Register
	// Position of TXNPTR field.
	PWM_TNPR_TXNPTR_Pos = 0x0
	// Bit mask of TXNPTR field.
	PWM_TNPR_TXNPTR_Msk = 0xffffffff

	// TNCR: Transmit Next Counter Register
	// Position of TXNCTR field.
	PWM_TNCR_TXNCTR_Pos = 0x0
	// Bit mask of TXNCTR field.
	PWM_TNCR_TXNCTR_Msk = 0xffff

	// PTCR: Transfer Control Register
	// Position of RXTEN field.
	PWM_PTCR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	PWM_PTCR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	PWM_PTCR_RXTEN = 0x1
	// Position of RXTDIS field.
	PWM_PTCR_RXTDIS_Pos = 0x1
	// Bit mask of RXTDIS field.
	PWM_PTCR_RXTDIS_Msk = 0x2
	// Bit RXTDIS.
	PWM_PTCR_RXTDIS = 0x2
	// Position of TXTEN field.
	PWM_PTCR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	PWM_PTCR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	PWM_PTCR_TXTEN = 0x100
	// Position of TXTDIS field.
	PWM_PTCR_TXTDIS_Pos = 0x9
	// Bit mask of TXTDIS field.
	PWM_PTCR_TXTDIS_Msk = 0x200
	// Bit TXTDIS.
	PWM_PTCR_TXTDIS = 0x200

	// PTSR: Transfer Status Register
	// Position of RXTEN field.
	PWM_PTSR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	PWM_PTSR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	PWM_PTSR_RXTEN = 0x1
	// Position of TXTEN field.
	PWM_PTSR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	PWM_PTSR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	PWM_PTSR_TXTEN = 0x100

	// CMPV0: PWM Comparison 0 Value Register
	// Position of CV field.
	PWM_CMPV0_CV_Pos = 0x0
	// Bit mask of CV field.
	PWM_CMPV0_CV_Msk = 0xffffff
	// Position of CVM field.
	PWM_CMPV0_CVM_Pos = 0x18
	// Bit mask of CVM field.
	PWM_CMPV0_CVM_Msk = 0x1000000
	// Bit CVM.
	PWM_CMPV0_CVM = 0x1000000

	// CMPVUPD0: PWM Comparison 0 Value Update Register
	// Position of CVUPD field.
	PWM_CMPVUPD0_CVUPD_Pos = 0x0
	// Bit mask of CVUPD field.
	PWM_CMPVUPD0_CVUPD_Msk = 0xffffff
	// Position of CVMUPD field.
	PWM_CMPVUPD0_CVMUPD_Pos = 0x18
	// Bit mask of CVMUPD field.
	PWM_CMPVUPD0_CVMUPD_Msk = 0x1000000
	// Bit CVMUPD.
	PWM_CMPVUPD0_CVMUPD = 0x1000000

	// CMPM0: PWM Comparison 0 Mode Register
	// Position of CEN field.
	PWM_CMPM0_CEN_Pos = 0x0
	// Bit mask of CEN field.
	PWM_CMPM0_CEN_Msk = 0x1
	// Bit CEN.
	PWM_CMPM0_CEN = 0x1
	// Position of CTR field.
	PWM_CMPM0_CTR_Pos = 0x4
	// Bit mask of CTR field.
	PWM_CMPM0_CTR_Msk = 0xf0
	// Position of CPR field.
	PWM_CMPM0_CPR_Pos = 0x8
	// Bit mask of CPR field.
	PWM_CMPM0_CPR_Msk = 0xf00
	// Position of CPRCNT field.
	PWM_CMPM0_CPRCNT_Pos = 0xc
	// Bit mask of CPRCNT field.
	PWM_CMPM0_CPRCNT_Msk = 0xf000
	// Position of CUPR field.
	PWM_CMPM0_CUPR_Pos = 0x10
	// Bit mask of CUPR field.
	PWM_CMPM0_CUPR_Msk = 0xf0000
	// Position of CUPRCNT field.
	PWM_CMPM0_CUPRCNT_Pos = 0x14
	// Bit mask of CUPRCNT field.
	PWM_CMPM0_CUPRCNT_Msk = 0xf00000

	// CMPMUPD0: PWM Comparison 0 Mode Update Register
	// Position of CENUPD field.
	PWM_CMPMUPD0_CENUPD_Pos = 0x0
	// Bit mask of CENUPD field.
	PWM_CMPMUPD0_CENUPD_Msk = 0x1
	// Bit CENUPD.
	PWM_CMPMUPD0_CENUPD = 0x1
	// Position of CTRUPD field.
	PWM_CMPMUPD0_CTRUPD_Pos = 0x4
	// Bit mask of CTRUPD field.
	PWM_CMPMUPD0_CTRUPD_Msk = 0xf0
	// Position of CPRUPD field.
	PWM_CMPMUPD0_CPRUPD_Pos = 0x8
	// Bit mask of CPRUPD field.
	PWM_CMPMUPD0_CPRUPD_Msk = 0xf00
	// Position of CUPRUPD field.
	PWM_CMPMUPD0_CUPRUPD_Pos = 0x10
	// Bit mask of CUPRUPD field.
	PWM_CMPMUPD0_CUPRUPD_Msk = 0xf0000

	// CMPV1: PWM Comparison 1 Value Register
	// Position of CV field.
	PWM_CMPV1_CV_Pos = 0x0
	// Bit mask of CV field.
	PWM_CMPV1_CV_Msk = 0xffffff
	// Position of CVM field.
	PWM_CMPV1_CVM_Pos = 0x18
	// Bit mask of CVM field.
	PWM_CMPV1_CVM_Msk = 0x1000000
	// Bit CVM.
	PWM_CMPV1_CVM = 0x1000000

	// CMPVUPD1: PWM Comparison 1 Value Update Register
	// Position of CVUPD field.
	PWM_CMPVUPD1_CVUPD_Pos = 0x0
	// Bit mask of CVUPD field.
	PWM_CMPVUPD1_CVUPD_Msk = 0xffffff
	// Position of CVMUPD field.
	PWM_CMPVUPD1_CVMUPD_Pos = 0x18
	// Bit mask of CVMUPD field.
	PWM_CMPVUPD1_CVMUPD_Msk = 0x1000000
	// Bit CVMUPD.
	PWM_CMPVUPD1_CVMUPD = 0x1000000

	// CMPM1: PWM Comparison 1 Mode Register
	// Position of CEN field.
	PWM_CMPM1_CEN_Pos = 0x0
	// Bit mask of CEN field.
	PWM_CMPM1_CEN_Msk = 0x1
	// Bit CEN.
	PWM_CMPM1_CEN = 0x1
	// Position of CTR field.
	PWM_CMPM1_CTR_Pos = 0x4
	// Bit mask of CTR field.
	PWM_CMPM1_CTR_Msk = 0xf0
	// Position of CPR field.
	PWM_CMPM1_CPR_Pos = 0x8
	// Bit mask of CPR field.
	PWM_CMPM1_CPR_Msk = 0xf00
	// Position of CPRCNT field.
	PWM_CMPM1_CPRCNT_Pos = 0xc
	// Bit mask of CPRCNT field.
	PWM_CMPM1_CPRCNT_Msk = 0xf000
	// Position of CUPR field.
	PWM_CMPM1_CUPR_Pos = 0x10
	// Bit mask of CUPR field.
	PWM_CMPM1_CUPR_Msk = 0xf0000
	// Position of CUPRCNT field.
	PWM_CMPM1_CUPRCNT_Pos = 0x14
	// Bit mask of CUPRCNT field.
	PWM_CMPM1_CUPRCNT_Msk = 0xf00000

	// CMPMUPD1: PWM Comparison 1 Mode Update Register
	// Position of CENUPD field.
	PWM_CMPMUPD1_CENUPD_Pos = 0x0
	// Bit mask of CENUPD field.
	PWM_CMPMUPD1_CENUPD_Msk = 0x1
	// Bit CENUPD.
	PWM_CMPMUPD1_CENUPD = 0x1
	// Position of CTRUPD field.
	PWM_CMPMUPD1_CTRUPD_Pos = 0x4
	// Bit mask of CTRUPD field.
	PWM_CMPMUPD1_CTRUPD_Msk = 0xf0
	// Position of CPRUPD field.
	PWM_CMPMUPD1_CPRUPD_Pos = 0x8
	// Bit mask of CPRUPD field.
	PWM_CMPMUPD1_CPRUPD_Msk = 0xf00
	// Position of CUPRUPD field.
	PWM_CMPMUPD1_CUPRUPD_Pos = 0x10
	// Bit mask of CUPRUPD field.
	PWM_CMPMUPD1_CUPRUPD_Msk = 0xf0000

	// CMPV2: PWM Comparison 2 Value Register
	// Position of CV field.
	PWM_CMPV2_CV_Pos = 0x0
	// Bit mask of CV field.
	PWM_CMPV2_CV_Msk = 0xffffff
	// Position of CVM field.
	PWM_CMPV2_CVM_Pos = 0x18
	// Bit mask of CVM field.
	PWM_CMPV2_CVM_Msk = 0x1000000
	// Bit CVM.
	PWM_CMPV2_CVM = 0x1000000

	// CMPVUPD2: PWM Comparison 2 Value Update Register
	// Position of CVUPD field.
	PWM_CMPVUPD2_CVUPD_Pos = 0x0
	// Bit mask of CVUPD field.
	PWM_CMPVUPD2_CVUPD_Msk = 0xffffff
	// Position of CVMUPD field.
	PWM_CMPVUPD2_CVMUPD_Pos = 0x18
	// Bit mask of CVMUPD field.
	PWM_CMPVUPD2_CVMUPD_Msk = 0x1000000
	// Bit CVMUPD.
	PWM_CMPVUPD2_CVMUPD = 0x1000000

	// CMPM2: PWM Comparison 2 Mode Register
	// Position of CEN field.
	PWM_CMPM2_CEN_Pos = 0x0
	// Bit mask of CEN field.
	PWM_CMPM2_CEN_Msk = 0x1
	// Bit CEN.
	PWM_CMPM2_CEN = 0x1
	// Position of CTR field.
	PWM_CMPM2_CTR_Pos = 0x4
	// Bit mask of CTR field.
	PWM_CMPM2_CTR_Msk = 0xf0
	// Position of CPR field.
	PWM_CMPM2_CPR_Pos = 0x8
	// Bit mask of CPR field.
	PWM_CMPM2_CPR_Msk = 0xf00
	// Position of CPRCNT field.
	PWM_CMPM2_CPRCNT_Pos = 0xc
	// Bit mask of CPRCNT field.
	PWM_CMPM2_CPRCNT_Msk = 0xf000
	// Position of CUPR field.
	PWM_CMPM2_CUPR_Pos = 0x10
	// Bit mask of CUPR field.
	PWM_CMPM2_CUPR_Msk = 0xf0000
	// Position of CUPRCNT field.
	PWM_CMPM2_CUPRCNT_Pos = 0x14
	// Bit mask of CUPRCNT field.
	PWM_CMPM2_CUPRCNT_Msk = 0xf00000

	// CMPMUPD2: PWM Comparison 2 Mode Update Register
	// Position of CENUPD field.
	PWM_CMPMUPD2_CENUPD_Pos = 0x0
	// Bit mask of CENUPD field.
	PWM_CMPMUPD2_CENUPD_Msk = 0x1
	// Bit CENUPD.
	PWM_CMPMUPD2_CENUPD = 0x1
	// Position of CTRUPD field.
	PWM_CMPMUPD2_CTRUPD_Pos = 0x4
	// Bit mask of CTRUPD field.
	PWM_CMPMUPD2_CTRUPD_Msk = 0xf0
	// Position of CPRUPD field.
	PWM_CMPMUPD2_CPRUPD_Pos = 0x8
	// Bit mask of CPRUPD field.
	PWM_CMPMUPD2_CPRUPD_Msk = 0xf00
	// Position of CUPRUPD field.
	PWM_CMPMUPD2_CUPRUPD_Pos = 0x10
	// Bit mask of CUPRUPD field.
	PWM_CMPMUPD2_CUPRUPD_Msk = 0xf0000

	// CMPV3: PWM Comparison 3 Value Register
	// Position of CV field.
	PWM_CMPV3_CV_Pos = 0x0
	// Bit mask of CV field.
	PWM_CMPV3_CV_Msk = 0xffffff
	// Position of CVM field.
	PWM_CMPV3_CVM_Pos = 0x18
	// Bit mask of CVM field.
	PWM_CMPV3_CVM_Msk = 0x1000000
	// Bit CVM.
	PWM_CMPV3_CVM = 0x1000000

	// CMPVUPD3: PWM Comparison 3 Value Update Register
	// Position of CVUPD field.
	PWM_CMPVUPD3_CVUPD_Pos = 0x0
	// Bit mask of CVUPD field.
	PWM_CMPVUPD3_CVUPD_Msk = 0xffffff
	// Position of CVMUPD field.
	PWM_CMPVUPD3_CVMUPD_Pos = 0x18
	// Bit mask of CVMUPD field.
	PWM_CMPVUPD3_CVMUPD_Msk = 0x1000000
	// Bit CVMUPD.
	PWM_CMPVUPD3_CVMUPD = 0x1000000

	// CMPM3: PWM Comparison 3 Mode Register
	// Position of CEN field.
	PWM_CMPM3_CEN_Pos = 0x0
	// Bit mask of CEN field.
	PWM_CMPM3_CEN_Msk = 0x1
	// Bit CEN.
	PWM_CMPM3_CEN = 0x1
	// Position of CTR field.
	PWM_CMPM3_CTR_Pos = 0x4
	// Bit mask of CTR field.
	PWM_CMPM3_CTR_Msk = 0xf0
	// Position of CPR field.
	PWM_CMPM3_CPR_Pos = 0x8
	// Bit mask of CPR field.
	PWM_CMPM3_CPR_Msk = 0xf00
	// Position of CPRCNT field.
	PWM_CMPM3_CPRCNT_Pos = 0xc
	// Bit mask of CPRCNT field.
	PWM_CMPM3_CPRCNT_Msk = 0xf000
	// Position of CUPR field.
	PWM_CMPM3_CUPR_Pos = 0x10
	// Bit mask of CUPR field.
	PWM_CMPM3_CUPR_Msk = 0xf0000
	// Position of CUPRCNT field.
	PWM_CMPM3_CUPRCNT_Pos = 0x14
	// Bit mask of CUPRCNT field.
	PWM_CMPM3_CUPRCNT_Msk = 0xf00000

	// CMPMUPD3: PWM Comparison 3 Mode Update Register
	// Position of CENUPD field.
	PWM_CMPMUPD3_CENUPD_Pos = 0x0
	// Bit mask of CENUPD field.
	PWM_CMPMUPD3_CENUPD_Msk = 0x1
	// Bit CENUPD.
	PWM_CMPMUPD3_CENUPD = 0x1
	// Position of CTRUPD field.
	PWM_CMPMUPD3_CTRUPD_Pos = 0x4
	// Bit mask of CTRUPD field.
	PWM_CMPMUPD3_CTRUPD_Msk = 0xf0
	// Position of CPRUPD field.
	PWM_CMPMUPD3_CPRUPD_Pos = 0x8
	// Bit mask of CPRUPD field.
	PWM_CMPMUPD3_CPRUPD_Msk = 0xf00
	// Position of CUPRUPD field.
	PWM_CMPMUPD3_CUPRUPD_Pos = 0x10
	// Bit mask of CUPRUPD field.
	PWM_CMPMUPD3_CUPRUPD_Msk = 0xf0000

	// CMPV4: PWM Comparison 4 Value Register
	// Position of CV field.
	PWM_CMPV4_CV_Pos = 0x0
	// Bit mask of CV field.
	PWM_CMPV4_CV_Msk = 0xffffff
	// Position of CVM field.
	PWM_CMPV4_CVM_Pos = 0x18
	// Bit mask of CVM field.
	PWM_CMPV4_CVM_Msk = 0x1000000
	// Bit CVM.
	PWM_CMPV4_CVM = 0x1000000

	// CMPVUPD4: PWM Comparison 4 Value Update Register
	// Position of CVUPD field.
	PWM_CMPVUPD4_CVUPD_Pos = 0x0
	// Bit mask of CVUPD field.
	PWM_CMPVUPD4_CVUPD_Msk = 0xffffff
	// Position of CVMUPD field.
	PWM_CMPVUPD4_CVMUPD_Pos = 0x18
	// Bit mask of CVMUPD field.
	PWM_CMPVUPD4_CVMUPD_Msk = 0x1000000
	// Bit CVMUPD.
	PWM_CMPVUPD4_CVMUPD = 0x1000000

	// CMPM4: PWM Comparison 4 Mode Register
	// Position of CEN field.
	PWM_CMPM4_CEN_Pos = 0x0
	// Bit mask of CEN field.
	PWM_CMPM4_CEN_Msk = 0x1
	// Bit CEN.
	PWM_CMPM4_CEN = 0x1
	// Position of CTR field.
	PWM_CMPM4_CTR_Pos = 0x4
	// Bit mask of CTR field.
	PWM_CMPM4_CTR_Msk = 0xf0
	// Position of CPR field.
	PWM_CMPM4_CPR_Pos = 0x8
	// Bit mask of CPR field.
	PWM_CMPM4_CPR_Msk = 0xf00
	// Position of CPRCNT field.
	PWM_CMPM4_CPRCNT_Pos = 0xc
	// Bit mask of CPRCNT field.
	PWM_CMPM4_CPRCNT_Msk = 0xf000
	// Position of CUPR field.
	PWM_CMPM4_CUPR_Pos = 0x10
	// Bit mask of CUPR field.
	PWM_CMPM4_CUPR_Msk = 0xf0000
	// Position of CUPRCNT field.
	PWM_CMPM4_CUPRCNT_Pos = 0x14
	// Bit mask of CUPRCNT field.
	PWM_CMPM4_CUPRCNT_Msk = 0xf00000

	// CMPMUPD4: PWM Comparison 4 Mode Update Register
	// Position of CENUPD field.
	PWM_CMPMUPD4_CENUPD_Pos = 0x0
	// Bit mask of CENUPD field.
	PWM_CMPMUPD4_CENUPD_Msk = 0x1
	// Bit CENUPD.
	PWM_CMPMUPD4_CENUPD = 0x1
	// Position of CTRUPD field.
	PWM_CMPMUPD4_CTRUPD_Pos = 0x4
	// Bit mask of CTRUPD field.
	PWM_CMPMUPD4_CTRUPD_Msk = 0xf0
	// Position of CPRUPD field.
	PWM_CMPMUPD4_CPRUPD_Pos = 0x8
	// Bit mask of CPRUPD field.
	PWM_CMPMUPD4_CPRUPD_Msk = 0xf00
	// Position of CUPRUPD field.
	PWM_CMPMUPD4_CUPRUPD_Pos = 0x10
	// Bit mask of CUPRUPD field.
	PWM_CMPMUPD4_CUPRUPD_Msk = 0xf0000

	// CMPV5: PWM Comparison 5 Value Register
	// Position of CV field.
	PWM_CMPV5_CV_Pos = 0x0
	// Bit mask of CV field.
	PWM_CMPV5_CV_Msk = 0xffffff
	// Position of CVM field.
	PWM_CMPV5_CVM_Pos = 0x18
	// Bit mask of CVM field.
	PWM_CMPV5_CVM_Msk = 0x1000000
	// Bit CVM.
	PWM_CMPV5_CVM = 0x1000000

	// CMPVUPD5: PWM Comparison 5 Value Update Register
	// Position of CVUPD field.
	PWM_CMPVUPD5_CVUPD_Pos = 0x0
	// Bit mask of CVUPD field.
	PWM_CMPVUPD5_CVUPD_Msk = 0xffffff
	// Position of CVMUPD field.
	PWM_CMPVUPD5_CVMUPD_Pos = 0x18
	// Bit mask of CVMUPD field.
	PWM_CMPVUPD5_CVMUPD_Msk = 0x1000000
	// Bit CVMUPD.
	PWM_CMPVUPD5_CVMUPD = 0x1000000

	// CMPM5: PWM Comparison 5 Mode Register
	// Position of CEN field.
	PWM_CMPM5_CEN_Pos = 0x0
	// Bit mask of CEN field.
	PWM_CMPM5_CEN_Msk = 0x1
	// Bit CEN.
	PWM_CMPM5_CEN = 0x1
	// Position of CTR field.
	PWM_CMPM5_CTR_Pos = 0x4
	// Bit mask of CTR field.
	PWM_CMPM5_CTR_Msk = 0xf0
	// Position of CPR field.
	PWM_CMPM5_CPR_Pos = 0x8
	// Bit mask of CPR field.
	PWM_CMPM5_CPR_Msk = 0xf00
	// Position of CPRCNT field.
	PWM_CMPM5_CPRCNT_Pos = 0xc
	// Bit mask of CPRCNT field.
	PWM_CMPM5_CPRCNT_Msk = 0xf000
	// Position of CUPR field.
	PWM_CMPM5_CUPR_Pos = 0x10
	// Bit mask of CUPR field.
	PWM_CMPM5_CUPR_Msk = 0xf0000
	// Position of CUPRCNT field.
	PWM_CMPM5_CUPRCNT_Pos = 0x14
	// Bit mask of CUPRCNT field.
	PWM_CMPM5_CUPRCNT_Msk = 0xf00000

	// CMPMUPD5: PWM Comparison 5 Mode Update Register
	// Position of CENUPD field.
	PWM_CMPMUPD5_CENUPD_Pos = 0x0
	// Bit mask of CENUPD field.
	PWM_CMPMUPD5_CENUPD_Msk = 0x1
	// Bit CENUPD.
	PWM_CMPMUPD5_CENUPD = 0x1
	// Position of CTRUPD field.
	PWM_CMPMUPD5_CTRUPD_Pos = 0x4
	// Bit mask of CTRUPD field.
	PWM_CMPMUPD5_CTRUPD_Msk = 0xf0
	// Position of CPRUPD field.
	PWM_CMPMUPD5_CPRUPD_Pos = 0x8
	// Bit mask of CPRUPD field.
	PWM_CMPMUPD5_CPRUPD_Msk = 0xf00
	// Position of CUPRUPD field.
	PWM_CMPMUPD5_CUPRUPD_Pos = 0x10
	// Bit mask of CUPRUPD field.
	PWM_CMPMUPD5_CUPRUPD_Msk = 0xf0000

	// CMPV6: PWM Comparison 6 Value Register
	// Position of CV field.
	PWM_CMPV6_CV_Pos = 0x0
	// Bit mask of CV field.
	PWM_CMPV6_CV_Msk = 0xffffff
	// Position of CVM field.
	PWM_CMPV6_CVM_Pos = 0x18
	// Bit mask of CVM field.
	PWM_CMPV6_CVM_Msk = 0x1000000
	// Bit CVM.
	PWM_CMPV6_CVM = 0x1000000

	// CMPVUPD6: PWM Comparison 6 Value Update Register
	// Position of CVUPD field.
	PWM_CMPVUPD6_CVUPD_Pos = 0x0
	// Bit mask of CVUPD field.
	PWM_CMPVUPD6_CVUPD_Msk = 0xffffff
	// Position of CVMUPD field.
	PWM_CMPVUPD6_CVMUPD_Pos = 0x18
	// Bit mask of CVMUPD field.
	PWM_CMPVUPD6_CVMUPD_Msk = 0x1000000
	// Bit CVMUPD.
	PWM_CMPVUPD6_CVMUPD = 0x1000000

	// CMPM6: PWM Comparison 6 Mode Register
	// Position of CEN field.
	PWM_CMPM6_CEN_Pos = 0x0
	// Bit mask of CEN field.
	PWM_CMPM6_CEN_Msk = 0x1
	// Bit CEN.
	PWM_CMPM6_CEN = 0x1
	// Position of CTR field.
	PWM_CMPM6_CTR_Pos = 0x4
	// Bit mask of CTR field.
	PWM_CMPM6_CTR_Msk = 0xf0
	// Position of CPR field.
	PWM_CMPM6_CPR_Pos = 0x8
	// Bit mask of CPR field.
	PWM_CMPM6_CPR_Msk = 0xf00
	// Position of CPRCNT field.
	PWM_CMPM6_CPRCNT_Pos = 0xc
	// Bit mask of CPRCNT field.
	PWM_CMPM6_CPRCNT_Msk = 0xf000
	// Position of CUPR field.
	PWM_CMPM6_CUPR_Pos = 0x10
	// Bit mask of CUPR field.
	PWM_CMPM6_CUPR_Msk = 0xf0000
	// Position of CUPRCNT field.
	PWM_CMPM6_CUPRCNT_Pos = 0x14
	// Bit mask of CUPRCNT field.
	PWM_CMPM6_CUPRCNT_Msk = 0xf00000

	// CMPMUPD6: PWM Comparison 6 Mode Update Register
	// Position of CENUPD field.
	PWM_CMPMUPD6_CENUPD_Pos = 0x0
	// Bit mask of CENUPD field.
	PWM_CMPMUPD6_CENUPD_Msk = 0x1
	// Bit CENUPD.
	PWM_CMPMUPD6_CENUPD = 0x1
	// Position of CTRUPD field.
	PWM_CMPMUPD6_CTRUPD_Pos = 0x4
	// Bit mask of CTRUPD field.
	PWM_CMPMUPD6_CTRUPD_Msk = 0xf0
	// Position of CPRUPD field.
	PWM_CMPMUPD6_CPRUPD_Pos = 0x8
	// Bit mask of CPRUPD field.
	PWM_CMPMUPD6_CPRUPD_Msk = 0xf00
	// Position of CUPRUPD field.
	PWM_CMPMUPD6_CUPRUPD_Pos = 0x10
	// Bit mask of CUPRUPD field.
	PWM_CMPMUPD6_CUPRUPD_Msk = 0xf0000

	// CMPV7: PWM Comparison 7 Value Register
	// Position of CV field.
	PWM_CMPV7_CV_Pos = 0x0
	// Bit mask of CV field.
	PWM_CMPV7_CV_Msk = 0xffffff
	// Position of CVM field.
	PWM_CMPV7_CVM_Pos = 0x18
	// Bit mask of CVM field.
	PWM_CMPV7_CVM_Msk = 0x1000000
	// Bit CVM.
	PWM_CMPV7_CVM = 0x1000000

	// CMPVUPD7: PWM Comparison 7 Value Update Register
	// Position of CVUPD field.
	PWM_CMPVUPD7_CVUPD_Pos = 0x0
	// Bit mask of CVUPD field.
	PWM_CMPVUPD7_CVUPD_Msk = 0xffffff
	// Position of CVMUPD field.
	PWM_CMPVUPD7_CVMUPD_Pos = 0x18
	// Bit mask of CVMUPD field.
	PWM_CMPVUPD7_CVMUPD_Msk = 0x1000000
	// Bit CVMUPD.
	PWM_CMPVUPD7_CVMUPD = 0x1000000

	// CMPM7: PWM Comparison 7 Mode Register
	// Position of CEN field.
	PWM_CMPM7_CEN_Pos = 0x0
	// Bit mask of CEN field.
	PWM_CMPM7_CEN_Msk = 0x1
	// Bit CEN.
	PWM_CMPM7_CEN = 0x1
	// Position of CTR field.
	PWM_CMPM7_CTR_Pos = 0x4
	// Bit mask of CTR field.
	PWM_CMPM7_CTR_Msk = 0xf0
	// Position of CPR field.
	PWM_CMPM7_CPR_Pos = 0x8
	// Bit mask of CPR field.
	PWM_CMPM7_CPR_Msk = 0xf00
	// Position of CPRCNT field.
	PWM_CMPM7_CPRCNT_Pos = 0xc
	// Bit mask of CPRCNT field.
	PWM_CMPM7_CPRCNT_Msk = 0xf000
	// Position of CUPR field.
	PWM_CMPM7_CUPR_Pos = 0x10
	// Bit mask of CUPR field.
	PWM_CMPM7_CUPR_Msk = 0xf0000
	// Position of CUPRCNT field.
	PWM_CMPM7_CUPRCNT_Pos = 0x14
	// Bit mask of CUPRCNT field.
	PWM_CMPM7_CUPRCNT_Msk = 0xf00000

	// CMPMUPD7: PWM Comparison 7 Mode Update Register
	// Position of CENUPD field.
	PWM_CMPMUPD7_CENUPD_Pos = 0x0
	// Bit mask of CENUPD field.
	PWM_CMPMUPD7_CENUPD_Msk = 0x1
	// Bit CENUPD.
	PWM_CMPMUPD7_CENUPD = 0x1
	// Position of CTRUPD field.
	PWM_CMPMUPD7_CTRUPD_Pos = 0x4
	// Bit mask of CTRUPD field.
	PWM_CMPMUPD7_CTRUPD_Msk = 0xf0
	// Position of CPRUPD field.
	PWM_CMPMUPD7_CPRUPD_Pos = 0x8
	// Bit mask of CPRUPD field.
	PWM_CMPMUPD7_CPRUPD_Msk = 0xf00
	// Position of CUPRUPD field.
	PWM_CMPMUPD7_CUPRUPD_Pos = 0x10
	// Bit mask of CUPRUPD field.
	PWM_CMPMUPD7_CUPRUPD_Msk = 0xf0000

	// CMR0: PWM Channel Mode Register (ch_num = 0)
	// Position of CPRE field.
	PWM_CMR0_CPRE_Pos = 0x0
	// Bit mask of CPRE field.
	PWM_CMR0_CPRE_Msk = 0xf
	// Master clock
	PWM_CMR0_CPRE_MCK = 0x0
	// Master clock/2
	PWM_CMR0_CPRE_MCK_DIV_2 = 0x1
	// Master clock/4
	PWM_CMR0_CPRE_MCK_DIV_4 = 0x2
	// Master clock/8
	PWM_CMR0_CPRE_MCK_DIV_8 = 0x3
	// Master clock/16
	PWM_CMR0_CPRE_MCK_DIV_16 = 0x4
	// Master clock/32
	PWM_CMR0_CPRE_MCK_DIV_32 = 0x5
	// Master clock/64
	PWM_CMR0_CPRE_MCK_DIV_64 = 0x6
	// Master clock/128
	PWM_CMR0_CPRE_MCK_DIV_128 = 0x7
	// Master clock/256
	PWM_CMR0_CPRE_MCK_DIV_256 = 0x8
	// Master clock/512
	PWM_CMR0_CPRE_MCK_DIV_512 = 0x9
	// Master clock/1024
	PWM_CMR0_CPRE_MCK_DIV_1024 = 0xa
	// Clock A
	PWM_CMR0_CPRE_CLKA = 0xb
	// Clock B
	PWM_CMR0_CPRE_CLKB = 0xc
	// Position of CALG field.
	PWM_CMR0_CALG_Pos = 0x8
	// Bit mask of CALG field.
	PWM_CMR0_CALG_Msk = 0x100
	// Bit CALG.
	PWM_CMR0_CALG = 0x100
	// Position of CPOL field.
	PWM_CMR0_CPOL_Pos = 0x9
	// Bit mask of CPOL field.
	PWM_CMR0_CPOL_Msk = 0x200
	// Bit CPOL.
	PWM_CMR0_CPOL = 0x200
	// Position of CES field.
	PWM_CMR0_CES_Pos = 0xa
	// Bit mask of CES field.
	PWM_CMR0_CES_Msk = 0x400
	// Bit CES.
	PWM_CMR0_CES = 0x400
	// Position of DTE field.
	PWM_CMR0_DTE_Pos = 0x10
	// Bit mask of DTE field.
	PWM_CMR0_DTE_Msk = 0x10000
	// Bit DTE.
	PWM_CMR0_DTE = 0x10000
	// Position of DTHI field.
	PWM_CMR0_DTHI_Pos = 0x11
	// Bit mask of DTHI field.
	PWM_CMR0_DTHI_Msk = 0x20000
	// Bit DTHI.
	PWM_CMR0_DTHI = 0x20000
	// Position of DTLI field.
	PWM_CMR0_DTLI_Pos = 0x12
	// Bit mask of DTLI field.
	PWM_CMR0_DTLI_Msk = 0x40000
	// Bit DTLI.
	PWM_CMR0_DTLI = 0x40000

	// CDTY0: PWM Channel Duty Cycle Register (ch_num = 0)
	// Position of CDTY field.
	PWM_CDTY0_CDTY_Pos = 0x0
	// Bit mask of CDTY field.
	PWM_CDTY0_CDTY_Msk = 0xffffff

	// CDTYUPD0: PWM Channel Duty Cycle Update Register (ch_num = 0)
	// Position of CDTYUPD field.
	PWM_CDTYUPD0_CDTYUPD_Pos = 0x0
	// Bit mask of CDTYUPD field.
	PWM_CDTYUPD0_CDTYUPD_Msk = 0xffffff

	// CPRD0: PWM Channel Period Register (ch_num = 0)
	// Position of CPRD field.
	PWM_CPRD0_CPRD_Pos = 0x0
	// Bit mask of CPRD field.
	PWM_CPRD0_CPRD_Msk = 0xffffff

	// CPRDUPD0: PWM Channel Period Update Register (ch_num = 0)
	// Position of CPRDUPD field.
	PWM_CPRDUPD0_CPRDUPD_Pos = 0x0
	// Bit mask of CPRDUPD field.
	PWM_CPRDUPD0_CPRDUPD_Msk = 0xffffff

	// CCNT0: PWM Channel Counter Register (ch_num = 0)
	// Position of CNT field.
	PWM_CCNT0_CNT_Pos = 0x0
	// Bit mask of CNT field.
	PWM_CCNT0_CNT_Msk = 0xffffff

	// DT0: PWM Channel Dead Time Register (ch_num = 0)
	// Position of DTH field.
	PWM_DT0_DTH_Pos = 0x0
	// Bit mask of DTH field.
	PWM_DT0_DTH_Msk = 0xffff
	// Position of DTL field.
	PWM_DT0_DTL_Pos = 0x10
	// Bit mask of DTL field.
	PWM_DT0_DTL_Msk = 0xffff0000

	// DTUPD0: PWM Channel Dead Time Update Register (ch_num = 0)
	// Position of DTHUPD field.
	PWM_DTUPD0_DTHUPD_Pos = 0x0
	// Bit mask of DTHUPD field.
	PWM_DTUPD0_DTHUPD_Msk = 0xffff
	// Position of DTLUPD field.
	PWM_DTUPD0_DTLUPD_Pos = 0x10
	// Bit mask of DTLUPD field.
	PWM_DTUPD0_DTLUPD_Msk = 0xffff0000

	// CMR1: PWM Channel Mode Register (ch_num = 1)
	// Position of CPRE field.
	PWM_CMR1_CPRE_Pos = 0x0
	// Bit mask of CPRE field.
	PWM_CMR1_CPRE_Msk = 0xf
	// Master clock
	PWM_CMR1_CPRE_MCK = 0x0
	// Master clock/2
	PWM_CMR1_CPRE_MCK_DIV_2 = 0x1
	// Master clock/4
	PWM_CMR1_CPRE_MCK_DIV_4 = 0x2
	// Master clock/8
	PWM_CMR1_CPRE_MCK_DIV_8 = 0x3
	// Master clock/16
	PWM_CMR1_CPRE_MCK_DIV_16 = 0x4
	// Master clock/32
	PWM_CMR1_CPRE_MCK_DIV_32 = 0x5
	// Master clock/64
	PWM_CMR1_CPRE_MCK_DIV_64 = 0x6
	// Master clock/128
	PWM_CMR1_CPRE_MCK_DIV_128 = 0x7
	// Master clock/256
	PWM_CMR1_CPRE_MCK_DIV_256 = 0x8
	// Master clock/512
	PWM_CMR1_CPRE_MCK_DIV_512 = 0x9
	// Master clock/1024
	PWM_CMR1_CPRE_MCK_DIV_1024 = 0xa
	// Clock A
	PWM_CMR1_CPRE_CLKA = 0xb
	// Clock B
	PWM_CMR1_CPRE_CLKB = 0xc
	// Position of CALG field.
	PWM_CMR1_CALG_Pos = 0x8
	// Bit mask of CALG field.
	PWM_CMR1_CALG_Msk = 0x100
	// Bit CALG.
	PWM_CMR1_CALG = 0x100
	// Position of CPOL field.
	PWM_CMR1_CPOL_Pos = 0x9
	// Bit mask of CPOL field.
	PWM_CMR1_CPOL_Msk = 0x200
	// Bit CPOL.
	PWM_CMR1_CPOL = 0x200
	// Position of CES field.
	PWM_CMR1_CES_Pos = 0xa
	// Bit mask of CES field.
	PWM_CMR1_CES_Msk = 0x400
	// Bit CES.
	PWM_CMR1_CES = 0x400
	// Position of DTE field.
	PWM_CMR1_DTE_Pos = 0x10
	// Bit mask of DTE field.
	PWM_CMR1_DTE_Msk = 0x10000
	// Bit DTE.
	PWM_CMR1_DTE = 0x10000
	// Position of DTHI field.
	PWM_CMR1_DTHI_Pos = 0x11
	// Bit mask of DTHI field.
	PWM_CMR1_DTHI_Msk = 0x20000
	// Bit DTHI.
	PWM_CMR1_DTHI = 0x20000
	// Position of DTLI field.
	PWM_CMR1_DTLI_Pos = 0x12
	// Bit mask of DTLI field.
	PWM_CMR1_DTLI_Msk = 0x40000
	// Bit DTLI.
	PWM_CMR1_DTLI = 0x40000

	// CDTY1: PWM Channel Duty Cycle Register (ch_num = 1)
	// Position of CDTY field.
	PWM_CDTY1_CDTY_Pos = 0x0
	// Bit mask of CDTY field.
	PWM_CDTY1_CDTY_Msk = 0xffffff

	// CDTYUPD1: PWM Channel Duty Cycle Update Register (ch_num = 1)
	// Position of CDTYUPD field.
	PWM_CDTYUPD1_CDTYUPD_Pos = 0x0
	// Bit mask of CDTYUPD field.
	PWM_CDTYUPD1_CDTYUPD_Msk = 0xffffff

	// CPRD1: PWM Channel Period Register (ch_num = 1)
	// Position of CPRD field.
	PWM_CPRD1_CPRD_Pos = 0x0
	// Bit mask of CPRD field.
	PWM_CPRD1_CPRD_Msk = 0xffffff

	// CPRDUPD1: PWM Channel Period Update Register (ch_num = 1)
	// Position of CPRDUPD field.
	PWM_CPRDUPD1_CPRDUPD_Pos = 0x0
	// Bit mask of CPRDUPD field.
	PWM_CPRDUPD1_CPRDUPD_Msk = 0xffffff

	// CCNT1: PWM Channel Counter Register (ch_num = 1)
	// Position of CNT field.
	PWM_CCNT1_CNT_Pos = 0x0
	// Bit mask of CNT field.
	PWM_CCNT1_CNT_Msk = 0xffffff

	// DT1: PWM Channel Dead Time Register (ch_num = 1)
	// Position of DTH field.
	PWM_DT1_DTH_Pos = 0x0
	// Bit mask of DTH field.
	PWM_DT1_DTH_Msk = 0xffff
	// Position of DTL field.
	PWM_DT1_DTL_Pos = 0x10
	// Bit mask of DTL field.
	PWM_DT1_DTL_Msk = 0xffff0000

	// DTUPD1: PWM Channel Dead Time Update Register (ch_num = 1)
	// Position of DTHUPD field.
	PWM_DTUPD1_DTHUPD_Pos = 0x0
	// Bit mask of DTHUPD field.
	PWM_DTUPD1_DTHUPD_Msk = 0xffff
	// Position of DTLUPD field.
	PWM_DTUPD1_DTLUPD_Pos = 0x10
	// Bit mask of DTLUPD field.
	PWM_DTUPD1_DTLUPD_Msk = 0xffff0000

	// CMR2: PWM Channel Mode Register (ch_num = 2)
	// Position of CPRE field.
	PWM_CMR2_CPRE_Pos = 0x0
	// Bit mask of CPRE field.
	PWM_CMR2_CPRE_Msk = 0xf
	// Master clock
	PWM_CMR2_CPRE_MCK = 0x0
	// Master clock/2
	PWM_CMR2_CPRE_MCK_DIV_2 = 0x1
	// Master clock/4
	PWM_CMR2_CPRE_MCK_DIV_4 = 0x2
	// Master clock/8
	PWM_CMR2_CPRE_MCK_DIV_8 = 0x3
	// Master clock/16
	PWM_CMR2_CPRE_MCK_DIV_16 = 0x4
	// Master clock/32
	PWM_CMR2_CPRE_MCK_DIV_32 = 0x5
	// Master clock/64
	PWM_CMR2_CPRE_MCK_DIV_64 = 0x6
	// Master clock/128
	PWM_CMR2_CPRE_MCK_DIV_128 = 0x7
	// Master clock/256
	PWM_CMR2_CPRE_MCK_DIV_256 = 0x8
	// Master clock/512
	PWM_CMR2_CPRE_MCK_DIV_512 = 0x9
	// Master clock/1024
	PWM_CMR2_CPRE_MCK_DIV_1024 = 0xa
	// Clock A
	PWM_CMR2_CPRE_CLKA = 0xb
	// Clock B
	PWM_CMR2_CPRE_CLKB = 0xc
	// Position of CALG field.
	PWM_CMR2_CALG_Pos = 0x8
	// Bit mask of CALG field.
	PWM_CMR2_CALG_Msk = 0x100
	// Bit CALG.
	PWM_CMR2_CALG = 0x100
	// Position of CPOL field.
	PWM_CMR2_CPOL_Pos = 0x9
	// Bit mask of CPOL field.
	PWM_CMR2_CPOL_Msk = 0x200
	// Bit CPOL.
	PWM_CMR2_CPOL = 0x200
	// Position of CES field.
	PWM_CMR2_CES_Pos = 0xa
	// Bit mask of CES field.
	PWM_CMR2_CES_Msk = 0x400
	// Bit CES.
	PWM_CMR2_CES = 0x400
	// Position of DTE field.
	PWM_CMR2_DTE_Pos = 0x10
	// Bit mask of DTE field.
	PWM_CMR2_DTE_Msk = 0x10000
	// Bit DTE.
	PWM_CMR2_DTE = 0x10000
	// Position of DTHI field.
	PWM_CMR2_DTHI_Pos = 0x11
	// Bit mask of DTHI field.
	PWM_CMR2_DTHI_Msk = 0x20000
	// Bit DTHI.
	PWM_CMR2_DTHI = 0x20000
	// Position of DTLI field.
	PWM_CMR2_DTLI_Pos = 0x12
	// Bit mask of DTLI field.
	PWM_CMR2_DTLI_Msk = 0x40000
	// Bit DTLI.
	PWM_CMR2_DTLI = 0x40000

	// CDTY2: PWM Channel Duty Cycle Register (ch_num = 2)
	// Position of CDTY field.
	PWM_CDTY2_CDTY_Pos = 0x0
	// Bit mask of CDTY field.
	PWM_CDTY2_CDTY_Msk = 0xffffff

	// CDTYUPD2: PWM Channel Duty Cycle Update Register (ch_num = 2)
	// Position of CDTYUPD field.
	PWM_CDTYUPD2_CDTYUPD_Pos = 0x0
	// Bit mask of CDTYUPD field.
	PWM_CDTYUPD2_CDTYUPD_Msk = 0xffffff

	// CPRD2: PWM Channel Period Register (ch_num = 2)
	// Position of CPRD field.
	PWM_CPRD2_CPRD_Pos = 0x0
	// Bit mask of CPRD field.
	PWM_CPRD2_CPRD_Msk = 0xffffff

	// CPRDUPD2: PWM Channel Period Update Register (ch_num = 2)
	// Position of CPRDUPD field.
	PWM_CPRDUPD2_CPRDUPD_Pos = 0x0
	// Bit mask of CPRDUPD field.
	PWM_CPRDUPD2_CPRDUPD_Msk = 0xffffff

	// CCNT2: PWM Channel Counter Register (ch_num = 2)
	// Position of CNT field.
	PWM_CCNT2_CNT_Pos = 0x0
	// Bit mask of CNT field.
	PWM_CCNT2_CNT_Msk = 0xffffff

	// DT2: PWM Channel Dead Time Register (ch_num = 2)
	// Position of DTH field.
	PWM_DT2_DTH_Pos = 0x0
	// Bit mask of DTH field.
	PWM_DT2_DTH_Msk = 0xffff
	// Position of DTL field.
	PWM_DT2_DTL_Pos = 0x10
	// Bit mask of DTL field.
	PWM_DT2_DTL_Msk = 0xffff0000

	// DTUPD2: PWM Channel Dead Time Update Register (ch_num = 2)
	// Position of DTHUPD field.
	PWM_DTUPD2_DTHUPD_Pos = 0x0
	// Bit mask of DTHUPD field.
	PWM_DTUPD2_DTHUPD_Msk = 0xffff
	// Position of DTLUPD field.
	PWM_DTUPD2_DTLUPD_Pos = 0x10
	// Bit mask of DTLUPD field.
	PWM_DTUPD2_DTLUPD_Msk = 0xffff0000

	// CMR3: PWM Channel Mode Register (ch_num = 3)
	// Position of CPRE field.
	PWM_CMR3_CPRE_Pos = 0x0
	// Bit mask of CPRE field.
	PWM_CMR3_CPRE_Msk = 0xf
	// Master clock
	PWM_CMR3_CPRE_MCK = 0x0
	// Master clock/2
	PWM_CMR3_CPRE_MCK_DIV_2 = 0x1
	// Master clock/4
	PWM_CMR3_CPRE_MCK_DIV_4 = 0x2
	// Master clock/8
	PWM_CMR3_CPRE_MCK_DIV_8 = 0x3
	// Master clock/16
	PWM_CMR3_CPRE_MCK_DIV_16 = 0x4
	// Master clock/32
	PWM_CMR3_CPRE_MCK_DIV_32 = 0x5
	// Master clock/64
	PWM_CMR3_CPRE_MCK_DIV_64 = 0x6
	// Master clock/128
	PWM_CMR3_CPRE_MCK_DIV_128 = 0x7
	// Master clock/256
	PWM_CMR3_CPRE_MCK_DIV_256 = 0x8
	// Master clock/512
	PWM_CMR3_CPRE_MCK_DIV_512 = 0x9
	// Master clock/1024
	PWM_CMR3_CPRE_MCK_DIV_1024 = 0xa
	// Clock A
	PWM_CMR3_CPRE_CLKA = 0xb
	// Clock B
	PWM_CMR3_CPRE_CLKB = 0xc
	// Position of CALG field.
	PWM_CMR3_CALG_Pos = 0x8
	// Bit mask of CALG field.
	PWM_CMR3_CALG_Msk = 0x100
	// Bit CALG.
	PWM_CMR3_CALG = 0x100
	// Position of CPOL field.
	PWM_CMR3_CPOL_Pos = 0x9
	// Bit mask of CPOL field.
	PWM_CMR3_CPOL_Msk = 0x200
	// Bit CPOL.
	PWM_CMR3_CPOL = 0x200
	// Position of CES field.
	PWM_CMR3_CES_Pos = 0xa
	// Bit mask of CES field.
	PWM_CMR3_CES_Msk = 0x400
	// Bit CES.
	PWM_CMR3_CES = 0x400
	// Position of DTE field.
	PWM_CMR3_DTE_Pos = 0x10
	// Bit mask of DTE field.
	PWM_CMR3_DTE_Msk = 0x10000
	// Bit DTE.
	PWM_CMR3_DTE = 0x10000
	// Position of DTHI field.
	PWM_CMR3_DTHI_Pos = 0x11
	// Bit mask of DTHI field.
	PWM_CMR3_DTHI_Msk = 0x20000
	// Bit DTHI.
	PWM_CMR3_DTHI = 0x20000
	// Position of DTLI field.
	PWM_CMR3_DTLI_Pos = 0x12
	// Bit mask of DTLI field.
	PWM_CMR3_DTLI_Msk = 0x40000
	// Bit DTLI.
	PWM_CMR3_DTLI = 0x40000

	// CDTY3: PWM Channel Duty Cycle Register (ch_num = 3)
	// Position of CDTY field.
	PWM_CDTY3_CDTY_Pos = 0x0
	// Bit mask of CDTY field.
	PWM_CDTY3_CDTY_Msk = 0xffffff

	// CDTYUPD3: PWM Channel Duty Cycle Update Register (ch_num = 3)
	// Position of CDTYUPD field.
	PWM_CDTYUPD3_CDTYUPD_Pos = 0x0
	// Bit mask of CDTYUPD field.
	PWM_CDTYUPD3_CDTYUPD_Msk = 0xffffff

	// CPRD3: PWM Channel Period Register (ch_num = 3)
	// Position of CPRD field.
	PWM_CPRD3_CPRD_Pos = 0x0
	// Bit mask of CPRD field.
	PWM_CPRD3_CPRD_Msk = 0xffffff

	// CPRDUPD3: PWM Channel Period Update Register (ch_num = 3)
	// Position of CPRDUPD field.
	PWM_CPRDUPD3_CPRDUPD_Pos = 0x0
	// Bit mask of CPRDUPD field.
	PWM_CPRDUPD3_CPRDUPD_Msk = 0xffffff

	// CCNT3: PWM Channel Counter Register (ch_num = 3)
	// Position of CNT field.
	PWM_CCNT3_CNT_Pos = 0x0
	// Bit mask of CNT field.
	PWM_CCNT3_CNT_Msk = 0xffffff

	// DT3: PWM Channel Dead Time Register (ch_num = 3)
	// Position of DTH field.
	PWM_DT3_DTH_Pos = 0x0
	// Bit mask of DTH field.
	PWM_DT3_DTH_Msk = 0xffff
	// Position of DTL field.
	PWM_DT3_DTL_Pos = 0x10
	// Bit mask of DTL field.
	PWM_DT3_DTL_Msk = 0xffff0000

	// DTUPD3: PWM Channel Dead Time Update Register (ch_num = 3)
	// Position of DTHUPD field.
	PWM_DTUPD3_DTHUPD_Pos = 0x0
	// Bit mask of DTHUPD field.
	PWM_DTUPD3_DTHUPD_Msk = 0xffff
	// Position of DTLUPD field.
	PWM_DTUPD3_DTLUPD_Pos = 0x10
	// Bit mask of DTLUPD field.
	PWM_DTUPD3_DTLUPD_Msk = 0xffff0000

	// CMR4: PWM Channel Mode Register (ch_num = 4)
	// Position of CPRE field.
	PWM_CMR4_CPRE_Pos = 0x0
	// Bit mask of CPRE field.
	PWM_CMR4_CPRE_Msk = 0xf
	// Master clock
	PWM_CMR4_CPRE_MCK = 0x0
	// Master clock/2
	PWM_CMR4_CPRE_MCK_DIV_2 = 0x1
	// Master clock/4
	PWM_CMR4_CPRE_MCK_DIV_4 = 0x2
	// Master clock/8
	PWM_CMR4_CPRE_MCK_DIV_8 = 0x3
	// Master clock/16
	PWM_CMR4_CPRE_MCK_DIV_16 = 0x4
	// Master clock/32
	PWM_CMR4_CPRE_MCK_DIV_32 = 0x5
	// Master clock/64
	PWM_CMR4_CPRE_MCK_DIV_64 = 0x6
	// Master clock/128
	PWM_CMR4_CPRE_MCK_DIV_128 = 0x7
	// Master clock/256
	PWM_CMR4_CPRE_MCK_DIV_256 = 0x8
	// Master clock/512
	PWM_CMR4_CPRE_MCK_DIV_512 = 0x9
	// Master clock/1024
	PWM_CMR4_CPRE_MCK_DIV_1024 = 0xa
	// Clock A
	PWM_CMR4_CPRE_CLKA = 0xb
	// Clock B
	PWM_CMR4_CPRE_CLKB = 0xc
	// Position of CALG field.
	PWM_CMR4_CALG_Pos = 0x8
	// Bit mask of CALG field.
	PWM_CMR4_CALG_Msk = 0x100
	// Bit CALG.
	PWM_CMR4_CALG = 0x100
	// Position of CPOL field.
	PWM_CMR4_CPOL_Pos = 0x9
	// Bit mask of CPOL field.
	PWM_CMR4_CPOL_Msk = 0x200
	// Bit CPOL.
	PWM_CMR4_CPOL = 0x200
	// Position of CES field.
	PWM_CMR4_CES_Pos = 0xa
	// Bit mask of CES field.
	PWM_CMR4_CES_Msk = 0x400
	// Bit CES.
	PWM_CMR4_CES = 0x400
	// Position of DTE field.
	PWM_CMR4_DTE_Pos = 0x10
	// Bit mask of DTE field.
	PWM_CMR4_DTE_Msk = 0x10000
	// Bit DTE.
	PWM_CMR4_DTE = 0x10000
	// Position of DTHI field.
	PWM_CMR4_DTHI_Pos = 0x11
	// Bit mask of DTHI field.
	PWM_CMR4_DTHI_Msk = 0x20000
	// Bit DTHI.
	PWM_CMR4_DTHI = 0x20000
	// Position of DTLI field.
	PWM_CMR4_DTLI_Pos = 0x12
	// Bit mask of DTLI field.
	PWM_CMR4_DTLI_Msk = 0x40000
	// Bit DTLI.
	PWM_CMR4_DTLI = 0x40000

	// CDTY4: PWM Channel Duty Cycle Register (ch_num = 4)
	// Position of CDTY field.
	PWM_CDTY4_CDTY_Pos = 0x0
	// Bit mask of CDTY field.
	PWM_CDTY4_CDTY_Msk = 0xffffff

	// CDTYUPD4: PWM Channel Duty Cycle Update Register (ch_num = 4)
	// Position of CDTYUPD field.
	PWM_CDTYUPD4_CDTYUPD_Pos = 0x0
	// Bit mask of CDTYUPD field.
	PWM_CDTYUPD4_CDTYUPD_Msk = 0xffffff

	// CPRD4: PWM Channel Period Register (ch_num = 4)
	// Position of CPRD field.
	PWM_CPRD4_CPRD_Pos = 0x0
	// Bit mask of CPRD field.
	PWM_CPRD4_CPRD_Msk = 0xffffff

	// CPRDUPD4: PWM Channel Period Update Register (ch_num = 4)
	// Position of CPRDUPD field.
	PWM_CPRDUPD4_CPRDUPD_Pos = 0x0
	// Bit mask of CPRDUPD field.
	PWM_CPRDUPD4_CPRDUPD_Msk = 0xffffff

	// CCNT4: PWM Channel Counter Register (ch_num = 4)
	// Position of CNT field.
	PWM_CCNT4_CNT_Pos = 0x0
	// Bit mask of CNT field.
	PWM_CCNT4_CNT_Msk = 0xffffff

	// DT4: PWM Channel Dead Time Register (ch_num = 4)
	// Position of DTH field.
	PWM_DT4_DTH_Pos = 0x0
	// Bit mask of DTH field.
	PWM_DT4_DTH_Msk = 0xffff
	// Position of DTL field.
	PWM_DT4_DTL_Pos = 0x10
	// Bit mask of DTL field.
	PWM_DT4_DTL_Msk = 0xffff0000

	// DTUPD4: PWM Channel Dead Time Update Register (ch_num = 4)
	// Position of DTHUPD field.
	PWM_DTUPD4_DTHUPD_Pos = 0x0
	// Bit mask of DTHUPD field.
	PWM_DTUPD4_DTHUPD_Msk = 0xffff
	// Position of DTLUPD field.
	PWM_DTUPD4_DTLUPD_Pos = 0x10
	// Bit mask of DTLUPD field.
	PWM_DTUPD4_DTLUPD_Msk = 0xffff0000

	// CMR5: PWM Channel Mode Register (ch_num = 5)
	// Position of CPRE field.
	PWM_CMR5_CPRE_Pos = 0x0
	// Bit mask of CPRE field.
	PWM_CMR5_CPRE_Msk = 0xf
	// Master clock
	PWM_CMR5_CPRE_MCK = 0x0
	// Master clock/2
	PWM_CMR5_CPRE_MCK_DIV_2 = 0x1
	// Master clock/4
	PWM_CMR5_CPRE_MCK_DIV_4 = 0x2
	// Master clock/8
	PWM_CMR5_CPRE_MCK_DIV_8 = 0x3
	// Master clock/16
	PWM_CMR5_CPRE_MCK_DIV_16 = 0x4
	// Master clock/32
	PWM_CMR5_CPRE_MCK_DIV_32 = 0x5
	// Master clock/64
	PWM_CMR5_CPRE_MCK_DIV_64 = 0x6
	// Master clock/128
	PWM_CMR5_CPRE_MCK_DIV_128 = 0x7
	// Master clock/256
	PWM_CMR5_CPRE_MCK_DIV_256 = 0x8
	// Master clock/512
	PWM_CMR5_CPRE_MCK_DIV_512 = 0x9
	// Master clock/1024
	PWM_CMR5_CPRE_MCK_DIV_1024 = 0xa
	// Clock A
	PWM_CMR5_CPRE_CLKA = 0xb
	// Clock B
	PWM_CMR5_CPRE_CLKB = 0xc
	// Position of CALG field.
	PWM_CMR5_CALG_Pos = 0x8
	// Bit mask of CALG field.
	PWM_CMR5_CALG_Msk = 0x100
	// Bit CALG.
	PWM_CMR5_CALG = 0x100
	// Position of CPOL field.
	PWM_CMR5_CPOL_Pos = 0x9
	// Bit mask of CPOL field.
	PWM_CMR5_CPOL_Msk = 0x200
	// Bit CPOL.
	PWM_CMR5_CPOL = 0x200
	// Position of CES field.
	PWM_CMR5_CES_Pos = 0xa
	// Bit mask of CES field.
	PWM_CMR5_CES_Msk = 0x400
	// Bit CES.
	PWM_CMR5_CES = 0x400
	// Position of DTE field.
	PWM_CMR5_DTE_Pos = 0x10
	// Bit mask of DTE field.
	PWM_CMR5_DTE_Msk = 0x10000
	// Bit DTE.
	PWM_CMR5_DTE = 0x10000
	// Position of DTHI field.
	PWM_CMR5_DTHI_Pos = 0x11
	// Bit mask of DTHI field.
	PWM_CMR5_DTHI_Msk = 0x20000
	// Bit DTHI.
	PWM_CMR5_DTHI = 0x20000
	// Position of DTLI field.
	PWM_CMR5_DTLI_Pos = 0x12
	// Bit mask of DTLI field.
	PWM_CMR5_DTLI_Msk = 0x40000
	// Bit DTLI.
	PWM_CMR5_DTLI = 0x40000

	// CDTY5: PWM Channel Duty Cycle Register (ch_num = 5)
	// Position of CDTY field.
	PWM_CDTY5_CDTY_Pos = 0x0
	// Bit mask of CDTY field.
	PWM_CDTY5_CDTY_Msk = 0xffffff

	// CDTYUPD5: PWM Channel Duty Cycle Update Register (ch_num = 5)
	// Position of CDTYUPD field.
	PWM_CDTYUPD5_CDTYUPD_Pos = 0x0
	// Bit mask of CDTYUPD field.
	PWM_CDTYUPD5_CDTYUPD_Msk = 0xffffff

	// CPRD5: PWM Channel Period Register (ch_num = 5)
	// Position of CPRD field.
	PWM_CPRD5_CPRD_Pos = 0x0
	// Bit mask of CPRD field.
	PWM_CPRD5_CPRD_Msk = 0xffffff

	// CPRDUPD5: PWM Channel Period Update Register (ch_num = 5)
	// Position of CPRDUPD field.
	PWM_CPRDUPD5_CPRDUPD_Pos = 0x0
	// Bit mask of CPRDUPD field.
	PWM_CPRDUPD5_CPRDUPD_Msk = 0xffffff

	// CCNT5: PWM Channel Counter Register (ch_num = 5)
	// Position of CNT field.
	PWM_CCNT5_CNT_Pos = 0x0
	// Bit mask of CNT field.
	PWM_CCNT5_CNT_Msk = 0xffffff

	// DT5: PWM Channel Dead Time Register (ch_num = 5)
	// Position of DTH field.
	PWM_DT5_DTH_Pos = 0x0
	// Bit mask of DTH field.
	PWM_DT5_DTH_Msk = 0xffff
	// Position of DTL field.
	PWM_DT5_DTL_Pos = 0x10
	// Bit mask of DTL field.
	PWM_DT5_DTL_Msk = 0xffff0000

	// DTUPD5: PWM Channel Dead Time Update Register (ch_num = 5)
	// Position of DTHUPD field.
	PWM_DTUPD5_DTHUPD_Pos = 0x0
	// Bit mask of DTHUPD field.
	PWM_DTUPD5_DTHUPD_Msk = 0xffff
	// Position of DTLUPD field.
	PWM_DTUPD5_DTLUPD_Pos = 0x10
	// Bit mask of DTLUPD field.
	PWM_DTUPD5_DTLUPD_Msk = 0xffff0000

	// CMR6: PWM Channel Mode Register (ch_num = 6)
	// Position of CPRE field.
	PWM_CMR6_CPRE_Pos = 0x0
	// Bit mask of CPRE field.
	PWM_CMR6_CPRE_Msk = 0xf
	// Master clock
	PWM_CMR6_CPRE_MCK = 0x0
	// Master clock/2
	PWM_CMR6_CPRE_MCK_DIV_2 = 0x1
	// Master clock/4
	PWM_CMR6_CPRE_MCK_DIV_4 = 0x2
	// Master clock/8
	PWM_CMR6_CPRE_MCK_DIV_8 = 0x3
	// Master clock/16
	PWM_CMR6_CPRE_MCK_DIV_16 = 0x4
	// Master clock/32
	PWM_CMR6_CPRE_MCK_DIV_32 = 0x5
	// Master clock/64
	PWM_CMR6_CPRE_MCK_DIV_64 = 0x6
	// Master clock/128
	PWM_CMR6_CPRE_MCK_DIV_128 = 0x7
	// Master clock/256
	PWM_CMR6_CPRE_MCK_DIV_256 = 0x8
	// Master clock/512
	PWM_CMR6_CPRE_MCK_DIV_512 = 0x9
	// Master clock/1024
	PWM_CMR6_CPRE_MCK_DIV_1024 = 0xa
	// Clock A
	PWM_CMR6_CPRE_CLKA = 0xb
	// Clock B
	PWM_CMR6_CPRE_CLKB = 0xc
	// Position of CALG field.
	PWM_CMR6_CALG_Pos = 0x8
	// Bit mask of CALG field.
	PWM_CMR6_CALG_Msk = 0x100
	// Bit CALG.
	PWM_CMR6_CALG = 0x100
	// Position of CPOL field.
	PWM_CMR6_CPOL_Pos = 0x9
	// Bit mask of CPOL field.
	PWM_CMR6_CPOL_Msk = 0x200
	// Bit CPOL.
	PWM_CMR6_CPOL = 0x200
	// Position of CES field.
	PWM_CMR6_CES_Pos = 0xa
	// Bit mask of CES field.
	PWM_CMR6_CES_Msk = 0x400
	// Bit CES.
	PWM_CMR6_CES = 0x400
	// Position of DTE field.
	PWM_CMR6_DTE_Pos = 0x10
	// Bit mask of DTE field.
	PWM_CMR6_DTE_Msk = 0x10000
	// Bit DTE.
	PWM_CMR6_DTE = 0x10000
	// Position of DTHI field.
	PWM_CMR6_DTHI_Pos = 0x11
	// Bit mask of DTHI field.
	PWM_CMR6_DTHI_Msk = 0x20000
	// Bit DTHI.
	PWM_CMR6_DTHI = 0x20000
	// Position of DTLI field.
	PWM_CMR6_DTLI_Pos = 0x12
	// Bit mask of DTLI field.
	PWM_CMR6_DTLI_Msk = 0x40000
	// Bit DTLI.
	PWM_CMR6_DTLI = 0x40000

	// CDTY6: PWM Channel Duty Cycle Register (ch_num = 6)
	// Position of CDTY field.
	PWM_CDTY6_CDTY_Pos = 0x0
	// Bit mask of CDTY field.
	PWM_CDTY6_CDTY_Msk = 0xffffff

	// CDTYUPD6: PWM Channel Duty Cycle Update Register (ch_num = 6)
	// Position of CDTYUPD field.
	PWM_CDTYUPD6_CDTYUPD_Pos = 0x0
	// Bit mask of CDTYUPD field.
	PWM_CDTYUPD6_CDTYUPD_Msk = 0xffffff

	// CPRD6: PWM Channel Period Register (ch_num = 6)
	// Position of CPRD field.
	PWM_CPRD6_CPRD_Pos = 0x0
	// Bit mask of CPRD field.
	PWM_CPRD6_CPRD_Msk = 0xffffff

	// CPRDUPD6: PWM Channel Period Update Register (ch_num = 6)
	// Position of CPRDUPD field.
	PWM_CPRDUPD6_CPRDUPD_Pos = 0x0
	// Bit mask of CPRDUPD field.
	PWM_CPRDUPD6_CPRDUPD_Msk = 0xffffff

	// CCNT6: PWM Channel Counter Register (ch_num = 6)
	// Position of CNT field.
	PWM_CCNT6_CNT_Pos = 0x0
	// Bit mask of CNT field.
	PWM_CCNT6_CNT_Msk = 0xffffff

	// DT6: PWM Channel Dead Time Register (ch_num = 6)
	// Position of DTH field.
	PWM_DT6_DTH_Pos = 0x0
	// Bit mask of DTH field.
	PWM_DT6_DTH_Msk = 0xffff
	// Position of DTL field.
	PWM_DT6_DTL_Pos = 0x10
	// Bit mask of DTL field.
	PWM_DT6_DTL_Msk = 0xffff0000

	// DTUPD6: PWM Channel Dead Time Update Register (ch_num = 6)
	// Position of DTHUPD field.
	PWM_DTUPD6_DTHUPD_Pos = 0x0
	// Bit mask of DTHUPD field.
	PWM_DTUPD6_DTHUPD_Msk = 0xffff
	// Position of DTLUPD field.
	PWM_DTUPD6_DTLUPD_Pos = 0x10
	// Bit mask of DTLUPD field.
	PWM_DTUPD6_DTLUPD_Msk = 0xffff0000

	// CMR7: PWM Channel Mode Register (ch_num = 7)
	// Position of CPRE field.
	PWM_CMR7_CPRE_Pos = 0x0
	// Bit mask of CPRE field.
	PWM_CMR7_CPRE_Msk = 0xf
	// Master clock
	PWM_CMR7_CPRE_MCK = 0x0
	// Master clock/2
	PWM_CMR7_CPRE_MCK_DIV_2 = 0x1
	// Master clock/4
	PWM_CMR7_CPRE_MCK_DIV_4 = 0x2
	// Master clock/8
	PWM_CMR7_CPRE_MCK_DIV_8 = 0x3
	// Master clock/16
	PWM_CMR7_CPRE_MCK_DIV_16 = 0x4
	// Master clock/32
	PWM_CMR7_CPRE_MCK_DIV_32 = 0x5
	// Master clock/64
	PWM_CMR7_CPRE_MCK_DIV_64 = 0x6
	// Master clock/128
	PWM_CMR7_CPRE_MCK_DIV_128 = 0x7
	// Master clock/256
	PWM_CMR7_CPRE_MCK_DIV_256 = 0x8
	// Master clock/512
	PWM_CMR7_CPRE_MCK_DIV_512 = 0x9
	// Master clock/1024
	PWM_CMR7_CPRE_MCK_DIV_1024 = 0xa
	// Clock A
	PWM_CMR7_CPRE_CLKA = 0xb
	// Clock B
	PWM_CMR7_CPRE_CLKB = 0xc
	// Position of CALG field.
	PWM_CMR7_CALG_Pos = 0x8
	// Bit mask of CALG field.
	PWM_CMR7_CALG_Msk = 0x100
	// Bit CALG.
	PWM_CMR7_CALG = 0x100
	// Position of CPOL field.
	PWM_CMR7_CPOL_Pos = 0x9
	// Bit mask of CPOL field.
	PWM_CMR7_CPOL_Msk = 0x200
	// Bit CPOL.
	PWM_CMR7_CPOL = 0x200
	// Position of CES field.
	PWM_CMR7_CES_Pos = 0xa
	// Bit mask of CES field.
	PWM_CMR7_CES_Msk = 0x400
	// Bit CES.
	PWM_CMR7_CES = 0x400
	// Position of DTE field.
	PWM_CMR7_DTE_Pos = 0x10
	// Bit mask of DTE field.
	PWM_CMR7_DTE_Msk = 0x10000
	// Bit DTE.
	PWM_CMR7_DTE = 0x10000
	// Position of DTHI field.
	PWM_CMR7_DTHI_Pos = 0x11
	// Bit mask of DTHI field.
	PWM_CMR7_DTHI_Msk = 0x20000
	// Bit DTHI.
	PWM_CMR7_DTHI = 0x20000
	// Position of DTLI field.
	PWM_CMR7_DTLI_Pos = 0x12
	// Bit mask of DTLI field.
	PWM_CMR7_DTLI_Msk = 0x40000
	// Bit DTLI.
	PWM_CMR7_DTLI = 0x40000

	// CDTY7: PWM Channel Duty Cycle Register (ch_num = 7)
	// Position of CDTY field.
	PWM_CDTY7_CDTY_Pos = 0x0
	// Bit mask of CDTY field.
	PWM_CDTY7_CDTY_Msk = 0xffffff

	// CDTYUPD7: PWM Channel Duty Cycle Update Register (ch_num = 7)
	// Position of CDTYUPD field.
	PWM_CDTYUPD7_CDTYUPD_Pos = 0x0
	// Bit mask of CDTYUPD field.
	PWM_CDTYUPD7_CDTYUPD_Msk = 0xffffff

	// CPRD7: PWM Channel Period Register (ch_num = 7)
	// Position of CPRD field.
	PWM_CPRD7_CPRD_Pos = 0x0
	// Bit mask of CPRD field.
	PWM_CPRD7_CPRD_Msk = 0xffffff

	// CPRDUPD7: PWM Channel Period Update Register (ch_num = 7)
	// Position of CPRDUPD field.
	PWM_CPRDUPD7_CPRDUPD_Pos = 0x0
	// Bit mask of CPRDUPD field.
	PWM_CPRDUPD7_CPRDUPD_Msk = 0xffffff

	// CCNT7: PWM Channel Counter Register (ch_num = 7)
	// Position of CNT field.
	PWM_CCNT7_CNT_Pos = 0x0
	// Bit mask of CNT field.
	PWM_CCNT7_CNT_Msk = 0xffffff

	// DT7: PWM Channel Dead Time Register (ch_num = 7)
	// Position of DTH field.
	PWM_DT7_DTH_Pos = 0x0
	// Bit mask of DTH field.
	PWM_DT7_DTH_Msk = 0xffff
	// Position of DTL field.
	PWM_DT7_DTL_Pos = 0x10
	// Bit mask of DTL field.
	PWM_DT7_DTL_Msk = 0xffff0000

	// DTUPD7: PWM Channel Dead Time Update Register (ch_num = 7)
	// Position of DTHUPD field.
	PWM_DTUPD7_DTHUPD_Pos = 0x0
	// Bit mask of DTHUPD field.
	PWM_DTUPD7_DTHUPD_Msk = 0xffff
	// Position of DTLUPD field.
	PWM_DTUPD7_DTLUPD_Pos = 0x10
	// Bit mask of DTLUPD field.
	PWM_DTUPD7_DTLUPD_Msk = 0xffff0000
)

// Bitfields for USART0: Universal Synchronous Asynchronous Receiver Transmitter 0
const (
	// CR: Control Register
	// Position of RSTRX field.
	USART_CR_RSTRX_Pos = 0x2
	// Bit mask of RSTRX field.
	USART_CR_RSTRX_Msk = 0x4
	// Bit RSTRX.
	USART_CR_RSTRX = 0x4
	// Position of RSTTX field.
	USART_CR_RSTTX_Pos = 0x3
	// Bit mask of RSTTX field.
	USART_CR_RSTTX_Msk = 0x8
	// Bit RSTTX.
	USART_CR_RSTTX = 0x8
	// Position of RXEN field.
	USART_CR_RXEN_Pos = 0x4
	// Bit mask of RXEN field.
	USART_CR_RXEN_Msk = 0x10
	// Bit RXEN.
	USART_CR_RXEN = 0x10
	// Position of RXDIS field.
	USART_CR_RXDIS_Pos = 0x5
	// Bit mask of RXDIS field.
	USART_CR_RXDIS_Msk = 0x20
	// Bit RXDIS.
	USART_CR_RXDIS = 0x20
	// Position of TXEN field.
	USART_CR_TXEN_Pos = 0x6
	// Bit mask of TXEN field.
	USART_CR_TXEN_Msk = 0x40
	// Bit TXEN.
	USART_CR_TXEN = 0x40
	// Position of TXDIS field.
	USART_CR_TXDIS_Pos = 0x7
	// Bit mask of TXDIS field.
	USART_CR_TXDIS_Msk = 0x80
	// Bit TXDIS.
	USART_CR_TXDIS = 0x80
	// Position of RSTSTA field.
	USART_CR_RSTSTA_Pos = 0x8
	// Bit mask of RSTSTA field.
	USART_CR_RSTSTA_Msk = 0x100
	// Bit RSTSTA.
	USART_CR_RSTSTA = 0x100
	// Position of STTBRK field.
	USART_CR_STTBRK_Pos = 0x9
	// Bit mask of STTBRK field.
	USART_CR_STTBRK_Msk = 0x200
	// Bit STTBRK.
	USART_CR_STTBRK = 0x200
	// Position of STPBRK field.
	USART_CR_STPBRK_Pos = 0xa
	// Bit mask of STPBRK field.
	USART_CR_STPBRK_Msk = 0x400
	// Bit STPBRK.
	USART_CR_STPBRK = 0x400
	// Position of STTTO field.
	USART_CR_STTTO_Pos = 0xb
	// Bit mask of STTTO field.
	USART_CR_STTTO_Msk = 0x800
	// Bit STTTO.
	USART_CR_STTTO = 0x800
	// Position of SENDA field.
	USART_CR_SENDA_Pos = 0xc
	// Bit mask of SENDA field.
	USART_CR_SENDA_Msk = 0x1000
	// Bit SENDA.
	USART_CR_SENDA = 0x1000
	// Position of RSTIT field.
	USART_CR_RSTIT_Pos = 0xd
	// Bit mask of RSTIT field.
	USART_CR_RSTIT_Msk = 0x2000
	// Bit RSTIT.
	USART_CR_RSTIT = 0x2000
	// Position of RSTNACK field.
	USART_CR_RSTNACK_Pos = 0xe
	// Bit mask of RSTNACK field.
	USART_CR_RSTNACK_Msk = 0x4000
	// Bit RSTNACK.
	USART_CR_RSTNACK = 0x4000
	// Position of RETTO field.
	USART_CR_RETTO_Pos = 0xf
	// Bit mask of RETTO field.
	USART_CR_RETTO_Msk = 0x8000
	// Bit RETTO.
	USART_CR_RETTO = 0x8000
	// Position of RTSEN field.
	USART_CR_RTSEN_Pos = 0x12
	// Bit mask of RTSEN field.
	USART_CR_RTSEN_Msk = 0x40000
	// Bit RTSEN.
	USART_CR_RTSEN = 0x40000
	// Position of RTSDIS field.
	USART_CR_RTSDIS_Pos = 0x13
	// Bit mask of RTSDIS field.
	USART_CR_RTSDIS_Msk = 0x80000
	// Bit RTSDIS.
	USART_CR_RTSDIS = 0x80000
	// Position of LINABT field.
	USART_CR_LINABT_Pos = 0x14
	// Bit mask of LINABT field.
	USART_CR_LINABT_Msk = 0x100000
	// Bit LINABT.
	USART_CR_LINABT = 0x100000
	// Position of LINWKUP field.
	USART_CR_LINWKUP_Pos = 0x15
	// Bit mask of LINWKUP field.
	USART_CR_LINWKUP_Msk = 0x200000
	// Bit LINWKUP.
	USART_CR_LINWKUP = 0x200000

	// CR_SPI_MODE: Control Register
	// Position of RSTRX field.
	USART_CR_SPI_MODE_RSTRX_Pos = 0x2
	// Bit mask of RSTRX field.
	USART_CR_SPI_MODE_RSTRX_Msk = 0x4
	// Bit RSTRX.
	USART_CR_SPI_MODE_RSTRX = 0x4
	// Position of RSTTX field.
	USART_CR_SPI_MODE_RSTTX_Pos = 0x3
	// Bit mask of RSTTX field.
	USART_CR_SPI_MODE_RSTTX_Msk = 0x8
	// Bit RSTTX.
	USART_CR_SPI_MODE_RSTTX = 0x8
	// Position of RXEN field.
	USART_CR_SPI_MODE_RXEN_Pos = 0x4
	// Bit mask of RXEN field.
	USART_CR_SPI_MODE_RXEN_Msk = 0x10
	// Bit RXEN.
	USART_CR_SPI_MODE_RXEN = 0x10
	// Position of RXDIS field.
	USART_CR_SPI_MODE_RXDIS_Pos = 0x5
	// Bit mask of RXDIS field.
	USART_CR_SPI_MODE_RXDIS_Msk = 0x20
	// Bit RXDIS.
	USART_CR_SPI_MODE_RXDIS = 0x20
	// Position of TXEN field.
	USART_CR_SPI_MODE_TXEN_Pos = 0x6
	// Bit mask of TXEN field.
	USART_CR_SPI_MODE_TXEN_Msk = 0x40
	// Bit TXEN.
	USART_CR_SPI_MODE_TXEN = 0x40
	// Position of TXDIS field.
	USART_CR_SPI_MODE_TXDIS_Pos = 0x7
	// Bit mask of TXDIS field.
	USART_CR_SPI_MODE_TXDIS_Msk = 0x80
	// Bit TXDIS.
	USART_CR_SPI_MODE_TXDIS = 0x80
	// Position of RSTSTA field.
	USART_CR_SPI_MODE_RSTSTA_Pos = 0x8
	// Bit mask of RSTSTA field.
	USART_CR_SPI_MODE_RSTSTA_Msk = 0x100
	// Bit RSTSTA.
	USART_CR_SPI_MODE_RSTSTA = 0x100
	// Position of FCS field.
	USART_CR_SPI_MODE_FCS_Pos = 0x12
	// Bit mask of FCS field.
	USART_CR_SPI_MODE_FCS_Msk = 0x40000
	// Bit FCS.
	USART_CR_SPI_MODE_FCS = 0x40000
	// Position of RCS field.
	USART_CR_SPI_MODE_RCS_Pos = 0x13
	// Bit mask of RCS field.
	USART_CR_SPI_MODE_RCS_Msk = 0x80000
	// Bit RCS.
	USART_CR_SPI_MODE_RCS = 0x80000

	// MR: Mode Register
	// Position of USART_MODE field.
	USART_MR_USART_MODE_Pos = 0x0
	// Bit mask of USART_MODE field.
	USART_MR_USART_MODE_Msk = 0xf
	// Normal mode
	USART_MR_USART_MODE_NORMAL = 0x0
	// RS485
	USART_MR_USART_MODE_RS485 = 0x1
	// Hardware Handshaking
	USART_MR_USART_MODE_HW_HANDSHAKING = 0x2
	// IS07816 Protocol: T = 0
	USART_MR_USART_MODE_IS07816_T_0 = 0x4
	// IS07816 Protocol: T = 1
	USART_MR_USART_MODE_IS07816_T_1 = 0x6
	// IrDA
	USART_MR_USART_MODE_IRDA = 0x8
	// LIN master
	USART_MR_USART_MODE_LIN_MASTER = 0xa
	// LIN Slave
	USART_MR_USART_MODE_LIN_SLAVE = 0xb
	// SPI master
	USART_MR_USART_MODE_SPI_MASTER = 0xe
	// SPI Slave
	USART_MR_USART_MODE_SPI_SLAVE = 0xf
	// Position of USCLKS field.
	USART_MR_USCLKS_Pos = 0x4
	// Bit mask of USCLKS field.
	USART_MR_USCLKS_Msk = 0x30
	// master Clock MCK is selected
	USART_MR_USCLKS_MCK = 0x0
	// Internal Clock Divided MCK/DIV (DIV=8) is selected
	USART_MR_USCLKS_DIV = 0x1
	// Serial Clock SLK is selected
	USART_MR_USCLKS_SCK = 0x3
	// Position of CHRL field.
	USART_MR_CHRL_Pos = 0x6
	// Bit mask of CHRL field.
	USART_MR_CHRL_Msk = 0xc0
	// Character length is 5 bits
	USART_MR_CHRL_5_BIT = 0x0
	// Character length is 6 bits
	USART_MR_CHRL_6_BIT = 0x1
	// Character length is 7 bits
	USART_MR_CHRL_7_BIT = 0x2
	// Character length is 8 bits
	USART_MR_CHRL_8_BIT = 0x3
	// Position of SYNC field.
	USART_MR_SYNC_Pos = 0x8
	// Bit mask of SYNC field.
	USART_MR_SYNC_Msk = 0x100
	// Bit SYNC.
	USART_MR_SYNC = 0x100
	// Position of PAR field.
	USART_MR_PAR_Pos = 0x9
	// Bit mask of PAR field.
	USART_MR_PAR_Msk = 0xe00
	// Even parity
	USART_MR_PAR_EVEN = 0x0
	// Odd parity
	USART_MR_PAR_ODD = 0x1
	// Parity forced to 0 (Space)
	USART_MR_PAR_SPACE = 0x2
	// Parity forced to 1 (Mark)
	USART_MR_PAR_MARK = 0x3
	// No parity
	USART_MR_PAR_NO = 0x4
	// Multidrop mode
	USART_MR_PAR_MULTIDROP = 0x6
	// Position of NBSTOP field.
	USART_MR_NBSTOP_Pos = 0xc
	// Bit mask of NBSTOP field.
	USART_MR_NBSTOP_Msk = 0x3000
	// 1 stop bit
	USART_MR_NBSTOP_1_BIT = 0x0
	// 1.5 stop bit (SYNC = 0) or reserved (SYNC = 1)
	USART_MR_NBSTOP_1_5_BIT = 0x1
	// 2 stop bits
	USART_MR_NBSTOP_2_BIT = 0x2
	// Position of CHMODE field.
	USART_MR_CHMODE_Pos = 0xe
	// Bit mask of CHMODE field.
	USART_MR_CHMODE_Msk = 0xc000
	// Normal mode
	USART_MR_CHMODE_NORMAL = 0x0
	// Automatic Echo. Receiver input is connected to the TXD pin.
	USART_MR_CHMODE_AUTOMATIC = 0x1
	// Local Loopback. Transmitter output is connected to the Receiver Input.
	USART_MR_CHMODE_LOCAL_LOOPBACK = 0x2
	// Remote Loopback. RXD pin is internally connected to the TXD pin.
	USART_MR_CHMODE_REMOTE_LOOPBACK = 0x3
	// Position of MSBF field.
	USART_MR_MSBF_Pos = 0x10
	// Bit mask of MSBF field.
	USART_MR_MSBF_Msk = 0x10000
	// Bit MSBF.
	USART_MR_MSBF = 0x10000
	// Position of MODE9 field.
	USART_MR_MODE9_Pos = 0x11
	// Bit mask of MODE9 field.
	USART_MR_MODE9_Msk = 0x20000
	// Bit MODE9.
	USART_MR_MODE9 = 0x20000
	// Position of CLKO field.
	USART_MR_CLKO_Pos = 0x12
	// Bit mask of CLKO field.
	USART_MR_CLKO_Msk = 0x40000
	// Bit CLKO.
	USART_MR_CLKO = 0x40000
	// Position of OVER field.
	USART_MR_OVER_Pos = 0x13
	// Bit mask of OVER field.
	USART_MR_OVER_Msk = 0x80000
	// Bit OVER.
	USART_MR_OVER = 0x80000
	// Position of INACK field.
	USART_MR_INACK_Pos = 0x14
	// Bit mask of INACK field.
	USART_MR_INACK_Msk = 0x100000
	// Bit INACK.
	USART_MR_INACK = 0x100000
	// Position of DSNACK field.
	USART_MR_DSNACK_Pos = 0x15
	// Bit mask of DSNACK field.
	USART_MR_DSNACK_Msk = 0x200000
	// Bit DSNACK.
	USART_MR_DSNACK = 0x200000
	// Position of VAR_SYNC field.
	USART_MR_VAR_SYNC_Pos = 0x16
	// Bit mask of VAR_SYNC field.
	USART_MR_VAR_SYNC_Msk = 0x400000
	// Bit VAR_SYNC.
	USART_MR_VAR_SYNC = 0x400000
	// Position of INVDATA field.
	USART_MR_INVDATA_Pos = 0x17
	// Bit mask of INVDATA field.
	USART_MR_INVDATA_Msk = 0x800000
	// Bit INVDATA.
	USART_MR_INVDATA = 0x800000
	// Position of MAX_ITERATION field.
	USART_MR_MAX_ITERATION_Pos = 0x18
	// Bit mask of MAX_ITERATION field.
	USART_MR_MAX_ITERATION_Msk = 0x7000000
	// Position of FILTER field.
	USART_MR_FILTER_Pos = 0x1c
	// Bit mask of FILTER field.
	USART_MR_FILTER_Msk = 0x10000000
	// Bit FILTER.
	USART_MR_FILTER = 0x10000000
	// Position of MAN field.
	USART_MR_MAN_Pos = 0x1d
	// Bit mask of MAN field.
	USART_MR_MAN_Msk = 0x20000000
	// Bit MAN.
	USART_MR_MAN = 0x20000000
	// Position of MODSYNC field.
	USART_MR_MODSYNC_Pos = 0x1e
	// Bit mask of MODSYNC field.
	USART_MR_MODSYNC_Msk = 0x40000000
	// Bit MODSYNC.
	USART_MR_MODSYNC = 0x40000000
	// Position of ONEBIT field.
	USART_MR_ONEBIT_Pos = 0x1f
	// Bit mask of ONEBIT field.
	USART_MR_ONEBIT_Msk = 0x80000000
	// Bit ONEBIT.
	USART_MR_ONEBIT = 0x80000000

	// MR_SPI_MODE: Mode Register
	// Position of USART_MODE field.
	USART_MR_SPI_MODE_USART_MODE_Pos = 0x0
	// Bit mask of USART_MODE field.
	USART_MR_SPI_MODE_USART_MODE_Msk = 0xf
	// SPI master
	USART_MR_SPI_MODE_USART_MODE_SPI_MASTER = 0xe
	// SPI Slave
	USART_MR_SPI_MODE_USART_MODE_SPI_SLAVE = 0xf
	// Position of USCLKS field.
	USART_MR_SPI_MODE_USCLKS_Pos = 0x4
	// Bit mask of USCLKS field.
	USART_MR_SPI_MODE_USCLKS_Msk = 0x30
	// master Clock MCK is selected
	USART_MR_SPI_MODE_USCLKS_MCK = 0x0
	// Internal Clock Divided MCK/DIV (DIV=8) is selected
	USART_MR_SPI_MODE_USCLKS_DIV = 0x1
	// Serial Clock SLK is selected
	USART_MR_SPI_MODE_USCLKS_SCK = 0x3
	// Position of CHRL field.
	USART_MR_SPI_MODE_CHRL_Pos = 0x6
	// Bit mask of CHRL field.
	USART_MR_SPI_MODE_CHRL_Msk = 0xc0
	// Character length is 8 bits
	USART_MR_SPI_MODE_CHRL_8_BIT = 0x3
	// Position of CPHA field.
	USART_MR_SPI_MODE_CPHA_Pos = 0x8
	// Bit mask of CPHA field.
	USART_MR_SPI_MODE_CPHA_Msk = 0x100
	// Bit CPHA.
	USART_MR_SPI_MODE_CPHA = 0x100
	// Position of CPOL field.
	USART_MR_SPI_MODE_CPOL_Pos = 0x10
	// Bit mask of CPOL field.
	USART_MR_SPI_MODE_CPOL_Msk = 0x10000
	// Bit CPOL.
	USART_MR_SPI_MODE_CPOL = 0x10000
	// Position of WRDBT field.
	USART_MR_SPI_MODE_WRDBT_Pos = 0x14
	// Bit mask of WRDBT field.
	USART_MR_SPI_MODE_WRDBT_Msk = 0x100000
	// Bit WRDBT.
	USART_MR_SPI_MODE_WRDBT = 0x100000

	// IER: Interrupt Enable Register
	// Position of RXRDY field.
	USART_IER_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART_IER_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART_IER_RXRDY = 0x1
	// Position of TXRDY field.
	USART_IER_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	USART_IER_TXRDY_Msk = 0x2
	// Bit TXRDY.
	USART_IER_TXRDY = 0x2
	// Position of RXBRK field.
	USART_IER_RXBRK_Pos = 0x2
	// Bit mask of RXBRK field.
	USART_IER_RXBRK_Msk = 0x4
	// Bit RXBRK.
	USART_IER_RXBRK = 0x4
	// Position of ENDRX field.
	USART_IER_ENDRX_Pos = 0x3
	// Bit mask of ENDRX field.
	USART_IER_ENDRX_Msk = 0x8
	// Bit ENDRX.
	USART_IER_ENDRX = 0x8
	// Position of ENDTX field.
	USART_IER_ENDTX_Pos = 0x4
	// Bit mask of ENDTX field.
	USART_IER_ENDTX_Msk = 0x10
	// Bit ENDTX.
	USART_IER_ENDTX = 0x10
	// Position of OVRE field.
	USART_IER_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	USART_IER_OVRE_Msk = 0x20
	// Bit OVRE.
	USART_IER_OVRE = 0x20
	// Position of FRAME field.
	USART_IER_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	USART_IER_FRAME_Msk = 0x40
	// Bit FRAME.
	USART_IER_FRAME = 0x40
	// Position of PARE field.
	USART_IER_PARE_Pos = 0x7
	// Bit mask of PARE field.
	USART_IER_PARE_Msk = 0x80
	// Bit PARE.
	USART_IER_PARE = 0x80
	// Position of TIMEOUT field.
	USART_IER_TIMEOUT_Pos = 0x8
	// Bit mask of TIMEOUT field.
	USART_IER_TIMEOUT_Msk = 0x100
	// Bit TIMEOUT.
	USART_IER_TIMEOUT = 0x100
	// Position of TXEMPTY field.
	USART_IER_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	USART_IER_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	USART_IER_TXEMPTY = 0x200
	// Position of ITER field.
	USART_IER_ITER_Pos = 0xa
	// Bit mask of ITER field.
	USART_IER_ITER_Msk = 0x400
	// Bit ITER.
	USART_IER_ITER = 0x400
	// Position of TXBUFE field.
	USART_IER_TXBUFE_Pos = 0xb
	// Bit mask of TXBUFE field.
	USART_IER_TXBUFE_Msk = 0x800
	// Bit TXBUFE.
	USART_IER_TXBUFE = 0x800
	// Position of RXBUFF field.
	USART_IER_RXBUFF_Pos = 0xc
	// Bit mask of RXBUFF field.
	USART_IER_RXBUFF_Msk = 0x1000
	// Bit RXBUFF.
	USART_IER_RXBUFF = 0x1000
	// Position of NACK field.
	USART_IER_NACK_Pos = 0xd
	// Bit mask of NACK field.
	USART_IER_NACK_Msk = 0x2000
	// Bit NACK.
	USART_IER_NACK = 0x2000
	// Position of CTSIC field.
	USART_IER_CTSIC_Pos = 0x13
	// Bit mask of CTSIC field.
	USART_IER_CTSIC_Msk = 0x80000
	// Bit CTSIC.
	USART_IER_CTSIC = 0x80000
	// Position of MANE field.
	USART_IER_MANE_Pos = 0x18
	// Bit mask of MANE field.
	USART_IER_MANE_Msk = 0x1000000
	// Bit MANE.
	USART_IER_MANE = 0x1000000

	// IER_SPI_MODE: Interrupt Enable Register
	// Position of RXRDY field.
	USART_IER_SPI_MODE_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART_IER_SPI_MODE_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART_IER_SPI_MODE_RXRDY = 0x1
	// Position of TXRDY field.
	USART_IER_SPI_MODE_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	USART_IER_SPI_MODE_TXRDY_Msk = 0x2
	// Bit TXRDY.
	USART_IER_SPI_MODE_TXRDY = 0x2
	// Position of ENDRX field.
	USART_IER_SPI_MODE_ENDRX_Pos = 0x3
	// Bit mask of ENDRX field.
	USART_IER_SPI_MODE_ENDRX_Msk = 0x8
	// Bit ENDRX.
	USART_IER_SPI_MODE_ENDRX = 0x8
	// Position of ENDTX field.
	USART_IER_SPI_MODE_ENDTX_Pos = 0x4
	// Bit mask of ENDTX field.
	USART_IER_SPI_MODE_ENDTX_Msk = 0x10
	// Bit ENDTX.
	USART_IER_SPI_MODE_ENDTX = 0x10
	// Position of OVRE field.
	USART_IER_SPI_MODE_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	USART_IER_SPI_MODE_OVRE_Msk = 0x20
	// Bit OVRE.
	USART_IER_SPI_MODE_OVRE = 0x20
	// Position of TXEMPTY field.
	USART_IER_SPI_MODE_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	USART_IER_SPI_MODE_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	USART_IER_SPI_MODE_TXEMPTY = 0x200
	// Position of UNRE field.
	USART_IER_SPI_MODE_UNRE_Pos = 0xa
	// Bit mask of UNRE field.
	USART_IER_SPI_MODE_UNRE_Msk = 0x400
	// Bit UNRE.
	USART_IER_SPI_MODE_UNRE = 0x400
	// Position of TXBUFE field.
	USART_IER_SPI_MODE_TXBUFE_Pos = 0xb
	// Bit mask of TXBUFE field.
	USART_IER_SPI_MODE_TXBUFE_Msk = 0x800
	// Bit TXBUFE.
	USART_IER_SPI_MODE_TXBUFE = 0x800
	// Position of RXBUFF field.
	USART_IER_SPI_MODE_RXBUFF_Pos = 0xc
	// Bit mask of RXBUFF field.
	USART_IER_SPI_MODE_RXBUFF_Msk = 0x1000
	// Bit RXBUFF.
	USART_IER_SPI_MODE_RXBUFF = 0x1000

	// IER_LIN_MODE: Interrupt Enable Register
	// Position of RXRDY field.
	USART_IER_LIN_MODE_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART_IER_LIN_MODE_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART_IER_LIN_MODE_RXRDY = 0x1
	// Position of TXRDY field.
	USART_IER_LIN_MODE_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	USART_IER_LIN_MODE_TXRDY_Msk = 0x2
	// Bit TXRDY.
	USART_IER_LIN_MODE_TXRDY = 0x2
	// Position of ENDRX field.
	USART_IER_LIN_MODE_ENDRX_Pos = 0x3
	// Bit mask of ENDRX field.
	USART_IER_LIN_MODE_ENDRX_Msk = 0x8
	// Bit ENDRX.
	USART_IER_LIN_MODE_ENDRX = 0x8
	// Position of ENDTX field.
	USART_IER_LIN_MODE_ENDTX_Pos = 0x4
	// Bit mask of ENDTX field.
	USART_IER_LIN_MODE_ENDTX_Msk = 0x10
	// Bit ENDTX.
	USART_IER_LIN_MODE_ENDTX = 0x10
	// Position of OVRE field.
	USART_IER_LIN_MODE_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	USART_IER_LIN_MODE_OVRE_Msk = 0x20
	// Bit OVRE.
	USART_IER_LIN_MODE_OVRE = 0x20
	// Position of FRAME field.
	USART_IER_LIN_MODE_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	USART_IER_LIN_MODE_FRAME_Msk = 0x40
	// Bit FRAME.
	USART_IER_LIN_MODE_FRAME = 0x40
	// Position of PARE field.
	USART_IER_LIN_MODE_PARE_Pos = 0x7
	// Bit mask of PARE field.
	USART_IER_LIN_MODE_PARE_Msk = 0x80
	// Bit PARE.
	USART_IER_LIN_MODE_PARE = 0x80
	// Position of TIMEOUT field.
	USART_IER_LIN_MODE_TIMEOUT_Pos = 0x8
	// Bit mask of TIMEOUT field.
	USART_IER_LIN_MODE_TIMEOUT_Msk = 0x100
	// Bit TIMEOUT.
	USART_IER_LIN_MODE_TIMEOUT = 0x100
	// Position of TXEMPTY field.
	USART_IER_LIN_MODE_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	USART_IER_LIN_MODE_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	USART_IER_LIN_MODE_TXEMPTY = 0x200
	// Position of TXBUFE field.
	USART_IER_LIN_MODE_TXBUFE_Pos = 0xb
	// Bit mask of TXBUFE field.
	USART_IER_LIN_MODE_TXBUFE_Msk = 0x800
	// Bit TXBUFE.
	USART_IER_LIN_MODE_TXBUFE = 0x800
	// Position of RXBUFF field.
	USART_IER_LIN_MODE_RXBUFF_Pos = 0xc
	// Bit mask of RXBUFF field.
	USART_IER_LIN_MODE_RXBUFF_Msk = 0x1000
	// Bit RXBUFF.
	USART_IER_LIN_MODE_RXBUFF = 0x1000
	// Position of LINBK field.
	USART_IER_LIN_MODE_LINBK_Pos = 0xd
	// Bit mask of LINBK field.
	USART_IER_LIN_MODE_LINBK_Msk = 0x2000
	// Bit LINBK.
	USART_IER_LIN_MODE_LINBK = 0x2000
	// Position of LINID field.
	USART_IER_LIN_MODE_LINID_Pos = 0xe
	// Bit mask of LINID field.
	USART_IER_LIN_MODE_LINID_Msk = 0x4000
	// Bit LINID.
	USART_IER_LIN_MODE_LINID = 0x4000
	// Position of LINTC field.
	USART_IER_LIN_MODE_LINTC_Pos = 0xf
	// Bit mask of LINTC field.
	USART_IER_LIN_MODE_LINTC_Msk = 0x8000
	// Bit LINTC.
	USART_IER_LIN_MODE_LINTC = 0x8000
	// Position of LINBE field.
	USART_IER_LIN_MODE_LINBE_Pos = 0x19
	// Bit mask of LINBE field.
	USART_IER_LIN_MODE_LINBE_Msk = 0x2000000
	// Bit LINBE.
	USART_IER_LIN_MODE_LINBE = 0x2000000
	// Position of LINISFE field.
	USART_IER_LIN_MODE_LINISFE_Pos = 0x1a
	// Bit mask of LINISFE field.
	USART_IER_LIN_MODE_LINISFE_Msk = 0x4000000
	// Bit LINISFE.
	USART_IER_LIN_MODE_LINISFE = 0x4000000
	// Position of LINIPE field.
	USART_IER_LIN_MODE_LINIPE_Pos = 0x1b
	// Bit mask of LINIPE field.
	USART_IER_LIN_MODE_LINIPE_Msk = 0x8000000
	// Bit LINIPE.
	USART_IER_LIN_MODE_LINIPE = 0x8000000
	// Position of LINCE field.
	USART_IER_LIN_MODE_LINCE_Pos = 0x1c
	// Bit mask of LINCE field.
	USART_IER_LIN_MODE_LINCE_Msk = 0x10000000
	// Bit LINCE.
	USART_IER_LIN_MODE_LINCE = 0x10000000
	// Position of LINSNRE field.
	USART_IER_LIN_MODE_LINSNRE_Pos = 0x1d
	// Bit mask of LINSNRE field.
	USART_IER_LIN_MODE_LINSNRE_Msk = 0x20000000
	// Bit LINSNRE.
	USART_IER_LIN_MODE_LINSNRE = 0x20000000

	// IDR: Interrupt Disable Register
	// Position of RXRDY field.
	USART_IDR_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART_IDR_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART_IDR_RXRDY = 0x1
	// Position of TXRDY field.
	USART_IDR_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	USART_IDR_TXRDY_Msk = 0x2
	// Bit TXRDY.
	USART_IDR_TXRDY = 0x2
	// Position of RXBRK field.
	USART_IDR_RXBRK_Pos = 0x2
	// Bit mask of RXBRK field.
	USART_IDR_RXBRK_Msk = 0x4
	// Bit RXBRK.
	USART_IDR_RXBRK = 0x4
	// Position of ENDRX field.
	USART_IDR_ENDRX_Pos = 0x3
	// Bit mask of ENDRX field.
	USART_IDR_ENDRX_Msk = 0x8
	// Bit ENDRX.
	USART_IDR_ENDRX = 0x8
	// Position of ENDTX field.
	USART_IDR_ENDTX_Pos = 0x4
	// Bit mask of ENDTX field.
	USART_IDR_ENDTX_Msk = 0x10
	// Bit ENDTX.
	USART_IDR_ENDTX = 0x10
	// Position of OVRE field.
	USART_IDR_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	USART_IDR_OVRE_Msk = 0x20
	// Bit OVRE.
	USART_IDR_OVRE = 0x20
	// Position of FRAME field.
	USART_IDR_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	USART_IDR_FRAME_Msk = 0x40
	// Bit FRAME.
	USART_IDR_FRAME = 0x40
	// Position of PARE field.
	USART_IDR_PARE_Pos = 0x7
	// Bit mask of PARE field.
	USART_IDR_PARE_Msk = 0x80
	// Bit PARE.
	USART_IDR_PARE = 0x80
	// Position of TIMEOUT field.
	USART_IDR_TIMEOUT_Pos = 0x8
	// Bit mask of TIMEOUT field.
	USART_IDR_TIMEOUT_Msk = 0x100
	// Bit TIMEOUT.
	USART_IDR_TIMEOUT = 0x100
	// Position of TXEMPTY field.
	USART_IDR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	USART_IDR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	USART_IDR_TXEMPTY = 0x200
	// Position of ITER field.
	USART_IDR_ITER_Pos = 0xa
	// Bit mask of ITER field.
	USART_IDR_ITER_Msk = 0x400
	// Bit ITER.
	USART_IDR_ITER = 0x400
	// Position of TXBUFE field.
	USART_IDR_TXBUFE_Pos = 0xb
	// Bit mask of TXBUFE field.
	USART_IDR_TXBUFE_Msk = 0x800
	// Bit TXBUFE.
	USART_IDR_TXBUFE = 0x800
	// Position of RXBUFF field.
	USART_IDR_RXBUFF_Pos = 0xc
	// Bit mask of RXBUFF field.
	USART_IDR_RXBUFF_Msk = 0x1000
	// Bit RXBUFF.
	USART_IDR_RXBUFF = 0x1000
	// Position of NACK field.
	USART_IDR_NACK_Pos = 0xd
	// Bit mask of NACK field.
	USART_IDR_NACK_Msk = 0x2000
	// Bit NACK.
	USART_IDR_NACK = 0x2000
	// Position of CTSIC field.
	USART_IDR_CTSIC_Pos = 0x13
	// Bit mask of CTSIC field.
	USART_IDR_CTSIC_Msk = 0x80000
	// Bit CTSIC.
	USART_IDR_CTSIC = 0x80000
	// Position of MANE field.
	USART_IDR_MANE_Pos = 0x18
	// Bit mask of MANE field.
	USART_IDR_MANE_Msk = 0x1000000
	// Bit MANE.
	USART_IDR_MANE = 0x1000000

	// IDR_SPI_MODE: Interrupt Disable Register
	// Position of RXRDY field.
	USART_IDR_SPI_MODE_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART_IDR_SPI_MODE_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART_IDR_SPI_MODE_RXRDY = 0x1
	// Position of TXRDY field.
	USART_IDR_SPI_MODE_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	USART_IDR_SPI_MODE_TXRDY_Msk = 0x2
	// Bit TXRDY.
	USART_IDR_SPI_MODE_TXRDY = 0x2
	// Position of ENDRX field.
	USART_IDR_SPI_MODE_ENDRX_Pos = 0x3
	// Bit mask of ENDRX field.
	USART_IDR_SPI_MODE_ENDRX_Msk = 0x8
	// Bit ENDRX.
	USART_IDR_SPI_MODE_ENDRX = 0x8
	// Position of ENDTX field.
	USART_IDR_SPI_MODE_ENDTX_Pos = 0x4
	// Bit mask of ENDTX field.
	USART_IDR_SPI_MODE_ENDTX_Msk = 0x10
	// Bit ENDTX.
	USART_IDR_SPI_MODE_ENDTX = 0x10
	// Position of OVRE field.
	USART_IDR_SPI_MODE_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	USART_IDR_SPI_MODE_OVRE_Msk = 0x20
	// Bit OVRE.
	USART_IDR_SPI_MODE_OVRE = 0x20
	// Position of TXEMPTY field.
	USART_IDR_SPI_MODE_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	USART_IDR_SPI_MODE_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	USART_IDR_SPI_MODE_TXEMPTY = 0x200
	// Position of UNRE field.
	USART_IDR_SPI_MODE_UNRE_Pos = 0xa
	// Bit mask of UNRE field.
	USART_IDR_SPI_MODE_UNRE_Msk = 0x400
	// Bit UNRE.
	USART_IDR_SPI_MODE_UNRE = 0x400
	// Position of TXBUFE field.
	USART_IDR_SPI_MODE_TXBUFE_Pos = 0xb
	// Bit mask of TXBUFE field.
	USART_IDR_SPI_MODE_TXBUFE_Msk = 0x800
	// Bit TXBUFE.
	USART_IDR_SPI_MODE_TXBUFE = 0x800
	// Position of RXBUFF field.
	USART_IDR_SPI_MODE_RXBUFF_Pos = 0xc
	// Bit mask of RXBUFF field.
	USART_IDR_SPI_MODE_RXBUFF_Msk = 0x1000
	// Bit RXBUFF.
	USART_IDR_SPI_MODE_RXBUFF = 0x1000

	// IDR_LIN_MODE: Interrupt Disable Register
	// Position of RXRDY field.
	USART_IDR_LIN_MODE_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART_IDR_LIN_MODE_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART_IDR_LIN_MODE_RXRDY = 0x1
	// Position of TXRDY field.
	USART_IDR_LIN_MODE_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	USART_IDR_LIN_MODE_TXRDY_Msk = 0x2
	// Bit TXRDY.
	USART_IDR_LIN_MODE_TXRDY = 0x2
	// Position of ENDRX field.
	USART_IDR_LIN_MODE_ENDRX_Pos = 0x3
	// Bit mask of ENDRX field.
	USART_IDR_LIN_MODE_ENDRX_Msk = 0x8
	// Bit ENDRX.
	USART_IDR_LIN_MODE_ENDRX = 0x8
	// Position of ENDTX field.
	USART_IDR_LIN_MODE_ENDTX_Pos = 0x4
	// Bit mask of ENDTX field.
	USART_IDR_LIN_MODE_ENDTX_Msk = 0x10
	// Bit ENDTX.
	USART_IDR_LIN_MODE_ENDTX = 0x10
	// Position of OVRE field.
	USART_IDR_LIN_MODE_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	USART_IDR_LIN_MODE_OVRE_Msk = 0x20
	// Bit OVRE.
	USART_IDR_LIN_MODE_OVRE = 0x20
	// Position of FRAME field.
	USART_IDR_LIN_MODE_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	USART_IDR_LIN_MODE_FRAME_Msk = 0x40
	// Bit FRAME.
	USART_IDR_LIN_MODE_FRAME = 0x40
	// Position of PARE field.
	USART_IDR_LIN_MODE_PARE_Pos = 0x7
	// Bit mask of PARE field.
	USART_IDR_LIN_MODE_PARE_Msk = 0x80
	// Bit PARE.
	USART_IDR_LIN_MODE_PARE = 0x80
	// Position of TIMEOUT field.
	USART_IDR_LIN_MODE_TIMEOUT_Pos = 0x8
	// Bit mask of TIMEOUT field.
	USART_IDR_LIN_MODE_TIMEOUT_Msk = 0x100
	// Bit TIMEOUT.
	USART_IDR_LIN_MODE_TIMEOUT = 0x100
	// Position of TXEMPTY field.
	USART_IDR_LIN_MODE_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	USART_IDR_LIN_MODE_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	USART_IDR_LIN_MODE_TXEMPTY = 0x200
	// Position of TXBUFE field.
	USART_IDR_LIN_MODE_TXBUFE_Pos = 0xb
	// Bit mask of TXBUFE field.
	USART_IDR_LIN_MODE_TXBUFE_Msk = 0x800
	// Bit TXBUFE.
	USART_IDR_LIN_MODE_TXBUFE = 0x800
	// Position of RXBUFF field.
	USART_IDR_LIN_MODE_RXBUFF_Pos = 0xc
	// Bit mask of RXBUFF field.
	USART_IDR_LIN_MODE_RXBUFF_Msk = 0x1000
	// Bit RXBUFF.
	USART_IDR_LIN_MODE_RXBUFF = 0x1000
	// Position of LINBK field.
	USART_IDR_LIN_MODE_LINBK_Pos = 0xd
	// Bit mask of LINBK field.
	USART_IDR_LIN_MODE_LINBK_Msk = 0x2000
	// Bit LINBK.
	USART_IDR_LIN_MODE_LINBK = 0x2000
	// Position of LINID field.
	USART_IDR_LIN_MODE_LINID_Pos = 0xe
	// Bit mask of LINID field.
	USART_IDR_LIN_MODE_LINID_Msk = 0x4000
	// Bit LINID.
	USART_IDR_LIN_MODE_LINID = 0x4000
	// Position of LINTC field.
	USART_IDR_LIN_MODE_LINTC_Pos = 0xf
	// Bit mask of LINTC field.
	USART_IDR_LIN_MODE_LINTC_Msk = 0x8000
	// Bit LINTC.
	USART_IDR_LIN_MODE_LINTC = 0x8000
	// Position of LINBE field.
	USART_IDR_LIN_MODE_LINBE_Pos = 0x19
	// Bit mask of LINBE field.
	USART_IDR_LIN_MODE_LINBE_Msk = 0x2000000
	// Bit LINBE.
	USART_IDR_LIN_MODE_LINBE = 0x2000000
	// Position of LINISFE field.
	USART_IDR_LIN_MODE_LINISFE_Pos = 0x1a
	// Bit mask of LINISFE field.
	USART_IDR_LIN_MODE_LINISFE_Msk = 0x4000000
	// Bit LINISFE.
	USART_IDR_LIN_MODE_LINISFE = 0x4000000
	// Position of LINIPE field.
	USART_IDR_LIN_MODE_LINIPE_Pos = 0x1b
	// Bit mask of LINIPE field.
	USART_IDR_LIN_MODE_LINIPE_Msk = 0x8000000
	// Bit LINIPE.
	USART_IDR_LIN_MODE_LINIPE = 0x8000000
	// Position of LINCE field.
	USART_IDR_LIN_MODE_LINCE_Pos = 0x1c
	// Bit mask of LINCE field.
	USART_IDR_LIN_MODE_LINCE_Msk = 0x10000000
	// Bit LINCE.
	USART_IDR_LIN_MODE_LINCE = 0x10000000
	// Position of LINSNRE field.
	USART_IDR_LIN_MODE_LINSNRE_Pos = 0x1d
	// Bit mask of LINSNRE field.
	USART_IDR_LIN_MODE_LINSNRE_Msk = 0x20000000
	// Bit LINSNRE.
	USART_IDR_LIN_MODE_LINSNRE = 0x20000000

	// IMR: Interrupt Mask Register
	// Position of RXRDY field.
	USART_IMR_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART_IMR_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART_IMR_RXRDY = 0x1
	// Position of TXRDY field.
	USART_IMR_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	USART_IMR_TXRDY_Msk = 0x2
	// Bit TXRDY.
	USART_IMR_TXRDY = 0x2
	// Position of RXBRK field.
	USART_IMR_RXBRK_Pos = 0x2
	// Bit mask of RXBRK field.
	USART_IMR_RXBRK_Msk = 0x4
	// Bit RXBRK.
	USART_IMR_RXBRK = 0x4
	// Position of ENDRX field.
	USART_IMR_ENDRX_Pos = 0x3
	// Bit mask of ENDRX field.
	USART_IMR_ENDRX_Msk = 0x8
	// Bit ENDRX.
	USART_IMR_ENDRX = 0x8
	// Position of ENDTX field.
	USART_IMR_ENDTX_Pos = 0x4
	// Bit mask of ENDTX field.
	USART_IMR_ENDTX_Msk = 0x10
	// Bit ENDTX.
	USART_IMR_ENDTX = 0x10
	// Position of OVRE field.
	USART_IMR_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	USART_IMR_OVRE_Msk = 0x20
	// Bit OVRE.
	USART_IMR_OVRE = 0x20
	// Position of FRAME field.
	USART_IMR_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	USART_IMR_FRAME_Msk = 0x40
	// Bit FRAME.
	USART_IMR_FRAME = 0x40
	// Position of PARE field.
	USART_IMR_PARE_Pos = 0x7
	// Bit mask of PARE field.
	USART_IMR_PARE_Msk = 0x80
	// Bit PARE.
	USART_IMR_PARE = 0x80
	// Position of TIMEOUT field.
	USART_IMR_TIMEOUT_Pos = 0x8
	// Bit mask of TIMEOUT field.
	USART_IMR_TIMEOUT_Msk = 0x100
	// Bit TIMEOUT.
	USART_IMR_TIMEOUT = 0x100
	// Position of TXEMPTY field.
	USART_IMR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	USART_IMR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	USART_IMR_TXEMPTY = 0x200
	// Position of ITER field.
	USART_IMR_ITER_Pos = 0xa
	// Bit mask of ITER field.
	USART_IMR_ITER_Msk = 0x400
	// Bit ITER.
	USART_IMR_ITER = 0x400
	// Position of TXBUFE field.
	USART_IMR_TXBUFE_Pos = 0xb
	// Bit mask of TXBUFE field.
	USART_IMR_TXBUFE_Msk = 0x800
	// Bit TXBUFE.
	USART_IMR_TXBUFE = 0x800
	// Position of RXBUFF field.
	USART_IMR_RXBUFF_Pos = 0xc
	// Bit mask of RXBUFF field.
	USART_IMR_RXBUFF_Msk = 0x1000
	// Bit RXBUFF.
	USART_IMR_RXBUFF = 0x1000
	// Position of NACK field.
	USART_IMR_NACK_Pos = 0xd
	// Bit mask of NACK field.
	USART_IMR_NACK_Msk = 0x2000
	// Bit NACK.
	USART_IMR_NACK = 0x2000
	// Position of CTSIC field.
	USART_IMR_CTSIC_Pos = 0x13
	// Bit mask of CTSIC field.
	USART_IMR_CTSIC_Msk = 0x80000
	// Bit CTSIC.
	USART_IMR_CTSIC = 0x80000
	// Position of MANE field.
	USART_IMR_MANE_Pos = 0x18
	// Bit mask of MANE field.
	USART_IMR_MANE_Msk = 0x1000000
	// Bit MANE.
	USART_IMR_MANE = 0x1000000

	// IMR_SPI_MODE: Interrupt Mask Register
	// Position of RXRDY field.
	USART_IMR_SPI_MODE_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART_IMR_SPI_MODE_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART_IMR_SPI_MODE_RXRDY = 0x1
	// Position of TXRDY field.
	USART_IMR_SPI_MODE_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	USART_IMR_SPI_MODE_TXRDY_Msk = 0x2
	// Bit TXRDY.
	USART_IMR_SPI_MODE_TXRDY = 0x2
	// Position of ENDRX field.
	USART_IMR_SPI_MODE_ENDRX_Pos = 0x3
	// Bit mask of ENDRX field.
	USART_IMR_SPI_MODE_ENDRX_Msk = 0x8
	// Bit ENDRX.
	USART_IMR_SPI_MODE_ENDRX = 0x8
	// Position of ENDTX field.
	USART_IMR_SPI_MODE_ENDTX_Pos = 0x4
	// Bit mask of ENDTX field.
	USART_IMR_SPI_MODE_ENDTX_Msk = 0x10
	// Bit ENDTX.
	USART_IMR_SPI_MODE_ENDTX = 0x10
	// Position of OVRE field.
	USART_IMR_SPI_MODE_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	USART_IMR_SPI_MODE_OVRE_Msk = 0x20
	// Bit OVRE.
	USART_IMR_SPI_MODE_OVRE = 0x20
	// Position of TXEMPTY field.
	USART_IMR_SPI_MODE_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	USART_IMR_SPI_MODE_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	USART_IMR_SPI_MODE_TXEMPTY = 0x200
	// Position of UNRE field.
	USART_IMR_SPI_MODE_UNRE_Pos = 0xa
	// Bit mask of UNRE field.
	USART_IMR_SPI_MODE_UNRE_Msk = 0x400
	// Bit UNRE.
	USART_IMR_SPI_MODE_UNRE = 0x400
	// Position of TXBUFE field.
	USART_IMR_SPI_MODE_TXBUFE_Pos = 0xb
	// Bit mask of TXBUFE field.
	USART_IMR_SPI_MODE_TXBUFE_Msk = 0x800
	// Bit TXBUFE.
	USART_IMR_SPI_MODE_TXBUFE = 0x800
	// Position of RXBUFF field.
	USART_IMR_SPI_MODE_RXBUFF_Pos = 0xc
	// Bit mask of RXBUFF field.
	USART_IMR_SPI_MODE_RXBUFF_Msk = 0x1000
	// Bit RXBUFF.
	USART_IMR_SPI_MODE_RXBUFF = 0x1000

	// IMR_LIN_MODE: Interrupt Mask Register
	// Position of RXRDY field.
	USART_IMR_LIN_MODE_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART_IMR_LIN_MODE_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART_IMR_LIN_MODE_RXRDY = 0x1
	// Position of TXRDY field.
	USART_IMR_LIN_MODE_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	USART_IMR_LIN_MODE_TXRDY_Msk = 0x2
	// Bit TXRDY.
	USART_IMR_LIN_MODE_TXRDY = 0x2
	// Position of ENDRX field.
	USART_IMR_LIN_MODE_ENDRX_Pos = 0x3
	// Bit mask of ENDRX field.
	USART_IMR_LIN_MODE_ENDRX_Msk = 0x8
	// Bit ENDRX.
	USART_IMR_LIN_MODE_ENDRX = 0x8
	// Position of ENDTX field.
	USART_IMR_LIN_MODE_ENDTX_Pos = 0x4
	// Bit mask of ENDTX field.
	USART_IMR_LIN_MODE_ENDTX_Msk = 0x10
	// Bit ENDTX.
	USART_IMR_LIN_MODE_ENDTX = 0x10
	// Position of OVRE field.
	USART_IMR_LIN_MODE_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	USART_IMR_LIN_MODE_OVRE_Msk = 0x20
	// Bit OVRE.
	USART_IMR_LIN_MODE_OVRE = 0x20
	// Position of FRAME field.
	USART_IMR_LIN_MODE_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	USART_IMR_LIN_MODE_FRAME_Msk = 0x40
	// Bit FRAME.
	USART_IMR_LIN_MODE_FRAME = 0x40
	// Position of PARE field.
	USART_IMR_LIN_MODE_PARE_Pos = 0x7
	// Bit mask of PARE field.
	USART_IMR_LIN_MODE_PARE_Msk = 0x80
	// Bit PARE.
	USART_IMR_LIN_MODE_PARE = 0x80
	// Position of TIMEOUT field.
	USART_IMR_LIN_MODE_TIMEOUT_Pos = 0x8
	// Bit mask of TIMEOUT field.
	USART_IMR_LIN_MODE_TIMEOUT_Msk = 0x100
	// Bit TIMEOUT.
	USART_IMR_LIN_MODE_TIMEOUT = 0x100
	// Position of TXEMPTY field.
	USART_IMR_LIN_MODE_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	USART_IMR_LIN_MODE_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	USART_IMR_LIN_MODE_TXEMPTY = 0x200
	// Position of TXBUFE field.
	USART_IMR_LIN_MODE_TXBUFE_Pos = 0xb
	// Bit mask of TXBUFE field.
	USART_IMR_LIN_MODE_TXBUFE_Msk = 0x800
	// Bit TXBUFE.
	USART_IMR_LIN_MODE_TXBUFE = 0x800
	// Position of RXBUFF field.
	USART_IMR_LIN_MODE_RXBUFF_Pos = 0xc
	// Bit mask of RXBUFF field.
	USART_IMR_LIN_MODE_RXBUFF_Msk = 0x1000
	// Bit RXBUFF.
	USART_IMR_LIN_MODE_RXBUFF = 0x1000
	// Position of LINBK field.
	USART_IMR_LIN_MODE_LINBK_Pos = 0xd
	// Bit mask of LINBK field.
	USART_IMR_LIN_MODE_LINBK_Msk = 0x2000
	// Bit LINBK.
	USART_IMR_LIN_MODE_LINBK = 0x2000
	// Position of LINID field.
	USART_IMR_LIN_MODE_LINID_Pos = 0xe
	// Bit mask of LINID field.
	USART_IMR_LIN_MODE_LINID_Msk = 0x4000
	// Bit LINID.
	USART_IMR_LIN_MODE_LINID = 0x4000
	// Position of LINTC field.
	USART_IMR_LIN_MODE_LINTC_Pos = 0xf
	// Bit mask of LINTC field.
	USART_IMR_LIN_MODE_LINTC_Msk = 0x8000
	// Bit LINTC.
	USART_IMR_LIN_MODE_LINTC = 0x8000
	// Position of LINBE field.
	USART_IMR_LIN_MODE_LINBE_Pos = 0x19
	// Bit mask of LINBE field.
	USART_IMR_LIN_MODE_LINBE_Msk = 0x2000000
	// Bit LINBE.
	USART_IMR_LIN_MODE_LINBE = 0x2000000
	// Position of LINISFE field.
	USART_IMR_LIN_MODE_LINISFE_Pos = 0x1a
	// Bit mask of LINISFE field.
	USART_IMR_LIN_MODE_LINISFE_Msk = 0x4000000
	// Bit LINISFE.
	USART_IMR_LIN_MODE_LINISFE = 0x4000000
	// Position of LINIPE field.
	USART_IMR_LIN_MODE_LINIPE_Pos = 0x1b
	// Bit mask of LINIPE field.
	USART_IMR_LIN_MODE_LINIPE_Msk = 0x8000000
	// Bit LINIPE.
	USART_IMR_LIN_MODE_LINIPE = 0x8000000
	// Position of LINCE field.
	USART_IMR_LIN_MODE_LINCE_Pos = 0x1c
	// Bit mask of LINCE field.
	USART_IMR_LIN_MODE_LINCE_Msk = 0x10000000
	// Bit LINCE.
	USART_IMR_LIN_MODE_LINCE = 0x10000000
	// Position of LINSNRE field.
	USART_IMR_LIN_MODE_LINSNRE_Pos = 0x1d
	// Bit mask of LINSNRE field.
	USART_IMR_LIN_MODE_LINSNRE_Msk = 0x20000000
	// Bit LINSNRE.
	USART_IMR_LIN_MODE_LINSNRE = 0x20000000

	// CSR: Channel Status Register
	// Position of RXRDY field.
	USART_CSR_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART_CSR_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART_CSR_RXRDY = 0x1
	// Position of TXRDY field.
	USART_CSR_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	USART_CSR_TXRDY_Msk = 0x2
	// Bit TXRDY.
	USART_CSR_TXRDY = 0x2
	// Position of RXBRK field.
	USART_CSR_RXBRK_Pos = 0x2
	// Bit mask of RXBRK field.
	USART_CSR_RXBRK_Msk = 0x4
	// Bit RXBRK.
	USART_CSR_RXBRK = 0x4
	// Position of ENDRX field.
	USART_CSR_ENDRX_Pos = 0x3
	// Bit mask of ENDRX field.
	USART_CSR_ENDRX_Msk = 0x8
	// Bit ENDRX.
	USART_CSR_ENDRX = 0x8
	// Position of ENDTX field.
	USART_CSR_ENDTX_Pos = 0x4
	// Bit mask of ENDTX field.
	USART_CSR_ENDTX_Msk = 0x10
	// Bit ENDTX.
	USART_CSR_ENDTX = 0x10
	// Position of OVRE field.
	USART_CSR_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	USART_CSR_OVRE_Msk = 0x20
	// Bit OVRE.
	USART_CSR_OVRE = 0x20
	// Position of FRAME field.
	USART_CSR_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	USART_CSR_FRAME_Msk = 0x40
	// Bit FRAME.
	USART_CSR_FRAME = 0x40
	// Position of PARE field.
	USART_CSR_PARE_Pos = 0x7
	// Bit mask of PARE field.
	USART_CSR_PARE_Msk = 0x80
	// Bit PARE.
	USART_CSR_PARE = 0x80
	// Position of TIMEOUT field.
	USART_CSR_TIMEOUT_Pos = 0x8
	// Bit mask of TIMEOUT field.
	USART_CSR_TIMEOUT_Msk = 0x100
	// Bit TIMEOUT.
	USART_CSR_TIMEOUT = 0x100
	// Position of TXEMPTY field.
	USART_CSR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	USART_CSR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	USART_CSR_TXEMPTY = 0x200
	// Position of ITER field.
	USART_CSR_ITER_Pos = 0xa
	// Bit mask of ITER field.
	USART_CSR_ITER_Msk = 0x400
	// Bit ITER.
	USART_CSR_ITER = 0x400
	// Position of TXBUFE field.
	USART_CSR_TXBUFE_Pos = 0xb
	// Bit mask of TXBUFE field.
	USART_CSR_TXBUFE_Msk = 0x800
	// Bit TXBUFE.
	USART_CSR_TXBUFE = 0x800
	// Position of RXBUFF field.
	USART_CSR_RXBUFF_Pos = 0xc
	// Bit mask of RXBUFF field.
	USART_CSR_RXBUFF_Msk = 0x1000
	// Bit RXBUFF.
	USART_CSR_RXBUFF = 0x1000
	// Position of NACK field.
	USART_CSR_NACK_Pos = 0xd
	// Bit mask of NACK field.
	USART_CSR_NACK_Msk = 0x2000
	// Bit NACK.
	USART_CSR_NACK = 0x2000
	// Position of CTSIC field.
	USART_CSR_CTSIC_Pos = 0x13
	// Bit mask of CTSIC field.
	USART_CSR_CTSIC_Msk = 0x80000
	// Bit CTSIC.
	USART_CSR_CTSIC = 0x80000
	// Position of CTS field.
	USART_CSR_CTS_Pos = 0x17
	// Bit mask of CTS field.
	USART_CSR_CTS_Msk = 0x800000
	// Bit CTS.
	USART_CSR_CTS = 0x800000
	// Position of MANERR field.
	USART_CSR_MANERR_Pos = 0x18
	// Bit mask of MANERR field.
	USART_CSR_MANERR_Msk = 0x1000000
	// Bit MANERR.
	USART_CSR_MANERR = 0x1000000

	// CSR_SPI_MODE: Channel Status Register
	// Position of RXRDY field.
	USART_CSR_SPI_MODE_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART_CSR_SPI_MODE_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART_CSR_SPI_MODE_RXRDY = 0x1
	// Position of TXRDY field.
	USART_CSR_SPI_MODE_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	USART_CSR_SPI_MODE_TXRDY_Msk = 0x2
	// Bit TXRDY.
	USART_CSR_SPI_MODE_TXRDY = 0x2
	// Position of ENDRX field.
	USART_CSR_SPI_MODE_ENDRX_Pos = 0x3
	// Bit mask of ENDRX field.
	USART_CSR_SPI_MODE_ENDRX_Msk = 0x8
	// Bit ENDRX.
	USART_CSR_SPI_MODE_ENDRX = 0x8
	// Position of ENDTX field.
	USART_CSR_SPI_MODE_ENDTX_Pos = 0x4
	// Bit mask of ENDTX field.
	USART_CSR_SPI_MODE_ENDTX_Msk = 0x10
	// Bit ENDTX.
	USART_CSR_SPI_MODE_ENDTX = 0x10
	// Position of OVRE field.
	USART_CSR_SPI_MODE_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	USART_CSR_SPI_MODE_OVRE_Msk = 0x20
	// Bit OVRE.
	USART_CSR_SPI_MODE_OVRE = 0x20
	// Position of TXEMPTY field.
	USART_CSR_SPI_MODE_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	USART_CSR_SPI_MODE_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	USART_CSR_SPI_MODE_TXEMPTY = 0x200
	// Position of UNRE field.
	USART_CSR_SPI_MODE_UNRE_Pos = 0xa
	// Bit mask of UNRE field.
	USART_CSR_SPI_MODE_UNRE_Msk = 0x400
	// Bit UNRE.
	USART_CSR_SPI_MODE_UNRE = 0x400
	// Position of TXBUFE field.
	USART_CSR_SPI_MODE_TXBUFE_Pos = 0xb
	// Bit mask of TXBUFE field.
	USART_CSR_SPI_MODE_TXBUFE_Msk = 0x800
	// Bit TXBUFE.
	USART_CSR_SPI_MODE_TXBUFE = 0x800
	// Position of RXBUFF field.
	USART_CSR_SPI_MODE_RXBUFF_Pos = 0xc
	// Bit mask of RXBUFF field.
	USART_CSR_SPI_MODE_RXBUFF_Msk = 0x1000
	// Bit RXBUFF.
	USART_CSR_SPI_MODE_RXBUFF = 0x1000

	// CSR_LIN_MODE: Channel Status Register
	// Position of RXRDY field.
	USART_CSR_LIN_MODE_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART_CSR_LIN_MODE_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART_CSR_LIN_MODE_RXRDY = 0x1
	// Position of TXRDY field.
	USART_CSR_LIN_MODE_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	USART_CSR_LIN_MODE_TXRDY_Msk = 0x2
	// Bit TXRDY.
	USART_CSR_LIN_MODE_TXRDY = 0x2
	// Position of ENDRX field.
	USART_CSR_LIN_MODE_ENDRX_Pos = 0x3
	// Bit mask of ENDRX field.
	USART_CSR_LIN_MODE_ENDRX_Msk = 0x8
	// Bit ENDRX.
	USART_CSR_LIN_MODE_ENDRX = 0x8
	// Position of ENDTX field.
	USART_CSR_LIN_MODE_ENDTX_Pos = 0x4
	// Bit mask of ENDTX field.
	USART_CSR_LIN_MODE_ENDTX_Msk = 0x10
	// Bit ENDTX.
	USART_CSR_LIN_MODE_ENDTX = 0x10
	// Position of OVRE field.
	USART_CSR_LIN_MODE_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	USART_CSR_LIN_MODE_OVRE_Msk = 0x20
	// Bit OVRE.
	USART_CSR_LIN_MODE_OVRE = 0x20
	// Position of FRAME field.
	USART_CSR_LIN_MODE_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	USART_CSR_LIN_MODE_FRAME_Msk = 0x40
	// Bit FRAME.
	USART_CSR_LIN_MODE_FRAME = 0x40
	// Position of PARE field.
	USART_CSR_LIN_MODE_PARE_Pos = 0x7
	// Bit mask of PARE field.
	USART_CSR_LIN_MODE_PARE_Msk = 0x80
	// Bit PARE.
	USART_CSR_LIN_MODE_PARE = 0x80
	// Position of TIMEOUT field.
	USART_CSR_LIN_MODE_TIMEOUT_Pos = 0x8
	// Bit mask of TIMEOUT field.
	USART_CSR_LIN_MODE_TIMEOUT_Msk = 0x100
	// Bit TIMEOUT.
	USART_CSR_LIN_MODE_TIMEOUT = 0x100
	// Position of TXEMPTY field.
	USART_CSR_LIN_MODE_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	USART_CSR_LIN_MODE_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	USART_CSR_LIN_MODE_TXEMPTY = 0x200
	// Position of TXBUFE field.
	USART_CSR_LIN_MODE_TXBUFE_Pos = 0xb
	// Bit mask of TXBUFE field.
	USART_CSR_LIN_MODE_TXBUFE_Msk = 0x800
	// Bit TXBUFE.
	USART_CSR_LIN_MODE_TXBUFE = 0x800
	// Position of RXBUFF field.
	USART_CSR_LIN_MODE_RXBUFF_Pos = 0xc
	// Bit mask of RXBUFF field.
	USART_CSR_LIN_MODE_RXBUFF_Msk = 0x1000
	// Bit RXBUFF.
	USART_CSR_LIN_MODE_RXBUFF = 0x1000
	// Position of LINBK field.
	USART_CSR_LIN_MODE_LINBK_Pos = 0xd
	// Bit mask of LINBK field.
	USART_CSR_LIN_MODE_LINBK_Msk = 0x2000
	// Bit LINBK.
	USART_CSR_LIN_MODE_LINBK = 0x2000
	// Position of LINID field.
	USART_CSR_LIN_MODE_LINID_Pos = 0xe
	// Bit mask of LINID field.
	USART_CSR_LIN_MODE_LINID_Msk = 0x4000
	// Bit LINID.
	USART_CSR_LIN_MODE_LINID = 0x4000
	// Position of LINTC field.
	USART_CSR_LIN_MODE_LINTC_Pos = 0xf
	// Bit mask of LINTC field.
	USART_CSR_LIN_MODE_LINTC_Msk = 0x8000
	// Bit LINTC.
	USART_CSR_LIN_MODE_LINTC = 0x8000
	// Position of LINBLS field.
	USART_CSR_LIN_MODE_LINBLS_Pos = 0x17
	// Bit mask of LINBLS field.
	USART_CSR_LIN_MODE_LINBLS_Msk = 0x800000
	// Bit LINBLS.
	USART_CSR_LIN_MODE_LINBLS = 0x800000
	// Position of LINBE field.
	USART_CSR_LIN_MODE_LINBE_Pos = 0x19
	// Bit mask of LINBE field.
	USART_CSR_LIN_MODE_LINBE_Msk = 0x2000000
	// Bit LINBE.
	USART_CSR_LIN_MODE_LINBE = 0x2000000
	// Position of LINISFE field.
	USART_CSR_LIN_MODE_LINISFE_Pos = 0x1a
	// Bit mask of LINISFE field.
	USART_CSR_LIN_MODE_LINISFE_Msk = 0x4000000
	// Bit LINISFE.
	USART_CSR_LIN_MODE_LINISFE = 0x4000000
	// Position of LINIPE field.
	USART_CSR_LIN_MODE_LINIPE_Pos = 0x1b
	// Bit mask of LINIPE field.
	USART_CSR_LIN_MODE_LINIPE_Msk = 0x8000000
	// Bit LINIPE.
	USART_CSR_LIN_MODE_LINIPE = 0x8000000
	// Position of LINCE field.
	USART_CSR_LIN_MODE_LINCE_Pos = 0x1c
	// Bit mask of LINCE field.
	USART_CSR_LIN_MODE_LINCE_Msk = 0x10000000
	// Bit LINCE.
	USART_CSR_LIN_MODE_LINCE = 0x10000000
	// Position of LINSNRE field.
	USART_CSR_LIN_MODE_LINSNRE_Pos = 0x1d
	// Bit mask of LINSNRE field.
	USART_CSR_LIN_MODE_LINSNRE_Msk = 0x20000000
	// Bit LINSNRE.
	USART_CSR_LIN_MODE_LINSNRE = 0x20000000

	// RHR: Receive Holding Register
	// Position of RXCHR field.
	USART_RHR_RXCHR_Pos = 0x0
	// Bit mask of RXCHR field.
	USART_RHR_RXCHR_Msk = 0x1ff
	// Position of RXSYNH field.
	USART_RHR_RXSYNH_Pos = 0xf
	// Bit mask of RXSYNH field.
	USART_RHR_RXSYNH_Msk = 0x8000
	// Bit RXSYNH.
	USART_RHR_RXSYNH = 0x8000

	// THR: Transmit Holding Register
	// Position of TXCHR field.
	USART_THR_TXCHR_Pos = 0x0
	// Bit mask of TXCHR field.
	USART_THR_TXCHR_Msk = 0x1ff
	// Position of TXSYNH field.
	USART_THR_TXSYNH_Pos = 0xf
	// Bit mask of TXSYNH field.
	USART_THR_TXSYNH_Msk = 0x8000
	// Bit TXSYNH.
	USART_THR_TXSYNH = 0x8000

	// BRGR: Baud Rate Generator Register
	// Position of CD field.
	USART_BRGR_CD_Pos = 0x0
	// Bit mask of CD field.
	USART_BRGR_CD_Msk = 0xffff
	// Position of FP field.
	USART_BRGR_FP_Pos = 0x10
	// Bit mask of FP field.
	USART_BRGR_FP_Msk = 0x70000

	// RTOR: Receiver Time-out Register
	// Position of TO field.
	USART_RTOR_TO_Pos = 0x0
	// Bit mask of TO field.
	USART_RTOR_TO_Msk = 0x1ffff

	// TTGR: Transmitter Timeguard Register
	// Position of TG field.
	USART_TTGR_TG_Pos = 0x0
	// Bit mask of TG field.
	USART_TTGR_TG_Msk = 0xff

	// FIDI: FI DI Ratio Register
	// Position of FI_DI_RATIO field.
	USART_FIDI_FI_DI_RATIO_Pos = 0x0
	// Bit mask of FI_DI_RATIO field.
	USART_FIDI_FI_DI_RATIO_Msk = 0x7ff

	// NER: Number of Errors Register
	// Position of NB_ERRORS field.
	USART_NER_NB_ERRORS_Pos = 0x0
	// Bit mask of NB_ERRORS field.
	USART_NER_NB_ERRORS_Msk = 0xff

	// IF: IrDA Filter Register
	// Position of IRDA_FILTER field.
	USART_IF_IRDA_FILTER_Pos = 0x0
	// Bit mask of IRDA_FILTER field.
	USART_IF_IRDA_FILTER_Msk = 0xff

	// MAN: Manchester Configuration Register
	// Position of TX_PL field.
	USART_MAN_TX_PL_Pos = 0x0
	// Bit mask of TX_PL field.
	USART_MAN_TX_PL_Msk = 0xf
	// Position of TX_PP field.
	USART_MAN_TX_PP_Pos = 0x8
	// Bit mask of TX_PP field.
	USART_MAN_TX_PP_Msk = 0x300
	// The preamble is composed of '1's
	USART_MAN_TX_PP_ALL_ONE = 0x0
	// The preamble is composed of '0's
	USART_MAN_TX_PP_ALL_ZERO = 0x1
	// The preamble is composed of '01's
	USART_MAN_TX_PP_ZERO_ONE = 0x2
	// The preamble is composed of '10's
	USART_MAN_TX_PP_ONE_ZERO = 0x3
	// Position of TX_MPOL field.
	USART_MAN_TX_MPOL_Pos = 0xc
	// Bit mask of TX_MPOL field.
	USART_MAN_TX_MPOL_Msk = 0x1000
	// Bit TX_MPOL.
	USART_MAN_TX_MPOL = 0x1000
	// Position of RX_PL field.
	USART_MAN_RX_PL_Pos = 0x10
	// Bit mask of RX_PL field.
	USART_MAN_RX_PL_Msk = 0xf0000
	// Position of RX_PP field.
	USART_MAN_RX_PP_Pos = 0x18
	// Bit mask of RX_PP field.
	USART_MAN_RX_PP_Msk = 0x3000000
	// The preamble is composed of '1's
	USART_MAN_RX_PP_ALL_ONE = 0x0
	// The preamble is composed of '0's
	USART_MAN_RX_PP_ALL_ZERO = 0x1
	// The preamble is composed of '01's
	USART_MAN_RX_PP_ZERO_ONE = 0x2
	// The preamble is composed of '10's
	USART_MAN_RX_PP_ONE_ZERO = 0x3
	// Position of RX_MPOL field.
	USART_MAN_RX_MPOL_Pos = 0x1c
	// Bit mask of RX_MPOL field.
	USART_MAN_RX_MPOL_Msk = 0x10000000
	// Bit RX_MPOL.
	USART_MAN_RX_MPOL = 0x10000000
	// Position of ONE field.
	USART_MAN_ONE_Pos = 0x1d
	// Bit mask of ONE field.
	USART_MAN_ONE_Msk = 0x20000000
	// Bit ONE.
	USART_MAN_ONE = 0x20000000
	// Position of DRIFT field.
	USART_MAN_DRIFT_Pos = 0x1e
	// Bit mask of DRIFT field.
	USART_MAN_DRIFT_Msk = 0x40000000
	// Bit DRIFT.
	USART_MAN_DRIFT = 0x40000000

	// LINMR: LIN Mode Register
	// Position of NACT field.
	USART_LINMR_NACT_Pos = 0x0
	// Bit mask of NACT field.
	USART_LINMR_NACT_Msk = 0x3
	// The USART transmits the response.
	USART_LINMR_NACT_PUBLISH = 0x0
	// The USART receives the response.
	USART_LINMR_NACT_SUBSCRIBE = 0x1
	// The USART does not transmit and does not receive the response.
	USART_LINMR_NACT_IGNORE = 0x2
	// Position of PARDIS field.
	USART_LINMR_PARDIS_Pos = 0x2
	// Bit mask of PARDIS field.
	USART_LINMR_PARDIS_Msk = 0x4
	// Bit PARDIS.
	USART_LINMR_PARDIS = 0x4
	// Position of CHKDIS field.
	USART_LINMR_CHKDIS_Pos = 0x3
	// Bit mask of CHKDIS field.
	USART_LINMR_CHKDIS_Msk = 0x8
	// Bit CHKDIS.
	USART_LINMR_CHKDIS = 0x8
	// Position of CHKTYP field.
	USART_LINMR_CHKTYP_Pos = 0x4
	// Bit mask of CHKTYP field.
	USART_LINMR_CHKTYP_Msk = 0x10
	// Bit CHKTYP.
	USART_LINMR_CHKTYP = 0x10
	// Position of DLM field.
	USART_LINMR_DLM_Pos = 0x5
	// Bit mask of DLM field.
	USART_LINMR_DLM_Msk = 0x20
	// Bit DLM.
	USART_LINMR_DLM = 0x20
	// Position of FSDIS field.
	USART_LINMR_FSDIS_Pos = 0x6
	// Bit mask of FSDIS field.
	USART_LINMR_FSDIS_Msk = 0x40
	// Bit FSDIS.
	USART_LINMR_FSDIS = 0x40
	// Position of WKUPTYP field.
	USART_LINMR_WKUPTYP_Pos = 0x7
	// Bit mask of WKUPTYP field.
	USART_LINMR_WKUPTYP_Msk = 0x80
	// Bit WKUPTYP.
	USART_LINMR_WKUPTYP = 0x80
	// Position of DLC field.
	USART_LINMR_DLC_Pos = 0x8
	// Bit mask of DLC field.
	USART_LINMR_DLC_Msk = 0xff00
	// Position of PDCM field.
	USART_LINMR_PDCM_Pos = 0x10
	// Bit mask of PDCM field.
	USART_LINMR_PDCM_Msk = 0x10000
	// Bit PDCM.
	USART_LINMR_PDCM = 0x10000

	// LINIR: LIN Identifier Register
	// Position of IDCHR field.
	USART_LINIR_IDCHR_Pos = 0x0
	// Bit mask of IDCHR field.
	USART_LINIR_IDCHR_Msk = 0xff

	// LINBRR: LIN Baud Rate Register
	// Position of LINCD field.
	USART_LINBRR_LINCD_Pos = 0x0
	// Bit mask of LINCD field.
	USART_LINBRR_LINCD_Msk = 0xffff
	// Position of LINFP field.
	USART_LINBRR_LINFP_Pos = 0x10
	// Bit mask of LINFP field.
	USART_LINBRR_LINFP_Msk = 0x70000

	// WPMR: Write Protection Mode Register
	// Position of WPEN field.
	USART_WPMR_WPEN_Pos = 0x0
	// Bit mask of WPEN field.
	USART_WPMR_WPEN_Msk = 0x1
	// Bit WPEN.
	USART_WPMR_WPEN = 0x1
	// Position of WPKEY field.
	USART_WPMR_WPKEY_Pos = 0x8
	// Bit mask of WPKEY field.
	USART_WPMR_WPKEY_Msk = 0xffffff00
	// Writing any other value in this field aborts the write operation of the WPEN bit. Always reads as 0.
	USART_WPMR_WPKEY_PASSWD = 0x555341

	// WPSR: Write Protection Status Register
	// Position of WPVS field.
	USART_WPSR_WPVS_Pos = 0x0
	// Bit mask of WPVS field.
	USART_WPSR_WPVS_Msk = 0x1
	// Bit WPVS.
	USART_WPSR_WPVS = 0x1
	// Position of WPVSRC field.
	USART_WPSR_WPVSRC_Pos = 0x8
	// Bit mask of WPVSRC field.
	USART_WPSR_WPVSRC_Msk = 0xffff00

	// RPR: Receive Pointer Register
	// Position of RXPTR field.
	USART_RPR_RXPTR_Pos = 0x0
	// Bit mask of RXPTR field.
	USART_RPR_RXPTR_Msk = 0xffffffff

	// RCR: Receive Counter Register
	// Position of RXCTR field.
	USART_RCR_RXCTR_Pos = 0x0
	// Bit mask of RXCTR field.
	USART_RCR_RXCTR_Msk = 0xffff

	// TPR: Transmit Pointer Register
	// Position of TXPTR field.
	USART_TPR_TXPTR_Pos = 0x0
	// Bit mask of TXPTR field.
	USART_TPR_TXPTR_Msk = 0xffffffff

	// TCR: Transmit Counter Register
	// Position of TXCTR field.
	USART_TCR_TXCTR_Pos = 0x0
	// Bit mask of TXCTR field.
	USART_TCR_TXCTR_Msk = 0xffff

	// RNPR: Receive Next Pointer Register
	// Position of RXNPTR field.
	USART_RNPR_RXNPTR_Pos = 0x0
	// Bit mask of RXNPTR field.
	USART_RNPR_RXNPTR_Msk = 0xffffffff

	// RNCR: Receive Next Counter Register
	// Position of RXNCTR field.
	USART_RNCR_RXNCTR_Pos = 0x0
	// Bit mask of RXNCTR field.
	USART_RNCR_RXNCTR_Msk = 0xffff

	// TNPR: Transmit Next Pointer Register
	// Position of TXNPTR field.
	USART_TNPR_TXNPTR_Pos = 0x0
	// Bit mask of TXNPTR field.
	USART_TNPR_TXNPTR_Msk = 0xffffffff

	// TNCR: Transmit Next Counter Register
	// Position of TXNCTR field.
	USART_TNCR_TXNCTR_Pos = 0x0
	// Bit mask of TXNCTR field.
	USART_TNCR_TXNCTR_Msk = 0xffff

	// PTCR: Transfer Control Register
	// Position of RXTEN field.
	USART_PTCR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	USART_PTCR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	USART_PTCR_RXTEN = 0x1
	// Position of RXTDIS field.
	USART_PTCR_RXTDIS_Pos = 0x1
	// Bit mask of RXTDIS field.
	USART_PTCR_RXTDIS_Msk = 0x2
	// Bit RXTDIS.
	USART_PTCR_RXTDIS = 0x2
	// Position of TXTEN field.
	USART_PTCR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	USART_PTCR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	USART_PTCR_TXTEN = 0x100
	// Position of TXTDIS field.
	USART_PTCR_TXTDIS_Pos = 0x9
	// Bit mask of TXTDIS field.
	USART_PTCR_TXTDIS_Msk = 0x200
	// Bit TXTDIS.
	USART_PTCR_TXTDIS = 0x200

	// PTSR: Transfer Status Register
	// Position of RXTEN field.
	USART_PTSR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	USART_PTSR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	USART_PTSR_RXTEN = 0x1
	// Position of TXTEN field.
	USART_PTSR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	USART_PTSR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	USART_PTSR_TXTEN = 0x100
)

// Bitfields for UOTGHS: USB On-The-Go Interface
const (
	// DEVCTRL: Device General Control Register
	// Position of UADD field.
	UOTGHS_DEVCTRL_UADD_Pos = 0x0
	// Bit mask of UADD field.
	UOTGHS_DEVCTRL_UADD_Msk = 0x7f
	// Position of ADDEN field.
	UOTGHS_DEVCTRL_ADDEN_Pos = 0x7
	// Bit mask of ADDEN field.
	UOTGHS_DEVCTRL_ADDEN_Msk = 0x80
	// Bit ADDEN.
	UOTGHS_DEVCTRL_ADDEN = 0x80
	// Position of DETACH field.
	UOTGHS_DEVCTRL_DETACH_Pos = 0x8
	// Bit mask of DETACH field.
	UOTGHS_DEVCTRL_DETACH_Msk = 0x100
	// Bit DETACH.
	UOTGHS_DEVCTRL_DETACH = 0x100
	// Position of RMWKUP field.
	UOTGHS_DEVCTRL_RMWKUP_Pos = 0x9
	// Bit mask of RMWKUP field.
	UOTGHS_DEVCTRL_RMWKUP_Msk = 0x200
	// Bit RMWKUP.
	UOTGHS_DEVCTRL_RMWKUP = 0x200
	// Position of SPDCONF field.
	UOTGHS_DEVCTRL_SPDCONF_Pos = 0xa
	// Bit mask of SPDCONF field.
	UOTGHS_DEVCTRL_SPDCONF_Msk = 0xc00
	// The peripheral starts in full-speed mode and performs a high-speed reset to switch to the high-speed mode if the host is high-speed capable.
	UOTGHS_DEVCTRL_SPDCONF_NORMAL = 0x0
	// For a better consumption, if high-speed is not needed.
	UOTGHS_DEVCTRL_SPDCONF_LOW_POWER = 0x1
	// Forced high speed.
	UOTGHS_DEVCTRL_SPDCONF_HIGH_SPEED = 0x2
	// The peripheral remains in full-speed mode whatever the host speed capability.
	UOTGHS_DEVCTRL_SPDCONF_FORCED_FS = 0x3
	// Position of LS field.
	UOTGHS_DEVCTRL_LS_Pos = 0xc
	// Bit mask of LS field.
	UOTGHS_DEVCTRL_LS_Msk = 0x1000
	// Bit LS.
	UOTGHS_DEVCTRL_LS = 0x1000
	// Position of TSTJ field.
	UOTGHS_DEVCTRL_TSTJ_Pos = 0xd
	// Bit mask of TSTJ field.
	UOTGHS_DEVCTRL_TSTJ_Msk = 0x2000
	// Bit TSTJ.
	UOTGHS_DEVCTRL_TSTJ = 0x2000
	// Position of TSTK field.
	UOTGHS_DEVCTRL_TSTK_Pos = 0xe
	// Bit mask of TSTK field.
	UOTGHS_DEVCTRL_TSTK_Msk = 0x4000
	// Bit TSTK.
	UOTGHS_DEVCTRL_TSTK = 0x4000
	// Position of TSTPCKT field.
	UOTGHS_DEVCTRL_TSTPCKT_Pos = 0xf
	// Bit mask of TSTPCKT field.
	UOTGHS_DEVCTRL_TSTPCKT_Msk = 0x8000
	// Bit TSTPCKT.
	UOTGHS_DEVCTRL_TSTPCKT = 0x8000
	// Position of OPMODE2 field.
	UOTGHS_DEVCTRL_OPMODE2_Pos = 0x10
	// Bit mask of OPMODE2 field.
	UOTGHS_DEVCTRL_OPMODE2_Msk = 0x10000
	// Bit OPMODE2.
	UOTGHS_DEVCTRL_OPMODE2 = 0x10000

	// DEVISR: Device Global Interrupt Status Register
	// Position of SUSP field.
	UOTGHS_DEVISR_SUSP_Pos = 0x0
	// Bit mask of SUSP field.
	UOTGHS_DEVISR_SUSP_Msk = 0x1
	// Bit SUSP.
	UOTGHS_DEVISR_SUSP = 0x1
	// Position of MSOF field.
	UOTGHS_DEVISR_MSOF_Pos = 0x1
	// Bit mask of MSOF field.
	UOTGHS_DEVISR_MSOF_Msk = 0x2
	// Bit MSOF.
	UOTGHS_DEVISR_MSOF = 0x2
	// Position of SOF field.
	UOTGHS_DEVISR_SOF_Pos = 0x2
	// Bit mask of SOF field.
	UOTGHS_DEVISR_SOF_Msk = 0x4
	// Bit SOF.
	UOTGHS_DEVISR_SOF = 0x4
	// Position of EORST field.
	UOTGHS_DEVISR_EORST_Pos = 0x3
	// Bit mask of EORST field.
	UOTGHS_DEVISR_EORST_Msk = 0x8
	// Bit EORST.
	UOTGHS_DEVISR_EORST = 0x8
	// Position of WAKEUP field.
	UOTGHS_DEVISR_WAKEUP_Pos = 0x4
	// Bit mask of WAKEUP field.
	UOTGHS_DEVISR_WAKEUP_Msk = 0x10
	// Bit WAKEUP.
	UOTGHS_DEVISR_WAKEUP = 0x10
	// Position of EORSM field.
	UOTGHS_DEVISR_EORSM_Pos = 0x5
	// Bit mask of EORSM field.
	UOTGHS_DEVISR_EORSM_Msk = 0x20
	// Bit EORSM.
	UOTGHS_DEVISR_EORSM = 0x20
	// Position of UPRSM field.
	UOTGHS_DEVISR_UPRSM_Pos = 0x6
	// Bit mask of UPRSM field.
	UOTGHS_DEVISR_UPRSM_Msk = 0x40
	// Bit UPRSM.
	UOTGHS_DEVISR_UPRSM = 0x40
	// Position of PEP_0 field.
	UOTGHS_DEVISR_PEP_0_Pos = 0xc
	// Bit mask of PEP_0 field.
	UOTGHS_DEVISR_PEP_0_Msk = 0x1000
	// Bit PEP_0.
	UOTGHS_DEVISR_PEP_0 = 0x1000
	// Position of PEP_1 field.
	UOTGHS_DEVISR_PEP_1_Pos = 0xd
	// Bit mask of PEP_1 field.
	UOTGHS_DEVISR_PEP_1_Msk = 0x2000
	// Bit PEP_1.
	UOTGHS_DEVISR_PEP_1 = 0x2000
	// Position of PEP_2 field.
	UOTGHS_DEVISR_PEP_2_Pos = 0xe
	// Bit mask of PEP_2 field.
	UOTGHS_DEVISR_PEP_2_Msk = 0x4000
	// Bit PEP_2.
	UOTGHS_DEVISR_PEP_2 = 0x4000
	// Position of PEP_3 field.
	UOTGHS_DEVISR_PEP_3_Pos = 0xf
	// Bit mask of PEP_3 field.
	UOTGHS_DEVISR_PEP_3_Msk = 0x8000
	// Bit PEP_3.
	UOTGHS_DEVISR_PEP_3 = 0x8000
	// Position of PEP_4 field.
	UOTGHS_DEVISR_PEP_4_Pos = 0x10
	// Bit mask of PEP_4 field.
	UOTGHS_DEVISR_PEP_4_Msk = 0x10000
	// Bit PEP_4.
	UOTGHS_DEVISR_PEP_4 = 0x10000
	// Position of PEP_5 field.
	UOTGHS_DEVISR_PEP_5_Pos = 0x11
	// Bit mask of PEP_5 field.
	UOTGHS_DEVISR_PEP_5_Msk = 0x20000
	// Bit PEP_5.
	UOTGHS_DEVISR_PEP_5 = 0x20000
	// Position of PEP_6 field.
	UOTGHS_DEVISR_PEP_6_Pos = 0x12
	// Bit mask of PEP_6 field.
	UOTGHS_DEVISR_PEP_6_Msk = 0x40000
	// Bit PEP_6.
	UOTGHS_DEVISR_PEP_6 = 0x40000
	// Position of PEP_7 field.
	UOTGHS_DEVISR_PEP_7_Pos = 0x13
	// Bit mask of PEP_7 field.
	UOTGHS_DEVISR_PEP_7_Msk = 0x80000
	// Bit PEP_7.
	UOTGHS_DEVISR_PEP_7 = 0x80000
	// Position of PEP_8 field.
	UOTGHS_DEVISR_PEP_8_Pos = 0x14
	// Bit mask of PEP_8 field.
	UOTGHS_DEVISR_PEP_8_Msk = 0x100000
	// Bit PEP_8.
	UOTGHS_DEVISR_PEP_8 = 0x100000
	// Position of PEP_9 field.
	UOTGHS_DEVISR_PEP_9_Pos = 0x15
	// Bit mask of PEP_9 field.
	UOTGHS_DEVISR_PEP_9_Msk = 0x200000
	// Bit PEP_9.
	UOTGHS_DEVISR_PEP_9 = 0x200000
	// Position of DMA_1 field.
	UOTGHS_DEVISR_DMA_1_Pos = 0x19
	// Bit mask of DMA_1 field.
	UOTGHS_DEVISR_DMA_1_Msk = 0x2000000
	// Bit DMA_1.
	UOTGHS_DEVISR_DMA_1 = 0x2000000
	// Position of DMA_2 field.
	UOTGHS_DEVISR_DMA_2_Pos = 0x1a
	// Bit mask of DMA_2 field.
	UOTGHS_DEVISR_DMA_2_Msk = 0x4000000
	// Bit DMA_2.
	UOTGHS_DEVISR_DMA_2 = 0x4000000
	// Position of DMA_3 field.
	UOTGHS_DEVISR_DMA_3_Pos = 0x1b
	// Bit mask of DMA_3 field.
	UOTGHS_DEVISR_DMA_3_Msk = 0x8000000
	// Bit DMA_3.
	UOTGHS_DEVISR_DMA_3 = 0x8000000
	// Position of DMA_4 field.
	UOTGHS_DEVISR_DMA_4_Pos = 0x1c
	// Bit mask of DMA_4 field.
	UOTGHS_DEVISR_DMA_4_Msk = 0x10000000
	// Bit DMA_4.
	UOTGHS_DEVISR_DMA_4 = 0x10000000
	// Position of DMA_5 field.
	UOTGHS_DEVISR_DMA_5_Pos = 0x1d
	// Bit mask of DMA_5 field.
	UOTGHS_DEVISR_DMA_5_Msk = 0x20000000
	// Bit DMA_5.
	UOTGHS_DEVISR_DMA_5 = 0x20000000
	// Position of DMA_6 field.
	UOTGHS_DEVISR_DMA_6_Pos = 0x1e
	// Bit mask of DMA_6 field.
	UOTGHS_DEVISR_DMA_6_Msk = 0x40000000
	// Bit DMA_6.
	UOTGHS_DEVISR_DMA_6 = 0x40000000

	// DEVICR: Device Global Interrupt Clear Register
	// Position of SUSPC field.
	UOTGHS_DEVICR_SUSPC_Pos = 0x0
	// Bit mask of SUSPC field.
	UOTGHS_DEVICR_SUSPC_Msk = 0x1
	// Bit SUSPC.
	UOTGHS_DEVICR_SUSPC = 0x1
	// Position of MSOFC field.
	UOTGHS_DEVICR_MSOFC_Pos = 0x1
	// Bit mask of MSOFC field.
	UOTGHS_DEVICR_MSOFC_Msk = 0x2
	// Bit MSOFC.
	UOTGHS_DEVICR_MSOFC = 0x2
	// Position of SOFC field.
	UOTGHS_DEVICR_SOFC_Pos = 0x2
	// Bit mask of SOFC field.
	UOTGHS_DEVICR_SOFC_Msk = 0x4
	// Bit SOFC.
	UOTGHS_DEVICR_SOFC = 0x4
	// Position of EORSTC field.
	UOTGHS_DEVICR_EORSTC_Pos = 0x3
	// Bit mask of EORSTC field.
	UOTGHS_DEVICR_EORSTC_Msk = 0x8
	// Bit EORSTC.
	UOTGHS_DEVICR_EORSTC = 0x8
	// Position of WAKEUPC field.
	UOTGHS_DEVICR_WAKEUPC_Pos = 0x4
	// Bit mask of WAKEUPC field.
	UOTGHS_DEVICR_WAKEUPC_Msk = 0x10
	// Bit WAKEUPC.
	UOTGHS_DEVICR_WAKEUPC = 0x10
	// Position of EORSMC field.
	UOTGHS_DEVICR_EORSMC_Pos = 0x5
	// Bit mask of EORSMC field.
	UOTGHS_DEVICR_EORSMC_Msk = 0x20
	// Bit EORSMC.
	UOTGHS_DEVICR_EORSMC = 0x20
	// Position of UPRSMC field.
	UOTGHS_DEVICR_UPRSMC_Pos = 0x6
	// Bit mask of UPRSMC field.
	UOTGHS_DEVICR_UPRSMC_Msk = 0x40
	// Bit UPRSMC.
	UOTGHS_DEVICR_UPRSMC = 0x40

	// DEVIFR: Device Global Interrupt Set Register
	// Position of SUSPS field.
	UOTGHS_DEVIFR_SUSPS_Pos = 0x0
	// Bit mask of SUSPS field.
	UOTGHS_DEVIFR_SUSPS_Msk = 0x1
	// Bit SUSPS.
	UOTGHS_DEVIFR_SUSPS = 0x1
	// Position of MSOFS field.
	UOTGHS_DEVIFR_MSOFS_Pos = 0x1
	// Bit mask of MSOFS field.
	UOTGHS_DEVIFR_MSOFS_Msk = 0x2
	// Bit MSOFS.
	UOTGHS_DEVIFR_MSOFS = 0x2
	// Position of SOFS field.
	UOTGHS_DEVIFR_SOFS_Pos = 0x2
	// Bit mask of SOFS field.
	UOTGHS_DEVIFR_SOFS_Msk = 0x4
	// Bit SOFS.
	UOTGHS_DEVIFR_SOFS = 0x4
	// Position of EORSTS field.
	UOTGHS_DEVIFR_EORSTS_Pos = 0x3
	// Bit mask of EORSTS field.
	UOTGHS_DEVIFR_EORSTS_Msk = 0x8
	// Bit EORSTS.
	UOTGHS_DEVIFR_EORSTS = 0x8
	// Position of WAKEUPS field.
	UOTGHS_DEVIFR_WAKEUPS_Pos = 0x4
	// Bit mask of WAKEUPS field.
	UOTGHS_DEVIFR_WAKEUPS_Msk = 0x10
	// Bit WAKEUPS.
	UOTGHS_DEVIFR_WAKEUPS = 0x10
	// Position of EORSMS field.
	UOTGHS_DEVIFR_EORSMS_Pos = 0x5
	// Bit mask of EORSMS field.
	UOTGHS_DEVIFR_EORSMS_Msk = 0x20
	// Bit EORSMS.
	UOTGHS_DEVIFR_EORSMS = 0x20
	// Position of UPRSMS field.
	UOTGHS_DEVIFR_UPRSMS_Pos = 0x6
	// Bit mask of UPRSMS field.
	UOTGHS_DEVIFR_UPRSMS_Msk = 0x40
	// Bit UPRSMS.
	UOTGHS_DEVIFR_UPRSMS = 0x40
	// Position of DMA_1 field.
	UOTGHS_DEVIFR_DMA_1_Pos = 0x19
	// Bit mask of DMA_1 field.
	UOTGHS_DEVIFR_DMA_1_Msk = 0x2000000
	// Bit DMA_1.
	UOTGHS_DEVIFR_DMA_1 = 0x2000000
	// Position of DMA_2 field.
	UOTGHS_DEVIFR_DMA_2_Pos = 0x1a
	// Bit mask of DMA_2 field.
	UOTGHS_DEVIFR_DMA_2_Msk = 0x4000000
	// Bit DMA_2.
	UOTGHS_DEVIFR_DMA_2 = 0x4000000
	// Position of DMA_3 field.
	UOTGHS_DEVIFR_DMA_3_Pos = 0x1b
	// Bit mask of DMA_3 field.
	UOTGHS_DEVIFR_DMA_3_Msk = 0x8000000
	// Bit DMA_3.
	UOTGHS_DEVIFR_DMA_3 = 0x8000000
	// Position of DMA_4 field.
	UOTGHS_DEVIFR_DMA_4_Pos = 0x1c
	// Bit mask of DMA_4 field.
	UOTGHS_DEVIFR_DMA_4_Msk = 0x10000000
	// Bit DMA_4.
	UOTGHS_DEVIFR_DMA_4 = 0x10000000
	// Position of DMA_5 field.
	UOTGHS_DEVIFR_DMA_5_Pos = 0x1d
	// Bit mask of DMA_5 field.
	UOTGHS_DEVIFR_DMA_5_Msk = 0x20000000
	// Bit DMA_5.
	UOTGHS_DEVIFR_DMA_5 = 0x20000000
	// Position of DMA_6 field.
	UOTGHS_DEVIFR_DMA_6_Pos = 0x1e
	// Bit mask of DMA_6 field.
	UOTGHS_DEVIFR_DMA_6_Msk = 0x40000000
	// Bit DMA_6.
	UOTGHS_DEVIFR_DMA_6 = 0x40000000

	// DEVIMR: Device Global Interrupt Mask Register
	// Position of SUSPE field.
	UOTGHS_DEVIMR_SUSPE_Pos = 0x0
	// Bit mask of SUSPE field.
	UOTGHS_DEVIMR_SUSPE_Msk = 0x1
	// Bit SUSPE.
	UOTGHS_DEVIMR_SUSPE = 0x1
	// Position of MSOFE field.
	UOTGHS_DEVIMR_MSOFE_Pos = 0x1
	// Bit mask of MSOFE field.
	UOTGHS_DEVIMR_MSOFE_Msk = 0x2
	// Bit MSOFE.
	UOTGHS_DEVIMR_MSOFE = 0x2
	// Position of SOFE field.
	UOTGHS_DEVIMR_SOFE_Pos = 0x2
	// Bit mask of SOFE field.
	UOTGHS_DEVIMR_SOFE_Msk = 0x4
	// Bit SOFE.
	UOTGHS_DEVIMR_SOFE = 0x4
	// Position of EORSTE field.
	UOTGHS_DEVIMR_EORSTE_Pos = 0x3
	// Bit mask of EORSTE field.
	UOTGHS_DEVIMR_EORSTE_Msk = 0x8
	// Bit EORSTE.
	UOTGHS_DEVIMR_EORSTE = 0x8
	// Position of WAKEUPE field.
	UOTGHS_DEVIMR_WAKEUPE_Pos = 0x4
	// Bit mask of WAKEUPE field.
	UOTGHS_DEVIMR_WAKEUPE_Msk = 0x10
	// Bit WAKEUPE.
	UOTGHS_DEVIMR_WAKEUPE = 0x10
	// Position of EORSME field.
	UOTGHS_DEVIMR_EORSME_Pos = 0x5
	// Bit mask of EORSME field.
	UOTGHS_DEVIMR_EORSME_Msk = 0x20
	// Bit EORSME.
	UOTGHS_DEVIMR_EORSME = 0x20
	// Position of UPRSME field.
	UOTGHS_DEVIMR_UPRSME_Pos = 0x6
	// Bit mask of UPRSME field.
	UOTGHS_DEVIMR_UPRSME_Msk = 0x40
	// Bit UPRSME.
	UOTGHS_DEVIMR_UPRSME = 0x40
	// Position of PEP_0 field.
	UOTGHS_DEVIMR_PEP_0_Pos = 0xc
	// Bit mask of PEP_0 field.
	UOTGHS_DEVIMR_PEP_0_Msk = 0x1000
	// Bit PEP_0.
	UOTGHS_DEVIMR_PEP_0 = 0x1000
	// Position of PEP_1 field.
	UOTGHS_DEVIMR_PEP_1_Pos = 0xd
	// Bit mask of PEP_1 field.
	UOTGHS_DEVIMR_PEP_1_Msk = 0x2000
	// Bit PEP_1.
	UOTGHS_DEVIMR_PEP_1 = 0x2000
	// Position of PEP_2 field.
	UOTGHS_DEVIMR_PEP_2_Pos = 0xe
	// Bit mask of PEP_2 field.
	UOTGHS_DEVIMR_PEP_2_Msk = 0x4000
	// Bit PEP_2.
	UOTGHS_DEVIMR_PEP_2 = 0x4000
	// Position of PEP_3 field.
	UOTGHS_DEVIMR_PEP_3_Pos = 0xf
	// Bit mask of PEP_3 field.
	UOTGHS_DEVIMR_PEP_3_Msk = 0x8000
	// Bit PEP_3.
	UOTGHS_DEVIMR_PEP_3 = 0x8000
	// Position of PEP_4 field.
	UOTGHS_DEVIMR_PEP_4_Pos = 0x10
	// Bit mask of PEP_4 field.
	UOTGHS_DEVIMR_PEP_4_Msk = 0x10000
	// Bit PEP_4.
	UOTGHS_DEVIMR_PEP_4 = 0x10000
	// Position of PEP_5 field.
	UOTGHS_DEVIMR_PEP_5_Pos = 0x11
	// Bit mask of PEP_5 field.
	UOTGHS_DEVIMR_PEP_5_Msk = 0x20000
	// Bit PEP_5.
	UOTGHS_DEVIMR_PEP_5 = 0x20000
	// Position of PEP_6 field.
	UOTGHS_DEVIMR_PEP_6_Pos = 0x12
	// Bit mask of PEP_6 field.
	UOTGHS_DEVIMR_PEP_6_Msk = 0x40000
	// Bit PEP_6.
	UOTGHS_DEVIMR_PEP_6 = 0x40000
	// Position of PEP_7 field.
	UOTGHS_DEVIMR_PEP_7_Pos = 0x13
	// Bit mask of PEP_7 field.
	UOTGHS_DEVIMR_PEP_7_Msk = 0x80000
	// Bit PEP_7.
	UOTGHS_DEVIMR_PEP_7 = 0x80000
	// Position of PEP_8 field.
	UOTGHS_DEVIMR_PEP_8_Pos = 0x14
	// Bit mask of PEP_8 field.
	UOTGHS_DEVIMR_PEP_8_Msk = 0x100000
	// Bit PEP_8.
	UOTGHS_DEVIMR_PEP_8 = 0x100000
	// Position of PEP_9 field.
	UOTGHS_DEVIMR_PEP_9_Pos = 0x15
	// Bit mask of PEP_9 field.
	UOTGHS_DEVIMR_PEP_9_Msk = 0x200000
	// Bit PEP_9.
	UOTGHS_DEVIMR_PEP_9 = 0x200000
	// Position of DMA_1 field.
	UOTGHS_DEVIMR_DMA_1_Pos = 0x19
	// Bit mask of DMA_1 field.
	UOTGHS_DEVIMR_DMA_1_Msk = 0x2000000
	// Bit DMA_1.
	UOTGHS_DEVIMR_DMA_1 = 0x2000000
	// Position of DMA_2 field.
	UOTGHS_DEVIMR_DMA_2_Pos = 0x1a
	// Bit mask of DMA_2 field.
	UOTGHS_DEVIMR_DMA_2_Msk = 0x4000000
	// Bit DMA_2.
	UOTGHS_DEVIMR_DMA_2 = 0x4000000
	// Position of DMA_3 field.
	UOTGHS_DEVIMR_DMA_3_Pos = 0x1b
	// Bit mask of DMA_3 field.
	UOTGHS_DEVIMR_DMA_3_Msk = 0x8000000
	// Bit DMA_3.
	UOTGHS_DEVIMR_DMA_3 = 0x8000000
	// Position of DMA_4 field.
	UOTGHS_DEVIMR_DMA_4_Pos = 0x1c
	// Bit mask of DMA_4 field.
	UOTGHS_DEVIMR_DMA_4_Msk = 0x10000000
	// Bit DMA_4.
	UOTGHS_DEVIMR_DMA_4 = 0x10000000
	// Position of DMA_5 field.
	UOTGHS_DEVIMR_DMA_5_Pos = 0x1d
	// Bit mask of DMA_5 field.
	UOTGHS_DEVIMR_DMA_5_Msk = 0x20000000
	// Bit DMA_5.
	UOTGHS_DEVIMR_DMA_5 = 0x20000000
	// Position of DMA_6 field.
	UOTGHS_DEVIMR_DMA_6_Pos = 0x1e
	// Bit mask of DMA_6 field.
	UOTGHS_DEVIMR_DMA_6_Msk = 0x40000000
	// Bit DMA_6.
	UOTGHS_DEVIMR_DMA_6 = 0x40000000

	// DEVIDR: Device Global Interrupt Disable Register
	// Position of SUSPEC field.
	UOTGHS_DEVIDR_SUSPEC_Pos = 0x0
	// Bit mask of SUSPEC field.
	UOTGHS_DEVIDR_SUSPEC_Msk = 0x1
	// Bit SUSPEC.
	UOTGHS_DEVIDR_SUSPEC = 0x1
	// Position of MSOFEC field.
	UOTGHS_DEVIDR_MSOFEC_Pos = 0x1
	// Bit mask of MSOFEC field.
	UOTGHS_DEVIDR_MSOFEC_Msk = 0x2
	// Bit MSOFEC.
	UOTGHS_DEVIDR_MSOFEC = 0x2
	// Position of SOFEC field.
	UOTGHS_DEVIDR_SOFEC_Pos = 0x2
	// Bit mask of SOFEC field.
	UOTGHS_DEVIDR_SOFEC_Msk = 0x4
	// Bit SOFEC.
	UOTGHS_DEVIDR_SOFEC = 0x4
	// Position of EORSTEC field.
	UOTGHS_DEVIDR_EORSTEC_Pos = 0x3
	// Bit mask of EORSTEC field.
	UOTGHS_DEVIDR_EORSTEC_Msk = 0x8
	// Bit EORSTEC.
	UOTGHS_DEVIDR_EORSTEC = 0x8
	// Position of WAKEUPEC field.
	UOTGHS_DEVIDR_WAKEUPEC_Pos = 0x4
	// Bit mask of WAKEUPEC field.
	UOTGHS_DEVIDR_WAKEUPEC_Msk = 0x10
	// Bit WAKEUPEC.
	UOTGHS_DEVIDR_WAKEUPEC = 0x10
	// Position of EORSMEC field.
	UOTGHS_DEVIDR_EORSMEC_Pos = 0x5
	// Bit mask of EORSMEC field.
	UOTGHS_DEVIDR_EORSMEC_Msk = 0x20
	// Bit EORSMEC.
	UOTGHS_DEVIDR_EORSMEC = 0x20
	// Position of UPRSMEC field.
	UOTGHS_DEVIDR_UPRSMEC_Pos = 0x6
	// Bit mask of UPRSMEC field.
	UOTGHS_DEVIDR_UPRSMEC_Msk = 0x40
	// Bit UPRSMEC.
	UOTGHS_DEVIDR_UPRSMEC = 0x40
	// Position of PEP_0 field.
	UOTGHS_DEVIDR_PEP_0_Pos = 0xc
	// Bit mask of PEP_0 field.
	UOTGHS_DEVIDR_PEP_0_Msk = 0x1000
	// Bit PEP_0.
	UOTGHS_DEVIDR_PEP_0 = 0x1000
	// Position of PEP_1 field.
	UOTGHS_DEVIDR_PEP_1_Pos = 0xd
	// Bit mask of PEP_1 field.
	UOTGHS_DEVIDR_PEP_1_Msk = 0x2000
	// Bit PEP_1.
	UOTGHS_DEVIDR_PEP_1 = 0x2000
	// Position of PEP_2 field.
	UOTGHS_DEVIDR_PEP_2_Pos = 0xe
	// Bit mask of PEP_2 field.
	UOTGHS_DEVIDR_PEP_2_Msk = 0x4000
	// Bit PEP_2.
	UOTGHS_DEVIDR_PEP_2 = 0x4000
	// Position of PEP_3 field.
	UOTGHS_DEVIDR_PEP_3_Pos = 0xf
	// Bit mask of PEP_3 field.
	UOTGHS_DEVIDR_PEP_3_Msk = 0x8000
	// Bit PEP_3.
	UOTGHS_DEVIDR_PEP_3 = 0x8000
	// Position of PEP_4 field.
	UOTGHS_DEVIDR_PEP_4_Pos = 0x10
	// Bit mask of PEP_4 field.
	UOTGHS_DEVIDR_PEP_4_Msk = 0x10000
	// Bit PEP_4.
	UOTGHS_DEVIDR_PEP_4 = 0x10000
	// Position of PEP_5 field.
	UOTGHS_DEVIDR_PEP_5_Pos = 0x11
	// Bit mask of PEP_5 field.
	UOTGHS_DEVIDR_PEP_5_Msk = 0x20000
	// Bit PEP_5.
	UOTGHS_DEVIDR_PEP_5 = 0x20000
	// Position of PEP_6 field.
	UOTGHS_DEVIDR_PEP_6_Pos = 0x12
	// Bit mask of PEP_6 field.
	UOTGHS_DEVIDR_PEP_6_Msk = 0x40000
	// Bit PEP_6.
	UOTGHS_DEVIDR_PEP_6 = 0x40000
	// Position of PEP_7 field.
	UOTGHS_DEVIDR_PEP_7_Pos = 0x13
	// Bit mask of PEP_7 field.
	UOTGHS_DEVIDR_PEP_7_Msk = 0x80000
	// Bit PEP_7.
	UOTGHS_DEVIDR_PEP_7 = 0x80000
	// Position of PEP_8 field.
	UOTGHS_DEVIDR_PEP_8_Pos = 0x14
	// Bit mask of PEP_8 field.
	UOTGHS_DEVIDR_PEP_8_Msk = 0x100000
	// Bit PEP_8.
	UOTGHS_DEVIDR_PEP_8 = 0x100000
	// Position of PEP_9 field.
	UOTGHS_DEVIDR_PEP_9_Pos = 0x15
	// Bit mask of PEP_9 field.
	UOTGHS_DEVIDR_PEP_9_Msk = 0x200000
	// Bit PEP_9.
	UOTGHS_DEVIDR_PEP_9 = 0x200000
	// Position of DMA_1 field.
	UOTGHS_DEVIDR_DMA_1_Pos = 0x19
	// Bit mask of DMA_1 field.
	UOTGHS_DEVIDR_DMA_1_Msk = 0x2000000
	// Bit DMA_1.
	UOTGHS_DEVIDR_DMA_1 = 0x2000000
	// Position of DMA_2 field.
	UOTGHS_DEVIDR_DMA_2_Pos = 0x1a
	// Bit mask of DMA_2 field.
	UOTGHS_DEVIDR_DMA_2_Msk = 0x4000000
	// Bit DMA_2.
	UOTGHS_DEVIDR_DMA_2 = 0x4000000
	// Position of DMA_3 field.
	UOTGHS_DEVIDR_DMA_3_Pos = 0x1b
	// Bit mask of DMA_3 field.
	UOTGHS_DEVIDR_DMA_3_Msk = 0x8000000
	// Bit DMA_3.
	UOTGHS_DEVIDR_DMA_3 = 0x8000000
	// Position of DMA_4 field.
	UOTGHS_DEVIDR_DMA_4_Pos = 0x1c
	// Bit mask of DMA_4 field.
	UOTGHS_DEVIDR_DMA_4_Msk = 0x10000000
	// Bit DMA_4.
	UOTGHS_DEVIDR_DMA_4 = 0x10000000
	// Position of DMA_5 field.
	UOTGHS_DEVIDR_DMA_5_Pos = 0x1d
	// Bit mask of DMA_5 field.
	UOTGHS_DEVIDR_DMA_5_Msk = 0x20000000
	// Bit DMA_5.
	UOTGHS_DEVIDR_DMA_5 = 0x20000000
	// Position of DMA_6 field.
	UOTGHS_DEVIDR_DMA_6_Pos = 0x1e
	// Bit mask of DMA_6 field.
	UOTGHS_DEVIDR_DMA_6_Msk = 0x40000000
	// Bit DMA_6.
	UOTGHS_DEVIDR_DMA_6 = 0x40000000

	// DEVIER: Device Global Interrupt Enable Register
	// Position of SUSPES field.
	UOTGHS_DEVIER_SUSPES_Pos = 0x0
	// Bit mask of SUSPES field.
	UOTGHS_DEVIER_SUSPES_Msk = 0x1
	// Bit SUSPES.
	UOTGHS_DEVIER_SUSPES = 0x1
	// Position of MSOFES field.
	UOTGHS_DEVIER_MSOFES_Pos = 0x1
	// Bit mask of MSOFES field.
	UOTGHS_DEVIER_MSOFES_Msk = 0x2
	// Bit MSOFES.
	UOTGHS_DEVIER_MSOFES = 0x2
	// Position of SOFES field.
	UOTGHS_DEVIER_SOFES_Pos = 0x2
	// Bit mask of SOFES field.
	UOTGHS_DEVIER_SOFES_Msk = 0x4
	// Bit SOFES.
	UOTGHS_DEVIER_SOFES = 0x4
	// Position of EORSTES field.
	UOTGHS_DEVIER_EORSTES_Pos = 0x3
	// Bit mask of EORSTES field.
	UOTGHS_DEVIER_EORSTES_Msk = 0x8
	// Bit EORSTES.
	UOTGHS_DEVIER_EORSTES = 0x8
	// Position of WAKEUPES field.
	UOTGHS_DEVIER_WAKEUPES_Pos = 0x4
	// Bit mask of WAKEUPES field.
	UOTGHS_DEVIER_WAKEUPES_Msk = 0x10
	// Bit WAKEUPES.
	UOTGHS_DEVIER_WAKEUPES = 0x10
	// Position of EORSMES field.
	UOTGHS_DEVIER_EORSMES_Pos = 0x5
	// Bit mask of EORSMES field.
	UOTGHS_DEVIER_EORSMES_Msk = 0x20
	// Bit EORSMES.
	UOTGHS_DEVIER_EORSMES = 0x20
	// Position of UPRSMES field.
	UOTGHS_DEVIER_UPRSMES_Pos = 0x6
	// Bit mask of UPRSMES field.
	UOTGHS_DEVIER_UPRSMES_Msk = 0x40
	// Bit UPRSMES.
	UOTGHS_DEVIER_UPRSMES = 0x40
	// Position of PEP_0 field.
	UOTGHS_DEVIER_PEP_0_Pos = 0xc
	// Bit mask of PEP_0 field.
	UOTGHS_DEVIER_PEP_0_Msk = 0x1000
	// Bit PEP_0.
	UOTGHS_DEVIER_PEP_0 = 0x1000
	// Position of PEP_1 field.
	UOTGHS_DEVIER_PEP_1_Pos = 0xd
	// Bit mask of PEP_1 field.
	UOTGHS_DEVIER_PEP_1_Msk = 0x2000
	// Bit PEP_1.
	UOTGHS_DEVIER_PEP_1 = 0x2000
	// Position of PEP_2 field.
	UOTGHS_DEVIER_PEP_2_Pos = 0xe
	// Bit mask of PEP_2 field.
	UOTGHS_DEVIER_PEP_2_Msk = 0x4000
	// Bit PEP_2.
	UOTGHS_DEVIER_PEP_2 = 0x4000
	// Position of PEP_3 field.
	UOTGHS_DEVIER_PEP_3_Pos = 0xf
	// Bit mask of PEP_3 field.
	UOTGHS_DEVIER_PEP_3_Msk = 0x8000
	// Bit PEP_3.
	UOTGHS_DEVIER_PEP_3 = 0x8000
	// Position of PEP_4 field.
	UOTGHS_DEVIER_PEP_4_Pos = 0x10
	// Bit mask of PEP_4 field.
	UOTGHS_DEVIER_PEP_4_Msk = 0x10000
	// Bit PEP_4.
	UOTGHS_DEVIER_PEP_4 = 0x10000
	// Position of PEP_5 field.
	UOTGHS_DEVIER_PEP_5_Pos = 0x11
	// Bit mask of PEP_5 field.
	UOTGHS_DEVIER_PEP_5_Msk = 0x20000
	// Bit PEP_5.
	UOTGHS_DEVIER_PEP_5 = 0x20000
	// Position of PEP_6 field.
	UOTGHS_DEVIER_PEP_6_Pos = 0x12
	// Bit mask of PEP_6 field.
	UOTGHS_DEVIER_PEP_6_Msk = 0x40000
	// Bit PEP_6.
	UOTGHS_DEVIER_PEP_6 = 0x40000
	// Position of PEP_7 field.
	UOTGHS_DEVIER_PEP_7_Pos = 0x13
	// Bit mask of PEP_7 field.
	UOTGHS_DEVIER_PEP_7_Msk = 0x80000
	// Bit PEP_7.
	UOTGHS_DEVIER_PEP_7 = 0x80000
	// Position of PEP_8 field.
	UOTGHS_DEVIER_PEP_8_Pos = 0x14
	// Bit mask of PEP_8 field.
	UOTGHS_DEVIER_PEP_8_Msk = 0x100000
	// Bit PEP_8.
	UOTGHS_DEVIER_PEP_8 = 0x100000
	// Position of PEP_9 field.
	UOTGHS_DEVIER_PEP_9_Pos = 0x15
	// Bit mask of PEP_9 field.
	UOTGHS_DEVIER_PEP_9_Msk = 0x200000
	// Bit PEP_9.
	UOTGHS_DEVIER_PEP_9 = 0x200000
	// Position of DMA_1 field.
	UOTGHS_DEVIER_DMA_1_Pos = 0x19
	// Bit mask of DMA_1 field.
	UOTGHS_DEVIER_DMA_1_Msk = 0x2000000
	// Bit DMA_1.
	UOTGHS_DEVIER_DMA_1 = 0x2000000
	// Position of DMA_2 field.
	UOTGHS_DEVIER_DMA_2_Pos = 0x1a
	// Bit mask of DMA_2 field.
	UOTGHS_DEVIER_DMA_2_Msk = 0x4000000
	// Bit DMA_2.
	UOTGHS_DEVIER_DMA_2 = 0x4000000
	// Position of DMA_3 field.
	UOTGHS_DEVIER_DMA_3_Pos = 0x1b
	// Bit mask of DMA_3 field.
	UOTGHS_DEVIER_DMA_3_Msk = 0x8000000
	// Bit DMA_3.
	UOTGHS_DEVIER_DMA_3 = 0x8000000
	// Position of DMA_4 field.
	UOTGHS_DEVIER_DMA_4_Pos = 0x1c
	// Bit mask of DMA_4 field.
	UOTGHS_DEVIER_DMA_4_Msk = 0x10000000
	// Bit DMA_4.
	UOTGHS_DEVIER_DMA_4 = 0x10000000
	// Position of DMA_5 field.
	UOTGHS_DEVIER_DMA_5_Pos = 0x1d
	// Bit mask of DMA_5 field.
	UOTGHS_DEVIER_DMA_5_Msk = 0x20000000
	// Bit DMA_5.
	UOTGHS_DEVIER_DMA_5 = 0x20000000
	// Position of DMA_6 field.
	UOTGHS_DEVIER_DMA_6_Pos = 0x1e
	// Bit mask of DMA_6 field.
	UOTGHS_DEVIER_DMA_6_Msk = 0x40000000
	// Bit DMA_6.
	UOTGHS_DEVIER_DMA_6 = 0x40000000

	// DEVEPT: Device Endpoint Register
	// Position of EPEN0 field.
	UOTGHS_DEVEPT_EPEN0_Pos = 0x0
	// Bit mask of EPEN0 field.
	UOTGHS_DEVEPT_EPEN0_Msk = 0x1
	// Bit EPEN0.
	UOTGHS_DEVEPT_EPEN0 = 0x1
	// Position of EPEN1 field.
	UOTGHS_DEVEPT_EPEN1_Pos = 0x1
	// Bit mask of EPEN1 field.
	UOTGHS_DEVEPT_EPEN1_Msk = 0x2
	// Bit EPEN1.
	UOTGHS_DEVEPT_EPEN1 = 0x2
	// Position of EPEN2 field.
	UOTGHS_DEVEPT_EPEN2_Pos = 0x2
	// Bit mask of EPEN2 field.
	UOTGHS_DEVEPT_EPEN2_Msk = 0x4
	// Bit EPEN2.
	UOTGHS_DEVEPT_EPEN2 = 0x4
	// Position of EPEN3 field.
	UOTGHS_DEVEPT_EPEN3_Pos = 0x3
	// Bit mask of EPEN3 field.
	UOTGHS_DEVEPT_EPEN3_Msk = 0x8
	// Bit EPEN3.
	UOTGHS_DEVEPT_EPEN3 = 0x8
	// Position of EPEN4 field.
	UOTGHS_DEVEPT_EPEN4_Pos = 0x4
	// Bit mask of EPEN4 field.
	UOTGHS_DEVEPT_EPEN4_Msk = 0x10
	// Bit EPEN4.
	UOTGHS_DEVEPT_EPEN4 = 0x10
	// Position of EPEN5 field.
	UOTGHS_DEVEPT_EPEN5_Pos = 0x5
	// Bit mask of EPEN5 field.
	UOTGHS_DEVEPT_EPEN5_Msk = 0x20
	// Bit EPEN5.
	UOTGHS_DEVEPT_EPEN5 = 0x20
	// Position of EPEN6 field.
	UOTGHS_DEVEPT_EPEN6_Pos = 0x6
	// Bit mask of EPEN6 field.
	UOTGHS_DEVEPT_EPEN6_Msk = 0x40
	// Bit EPEN6.
	UOTGHS_DEVEPT_EPEN6 = 0x40
	// Position of EPEN7 field.
	UOTGHS_DEVEPT_EPEN7_Pos = 0x7
	// Bit mask of EPEN7 field.
	UOTGHS_DEVEPT_EPEN7_Msk = 0x80
	// Bit EPEN7.
	UOTGHS_DEVEPT_EPEN7 = 0x80
	// Position of EPEN8 field.
	UOTGHS_DEVEPT_EPEN8_Pos = 0x8
	// Bit mask of EPEN8 field.
	UOTGHS_DEVEPT_EPEN8_Msk = 0x100
	// Bit EPEN8.
	UOTGHS_DEVEPT_EPEN8 = 0x100
	// Position of EPRST0 field.
	UOTGHS_DEVEPT_EPRST0_Pos = 0x10
	// Bit mask of EPRST0 field.
	UOTGHS_DEVEPT_EPRST0_Msk = 0x10000
	// Bit EPRST0.
	UOTGHS_DEVEPT_EPRST0 = 0x10000
	// Position of EPRST1 field.
	UOTGHS_DEVEPT_EPRST1_Pos = 0x11
	// Bit mask of EPRST1 field.
	UOTGHS_DEVEPT_EPRST1_Msk = 0x20000
	// Bit EPRST1.
	UOTGHS_DEVEPT_EPRST1 = 0x20000
	// Position of EPRST2 field.
	UOTGHS_DEVEPT_EPRST2_Pos = 0x12
	// Bit mask of EPRST2 field.
	UOTGHS_DEVEPT_EPRST2_Msk = 0x40000
	// Bit EPRST2.
	UOTGHS_DEVEPT_EPRST2 = 0x40000
	// Position of EPRST3 field.
	UOTGHS_DEVEPT_EPRST3_Pos = 0x13
	// Bit mask of EPRST3 field.
	UOTGHS_DEVEPT_EPRST3_Msk = 0x80000
	// Bit EPRST3.
	UOTGHS_DEVEPT_EPRST3 = 0x80000
	// Position of EPRST4 field.
	UOTGHS_DEVEPT_EPRST4_Pos = 0x14
	// Bit mask of EPRST4 field.
	UOTGHS_DEVEPT_EPRST4_Msk = 0x100000
	// Bit EPRST4.
	UOTGHS_DEVEPT_EPRST4 = 0x100000
	// Position of EPRST5 field.
	UOTGHS_DEVEPT_EPRST5_Pos = 0x15
	// Bit mask of EPRST5 field.
	UOTGHS_DEVEPT_EPRST5_Msk = 0x200000
	// Bit EPRST5.
	UOTGHS_DEVEPT_EPRST5 = 0x200000
	// Position of EPRST6 field.
	UOTGHS_DEVEPT_EPRST6_Pos = 0x16
	// Bit mask of EPRST6 field.
	UOTGHS_DEVEPT_EPRST6_Msk = 0x400000
	// Bit EPRST6.
	UOTGHS_DEVEPT_EPRST6 = 0x400000
	// Position of EPRST7 field.
	UOTGHS_DEVEPT_EPRST7_Pos = 0x17
	// Bit mask of EPRST7 field.
	UOTGHS_DEVEPT_EPRST7_Msk = 0x800000
	// Bit EPRST7.
	UOTGHS_DEVEPT_EPRST7 = 0x800000
	// Position of EPRST8 field.
	UOTGHS_DEVEPT_EPRST8_Pos = 0x18
	// Bit mask of EPRST8 field.
	UOTGHS_DEVEPT_EPRST8_Msk = 0x1000000
	// Bit EPRST8.
	UOTGHS_DEVEPT_EPRST8 = 0x1000000

	// DEVFNUM: Device Frame Number Register
	// Position of MFNUM field.
	UOTGHS_DEVFNUM_MFNUM_Pos = 0x0
	// Bit mask of MFNUM field.
	UOTGHS_DEVFNUM_MFNUM_Msk = 0x7
	// Position of FNUM field.
	UOTGHS_DEVFNUM_FNUM_Pos = 0x3
	// Bit mask of FNUM field.
	UOTGHS_DEVFNUM_FNUM_Msk = 0x3ff8
	// Position of FNCERR field.
	UOTGHS_DEVFNUM_FNCERR_Pos = 0xf
	// Bit mask of FNCERR field.
	UOTGHS_DEVFNUM_FNCERR_Msk = 0x8000
	// Bit FNCERR.
	UOTGHS_DEVFNUM_FNCERR = 0x8000

	// DEVEPTCFG: Device Endpoint Configuration Register (n = 0)
	// Position of ALLOC field.
	UOTGHS_DEVEPTCFG_ALLOC_Pos = 0x1
	// Bit mask of ALLOC field.
	UOTGHS_DEVEPTCFG_ALLOC_Msk = 0x2
	// Bit ALLOC.
	UOTGHS_DEVEPTCFG_ALLOC = 0x2
	// Position of EPBK field.
	UOTGHS_DEVEPTCFG_EPBK_Pos = 0x2
	// Bit mask of EPBK field.
	UOTGHS_DEVEPTCFG_EPBK_Msk = 0xc
	// Single-bank endpoint
	UOTGHS_DEVEPTCFG_EPBK_1_BANK = 0x0
	// Double-bank endpoint
	UOTGHS_DEVEPTCFG_EPBK_2_BANK = 0x1
	// Triple-bank endpoint
	UOTGHS_DEVEPTCFG_EPBK_3_BANK = 0x2
	// Position of EPSIZE field.
	UOTGHS_DEVEPTCFG_EPSIZE_Pos = 0x4
	// Bit mask of EPSIZE field.
	UOTGHS_DEVEPTCFG_EPSIZE_Msk = 0x70
	// 8 bytes
	UOTGHS_DEVEPTCFG_EPSIZE_8_BYTE = 0x0
	// 16 bytes
	UOTGHS_DEVEPTCFG_EPSIZE_16_BYTE = 0x1
	// 32 bytes
	UOTGHS_DEVEPTCFG_EPSIZE_32_BYTE = 0x2
	// 64 bytes
	UOTGHS_DEVEPTCFG_EPSIZE_64_BYTE = 0x3
	// 128 bytes
	UOTGHS_DEVEPTCFG_EPSIZE_128_BYTE = 0x4
	// 256 bytes
	UOTGHS_DEVEPTCFG_EPSIZE_256_BYTE = 0x5
	// 512 bytes
	UOTGHS_DEVEPTCFG_EPSIZE_512_BYTE = 0x6
	// 1024 bytes
	UOTGHS_DEVEPTCFG_EPSIZE_1024_BYTE = 0x7
	// Position of EPDIR field.
	UOTGHS_DEVEPTCFG_EPDIR_Pos = 0x8
	// Bit mask of EPDIR field.
	UOTGHS_DEVEPTCFG_EPDIR_Msk = 0x100
	// Bit EPDIR.
	UOTGHS_DEVEPTCFG_EPDIR = 0x100
	// The endpoint direction is OUT.
	UOTGHS_DEVEPTCFG_EPDIR_OUT = 0x0
	// The endpoint direction is IN (nor for control endpoints).
	UOTGHS_DEVEPTCFG_EPDIR_IN = 0x1
	// Position of AUTOSW field.
	UOTGHS_DEVEPTCFG_AUTOSW_Pos = 0x9
	// Bit mask of AUTOSW field.
	UOTGHS_DEVEPTCFG_AUTOSW_Msk = 0x200
	// Bit AUTOSW.
	UOTGHS_DEVEPTCFG_AUTOSW = 0x200
	// Position of EPTYPE field.
	UOTGHS_DEVEPTCFG_EPTYPE_Pos = 0xb
	// Bit mask of EPTYPE field.
	UOTGHS_DEVEPTCFG_EPTYPE_Msk = 0x1800
	// Control
	UOTGHS_DEVEPTCFG_EPTYPE_CTRL = 0x0
	// Isochronous
	UOTGHS_DEVEPTCFG_EPTYPE_ISO = 0x1
	// Bulk
	UOTGHS_DEVEPTCFG_EPTYPE_BLK = 0x2
	// Interrupt
	UOTGHS_DEVEPTCFG_EPTYPE_INTRPT = 0x3
	// Position of NBTRANS field.
	UOTGHS_DEVEPTCFG_NBTRANS_Pos = 0xd
	// Bit mask of NBTRANS field.
	UOTGHS_DEVEPTCFG_NBTRANS_Msk = 0x6000
	// reserved to endpoint that does not have the high-bandwidth isochronous capability.
	UOTGHS_DEVEPTCFG_NBTRANS_0_TRANS = 0x0
	// default value: one transaction per micro-frame.
	UOTGHS_DEVEPTCFG_NBTRANS_1_TRANS = 0x1
	// 2 transactions per micro-frame. This endpoint should be configured as double-bank.
	UOTGHS_DEVEPTCFG_NBTRANS_2_TRANS = 0x2
	// 3 transactions per micro-frame. This endpoint should be configured as triple-bank.
	UOTGHS_DEVEPTCFG_NBTRANS_3_TRANS = 0x3

	// DEVEPTISR: Device Endpoint Status Register (n = 0)
	// Position of TXINI field.
	UOTGHS_DEVEPTISR_TXINI_Pos = 0x0
	// Bit mask of TXINI field.
	UOTGHS_DEVEPTISR_TXINI_Msk = 0x1
	// Bit TXINI.
	UOTGHS_DEVEPTISR_TXINI = 0x1
	// Position of RXOUTI field.
	UOTGHS_DEVEPTISR_RXOUTI_Pos = 0x1
	// Bit mask of RXOUTI field.
	UOTGHS_DEVEPTISR_RXOUTI_Msk = 0x2
	// Bit RXOUTI.
	UOTGHS_DEVEPTISR_RXOUTI = 0x2
	// Position of RXSTPI field.
	UOTGHS_DEVEPTISR_RXSTPI_Pos = 0x2
	// Bit mask of RXSTPI field.
	UOTGHS_DEVEPTISR_RXSTPI_Msk = 0x4
	// Bit RXSTPI.
	UOTGHS_DEVEPTISR_RXSTPI = 0x4
	// Position of NAKOUTI field.
	UOTGHS_DEVEPTISR_NAKOUTI_Pos = 0x3
	// Bit mask of NAKOUTI field.
	UOTGHS_DEVEPTISR_NAKOUTI_Msk = 0x8
	// Bit NAKOUTI.
	UOTGHS_DEVEPTISR_NAKOUTI = 0x8
	// Position of NAKINI field.
	UOTGHS_DEVEPTISR_NAKINI_Pos = 0x4
	// Bit mask of NAKINI field.
	UOTGHS_DEVEPTISR_NAKINI_Msk = 0x10
	// Bit NAKINI.
	UOTGHS_DEVEPTISR_NAKINI = 0x10
	// Position of OVERFI field.
	UOTGHS_DEVEPTISR_OVERFI_Pos = 0x5
	// Bit mask of OVERFI field.
	UOTGHS_DEVEPTISR_OVERFI_Msk = 0x20
	// Bit OVERFI.
	UOTGHS_DEVEPTISR_OVERFI = 0x20
	// Position of STALLEDI field.
	UOTGHS_DEVEPTISR_STALLEDI_Pos = 0x6
	// Bit mask of STALLEDI field.
	UOTGHS_DEVEPTISR_STALLEDI_Msk = 0x40
	// Bit STALLEDI.
	UOTGHS_DEVEPTISR_STALLEDI = 0x40
	// Position of SHORTPACKET field.
	UOTGHS_DEVEPTISR_SHORTPACKET_Pos = 0x7
	// Bit mask of SHORTPACKET field.
	UOTGHS_DEVEPTISR_SHORTPACKET_Msk = 0x80
	// Bit SHORTPACKET.
	UOTGHS_DEVEPTISR_SHORTPACKET = 0x80
	// Position of DTSEQ field.
	UOTGHS_DEVEPTISR_DTSEQ_Pos = 0x8
	// Bit mask of DTSEQ field.
	UOTGHS_DEVEPTISR_DTSEQ_Msk = 0x300
	// Data0 toggle sequence
	UOTGHS_DEVEPTISR_DTSEQ_DATA0 = 0x0
	// Data1 toggle sequence
	UOTGHS_DEVEPTISR_DTSEQ_DATA1 = 0x1
	// Reserved for high-bandwidth isochronous endpoint
	UOTGHS_DEVEPTISR_DTSEQ_DATA2 = 0x2
	// Reserved for high-bandwidth isochronous endpoint
	UOTGHS_DEVEPTISR_DTSEQ_MDATA = 0x3
	// Position of NBUSYBK field.
	UOTGHS_DEVEPTISR_NBUSYBK_Pos = 0xc
	// Bit mask of NBUSYBK field.
	UOTGHS_DEVEPTISR_NBUSYBK_Msk = 0x3000
	// 0 busy bank (all banks free)
	UOTGHS_DEVEPTISR_NBUSYBK_0_BUSY = 0x0
	// 1 busy bank
	UOTGHS_DEVEPTISR_NBUSYBK_1_BUSY = 0x1
	// 2 busy banks
	UOTGHS_DEVEPTISR_NBUSYBK_2_BUSY = 0x2
	// 3 busy banks
	UOTGHS_DEVEPTISR_NBUSYBK_3_BUSY = 0x3
	// Position of CURRBK field.
	UOTGHS_DEVEPTISR_CURRBK_Pos = 0xe
	// Bit mask of CURRBK field.
	UOTGHS_DEVEPTISR_CURRBK_Msk = 0xc000
	// Current bank is bank0
	UOTGHS_DEVEPTISR_CURRBK_BANK0 = 0x0
	// Current bank is bank1
	UOTGHS_DEVEPTISR_CURRBK_BANK1 = 0x1
	// Current bank is bank2
	UOTGHS_DEVEPTISR_CURRBK_BANK2 = 0x2
	// Position of RWALL field.
	UOTGHS_DEVEPTISR_RWALL_Pos = 0x10
	// Bit mask of RWALL field.
	UOTGHS_DEVEPTISR_RWALL_Msk = 0x10000
	// Bit RWALL.
	UOTGHS_DEVEPTISR_RWALL = 0x10000
	// Position of CTRLDIR field.
	UOTGHS_DEVEPTISR_CTRLDIR_Pos = 0x11
	// Bit mask of CTRLDIR field.
	UOTGHS_DEVEPTISR_CTRLDIR_Msk = 0x20000
	// Bit CTRLDIR.
	UOTGHS_DEVEPTISR_CTRLDIR = 0x20000
	// Position of CFGOK field.
	UOTGHS_DEVEPTISR_CFGOK_Pos = 0x12
	// Bit mask of CFGOK field.
	UOTGHS_DEVEPTISR_CFGOK_Msk = 0x40000
	// Bit CFGOK.
	UOTGHS_DEVEPTISR_CFGOK = 0x40000
	// Position of BYCT field.
	UOTGHS_DEVEPTISR_BYCT_Pos = 0x14
	// Bit mask of BYCT field.
	UOTGHS_DEVEPTISR_BYCT_Msk = 0x7ff00000

	// DEVEPTISR0_ISOENPT: Device Endpoint Status Register (n = 0)
	// Position of TXINI field.
	UOTGHS_DEVEPTISR0_ISOENPT_TXINI_Pos = 0x0
	// Bit mask of TXINI field.
	UOTGHS_DEVEPTISR0_ISOENPT_TXINI_Msk = 0x1
	// Bit TXINI.
	UOTGHS_DEVEPTISR0_ISOENPT_TXINI = 0x1
	// Position of RXOUTI field.
	UOTGHS_DEVEPTISR0_ISOENPT_RXOUTI_Pos = 0x1
	// Bit mask of RXOUTI field.
	UOTGHS_DEVEPTISR0_ISOENPT_RXOUTI_Msk = 0x2
	// Bit RXOUTI.
	UOTGHS_DEVEPTISR0_ISOENPT_RXOUTI = 0x2
	// Position of UNDERFI field.
	UOTGHS_DEVEPTISR0_ISOENPT_UNDERFI_Pos = 0x2
	// Bit mask of UNDERFI field.
	UOTGHS_DEVEPTISR0_ISOENPT_UNDERFI_Msk = 0x4
	// Bit UNDERFI.
	UOTGHS_DEVEPTISR0_ISOENPT_UNDERFI = 0x4
	// Position of HBISOINERRI field.
	UOTGHS_DEVEPTISR0_ISOENPT_HBISOINERRI_Pos = 0x3
	// Bit mask of HBISOINERRI field.
	UOTGHS_DEVEPTISR0_ISOENPT_HBISOINERRI_Msk = 0x8
	// Bit HBISOINERRI.
	UOTGHS_DEVEPTISR0_ISOENPT_HBISOINERRI = 0x8
	// Position of HBISOFLUSHI field.
	UOTGHS_DEVEPTISR0_ISOENPT_HBISOFLUSHI_Pos = 0x4
	// Bit mask of HBISOFLUSHI field.
	UOTGHS_DEVEPTISR0_ISOENPT_HBISOFLUSHI_Msk = 0x10
	// Bit HBISOFLUSHI.
	UOTGHS_DEVEPTISR0_ISOENPT_HBISOFLUSHI = 0x10
	// Position of OVERFI field.
	UOTGHS_DEVEPTISR0_ISOENPT_OVERFI_Pos = 0x5
	// Bit mask of OVERFI field.
	UOTGHS_DEVEPTISR0_ISOENPT_OVERFI_Msk = 0x20
	// Bit OVERFI.
	UOTGHS_DEVEPTISR0_ISOENPT_OVERFI = 0x20
	// Position of CRCERRI field.
	UOTGHS_DEVEPTISR0_ISOENPT_CRCERRI_Pos = 0x6
	// Bit mask of CRCERRI field.
	UOTGHS_DEVEPTISR0_ISOENPT_CRCERRI_Msk = 0x40
	// Bit CRCERRI.
	UOTGHS_DEVEPTISR0_ISOENPT_CRCERRI = 0x40
	// Position of SHORTPACKET field.
	UOTGHS_DEVEPTISR0_ISOENPT_SHORTPACKET_Pos = 0x7
	// Bit mask of SHORTPACKET field.
	UOTGHS_DEVEPTISR0_ISOENPT_SHORTPACKET_Msk = 0x80
	// Bit SHORTPACKET.
	UOTGHS_DEVEPTISR0_ISOENPT_SHORTPACKET = 0x80
	// Position of DTSEQ field.
	UOTGHS_DEVEPTISR0_ISOENPT_DTSEQ_Pos = 0x8
	// Bit mask of DTSEQ field.
	UOTGHS_DEVEPTISR0_ISOENPT_DTSEQ_Msk = 0x300
	// Data0 toggle sequence
	UOTGHS_DEVEPTISR0_ISOENPT_DTSEQ_DATA0 = 0x0
	// Data1 toggle sequence
	UOTGHS_DEVEPTISR0_ISOENPT_DTSEQ_DATA1 = 0x1
	// Data2 toggle sequence (for high-bandwidth isochronous endpoint)
	UOTGHS_DEVEPTISR0_ISOENPT_DTSEQ_DATA2 = 0x2
	// MData toggle sequence (for high-bandwidth isochronous endpoint)
	UOTGHS_DEVEPTISR0_ISOENPT_DTSEQ_MDATA = 0x3
	// Position of ERRORTRANS field.
	UOTGHS_DEVEPTISR0_ISOENPT_ERRORTRANS_Pos = 0xa
	// Bit mask of ERRORTRANS field.
	UOTGHS_DEVEPTISR0_ISOENPT_ERRORTRANS_Msk = 0x400
	// Bit ERRORTRANS.
	UOTGHS_DEVEPTISR0_ISOENPT_ERRORTRANS = 0x400
	// Position of NBUSYBK field.
	UOTGHS_DEVEPTISR0_ISOENPT_NBUSYBK_Pos = 0xc
	// Bit mask of NBUSYBK field.
	UOTGHS_DEVEPTISR0_ISOENPT_NBUSYBK_Msk = 0x3000
	// 0 busy bank (all banks free)
	UOTGHS_DEVEPTISR0_ISOENPT_NBUSYBK_0_BUSY = 0x0
	// 1 busy bank
	UOTGHS_DEVEPTISR0_ISOENPT_NBUSYBK_1_BUSY = 0x1
	// 2 busy banks
	UOTGHS_DEVEPTISR0_ISOENPT_NBUSYBK_2_BUSY = 0x2
	// 3 busy banks
	UOTGHS_DEVEPTISR0_ISOENPT_NBUSYBK_3_BUSY = 0x3
	// Position of CURRBK field.
	UOTGHS_DEVEPTISR0_ISOENPT_CURRBK_Pos = 0xe
	// Bit mask of CURRBK field.
	UOTGHS_DEVEPTISR0_ISOENPT_CURRBK_Msk = 0xc000
	// Current bank is bank0
	UOTGHS_DEVEPTISR0_ISOENPT_CURRBK_BANK0 = 0x0
	// Current bank is bank1
	UOTGHS_DEVEPTISR0_ISOENPT_CURRBK_BANK1 = 0x1
	// Current bank is bank2
	UOTGHS_DEVEPTISR0_ISOENPT_CURRBK_BANK2 = 0x2
	// Position of RWALL field.
	UOTGHS_DEVEPTISR0_ISOENPT_RWALL_Pos = 0x10
	// Bit mask of RWALL field.
	UOTGHS_DEVEPTISR0_ISOENPT_RWALL_Msk = 0x10000
	// Bit RWALL.
	UOTGHS_DEVEPTISR0_ISOENPT_RWALL = 0x10000
	// Position of CFGOK field.
	UOTGHS_DEVEPTISR0_ISOENPT_CFGOK_Pos = 0x12
	// Bit mask of CFGOK field.
	UOTGHS_DEVEPTISR0_ISOENPT_CFGOK_Msk = 0x40000
	// Bit CFGOK.
	UOTGHS_DEVEPTISR0_ISOENPT_CFGOK = 0x40000
	// Position of BYCT field.
	UOTGHS_DEVEPTISR0_ISOENPT_BYCT_Pos = 0x14
	// Bit mask of BYCT field.
	UOTGHS_DEVEPTISR0_ISOENPT_BYCT_Msk = 0x7ff00000

	// DEVEPTICR: Device Endpoint Clear Register (n = 0)
	// Position of TXINIC field.
	UOTGHS_DEVEPTICR_TXINIC_Pos = 0x0
	// Bit mask of TXINIC field.
	UOTGHS_DEVEPTICR_TXINIC_Msk = 0x1
	// Bit TXINIC.
	UOTGHS_DEVEPTICR_TXINIC = 0x1
	// Position of RXOUTIC field.
	UOTGHS_DEVEPTICR_RXOUTIC_Pos = 0x1
	// Bit mask of RXOUTIC field.
	UOTGHS_DEVEPTICR_RXOUTIC_Msk = 0x2
	// Bit RXOUTIC.
	UOTGHS_DEVEPTICR_RXOUTIC = 0x2
	// Position of RXSTPIC field.
	UOTGHS_DEVEPTICR_RXSTPIC_Pos = 0x2
	// Bit mask of RXSTPIC field.
	UOTGHS_DEVEPTICR_RXSTPIC_Msk = 0x4
	// Bit RXSTPIC.
	UOTGHS_DEVEPTICR_RXSTPIC = 0x4
	// Position of NAKOUTIC field.
	UOTGHS_DEVEPTICR_NAKOUTIC_Pos = 0x3
	// Bit mask of NAKOUTIC field.
	UOTGHS_DEVEPTICR_NAKOUTIC_Msk = 0x8
	// Bit NAKOUTIC.
	UOTGHS_DEVEPTICR_NAKOUTIC = 0x8
	// Position of NAKINIC field.
	UOTGHS_DEVEPTICR_NAKINIC_Pos = 0x4
	// Bit mask of NAKINIC field.
	UOTGHS_DEVEPTICR_NAKINIC_Msk = 0x10
	// Bit NAKINIC.
	UOTGHS_DEVEPTICR_NAKINIC = 0x10
	// Position of OVERFIC field.
	UOTGHS_DEVEPTICR_OVERFIC_Pos = 0x5
	// Bit mask of OVERFIC field.
	UOTGHS_DEVEPTICR_OVERFIC_Msk = 0x20
	// Bit OVERFIC.
	UOTGHS_DEVEPTICR_OVERFIC = 0x20
	// Position of STALLEDIC field.
	UOTGHS_DEVEPTICR_STALLEDIC_Pos = 0x6
	// Bit mask of STALLEDIC field.
	UOTGHS_DEVEPTICR_STALLEDIC_Msk = 0x40
	// Bit STALLEDIC.
	UOTGHS_DEVEPTICR_STALLEDIC = 0x40
	// Position of SHORTPACKETC field.
	UOTGHS_DEVEPTICR_SHORTPACKETC_Pos = 0x7
	// Bit mask of SHORTPACKETC field.
	UOTGHS_DEVEPTICR_SHORTPACKETC_Msk = 0x80
	// Bit SHORTPACKETC.
	UOTGHS_DEVEPTICR_SHORTPACKETC = 0x80

	// DEVEPTICR0_ISOENPT: Device Endpoint Clear Register (n = 0)
	// Position of TXINIC field.
	UOTGHS_DEVEPTICR0_ISOENPT_TXINIC_Pos = 0x0
	// Bit mask of TXINIC field.
	UOTGHS_DEVEPTICR0_ISOENPT_TXINIC_Msk = 0x1
	// Bit TXINIC.
	UOTGHS_DEVEPTICR0_ISOENPT_TXINIC = 0x1
	// Position of RXOUTIC field.
	UOTGHS_DEVEPTICR0_ISOENPT_RXOUTIC_Pos = 0x1
	// Bit mask of RXOUTIC field.
	UOTGHS_DEVEPTICR0_ISOENPT_RXOUTIC_Msk = 0x2
	// Bit RXOUTIC.
	UOTGHS_DEVEPTICR0_ISOENPT_RXOUTIC = 0x2
	// Position of UNDERFIC field.
	UOTGHS_DEVEPTICR0_ISOENPT_UNDERFIC_Pos = 0x2
	// Bit mask of UNDERFIC field.
	UOTGHS_DEVEPTICR0_ISOENPT_UNDERFIC_Msk = 0x4
	// Bit UNDERFIC.
	UOTGHS_DEVEPTICR0_ISOENPT_UNDERFIC = 0x4
	// Position of HBISOINERRIC field.
	UOTGHS_DEVEPTICR0_ISOENPT_HBISOINERRIC_Pos = 0x3
	// Bit mask of HBISOINERRIC field.
	UOTGHS_DEVEPTICR0_ISOENPT_HBISOINERRIC_Msk = 0x8
	// Bit HBISOINERRIC.
	UOTGHS_DEVEPTICR0_ISOENPT_HBISOINERRIC = 0x8
	// Position of HBISOFLUSHIC field.
	UOTGHS_DEVEPTICR0_ISOENPT_HBISOFLUSHIC_Pos = 0x4
	// Bit mask of HBISOFLUSHIC field.
	UOTGHS_DEVEPTICR0_ISOENPT_HBISOFLUSHIC_Msk = 0x10
	// Bit HBISOFLUSHIC.
	UOTGHS_DEVEPTICR0_ISOENPT_HBISOFLUSHIC = 0x10
	// Position of OVERFIC field.
	UOTGHS_DEVEPTICR0_ISOENPT_OVERFIC_Pos = 0x5
	// Bit mask of OVERFIC field.
	UOTGHS_DEVEPTICR0_ISOENPT_OVERFIC_Msk = 0x20
	// Bit OVERFIC.
	UOTGHS_DEVEPTICR0_ISOENPT_OVERFIC = 0x20
	// Position of CRCERRIC field.
	UOTGHS_DEVEPTICR0_ISOENPT_CRCERRIC_Pos = 0x6
	// Bit mask of CRCERRIC field.
	UOTGHS_DEVEPTICR0_ISOENPT_CRCERRIC_Msk = 0x40
	// Bit CRCERRIC.
	UOTGHS_DEVEPTICR0_ISOENPT_CRCERRIC = 0x40
	// Position of SHORTPACKETC field.
	UOTGHS_DEVEPTICR0_ISOENPT_SHORTPACKETC_Pos = 0x7
	// Bit mask of SHORTPACKETC field.
	UOTGHS_DEVEPTICR0_ISOENPT_SHORTPACKETC_Msk = 0x80
	// Bit SHORTPACKETC.
	UOTGHS_DEVEPTICR0_ISOENPT_SHORTPACKETC = 0x80

	// DEVEPTIFR: Device Endpoint Set Register (n = 0)
	// Position of TXINIS field.
	UOTGHS_DEVEPTIFR_TXINIS_Pos = 0x0
	// Bit mask of TXINIS field.
	UOTGHS_DEVEPTIFR_TXINIS_Msk = 0x1
	// Bit TXINIS.
	UOTGHS_DEVEPTIFR_TXINIS = 0x1
	// Position of RXOUTIS field.
	UOTGHS_DEVEPTIFR_RXOUTIS_Pos = 0x1
	// Bit mask of RXOUTIS field.
	UOTGHS_DEVEPTIFR_RXOUTIS_Msk = 0x2
	// Bit RXOUTIS.
	UOTGHS_DEVEPTIFR_RXOUTIS = 0x2
	// Position of RXSTPIS field.
	UOTGHS_DEVEPTIFR_RXSTPIS_Pos = 0x2
	// Bit mask of RXSTPIS field.
	UOTGHS_DEVEPTIFR_RXSTPIS_Msk = 0x4
	// Bit RXSTPIS.
	UOTGHS_DEVEPTIFR_RXSTPIS = 0x4
	// Position of NAKOUTIS field.
	UOTGHS_DEVEPTIFR_NAKOUTIS_Pos = 0x3
	// Bit mask of NAKOUTIS field.
	UOTGHS_DEVEPTIFR_NAKOUTIS_Msk = 0x8
	// Bit NAKOUTIS.
	UOTGHS_DEVEPTIFR_NAKOUTIS = 0x8
	// Position of NAKINIS field.
	UOTGHS_DEVEPTIFR_NAKINIS_Pos = 0x4
	// Bit mask of NAKINIS field.
	UOTGHS_DEVEPTIFR_NAKINIS_Msk = 0x10
	// Bit NAKINIS.
	UOTGHS_DEVEPTIFR_NAKINIS = 0x10
	// Position of OVERFIS field.
	UOTGHS_DEVEPTIFR_OVERFIS_Pos = 0x5
	// Bit mask of OVERFIS field.
	UOTGHS_DEVEPTIFR_OVERFIS_Msk = 0x20
	// Bit OVERFIS.
	UOTGHS_DEVEPTIFR_OVERFIS = 0x20
	// Position of STALLEDIS field.
	UOTGHS_DEVEPTIFR_STALLEDIS_Pos = 0x6
	// Bit mask of STALLEDIS field.
	UOTGHS_DEVEPTIFR_STALLEDIS_Msk = 0x40
	// Bit STALLEDIS.
	UOTGHS_DEVEPTIFR_STALLEDIS = 0x40
	// Position of SHORTPACKETS field.
	UOTGHS_DEVEPTIFR_SHORTPACKETS_Pos = 0x7
	// Bit mask of SHORTPACKETS field.
	UOTGHS_DEVEPTIFR_SHORTPACKETS_Msk = 0x80
	// Bit SHORTPACKETS.
	UOTGHS_DEVEPTIFR_SHORTPACKETS = 0x80
	// Position of NBUSYBKS field.
	UOTGHS_DEVEPTIFR_NBUSYBKS_Pos = 0xc
	// Bit mask of NBUSYBKS field.
	UOTGHS_DEVEPTIFR_NBUSYBKS_Msk = 0x1000
	// Bit NBUSYBKS.
	UOTGHS_DEVEPTIFR_NBUSYBKS = 0x1000

	// DEVEPTIFR0_ISOENPT: Device Endpoint Set Register (n = 0)
	// Position of TXINIS field.
	UOTGHS_DEVEPTIFR0_ISOENPT_TXINIS_Pos = 0x0
	// Bit mask of TXINIS field.
	UOTGHS_DEVEPTIFR0_ISOENPT_TXINIS_Msk = 0x1
	// Bit TXINIS.
	UOTGHS_DEVEPTIFR0_ISOENPT_TXINIS = 0x1
	// Position of RXOUTIS field.
	UOTGHS_DEVEPTIFR0_ISOENPT_RXOUTIS_Pos = 0x1
	// Bit mask of RXOUTIS field.
	UOTGHS_DEVEPTIFR0_ISOENPT_RXOUTIS_Msk = 0x2
	// Bit RXOUTIS.
	UOTGHS_DEVEPTIFR0_ISOENPT_RXOUTIS = 0x2
	// Position of UNDERFIS field.
	UOTGHS_DEVEPTIFR0_ISOENPT_UNDERFIS_Pos = 0x2
	// Bit mask of UNDERFIS field.
	UOTGHS_DEVEPTIFR0_ISOENPT_UNDERFIS_Msk = 0x4
	// Bit UNDERFIS.
	UOTGHS_DEVEPTIFR0_ISOENPT_UNDERFIS = 0x4
	// Position of HBISOINERRIS field.
	UOTGHS_DEVEPTIFR0_ISOENPT_HBISOINERRIS_Pos = 0x3
	// Bit mask of HBISOINERRIS field.
	UOTGHS_DEVEPTIFR0_ISOENPT_HBISOINERRIS_Msk = 0x8
	// Bit HBISOINERRIS.
	UOTGHS_DEVEPTIFR0_ISOENPT_HBISOINERRIS = 0x8
	// Position of HBISOFLUSHIS field.
	UOTGHS_DEVEPTIFR0_ISOENPT_HBISOFLUSHIS_Pos = 0x4
	// Bit mask of HBISOFLUSHIS field.
	UOTGHS_DEVEPTIFR0_ISOENPT_HBISOFLUSHIS_Msk = 0x10
	// Bit HBISOFLUSHIS.
	UOTGHS_DEVEPTIFR0_ISOENPT_HBISOFLUSHIS = 0x10
	// Position of OVERFIS field.
	UOTGHS_DEVEPTIFR0_ISOENPT_OVERFIS_Pos = 0x5
	// Bit mask of OVERFIS field.
	UOTGHS_DEVEPTIFR0_ISOENPT_OVERFIS_Msk = 0x20
	// Bit OVERFIS.
	UOTGHS_DEVEPTIFR0_ISOENPT_OVERFIS = 0x20
	// Position of CRCERRIS field.
	UOTGHS_DEVEPTIFR0_ISOENPT_CRCERRIS_Pos = 0x6
	// Bit mask of CRCERRIS field.
	UOTGHS_DEVEPTIFR0_ISOENPT_CRCERRIS_Msk = 0x40
	// Bit CRCERRIS.
	UOTGHS_DEVEPTIFR0_ISOENPT_CRCERRIS = 0x40
	// Position of SHORTPACKETS field.
	UOTGHS_DEVEPTIFR0_ISOENPT_SHORTPACKETS_Pos = 0x7
	// Bit mask of SHORTPACKETS field.
	UOTGHS_DEVEPTIFR0_ISOENPT_SHORTPACKETS_Msk = 0x80
	// Bit SHORTPACKETS.
	UOTGHS_DEVEPTIFR0_ISOENPT_SHORTPACKETS = 0x80
	// Position of NBUSYBKS field.
	UOTGHS_DEVEPTIFR0_ISOENPT_NBUSYBKS_Pos = 0xc
	// Bit mask of NBUSYBKS field.
	UOTGHS_DEVEPTIFR0_ISOENPT_NBUSYBKS_Msk = 0x1000
	// Bit NBUSYBKS.
	UOTGHS_DEVEPTIFR0_ISOENPT_NBUSYBKS = 0x1000

	// DEVEPTIMR: Device Endpoint Mask Register (n = 0)
	// Position of TXINE field.
	UOTGHS_DEVEPTIMR_TXINE_Pos = 0x0
	// Bit mask of TXINE field.
	UOTGHS_DEVEPTIMR_TXINE_Msk = 0x1
	// Bit TXINE.
	UOTGHS_DEVEPTIMR_TXINE = 0x1
	// Position of RXOUTE field.
	UOTGHS_DEVEPTIMR_RXOUTE_Pos = 0x1
	// Bit mask of RXOUTE field.
	UOTGHS_DEVEPTIMR_RXOUTE_Msk = 0x2
	// Bit RXOUTE.
	UOTGHS_DEVEPTIMR_RXOUTE = 0x2
	// Position of RXSTPE field.
	UOTGHS_DEVEPTIMR_RXSTPE_Pos = 0x2
	// Bit mask of RXSTPE field.
	UOTGHS_DEVEPTIMR_RXSTPE_Msk = 0x4
	// Bit RXSTPE.
	UOTGHS_DEVEPTIMR_RXSTPE = 0x4
	// Position of NAKOUTE field.
	UOTGHS_DEVEPTIMR_NAKOUTE_Pos = 0x3
	// Bit mask of NAKOUTE field.
	UOTGHS_DEVEPTIMR_NAKOUTE_Msk = 0x8
	// Bit NAKOUTE.
	UOTGHS_DEVEPTIMR_NAKOUTE = 0x8
	// Position of NAKINE field.
	UOTGHS_DEVEPTIMR_NAKINE_Pos = 0x4
	// Bit mask of NAKINE field.
	UOTGHS_DEVEPTIMR_NAKINE_Msk = 0x10
	// Bit NAKINE.
	UOTGHS_DEVEPTIMR_NAKINE = 0x10
	// Position of OVERFE field.
	UOTGHS_DEVEPTIMR_OVERFE_Pos = 0x5
	// Bit mask of OVERFE field.
	UOTGHS_DEVEPTIMR_OVERFE_Msk = 0x20
	// Bit OVERFE.
	UOTGHS_DEVEPTIMR_OVERFE = 0x20
	// Position of STALLEDE field.
	UOTGHS_DEVEPTIMR_STALLEDE_Pos = 0x6
	// Bit mask of STALLEDE field.
	UOTGHS_DEVEPTIMR_STALLEDE_Msk = 0x40
	// Bit STALLEDE.
	UOTGHS_DEVEPTIMR_STALLEDE = 0x40
	// Position of SHORTPACKETE field.
	UOTGHS_DEVEPTIMR_SHORTPACKETE_Pos = 0x7
	// Bit mask of SHORTPACKETE field.
	UOTGHS_DEVEPTIMR_SHORTPACKETE_Msk = 0x80
	// Bit SHORTPACKETE.
	UOTGHS_DEVEPTIMR_SHORTPACKETE = 0x80
	// Position of NBUSYBKE field.
	UOTGHS_DEVEPTIMR_NBUSYBKE_Pos = 0xc
	// Bit mask of NBUSYBKE field.
	UOTGHS_DEVEPTIMR_NBUSYBKE_Msk = 0x1000
	// Bit NBUSYBKE.
	UOTGHS_DEVEPTIMR_NBUSYBKE = 0x1000
	// Position of KILLBK field.
	UOTGHS_DEVEPTIMR_KILLBK_Pos = 0xd
	// Bit mask of KILLBK field.
	UOTGHS_DEVEPTIMR_KILLBK_Msk = 0x2000
	// Bit KILLBK.
	UOTGHS_DEVEPTIMR_KILLBK = 0x2000
	// Position of FIFOCON field.
	UOTGHS_DEVEPTIMR_FIFOCON_Pos = 0xe
	// Bit mask of FIFOCON field.
	UOTGHS_DEVEPTIMR_FIFOCON_Msk = 0x4000
	// Bit FIFOCON.
	UOTGHS_DEVEPTIMR_FIFOCON = 0x4000
	// Position of EPDISHDMA field.
	UOTGHS_DEVEPTIMR_EPDISHDMA_Pos = 0x10
	// Bit mask of EPDISHDMA field.
	UOTGHS_DEVEPTIMR_EPDISHDMA_Msk = 0x10000
	// Bit EPDISHDMA.
	UOTGHS_DEVEPTIMR_EPDISHDMA = 0x10000
	// Position of NYETDIS field.
	UOTGHS_DEVEPTIMR_NYETDIS_Pos = 0x11
	// Bit mask of NYETDIS field.
	UOTGHS_DEVEPTIMR_NYETDIS_Msk = 0x20000
	// Bit NYETDIS.
	UOTGHS_DEVEPTIMR_NYETDIS = 0x20000
	// Position of RSTDT field.
	UOTGHS_DEVEPTIMR_RSTDT_Pos = 0x12
	// Bit mask of RSTDT field.
	UOTGHS_DEVEPTIMR_RSTDT_Msk = 0x40000
	// Bit RSTDT.
	UOTGHS_DEVEPTIMR_RSTDT = 0x40000
	// Position of STALLRQ field.
	UOTGHS_DEVEPTIMR_STALLRQ_Pos = 0x13
	// Bit mask of STALLRQ field.
	UOTGHS_DEVEPTIMR_STALLRQ_Msk = 0x80000
	// Bit STALLRQ.
	UOTGHS_DEVEPTIMR_STALLRQ = 0x80000

	// DEVEPTIMR0_ISOENPT: Device Endpoint Mask Register (n = 0)
	// Position of TXINE field.
	UOTGHS_DEVEPTIMR0_ISOENPT_TXINE_Pos = 0x0
	// Bit mask of TXINE field.
	UOTGHS_DEVEPTIMR0_ISOENPT_TXINE_Msk = 0x1
	// Bit TXINE.
	UOTGHS_DEVEPTIMR0_ISOENPT_TXINE = 0x1
	// Position of RXOUTE field.
	UOTGHS_DEVEPTIMR0_ISOENPT_RXOUTE_Pos = 0x1
	// Bit mask of RXOUTE field.
	UOTGHS_DEVEPTIMR0_ISOENPT_RXOUTE_Msk = 0x2
	// Bit RXOUTE.
	UOTGHS_DEVEPTIMR0_ISOENPT_RXOUTE = 0x2
	// Position of UNDERFE field.
	UOTGHS_DEVEPTIMR0_ISOENPT_UNDERFE_Pos = 0x2
	// Bit mask of UNDERFE field.
	UOTGHS_DEVEPTIMR0_ISOENPT_UNDERFE_Msk = 0x4
	// Bit UNDERFE.
	UOTGHS_DEVEPTIMR0_ISOENPT_UNDERFE = 0x4
	// Position of HBISOINERRE field.
	UOTGHS_DEVEPTIMR0_ISOENPT_HBISOINERRE_Pos = 0x3
	// Bit mask of HBISOINERRE field.
	UOTGHS_DEVEPTIMR0_ISOENPT_HBISOINERRE_Msk = 0x8
	// Bit HBISOINERRE.
	UOTGHS_DEVEPTIMR0_ISOENPT_HBISOINERRE = 0x8
	// Position of HBISOFLUSHE field.
	UOTGHS_DEVEPTIMR0_ISOENPT_HBISOFLUSHE_Pos = 0x4
	// Bit mask of HBISOFLUSHE field.
	UOTGHS_DEVEPTIMR0_ISOENPT_HBISOFLUSHE_Msk = 0x10
	// Bit HBISOFLUSHE.
	UOTGHS_DEVEPTIMR0_ISOENPT_HBISOFLUSHE = 0x10
	// Position of OVERFE field.
	UOTGHS_DEVEPTIMR0_ISOENPT_OVERFE_Pos = 0x5
	// Bit mask of OVERFE field.
	UOTGHS_DEVEPTIMR0_ISOENPT_OVERFE_Msk = 0x20
	// Bit OVERFE.
	UOTGHS_DEVEPTIMR0_ISOENPT_OVERFE = 0x20
	// Position of CRCERRE field.
	UOTGHS_DEVEPTIMR0_ISOENPT_CRCERRE_Pos = 0x6
	// Bit mask of CRCERRE field.
	UOTGHS_DEVEPTIMR0_ISOENPT_CRCERRE_Msk = 0x40
	// Bit CRCERRE.
	UOTGHS_DEVEPTIMR0_ISOENPT_CRCERRE = 0x40
	// Position of SHORTPACKETE field.
	UOTGHS_DEVEPTIMR0_ISOENPT_SHORTPACKETE_Pos = 0x7
	// Bit mask of SHORTPACKETE field.
	UOTGHS_DEVEPTIMR0_ISOENPT_SHORTPACKETE_Msk = 0x80
	// Bit SHORTPACKETE.
	UOTGHS_DEVEPTIMR0_ISOENPT_SHORTPACKETE = 0x80
	// Position of MDATAE field.
	UOTGHS_DEVEPTIMR0_ISOENPT_MDATAE_Pos = 0x8
	// Bit mask of MDATAE field.
	UOTGHS_DEVEPTIMR0_ISOENPT_MDATAE_Msk = 0x100
	// Bit MDATAE.
	UOTGHS_DEVEPTIMR0_ISOENPT_MDATAE = 0x100
	// Position of DATAXE field.
	UOTGHS_DEVEPTIMR0_ISOENPT_DATAXE_Pos = 0x9
	// Bit mask of DATAXE field.
	UOTGHS_DEVEPTIMR0_ISOENPT_DATAXE_Msk = 0x200
	// Bit DATAXE.
	UOTGHS_DEVEPTIMR0_ISOENPT_DATAXE = 0x200
	// Position of ERRORTRANSE field.
	UOTGHS_DEVEPTIMR0_ISOENPT_ERRORTRANSE_Pos = 0xa
	// Bit mask of ERRORTRANSE field.
	UOTGHS_DEVEPTIMR0_ISOENPT_ERRORTRANSE_Msk = 0x400
	// Bit ERRORTRANSE.
	UOTGHS_DEVEPTIMR0_ISOENPT_ERRORTRANSE = 0x400
	// Position of NBUSYBKE field.
	UOTGHS_DEVEPTIMR0_ISOENPT_NBUSYBKE_Pos = 0xc
	// Bit mask of NBUSYBKE field.
	UOTGHS_DEVEPTIMR0_ISOENPT_NBUSYBKE_Msk = 0x1000
	// Bit NBUSYBKE.
	UOTGHS_DEVEPTIMR0_ISOENPT_NBUSYBKE = 0x1000
	// Position of KILLBK field.
	UOTGHS_DEVEPTIMR0_ISOENPT_KILLBK_Pos = 0xd
	// Bit mask of KILLBK field.
	UOTGHS_DEVEPTIMR0_ISOENPT_KILLBK_Msk = 0x2000
	// Bit KILLBK.
	UOTGHS_DEVEPTIMR0_ISOENPT_KILLBK = 0x2000
	// Position of FIFOCON field.
	UOTGHS_DEVEPTIMR0_ISOENPT_FIFOCON_Pos = 0xe
	// Bit mask of FIFOCON field.
	UOTGHS_DEVEPTIMR0_ISOENPT_FIFOCON_Msk = 0x4000
	// Bit FIFOCON.
	UOTGHS_DEVEPTIMR0_ISOENPT_FIFOCON = 0x4000
	// Position of EPDISHDMA field.
	UOTGHS_DEVEPTIMR0_ISOENPT_EPDISHDMA_Pos = 0x10
	// Bit mask of EPDISHDMA field.
	UOTGHS_DEVEPTIMR0_ISOENPT_EPDISHDMA_Msk = 0x10000
	// Bit EPDISHDMA.
	UOTGHS_DEVEPTIMR0_ISOENPT_EPDISHDMA = 0x10000
	// Position of RSTDT field.
	UOTGHS_DEVEPTIMR0_ISOENPT_RSTDT_Pos = 0x12
	// Bit mask of RSTDT field.
	UOTGHS_DEVEPTIMR0_ISOENPT_RSTDT_Msk = 0x40000
	// Bit RSTDT.
	UOTGHS_DEVEPTIMR0_ISOENPT_RSTDT = 0x40000

	// DEVEPTIER: Device Endpoint Enable Register (n = 0)
	// Position of TXINES field.
	UOTGHS_DEVEPTIER_TXINES_Pos = 0x0
	// Bit mask of TXINES field.
	UOTGHS_DEVEPTIER_TXINES_Msk = 0x1
	// Bit TXINES.
	UOTGHS_DEVEPTIER_TXINES = 0x1
	// Position of RXOUTES field.
	UOTGHS_DEVEPTIER_RXOUTES_Pos = 0x1
	// Bit mask of RXOUTES field.
	UOTGHS_DEVEPTIER_RXOUTES_Msk = 0x2
	// Bit RXOUTES.
	UOTGHS_DEVEPTIER_RXOUTES = 0x2
	// Position of RXSTPES field.
	UOTGHS_DEVEPTIER_RXSTPES_Pos = 0x2
	// Bit mask of RXSTPES field.
	UOTGHS_DEVEPTIER_RXSTPES_Msk = 0x4
	// Bit RXSTPES.
	UOTGHS_DEVEPTIER_RXSTPES = 0x4
	// Position of NAKOUTES field.
	UOTGHS_DEVEPTIER_NAKOUTES_Pos = 0x3
	// Bit mask of NAKOUTES field.
	UOTGHS_DEVEPTIER_NAKOUTES_Msk = 0x8
	// Bit NAKOUTES.
	UOTGHS_DEVEPTIER_NAKOUTES = 0x8
	// Position of NAKINES field.
	UOTGHS_DEVEPTIER_NAKINES_Pos = 0x4
	// Bit mask of NAKINES field.
	UOTGHS_DEVEPTIER_NAKINES_Msk = 0x10
	// Bit NAKINES.
	UOTGHS_DEVEPTIER_NAKINES = 0x10
	// Position of OVERFES field.
	UOTGHS_DEVEPTIER_OVERFES_Pos = 0x5
	// Bit mask of OVERFES field.
	UOTGHS_DEVEPTIER_OVERFES_Msk = 0x20
	// Bit OVERFES.
	UOTGHS_DEVEPTIER_OVERFES = 0x20
	// Position of STALLEDES field.
	UOTGHS_DEVEPTIER_STALLEDES_Pos = 0x6
	// Bit mask of STALLEDES field.
	UOTGHS_DEVEPTIER_STALLEDES_Msk = 0x40
	// Bit STALLEDES.
	UOTGHS_DEVEPTIER_STALLEDES = 0x40
	// Position of SHORTPACKETES field.
	UOTGHS_DEVEPTIER_SHORTPACKETES_Pos = 0x7
	// Bit mask of SHORTPACKETES field.
	UOTGHS_DEVEPTIER_SHORTPACKETES_Msk = 0x80
	// Bit SHORTPACKETES.
	UOTGHS_DEVEPTIER_SHORTPACKETES = 0x80
	// Position of NBUSYBKES field.
	UOTGHS_DEVEPTIER_NBUSYBKES_Pos = 0xc
	// Bit mask of NBUSYBKES field.
	UOTGHS_DEVEPTIER_NBUSYBKES_Msk = 0x1000
	// Bit NBUSYBKES.
	UOTGHS_DEVEPTIER_NBUSYBKES = 0x1000
	// Position of KILLBKS field.
	UOTGHS_DEVEPTIER_KILLBKS_Pos = 0xd
	// Bit mask of KILLBKS field.
	UOTGHS_DEVEPTIER_KILLBKS_Msk = 0x2000
	// Bit KILLBKS.
	UOTGHS_DEVEPTIER_KILLBKS = 0x2000
	// Position of FIFOCONS field.
	UOTGHS_DEVEPTIER_FIFOCONS_Pos = 0xe
	// Bit mask of FIFOCONS field.
	UOTGHS_DEVEPTIER_FIFOCONS_Msk = 0x4000
	// Bit FIFOCONS.
	UOTGHS_DEVEPTIER_FIFOCONS = 0x4000
	// Position of EPDISHDMAS field.
	UOTGHS_DEVEPTIER_EPDISHDMAS_Pos = 0x10
	// Bit mask of EPDISHDMAS field.
	UOTGHS_DEVEPTIER_EPDISHDMAS_Msk = 0x10000
	// Bit EPDISHDMAS.
	UOTGHS_DEVEPTIER_EPDISHDMAS = 0x10000
	// Position of NYETDISS field.
	UOTGHS_DEVEPTIER_NYETDISS_Pos = 0x11
	// Bit mask of NYETDISS field.
	UOTGHS_DEVEPTIER_NYETDISS_Msk = 0x20000
	// Bit NYETDISS.
	UOTGHS_DEVEPTIER_NYETDISS = 0x20000
	// Position of RSTDTS field.
	UOTGHS_DEVEPTIER_RSTDTS_Pos = 0x12
	// Bit mask of RSTDTS field.
	UOTGHS_DEVEPTIER_RSTDTS_Msk = 0x40000
	// Bit RSTDTS.
	UOTGHS_DEVEPTIER_RSTDTS = 0x40000
	// Position of STALLRQS field.
	UOTGHS_DEVEPTIER_STALLRQS_Pos = 0x13
	// Bit mask of STALLRQS field.
	UOTGHS_DEVEPTIER_STALLRQS_Msk = 0x80000
	// Bit STALLRQS.
	UOTGHS_DEVEPTIER_STALLRQS = 0x80000

	// DEVEPTIER0_ISOENPT: Device Endpoint Enable Register (n = 0)
	// Position of TXINES field.
	UOTGHS_DEVEPTIER0_ISOENPT_TXINES_Pos = 0x0
	// Bit mask of TXINES field.
	UOTGHS_DEVEPTIER0_ISOENPT_TXINES_Msk = 0x1
	// Bit TXINES.
	UOTGHS_DEVEPTIER0_ISOENPT_TXINES = 0x1
	// Position of RXOUTES field.
	UOTGHS_DEVEPTIER0_ISOENPT_RXOUTES_Pos = 0x1
	// Bit mask of RXOUTES field.
	UOTGHS_DEVEPTIER0_ISOENPT_RXOUTES_Msk = 0x2
	// Bit RXOUTES.
	UOTGHS_DEVEPTIER0_ISOENPT_RXOUTES = 0x2
	// Position of UNDERFES field.
	UOTGHS_DEVEPTIER0_ISOENPT_UNDERFES_Pos = 0x2
	// Bit mask of UNDERFES field.
	UOTGHS_DEVEPTIER0_ISOENPT_UNDERFES_Msk = 0x4
	// Bit UNDERFES.
	UOTGHS_DEVEPTIER0_ISOENPT_UNDERFES = 0x4
	// Position of HBISOINERRES field.
	UOTGHS_DEVEPTIER0_ISOENPT_HBISOINERRES_Pos = 0x3
	// Bit mask of HBISOINERRES field.
	UOTGHS_DEVEPTIER0_ISOENPT_HBISOINERRES_Msk = 0x8
	// Bit HBISOINERRES.
	UOTGHS_DEVEPTIER0_ISOENPT_HBISOINERRES = 0x8
	// Position of HBISOFLUSHES field.
	UOTGHS_DEVEPTIER0_ISOENPT_HBISOFLUSHES_Pos = 0x4
	// Bit mask of HBISOFLUSHES field.
	UOTGHS_DEVEPTIER0_ISOENPT_HBISOFLUSHES_Msk = 0x10
	// Bit HBISOFLUSHES.
	UOTGHS_DEVEPTIER0_ISOENPT_HBISOFLUSHES = 0x10
	// Position of OVERFES field.
	UOTGHS_DEVEPTIER0_ISOENPT_OVERFES_Pos = 0x5
	// Bit mask of OVERFES field.
	UOTGHS_DEVEPTIER0_ISOENPT_OVERFES_Msk = 0x20
	// Bit OVERFES.
	UOTGHS_DEVEPTIER0_ISOENPT_OVERFES = 0x20
	// Position of CRCERRES field.
	UOTGHS_DEVEPTIER0_ISOENPT_CRCERRES_Pos = 0x6
	// Bit mask of CRCERRES field.
	UOTGHS_DEVEPTIER0_ISOENPT_CRCERRES_Msk = 0x40
	// Bit CRCERRES.
	UOTGHS_DEVEPTIER0_ISOENPT_CRCERRES = 0x40
	// Position of SHORTPACKETES field.
	UOTGHS_DEVEPTIER0_ISOENPT_SHORTPACKETES_Pos = 0x7
	// Bit mask of SHORTPACKETES field.
	UOTGHS_DEVEPTIER0_ISOENPT_SHORTPACKETES_Msk = 0x80
	// Bit SHORTPACKETES.
	UOTGHS_DEVEPTIER0_ISOENPT_SHORTPACKETES = 0x80
	// Position of MDATAES field.
	UOTGHS_DEVEPTIER0_ISOENPT_MDATAES_Pos = 0x8
	// Bit mask of MDATAES field.
	UOTGHS_DEVEPTIER0_ISOENPT_MDATAES_Msk = 0x100
	// Bit MDATAES.
	UOTGHS_DEVEPTIER0_ISOENPT_MDATAES = 0x100
	// Position of DATAXES field.
	UOTGHS_DEVEPTIER0_ISOENPT_DATAXES_Pos = 0x9
	// Bit mask of DATAXES field.
	UOTGHS_DEVEPTIER0_ISOENPT_DATAXES_Msk = 0x200
	// Bit DATAXES.
	UOTGHS_DEVEPTIER0_ISOENPT_DATAXES = 0x200
	// Position of ERRORTRANSES field.
	UOTGHS_DEVEPTIER0_ISOENPT_ERRORTRANSES_Pos = 0xa
	// Bit mask of ERRORTRANSES field.
	UOTGHS_DEVEPTIER0_ISOENPT_ERRORTRANSES_Msk = 0x400
	// Bit ERRORTRANSES.
	UOTGHS_DEVEPTIER0_ISOENPT_ERRORTRANSES = 0x400
	// Position of NBUSYBKES field.
	UOTGHS_DEVEPTIER0_ISOENPT_NBUSYBKES_Pos = 0xc
	// Bit mask of NBUSYBKES field.
	UOTGHS_DEVEPTIER0_ISOENPT_NBUSYBKES_Msk = 0x1000
	// Bit NBUSYBKES.
	UOTGHS_DEVEPTIER0_ISOENPT_NBUSYBKES = 0x1000
	// Position of KILLBKS field.
	UOTGHS_DEVEPTIER0_ISOENPT_KILLBKS_Pos = 0xd
	// Bit mask of KILLBKS field.
	UOTGHS_DEVEPTIER0_ISOENPT_KILLBKS_Msk = 0x2000
	// Bit KILLBKS.
	UOTGHS_DEVEPTIER0_ISOENPT_KILLBKS = 0x2000
	// Position of FIFOCONS field.
	UOTGHS_DEVEPTIER0_ISOENPT_FIFOCONS_Pos = 0xe
	// Bit mask of FIFOCONS field.
	UOTGHS_DEVEPTIER0_ISOENPT_FIFOCONS_Msk = 0x4000
	// Bit FIFOCONS.
	UOTGHS_DEVEPTIER0_ISOENPT_FIFOCONS = 0x4000
	// Position of EPDISHDMAS field.
	UOTGHS_DEVEPTIER0_ISOENPT_EPDISHDMAS_Pos = 0x10
	// Bit mask of EPDISHDMAS field.
	UOTGHS_DEVEPTIER0_ISOENPT_EPDISHDMAS_Msk = 0x10000
	// Bit EPDISHDMAS.
	UOTGHS_DEVEPTIER0_ISOENPT_EPDISHDMAS = 0x10000
	// Position of RSTDTS field.
	UOTGHS_DEVEPTIER0_ISOENPT_RSTDTS_Pos = 0x12
	// Bit mask of RSTDTS field.
	UOTGHS_DEVEPTIER0_ISOENPT_RSTDTS_Msk = 0x40000
	// Bit RSTDTS.
	UOTGHS_DEVEPTIER0_ISOENPT_RSTDTS = 0x40000
	// Position of STALLRQS field.
	UOTGHS_DEVEPTIER0_ISOENPT_STALLRQS_Pos = 0x13
	// Bit mask of STALLRQS field.
	UOTGHS_DEVEPTIER0_ISOENPT_STALLRQS_Msk = 0x80000
	// Bit STALLRQS.
	UOTGHS_DEVEPTIER0_ISOENPT_STALLRQS = 0x80000

	// DEVEPTIDR: Device Endpoint Disable Register (n = 0)
	// Position of TXINEC field.
	UOTGHS_DEVEPTIDR_TXINEC_Pos = 0x0
	// Bit mask of TXINEC field.
	UOTGHS_DEVEPTIDR_TXINEC_Msk = 0x1
	// Bit TXINEC.
	UOTGHS_DEVEPTIDR_TXINEC = 0x1
	// Position of RXOUTEC field.
	UOTGHS_DEVEPTIDR_RXOUTEC_Pos = 0x1
	// Bit mask of RXOUTEC field.
	UOTGHS_DEVEPTIDR_RXOUTEC_Msk = 0x2
	// Bit RXOUTEC.
	UOTGHS_DEVEPTIDR_RXOUTEC = 0x2
	// Position of RXSTPEC field.
	UOTGHS_DEVEPTIDR_RXSTPEC_Pos = 0x2
	// Bit mask of RXSTPEC field.
	UOTGHS_DEVEPTIDR_RXSTPEC_Msk = 0x4
	// Bit RXSTPEC.
	UOTGHS_DEVEPTIDR_RXSTPEC = 0x4
	// Position of NAKOUTEC field.
	UOTGHS_DEVEPTIDR_NAKOUTEC_Pos = 0x3
	// Bit mask of NAKOUTEC field.
	UOTGHS_DEVEPTIDR_NAKOUTEC_Msk = 0x8
	// Bit NAKOUTEC.
	UOTGHS_DEVEPTIDR_NAKOUTEC = 0x8
	// Position of NAKINEC field.
	UOTGHS_DEVEPTIDR_NAKINEC_Pos = 0x4
	// Bit mask of NAKINEC field.
	UOTGHS_DEVEPTIDR_NAKINEC_Msk = 0x10
	// Bit NAKINEC.
	UOTGHS_DEVEPTIDR_NAKINEC = 0x10
	// Position of OVERFEC field.
	UOTGHS_DEVEPTIDR_OVERFEC_Pos = 0x5
	// Bit mask of OVERFEC field.
	UOTGHS_DEVEPTIDR_OVERFEC_Msk = 0x20
	// Bit OVERFEC.
	UOTGHS_DEVEPTIDR_OVERFEC = 0x20
	// Position of STALLEDEC field.
	UOTGHS_DEVEPTIDR_STALLEDEC_Pos = 0x6
	// Bit mask of STALLEDEC field.
	UOTGHS_DEVEPTIDR_STALLEDEC_Msk = 0x40
	// Bit STALLEDEC.
	UOTGHS_DEVEPTIDR_STALLEDEC = 0x40
	// Position of SHORTPACKETEC field.
	UOTGHS_DEVEPTIDR_SHORTPACKETEC_Pos = 0x7
	// Bit mask of SHORTPACKETEC field.
	UOTGHS_DEVEPTIDR_SHORTPACKETEC_Msk = 0x80
	// Bit SHORTPACKETEC.
	UOTGHS_DEVEPTIDR_SHORTPACKETEC = 0x80
	// Position of NBUSYBKEC field.
	UOTGHS_DEVEPTIDR_NBUSYBKEC_Pos = 0xc
	// Bit mask of NBUSYBKEC field.
	UOTGHS_DEVEPTIDR_NBUSYBKEC_Msk = 0x1000
	// Bit NBUSYBKEC.
	UOTGHS_DEVEPTIDR_NBUSYBKEC = 0x1000
	// Position of FIFOCONC field.
	UOTGHS_DEVEPTIDR_FIFOCONC_Pos = 0xe
	// Bit mask of FIFOCONC field.
	UOTGHS_DEVEPTIDR_FIFOCONC_Msk = 0x4000
	// Bit FIFOCONC.
	UOTGHS_DEVEPTIDR_FIFOCONC = 0x4000
	// Position of EPDISHDMAC field.
	UOTGHS_DEVEPTIDR_EPDISHDMAC_Pos = 0x10
	// Bit mask of EPDISHDMAC field.
	UOTGHS_DEVEPTIDR_EPDISHDMAC_Msk = 0x10000
	// Bit EPDISHDMAC.
	UOTGHS_DEVEPTIDR_EPDISHDMAC = 0x10000
	// Position of NYETDISC field.
	UOTGHS_DEVEPTIDR_NYETDISC_Pos = 0x11
	// Bit mask of NYETDISC field.
	UOTGHS_DEVEPTIDR_NYETDISC_Msk = 0x20000
	// Bit NYETDISC.
	UOTGHS_DEVEPTIDR_NYETDISC = 0x20000
	// Position of STALLRQC field.
	UOTGHS_DEVEPTIDR_STALLRQC_Pos = 0x13
	// Bit mask of STALLRQC field.
	UOTGHS_DEVEPTIDR_STALLRQC_Msk = 0x80000
	// Bit STALLRQC.
	UOTGHS_DEVEPTIDR_STALLRQC = 0x80000

	// DEVEPTIDR0_ISOENPT: Device Endpoint Disable Register (n = 0)
	// Position of TXINEC field.
	UOTGHS_DEVEPTIDR0_ISOENPT_TXINEC_Pos = 0x0
	// Bit mask of TXINEC field.
	UOTGHS_DEVEPTIDR0_ISOENPT_TXINEC_Msk = 0x1
	// Bit TXINEC.
	UOTGHS_DEVEPTIDR0_ISOENPT_TXINEC = 0x1
	// Position of RXOUTEC field.
	UOTGHS_DEVEPTIDR0_ISOENPT_RXOUTEC_Pos = 0x1
	// Bit mask of RXOUTEC field.
	UOTGHS_DEVEPTIDR0_ISOENPT_RXOUTEC_Msk = 0x2
	// Bit RXOUTEC.
	UOTGHS_DEVEPTIDR0_ISOENPT_RXOUTEC = 0x2
	// Position of UNDERFEC field.
	UOTGHS_DEVEPTIDR0_ISOENPT_UNDERFEC_Pos = 0x2
	// Bit mask of UNDERFEC field.
	UOTGHS_DEVEPTIDR0_ISOENPT_UNDERFEC_Msk = 0x4
	// Bit UNDERFEC.
	UOTGHS_DEVEPTIDR0_ISOENPT_UNDERFEC = 0x4
	// Position of HBISOINERREC field.
	UOTGHS_DEVEPTIDR0_ISOENPT_HBISOINERREC_Pos = 0x3
	// Bit mask of HBISOINERREC field.
	UOTGHS_DEVEPTIDR0_ISOENPT_HBISOINERREC_Msk = 0x8
	// Bit HBISOINERREC.
	UOTGHS_DEVEPTIDR0_ISOENPT_HBISOINERREC = 0x8
	// Position of HBISOFLUSHEC field.
	UOTGHS_DEVEPTIDR0_ISOENPT_HBISOFLUSHEC_Pos = 0x4
	// Bit mask of HBISOFLUSHEC field.
	UOTGHS_DEVEPTIDR0_ISOENPT_HBISOFLUSHEC_Msk = 0x10
	// Bit HBISOFLUSHEC.
	UOTGHS_DEVEPTIDR0_ISOENPT_HBISOFLUSHEC = 0x10
	// Position of OVERFEC field.
	UOTGHS_DEVEPTIDR0_ISOENPT_OVERFEC_Pos = 0x5
	// Bit mask of OVERFEC field.
	UOTGHS_DEVEPTIDR0_ISOENPT_OVERFEC_Msk = 0x20
	// Bit OVERFEC.
	UOTGHS_DEVEPTIDR0_ISOENPT_OVERFEC = 0x20
	// Position of CRCERREC field.
	UOTGHS_DEVEPTIDR0_ISOENPT_CRCERREC_Pos = 0x6
	// Bit mask of CRCERREC field.
	UOTGHS_DEVEPTIDR0_ISOENPT_CRCERREC_Msk = 0x40
	// Bit CRCERREC.
	UOTGHS_DEVEPTIDR0_ISOENPT_CRCERREC = 0x40
	// Position of SHORTPACKETEC field.
	UOTGHS_DEVEPTIDR0_ISOENPT_SHORTPACKETEC_Pos = 0x7
	// Bit mask of SHORTPACKETEC field.
	UOTGHS_DEVEPTIDR0_ISOENPT_SHORTPACKETEC_Msk = 0x80
	// Bit SHORTPACKETEC.
	UOTGHS_DEVEPTIDR0_ISOENPT_SHORTPACKETEC = 0x80
	// Position of MDATEC field.
	UOTGHS_DEVEPTIDR0_ISOENPT_MDATEC_Pos = 0x8
	// Bit mask of MDATEC field.
	UOTGHS_DEVEPTIDR0_ISOENPT_MDATEC_Msk = 0x100
	// Bit MDATEC.
	UOTGHS_DEVEPTIDR0_ISOENPT_MDATEC = 0x100
	// Position of DATAXEC field.
	UOTGHS_DEVEPTIDR0_ISOENPT_DATAXEC_Pos = 0x9
	// Bit mask of DATAXEC field.
	UOTGHS_DEVEPTIDR0_ISOENPT_DATAXEC_Msk = 0x200
	// Bit DATAXEC.
	UOTGHS_DEVEPTIDR0_ISOENPT_DATAXEC = 0x200
	// Position of ERRORTRANSEC field.
	UOTGHS_DEVEPTIDR0_ISOENPT_ERRORTRANSEC_Pos = 0xa
	// Bit mask of ERRORTRANSEC field.
	UOTGHS_DEVEPTIDR0_ISOENPT_ERRORTRANSEC_Msk = 0x400
	// Bit ERRORTRANSEC.
	UOTGHS_DEVEPTIDR0_ISOENPT_ERRORTRANSEC = 0x400
	// Position of NBUSYBKEC field.
	UOTGHS_DEVEPTIDR0_ISOENPT_NBUSYBKEC_Pos = 0xc
	// Bit mask of NBUSYBKEC field.
	UOTGHS_DEVEPTIDR0_ISOENPT_NBUSYBKEC_Msk = 0x1000
	// Bit NBUSYBKEC.
	UOTGHS_DEVEPTIDR0_ISOENPT_NBUSYBKEC = 0x1000
	// Position of FIFOCONC field.
	UOTGHS_DEVEPTIDR0_ISOENPT_FIFOCONC_Pos = 0xe
	// Bit mask of FIFOCONC field.
	UOTGHS_DEVEPTIDR0_ISOENPT_FIFOCONC_Msk = 0x4000
	// Bit FIFOCONC.
	UOTGHS_DEVEPTIDR0_ISOENPT_FIFOCONC = 0x4000
	// Position of EPDISHDMAC field.
	UOTGHS_DEVEPTIDR0_ISOENPT_EPDISHDMAC_Pos = 0x10
	// Bit mask of EPDISHDMAC field.
	UOTGHS_DEVEPTIDR0_ISOENPT_EPDISHDMAC_Msk = 0x10000
	// Bit EPDISHDMAC.
	UOTGHS_DEVEPTIDR0_ISOENPT_EPDISHDMAC = 0x10000

	// DEVDMANXTDSC1: Device DMA Channel Next Descriptor Address Register (n = 1)
	// Position of NXT_DSC_ADD field.
	UOTGHS_DEVDMANXTDSC1_NXT_DSC_ADD_Pos = 0x0
	// Bit mask of NXT_DSC_ADD field.
	UOTGHS_DEVDMANXTDSC1_NXT_DSC_ADD_Msk = 0xffffffff

	// DEVDMAADDRESS1: Device DMA Channel Address Register (n = 1)
	// Position of BUFF_ADD field.
	UOTGHS_DEVDMAADDRESS1_BUFF_ADD_Pos = 0x0
	// Bit mask of BUFF_ADD field.
	UOTGHS_DEVDMAADDRESS1_BUFF_ADD_Msk = 0xffffffff

	// DEVDMACONTROL1: Device DMA Channel Control Register (n = 1)
	// Position of CHANN_ENB field.
	UOTGHS_DEVDMACONTROL1_CHANN_ENB_Pos = 0x0
	// Bit mask of CHANN_ENB field.
	UOTGHS_DEVDMACONTROL1_CHANN_ENB_Msk = 0x1
	// Bit CHANN_ENB.
	UOTGHS_DEVDMACONTROL1_CHANN_ENB = 0x1
	// Position of LDNXT_DSC field.
	UOTGHS_DEVDMACONTROL1_LDNXT_DSC_Pos = 0x1
	// Bit mask of LDNXT_DSC field.
	UOTGHS_DEVDMACONTROL1_LDNXT_DSC_Msk = 0x2
	// Bit LDNXT_DSC.
	UOTGHS_DEVDMACONTROL1_LDNXT_DSC = 0x2
	// Position of END_TR_EN field.
	UOTGHS_DEVDMACONTROL1_END_TR_EN_Pos = 0x2
	// Bit mask of END_TR_EN field.
	UOTGHS_DEVDMACONTROL1_END_TR_EN_Msk = 0x4
	// Bit END_TR_EN.
	UOTGHS_DEVDMACONTROL1_END_TR_EN = 0x4
	// Position of END_B_EN field.
	UOTGHS_DEVDMACONTROL1_END_B_EN_Pos = 0x3
	// Bit mask of END_B_EN field.
	UOTGHS_DEVDMACONTROL1_END_B_EN_Msk = 0x8
	// Bit END_B_EN.
	UOTGHS_DEVDMACONTROL1_END_B_EN = 0x8
	// Position of END_TR_IT field.
	UOTGHS_DEVDMACONTROL1_END_TR_IT_Pos = 0x4
	// Bit mask of END_TR_IT field.
	UOTGHS_DEVDMACONTROL1_END_TR_IT_Msk = 0x10
	// Bit END_TR_IT.
	UOTGHS_DEVDMACONTROL1_END_TR_IT = 0x10
	// Position of END_BUFFIT field.
	UOTGHS_DEVDMACONTROL1_END_BUFFIT_Pos = 0x5
	// Bit mask of END_BUFFIT field.
	UOTGHS_DEVDMACONTROL1_END_BUFFIT_Msk = 0x20
	// Bit END_BUFFIT.
	UOTGHS_DEVDMACONTROL1_END_BUFFIT = 0x20
	// Position of DESC_LD_IT field.
	UOTGHS_DEVDMACONTROL1_DESC_LD_IT_Pos = 0x6
	// Bit mask of DESC_LD_IT field.
	UOTGHS_DEVDMACONTROL1_DESC_LD_IT_Msk = 0x40
	// Bit DESC_LD_IT.
	UOTGHS_DEVDMACONTROL1_DESC_LD_IT = 0x40
	// Position of BURST_LCK field.
	UOTGHS_DEVDMACONTROL1_BURST_LCK_Pos = 0x7
	// Bit mask of BURST_LCK field.
	UOTGHS_DEVDMACONTROL1_BURST_LCK_Msk = 0x80
	// Bit BURST_LCK.
	UOTGHS_DEVDMACONTROL1_BURST_LCK = 0x80
	// Position of BUFF_LENGTH field.
	UOTGHS_DEVDMACONTROL1_BUFF_LENGTH_Pos = 0x10
	// Bit mask of BUFF_LENGTH field.
	UOTGHS_DEVDMACONTROL1_BUFF_LENGTH_Msk = 0xffff0000

	// DEVDMASTATUS1: Device DMA Channel Status Register (n = 1)
	// Position of CHANN_ENB field.
	UOTGHS_DEVDMASTATUS1_CHANN_ENB_Pos = 0x0
	// Bit mask of CHANN_ENB field.
	UOTGHS_DEVDMASTATUS1_CHANN_ENB_Msk = 0x1
	// Bit CHANN_ENB.
	UOTGHS_DEVDMASTATUS1_CHANN_ENB = 0x1
	// Position of CHANN_ACT field.
	UOTGHS_DEVDMASTATUS1_CHANN_ACT_Pos = 0x1
	// Bit mask of CHANN_ACT field.
	UOTGHS_DEVDMASTATUS1_CHANN_ACT_Msk = 0x2
	// Bit CHANN_ACT.
	UOTGHS_DEVDMASTATUS1_CHANN_ACT = 0x2
	// Position of END_TR_ST field.
	UOTGHS_DEVDMASTATUS1_END_TR_ST_Pos = 0x4
	// Bit mask of END_TR_ST field.
	UOTGHS_DEVDMASTATUS1_END_TR_ST_Msk = 0x10
	// Bit END_TR_ST.
	UOTGHS_DEVDMASTATUS1_END_TR_ST = 0x10
	// Position of END_BF_ST field.
	UOTGHS_DEVDMASTATUS1_END_BF_ST_Pos = 0x5
	// Bit mask of END_BF_ST field.
	UOTGHS_DEVDMASTATUS1_END_BF_ST_Msk = 0x20
	// Bit END_BF_ST.
	UOTGHS_DEVDMASTATUS1_END_BF_ST = 0x20
	// Position of DESC_LDST field.
	UOTGHS_DEVDMASTATUS1_DESC_LDST_Pos = 0x6
	// Bit mask of DESC_LDST field.
	UOTGHS_DEVDMASTATUS1_DESC_LDST_Msk = 0x40
	// Bit DESC_LDST.
	UOTGHS_DEVDMASTATUS1_DESC_LDST = 0x40
	// Position of BUFF_COUNT field.
	UOTGHS_DEVDMASTATUS1_BUFF_COUNT_Pos = 0x10
	// Bit mask of BUFF_COUNT field.
	UOTGHS_DEVDMASTATUS1_BUFF_COUNT_Msk = 0xffff0000

	// DEVDMANXTDSC2: Device DMA Channel Next Descriptor Address Register (n = 2)
	// Position of NXT_DSC_ADD field.
	UOTGHS_DEVDMANXTDSC2_NXT_DSC_ADD_Pos = 0x0
	// Bit mask of NXT_DSC_ADD field.
	UOTGHS_DEVDMANXTDSC2_NXT_DSC_ADD_Msk = 0xffffffff

	// DEVDMAADDRESS2: Device DMA Channel Address Register (n = 2)
	// Position of BUFF_ADD field.
	UOTGHS_DEVDMAADDRESS2_BUFF_ADD_Pos = 0x0
	// Bit mask of BUFF_ADD field.
	UOTGHS_DEVDMAADDRESS2_BUFF_ADD_Msk = 0xffffffff

	// DEVDMACONTROL2: Device DMA Channel Control Register (n = 2)
	// Position of CHANN_ENB field.
	UOTGHS_DEVDMACONTROL2_CHANN_ENB_Pos = 0x0
	// Bit mask of CHANN_ENB field.
	UOTGHS_DEVDMACONTROL2_CHANN_ENB_Msk = 0x1
	// Bit CHANN_ENB.
	UOTGHS_DEVDMACONTROL2_CHANN_ENB = 0x1
	// Position of LDNXT_DSC field.
	UOTGHS_DEVDMACONTROL2_LDNXT_DSC_Pos = 0x1
	// Bit mask of LDNXT_DSC field.
	UOTGHS_DEVDMACONTROL2_LDNXT_DSC_Msk = 0x2
	// Bit LDNXT_DSC.
	UOTGHS_DEVDMACONTROL2_LDNXT_DSC = 0x2
	// Position of END_TR_EN field.
	UOTGHS_DEVDMACONTROL2_END_TR_EN_Pos = 0x2
	// Bit mask of END_TR_EN field.
	UOTGHS_DEVDMACONTROL2_END_TR_EN_Msk = 0x4
	// Bit END_TR_EN.
	UOTGHS_DEVDMACONTROL2_END_TR_EN = 0x4
	// Position of END_B_EN field.
	UOTGHS_DEVDMACONTROL2_END_B_EN_Pos = 0x3
	// Bit mask of END_B_EN field.
	UOTGHS_DEVDMACONTROL2_END_B_EN_Msk = 0x8
	// Bit END_B_EN.
	UOTGHS_DEVDMACONTROL2_END_B_EN = 0x8
	// Position of END_TR_IT field.
	UOTGHS_DEVDMACONTROL2_END_TR_IT_Pos = 0x4
	// Bit mask of END_TR_IT field.
	UOTGHS_DEVDMACONTROL2_END_TR_IT_Msk = 0x10
	// Bit END_TR_IT.
	UOTGHS_DEVDMACONTROL2_END_TR_IT = 0x10
	// Position of END_BUFFIT field.
	UOTGHS_DEVDMACONTROL2_END_BUFFIT_Pos = 0x5
	// Bit mask of END_BUFFIT field.
	UOTGHS_DEVDMACONTROL2_END_BUFFIT_Msk = 0x20
	// Bit END_BUFFIT.
	UOTGHS_DEVDMACONTROL2_END_BUFFIT = 0x20
	// Position of DESC_LD_IT field.
	UOTGHS_DEVDMACONTROL2_DESC_LD_IT_Pos = 0x6
	// Bit mask of DESC_LD_IT field.
	UOTGHS_DEVDMACONTROL2_DESC_LD_IT_Msk = 0x40
	// Bit DESC_LD_IT.
	UOTGHS_DEVDMACONTROL2_DESC_LD_IT = 0x40
	// Position of BURST_LCK field.
	UOTGHS_DEVDMACONTROL2_BURST_LCK_Pos = 0x7
	// Bit mask of BURST_LCK field.
	UOTGHS_DEVDMACONTROL2_BURST_LCK_Msk = 0x80
	// Bit BURST_LCK.
	UOTGHS_DEVDMACONTROL2_BURST_LCK = 0x80
	// Position of BUFF_LENGTH field.
	UOTGHS_DEVDMACONTROL2_BUFF_LENGTH_Pos = 0x10
	// Bit mask of BUFF_LENGTH field.
	UOTGHS_DEVDMACONTROL2_BUFF_LENGTH_Msk = 0xffff0000

	// DEVDMASTATUS2: Device DMA Channel Status Register (n = 2)
	// Position of CHANN_ENB field.
	UOTGHS_DEVDMASTATUS2_CHANN_ENB_Pos = 0x0
	// Bit mask of CHANN_ENB field.
	UOTGHS_DEVDMASTATUS2_CHANN_ENB_Msk = 0x1
	// Bit CHANN_ENB.
	UOTGHS_DEVDMASTATUS2_CHANN_ENB = 0x1
	// Position of CHANN_ACT field.
	UOTGHS_DEVDMASTATUS2_CHANN_ACT_Pos = 0x1
	// Bit mask of CHANN_ACT field.
	UOTGHS_DEVDMASTATUS2_CHANN_ACT_Msk = 0x2
	// Bit CHANN_ACT.
	UOTGHS_DEVDMASTATUS2_CHANN_ACT = 0x2
	// Position of END_TR_ST field.
	UOTGHS_DEVDMASTATUS2_END_TR_ST_Pos = 0x4
	// Bit mask of END_TR_ST field.
	UOTGHS_DEVDMASTATUS2_END_TR_ST_Msk = 0x10
	// Bit END_TR_ST.
	UOTGHS_DEVDMASTATUS2_END_TR_ST = 0x10
	// Position of END_BF_ST field.
	UOTGHS_DEVDMASTATUS2_END_BF_ST_Pos = 0x5
	// Bit mask of END_BF_ST field.
	UOTGHS_DEVDMASTATUS2_END_BF_ST_Msk = 0x20
	// Bit END_BF_ST.
	UOTGHS_DEVDMASTATUS2_END_BF_ST = 0x20
	// Position of DESC_LDST field.
	UOTGHS_DEVDMASTATUS2_DESC_LDST_Pos = 0x6
	// Bit mask of DESC_LDST field.
	UOTGHS_DEVDMASTATUS2_DESC_LDST_Msk = 0x40
	// Bit DESC_LDST.
	UOTGHS_DEVDMASTATUS2_DESC_LDST = 0x40
	// Position of BUFF_COUNT field.
	UOTGHS_DEVDMASTATUS2_BUFF_COUNT_Pos = 0x10
	// Bit mask of BUFF_COUNT field.
	UOTGHS_DEVDMASTATUS2_BUFF_COUNT_Msk = 0xffff0000

	// DEVDMANXTDSC3: Device DMA Channel Next Descriptor Address Register (n = 3)
	// Position of NXT_DSC_ADD field.
	UOTGHS_DEVDMANXTDSC3_NXT_DSC_ADD_Pos = 0x0
	// Bit mask of NXT_DSC_ADD field.
	UOTGHS_DEVDMANXTDSC3_NXT_DSC_ADD_Msk = 0xffffffff

	// DEVDMAADDRESS3: Device DMA Channel Address Register (n = 3)
	// Position of BUFF_ADD field.
	UOTGHS_DEVDMAADDRESS3_BUFF_ADD_Pos = 0x0
	// Bit mask of BUFF_ADD field.
	UOTGHS_DEVDMAADDRESS3_BUFF_ADD_Msk = 0xffffffff

	// DEVDMACONTROL3: Device DMA Channel Control Register (n = 3)
	// Position of CHANN_ENB field.
	UOTGHS_DEVDMACONTROL3_CHANN_ENB_Pos = 0x0
	// Bit mask of CHANN_ENB field.
	UOTGHS_DEVDMACONTROL3_CHANN_ENB_Msk = 0x1
	// Bit CHANN_ENB.
	UOTGHS_DEVDMACONTROL3_CHANN_ENB = 0x1
	// Position of LDNXT_DSC field.
	UOTGHS_DEVDMACONTROL3_LDNXT_DSC_Pos = 0x1
	// Bit mask of LDNXT_DSC field.
	UOTGHS_DEVDMACONTROL3_LDNXT_DSC_Msk = 0x2
	// Bit LDNXT_DSC.
	UOTGHS_DEVDMACONTROL3_LDNXT_DSC = 0x2
	// Position of END_TR_EN field.
	UOTGHS_DEVDMACONTROL3_END_TR_EN_Pos = 0x2
	// Bit mask of END_TR_EN field.
	UOTGHS_DEVDMACONTROL3_END_TR_EN_Msk = 0x4
	// Bit END_TR_EN.
	UOTGHS_DEVDMACONTROL3_END_TR_EN = 0x4
	// Position of END_B_EN field.
	UOTGHS_DEVDMACONTROL3_END_B_EN_Pos = 0x3
	// Bit mask of END_B_EN field.
	UOTGHS_DEVDMACONTROL3_END_B_EN_Msk = 0x8
	// Bit END_B_EN.
	UOTGHS_DEVDMACONTROL3_END_B_EN = 0x8
	// Position of END_TR_IT field.
	UOTGHS_DEVDMACONTROL3_END_TR_IT_Pos = 0x4
	// Bit mask of END_TR_IT field.
	UOTGHS_DEVDMACONTROL3_END_TR_IT_Msk = 0x10
	// Bit END_TR_IT.
	UOTGHS_DEVDMACONTROL3_END_TR_IT = 0x10
	// Position of END_BUFFIT field.
	UOTGHS_DEVDMACONTROL3_END_BUFFIT_Pos = 0x5
	// Bit mask of END_BUFFIT field.
	UOTGHS_DEVDMACONTROL3_END_BUFFIT_Msk = 0x20
	// Bit END_BUFFIT.
	UOTGHS_DEVDMACONTROL3_END_BUFFIT = 0x20
	// Position of DESC_LD_IT field.
	UOTGHS_DEVDMACONTROL3_DESC_LD_IT_Pos = 0x6
	// Bit mask of DESC_LD_IT field.
	UOTGHS_DEVDMACONTROL3_DESC_LD_IT_Msk = 0x40
	// Bit DESC_LD_IT.
	UOTGHS_DEVDMACONTROL3_DESC_LD_IT = 0x40
	// Position of BURST_LCK field.
	UOTGHS_DEVDMACONTROL3_BURST_LCK_Pos = 0x7
	// Bit mask of BURST_LCK field.
	UOTGHS_DEVDMACONTROL3_BURST_LCK_Msk = 0x80
	// Bit BURST_LCK.
	UOTGHS_DEVDMACONTROL3_BURST_LCK = 0x80
	// Position of BUFF_LENGTH field.
	UOTGHS_DEVDMACONTROL3_BUFF_LENGTH_Pos = 0x10
	// Bit mask of BUFF_LENGTH field.
	UOTGHS_DEVDMACONTROL3_BUFF_LENGTH_Msk = 0xffff0000

	// DEVDMASTATUS3: Device DMA Channel Status Register (n = 3)
	// Position of CHANN_ENB field.
	UOTGHS_DEVDMASTATUS3_CHANN_ENB_Pos = 0x0
	// Bit mask of CHANN_ENB field.
	UOTGHS_DEVDMASTATUS3_CHANN_ENB_Msk = 0x1
	// Bit CHANN_ENB.
	UOTGHS_DEVDMASTATUS3_CHANN_ENB = 0x1
	// Position of CHANN_ACT field.
	UOTGHS_DEVDMASTATUS3_CHANN_ACT_Pos = 0x1
	// Bit mask of CHANN_ACT field.
	UOTGHS_DEVDMASTATUS3_CHANN_ACT_Msk = 0x2
	// Bit CHANN_ACT.
	UOTGHS_DEVDMASTATUS3_CHANN_ACT = 0x2
	// Position of END_TR_ST field.
	UOTGHS_DEVDMASTATUS3_END_TR_ST_Pos = 0x4
	// Bit mask of END_TR_ST field.
	UOTGHS_DEVDMASTATUS3_END_TR_ST_Msk = 0x10
	// Bit END_TR_ST.
	UOTGHS_DEVDMASTATUS3_END_TR_ST = 0x10
	// Position of END_BF_ST field.
	UOTGHS_DEVDMASTATUS3_END_BF_ST_Pos = 0x5
	// Bit mask of END_BF_ST field.
	UOTGHS_DEVDMASTATUS3_END_BF_ST_Msk = 0x20
	// Bit END_BF_ST.
	UOTGHS_DEVDMASTATUS3_END_BF_ST = 0x20
	// Position of DESC_LDST field.
	UOTGHS_DEVDMASTATUS3_DESC_LDST_Pos = 0x6
	// Bit mask of DESC_LDST field.
	UOTGHS_DEVDMASTATUS3_DESC_LDST_Msk = 0x40
	// Bit DESC_LDST.
	UOTGHS_DEVDMASTATUS3_DESC_LDST = 0x40
	// Position of BUFF_COUNT field.
	UOTGHS_DEVDMASTATUS3_BUFF_COUNT_Pos = 0x10
	// Bit mask of BUFF_COUNT field.
	UOTGHS_DEVDMASTATUS3_BUFF_COUNT_Msk = 0xffff0000

	// DEVDMANXTDSC4: Device DMA Channel Next Descriptor Address Register (n = 4)
	// Position of NXT_DSC_ADD field.
	UOTGHS_DEVDMANXTDSC4_NXT_DSC_ADD_Pos = 0x0
	// Bit mask of NXT_DSC_ADD field.
	UOTGHS_DEVDMANXTDSC4_NXT_DSC_ADD_Msk = 0xffffffff

	// DEVDMAADDRESS4: Device DMA Channel Address Register (n = 4)
	// Position of BUFF_ADD field.
	UOTGHS_DEVDMAADDRESS4_BUFF_ADD_Pos = 0x0
	// Bit mask of BUFF_ADD field.
	UOTGHS_DEVDMAADDRESS4_BUFF_ADD_Msk = 0xffffffff

	// DEVDMACONTROL4: Device DMA Channel Control Register (n = 4)
	// Position of CHANN_ENB field.
	UOTGHS_DEVDMACONTROL4_CHANN_ENB_Pos = 0x0
	// Bit mask of CHANN_ENB field.
	UOTGHS_DEVDMACONTROL4_CHANN_ENB_Msk = 0x1
	// Bit CHANN_ENB.
	UOTGHS_DEVDMACONTROL4_CHANN_ENB = 0x1
	// Position of LDNXT_DSC field.
	UOTGHS_DEVDMACONTROL4_LDNXT_DSC_Pos = 0x1
	// Bit mask of LDNXT_DSC field.
	UOTGHS_DEVDMACONTROL4_LDNXT_DSC_Msk = 0x2
	// Bit LDNXT_DSC.
	UOTGHS_DEVDMACONTROL4_LDNXT_DSC = 0x2
	// Position of END_TR_EN field.
	UOTGHS_DEVDMACONTROL4_END_TR_EN_Pos = 0x2
	// Bit mask of END_TR_EN field.
	UOTGHS_DEVDMACONTROL4_END_TR_EN_Msk = 0x4
	// Bit END_TR_EN.
	UOTGHS_DEVDMACONTROL4_END_TR_EN = 0x4
	// Position of END_B_EN field.
	UOTGHS_DEVDMACONTROL4_END_B_EN_Pos = 0x3
	// Bit mask of END_B_EN field.
	UOTGHS_DEVDMACONTROL4_END_B_EN_Msk = 0x8
	// Bit END_B_EN.
	UOTGHS_DEVDMACONTROL4_END_B_EN = 0x8
	// Position of END_TR_IT field.
	UOTGHS_DEVDMACONTROL4_END_TR_IT_Pos = 0x4
	// Bit mask of END_TR_IT field.
	UOTGHS_DEVDMACONTROL4_END_TR_IT_Msk = 0x10
	// Bit END_TR_IT.
	UOTGHS_DEVDMACONTROL4_END_TR_IT = 0x10
	// Position of END_BUFFIT field.
	UOTGHS_DEVDMACONTROL4_END_BUFFIT_Pos = 0x5
	// Bit mask of END_BUFFIT field.
	UOTGHS_DEVDMACONTROL4_END_BUFFIT_Msk = 0x20
	// Bit END_BUFFIT.
	UOTGHS_DEVDMACONTROL4_END_BUFFIT = 0x20
	// Position of DESC_LD_IT field.
	UOTGHS_DEVDMACONTROL4_DESC_LD_IT_Pos = 0x6
	// Bit mask of DESC_LD_IT field.
	UOTGHS_DEVDMACONTROL4_DESC_LD_IT_Msk = 0x40
	// Bit DESC_LD_IT.
	UOTGHS_DEVDMACONTROL4_DESC_LD_IT = 0x40
	// Position of BURST_LCK field.
	UOTGHS_DEVDMACONTROL4_BURST_LCK_Pos = 0x7
	// Bit mask of BURST_LCK field.
	UOTGHS_DEVDMACONTROL4_BURST_LCK_Msk = 0x80
	// Bit BURST_LCK.
	UOTGHS_DEVDMACONTROL4_BURST_LCK = 0x80
	// Position of BUFF_LENGTH field.
	UOTGHS_DEVDMACONTROL4_BUFF_LENGTH_Pos = 0x10
	// Bit mask of BUFF_LENGTH field.
	UOTGHS_DEVDMACONTROL4_BUFF_LENGTH_Msk = 0xffff0000

	// DEVDMASTATUS4: Device DMA Channel Status Register (n = 4)
	// Position of CHANN_ENB field.
	UOTGHS_DEVDMASTATUS4_CHANN_ENB_Pos = 0x0
	// Bit mask of CHANN_ENB field.
	UOTGHS_DEVDMASTATUS4_CHANN_ENB_Msk = 0x1
	// Bit CHANN_ENB.
	UOTGHS_DEVDMASTATUS4_CHANN_ENB = 0x1
	// Position of CHANN_ACT field.
	UOTGHS_DEVDMASTATUS4_CHANN_ACT_Pos = 0x1
	// Bit mask of CHANN_ACT field.
	UOTGHS_DEVDMASTATUS4_CHANN_ACT_Msk = 0x2
	// Bit CHANN_ACT.
	UOTGHS_DEVDMASTATUS4_CHANN_ACT = 0x2
	// Position of END_TR_ST field.
	UOTGHS_DEVDMASTATUS4_END_TR_ST_Pos = 0x4
	// Bit mask of END_TR_ST field.
	UOTGHS_DEVDMASTATUS4_END_TR_ST_Msk = 0x10
	// Bit END_TR_ST.
	UOTGHS_DEVDMASTATUS4_END_TR_ST = 0x10
	// Position of END_BF_ST field.
	UOTGHS_DEVDMASTATUS4_END_BF_ST_Pos = 0x5
	// Bit mask of END_BF_ST field.
	UOTGHS_DEVDMASTATUS4_END_BF_ST_Msk = 0x20
	// Bit END_BF_ST.
	UOTGHS_DEVDMASTATUS4_END_BF_ST = 0x20
	// Position of DESC_LDST field.
	UOTGHS_DEVDMASTATUS4_DESC_LDST_Pos = 0x6
	// Bit mask of DESC_LDST field.
	UOTGHS_DEVDMASTATUS4_DESC_LDST_Msk = 0x40
	// Bit DESC_LDST.
	UOTGHS_DEVDMASTATUS4_DESC_LDST = 0x40
	// Position of BUFF_COUNT field.
	UOTGHS_DEVDMASTATUS4_BUFF_COUNT_Pos = 0x10
	// Bit mask of BUFF_COUNT field.
	UOTGHS_DEVDMASTATUS4_BUFF_COUNT_Msk = 0xffff0000

	// DEVDMANXTDSC5: Device DMA Channel Next Descriptor Address Register (n = 5)
	// Position of NXT_DSC_ADD field.
	UOTGHS_DEVDMANXTDSC5_NXT_DSC_ADD_Pos = 0x0
	// Bit mask of NXT_DSC_ADD field.
	UOTGHS_DEVDMANXTDSC5_NXT_DSC_ADD_Msk = 0xffffffff

	// DEVDMAADDRESS5: Device DMA Channel Address Register (n = 5)
	// Position of BUFF_ADD field.
	UOTGHS_DEVDMAADDRESS5_BUFF_ADD_Pos = 0x0
	// Bit mask of BUFF_ADD field.
	UOTGHS_DEVDMAADDRESS5_BUFF_ADD_Msk = 0xffffffff

	// DEVDMACONTROL5: Device DMA Channel Control Register (n = 5)
	// Position of CHANN_ENB field.
	UOTGHS_DEVDMACONTROL5_CHANN_ENB_Pos = 0x0
	// Bit mask of CHANN_ENB field.
	UOTGHS_DEVDMACONTROL5_CHANN_ENB_Msk = 0x1
	// Bit CHANN_ENB.
	UOTGHS_DEVDMACONTROL5_CHANN_ENB = 0x1
	// Position of LDNXT_DSC field.
	UOTGHS_DEVDMACONTROL5_LDNXT_DSC_Pos = 0x1
	// Bit mask of LDNXT_DSC field.
	UOTGHS_DEVDMACONTROL5_LDNXT_DSC_Msk = 0x2
	// Bit LDNXT_DSC.
	UOTGHS_DEVDMACONTROL5_LDNXT_DSC = 0x2
	// Position of END_TR_EN field.
	UOTGHS_DEVDMACONTROL5_END_TR_EN_Pos = 0x2
	// Bit mask of END_TR_EN field.
	UOTGHS_DEVDMACONTROL5_END_TR_EN_Msk = 0x4
	// Bit END_TR_EN.
	UOTGHS_DEVDMACONTROL5_END_TR_EN = 0x4
	// Position of END_B_EN field.
	UOTGHS_DEVDMACONTROL5_END_B_EN_Pos = 0x3
	// Bit mask of END_B_EN field.
	UOTGHS_DEVDMACONTROL5_END_B_EN_Msk = 0x8
	// Bit END_B_EN.
	UOTGHS_DEVDMACONTROL5_END_B_EN = 0x8
	// Position of END_TR_IT field.
	UOTGHS_DEVDMACONTROL5_END_TR_IT_Pos = 0x4
	// Bit mask of END_TR_IT field.
	UOTGHS_DEVDMACONTROL5_END_TR_IT_Msk = 0x10
	// Bit END_TR_IT.
	UOTGHS_DEVDMACONTROL5_END_TR_IT = 0x10
	// Position of END_BUFFIT field.
	UOTGHS_DEVDMACONTROL5_END_BUFFIT_Pos = 0x5
	// Bit mask of END_BUFFIT field.
	UOTGHS_DEVDMACONTROL5_END_BUFFIT_Msk = 0x20
	// Bit END_BUFFIT.
	UOTGHS_DEVDMACONTROL5_END_BUFFIT = 0x20
	// Position of DESC_LD_IT field.
	UOTGHS_DEVDMACONTROL5_DESC_LD_IT_Pos = 0x6
	// Bit mask of DESC_LD_IT field.
	UOTGHS_DEVDMACONTROL5_DESC_LD_IT_Msk = 0x40
	// Bit DESC_LD_IT.
	UOTGHS_DEVDMACONTROL5_DESC_LD_IT = 0x40
	// Position of BURST_LCK field.
	UOTGHS_DEVDMACONTROL5_BURST_LCK_Pos = 0x7
	// Bit mask of BURST_LCK field.
	UOTGHS_DEVDMACONTROL5_BURST_LCK_Msk = 0x80
	// Bit BURST_LCK.
	UOTGHS_DEVDMACONTROL5_BURST_LCK = 0x80
	// Position of BUFF_LENGTH field.
	UOTGHS_DEVDMACONTROL5_BUFF_LENGTH_Pos = 0x10
	// Bit mask of BUFF_LENGTH field.
	UOTGHS_DEVDMACONTROL5_BUFF_LENGTH_Msk = 0xffff0000

	// DEVDMASTATUS5: Device DMA Channel Status Register (n = 5)
	// Position of CHANN_ENB field.
	UOTGHS_DEVDMASTATUS5_CHANN_ENB_Pos = 0x0
	// Bit mask of CHANN_ENB field.
	UOTGHS_DEVDMASTATUS5_CHANN_ENB_Msk = 0x1
	// Bit CHANN_ENB.
	UOTGHS_DEVDMASTATUS5_CHANN_ENB = 0x1
	// Position of CHANN_ACT field.
	UOTGHS_DEVDMASTATUS5_CHANN_ACT_Pos = 0x1
	// Bit mask of CHANN_ACT field.
	UOTGHS_DEVDMASTATUS5_CHANN_ACT_Msk = 0x2
	// Bit CHANN_ACT.
	UOTGHS_DEVDMASTATUS5_CHANN_ACT = 0x2
	// Position of END_TR_ST field.
	UOTGHS_DEVDMASTATUS5_END_TR_ST_Pos = 0x4
	// Bit mask of END_TR_ST field.
	UOTGHS_DEVDMASTATUS5_END_TR_ST_Msk = 0x10
	// Bit END_TR_ST.
	UOTGHS_DEVDMASTATUS5_END_TR_ST = 0x10
	// Position of END_BF_ST field.
	UOTGHS_DEVDMASTATUS5_END_BF_ST_Pos = 0x5
	// Bit mask of END_BF_ST field.
	UOTGHS_DEVDMASTATUS5_END_BF_ST_Msk = 0x20
	// Bit END_BF_ST.
	UOTGHS_DEVDMASTATUS5_END_BF_ST = 0x20
	// Position of DESC_LDST field.
	UOTGHS_DEVDMASTATUS5_DESC_LDST_Pos = 0x6
	// Bit mask of DESC_LDST field.
	UOTGHS_DEVDMASTATUS5_DESC_LDST_Msk = 0x40
	// Bit DESC_LDST.
	UOTGHS_DEVDMASTATUS5_DESC_LDST = 0x40
	// Position of BUFF_COUNT field.
	UOTGHS_DEVDMASTATUS5_BUFF_COUNT_Pos = 0x10
	// Bit mask of BUFF_COUNT field.
	UOTGHS_DEVDMASTATUS5_BUFF_COUNT_Msk = 0xffff0000

	// DEVDMANXTDSC6: Device DMA Channel Next Descriptor Address Register (n = 6)
	// Position of NXT_DSC_ADD field.
	UOTGHS_DEVDMANXTDSC6_NXT_DSC_ADD_Pos = 0x0
	// Bit mask of NXT_DSC_ADD field.
	UOTGHS_DEVDMANXTDSC6_NXT_DSC_ADD_Msk = 0xffffffff

	// DEVDMAADDRESS6: Device DMA Channel Address Register (n = 6)
	// Position of BUFF_ADD field.
	UOTGHS_DEVDMAADDRESS6_BUFF_ADD_Pos = 0x0
	// Bit mask of BUFF_ADD field.
	UOTGHS_DEVDMAADDRESS6_BUFF_ADD_Msk = 0xffffffff

	// DEVDMACONTROL6: Device DMA Channel Control Register (n = 6)
	// Position of CHANN_ENB field.
	UOTGHS_DEVDMACONTROL6_CHANN_ENB_Pos = 0x0
	// Bit mask of CHANN_ENB field.
	UOTGHS_DEVDMACONTROL6_CHANN_ENB_Msk = 0x1
	// Bit CHANN_ENB.
	UOTGHS_DEVDMACONTROL6_CHANN_ENB = 0x1
	// Position of LDNXT_DSC field.
	UOTGHS_DEVDMACONTROL6_LDNXT_DSC_Pos = 0x1
	// Bit mask of LDNXT_DSC field.
	UOTGHS_DEVDMACONTROL6_LDNXT_DSC_Msk = 0x2
	// Bit LDNXT_DSC.
	UOTGHS_DEVDMACONTROL6_LDNXT_DSC = 0x2
	// Position of END_TR_EN field.
	UOTGHS_DEVDMACONTROL6_END_TR_EN_Pos = 0x2
	// Bit mask of END_TR_EN field.
	UOTGHS_DEVDMACONTROL6_END_TR_EN_Msk = 0x4
	// Bit END_TR_EN.
	UOTGHS_DEVDMACONTROL6_END_TR_EN = 0x4
	// Position of END_B_EN field.
	UOTGHS_DEVDMACONTROL6_END_B_EN_Pos = 0x3
	// Bit mask of END_B_EN field.
	UOTGHS_DEVDMACONTROL6_END_B_EN_Msk = 0x8
	// Bit END_B_EN.
	UOTGHS_DEVDMACONTROL6_END_B_EN = 0x8
	// Position of END_TR_IT field.
	UOTGHS_DEVDMACONTROL6_END_TR_IT_Pos = 0x4
	// Bit mask of END_TR_IT field.
	UOTGHS_DEVDMACONTROL6_END_TR_IT_Msk = 0x10
	// Bit END_TR_IT.
	UOTGHS_DEVDMACONTROL6_END_TR_IT = 0x10
	// Position of END_BUFFIT field.
	UOTGHS_DEVDMACONTROL6_END_BUFFIT_Pos = 0x5
	// Bit mask of END_BUFFIT field.
	UOTGHS_DEVDMACONTROL6_END_BUFFIT_Msk = 0x20
	// Bit END_BUFFIT.
	UOTGHS_DEVDMACONTROL6_END_BUFFIT = 0x20
	// Position of DESC_LD_IT field.
	UOTGHS_DEVDMACONTROL6_DESC_LD_IT_Pos = 0x6
	// Bit mask of DESC_LD_IT field.
	UOTGHS_DEVDMACONTROL6_DESC_LD_IT_Msk = 0x40
	// Bit DESC_LD_IT.
	UOTGHS_DEVDMACONTROL6_DESC_LD_IT = 0x40
	// Position of BURST_LCK field.
	UOTGHS_DEVDMACONTROL6_BURST_LCK_Pos = 0x7
	// Bit mask of BURST_LCK field.
	UOTGHS_DEVDMACONTROL6_BURST_LCK_Msk = 0x80
	// Bit BURST_LCK.
	UOTGHS_DEVDMACONTROL6_BURST_LCK = 0x80
	// Position of BUFF_LENGTH field.
	UOTGHS_DEVDMACONTROL6_BUFF_LENGTH_Pos = 0x10
	// Bit mask of BUFF_LENGTH field.
	UOTGHS_DEVDMACONTROL6_BUFF_LENGTH_Msk = 0xffff0000

	// DEVDMASTATUS6: Device DMA Channel Status Register (n = 6)
	// Position of CHANN_ENB field.
	UOTGHS_DEVDMASTATUS6_CHANN_ENB_Pos = 0x0
	// Bit mask of CHANN_ENB field.
	UOTGHS_DEVDMASTATUS6_CHANN_ENB_Msk = 0x1
	// Bit CHANN_ENB.
	UOTGHS_DEVDMASTATUS6_CHANN_ENB = 0x1
	// Position of CHANN_ACT field.
	UOTGHS_DEVDMASTATUS6_CHANN_ACT_Pos = 0x1
	// Bit mask of CHANN_ACT field.
	UOTGHS_DEVDMASTATUS6_CHANN_ACT_Msk = 0x2
	// Bit CHANN_ACT.
	UOTGHS_DEVDMASTATUS6_CHANN_ACT = 0x2
	// Position of END_TR_ST field.
	UOTGHS_DEVDMASTATUS6_END_TR_ST_Pos = 0x4
	// Bit mask of END_TR_ST field.
	UOTGHS_DEVDMASTATUS6_END_TR_ST_Msk = 0x10
	// Bit END_TR_ST.
	UOTGHS_DEVDMASTATUS6_END_TR_ST = 0x10
	// Position of END_BF_ST field.
	UOTGHS_DEVDMASTATUS6_END_BF_ST_Pos = 0x5
	// Bit mask of END_BF_ST field.
	UOTGHS_DEVDMASTATUS6_END_BF_ST_Msk = 0x20
	// Bit END_BF_ST.
	UOTGHS_DEVDMASTATUS6_END_BF_ST = 0x20
	// Position of DESC_LDST field.
	UOTGHS_DEVDMASTATUS6_DESC_LDST_Pos = 0x6
	// Bit mask of DESC_LDST field.
	UOTGHS_DEVDMASTATUS6_DESC_LDST_Msk = 0x40
	// Bit DESC_LDST.
	UOTGHS_DEVDMASTATUS6_DESC_LDST = 0x40
	// Position of BUFF_COUNT field.
	UOTGHS_DEVDMASTATUS6_BUFF_COUNT_Pos = 0x10
	// Bit mask of BUFF_COUNT field.
	UOTGHS_DEVDMASTATUS6_BUFF_COUNT_Msk = 0xffff0000

	// DEVDMANXTDSC7: Device DMA Channel Next Descriptor Address Register (n = 7)
	// Position of NXT_DSC_ADD field.
	UOTGHS_DEVDMANXTDSC7_NXT_DSC_ADD_Pos = 0x0
	// Bit mask of NXT_DSC_ADD field.
	UOTGHS_DEVDMANXTDSC7_NXT_DSC_ADD_Msk = 0xffffffff

	// DEVDMAADDRESS7: Device DMA Channel Address Register (n = 7)
	// Position of BUFF_ADD field.
	UOTGHS_DEVDMAADDRESS7_BUFF_ADD_Pos = 0x0
	// Bit mask of BUFF_ADD field.
	UOTGHS_DEVDMAADDRESS7_BUFF_ADD_Msk = 0xffffffff

	// DEVDMACONTROL7: Device DMA Channel Control Register (n = 7)
	// Position of CHANN_ENB field.
	UOTGHS_DEVDMACONTROL7_CHANN_ENB_Pos = 0x0
	// Bit mask of CHANN_ENB field.
	UOTGHS_DEVDMACONTROL7_CHANN_ENB_Msk = 0x1
	// Bit CHANN_ENB.
	UOTGHS_DEVDMACONTROL7_CHANN_ENB = 0x1
	// Position of LDNXT_DSC field.
	UOTGHS_DEVDMACONTROL7_LDNXT_DSC_Pos = 0x1
	// Bit mask of LDNXT_DSC field.
	UOTGHS_DEVDMACONTROL7_LDNXT_DSC_Msk = 0x2
	// Bit LDNXT_DSC.
	UOTGHS_DEVDMACONTROL7_LDNXT_DSC = 0x2
	// Position of END_TR_EN field.
	UOTGHS_DEVDMACONTROL7_END_TR_EN_Pos = 0x2
	// Bit mask of END_TR_EN field.
	UOTGHS_DEVDMACONTROL7_END_TR_EN_Msk = 0x4
	// Bit END_TR_EN.
	UOTGHS_DEVDMACONTROL7_END_TR_EN = 0x4
	// Position of END_B_EN field.
	UOTGHS_DEVDMACONTROL7_END_B_EN_Pos = 0x3
	// Bit mask of END_B_EN field.
	UOTGHS_DEVDMACONTROL7_END_B_EN_Msk = 0x8
	// Bit END_B_EN.
	UOTGHS_DEVDMACONTROL7_END_B_EN = 0x8
	// Position of END_TR_IT field.
	UOTGHS_DEVDMACONTROL7_END_TR_IT_Pos = 0x4
	// Bit mask of END_TR_IT field.
	UOTGHS_DEVDMACONTROL7_END_TR_IT_Msk = 0x10
	// Bit END_TR_IT.
	UOTGHS_DEVDMACONTROL7_END_TR_IT = 0x10
	// Position of END_BUFFIT field.
	UOTGHS_DEVDMACONTROL7_END_BUFFIT_Pos = 0x5
	// Bit mask of END_BUFFIT field.
	UOTGHS_DEVDMACONTROL7_END_BUFFIT_Msk = 0x20
	// Bit END_BUFFIT.
	UOTGHS_DEVDMACONTROL7_END_BUFFIT = 0x20
	// Position of DESC_LD_IT field.
	UOTGHS_DEVDMACONTROL7_DESC_LD_IT_Pos = 0x6
	// Bit mask of DESC_LD_IT field.
	UOTGHS_DEVDMACONTROL7_DESC_LD_IT_Msk = 0x40
	// Bit DESC_LD_IT.
	UOTGHS_DEVDMACONTROL7_DESC_LD_IT = 0x40
	// Position of BURST_LCK field.
	UOTGHS_DEVDMACONTROL7_BURST_LCK_Pos = 0x7
	// Bit mask of BURST_LCK field.
	UOTGHS_DEVDMACONTROL7_BURST_LCK_Msk = 0x80
	// Bit BURST_LCK.
	UOTGHS_DEVDMACONTROL7_BURST_LCK = 0x80
	// Position of BUFF_LENGTH field.
	UOTGHS_DEVDMACONTROL7_BUFF_LENGTH_Pos = 0x10
	// Bit mask of BUFF_LENGTH field.
	UOTGHS_DEVDMACONTROL7_BUFF_LENGTH_Msk = 0xffff0000

	// DEVDMASTATUS7: Device DMA Channel Status Register (n = 7)
	// Position of CHANN_ENB field.
	UOTGHS_DEVDMASTATUS7_CHANN_ENB_Pos = 0x0
	// Bit mask of CHANN_ENB field.
	UOTGHS_DEVDMASTATUS7_CHANN_ENB_Msk = 0x1
	// Bit CHANN_ENB.
	UOTGHS_DEVDMASTATUS7_CHANN_ENB = 0x1
	// Position of CHANN_ACT field.
	UOTGHS_DEVDMASTATUS7_CHANN_ACT_Pos = 0x1
	// Bit mask of CHANN_ACT field.
	UOTGHS_DEVDMASTATUS7_CHANN_ACT_Msk = 0x2
	// Bit CHANN_ACT.
	UOTGHS_DEVDMASTATUS7_CHANN_ACT = 0x2
	// Position of END_TR_ST field.
	UOTGHS_DEVDMASTATUS7_END_TR_ST_Pos = 0x4
	// Bit mask of END_TR_ST field.
	UOTGHS_DEVDMASTATUS7_END_TR_ST_Msk = 0x10
	// Bit END_TR_ST.
	UOTGHS_DEVDMASTATUS7_END_TR_ST = 0x10
	// Position of END_BF_ST field.
	UOTGHS_DEVDMASTATUS7_END_BF_ST_Pos = 0x5
	// Bit mask of END_BF_ST field.
	UOTGHS_DEVDMASTATUS7_END_BF_ST_Msk = 0x20
	// Bit END_BF_ST.
	UOTGHS_DEVDMASTATUS7_END_BF_ST = 0x20
	// Position of DESC_LDST field.
	UOTGHS_DEVDMASTATUS7_DESC_LDST_Pos = 0x6
	// Bit mask of DESC_LDST field.
	UOTGHS_DEVDMASTATUS7_DESC_LDST_Msk = 0x40
	// Bit DESC_LDST.
	UOTGHS_DEVDMASTATUS7_DESC_LDST = 0x40
	// Position of BUFF_COUNT field.
	UOTGHS_DEVDMASTATUS7_BUFF_COUNT_Pos = 0x10
	// Bit mask of BUFF_COUNT field.
	UOTGHS_DEVDMASTATUS7_BUFF_COUNT_Msk = 0xffff0000

	// HSTCTRL: Host General Control Register
	// Position of SOFE field.
	UOTGHS_HSTCTRL_SOFE_Pos = 0x8
	// Bit mask of SOFE field.
	UOTGHS_HSTCTRL_SOFE_Msk = 0x100
	// Bit SOFE.
	UOTGHS_HSTCTRL_SOFE = 0x100
	// Position of RESET field.
	UOTGHS_HSTCTRL_RESET_Pos = 0x9
	// Bit mask of RESET field.
	UOTGHS_HSTCTRL_RESET_Msk = 0x200
	// Bit RESET.
	UOTGHS_HSTCTRL_RESET = 0x200
	// Position of RESUME field.
	UOTGHS_HSTCTRL_RESUME_Pos = 0xa
	// Bit mask of RESUME field.
	UOTGHS_HSTCTRL_RESUME_Msk = 0x400
	// Bit RESUME.
	UOTGHS_HSTCTRL_RESUME = 0x400
	// Position of SPDCONF field.
	UOTGHS_HSTCTRL_SPDCONF_Pos = 0xc
	// Bit mask of SPDCONF field.
	UOTGHS_HSTCTRL_SPDCONF_Msk = 0x3000
	// The host starts in full-speed mode and performs a high-speed reset to switch to the high-speed mode if the downstream peripheral is high-speed capable.
	UOTGHS_HSTCTRL_SPDCONF_NORMAL = 0x0
	// For a better consumption, if high-speed is not needed.
	UOTGHS_HSTCTRL_SPDCONF_LOW_POWER = 0x1
	// Forced high speed.
	UOTGHS_HSTCTRL_SPDCONF_HIGH_SPEED = 0x2
	// The host remains to full-speed mode whatever the peripheral speed capability.
	UOTGHS_HSTCTRL_SPDCONF_FORCED_FS = 0x3

	// HSTISR: Host Global Interrupt Status Register
	// Position of DCONNI field.
	UOTGHS_HSTISR_DCONNI_Pos = 0x0
	// Bit mask of DCONNI field.
	UOTGHS_HSTISR_DCONNI_Msk = 0x1
	// Bit DCONNI.
	UOTGHS_HSTISR_DCONNI = 0x1
	// Position of DDISCI field.
	UOTGHS_HSTISR_DDISCI_Pos = 0x1
	// Bit mask of DDISCI field.
	UOTGHS_HSTISR_DDISCI_Msk = 0x2
	// Bit DDISCI.
	UOTGHS_HSTISR_DDISCI = 0x2
	// Position of RSTI field.
	UOTGHS_HSTISR_RSTI_Pos = 0x2
	// Bit mask of RSTI field.
	UOTGHS_HSTISR_RSTI_Msk = 0x4
	// Bit RSTI.
	UOTGHS_HSTISR_RSTI = 0x4
	// Position of RSMEDI field.
	UOTGHS_HSTISR_RSMEDI_Pos = 0x3
	// Bit mask of RSMEDI field.
	UOTGHS_HSTISR_RSMEDI_Msk = 0x8
	// Bit RSMEDI.
	UOTGHS_HSTISR_RSMEDI = 0x8
	// Position of RXRSMI field.
	UOTGHS_HSTISR_RXRSMI_Pos = 0x4
	// Bit mask of RXRSMI field.
	UOTGHS_HSTISR_RXRSMI_Msk = 0x10
	// Bit RXRSMI.
	UOTGHS_HSTISR_RXRSMI = 0x10
	// Position of HSOFI field.
	UOTGHS_HSTISR_HSOFI_Pos = 0x5
	// Bit mask of HSOFI field.
	UOTGHS_HSTISR_HSOFI_Msk = 0x20
	// Bit HSOFI.
	UOTGHS_HSTISR_HSOFI = 0x20
	// Position of HWUPI field.
	UOTGHS_HSTISR_HWUPI_Pos = 0x6
	// Bit mask of HWUPI field.
	UOTGHS_HSTISR_HWUPI_Msk = 0x40
	// Bit HWUPI.
	UOTGHS_HSTISR_HWUPI = 0x40
	// Position of PEP_0 field.
	UOTGHS_HSTISR_PEP_0_Pos = 0x8
	// Bit mask of PEP_0 field.
	UOTGHS_HSTISR_PEP_0_Msk = 0x100
	// Bit PEP_0.
	UOTGHS_HSTISR_PEP_0 = 0x100
	// Position of PEP_1 field.
	UOTGHS_HSTISR_PEP_1_Pos = 0x9
	// Bit mask of PEP_1 field.
	UOTGHS_HSTISR_PEP_1_Msk = 0x200
	// Bit PEP_1.
	UOTGHS_HSTISR_PEP_1 = 0x200
	// Position of PEP_2 field.
	UOTGHS_HSTISR_PEP_2_Pos = 0xa
	// Bit mask of PEP_2 field.
	UOTGHS_HSTISR_PEP_2_Msk = 0x400
	// Bit PEP_2.
	UOTGHS_HSTISR_PEP_2 = 0x400
	// Position of PEP_3 field.
	UOTGHS_HSTISR_PEP_3_Pos = 0xb
	// Bit mask of PEP_3 field.
	UOTGHS_HSTISR_PEP_3_Msk = 0x800
	// Bit PEP_3.
	UOTGHS_HSTISR_PEP_3 = 0x800
	// Position of PEP_4 field.
	UOTGHS_HSTISR_PEP_4_Pos = 0xc
	// Bit mask of PEP_4 field.
	UOTGHS_HSTISR_PEP_4_Msk = 0x1000
	// Bit PEP_4.
	UOTGHS_HSTISR_PEP_4 = 0x1000
	// Position of PEP_5 field.
	UOTGHS_HSTISR_PEP_5_Pos = 0xd
	// Bit mask of PEP_5 field.
	UOTGHS_HSTISR_PEP_5_Msk = 0x2000
	// Bit PEP_5.
	UOTGHS_HSTISR_PEP_5 = 0x2000
	// Position of PEP_6 field.
	UOTGHS_HSTISR_PEP_6_Pos = 0xe
	// Bit mask of PEP_6 field.
	UOTGHS_HSTISR_PEP_6_Msk = 0x4000
	// Bit PEP_6.
	UOTGHS_HSTISR_PEP_6 = 0x4000
	// Position of PEP_7 field.
	UOTGHS_HSTISR_PEP_7_Pos = 0xf
	// Bit mask of PEP_7 field.
	UOTGHS_HSTISR_PEP_7_Msk = 0x8000
	// Bit PEP_7.
	UOTGHS_HSTISR_PEP_7 = 0x8000
	// Position of PEP_8 field.
	UOTGHS_HSTISR_PEP_8_Pos = 0x10
	// Bit mask of PEP_8 field.
	UOTGHS_HSTISR_PEP_8_Msk = 0x10000
	// Bit PEP_8.
	UOTGHS_HSTISR_PEP_8 = 0x10000
	// Position of PEP_9 field.
	UOTGHS_HSTISR_PEP_9_Pos = 0x11
	// Bit mask of PEP_9 field.
	UOTGHS_HSTISR_PEP_9_Msk = 0x20000
	// Bit PEP_9.
	UOTGHS_HSTISR_PEP_9 = 0x20000
	// Position of DMA_1 field.
	UOTGHS_HSTISR_DMA_1_Pos = 0x19
	// Bit mask of DMA_1 field.
	UOTGHS_HSTISR_DMA_1_Msk = 0x2000000
	// Bit DMA_1.
	UOTGHS_HSTISR_DMA_1 = 0x2000000
	// Position of DMA_2 field.
	UOTGHS_HSTISR_DMA_2_Pos = 0x1a
	// Bit mask of DMA_2 field.
	UOTGHS_HSTISR_DMA_2_Msk = 0x4000000
	// Bit DMA_2.
	UOTGHS_HSTISR_DMA_2 = 0x4000000
	// Position of DMA_3 field.
	UOTGHS_HSTISR_DMA_3_Pos = 0x1b
	// Bit mask of DMA_3 field.
	UOTGHS_HSTISR_DMA_3_Msk = 0x8000000
	// Bit DMA_3.
	UOTGHS_HSTISR_DMA_3 = 0x8000000
	// Position of DMA_4 field.
	UOTGHS_HSTISR_DMA_4_Pos = 0x1c
	// Bit mask of DMA_4 field.
	UOTGHS_HSTISR_DMA_4_Msk = 0x10000000
	// Bit DMA_4.
	UOTGHS_HSTISR_DMA_4 = 0x10000000
	// Position of DMA_5 field.
	UOTGHS_HSTISR_DMA_5_Pos = 0x1d
	// Bit mask of DMA_5 field.
	UOTGHS_HSTISR_DMA_5_Msk = 0x20000000
	// Bit DMA_5.
	UOTGHS_HSTISR_DMA_5 = 0x20000000
	// Position of DMA_6 field.
	UOTGHS_HSTISR_DMA_6_Pos = 0x1e
	// Bit mask of DMA_6 field.
	UOTGHS_HSTISR_DMA_6_Msk = 0x40000000
	// Bit DMA_6.
	UOTGHS_HSTISR_DMA_6 = 0x40000000

	// HSTICR: Host Global Interrupt Clear Register
	// Position of DCONNIC field.
	UOTGHS_HSTICR_DCONNIC_Pos = 0x0
	// Bit mask of DCONNIC field.
	UOTGHS_HSTICR_DCONNIC_Msk = 0x1
	// Bit DCONNIC.
	UOTGHS_HSTICR_DCONNIC = 0x1
	// Position of DDISCIC field.
	UOTGHS_HSTICR_DDISCIC_Pos = 0x1
	// Bit mask of DDISCIC field.
	UOTGHS_HSTICR_DDISCIC_Msk = 0x2
	// Bit DDISCIC.
	UOTGHS_HSTICR_DDISCIC = 0x2
	// Position of RSTIC field.
	UOTGHS_HSTICR_RSTIC_Pos = 0x2
	// Bit mask of RSTIC field.
	UOTGHS_HSTICR_RSTIC_Msk = 0x4
	// Bit RSTIC.
	UOTGHS_HSTICR_RSTIC = 0x4
	// Position of RSMEDIC field.
	UOTGHS_HSTICR_RSMEDIC_Pos = 0x3
	// Bit mask of RSMEDIC field.
	UOTGHS_HSTICR_RSMEDIC_Msk = 0x8
	// Bit RSMEDIC.
	UOTGHS_HSTICR_RSMEDIC = 0x8
	// Position of RXRSMIC field.
	UOTGHS_HSTICR_RXRSMIC_Pos = 0x4
	// Bit mask of RXRSMIC field.
	UOTGHS_HSTICR_RXRSMIC_Msk = 0x10
	// Bit RXRSMIC.
	UOTGHS_HSTICR_RXRSMIC = 0x10
	// Position of HSOFIC field.
	UOTGHS_HSTICR_HSOFIC_Pos = 0x5
	// Bit mask of HSOFIC field.
	UOTGHS_HSTICR_HSOFIC_Msk = 0x20
	// Bit HSOFIC.
	UOTGHS_HSTICR_HSOFIC = 0x20
	// Position of HWUPIC field.
	UOTGHS_HSTICR_HWUPIC_Pos = 0x6
	// Bit mask of HWUPIC field.
	UOTGHS_HSTICR_HWUPIC_Msk = 0x40
	// Bit HWUPIC.
	UOTGHS_HSTICR_HWUPIC = 0x40

	// HSTIFR: Host Global Interrupt Set Register
	// Position of DCONNIS field.
	UOTGHS_HSTIFR_DCONNIS_Pos = 0x0
	// Bit mask of DCONNIS field.
	UOTGHS_HSTIFR_DCONNIS_Msk = 0x1
	// Bit DCONNIS.
	UOTGHS_HSTIFR_DCONNIS = 0x1
	// Position of DDISCIS field.
	UOTGHS_HSTIFR_DDISCIS_Pos = 0x1
	// Bit mask of DDISCIS field.
	UOTGHS_HSTIFR_DDISCIS_Msk = 0x2
	// Bit DDISCIS.
	UOTGHS_HSTIFR_DDISCIS = 0x2
	// Position of RSTIS field.
	UOTGHS_HSTIFR_RSTIS_Pos = 0x2
	// Bit mask of RSTIS field.
	UOTGHS_HSTIFR_RSTIS_Msk = 0x4
	// Bit RSTIS.
	UOTGHS_HSTIFR_RSTIS = 0x4
	// Position of RSMEDIS field.
	UOTGHS_HSTIFR_RSMEDIS_Pos = 0x3
	// Bit mask of RSMEDIS field.
	UOTGHS_HSTIFR_RSMEDIS_Msk = 0x8
	// Bit RSMEDIS.
	UOTGHS_HSTIFR_RSMEDIS = 0x8
	// Position of RXRSMIS field.
	UOTGHS_HSTIFR_RXRSMIS_Pos = 0x4
	// Bit mask of RXRSMIS field.
	UOTGHS_HSTIFR_RXRSMIS_Msk = 0x10
	// Bit RXRSMIS.
	UOTGHS_HSTIFR_RXRSMIS = 0x10
	// Position of HSOFIS field.
	UOTGHS_HSTIFR_HSOFIS_Pos = 0x5
	// Bit mask of HSOFIS field.
	UOTGHS_HSTIFR_HSOFIS_Msk = 0x20
	// Bit HSOFIS.
	UOTGHS_HSTIFR_HSOFIS = 0x20
	// Position of HWUPIS field.
	UOTGHS_HSTIFR_HWUPIS_Pos = 0x6
	// Bit mask of HWUPIS field.
	UOTGHS_HSTIFR_HWUPIS_Msk = 0x40
	// Bit HWUPIS.
	UOTGHS_HSTIFR_HWUPIS = 0x40
	// Position of DMA_1 field.
	UOTGHS_HSTIFR_DMA_1_Pos = 0x19
	// Bit mask of DMA_1 field.
	UOTGHS_HSTIFR_DMA_1_Msk = 0x2000000
	// Bit DMA_1.
	UOTGHS_HSTIFR_DMA_1 = 0x2000000
	// Position of DMA_2 field.
	UOTGHS_HSTIFR_DMA_2_Pos = 0x1a
	// Bit mask of DMA_2 field.
	UOTGHS_HSTIFR_DMA_2_Msk = 0x4000000
	// Bit DMA_2.
	UOTGHS_HSTIFR_DMA_2 = 0x4000000
	// Position of DMA_3 field.
	UOTGHS_HSTIFR_DMA_3_Pos = 0x1b
	// Bit mask of DMA_3 field.
	UOTGHS_HSTIFR_DMA_3_Msk = 0x8000000
	// Bit DMA_3.
	UOTGHS_HSTIFR_DMA_3 = 0x8000000
	// Position of DMA_4 field.
	UOTGHS_HSTIFR_DMA_4_Pos = 0x1c
	// Bit mask of DMA_4 field.
	UOTGHS_HSTIFR_DMA_4_Msk = 0x10000000
	// Bit DMA_4.
	UOTGHS_HSTIFR_DMA_4 = 0x10000000
	// Position of DMA_5 field.
	UOTGHS_HSTIFR_DMA_5_Pos = 0x1d
	// Bit mask of DMA_5 field.
	UOTGHS_HSTIFR_DMA_5_Msk = 0x20000000
	// Bit DMA_5.
	UOTGHS_HSTIFR_DMA_5 = 0x20000000
	// Position of DMA_6 field.
	UOTGHS_HSTIFR_DMA_6_Pos = 0x1e
	// Bit mask of DMA_6 field.
	UOTGHS_HSTIFR_DMA_6_Msk = 0x40000000
	// Bit DMA_6.
	UOTGHS_HSTIFR_DMA_6 = 0x40000000

	// HSTIMR: Host Global Interrupt Mask Register
	// Position of DCONNIE field.
	UOTGHS_HSTIMR_DCONNIE_Pos = 0x0
	// Bit mask of DCONNIE field.
	UOTGHS_HSTIMR_DCONNIE_Msk = 0x1
	// Bit DCONNIE.
	UOTGHS_HSTIMR_DCONNIE = 0x1
	// Position of DDISCIE field.
	UOTGHS_HSTIMR_DDISCIE_Pos = 0x1
	// Bit mask of DDISCIE field.
	UOTGHS_HSTIMR_DDISCIE_Msk = 0x2
	// Bit DDISCIE.
	UOTGHS_HSTIMR_DDISCIE = 0x2
	// Position of RSTIE field.
	UOTGHS_HSTIMR_RSTIE_Pos = 0x2
	// Bit mask of RSTIE field.
	UOTGHS_HSTIMR_RSTIE_Msk = 0x4
	// Bit RSTIE.
	UOTGHS_HSTIMR_RSTIE = 0x4
	// Position of RSMEDIE field.
	UOTGHS_HSTIMR_RSMEDIE_Pos = 0x3
	// Bit mask of RSMEDIE field.
	UOTGHS_HSTIMR_RSMEDIE_Msk = 0x8
	// Bit RSMEDIE.
	UOTGHS_HSTIMR_RSMEDIE = 0x8
	// Position of RXRSMIE field.
	UOTGHS_HSTIMR_RXRSMIE_Pos = 0x4
	// Bit mask of RXRSMIE field.
	UOTGHS_HSTIMR_RXRSMIE_Msk = 0x10
	// Bit RXRSMIE.
	UOTGHS_HSTIMR_RXRSMIE = 0x10
	// Position of HSOFIE field.
	UOTGHS_HSTIMR_HSOFIE_Pos = 0x5
	// Bit mask of HSOFIE field.
	UOTGHS_HSTIMR_HSOFIE_Msk = 0x20
	// Bit HSOFIE.
	UOTGHS_HSTIMR_HSOFIE = 0x20
	// Position of HWUPIE field.
	UOTGHS_HSTIMR_HWUPIE_Pos = 0x6
	// Bit mask of HWUPIE field.
	UOTGHS_HSTIMR_HWUPIE_Msk = 0x40
	// Bit HWUPIE.
	UOTGHS_HSTIMR_HWUPIE = 0x40
	// Position of PEP_0 field.
	UOTGHS_HSTIMR_PEP_0_Pos = 0x8
	// Bit mask of PEP_0 field.
	UOTGHS_HSTIMR_PEP_0_Msk = 0x100
	// Bit PEP_0.
	UOTGHS_HSTIMR_PEP_0 = 0x100
	// Position of PEP_1 field.
	UOTGHS_HSTIMR_PEP_1_Pos = 0x9
	// Bit mask of PEP_1 field.
	UOTGHS_HSTIMR_PEP_1_Msk = 0x200
	// Bit PEP_1.
	UOTGHS_HSTIMR_PEP_1 = 0x200
	// Position of PEP_2 field.
	UOTGHS_HSTIMR_PEP_2_Pos = 0xa
	// Bit mask of PEP_2 field.
	UOTGHS_HSTIMR_PEP_2_Msk = 0x400
	// Bit PEP_2.
	UOTGHS_HSTIMR_PEP_2 = 0x400
	// Position of PEP_3 field.
	UOTGHS_HSTIMR_PEP_3_Pos = 0xb
	// Bit mask of PEP_3 field.
	UOTGHS_HSTIMR_PEP_3_Msk = 0x800
	// Bit PEP_3.
	UOTGHS_HSTIMR_PEP_3 = 0x800
	// Position of PEP_4 field.
	UOTGHS_HSTIMR_PEP_4_Pos = 0xc
	// Bit mask of PEP_4 field.
	UOTGHS_HSTIMR_PEP_4_Msk = 0x1000
	// Bit PEP_4.
	UOTGHS_HSTIMR_PEP_4 = 0x1000
	// Position of PEP_5 field.
	UOTGHS_HSTIMR_PEP_5_Pos = 0xd
	// Bit mask of PEP_5 field.
	UOTGHS_HSTIMR_PEP_5_Msk = 0x2000
	// Bit PEP_5.
	UOTGHS_HSTIMR_PEP_5 = 0x2000
	// Position of PEP_6 field.
	UOTGHS_HSTIMR_PEP_6_Pos = 0xe
	// Bit mask of PEP_6 field.
	UOTGHS_HSTIMR_PEP_6_Msk = 0x4000
	// Bit PEP_6.
	UOTGHS_HSTIMR_PEP_6 = 0x4000
	// Position of PEP_7 field.
	UOTGHS_HSTIMR_PEP_7_Pos = 0xf
	// Bit mask of PEP_7 field.
	UOTGHS_HSTIMR_PEP_7_Msk = 0x8000
	// Bit PEP_7.
	UOTGHS_HSTIMR_PEP_7 = 0x8000
	// Position of PEP_8 field.
	UOTGHS_HSTIMR_PEP_8_Pos = 0x10
	// Bit mask of PEP_8 field.
	UOTGHS_HSTIMR_PEP_8_Msk = 0x10000
	// Bit PEP_8.
	UOTGHS_HSTIMR_PEP_8 = 0x10000
	// Position of PEP_9 field.
	UOTGHS_HSTIMR_PEP_9_Pos = 0x11
	// Bit mask of PEP_9 field.
	UOTGHS_HSTIMR_PEP_9_Msk = 0x20000
	// Bit PEP_9.
	UOTGHS_HSTIMR_PEP_9 = 0x20000
	// Position of DMA_1 field.
	UOTGHS_HSTIMR_DMA_1_Pos = 0x19
	// Bit mask of DMA_1 field.
	UOTGHS_HSTIMR_DMA_1_Msk = 0x2000000
	// Bit DMA_1.
	UOTGHS_HSTIMR_DMA_1 = 0x2000000
	// Position of DMA_2 field.
	UOTGHS_HSTIMR_DMA_2_Pos = 0x1a
	// Bit mask of DMA_2 field.
	UOTGHS_HSTIMR_DMA_2_Msk = 0x4000000
	// Bit DMA_2.
	UOTGHS_HSTIMR_DMA_2 = 0x4000000
	// Position of DMA_3 field.
	UOTGHS_HSTIMR_DMA_3_Pos = 0x1b
	// Bit mask of DMA_3 field.
	UOTGHS_HSTIMR_DMA_3_Msk = 0x8000000
	// Bit DMA_3.
	UOTGHS_HSTIMR_DMA_3 = 0x8000000
	// Position of DMA_4 field.
	UOTGHS_HSTIMR_DMA_4_Pos = 0x1c
	// Bit mask of DMA_4 field.
	UOTGHS_HSTIMR_DMA_4_Msk = 0x10000000
	// Bit DMA_4.
	UOTGHS_HSTIMR_DMA_4 = 0x10000000
	// Position of DMA_5 field.
	UOTGHS_HSTIMR_DMA_5_Pos = 0x1d
	// Bit mask of DMA_5 field.
	UOTGHS_HSTIMR_DMA_5_Msk = 0x20000000
	// Bit DMA_5.
	UOTGHS_HSTIMR_DMA_5 = 0x20000000
	// Position of DMA_6 field.
	UOTGHS_HSTIMR_DMA_6_Pos = 0x1e
	// Bit mask of DMA_6 field.
	UOTGHS_HSTIMR_DMA_6_Msk = 0x40000000
	// Bit DMA_6.
	UOTGHS_HSTIMR_DMA_6 = 0x40000000

	// HSTIDR: Host Global Interrupt Disable Register
	// Position of DCONNIEC field.
	UOTGHS_HSTIDR_DCONNIEC_Pos = 0x0
	// Bit mask of DCONNIEC field.
	UOTGHS_HSTIDR_DCONNIEC_Msk = 0x1
	// Bit DCONNIEC.
	UOTGHS_HSTIDR_DCONNIEC = 0x1
	// Position of DDISCIEC field.
	UOTGHS_HSTIDR_DDISCIEC_Pos = 0x1
	// Bit mask of DDISCIEC field.
	UOTGHS_HSTIDR_DDISCIEC_Msk = 0x2
	// Bit DDISCIEC.
	UOTGHS_HSTIDR_DDISCIEC = 0x2
	// Position of RSTIEC field.
	UOTGHS_HSTIDR_RSTIEC_Pos = 0x2
	// Bit mask of RSTIEC field.
	UOTGHS_HSTIDR_RSTIEC_Msk = 0x4
	// Bit RSTIEC.
	UOTGHS_HSTIDR_RSTIEC = 0x4
	// Position of RSMEDIEC field.
	UOTGHS_HSTIDR_RSMEDIEC_Pos = 0x3
	// Bit mask of RSMEDIEC field.
	UOTGHS_HSTIDR_RSMEDIEC_Msk = 0x8
	// Bit RSMEDIEC.
	UOTGHS_HSTIDR_RSMEDIEC = 0x8
	// Position of RXRSMIEC field.
	UOTGHS_HSTIDR_RXRSMIEC_Pos = 0x4
	// Bit mask of RXRSMIEC field.
	UOTGHS_HSTIDR_RXRSMIEC_Msk = 0x10
	// Bit RXRSMIEC.
	UOTGHS_HSTIDR_RXRSMIEC = 0x10
	// Position of HSOFIEC field.
	UOTGHS_HSTIDR_HSOFIEC_Pos = 0x5
	// Bit mask of HSOFIEC field.
	UOTGHS_HSTIDR_HSOFIEC_Msk = 0x20
	// Bit HSOFIEC.
	UOTGHS_HSTIDR_HSOFIEC = 0x20
	// Position of HWUPIEC field.
	UOTGHS_HSTIDR_HWUPIEC_Pos = 0x6
	// Bit mask of HWUPIEC field.
	UOTGHS_HSTIDR_HWUPIEC_Msk = 0x40
	// Bit HWUPIEC.
	UOTGHS_HSTIDR_HWUPIEC = 0x40
	// Position of PEP_0 field.
	UOTGHS_HSTIDR_PEP_0_Pos = 0x8
	// Bit mask of PEP_0 field.
	UOTGHS_HSTIDR_PEP_0_Msk = 0x100
	// Bit PEP_0.
	UOTGHS_HSTIDR_PEP_0 = 0x100
	// Position of PEP_1 field.
	UOTGHS_HSTIDR_PEP_1_Pos = 0x9
	// Bit mask of PEP_1 field.
	UOTGHS_HSTIDR_PEP_1_Msk = 0x200
	// Bit PEP_1.
	UOTGHS_HSTIDR_PEP_1 = 0x200
	// Position of PEP_2 field.
	UOTGHS_HSTIDR_PEP_2_Pos = 0xa
	// Bit mask of PEP_2 field.
	UOTGHS_HSTIDR_PEP_2_Msk = 0x400
	// Bit PEP_2.
	UOTGHS_HSTIDR_PEP_2 = 0x400
	// Position of PEP_3 field.
	UOTGHS_HSTIDR_PEP_3_Pos = 0xb
	// Bit mask of PEP_3 field.
	UOTGHS_HSTIDR_PEP_3_Msk = 0x800
	// Bit PEP_3.
	UOTGHS_HSTIDR_PEP_3 = 0x800
	// Position of PEP_4 field.
	UOTGHS_HSTIDR_PEP_4_Pos = 0xc
	// Bit mask of PEP_4 field.
	UOTGHS_HSTIDR_PEP_4_Msk = 0x1000
	// Bit PEP_4.
	UOTGHS_HSTIDR_PEP_4 = 0x1000
	// Position of PEP_5 field.
	UOTGHS_HSTIDR_PEP_5_Pos = 0xd
	// Bit mask of PEP_5 field.
	UOTGHS_HSTIDR_PEP_5_Msk = 0x2000
	// Bit PEP_5.
	UOTGHS_HSTIDR_PEP_5 = 0x2000
	// Position of PEP_6 field.
	UOTGHS_HSTIDR_PEP_6_Pos = 0xe
	// Bit mask of PEP_6 field.
	UOTGHS_HSTIDR_PEP_6_Msk = 0x4000
	// Bit PEP_6.
	UOTGHS_HSTIDR_PEP_6 = 0x4000
	// Position of PEP_7 field.
	UOTGHS_HSTIDR_PEP_7_Pos = 0xf
	// Bit mask of PEP_7 field.
	UOTGHS_HSTIDR_PEP_7_Msk = 0x8000
	// Bit PEP_7.
	UOTGHS_HSTIDR_PEP_7 = 0x8000
	// Position of PEP_8 field.
	UOTGHS_HSTIDR_PEP_8_Pos = 0x10
	// Bit mask of PEP_8 field.
	UOTGHS_HSTIDR_PEP_8_Msk = 0x10000
	// Bit PEP_8.
	UOTGHS_HSTIDR_PEP_8 = 0x10000
	// Position of PEP_9 field.
	UOTGHS_HSTIDR_PEP_9_Pos = 0x11
	// Bit mask of PEP_9 field.
	UOTGHS_HSTIDR_PEP_9_Msk = 0x20000
	// Bit PEP_9.
	UOTGHS_HSTIDR_PEP_9 = 0x20000
	// Position of DMA_1 field.
	UOTGHS_HSTIDR_DMA_1_Pos = 0x19
	// Bit mask of DMA_1 field.
	UOTGHS_HSTIDR_DMA_1_Msk = 0x2000000
	// Bit DMA_1.
	UOTGHS_HSTIDR_DMA_1 = 0x2000000
	// Position of DMA_2 field.
	UOTGHS_HSTIDR_DMA_2_Pos = 0x1a
	// Bit mask of DMA_2 field.
	UOTGHS_HSTIDR_DMA_2_Msk = 0x4000000
	// Bit DMA_2.
	UOTGHS_HSTIDR_DMA_2 = 0x4000000
	// Position of DMA_3 field.
	UOTGHS_HSTIDR_DMA_3_Pos = 0x1b
	// Bit mask of DMA_3 field.
	UOTGHS_HSTIDR_DMA_3_Msk = 0x8000000
	// Bit DMA_3.
	UOTGHS_HSTIDR_DMA_3 = 0x8000000
	// Position of DMA_4 field.
	UOTGHS_HSTIDR_DMA_4_Pos = 0x1c
	// Bit mask of DMA_4 field.
	UOTGHS_HSTIDR_DMA_4_Msk = 0x10000000
	// Bit DMA_4.
	UOTGHS_HSTIDR_DMA_4 = 0x10000000
	// Position of DMA_5 field.
	UOTGHS_HSTIDR_DMA_5_Pos = 0x1d
	// Bit mask of DMA_5 field.
	UOTGHS_HSTIDR_DMA_5_Msk = 0x20000000
	// Bit DMA_5.
	UOTGHS_HSTIDR_DMA_5 = 0x20000000
	// Position of DMA_6 field.
	UOTGHS_HSTIDR_DMA_6_Pos = 0x1e
	// Bit mask of DMA_6 field.
	UOTGHS_HSTIDR_DMA_6_Msk = 0x40000000
	// Bit DMA_6.
	UOTGHS_HSTIDR_DMA_6 = 0x40000000

	// HSTIER: Host Global Interrupt Enable Register
	// Position of DCONNIES field.
	UOTGHS_HSTIER_DCONNIES_Pos = 0x0
	// Bit mask of DCONNIES field.
	UOTGHS_HSTIER_DCONNIES_Msk = 0x1
	// Bit DCONNIES.
	UOTGHS_HSTIER_DCONNIES = 0x1
	// Position of DDISCIES field.
	UOTGHS_HSTIER_DDISCIES_Pos = 0x1
	// Bit mask of DDISCIES field.
	UOTGHS_HSTIER_DDISCIES_Msk = 0x2
	// Bit DDISCIES.
	UOTGHS_HSTIER_DDISCIES = 0x2
	// Position of RSTIES field.
	UOTGHS_HSTIER_RSTIES_Pos = 0x2
	// Bit mask of RSTIES field.
	UOTGHS_HSTIER_RSTIES_Msk = 0x4
	// Bit RSTIES.
	UOTGHS_HSTIER_RSTIES = 0x4
	// Position of RSMEDIES field.
	UOTGHS_HSTIER_RSMEDIES_Pos = 0x3
	// Bit mask of RSMEDIES field.
	UOTGHS_HSTIER_RSMEDIES_Msk = 0x8
	// Bit RSMEDIES.
	UOTGHS_HSTIER_RSMEDIES = 0x8
	// Position of RXRSMIES field.
	UOTGHS_HSTIER_RXRSMIES_Pos = 0x4
	// Bit mask of RXRSMIES field.
	UOTGHS_HSTIER_RXRSMIES_Msk = 0x10
	// Bit RXRSMIES.
	UOTGHS_HSTIER_RXRSMIES = 0x10
	// Position of HSOFIES field.
	UOTGHS_HSTIER_HSOFIES_Pos = 0x5
	// Bit mask of HSOFIES field.
	UOTGHS_HSTIER_HSOFIES_Msk = 0x20
	// Bit HSOFIES.
	UOTGHS_HSTIER_HSOFIES = 0x20
	// Position of HWUPIES field.
	UOTGHS_HSTIER_HWUPIES_Pos = 0x6
	// Bit mask of HWUPIES field.
	UOTGHS_HSTIER_HWUPIES_Msk = 0x40
	// Bit HWUPIES.
	UOTGHS_HSTIER_HWUPIES = 0x40
	// Position of PEP_0 field.
	UOTGHS_HSTIER_PEP_0_Pos = 0x8
	// Bit mask of PEP_0 field.
	UOTGHS_HSTIER_PEP_0_Msk = 0x100
	// Bit PEP_0.
	UOTGHS_HSTIER_PEP_0 = 0x100
	// Position of PEP_1 field.
	UOTGHS_HSTIER_PEP_1_Pos = 0x9
	// Bit mask of PEP_1 field.
	UOTGHS_HSTIER_PEP_1_Msk = 0x200
	// Bit PEP_1.
	UOTGHS_HSTIER_PEP_1 = 0x200
	// Position of PEP_2 field.
	UOTGHS_HSTIER_PEP_2_Pos = 0xa
	// Bit mask of PEP_2 field.
	UOTGHS_HSTIER_PEP_2_Msk = 0x400
	// Bit PEP_2.
	UOTGHS_HSTIER_PEP_2 = 0x400
	// Position of PEP_3 field.
	UOTGHS_HSTIER_PEP_3_Pos = 0xb
	// Bit mask of PEP_3 field.
	UOTGHS_HSTIER_PEP_3_Msk = 0x800
	// Bit PEP_3.
	UOTGHS_HSTIER_PEP_3 = 0x800
	// Position of PEP_4 field.
	UOTGHS_HSTIER_PEP_4_Pos = 0xc
	// Bit mask of PEP_4 field.
	UOTGHS_HSTIER_PEP_4_Msk = 0x1000
	// Bit PEP_4.
	UOTGHS_HSTIER_PEP_4 = 0x1000
	// Position of PEP_5 field.
	UOTGHS_HSTIER_PEP_5_Pos = 0xd
	// Bit mask of PEP_5 field.
	UOTGHS_HSTIER_PEP_5_Msk = 0x2000
	// Bit PEP_5.
	UOTGHS_HSTIER_PEP_5 = 0x2000
	// Position of PEP_6 field.
	UOTGHS_HSTIER_PEP_6_Pos = 0xe
	// Bit mask of PEP_6 field.
	UOTGHS_HSTIER_PEP_6_Msk = 0x4000
	// Bit PEP_6.
	UOTGHS_HSTIER_PEP_6 = 0x4000
	// Position of PEP_7 field.
	UOTGHS_HSTIER_PEP_7_Pos = 0xf
	// Bit mask of PEP_7 field.
	UOTGHS_HSTIER_PEP_7_Msk = 0x8000
	// Bit PEP_7.
	UOTGHS_HSTIER_PEP_7 = 0x8000
	// Position of PEP_8 field.
	UOTGHS_HSTIER_PEP_8_Pos = 0x10
	// Bit mask of PEP_8 field.
	UOTGHS_HSTIER_PEP_8_Msk = 0x10000
	// Bit PEP_8.
	UOTGHS_HSTIER_PEP_8 = 0x10000
	// Position of PEP_9 field.
	UOTGHS_HSTIER_PEP_9_Pos = 0x11
	// Bit mask of PEP_9 field.
	UOTGHS_HSTIER_PEP_9_Msk = 0x20000
	// Bit PEP_9.
	UOTGHS_HSTIER_PEP_9 = 0x20000
	// Position of DMA_1 field.
	UOTGHS_HSTIER_DMA_1_Pos = 0x19
	// Bit mask of DMA_1 field.
	UOTGHS_HSTIER_DMA_1_Msk = 0x2000000
	// Bit DMA_1.
	UOTGHS_HSTIER_DMA_1 = 0x2000000
	// Position of DMA_2 field.
	UOTGHS_HSTIER_DMA_2_Pos = 0x1a
	// Bit mask of DMA_2 field.
	UOTGHS_HSTIER_DMA_2_Msk = 0x4000000
	// Bit DMA_2.
	UOTGHS_HSTIER_DMA_2 = 0x4000000
	// Position of DMA_3 field.
	UOTGHS_HSTIER_DMA_3_Pos = 0x1b
	// Bit mask of DMA_3 field.
	UOTGHS_HSTIER_DMA_3_Msk = 0x8000000
	// Bit DMA_3.
	UOTGHS_HSTIER_DMA_3 = 0x8000000
	// Position of DMA_4 field.
	UOTGHS_HSTIER_DMA_4_Pos = 0x1c
	// Bit mask of DMA_4 field.
	UOTGHS_HSTIER_DMA_4_Msk = 0x10000000
	// Bit DMA_4.
	UOTGHS_HSTIER_DMA_4 = 0x10000000
	// Position of DMA_5 field.
	UOTGHS_HSTIER_DMA_5_Pos = 0x1d
	// Bit mask of DMA_5 field.
	UOTGHS_HSTIER_DMA_5_Msk = 0x20000000
	// Bit DMA_5.
	UOTGHS_HSTIER_DMA_5 = 0x20000000
	// Position of DMA_6 field.
	UOTGHS_HSTIER_DMA_6_Pos = 0x1e
	// Bit mask of DMA_6 field.
	UOTGHS_HSTIER_DMA_6_Msk = 0x40000000
	// Bit DMA_6.
	UOTGHS_HSTIER_DMA_6 = 0x40000000

	// HSTPIP: Host Pipe Register
	// Position of PEN0 field.
	UOTGHS_HSTPIP_PEN0_Pos = 0x0
	// Bit mask of PEN0 field.
	UOTGHS_HSTPIP_PEN0_Msk = 0x1
	// Bit PEN0.
	UOTGHS_HSTPIP_PEN0 = 0x1
	// Position of PEN1 field.
	UOTGHS_HSTPIP_PEN1_Pos = 0x1
	// Bit mask of PEN1 field.
	UOTGHS_HSTPIP_PEN1_Msk = 0x2
	// Bit PEN1.
	UOTGHS_HSTPIP_PEN1 = 0x2
	// Position of PEN2 field.
	UOTGHS_HSTPIP_PEN2_Pos = 0x2
	// Bit mask of PEN2 field.
	UOTGHS_HSTPIP_PEN2_Msk = 0x4
	// Bit PEN2.
	UOTGHS_HSTPIP_PEN2 = 0x4
	// Position of PEN3 field.
	UOTGHS_HSTPIP_PEN3_Pos = 0x3
	// Bit mask of PEN3 field.
	UOTGHS_HSTPIP_PEN3_Msk = 0x8
	// Bit PEN3.
	UOTGHS_HSTPIP_PEN3 = 0x8
	// Position of PEN4 field.
	UOTGHS_HSTPIP_PEN4_Pos = 0x4
	// Bit mask of PEN4 field.
	UOTGHS_HSTPIP_PEN4_Msk = 0x10
	// Bit PEN4.
	UOTGHS_HSTPIP_PEN4 = 0x10
	// Position of PEN5 field.
	UOTGHS_HSTPIP_PEN5_Pos = 0x5
	// Bit mask of PEN5 field.
	UOTGHS_HSTPIP_PEN5_Msk = 0x20
	// Bit PEN5.
	UOTGHS_HSTPIP_PEN5 = 0x20
	// Position of PEN6 field.
	UOTGHS_HSTPIP_PEN6_Pos = 0x6
	// Bit mask of PEN6 field.
	UOTGHS_HSTPIP_PEN6_Msk = 0x40
	// Bit PEN6.
	UOTGHS_HSTPIP_PEN6 = 0x40
	// Position of PEN7 field.
	UOTGHS_HSTPIP_PEN7_Pos = 0x7
	// Bit mask of PEN7 field.
	UOTGHS_HSTPIP_PEN7_Msk = 0x80
	// Bit PEN7.
	UOTGHS_HSTPIP_PEN7 = 0x80
	// Position of PEN8 field.
	UOTGHS_HSTPIP_PEN8_Pos = 0x8
	// Bit mask of PEN8 field.
	UOTGHS_HSTPIP_PEN8_Msk = 0x100
	// Bit PEN8.
	UOTGHS_HSTPIP_PEN8 = 0x100
	// Position of PRST0 field.
	UOTGHS_HSTPIP_PRST0_Pos = 0x10
	// Bit mask of PRST0 field.
	UOTGHS_HSTPIP_PRST0_Msk = 0x10000
	// Bit PRST0.
	UOTGHS_HSTPIP_PRST0 = 0x10000
	// Position of PRST1 field.
	UOTGHS_HSTPIP_PRST1_Pos = 0x11
	// Bit mask of PRST1 field.
	UOTGHS_HSTPIP_PRST1_Msk = 0x20000
	// Bit PRST1.
	UOTGHS_HSTPIP_PRST1 = 0x20000
	// Position of PRST2 field.
	UOTGHS_HSTPIP_PRST2_Pos = 0x12
	// Bit mask of PRST2 field.
	UOTGHS_HSTPIP_PRST2_Msk = 0x40000
	// Bit PRST2.
	UOTGHS_HSTPIP_PRST2 = 0x40000
	// Position of PRST3 field.
	UOTGHS_HSTPIP_PRST3_Pos = 0x13
	// Bit mask of PRST3 field.
	UOTGHS_HSTPIP_PRST3_Msk = 0x80000
	// Bit PRST3.
	UOTGHS_HSTPIP_PRST3 = 0x80000
	// Position of PRST4 field.
	UOTGHS_HSTPIP_PRST4_Pos = 0x14
	// Bit mask of PRST4 field.
	UOTGHS_HSTPIP_PRST4_Msk = 0x100000
	// Bit PRST4.
	UOTGHS_HSTPIP_PRST4 = 0x100000
	// Position of PRST5 field.
	UOTGHS_HSTPIP_PRST5_Pos = 0x15
	// Bit mask of PRST5 field.
	UOTGHS_HSTPIP_PRST5_Msk = 0x200000
	// Bit PRST5.
	UOTGHS_HSTPIP_PRST5 = 0x200000
	// Position of PRST6 field.
	UOTGHS_HSTPIP_PRST6_Pos = 0x16
	// Bit mask of PRST6 field.
	UOTGHS_HSTPIP_PRST6_Msk = 0x400000
	// Bit PRST6.
	UOTGHS_HSTPIP_PRST6 = 0x400000
	// Position of PRST7 field.
	UOTGHS_HSTPIP_PRST7_Pos = 0x17
	// Bit mask of PRST7 field.
	UOTGHS_HSTPIP_PRST7_Msk = 0x800000
	// Bit PRST7.
	UOTGHS_HSTPIP_PRST7 = 0x800000
	// Position of PRST8 field.
	UOTGHS_HSTPIP_PRST8_Pos = 0x18
	// Bit mask of PRST8 field.
	UOTGHS_HSTPIP_PRST8_Msk = 0x1000000
	// Bit PRST8.
	UOTGHS_HSTPIP_PRST8 = 0x1000000

	// HSTFNUM: Host Frame Number Register
	// Position of MFNUM field.
	UOTGHS_HSTFNUM_MFNUM_Pos = 0x0
	// Bit mask of MFNUM field.
	UOTGHS_HSTFNUM_MFNUM_Msk = 0x7
	// Position of FNUM field.
	UOTGHS_HSTFNUM_FNUM_Pos = 0x3
	// Bit mask of FNUM field.
	UOTGHS_HSTFNUM_FNUM_Msk = 0x3ff8
	// Position of FLENHIGH field.
	UOTGHS_HSTFNUM_FLENHIGH_Pos = 0x10
	// Bit mask of FLENHIGH field.
	UOTGHS_HSTFNUM_FLENHIGH_Msk = 0xff0000

	// HSTADDR1: Host Address 1 Register
	// Position of HSTADDRP0 field.
	UOTGHS_HSTADDR1_HSTADDRP0_Pos = 0x0
	// Bit mask of HSTADDRP0 field.
	UOTGHS_HSTADDR1_HSTADDRP0_Msk = 0x7f
	// Position of HSTADDRP1 field.
	UOTGHS_HSTADDR1_HSTADDRP1_Pos = 0x8
	// Bit mask of HSTADDRP1 field.
	UOTGHS_HSTADDR1_HSTADDRP1_Msk = 0x7f00
	// Position of HSTADDRP2 field.
	UOTGHS_HSTADDR1_HSTADDRP2_Pos = 0x10
	// Bit mask of HSTADDRP2 field.
	UOTGHS_HSTADDR1_HSTADDRP2_Msk = 0x7f0000
	// Position of HSTADDRP3 field.
	UOTGHS_HSTADDR1_HSTADDRP3_Pos = 0x18
	// Bit mask of HSTADDRP3 field.
	UOTGHS_HSTADDR1_HSTADDRP3_Msk = 0x7f000000

	// HSTADDR2: Host Address 2 Register
	// Position of HSTADDRP4 field.
	UOTGHS_HSTADDR2_HSTADDRP4_Pos = 0x0
	// Bit mask of HSTADDRP4 field.
	UOTGHS_HSTADDR2_HSTADDRP4_Msk = 0x7f
	// Position of HSTADDRP5 field.
	UOTGHS_HSTADDR2_HSTADDRP5_Pos = 0x8
	// Bit mask of HSTADDRP5 field.
	UOTGHS_HSTADDR2_HSTADDRP5_Msk = 0x7f00
	// Position of HSTADDRP6 field.
	UOTGHS_HSTADDR2_HSTADDRP6_Pos = 0x10
	// Bit mask of HSTADDRP6 field.
	UOTGHS_HSTADDR2_HSTADDRP6_Msk = 0x7f0000
	// Position of HSTADDRP7 field.
	UOTGHS_HSTADDR2_HSTADDRP7_Pos = 0x18
	// Bit mask of HSTADDRP7 field.
	UOTGHS_HSTADDR2_HSTADDRP7_Msk = 0x7f000000

	// HSTADDR3: Host Address 3 Register
	// Position of HSTADDRP8 field.
	UOTGHS_HSTADDR3_HSTADDRP8_Pos = 0x0
	// Bit mask of HSTADDRP8 field.
	UOTGHS_HSTADDR3_HSTADDRP8_Msk = 0x7f
	// Position of HSTADDRP9 field.
	UOTGHS_HSTADDR3_HSTADDRP9_Pos = 0x8
	// Bit mask of HSTADDRP9 field.
	UOTGHS_HSTADDR3_HSTADDRP9_Msk = 0x7f00

	// HSTPIPCFG: Host Pipe Configuration Register (n = 0)
	// Position of ALLOC field.
	UOTGHS_HSTPIPCFG_ALLOC_Pos = 0x1
	// Bit mask of ALLOC field.
	UOTGHS_HSTPIPCFG_ALLOC_Msk = 0x2
	// Bit ALLOC.
	UOTGHS_HSTPIPCFG_ALLOC = 0x2
	// Position of PBK field.
	UOTGHS_HSTPIPCFG_PBK_Pos = 0x2
	// Bit mask of PBK field.
	UOTGHS_HSTPIPCFG_PBK_Msk = 0xc
	// Single-bank pipe
	UOTGHS_HSTPIPCFG_PBK_1_BANK = 0x0
	// Double-bank pipe
	UOTGHS_HSTPIPCFG_PBK_2_BANK = 0x1
	// Triple-bank pipe
	UOTGHS_HSTPIPCFG_PBK_3_BANK = 0x2
	// Position of PSIZE field.
	UOTGHS_HSTPIPCFG_PSIZE_Pos = 0x4
	// Bit mask of PSIZE field.
	UOTGHS_HSTPIPCFG_PSIZE_Msk = 0x70
	// 8 bytes
	UOTGHS_HSTPIPCFG_PSIZE_8_BYTE = 0x0
	// 16 bytes
	UOTGHS_HSTPIPCFG_PSIZE_16_BYTE = 0x1
	// 32 bytes
	UOTGHS_HSTPIPCFG_PSIZE_32_BYTE = 0x2
	// 64 bytes
	UOTGHS_HSTPIPCFG_PSIZE_64_BYTE = 0x3
	// 128 bytes
	UOTGHS_HSTPIPCFG_PSIZE_128_BYTE = 0x4
	// 256 bytes
	UOTGHS_HSTPIPCFG_PSIZE_256_BYTE = 0x5
	// 512 bytes
	UOTGHS_HSTPIPCFG_PSIZE_512_BYTE = 0x6
	// 1024 bytes
	UOTGHS_HSTPIPCFG_PSIZE_1024_BYTE = 0x7
	// Position of PTOKEN field.
	UOTGHS_HSTPIPCFG_PTOKEN_Pos = 0x8
	// Bit mask of PTOKEN field.
	UOTGHS_HSTPIPCFG_PTOKEN_Msk = 0x300
	// SETUP
	UOTGHS_HSTPIPCFG_PTOKEN_SETUP = 0x0
	// IN
	UOTGHS_HSTPIPCFG_PTOKEN_IN = 0x1
	// OUT
	UOTGHS_HSTPIPCFG_PTOKEN_OUT = 0x2
	// Position of AUTOSW field.
	UOTGHS_HSTPIPCFG_AUTOSW_Pos = 0xa
	// Bit mask of AUTOSW field.
	UOTGHS_HSTPIPCFG_AUTOSW_Msk = 0x400
	// Bit AUTOSW.
	UOTGHS_HSTPIPCFG_AUTOSW = 0x400
	// Position of PTYPE field.
	UOTGHS_HSTPIPCFG_PTYPE_Pos = 0xc
	// Bit mask of PTYPE field.
	UOTGHS_HSTPIPCFG_PTYPE_Msk = 0x3000
	// Control
	UOTGHS_HSTPIPCFG_PTYPE_CTRL = 0x0
	// Isochronous
	UOTGHS_HSTPIPCFG_PTYPE_ISO = 0x1
	// Bulk
	UOTGHS_HSTPIPCFG_PTYPE_BLK = 0x2
	// Interrupt
	UOTGHS_HSTPIPCFG_PTYPE_INTRPT = 0x3
	// Position of PEPNUM field.
	UOTGHS_HSTPIPCFG_PEPNUM_Pos = 0x10
	// Bit mask of PEPNUM field.
	UOTGHS_HSTPIPCFG_PEPNUM_Msk = 0xf0000
	// Position of INTFRQ field.
	UOTGHS_HSTPIPCFG_INTFRQ_Pos = 0x18
	// Bit mask of INTFRQ field.
	UOTGHS_HSTPIPCFG_INTFRQ_Msk = 0xff000000

	// HSTPIPCFG0_HSBOHSCP: Host Pipe Configuration Register (n = 0)
	// Position of ALLOC field.
	UOTGHS_HSTPIPCFG0_HSBOHSCP_ALLOC_Pos = 0x1
	// Bit mask of ALLOC field.
	UOTGHS_HSTPIPCFG0_HSBOHSCP_ALLOC_Msk = 0x2
	// Bit ALLOC.
	UOTGHS_HSTPIPCFG0_HSBOHSCP_ALLOC = 0x2
	// Position of PBK field.
	UOTGHS_HSTPIPCFG0_HSBOHSCP_PBK_Pos = 0x2
	// Bit mask of PBK field.
	UOTGHS_HSTPIPCFG0_HSBOHSCP_PBK_Msk = 0xc
	// Single-bank pipe
	UOTGHS_HSTPIPCFG0_HSBOHSCP_PBK_1_BANK = 0x0
	// Double-bank pipe
	UOTGHS_HSTPIPCFG0_HSBOHSCP_PBK_2_BANK = 0x1
	// Triple-bank pipe
	UOTGHS_HSTPIPCFG0_HSBOHSCP_PBK_3_BANK = 0x2
	// Position of PSIZE field.
	UOTGHS_HSTPIPCFG0_HSBOHSCP_PSIZE_Pos = 0x4
	// Bit mask of PSIZE field.
	UOTGHS_HSTPIPCFG0_HSBOHSCP_PSIZE_Msk = 0x70
	// 8 bytes
	UOTGHS_HSTPIPCFG0_HSBOHSCP_PSIZE_8_BYTE = 0x0
	// 16 bytes
	UOTGHS_HSTPIPCFG0_HSBOHSCP_PSIZE_16_BYTE = 0x1
	// 32 bytes
	UOTGHS_HSTPIPCFG0_HSBOHSCP_PSIZE_32_BYTE = 0x2
	// 64 bytes
	UOTGHS_HSTPIPCFG0_HSBOHSCP_PSIZE_64_BYTE = 0x3
	// 128 bytes
	UOTGHS_HSTPIPCFG0_HSBOHSCP_PSIZE_128_BYTE = 0x4
	// 256 bytes
	UOTGHS_HSTPIPCFG0_HSBOHSCP_PSIZE_256_BYTE = 0x5
	// 512 bytes
	UOTGHS_HSTPIPCFG0_HSBOHSCP_PSIZE_512_BYTE = 0x6
	// 1024 bytes
	UOTGHS_HSTPIPCFG0_HSBOHSCP_PSIZE_1024_BYTE = 0x7
	// Position of PTOKEN field.
	UOTGHS_HSTPIPCFG0_HSBOHSCP_PTOKEN_Pos = 0x8
	// Bit mask of PTOKEN field.
	UOTGHS_HSTPIPCFG0_HSBOHSCP_PTOKEN_Msk = 0x300
	// SETUP
	UOTGHS_HSTPIPCFG0_HSBOHSCP_PTOKEN_SETUP = 0x0
	// IN
	UOTGHS_HSTPIPCFG0_HSBOHSCP_PTOKEN_IN = 0x1
	// OUT
	UOTGHS_HSTPIPCFG0_HSBOHSCP_PTOKEN_OUT = 0x2
	// Position of AUTOSW field.
	UOTGHS_HSTPIPCFG0_HSBOHSCP_AUTOSW_Pos = 0xa
	// Bit mask of AUTOSW field.
	UOTGHS_HSTPIPCFG0_HSBOHSCP_AUTOSW_Msk = 0x400
	// Bit AUTOSW.
	UOTGHS_HSTPIPCFG0_HSBOHSCP_AUTOSW = 0x400
	// Position of PTYPE field.
	UOTGHS_HSTPIPCFG0_HSBOHSCP_PTYPE_Pos = 0xc
	// Bit mask of PTYPE field.
	UOTGHS_HSTPIPCFG0_HSBOHSCP_PTYPE_Msk = 0x3000
	// Control
	UOTGHS_HSTPIPCFG0_HSBOHSCP_PTYPE_CTRL = 0x0
	// Bulk
	UOTGHS_HSTPIPCFG0_HSBOHSCP_PTYPE_BLK = 0x2
	// Position of PEPNUM field.
	UOTGHS_HSTPIPCFG0_HSBOHSCP_PEPNUM_Pos = 0x10
	// Bit mask of PEPNUM field.
	UOTGHS_HSTPIPCFG0_HSBOHSCP_PEPNUM_Msk = 0xf0000
	// Position of PINGEN field.
	UOTGHS_HSTPIPCFG0_HSBOHSCP_PINGEN_Pos = 0x14
	// Bit mask of PINGEN field.
	UOTGHS_HSTPIPCFG0_HSBOHSCP_PINGEN_Msk = 0x100000
	// Bit PINGEN.
	UOTGHS_HSTPIPCFG0_HSBOHSCP_PINGEN = 0x100000
	// Position of BINTERVAL field.
	UOTGHS_HSTPIPCFG0_HSBOHSCP_BINTERVAL_Pos = 0x18
	// Bit mask of BINTERVAL field.
	UOTGHS_HSTPIPCFG0_HSBOHSCP_BINTERVAL_Msk = 0xff000000

	// HSTPIPISR: Host Pipe Status Register (n = 0)
	// Position of RXINI field.
	UOTGHS_HSTPIPISR_RXINI_Pos = 0x0
	// Bit mask of RXINI field.
	UOTGHS_HSTPIPISR_RXINI_Msk = 0x1
	// Bit RXINI.
	UOTGHS_HSTPIPISR_RXINI = 0x1
	// Position of TXOUTI field.
	UOTGHS_HSTPIPISR_TXOUTI_Pos = 0x1
	// Bit mask of TXOUTI field.
	UOTGHS_HSTPIPISR_TXOUTI_Msk = 0x2
	// Bit TXOUTI.
	UOTGHS_HSTPIPISR_TXOUTI = 0x2
	// Position of TXSTPI field.
	UOTGHS_HSTPIPISR_TXSTPI_Pos = 0x2
	// Bit mask of TXSTPI field.
	UOTGHS_HSTPIPISR_TXSTPI_Msk = 0x4
	// Bit TXSTPI.
	UOTGHS_HSTPIPISR_TXSTPI = 0x4
	// Position of PERRI field.
	UOTGHS_HSTPIPISR_PERRI_Pos = 0x3
	// Bit mask of PERRI field.
	UOTGHS_HSTPIPISR_PERRI_Msk = 0x8
	// Bit PERRI.
	UOTGHS_HSTPIPISR_PERRI = 0x8
	// Position of NAKEDI field.
	UOTGHS_HSTPIPISR_NAKEDI_Pos = 0x4
	// Bit mask of NAKEDI field.
	UOTGHS_HSTPIPISR_NAKEDI_Msk = 0x10
	// Bit NAKEDI.
	UOTGHS_HSTPIPISR_NAKEDI = 0x10
	// Position of OVERFI field.
	UOTGHS_HSTPIPISR_OVERFI_Pos = 0x5
	// Bit mask of OVERFI field.
	UOTGHS_HSTPIPISR_OVERFI_Msk = 0x20
	// Bit OVERFI.
	UOTGHS_HSTPIPISR_OVERFI = 0x20
	// Position of RXSTALLDI field.
	UOTGHS_HSTPIPISR_RXSTALLDI_Pos = 0x6
	// Bit mask of RXSTALLDI field.
	UOTGHS_HSTPIPISR_RXSTALLDI_Msk = 0x40
	// Bit RXSTALLDI.
	UOTGHS_HSTPIPISR_RXSTALLDI = 0x40
	// Position of SHORTPACKETI field.
	UOTGHS_HSTPIPISR_SHORTPACKETI_Pos = 0x7
	// Bit mask of SHORTPACKETI field.
	UOTGHS_HSTPIPISR_SHORTPACKETI_Msk = 0x80
	// Bit SHORTPACKETI.
	UOTGHS_HSTPIPISR_SHORTPACKETI = 0x80
	// Position of DTSEQ field.
	UOTGHS_HSTPIPISR_DTSEQ_Pos = 0x8
	// Bit mask of DTSEQ field.
	UOTGHS_HSTPIPISR_DTSEQ_Msk = 0x300
	// Data0 toggle sequence
	UOTGHS_HSTPIPISR_DTSEQ_DATA0 = 0x0
	// Data1 toggle sequence
	UOTGHS_HSTPIPISR_DTSEQ_DATA1 = 0x1
	// Position of NBUSYBK field.
	UOTGHS_HSTPIPISR_NBUSYBK_Pos = 0xc
	// Bit mask of NBUSYBK field.
	UOTGHS_HSTPIPISR_NBUSYBK_Msk = 0x3000
	// 0 busy bank (all banks free)
	UOTGHS_HSTPIPISR_NBUSYBK_0_BUSY = 0x0
	// 1 busy bank
	UOTGHS_HSTPIPISR_NBUSYBK_1_BUSY = 0x1
	// 2 busy banks
	UOTGHS_HSTPIPISR_NBUSYBK_2_BUSY = 0x2
	// 3 busy banks
	UOTGHS_HSTPIPISR_NBUSYBK_3_BUSY = 0x3
	// Position of CURRBK field.
	UOTGHS_HSTPIPISR_CURRBK_Pos = 0xe
	// Bit mask of CURRBK field.
	UOTGHS_HSTPIPISR_CURRBK_Msk = 0xc000
	// Current bank is bank0
	UOTGHS_HSTPIPISR_CURRBK_BANK0 = 0x0
	// Current bank is bank1
	UOTGHS_HSTPIPISR_CURRBK_BANK1 = 0x1
	// Current bank is bank2
	UOTGHS_HSTPIPISR_CURRBK_BANK2 = 0x2
	// Position of RWALL field.
	UOTGHS_HSTPIPISR_RWALL_Pos = 0x10
	// Bit mask of RWALL field.
	UOTGHS_HSTPIPISR_RWALL_Msk = 0x10000
	// Bit RWALL.
	UOTGHS_HSTPIPISR_RWALL = 0x10000
	// Position of CFGOK field.
	UOTGHS_HSTPIPISR_CFGOK_Pos = 0x12
	// Bit mask of CFGOK field.
	UOTGHS_HSTPIPISR_CFGOK_Msk = 0x40000
	// Bit CFGOK.
	UOTGHS_HSTPIPISR_CFGOK = 0x40000
	// Position of PBYCT field.
	UOTGHS_HSTPIPISR_PBYCT_Pos = 0x14
	// Bit mask of PBYCT field.
	UOTGHS_HSTPIPISR_PBYCT_Msk = 0x7ff00000

	// HSTPIPISR0_INTPIPES: Host Pipe Status Register (n = 0)
	// Position of RXINI field.
	UOTGHS_HSTPIPISR0_INTPIPES_RXINI_Pos = 0x0
	// Bit mask of RXINI field.
	UOTGHS_HSTPIPISR0_INTPIPES_RXINI_Msk = 0x1
	// Bit RXINI.
	UOTGHS_HSTPIPISR0_INTPIPES_RXINI = 0x1
	// Position of TXOUTI field.
	UOTGHS_HSTPIPISR0_INTPIPES_TXOUTI_Pos = 0x1
	// Bit mask of TXOUTI field.
	UOTGHS_HSTPIPISR0_INTPIPES_TXOUTI_Msk = 0x2
	// Bit TXOUTI.
	UOTGHS_HSTPIPISR0_INTPIPES_TXOUTI = 0x2
	// Position of UNDERFI field.
	UOTGHS_HSTPIPISR0_INTPIPES_UNDERFI_Pos = 0x2
	// Bit mask of UNDERFI field.
	UOTGHS_HSTPIPISR0_INTPIPES_UNDERFI_Msk = 0x4
	// Bit UNDERFI.
	UOTGHS_HSTPIPISR0_INTPIPES_UNDERFI = 0x4
	// Position of PERRI field.
	UOTGHS_HSTPIPISR0_INTPIPES_PERRI_Pos = 0x3
	// Bit mask of PERRI field.
	UOTGHS_HSTPIPISR0_INTPIPES_PERRI_Msk = 0x8
	// Bit PERRI.
	UOTGHS_HSTPIPISR0_INTPIPES_PERRI = 0x8
	// Position of NAKEDI field.
	UOTGHS_HSTPIPISR0_INTPIPES_NAKEDI_Pos = 0x4
	// Bit mask of NAKEDI field.
	UOTGHS_HSTPIPISR0_INTPIPES_NAKEDI_Msk = 0x10
	// Bit NAKEDI.
	UOTGHS_HSTPIPISR0_INTPIPES_NAKEDI = 0x10
	// Position of OVERFI field.
	UOTGHS_HSTPIPISR0_INTPIPES_OVERFI_Pos = 0x5
	// Bit mask of OVERFI field.
	UOTGHS_HSTPIPISR0_INTPIPES_OVERFI_Msk = 0x20
	// Bit OVERFI.
	UOTGHS_HSTPIPISR0_INTPIPES_OVERFI = 0x20
	// Position of RXSTALLDI field.
	UOTGHS_HSTPIPISR0_INTPIPES_RXSTALLDI_Pos = 0x6
	// Bit mask of RXSTALLDI field.
	UOTGHS_HSTPIPISR0_INTPIPES_RXSTALLDI_Msk = 0x40
	// Bit RXSTALLDI.
	UOTGHS_HSTPIPISR0_INTPIPES_RXSTALLDI = 0x40
	// Position of SHORTPACKETI field.
	UOTGHS_HSTPIPISR0_INTPIPES_SHORTPACKETI_Pos = 0x7
	// Bit mask of SHORTPACKETI field.
	UOTGHS_HSTPIPISR0_INTPIPES_SHORTPACKETI_Msk = 0x80
	// Bit SHORTPACKETI.
	UOTGHS_HSTPIPISR0_INTPIPES_SHORTPACKETI = 0x80
	// Position of DTSEQ field.
	UOTGHS_HSTPIPISR0_INTPIPES_DTSEQ_Pos = 0x8
	// Bit mask of DTSEQ field.
	UOTGHS_HSTPIPISR0_INTPIPES_DTSEQ_Msk = 0x300
	// Data0 toggle sequence
	UOTGHS_HSTPIPISR0_INTPIPES_DTSEQ_DATA0 = 0x0
	// Data1 toggle sequence
	UOTGHS_HSTPIPISR0_INTPIPES_DTSEQ_DATA1 = 0x1
	// Position of NBUSYBK field.
	UOTGHS_HSTPIPISR0_INTPIPES_NBUSYBK_Pos = 0xc
	// Bit mask of NBUSYBK field.
	UOTGHS_HSTPIPISR0_INTPIPES_NBUSYBK_Msk = 0x3000
	// 0 busy bank (all banks free)
	UOTGHS_HSTPIPISR0_INTPIPES_NBUSYBK_0_BUSY = 0x0
	// 1 busy bank
	UOTGHS_HSTPIPISR0_INTPIPES_NBUSYBK_1_BUSY = 0x1
	// 2 busy banks
	UOTGHS_HSTPIPISR0_INTPIPES_NBUSYBK_2_BUSY = 0x2
	// 3 busy banks
	UOTGHS_HSTPIPISR0_INTPIPES_NBUSYBK_3_BUSY = 0x3
	// Position of CURRBK field.
	UOTGHS_HSTPIPISR0_INTPIPES_CURRBK_Pos = 0xe
	// Bit mask of CURRBK field.
	UOTGHS_HSTPIPISR0_INTPIPES_CURRBK_Msk = 0xc000
	// Current bank is bank0
	UOTGHS_HSTPIPISR0_INTPIPES_CURRBK_BANK0 = 0x0
	// Current bank is bank1
	UOTGHS_HSTPIPISR0_INTPIPES_CURRBK_BANK1 = 0x1
	// Current bank is bank2
	UOTGHS_HSTPIPISR0_INTPIPES_CURRBK_BANK2 = 0x2
	// Position of RWALL field.
	UOTGHS_HSTPIPISR0_INTPIPES_RWALL_Pos = 0x10
	// Bit mask of RWALL field.
	UOTGHS_HSTPIPISR0_INTPIPES_RWALL_Msk = 0x10000
	// Bit RWALL.
	UOTGHS_HSTPIPISR0_INTPIPES_RWALL = 0x10000
	// Position of CFGOK field.
	UOTGHS_HSTPIPISR0_INTPIPES_CFGOK_Pos = 0x12
	// Bit mask of CFGOK field.
	UOTGHS_HSTPIPISR0_INTPIPES_CFGOK_Msk = 0x40000
	// Bit CFGOK.
	UOTGHS_HSTPIPISR0_INTPIPES_CFGOK = 0x40000
	// Position of PBYCT field.
	UOTGHS_HSTPIPISR0_INTPIPES_PBYCT_Pos = 0x14
	// Bit mask of PBYCT field.
	UOTGHS_HSTPIPISR0_INTPIPES_PBYCT_Msk = 0x7ff00000

	// HSTPIPISR0_ISOPIPES: Host Pipe Status Register (n = 0)
	// Position of RXINI field.
	UOTGHS_HSTPIPISR0_ISOPIPES_RXINI_Pos = 0x0
	// Bit mask of RXINI field.
	UOTGHS_HSTPIPISR0_ISOPIPES_RXINI_Msk = 0x1
	// Bit RXINI.
	UOTGHS_HSTPIPISR0_ISOPIPES_RXINI = 0x1
	// Position of TXOUTI field.
	UOTGHS_HSTPIPISR0_ISOPIPES_TXOUTI_Pos = 0x1
	// Bit mask of TXOUTI field.
	UOTGHS_HSTPIPISR0_ISOPIPES_TXOUTI_Msk = 0x2
	// Bit TXOUTI.
	UOTGHS_HSTPIPISR0_ISOPIPES_TXOUTI = 0x2
	// Position of UNDERFI field.
	UOTGHS_HSTPIPISR0_ISOPIPES_UNDERFI_Pos = 0x2
	// Bit mask of UNDERFI field.
	UOTGHS_HSTPIPISR0_ISOPIPES_UNDERFI_Msk = 0x4
	// Bit UNDERFI.
	UOTGHS_HSTPIPISR0_ISOPIPES_UNDERFI = 0x4
	// Position of PERRI field.
	UOTGHS_HSTPIPISR0_ISOPIPES_PERRI_Pos = 0x3
	// Bit mask of PERRI field.
	UOTGHS_HSTPIPISR0_ISOPIPES_PERRI_Msk = 0x8
	// Bit PERRI.
	UOTGHS_HSTPIPISR0_ISOPIPES_PERRI = 0x8
	// Position of NAKEDI field.
	UOTGHS_HSTPIPISR0_ISOPIPES_NAKEDI_Pos = 0x4
	// Bit mask of NAKEDI field.
	UOTGHS_HSTPIPISR0_ISOPIPES_NAKEDI_Msk = 0x10
	// Bit NAKEDI.
	UOTGHS_HSTPIPISR0_ISOPIPES_NAKEDI = 0x10
	// Position of OVERFI field.
	UOTGHS_HSTPIPISR0_ISOPIPES_OVERFI_Pos = 0x5
	// Bit mask of OVERFI field.
	UOTGHS_HSTPIPISR0_ISOPIPES_OVERFI_Msk = 0x20
	// Bit OVERFI.
	UOTGHS_HSTPIPISR0_ISOPIPES_OVERFI = 0x20
	// Position of CRCERRI field.
	UOTGHS_HSTPIPISR0_ISOPIPES_CRCERRI_Pos = 0x6
	// Bit mask of CRCERRI field.
	UOTGHS_HSTPIPISR0_ISOPIPES_CRCERRI_Msk = 0x40
	// Bit CRCERRI.
	UOTGHS_HSTPIPISR0_ISOPIPES_CRCERRI = 0x40
	// Position of SHORTPACKETI field.
	UOTGHS_HSTPIPISR0_ISOPIPES_SHORTPACKETI_Pos = 0x7
	// Bit mask of SHORTPACKETI field.
	UOTGHS_HSTPIPISR0_ISOPIPES_SHORTPACKETI_Msk = 0x80
	// Bit SHORTPACKETI.
	UOTGHS_HSTPIPISR0_ISOPIPES_SHORTPACKETI = 0x80
	// Position of DTSEQ field.
	UOTGHS_HSTPIPISR0_ISOPIPES_DTSEQ_Pos = 0x8
	// Bit mask of DTSEQ field.
	UOTGHS_HSTPIPISR0_ISOPIPES_DTSEQ_Msk = 0x300
	// Data0 toggle sequence
	UOTGHS_HSTPIPISR0_ISOPIPES_DTSEQ_DATA0 = 0x0
	// Data1 toggle sequence
	UOTGHS_HSTPIPISR0_ISOPIPES_DTSEQ_DATA1 = 0x1
	// Position of NBUSYBK field.
	UOTGHS_HSTPIPISR0_ISOPIPES_NBUSYBK_Pos = 0xc
	// Bit mask of NBUSYBK field.
	UOTGHS_HSTPIPISR0_ISOPIPES_NBUSYBK_Msk = 0x3000
	// 0 busy bank (all banks free)
	UOTGHS_HSTPIPISR0_ISOPIPES_NBUSYBK_0_BUSY = 0x0
	// 1 busy bank
	UOTGHS_HSTPIPISR0_ISOPIPES_NBUSYBK_1_BUSY = 0x1
	// 2 busy banks
	UOTGHS_HSTPIPISR0_ISOPIPES_NBUSYBK_2_BUSY = 0x2
	// 3 busy banks
	UOTGHS_HSTPIPISR0_ISOPIPES_NBUSYBK_3_BUSY = 0x3
	// Position of CURRBK field.
	UOTGHS_HSTPIPISR0_ISOPIPES_CURRBK_Pos = 0xe
	// Bit mask of CURRBK field.
	UOTGHS_HSTPIPISR0_ISOPIPES_CURRBK_Msk = 0xc000
	// Current bank is bank0
	UOTGHS_HSTPIPISR0_ISOPIPES_CURRBK_BANK0 = 0x0
	// Current bank is bank1
	UOTGHS_HSTPIPISR0_ISOPIPES_CURRBK_BANK1 = 0x1
	// Current bank is bank2
	UOTGHS_HSTPIPISR0_ISOPIPES_CURRBK_BANK2 = 0x2
	// Position of RWALL field.
	UOTGHS_HSTPIPISR0_ISOPIPES_RWALL_Pos = 0x10
	// Bit mask of RWALL field.
	UOTGHS_HSTPIPISR0_ISOPIPES_RWALL_Msk = 0x10000
	// Bit RWALL.
	UOTGHS_HSTPIPISR0_ISOPIPES_RWALL = 0x10000
	// Position of CFGOK field.
	UOTGHS_HSTPIPISR0_ISOPIPES_CFGOK_Pos = 0x12
	// Bit mask of CFGOK field.
	UOTGHS_HSTPIPISR0_ISOPIPES_CFGOK_Msk = 0x40000
	// Bit CFGOK.
	UOTGHS_HSTPIPISR0_ISOPIPES_CFGOK = 0x40000
	// Position of PBYCT field.
	UOTGHS_HSTPIPISR0_ISOPIPES_PBYCT_Pos = 0x14
	// Bit mask of PBYCT field.
	UOTGHS_HSTPIPISR0_ISOPIPES_PBYCT_Msk = 0x7ff00000

	// HSTPIPICR: Host Pipe Clear Register (n = 0)
	// Position of RXINIC field.
	UOTGHS_HSTPIPICR_RXINIC_Pos = 0x0
	// Bit mask of RXINIC field.
	UOTGHS_HSTPIPICR_RXINIC_Msk = 0x1
	// Bit RXINIC.
	UOTGHS_HSTPIPICR_RXINIC = 0x1
	// Position of TXOUTIC field.
	UOTGHS_HSTPIPICR_TXOUTIC_Pos = 0x1
	// Bit mask of TXOUTIC field.
	UOTGHS_HSTPIPICR_TXOUTIC_Msk = 0x2
	// Bit TXOUTIC.
	UOTGHS_HSTPIPICR_TXOUTIC = 0x2
	// Position of TXSTPIC field.
	UOTGHS_HSTPIPICR_TXSTPIC_Pos = 0x2
	// Bit mask of TXSTPIC field.
	UOTGHS_HSTPIPICR_TXSTPIC_Msk = 0x4
	// Bit TXSTPIC.
	UOTGHS_HSTPIPICR_TXSTPIC = 0x4
	// Position of NAKEDIC field.
	UOTGHS_HSTPIPICR_NAKEDIC_Pos = 0x4
	// Bit mask of NAKEDIC field.
	UOTGHS_HSTPIPICR_NAKEDIC_Msk = 0x10
	// Bit NAKEDIC.
	UOTGHS_HSTPIPICR_NAKEDIC = 0x10
	// Position of OVERFIC field.
	UOTGHS_HSTPIPICR_OVERFIC_Pos = 0x5
	// Bit mask of OVERFIC field.
	UOTGHS_HSTPIPICR_OVERFIC_Msk = 0x20
	// Bit OVERFIC.
	UOTGHS_HSTPIPICR_OVERFIC = 0x20
	// Position of RXSTALLDIC field.
	UOTGHS_HSTPIPICR_RXSTALLDIC_Pos = 0x6
	// Bit mask of RXSTALLDIC field.
	UOTGHS_HSTPIPICR_RXSTALLDIC_Msk = 0x40
	// Bit RXSTALLDIC.
	UOTGHS_HSTPIPICR_RXSTALLDIC = 0x40
	// Position of SHORTPACKETIC field.
	UOTGHS_HSTPIPICR_SHORTPACKETIC_Pos = 0x7
	// Bit mask of SHORTPACKETIC field.
	UOTGHS_HSTPIPICR_SHORTPACKETIC_Msk = 0x80
	// Bit SHORTPACKETIC.
	UOTGHS_HSTPIPICR_SHORTPACKETIC = 0x80

	// HSTPIPICR0_INTPIPES: Host Pipe Clear Register (n = 0)
	// Position of RXINIC field.
	UOTGHS_HSTPIPICR0_INTPIPES_RXINIC_Pos = 0x0
	// Bit mask of RXINIC field.
	UOTGHS_HSTPIPICR0_INTPIPES_RXINIC_Msk = 0x1
	// Bit RXINIC.
	UOTGHS_HSTPIPICR0_INTPIPES_RXINIC = 0x1
	// Position of TXOUTIC field.
	UOTGHS_HSTPIPICR0_INTPIPES_TXOUTIC_Pos = 0x1
	// Bit mask of TXOUTIC field.
	UOTGHS_HSTPIPICR0_INTPIPES_TXOUTIC_Msk = 0x2
	// Bit TXOUTIC.
	UOTGHS_HSTPIPICR0_INTPIPES_TXOUTIC = 0x2
	// Position of UNDERFIC field.
	UOTGHS_HSTPIPICR0_INTPIPES_UNDERFIC_Pos = 0x2
	// Bit mask of UNDERFIC field.
	UOTGHS_HSTPIPICR0_INTPIPES_UNDERFIC_Msk = 0x4
	// Bit UNDERFIC.
	UOTGHS_HSTPIPICR0_INTPIPES_UNDERFIC = 0x4
	// Position of NAKEDIC field.
	UOTGHS_HSTPIPICR0_INTPIPES_NAKEDIC_Pos = 0x4
	// Bit mask of NAKEDIC field.
	UOTGHS_HSTPIPICR0_INTPIPES_NAKEDIC_Msk = 0x10
	// Bit NAKEDIC.
	UOTGHS_HSTPIPICR0_INTPIPES_NAKEDIC = 0x10
	// Position of OVERFIC field.
	UOTGHS_HSTPIPICR0_INTPIPES_OVERFIC_Pos = 0x5
	// Bit mask of OVERFIC field.
	UOTGHS_HSTPIPICR0_INTPIPES_OVERFIC_Msk = 0x20
	// Bit OVERFIC.
	UOTGHS_HSTPIPICR0_INTPIPES_OVERFIC = 0x20
	// Position of RXSTALLDIC field.
	UOTGHS_HSTPIPICR0_INTPIPES_RXSTALLDIC_Pos = 0x6
	// Bit mask of RXSTALLDIC field.
	UOTGHS_HSTPIPICR0_INTPIPES_RXSTALLDIC_Msk = 0x40
	// Bit RXSTALLDIC.
	UOTGHS_HSTPIPICR0_INTPIPES_RXSTALLDIC = 0x40
	// Position of SHORTPACKETIC field.
	UOTGHS_HSTPIPICR0_INTPIPES_SHORTPACKETIC_Pos = 0x7
	// Bit mask of SHORTPACKETIC field.
	UOTGHS_HSTPIPICR0_INTPIPES_SHORTPACKETIC_Msk = 0x80
	// Bit SHORTPACKETIC.
	UOTGHS_HSTPIPICR0_INTPIPES_SHORTPACKETIC = 0x80

	// HSTPIPICR0_ISOPIPES: Host Pipe Clear Register (n = 0)
	// Position of RXINIC field.
	UOTGHS_HSTPIPICR0_ISOPIPES_RXINIC_Pos = 0x0
	// Bit mask of RXINIC field.
	UOTGHS_HSTPIPICR0_ISOPIPES_RXINIC_Msk = 0x1
	// Bit RXINIC.
	UOTGHS_HSTPIPICR0_ISOPIPES_RXINIC = 0x1
	// Position of TXOUTIC field.
	UOTGHS_HSTPIPICR0_ISOPIPES_TXOUTIC_Pos = 0x1
	// Bit mask of TXOUTIC field.
	UOTGHS_HSTPIPICR0_ISOPIPES_TXOUTIC_Msk = 0x2
	// Bit TXOUTIC.
	UOTGHS_HSTPIPICR0_ISOPIPES_TXOUTIC = 0x2
	// Position of UNDERFIC field.
	UOTGHS_HSTPIPICR0_ISOPIPES_UNDERFIC_Pos = 0x2
	// Bit mask of UNDERFIC field.
	UOTGHS_HSTPIPICR0_ISOPIPES_UNDERFIC_Msk = 0x4
	// Bit UNDERFIC.
	UOTGHS_HSTPIPICR0_ISOPIPES_UNDERFIC = 0x4
	// Position of NAKEDIC field.
	UOTGHS_HSTPIPICR0_ISOPIPES_NAKEDIC_Pos = 0x4
	// Bit mask of NAKEDIC field.
	UOTGHS_HSTPIPICR0_ISOPIPES_NAKEDIC_Msk = 0x10
	// Bit NAKEDIC.
	UOTGHS_HSTPIPICR0_ISOPIPES_NAKEDIC = 0x10
	// Position of OVERFIC field.
	UOTGHS_HSTPIPICR0_ISOPIPES_OVERFIC_Pos = 0x5
	// Bit mask of OVERFIC field.
	UOTGHS_HSTPIPICR0_ISOPIPES_OVERFIC_Msk = 0x20
	// Bit OVERFIC.
	UOTGHS_HSTPIPICR0_ISOPIPES_OVERFIC = 0x20
	// Position of CRCERRIC field.
	UOTGHS_HSTPIPICR0_ISOPIPES_CRCERRIC_Pos = 0x6
	// Bit mask of CRCERRIC field.
	UOTGHS_HSTPIPICR0_ISOPIPES_CRCERRIC_Msk = 0x40
	// Bit CRCERRIC.
	UOTGHS_HSTPIPICR0_ISOPIPES_CRCERRIC = 0x40
	// Position of SHORTPACKETIC field.
	UOTGHS_HSTPIPICR0_ISOPIPES_SHORTPACKETIC_Pos = 0x7
	// Bit mask of SHORTPACKETIC field.
	UOTGHS_HSTPIPICR0_ISOPIPES_SHORTPACKETIC_Msk = 0x80
	// Bit SHORTPACKETIC.
	UOTGHS_HSTPIPICR0_ISOPIPES_SHORTPACKETIC = 0x80

	// HSTPIPIFR: Host Pipe Set Register (n = 0)
	// Position of RXINIS field.
	UOTGHS_HSTPIPIFR_RXINIS_Pos = 0x0
	// Bit mask of RXINIS field.
	UOTGHS_HSTPIPIFR_RXINIS_Msk = 0x1
	// Bit RXINIS.
	UOTGHS_HSTPIPIFR_RXINIS = 0x1
	// Position of TXOUTIS field.
	UOTGHS_HSTPIPIFR_TXOUTIS_Pos = 0x1
	// Bit mask of TXOUTIS field.
	UOTGHS_HSTPIPIFR_TXOUTIS_Msk = 0x2
	// Bit TXOUTIS.
	UOTGHS_HSTPIPIFR_TXOUTIS = 0x2
	// Position of TXSTPIS field.
	UOTGHS_HSTPIPIFR_TXSTPIS_Pos = 0x2
	// Bit mask of TXSTPIS field.
	UOTGHS_HSTPIPIFR_TXSTPIS_Msk = 0x4
	// Bit TXSTPIS.
	UOTGHS_HSTPIPIFR_TXSTPIS = 0x4
	// Position of PERRIS field.
	UOTGHS_HSTPIPIFR_PERRIS_Pos = 0x3
	// Bit mask of PERRIS field.
	UOTGHS_HSTPIPIFR_PERRIS_Msk = 0x8
	// Bit PERRIS.
	UOTGHS_HSTPIPIFR_PERRIS = 0x8
	// Position of NAKEDIS field.
	UOTGHS_HSTPIPIFR_NAKEDIS_Pos = 0x4
	// Bit mask of NAKEDIS field.
	UOTGHS_HSTPIPIFR_NAKEDIS_Msk = 0x10
	// Bit NAKEDIS.
	UOTGHS_HSTPIPIFR_NAKEDIS = 0x10
	// Position of OVERFIS field.
	UOTGHS_HSTPIPIFR_OVERFIS_Pos = 0x5
	// Bit mask of OVERFIS field.
	UOTGHS_HSTPIPIFR_OVERFIS_Msk = 0x20
	// Bit OVERFIS.
	UOTGHS_HSTPIPIFR_OVERFIS = 0x20
	// Position of RXSTALLDIS field.
	UOTGHS_HSTPIPIFR_RXSTALLDIS_Pos = 0x6
	// Bit mask of RXSTALLDIS field.
	UOTGHS_HSTPIPIFR_RXSTALLDIS_Msk = 0x40
	// Bit RXSTALLDIS.
	UOTGHS_HSTPIPIFR_RXSTALLDIS = 0x40
	// Position of SHORTPACKETIS field.
	UOTGHS_HSTPIPIFR_SHORTPACKETIS_Pos = 0x7
	// Bit mask of SHORTPACKETIS field.
	UOTGHS_HSTPIPIFR_SHORTPACKETIS_Msk = 0x80
	// Bit SHORTPACKETIS.
	UOTGHS_HSTPIPIFR_SHORTPACKETIS = 0x80
	// Position of NBUSYBKS field.
	UOTGHS_HSTPIPIFR_NBUSYBKS_Pos = 0xc
	// Bit mask of NBUSYBKS field.
	UOTGHS_HSTPIPIFR_NBUSYBKS_Msk = 0x1000
	// Bit NBUSYBKS.
	UOTGHS_HSTPIPIFR_NBUSYBKS = 0x1000

	// HSTPIPIFR0_INTPIPES: Host Pipe Set Register (n = 0)
	// Position of RXINIS field.
	UOTGHS_HSTPIPIFR0_INTPIPES_RXINIS_Pos = 0x0
	// Bit mask of RXINIS field.
	UOTGHS_HSTPIPIFR0_INTPIPES_RXINIS_Msk = 0x1
	// Bit RXINIS.
	UOTGHS_HSTPIPIFR0_INTPIPES_RXINIS = 0x1
	// Position of TXOUTIS field.
	UOTGHS_HSTPIPIFR0_INTPIPES_TXOUTIS_Pos = 0x1
	// Bit mask of TXOUTIS field.
	UOTGHS_HSTPIPIFR0_INTPIPES_TXOUTIS_Msk = 0x2
	// Bit TXOUTIS.
	UOTGHS_HSTPIPIFR0_INTPIPES_TXOUTIS = 0x2
	// Position of UNDERFIS field.
	UOTGHS_HSTPIPIFR0_INTPIPES_UNDERFIS_Pos = 0x2
	// Bit mask of UNDERFIS field.
	UOTGHS_HSTPIPIFR0_INTPIPES_UNDERFIS_Msk = 0x4
	// Bit UNDERFIS.
	UOTGHS_HSTPIPIFR0_INTPIPES_UNDERFIS = 0x4
	// Position of PERRIS field.
	UOTGHS_HSTPIPIFR0_INTPIPES_PERRIS_Pos = 0x3
	// Bit mask of PERRIS field.
	UOTGHS_HSTPIPIFR0_INTPIPES_PERRIS_Msk = 0x8
	// Bit PERRIS.
	UOTGHS_HSTPIPIFR0_INTPIPES_PERRIS = 0x8
	// Position of NAKEDIS field.
	UOTGHS_HSTPIPIFR0_INTPIPES_NAKEDIS_Pos = 0x4
	// Bit mask of NAKEDIS field.
	UOTGHS_HSTPIPIFR0_INTPIPES_NAKEDIS_Msk = 0x10
	// Bit NAKEDIS.
	UOTGHS_HSTPIPIFR0_INTPIPES_NAKEDIS = 0x10
	// Position of OVERFIS field.
	UOTGHS_HSTPIPIFR0_INTPIPES_OVERFIS_Pos = 0x5
	// Bit mask of OVERFIS field.
	UOTGHS_HSTPIPIFR0_INTPIPES_OVERFIS_Msk = 0x20
	// Bit OVERFIS.
	UOTGHS_HSTPIPIFR0_INTPIPES_OVERFIS = 0x20
	// Position of RXSTALLDIS field.
	UOTGHS_HSTPIPIFR0_INTPIPES_RXSTALLDIS_Pos = 0x6
	// Bit mask of RXSTALLDIS field.
	UOTGHS_HSTPIPIFR0_INTPIPES_RXSTALLDIS_Msk = 0x40
	// Bit RXSTALLDIS.
	UOTGHS_HSTPIPIFR0_INTPIPES_RXSTALLDIS = 0x40
	// Position of SHORTPACKETIS field.
	UOTGHS_HSTPIPIFR0_INTPIPES_SHORTPACKETIS_Pos = 0x7
	// Bit mask of SHORTPACKETIS field.
	UOTGHS_HSTPIPIFR0_INTPIPES_SHORTPACKETIS_Msk = 0x80
	// Bit SHORTPACKETIS.
	UOTGHS_HSTPIPIFR0_INTPIPES_SHORTPACKETIS = 0x80
	// Position of NBUSYBKS field.
	UOTGHS_HSTPIPIFR0_INTPIPES_NBUSYBKS_Pos = 0xc
	// Bit mask of NBUSYBKS field.
	UOTGHS_HSTPIPIFR0_INTPIPES_NBUSYBKS_Msk = 0x1000
	// Bit NBUSYBKS.
	UOTGHS_HSTPIPIFR0_INTPIPES_NBUSYBKS = 0x1000

	// HSTPIPIFR0_ISOPIPES: Host Pipe Set Register (n = 0)
	// Position of RXINIS field.
	UOTGHS_HSTPIPIFR0_ISOPIPES_RXINIS_Pos = 0x0
	// Bit mask of RXINIS field.
	UOTGHS_HSTPIPIFR0_ISOPIPES_RXINIS_Msk = 0x1
	// Bit RXINIS.
	UOTGHS_HSTPIPIFR0_ISOPIPES_RXINIS = 0x1
	// Position of TXOUTIS field.
	UOTGHS_HSTPIPIFR0_ISOPIPES_TXOUTIS_Pos = 0x1
	// Bit mask of TXOUTIS field.
	UOTGHS_HSTPIPIFR0_ISOPIPES_TXOUTIS_Msk = 0x2
	// Bit TXOUTIS.
	UOTGHS_HSTPIPIFR0_ISOPIPES_TXOUTIS = 0x2
	// Position of UNDERFIS field.
	UOTGHS_HSTPIPIFR0_ISOPIPES_UNDERFIS_Pos = 0x2
	// Bit mask of UNDERFIS field.
	UOTGHS_HSTPIPIFR0_ISOPIPES_UNDERFIS_Msk = 0x4
	// Bit UNDERFIS.
	UOTGHS_HSTPIPIFR0_ISOPIPES_UNDERFIS = 0x4
	// Position of PERRIS field.
	UOTGHS_HSTPIPIFR0_ISOPIPES_PERRIS_Pos = 0x3
	// Bit mask of PERRIS field.
	UOTGHS_HSTPIPIFR0_ISOPIPES_PERRIS_Msk = 0x8
	// Bit PERRIS.
	UOTGHS_HSTPIPIFR0_ISOPIPES_PERRIS = 0x8
	// Position of NAKEDIS field.
	UOTGHS_HSTPIPIFR0_ISOPIPES_NAKEDIS_Pos = 0x4
	// Bit mask of NAKEDIS field.
	UOTGHS_HSTPIPIFR0_ISOPIPES_NAKEDIS_Msk = 0x10
	// Bit NAKEDIS.
	UOTGHS_HSTPIPIFR0_ISOPIPES_NAKEDIS = 0x10
	// Position of OVERFIS field.
	UOTGHS_HSTPIPIFR0_ISOPIPES_OVERFIS_Pos = 0x5
	// Bit mask of OVERFIS field.
	UOTGHS_HSTPIPIFR0_ISOPIPES_OVERFIS_Msk = 0x20
	// Bit OVERFIS.
	UOTGHS_HSTPIPIFR0_ISOPIPES_OVERFIS = 0x20
	// Position of CRCERRIS field.
	UOTGHS_HSTPIPIFR0_ISOPIPES_CRCERRIS_Pos = 0x6
	// Bit mask of CRCERRIS field.
	UOTGHS_HSTPIPIFR0_ISOPIPES_CRCERRIS_Msk = 0x40
	// Bit CRCERRIS.
	UOTGHS_HSTPIPIFR0_ISOPIPES_CRCERRIS = 0x40
	// Position of SHORTPACKETIS field.
	UOTGHS_HSTPIPIFR0_ISOPIPES_SHORTPACKETIS_Pos = 0x7
	// Bit mask of SHORTPACKETIS field.
	UOTGHS_HSTPIPIFR0_ISOPIPES_SHORTPACKETIS_Msk = 0x80
	// Bit SHORTPACKETIS.
	UOTGHS_HSTPIPIFR0_ISOPIPES_SHORTPACKETIS = 0x80
	// Position of NBUSYBKS field.
	UOTGHS_HSTPIPIFR0_ISOPIPES_NBUSYBKS_Pos = 0xc
	// Bit mask of NBUSYBKS field.
	UOTGHS_HSTPIPIFR0_ISOPIPES_NBUSYBKS_Msk = 0x1000
	// Bit NBUSYBKS.
	UOTGHS_HSTPIPIFR0_ISOPIPES_NBUSYBKS = 0x1000

	// HSTPIPIMR: Host Pipe Mask Register (n = 0)
	// Position of RXINE field.
	UOTGHS_HSTPIPIMR_RXINE_Pos = 0x0
	// Bit mask of RXINE field.
	UOTGHS_HSTPIPIMR_RXINE_Msk = 0x1
	// Bit RXINE.
	UOTGHS_HSTPIPIMR_RXINE = 0x1
	// Position of TXOUTE field.
	UOTGHS_HSTPIPIMR_TXOUTE_Pos = 0x1
	// Bit mask of TXOUTE field.
	UOTGHS_HSTPIPIMR_TXOUTE_Msk = 0x2
	// Bit TXOUTE.
	UOTGHS_HSTPIPIMR_TXOUTE = 0x2
	// Position of TXSTPE field.
	UOTGHS_HSTPIPIMR_TXSTPE_Pos = 0x2
	// Bit mask of TXSTPE field.
	UOTGHS_HSTPIPIMR_TXSTPE_Msk = 0x4
	// Bit TXSTPE.
	UOTGHS_HSTPIPIMR_TXSTPE = 0x4
	// Position of PERRE field.
	UOTGHS_HSTPIPIMR_PERRE_Pos = 0x3
	// Bit mask of PERRE field.
	UOTGHS_HSTPIPIMR_PERRE_Msk = 0x8
	// Bit PERRE.
	UOTGHS_HSTPIPIMR_PERRE = 0x8
	// Position of NAKEDE field.
	UOTGHS_HSTPIPIMR_NAKEDE_Pos = 0x4
	// Bit mask of NAKEDE field.
	UOTGHS_HSTPIPIMR_NAKEDE_Msk = 0x10
	// Bit NAKEDE.
	UOTGHS_HSTPIPIMR_NAKEDE = 0x10
	// Position of OVERFIE field.
	UOTGHS_HSTPIPIMR_OVERFIE_Pos = 0x5
	// Bit mask of OVERFIE field.
	UOTGHS_HSTPIPIMR_OVERFIE_Msk = 0x20
	// Bit OVERFIE.
	UOTGHS_HSTPIPIMR_OVERFIE = 0x20
	// Position of RXSTALLDE field.
	UOTGHS_HSTPIPIMR_RXSTALLDE_Pos = 0x6
	// Bit mask of RXSTALLDE field.
	UOTGHS_HSTPIPIMR_RXSTALLDE_Msk = 0x40
	// Bit RXSTALLDE.
	UOTGHS_HSTPIPIMR_RXSTALLDE = 0x40
	// Position of SHORTPACKETIE field.
	UOTGHS_HSTPIPIMR_SHORTPACKETIE_Pos = 0x7
	// Bit mask of SHORTPACKETIE field.
	UOTGHS_HSTPIPIMR_SHORTPACKETIE_Msk = 0x80
	// Bit SHORTPACKETIE.
	UOTGHS_HSTPIPIMR_SHORTPACKETIE = 0x80
	// Position of NBUSYBKE field.
	UOTGHS_HSTPIPIMR_NBUSYBKE_Pos = 0xc
	// Bit mask of NBUSYBKE field.
	UOTGHS_HSTPIPIMR_NBUSYBKE_Msk = 0x1000
	// Bit NBUSYBKE.
	UOTGHS_HSTPIPIMR_NBUSYBKE = 0x1000
	// Position of FIFOCON field.
	UOTGHS_HSTPIPIMR_FIFOCON_Pos = 0xe
	// Bit mask of FIFOCON field.
	UOTGHS_HSTPIPIMR_FIFOCON_Msk = 0x4000
	// Bit FIFOCON.
	UOTGHS_HSTPIPIMR_FIFOCON = 0x4000
	// Position of PDISHDMA field.
	UOTGHS_HSTPIPIMR_PDISHDMA_Pos = 0x10
	// Bit mask of PDISHDMA field.
	UOTGHS_HSTPIPIMR_PDISHDMA_Msk = 0x10000
	// Bit PDISHDMA.
	UOTGHS_HSTPIPIMR_PDISHDMA = 0x10000
	// Position of PFREEZE field.
	UOTGHS_HSTPIPIMR_PFREEZE_Pos = 0x11
	// Bit mask of PFREEZE field.
	UOTGHS_HSTPIPIMR_PFREEZE_Msk = 0x20000
	// Bit PFREEZE.
	UOTGHS_HSTPIPIMR_PFREEZE = 0x20000
	// Position of RSTDT field.
	UOTGHS_HSTPIPIMR_RSTDT_Pos = 0x12
	// Bit mask of RSTDT field.
	UOTGHS_HSTPIPIMR_RSTDT_Msk = 0x40000
	// Bit RSTDT.
	UOTGHS_HSTPIPIMR_RSTDT = 0x40000

	// HSTPIPIMR0_INTPIPES: Host Pipe Mask Register (n = 0)
	// Position of RXINE field.
	UOTGHS_HSTPIPIMR0_INTPIPES_RXINE_Pos = 0x0
	// Bit mask of RXINE field.
	UOTGHS_HSTPIPIMR0_INTPIPES_RXINE_Msk = 0x1
	// Bit RXINE.
	UOTGHS_HSTPIPIMR0_INTPIPES_RXINE = 0x1
	// Position of TXOUTE field.
	UOTGHS_HSTPIPIMR0_INTPIPES_TXOUTE_Pos = 0x1
	// Bit mask of TXOUTE field.
	UOTGHS_HSTPIPIMR0_INTPIPES_TXOUTE_Msk = 0x2
	// Bit TXOUTE.
	UOTGHS_HSTPIPIMR0_INTPIPES_TXOUTE = 0x2
	// Position of UNDERFIE field.
	UOTGHS_HSTPIPIMR0_INTPIPES_UNDERFIE_Pos = 0x2
	// Bit mask of UNDERFIE field.
	UOTGHS_HSTPIPIMR0_INTPIPES_UNDERFIE_Msk = 0x4
	// Bit UNDERFIE.
	UOTGHS_HSTPIPIMR0_INTPIPES_UNDERFIE = 0x4
	// Position of PERRE field.
	UOTGHS_HSTPIPIMR0_INTPIPES_PERRE_Pos = 0x3
	// Bit mask of PERRE field.
	UOTGHS_HSTPIPIMR0_INTPIPES_PERRE_Msk = 0x8
	// Bit PERRE.
	UOTGHS_HSTPIPIMR0_INTPIPES_PERRE = 0x8
	// Position of NAKEDE field.
	UOTGHS_HSTPIPIMR0_INTPIPES_NAKEDE_Pos = 0x4
	// Bit mask of NAKEDE field.
	UOTGHS_HSTPIPIMR0_INTPIPES_NAKEDE_Msk = 0x10
	// Bit NAKEDE.
	UOTGHS_HSTPIPIMR0_INTPIPES_NAKEDE = 0x10
	// Position of OVERFIE field.
	UOTGHS_HSTPIPIMR0_INTPIPES_OVERFIE_Pos = 0x5
	// Bit mask of OVERFIE field.
	UOTGHS_HSTPIPIMR0_INTPIPES_OVERFIE_Msk = 0x20
	// Bit OVERFIE.
	UOTGHS_HSTPIPIMR0_INTPIPES_OVERFIE = 0x20
	// Position of RXSTALLDE field.
	UOTGHS_HSTPIPIMR0_INTPIPES_RXSTALLDE_Pos = 0x6
	// Bit mask of RXSTALLDE field.
	UOTGHS_HSTPIPIMR0_INTPIPES_RXSTALLDE_Msk = 0x40
	// Bit RXSTALLDE.
	UOTGHS_HSTPIPIMR0_INTPIPES_RXSTALLDE = 0x40
	// Position of SHORTPACKETIE field.
	UOTGHS_HSTPIPIMR0_INTPIPES_SHORTPACKETIE_Pos = 0x7
	// Bit mask of SHORTPACKETIE field.
	UOTGHS_HSTPIPIMR0_INTPIPES_SHORTPACKETIE_Msk = 0x80
	// Bit SHORTPACKETIE.
	UOTGHS_HSTPIPIMR0_INTPIPES_SHORTPACKETIE = 0x80
	// Position of NBUSYBKE field.
	UOTGHS_HSTPIPIMR0_INTPIPES_NBUSYBKE_Pos = 0xc
	// Bit mask of NBUSYBKE field.
	UOTGHS_HSTPIPIMR0_INTPIPES_NBUSYBKE_Msk = 0x1000
	// Bit NBUSYBKE.
	UOTGHS_HSTPIPIMR0_INTPIPES_NBUSYBKE = 0x1000
	// Position of FIFOCON field.
	UOTGHS_HSTPIPIMR0_INTPIPES_FIFOCON_Pos = 0xe
	// Bit mask of FIFOCON field.
	UOTGHS_HSTPIPIMR0_INTPIPES_FIFOCON_Msk = 0x4000
	// Bit FIFOCON.
	UOTGHS_HSTPIPIMR0_INTPIPES_FIFOCON = 0x4000
	// Position of PDISHDMA field.
	UOTGHS_HSTPIPIMR0_INTPIPES_PDISHDMA_Pos = 0x10
	// Bit mask of PDISHDMA field.
	UOTGHS_HSTPIPIMR0_INTPIPES_PDISHDMA_Msk = 0x10000
	// Bit PDISHDMA.
	UOTGHS_HSTPIPIMR0_INTPIPES_PDISHDMA = 0x10000
	// Position of PFREEZE field.
	UOTGHS_HSTPIPIMR0_INTPIPES_PFREEZE_Pos = 0x11
	// Bit mask of PFREEZE field.
	UOTGHS_HSTPIPIMR0_INTPIPES_PFREEZE_Msk = 0x20000
	// Bit PFREEZE.
	UOTGHS_HSTPIPIMR0_INTPIPES_PFREEZE = 0x20000
	// Position of RSTDT field.
	UOTGHS_HSTPIPIMR0_INTPIPES_RSTDT_Pos = 0x12
	// Bit mask of RSTDT field.
	UOTGHS_HSTPIPIMR0_INTPIPES_RSTDT_Msk = 0x40000
	// Bit RSTDT.
	UOTGHS_HSTPIPIMR0_INTPIPES_RSTDT = 0x40000

	// HSTPIPIMR0_ISOPIPES: Host Pipe Mask Register (n = 0)
	// Position of RXINE field.
	UOTGHS_HSTPIPIMR0_ISOPIPES_RXINE_Pos = 0x0
	// Bit mask of RXINE field.
	UOTGHS_HSTPIPIMR0_ISOPIPES_RXINE_Msk = 0x1
	// Bit RXINE.
	UOTGHS_HSTPIPIMR0_ISOPIPES_RXINE = 0x1
	// Position of TXOUTE field.
	UOTGHS_HSTPIPIMR0_ISOPIPES_TXOUTE_Pos = 0x1
	// Bit mask of TXOUTE field.
	UOTGHS_HSTPIPIMR0_ISOPIPES_TXOUTE_Msk = 0x2
	// Bit TXOUTE.
	UOTGHS_HSTPIPIMR0_ISOPIPES_TXOUTE = 0x2
	// Position of UNDERFIE field.
	UOTGHS_HSTPIPIMR0_ISOPIPES_UNDERFIE_Pos = 0x2
	// Bit mask of UNDERFIE field.
	UOTGHS_HSTPIPIMR0_ISOPIPES_UNDERFIE_Msk = 0x4
	// Bit UNDERFIE.
	UOTGHS_HSTPIPIMR0_ISOPIPES_UNDERFIE = 0x4
	// Position of PERRE field.
	UOTGHS_HSTPIPIMR0_ISOPIPES_PERRE_Pos = 0x3
	// Bit mask of PERRE field.
	UOTGHS_HSTPIPIMR0_ISOPIPES_PERRE_Msk = 0x8
	// Bit PERRE.
	UOTGHS_HSTPIPIMR0_ISOPIPES_PERRE = 0x8
	// Position of NAKEDE field.
	UOTGHS_HSTPIPIMR0_ISOPIPES_NAKEDE_Pos = 0x4
	// Bit mask of NAKEDE field.
	UOTGHS_HSTPIPIMR0_ISOPIPES_NAKEDE_Msk = 0x10
	// Bit NAKEDE.
	UOTGHS_HSTPIPIMR0_ISOPIPES_NAKEDE = 0x10
	// Position of OVERFIE field.
	UOTGHS_HSTPIPIMR0_ISOPIPES_OVERFIE_Pos = 0x5
	// Bit mask of OVERFIE field.
	UOTGHS_HSTPIPIMR0_ISOPIPES_OVERFIE_Msk = 0x20
	// Bit OVERFIE.
	UOTGHS_HSTPIPIMR0_ISOPIPES_OVERFIE = 0x20
	// Position of CRCERRE field.
	UOTGHS_HSTPIPIMR0_ISOPIPES_CRCERRE_Pos = 0x6
	// Bit mask of CRCERRE field.
	UOTGHS_HSTPIPIMR0_ISOPIPES_CRCERRE_Msk = 0x40
	// Bit CRCERRE.
	UOTGHS_HSTPIPIMR0_ISOPIPES_CRCERRE = 0x40
	// Position of SHORTPACKETIE field.
	UOTGHS_HSTPIPIMR0_ISOPIPES_SHORTPACKETIE_Pos = 0x7
	// Bit mask of SHORTPACKETIE field.
	UOTGHS_HSTPIPIMR0_ISOPIPES_SHORTPACKETIE_Msk = 0x80
	// Bit SHORTPACKETIE.
	UOTGHS_HSTPIPIMR0_ISOPIPES_SHORTPACKETIE = 0x80
	// Position of NBUSYBKE field.
	UOTGHS_HSTPIPIMR0_ISOPIPES_NBUSYBKE_Pos = 0xc
	// Bit mask of NBUSYBKE field.
	UOTGHS_HSTPIPIMR0_ISOPIPES_NBUSYBKE_Msk = 0x1000
	// Bit NBUSYBKE.
	UOTGHS_HSTPIPIMR0_ISOPIPES_NBUSYBKE = 0x1000
	// Position of FIFOCON field.
	UOTGHS_HSTPIPIMR0_ISOPIPES_FIFOCON_Pos = 0xe
	// Bit mask of FIFOCON field.
	UOTGHS_HSTPIPIMR0_ISOPIPES_FIFOCON_Msk = 0x4000
	// Bit FIFOCON.
	UOTGHS_HSTPIPIMR0_ISOPIPES_FIFOCON = 0x4000
	// Position of PDISHDMA field.
	UOTGHS_HSTPIPIMR0_ISOPIPES_PDISHDMA_Pos = 0x10
	// Bit mask of PDISHDMA field.
	UOTGHS_HSTPIPIMR0_ISOPIPES_PDISHDMA_Msk = 0x10000
	// Bit PDISHDMA.
	UOTGHS_HSTPIPIMR0_ISOPIPES_PDISHDMA = 0x10000
	// Position of PFREEZE field.
	UOTGHS_HSTPIPIMR0_ISOPIPES_PFREEZE_Pos = 0x11
	// Bit mask of PFREEZE field.
	UOTGHS_HSTPIPIMR0_ISOPIPES_PFREEZE_Msk = 0x20000
	// Bit PFREEZE.
	UOTGHS_HSTPIPIMR0_ISOPIPES_PFREEZE = 0x20000
	// Position of RSTDT field.
	UOTGHS_HSTPIPIMR0_ISOPIPES_RSTDT_Pos = 0x12
	// Bit mask of RSTDT field.
	UOTGHS_HSTPIPIMR0_ISOPIPES_RSTDT_Msk = 0x40000
	// Bit RSTDT.
	UOTGHS_HSTPIPIMR0_ISOPIPES_RSTDT = 0x40000

	// HSTPIPIER: Host Pipe Enable Register (n = 0)
	// Position of RXINES field.
	UOTGHS_HSTPIPIER_RXINES_Pos = 0x0
	// Bit mask of RXINES field.
	UOTGHS_HSTPIPIER_RXINES_Msk = 0x1
	// Bit RXINES.
	UOTGHS_HSTPIPIER_RXINES = 0x1
	// Position of TXOUTES field.
	UOTGHS_HSTPIPIER_TXOUTES_Pos = 0x1
	// Bit mask of TXOUTES field.
	UOTGHS_HSTPIPIER_TXOUTES_Msk = 0x2
	// Bit TXOUTES.
	UOTGHS_HSTPIPIER_TXOUTES = 0x2
	// Position of TXSTPES field.
	UOTGHS_HSTPIPIER_TXSTPES_Pos = 0x2
	// Bit mask of TXSTPES field.
	UOTGHS_HSTPIPIER_TXSTPES_Msk = 0x4
	// Bit TXSTPES.
	UOTGHS_HSTPIPIER_TXSTPES = 0x4
	// Position of PERRES field.
	UOTGHS_HSTPIPIER_PERRES_Pos = 0x3
	// Bit mask of PERRES field.
	UOTGHS_HSTPIPIER_PERRES_Msk = 0x8
	// Bit PERRES.
	UOTGHS_HSTPIPIER_PERRES = 0x8
	// Position of NAKEDES field.
	UOTGHS_HSTPIPIER_NAKEDES_Pos = 0x4
	// Bit mask of NAKEDES field.
	UOTGHS_HSTPIPIER_NAKEDES_Msk = 0x10
	// Bit NAKEDES.
	UOTGHS_HSTPIPIER_NAKEDES = 0x10
	// Position of OVERFIES field.
	UOTGHS_HSTPIPIER_OVERFIES_Pos = 0x5
	// Bit mask of OVERFIES field.
	UOTGHS_HSTPIPIER_OVERFIES_Msk = 0x20
	// Bit OVERFIES.
	UOTGHS_HSTPIPIER_OVERFIES = 0x20
	// Position of RXSTALLDES field.
	UOTGHS_HSTPIPIER_RXSTALLDES_Pos = 0x6
	// Bit mask of RXSTALLDES field.
	UOTGHS_HSTPIPIER_RXSTALLDES_Msk = 0x40
	// Bit RXSTALLDES.
	UOTGHS_HSTPIPIER_RXSTALLDES = 0x40
	// Position of SHORTPACKETIES field.
	UOTGHS_HSTPIPIER_SHORTPACKETIES_Pos = 0x7
	// Bit mask of SHORTPACKETIES field.
	UOTGHS_HSTPIPIER_SHORTPACKETIES_Msk = 0x80
	// Bit SHORTPACKETIES.
	UOTGHS_HSTPIPIER_SHORTPACKETIES = 0x80
	// Position of NBUSYBKES field.
	UOTGHS_HSTPIPIER_NBUSYBKES_Pos = 0xc
	// Bit mask of NBUSYBKES field.
	UOTGHS_HSTPIPIER_NBUSYBKES_Msk = 0x1000
	// Bit NBUSYBKES.
	UOTGHS_HSTPIPIER_NBUSYBKES = 0x1000
	// Position of PDISHDMAS field.
	UOTGHS_HSTPIPIER_PDISHDMAS_Pos = 0x10
	// Bit mask of PDISHDMAS field.
	UOTGHS_HSTPIPIER_PDISHDMAS_Msk = 0x10000
	// Bit PDISHDMAS.
	UOTGHS_HSTPIPIER_PDISHDMAS = 0x10000
	// Position of PFREEZES field.
	UOTGHS_HSTPIPIER_PFREEZES_Pos = 0x11
	// Bit mask of PFREEZES field.
	UOTGHS_HSTPIPIER_PFREEZES_Msk = 0x20000
	// Bit PFREEZES.
	UOTGHS_HSTPIPIER_PFREEZES = 0x20000
	// Position of RSTDTS field.
	UOTGHS_HSTPIPIER_RSTDTS_Pos = 0x12
	// Bit mask of RSTDTS field.
	UOTGHS_HSTPIPIER_RSTDTS_Msk = 0x40000
	// Bit RSTDTS.
	UOTGHS_HSTPIPIER_RSTDTS = 0x40000

	// HSTPIPIER0_INTPIPES: Host Pipe Enable Register (n = 0)
	// Position of RXINES field.
	UOTGHS_HSTPIPIER0_INTPIPES_RXINES_Pos = 0x0
	// Bit mask of RXINES field.
	UOTGHS_HSTPIPIER0_INTPIPES_RXINES_Msk = 0x1
	// Bit RXINES.
	UOTGHS_HSTPIPIER0_INTPIPES_RXINES = 0x1
	// Position of TXOUTES field.
	UOTGHS_HSTPIPIER0_INTPIPES_TXOUTES_Pos = 0x1
	// Bit mask of TXOUTES field.
	UOTGHS_HSTPIPIER0_INTPIPES_TXOUTES_Msk = 0x2
	// Bit TXOUTES.
	UOTGHS_HSTPIPIER0_INTPIPES_TXOUTES = 0x2
	// Position of UNDERFIES field.
	UOTGHS_HSTPIPIER0_INTPIPES_UNDERFIES_Pos = 0x2
	// Bit mask of UNDERFIES field.
	UOTGHS_HSTPIPIER0_INTPIPES_UNDERFIES_Msk = 0x4
	// Bit UNDERFIES.
	UOTGHS_HSTPIPIER0_INTPIPES_UNDERFIES = 0x4
	// Position of PERRES field.
	UOTGHS_HSTPIPIER0_INTPIPES_PERRES_Pos = 0x3
	// Bit mask of PERRES field.
	UOTGHS_HSTPIPIER0_INTPIPES_PERRES_Msk = 0x8
	// Bit PERRES.
	UOTGHS_HSTPIPIER0_INTPIPES_PERRES = 0x8
	// Position of NAKEDES field.
	UOTGHS_HSTPIPIER0_INTPIPES_NAKEDES_Pos = 0x4
	// Bit mask of NAKEDES field.
	UOTGHS_HSTPIPIER0_INTPIPES_NAKEDES_Msk = 0x10
	// Bit NAKEDES.
	UOTGHS_HSTPIPIER0_INTPIPES_NAKEDES = 0x10
	// Position of OVERFIES field.
	UOTGHS_HSTPIPIER0_INTPIPES_OVERFIES_Pos = 0x5
	// Bit mask of OVERFIES field.
	UOTGHS_HSTPIPIER0_INTPIPES_OVERFIES_Msk = 0x20
	// Bit OVERFIES.
	UOTGHS_HSTPIPIER0_INTPIPES_OVERFIES = 0x20
	// Position of RXSTALLDES field.
	UOTGHS_HSTPIPIER0_INTPIPES_RXSTALLDES_Pos = 0x6
	// Bit mask of RXSTALLDES field.
	UOTGHS_HSTPIPIER0_INTPIPES_RXSTALLDES_Msk = 0x40
	// Bit RXSTALLDES.
	UOTGHS_HSTPIPIER0_INTPIPES_RXSTALLDES = 0x40
	// Position of SHORTPACKETIES field.
	UOTGHS_HSTPIPIER0_INTPIPES_SHORTPACKETIES_Pos = 0x7
	// Bit mask of SHORTPACKETIES field.
	UOTGHS_HSTPIPIER0_INTPIPES_SHORTPACKETIES_Msk = 0x80
	// Bit SHORTPACKETIES.
	UOTGHS_HSTPIPIER0_INTPIPES_SHORTPACKETIES = 0x80
	// Position of NBUSYBKES field.
	UOTGHS_HSTPIPIER0_INTPIPES_NBUSYBKES_Pos = 0xc
	// Bit mask of NBUSYBKES field.
	UOTGHS_HSTPIPIER0_INTPIPES_NBUSYBKES_Msk = 0x1000
	// Bit NBUSYBKES.
	UOTGHS_HSTPIPIER0_INTPIPES_NBUSYBKES = 0x1000
	// Position of PDISHDMAS field.
	UOTGHS_HSTPIPIER0_INTPIPES_PDISHDMAS_Pos = 0x10
	// Bit mask of PDISHDMAS field.
	UOTGHS_HSTPIPIER0_INTPIPES_PDISHDMAS_Msk = 0x10000
	// Bit PDISHDMAS.
	UOTGHS_HSTPIPIER0_INTPIPES_PDISHDMAS = 0x10000
	// Position of PFREEZES field.
	UOTGHS_HSTPIPIER0_INTPIPES_PFREEZES_Pos = 0x11
	// Bit mask of PFREEZES field.
	UOTGHS_HSTPIPIER0_INTPIPES_PFREEZES_Msk = 0x20000
	// Bit PFREEZES.
	UOTGHS_HSTPIPIER0_INTPIPES_PFREEZES = 0x20000
	// Position of RSTDTS field.
	UOTGHS_HSTPIPIER0_INTPIPES_RSTDTS_Pos = 0x12
	// Bit mask of RSTDTS field.
	UOTGHS_HSTPIPIER0_INTPIPES_RSTDTS_Msk = 0x40000
	// Bit RSTDTS.
	UOTGHS_HSTPIPIER0_INTPIPES_RSTDTS = 0x40000

	// HSTPIPIER0_ISOPIPES: Host Pipe Enable Register (n = 0)
	// Position of RXINES field.
	UOTGHS_HSTPIPIER0_ISOPIPES_RXINES_Pos = 0x0
	// Bit mask of RXINES field.
	UOTGHS_HSTPIPIER0_ISOPIPES_RXINES_Msk = 0x1
	// Bit RXINES.
	UOTGHS_HSTPIPIER0_ISOPIPES_RXINES = 0x1
	// Position of TXOUTES field.
	UOTGHS_HSTPIPIER0_ISOPIPES_TXOUTES_Pos = 0x1
	// Bit mask of TXOUTES field.
	UOTGHS_HSTPIPIER0_ISOPIPES_TXOUTES_Msk = 0x2
	// Bit TXOUTES.
	UOTGHS_HSTPIPIER0_ISOPIPES_TXOUTES = 0x2
	// Position of UNDERFIES field.
	UOTGHS_HSTPIPIER0_ISOPIPES_UNDERFIES_Pos = 0x2
	// Bit mask of UNDERFIES field.
	UOTGHS_HSTPIPIER0_ISOPIPES_UNDERFIES_Msk = 0x4
	// Bit UNDERFIES.
	UOTGHS_HSTPIPIER0_ISOPIPES_UNDERFIES = 0x4
	// Position of PERRES field.
	UOTGHS_HSTPIPIER0_ISOPIPES_PERRES_Pos = 0x3
	// Bit mask of PERRES field.
	UOTGHS_HSTPIPIER0_ISOPIPES_PERRES_Msk = 0x8
	// Bit PERRES.
	UOTGHS_HSTPIPIER0_ISOPIPES_PERRES = 0x8
	// Position of NAKEDES field.
	UOTGHS_HSTPIPIER0_ISOPIPES_NAKEDES_Pos = 0x4
	// Bit mask of NAKEDES field.
	UOTGHS_HSTPIPIER0_ISOPIPES_NAKEDES_Msk = 0x10
	// Bit NAKEDES.
	UOTGHS_HSTPIPIER0_ISOPIPES_NAKEDES = 0x10
	// Position of OVERFIES field.
	UOTGHS_HSTPIPIER0_ISOPIPES_OVERFIES_Pos = 0x5
	// Bit mask of OVERFIES field.
	UOTGHS_HSTPIPIER0_ISOPIPES_OVERFIES_Msk = 0x20
	// Bit OVERFIES.
	UOTGHS_HSTPIPIER0_ISOPIPES_OVERFIES = 0x20
	// Position of CRCERRES field.
	UOTGHS_HSTPIPIER0_ISOPIPES_CRCERRES_Pos = 0x6
	// Bit mask of CRCERRES field.
	UOTGHS_HSTPIPIER0_ISOPIPES_CRCERRES_Msk = 0x40
	// Bit CRCERRES.
	UOTGHS_HSTPIPIER0_ISOPIPES_CRCERRES = 0x40
	// Position of SHORTPACKETIES field.
	UOTGHS_HSTPIPIER0_ISOPIPES_SHORTPACKETIES_Pos = 0x7
	// Bit mask of SHORTPACKETIES field.
	UOTGHS_HSTPIPIER0_ISOPIPES_SHORTPACKETIES_Msk = 0x80
	// Bit SHORTPACKETIES.
	UOTGHS_HSTPIPIER0_ISOPIPES_SHORTPACKETIES = 0x80
	// Position of NBUSYBKES field.
	UOTGHS_HSTPIPIER0_ISOPIPES_NBUSYBKES_Pos = 0xc
	// Bit mask of NBUSYBKES field.
	UOTGHS_HSTPIPIER0_ISOPIPES_NBUSYBKES_Msk = 0x1000
	// Bit NBUSYBKES.
	UOTGHS_HSTPIPIER0_ISOPIPES_NBUSYBKES = 0x1000
	// Position of PDISHDMAS field.
	UOTGHS_HSTPIPIER0_ISOPIPES_PDISHDMAS_Pos = 0x10
	// Bit mask of PDISHDMAS field.
	UOTGHS_HSTPIPIER0_ISOPIPES_PDISHDMAS_Msk = 0x10000
	// Bit PDISHDMAS.
	UOTGHS_HSTPIPIER0_ISOPIPES_PDISHDMAS = 0x10000
	// Position of PFREEZES field.
	UOTGHS_HSTPIPIER0_ISOPIPES_PFREEZES_Pos = 0x11
	// Bit mask of PFREEZES field.
	UOTGHS_HSTPIPIER0_ISOPIPES_PFREEZES_Msk = 0x20000
	// Bit PFREEZES.
	UOTGHS_HSTPIPIER0_ISOPIPES_PFREEZES = 0x20000
	// Position of RSTDTS field.
	UOTGHS_HSTPIPIER0_ISOPIPES_RSTDTS_Pos = 0x12
	// Bit mask of RSTDTS field.
	UOTGHS_HSTPIPIER0_ISOPIPES_RSTDTS_Msk = 0x40000
	// Bit RSTDTS.
	UOTGHS_HSTPIPIER0_ISOPIPES_RSTDTS = 0x40000

	// HSTPIPIDR: Host Pipe Disable Register (n = 0)
	// Position of RXINEC field.
	UOTGHS_HSTPIPIDR_RXINEC_Pos = 0x0
	// Bit mask of RXINEC field.
	UOTGHS_HSTPIPIDR_RXINEC_Msk = 0x1
	// Bit RXINEC.
	UOTGHS_HSTPIPIDR_RXINEC = 0x1
	// Position of TXOUTEC field.
	UOTGHS_HSTPIPIDR_TXOUTEC_Pos = 0x1
	// Bit mask of TXOUTEC field.
	UOTGHS_HSTPIPIDR_TXOUTEC_Msk = 0x2
	// Bit TXOUTEC.
	UOTGHS_HSTPIPIDR_TXOUTEC = 0x2
	// Position of TXSTPEC field.
	UOTGHS_HSTPIPIDR_TXSTPEC_Pos = 0x2
	// Bit mask of TXSTPEC field.
	UOTGHS_HSTPIPIDR_TXSTPEC_Msk = 0x4
	// Bit TXSTPEC.
	UOTGHS_HSTPIPIDR_TXSTPEC = 0x4
	// Position of PERREC field.
	UOTGHS_HSTPIPIDR_PERREC_Pos = 0x3
	// Bit mask of PERREC field.
	UOTGHS_HSTPIPIDR_PERREC_Msk = 0x8
	// Bit PERREC.
	UOTGHS_HSTPIPIDR_PERREC = 0x8
	// Position of NAKEDEC field.
	UOTGHS_HSTPIPIDR_NAKEDEC_Pos = 0x4
	// Bit mask of NAKEDEC field.
	UOTGHS_HSTPIPIDR_NAKEDEC_Msk = 0x10
	// Bit NAKEDEC.
	UOTGHS_HSTPIPIDR_NAKEDEC = 0x10
	// Position of OVERFIEC field.
	UOTGHS_HSTPIPIDR_OVERFIEC_Pos = 0x5
	// Bit mask of OVERFIEC field.
	UOTGHS_HSTPIPIDR_OVERFIEC_Msk = 0x20
	// Bit OVERFIEC.
	UOTGHS_HSTPIPIDR_OVERFIEC = 0x20
	// Position of RXSTALLDEC field.
	UOTGHS_HSTPIPIDR_RXSTALLDEC_Pos = 0x6
	// Bit mask of RXSTALLDEC field.
	UOTGHS_HSTPIPIDR_RXSTALLDEC_Msk = 0x40
	// Bit RXSTALLDEC.
	UOTGHS_HSTPIPIDR_RXSTALLDEC = 0x40
	// Position of SHORTPACKETIEC field.
	UOTGHS_HSTPIPIDR_SHORTPACKETIEC_Pos = 0x7
	// Bit mask of SHORTPACKETIEC field.
	UOTGHS_HSTPIPIDR_SHORTPACKETIEC_Msk = 0x80
	// Bit SHORTPACKETIEC.
	UOTGHS_HSTPIPIDR_SHORTPACKETIEC = 0x80
	// Position of NBUSYBKEC field.
	UOTGHS_HSTPIPIDR_NBUSYBKEC_Pos = 0xc
	// Bit mask of NBUSYBKEC field.
	UOTGHS_HSTPIPIDR_NBUSYBKEC_Msk = 0x1000
	// Bit NBUSYBKEC.
	UOTGHS_HSTPIPIDR_NBUSYBKEC = 0x1000
	// Position of FIFOCONC field.
	UOTGHS_HSTPIPIDR_FIFOCONC_Pos = 0xe
	// Bit mask of FIFOCONC field.
	UOTGHS_HSTPIPIDR_FIFOCONC_Msk = 0x4000
	// Bit FIFOCONC.
	UOTGHS_HSTPIPIDR_FIFOCONC = 0x4000
	// Position of PDISHDMAC field.
	UOTGHS_HSTPIPIDR_PDISHDMAC_Pos = 0x10
	// Bit mask of PDISHDMAC field.
	UOTGHS_HSTPIPIDR_PDISHDMAC_Msk = 0x10000
	// Bit PDISHDMAC.
	UOTGHS_HSTPIPIDR_PDISHDMAC = 0x10000
	// Position of PFREEZEC field.
	UOTGHS_HSTPIPIDR_PFREEZEC_Pos = 0x11
	// Bit mask of PFREEZEC field.
	UOTGHS_HSTPIPIDR_PFREEZEC_Msk = 0x20000
	// Bit PFREEZEC.
	UOTGHS_HSTPIPIDR_PFREEZEC = 0x20000

	// HSTPIPIDR0_INTPIPES: Host Pipe Disable Register (n = 0)
	// Position of RXINEC field.
	UOTGHS_HSTPIPIDR0_INTPIPES_RXINEC_Pos = 0x0
	// Bit mask of RXINEC field.
	UOTGHS_HSTPIPIDR0_INTPIPES_RXINEC_Msk = 0x1
	// Bit RXINEC.
	UOTGHS_HSTPIPIDR0_INTPIPES_RXINEC = 0x1
	// Position of TXOUTEC field.
	UOTGHS_HSTPIPIDR0_INTPIPES_TXOUTEC_Pos = 0x1
	// Bit mask of TXOUTEC field.
	UOTGHS_HSTPIPIDR0_INTPIPES_TXOUTEC_Msk = 0x2
	// Bit TXOUTEC.
	UOTGHS_HSTPIPIDR0_INTPIPES_TXOUTEC = 0x2
	// Position of UNDERFIEC field.
	UOTGHS_HSTPIPIDR0_INTPIPES_UNDERFIEC_Pos = 0x2
	// Bit mask of UNDERFIEC field.
	UOTGHS_HSTPIPIDR0_INTPIPES_UNDERFIEC_Msk = 0x4
	// Bit UNDERFIEC.
	UOTGHS_HSTPIPIDR0_INTPIPES_UNDERFIEC = 0x4
	// Position of PERREC field.
	UOTGHS_HSTPIPIDR0_INTPIPES_PERREC_Pos = 0x3
	// Bit mask of PERREC field.
	UOTGHS_HSTPIPIDR0_INTPIPES_PERREC_Msk = 0x8
	// Bit PERREC.
	UOTGHS_HSTPIPIDR0_INTPIPES_PERREC = 0x8
	// Position of NAKEDEC field.
	UOTGHS_HSTPIPIDR0_INTPIPES_NAKEDEC_Pos = 0x4
	// Bit mask of NAKEDEC field.
	UOTGHS_HSTPIPIDR0_INTPIPES_NAKEDEC_Msk = 0x10
	// Bit NAKEDEC.
	UOTGHS_HSTPIPIDR0_INTPIPES_NAKEDEC = 0x10
	// Position of OVERFIEC field.
	UOTGHS_HSTPIPIDR0_INTPIPES_OVERFIEC_Pos = 0x5
	// Bit mask of OVERFIEC field.
	UOTGHS_HSTPIPIDR0_INTPIPES_OVERFIEC_Msk = 0x20
	// Bit OVERFIEC.
	UOTGHS_HSTPIPIDR0_INTPIPES_OVERFIEC = 0x20
	// Position of RXSTALLDEC field.
	UOTGHS_HSTPIPIDR0_INTPIPES_RXSTALLDEC_Pos = 0x6
	// Bit mask of RXSTALLDEC field.
	UOTGHS_HSTPIPIDR0_INTPIPES_RXSTALLDEC_Msk = 0x40
	// Bit RXSTALLDEC.
	UOTGHS_HSTPIPIDR0_INTPIPES_RXSTALLDEC = 0x40
	// Position of SHORTPACKETIEC field.
	UOTGHS_HSTPIPIDR0_INTPIPES_SHORTPACKETIEC_Pos = 0x7
	// Bit mask of SHORTPACKETIEC field.
	UOTGHS_HSTPIPIDR0_INTPIPES_SHORTPACKETIEC_Msk = 0x80
	// Bit SHORTPACKETIEC.
	UOTGHS_HSTPIPIDR0_INTPIPES_SHORTPACKETIEC = 0x80
	// Position of NBUSYBKEC field.
	UOTGHS_HSTPIPIDR0_INTPIPES_NBUSYBKEC_Pos = 0xc
	// Bit mask of NBUSYBKEC field.
	UOTGHS_HSTPIPIDR0_INTPIPES_NBUSYBKEC_Msk = 0x1000
	// Bit NBUSYBKEC.
	UOTGHS_HSTPIPIDR0_INTPIPES_NBUSYBKEC = 0x1000
	// Position of FIFOCONC field.
	UOTGHS_HSTPIPIDR0_INTPIPES_FIFOCONC_Pos = 0xe
	// Bit mask of FIFOCONC field.
	UOTGHS_HSTPIPIDR0_INTPIPES_FIFOCONC_Msk = 0x4000
	// Bit FIFOCONC.
	UOTGHS_HSTPIPIDR0_INTPIPES_FIFOCONC = 0x4000
	// Position of PDISHDMAC field.
	UOTGHS_HSTPIPIDR0_INTPIPES_PDISHDMAC_Pos = 0x10
	// Bit mask of PDISHDMAC field.
	UOTGHS_HSTPIPIDR0_INTPIPES_PDISHDMAC_Msk = 0x10000
	// Bit PDISHDMAC.
	UOTGHS_HSTPIPIDR0_INTPIPES_PDISHDMAC = 0x10000
	// Position of PFREEZEC field.
	UOTGHS_HSTPIPIDR0_INTPIPES_PFREEZEC_Pos = 0x11
	// Bit mask of PFREEZEC field.
	UOTGHS_HSTPIPIDR0_INTPIPES_PFREEZEC_Msk = 0x20000
	// Bit PFREEZEC.
	UOTGHS_HSTPIPIDR0_INTPIPES_PFREEZEC = 0x20000

	// HSTPIPIDR0_ISOPIPES: Host Pipe Disable Register (n = 0)
	// Position of RXINEC field.
	UOTGHS_HSTPIPIDR0_ISOPIPES_RXINEC_Pos = 0x0
	// Bit mask of RXINEC field.
	UOTGHS_HSTPIPIDR0_ISOPIPES_RXINEC_Msk = 0x1
	// Bit RXINEC.
	UOTGHS_HSTPIPIDR0_ISOPIPES_RXINEC = 0x1
	// Position of TXOUTEC field.
	UOTGHS_HSTPIPIDR0_ISOPIPES_TXOUTEC_Pos = 0x1
	// Bit mask of TXOUTEC field.
	UOTGHS_HSTPIPIDR0_ISOPIPES_TXOUTEC_Msk = 0x2
	// Bit TXOUTEC.
	UOTGHS_HSTPIPIDR0_ISOPIPES_TXOUTEC = 0x2
	// Position of UNDERFIEC field.
	UOTGHS_HSTPIPIDR0_ISOPIPES_UNDERFIEC_Pos = 0x2
	// Bit mask of UNDERFIEC field.
	UOTGHS_HSTPIPIDR0_ISOPIPES_UNDERFIEC_Msk = 0x4
	// Bit UNDERFIEC.
	UOTGHS_HSTPIPIDR0_ISOPIPES_UNDERFIEC = 0x4
	// Position of PERREC field.
	UOTGHS_HSTPIPIDR0_ISOPIPES_PERREC_Pos = 0x3
	// Bit mask of PERREC field.
	UOTGHS_HSTPIPIDR0_ISOPIPES_PERREC_Msk = 0x8
	// Bit PERREC.
	UOTGHS_HSTPIPIDR0_ISOPIPES_PERREC = 0x8
	// Position of NAKEDEC field.
	UOTGHS_HSTPIPIDR0_ISOPIPES_NAKEDEC_Pos = 0x4
	// Bit mask of NAKEDEC field.
	UOTGHS_HSTPIPIDR0_ISOPIPES_NAKEDEC_Msk = 0x10
	// Bit NAKEDEC.
	UOTGHS_HSTPIPIDR0_ISOPIPES_NAKEDEC = 0x10
	// Position of OVERFIEC field.
	UOTGHS_HSTPIPIDR0_ISOPIPES_OVERFIEC_Pos = 0x5
	// Bit mask of OVERFIEC field.
	UOTGHS_HSTPIPIDR0_ISOPIPES_OVERFIEC_Msk = 0x20
	// Bit OVERFIEC.
	UOTGHS_HSTPIPIDR0_ISOPIPES_OVERFIEC = 0x20
	// Position of CRCERREC field.
	UOTGHS_HSTPIPIDR0_ISOPIPES_CRCERREC_Pos = 0x6
	// Bit mask of CRCERREC field.
	UOTGHS_HSTPIPIDR0_ISOPIPES_CRCERREC_Msk = 0x40
	// Bit CRCERREC.
	UOTGHS_HSTPIPIDR0_ISOPIPES_CRCERREC = 0x40
	// Position of SHORTPACKETIEC field.
	UOTGHS_HSTPIPIDR0_ISOPIPES_SHORTPACKETIEC_Pos = 0x7
	// Bit mask of SHORTPACKETIEC field.
	UOTGHS_HSTPIPIDR0_ISOPIPES_SHORTPACKETIEC_Msk = 0x80
	// Bit SHORTPACKETIEC.
	UOTGHS_HSTPIPIDR0_ISOPIPES_SHORTPACKETIEC = 0x80
	// Position of NBUSYBKEC field.
	UOTGHS_HSTPIPIDR0_ISOPIPES_NBUSYBKEC_Pos = 0xc
	// Bit mask of NBUSYBKEC field.
	UOTGHS_HSTPIPIDR0_ISOPIPES_NBUSYBKEC_Msk = 0x1000
	// Bit NBUSYBKEC.
	UOTGHS_HSTPIPIDR0_ISOPIPES_NBUSYBKEC = 0x1000
	// Position of FIFOCONC field.
	UOTGHS_HSTPIPIDR0_ISOPIPES_FIFOCONC_Pos = 0xe
	// Bit mask of FIFOCONC field.
	UOTGHS_HSTPIPIDR0_ISOPIPES_FIFOCONC_Msk = 0x4000
	// Bit FIFOCONC.
	UOTGHS_HSTPIPIDR0_ISOPIPES_FIFOCONC = 0x4000
	// Position of PDISHDMAC field.
	UOTGHS_HSTPIPIDR0_ISOPIPES_PDISHDMAC_Pos = 0x10
	// Bit mask of PDISHDMAC field.
	UOTGHS_HSTPIPIDR0_ISOPIPES_PDISHDMAC_Msk = 0x10000
	// Bit PDISHDMAC.
	UOTGHS_HSTPIPIDR0_ISOPIPES_PDISHDMAC = 0x10000
	// Position of PFREEZEC field.
	UOTGHS_HSTPIPIDR0_ISOPIPES_PFREEZEC_Pos = 0x11
	// Bit mask of PFREEZEC field.
	UOTGHS_HSTPIPIDR0_ISOPIPES_PFREEZEC_Msk = 0x20000
	// Bit PFREEZEC.
	UOTGHS_HSTPIPIDR0_ISOPIPES_PFREEZEC = 0x20000

	// HSTPIPINRQ: Host Pipe IN Request Register (n = 0)
	// Position of INRQ field.
	UOTGHS_HSTPIPINRQ_INRQ_Pos = 0x0
	// Bit mask of INRQ field.
	UOTGHS_HSTPIPINRQ_INRQ_Msk = 0xff
	// Position of INMODE field.
	UOTGHS_HSTPIPINRQ_INMODE_Pos = 0x8
	// Bit mask of INMODE field.
	UOTGHS_HSTPIPINRQ_INMODE_Msk = 0x100
	// Bit INMODE.
	UOTGHS_HSTPIPINRQ_INMODE = 0x100

	// HSTPIPERR: Host Pipe Error Register (n = 0)
	// Position of DATATGL field.
	UOTGHS_HSTPIPERR_DATATGL_Pos = 0x0
	// Bit mask of DATATGL field.
	UOTGHS_HSTPIPERR_DATATGL_Msk = 0x1
	// Bit DATATGL.
	UOTGHS_HSTPIPERR_DATATGL = 0x1
	// Position of DATAPID field.
	UOTGHS_HSTPIPERR_DATAPID_Pos = 0x1
	// Bit mask of DATAPID field.
	UOTGHS_HSTPIPERR_DATAPID_Msk = 0x2
	// Bit DATAPID.
	UOTGHS_HSTPIPERR_DATAPID = 0x2
	// Position of PID field.
	UOTGHS_HSTPIPERR_PID_Pos = 0x2
	// Bit mask of PID field.
	UOTGHS_HSTPIPERR_PID_Msk = 0x4
	// Bit PID.
	UOTGHS_HSTPIPERR_PID = 0x4
	// Position of TIMEOUT field.
	UOTGHS_HSTPIPERR_TIMEOUT_Pos = 0x3
	// Bit mask of TIMEOUT field.
	UOTGHS_HSTPIPERR_TIMEOUT_Msk = 0x8
	// Bit TIMEOUT.
	UOTGHS_HSTPIPERR_TIMEOUT = 0x8
	// Position of CRC16 field.
	UOTGHS_HSTPIPERR_CRC16_Pos = 0x4
	// Bit mask of CRC16 field.
	UOTGHS_HSTPIPERR_CRC16_Msk = 0x10
	// Bit CRC16.
	UOTGHS_HSTPIPERR_CRC16 = 0x10
	// Position of COUNTER field.
	UOTGHS_HSTPIPERR_COUNTER_Pos = 0x5
	// Bit mask of COUNTER field.
	UOTGHS_HSTPIPERR_COUNTER_Msk = 0x60

	// HSTDMANXTDSC1: Host DMA Channel Next Descriptor Address Register (n = 1)
	// Position of NXT_DSC_ADD field.
	UOTGHS_HSTDMANXTDSC1_NXT_DSC_ADD_Pos = 0x0
	// Bit mask of NXT_DSC_ADD field.
	UOTGHS_HSTDMANXTDSC1_NXT_DSC_ADD_Msk = 0xffffffff

	// HSTDMAADDRESS1: Host DMA Channel Address Register (n = 1)
	// Position of BUFF_ADD field.
	UOTGHS_HSTDMAADDRESS1_BUFF_ADD_Pos = 0x0
	// Bit mask of BUFF_ADD field.
	UOTGHS_HSTDMAADDRESS1_BUFF_ADD_Msk = 0xffffffff

	// HSTDMACONTROL1: Host DMA Channel Control Register (n = 1)
	// Position of CHANN_ENB field.
	UOTGHS_HSTDMACONTROL1_CHANN_ENB_Pos = 0x0
	// Bit mask of CHANN_ENB field.
	UOTGHS_HSTDMACONTROL1_CHANN_ENB_Msk = 0x1
	// Bit CHANN_ENB.
	UOTGHS_HSTDMACONTROL1_CHANN_ENB = 0x1
	// Position of LDNXT_DSC field.
	UOTGHS_HSTDMACONTROL1_LDNXT_DSC_Pos = 0x1
	// Bit mask of LDNXT_DSC field.
	UOTGHS_HSTDMACONTROL1_LDNXT_DSC_Msk = 0x2
	// Bit LDNXT_DSC.
	UOTGHS_HSTDMACONTROL1_LDNXT_DSC = 0x2
	// Position of END_TR_EN field.
	UOTGHS_HSTDMACONTROL1_END_TR_EN_Pos = 0x2
	// Bit mask of END_TR_EN field.
	UOTGHS_HSTDMACONTROL1_END_TR_EN_Msk = 0x4
	// Bit END_TR_EN.
	UOTGHS_HSTDMACONTROL1_END_TR_EN = 0x4
	// Position of END_B_EN field.
	UOTGHS_HSTDMACONTROL1_END_B_EN_Pos = 0x3
	// Bit mask of END_B_EN field.
	UOTGHS_HSTDMACONTROL1_END_B_EN_Msk = 0x8
	// Bit END_B_EN.
	UOTGHS_HSTDMACONTROL1_END_B_EN = 0x8
	// Position of END_TR_IT field.
	UOTGHS_HSTDMACONTROL1_END_TR_IT_Pos = 0x4
	// Bit mask of END_TR_IT field.
	UOTGHS_HSTDMACONTROL1_END_TR_IT_Msk = 0x10
	// Bit END_TR_IT.
	UOTGHS_HSTDMACONTROL1_END_TR_IT = 0x10
	// Position of END_BUFFIT field.
	UOTGHS_HSTDMACONTROL1_END_BUFFIT_Pos = 0x5
	// Bit mask of END_BUFFIT field.
	UOTGHS_HSTDMACONTROL1_END_BUFFIT_Msk = 0x20
	// Bit END_BUFFIT.
	UOTGHS_HSTDMACONTROL1_END_BUFFIT = 0x20
	// Position of DESC_LD_IT field.
	UOTGHS_HSTDMACONTROL1_DESC_LD_IT_Pos = 0x6
	// Bit mask of DESC_LD_IT field.
	UOTGHS_HSTDMACONTROL1_DESC_LD_IT_Msk = 0x40
	// Bit DESC_LD_IT.
	UOTGHS_HSTDMACONTROL1_DESC_LD_IT = 0x40
	// Position of BURST_LCK field.
	UOTGHS_HSTDMACONTROL1_BURST_LCK_Pos = 0x7
	// Bit mask of BURST_LCK field.
	UOTGHS_HSTDMACONTROL1_BURST_LCK_Msk = 0x80
	// Bit BURST_LCK.
	UOTGHS_HSTDMACONTROL1_BURST_LCK = 0x80
	// Position of BUFF_LENGTH field.
	UOTGHS_HSTDMACONTROL1_BUFF_LENGTH_Pos = 0x10
	// Bit mask of BUFF_LENGTH field.
	UOTGHS_HSTDMACONTROL1_BUFF_LENGTH_Msk = 0xffff0000

	// HSTDMASTATUS1: Host DMA Channel Status Register (n = 1)
	// Position of CHANN_ENB field.
	UOTGHS_HSTDMASTATUS1_CHANN_ENB_Pos = 0x0
	// Bit mask of CHANN_ENB field.
	UOTGHS_HSTDMASTATUS1_CHANN_ENB_Msk = 0x1
	// Bit CHANN_ENB.
	UOTGHS_HSTDMASTATUS1_CHANN_ENB = 0x1
	// Position of CHANN_ACT field.
	UOTGHS_HSTDMASTATUS1_CHANN_ACT_Pos = 0x1
	// Bit mask of CHANN_ACT field.
	UOTGHS_HSTDMASTATUS1_CHANN_ACT_Msk = 0x2
	// Bit CHANN_ACT.
	UOTGHS_HSTDMASTATUS1_CHANN_ACT = 0x2
	// Position of END_TR_ST field.
	UOTGHS_HSTDMASTATUS1_END_TR_ST_Pos = 0x4
	// Bit mask of END_TR_ST field.
	UOTGHS_HSTDMASTATUS1_END_TR_ST_Msk = 0x10
	// Bit END_TR_ST.
	UOTGHS_HSTDMASTATUS1_END_TR_ST = 0x10
	// Position of END_BF_ST field.
	UOTGHS_HSTDMASTATUS1_END_BF_ST_Pos = 0x5
	// Bit mask of END_BF_ST field.
	UOTGHS_HSTDMASTATUS1_END_BF_ST_Msk = 0x20
	// Bit END_BF_ST.
	UOTGHS_HSTDMASTATUS1_END_BF_ST = 0x20
	// Position of DESC_LDST field.
	UOTGHS_HSTDMASTATUS1_DESC_LDST_Pos = 0x6
	// Bit mask of DESC_LDST field.
	UOTGHS_HSTDMASTATUS1_DESC_LDST_Msk = 0x40
	// Bit DESC_LDST.
	UOTGHS_HSTDMASTATUS1_DESC_LDST = 0x40
	// Position of BUFF_COUNT field.
	UOTGHS_HSTDMASTATUS1_BUFF_COUNT_Pos = 0x10
	// Bit mask of BUFF_COUNT field.
	UOTGHS_HSTDMASTATUS1_BUFF_COUNT_Msk = 0xffff0000

	// HSTDMANXTDSC2: Host DMA Channel Next Descriptor Address Register (n = 2)
	// Position of NXT_DSC_ADD field.
	UOTGHS_HSTDMANXTDSC2_NXT_DSC_ADD_Pos = 0x0
	// Bit mask of NXT_DSC_ADD field.
	UOTGHS_HSTDMANXTDSC2_NXT_DSC_ADD_Msk = 0xffffffff

	// HSTDMAADDRESS2: Host DMA Channel Address Register (n = 2)
	// Position of BUFF_ADD field.
	UOTGHS_HSTDMAADDRESS2_BUFF_ADD_Pos = 0x0
	// Bit mask of BUFF_ADD field.
	UOTGHS_HSTDMAADDRESS2_BUFF_ADD_Msk = 0xffffffff

	// HSTDMACONTROL2: Host DMA Channel Control Register (n = 2)
	// Position of CHANN_ENB field.
	UOTGHS_HSTDMACONTROL2_CHANN_ENB_Pos = 0x0
	// Bit mask of CHANN_ENB field.
	UOTGHS_HSTDMACONTROL2_CHANN_ENB_Msk = 0x1
	// Bit CHANN_ENB.
	UOTGHS_HSTDMACONTROL2_CHANN_ENB = 0x1
	// Position of LDNXT_DSC field.
	UOTGHS_HSTDMACONTROL2_LDNXT_DSC_Pos = 0x1
	// Bit mask of LDNXT_DSC field.
	UOTGHS_HSTDMACONTROL2_LDNXT_DSC_Msk = 0x2
	// Bit LDNXT_DSC.
	UOTGHS_HSTDMACONTROL2_LDNXT_DSC = 0x2
	// Position of END_TR_EN field.
	UOTGHS_HSTDMACONTROL2_END_TR_EN_Pos = 0x2
	// Bit mask of END_TR_EN field.
	UOTGHS_HSTDMACONTROL2_END_TR_EN_Msk = 0x4
	// Bit END_TR_EN.
	UOTGHS_HSTDMACONTROL2_END_TR_EN = 0x4
	// Position of END_B_EN field.
	UOTGHS_HSTDMACONTROL2_END_B_EN_Pos = 0x3
	// Bit mask of END_B_EN field.
	UOTGHS_HSTDMACONTROL2_END_B_EN_Msk = 0x8
	// Bit END_B_EN.
	UOTGHS_HSTDMACONTROL2_END_B_EN = 0x8
	// Position of END_TR_IT field.
	UOTGHS_HSTDMACONTROL2_END_TR_IT_Pos = 0x4
	// Bit mask of END_TR_IT field.
	UOTGHS_HSTDMACONTROL2_END_TR_IT_Msk = 0x10
	// Bit END_TR_IT.
	UOTGHS_HSTDMACONTROL2_END_TR_IT = 0x10
	// Position of END_BUFFIT field.
	UOTGHS_HSTDMACONTROL2_END_BUFFIT_Pos = 0x5
	// Bit mask of END_BUFFIT field.
	UOTGHS_HSTDMACONTROL2_END_BUFFIT_Msk = 0x20
	// Bit END_BUFFIT.
	UOTGHS_HSTDMACONTROL2_END_BUFFIT = 0x20
	// Position of DESC_LD_IT field.
	UOTGHS_HSTDMACONTROL2_DESC_LD_IT_Pos = 0x6
	// Bit mask of DESC_LD_IT field.
	UOTGHS_HSTDMACONTROL2_DESC_LD_IT_Msk = 0x40
	// Bit DESC_LD_IT.
	UOTGHS_HSTDMACONTROL2_DESC_LD_IT = 0x40
	// Position of BURST_LCK field.
	UOTGHS_HSTDMACONTROL2_BURST_LCK_Pos = 0x7
	// Bit mask of BURST_LCK field.
	UOTGHS_HSTDMACONTROL2_BURST_LCK_Msk = 0x80
	// Bit BURST_LCK.
	UOTGHS_HSTDMACONTROL2_BURST_LCK = 0x80
	// Position of BUFF_LENGTH field.
	UOTGHS_HSTDMACONTROL2_BUFF_LENGTH_Pos = 0x10
	// Bit mask of BUFF_LENGTH field.
	UOTGHS_HSTDMACONTROL2_BUFF_LENGTH_Msk = 0xffff0000

	// HSTDMASTATUS2: Host DMA Channel Status Register (n = 2)
	// Position of CHANN_ENB field.
	UOTGHS_HSTDMASTATUS2_CHANN_ENB_Pos = 0x0
	// Bit mask of CHANN_ENB field.
	UOTGHS_HSTDMASTATUS2_CHANN_ENB_Msk = 0x1
	// Bit CHANN_ENB.
	UOTGHS_HSTDMASTATUS2_CHANN_ENB = 0x1
	// Position of CHANN_ACT field.
	UOTGHS_HSTDMASTATUS2_CHANN_ACT_Pos = 0x1
	// Bit mask of CHANN_ACT field.
	UOTGHS_HSTDMASTATUS2_CHANN_ACT_Msk = 0x2
	// Bit CHANN_ACT.
	UOTGHS_HSTDMASTATUS2_CHANN_ACT = 0x2
	// Position of END_TR_ST field.
	UOTGHS_HSTDMASTATUS2_END_TR_ST_Pos = 0x4
	// Bit mask of END_TR_ST field.
	UOTGHS_HSTDMASTATUS2_END_TR_ST_Msk = 0x10
	// Bit END_TR_ST.
	UOTGHS_HSTDMASTATUS2_END_TR_ST = 0x10
	// Position of END_BF_ST field.
	UOTGHS_HSTDMASTATUS2_END_BF_ST_Pos = 0x5
	// Bit mask of END_BF_ST field.
	UOTGHS_HSTDMASTATUS2_END_BF_ST_Msk = 0x20
	// Bit END_BF_ST.
	UOTGHS_HSTDMASTATUS2_END_BF_ST = 0x20
	// Position of DESC_LDST field.
	UOTGHS_HSTDMASTATUS2_DESC_LDST_Pos = 0x6
	// Bit mask of DESC_LDST field.
	UOTGHS_HSTDMASTATUS2_DESC_LDST_Msk = 0x40
	// Bit DESC_LDST.
	UOTGHS_HSTDMASTATUS2_DESC_LDST = 0x40
	// Position of BUFF_COUNT field.
	UOTGHS_HSTDMASTATUS2_BUFF_COUNT_Pos = 0x10
	// Bit mask of BUFF_COUNT field.
	UOTGHS_HSTDMASTATUS2_BUFF_COUNT_Msk = 0xffff0000

	// HSTDMANXTDSC3: Host DMA Channel Next Descriptor Address Register (n = 3)
	// Position of NXT_DSC_ADD field.
	UOTGHS_HSTDMANXTDSC3_NXT_DSC_ADD_Pos = 0x0
	// Bit mask of NXT_DSC_ADD field.
	UOTGHS_HSTDMANXTDSC3_NXT_DSC_ADD_Msk = 0xffffffff

	// HSTDMAADDRESS3: Host DMA Channel Address Register (n = 3)
	// Position of BUFF_ADD field.
	UOTGHS_HSTDMAADDRESS3_BUFF_ADD_Pos = 0x0
	// Bit mask of BUFF_ADD field.
	UOTGHS_HSTDMAADDRESS3_BUFF_ADD_Msk = 0xffffffff

	// HSTDMACONTROL3: Host DMA Channel Control Register (n = 3)
	// Position of CHANN_ENB field.
	UOTGHS_HSTDMACONTROL3_CHANN_ENB_Pos = 0x0
	// Bit mask of CHANN_ENB field.
	UOTGHS_HSTDMACONTROL3_CHANN_ENB_Msk = 0x1
	// Bit CHANN_ENB.
	UOTGHS_HSTDMACONTROL3_CHANN_ENB = 0x1
	// Position of LDNXT_DSC field.
	UOTGHS_HSTDMACONTROL3_LDNXT_DSC_Pos = 0x1
	// Bit mask of LDNXT_DSC field.
	UOTGHS_HSTDMACONTROL3_LDNXT_DSC_Msk = 0x2
	// Bit LDNXT_DSC.
	UOTGHS_HSTDMACONTROL3_LDNXT_DSC = 0x2
	// Position of END_TR_EN field.
	UOTGHS_HSTDMACONTROL3_END_TR_EN_Pos = 0x2
	// Bit mask of END_TR_EN field.
	UOTGHS_HSTDMACONTROL3_END_TR_EN_Msk = 0x4
	// Bit END_TR_EN.
	UOTGHS_HSTDMACONTROL3_END_TR_EN = 0x4
	// Position of END_B_EN field.
	UOTGHS_HSTDMACONTROL3_END_B_EN_Pos = 0x3
	// Bit mask of END_B_EN field.
	UOTGHS_HSTDMACONTROL3_END_B_EN_Msk = 0x8
	// Bit END_B_EN.
	UOTGHS_HSTDMACONTROL3_END_B_EN = 0x8
	// Position of END_TR_IT field.
	UOTGHS_HSTDMACONTROL3_END_TR_IT_Pos = 0x4
	// Bit mask of END_TR_IT field.
	UOTGHS_HSTDMACONTROL3_END_TR_IT_Msk = 0x10
	// Bit END_TR_IT.
	UOTGHS_HSTDMACONTROL3_END_TR_IT = 0x10
	// Position of END_BUFFIT field.
	UOTGHS_HSTDMACONTROL3_END_BUFFIT_Pos = 0x5
	// Bit mask of END_BUFFIT field.
	UOTGHS_HSTDMACONTROL3_END_BUFFIT_Msk = 0x20
	// Bit END_BUFFIT.
	UOTGHS_HSTDMACONTROL3_END_BUFFIT = 0x20
	// Position of DESC_LD_IT field.
	UOTGHS_HSTDMACONTROL3_DESC_LD_IT_Pos = 0x6
	// Bit mask of DESC_LD_IT field.
	UOTGHS_HSTDMACONTROL3_DESC_LD_IT_Msk = 0x40
	// Bit DESC_LD_IT.
	UOTGHS_HSTDMACONTROL3_DESC_LD_IT = 0x40
	// Position of BURST_LCK field.
	UOTGHS_HSTDMACONTROL3_BURST_LCK_Pos = 0x7
	// Bit mask of BURST_LCK field.
	UOTGHS_HSTDMACONTROL3_BURST_LCK_Msk = 0x80
	// Bit BURST_LCK.
	UOTGHS_HSTDMACONTROL3_BURST_LCK = 0x80
	// Position of BUFF_LENGTH field.
	UOTGHS_HSTDMACONTROL3_BUFF_LENGTH_Pos = 0x10
	// Bit mask of BUFF_LENGTH field.
	UOTGHS_HSTDMACONTROL3_BUFF_LENGTH_Msk = 0xffff0000

	// HSTDMASTATUS3: Host DMA Channel Status Register (n = 3)
	// Position of CHANN_ENB field.
	UOTGHS_HSTDMASTATUS3_CHANN_ENB_Pos = 0x0
	// Bit mask of CHANN_ENB field.
	UOTGHS_HSTDMASTATUS3_CHANN_ENB_Msk = 0x1
	// Bit CHANN_ENB.
	UOTGHS_HSTDMASTATUS3_CHANN_ENB = 0x1
	// Position of CHANN_ACT field.
	UOTGHS_HSTDMASTATUS3_CHANN_ACT_Pos = 0x1
	// Bit mask of CHANN_ACT field.
	UOTGHS_HSTDMASTATUS3_CHANN_ACT_Msk = 0x2
	// Bit CHANN_ACT.
	UOTGHS_HSTDMASTATUS3_CHANN_ACT = 0x2
	// Position of END_TR_ST field.
	UOTGHS_HSTDMASTATUS3_END_TR_ST_Pos = 0x4
	// Bit mask of END_TR_ST field.
	UOTGHS_HSTDMASTATUS3_END_TR_ST_Msk = 0x10
	// Bit END_TR_ST.
	UOTGHS_HSTDMASTATUS3_END_TR_ST = 0x10
	// Position of END_BF_ST field.
	UOTGHS_HSTDMASTATUS3_END_BF_ST_Pos = 0x5
	// Bit mask of END_BF_ST field.
	UOTGHS_HSTDMASTATUS3_END_BF_ST_Msk = 0x20
	// Bit END_BF_ST.
	UOTGHS_HSTDMASTATUS3_END_BF_ST = 0x20
	// Position of DESC_LDST field.
	UOTGHS_HSTDMASTATUS3_DESC_LDST_Pos = 0x6
	// Bit mask of DESC_LDST field.
	UOTGHS_HSTDMASTATUS3_DESC_LDST_Msk = 0x40
	// Bit DESC_LDST.
	UOTGHS_HSTDMASTATUS3_DESC_LDST = 0x40
	// Position of BUFF_COUNT field.
	UOTGHS_HSTDMASTATUS3_BUFF_COUNT_Pos = 0x10
	// Bit mask of BUFF_COUNT field.
	UOTGHS_HSTDMASTATUS3_BUFF_COUNT_Msk = 0xffff0000

	// HSTDMANXTDSC4: Host DMA Channel Next Descriptor Address Register (n = 4)
	// Position of NXT_DSC_ADD field.
	UOTGHS_HSTDMANXTDSC4_NXT_DSC_ADD_Pos = 0x0
	// Bit mask of NXT_DSC_ADD field.
	UOTGHS_HSTDMANXTDSC4_NXT_DSC_ADD_Msk = 0xffffffff

	// HSTDMAADDRESS4: Host DMA Channel Address Register (n = 4)
	// Position of BUFF_ADD field.
	UOTGHS_HSTDMAADDRESS4_BUFF_ADD_Pos = 0x0
	// Bit mask of BUFF_ADD field.
	UOTGHS_HSTDMAADDRESS4_BUFF_ADD_Msk = 0xffffffff

	// HSTDMACONTROL4: Host DMA Channel Control Register (n = 4)
	// Position of CHANN_ENB field.
	UOTGHS_HSTDMACONTROL4_CHANN_ENB_Pos = 0x0
	// Bit mask of CHANN_ENB field.
	UOTGHS_HSTDMACONTROL4_CHANN_ENB_Msk = 0x1
	// Bit CHANN_ENB.
	UOTGHS_HSTDMACONTROL4_CHANN_ENB = 0x1
	// Position of LDNXT_DSC field.
	UOTGHS_HSTDMACONTROL4_LDNXT_DSC_Pos = 0x1
	// Bit mask of LDNXT_DSC field.
	UOTGHS_HSTDMACONTROL4_LDNXT_DSC_Msk = 0x2
	// Bit LDNXT_DSC.
	UOTGHS_HSTDMACONTROL4_LDNXT_DSC = 0x2
	// Position of END_TR_EN field.
	UOTGHS_HSTDMACONTROL4_END_TR_EN_Pos = 0x2
	// Bit mask of END_TR_EN field.
	UOTGHS_HSTDMACONTROL4_END_TR_EN_Msk = 0x4
	// Bit END_TR_EN.
	UOTGHS_HSTDMACONTROL4_END_TR_EN = 0x4
	// Position of END_B_EN field.
	UOTGHS_HSTDMACONTROL4_END_B_EN_Pos = 0x3
	// Bit mask of END_B_EN field.
	UOTGHS_HSTDMACONTROL4_END_B_EN_Msk = 0x8
	// Bit END_B_EN.
	UOTGHS_HSTDMACONTROL4_END_B_EN = 0x8
	// Position of END_TR_IT field.
	UOTGHS_HSTDMACONTROL4_END_TR_IT_Pos = 0x4
	// Bit mask of END_TR_IT field.
	UOTGHS_HSTDMACONTROL4_END_TR_IT_Msk = 0x10
	// Bit END_TR_IT.
	UOTGHS_HSTDMACONTROL4_END_TR_IT = 0x10
	// Position of END_BUFFIT field.
	UOTGHS_HSTDMACONTROL4_END_BUFFIT_Pos = 0x5
	// Bit mask of END_BUFFIT field.
	UOTGHS_HSTDMACONTROL4_END_BUFFIT_Msk = 0x20
	// Bit END_BUFFIT.
	UOTGHS_HSTDMACONTROL4_END_BUFFIT = 0x20
	// Position of DESC_LD_IT field.
	UOTGHS_HSTDMACONTROL4_DESC_LD_IT_Pos = 0x6
	// Bit mask of DESC_LD_IT field.
	UOTGHS_HSTDMACONTROL4_DESC_LD_IT_Msk = 0x40
	// Bit DESC_LD_IT.
	UOTGHS_HSTDMACONTROL4_DESC_LD_IT = 0x40
	// Position of BURST_LCK field.
	UOTGHS_HSTDMACONTROL4_BURST_LCK_Pos = 0x7
	// Bit mask of BURST_LCK field.
	UOTGHS_HSTDMACONTROL4_BURST_LCK_Msk = 0x80
	// Bit BURST_LCK.
	UOTGHS_HSTDMACONTROL4_BURST_LCK = 0x80
	// Position of BUFF_LENGTH field.
	UOTGHS_HSTDMACONTROL4_BUFF_LENGTH_Pos = 0x10
	// Bit mask of BUFF_LENGTH field.
	UOTGHS_HSTDMACONTROL4_BUFF_LENGTH_Msk = 0xffff0000

	// HSTDMASTATUS4: Host DMA Channel Status Register (n = 4)
	// Position of CHANN_ENB field.
	UOTGHS_HSTDMASTATUS4_CHANN_ENB_Pos = 0x0
	// Bit mask of CHANN_ENB field.
	UOTGHS_HSTDMASTATUS4_CHANN_ENB_Msk = 0x1
	// Bit CHANN_ENB.
	UOTGHS_HSTDMASTATUS4_CHANN_ENB = 0x1
	// Position of CHANN_ACT field.
	UOTGHS_HSTDMASTATUS4_CHANN_ACT_Pos = 0x1
	// Bit mask of CHANN_ACT field.
	UOTGHS_HSTDMASTATUS4_CHANN_ACT_Msk = 0x2
	// Bit CHANN_ACT.
	UOTGHS_HSTDMASTATUS4_CHANN_ACT = 0x2
	// Position of END_TR_ST field.
	UOTGHS_HSTDMASTATUS4_END_TR_ST_Pos = 0x4
	// Bit mask of END_TR_ST field.
	UOTGHS_HSTDMASTATUS4_END_TR_ST_Msk = 0x10
	// Bit END_TR_ST.
	UOTGHS_HSTDMASTATUS4_END_TR_ST = 0x10
	// Position of END_BF_ST field.
	UOTGHS_HSTDMASTATUS4_END_BF_ST_Pos = 0x5
	// Bit mask of END_BF_ST field.
	UOTGHS_HSTDMASTATUS4_END_BF_ST_Msk = 0x20
	// Bit END_BF_ST.
	UOTGHS_HSTDMASTATUS4_END_BF_ST = 0x20
	// Position of DESC_LDST field.
	UOTGHS_HSTDMASTATUS4_DESC_LDST_Pos = 0x6
	// Bit mask of DESC_LDST field.
	UOTGHS_HSTDMASTATUS4_DESC_LDST_Msk = 0x40
	// Bit DESC_LDST.
	UOTGHS_HSTDMASTATUS4_DESC_LDST = 0x40
	// Position of BUFF_COUNT field.
	UOTGHS_HSTDMASTATUS4_BUFF_COUNT_Pos = 0x10
	// Bit mask of BUFF_COUNT field.
	UOTGHS_HSTDMASTATUS4_BUFF_COUNT_Msk = 0xffff0000

	// HSTDMANXTDSC5: Host DMA Channel Next Descriptor Address Register (n = 5)
	// Position of NXT_DSC_ADD field.
	UOTGHS_HSTDMANXTDSC5_NXT_DSC_ADD_Pos = 0x0
	// Bit mask of NXT_DSC_ADD field.
	UOTGHS_HSTDMANXTDSC5_NXT_DSC_ADD_Msk = 0xffffffff

	// HSTDMAADDRESS5: Host DMA Channel Address Register (n = 5)
	// Position of BUFF_ADD field.
	UOTGHS_HSTDMAADDRESS5_BUFF_ADD_Pos = 0x0
	// Bit mask of BUFF_ADD field.
	UOTGHS_HSTDMAADDRESS5_BUFF_ADD_Msk = 0xffffffff

	// HSTDMACONTROL5: Host DMA Channel Control Register (n = 5)
	// Position of CHANN_ENB field.
	UOTGHS_HSTDMACONTROL5_CHANN_ENB_Pos = 0x0
	// Bit mask of CHANN_ENB field.
	UOTGHS_HSTDMACONTROL5_CHANN_ENB_Msk = 0x1
	// Bit CHANN_ENB.
	UOTGHS_HSTDMACONTROL5_CHANN_ENB = 0x1
	// Position of LDNXT_DSC field.
	UOTGHS_HSTDMACONTROL5_LDNXT_DSC_Pos = 0x1
	// Bit mask of LDNXT_DSC field.
	UOTGHS_HSTDMACONTROL5_LDNXT_DSC_Msk = 0x2
	// Bit LDNXT_DSC.
	UOTGHS_HSTDMACONTROL5_LDNXT_DSC = 0x2
	// Position of END_TR_EN field.
	UOTGHS_HSTDMACONTROL5_END_TR_EN_Pos = 0x2
	// Bit mask of END_TR_EN field.
	UOTGHS_HSTDMACONTROL5_END_TR_EN_Msk = 0x4
	// Bit END_TR_EN.
	UOTGHS_HSTDMACONTROL5_END_TR_EN = 0x4
	// Position of END_B_EN field.
	UOTGHS_HSTDMACONTROL5_END_B_EN_Pos = 0x3
	// Bit mask of END_B_EN field.
	UOTGHS_HSTDMACONTROL5_END_B_EN_Msk = 0x8
	// Bit END_B_EN.
	UOTGHS_HSTDMACONTROL5_END_B_EN = 0x8
	// Position of END_TR_IT field.
	UOTGHS_HSTDMACONTROL5_END_TR_IT_Pos = 0x4
	// Bit mask of END_TR_IT field.
	UOTGHS_HSTDMACONTROL5_END_TR_IT_Msk = 0x10
	// Bit END_TR_IT.
	UOTGHS_HSTDMACONTROL5_END_TR_IT = 0x10
	// Position of END_BUFFIT field.
	UOTGHS_HSTDMACONTROL5_END_BUFFIT_Pos = 0x5
	// Bit mask of END_BUFFIT field.
	UOTGHS_HSTDMACONTROL5_END_BUFFIT_Msk = 0x20
	// Bit END_BUFFIT.
	UOTGHS_HSTDMACONTROL5_END_BUFFIT = 0x20
	// Position of DESC_LD_IT field.
	UOTGHS_HSTDMACONTROL5_DESC_LD_IT_Pos = 0x6
	// Bit mask of DESC_LD_IT field.
	UOTGHS_HSTDMACONTROL5_DESC_LD_IT_Msk = 0x40
	// Bit DESC_LD_IT.
	UOTGHS_HSTDMACONTROL5_DESC_LD_IT = 0x40
	// Position of BURST_LCK field.
	UOTGHS_HSTDMACONTROL5_BURST_LCK_Pos = 0x7
	// Bit mask of BURST_LCK field.
	UOTGHS_HSTDMACONTROL5_BURST_LCK_Msk = 0x80
	// Bit BURST_LCK.
	UOTGHS_HSTDMACONTROL5_BURST_LCK = 0x80
	// Position of BUFF_LENGTH field.
	UOTGHS_HSTDMACONTROL5_BUFF_LENGTH_Pos = 0x10
	// Bit mask of BUFF_LENGTH field.
	UOTGHS_HSTDMACONTROL5_BUFF_LENGTH_Msk = 0xffff0000

	// HSTDMASTATUS5: Host DMA Channel Status Register (n = 5)
	// Position of CHANN_ENB field.
	UOTGHS_HSTDMASTATUS5_CHANN_ENB_Pos = 0x0
	// Bit mask of CHANN_ENB field.
	UOTGHS_HSTDMASTATUS5_CHANN_ENB_Msk = 0x1
	// Bit CHANN_ENB.
	UOTGHS_HSTDMASTATUS5_CHANN_ENB = 0x1
	// Position of CHANN_ACT field.
	UOTGHS_HSTDMASTATUS5_CHANN_ACT_Pos = 0x1
	// Bit mask of CHANN_ACT field.
	UOTGHS_HSTDMASTATUS5_CHANN_ACT_Msk = 0x2
	// Bit CHANN_ACT.
	UOTGHS_HSTDMASTATUS5_CHANN_ACT = 0x2
	// Position of END_TR_ST field.
	UOTGHS_HSTDMASTATUS5_END_TR_ST_Pos = 0x4
	// Bit mask of END_TR_ST field.
	UOTGHS_HSTDMASTATUS5_END_TR_ST_Msk = 0x10
	// Bit END_TR_ST.
	UOTGHS_HSTDMASTATUS5_END_TR_ST = 0x10
	// Position of END_BF_ST field.
	UOTGHS_HSTDMASTATUS5_END_BF_ST_Pos = 0x5
	// Bit mask of END_BF_ST field.
	UOTGHS_HSTDMASTATUS5_END_BF_ST_Msk = 0x20
	// Bit END_BF_ST.
	UOTGHS_HSTDMASTATUS5_END_BF_ST = 0x20
	// Position of DESC_LDST field.
	UOTGHS_HSTDMASTATUS5_DESC_LDST_Pos = 0x6
	// Bit mask of DESC_LDST field.
	UOTGHS_HSTDMASTATUS5_DESC_LDST_Msk = 0x40
	// Bit DESC_LDST.
	UOTGHS_HSTDMASTATUS5_DESC_LDST = 0x40
	// Position of BUFF_COUNT field.
	UOTGHS_HSTDMASTATUS5_BUFF_COUNT_Pos = 0x10
	// Bit mask of BUFF_COUNT field.
	UOTGHS_HSTDMASTATUS5_BUFF_COUNT_Msk = 0xffff0000

	// HSTDMANXTDSC6: Host DMA Channel Next Descriptor Address Register (n = 6)
	// Position of NXT_DSC_ADD field.
	UOTGHS_HSTDMANXTDSC6_NXT_DSC_ADD_Pos = 0x0
	// Bit mask of NXT_DSC_ADD field.
	UOTGHS_HSTDMANXTDSC6_NXT_DSC_ADD_Msk = 0xffffffff

	// HSTDMAADDRESS6: Host DMA Channel Address Register (n = 6)
	// Position of BUFF_ADD field.
	UOTGHS_HSTDMAADDRESS6_BUFF_ADD_Pos = 0x0
	// Bit mask of BUFF_ADD field.
	UOTGHS_HSTDMAADDRESS6_BUFF_ADD_Msk = 0xffffffff

	// HSTDMACONTROL6: Host DMA Channel Control Register (n = 6)
	// Position of CHANN_ENB field.
	UOTGHS_HSTDMACONTROL6_CHANN_ENB_Pos = 0x0
	// Bit mask of CHANN_ENB field.
	UOTGHS_HSTDMACONTROL6_CHANN_ENB_Msk = 0x1
	// Bit CHANN_ENB.
	UOTGHS_HSTDMACONTROL6_CHANN_ENB = 0x1
	// Position of LDNXT_DSC field.
	UOTGHS_HSTDMACONTROL6_LDNXT_DSC_Pos = 0x1
	// Bit mask of LDNXT_DSC field.
	UOTGHS_HSTDMACONTROL6_LDNXT_DSC_Msk = 0x2
	// Bit LDNXT_DSC.
	UOTGHS_HSTDMACONTROL6_LDNXT_DSC = 0x2
	// Position of END_TR_EN field.
	UOTGHS_HSTDMACONTROL6_END_TR_EN_Pos = 0x2
	// Bit mask of END_TR_EN field.
	UOTGHS_HSTDMACONTROL6_END_TR_EN_Msk = 0x4
	// Bit END_TR_EN.
	UOTGHS_HSTDMACONTROL6_END_TR_EN = 0x4
	// Position of END_B_EN field.
	UOTGHS_HSTDMACONTROL6_END_B_EN_Pos = 0x3
	// Bit mask of END_B_EN field.
	UOTGHS_HSTDMACONTROL6_END_B_EN_Msk = 0x8
	// Bit END_B_EN.
	UOTGHS_HSTDMACONTROL6_END_B_EN = 0x8
	// Position of END_TR_IT field.
	UOTGHS_HSTDMACONTROL6_END_TR_IT_Pos = 0x4
	// Bit mask of END_TR_IT field.
	UOTGHS_HSTDMACONTROL6_END_TR_IT_Msk = 0x10
	// Bit END_TR_IT.
	UOTGHS_HSTDMACONTROL6_END_TR_IT = 0x10
	// Position of END_BUFFIT field.
	UOTGHS_HSTDMACONTROL6_END_BUFFIT_Pos = 0x5
	// Bit mask of END_BUFFIT field.
	UOTGHS_HSTDMACONTROL6_END_BUFFIT_Msk = 0x20
	// Bit END_BUFFIT.
	UOTGHS_HSTDMACONTROL6_END_BUFFIT = 0x20
	// Position of DESC_LD_IT field.
	UOTGHS_HSTDMACONTROL6_DESC_LD_IT_Pos = 0x6
	// Bit mask of DESC_LD_IT field.
	UOTGHS_HSTDMACONTROL6_DESC_LD_IT_Msk = 0x40
	// Bit DESC_LD_IT.
	UOTGHS_HSTDMACONTROL6_DESC_LD_IT = 0x40
	// Position of BURST_LCK field.
	UOTGHS_HSTDMACONTROL6_BURST_LCK_Pos = 0x7
	// Bit mask of BURST_LCK field.
	UOTGHS_HSTDMACONTROL6_BURST_LCK_Msk = 0x80
	// Bit BURST_LCK.
	UOTGHS_HSTDMACONTROL6_BURST_LCK = 0x80
	// Position of BUFF_LENGTH field.
	UOTGHS_HSTDMACONTROL6_BUFF_LENGTH_Pos = 0x10
	// Bit mask of BUFF_LENGTH field.
	UOTGHS_HSTDMACONTROL6_BUFF_LENGTH_Msk = 0xffff0000

	// HSTDMASTATUS6: Host DMA Channel Status Register (n = 6)
	// Position of CHANN_ENB field.
	UOTGHS_HSTDMASTATUS6_CHANN_ENB_Pos = 0x0
	// Bit mask of CHANN_ENB field.
	UOTGHS_HSTDMASTATUS6_CHANN_ENB_Msk = 0x1
	// Bit CHANN_ENB.
	UOTGHS_HSTDMASTATUS6_CHANN_ENB = 0x1
	// Position of CHANN_ACT field.
	UOTGHS_HSTDMASTATUS6_CHANN_ACT_Pos = 0x1
	// Bit mask of CHANN_ACT field.
	UOTGHS_HSTDMASTATUS6_CHANN_ACT_Msk = 0x2
	// Bit CHANN_ACT.
	UOTGHS_HSTDMASTATUS6_CHANN_ACT = 0x2
	// Position of END_TR_ST field.
	UOTGHS_HSTDMASTATUS6_END_TR_ST_Pos = 0x4
	// Bit mask of END_TR_ST field.
	UOTGHS_HSTDMASTATUS6_END_TR_ST_Msk = 0x10
	// Bit END_TR_ST.
	UOTGHS_HSTDMASTATUS6_END_TR_ST = 0x10
	// Position of END_BF_ST field.
	UOTGHS_HSTDMASTATUS6_END_BF_ST_Pos = 0x5
	// Bit mask of END_BF_ST field.
	UOTGHS_HSTDMASTATUS6_END_BF_ST_Msk = 0x20
	// Bit END_BF_ST.
	UOTGHS_HSTDMASTATUS6_END_BF_ST = 0x20
	// Position of DESC_LDST field.
	UOTGHS_HSTDMASTATUS6_DESC_LDST_Pos = 0x6
	// Bit mask of DESC_LDST field.
	UOTGHS_HSTDMASTATUS6_DESC_LDST_Msk = 0x40
	// Bit DESC_LDST.
	UOTGHS_HSTDMASTATUS6_DESC_LDST = 0x40
	// Position of BUFF_COUNT field.
	UOTGHS_HSTDMASTATUS6_BUFF_COUNT_Pos = 0x10
	// Bit mask of BUFF_COUNT field.
	UOTGHS_HSTDMASTATUS6_BUFF_COUNT_Msk = 0xffff0000

	// HSTDMANXTDSC7: Host DMA Channel Next Descriptor Address Register (n = 7)
	// Position of NXT_DSC_ADD field.
	UOTGHS_HSTDMANXTDSC7_NXT_DSC_ADD_Pos = 0x0
	// Bit mask of NXT_DSC_ADD field.
	UOTGHS_HSTDMANXTDSC7_NXT_DSC_ADD_Msk = 0xffffffff

	// HSTDMAADDRESS7: Host DMA Channel Address Register (n = 7)
	// Position of BUFF_ADD field.
	UOTGHS_HSTDMAADDRESS7_BUFF_ADD_Pos = 0x0
	// Bit mask of BUFF_ADD field.
	UOTGHS_HSTDMAADDRESS7_BUFF_ADD_Msk = 0xffffffff

	// HSTDMACONTROL7: Host DMA Channel Control Register (n = 7)
	// Position of CHANN_ENB field.
	UOTGHS_HSTDMACONTROL7_CHANN_ENB_Pos = 0x0
	// Bit mask of CHANN_ENB field.
	UOTGHS_HSTDMACONTROL7_CHANN_ENB_Msk = 0x1
	// Bit CHANN_ENB.
	UOTGHS_HSTDMACONTROL7_CHANN_ENB = 0x1
	// Position of LDNXT_DSC field.
	UOTGHS_HSTDMACONTROL7_LDNXT_DSC_Pos = 0x1
	// Bit mask of LDNXT_DSC field.
	UOTGHS_HSTDMACONTROL7_LDNXT_DSC_Msk = 0x2
	// Bit LDNXT_DSC.
	UOTGHS_HSTDMACONTROL7_LDNXT_DSC = 0x2
	// Position of END_TR_EN field.
	UOTGHS_HSTDMACONTROL7_END_TR_EN_Pos = 0x2
	// Bit mask of END_TR_EN field.
	UOTGHS_HSTDMACONTROL7_END_TR_EN_Msk = 0x4
	// Bit END_TR_EN.
	UOTGHS_HSTDMACONTROL7_END_TR_EN = 0x4
	// Position of END_B_EN field.
	UOTGHS_HSTDMACONTROL7_END_B_EN_Pos = 0x3
	// Bit mask of END_B_EN field.
	UOTGHS_HSTDMACONTROL7_END_B_EN_Msk = 0x8
	// Bit END_B_EN.
	UOTGHS_HSTDMACONTROL7_END_B_EN = 0x8
	// Position of END_TR_IT field.
	UOTGHS_HSTDMACONTROL7_END_TR_IT_Pos = 0x4
	// Bit mask of END_TR_IT field.
	UOTGHS_HSTDMACONTROL7_END_TR_IT_Msk = 0x10
	// Bit END_TR_IT.
	UOTGHS_HSTDMACONTROL7_END_TR_IT = 0x10
	// Position of END_BUFFIT field.
	UOTGHS_HSTDMACONTROL7_END_BUFFIT_Pos = 0x5
	// Bit mask of END_BUFFIT field.
	UOTGHS_HSTDMACONTROL7_END_BUFFIT_Msk = 0x20
	// Bit END_BUFFIT.
	UOTGHS_HSTDMACONTROL7_END_BUFFIT = 0x20
	// Position of DESC_LD_IT field.
	UOTGHS_HSTDMACONTROL7_DESC_LD_IT_Pos = 0x6
	// Bit mask of DESC_LD_IT field.
	UOTGHS_HSTDMACONTROL7_DESC_LD_IT_Msk = 0x40
	// Bit DESC_LD_IT.
	UOTGHS_HSTDMACONTROL7_DESC_LD_IT = 0x40
	// Position of BURST_LCK field.
	UOTGHS_HSTDMACONTROL7_BURST_LCK_Pos = 0x7
	// Bit mask of BURST_LCK field.
	UOTGHS_HSTDMACONTROL7_BURST_LCK_Msk = 0x80
	// Bit BURST_LCK.
	UOTGHS_HSTDMACONTROL7_BURST_LCK = 0x80
	// Position of BUFF_LENGTH field.
	UOTGHS_HSTDMACONTROL7_BUFF_LENGTH_Pos = 0x10
	// Bit mask of BUFF_LENGTH field.
	UOTGHS_HSTDMACONTROL7_BUFF_LENGTH_Msk = 0xffff0000

	// HSTDMASTATUS7: Host DMA Channel Status Register (n = 7)
	// Position of CHANN_ENB field.
	UOTGHS_HSTDMASTATUS7_CHANN_ENB_Pos = 0x0
	// Bit mask of CHANN_ENB field.
	UOTGHS_HSTDMASTATUS7_CHANN_ENB_Msk = 0x1
	// Bit CHANN_ENB.
	UOTGHS_HSTDMASTATUS7_CHANN_ENB = 0x1
	// Position of CHANN_ACT field.
	UOTGHS_HSTDMASTATUS7_CHANN_ACT_Pos = 0x1
	// Bit mask of CHANN_ACT field.
	UOTGHS_HSTDMASTATUS7_CHANN_ACT_Msk = 0x2
	// Bit CHANN_ACT.
	UOTGHS_HSTDMASTATUS7_CHANN_ACT = 0x2
	// Position of END_TR_ST field.
	UOTGHS_HSTDMASTATUS7_END_TR_ST_Pos = 0x4
	// Bit mask of END_TR_ST field.
	UOTGHS_HSTDMASTATUS7_END_TR_ST_Msk = 0x10
	// Bit END_TR_ST.
	UOTGHS_HSTDMASTATUS7_END_TR_ST = 0x10
	// Position of END_BF_ST field.
	UOTGHS_HSTDMASTATUS7_END_BF_ST_Pos = 0x5
	// Bit mask of END_BF_ST field.
	UOTGHS_HSTDMASTATUS7_END_BF_ST_Msk = 0x20
	// Bit END_BF_ST.
	UOTGHS_HSTDMASTATUS7_END_BF_ST = 0x20
	// Position of DESC_LDST field.
	UOTGHS_HSTDMASTATUS7_DESC_LDST_Pos = 0x6
	// Bit mask of DESC_LDST field.
	UOTGHS_HSTDMASTATUS7_DESC_LDST_Msk = 0x40
	// Bit DESC_LDST.
	UOTGHS_HSTDMASTATUS7_DESC_LDST = 0x40
	// Position of BUFF_COUNT field.
	UOTGHS_HSTDMASTATUS7_BUFF_COUNT_Pos = 0x10
	// Bit mask of BUFF_COUNT field.
	UOTGHS_HSTDMASTATUS7_BUFF_COUNT_Msk = 0xffff0000

	// CTRL: General Control Register
	// Position of IDTE field.
	UOTGHS_CTRL_IDTE_Pos = 0x0
	// Bit mask of IDTE field.
	UOTGHS_CTRL_IDTE_Msk = 0x1
	// Bit IDTE.
	UOTGHS_CTRL_IDTE = 0x1
	// Position of VBUSTE field.
	UOTGHS_CTRL_VBUSTE_Pos = 0x1
	// Bit mask of VBUSTE field.
	UOTGHS_CTRL_VBUSTE_Msk = 0x2
	// Bit VBUSTE.
	UOTGHS_CTRL_VBUSTE = 0x2
	// Position of SRPE field.
	UOTGHS_CTRL_SRPE_Pos = 0x2
	// Bit mask of SRPE field.
	UOTGHS_CTRL_SRPE_Msk = 0x4
	// Bit SRPE.
	UOTGHS_CTRL_SRPE = 0x4
	// Position of VBERRE field.
	UOTGHS_CTRL_VBERRE_Pos = 0x3
	// Bit mask of VBERRE field.
	UOTGHS_CTRL_VBERRE_Msk = 0x8
	// Bit VBERRE.
	UOTGHS_CTRL_VBERRE = 0x8
	// Position of BCERRE field.
	UOTGHS_CTRL_BCERRE_Pos = 0x4
	// Bit mask of BCERRE field.
	UOTGHS_CTRL_BCERRE_Msk = 0x10
	// Bit BCERRE.
	UOTGHS_CTRL_BCERRE = 0x10
	// Position of ROLEEXE field.
	UOTGHS_CTRL_ROLEEXE_Pos = 0x5
	// Bit mask of ROLEEXE field.
	UOTGHS_CTRL_ROLEEXE_Msk = 0x20
	// Bit ROLEEXE.
	UOTGHS_CTRL_ROLEEXE = 0x20
	// Position of HNPERRE field.
	UOTGHS_CTRL_HNPERRE_Pos = 0x6
	// Bit mask of HNPERRE field.
	UOTGHS_CTRL_HNPERRE_Msk = 0x40
	// Bit HNPERRE.
	UOTGHS_CTRL_HNPERRE = 0x40
	// Position of STOE field.
	UOTGHS_CTRL_STOE_Pos = 0x7
	// Bit mask of STOE field.
	UOTGHS_CTRL_STOE_Msk = 0x80
	// Bit STOE.
	UOTGHS_CTRL_STOE = 0x80
	// Position of VBUSHWC field.
	UOTGHS_CTRL_VBUSHWC_Pos = 0x8
	// Bit mask of VBUSHWC field.
	UOTGHS_CTRL_VBUSHWC_Msk = 0x100
	// Bit VBUSHWC.
	UOTGHS_CTRL_VBUSHWC = 0x100
	// Position of SRPSEL field.
	UOTGHS_CTRL_SRPSEL_Pos = 0x9
	// Bit mask of SRPSEL field.
	UOTGHS_CTRL_SRPSEL_Msk = 0x200
	// Bit SRPSEL.
	UOTGHS_CTRL_SRPSEL = 0x200
	// Position of SRPREQ field.
	UOTGHS_CTRL_SRPREQ_Pos = 0xa
	// Bit mask of SRPREQ field.
	UOTGHS_CTRL_SRPREQ_Msk = 0x400
	// Bit SRPREQ.
	UOTGHS_CTRL_SRPREQ = 0x400
	// Position of HNPREQ field.
	UOTGHS_CTRL_HNPREQ_Pos = 0xb
	// Bit mask of HNPREQ field.
	UOTGHS_CTRL_HNPREQ_Msk = 0x800
	// Bit HNPREQ.
	UOTGHS_CTRL_HNPREQ = 0x800
	// Position of OTGPADE field.
	UOTGHS_CTRL_OTGPADE_Pos = 0xc
	// Bit mask of OTGPADE field.
	UOTGHS_CTRL_OTGPADE_Msk = 0x1000
	// Bit OTGPADE.
	UOTGHS_CTRL_OTGPADE = 0x1000
	// Position of VBUSPO field.
	UOTGHS_CTRL_VBUSPO_Pos = 0xd
	// Bit mask of VBUSPO field.
	UOTGHS_CTRL_VBUSPO_Msk = 0x2000
	// Bit VBUSPO.
	UOTGHS_CTRL_VBUSPO = 0x2000
	// Position of FRZCLK field.
	UOTGHS_CTRL_FRZCLK_Pos = 0xe
	// Bit mask of FRZCLK field.
	UOTGHS_CTRL_FRZCLK_Msk = 0x4000
	// Bit FRZCLK.
	UOTGHS_CTRL_FRZCLK = 0x4000
	// Position of USBE field.
	UOTGHS_CTRL_USBE_Pos = 0xf
	// Bit mask of USBE field.
	UOTGHS_CTRL_USBE_Msk = 0x8000
	// Bit USBE.
	UOTGHS_CTRL_USBE = 0x8000
	// Position of TIMVALUE field.
	UOTGHS_CTRL_TIMVALUE_Pos = 0x10
	// Bit mask of TIMVALUE field.
	UOTGHS_CTRL_TIMVALUE_Msk = 0x30000
	// Position of TIMPAGE field.
	UOTGHS_CTRL_TIMPAGE_Pos = 0x14
	// Bit mask of TIMPAGE field.
	UOTGHS_CTRL_TIMPAGE_Msk = 0x300000
	// Position of UNLOCK field.
	UOTGHS_CTRL_UNLOCK_Pos = 0x16
	// Bit mask of UNLOCK field.
	UOTGHS_CTRL_UNLOCK_Msk = 0x400000
	// Bit UNLOCK.
	UOTGHS_CTRL_UNLOCK = 0x400000
	// Position of UIDE field.
	UOTGHS_CTRL_UIDE_Pos = 0x18
	// Bit mask of UIDE field.
	UOTGHS_CTRL_UIDE_Msk = 0x1000000
	// Bit UIDE.
	UOTGHS_CTRL_UIDE = 0x1000000
	// The USB mode (device/host) is selected from the UIMOD bit.
	UOTGHS_CTRL_UIDE_UIMOD = 0x0
	// The USB mode (device/host) is selected from the UOTGID input pin.
	UOTGHS_CTRL_UIDE_UOTGID = 0x1
	// Position of UIMOD field.
	UOTGHS_CTRL_UIMOD_Pos = 0x19
	// Bit mask of UIMOD field.
	UOTGHS_CTRL_UIMOD_Msk = 0x2000000
	// Bit UIMOD.
	UOTGHS_CTRL_UIMOD = 0x2000000
	// The module is in USB host mode.
	UOTGHS_CTRL_UIMOD_HOST = 0x0
	// The module is in USB device mode.
	UOTGHS_CTRL_UIMOD_DEVICE = 0x1

	// SR: General Status Register
	// Position of IDTI field.
	UOTGHS_SR_IDTI_Pos = 0x0
	// Bit mask of IDTI field.
	UOTGHS_SR_IDTI_Msk = 0x1
	// Bit IDTI.
	UOTGHS_SR_IDTI = 0x1
	// Position of VBUSTI field.
	UOTGHS_SR_VBUSTI_Pos = 0x1
	// Bit mask of VBUSTI field.
	UOTGHS_SR_VBUSTI_Msk = 0x2
	// Bit VBUSTI.
	UOTGHS_SR_VBUSTI = 0x2
	// Position of SRPI field.
	UOTGHS_SR_SRPI_Pos = 0x2
	// Bit mask of SRPI field.
	UOTGHS_SR_SRPI_Msk = 0x4
	// Bit SRPI.
	UOTGHS_SR_SRPI = 0x4
	// Position of VBERRI field.
	UOTGHS_SR_VBERRI_Pos = 0x3
	// Bit mask of VBERRI field.
	UOTGHS_SR_VBERRI_Msk = 0x8
	// Bit VBERRI.
	UOTGHS_SR_VBERRI = 0x8
	// Position of BCERRI field.
	UOTGHS_SR_BCERRI_Pos = 0x4
	// Bit mask of BCERRI field.
	UOTGHS_SR_BCERRI_Msk = 0x10
	// Bit BCERRI.
	UOTGHS_SR_BCERRI = 0x10
	// Position of ROLEEXI field.
	UOTGHS_SR_ROLEEXI_Pos = 0x5
	// Bit mask of ROLEEXI field.
	UOTGHS_SR_ROLEEXI_Msk = 0x20
	// Bit ROLEEXI.
	UOTGHS_SR_ROLEEXI = 0x20
	// Position of HNPERRI field.
	UOTGHS_SR_HNPERRI_Pos = 0x6
	// Bit mask of HNPERRI field.
	UOTGHS_SR_HNPERRI_Msk = 0x40
	// Bit HNPERRI.
	UOTGHS_SR_HNPERRI = 0x40
	// Position of STOI field.
	UOTGHS_SR_STOI_Pos = 0x7
	// Bit mask of STOI field.
	UOTGHS_SR_STOI_Msk = 0x80
	// Bit STOI.
	UOTGHS_SR_STOI = 0x80
	// Position of VBUSRQ field.
	UOTGHS_SR_VBUSRQ_Pos = 0x9
	// Bit mask of VBUSRQ field.
	UOTGHS_SR_VBUSRQ_Msk = 0x200
	// Bit VBUSRQ.
	UOTGHS_SR_VBUSRQ = 0x200
	// Position of ID field.
	UOTGHS_SR_ID_Pos = 0xa
	// Bit mask of ID field.
	UOTGHS_SR_ID_Msk = 0x400
	// Bit ID.
	UOTGHS_SR_ID = 0x400
	// Position of VBUS field.
	UOTGHS_SR_VBUS_Pos = 0xb
	// Bit mask of VBUS field.
	UOTGHS_SR_VBUS_Msk = 0x800
	// Bit VBUS.
	UOTGHS_SR_VBUS = 0x800
	// Position of SPEED field.
	UOTGHS_SR_SPEED_Pos = 0xc
	// Bit mask of SPEED field.
	UOTGHS_SR_SPEED_Msk = 0x3000
	// Full-Speed mode
	UOTGHS_SR_SPEED_FULL_SPEED = 0x0
	// High-Speed mode
	UOTGHS_SR_SPEED_HIGH_SPEED = 0x1
	// Low-Speed mode
	UOTGHS_SR_SPEED_LOW_SPEED = 0x2
	// Position of CLKUSABLE field.
	UOTGHS_SR_CLKUSABLE_Pos = 0xe
	// Bit mask of CLKUSABLE field.
	UOTGHS_SR_CLKUSABLE_Msk = 0x4000
	// Bit CLKUSABLE.
	UOTGHS_SR_CLKUSABLE = 0x4000

	// SCR: General Status Clear Register
	// Position of IDTIC field.
	UOTGHS_SCR_IDTIC_Pos = 0x0
	// Bit mask of IDTIC field.
	UOTGHS_SCR_IDTIC_Msk = 0x1
	// Bit IDTIC.
	UOTGHS_SCR_IDTIC = 0x1
	// Position of VBUSTIC field.
	UOTGHS_SCR_VBUSTIC_Pos = 0x1
	// Bit mask of VBUSTIC field.
	UOTGHS_SCR_VBUSTIC_Msk = 0x2
	// Bit VBUSTIC.
	UOTGHS_SCR_VBUSTIC = 0x2
	// Position of SRPIC field.
	UOTGHS_SCR_SRPIC_Pos = 0x2
	// Bit mask of SRPIC field.
	UOTGHS_SCR_SRPIC_Msk = 0x4
	// Bit SRPIC.
	UOTGHS_SCR_SRPIC = 0x4
	// Position of VBERRIC field.
	UOTGHS_SCR_VBERRIC_Pos = 0x3
	// Bit mask of VBERRIC field.
	UOTGHS_SCR_VBERRIC_Msk = 0x8
	// Bit VBERRIC.
	UOTGHS_SCR_VBERRIC = 0x8
	// Position of BCERRIC field.
	UOTGHS_SCR_BCERRIC_Pos = 0x4
	// Bit mask of BCERRIC field.
	UOTGHS_SCR_BCERRIC_Msk = 0x10
	// Bit BCERRIC.
	UOTGHS_SCR_BCERRIC = 0x10
	// Position of ROLEEXIC field.
	UOTGHS_SCR_ROLEEXIC_Pos = 0x5
	// Bit mask of ROLEEXIC field.
	UOTGHS_SCR_ROLEEXIC_Msk = 0x20
	// Bit ROLEEXIC.
	UOTGHS_SCR_ROLEEXIC = 0x20
	// Position of HNPERRIC field.
	UOTGHS_SCR_HNPERRIC_Pos = 0x6
	// Bit mask of HNPERRIC field.
	UOTGHS_SCR_HNPERRIC_Msk = 0x40
	// Bit HNPERRIC.
	UOTGHS_SCR_HNPERRIC = 0x40
	// Position of STOIC field.
	UOTGHS_SCR_STOIC_Pos = 0x7
	// Bit mask of STOIC field.
	UOTGHS_SCR_STOIC_Msk = 0x80
	// Bit STOIC.
	UOTGHS_SCR_STOIC = 0x80
	// Position of VBUSRQC field.
	UOTGHS_SCR_VBUSRQC_Pos = 0x9
	// Bit mask of VBUSRQC field.
	UOTGHS_SCR_VBUSRQC_Msk = 0x200
	// Bit VBUSRQC.
	UOTGHS_SCR_VBUSRQC = 0x200

	// SFR: General Status Set Register
	// Position of IDTIS field.
	UOTGHS_SFR_IDTIS_Pos = 0x0
	// Bit mask of IDTIS field.
	UOTGHS_SFR_IDTIS_Msk = 0x1
	// Bit IDTIS.
	UOTGHS_SFR_IDTIS = 0x1
	// Position of VBUSTIS field.
	UOTGHS_SFR_VBUSTIS_Pos = 0x1
	// Bit mask of VBUSTIS field.
	UOTGHS_SFR_VBUSTIS_Msk = 0x2
	// Bit VBUSTIS.
	UOTGHS_SFR_VBUSTIS = 0x2
	// Position of SRPIS field.
	UOTGHS_SFR_SRPIS_Pos = 0x2
	// Bit mask of SRPIS field.
	UOTGHS_SFR_SRPIS_Msk = 0x4
	// Bit SRPIS.
	UOTGHS_SFR_SRPIS = 0x4
	// Position of VBERRIS field.
	UOTGHS_SFR_VBERRIS_Pos = 0x3
	// Bit mask of VBERRIS field.
	UOTGHS_SFR_VBERRIS_Msk = 0x8
	// Bit VBERRIS.
	UOTGHS_SFR_VBERRIS = 0x8
	// Position of BCERRIS field.
	UOTGHS_SFR_BCERRIS_Pos = 0x4
	// Bit mask of BCERRIS field.
	UOTGHS_SFR_BCERRIS_Msk = 0x10
	// Bit BCERRIS.
	UOTGHS_SFR_BCERRIS = 0x10
	// Position of ROLEEXIS field.
	UOTGHS_SFR_ROLEEXIS_Pos = 0x5
	// Bit mask of ROLEEXIS field.
	UOTGHS_SFR_ROLEEXIS_Msk = 0x20
	// Bit ROLEEXIS.
	UOTGHS_SFR_ROLEEXIS = 0x20
	// Position of HNPERRIS field.
	UOTGHS_SFR_HNPERRIS_Pos = 0x6
	// Bit mask of HNPERRIS field.
	UOTGHS_SFR_HNPERRIS_Msk = 0x40
	// Bit HNPERRIS.
	UOTGHS_SFR_HNPERRIS = 0x40
	// Position of STOIS field.
	UOTGHS_SFR_STOIS_Pos = 0x7
	// Bit mask of STOIS field.
	UOTGHS_SFR_STOIS_Msk = 0x80
	// Bit STOIS.
	UOTGHS_SFR_STOIS = 0x80
	// Position of VBUSRQS field.
	UOTGHS_SFR_VBUSRQS_Pos = 0x9
	// Bit mask of VBUSRQS field.
	UOTGHS_SFR_VBUSRQS_Msk = 0x200
	// Bit VBUSRQS.
	UOTGHS_SFR_VBUSRQS = 0x200

	// FSM: General Finite State Machine Register
	// Position of DRDSTATE field.
	UOTGHS_FSM_DRDSTATE_Pos = 0x0
	// Bit mask of DRDSTATE field.
	UOTGHS_FSM_DRDSTATE_Msk = 0xf
	// This is the start state for A-devices (when the ID pin is 0)
	UOTGHS_FSM_DRDSTATE_A_IDLESTATE = 0x0
	// In this state, the A-device waits for the voltage on VBus to rise above the A-device VBus Valid threshold (4.4 V).
	UOTGHS_FSM_DRDSTATE_A_WAIT_VRISE = 0x1
	// In this state, the A-device waits for the B-device to signal a connection.
	UOTGHS_FSM_DRDSTATE_A_WAIT_BCON = 0x2
	// In this state, the A-device that operates in Host mode is operational.
	UOTGHS_FSM_DRDSTATE_A_HOST = 0x3
	// The A-device operating as a host is in the suspend mode.
	UOTGHS_FSM_DRDSTATE_A_SUSPEND = 0x4
	// The A-device operates as a peripheral.
	UOTGHS_FSM_DRDSTATE_A_PERIPHERAL = 0x5
	// In this state, the A-device waits for the voltage on VBus to drop below the A-device Session Valid threshold (1.4 V).
	UOTGHS_FSM_DRDSTATE_A_WAIT_VFALL = 0x6
	// In this state, the A-device waits for recovery of the over-current condition that caused it to enter this state.
	UOTGHS_FSM_DRDSTATE_A_VBUS_ERR = 0x7
	// In this state, the A-device waits for the data USB line to discharge (100 us).
	UOTGHS_FSM_DRDSTATE_A_WAIT_DISCHARGE = 0x8
	// This is the start state for B-device (when the ID pin is 1).
	UOTGHS_FSM_DRDSTATE_B_IDLE = 0x9
	// In this state, the B-device acts as the peripheral.
	UOTGHS_FSM_DRDSTATE_B_PERIPHERAL = 0xa
	// In this state, the B-device is in suspend mode and waits until 3 ms before initiating the HNP protocol if requested.
	UOTGHS_FSM_DRDSTATE_B_WAIT_BEGIN_HNP = 0xb
	// In this state, the B-device waits for the data USB line to discharge (100 us) before becoming Host.
	UOTGHS_FSM_DRDSTATE_B_WAIT_DISCHARGE = 0xc
	// In this state, the B-device waits for the A-device to signal a connect before becoming B-Host.
	UOTGHS_FSM_DRDSTATE_B_WAIT_ACON = 0xd
	// In this state, the B-device acts as the Host.
	UOTGHS_FSM_DRDSTATE_B_HOST = 0xe
	// In this state, the B-device attempts to start a session using the SRP protocol.
	UOTGHS_FSM_DRDSTATE_B_SRP_INIT = 0xf
)

// Bitfields for CAN0: Controller Area Network 0
const (
	// MR: Mode Register
	// Position of CANEN field.
	CAN_MR_CANEN_Pos = 0x0
	// Bit mask of CANEN field.
	CAN_MR_CANEN_Msk = 0x1
	// Bit CANEN.
	CAN_MR_CANEN = 0x1
	// Position of LPM field.
	CAN_MR_LPM_Pos = 0x1
	// Bit mask of LPM field.
	CAN_MR_LPM_Msk = 0x2
	// Bit LPM.
	CAN_MR_LPM = 0x2
	// Position of ABM field.
	CAN_MR_ABM_Pos = 0x2
	// Bit mask of ABM field.
	CAN_MR_ABM_Msk = 0x4
	// Bit ABM.
	CAN_MR_ABM = 0x4
	// Position of OVL field.
	CAN_MR_OVL_Pos = 0x3
	// Bit mask of OVL field.
	CAN_MR_OVL_Msk = 0x8
	// Bit OVL.
	CAN_MR_OVL = 0x8
	// Position of TEOF field.
	CAN_MR_TEOF_Pos = 0x4
	// Bit mask of TEOF field.
	CAN_MR_TEOF_Msk = 0x10
	// Bit TEOF.
	CAN_MR_TEOF = 0x10
	// Position of TTM field.
	CAN_MR_TTM_Pos = 0x5
	// Bit mask of TTM field.
	CAN_MR_TTM_Msk = 0x20
	// Bit TTM.
	CAN_MR_TTM = 0x20
	// Position of TIMFRZ field.
	CAN_MR_TIMFRZ_Pos = 0x6
	// Bit mask of TIMFRZ field.
	CAN_MR_TIMFRZ_Msk = 0x40
	// Bit TIMFRZ.
	CAN_MR_TIMFRZ = 0x40
	// Position of DRPT field.
	CAN_MR_DRPT_Pos = 0x7
	// Bit mask of DRPT field.
	CAN_MR_DRPT_Msk = 0x80
	// Bit DRPT.
	CAN_MR_DRPT = 0x80
	// Position of RXSYNC field.
	CAN_MR_RXSYNC_Pos = 0x18
	// Bit mask of RXSYNC field.
	CAN_MR_RXSYNC_Msk = 0x7000000
	// Rx Signal with Double Synchro Stages (2 Positive Edges)
	CAN_MR_RXSYNC_DOUBLE_PP = 0x0
	// Rx Signal with Double Synchro Stages (One Positive Edge and One Negative Edge)
	CAN_MR_RXSYNC_DOUBLE_PN = 0x1
	// Rx Signal with Single Synchro Stage (Positive Edge)
	CAN_MR_RXSYNC_SINGLE_P = 0x2
	// Rx Signal with No Synchro Stage
	CAN_MR_RXSYNC_NONE = 0x3

	// IER: Interrupt Enable Register
	// Position of MB0 field.
	CAN_IER_MB0_Pos = 0x0
	// Bit mask of MB0 field.
	CAN_IER_MB0_Msk = 0x1
	// Bit MB0.
	CAN_IER_MB0 = 0x1
	// Position of MB1 field.
	CAN_IER_MB1_Pos = 0x1
	// Bit mask of MB1 field.
	CAN_IER_MB1_Msk = 0x2
	// Bit MB1.
	CAN_IER_MB1 = 0x2
	// Position of MB2 field.
	CAN_IER_MB2_Pos = 0x2
	// Bit mask of MB2 field.
	CAN_IER_MB2_Msk = 0x4
	// Bit MB2.
	CAN_IER_MB2 = 0x4
	// Position of MB3 field.
	CAN_IER_MB3_Pos = 0x3
	// Bit mask of MB3 field.
	CAN_IER_MB3_Msk = 0x8
	// Bit MB3.
	CAN_IER_MB3 = 0x8
	// Position of MB4 field.
	CAN_IER_MB4_Pos = 0x4
	// Bit mask of MB4 field.
	CAN_IER_MB4_Msk = 0x10
	// Bit MB4.
	CAN_IER_MB4 = 0x10
	// Position of MB5 field.
	CAN_IER_MB5_Pos = 0x5
	// Bit mask of MB5 field.
	CAN_IER_MB5_Msk = 0x20
	// Bit MB5.
	CAN_IER_MB5 = 0x20
	// Position of MB6 field.
	CAN_IER_MB6_Pos = 0x6
	// Bit mask of MB6 field.
	CAN_IER_MB6_Msk = 0x40
	// Bit MB6.
	CAN_IER_MB6 = 0x40
	// Position of MB7 field.
	CAN_IER_MB7_Pos = 0x7
	// Bit mask of MB7 field.
	CAN_IER_MB7_Msk = 0x80
	// Bit MB7.
	CAN_IER_MB7 = 0x80
	// Position of ERRA field.
	CAN_IER_ERRA_Pos = 0x10
	// Bit mask of ERRA field.
	CAN_IER_ERRA_Msk = 0x10000
	// Bit ERRA.
	CAN_IER_ERRA = 0x10000
	// Position of WARN field.
	CAN_IER_WARN_Pos = 0x11
	// Bit mask of WARN field.
	CAN_IER_WARN_Msk = 0x20000
	// Bit WARN.
	CAN_IER_WARN = 0x20000
	// Position of ERRP field.
	CAN_IER_ERRP_Pos = 0x12
	// Bit mask of ERRP field.
	CAN_IER_ERRP_Msk = 0x40000
	// Bit ERRP.
	CAN_IER_ERRP = 0x40000
	// Position of BOFF field.
	CAN_IER_BOFF_Pos = 0x13
	// Bit mask of BOFF field.
	CAN_IER_BOFF_Msk = 0x80000
	// Bit BOFF.
	CAN_IER_BOFF = 0x80000
	// Position of SLEEP field.
	CAN_IER_SLEEP_Pos = 0x14
	// Bit mask of SLEEP field.
	CAN_IER_SLEEP_Msk = 0x100000
	// Bit SLEEP.
	CAN_IER_SLEEP = 0x100000
	// Position of WAKEUP field.
	CAN_IER_WAKEUP_Pos = 0x15
	// Bit mask of WAKEUP field.
	CAN_IER_WAKEUP_Msk = 0x200000
	// Bit WAKEUP.
	CAN_IER_WAKEUP = 0x200000
	// Position of TOVF field.
	CAN_IER_TOVF_Pos = 0x16
	// Bit mask of TOVF field.
	CAN_IER_TOVF_Msk = 0x400000
	// Bit TOVF.
	CAN_IER_TOVF = 0x400000
	// Position of TSTP field.
	CAN_IER_TSTP_Pos = 0x17
	// Bit mask of TSTP field.
	CAN_IER_TSTP_Msk = 0x800000
	// Bit TSTP.
	CAN_IER_TSTP = 0x800000
	// Position of CERR field.
	CAN_IER_CERR_Pos = 0x18
	// Bit mask of CERR field.
	CAN_IER_CERR_Msk = 0x1000000
	// Bit CERR.
	CAN_IER_CERR = 0x1000000
	// Position of SERR field.
	CAN_IER_SERR_Pos = 0x19
	// Bit mask of SERR field.
	CAN_IER_SERR_Msk = 0x2000000
	// Bit SERR.
	CAN_IER_SERR = 0x2000000
	// Position of AERR field.
	CAN_IER_AERR_Pos = 0x1a
	// Bit mask of AERR field.
	CAN_IER_AERR_Msk = 0x4000000
	// Bit AERR.
	CAN_IER_AERR = 0x4000000
	// Position of FERR field.
	CAN_IER_FERR_Pos = 0x1b
	// Bit mask of FERR field.
	CAN_IER_FERR_Msk = 0x8000000
	// Bit FERR.
	CAN_IER_FERR = 0x8000000
	// Position of BERR field.
	CAN_IER_BERR_Pos = 0x1c
	// Bit mask of BERR field.
	CAN_IER_BERR_Msk = 0x10000000
	// Bit BERR.
	CAN_IER_BERR = 0x10000000

	// IDR: Interrupt Disable Register
	// Position of MB0 field.
	CAN_IDR_MB0_Pos = 0x0
	// Bit mask of MB0 field.
	CAN_IDR_MB0_Msk = 0x1
	// Bit MB0.
	CAN_IDR_MB0 = 0x1
	// Position of MB1 field.
	CAN_IDR_MB1_Pos = 0x1
	// Bit mask of MB1 field.
	CAN_IDR_MB1_Msk = 0x2
	// Bit MB1.
	CAN_IDR_MB1 = 0x2
	// Position of MB2 field.
	CAN_IDR_MB2_Pos = 0x2
	// Bit mask of MB2 field.
	CAN_IDR_MB2_Msk = 0x4
	// Bit MB2.
	CAN_IDR_MB2 = 0x4
	// Position of MB3 field.
	CAN_IDR_MB3_Pos = 0x3
	// Bit mask of MB3 field.
	CAN_IDR_MB3_Msk = 0x8
	// Bit MB3.
	CAN_IDR_MB3 = 0x8
	// Position of MB4 field.
	CAN_IDR_MB4_Pos = 0x4
	// Bit mask of MB4 field.
	CAN_IDR_MB4_Msk = 0x10
	// Bit MB4.
	CAN_IDR_MB4 = 0x10
	// Position of MB5 field.
	CAN_IDR_MB5_Pos = 0x5
	// Bit mask of MB5 field.
	CAN_IDR_MB5_Msk = 0x20
	// Bit MB5.
	CAN_IDR_MB5 = 0x20
	// Position of MB6 field.
	CAN_IDR_MB6_Pos = 0x6
	// Bit mask of MB6 field.
	CAN_IDR_MB6_Msk = 0x40
	// Bit MB6.
	CAN_IDR_MB6 = 0x40
	// Position of MB7 field.
	CAN_IDR_MB7_Pos = 0x7
	// Bit mask of MB7 field.
	CAN_IDR_MB7_Msk = 0x80
	// Bit MB7.
	CAN_IDR_MB7 = 0x80
	// Position of ERRA field.
	CAN_IDR_ERRA_Pos = 0x10
	// Bit mask of ERRA field.
	CAN_IDR_ERRA_Msk = 0x10000
	// Bit ERRA.
	CAN_IDR_ERRA = 0x10000
	// Position of WARN field.
	CAN_IDR_WARN_Pos = 0x11
	// Bit mask of WARN field.
	CAN_IDR_WARN_Msk = 0x20000
	// Bit WARN.
	CAN_IDR_WARN = 0x20000
	// Position of ERRP field.
	CAN_IDR_ERRP_Pos = 0x12
	// Bit mask of ERRP field.
	CAN_IDR_ERRP_Msk = 0x40000
	// Bit ERRP.
	CAN_IDR_ERRP = 0x40000
	// Position of BOFF field.
	CAN_IDR_BOFF_Pos = 0x13
	// Bit mask of BOFF field.
	CAN_IDR_BOFF_Msk = 0x80000
	// Bit BOFF.
	CAN_IDR_BOFF = 0x80000
	// Position of SLEEP field.
	CAN_IDR_SLEEP_Pos = 0x14
	// Bit mask of SLEEP field.
	CAN_IDR_SLEEP_Msk = 0x100000
	// Bit SLEEP.
	CAN_IDR_SLEEP = 0x100000
	// Position of WAKEUP field.
	CAN_IDR_WAKEUP_Pos = 0x15
	// Bit mask of WAKEUP field.
	CAN_IDR_WAKEUP_Msk = 0x200000
	// Bit WAKEUP.
	CAN_IDR_WAKEUP = 0x200000
	// Position of TOVF field.
	CAN_IDR_TOVF_Pos = 0x16
	// Bit mask of TOVF field.
	CAN_IDR_TOVF_Msk = 0x400000
	// Bit TOVF.
	CAN_IDR_TOVF = 0x400000
	// Position of TSTP field.
	CAN_IDR_TSTP_Pos = 0x17
	// Bit mask of TSTP field.
	CAN_IDR_TSTP_Msk = 0x800000
	// Bit TSTP.
	CAN_IDR_TSTP = 0x800000
	// Position of CERR field.
	CAN_IDR_CERR_Pos = 0x18
	// Bit mask of CERR field.
	CAN_IDR_CERR_Msk = 0x1000000
	// Bit CERR.
	CAN_IDR_CERR = 0x1000000
	// Position of SERR field.
	CAN_IDR_SERR_Pos = 0x19
	// Bit mask of SERR field.
	CAN_IDR_SERR_Msk = 0x2000000
	// Bit SERR.
	CAN_IDR_SERR = 0x2000000
	// Position of AERR field.
	CAN_IDR_AERR_Pos = 0x1a
	// Bit mask of AERR field.
	CAN_IDR_AERR_Msk = 0x4000000
	// Bit AERR.
	CAN_IDR_AERR = 0x4000000
	// Position of FERR field.
	CAN_IDR_FERR_Pos = 0x1b
	// Bit mask of FERR field.
	CAN_IDR_FERR_Msk = 0x8000000
	// Bit FERR.
	CAN_IDR_FERR = 0x8000000
	// Position of BERR field.
	CAN_IDR_BERR_Pos = 0x1c
	// Bit mask of BERR field.
	CAN_IDR_BERR_Msk = 0x10000000
	// Bit BERR.
	CAN_IDR_BERR = 0x10000000

	// IMR: Interrupt Mask Register
	// Position of MB0 field.
	CAN_IMR_MB0_Pos = 0x0
	// Bit mask of MB0 field.
	CAN_IMR_MB0_Msk = 0x1
	// Bit MB0.
	CAN_IMR_MB0 = 0x1
	// Position of MB1 field.
	CAN_IMR_MB1_Pos = 0x1
	// Bit mask of MB1 field.
	CAN_IMR_MB1_Msk = 0x2
	// Bit MB1.
	CAN_IMR_MB1 = 0x2
	// Position of MB2 field.
	CAN_IMR_MB2_Pos = 0x2
	// Bit mask of MB2 field.
	CAN_IMR_MB2_Msk = 0x4
	// Bit MB2.
	CAN_IMR_MB2 = 0x4
	// Position of MB3 field.
	CAN_IMR_MB3_Pos = 0x3
	// Bit mask of MB3 field.
	CAN_IMR_MB3_Msk = 0x8
	// Bit MB3.
	CAN_IMR_MB3 = 0x8
	// Position of MB4 field.
	CAN_IMR_MB4_Pos = 0x4
	// Bit mask of MB4 field.
	CAN_IMR_MB4_Msk = 0x10
	// Bit MB4.
	CAN_IMR_MB4 = 0x10
	// Position of MB5 field.
	CAN_IMR_MB5_Pos = 0x5
	// Bit mask of MB5 field.
	CAN_IMR_MB5_Msk = 0x20
	// Bit MB5.
	CAN_IMR_MB5 = 0x20
	// Position of MB6 field.
	CAN_IMR_MB6_Pos = 0x6
	// Bit mask of MB6 field.
	CAN_IMR_MB6_Msk = 0x40
	// Bit MB6.
	CAN_IMR_MB6 = 0x40
	// Position of MB7 field.
	CAN_IMR_MB7_Pos = 0x7
	// Bit mask of MB7 field.
	CAN_IMR_MB7_Msk = 0x80
	// Bit MB7.
	CAN_IMR_MB7 = 0x80
	// Position of ERRA field.
	CAN_IMR_ERRA_Pos = 0x10
	// Bit mask of ERRA field.
	CAN_IMR_ERRA_Msk = 0x10000
	// Bit ERRA.
	CAN_IMR_ERRA = 0x10000
	// Position of WARN field.
	CAN_IMR_WARN_Pos = 0x11
	// Bit mask of WARN field.
	CAN_IMR_WARN_Msk = 0x20000
	// Bit WARN.
	CAN_IMR_WARN = 0x20000
	// Position of ERRP field.
	CAN_IMR_ERRP_Pos = 0x12
	// Bit mask of ERRP field.
	CAN_IMR_ERRP_Msk = 0x40000
	// Bit ERRP.
	CAN_IMR_ERRP = 0x40000
	// Position of BOFF field.
	CAN_IMR_BOFF_Pos = 0x13
	// Bit mask of BOFF field.
	CAN_IMR_BOFF_Msk = 0x80000
	// Bit BOFF.
	CAN_IMR_BOFF = 0x80000
	// Position of SLEEP field.
	CAN_IMR_SLEEP_Pos = 0x14
	// Bit mask of SLEEP field.
	CAN_IMR_SLEEP_Msk = 0x100000
	// Bit SLEEP.
	CAN_IMR_SLEEP = 0x100000
	// Position of WAKEUP field.
	CAN_IMR_WAKEUP_Pos = 0x15
	// Bit mask of WAKEUP field.
	CAN_IMR_WAKEUP_Msk = 0x200000
	// Bit WAKEUP.
	CAN_IMR_WAKEUP = 0x200000
	// Position of TOVF field.
	CAN_IMR_TOVF_Pos = 0x16
	// Bit mask of TOVF field.
	CAN_IMR_TOVF_Msk = 0x400000
	// Bit TOVF.
	CAN_IMR_TOVF = 0x400000
	// Position of TSTP field.
	CAN_IMR_TSTP_Pos = 0x17
	// Bit mask of TSTP field.
	CAN_IMR_TSTP_Msk = 0x800000
	// Bit TSTP.
	CAN_IMR_TSTP = 0x800000
	// Position of CERR field.
	CAN_IMR_CERR_Pos = 0x18
	// Bit mask of CERR field.
	CAN_IMR_CERR_Msk = 0x1000000
	// Bit CERR.
	CAN_IMR_CERR = 0x1000000
	// Position of SERR field.
	CAN_IMR_SERR_Pos = 0x19
	// Bit mask of SERR field.
	CAN_IMR_SERR_Msk = 0x2000000
	// Bit SERR.
	CAN_IMR_SERR = 0x2000000
	// Position of AERR field.
	CAN_IMR_AERR_Pos = 0x1a
	// Bit mask of AERR field.
	CAN_IMR_AERR_Msk = 0x4000000
	// Bit AERR.
	CAN_IMR_AERR = 0x4000000
	// Position of FERR field.
	CAN_IMR_FERR_Pos = 0x1b
	// Bit mask of FERR field.
	CAN_IMR_FERR_Msk = 0x8000000
	// Bit FERR.
	CAN_IMR_FERR = 0x8000000
	// Position of BERR field.
	CAN_IMR_BERR_Pos = 0x1c
	// Bit mask of BERR field.
	CAN_IMR_BERR_Msk = 0x10000000
	// Bit BERR.
	CAN_IMR_BERR = 0x10000000

	// SR: Status Register
	// Position of MB0 field.
	CAN_SR_MB0_Pos = 0x0
	// Bit mask of MB0 field.
	CAN_SR_MB0_Msk = 0x1
	// Bit MB0.
	CAN_SR_MB0 = 0x1
	// Position of MB1 field.
	CAN_SR_MB1_Pos = 0x1
	// Bit mask of MB1 field.
	CAN_SR_MB1_Msk = 0x2
	// Bit MB1.
	CAN_SR_MB1 = 0x2
	// Position of MB2 field.
	CAN_SR_MB2_Pos = 0x2
	// Bit mask of MB2 field.
	CAN_SR_MB2_Msk = 0x4
	// Bit MB2.
	CAN_SR_MB2 = 0x4
	// Position of MB3 field.
	CAN_SR_MB3_Pos = 0x3
	// Bit mask of MB3 field.
	CAN_SR_MB3_Msk = 0x8
	// Bit MB3.
	CAN_SR_MB3 = 0x8
	// Position of MB4 field.
	CAN_SR_MB4_Pos = 0x4
	// Bit mask of MB4 field.
	CAN_SR_MB4_Msk = 0x10
	// Bit MB4.
	CAN_SR_MB4 = 0x10
	// Position of MB5 field.
	CAN_SR_MB5_Pos = 0x5
	// Bit mask of MB5 field.
	CAN_SR_MB5_Msk = 0x20
	// Bit MB5.
	CAN_SR_MB5 = 0x20
	// Position of MB6 field.
	CAN_SR_MB6_Pos = 0x6
	// Bit mask of MB6 field.
	CAN_SR_MB6_Msk = 0x40
	// Bit MB6.
	CAN_SR_MB6 = 0x40
	// Position of MB7 field.
	CAN_SR_MB7_Pos = 0x7
	// Bit mask of MB7 field.
	CAN_SR_MB7_Msk = 0x80
	// Bit MB7.
	CAN_SR_MB7 = 0x80
	// Position of ERRA field.
	CAN_SR_ERRA_Pos = 0x10
	// Bit mask of ERRA field.
	CAN_SR_ERRA_Msk = 0x10000
	// Bit ERRA.
	CAN_SR_ERRA = 0x10000
	// Position of WARN field.
	CAN_SR_WARN_Pos = 0x11
	// Bit mask of WARN field.
	CAN_SR_WARN_Msk = 0x20000
	// Bit WARN.
	CAN_SR_WARN = 0x20000
	// Position of ERRP field.
	CAN_SR_ERRP_Pos = 0x12
	// Bit mask of ERRP field.
	CAN_SR_ERRP_Msk = 0x40000
	// Bit ERRP.
	CAN_SR_ERRP = 0x40000
	// Position of BOFF field.
	CAN_SR_BOFF_Pos = 0x13
	// Bit mask of BOFF field.
	CAN_SR_BOFF_Msk = 0x80000
	// Bit BOFF.
	CAN_SR_BOFF = 0x80000
	// Position of SLEEP field.
	CAN_SR_SLEEP_Pos = 0x14
	// Bit mask of SLEEP field.
	CAN_SR_SLEEP_Msk = 0x100000
	// Bit SLEEP.
	CAN_SR_SLEEP = 0x100000
	// Position of WAKEUP field.
	CAN_SR_WAKEUP_Pos = 0x15
	// Bit mask of WAKEUP field.
	CAN_SR_WAKEUP_Msk = 0x200000
	// Bit WAKEUP.
	CAN_SR_WAKEUP = 0x200000
	// Position of TOVF field.
	CAN_SR_TOVF_Pos = 0x16
	// Bit mask of TOVF field.
	CAN_SR_TOVF_Msk = 0x400000
	// Bit TOVF.
	CAN_SR_TOVF = 0x400000
	// Position of TSTP field.
	CAN_SR_TSTP_Pos = 0x17
	// Bit mask of TSTP field.
	CAN_SR_TSTP_Msk = 0x800000
	// Bit TSTP.
	CAN_SR_TSTP = 0x800000
	// Position of CERR field.
	CAN_SR_CERR_Pos = 0x18
	// Bit mask of CERR field.
	CAN_SR_CERR_Msk = 0x1000000
	// Bit CERR.
	CAN_SR_CERR = 0x1000000
	// Position of SERR field.
	CAN_SR_SERR_Pos = 0x19
	// Bit mask of SERR field.
	CAN_SR_SERR_Msk = 0x2000000
	// Bit SERR.
	CAN_SR_SERR = 0x2000000
	// Position of AERR field.
	CAN_SR_AERR_Pos = 0x1a
	// Bit mask of AERR field.
	CAN_SR_AERR_Msk = 0x4000000
	// Bit AERR.
	CAN_SR_AERR = 0x4000000
	// Position of FERR field.
	CAN_SR_FERR_Pos = 0x1b
	// Bit mask of FERR field.
	CAN_SR_FERR_Msk = 0x8000000
	// Bit FERR.
	CAN_SR_FERR = 0x8000000
	// Position of BERR field.
	CAN_SR_BERR_Pos = 0x1c
	// Bit mask of BERR field.
	CAN_SR_BERR_Msk = 0x10000000
	// Bit BERR.
	CAN_SR_BERR = 0x10000000
	// Position of RBSY field.
	CAN_SR_RBSY_Pos = 0x1d
	// Bit mask of RBSY field.
	CAN_SR_RBSY_Msk = 0x20000000
	// Bit RBSY.
	CAN_SR_RBSY = 0x20000000
	// Position of TBSY field.
	CAN_SR_TBSY_Pos = 0x1e
	// Bit mask of TBSY field.
	CAN_SR_TBSY_Msk = 0x40000000
	// Bit TBSY.
	CAN_SR_TBSY = 0x40000000
	// Position of OVLSY field.
	CAN_SR_OVLSY_Pos = 0x1f
	// Bit mask of OVLSY field.
	CAN_SR_OVLSY_Msk = 0x80000000
	// Bit OVLSY.
	CAN_SR_OVLSY = 0x80000000

	// BR: Baudrate Register
	// Position of PHASE2 field.
	CAN_BR_PHASE2_Pos = 0x0
	// Bit mask of PHASE2 field.
	CAN_BR_PHASE2_Msk = 0x7
	// Position of PHASE1 field.
	CAN_BR_PHASE1_Pos = 0x4
	// Bit mask of PHASE1 field.
	CAN_BR_PHASE1_Msk = 0x70
	// Position of PROPAG field.
	CAN_BR_PROPAG_Pos = 0x8
	// Bit mask of PROPAG field.
	CAN_BR_PROPAG_Msk = 0x700
	// Position of SJW field.
	CAN_BR_SJW_Pos = 0xc
	// Bit mask of SJW field.
	CAN_BR_SJW_Msk = 0x3000
	// Position of BRP field.
	CAN_BR_BRP_Pos = 0x10
	// Bit mask of BRP field.
	CAN_BR_BRP_Msk = 0x7f0000
	// Position of SMP field.
	CAN_BR_SMP_Pos = 0x18
	// Bit mask of SMP field.
	CAN_BR_SMP_Msk = 0x1000000
	// Bit SMP.
	CAN_BR_SMP = 0x1000000
	// The incoming bit stream is sampled once at sample point.
	CAN_BR_SMP_ONCE = 0x0
	// The incoming bit stream is sampled three times with a period of a MCK clock period, centered on sample point.
	CAN_BR_SMP_THREE = 0x1

	// TIM: Timer Register
	// Position of TIMER field.
	CAN_TIM_TIMER_Pos = 0x0
	// Bit mask of TIMER field.
	CAN_TIM_TIMER_Msk = 0xffff

	// TIMESTP: Timestamp Register
	// Position of MTIMESTAMP field.
	CAN_TIMESTP_MTIMESTAMP_Pos = 0x0
	// Bit mask of MTIMESTAMP field.
	CAN_TIMESTP_MTIMESTAMP_Msk = 0xffff

	// ECR: Error Counter Register
	// Position of REC field.
	CAN_ECR_REC_Pos = 0x0
	// Bit mask of REC field.
	CAN_ECR_REC_Msk = 0xff
	// Position of TEC field.
	CAN_ECR_TEC_Pos = 0x10
	// Bit mask of TEC field.
	CAN_ECR_TEC_Msk = 0xff0000

	// TCR: Transfer Command Register
	// Position of MB0 field.
	CAN_TCR_MB0_Pos = 0x0
	// Bit mask of MB0 field.
	CAN_TCR_MB0_Msk = 0x1
	// Bit MB0.
	CAN_TCR_MB0 = 0x1
	// Position of MB1 field.
	CAN_TCR_MB1_Pos = 0x1
	// Bit mask of MB1 field.
	CAN_TCR_MB1_Msk = 0x2
	// Bit MB1.
	CAN_TCR_MB1 = 0x2
	// Position of MB2 field.
	CAN_TCR_MB2_Pos = 0x2
	// Bit mask of MB2 field.
	CAN_TCR_MB2_Msk = 0x4
	// Bit MB2.
	CAN_TCR_MB2 = 0x4
	// Position of MB3 field.
	CAN_TCR_MB3_Pos = 0x3
	// Bit mask of MB3 field.
	CAN_TCR_MB3_Msk = 0x8
	// Bit MB3.
	CAN_TCR_MB3 = 0x8
	// Position of MB4 field.
	CAN_TCR_MB4_Pos = 0x4
	// Bit mask of MB4 field.
	CAN_TCR_MB4_Msk = 0x10
	// Bit MB4.
	CAN_TCR_MB4 = 0x10
	// Position of MB5 field.
	CAN_TCR_MB5_Pos = 0x5
	// Bit mask of MB5 field.
	CAN_TCR_MB5_Msk = 0x20
	// Bit MB5.
	CAN_TCR_MB5 = 0x20
	// Position of MB6 field.
	CAN_TCR_MB6_Pos = 0x6
	// Bit mask of MB6 field.
	CAN_TCR_MB6_Msk = 0x40
	// Bit MB6.
	CAN_TCR_MB6 = 0x40
	// Position of MB7 field.
	CAN_TCR_MB7_Pos = 0x7
	// Bit mask of MB7 field.
	CAN_TCR_MB7_Msk = 0x80
	// Bit MB7.
	CAN_TCR_MB7 = 0x80
	// Position of TIMRST field.
	CAN_TCR_TIMRST_Pos = 0x1f
	// Bit mask of TIMRST field.
	CAN_TCR_TIMRST_Msk = 0x80000000
	// Bit TIMRST.
	CAN_TCR_TIMRST = 0x80000000

	// ACR: Abort Command Register
	// Position of MB0 field.
	CAN_ACR_MB0_Pos = 0x0
	// Bit mask of MB0 field.
	CAN_ACR_MB0_Msk = 0x1
	// Bit MB0.
	CAN_ACR_MB0 = 0x1
	// Position of MB1 field.
	CAN_ACR_MB1_Pos = 0x1
	// Bit mask of MB1 field.
	CAN_ACR_MB1_Msk = 0x2
	// Bit MB1.
	CAN_ACR_MB1 = 0x2
	// Position of MB2 field.
	CAN_ACR_MB2_Pos = 0x2
	// Bit mask of MB2 field.
	CAN_ACR_MB2_Msk = 0x4
	// Bit MB2.
	CAN_ACR_MB2 = 0x4
	// Position of MB3 field.
	CAN_ACR_MB3_Pos = 0x3
	// Bit mask of MB3 field.
	CAN_ACR_MB3_Msk = 0x8
	// Bit MB3.
	CAN_ACR_MB3 = 0x8
	// Position of MB4 field.
	CAN_ACR_MB4_Pos = 0x4
	// Bit mask of MB4 field.
	CAN_ACR_MB4_Msk = 0x10
	// Bit MB4.
	CAN_ACR_MB4 = 0x10
	// Position of MB5 field.
	CAN_ACR_MB5_Pos = 0x5
	// Bit mask of MB5 field.
	CAN_ACR_MB5_Msk = 0x20
	// Bit MB5.
	CAN_ACR_MB5 = 0x20
	// Position of MB6 field.
	CAN_ACR_MB6_Pos = 0x6
	// Bit mask of MB6 field.
	CAN_ACR_MB6_Msk = 0x40
	// Bit MB6.
	CAN_ACR_MB6 = 0x40
	// Position of MB7 field.
	CAN_ACR_MB7_Pos = 0x7
	// Bit mask of MB7 field.
	CAN_ACR_MB7_Msk = 0x80
	// Bit MB7.
	CAN_ACR_MB7 = 0x80

	// WPMR: Write Protect Mode Register
	// Position of WPEN field.
	CAN_WPMR_WPEN_Pos = 0x0
	// Bit mask of WPEN field.
	CAN_WPMR_WPEN_Msk = 0x1
	// Bit WPEN.
	CAN_WPMR_WPEN = 0x1
	// Position of WPKEY field.
	CAN_WPMR_WPKEY_Pos = 0x8
	// Bit mask of WPKEY field.
	CAN_WPMR_WPKEY_Msk = 0xffffff00

	// WPSR: Write Protect Status Register
	// Position of WPVS field.
	CAN_WPSR_WPVS_Pos = 0x0
	// Bit mask of WPVS field.
	CAN_WPSR_WPVS_Msk = 0x1
	// Bit WPVS.
	CAN_WPSR_WPVS = 0x1
	// Position of WPVSRC field.
	CAN_WPSR_WPVSRC_Pos = 0x8
	// Bit mask of WPVSRC field.
	CAN_WPSR_WPVSRC_Msk = 0xff00

	// MMR0: Mailbox Mode Register (MB = 0)
	// Position of MTIMEMARK field.
	CAN_MMR0_MTIMEMARK_Pos = 0x0
	// Bit mask of MTIMEMARK field.
	CAN_MMR0_MTIMEMARK_Msk = 0xffff
	// Position of PRIOR field.
	CAN_MMR0_PRIOR_Pos = 0x10
	// Bit mask of PRIOR field.
	CAN_MMR0_PRIOR_Msk = 0xf0000
	// Position of MOT field.
	CAN_MMR0_MOT_Pos = 0x18
	// Bit mask of MOT field.
	CAN_MMR0_MOT_Msk = 0x7000000
	// Mailbox is disabled. This prevents receiving or transmitting any messages with this mailbox.
	CAN_MMR0_MOT_MB_DISABLED = 0x0
	// Reception Mailbox. Mailbox is configured for reception. If a message is received while the mailbox data register is full, it is discarded.
	CAN_MMR0_MOT_MB_RX = 0x1
	// Reception mailbox with overwrite. Mailbox is configured for reception. If a message is received while the mailbox is full, it overwrites the previous message.
	CAN_MMR0_MOT_MB_RX_OVERWRITE = 0x2
	// Transmit mailbox. Mailbox is configured for transmission.
	CAN_MMR0_MOT_MB_TX = 0x3
	// Consumer Mailbox. Mailbox is configured in reception but behaves as a Transmit Mailbox, i.e., it sends a remote frame and waits for an answer.
	CAN_MMR0_MOT_MB_CONSUMER = 0x4
	// Producer Mailbox. Mailbox is configured in transmission but also behaves like a reception mailbox, i.e., it waits to receive a Remote Frame before sending its contents.
	CAN_MMR0_MOT_MB_PRODUCER = 0x5

	// MAM0: Mailbox Acceptance Mask Register (MB = 0)
	// Position of MIDvB field.
	CAN_MAM0_MIDvB_Pos = 0x0
	// Bit mask of MIDvB field.
	CAN_MAM0_MIDvB_Msk = 0x3ffff
	// Position of MIDvA field.
	CAN_MAM0_MIDvA_Pos = 0x12
	// Bit mask of MIDvA field.
	CAN_MAM0_MIDvA_Msk = 0x1ffc0000
	// Position of MIDE field.
	CAN_MAM0_MIDE_Pos = 0x1d
	// Bit mask of MIDE field.
	CAN_MAM0_MIDE_Msk = 0x20000000
	// Bit MIDE.
	CAN_MAM0_MIDE = 0x20000000

	// MID0: Mailbox ID Register (MB = 0)
	// Position of MIDvB field.
	CAN_MID0_MIDvB_Pos = 0x0
	// Bit mask of MIDvB field.
	CAN_MID0_MIDvB_Msk = 0x3ffff
	// Position of MIDvA field.
	CAN_MID0_MIDvA_Pos = 0x12
	// Bit mask of MIDvA field.
	CAN_MID0_MIDvA_Msk = 0x1ffc0000
	// Position of MIDE field.
	CAN_MID0_MIDE_Pos = 0x1d
	// Bit mask of MIDE field.
	CAN_MID0_MIDE_Msk = 0x20000000
	// Bit MIDE.
	CAN_MID0_MIDE = 0x20000000

	// MFID0: Mailbox Family ID Register (MB = 0)
	// Position of MFID field.
	CAN_MFID0_MFID_Pos = 0x0
	// Bit mask of MFID field.
	CAN_MFID0_MFID_Msk = 0x1fffffff

	// MSR0: Mailbox Status Register (MB = 0)
	// Position of MTIMESTAMP field.
	CAN_MSR0_MTIMESTAMP_Pos = 0x0
	// Bit mask of MTIMESTAMP field.
	CAN_MSR0_MTIMESTAMP_Msk = 0xffff
	// Position of MDLC field.
	CAN_MSR0_MDLC_Pos = 0x10
	// Bit mask of MDLC field.
	CAN_MSR0_MDLC_Msk = 0xf0000
	// Position of MRTR field.
	CAN_MSR0_MRTR_Pos = 0x14
	// Bit mask of MRTR field.
	CAN_MSR0_MRTR_Msk = 0x100000
	// Bit MRTR.
	CAN_MSR0_MRTR = 0x100000
	// Position of MABT field.
	CAN_MSR0_MABT_Pos = 0x16
	// Bit mask of MABT field.
	CAN_MSR0_MABT_Msk = 0x400000
	// Bit MABT.
	CAN_MSR0_MABT = 0x400000
	// Position of MRDY field.
	CAN_MSR0_MRDY_Pos = 0x17
	// Bit mask of MRDY field.
	CAN_MSR0_MRDY_Msk = 0x800000
	// Bit MRDY.
	CAN_MSR0_MRDY = 0x800000
	// Position of MMI field.
	CAN_MSR0_MMI_Pos = 0x18
	// Bit mask of MMI field.
	CAN_MSR0_MMI_Msk = 0x1000000
	// Bit MMI.
	CAN_MSR0_MMI = 0x1000000

	// MDL0: Mailbox Data Low Register (MB = 0)
	// Position of MDL field.
	CAN_MDL0_MDL_Pos = 0x0
	// Bit mask of MDL field.
	CAN_MDL0_MDL_Msk = 0xffffffff

	// MDH0: Mailbox Data High Register (MB = 0)
	// Position of MDH field.
	CAN_MDH0_MDH_Pos = 0x0
	// Bit mask of MDH field.
	CAN_MDH0_MDH_Msk = 0xffffffff

	// MCR0: Mailbox Control Register (MB = 0)
	// Position of MDLC field.
	CAN_MCR0_MDLC_Pos = 0x10
	// Bit mask of MDLC field.
	CAN_MCR0_MDLC_Msk = 0xf0000
	// Position of MRTR field.
	CAN_MCR0_MRTR_Pos = 0x14
	// Bit mask of MRTR field.
	CAN_MCR0_MRTR_Msk = 0x100000
	// Bit MRTR.
	CAN_MCR0_MRTR = 0x100000
	// Position of MACR field.
	CAN_MCR0_MACR_Pos = 0x16
	// Bit mask of MACR field.
	CAN_MCR0_MACR_Msk = 0x400000
	// Bit MACR.
	CAN_MCR0_MACR = 0x400000
	// Position of MTCR field.
	CAN_MCR0_MTCR_Pos = 0x17
	// Bit mask of MTCR field.
	CAN_MCR0_MTCR_Msk = 0x800000
	// Bit MTCR.
	CAN_MCR0_MTCR = 0x800000

	// MMR1: Mailbox Mode Register (MB = 1)
	// Position of MTIMEMARK field.
	CAN_MMR1_MTIMEMARK_Pos = 0x0
	// Bit mask of MTIMEMARK field.
	CAN_MMR1_MTIMEMARK_Msk = 0xffff
	// Position of PRIOR field.
	CAN_MMR1_PRIOR_Pos = 0x10
	// Bit mask of PRIOR field.
	CAN_MMR1_PRIOR_Msk = 0xf0000
	// Position of MOT field.
	CAN_MMR1_MOT_Pos = 0x18
	// Bit mask of MOT field.
	CAN_MMR1_MOT_Msk = 0x7000000
	// Mailbox is disabled. This prevents receiving or transmitting any messages with this mailbox.
	CAN_MMR1_MOT_MB_DISABLED = 0x0
	// Reception Mailbox. Mailbox is configured for reception. If a message is received while the mailbox data register is full, it is discarded.
	CAN_MMR1_MOT_MB_RX = 0x1
	// Reception mailbox with overwrite. Mailbox is configured for reception. If a message is received while the mailbox is full, it overwrites the previous message.
	CAN_MMR1_MOT_MB_RX_OVERWRITE = 0x2
	// Transmit mailbox. Mailbox is configured for transmission.
	CAN_MMR1_MOT_MB_TX = 0x3
	// Consumer Mailbox. Mailbox is configured in reception but behaves as a Transmit Mailbox, i.e., it sends a remote frame and waits for an answer.
	CAN_MMR1_MOT_MB_CONSUMER = 0x4
	// Producer Mailbox. Mailbox is configured in transmission but also behaves like a reception mailbox, i.e., it waits to receive a Remote Frame before sending its contents.
	CAN_MMR1_MOT_MB_PRODUCER = 0x5

	// MAM1: Mailbox Acceptance Mask Register (MB = 1)
	// Position of MIDvB field.
	CAN_MAM1_MIDvB_Pos = 0x0
	// Bit mask of MIDvB field.
	CAN_MAM1_MIDvB_Msk = 0x3ffff
	// Position of MIDvA field.
	CAN_MAM1_MIDvA_Pos = 0x12
	// Bit mask of MIDvA field.
	CAN_MAM1_MIDvA_Msk = 0x1ffc0000
	// Position of MIDE field.
	CAN_MAM1_MIDE_Pos = 0x1d
	// Bit mask of MIDE field.
	CAN_MAM1_MIDE_Msk = 0x20000000
	// Bit MIDE.
	CAN_MAM1_MIDE = 0x20000000

	// MID1: Mailbox ID Register (MB = 1)
	// Position of MIDvB field.
	CAN_MID1_MIDvB_Pos = 0x0
	// Bit mask of MIDvB field.
	CAN_MID1_MIDvB_Msk = 0x3ffff
	// Position of MIDvA field.
	CAN_MID1_MIDvA_Pos = 0x12
	// Bit mask of MIDvA field.
	CAN_MID1_MIDvA_Msk = 0x1ffc0000
	// Position of MIDE field.
	CAN_MID1_MIDE_Pos = 0x1d
	// Bit mask of MIDE field.
	CAN_MID1_MIDE_Msk = 0x20000000
	// Bit MIDE.
	CAN_MID1_MIDE = 0x20000000

	// MFID1: Mailbox Family ID Register (MB = 1)
	// Position of MFID field.
	CAN_MFID1_MFID_Pos = 0x0
	// Bit mask of MFID field.
	CAN_MFID1_MFID_Msk = 0x1fffffff

	// MSR1: Mailbox Status Register (MB = 1)
	// Position of MTIMESTAMP field.
	CAN_MSR1_MTIMESTAMP_Pos = 0x0
	// Bit mask of MTIMESTAMP field.
	CAN_MSR1_MTIMESTAMP_Msk = 0xffff
	// Position of MDLC field.
	CAN_MSR1_MDLC_Pos = 0x10
	// Bit mask of MDLC field.
	CAN_MSR1_MDLC_Msk = 0xf0000
	// Position of MRTR field.
	CAN_MSR1_MRTR_Pos = 0x14
	// Bit mask of MRTR field.
	CAN_MSR1_MRTR_Msk = 0x100000
	// Bit MRTR.
	CAN_MSR1_MRTR = 0x100000
	// Position of MABT field.
	CAN_MSR1_MABT_Pos = 0x16
	// Bit mask of MABT field.
	CAN_MSR1_MABT_Msk = 0x400000
	// Bit MABT.
	CAN_MSR1_MABT = 0x400000
	// Position of MRDY field.
	CAN_MSR1_MRDY_Pos = 0x17
	// Bit mask of MRDY field.
	CAN_MSR1_MRDY_Msk = 0x800000
	// Bit MRDY.
	CAN_MSR1_MRDY = 0x800000
	// Position of MMI field.
	CAN_MSR1_MMI_Pos = 0x18
	// Bit mask of MMI field.
	CAN_MSR1_MMI_Msk = 0x1000000
	// Bit MMI.
	CAN_MSR1_MMI = 0x1000000

	// MDL1: Mailbox Data Low Register (MB = 1)
	// Position of MDL field.
	CAN_MDL1_MDL_Pos = 0x0
	// Bit mask of MDL field.
	CAN_MDL1_MDL_Msk = 0xffffffff

	// MDH1: Mailbox Data High Register (MB = 1)
	// Position of MDH field.
	CAN_MDH1_MDH_Pos = 0x0
	// Bit mask of MDH field.
	CAN_MDH1_MDH_Msk = 0xffffffff

	// MCR1: Mailbox Control Register (MB = 1)
	// Position of MDLC field.
	CAN_MCR1_MDLC_Pos = 0x10
	// Bit mask of MDLC field.
	CAN_MCR1_MDLC_Msk = 0xf0000
	// Position of MRTR field.
	CAN_MCR1_MRTR_Pos = 0x14
	// Bit mask of MRTR field.
	CAN_MCR1_MRTR_Msk = 0x100000
	// Bit MRTR.
	CAN_MCR1_MRTR = 0x100000
	// Position of MACR field.
	CAN_MCR1_MACR_Pos = 0x16
	// Bit mask of MACR field.
	CAN_MCR1_MACR_Msk = 0x400000
	// Bit MACR.
	CAN_MCR1_MACR = 0x400000
	// Position of MTCR field.
	CAN_MCR1_MTCR_Pos = 0x17
	// Bit mask of MTCR field.
	CAN_MCR1_MTCR_Msk = 0x800000
	// Bit MTCR.
	CAN_MCR1_MTCR = 0x800000

	// MMR2: Mailbox Mode Register (MB = 2)
	// Position of MTIMEMARK field.
	CAN_MMR2_MTIMEMARK_Pos = 0x0
	// Bit mask of MTIMEMARK field.
	CAN_MMR2_MTIMEMARK_Msk = 0xffff
	// Position of PRIOR field.
	CAN_MMR2_PRIOR_Pos = 0x10
	// Bit mask of PRIOR field.
	CAN_MMR2_PRIOR_Msk = 0xf0000
	// Position of MOT field.
	CAN_MMR2_MOT_Pos = 0x18
	// Bit mask of MOT field.
	CAN_MMR2_MOT_Msk = 0x7000000
	// Mailbox is disabled. This prevents receiving or transmitting any messages with this mailbox.
	CAN_MMR2_MOT_MB_DISABLED = 0x0
	// Reception Mailbox. Mailbox is configured for reception. If a message is received while the mailbox data register is full, it is discarded.
	CAN_MMR2_MOT_MB_RX = 0x1
	// Reception mailbox with overwrite. Mailbox is configured for reception. If a message is received while the mailbox is full, it overwrites the previous message.
	CAN_MMR2_MOT_MB_RX_OVERWRITE = 0x2
	// Transmit mailbox. Mailbox is configured for transmission.
	CAN_MMR2_MOT_MB_TX = 0x3
	// Consumer Mailbox. Mailbox is configured in reception but behaves as a Transmit Mailbox, i.e., it sends a remote frame and waits for an answer.
	CAN_MMR2_MOT_MB_CONSUMER = 0x4
	// Producer Mailbox. Mailbox is configured in transmission but also behaves like a reception mailbox, i.e., it waits to receive a Remote Frame before sending its contents.
	CAN_MMR2_MOT_MB_PRODUCER = 0x5

	// MAM2: Mailbox Acceptance Mask Register (MB = 2)
	// Position of MIDvB field.
	CAN_MAM2_MIDvB_Pos = 0x0
	// Bit mask of MIDvB field.
	CAN_MAM2_MIDvB_Msk = 0x3ffff
	// Position of MIDvA field.
	CAN_MAM2_MIDvA_Pos = 0x12
	// Bit mask of MIDvA field.
	CAN_MAM2_MIDvA_Msk = 0x1ffc0000
	// Position of MIDE field.
	CAN_MAM2_MIDE_Pos = 0x1d
	// Bit mask of MIDE field.
	CAN_MAM2_MIDE_Msk = 0x20000000
	// Bit MIDE.
	CAN_MAM2_MIDE = 0x20000000

	// MID2: Mailbox ID Register (MB = 2)
	// Position of MIDvB field.
	CAN_MID2_MIDvB_Pos = 0x0
	// Bit mask of MIDvB field.
	CAN_MID2_MIDvB_Msk = 0x3ffff
	// Position of MIDvA field.
	CAN_MID2_MIDvA_Pos = 0x12
	// Bit mask of MIDvA field.
	CAN_MID2_MIDvA_Msk = 0x1ffc0000
	// Position of MIDE field.
	CAN_MID2_MIDE_Pos = 0x1d
	// Bit mask of MIDE field.
	CAN_MID2_MIDE_Msk = 0x20000000
	// Bit MIDE.
	CAN_MID2_MIDE = 0x20000000

	// MFID2: Mailbox Family ID Register (MB = 2)
	// Position of MFID field.
	CAN_MFID2_MFID_Pos = 0x0
	// Bit mask of MFID field.
	CAN_MFID2_MFID_Msk = 0x1fffffff

	// MSR2: Mailbox Status Register (MB = 2)
	// Position of MTIMESTAMP field.
	CAN_MSR2_MTIMESTAMP_Pos = 0x0
	// Bit mask of MTIMESTAMP field.
	CAN_MSR2_MTIMESTAMP_Msk = 0xffff
	// Position of MDLC field.
	CAN_MSR2_MDLC_Pos = 0x10
	// Bit mask of MDLC field.
	CAN_MSR2_MDLC_Msk = 0xf0000
	// Position of MRTR field.
	CAN_MSR2_MRTR_Pos = 0x14
	// Bit mask of MRTR field.
	CAN_MSR2_MRTR_Msk = 0x100000
	// Bit MRTR.
	CAN_MSR2_MRTR = 0x100000
	// Position of MABT field.
	CAN_MSR2_MABT_Pos = 0x16
	// Bit mask of MABT field.
	CAN_MSR2_MABT_Msk = 0x400000
	// Bit MABT.
	CAN_MSR2_MABT = 0x400000
	// Position of MRDY field.
	CAN_MSR2_MRDY_Pos = 0x17
	// Bit mask of MRDY field.
	CAN_MSR2_MRDY_Msk = 0x800000
	// Bit MRDY.
	CAN_MSR2_MRDY = 0x800000
	// Position of MMI field.
	CAN_MSR2_MMI_Pos = 0x18
	// Bit mask of MMI field.
	CAN_MSR2_MMI_Msk = 0x1000000
	// Bit MMI.
	CAN_MSR2_MMI = 0x1000000

	// MDL2: Mailbox Data Low Register (MB = 2)
	// Position of MDL field.
	CAN_MDL2_MDL_Pos = 0x0
	// Bit mask of MDL field.
	CAN_MDL2_MDL_Msk = 0xffffffff

	// MDH2: Mailbox Data High Register (MB = 2)
	// Position of MDH field.
	CAN_MDH2_MDH_Pos = 0x0
	// Bit mask of MDH field.
	CAN_MDH2_MDH_Msk = 0xffffffff

	// MCR2: Mailbox Control Register (MB = 2)
	// Position of MDLC field.
	CAN_MCR2_MDLC_Pos = 0x10
	// Bit mask of MDLC field.
	CAN_MCR2_MDLC_Msk = 0xf0000
	// Position of MRTR field.
	CAN_MCR2_MRTR_Pos = 0x14
	// Bit mask of MRTR field.
	CAN_MCR2_MRTR_Msk = 0x100000
	// Bit MRTR.
	CAN_MCR2_MRTR = 0x100000
	// Position of MACR field.
	CAN_MCR2_MACR_Pos = 0x16
	// Bit mask of MACR field.
	CAN_MCR2_MACR_Msk = 0x400000
	// Bit MACR.
	CAN_MCR2_MACR = 0x400000
	// Position of MTCR field.
	CAN_MCR2_MTCR_Pos = 0x17
	// Bit mask of MTCR field.
	CAN_MCR2_MTCR_Msk = 0x800000
	// Bit MTCR.
	CAN_MCR2_MTCR = 0x800000

	// MMR3: Mailbox Mode Register (MB = 3)
	// Position of MTIMEMARK field.
	CAN_MMR3_MTIMEMARK_Pos = 0x0
	// Bit mask of MTIMEMARK field.
	CAN_MMR3_MTIMEMARK_Msk = 0xffff
	// Position of PRIOR field.
	CAN_MMR3_PRIOR_Pos = 0x10
	// Bit mask of PRIOR field.
	CAN_MMR3_PRIOR_Msk = 0xf0000
	// Position of MOT field.
	CAN_MMR3_MOT_Pos = 0x18
	// Bit mask of MOT field.
	CAN_MMR3_MOT_Msk = 0x7000000
	// Mailbox is disabled. This prevents receiving or transmitting any messages with this mailbox.
	CAN_MMR3_MOT_MB_DISABLED = 0x0
	// Reception Mailbox. Mailbox is configured for reception. If a message is received while the mailbox data register is full, it is discarded.
	CAN_MMR3_MOT_MB_RX = 0x1
	// Reception mailbox with overwrite. Mailbox is configured for reception. If a message is received while the mailbox is full, it overwrites the previous message.
	CAN_MMR3_MOT_MB_RX_OVERWRITE = 0x2
	// Transmit mailbox. Mailbox is configured for transmission.
	CAN_MMR3_MOT_MB_TX = 0x3
	// Consumer Mailbox. Mailbox is configured in reception but behaves as a Transmit Mailbox, i.e., it sends a remote frame and waits for an answer.
	CAN_MMR3_MOT_MB_CONSUMER = 0x4
	// Producer Mailbox. Mailbox is configured in transmission but also behaves like a reception mailbox, i.e., it waits to receive a Remote Frame before sending its contents.
	CAN_MMR3_MOT_MB_PRODUCER = 0x5

	// MAM3: Mailbox Acceptance Mask Register (MB = 3)
	// Position of MIDvB field.
	CAN_MAM3_MIDvB_Pos = 0x0
	// Bit mask of MIDvB field.
	CAN_MAM3_MIDvB_Msk = 0x3ffff
	// Position of MIDvA field.
	CAN_MAM3_MIDvA_Pos = 0x12
	// Bit mask of MIDvA field.
	CAN_MAM3_MIDvA_Msk = 0x1ffc0000
	// Position of MIDE field.
	CAN_MAM3_MIDE_Pos = 0x1d
	// Bit mask of MIDE field.
	CAN_MAM3_MIDE_Msk = 0x20000000
	// Bit MIDE.
	CAN_MAM3_MIDE = 0x20000000

	// MID3: Mailbox ID Register (MB = 3)
	// Position of MIDvB field.
	CAN_MID3_MIDvB_Pos = 0x0
	// Bit mask of MIDvB field.
	CAN_MID3_MIDvB_Msk = 0x3ffff
	// Position of MIDvA field.
	CAN_MID3_MIDvA_Pos = 0x12
	// Bit mask of MIDvA field.
	CAN_MID3_MIDvA_Msk = 0x1ffc0000
	// Position of MIDE field.
	CAN_MID3_MIDE_Pos = 0x1d
	// Bit mask of MIDE field.
	CAN_MID3_MIDE_Msk = 0x20000000
	// Bit MIDE.
	CAN_MID3_MIDE = 0x20000000

	// MFID3: Mailbox Family ID Register (MB = 3)
	// Position of MFID field.
	CAN_MFID3_MFID_Pos = 0x0
	// Bit mask of MFID field.
	CAN_MFID3_MFID_Msk = 0x1fffffff

	// MSR3: Mailbox Status Register (MB = 3)
	// Position of MTIMESTAMP field.
	CAN_MSR3_MTIMESTAMP_Pos = 0x0
	// Bit mask of MTIMESTAMP field.
	CAN_MSR3_MTIMESTAMP_Msk = 0xffff
	// Position of MDLC field.
	CAN_MSR3_MDLC_Pos = 0x10
	// Bit mask of MDLC field.
	CAN_MSR3_MDLC_Msk = 0xf0000
	// Position of MRTR field.
	CAN_MSR3_MRTR_Pos = 0x14
	// Bit mask of MRTR field.
	CAN_MSR3_MRTR_Msk = 0x100000
	// Bit MRTR.
	CAN_MSR3_MRTR = 0x100000
	// Position of MABT field.
	CAN_MSR3_MABT_Pos = 0x16
	// Bit mask of MABT field.
	CAN_MSR3_MABT_Msk = 0x400000
	// Bit MABT.
	CAN_MSR3_MABT = 0x400000
	// Position of MRDY field.
	CAN_MSR3_MRDY_Pos = 0x17
	// Bit mask of MRDY field.
	CAN_MSR3_MRDY_Msk = 0x800000
	// Bit MRDY.
	CAN_MSR3_MRDY = 0x800000
	// Position of MMI field.
	CAN_MSR3_MMI_Pos = 0x18
	// Bit mask of MMI field.
	CAN_MSR3_MMI_Msk = 0x1000000
	// Bit MMI.
	CAN_MSR3_MMI = 0x1000000

	// MDL3: Mailbox Data Low Register (MB = 3)
	// Position of MDL field.
	CAN_MDL3_MDL_Pos = 0x0
	// Bit mask of MDL field.
	CAN_MDL3_MDL_Msk = 0xffffffff

	// MDH3: Mailbox Data High Register (MB = 3)
	// Position of MDH field.
	CAN_MDH3_MDH_Pos = 0x0
	// Bit mask of MDH field.
	CAN_MDH3_MDH_Msk = 0xffffffff

	// MCR3: Mailbox Control Register (MB = 3)
	// Position of MDLC field.
	CAN_MCR3_MDLC_Pos = 0x10
	// Bit mask of MDLC field.
	CAN_MCR3_MDLC_Msk = 0xf0000
	// Position of MRTR field.
	CAN_MCR3_MRTR_Pos = 0x14
	// Bit mask of MRTR field.
	CAN_MCR3_MRTR_Msk = 0x100000
	// Bit MRTR.
	CAN_MCR3_MRTR = 0x100000
	// Position of MACR field.
	CAN_MCR3_MACR_Pos = 0x16
	// Bit mask of MACR field.
	CAN_MCR3_MACR_Msk = 0x400000
	// Bit MACR.
	CAN_MCR3_MACR = 0x400000
	// Position of MTCR field.
	CAN_MCR3_MTCR_Pos = 0x17
	// Bit mask of MTCR field.
	CAN_MCR3_MTCR_Msk = 0x800000
	// Bit MTCR.
	CAN_MCR3_MTCR = 0x800000

	// MMR4: Mailbox Mode Register (MB = 4)
	// Position of MTIMEMARK field.
	CAN_MMR4_MTIMEMARK_Pos = 0x0
	// Bit mask of MTIMEMARK field.
	CAN_MMR4_MTIMEMARK_Msk = 0xffff
	// Position of PRIOR field.
	CAN_MMR4_PRIOR_Pos = 0x10
	// Bit mask of PRIOR field.
	CAN_MMR4_PRIOR_Msk = 0xf0000
	// Position of MOT field.
	CAN_MMR4_MOT_Pos = 0x18
	// Bit mask of MOT field.
	CAN_MMR4_MOT_Msk = 0x7000000
	// Mailbox is disabled. This prevents receiving or transmitting any messages with this mailbox.
	CAN_MMR4_MOT_MB_DISABLED = 0x0
	// Reception Mailbox. Mailbox is configured for reception. If a message is received while the mailbox data register is full, it is discarded.
	CAN_MMR4_MOT_MB_RX = 0x1
	// Reception mailbox with overwrite. Mailbox is configured for reception. If a message is received while the mailbox is full, it overwrites the previous message.
	CAN_MMR4_MOT_MB_RX_OVERWRITE = 0x2
	// Transmit mailbox. Mailbox is configured for transmission.
	CAN_MMR4_MOT_MB_TX = 0x3
	// Consumer Mailbox. Mailbox is configured in reception but behaves as a Transmit Mailbox, i.e., it sends a remote frame and waits for an answer.
	CAN_MMR4_MOT_MB_CONSUMER = 0x4
	// Producer Mailbox. Mailbox is configured in transmission but also behaves like a reception mailbox, i.e., it waits to receive a Remote Frame before sending its contents.
	CAN_MMR4_MOT_MB_PRODUCER = 0x5

	// MAM4: Mailbox Acceptance Mask Register (MB = 4)
	// Position of MIDvB field.
	CAN_MAM4_MIDvB_Pos = 0x0
	// Bit mask of MIDvB field.
	CAN_MAM4_MIDvB_Msk = 0x3ffff
	// Position of MIDvA field.
	CAN_MAM4_MIDvA_Pos = 0x12
	// Bit mask of MIDvA field.
	CAN_MAM4_MIDvA_Msk = 0x1ffc0000
	// Position of MIDE field.
	CAN_MAM4_MIDE_Pos = 0x1d
	// Bit mask of MIDE field.
	CAN_MAM4_MIDE_Msk = 0x20000000
	// Bit MIDE.
	CAN_MAM4_MIDE = 0x20000000

	// MID4: Mailbox ID Register (MB = 4)
	// Position of MIDvB field.
	CAN_MID4_MIDvB_Pos = 0x0
	// Bit mask of MIDvB field.
	CAN_MID4_MIDvB_Msk = 0x3ffff
	// Position of MIDvA field.
	CAN_MID4_MIDvA_Pos = 0x12
	// Bit mask of MIDvA field.
	CAN_MID4_MIDvA_Msk = 0x1ffc0000
	// Position of MIDE field.
	CAN_MID4_MIDE_Pos = 0x1d
	// Bit mask of MIDE field.
	CAN_MID4_MIDE_Msk = 0x20000000
	// Bit MIDE.
	CAN_MID4_MIDE = 0x20000000

	// MFID4: Mailbox Family ID Register (MB = 4)
	// Position of MFID field.
	CAN_MFID4_MFID_Pos = 0x0
	// Bit mask of MFID field.
	CAN_MFID4_MFID_Msk = 0x1fffffff

	// MSR4: Mailbox Status Register (MB = 4)
	// Position of MTIMESTAMP field.
	CAN_MSR4_MTIMESTAMP_Pos = 0x0
	// Bit mask of MTIMESTAMP field.
	CAN_MSR4_MTIMESTAMP_Msk = 0xffff
	// Position of MDLC field.
	CAN_MSR4_MDLC_Pos = 0x10
	// Bit mask of MDLC field.
	CAN_MSR4_MDLC_Msk = 0xf0000
	// Position of MRTR field.
	CAN_MSR4_MRTR_Pos = 0x14
	// Bit mask of MRTR field.
	CAN_MSR4_MRTR_Msk = 0x100000
	// Bit MRTR.
	CAN_MSR4_MRTR = 0x100000
	// Position of MABT field.
	CAN_MSR4_MABT_Pos = 0x16
	// Bit mask of MABT field.
	CAN_MSR4_MABT_Msk = 0x400000
	// Bit MABT.
	CAN_MSR4_MABT = 0x400000
	// Position of MRDY field.
	CAN_MSR4_MRDY_Pos = 0x17
	// Bit mask of MRDY field.
	CAN_MSR4_MRDY_Msk = 0x800000
	// Bit MRDY.
	CAN_MSR4_MRDY = 0x800000
	// Position of MMI field.
	CAN_MSR4_MMI_Pos = 0x18
	// Bit mask of MMI field.
	CAN_MSR4_MMI_Msk = 0x1000000
	// Bit MMI.
	CAN_MSR4_MMI = 0x1000000

	// MDL4: Mailbox Data Low Register (MB = 4)
	// Position of MDL field.
	CAN_MDL4_MDL_Pos = 0x0
	// Bit mask of MDL field.
	CAN_MDL4_MDL_Msk = 0xffffffff

	// MDH4: Mailbox Data High Register (MB = 4)
	// Position of MDH field.
	CAN_MDH4_MDH_Pos = 0x0
	// Bit mask of MDH field.
	CAN_MDH4_MDH_Msk = 0xffffffff

	// MCR4: Mailbox Control Register (MB = 4)
	// Position of MDLC field.
	CAN_MCR4_MDLC_Pos = 0x10
	// Bit mask of MDLC field.
	CAN_MCR4_MDLC_Msk = 0xf0000
	// Position of MRTR field.
	CAN_MCR4_MRTR_Pos = 0x14
	// Bit mask of MRTR field.
	CAN_MCR4_MRTR_Msk = 0x100000
	// Bit MRTR.
	CAN_MCR4_MRTR = 0x100000
	// Position of MACR field.
	CAN_MCR4_MACR_Pos = 0x16
	// Bit mask of MACR field.
	CAN_MCR4_MACR_Msk = 0x400000
	// Bit MACR.
	CAN_MCR4_MACR = 0x400000
	// Position of MTCR field.
	CAN_MCR4_MTCR_Pos = 0x17
	// Bit mask of MTCR field.
	CAN_MCR4_MTCR_Msk = 0x800000
	// Bit MTCR.
	CAN_MCR4_MTCR = 0x800000

	// MMR5: Mailbox Mode Register (MB = 5)
	// Position of MTIMEMARK field.
	CAN_MMR5_MTIMEMARK_Pos = 0x0
	// Bit mask of MTIMEMARK field.
	CAN_MMR5_MTIMEMARK_Msk = 0xffff
	// Position of PRIOR field.
	CAN_MMR5_PRIOR_Pos = 0x10
	// Bit mask of PRIOR field.
	CAN_MMR5_PRIOR_Msk = 0xf0000
	// Position of MOT field.
	CAN_MMR5_MOT_Pos = 0x18
	// Bit mask of MOT field.
	CAN_MMR5_MOT_Msk = 0x7000000
	// Mailbox is disabled. This prevents receiving or transmitting any messages with this mailbox.
	CAN_MMR5_MOT_MB_DISABLED = 0x0
	// Reception Mailbox. Mailbox is configured for reception. If a message is received while the mailbox data register is full, it is discarded.
	CAN_MMR5_MOT_MB_RX = 0x1
	// Reception mailbox with overwrite. Mailbox is configured for reception. If a message is received while the mailbox is full, it overwrites the previous message.
	CAN_MMR5_MOT_MB_RX_OVERWRITE = 0x2
	// Transmit mailbox. Mailbox is configured for transmission.
	CAN_MMR5_MOT_MB_TX = 0x3
	// Consumer Mailbox. Mailbox is configured in reception but behaves as a Transmit Mailbox, i.e., it sends a remote frame and waits for an answer.
	CAN_MMR5_MOT_MB_CONSUMER = 0x4
	// Producer Mailbox. Mailbox is configured in transmission but also behaves like a reception mailbox, i.e., it waits to receive a Remote Frame before sending its contents.
	CAN_MMR5_MOT_MB_PRODUCER = 0x5

	// MAM5: Mailbox Acceptance Mask Register (MB = 5)
	// Position of MIDvB field.
	CAN_MAM5_MIDvB_Pos = 0x0
	// Bit mask of MIDvB field.
	CAN_MAM5_MIDvB_Msk = 0x3ffff
	// Position of MIDvA field.
	CAN_MAM5_MIDvA_Pos = 0x12
	// Bit mask of MIDvA field.
	CAN_MAM5_MIDvA_Msk = 0x1ffc0000
	// Position of MIDE field.
	CAN_MAM5_MIDE_Pos = 0x1d
	// Bit mask of MIDE field.
	CAN_MAM5_MIDE_Msk = 0x20000000
	// Bit MIDE.
	CAN_MAM5_MIDE = 0x20000000

	// MID5: Mailbox ID Register (MB = 5)
	// Position of MIDvB field.
	CAN_MID5_MIDvB_Pos = 0x0
	// Bit mask of MIDvB field.
	CAN_MID5_MIDvB_Msk = 0x3ffff
	// Position of MIDvA field.
	CAN_MID5_MIDvA_Pos = 0x12
	// Bit mask of MIDvA field.
	CAN_MID5_MIDvA_Msk = 0x1ffc0000
	// Position of MIDE field.
	CAN_MID5_MIDE_Pos = 0x1d
	// Bit mask of MIDE field.
	CAN_MID5_MIDE_Msk = 0x20000000
	// Bit MIDE.
	CAN_MID5_MIDE = 0x20000000

	// MFID5: Mailbox Family ID Register (MB = 5)
	// Position of MFID field.
	CAN_MFID5_MFID_Pos = 0x0
	// Bit mask of MFID field.
	CAN_MFID5_MFID_Msk = 0x1fffffff

	// MSR5: Mailbox Status Register (MB = 5)
	// Position of MTIMESTAMP field.
	CAN_MSR5_MTIMESTAMP_Pos = 0x0
	// Bit mask of MTIMESTAMP field.
	CAN_MSR5_MTIMESTAMP_Msk = 0xffff
	// Position of MDLC field.
	CAN_MSR5_MDLC_Pos = 0x10
	// Bit mask of MDLC field.
	CAN_MSR5_MDLC_Msk = 0xf0000
	// Position of MRTR field.
	CAN_MSR5_MRTR_Pos = 0x14
	// Bit mask of MRTR field.
	CAN_MSR5_MRTR_Msk = 0x100000
	// Bit MRTR.
	CAN_MSR5_MRTR = 0x100000
	// Position of MABT field.
	CAN_MSR5_MABT_Pos = 0x16
	// Bit mask of MABT field.
	CAN_MSR5_MABT_Msk = 0x400000
	// Bit MABT.
	CAN_MSR5_MABT = 0x400000
	// Position of MRDY field.
	CAN_MSR5_MRDY_Pos = 0x17
	// Bit mask of MRDY field.
	CAN_MSR5_MRDY_Msk = 0x800000
	// Bit MRDY.
	CAN_MSR5_MRDY = 0x800000
	// Position of MMI field.
	CAN_MSR5_MMI_Pos = 0x18
	// Bit mask of MMI field.
	CAN_MSR5_MMI_Msk = 0x1000000
	// Bit MMI.
	CAN_MSR5_MMI = 0x1000000

	// MDL5: Mailbox Data Low Register (MB = 5)
	// Position of MDL field.
	CAN_MDL5_MDL_Pos = 0x0
	// Bit mask of MDL field.
	CAN_MDL5_MDL_Msk = 0xffffffff

	// MDH5: Mailbox Data High Register (MB = 5)
	// Position of MDH field.
	CAN_MDH5_MDH_Pos = 0x0
	// Bit mask of MDH field.
	CAN_MDH5_MDH_Msk = 0xffffffff

	// MCR5: Mailbox Control Register (MB = 5)
	// Position of MDLC field.
	CAN_MCR5_MDLC_Pos = 0x10
	// Bit mask of MDLC field.
	CAN_MCR5_MDLC_Msk = 0xf0000
	// Position of MRTR field.
	CAN_MCR5_MRTR_Pos = 0x14
	// Bit mask of MRTR field.
	CAN_MCR5_MRTR_Msk = 0x100000
	// Bit MRTR.
	CAN_MCR5_MRTR = 0x100000
	// Position of MACR field.
	CAN_MCR5_MACR_Pos = 0x16
	// Bit mask of MACR field.
	CAN_MCR5_MACR_Msk = 0x400000
	// Bit MACR.
	CAN_MCR5_MACR = 0x400000
	// Position of MTCR field.
	CAN_MCR5_MTCR_Pos = 0x17
	// Bit mask of MTCR field.
	CAN_MCR5_MTCR_Msk = 0x800000
	// Bit MTCR.
	CAN_MCR5_MTCR = 0x800000

	// MMR6: Mailbox Mode Register (MB = 6)
	// Position of MTIMEMARK field.
	CAN_MMR6_MTIMEMARK_Pos = 0x0
	// Bit mask of MTIMEMARK field.
	CAN_MMR6_MTIMEMARK_Msk = 0xffff
	// Position of PRIOR field.
	CAN_MMR6_PRIOR_Pos = 0x10
	// Bit mask of PRIOR field.
	CAN_MMR6_PRIOR_Msk = 0xf0000
	// Position of MOT field.
	CAN_MMR6_MOT_Pos = 0x18
	// Bit mask of MOT field.
	CAN_MMR6_MOT_Msk = 0x7000000
	// Mailbox is disabled. This prevents receiving or transmitting any messages with this mailbox.
	CAN_MMR6_MOT_MB_DISABLED = 0x0
	// Reception Mailbox. Mailbox is configured for reception. If a message is received while the mailbox data register is full, it is discarded.
	CAN_MMR6_MOT_MB_RX = 0x1
	// Reception mailbox with overwrite. Mailbox is configured for reception. If a message is received while the mailbox is full, it overwrites the previous message.
	CAN_MMR6_MOT_MB_RX_OVERWRITE = 0x2
	// Transmit mailbox. Mailbox is configured for transmission.
	CAN_MMR6_MOT_MB_TX = 0x3
	// Consumer Mailbox. Mailbox is configured in reception but behaves as a Transmit Mailbox, i.e., it sends a remote frame and waits for an answer.
	CAN_MMR6_MOT_MB_CONSUMER = 0x4
	// Producer Mailbox. Mailbox is configured in transmission but also behaves like a reception mailbox, i.e., it waits to receive a Remote Frame before sending its contents.
	CAN_MMR6_MOT_MB_PRODUCER = 0x5

	// MAM6: Mailbox Acceptance Mask Register (MB = 6)
	// Position of MIDvB field.
	CAN_MAM6_MIDvB_Pos = 0x0
	// Bit mask of MIDvB field.
	CAN_MAM6_MIDvB_Msk = 0x3ffff
	// Position of MIDvA field.
	CAN_MAM6_MIDvA_Pos = 0x12
	// Bit mask of MIDvA field.
	CAN_MAM6_MIDvA_Msk = 0x1ffc0000
	// Position of MIDE field.
	CAN_MAM6_MIDE_Pos = 0x1d
	// Bit mask of MIDE field.
	CAN_MAM6_MIDE_Msk = 0x20000000
	// Bit MIDE.
	CAN_MAM6_MIDE = 0x20000000

	// MID6: Mailbox ID Register (MB = 6)
	// Position of MIDvB field.
	CAN_MID6_MIDvB_Pos = 0x0
	// Bit mask of MIDvB field.
	CAN_MID6_MIDvB_Msk = 0x3ffff
	// Position of MIDvA field.
	CAN_MID6_MIDvA_Pos = 0x12
	// Bit mask of MIDvA field.
	CAN_MID6_MIDvA_Msk = 0x1ffc0000
	// Position of MIDE field.
	CAN_MID6_MIDE_Pos = 0x1d
	// Bit mask of MIDE field.
	CAN_MID6_MIDE_Msk = 0x20000000
	// Bit MIDE.
	CAN_MID6_MIDE = 0x20000000

	// MFID6: Mailbox Family ID Register (MB = 6)
	// Position of MFID field.
	CAN_MFID6_MFID_Pos = 0x0
	// Bit mask of MFID field.
	CAN_MFID6_MFID_Msk = 0x1fffffff

	// MSR6: Mailbox Status Register (MB = 6)
	// Position of MTIMESTAMP field.
	CAN_MSR6_MTIMESTAMP_Pos = 0x0
	// Bit mask of MTIMESTAMP field.
	CAN_MSR6_MTIMESTAMP_Msk = 0xffff
	// Position of MDLC field.
	CAN_MSR6_MDLC_Pos = 0x10
	// Bit mask of MDLC field.
	CAN_MSR6_MDLC_Msk = 0xf0000
	// Position of MRTR field.
	CAN_MSR6_MRTR_Pos = 0x14
	// Bit mask of MRTR field.
	CAN_MSR6_MRTR_Msk = 0x100000
	// Bit MRTR.
	CAN_MSR6_MRTR = 0x100000
	// Position of MABT field.
	CAN_MSR6_MABT_Pos = 0x16
	// Bit mask of MABT field.
	CAN_MSR6_MABT_Msk = 0x400000
	// Bit MABT.
	CAN_MSR6_MABT = 0x400000
	// Position of MRDY field.
	CAN_MSR6_MRDY_Pos = 0x17
	// Bit mask of MRDY field.
	CAN_MSR6_MRDY_Msk = 0x800000
	// Bit MRDY.
	CAN_MSR6_MRDY = 0x800000
	// Position of MMI field.
	CAN_MSR6_MMI_Pos = 0x18
	// Bit mask of MMI field.
	CAN_MSR6_MMI_Msk = 0x1000000
	// Bit MMI.
	CAN_MSR6_MMI = 0x1000000

	// MDL6: Mailbox Data Low Register (MB = 6)
	// Position of MDL field.
	CAN_MDL6_MDL_Pos = 0x0
	// Bit mask of MDL field.
	CAN_MDL6_MDL_Msk = 0xffffffff

	// MDH6: Mailbox Data High Register (MB = 6)
	// Position of MDH field.
	CAN_MDH6_MDH_Pos = 0x0
	// Bit mask of MDH field.
	CAN_MDH6_MDH_Msk = 0xffffffff

	// MCR6: Mailbox Control Register (MB = 6)
	// Position of MDLC field.
	CAN_MCR6_MDLC_Pos = 0x10
	// Bit mask of MDLC field.
	CAN_MCR6_MDLC_Msk = 0xf0000
	// Position of MRTR field.
	CAN_MCR6_MRTR_Pos = 0x14
	// Bit mask of MRTR field.
	CAN_MCR6_MRTR_Msk = 0x100000
	// Bit MRTR.
	CAN_MCR6_MRTR = 0x100000
	// Position of MACR field.
	CAN_MCR6_MACR_Pos = 0x16
	// Bit mask of MACR field.
	CAN_MCR6_MACR_Msk = 0x400000
	// Bit MACR.
	CAN_MCR6_MACR = 0x400000
	// Position of MTCR field.
	CAN_MCR6_MTCR_Pos = 0x17
	// Bit mask of MTCR field.
	CAN_MCR6_MTCR_Msk = 0x800000
	// Bit MTCR.
	CAN_MCR6_MTCR = 0x800000

	// MMR7: Mailbox Mode Register (MB = 7)
	// Position of MTIMEMARK field.
	CAN_MMR7_MTIMEMARK_Pos = 0x0
	// Bit mask of MTIMEMARK field.
	CAN_MMR7_MTIMEMARK_Msk = 0xffff
	// Position of PRIOR field.
	CAN_MMR7_PRIOR_Pos = 0x10
	// Bit mask of PRIOR field.
	CAN_MMR7_PRIOR_Msk = 0xf0000
	// Position of MOT field.
	CAN_MMR7_MOT_Pos = 0x18
	// Bit mask of MOT field.
	CAN_MMR7_MOT_Msk = 0x7000000
	// Mailbox is disabled. This prevents receiving or transmitting any messages with this mailbox.
	CAN_MMR7_MOT_MB_DISABLED = 0x0
	// Reception Mailbox. Mailbox is configured for reception. If a message is received while the mailbox data register is full, it is discarded.
	CAN_MMR7_MOT_MB_RX = 0x1
	// Reception mailbox with overwrite. Mailbox is configured for reception. If a message is received while the mailbox is full, it overwrites the previous message.
	CAN_MMR7_MOT_MB_RX_OVERWRITE = 0x2
	// Transmit mailbox. Mailbox is configured for transmission.
	CAN_MMR7_MOT_MB_TX = 0x3
	// Consumer Mailbox. Mailbox is configured in reception but behaves as a Transmit Mailbox, i.e., it sends a remote frame and waits for an answer.
	CAN_MMR7_MOT_MB_CONSUMER = 0x4
	// Producer Mailbox. Mailbox is configured in transmission but also behaves like a reception mailbox, i.e., it waits to receive a Remote Frame before sending its contents.
	CAN_MMR7_MOT_MB_PRODUCER = 0x5

	// MAM7: Mailbox Acceptance Mask Register (MB = 7)
	// Position of MIDvB field.
	CAN_MAM7_MIDvB_Pos = 0x0
	// Bit mask of MIDvB field.
	CAN_MAM7_MIDvB_Msk = 0x3ffff
	// Position of MIDvA field.
	CAN_MAM7_MIDvA_Pos = 0x12
	// Bit mask of MIDvA field.
	CAN_MAM7_MIDvA_Msk = 0x1ffc0000
	// Position of MIDE field.
	CAN_MAM7_MIDE_Pos = 0x1d
	// Bit mask of MIDE field.
	CAN_MAM7_MIDE_Msk = 0x20000000
	// Bit MIDE.
	CAN_MAM7_MIDE = 0x20000000

	// MID7: Mailbox ID Register (MB = 7)
	// Position of MIDvB field.
	CAN_MID7_MIDvB_Pos = 0x0
	// Bit mask of MIDvB field.
	CAN_MID7_MIDvB_Msk = 0x3ffff
	// Position of MIDvA field.
	CAN_MID7_MIDvA_Pos = 0x12
	// Bit mask of MIDvA field.
	CAN_MID7_MIDvA_Msk = 0x1ffc0000
	// Position of MIDE field.
	CAN_MID7_MIDE_Pos = 0x1d
	// Bit mask of MIDE field.
	CAN_MID7_MIDE_Msk = 0x20000000
	// Bit MIDE.
	CAN_MID7_MIDE = 0x20000000

	// MFID7: Mailbox Family ID Register (MB = 7)
	// Position of MFID field.
	CAN_MFID7_MFID_Pos = 0x0
	// Bit mask of MFID field.
	CAN_MFID7_MFID_Msk = 0x1fffffff

	// MSR7: Mailbox Status Register (MB = 7)
	// Position of MTIMESTAMP field.
	CAN_MSR7_MTIMESTAMP_Pos = 0x0
	// Bit mask of MTIMESTAMP field.
	CAN_MSR7_MTIMESTAMP_Msk = 0xffff
	// Position of MDLC field.
	CAN_MSR7_MDLC_Pos = 0x10
	// Bit mask of MDLC field.
	CAN_MSR7_MDLC_Msk = 0xf0000
	// Position of MRTR field.
	CAN_MSR7_MRTR_Pos = 0x14
	// Bit mask of MRTR field.
	CAN_MSR7_MRTR_Msk = 0x100000
	// Bit MRTR.
	CAN_MSR7_MRTR = 0x100000
	// Position of MABT field.
	CAN_MSR7_MABT_Pos = 0x16
	// Bit mask of MABT field.
	CAN_MSR7_MABT_Msk = 0x400000
	// Bit MABT.
	CAN_MSR7_MABT = 0x400000
	// Position of MRDY field.
	CAN_MSR7_MRDY_Pos = 0x17
	// Bit mask of MRDY field.
	CAN_MSR7_MRDY_Msk = 0x800000
	// Bit MRDY.
	CAN_MSR7_MRDY = 0x800000
	// Position of MMI field.
	CAN_MSR7_MMI_Pos = 0x18
	// Bit mask of MMI field.
	CAN_MSR7_MMI_Msk = 0x1000000
	// Bit MMI.
	CAN_MSR7_MMI = 0x1000000

	// MDL7: Mailbox Data Low Register (MB = 7)
	// Position of MDL field.
	CAN_MDL7_MDL_Pos = 0x0
	// Bit mask of MDL field.
	CAN_MDL7_MDL_Msk = 0xffffffff

	// MDH7: Mailbox Data High Register (MB = 7)
	// Position of MDH field.
	CAN_MDH7_MDH_Pos = 0x0
	// Bit mask of MDH field.
	CAN_MDH7_MDH_Msk = 0xffffffff

	// MCR7: Mailbox Control Register (MB = 7)
	// Position of MDLC field.
	CAN_MCR7_MDLC_Pos = 0x10
	// Bit mask of MDLC field.
	CAN_MCR7_MDLC_Msk = 0xf0000
	// Position of MRTR field.
	CAN_MCR7_MRTR_Pos = 0x14
	// Bit mask of MRTR field.
	CAN_MCR7_MRTR_Msk = 0x100000
	// Bit MRTR.
	CAN_MCR7_MRTR = 0x100000
	// Position of MACR field.
	CAN_MCR7_MACR_Pos = 0x16
	// Bit mask of MACR field.
	CAN_MCR7_MACR_Msk = 0x400000
	// Bit MACR.
	CAN_MCR7_MACR = 0x400000
	// Position of MTCR field.
	CAN_MCR7_MTCR_Pos = 0x17
	// Bit mask of MTCR field.
	CAN_MCR7_MTCR_Msk = 0x800000
	// Bit MTCR.
	CAN_MCR7_MTCR = 0x800000
)

// Bitfields for TRNG: True Random Number Generator
const (
	// CR: Control Register
	// Position of ENABLE field.
	TRNG_CR_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	TRNG_CR_ENABLE_Msk = 0x1
	// Bit ENABLE.
	TRNG_CR_ENABLE = 0x1
	// Position of KEY field.
	TRNG_CR_KEY_Pos = 0x8
	// Bit mask of KEY field.
	TRNG_CR_KEY_Msk = 0xffffff00

	// IER: Interrupt Enable Register
	// Position of DATRDY field.
	TRNG_IER_DATRDY_Pos = 0x0
	// Bit mask of DATRDY field.
	TRNG_IER_DATRDY_Msk = 0x1
	// Bit DATRDY.
	TRNG_IER_DATRDY = 0x1

	// IDR: Interrupt Disable Register
	// Position of DATRDY field.
	TRNG_IDR_DATRDY_Pos = 0x0
	// Bit mask of DATRDY field.
	TRNG_IDR_DATRDY_Msk = 0x1
	// Bit DATRDY.
	TRNG_IDR_DATRDY = 0x1

	// IMR: Interrupt Mask Register
	// Position of DATRDY field.
	TRNG_IMR_DATRDY_Pos = 0x0
	// Bit mask of DATRDY field.
	TRNG_IMR_DATRDY_Msk = 0x1
	// Bit DATRDY.
	TRNG_IMR_DATRDY = 0x1

	// ISR: Interrupt Status Register
	// Position of DATRDY field.
	TRNG_ISR_DATRDY_Pos = 0x0
	// Bit mask of DATRDY field.
	TRNG_ISR_DATRDY_Msk = 0x1
	// Bit DATRDY.
	TRNG_ISR_DATRDY = 0x1

	// ODATA: Output Data Register
	// Position of ODATA field.
	TRNG_ODATA_ODATA_Pos = 0x0
	// Bit mask of ODATA field.
	TRNG_ODATA_ODATA_Msk = 0xffffffff
)

// Bitfields for ADC: Analog-to-Digital Converter
const (
	// CR: Control Register
	// Position of SWRST field.
	ADC_CR_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	ADC_CR_SWRST_Msk = 0x1
	// Bit SWRST.
	ADC_CR_SWRST = 0x1
	// Position of START field.
	ADC_CR_START_Pos = 0x1
	// Bit mask of START field.
	ADC_CR_START_Msk = 0x2
	// Bit START.
	ADC_CR_START = 0x2

	// MR: Mode Register
	// Position of TRGEN field.
	ADC_MR_TRGEN_Pos = 0x0
	// Bit mask of TRGEN field.
	ADC_MR_TRGEN_Msk = 0x1
	// Bit TRGEN.
	ADC_MR_TRGEN = 0x1
	// Hardware triggers are disabled. Starting a conversion is only possible by software.
	ADC_MR_TRGEN_DIS = 0x0
	// Hardware trigger selected by TRGSEL field is enabled.
	ADC_MR_TRGEN_EN = 0x1
	// Position of TRGSEL field.
	ADC_MR_TRGSEL_Pos = 0x1
	// Bit mask of TRGSEL field.
	ADC_MR_TRGSEL_Msk = 0xe
	// External : ADCTRG
	ADC_MR_TRGSEL_ADC_TRIG0 = 0x0
	// TIOA Output of the Timer Counter Channel 0
	ADC_MR_TRGSEL_ADC_TRIG1 = 0x1
	// TIOA Output of the Timer Counter Channel 1
	ADC_MR_TRGSEL_ADC_TRIG2 = 0x2
	// TIOA Output of the Timer Counter Channel 2
	ADC_MR_TRGSEL_ADC_TRIG3 = 0x3
	// PWM Event Line 0
	ADC_MR_TRGSEL_ADC_TRIG4 = 0x4
	// PWM Event Line 0
	ADC_MR_TRGSEL_ADC_TRIG5 = 0x5
	// Position of SLEEP field.
	ADC_MR_SLEEP_Pos = 0x5
	// Bit mask of SLEEP field.
	ADC_MR_SLEEP_Msk = 0x20
	// Bit SLEEP.
	ADC_MR_SLEEP = 0x20
	// Normal Mode: The ADC Core and reference voltage circuitry are kept ON between conversions
	ADC_MR_SLEEP_NORMAL = 0x0
	// Sleep Mode: The wake-up time can be modified by programming FWUP bit
	ADC_MR_SLEEP_SLEEP = 0x1
	// Position of FWUP field.
	ADC_MR_FWUP_Pos = 0x6
	// Bit mask of FWUP field.
	ADC_MR_FWUP_Msk = 0x40
	// Bit FWUP.
	ADC_MR_FWUP = 0x40
	// If SLEEP is 1 then both ADC Core and reference voltage circuitry are OFF between conversions
	ADC_MR_FWUP_OFF = 0x0
	// If SLEEP is 1 then Fast Wake-up Sleep Mode: The Voltage reference is ON between conversions and ADC Core is OFF
	ADC_MR_FWUP_ON = 0x1
	// Position of FREERUN field.
	ADC_MR_FREERUN_Pos = 0x7
	// Bit mask of FREERUN field.
	ADC_MR_FREERUN_Msk = 0x80
	// Bit FREERUN.
	ADC_MR_FREERUN = 0x80
	// Normal Mode
	ADC_MR_FREERUN_OFF = 0x0
	// Free Run Mode: Never wait for any trigger.
	ADC_MR_FREERUN_ON = 0x1
	// Position of PRESCAL field.
	ADC_MR_PRESCAL_Pos = 0x8
	// Bit mask of PRESCAL field.
	ADC_MR_PRESCAL_Msk = 0xff00
	// Position of STARTUP field.
	ADC_MR_STARTUP_Pos = 0x10
	// Bit mask of STARTUP field.
	ADC_MR_STARTUP_Msk = 0xf0000
	// 0 periods of ADCClock
	ADC_MR_STARTUP_SUT0 = 0x0
	// 8 periods of ADCClock
	ADC_MR_STARTUP_SUT8 = 0x1
	// 16 periods of ADCClock
	ADC_MR_STARTUP_SUT16 = 0x2
	// 24 periods of ADCClock
	ADC_MR_STARTUP_SUT24 = 0x3
	// 64 periods of ADCClock
	ADC_MR_STARTUP_SUT64 = 0x4
	// 80 periods of ADCClock
	ADC_MR_STARTUP_SUT80 = 0x5
	// 96 periods of ADCClock
	ADC_MR_STARTUP_SUT96 = 0x6
	// 112 periods of ADCClock
	ADC_MR_STARTUP_SUT112 = 0x7
	// 512 periods of ADCClock
	ADC_MR_STARTUP_SUT512 = 0x8
	// 576 periods of ADCClock
	ADC_MR_STARTUP_SUT576 = 0x9
	// 640 periods of ADCClock
	ADC_MR_STARTUP_SUT640 = 0xa
	// 704 periods of ADCClock
	ADC_MR_STARTUP_SUT704 = 0xb
	// 768 periods of ADCClock
	ADC_MR_STARTUP_SUT768 = 0xc
	// 832 periods of ADCClock
	ADC_MR_STARTUP_SUT832 = 0xd
	// 896 periods of ADCClock
	ADC_MR_STARTUP_SUT896 = 0xe
	// 960 periods of ADCClock
	ADC_MR_STARTUP_SUT960 = 0xf
	// Position of SETTLING field.
	ADC_MR_SETTLING_Pos = 0x14
	// Bit mask of SETTLING field.
	ADC_MR_SETTLING_Msk = 0x300000
	// 3 periods of ADCClock
	ADC_MR_SETTLING_AST3 = 0x0
	// 5 periods of ADCClock
	ADC_MR_SETTLING_AST5 = 0x1
	// 9 periods of ADCClock
	ADC_MR_SETTLING_AST9 = 0x2
	// 17 periods of ADCClock
	ADC_MR_SETTLING_AST17 = 0x3
	// Position of ANACH field.
	ADC_MR_ANACH_Pos = 0x17
	// Bit mask of ANACH field.
	ADC_MR_ANACH_Msk = 0x800000
	// Bit ANACH.
	ADC_MR_ANACH = 0x800000
	// No analog change on channel switching: DIFF0, GAIN0 and OFF0 are used for all channels
	ADC_MR_ANACH_NONE = 0x0
	// Allows different analog settings for each channel. See ADC_CGR and ADC_COR Registers
	ADC_MR_ANACH_ALLOWED = 0x1
	// Position of TRACKTIM field.
	ADC_MR_TRACKTIM_Pos = 0x18
	// Bit mask of TRACKTIM field.
	ADC_MR_TRACKTIM_Msk = 0xf000000
	// Position of TRANSFER field.
	ADC_MR_TRANSFER_Pos = 0x1c
	// Bit mask of TRANSFER field.
	ADC_MR_TRANSFER_Msk = 0x30000000
	// Position of USEQ field.
	ADC_MR_USEQ_Pos = 0x1f
	// Bit mask of USEQ field.
	ADC_MR_USEQ_Msk = 0x80000000
	// Bit USEQ.
	ADC_MR_USEQ = 0x80000000
	// Normal Mode: The controller converts channels in a simple numeric order depending only on the channel index.
	ADC_MR_USEQ_NUM_ORDER = 0x0
	// User Sequence Mode: The sequence respects what is defined in ADC_SEQR1 and ADC_SEQR2 registers and can be used to convert several times the same channel.
	ADC_MR_USEQ_REG_ORDER = 0x1

	// SEQR1: Channel Sequence Register 1
	// Position of USCH1 field.
	ADC_SEQR1_USCH1_Pos = 0x0
	// Bit mask of USCH1 field.
	ADC_SEQR1_USCH1_Msk = 0xf
	// Position of USCH2 field.
	ADC_SEQR1_USCH2_Pos = 0x4
	// Bit mask of USCH2 field.
	ADC_SEQR1_USCH2_Msk = 0xf0
	// Position of USCH3 field.
	ADC_SEQR1_USCH3_Pos = 0x8
	// Bit mask of USCH3 field.
	ADC_SEQR1_USCH3_Msk = 0xf00
	// Position of USCH4 field.
	ADC_SEQR1_USCH4_Pos = 0xc
	// Bit mask of USCH4 field.
	ADC_SEQR1_USCH4_Msk = 0xf000
	// Position of USCH5 field.
	ADC_SEQR1_USCH5_Pos = 0x10
	// Bit mask of USCH5 field.
	ADC_SEQR1_USCH5_Msk = 0xf0000
	// Position of USCH6 field.
	ADC_SEQR1_USCH6_Pos = 0x14
	// Bit mask of USCH6 field.
	ADC_SEQR1_USCH6_Msk = 0xf00000
	// Position of USCH7 field.
	ADC_SEQR1_USCH7_Pos = 0x18
	// Bit mask of USCH7 field.
	ADC_SEQR1_USCH7_Msk = 0xf000000
	// Position of USCH8 field.
	ADC_SEQR1_USCH8_Pos = 0x1c
	// Bit mask of USCH8 field.
	ADC_SEQR1_USCH8_Msk = 0xf0000000

	// SEQR2: Channel Sequence Register 2
	// Position of USCH9 field.
	ADC_SEQR2_USCH9_Pos = 0x0
	// Bit mask of USCH9 field.
	ADC_SEQR2_USCH9_Msk = 0xf
	// Position of USCH10 field.
	ADC_SEQR2_USCH10_Pos = 0x4
	// Bit mask of USCH10 field.
	ADC_SEQR2_USCH10_Msk = 0xf0
	// Position of USCH11 field.
	ADC_SEQR2_USCH11_Pos = 0x8
	// Bit mask of USCH11 field.
	ADC_SEQR2_USCH11_Msk = 0xf00
	// Position of USCH12 field.
	ADC_SEQR2_USCH12_Pos = 0xc
	// Bit mask of USCH12 field.
	ADC_SEQR2_USCH12_Msk = 0xf000
	// Position of USCH13 field.
	ADC_SEQR2_USCH13_Pos = 0x10
	// Bit mask of USCH13 field.
	ADC_SEQR2_USCH13_Msk = 0xf0000
	// Position of USCH14 field.
	ADC_SEQR2_USCH14_Pos = 0x14
	// Bit mask of USCH14 field.
	ADC_SEQR2_USCH14_Msk = 0xf00000
	// Position of USCH15 field.
	ADC_SEQR2_USCH15_Pos = 0x18
	// Bit mask of USCH15 field.
	ADC_SEQR2_USCH15_Msk = 0xf000000

	// CHER: Channel Enable Register
	// Position of CH0 field.
	ADC_CHER_CH0_Pos = 0x0
	// Bit mask of CH0 field.
	ADC_CHER_CH0_Msk = 0x1
	// Bit CH0.
	ADC_CHER_CH0 = 0x1
	// Position of CH1 field.
	ADC_CHER_CH1_Pos = 0x1
	// Bit mask of CH1 field.
	ADC_CHER_CH1_Msk = 0x2
	// Bit CH1.
	ADC_CHER_CH1 = 0x2
	// Position of CH2 field.
	ADC_CHER_CH2_Pos = 0x2
	// Bit mask of CH2 field.
	ADC_CHER_CH2_Msk = 0x4
	// Bit CH2.
	ADC_CHER_CH2 = 0x4
	// Position of CH3 field.
	ADC_CHER_CH3_Pos = 0x3
	// Bit mask of CH3 field.
	ADC_CHER_CH3_Msk = 0x8
	// Bit CH3.
	ADC_CHER_CH3 = 0x8
	// Position of CH4 field.
	ADC_CHER_CH4_Pos = 0x4
	// Bit mask of CH4 field.
	ADC_CHER_CH4_Msk = 0x10
	// Bit CH4.
	ADC_CHER_CH4 = 0x10
	// Position of CH5 field.
	ADC_CHER_CH5_Pos = 0x5
	// Bit mask of CH5 field.
	ADC_CHER_CH5_Msk = 0x20
	// Bit CH5.
	ADC_CHER_CH5 = 0x20
	// Position of CH6 field.
	ADC_CHER_CH6_Pos = 0x6
	// Bit mask of CH6 field.
	ADC_CHER_CH6_Msk = 0x40
	// Bit CH6.
	ADC_CHER_CH6 = 0x40
	// Position of CH7 field.
	ADC_CHER_CH7_Pos = 0x7
	// Bit mask of CH7 field.
	ADC_CHER_CH7_Msk = 0x80
	// Bit CH7.
	ADC_CHER_CH7 = 0x80
	// Position of CH8 field.
	ADC_CHER_CH8_Pos = 0x8
	// Bit mask of CH8 field.
	ADC_CHER_CH8_Msk = 0x100
	// Bit CH8.
	ADC_CHER_CH8 = 0x100
	// Position of CH9 field.
	ADC_CHER_CH9_Pos = 0x9
	// Bit mask of CH9 field.
	ADC_CHER_CH9_Msk = 0x200
	// Bit CH9.
	ADC_CHER_CH9 = 0x200
	// Position of CH10 field.
	ADC_CHER_CH10_Pos = 0xa
	// Bit mask of CH10 field.
	ADC_CHER_CH10_Msk = 0x400
	// Bit CH10.
	ADC_CHER_CH10 = 0x400
	// Position of CH11 field.
	ADC_CHER_CH11_Pos = 0xb
	// Bit mask of CH11 field.
	ADC_CHER_CH11_Msk = 0x800
	// Bit CH11.
	ADC_CHER_CH11 = 0x800
	// Position of CH12 field.
	ADC_CHER_CH12_Pos = 0xc
	// Bit mask of CH12 field.
	ADC_CHER_CH12_Msk = 0x1000
	// Bit CH12.
	ADC_CHER_CH12 = 0x1000
	// Position of CH13 field.
	ADC_CHER_CH13_Pos = 0xd
	// Bit mask of CH13 field.
	ADC_CHER_CH13_Msk = 0x2000
	// Bit CH13.
	ADC_CHER_CH13 = 0x2000
	// Position of CH14 field.
	ADC_CHER_CH14_Pos = 0xe
	// Bit mask of CH14 field.
	ADC_CHER_CH14_Msk = 0x4000
	// Bit CH14.
	ADC_CHER_CH14 = 0x4000
	// Position of CH15 field.
	ADC_CHER_CH15_Pos = 0xf
	// Bit mask of CH15 field.
	ADC_CHER_CH15_Msk = 0x8000
	// Bit CH15.
	ADC_CHER_CH15 = 0x8000

	// CHDR: Channel Disable Register
	// Position of CH0 field.
	ADC_CHDR_CH0_Pos = 0x0
	// Bit mask of CH0 field.
	ADC_CHDR_CH0_Msk = 0x1
	// Bit CH0.
	ADC_CHDR_CH0 = 0x1
	// Position of CH1 field.
	ADC_CHDR_CH1_Pos = 0x1
	// Bit mask of CH1 field.
	ADC_CHDR_CH1_Msk = 0x2
	// Bit CH1.
	ADC_CHDR_CH1 = 0x2
	// Position of CH2 field.
	ADC_CHDR_CH2_Pos = 0x2
	// Bit mask of CH2 field.
	ADC_CHDR_CH2_Msk = 0x4
	// Bit CH2.
	ADC_CHDR_CH2 = 0x4
	// Position of CH3 field.
	ADC_CHDR_CH3_Pos = 0x3
	// Bit mask of CH3 field.
	ADC_CHDR_CH3_Msk = 0x8
	// Bit CH3.
	ADC_CHDR_CH3 = 0x8
	// Position of CH4 field.
	ADC_CHDR_CH4_Pos = 0x4
	// Bit mask of CH4 field.
	ADC_CHDR_CH4_Msk = 0x10
	// Bit CH4.
	ADC_CHDR_CH4 = 0x10
	// Position of CH5 field.
	ADC_CHDR_CH5_Pos = 0x5
	// Bit mask of CH5 field.
	ADC_CHDR_CH5_Msk = 0x20
	// Bit CH5.
	ADC_CHDR_CH5 = 0x20
	// Position of CH6 field.
	ADC_CHDR_CH6_Pos = 0x6
	// Bit mask of CH6 field.
	ADC_CHDR_CH6_Msk = 0x40
	// Bit CH6.
	ADC_CHDR_CH6 = 0x40
	// Position of CH7 field.
	ADC_CHDR_CH7_Pos = 0x7
	// Bit mask of CH7 field.
	ADC_CHDR_CH7_Msk = 0x80
	// Bit CH7.
	ADC_CHDR_CH7 = 0x80
	// Position of CH8 field.
	ADC_CHDR_CH8_Pos = 0x8
	// Bit mask of CH8 field.
	ADC_CHDR_CH8_Msk = 0x100
	// Bit CH8.
	ADC_CHDR_CH8 = 0x100
	// Position of CH9 field.
	ADC_CHDR_CH9_Pos = 0x9
	// Bit mask of CH9 field.
	ADC_CHDR_CH9_Msk = 0x200
	// Bit CH9.
	ADC_CHDR_CH9 = 0x200
	// Position of CH10 field.
	ADC_CHDR_CH10_Pos = 0xa
	// Bit mask of CH10 field.
	ADC_CHDR_CH10_Msk = 0x400
	// Bit CH10.
	ADC_CHDR_CH10 = 0x400
	// Position of CH11 field.
	ADC_CHDR_CH11_Pos = 0xb
	// Bit mask of CH11 field.
	ADC_CHDR_CH11_Msk = 0x800
	// Bit CH11.
	ADC_CHDR_CH11 = 0x800
	// Position of CH12 field.
	ADC_CHDR_CH12_Pos = 0xc
	// Bit mask of CH12 field.
	ADC_CHDR_CH12_Msk = 0x1000
	// Bit CH12.
	ADC_CHDR_CH12 = 0x1000
	// Position of CH13 field.
	ADC_CHDR_CH13_Pos = 0xd
	// Bit mask of CH13 field.
	ADC_CHDR_CH13_Msk = 0x2000
	// Bit CH13.
	ADC_CHDR_CH13 = 0x2000
	// Position of CH14 field.
	ADC_CHDR_CH14_Pos = 0xe
	// Bit mask of CH14 field.
	ADC_CHDR_CH14_Msk = 0x4000
	// Bit CH14.
	ADC_CHDR_CH14 = 0x4000
	// Position of CH15 field.
	ADC_CHDR_CH15_Pos = 0xf
	// Bit mask of CH15 field.
	ADC_CHDR_CH15_Msk = 0x8000
	// Bit CH15.
	ADC_CHDR_CH15 = 0x8000

	// CHSR: Channel Status Register
	// Position of CH0 field.
	ADC_CHSR_CH0_Pos = 0x0
	// Bit mask of CH0 field.
	ADC_CHSR_CH0_Msk = 0x1
	// Bit CH0.
	ADC_CHSR_CH0 = 0x1
	// Position of CH1 field.
	ADC_CHSR_CH1_Pos = 0x1
	// Bit mask of CH1 field.
	ADC_CHSR_CH1_Msk = 0x2
	// Bit CH1.
	ADC_CHSR_CH1 = 0x2
	// Position of CH2 field.
	ADC_CHSR_CH2_Pos = 0x2
	// Bit mask of CH2 field.
	ADC_CHSR_CH2_Msk = 0x4
	// Bit CH2.
	ADC_CHSR_CH2 = 0x4
	// Position of CH3 field.
	ADC_CHSR_CH3_Pos = 0x3
	// Bit mask of CH3 field.
	ADC_CHSR_CH3_Msk = 0x8
	// Bit CH3.
	ADC_CHSR_CH3 = 0x8
	// Position of CH4 field.
	ADC_CHSR_CH4_Pos = 0x4
	// Bit mask of CH4 field.
	ADC_CHSR_CH4_Msk = 0x10
	// Bit CH4.
	ADC_CHSR_CH4 = 0x10
	// Position of CH5 field.
	ADC_CHSR_CH5_Pos = 0x5
	// Bit mask of CH5 field.
	ADC_CHSR_CH5_Msk = 0x20
	// Bit CH5.
	ADC_CHSR_CH5 = 0x20
	// Position of CH6 field.
	ADC_CHSR_CH6_Pos = 0x6
	// Bit mask of CH6 field.
	ADC_CHSR_CH6_Msk = 0x40
	// Bit CH6.
	ADC_CHSR_CH6 = 0x40
	// Position of CH7 field.
	ADC_CHSR_CH7_Pos = 0x7
	// Bit mask of CH7 field.
	ADC_CHSR_CH7_Msk = 0x80
	// Bit CH7.
	ADC_CHSR_CH7 = 0x80
	// Position of CH8 field.
	ADC_CHSR_CH8_Pos = 0x8
	// Bit mask of CH8 field.
	ADC_CHSR_CH8_Msk = 0x100
	// Bit CH8.
	ADC_CHSR_CH8 = 0x100
	// Position of CH9 field.
	ADC_CHSR_CH9_Pos = 0x9
	// Bit mask of CH9 field.
	ADC_CHSR_CH9_Msk = 0x200
	// Bit CH9.
	ADC_CHSR_CH9 = 0x200
	// Position of CH10 field.
	ADC_CHSR_CH10_Pos = 0xa
	// Bit mask of CH10 field.
	ADC_CHSR_CH10_Msk = 0x400
	// Bit CH10.
	ADC_CHSR_CH10 = 0x400
	// Position of CH11 field.
	ADC_CHSR_CH11_Pos = 0xb
	// Bit mask of CH11 field.
	ADC_CHSR_CH11_Msk = 0x800
	// Bit CH11.
	ADC_CHSR_CH11 = 0x800
	// Position of CH12 field.
	ADC_CHSR_CH12_Pos = 0xc
	// Bit mask of CH12 field.
	ADC_CHSR_CH12_Msk = 0x1000
	// Bit CH12.
	ADC_CHSR_CH12 = 0x1000
	// Position of CH13 field.
	ADC_CHSR_CH13_Pos = 0xd
	// Bit mask of CH13 field.
	ADC_CHSR_CH13_Msk = 0x2000
	// Bit CH13.
	ADC_CHSR_CH13 = 0x2000
	// Position of CH14 field.
	ADC_CHSR_CH14_Pos = 0xe
	// Bit mask of CH14 field.
	ADC_CHSR_CH14_Msk = 0x4000
	// Bit CH14.
	ADC_CHSR_CH14 = 0x4000
	// Position of CH15 field.
	ADC_CHSR_CH15_Pos = 0xf
	// Bit mask of CH15 field.
	ADC_CHSR_CH15_Msk = 0x8000
	// Bit CH15.
	ADC_CHSR_CH15 = 0x8000

	// LCDR: Last Converted Data Register
	// Position of LDATA field.
	ADC_LCDR_LDATA_Pos = 0x0
	// Bit mask of LDATA field.
	ADC_LCDR_LDATA_Msk = 0xfff
	// Position of CHNB field.
	ADC_LCDR_CHNB_Pos = 0xc
	// Bit mask of CHNB field.
	ADC_LCDR_CHNB_Msk = 0xf000

	// IER: Interrupt Enable Register
	// Position of EOC0 field.
	ADC_IER_EOC0_Pos = 0x0
	// Bit mask of EOC0 field.
	ADC_IER_EOC0_Msk = 0x1
	// Bit EOC0.
	ADC_IER_EOC0 = 0x1
	// Position of EOC1 field.
	ADC_IER_EOC1_Pos = 0x1
	// Bit mask of EOC1 field.
	ADC_IER_EOC1_Msk = 0x2
	// Bit EOC1.
	ADC_IER_EOC1 = 0x2
	// Position of EOC2 field.
	ADC_IER_EOC2_Pos = 0x2
	// Bit mask of EOC2 field.
	ADC_IER_EOC2_Msk = 0x4
	// Bit EOC2.
	ADC_IER_EOC2 = 0x4
	// Position of EOC3 field.
	ADC_IER_EOC3_Pos = 0x3
	// Bit mask of EOC3 field.
	ADC_IER_EOC3_Msk = 0x8
	// Bit EOC3.
	ADC_IER_EOC3 = 0x8
	// Position of EOC4 field.
	ADC_IER_EOC4_Pos = 0x4
	// Bit mask of EOC4 field.
	ADC_IER_EOC4_Msk = 0x10
	// Bit EOC4.
	ADC_IER_EOC4 = 0x10
	// Position of EOC5 field.
	ADC_IER_EOC5_Pos = 0x5
	// Bit mask of EOC5 field.
	ADC_IER_EOC5_Msk = 0x20
	// Bit EOC5.
	ADC_IER_EOC5 = 0x20
	// Position of EOC6 field.
	ADC_IER_EOC6_Pos = 0x6
	// Bit mask of EOC6 field.
	ADC_IER_EOC6_Msk = 0x40
	// Bit EOC6.
	ADC_IER_EOC6 = 0x40
	// Position of EOC7 field.
	ADC_IER_EOC7_Pos = 0x7
	// Bit mask of EOC7 field.
	ADC_IER_EOC7_Msk = 0x80
	// Bit EOC7.
	ADC_IER_EOC7 = 0x80
	// Position of EOC8 field.
	ADC_IER_EOC8_Pos = 0x8
	// Bit mask of EOC8 field.
	ADC_IER_EOC8_Msk = 0x100
	// Bit EOC8.
	ADC_IER_EOC8 = 0x100
	// Position of EOC9 field.
	ADC_IER_EOC9_Pos = 0x9
	// Bit mask of EOC9 field.
	ADC_IER_EOC9_Msk = 0x200
	// Bit EOC9.
	ADC_IER_EOC9 = 0x200
	// Position of EOC10 field.
	ADC_IER_EOC10_Pos = 0xa
	// Bit mask of EOC10 field.
	ADC_IER_EOC10_Msk = 0x400
	// Bit EOC10.
	ADC_IER_EOC10 = 0x400
	// Position of EOC11 field.
	ADC_IER_EOC11_Pos = 0xb
	// Bit mask of EOC11 field.
	ADC_IER_EOC11_Msk = 0x800
	// Bit EOC11.
	ADC_IER_EOC11 = 0x800
	// Position of EOC12 field.
	ADC_IER_EOC12_Pos = 0xc
	// Bit mask of EOC12 field.
	ADC_IER_EOC12_Msk = 0x1000
	// Bit EOC12.
	ADC_IER_EOC12 = 0x1000
	// Position of EOC13 field.
	ADC_IER_EOC13_Pos = 0xd
	// Bit mask of EOC13 field.
	ADC_IER_EOC13_Msk = 0x2000
	// Bit EOC13.
	ADC_IER_EOC13 = 0x2000
	// Position of EOC14 field.
	ADC_IER_EOC14_Pos = 0xe
	// Bit mask of EOC14 field.
	ADC_IER_EOC14_Msk = 0x4000
	// Bit EOC14.
	ADC_IER_EOC14 = 0x4000
	// Position of EOC15 field.
	ADC_IER_EOC15_Pos = 0xf
	// Bit mask of EOC15 field.
	ADC_IER_EOC15_Msk = 0x8000
	// Bit EOC15.
	ADC_IER_EOC15 = 0x8000
	// Position of DRDY field.
	ADC_IER_DRDY_Pos = 0x18
	// Bit mask of DRDY field.
	ADC_IER_DRDY_Msk = 0x1000000
	// Bit DRDY.
	ADC_IER_DRDY = 0x1000000
	// Position of GOVRE field.
	ADC_IER_GOVRE_Pos = 0x19
	// Bit mask of GOVRE field.
	ADC_IER_GOVRE_Msk = 0x2000000
	// Bit GOVRE.
	ADC_IER_GOVRE = 0x2000000
	// Position of COMPE field.
	ADC_IER_COMPE_Pos = 0x1a
	// Bit mask of COMPE field.
	ADC_IER_COMPE_Msk = 0x4000000
	// Bit COMPE.
	ADC_IER_COMPE = 0x4000000
	// Position of ENDRX field.
	ADC_IER_ENDRX_Pos = 0x1b
	// Bit mask of ENDRX field.
	ADC_IER_ENDRX_Msk = 0x8000000
	// Bit ENDRX.
	ADC_IER_ENDRX = 0x8000000
	// Position of RXBUFF field.
	ADC_IER_RXBUFF_Pos = 0x1c
	// Bit mask of RXBUFF field.
	ADC_IER_RXBUFF_Msk = 0x10000000
	// Bit RXBUFF.
	ADC_IER_RXBUFF = 0x10000000

	// IDR: Interrupt Disable Register
	// Position of EOC0 field.
	ADC_IDR_EOC0_Pos = 0x0
	// Bit mask of EOC0 field.
	ADC_IDR_EOC0_Msk = 0x1
	// Bit EOC0.
	ADC_IDR_EOC0 = 0x1
	// Position of EOC1 field.
	ADC_IDR_EOC1_Pos = 0x1
	// Bit mask of EOC1 field.
	ADC_IDR_EOC1_Msk = 0x2
	// Bit EOC1.
	ADC_IDR_EOC1 = 0x2
	// Position of EOC2 field.
	ADC_IDR_EOC2_Pos = 0x2
	// Bit mask of EOC2 field.
	ADC_IDR_EOC2_Msk = 0x4
	// Bit EOC2.
	ADC_IDR_EOC2 = 0x4
	// Position of EOC3 field.
	ADC_IDR_EOC3_Pos = 0x3
	// Bit mask of EOC3 field.
	ADC_IDR_EOC3_Msk = 0x8
	// Bit EOC3.
	ADC_IDR_EOC3 = 0x8
	// Position of EOC4 field.
	ADC_IDR_EOC4_Pos = 0x4
	// Bit mask of EOC4 field.
	ADC_IDR_EOC4_Msk = 0x10
	// Bit EOC4.
	ADC_IDR_EOC4 = 0x10
	// Position of EOC5 field.
	ADC_IDR_EOC5_Pos = 0x5
	// Bit mask of EOC5 field.
	ADC_IDR_EOC5_Msk = 0x20
	// Bit EOC5.
	ADC_IDR_EOC5 = 0x20
	// Position of EOC6 field.
	ADC_IDR_EOC6_Pos = 0x6
	// Bit mask of EOC6 field.
	ADC_IDR_EOC6_Msk = 0x40
	// Bit EOC6.
	ADC_IDR_EOC6 = 0x40
	// Position of EOC7 field.
	ADC_IDR_EOC7_Pos = 0x7
	// Bit mask of EOC7 field.
	ADC_IDR_EOC7_Msk = 0x80
	// Bit EOC7.
	ADC_IDR_EOC7 = 0x80
	// Position of EOC8 field.
	ADC_IDR_EOC8_Pos = 0x8
	// Bit mask of EOC8 field.
	ADC_IDR_EOC8_Msk = 0x100
	// Bit EOC8.
	ADC_IDR_EOC8 = 0x100
	// Position of EOC9 field.
	ADC_IDR_EOC9_Pos = 0x9
	// Bit mask of EOC9 field.
	ADC_IDR_EOC9_Msk = 0x200
	// Bit EOC9.
	ADC_IDR_EOC9 = 0x200
	// Position of EOC10 field.
	ADC_IDR_EOC10_Pos = 0xa
	// Bit mask of EOC10 field.
	ADC_IDR_EOC10_Msk = 0x400
	// Bit EOC10.
	ADC_IDR_EOC10 = 0x400
	// Position of EOC11 field.
	ADC_IDR_EOC11_Pos = 0xb
	// Bit mask of EOC11 field.
	ADC_IDR_EOC11_Msk = 0x800
	// Bit EOC11.
	ADC_IDR_EOC11 = 0x800
	// Position of EOC12 field.
	ADC_IDR_EOC12_Pos = 0xc
	// Bit mask of EOC12 field.
	ADC_IDR_EOC12_Msk = 0x1000
	// Bit EOC12.
	ADC_IDR_EOC12 = 0x1000
	// Position of EOC13 field.
	ADC_IDR_EOC13_Pos = 0xd
	// Bit mask of EOC13 field.
	ADC_IDR_EOC13_Msk = 0x2000
	// Bit EOC13.
	ADC_IDR_EOC13 = 0x2000
	// Position of EOC14 field.
	ADC_IDR_EOC14_Pos = 0xe
	// Bit mask of EOC14 field.
	ADC_IDR_EOC14_Msk = 0x4000
	// Bit EOC14.
	ADC_IDR_EOC14 = 0x4000
	// Position of EOC15 field.
	ADC_IDR_EOC15_Pos = 0xf
	// Bit mask of EOC15 field.
	ADC_IDR_EOC15_Msk = 0x8000
	// Bit EOC15.
	ADC_IDR_EOC15 = 0x8000
	// Position of DRDY field.
	ADC_IDR_DRDY_Pos = 0x18
	// Bit mask of DRDY field.
	ADC_IDR_DRDY_Msk = 0x1000000
	// Bit DRDY.
	ADC_IDR_DRDY = 0x1000000
	// Position of GOVRE field.
	ADC_IDR_GOVRE_Pos = 0x19
	// Bit mask of GOVRE field.
	ADC_IDR_GOVRE_Msk = 0x2000000
	// Bit GOVRE.
	ADC_IDR_GOVRE = 0x2000000
	// Position of COMPE field.
	ADC_IDR_COMPE_Pos = 0x1a
	// Bit mask of COMPE field.
	ADC_IDR_COMPE_Msk = 0x4000000
	// Bit COMPE.
	ADC_IDR_COMPE = 0x4000000
	// Position of ENDRX field.
	ADC_IDR_ENDRX_Pos = 0x1b
	// Bit mask of ENDRX field.
	ADC_IDR_ENDRX_Msk = 0x8000000
	// Bit ENDRX.
	ADC_IDR_ENDRX = 0x8000000
	// Position of RXBUFF field.
	ADC_IDR_RXBUFF_Pos = 0x1c
	// Bit mask of RXBUFF field.
	ADC_IDR_RXBUFF_Msk = 0x10000000
	// Bit RXBUFF.
	ADC_IDR_RXBUFF = 0x10000000

	// IMR: Interrupt Mask Register
	// Position of EOC0 field.
	ADC_IMR_EOC0_Pos = 0x0
	// Bit mask of EOC0 field.
	ADC_IMR_EOC0_Msk = 0x1
	// Bit EOC0.
	ADC_IMR_EOC0 = 0x1
	// Position of EOC1 field.
	ADC_IMR_EOC1_Pos = 0x1
	// Bit mask of EOC1 field.
	ADC_IMR_EOC1_Msk = 0x2
	// Bit EOC1.
	ADC_IMR_EOC1 = 0x2
	// Position of EOC2 field.
	ADC_IMR_EOC2_Pos = 0x2
	// Bit mask of EOC2 field.
	ADC_IMR_EOC2_Msk = 0x4
	// Bit EOC2.
	ADC_IMR_EOC2 = 0x4
	// Position of EOC3 field.
	ADC_IMR_EOC3_Pos = 0x3
	// Bit mask of EOC3 field.
	ADC_IMR_EOC3_Msk = 0x8
	// Bit EOC3.
	ADC_IMR_EOC3 = 0x8
	// Position of EOC4 field.
	ADC_IMR_EOC4_Pos = 0x4
	// Bit mask of EOC4 field.
	ADC_IMR_EOC4_Msk = 0x10
	// Bit EOC4.
	ADC_IMR_EOC4 = 0x10
	// Position of EOC5 field.
	ADC_IMR_EOC5_Pos = 0x5
	// Bit mask of EOC5 field.
	ADC_IMR_EOC5_Msk = 0x20
	// Bit EOC5.
	ADC_IMR_EOC5 = 0x20
	// Position of EOC6 field.
	ADC_IMR_EOC6_Pos = 0x6
	// Bit mask of EOC6 field.
	ADC_IMR_EOC6_Msk = 0x40
	// Bit EOC6.
	ADC_IMR_EOC6 = 0x40
	// Position of EOC7 field.
	ADC_IMR_EOC7_Pos = 0x7
	// Bit mask of EOC7 field.
	ADC_IMR_EOC7_Msk = 0x80
	// Bit EOC7.
	ADC_IMR_EOC7 = 0x80
	// Position of EOC8 field.
	ADC_IMR_EOC8_Pos = 0x8
	// Bit mask of EOC8 field.
	ADC_IMR_EOC8_Msk = 0x100
	// Bit EOC8.
	ADC_IMR_EOC8 = 0x100
	// Position of EOC9 field.
	ADC_IMR_EOC9_Pos = 0x9
	// Bit mask of EOC9 field.
	ADC_IMR_EOC9_Msk = 0x200
	// Bit EOC9.
	ADC_IMR_EOC9 = 0x200
	// Position of EOC10 field.
	ADC_IMR_EOC10_Pos = 0xa
	// Bit mask of EOC10 field.
	ADC_IMR_EOC10_Msk = 0x400
	// Bit EOC10.
	ADC_IMR_EOC10 = 0x400
	// Position of EOC11 field.
	ADC_IMR_EOC11_Pos = 0xb
	// Bit mask of EOC11 field.
	ADC_IMR_EOC11_Msk = 0x800
	// Bit EOC11.
	ADC_IMR_EOC11 = 0x800
	// Position of EOC12 field.
	ADC_IMR_EOC12_Pos = 0xc
	// Bit mask of EOC12 field.
	ADC_IMR_EOC12_Msk = 0x1000
	// Bit EOC12.
	ADC_IMR_EOC12 = 0x1000
	// Position of EOC13 field.
	ADC_IMR_EOC13_Pos = 0xd
	// Bit mask of EOC13 field.
	ADC_IMR_EOC13_Msk = 0x2000
	// Bit EOC13.
	ADC_IMR_EOC13 = 0x2000
	// Position of EOC14 field.
	ADC_IMR_EOC14_Pos = 0xe
	// Bit mask of EOC14 field.
	ADC_IMR_EOC14_Msk = 0x4000
	// Bit EOC14.
	ADC_IMR_EOC14 = 0x4000
	// Position of EOC15 field.
	ADC_IMR_EOC15_Pos = 0xf
	// Bit mask of EOC15 field.
	ADC_IMR_EOC15_Msk = 0x8000
	// Bit EOC15.
	ADC_IMR_EOC15 = 0x8000
	// Position of DRDY field.
	ADC_IMR_DRDY_Pos = 0x18
	// Bit mask of DRDY field.
	ADC_IMR_DRDY_Msk = 0x1000000
	// Bit DRDY.
	ADC_IMR_DRDY = 0x1000000
	// Position of GOVRE field.
	ADC_IMR_GOVRE_Pos = 0x19
	// Bit mask of GOVRE field.
	ADC_IMR_GOVRE_Msk = 0x2000000
	// Bit GOVRE.
	ADC_IMR_GOVRE = 0x2000000
	// Position of COMPE field.
	ADC_IMR_COMPE_Pos = 0x1a
	// Bit mask of COMPE field.
	ADC_IMR_COMPE_Msk = 0x4000000
	// Bit COMPE.
	ADC_IMR_COMPE = 0x4000000
	// Position of ENDRX field.
	ADC_IMR_ENDRX_Pos = 0x1b
	// Bit mask of ENDRX field.
	ADC_IMR_ENDRX_Msk = 0x8000000
	// Bit ENDRX.
	ADC_IMR_ENDRX = 0x8000000
	// Position of RXBUFF field.
	ADC_IMR_RXBUFF_Pos = 0x1c
	// Bit mask of RXBUFF field.
	ADC_IMR_RXBUFF_Msk = 0x10000000
	// Bit RXBUFF.
	ADC_IMR_RXBUFF = 0x10000000

	// ISR: Interrupt Status Register
	// Position of EOC0 field.
	ADC_ISR_EOC0_Pos = 0x0
	// Bit mask of EOC0 field.
	ADC_ISR_EOC0_Msk = 0x1
	// Bit EOC0.
	ADC_ISR_EOC0 = 0x1
	// Position of EOC1 field.
	ADC_ISR_EOC1_Pos = 0x1
	// Bit mask of EOC1 field.
	ADC_ISR_EOC1_Msk = 0x2
	// Bit EOC1.
	ADC_ISR_EOC1 = 0x2
	// Position of EOC2 field.
	ADC_ISR_EOC2_Pos = 0x2
	// Bit mask of EOC2 field.
	ADC_ISR_EOC2_Msk = 0x4
	// Bit EOC2.
	ADC_ISR_EOC2 = 0x4
	// Position of EOC3 field.
	ADC_ISR_EOC3_Pos = 0x3
	// Bit mask of EOC3 field.
	ADC_ISR_EOC3_Msk = 0x8
	// Bit EOC3.
	ADC_ISR_EOC3 = 0x8
	// Position of EOC4 field.
	ADC_ISR_EOC4_Pos = 0x4
	// Bit mask of EOC4 field.
	ADC_ISR_EOC4_Msk = 0x10
	// Bit EOC4.
	ADC_ISR_EOC4 = 0x10
	// Position of EOC5 field.
	ADC_ISR_EOC5_Pos = 0x5
	// Bit mask of EOC5 field.
	ADC_ISR_EOC5_Msk = 0x20
	// Bit EOC5.
	ADC_ISR_EOC5 = 0x20
	// Position of EOC6 field.
	ADC_ISR_EOC6_Pos = 0x6
	// Bit mask of EOC6 field.
	ADC_ISR_EOC6_Msk = 0x40
	// Bit EOC6.
	ADC_ISR_EOC6 = 0x40
	// Position of EOC7 field.
	ADC_ISR_EOC7_Pos = 0x7
	// Bit mask of EOC7 field.
	ADC_ISR_EOC7_Msk = 0x80
	// Bit EOC7.
	ADC_ISR_EOC7 = 0x80
	// Position of EOC8 field.
	ADC_ISR_EOC8_Pos = 0x8
	// Bit mask of EOC8 field.
	ADC_ISR_EOC8_Msk = 0x100
	// Bit EOC8.
	ADC_ISR_EOC8 = 0x100
	// Position of EOC9 field.
	ADC_ISR_EOC9_Pos = 0x9
	// Bit mask of EOC9 field.
	ADC_ISR_EOC9_Msk = 0x200
	// Bit EOC9.
	ADC_ISR_EOC9 = 0x200
	// Position of EOC10 field.
	ADC_ISR_EOC10_Pos = 0xa
	// Bit mask of EOC10 field.
	ADC_ISR_EOC10_Msk = 0x400
	// Bit EOC10.
	ADC_ISR_EOC10 = 0x400
	// Position of EOC11 field.
	ADC_ISR_EOC11_Pos = 0xb
	// Bit mask of EOC11 field.
	ADC_ISR_EOC11_Msk = 0x800
	// Bit EOC11.
	ADC_ISR_EOC11 = 0x800
	// Position of EOC12 field.
	ADC_ISR_EOC12_Pos = 0xc
	// Bit mask of EOC12 field.
	ADC_ISR_EOC12_Msk = 0x1000
	// Bit EOC12.
	ADC_ISR_EOC12 = 0x1000
	// Position of EOC13 field.
	ADC_ISR_EOC13_Pos = 0xd
	// Bit mask of EOC13 field.
	ADC_ISR_EOC13_Msk = 0x2000
	// Bit EOC13.
	ADC_ISR_EOC13 = 0x2000
	// Position of EOC14 field.
	ADC_ISR_EOC14_Pos = 0xe
	// Bit mask of EOC14 field.
	ADC_ISR_EOC14_Msk = 0x4000
	// Bit EOC14.
	ADC_ISR_EOC14 = 0x4000
	// Position of EOC15 field.
	ADC_ISR_EOC15_Pos = 0xf
	// Bit mask of EOC15 field.
	ADC_ISR_EOC15_Msk = 0x8000
	// Bit EOC15.
	ADC_ISR_EOC15 = 0x8000
	// Position of DRDY field.
	ADC_ISR_DRDY_Pos = 0x18
	// Bit mask of DRDY field.
	ADC_ISR_DRDY_Msk = 0x1000000
	// Bit DRDY.
	ADC_ISR_DRDY = 0x1000000
	// Position of GOVRE field.
	ADC_ISR_GOVRE_Pos = 0x19
	// Bit mask of GOVRE field.
	ADC_ISR_GOVRE_Msk = 0x2000000
	// Bit GOVRE.
	ADC_ISR_GOVRE = 0x2000000
	// Position of COMPE field.
	ADC_ISR_COMPE_Pos = 0x1a
	// Bit mask of COMPE field.
	ADC_ISR_COMPE_Msk = 0x4000000
	// Bit COMPE.
	ADC_ISR_COMPE = 0x4000000
	// Position of ENDRX field.
	ADC_ISR_ENDRX_Pos = 0x1b
	// Bit mask of ENDRX field.
	ADC_ISR_ENDRX_Msk = 0x8000000
	// Bit ENDRX.
	ADC_ISR_ENDRX = 0x8000000
	// Position of RXBUFF field.
	ADC_ISR_RXBUFF_Pos = 0x1c
	// Bit mask of RXBUFF field.
	ADC_ISR_RXBUFF_Msk = 0x10000000
	// Bit RXBUFF.
	ADC_ISR_RXBUFF = 0x10000000

	// OVER: Overrun Status Register
	// Position of OVRE0 field.
	ADC_OVER_OVRE0_Pos = 0x0
	// Bit mask of OVRE0 field.
	ADC_OVER_OVRE0_Msk = 0x1
	// Bit OVRE0.
	ADC_OVER_OVRE0 = 0x1
	// Position of OVRE1 field.
	ADC_OVER_OVRE1_Pos = 0x1
	// Bit mask of OVRE1 field.
	ADC_OVER_OVRE1_Msk = 0x2
	// Bit OVRE1.
	ADC_OVER_OVRE1 = 0x2
	// Position of OVRE2 field.
	ADC_OVER_OVRE2_Pos = 0x2
	// Bit mask of OVRE2 field.
	ADC_OVER_OVRE2_Msk = 0x4
	// Bit OVRE2.
	ADC_OVER_OVRE2 = 0x4
	// Position of OVRE3 field.
	ADC_OVER_OVRE3_Pos = 0x3
	// Bit mask of OVRE3 field.
	ADC_OVER_OVRE3_Msk = 0x8
	// Bit OVRE3.
	ADC_OVER_OVRE3 = 0x8
	// Position of OVRE4 field.
	ADC_OVER_OVRE4_Pos = 0x4
	// Bit mask of OVRE4 field.
	ADC_OVER_OVRE4_Msk = 0x10
	// Bit OVRE4.
	ADC_OVER_OVRE4 = 0x10
	// Position of OVRE5 field.
	ADC_OVER_OVRE5_Pos = 0x5
	// Bit mask of OVRE5 field.
	ADC_OVER_OVRE5_Msk = 0x20
	// Bit OVRE5.
	ADC_OVER_OVRE5 = 0x20
	// Position of OVRE6 field.
	ADC_OVER_OVRE6_Pos = 0x6
	// Bit mask of OVRE6 field.
	ADC_OVER_OVRE6_Msk = 0x40
	// Bit OVRE6.
	ADC_OVER_OVRE6 = 0x40
	// Position of OVRE7 field.
	ADC_OVER_OVRE7_Pos = 0x7
	// Bit mask of OVRE7 field.
	ADC_OVER_OVRE7_Msk = 0x80
	// Bit OVRE7.
	ADC_OVER_OVRE7 = 0x80
	// Position of OVRE8 field.
	ADC_OVER_OVRE8_Pos = 0x8
	// Bit mask of OVRE8 field.
	ADC_OVER_OVRE8_Msk = 0x100
	// Bit OVRE8.
	ADC_OVER_OVRE8 = 0x100
	// Position of OVRE9 field.
	ADC_OVER_OVRE9_Pos = 0x9
	// Bit mask of OVRE9 field.
	ADC_OVER_OVRE9_Msk = 0x200
	// Bit OVRE9.
	ADC_OVER_OVRE9 = 0x200
	// Position of OVRE10 field.
	ADC_OVER_OVRE10_Pos = 0xa
	// Bit mask of OVRE10 field.
	ADC_OVER_OVRE10_Msk = 0x400
	// Bit OVRE10.
	ADC_OVER_OVRE10 = 0x400
	// Position of OVRE11 field.
	ADC_OVER_OVRE11_Pos = 0xb
	// Bit mask of OVRE11 field.
	ADC_OVER_OVRE11_Msk = 0x800
	// Bit OVRE11.
	ADC_OVER_OVRE11 = 0x800
	// Position of OVRE12 field.
	ADC_OVER_OVRE12_Pos = 0xc
	// Bit mask of OVRE12 field.
	ADC_OVER_OVRE12_Msk = 0x1000
	// Bit OVRE12.
	ADC_OVER_OVRE12 = 0x1000
	// Position of OVRE13 field.
	ADC_OVER_OVRE13_Pos = 0xd
	// Bit mask of OVRE13 field.
	ADC_OVER_OVRE13_Msk = 0x2000
	// Bit OVRE13.
	ADC_OVER_OVRE13 = 0x2000
	// Position of OVRE14 field.
	ADC_OVER_OVRE14_Pos = 0xe
	// Bit mask of OVRE14 field.
	ADC_OVER_OVRE14_Msk = 0x4000
	// Bit OVRE14.
	ADC_OVER_OVRE14 = 0x4000
	// Position of OVRE15 field.
	ADC_OVER_OVRE15_Pos = 0xf
	// Bit mask of OVRE15 field.
	ADC_OVER_OVRE15_Msk = 0x8000
	// Bit OVRE15.
	ADC_OVER_OVRE15 = 0x8000

	// EMR: Extended Mode Register
	// Position of CMPMODE field.
	ADC_EMR_CMPMODE_Pos = 0x0
	// Bit mask of CMPMODE field.
	ADC_EMR_CMPMODE_Msk = 0x3
	// Generates an event when the converted data is lower than the low threshold of the window.
	ADC_EMR_CMPMODE_LOW = 0x0
	// Generates an event when the converted data is higher than the high threshold of the window.
	ADC_EMR_CMPMODE_HIGH = 0x1
	// Generates an event when the converted data is in the comparison window.
	ADC_EMR_CMPMODE_IN = 0x2
	// Generates an event when the converted data is out of the comparison window.
	ADC_EMR_CMPMODE_OUT = 0x3
	// Position of CMPSEL field.
	ADC_EMR_CMPSEL_Pos = 0x4
	// Bit mask of CMPSEL field.
	ADC_EMR_CMPSEL_Msk = 0xf0
	// Position of CMPALL field.
	ADC_EMR_CMPALL_Pos = 0x9
	// Bit mask of CMPALL field.
	ADC_EMR_CMPALL_Msk = 0x200
	// Bit CMPALL.
	ADC_EMR_CMPALL = 0x200
	// Position of CMPFILTER field.
	ADC_EMR_CMPFILTER_Pos = 0xc
	// Bit mask of CMPFILTER field.
	ADC_EMR_CMPFILTER_Msk = 0x3000
	// Position of TAG field.
	ADC_EMR_TAG_Pos = 0x18
	// Bit mask of TAG field.
	ADC_EMR_TAG_Msk = 0x1000000
	// Bit TAG.
	ADC_EMR_TAG = 0x1000000

	// CWR: Compare Window Register
	// Position of LOWTHRES field.
	ADC_CWR_LOWTHRES_Pos = 0x0
	// Bit mask of LOWTHRES field.
	ADC_CWR_LOWTHRES_Msk = 0xfff
	// Position of HIGHTHRES field.
	ADC_CWR_HIGHTHRES_Pos = 0x10
	// Bit mask of HIGHTHRES field.
	ADC_CWR_HIGHTHRES_Msk = 0xfff0000

	// CGR: Channel Gain Register
	// Position of GAIN0 field.
	ADC_CGR_GAIN0_Pos = 0x0
	// Bit mask of GAIN0 field.
	ADC_CGR_GAIN0_Msk = 0x3
	// Position of GAIN1 field.
	ADC_CGR_GAIN1_Pos = 0x2
	// Bit mask of GAIN1 field.
	ADC_CGR_GAIN1_Msk = 0xc
	// Position of GAIN2 field.
	ADC_CGR_GAIN2_Pos = 0x4
	// Bit mask of GAIN2 field.
	ADC_CGR_GAIN2_Msk = 0x30
	// Position of GAIN3 field.
	ADC_CGR_GAIN3_Pos = 0x6
	// Bit mask of GAIN3 field.
	ADC_CGR_GAIN3_Msk = 0xc0
	// Position of GAIN4 field.
	ADC_CGR_GAIN4_Pos = 0x8
	// Bit mask of GAIN4 field.
	ADC_CGR_GAIN4_Msk = 0x300
	// Position of GAIN5 field.
	ADC_CGR_GAIN5_Pos = 0xa
	// Bit mask of GAIN5 field.
	ADC_CGR_GAIN5_Msk = 0xc00
	// Position of GAIN6 field.
	ADC_CGR_GAIN6_Pos = 0xc
	// Bit mask of GAIN6 field.
	ADC_CGR_GAIN6_Msk = 0x3000
	// Position of GAIN7 field.
	ADC_CGR_GAIN7_Pos = 0xe
	// Bit mask of GAIN7 field.
	ADC_CGR_GAIN7_Msk = 0xc000
	// Position of GAIN8 field.
	ADC_CGR_GAIN8_Pos = 0x10
	// Bit mask of GAIN8 field.
	ADC_CGR_GAIN8_Msk = 0x30000
	// Position of GAIN9 field.
	ADC_CGR_GAIN9_Pos = 0x12
	// Bit mask of GAIN9 field.
	ADC_CGR_GAIN9_Msk = 0xc0000
	// Position of GAIN10 field.
	ADC_CGR_GAIN10_Pos = 0x14
	// Bit mask of GAIN10 field.
	ADC_CGR_GAIN10_Msk = 0x300000
	// Position of GAIN11 field.
	ADC_CGR_GAIN11_Pos = 0x16
	// Bit mask of GAIN11 field.
	ADC_CGR_GAIN11_Msk = 0xc00000
	// Position of GAIN12 field.
	ADC_CGR_GAIN12_Pos = 0x18
	// Bit mask of GAIN12 field.
	ADC_CGR_GAIN12_Msk = 0x3000000
	// Position of GAIN13 field.
	ADC_CGR_GAIN13_Pos = 0x1a
	// Bit mask of GAIN13 field.
	ADC_CGR_GAIN13_Msk = 0xc000000
	// Position of GAIN14 field.
	ADC_CGR_GAIN14_Pos = 0x1c
	// Bit mask of GAIN14 field.
	ADC_CGR_GAIN14_Msk = 0x30000000
	// Position of GAIN15 field.
	ADC_CGR_GAIN15_Pos = 0x1e
	// Bit mask of GAIN15 field.
	ADC_CGR_GAIN15_Msk = 0xc0000000

	// COR: Channel Offset Register
	// Position of OFF0 field.
	ADC_COR_OFF0_Pos = 0x0
	// Bit mask of OFF0 field.
	ADC_COR_OFF0_Msk = 0x1
	// Bit OFF0.
	ADC_COR_OFF0 = 0x1
	// Position of OFF1 field.
	ADC_COR_OFF1_Pos = 0x1
	// Bit mask of OFF1 field.
	ADC_COR_OFF1_Msk = 0x2
	// Bit OFF1.
	ADC_COR_OFF1 = 0x2
	// Position of OFF2 field.
	ADC_COR_OFF2_Pos = 0x2
	// Bit mask of OFF2 field.
	ADC_COR_OFF2_Msk = 0x4
	// Bit OFF2.
	ADC_COR_OFF2 = 0x4
	// Position of OFF3 field.
	ADC_COR_OFF3_Pos = 0x3
	// Bit mask of OFF3 field.
	ADC_COR_OFF3_Msk = 0x8
	// Bit OFF3.
	ADC_COR_OFF3 = 0x8
	// Position of OFF4 field.
	ADC_COR_OFF4_Pos = 0x4
	// Bit mask of OFF4 field.
	ADC_COR_OFF4_Msk = 0x10
	// Bit OFF4.
	ADC_COR_OFF4 = 0x10
	// Position of OFF5 field.
	ADC_COR_OFF5_Pos = 0x5
	// Bit mask of OFF5 field.
	ADC_COR_OFF5_Msk = 0x20
	// Bit OFF5.
	ADC_COR_OFF5 = 0x20
	// Position of OFF6 field.
	ADC_COR_OFF6_Pos = 0x6
	// Bit mask of OFF6 field.
	ADC_COR_OFF6_Msk = 0x40
	// Bit OFF6.
	ADC_COR_OFF6 = 0x40
	// Position of OFF7 field.
	ADC_COR_OFF7_Pos = 0x7
	// Bit mask of OFF7 field.
	ADC_COR_OFF7_Msk = 0x80
	// Bit OFF7.
	ADC_COR_OFF7 = 0x80
	// Position of OFF8 field.
	ADC_COR_OFF8_Pos = 0x8
	// Bit mask of OFF8 field.
	ADC_COR_OFF8_Msk = 0x100
	// Bit OFF8.
	ADC_COR_OFF8 = 0x100
	// Position of OFF9 field.
	ADC_COR_OFF9_Pos = 0x9
	// Bit mask of OFF9 field.
	ADC_COR_OFF9_Msk = 0x200
	// Bit OFF9.
	ADC_COR_OFF9 = 0x200
	// Position of OFF10 field.
	ADC_COR_OFF10_Pos = 0xa
	// Bit mask of OFF10 field.
	ADC_COR_OFF10_Msk = 0x400
	// Bit OFF10.
	ADC_COR_OFF10 = 0x400
	// Position of OFF11 field.
	ADC_COR_OFF11_Pos = 0xb
	// Bit mask of OFF11 field.
	ADC_COR_OFF11_Msk = 0x800
	// Bit OFF11.
	ADC_COR_OFF11 = 0x800
	// Position of OFF12 field.
	ADC_COR_OFF12_Pos = 0xc
	// Bit mask of OFF12 field.
	ADC_COR_OFF12_Msk = 0x1000
	// Bit OFF12.
	ADC_COR_OFF12 = 0x1000
	// Position of OFF13 field.
	ADC_COR_OFF13_Pos = 0xd
	// Bit mask of OFF13 field.
	ADC_COR_OFF13_Msk = 0x2000
	// Bit OFF13.
	ADC_COR_OFF13 = 0x2000
	// Position of OFF14 field.
	ADC_COR_OFF14_Pos = 0xe
	// Bit mask of OFF14 field.
	ADC_COR_OFF14_Msk = 0x4000
	// Bit OFF14.
	ADC_COR_OFF14 = 0x4000
	// Position of OFF15 field.
	ADC_COR_OFF15_Pos = 0xf
	// Bit mask of OFF15 field.
	ADC_COR_OFF15_Msk = 0x8000
	// Bit OFF15.
	ADC_COR_OFF15 = 0x8000
	// Position of DIFF0 field.
	ADC_COR_DIFF0_Pos = 0x10
	// Bit mask of DIFF0 field.
	ADC_COR_DIFF0_Msk = 0x10000
	// Bit DIFF0.
	ADC_COR_DIFF0 = 0x10000
	// Position of DIFF1 field.
	ADC_COR_DIFF1_Pos = 0x11
	// Bit mask of DIFF1 field.
	ADC_COR_DIFF1_Msk = 0x20000
	// Bit DIFF1.
	ADC_COR_DIFF1 = 0x20000
	// Position of DIFF2 field.
	ADC_COR_DIFF2_Pos = 0x12
	// Bit mask of DIFF2 field.
	ADC_COR_DIFF2_Msk = 0x40000
	// Bit DIFF2.
	ADC_COR_DIFF2 = 0x40000
	// Position of DIFF3 field.
	ADC_COR_DIFF3_Pos = 0x13
	// Bit mask of DIFF3 field.
	ADC_COR_DIFF3_Msk = 0x80000
	// Bit DIFF3.
	ADC_COR_DIFF3 = 0x80000
	// Position of DIFF4 field.
	ADC_COR_DIFF4_Pos = 0x14
	// Bit mask of DIFF4 field.
	ADC_COR_DIFF4_Msk = 0x100000
	// Bit DIFF4.
	ADC_COR_DIFF4 = 0x100000
	// Position of DIFF5 field.
	ADC_COR_DIFF5_Pos = 0x15
	// Bit mask of DIFF5 field.
	ADC_COR_DIFF5_Msk = 0x200000
	// Bit DIFF5.
	ADC_COR_DIFF5 = 0x200000
	// Position of DIFF6 field.
	ADC_COR_DIFF6_Pos = 0x16
	// Bit mask of DIFF6 field.
	ADC_COR_DIFF6_Msk = 0x400000
	// Bit DIFF6.
	ADC_COR_DIFF6 = 0x400000
	// Position of DIFF7 field.
	ADC_COR_DIFF7_Pos = 0x17
	// Bit mask of DIFF7 field.
	ADC_COR_DIFF7_Msk = 0x800000
	// Bit DIFF7.
	ADC_COR_DIFF7 = 0x800000
	// Position of DIFF8 field.
	ADC_COR_DIFF8_Pos = 0x18
	// Bit mask of DIFF8 field.
	ADC_COR_DIFF8_Msk = 0x1000000
	// Bit DIFF8.
	ADC_COR_DIFF8 = 0x1000000
	// Position of DIFF9 field.
	ADC_COR_DIFF9_Pos = 0x19
	// Bit mask of DIFF9 field.
	ADC_COR_DIFF9_Msk = 0x2000000
	// Bit DIFF9.
	ADC_COR_DIFF9 = 0x2000000
	// Position of DIFF10 field.
	ADC_COR_DIFF10_Pos = 0x1a
	// Bit mask of DIFF10 field.
	ADC_COR_DIFF10_Msk = 0x4000000
	// Bit DIFF10.
	ADC_COR_DIFF10 = 0x4000000
	// Position of DIFF11 field.
	ADC_COR_DIFF11_Pos = 0x1b
	// Bit mask of DIFF11 field.
	ADC_COR_DIFF11_Msk = 0x8000000
	// Bit DIFF11.
	ADC_COR_DIFF11 = 0x8000000
	// Position of DIFF12 field.
	ADC_COR_DIFF12_Pos = 0x1c
	// Bit mask of DIFF12 field.
	ADC_COR_DIFF12_Msk = 0x10000000
	// Bit DIFF12.
	ADC_COR_DIFF12 = 0x10000000
	// Position of DIFF13 field.
	ADC_COR_DIFF13_Pos = 0x1d
	// Bit mask of DIFF13 field.
	ADC_COR_DIFF13_Msk = 0x20000000
	// Bit DIFF13.
	ADC_COR_DIFF13 = 0x20000000
	// Position of DIFF14 field.
	ADC_COR_DIFF14_Pos = 0x1e
	// Bit mask of DIFF14 field.
	ADC_COR_DIFF14_Msk = 0x40000000
	// Bit DIFF14.
	ADC_COR_DIFF14 = 0x40000000
	// Position of DIFF15 field.
	ADC_COR_DIFF15_Pos = 0x1f
	// Bit mask of DIFF15 field.
	ADC_COR_DIFF15_Msk = 0x80000000
	// Bit DIFF15.
	ADC_COR_DIFF15 = 0x80000000

	// CDR: Channel Data Register
	// Position of DATA field.
	ADC_CDR_DATA_Pos = 0x0
	// Bit mask of DATA field.
	ADC_CDR_DATA_Msk = 0xfff

	// ACR: Analog Control Register
	// Position of TSON field.
	ADC_ACR_TSON_Pos = 0x4
	// Bit mask of TSON field.
	ADC_ACR_TSON_Msk = 0x10
	// Bit TSON.
	ADC_ACR_TSON = 0x10
	// Position of IBCTL field.
	ADC_ACR_IBCTL_Pos = 0x8
	// Bit mask of IBCTL field.
	ADC_ACR_IBCTL_Msk = 0x300

	// WPMR: Write Protect Mode Register
	// Position of WPEN field.
	ADC_WPMR_WPEN_Pos = 0x0
	// Bit mask of WPEN field.
	ADC_WPMR_WPEN_Msk = 0x1
	// Bit WPEN.
	ADC_WPMR_WPEN = 0x1
	// Position of WPKEY field.
	ADC_WPMR_WPKEY_Pos = 0x8
	// Bit mask of WPKEY field.
	ADC_WPMR_WPKEY_Msk = 0xffffff00
	// Writing any other value in this field aborts the write operation of the WPEN bit.Always reads as 0
	ADC_WPMR_WPKEY_PASSWD = 0x414443

	// WPSR: Write Protect Status Register
	// Position of WPVS field.
	ADC_WPSR_WPVS_Pos = 0x0
	// Bit mask of WPVS field.
	ADC_WPSR_WPVS_Msk = 0x1
	// Bit WPVS.
	ADC_WPSR_WPVS = 0x1
	// Position of WPVSRC field.
	ADC_WPSR_WPVSRC_Pos = 0x8
	// Bit mask of WPVSRC field.
	ADC_WPSR_WPVSRC_Msk = 0xffff00

	// RPR: Receive Pointer Register
	// Position of RXPTR field.
	ADC_RPR_RXPTR_Pos = 0x0
	// Bit mask of RXPTR field.
	ADC_RPR_RXPTR_Msk = 0xffffffff

	// RCR: Receive Counter Register
	// Position of RXCTR field.
	ADC_RCR_RXCTR_Pos = 0x0
	// Bit mask of RXCTR field.
	ADC_RCR_RXCTR_Msk = 0xffff

	// RNPR: Receive Next Pointer Register
	// Position of RXNPTR field.
	ADC_RNPR_RXNPTR_Pos = 0x0
	// Bit mask of RXNPTR field.
	ADC_RNPR_RXNPTR_Msk = 0xffffffff

	// RNCR: Receive Next Counter Register
	// Position of RXNCTR field.
	ADC_RNCR_RXNCTR_Pos = 0x0
	// Bit mask of RXNCTR field.
	ADC_RNCR_RXNCTR_Msk = 0xffff

	// PTCR: Transfer Control Register
	// Position of RXTEN field.
	ADC_PTCR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	ADC_PTCR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	ADC_PTCR_RXTEN = 0x1
	// Position of RXTDIS field.
	ADC_PTCR_RXTDIS_Pos = 0x1
	// Bit mask of RXTDIS field.
	ADC_PTCR_RXTDIS_Msk = 0x2
	// Bit RXTDIS.
	ADC_PTCR_RXTDIS = 0x2
	// Position of TXTEN field.
	ADC_PTCR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	ADC_PTCR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	ADC_PTCR_TXTEN = 0x100
	// Position of TXTDIS field.
	ADC_PTCR_TXTDIS_Pos = 0x9
	// Bit mask of TXTDIS field.
	ADC_PTCR_TXTDIS_Msk = 0x200
	// Bit TXTDIS.
	ADC_PTCR_TXTDIS = 0x200

	// PTSR: Transfer Status Register
	// Position of RXTEN field.
	ADC_PTSR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	ADC_PTSR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	ADC_PTSR_RXTEN = 0x1
	// Position of TXTEN field.
	ADC_PTSR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	ADC_PTSR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	ADC_PTSR_TXTEN = 0x100
)

// Bitfields for DMAC: DMA Controller
const (
	// GCFG: DMAC Global Configuration Register
	// Position of ARB_CFG field.
	DMAC_GCFG_ARB_CFG_Pos = 0x4
	// Bit mask of ARB_CFG field.
	DMAC_GCFG_ARB_CFG_Msk = 0x10
	// Bit ARB_CFG.
	DMAC_GCFG_ARB_CFG = 0x10
	// Fixed priority arbiter (see "Basic Definitions" )
	DMAC_GCFG_ARB_CFG_FIXED = 0x0
	// Modified round robin arbiter.
	DMAC_GCFG_ARB_CFG_ROUND_ROBIN = 0x1

	// EN: DMAC Enable Register
	// Position of ENABLE field.
	DMAC_EN_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	DMAC_EN_ENABLE_Msk = 0x1
	// Bit ENABLE.
	DMAC_EN_ENABLE = 0x1

	// SREQ: DMAC Software Single Request Register
	// Position of SSREQ0 field.
	DMAC_SREQ_SSREQ0_Pos = 0x0
	// Bit mask of SSREQ0 field.
	DMAC_SREQ_SSREQ0_Msk = 0x1
	// Bit SSREQ0.
	DMAC_SREQ_SSREQ0 = 0x1
	// Position of DSREQ0 field.
	DMAC_SREQ_DSREQ0_Pos = 0x1
	// Bit mask of DSREQ0 field.
	DMAC_SREQ_DSREQ0_Msk = 0x2
	// Bit DSREQ0.
	DMAC_SREQ_DSREQ0 = 0x2
	// Position of SSREQ1 field.
	DMAC_SREQ_SSREQ1_Pos = 0x2
	// Bit mask of SSREQ1 field.
	DMAC_SREQ_SSREQ1_Msk = 0x4
	// Bit SSREQ1.
	DMAC_SREQ_SSREQ1 = 0x4
	// Position of DSREQ1 field.
	DMAC_SREQ_DSREQ1_Pos = 0x3
	// Bit mask of DSREQ1 field.
	DMAC_SREQ_DSREQ1_Msk = 0x8
	// Bit DSREQ1.
	DMAC_SREQ_DSREQ1 = 0x8
	// Position of SSREQ2 field.
	DMAC_SREQ_SSREQ2_Pos = 0x4
	// Bit mask of SSREQ2 field.
	DMAC_SREQ_SSREQ2_Msk = 0x10
	// Bit SSREQ2.
	DMAC_SREQ_SSREQ2 = 0x10
	// Position of DSREQ2 field.
	DMAC_SREQ_DSREQ2_Pos = 0x5
	// Bit mask of DSREQ2 field.
	DMAC_SREQ_DSREQ2_Msk = 0x20
	// Bit DSREQ2.
	DMAC_SREQ_DSREQ2 = 0x20
	// Position of SSREQ3 field.
	DMAC_SREQ_SSREQ3_Pos = 0x6
	// Bit mask of SSREQ3 field.
	DMAC_SREQ_SSREQ3_Msk = 0x40
	// Bit SSREQ3.
	DMAC_SREQ_SSREQ3 = 0x40
	// Position of DSREQ3 field.
	DMAC_SREQ_DSREQ3_Pos = 0x7
	// Bit mask of DSREQ3 field.
	DMAC_SREQ_DSREQ3_Msk = 0x80
	// Bit DSREQ3.
	DMAC_SREQ_DSREQ3 = 0x80
	// Position of SSREQ4 field.
	DMAC_SREQ_SSREQ4_Pos = 0x8
	// Bit mask of SSREQ4 field.
	DMAC_SREQ_SSREQ4_Msk = 0x100
	// Bit SSREQ4.
	DMAC_SREQ_SSREQ4 = 0x100
	// Position of DSREQ4 field.
	DMAC_SREQ_DSREQ4_Pos = 0x9
	// Bit mask of DSREQ4 field.
	DMAC_SREQ_DSREQ4_Msk = 0x200
	// Bit DSREQ4.
	DMAC_SREQ_DSREQ4 = 0x200
	// Position of SSREQ5 field.
	DMAC_SREQ_SSREQ5_Pos = 0xa
	// Bit mask of SSREQ5 field.
	DMAC_SREQ_SSREQ5_Msk = 0x400
	// Bit SSREQ5.
	DMAC_SREQ_SSREQ5 = 0x400
	// Position of DSREQ5 field.
	DMAC_SREQ_DSREQ5_Pos = 0xb
	// Bit mask of DSREQ5 field.
	DMAC_SREQ_DSREQ5_Msk = 0x800
	// Bit DSREQ5.
	DMAC_SREQ_DSREQ5 = 0x800

	// CREQ: DMAC Software Chunk Transfer Request Register
	// Position of SCREQ0 field.
	DMAC_CREQ_SCREQ0_Pos = 0x0
	// Bit mask of SCREQ0 field.
	DMAC_CREQ_SCREQ0_Msk = 0x1
	// Bit SCREQ0.
	DMAC_CREQ_SCREQ0 = 0x1
	// Position of DCREQ0 field.
	DMAC_CREQ_DCREQ0_Pos = 0x1
	// Bit mask of DCREQ0 field.
	DMAC_CREQ_DCREQ0_Msk = 0x2
	// Bit DCREQ0.
	DMAC_CREQ_DCREQ0 = 0x2
	// Position of SCREQ1 field.
	DMAC_CREQ_SCREQ1_Pos = 0x2
	// Bit mask of SCREQ1 field.
	DMAC_CREQ_SCREQ1_Msk = 0x4
	// Bit SCREQ1.
	DMAC_CREQ_SCREQ1 = 0x4
	// Position of DCREQ1 field.
	DMAC_CREQ_DCREQ1_Pos = 0x3
	// Bit mask of DCREQ1 field.
	DMAC_CREQ_DCREQ1_Msk = 0x8
	// Bit DCREQ1.
	DMAC_CREQ_DCREQ1 = 0x8
	// Position of SCREQ2 field.
	DMAC_CREQ_SCREQ2_Pos = 0x4
	// Bit mask of SCREQ2 field.
	DMAC_CREQ_SCREQ2_Msk = 0x10
	// Bit SCREQ2.
	DMAC_CREQ_SCREQ2 = 0x10
	// Position of DCREQ2 field.
	DMAC_CREQ_DCREQ2_Pos = 0x5
	// Bit mask of DCREQ2 field.
	DMAC_CREQ_DCREQ2_Msk = 0x20
	// Bit DCREQ2.
	DMAC_CREQ_DCREQ2 = 0x20
	// Position of SCREQ3 field.
	DMAC_CREQ_SCREQ3_Pos = 0x6
	// Bit mask of SCREQ3 field.
	DMAC_CREQ_SCREQ3_Msk = 0x40
	// Bit SCREQ3.
	DMAC_CREQ_SCREQ3 = 0x40
	// Position of DCREQ3 field.
	DMAC_CREQ_DCREQ3_Pos = 0x7
	// Bit mask of DCREQ3 field.
	DMAC_CREQ_DCREQ3_Msk = 0x80
	// Bit DCREQ3.
	DMAC_CREQ_DCREQ3 = 0x80
	// Position of SCREQ4 field.
	DMAC_CREQ_SCREQ4_Pos = 0x8
	// Bit mask of SCREQ4 field.
	DMAC_CREQ_SCREQ4_Msk = 0x100
	// Bit SCREQ4.
	DMAC_CREQ_SCREQ4 = 0x100
	// Position of DCREQ4 field.
	DMAC_CREQ_DCREQ4_Pos = 0x9
	// Bit mask of DCREQ4 field.
	DMAC_CREQ_DCREQ4_Msk = 0x200
	// Bit DCREQ4.
	DMAC_CREQ_DCREQ4 = 0x200
	// Position of SCREQ5 field.
	DMAC_CREQ_SCREQ5_Pos = 0xa
	// Bit mask of SCREQ5 field.
	DMAC_CREQ_SCREQ5_Msk = 0x400
	// Bit SCREQ5.
	DMAC_CREQ_SCREQ5 = 0x400
	// Position of DCREQ5 field.
	DMAC_CREQ_DCREQ5_Pos = 0xb
	// Bit mask of DCREQ5 field.
	DMAC_CREQ_DCREQ5_Msk = 0x800
	// Bit DCREQ5.
	DMAC_CREQ_DCREQ5 = 0x800

	// LAST: DMAC Software Last Transfer Flag Register
	// Position of SLAST0 field.
	DMAC_LAST_SLAST0_Pos = 0x0
	// Bit mask of SLAST0 field.
	DMAC_LAST_SLAST0_Msk = 0x1
	// Bit SLAST0.
	DMAC_LAST_SLAST0 = 0x1
	// Position of DLAST0 field.
	DMAC_LAST_DLAST0_Pos = 0x1
	// Bit mask of DLAST0 field.
	DMAC_LAST_DLAST0_Msk = 0x2
	// Bit DLAST0.
	DMAC_LAST_DLAST0 = 0x2
	// Position of SLAST1 field.
	DMAC_LAST_SLAST1_Pos = 0x2
	// Bit mask of SLAST1 field.
	DMAC_LAST_SLAST1_Msk = 0x4
	// Bit SLAST1.
	DMAC_LAST_SLAST1 = 0x4
	// Position of DLAST1 field.
	DMAC_LAST_DLAST1_Pos = 0x3
	// Bit mask of DLAST1 field.
	DMAC_LAST_DLAST1_Msk = 0x8
	// Bit DLAST1.
	DMAC_LAST_DLAST1 = 0x8
	// Position of SLAST2 field.
	DMAC_LAST_SLAST2_Pos = 0x4
	// Bit mask of SLAST2 field.
	DMAC_LAST_SLAST2_Msk = 0x10
	// Bit SLAST2.
	DMAC_LAST_SLAST2 = 0x10
	// Position of DLAST2 field.
	DMAC_LAST_DLAST2_Pos = 0x5
	// Bit mask of DLAST2 field.
	DMAC_LAST_DLAST2_Msk = 0x20
	// Bit DLAST2.
	DMAC_LAST_DLAST2 = 0x20
	// Position of SLAST3 field.
	DMAC_LAST_SLAST3_Pos = 0x6
	// Bit mask of SLAST3 field.
	DMAC_LAST_SLAST3_Msk = 0x40
	// Bit SLAST3.
	DMAC_LAST_SLAST3 = 0x40
	// Position of DLAST3 field.
	DMAC_LAST_DLAST3_Pos = 0x7
	// Bit mask of DLAST3 field.
	DMAC_LAST_DLAST3_Msk = 0x80
	// Bit DLAST3.
	DMAC_LAST_DLAST3 = 0x80
	// Position of SLAST4 field.
	DMAC_LAST_SLAST4_Pos = 0x8
	// Bit mask of SLAST4 field.
	DMAC_LAST_SLAST4_Msk = 0x100
	// Bit SLAST4.
	DMAC_LAST_SLAST4 = 0x100
	// Position of DLAST4 field.
	DMAC_LAST_DLAST4_Pos = 0x9
	// Bit mask of DLAST4 field.
	DMAC_LAST_DLAST4_Msk = 0x200
	// Bit DLAST4.
	DMAC_LAST_DLAST4 = 0x200
	// Position of SLAST5 field.
	DMAC_LAST_SLAST5_Pos = 0xa
	// Bit mask of SLAST5 field.
	DMAC_LAST_SLAST5_Msk = 0x400
	// Bit SLAST5.
	DMAC_LAST_SLAST5 = 0x400
	// Position of DLAST5 field.
	DMAC_LAST_DLAST5_Pos = 0xb
	// Bit mask of DLAST5 field.
	DMAC_LAST_DLAST5_Msk = 0x800
	// Bit DLAST5.
	DMAC_LAST_DLAST5 = 0x800

	// EBCIER: DMAC Error, Chained Buffer Transfer Completed Interrupt and Buffer Transfer Completed Interrupt Enable register.
	// Position of BTC0 field.
	DMAC_EBCIER_BTC0_Pos = 0x0
	// Bit mask of BTC0 field.
	DMAC_EBCIER_BTC0_Msk = 0x1
	// Bit BTC0.
	DMAC_EBCIER_BTC0 = 0x1
	// Position of BTC1 field.
	DMAC_EBCIER_BTC1_Pos = 0x1
	// Bit mask of BTC1 field.
	DMAC_EBCIER_BTC1_Msk = 0x2
	// Bit BTC1.
	DMAC_EBCIER_BTC1 = 0x2
	// Position of BTC2 field.
	DMAC_EBCIER_BTC2_Pos = 0x2
	// Bit mask of BTC2 field.
	DMAC_EBCIER_BTC2_Msk = 0x4
	// Bit BTC2.
	DMAC_EBCIER_BTC2 = 0x4
	// Position of BTC3 field.
	DMAC_EBCIER_BTC3_Pos = 0x3
	// Bit mask of BTC3 field.
	DMAC_EBCIER_BTC3_Msk = 0x8
	// Bit BTC3.
	DMAC_EBCIER_BTC3 = 0x8
	// Position of BTC4 field.
	DMAC_EBCIER_BTC4_Pos = 0x4
	// Bit mask of BTC4 field.
	DMAC_EBCIER_BTC4_Msk = 0x10
	// Bit BTC4.
	DMAC_EBCIER_BTC4 = 0x10
	// Position of BTC5 field.
	DMAC_EBCIER_BTC5_Pos = 0x5
	// Bit mask of BTC5 field.
	DMAC_EBCIER_BTC5_Msk = 0x20
	// Bit BTC5.
	DMAC_EBCIER_BTC5 = 0x20
	// Position of CBTC0 field.
	DMAC_EBCIER_CBTC0_Pos = 0x8
	// Bit mask of CBTC0 field.
	DMAC_EBCIER_CBTC0_Msk = 0x100
	// Bit CBTC0.
	DMAC_EBCIER_CBTC0 = 0x100
	// Position of CBTC1 field.
	DMAC_EBCIER_CBTC1_Pos = 0x9
	// Bit mask of CBTC1 field.
	DMAC_EBCIER_CBTC1_Msk = 0x200
	// Bit CBTC1.
	DMAC_EBCIER_CBTC1 = 0x200
	// Position of CBTC2 field.
	DMAC_EBCIER_CBTC2_Pos = 0xa
	// Bit mask of CBTC2 field.
	DMAC_EBCIER_CBTC2_Msk = 0x400
	// Bit CBTC2.
	DMAC_EBCIER_CBTC2 = 0x400
	// Position of CBTC3 field.
	DMAC_EBCIER_CBTC3_Pos = 0xb
	// Bit mask of CBTC3 field.
	DMAC_EBCIER_CBTC3_Msk = 0x800
	// Bit CBTC3.
	DMAC_EBCIER_CBTC3 = 0x800
	// Position of CBTC4 field.
	DMAC_EBCIER_CBTC4_Pos = 0xc
	// Bit mask of CBTC4 field.
	DMAC_EBCIER_CBTC4_Msk = 0x1000
	// Bit CBTC4.
	DMAC_EBCIER_CBTC4 = 0x1000
	// Position of CBTC5 field.
	DMAC_EBCIER_CBTC5_Pos = 0xd
	// Bit mask of CBTC5 field.
	DMAC_EBCIER_CBTC5_Msk = 0x2000
	// Bit CBTC5.
	DMAC_EBCIER_CBTC5 = 0x2000
	// Position of ERR0 field.
	DMAC_EBCIER_ERR0_Pos = 0x10
	// Bit mask of ERR0 field.
	DMAC_EBCIER_ERR0_Msk = 0x10000
	// Bit ERR0.
	DMAC_EBCIER_ERR0 = 0x10000
	// Position of ERR1 field.
	DMAC_EBCIER_ERR1_Pos = 0x11
	// Bit mask of ERR1 field.
	DMAC_EBCIER_ERR1_Msk = 0x20000
	// Bit ERR1.
	DMAC_EBCIER_ERR1 = 0x20000
	// Position of ERR2 field.
	DMAC_EBCIER_ERR2_Pos = 0x12
	// Bit mask of ERR2 field.
	DMAC_EBCIER_ERR2_Msk = 0x40000
	// Bit ERR2.
	DMAC_EBCIER_ERR2 = 0x40000
	// Position of ERR3 field.
	DMAC_EBCIER_ERR3_Pos = 0x13
	// Bit mask of ERR3 field.
	DMAC_EBCIER_ERR3_Msk = 0x80000
	// Bit ERR3.
	DMAC_EBCIER_ERR3 = 0x80000
	// Position of ERR4 field.
	DMAC_EBCIER_ERR4_Pos = 0x14
	// Bit mask of ERR4 field.
	DMAC_EBCIER_ERR4_Msk = 0x100000
	// Bit ERR4.
	DMAC_EBCIER_ERR4 = 0x100000
	// Position of ERR5 field.
	DMAC_EBCIER_ERR5_Pos = 0x15
	// Bit mask of ERR5 field.
	DMAC_EBCIER_ERR5_Msk = 0x200000
	// Bit ERR5.
	DMAC_EBCIER_ERR5 = 0x200000

	// EBCIDR: DMAC Error, Chained Buffer Transfer Completed Interrupt and Buffer Transfer Completed Interrupt Disable register.
	// Position of BTC0 field.
	DMAC_EBCIDR_BTC0_Pos = 0x0
	// Bit mask of BTC0 field.
	DMAC_EBCIDR_BTC0_Msk = 0x1
	// Bit BTC0.
	DMAC_EBCIDR_BTC0 = 0x1
	// Position of BTC1 field.
	DMAC_EBCIDR_BTC1_Pos = 0x1
	// Bit mask of BTC1 field.
	DMAC_EBCIDR_BTC1_Msk = 0x2
	// Bit BTC1.
	DMAC_EBCIDR_BTC1 = 0x2
	// Position of BTC2 field.
	DMAC_EBCIDR_BTC2_Pos = 0x2
	// Bit mask of BTC2 field.
	DMAC_EBCIDR_BTC2_Msk = 0x4
	// Bit BTC2.
	DMAC_EBCIDR_BTC2 = 0x4
	// Position of BTC3 field.
	DMAC_EBCIDR_BTC3_Pos = 0x3
	// Bit mask of BTC3 field.
	DMAC_EBCIDR_BTC3_Msk = 0x8
	// Bit BTC3.
	DMAC_EBCIDR_BTC3 = 0x8
	// Position of BTC4 field.
	DMAC_EBCIDR_BTC4_Pos = 0x4
	// Bit mask of BTC4 field.
	DMAC_EBCIDR_BTC4_Msk = 0x10
	// Bit BTC4.
	DMAC_EBCIDR_BTC4 = 0x10
	// Position of BTC5 field.
	DMAC_EBCIDR_BTC5_Pos = 0x5
	// Bit mask of BTC5 field.
	DMAC_EBCIDR_BTC5_Msk = 0x20
	// Bit BTC5.
	DMAC_EBCIDR_BTC5 = 0x20
	// Position of CBTC0 field.
	DMAC_EBCIDR_CBTC0_Pos = 0x8
	// Bit mask of CBTC0 field.
	DMAC_EBCIDR_CBTC0_Msk = 0x100
	// Bit CBTC0.
	DMAC_EBCIDR_CBTC0 = 0x100
	// Position of CBTC1 field.
	DMAC_EBCIDR_CBTC1_Pos = 0x9
	// Bit mask of CBTC1 field.
	DMAC_EBCIDR_CBTC1_Msk = 0x200
	// Bit CBTC1.
	DMAC_EBCIDR_CBTC1 = 0x200
	// Position of CBTC2 field.
	DMAC_EBCIDR_CBTC2_Pos = 0xa
	// Bit mask of CBTC2 field.
	DMAC_EBCIDR_CBTC2_Msk = 0x400
	// Bit CBTC2.
	DMAC_EBCIDR_CBTC2 = 0x400
	// Position of CBTC3 field.
	DMAC_EBCIDR_CBTC3_Pos = 0xb
	// Bit mask of CBTC3 field.
	DMAC_EBCIDR_CBTC3_Msk = 0x800
	// Bit CBTC3.
	DMAC_EBCIDR_CBTC3 = 0x800
	// Position of CBTC4 field.
	DMAC_EBCIDR_CBTC4_Pos = 0xc
	// Bit mask of CBTC4 field.
	DMAC_EBCIDR_CBTC4_Msk = 0x1000
	// Bit CBTC4.
	DMAC_EBCIDR_CBTC4 = 0x1000
	// Position of CBTC5 field.
	DMAC_EBCIDR_CBTC5_Pos = 0xd
	// Bit mask of CBTC5 field.
	DMAC_EBCIDR_CBTC5_Msk = 0x2000
	// Bit CBTC5.
	DMAC_EBCIDR_CBTC5 = 0x2000
	// Position of ERR0 field.
	DMAC_EBCIDR_ERR0_Pos = 0x10
	// Bit mask of ERR0 field.
	DMAC_EBCIDR_ERR0_Msk = 0x10000
	// Bit ERR0.
	DMAC_EBCIDR_ERR0 = 0x10000
	// Position of ERR1 field.
	DMAC_EBCIDR_ERR1_Pos = 0x11
	// Bit mask of ERR1 field.
	DMAC_EBCIDR_ERR1_Msk = 0x20000
	// Bit ERR1.
	DMAC_EBCIDR_ERR1 = 0x20000
	// Position of ERR2 field.
	DMAC_EBCIDR_ERR2_Pos = 0x12
	// Bit mask of ERR2 field.
	DMAC_EBCIDR_ERR2_Msk = 0x40000
	// Bit ERR2.
	DMAC_EBCIDR_ERR2 = 0x40000
	// Position of ERR3 field.
	DMAC_EBCIDR_ERR3_Pos = 0x13
	// Bit mask of ERR3 field.
	DMAC_EBCIDR_ERR3_Msk = 0x80000
	// Bit ERR3.
	DMAC_EBCIDR_ERR3 = 0x80000
	// Position of ERR4 field.
	DMAC_EBCIDR_ERR4_Pos = 0x14
	// Bit mask of ERR4 field.
	DMAC_EBCIDR_ERR4_Msk = 0x100000
	// Bit ERR4.
	DMAC_EBCIDR_ERR4 = 0x100000
	// Position of ERR5 field.
	DMAC_EBCIDR_ERR5_Pos = 0x15
	// Bit mask of ERR5 field.
	DMAC_EBCIDR_ERR5_Msk = 0x200000
	// Bit ERR5.
	DMAC_EBCIDR_ERR5 = 0x200000

	// EBCIMR: DMAC Error, Chained Buffer Transfer Completed Interrupt and Buffer transfer completed Mask Register.
	// Position of BTC0 field.
	DMAC_EBCIMR_BTC0_Pos = 0x0
	// Bit mask of BTC0 field.
	DMAC_EBCIMR_BTC0_Msk = 0x1
	// Bit BTC0.
	DMAC_EBCIMR_BTC0 = 0x1
	// Position of BTC1 field.
	DMAC_EBCIMR_BTC1_Pos = 0x1
	// Bit mask of BTC1 field.
	DMAC_EBCIMR_BTC1_Msk = 0x2
	// Bit BTC1.
	DMAC_EBCIMR_BTC1 = 0x2
	// Position of BTC2 field.
	DMAC_EBCIMR_BTC2_Pos = 0x2
	// Bit mask of BTC2 field.
	DMAC_EBCIMR_BTC2_Msk = 0x4
	// Bit BTC2.
	DMAC_EBCIMR_BTC2 = 0x4
	// Position of BTC3 field.
	DMAC_EBCIMR_BTC3_Pos = 0x3
	// Bit mask of BTC3 field.
	DMAC_EBCIMR_BTC3_Msk = 0x8
	// Bit BTC3.
	DMAC_EBCIMR_BTC3 = 0x8
	// Position of BTC4 field.
	DMAC_EBCIMR_BTC4_Pos = 0x4
	// Bit mask of BTC4 field.
	DMAC_EBCIMR_BTC4_Msk = 0x10
	// Bit BTC4.
	DMAC_EBCIMR_BTC4 = 0x10
	// Position of BTC5 field.
	DMAC_EBCIMR_BTC5_Pos = 0x5
	// Bit mask of BTC5 field.
	DMAC_EBCIMR_BTC5_Msk = 0x20
	// Bit BTC5.
	DMAC_EBCIMR_BTC5 = 0x20
	// Position of CBTC0 field.
	DMAC_EBCIMR_CBTC0_Pos = 0x8
	// Bit mask of CBTC0 field.
	DMAC_EBCIMR_CBTC0_Msk = 0x100
	// Bit CBTC0.
	DMAC_EBCIMR_CBTC0 = 0x100
	// Position of CBTC1 field.
	DMAC_EBCIMR_CBTC1_Pos = 0x9
	// Bit mask of CBTC1 field.
	DMAC_EBCIMR_CBTC1_Msk = 0x200
	// Bit CBTC1.
	DMAC_EBCIMR_CBTC1 = 0x200
	// Position of CBTC2 field.
	DMAC_EBCIMR_CBTC2_Pos = 0xa
	// Bit mask of CBTC2 field.
	DMAC_EBCIMR_CBTC2_Msk = 0x400
	// Bit CBTC2.
	DMAC_EBCIMR_CBTC2 = 0x400
	// Position of CBTC3 field.
	DMAC_EBCIMR_CBTC3_Pos = 0xb
	// Bit mask of CBTC3 field.
	DMAC_EBCIMR_CBTC3_Msk = 0x800
	// Bit CBTC3.
	DMAC_EBCIMR_CBTC3 = 0x800
	// Position of CBTC4 field.
	DMAC_EBCIMR_CBTC4_Pos = 0xc
	// Bit mask of CBTC4 field.
	DMAC_EBCIMR_CBTC4_Msk = 0x1000
	// Bit CBTC4.
	DMAC_EBCIMR_CBTC4 = 0x1000
	// Position of CBTC5 field.
	DMAC_EBCIMR_CBTC5_Pos = 0xd
	// Bit mask of CBTC5 field.
	DMAC_EBCIMR_CBTC5_Msk = 0x2000
	// Bit CBTC5.
	DMAC_EBCIMR_CBTC5 = 0x2000
	// Position of ERR0 field.
	DMAC_EBCIMR_ERR0_Pos = 0x10
	// Bit mask of ERR0 field.
	DMAC_EBCIMR_ERR0_Msk = 0x10000
	// Bit ERR0.
	DMAC_EBCIMR_ERR0 = 0x10000
	// Position of ERR1 field.
	DMAC_EBCIMR_ERR1_Pos = 0x11
	// Bit mask of ERR1 field.
	DMAC_EBCIMR_ERR1_Msk = 0x20000
	// Bit ERR1.
	DMAC_EBCIMR_ERR1 = 0x20000
	// Position of ERR2 field.
	DMAC_EBCIMR_ERR2_Pos = 0x12
	// Bit mask of ERR2 field.
	DMAC_EBCIMR_ERR2_Msk = 0x40000
	// Bit ERR2.
	DMAC_EBCIMR_ERR2 = 0x40000
	// Position of ERR3 field.
	DMAC_EBCIMR_ERR3_Pos = 0x13
	// Bit mask of ERR3 field.
	DMAC_EBCIMR_ERR3_Msk = 0x80000
	// Bit ERR3.
	DMAC_EBCIMR_ERR3 = 0x80000
	// Position of ERR4 field.
	DMAC_EBCIMR_ERR4_Pos = 0x14
	// Bit mask of ERR4 field.
	DMAC_EBCIMR_ERR4_Msk = 0x100000
	// Bit ERR4.
	DMAC_EBCIMR_ERR4 = 0x100000
	// Position of ERR5 field.
	DMAC_EBCIMR_ERR5_Pos = 0x15
	// Bit mask of ERR5 field.
	DMAC_EBCIMR_ERR5_Msk = 0x200000
	// Bit ERR5.
	DMAC_EBCIMR_ERR5 = 0x200000

	// EBCISR: DMAC Error, Chained Buffer Transfer Completed Interrupt and Buffer transfer completed Status Register.
	// Position of BTC0 field.
	DMAC_EBCISR_BTC0_Pos = 0x0
	// Bit mask of BTC0 field.
	DMAC_EBCISR_BTC0_Msk = 0x1
	// Bit BTC0.
	DMAC_EBCISR_BTC0 = 0x1
	// Position of BTC1 field.
	DMAC_EBCISR_BTC1_Pos = 0x1
	// Bit mask of BTC1 field.
	DMAC_EBCISR_BTC1_Msk = 0x2
	// Bit BTC1.
	DMAC_EBCISR_BTC1 = 0x2
	// Position of BTC2 field.
	DMAC_EBCISR_BTC2_Pos = 0x2
	// Bit mask of BTC2 field.
	DMAC_EBCISR_BTC2_Msk = 0x4
	// Bit BTC2.
	DMAC_EBCISR_BTC2 = 0x4
	// Position of BTC3 field.
	DMAC_EBCISR_BTC3_Pos = 0x3
	// Bit mask of BTC3 field.
	DMAC_EBCISR_BTC3_Msk = 0x8
	// Bit BTC3.
	DMAC_EBCISR_BTC3 = 0x8
	// Position of BTC4 field.
	DMAC_EBCISR_BTC4_Pos = 0x4
	// Bit mask of BTC4 field.
	DMAC_EBCISR_BTC4_Msk = 0x10
	// Bit BTC4.
	DMAC_EBCISR_BTC4 = 0x10
	// Position of BTC5 field.
	DMAC_EBCISR_BTC5_Pos = 0x5
	// Bit mask of BTC5 field.
	DMAC_EBCISR_BTC5_Msk = 0x20
	// Bit BTC5.
	DMAC_EBCISR_BTC5 = 0x20
	// Position of CBTC0 field.
	DMAC_EBCISR_CBTC0_Pos = 0x8
	// Bit mask of CBTC0 field.
	DMAC_EBCISR_CBTC0_Msk = 0x100
	// Bit CBTC0.
	DMAC_EBCISR_CBTC0 = 0x100
	// Position of CBTC1 field.
	DMAC_EBCISR_CBTC1_Pos = 0x9
	// Bit mask of CBTC1 field.
	DMAC_EBCISR_CBTC1_Msk = 0x200
	// Bit CBTC1.
	DMAC_EBCISR_CBTC1 = 0x200
	// Position of CBTC2 field.
	DMAC_EBCISR_CBTC2_Pos = 0xa
	// Bit mask of CBTC2 field.
	DMAC_EBCISR_CBTC2_Msk = 0x400
	// Bit CBTC2.
	DMAC_EBCISR_CBTC2 = 0x400
	// Position of CBTC3 field.
	DMAC_EBCISR_CBTC3_Pos = 0xb
	// Bit mask of CBTC3 field.
	DMAC_EBCISR_CBTC3_Msk = 0x800
	// Bit CBTC3.
	DMAC_EBCISR_CBTC3 = 0x800
	// Position of CBTC4 field.
	DMAC_EBCISR_CBTC4_Pos = 0xc
	// Bit mask of CBTC4 field.
	DMAC_EBCISR_CBTC4_Msk = 0x1000
	// Bit CBTC4.
	DMAC_EBCISR_CBTC4 = 0x1000
	// Position of CBTC5 field.
	DMAC_EBCISR_CBTC5_Pos = 0xd
	// Bit mask of CBTC5 field.
	DMAC_EBCISR_CBTC5_Msk = 0x2000
	// Bit CBTC5.
	DMAC_EBCISR_CBTC5 = 0x2000
	// Position of ERR0 field.
	DMAC_EBCISR_ERR0_Pos = 0x10
	// Bit mask of ERR0 field.
	DMAC_EBCISR_ERR0_Msk = 0x10000
	// Bit ERR0.
	DMAC_EBCISR_ERR0 = 0x10000
	// Position of ERR1 field.
	DMAC_EBCISR_ERR1_Pos = 0x11
	// Bit mask of ERR1 field.
	DMAC_EBCISR_ERR1_Msk = 0x20000
	// Bit ERR1.
	DMAC_EBCISR_ERR1 = 0x20000
	// Position of ERR2 field.
	DMAC_EBCISR_ERR2_Pos = 0x12
	// Bit mask of ERR2 field.
	DMAC_EBCISR_ERR2_Msk = 0x40000
	// Bit ERR2.
	DMAC_EBCISR_ERR2 = 0x40000
	// Position of ERR3 field.
	DMAC_EBCISR_ERR3_Pos = 0x13
	// Bit mask of ERR3 field.
	DMAC_EBCISR_ERR3_Msk = 0x80000
	// Bit ERR3.
	DMAC_EBCISR_ERR3 = 0x80000
	// Position of ERR4 field.
	DMAC_EBCISR_ERR4_Pos = 0x14
	// Bit mask of ERR4 field.
	DMAC_EBCISR_ERR4_Msk = 0x100000
	// Bit ERR4.
	DMAC_EBCISR_ERR4 = 0x100000
	// Position of ERR5 field.
	DMAC_EBCISR_ERR5_Pos = 0x15
	// Bit mask of ERR5 field.
	DMAC_EBCISR_ERR5_Msk = 0x200000
	// Bit ERR5.
	DMAC_EBCISR_ERR5 = 0x200000

	// CHER: DMAC Channel Handler Enable Register
	// Position of ENA0 field.
	DMAC_CHER_ENA0_Pos = 0x0
	// Bit mask of ENA0 field.
	DMAC_CHER_ENA0_Msk = 0x1
	// Bit ENA0.
	DMAC_CHER_ENA0 = 0x1
	// Position of ENA1 field.
	DMAC_CHER_ENA1_Pos = 0x1
	// Bit mask of ENA1 field.
	DMAC_CHER_ENA1_Msk = 0x2
	// Bit ENA1.
	DMAC_CHER_ENA1 = 0x2
	// Position of ENA2 field.
	DMAC_CHER_ENA2_Pos = 0x2
	// Bit mask of ENA2 field.
	DMAC_CHER_ENA2_Msk = 0x4
	// Bit ENA2.
	DMAC_CHER_ENA2 = 0x4
	// Position of ENA3 field.
	DMAC_CHER_ENA3_Pos = 0x3
	// Bit mask of ENA3 field.
	DMAC_CHER_ENA3_Msk = 0x8
	// Bit ENA3.
	DMAC_CHER_ENA3 = 0x8
	// Position of ENA4 field.
	DMAC_CHER_ENA4_Pos = 0x4
	// Bit mask of ENA4 field.
	DMAC_CHER_ENA4_Msk = 0x10
	// Bit ENA4.
	DMAC_CHER_ENA4 = 0x10
	// Position of ENA5 field.
	DMAC_CHER_ENA5_Pos = 0x5
	// Bit mask of ENA5 field.
	DMAC_CHER_ENA5_Msk = 0x20
	// Bit ENA5.
	DMAC_CHER_ENA5 = 0x20
	// Position of SUSP0 field.
	DMAC_CHER_SUSP0_Pos = 0x8
	// Bit mask of SUSP0 field.
	DMAC_CHER_SUSP0_Msk = 0x100
	// Bit SUSP0.
	DMAC_CHER_SUSP0 = 0x100
	// Position of SUSP1 field.
	DMAC_CHER_SUSP1_Pos = 0x9
	// Bit mask of SUSP1 field.
	DMAC_CHER_SUSP1_Msk = 0x200
	// Bit SUSP1.
	DMAC_CHER_SUSP1 = 0x200
	// Position of SUSP2 field.
	DMAC_CHER_SUSP2_Pos = 0xa
	// Bit mask of SUSP2 field.
	DMAC_CHER_SUSP2_Msk = 0x400
	// Bit SUSP2.
	DMAC_CHER_SUSP2 = 0x400
	// Position of SUSP3 field.
	DMAC_CHER_SUSP3_Pos = 0xb
	// Bit mask of SUSP3 field.
	DMAC_CHER_SUSP3_Msk = 0x800
	// Bit SUSP3.
	DMAC_CHER_SUSP3 = 0x800
	// Position of SUSP4 field.
	DMAC_CHER_SUSP4_Pos = 0xc
	// Bit mask of SUSP4 field.
	DMAC_CHER_SUSP4_Msk = 0x1000
	// Bit SUSP4.
	DMAC_CHER_SUSP4 = 0x1000
	// Position of SUSP5 field.
	DMAC_CHER_SUSP5_Pos = 0xd
	// Bit mask of SUSP5 field.
	DMAC_CHER_SUSP5_Msk = 0x2000
	// Bit SUSP5.
	DMAC_CHER_SUSP5 = 0x2000
	// Position of KEEP0 field.
	DMAC_CHER_KEEP0_Pos = 0x18
	// Bit mask of KEEP0 field.
	DMAC_CHER_KEEP0_Msk = 0x1000000
	// Bit KEEP0.
	DMAC_CHER_KEEP0 = 0x1000000
	// Position of KEEP1 field.
	DMAC_CHER_KEEP1_Pos = 0x19
	// Bit mask of KEEP1 field.
	DMAC_CHER_KEEP1_Msk = 0x2000000
	// Bit KEEP1.
	DMAC_CHER_KEEP1 = 0x2000000
	// Position of KEEP2 field.
	DMAC_CHER_KEEP2_Pos = 0x1a
	// Bit mask of KEEP2 field.
	DMAC_CHER_KEEP2_Msk = 0x4000000
	// Bit KEEP2.
	DMAC_CHER_KEEP2 = 0x4000000
	// Position of KEEP3 field.
	DMAC_CHER_KEEP3_Pos = 0x1b
	// Bit mask of KEEP3 field.
	DMAC_CHER_KEEP3_Msk = 0x8000000
	// Bit KEEP3.
	DMAC_CHER_KEEP3 = 0x8000000
	// Position of KEEP4 field.
	DMAC_CHER_KEEP4_Pos = 0x1c
	// Bit mask of KEEP4 field.
	DMAC_CHER_KEEP4_Msk = 0x10000000
	// Bit KEEP4.
	DMAC_CHER_KEEP4 = 0x10000000
	// Position of KEEP5 field.
	DMAC_CHER_KEEP5_Pos = 0x1d
	// Bit mask of KEEP5 field.
	DMAC_CHER_KEEP5_Msk = 0x20000000
	// Bit KEEP5.
	DMAC_CHER_KEEP5 = 0x20000000

	// CHDR: DMAC Channel Handler Disable Register
	// Position of DIS0 field.
	DMAC_CHDR_DIS0_Pos = 0x0
	// Bit mask of DIS0 field.
	DMAC_CHDR_DIS0_Msk = 0x1
	// Bit DIS0.
	DMAC_CHDR_DIS0 = 0x1
	// Position of DIS1 field.
	DMAC_CHDR_DIS1_Pos = 0x1
	// Bit mask of DIS1 field.
	DMAC_CHDR_DIS1_Msk = 0x2
	// Bit DIS1.
	DMAC_CHDR_DIS1 = 0x2
	// Position of DIS2 field.
	DMAC_CHDR_DIS2_Pos = 0x2
	// Bit mask of DIS2 field.
	DMAC_CHDR_DIS2_Msk = 0x4
	// Bit DIS2.
	DMAC_CHDR_DIS2 = 0x4
	// Position of DIS3 field.
	DMAC_CHDR_DIS3_Pos = 0x3
	// Bit mask of DIS3 field.
	DMAC_CHDR_DIS3_Msk = 0x8
	// Bit DIS3.
	DMAC_CHDR_DIS3 = 0x8
	// Position of DIS4 field.
	DMAC_CHDR_DIS4_Pos = 0x4
	// Bit mask of DIS4 field.
	DMAC_CHDR_DIS4_Msk = 0x10
	// Bit DIS4.
	DMAC_CHDR_DIS4 = 0x10
	// Position of DIS5 field.
	DMAC_CHDR_DIS5_Pos = 0x5
	// Bit mask of DIS5 field.
	DMAC_CHDR_DIS5_Msk = 0x20
	// Bit DIS5.
	DMAC_CHDR_DIS5 = 0x20
	// Position of RES0 field.
	DMAC_CHDR_RES0_Pos = 0x8
	// Bit mask of RES0 field.
	DMAC_CHDR_RES0_Msk = 0x100
	// Bit RES0.
	DMAC_CHDR_RES0 = 0x100
	// Position of RES1 field.
	DMAC_CHDR_RES1_Pos = 0x9
	// Bit mask of RES1 field.
	DMAC_CHDR_RES1_Msk = 0x200
	// Bit RES1.
	DMAC_CHDR_RES1 = 0x200
	// Position of RES2 field.
	DMAC_CHDR_RES2_Pos = 0xa
	// Bit mask of RES2 field.
	DMAC_CHDR_RES2_Msk = 0x400
	// Bit RES2.
	DMAC_CHDR_RES2 = 0x400
	// Position of RES3 field.
	DMAC_CHDR_RES3_Pos = 0xb
	// Bit mask of RES3 field.
	DMAC_CHDR_RES3_Msk = 0x800
	// Bit RES3.
	DMAC_CHDR_RES3 = 0x800
	// Position of RES4 field.
	DMAC_CHDR_RES4_Pos = 0xc
	// Bit mask of RES4 field.
	DMAC_CHDR_RES4_Msk = 0x1000
	// Bit RES4.
	DMAC_CHDR_RES4 = 0x1000
	// Position of RES5 field.
	DMAC_CHDR_RES5_Pos = 0xd
	// Bit mask of RES5 field.
	DMAC_CHDR_RES5_Msk = 0x2000
	// Bit RES5.
	DMAC_CHDR_RES5 = 0x2000

	// CHSR: DMAC Channel Handler Status Register
	// Position of ENA0 field.
	DMAC_CHSR_ENA0_Pos = 0x0
	// Bit mask of ENA0 field.
	DMAC_CHSR_ENA0_Msk = 0x1
	// Bit ENA0.
	DMAC_CHSR_ENA0 = 0x1
	// Position of ENA1 field.
	DMAC_CHSR_ENA1_Pos = 0x1
	// Bit mask of ENA1 field.
	DMAC_CHSR_ENA1_Msk = 0x2
	// Bit ENA1.
	DMAC_CHSR_ENA1 = 0x2
	// Position of ENA2 field.
	DMAC_CHSR_ENA2_Pos = 0x2
	// Bit mask of ENA2 field.
	DMAC_CHSR_ENA2_Msk = 0x4
	// Bit ENA2.
	DMAC_CHSR_ENA2 = 0x4
	// Position of ENA3 field.
	DMAC_CHSR_ENA3_Pos = 0x3
	// Bit mask of ENA3 field.
	DMAC_CHSR_ENA3_Msk = 0x8
	// Bit ENA3.
	DMAC_CHSR_ENA3 = 0x8
	// Position of ENA4 field.
	DMAC_CHSR_ENA4_Pos = 0x4
	// Bit mask of ENA4 field.
	DMAC_CHSR_ENA4_Msk = 0x10
	// Bit ENA4.
	DMAC_CHSR_ENA4 = 0x10
	// Position of ENA5 field.
	DMAC_CHSR_ENA5_Pos = 0x5
	// Bit mask of ENA5 field.
	DMAC_CHSR_ENA5_Msk = 0x20
	// Bit ENA5.
	DMAC_CHSR_ENA5 = 0x20
	// Position of SUSP0 field.
	DMAC_CHSR_SUSP0_Pos = 0x8
	// Bit mask of SUSP0 field.
	DMAC_CHSR_SUSP0_Msk = 0x100
	// Bit SUSP0.
	DMAC_CHSR_SUSP0 = 0x100
	// Position of SUSP1 field.
	DMAC_CHSR_SUSP1_Pos = 0x9
	// Bit mask of SUSP1 field.
	DMAC_CHSR_SUSP1_Msk = 0x200
	// Bit SUSP1.
	DMAC_CHSR_SUSP1 = 0x200
	// Position of SUSP2 field.
	DMAC_CHSR_SUSP2_Pos = 0xa
	// Bit mask of SUSP2 field.
	DMAC_CHSR_SUSP2_Msk = 0x400
	// Bit SUSP2.
	DMAC_CHSR_SUSP2 = 0x400
	// Position of SUSP3 field.
	DMAC_CHSR_SUSP3_Pos = 0xb
	// Bit mask of SUSP3 field.
	DMAC_CHSR_SUSP3_Msk = 0x800
	// Bit SUSP3.
	DMAC_CHSR_SUSP3 = 0x800
	// Position of SUSP4 field.
	DMAC_CHSR_SUSP4_Pos = 0xc
	// Bit mask of SUSP4 field.
	DMAC_CHSR_SUSP4_Msk = 0x1000
	// Bit SUSP4.
	DMAC_CHSR_SUSP4 = 0x1000
	// Position of SUSP5 field.
	DMAC_CHSR_SUSP5_Pos = 0xd
	// Bit mask of SUSP5 field.
	DMAC_CHSR_SUSP5_Msk = 0x2000
	// Bit SUSP5.
	DMAC_CHSR_SUSP5 = 0x2000
	// Position of EMPT0 field.
	DMAC_CHSR_EMPT0_Pos = 0x10
	// Bit mask of EMPT0 field.
	DMAC_CHSR_EMPT0_Msk = 0x10000
	// Bit EMPT0.
	DMAC_CHSR_EMPT0 = 0x10000
	// Position of EMPT1 field.
	DMAC_CHSR_EMPT1_Pos = 0x11
	// Bit mask of EMPT1 field.
	DMAC_CHSR_EMPT1_Msk = 0x20000
	// Bit EMPT1.
	DMAC_CHSR_EMPT1 = 0x20000
	// Position of EMPT2 field.
	DMAC_CHSR_EMPT2_Pos = 0x12
	// Bit mask of EMPT2 field.
	DMAC_CHSR_EMPT2_Msk = 0x40000
	// Bit EMPT2.
	DMAC_CHSR_EMPT2 = 0x40000
	// Position of EMPT3 field.
	DMAC_CHSR_EMPT3_Pos = 0x13
	// Bit mask of EMPT3 field.
	DMAC_CHSR_EMPT3_Msk = 0x80000
	// Bit EMPT3.
	DMAC_CHSR_EMPT3 = 0x80000
	// Position of EMPT4 field.
	DMAC_CHSR_EMPT4_Pos = 0x14
	// Bit mask of EMPT4 field.
	DMAC_CHSR_EMPT4_Msk = 0x100000
	// Bit EMPT4.
	DMAC_CHSR_EMPT4 = 0x100000
	// Position of EMPT5 field.
	DMAC_CHSR_EMPT5_Pos = 0x15
	// Bit mask of EMPT5 field.
	DMAC_CHSR_EMPT5_Msk = 0x200000
	// Bit EMPT5.
	DMAC_CHSR_EMPT5 = 0x200000
	// Position of STAL0 field.
	DMAC_CHSR_STAL0_Pos = 0x18
	// Bit mask of STAL0 field.
	DMAC_CHSR_STAL0_Msk = 0x1000000
	// Bit STAL0.
	DMAC_CHSR_STAL0 = 0x1000000
	// Position of STAL1 field.
	DMAC_CHSR_STAL1_Pos = 0x19
	// Bit mask of STAL1 field.
	DMAC_CHSR_STAL1_Msk = 0x2000000
	// Bit STAL1.
	DMAC_CHSR_STAL1 = 0x2000000
	// Position of STAL2 field.
	DMAC_CHSR_STAL2_Pos = 0x1a
	// Bit mask of STAL2 field.
	DMAC_CHSR_STAL2_Msk = 0x4000000
	// Bit STAL2.
	DMAC_CHSR_STAL2 = 0x4000000
	// Position of STAL3 field.
	DMAC_CHSR_STAL3_Pos = 0x1b
	// Bit mask of STAL3 field.
	DMAC_CHSR_STAL3_Msk = 0x8000000
	// Bit STAL3.
	DMAC_CHSR_STAL3 = 0x8000000
	// Position of STAL4 field.
	DMAC_CHSR_STAL4_Pos = 0x1c
	// Bit mask of STAL4 field.
	DMAC_CHSR_STAL4_Msk = 0x10000000
	// Bit STAL4.
	DMAC_CHSR_STAL4 = 0x10000000
	// Position of STAL5 field.
	DMAC_CHSR_STAL5_Pos = 0x1d
	// Bit mask of STAL5 field.
	DMAC_CHSR_STAL5_Msk = 0x20000000
	// Bit STAL5.
	DMAC_CHSR_STAL5 = 0x20000000

	// SADDR0: DMAC Channel Source Address Register (ch_num = 0)
	// Position of SADDR field.
	DMAC_SADDR0_SADDR_Pos = 0x0
	// Bit mask of SADDR field.
	DMAC_SADDR0_SADDR_Msk = 0xffffffff

	// DADDR0: DMAC Channel Destination Address Register (ch_num = 0)
	// Position of DADDR field.
	DMAC_DADDR0_DADDR_Pos = 0x0
	// Bit mask of DADDR field.
	DMAC_DADDR0_DADDR_Msk = 0xffffffff

	// DSCR0: DMAC Channel Descriptor Address Register (ch_num = 0)
	// Position of DSCR field.
	DMAC_DSCR0_DSCR_Pos = 0x2
	// Bit mask of DSCR field.
	DMAC_DSCR0_DSCR_Msk = 0xfffffffc

	// CTRLA0: DMAC Channel Control A Register (ch_num = 0)
	// Position of BTSIZE field.
	DMAC_CTRLA0_BTSIZE_Pos = 0x0
	// Bit mask of BTSIZE field.
	DMAC_CTRLA0_BTSIZE_Msk = 0xffff
	// Position of SCSIZE field.
	DMAC_CTRLA0_SCSIZE_Pos = 0x10
	// Bit mask of SCSIZE field.
	DMAC_CTRLA0_SCSIZE_Msk = 0x70000
	// 1 data transferred
	DMAC_CTRLA0_SCSIZE_CHK_1 = 0x0
	// 4 data transferred
	DMAC_CTRLA0_SCSIZE_CHK_4 = 0x1
	// 8 data transferred
	DMAC_CTRLA0_SCSIZE_CHK_8 = 0x2
	// 16 data transferred
	DMAC_CTRLA0_SCSIZE_CHK_16 = 0x3
	// Position of DCSIZE field.
	DMAC_CTRLA0_DCSIZE_Pos = 0x14
	// Bit mask of DCSIZE field.
	DMAC_CTRLA0_DCSIZE_Msk = 0x700000
	// 1 data transferred
	DMAC_CTRLA0_DCSIZE_CHK_1 = 0x0
	// 4 data transferred
	DMAC_CTRLA0_DCSIZE_CHK_4 = 0x1
	// 8 data transferred
	DMAC_CTRLA0_DCSIZE_CHK_8 = 0x2
	// 16 data transferred
	DMAC_CTRLA0_DCSIZE_CHK_16 = 0x3
	// Position of SRC_WIDTH field.
	DMAC_CTRLA0_SRC_WIDTH_Pos = 0x18
	// Bit mask of SRC_WIDTH field.
	DMAC_CTRLA0_SRC_WIDTH_Msk = 0x3000000
	// the transfer size is set to 8-bit width
	DMAC_CTRLA0_SRC_WIDTH_BYTE = 0x0
	// the transfer size is set to 16-bit width
	DMAC_CTRLA0_SRC_WIDTH_HALF_WORD = 0x1
	// the transfer size is set to 32-bit width
	DMAC_CTRLA0_SRC_WIDTH_WORD = 0x2
	// Position of DST_WIDTH field.
	DMAC_CTRLA0_DST_WIDTH_Pos = 0x1c
	// Bit mask of DST_WIDTH field.
	DMAC_CTRLA0_DST_WIDTH_Msk = 0x30000000
	// the transfer size is set to 8-bit width
	DMAC_CTRLA0_DST_WIDTH_BYTE = 0x0
	// the transfer size is set to 16-bit width
	DMAC_CTRLA0_DST_WIDTH_HALF_WORD = 0x1
	// the transfer size is set to 32-bit width
	DMAC_CTRLA0_DST_WIDTH_WORD = 0x2
	// Position of DONE field.
	DMAC_CTRLA0_DONE_Pos = 0x1f
	// Bit mask of DONE field.
	DMAC_CTRLA0_DONE_Msk = 0x80000000
	// Bit DONE.
	DMAC_CTRLA0_DONE = 0x80000000

	// CTRLB0: DMAC Channel Control B Register (ch_num = 0)
	// Position of SRC_DSCR field.
	DMAC_CTRLB0_SRC_DSCR_Pos = 0x10
	// Bit mask of SRC_DSCR field.
	DMAC_CTRLB0_SRC_DSCR_Msk = 0x10000
	// Bit SRC_DSCR.
	DMAC_CTRLB0_SRC_DSCR = 0x10000
	// Source address is updated when the descriptor is fetched from the memory.
	DMAC_CTRLB0_SRC_DSCR_FETCH_FROM_MEM = 0x0
	// Buffer Descriptor Fetch operation is disabled for the source.
	DMAC_CTRLB0_SRC_DSCR_FETCH_DISABLE = 0x1
	// Position of DST_DSCR field.
	DMAC_CTRLB0_DST_DSCR_Pos = 0x14
	// Bit mask of DST_DSCR field.
	DMAC_CTRLB0_DST_DSCR_Msk = 0x100000
	// Bit DST_DSCR.
	DMAC_CTRLB0_DST_DSCR = 0x100000
	// Destination address is updated when the descriptor is fetched from the memory.
	DMAC_CTRLB0_DST_DSCR_FETCH_FROM_MEM = 0x0
	// Buffer Descriptor Fetch operation is disabled for the destination.
	DMAC_CTRLB0_DST_DSCR_FETCH_DISABLE = 0x1
	// Position of FC field.
	DMAC_CTRLB0_FC_Pos = 0x15
	// Bit mask of FC field.
	DMAC_CTRLB0_FC_Msk = 0x600000
	// Memory-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB0_FC_MEM2MEM_DMA_FC = 0x0
	// Memory-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB0_FC_MEM2PER_DMA_FC = 0x1
	// Peripheral-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB0_FC_PER2MEM_DMA_FC = 0x2
	// Peripheral-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB0_FC_PER2PER_DMA_FC = 0x3
	// Position of SRC_INCR field.
	DMAC_CTRLB0_SRC_INCR_Pos = 0x18
	// Bit mask of SRC_INCR field.
	DMAC_CTRLB0_SRC_INCR_Msk = 0x3000000
	// The source address is incremented
	DMAC_CTRLB0_SRC_INCR_INCREMENTING = 0x0
	// The source address is decremented
	DMAC_CTRLB0_SRC_INCR_DECREMENTING = 0x1
	// The source address remains unchanged
	DMAC_CTRLB0_SRC_INCR_FIXED = 0x2
	// Position of DST_INCR field.
	DMAC_CTRLB0_DST_INCR_Pos = 0x1c
	// Bit mask of DST_INCR field.
	DMAC_CTRLB0_DST_INCR_Msk = 0x30000000
	// The destination address is incremented
	DMAC_CTRLB0_DST_INCR_INCREMENTING = 0x0
	// The destination address is decremented
	DMAC_CTRLB0_DST_INCR_DECREMENTING = 0x1
	// The destination address remains unchanged
	DMAC_CTRLB0_DST_INCR_FIXED = 0x2
	// Position of IEN field.
	DMAC_CTRLB0_IEN_Pos = 0x1e
	// Bit mask of IEN field.
	DMAC_CTRLB0_IEN_Msk = 0x40000000
	// Bit IEN.
	DMAC_CTRLB0_IEN = 0x40000000

	// CFG0: DMAC Channel Configuration Register (ch_num = 0)
	// Position of SRC_PER field.
	DMAC_CFG0_SRC_PER_Pos = 0x0
	// Bit mask of SRC_PER field.
	DMAC_CFG0_SRC_PER_Msk = 0xf
	// Position of DST_PER field.
	DMAC_CFG0_DST_PER_Pos = 0x4
	// Bit mask of DST_PER field.
	DMAC_CFG0_DST_PER_Msk = 0xf0
	// Position of SRC_H2SEL field.
	DMAC_CFG0_SRC_H2SEL_Pos = 0x9
	// Bit mask of SRC_H2SEL field.
	DMAC_CFG0_SRC_H2SEL_Msk = 0x200
	// Bit SRC_H2SEL.
	DMAC_CFG0_SRC_H2SEL = 0x200
	// Software handshaking interface is used to trigger a transfer request.
	DMAC_CFG0_SRC_H2SEL_SW = 0x0
	// Hardware handshaking interface is used to trigger a transfer request.
	DMAC_CFG0_SRC_H2SEL_HW = 0x1
	// Position of DST_H2SEL field.
	DMAC_CFG0_DST_H2SEL_Pos = 0xd
	// Bit mask of DST_H2SEL field.
	DMAC_CFG0_DST_H2SEL_Msk = 0x2000
	// Bit DST_H2SEL.
	DMAC_CFG0_DST_H2SEL = 0x2000
	// Software handshaking interface is used to trigger a transfer request.
	DMAC_CFG0_DST_H2SEL_SW = 0x0
	// Hardware handshaking interface is used to trigger a transfer request.
	DMAC_CFG0_DST_H2SEL_HW = 0x1
	// Position of SOD field.
	DMAC_CFG0_SOD_Pos = 0x10
	// Bit mask of SOD field.
	DMAC_CFG0_SOD_Msk = 0x10000
	// Bit SOD.
	DMAC_CFG0_SOD = 0x10000
	// STOP ON DONE disabled, the descriptor fetch operation ignores DONE Field of CTRLA register.
	DMAC_CFG0_SOD_DISABLE = 0x0
	// STOP ON DONE activated, the DMAC module is automatically disabled if DONE FIELD is set to 1.
	DMAC_CFG0_SOD_ENABLE = 0x1
	// Position of LOCK_IF field.
	DMAC_CFG0_LOCK_IF_Pos = 0x14
	// Bit mask of LOCK_IF field.
	DMAC_CFG0_LOCK_IF_Msk = 0x100000
	// Bit LOCK_IF.
	DMAC_CFG0_LOCK_IF = 0x100000
	// Interface Lock capability is disabled
	DMAC_CFG0_LOCK_IF_DISABLE = 0x0
	// Interface Lock capability is enabled
	DMAC_CFG0_LOCK_IF_ENABLE = 0x1
	// Position of LOCK_B field.
	DMAC_CFG0_LOCK_B_Pos = 0x15
	// Bit mask of LOCK_B field.
	DMAC_CFG0_LOCK_B_Msk = 0x200000
	// Bit LOCK_B.
	DMAC_CFG0_LOCK_B = 0x200000
	// AHB Bus Locking capability is disabled.
	DMAC_CFG0_LOCK_B_DISABLE = 0x0
	// Position of LOCK_IF_L field.
	DMAC_CFG0_LOCK_IF_L_Pos = 0x16
	// Bit mask of LOCK_IF_L field.
	DMAC_CFG0_LOCK_IF_L_Msk = 0x400000
	// Bit LOCK_IF_L.
	DMAC_CFG0_LOCK_IF_L = 0x400000
	// The Master Interface Arbiter is locked by the channel x for a chunk transfer.
	DMAC_CFG0_LOCK_IF_L_CHUNK = 0x0
	// The Master Interface Arbiter is locked by the channel x for a buffer transfer.
	DMAC_CFG0_LOCK_IF_L_BUFFER = 0x1
	// Position of AHB_PROT field.
	DMAC_CFG0_AHB_PROT_Pos = 0x18
	// Bit mask of AHB_PROT field.
	DMAC_CFG0_AHB_PROT_Msk = 0x7000000
	// Position of FIFOCFG field.
	DMAC_CFG0_FIFOCFG_Pos = 0x1c
	// Bit mask of FIFOCFG field.
	DMAC_CFG0_FIFOCFG_Msk = 0x30000000
	// The largest defined length AHB burst is performed on the destination AHB interface.
	DMAC_CFG0_FIFOCFG_ALAP_CFG = 0x0
	// When half FIFO size is available/filled, a source/destination request is serviced.
	DMAC_CFG0_FIFOCFG_HALF_CFG = 0x1
	// When there is enough space/data available to perform a single AHB access, then the request is serviced.
	DMAC_CFG0_FIFOCFG_ASAP_CFG = 0x2

	// SADDR1: DMAC Channel Source Address Register (ch_num = 1)
	// Position of SADDR field.
	DMAC_SADDR1_SADDR_Pos = 0x0
	// Bit mask of SADDR field.
	DMAC_SADDR1_SADDR_Msk = 0xffffffff

	// DADDR1: DMAC Channel Destination Address Register (ch_num = 1)
	// Position of DADDR field.
	DMAC_DADDR1_DADDR_Pos = 0x0
	// Bit mask of DADDR field.
	DMAC_DADDR1_DADDR_Msk = 0xffffffff

	// DSCR1: DMAC Channel Descriptor Address Register (ch_num = 1)
	// Position of DSCR field.
	DMAC_DSCR1_DSCR_Pos = 0x2
	// Bit mask of DSCR field.
	DMAC_DSCR1_DSCR_Msk = 0xfffffffc

	// CTRLA1: DMAC Channel Control A Register (ch_num = 1)
	// Position of BTSIZE field.
	DMAC_CTRLA1_BTSIZE_Pos = 0x0
	// Bit mask of BTSIZE field.
	DMAC_CTRLA1_BTSIZE_Msk = 0xffff
	// Position of SCSIZE field.
	DMAC_CTRLA1_SCSIZE_Pos = 0x10
	// Bit mask of SCSIZE field.
	DMAC_CTRLA1_SCSIZE_Msk = 0x70000
	// 1 data transferred
	DMAC_CTRLA1_SCSIZE_CHK_1 = 0x0
	// 4 data transferred
	DMAC_CTRLA1_SCSIZE_CHK_4 = 0x1
	// 8 data transferred
	DMAC_CTRLA1_SCSIZE_CHK_8 = 0x2
	// 16 data transferred
	DMAC_CTRLA1_SCSIZE_CHK_16 = 0x3
	// Position of DCSIZE field.
	DMAC_CTRLA1_DCSIZE_Pos = 0x14
	// Bit mask of DCSIZE field.
	DMAC_CTRLA1_DCSIZE_Msk = 0x700000
	// 1 data transferred
	DMAC_CTRLA1_DCSIZE_CHK_1 = 0x0
	// 4 data transferred
	DMAC_CTRLA1_DCSIZE_CHK_4 = 0x1
	// 8 data transferred
	DMAC_CTRLA1_DCSIZE_CHK_8 = 0x2
	// 16 data transferred
	DMAC_CTRLA1_DCSIZE_CHK_16 = 0x3
	// Position of SRC_WIDTH field.
	DMAC_CTRLA1_SRC_WIDTH_Pos = 0x18
	// Bit mask of SRC_WIDTH field.
	DMAC_CTRLA1_SRC_WIDTH_Msk = 0x3000000
	// the transfer size is set to 8-bit width
	DMAC_CTRLA1_SRC_WIDTH_BYTE = 0x0
	// the transfer size is set to 16-bit width
	DMAC_CTRLA1_SRC_WIDTH_HALF_WORD = 0x1
	// the transfer size is set to 32-bit width
	DMAC_CTRLA1_SRC_WIDTH_WORD = 0x2
	// Position of DST_WIDTH field.
	DMAC_CTRLA1_DST_WIDTH_Pos = 0x1c
	// Bit mask of DST_WIDTH field.
	DMAC_CTRLA1_DST_WIDTH_Msk = 0x30000000
	// the transfer size is set to 8-bit width
	DMAC_CTRLA1_DST_WIDTH_BYTE = 0x0
	// the transfer size is set to 16-bit width
	DMAC_CTRLA1_DST_WIDTH_HALF_WORD = 0x1
	// the transfer size is set to 32-bit width
	DMAC_CTRLA1_DST_WIDTH_WORD = 0x2
	// Position of DONE field.
	DMAC_CTRLA1_DONE_Pos = 0x1f
	// Bit mask of DONE field.
	DMAC_CTRLA1_DONE_Msk = 0x80000000
	// Bit DONE.
	DMAC_CTRLA1_DONE = 0x80000000

	// CTRLB1: DMAC Channel Control B Register (ch_num = 1)
	// Position of SRC_DSCR field.
	DMAC_CTRLB1_SRC_DSCR_Pos = 0x10
	// Bit mask of SRC_DSCR field.
	DMAC_CTRLB1_SRC_DSCR_Msk = 0x10000
	// Bit SRC_DSCR.
	DMAC_CTRLB1_SRC_DSCR = 0x10000
	// Source address is updated when the descriptor is fetched from the memory.
	DMAC_CTRLB1_SRC_DSCR_FETCH_FROM_MEM = 0x0
	// Buffer Descriptor Fetch operation is disabled for the source.
	DMAC_CTRLB1_SRC_DSCR_FETCH_DISABLE = 0x1
	// Position of DST_DSCR field.
	DMAC_CTRLB1_DST_DSCR_Pos = 0x14
	// Bit mask of DST_DSCR field.
	DMAC_CTRLB1_DST_DSCR_Msk = 0x100000
	// Bit DST_DSCR.
	DMAC_CTRLB1_DST_DSCR = 0x100000
	// Destination address is updated when the descriptor is fetched from the memory.
	DMAC_CTRLB1_DST_DSCR_FETCH_FROM_MEM = 0x0
	// Buffer Descriptor Fetch operation is disabled for the destination.
	DMAC_CTRLB1_DST_DSCR_FETCH_DISABLE = 0x1
	// Position of FC field.
	DMAC_CTRLB1_FC_Pos = 0x15
	// Bit mask of FC field.
	DMAC_CTRLB1_FC_Msk = 0x600000
	// Memory-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB1_FC_MEM2MEM_DMA_FC = 0x0
	// Memory-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB1_FC_MEM2PER_DMA_FC = 0x1
	// Peripheral-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB1_FC_PER2MEM_DMA_FC = 0x2
	// Peripheral-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB1_FC_PER2PER_DMA_FC = 0x3
	// Position of SRC_INCR field.
	DMAC_CTRLB1_SRC_INCR_Pos = 0x18
	// Bit mask of SRC_INCR field.
	DMAC_CTRLB1_SRC_INCR_Msk = 0x3000000
	// The source address is incremented
	DMAC_CTRLB1_SRC_INCR_INCREMENTING = 0x0
	// The source address is decremented
	DMAC_CTRLB1_SRC_INCR_DECREMENTING = 0x1
	// The source address remains unchanged
	DMAC_CTRLB1_SRC_INCR_FIXED = 0x2
	// Position of DST_INCR field.
	DMAC_CTRLB1_DST_INCR_Pos = 0x1c
	// Bit mask of DST_INCR field.
	DMAC_CTRLB1_DST_INCR_Msk = 0x30000000
	// The destination address is incremented
	DMAC_CTRLB1_DST_INCR_INCREMENTING = 0x0
	// The destination address is decremented
	DMAC_CTRLB1_DST_INCR_DECREMENTING = 0x1
	// The destination address remains unchanged
	DMAC_CTRLB1_DST_INCR_FIXED = 0x2
	// Position of IEN field.
	DMAC_CTRLB1_IEN_Pos = 0x1e
	// Bit mask of IEN field.
	DMAC_CTRLB1_IEN_Msk = 0x40000000
	// Bit IEN.
	DMAC_CTRLB1_IEN = 0x40000000

	// CFG1: DMAC Channel Configuration Register (ch_num = 1)
	// Position of SRC_PER field.
	DMAC_CFG1_SRC_PER_Pos = 0x0
	// Bit mask of SRC_PER field.
	DMAC_CFG1_SRC_PER_Msk = 0xf
	// Position of DST_PER field.
	DMAC_CFG1_DST_PER_Pos = 0x4
	// Bit mask of DST_PER field.
	DMAC_CFG1_DST_PER_Msk = 0xf0
	// Position of SRC_H2SEL field.
	DMAC_CFG1_SRC_H2SEL_Pos = 0x9
	// Bit mask of SRC_H2SEL field.
	DMAC_CFG1_SRC_H2SEL_Msk = 0x200
	// Bit SRC_H2SEL.
	DMAC_CFG1_SRC_H2SEL = 0x200
	// Software handshaking interface is used to trigger a transfer request.
	DMAC_CFG1_SRC_H2SEL_SW = 0x0
	// Hardware handshaking interface is used to trigger a transfer request.
	DMAC_CFG1_SRC_H2SEL_HW = 0x1
	// Position of DST_H2SEL field.
	DMAC_CFG1_DST_H2SEL_Pos = 0xd
	// Bit mask of DST_H2SEL field.
	DMAC_CFG1_DST_H2SEL_Msk = 0x2000
	// Bit DST_H2SEL.
	DMAC_CFG1_DST_H2SEL = 0x2000
	// Software handshaking interface is used to trigger a transfer request.
	DMAC_CFG1_DST_H2SEL_SW = 0x0
	// Hardware handshaking interface is used to trigger a transfer request.
	DMAC_CFG1_DST_H2SEL_HW = 0x1
	// Position of SOD field.
	DMAC_CFG1_SOD_Pos = 0x10
	// Bit mask of SOD field.
	DMAC_CFG1_SOD_Msk = 0x10000
	// Bit SOD.
	DMAC_CFG1_SOD = 0x10000
	// STOP ON DONE disabled, the descriptor fetch operation ignores DONE Field of CTRLA register.
	DMAC_CFG1_SOD_DISABLE = 0x0
	// STOP ON DONE activated, the DMAC module is automatically disabled if DONE FIELD is set to 1.
	DMAC_CFG1_SOD_ENABLE = 0x1
	// Position of LOCK_IF field.
	DMAC_CFG1_LOCK_IF_Pos = 0x14
	// Bit mask of LOCK_IF field.
	DMAC_CFG1_LOCK_IF_Msk = 0x100000
	// Bit LOCK_IF.
	DMAC_CFG1_LOCK_IF = 0x100000
	// Interface Lock capability is disabled
	DMAC_CFG1_LOCK_IF_DISABLE = 0x0
	// Interface Lock capability is enabled
	DMAC_CFG1_LOCK_IF_ENABLE = 0x1
	// Position of LOCK_B field.
	DMAC_CFG1_LOCK_B_Pos = 0x15
	// Bit mask of LOCK_B field.
	DMAC_CFG1_LOCK_B_Msk = 0x200000
	// Bit LOCK_B.
	DMAC_CFG1_LOCK_B = 0x200000
	// AHB Bus Locking capability is disabled.
	DMAC_CFG1_LOCK_B_DISABLE = 0x0
	// Position of LOCK_IF_L field.
	DMAC_CFG1_LOCK_IF_L_Pos = 0x16
	// Bit mask of LOCK_IF_L field.
	DMAC_CFG1_LOCK_IF_L_Msk = 0x400000
	// Bit LOCK_IF_L.
	DMAC_CFG1_LOCK_IF_L = 0x400000
	// The Master Interface Arbiter is locked by the channel x for a chunk transfer.
	DMAC_CFG1_LOCK_IF_L_CHUNK = 0x0
	// The Master Interface Arbiter is locked by the channel x for a buffer transfer.
	DMAC_CFG1_LOCK_IF_L_BUFFER = 0x1
	// Position of AHB_PROT field.
	DMAC_CFG1_AHB_PROT_Pos = 0x18
	// Bit mask of AHB_PROT field.
	DMAC_CFG1_AHB_PROT_Msk = 0x7000000
	// Position of FIFOCFG field.
	DMAC_CFG1_FIFOCFG_Pos = 0x1c
	// Bit mask of FIFOCFG field.
	DMAC_CFG1_FIFOCFG_Msk = 0x30000000
	// The largest defined length AHB burst is performed on the destination AHB interface.
	DMAC_CFG1_FIFOCFG_ALAP_CFG = 0x0
	// When half FIFO size is available/filled, a source/destination request is serviced.
	DMAC_CFG1_FIFOCFG_HALF_CFG = 0x1
	// When there is enough space/data available to perform a single AHB access, then the request is serviced.
	DMAC_CFG1_FIFOCFG_ASAP_CFG = 0x2

	// SADDR2: DMAC Channel Source Address Register (ch_num = 2)
	// Position of SADDR field.
	DMAC_SADDR2_SADDR_Pos = 0x0
	// Bit mask of SADDR field.
	DMAC_SADDR2_SADDR_Msk = 0xffffffff

	// DADDR2: DMAC Channel Destination Address Register (ch_num = 2)
	// Position of DADDR field.
	DMAC_DADDR2_DADDR_Pos = 0x0
	// Bit mask of DADDR field.
	DMAC_DADDR2_DADDR_Msk = 0xffffffff

	// DSCR2: DMAC Channel Descriptor Address Register (ch_num = 2)
	// Position of DSCR field.
	DMAC_DSCR2_DSCR_Pos = 0x2
	// Bit mask of DSCR field.
	DMAC_DSCR2_DSCR_Msk = 0xfffffffc

	// CTRLA2: DMAC Channel Control A Register (ch_num = 2)
	// Position of BTSIZE field.
	DMAC_CTRLA2_BTSIZE_Pos = 0x0
	// Bit mask of BTSIZE field.
	DMAC_CTRLA2_BTSIZE_Msk = 0xffff
	// Position of SCSIZE field.
	DMAC_CTRLA2_SCSIZE_Pos = 0x10
	// Bit mask of SCSIZE field.
	DMAC_CTRLA2_SCSIZE_Msk = 0x70000
	// 1 data transferred
	DMAC_CTRLA2_SCSIZE_CHK_1 = 0x0
	// 4 data transferred
	DMAC_CTRLA2_SCSIZE_CHK_4 = 0x1
	// 8 data transferred
	DMAC_CTRLA2_SCSIZE_CHK_8 = 0x2
	// 16 data transferred
	DMAC_CTRLA2_SCSIZE_CHK_16 = 0x3
	// Position of DCSIZE field.
	DMAC_CTRLA2_DCSIZE_Pos = 0x14
	// Bit mask of DCSIZE field.
	DMAC_CTRLA2_DCSIZE_Msk = 0x700000
	// 1 data transferred
	DMAC_CTRLA2_DCSIZE_CHK_1 = 0x0
	// 4 data transferred
	DMAC_CTRLA2_DCSIZE_CHK_4 = 0x1
	// 8 data transferred
	DMAC_CTRLA2_DCSIZE_CHK_8 = 0x2
	// 16 data transferred
	DMAC_CTRLA2_DCSIZE_CHK_16 = 0x3
	// Position of SRC_WIDTH field.
	DMAC_CTRLA2_SRC_WIDTH_Pos = 0x18
	// Bit mask of SRC_WIDTH field.
	DMAC_CTRLA2_SRC_WIDTH_Msk = 0x3000000
	// the transfer size is set to 8-bit width
	DMAC_CTRLA2_SRC_WIDTH_BYTE = 0x0
	// the transfer size is set to 16-bit width
	DMAC_CTRLA2_SRC_WIDTH_HALF_WORD = 0x1
	// the transfer size is set to 32-bit width
	DMAC_CTRLA2_SRC_WIDTH_WORD = 0x2
	// Position of DST_WIDTH field.
	DMAC_CTRLA2_DST_WIDTH_Pos = 0x1c
	// Bit mask of DST_WIDTH field.
	DMAC_CTRLA2_DST_WIDTH_Msk = 0x30000000
	// the transfer size is set to 8-bit width
	DMAC_CTRLA2_DST_WIDTH_BYTE = 0x0
	// the transfer size is set to 16-bit width
	DMAC_CTRLA2_DST_WIDTH_HALF_WORD = 0x1
	// the transfer size is set to 32-bit width
	DMAC_CTRLA2_DST_WIDTH_WORD = 0x2
	// Position of DONE field.
	DMAC_CTRLA2_DONE_Pos = 0x1f
	// Bit mask of DONE field.
	DMAC_CTRLA2_DONE_Msk = 0x80000000
	// Bit DONE.
	DMAC_CTRLA2_DONE = 0x80000000

	// CTRLB2: DMAC Channel Control B Register (ch_num = 2)
	// Position of SRC_DSCR field.
	DMAC_CTRLB2_SRC_DSCR_Pos = 0x10
	// Bit mask of SRC_DSCR field.
	DMAC_CTRLB2_SRC_DSCR_Msk = 0x10000
	// Bit SRC_DSCR.
	DMAC_CTRLB2_SRC_DSCR = 0x10000
	// Source address is updated when the descriptor is fetched from the memory.
	DMAC_CTRLB2_SRC_DSCR_FETCH_FROM_MEM = 0x0
	// Buffer Descriptor Fetch operation is disabled for the source.
	DMAC_CTRLB2_SRC_DSCR_FETCH_DISABLE = 0x1
	// Position of DST_DSCR field.
	DMAC_CTRLB2_DST_DSCR_Pos = 0x14
	// Bit mask of DST_DSCR field.
	DMAC_CTRLB2_DST_DSCR_Msk = 0x100000
	// Bit DST_DSCR.
	DMAC_CTRLB2_DST_DSCR = 0x100000
	// Destination address is updated when the descriptor is fetched from the memory.
	DMAC_CTRLB2_DST_DSCR_FETCH_FROM_MEM = 0x0
	// Buffer Descriptor Fetch operation is disabled for the destination.
	DMAC_CTRLB2_DST_DSCR_FETCH_DISABLE = 0x1
	// Position of FC field.
	DMAC_CTRLB2_FC_Pos = 0x15
	// Bit mask of FC field.
	DMAC_CTRLB2_FC_Msk = 0x600000
	// Memory-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB2_FC_MEM2MEM_DMA_FC = 0x0
	// Memory-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB2_FC_MEM2PER_DMA_FC = 0x1
	// Peripheral-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB2_FC_PER2MEM_DMA_FC = 0x2
	// Peripheral-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB2_FC_PER2PER_DMA_FC = 0x3
	// Position of SRC_INCR field.
	DMAC_CTRLB2_SRC_INCR_Pos = 0x18
	// Bit mask of SRC_INCR field.
	DMAC_CTRLB2_SRC_INCR_Msk = 0x3000000
	// The source address is incremented
	DMAC_CTRLB2_SRC_INCR_INCREMENTING = 0x0
	// The source address is decremented
	DMAC_CTRLB2_SRC_INCR_DECREMENTING = 0x1
	// The source address remains unchanged
	DMAC_CTRLB2_SRC_INCR_FIXED = 0x2
	// Position of DST_INCR field.
	DMAC_CTRLB2_DST_INCR_Pos = 0x1c
	// Bit mask of DST_INCR field.
	DMAC_CTRLB2_DST_INCR_Msk = 0x30000000
	// The destination address is incremented
	DMAC_CTRLB2_DST_INCR_INCREMENTING = 0x0
	// The destination address is decremented
	DMAC_CTRLB2_DST_INCR_DECREMENTING = 0x1
	// The destination address remains unchanged
	DMAC_CTRLB2_DST_INCR_FIXED = 0x2
	// Position of IEN field.
	DMAC_CTRLB2_IEN_Pos = 0x1e
	// Bit mask of IEN field.
	DMAC_CTRLB2_IEN_Msk = 0x40000000
	// Bit IEN.
	DMAC_CTRLB2_IEN = 0x40000000

	// CFG2: DMAC Channel Configuration Register (ch_num = 2)
	// Position of SRC_PER field.
	DMAC_CFG2_SRC_PER_Pos = 0x0
	// Bit mask of SRC_PER field.
	DMAC_CFG2_SRC_PER_Msk = 0xf
	// Position of DST_PER field.
	DMAC_CFG2_DST_PER_Pos = 0x4
	// Bit mask of DST_PER field.
	DMAC_CFG2_DST_PER_Msk = 0xf0
	// Position of SRC_H2SEL field.
	DMAC_CFG2_SRC_H2SEL_Pos = 0x9
	// Bit mask of SRC_H2SEL field.
	DMAC_CFG2_SRC_H2SEL_Msk = 0x200
	// Bit SRC_H2SEL.
	DMAC_CFG2_SRC_H2SEL = 0x200
	// Software handshaking interface is used to trigger a transfer request.
	DMAC_CFG2_SRC_H2SEL_SW = 0x0
	// Hardware handshaking interface is used to trigger a transfer request.
	DMAC_CFG2_SRC_H2SEL_HW = 0x1
	// Position of DST_H2SEL field.
	DMAC_CFG2_DST_H2SEL_Pos = 0xd
	// Bit mask of DST_H2SEL field.
	DMAC_CFG2_DST_H2SEL_Msk = 0x2000
	// Bit DST_H2SEL.
	DMAC_CFG2_DST_H2SEL = 0x2000
	// Software handshaking interface is used to trigger a transfer request.
	DMAC_CFG2_DST_H2SEL_SW = 0x0
	// Hardware handshaking interface is used to trigger a transfer request.
	DMAC_CFG2_DST_H2SEL_HW = 0x1
	// Position of SOD field.
	DMAC_CFG2_SOD_Pos = 0x10
	// Bit mask of SOD field.
	DMAC_CFG2_SOD_Msk = 0x10000
	// Bit SOD.
	DMAC_CFG2_SOD = 0x10000
	// STOP ON DONE disabled, the descriptor fetch operation ignores DONE Field of CTRLA register.
	DMAC_CFG2_SOD_DISABLE = 0x0
	// STOP ON DONE activated, the DMAC module is automatically disabled if DONE FIELD is set to 1.
	DMAC_CFG2_SOD_ENABLE = 0x1
	// Position of LOCK_IF field.
	DMAC_CFG2_LOCK_IF_Pos = 0x14
	// Bit mask of LOCK_IF field.
	DMAC_CFG2_LOCK_IF_Msk = 0x100000
	// Bit LOCK_IF.
	DMAC_CFG2_LOCK_IF = 0x100000
	// Interface Lock capability is disabled
	DMAC_CFG2_LOCK_IF_DISABLE = 0x0
	// Interface Lock capability is enabled
	DMAC_CFG2_LOCK_IF_ENABLE = 0x1
	// Position of LOCK_B field.
	DMAC_CFG2_LOCK_B_Pos = 0x15
	// Bit mask of LOCK_B field.
	DMAC_CFG2_LOCK_B_Msk = 0x200000
	// Bit LOCK_B.
	DMAC_CFG2_LOCK_B = 0x200000
	// AHB Bus Locking capability is disabled.
	DMAC_CFG2_LOCK_B_DISABLE = 0x0
	// Position of LOCK_IF_L field.
	DMAC_CFG2_LOCK_IF_L_Pos = 0x16
	// Bit mask of LOCK_IF_L field.
	DMAC_CFG2_LOCK_IF_L_Msk = 0x400000
	// Bit LOCK_IF_L.
	DMAC_CFG2_LOCK_IF_L = 0x400000
	// The Master Interface Arbiter is locked by the channel x for a chunk transfer.
	DMAC_CFG2_LOCK_IF_L_CHUNK = 0x0
	// The Master Interface Arbiter is locked by the channel x for a buffer transfer.
	DMAC_CFG2_LOCK_IF_L_BUFFER = 0x1
	// Position of AHB_PROT field.
	DMAC_CFG2_AHB_PROT_Pos = 0x18
	// Bit mask of AHB_PROT field.
	DMAC_CFG2_AHB_PROT_Msk = 0x7000000
	// Position of FIFOCFG field.
	DMAC_CFG2_FIFOCFG_Pos = 0x1c
	// Bit mask of FIFOCFG field.
	DMAC_CFG2_FIFOCFG_Msk = 0x30000000
	// The largest defined length AHB burst is performed on the destination AHB interface.
	DMAC_CFG2_FIFOCFG_ALAP_CFG = 0x0
	// When half FIFO size is available/filled, a source/destination request is serviced.
	DMAC_CFG2_FIFOCFG_HALF_CFG = 0x1
	// When there is enough space/data available to perform a single AHB access, then the request is serviced.
	DMAC_CFG2_FIFOCFG_ASAP_CFG = 0x2

	// SADDR3: DMAC Channel Source Address Register (ch_num = 3)
	// Position of SADDR field.
	DMAC_SADDR3_SADDR_Pos = 0x0
	// Bit mask of SADDR field.
	DMAC_SADDR3_SADDR_Msk = 0xffffffff

	// DADDR3: DMAC Channel Destination Address Register (ch_num = 3)
	// Position of DADDR field.
	DMAC_DADDR3_DADDR_Pos = 0x0
	// Bit mask of DADDR field.
	DMAC_DADDR3_DADDR_Msk = 0xffffffff

	// DSCR3: DMAC Channel Descriptor Address Register (ch_num = 3)
	// Position of DSCR field.
	DMAC_DSCR3_DSCR_Pos = 0x2
	// Bit mask of DSCR field.
	DMAC_DSCR3_DSCR_Msk = 0xfffffffc

	// CTRLA3: DMAC Channel Control A Register (ch_num = 3)
	// Position of BTSIZE field.
	DMAC_CTRLA3_BTSIZE_Pos = 0x0
	// Bit mask of BTSIZE field.
	DMAC_CTRLA3_BTSIZE_Msk = 0xffff
	// Position of SCSIZE field.
	DMAC_CTRLA3_SCSIZE_Pos = 0x10
	// Bit mask of SCSIZE field.
	DMAC_CTRLA3_SCSIZE_Msk = 0x70000
	// 1 data transferred
	DMAC_CTRLA3_SCSIZE_CHK_1 = 0x0
	// 4 data transferred
	DMAC_CTRLA3_SCSIZE_CHK_4 = 0x1
	// 8 data transferred
	DMAC_CTRLA3_SCSIZE_CHK_8 = 0x2
	// 16 data transferred
	DMAC_CTRLA3_SCSIZE_CHK_16 = 0x3
	// Position of DCSIZE field.
	DMAC_CTRLA3_DCSIZE_Pos = 0x14
	// Bit mask of DCSIZE field.
	DMAC_CTRLA3_DCSIZE_Msk = 0x700000
	// 1 data transferred
	DMAC_CTRLA3_DCSIZE_CHK_1 = 0x0
	// 4 data transferred
	DMAC_CTRLA3_DCSIZE_CHK_4 = 0x1
	// 8 data transferred
	DMAC_CTRLA3_DCSIZE_CHK_8 = 0x2
	// 16 data transferred
	DMAC_CTRLA3_DCSIZE_CHK_16 = 0x3
	// Position of SRC_WIDTH field.
	DMAC_CTRLA3_SRC_WIDTH_Pos = 0x18
	// Bit mask of SRC_WIDTH field.
	DMAC_CTRLA3_SRC_WIDTH_Msk = 0x3000000
	// the transfer size is set to 8-bit width
	DMAC_CTRLA3_SRC_WIDTH_BYTE = 0x0
	// the transfer size is set to 16-bit width
	DMAC_CTRLA3_SRC_WIDTH_HALF_WORD = 0x1
	// the transfer size is set to 32-bit width
	DMAC_CTRLA3_SRC_WIDTH_WORD = 0x2
	// Position of DST_WIDTH field.
	DMAC_CTRLA3_DST_WIDTH_Pos = 0x1c
	// Bit mask of DST_WIDTH field.
	DMAC_CTRLA3_DST_WIDTH_Msk = 0x30000000
	// the transfer size is set to 8-bit width
	DMAC_CTRLA3_DST_WIDTH_BYTE = 0x0
	// the transfer size is set to 16-bit width
	DMAC_CTRLA3_DST_WIDTH_HALF_WORD = 0x1
	// the transfer size is set to 32-bit width
	DMAC_CTRLA3_DST_WIDTH_WORD = 0x2
	// Position of DONE field.
	DMAC_CTRLA3_DONE_Pos = 0x1f
	// Bit mask of DONE field.
	DMAC_CTRLA3_DONE_Msk = 0x80000000
	// Bit DONE.
	DMAC_CTRLA3_DONE = 0x80000000

	// CTRLB3: DMAC Channel Control B Register (ch_num = 3)
	// Position of SRC_DSCR field.
	DMAC_CTRLB3_SRC_DSCR_Pos = 0x10
	// Bit mask of SRC_DSCR field.
	DMAC_CTRLB3_SRC_DSCR_Msk = 0x10000
	// Bit SRC_DSCR.
	DMAC_CTRLB3_SRC_DSCR = 0x10000
	// Source address is updated when the descriptor is fetched from the memory.
	DMAC_CTRLB3_SRC_DSCR_FETCH_FROM_MEM = 0x0
	// Buffer Descriptor Fetch operation is disabled for the source.
	DMAC_CTRLB3_SRC_DSCR_FETCH_DISABLE = 0x1
	// Position of DST_DSCR field.
	DMAC_CTRLB3_DST_DSCR_Pos = 0x14
	// Bit mask of DST_DSCR field.
	DMAC_CTRLB3_DST_DSCR_Msk = 0x100000
	// Bit DST_DSCR.
	DMAC_CTRLB3_DST_DSCR = 0x100000
	// Destination address is updated when the descriptor is fetched from the memory.
	DMAC_CTRLB3_DST_DSCR_FETCH_FROM_MEM = 0x0
	// Buffer Descriptor Fetch operation is disabled for the destination.
	DMAC_CTRLB3_DST_DSCR_FETCH_DISABLE = 0x1
	// Position of FC field.
	DMAC_CTRLB3_FC_Pos = 0x15
	// Bit mask of FC field.
	DMAC_CTRLB3_FC_Msk = 0x600000
	// Memory-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB3_FC_MEM2MEM_DMA_FC = 0x0
	// Memory-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB3_FC_MEM2PER_DMA_FC = 0x1
	// Peripheral-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB3_FC_PER2MEM_DMA_FC = 0x2
	// Peripheral-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB3_FC_PER2PER_DMA_FC = 0x3
	// Position of SRC_INCR field.
	DMAC_CTRLB3_SRC_INCR_Pos = 0x18
	// Bit mask of SRC_INCR field.
	DMAC_CTRLB3_SRC_INCR_Msk = 0x3000000
	// The source address is incremented
	DMAC_CTRLB3_SRC_INCR_INCREMENTING = 0x0
	// The source address is decremented
	DMAC_CTRLB3_SRC_INCR_DECREMENTING = 0x1
	// The source address remains unchanged
	DMAC_CTRLB3_SRC_INCR_FIXED = 0x2
	// Position of DST_INCR field.
	DMAC_CTRLB3_DST_INCR_Pos = 0x1c
	// Bit mask of DST_INCR field.
	DMAC_CTRLB3_DST_INCR_Msk = 0x30000000
	// The destination address is incremented
	DMAC_CTRLB3_DST_INCR_INCREMENTING = 0x0
	// The destination address is decremented
	DMAC_CTRLB3_DST_INCR_DECREMENTING = 0x1
	// The destination address remains unchanged
	DMAC_CTRLB3_DST_INCR_FIXED = 0x2
	// Position of IEN field.
	DMAC_CTRLB3_IEN_Pos = 0x1e
	// Bit mask of IEN field.
	DMAC_CTRLB3_IEN_Msk = 0x40000000
	// Bit IEN.
	DMAC_CTRLB3_IEN = 0x40000000

	// CFG3: DMAC Channel Configuration Register (ch_num = 3)
	// Position of SRC_PER field.
	DMAC_CFG3_SRC_PER_Pos = 0x0
	// Bit mask of SRC_PER field.
	DMAC_CFG3_SRC_PER_Msk = 0xf
	// Position of DST_PER field.
	DMAC_CFG3_DST_PER_Pos = 0x4
	// Bit mask of DST_PER field.
	DMAC_CFG3_DST_PER_Msk = 0xf0
	// Position of SRC_H2SEL field.
	DMAC_CFG3_SRC_H2SEL_Pos = 0x9
	// Bit mask of SRC_H2SEL field.
	DMAC_CFG3_SRC_H2SEL_Msk = 0x200
	// Bit SRC_H2SEL.
	DMAC_CFG3_SRC_H2SEL = 0x200
	// Software handshaking interface is used to trigger a transfer request.
	DMAC_CFG3_SRC_H2SEL_SW = 0x0
	// Hardware handshaking interface is used to trigger a transfer request.
	DMAC_CFG3_SRC_H2SEL_HW = 0x1
	// Position of DST_H2SEL field.
	DMAC_CFG3_DST_H2SEL_Pos = 0xd
	// Bit mask of DST_H2SEL field.
	DMAC_CFG3_DST_H2SEL_Msk = 0x2000
	// Bit DST_H2SEL.
	DMAC_CFG3_DST_H2SEL = 0x2000
	// Software handshaking interface is used to trigger a transfer request.
	DMAC_CFG3_DST_H2SEL_SW = 0x0
	// Hardware handshaking interface is used to trigger a transfer request.
	DMAC_CFG3_DST_H2SEL_HW = 0x1
	// Position of SOD field.
	DMAC_CFG3_SOD_Pos = 0x10
	// Bit mask of SOD field.
	DMAC_CFG3_SOD_Msk = 0x10000
	// Bit SOD.
	DMAC_CFG3_SOD = 0x10000
	// STOP ON DONE disabled, the descriptor fetch operation ignores DONE Field of CTRLA register.
	DMAC_CFG3_SOD_DISABLE = 0x0
	// STOP ON DONE activated, the DMAC module is automatically disabled if DONE FIELD is set to 1.
	DMAC_CFG3_SOD_ENABLE = 0x1
	// Position of LOCK_IF field.
	DMAC_CFG3_LOCK_IF_Pos = 0x14
	// Bit mask of LOCK_IF field.
	DMAC_CFG3_LOCK_IF_Msk = 0x100000
	// Bit LOCK_IF.
	DMAC_CFG3_LOCK_IF = 0x100000
	// Interface Lock capability is disabled
	DMAC_CFG3_LOCK_IF_DISABLE = 0x0
	// Interface Lock capability is enabled
	DMAC_CFG3_LOCK_IF_ENABLE = 0x1
	// Position of LOCK_B field.
	DMAC_CFG3_LOCK_B_Pos = 0x15
	// Bit mask of LOCK_B field.
	DMAC_CFG3_LOCK_B_Msk = 0x200000
	// Bit LOCK_B.
	DMAC_CFG3_LOCK_B = 0x200000
	// AHB Bus Locking capability is disabled.
	DMAC_CFG3_LOCK_B_DISABLE = 0x0
	// Position of LOCK_IF_L field.
	DMAC_CFG3_LOCK_IF_L_Pos = 0x16
	// Bit mask of LOCK_IF_L field.
	DMAC_CFG3_LOCK_IF_L_Msk = 0x400000
	// Bit LOCK_IF_L.
	DMAC_CFG3_LOCK_IF_L = 0x400000
	// The Master Interface Arbiter is locked by the channel x for a chunk transfer.
	DMAC_CFG3_LOCK_IF_L_CHUNK = 0x0
	// The Master Interface Arbiter is locked by the channel x for a buffer transfer.
	DMAC_CFG3_LOCK_IF_L_BUFFER = 0x1
	// Position of AHB_PROT field.
	DMAC_CFG3_AHB_PROT_Pos = 0x18
	// Bit mask of AHB_PROT field.
	DMAC_CFG3_AHB_PROT_Msk = 0x7000000
	// Position of FIFOCFG field.
	DMAC_CFG3_FIFOCFG_Pos = 0x1c
	// Bit mask of FIFOCFG field.
	DMAC_CFG3_FIFOCFG_Msk = 0x30000000
	// The largest defined length AHB burst is performed on the destination AHB interface.
	DMAC_CFG3_FIFOCFG_ALAP_CFG = 0x0
	// When half FIFO size is available/filled, a source/destination request is serviced.
	DMAC_CFG3_FIFOCFG_HALF_CFG = 0x1
	// When there is enough space/data available to perform a single AHB access, then the request is serviced.
	DMAC_CFG3_FIFOCFG_ASAP_CFG = 0x2

	// SADDR4: DMAC Channel Source Address Register (ch_num = 4)
	// Position of SADDR field.
	DMAC_SADDR4_SADDR_Pos = 0x0
	// Bit mask of SADDR field.
	DMAC_SADDR4_SADDR_Msk = 0xffffffff

	// DADDR4: DMAC Channel Destination Address Register (ch_num = 4)
	// Position of DADDR field.
	DMAC_DADDR4_DADDR_Pos = 0x0
	// Bit mask of DADDR field.
	DMAC_DADDR4_DADDR_Msk = 0xffffffff

	// DSCR4: DMAC Channel Descriptor Address Register (ch_num = 4)
	// Position of DSCR field.
	DMAC_DSCR4_DSCR_Pos = 0x2
	// Bit mask of DSCR field.
	DMAC_DSCR4_DSCR_Msk = 0xfffffffc

	// CTRLA4: DMAC Channel Control A Register (ch_num = 4)
	// Position of BTSIZE field.
	DMAC_CTRLA4_BTSIZE_Pos = 0x0
	// Bit mask of BTSIZE field.
	DMAC_CTRLA4_BTSIZE_Msk = 0xffff
	// Position of SCSIZE field.
	DMAC_CTRLA4_SCSIZE_Pos = 0x10
	// Bit mask of SCSIZE field.
	DMAC_CTRLA4_SCSIZE_Msk = 0x70000
	// 1 data transferred
	DMAC_CTRLA4_SCSIZE_CHK_1 = 0x0
	// 4 data transferred
	DMAC_CTRLA4_SCSIZE_CHK_4 = 0x1
	// 8 data transferred
	DMAC_CTRLA4_SCSIZE_CHK_8 = 0x2
	// 16 data transferred
	DMAC_CTRLA4_SCSIZE_CHK_16 = 0x3
	// Position of DCSIZE field.
	DMAC_CTRLA4_DCSIZE_Pos = 0x14
	// Bit mask of DCSIZE field.
	DMAC_CTRLA4_DCSIZE_Msk = 0x700000
	// 1 data transferred
	DMAC_CTRLA4_DCSIZE_CHK_1 = 0x0
	// 4 data transferred
	DMAC_CTRLA4_DCSIZE_CHK_4 = 0x1
	// 8 data transferred
	DMAC_CTRLA4_DCSIZE_CHK_8 = 0x2
	// 16 data transferred
	DMAC_CTRLA4_DCSIZE_CHK_16 = 0x3
	// Position of SRC_WIDTH field.
	DMAC_CTRLA4_SRC_WIDTH_Pos = 0x18
	// Bit mask of SRC_WIDTH field.
	DMAC_CTRLA4_SRC_WIDTH_Msk = 0x3000000
	// the transfer size is set to 8-bit width
	DMAC_CTRLA4_SRC_WIDTH_BYTE = 0x0
	// the transfer size is set to 16-bit width
	DMAC_CTRLA4_SRC_WIDTH_HALF_WORD = 0x1
	// the transfer size is set to 32-bit width
	DMAC_CTRLA4_SRC_WIDTH_WORD = 0x2
	// Position of DST_WIDTH field.
	DMAC_CTRLA4_DST_WIDTH_Pos = 0x1c
	// Bit mask of DST_WIDTH field.
	DMAC_CTRLA4_DST_WIDTH_Msk = 0x30000000
	// the transfer size is set to 8-bit width
	DMAC_CTRLA4_DST_WIDTH_BYTE = 0x0
	// the transfer size is set to 16-bit width
	DMAC_CTRLA4_DST_WIDTH_HALF_WORD = 0x1
	// the transfer size is set to 32-bit width
	DMAC_CTRLA4_DST_WIDTH_WORD = 0x2
	// Position of DONE field.
	DMAC_CTRLA4_DONE_Pos = 0x1f
	// Bit mask of DONE field.
	DMAC_CTRLA4_DONE_Msk = 0x80000000
	// Bit DONE.
	DMAC_CTRLA4_DONE = 0x80000000

	// CTRLB4: DMAC Channel Control B Register (ch_num = 4)
	// Position of SRC_DSCR field.
	DMAC_CTRLB4_SRC_DSCR_Pos = 0x10
	// Bit mask of SRC_DSCR field.
	DMAC_CTRLB4_SRC_DSCR_Msk = 0x10000
	// Bit SRC_DSCR.
	DMAC_CTRLB4_SRC_DSCR = 0x10000
	// Source address is updated when the descriptor is fetched from the memory.
	DMAC_CTRLB4_SRC_DSCR_FETCH_FROM_MEM = 0x0
	// Buffer Descriptor Fetch operation is disabled for the source.
	DMAC_CTRLB4_SRC_DSCR_FETCH_DISABLE = 0x1
	// Position of DST_DSCR field.
	DMAC_CTRLB4_DST_DSCR_Pos = 0x14
	// Bit mask of DST_DSCR field.
	DMAC_CTRLB4_DST_DSCR_Msk = 0x100000
	// Bit DST_DSCR.
	DMAC_CTRLB4_DST_DSCR = 0x100000
	// Destination address is updated when the descriptor is fetched from the memory.
	DMAC_CTRLB4_DST_DSCR_FETCH_FROM_MEM = 0x0
	// Buffer Descriptor Fetch operation is disabled for the destination.
	DMAC_CTRLB4_DST_DSCR_FETCH_DISABLE = 0x1
	// Position of FC field.
	DMAC_CTRLB4_FC_Pos = 0x15
	// Bit mask of FC field.
	DMAC_CTRLB4_FC_Msk = 0x600000
	// Memory-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB4_FC_MEM2MEM_DMA_FC = 0x0
	// Memory-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB4_FC_MEM2PER_DMA_FC = 0x1
	// Peripheral-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB4_FC_PER2MEM_DMA_FC = 0x2
	// Peripheral-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB4_FC_PER2PER_DMA_FC = 0x3
	// Position of SRC_INCR field.
	DMAC_CTRLB4_SRC_INCR_Pos = 0x18
	// Bit mask of SRC_INCR field.
	DMAC_CTRLB4_SRC_INCR_Msk = 0x3000000
	// The source address is incremented
	DMAC_CTRLB4_SRC_INCR_INCREMENTING = 0x0
	// The source address is decremented
	DMAC_CTRLB4_SRC_INCR_DECREMENTING = 0x1
	// The source address remains unchanged
	DMAC_CTRLB4_SRC_INCR_FIXED = 0x2
	// Position of DST_INCR field.
	DMAC_CTRLB4_DST_INCR_Pos = 0x1c
	// Bit mask of DST_INCR field.
	DMAC_CTRLB4_DST_INCR_Msk = 0x30000000
	// The destination address is incremented
	DMAC_CTRLB4_DST_INCR_INCREMENTING = 0x0
	// The destination address is decremented
	DMAC_CTRLB4_DST_INCR_DECREMENTING = 0x1
	// The destination address remains unchanged
	DMAC_CTRLB4_DST_INCR_FIXED = 0x2
	// Position of IEN field.
	DMAC_CTRLB4_IEN_Pos = 0x1e
	// Bit mask of IEN field.
	DMAC_CTRLB4_IEN_Msk = 0x40000000
	// Bit IEN.
	DMAC_CTRLB4_IEN = 0x40000000

	// CFG4: DMAC Channel Configuration Register (ch_num = 4)
	// Position of SRC_PER field.
	DMAC_CFG4_SRC_PER_Pos = 0x0
	// Bit mask of SRC_PER field.
	DMAC_CFG4_SRC_PER_Msk = 0xf
	// Position of DST_PER field.
	DMAC_CFG4_DST_PER_Pos = 0x4
	// Bit mask of DST_PER field.
	DMAC_CFG4_DST_PER_Msk = 0xf0
	// Position of SRC_H2SEL field.
	DMAC_CFG4_SRC_H2SEL_Pos = 0x9
	// Bit mask of SRC_H2SEL field.
	DMAC_CFG4_SRC_H2SEL_Msk = 0x200
	// Bit SRC_H2SEL.
	DMAC_CFG4_SRC_H2SEL = 0x200
	// Software handshaking interface is used to trigger a transfer request.
	DMAC_CFG4_SRC_H2SEL_SW = 0x0
	// Hardware handshaking interface is used to trigger a transfer request.
	DMAC_CFG4_SRC_H2SEL_HW = 0x1
	// Position of DST_H2SEL field.
	DMAC_CFG4_DST_H2SEL_Pos = 0xd
	// Bit mask of DST_H2SEL field.
	DMAC_CFG4_DST_H2SEL_Msk = 0x2000
	// Bit DST_H2SEL.
	DMAC_CFG4_DST_H2SEL = 0x2000
	// Software handshaking interface is used to trigger a transfer request.
	DMAC_CFG4_DST_H2SEL_SW = 0x0
	// Hardware handshaking interface is used to trigger a transfer request.
	DMAC_CFG4_DST_H2SEL_HW = 0x1
	// Position of SOD field.
	DMAC_CFG4_SOD_Pos = 0x10
	// Bit mask of SOD field.
	DMAC_CFG4_SOD_Msk = 0x10000
	// Bit SOD.
	DMAC_CFG4_SOD = 0x10000
	// STOP ON DONE disabled, the descriptor fetch operation ignores DONE Field of CTRLA register.
	DMAC_CFG4_SOD_DISABLE = 0x0
	// STOP ON DONE activated, the DMAC module is automatically disabled if DONE FIELD is set to 1.
	DMAC_CFG4_SOD_ENABLE = 0x1
	// Position of LOCK_IF field.
	DMAC_CFG4_LOCK_IF_Pos = 0x14
	// Bit mask of LOCK_IF field.
	DMAC_CFG4_LOCK_IF_Msk = 0x100000
	// Bit LOCK_IF.
	DMAC_CFG4_LOCK_IF = 0x100000
	// Interface Lock capability is disabled
	DMAC_CFG4_LOCK_IF_DISABLE = 0x0
	// Interface Lock capability is enabled
	DMAC_CFG4_LOCK_IF_ENABLE = 0x1
	// Position of LOCK_B field.
	DMAC_CFG4_LOCK_B_Pos = 0x15
	// Bit mask of LOCK_B field.
	DMAC_CFG4_LOCK_B_Msk = 0x200000
	// Bit LOCK_B.
	DMAC_CFG4_LOCK_B = 0x200000
	// AHB Bus Locking capability is disabled.
	DMAC_CFG4_LOCK_B_DISABLE = 0x0
	// Position of LOCK_IF_L field.
	DMAC_CFG4_LOCK_IF_L_Pos = 0x16
	// Bit mask of LOCK_IF_L field.
	DMAC_CFG4_LOCK_IF_L_Msk = 0x400000
	// Bit LOCK_IF_L.
	DMAC_CFG4_LOCK_IF_L = 0x400000
	// The Master Interface Arbiter is locked by the channel x for a chunk transfer.
	DMAC_CFG4_LOCK_IF_L_CHUNK = 0x0
	// The Master Interface Arbiter is locked by the channel x for a buffer transfer.
	DMAC_CFG4_LOCK_IF_L_BUFFER = 0x1
	// Position of AHB_PROT field.
	DMAC_CFG4_AHB_PROT_Pos = 0x18
	// Bit mask of AHB_PROT field.
	DMAC_CFG4_AHB_PROT_Msk = 0x7000000
	// Position of FIFOCFG field.
	DMAC_CFG4_FIFOCFG_Pos = 0x1c
	// Bit mask of FIFOCFG field.
	DMAC_CFG4_FIFOCFG_Msk = 0x30000000
	// The largest defined length AHB burst is performed on the destination AHB interface.
	DMAC_CFG4_FIFOCFG_ALAP_CFG = 0x0
	// When half FIFO size is available/filled, a source/destination request is serviced.
	DMAC_CFG4_FIFOCFG_HALF_CFG = 0x1
	// When there is enough space/data available to perform a single AHB access, then the request is serviced.
	DMAC_CFG4_FIFOCFG_ASAP_CFG = 0x2

	// SADDR5: DMAC Channel Source Address Register (ch_num = 5)
	// Position of SADDR field.
	DMAC_SADDR5_SADDR_Pos = 0x0
	// Bit mask of SADDR field.
	DMAC_SADDR5_SADDR_Msk = 0xffffffff

	// DADDR5: DMAC Channel Destination Address Register (ch_num = 5)
	// Position of DADDR field.
	DMAC_DADDR5_DADDR_Pos = 0x0
	// Bit mask of DADDR field.
	DMAC_DADDR5_DADDR_Msk = 0xffffffff

	// DSCR5: DMAC Channel Descriptor Address Register (ch_num = 5)
	// Position of DSCR field.
	DMAC_DSCR5_DSCR_Pos = 0x2
	// Bit mask of DSCR field.
	DMAC_DSCR5_DSCR_Msk = 0xfffffffc

	// CTRLA5: DMAC Channel Control A Register (ch_num = 5)
	// Position of BTSIZE field.
	DMAC_CTRLA5_BTSIZE_Pos = 0x0
	// Bit mask of BTSIZE field.
	DMAC_CTRLA5_BTSIZE_Msk = 0xffff
	// Position of SCSIZE field.
	DMAC_CTRLA5_SCSIZE_Pos = 0x10
	// Bit mask of SCSIZE field.
	DMAC_CTRLA5_SCSIZE_Msk = 0x70000
	// 1 data transferred
	DMAC_CTRLA5_SCSIZE_CHK_1 = 0x0
	// 4 data transferred
	DMAC_CTRLA5_SCSIZE_CHK_4 = 0x1
	// 8 data transferred
	DMAC_CTRLA5_SCSIZE_CHK_8 = 0x2
	// 16 data transferred
	DMAC_CTRLA5_SCSIZE_CHK_16 = 0x3
	// Position of DCSIZE field.
	DMAC_CTRLA5_DCSIZE_Pos = 0x14
	// Bit mask of DCSIZE field.
	DMAC_CTRLA5_DCSIZE_Msk = 0x700000
	// 1 data transferred
	DMAC_CTRLA5_DCSIZE_CHK_1 = 0x0
	// 4 data transferred
	DMAC_CTRLA5_DCSIZE_CHK_4 = 0x1
	// 8 data transferred
	DMAC_CTRLA5_DCSIZE_CHK_8 = 0x2
	// 16 data transferred
	DMAC_CTRLA5_DCSIZE_CHK_16 = 0x3
	// Position of SRC_WIDTH field.
	DMAC_CTRLA5_SRC_WIDTH_Pos = 0x18
	// Bit mask of SRC_WIDTH field.
	DMAC_CTRLA5_SRC_WIDTH_Msk = 0x3000000
	// the transfer size is set to 8-bit width
	DMAC_CTRLA5_SRC_WIDTH_BYTE = 0x0
	// the transfer size is set to 16-bit width
	DMAC_CTRLA5_SRC_WIDTH_HALF_WORD = 0x1
	// the transfer size is set to 32-bit width
	DMAC_CTRLA5_SRC_WIDTH_WORD = 0x2
	// Position of DST_WIDTH field.
	DMAC_CTRLA5_DST_WIDTH_Pos = 0x1c
	// Bit mask of DST_WIDTH field.
	DMAC_CTRLA5_DST_WIDTH_Msk = 0x30000000
	// the transfer size is set to 8-bit width
	DMAC_CTRLA5_DST_WIDTH_BYTE = 0x0
	// the transfer size is set to 16-bit width
	DMAC_CTRLA5_DST_WIDTH_HALF_WORD = 0x1
	// the transfer size is set to 32-bit width
	DMAC_CTRLA5_DST_WIDTH_WORD = 0x2
	// Position of DONE field.
	DMAC_CTRLA5_DONE_Pos = 0x1f
	// Bit mask of DONE field.
	DMAC_CTRLA5_DONE_Msk = 0x80000000
	// Bit DONE.
	DMAC_CTRLA5_DONE = 0x80000000

	// CTRLB5: DMAC Channel Control B Register (ch_num = 5)
	// Position of SRC_DSCR field.
	DMAC_CTRLB5_SRC_DSCR_Pos = 0x10
	// Bit mask of SRC_DSCR field.
	DMAC_CTRLB5_SRC_DSCR_Msk = 0x10000
	// Bit SRC_DSCR.
	DMAC_CTRLB5_SRC_DSCR = 0x10000
	// Source address is updated when the descriptor is fetched from the memory.
	DMAC_CTRLB5_SRC_DSCR_FETCH_FROM_MEM = 0x0
	// Buffer Descriptor Fetch operation is disabled for the source.
	DMAC_CTRLB5_SRC_DSCR_FETCH_DISABLE = 0x1
	// Position of DST_DSCR field.
	DMAC_CTRLB5_DST_DSCR_Pos = 0x14
	// Bit mask of DST_DSCR field.
	DMAC_CTRLB5_DST_DSCR_Msk = 0x100000
	// Bit DST_DSCR.
	DMAC_CTRLB5_DST_DSCR = 0x100000
	// Destination address is updated when the descriptor is fetched from the memory.
	DMAC_CTRLB5_DST_DSCR_FETCH_FROM_MEM = 0x0
	// Buffer Descriptor Fetch operation is disabled for the destination.
	DMAC_CTRLB5_DST_DSCR_FETCH_DISABLE = 0x1
	// Position of FC field.
	DMAC_CTRLB5_FC_Pos = 0x15
	// Bit mask of FC field.
	DMAC_CTRLB5_FC_Msk = 0x600000
	// Memory-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB5_FC_MEM2MEM_DMA_FC = 0x0
	// Memory-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB5_FC_MEM2PER_DMA_FC = 0x1
	// Peripheral-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB5_FC_PER2MEM_DMA_FC = 0x2
	// Peripheral-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB5_FC_PER2PER_DMA_FC = 0x3
	// Position of SRC_INCR field.
	DMAC_CTRLB5_SRC_INCR_Pos = 0x18
	// Bit mask of SRC_INCR field.
	DMAC_CTRLB5_SRC_INCR_Msk = 0x3000000
	// The source address is incremented
	DMAC_CTRLB5_SRC_INCR_INCREMENTING = 0x0
	// The source address is decremented
	DMAC_CTRLB5_SRC_INCR_DECREMENTING = 0x1
	// The source address remains unchanged
	DMAC_CTRLB5_SRC_INCR_FIXED = 0x2
	// Position of DST_INCR field.
	DMAC_CTRLB5_DST_INCR_Pos = 0x1c
	// Bit mask of DST_INCR field.
	DMAC_CTRLB5_DST_INCR_Msk = 0x30000000
	// The destination address is incremented
	DMAC_CTRLB5_DST_INCR_INCREMENTING = 0x0
	// The destination address is decremented
	DMAC_CTRLB5_DST_INCR_DECREMENTING = 0x1
	// The destination address remains unchanged
	DMAC_CTRLB5_DST_INCR_FIXED = 0x2
	// Position of IEN field.
	DMAC_CTRLB5_IEN_Pos = 0x1e
	// Bit mask of IEN field.
	DMAC_CTRLB5_IEN_Msk = 0x40000000
	// Bit IEN.
	DMAC_CTRLB5_IEN = 0x40000000

	// CFG5: DMAC Channel Configuration Register (ch_num = 5)
	// Position of SRC_PER field.
	DMAC_CFG5_SRC_PER_Pos = 0x0
	// Bit mask of SRC_PER field.
	DMAC_CFG5_SRC_PER_Msk = 0xf
	// Position of DST_PER field.
	DMAC_CFG5_DST_PER_Pos = 0x4
	// Bit mask of DST_PER field.
	DMAC_CFG5_DST_PER_Msk = 0xf0
	// Position of SRC_H2SEL field.
	DMAC_CFG5_SRC_H2SEL_Pos = 0x9
	// Bit mask of SRC_H2SEL field.
	DMAC_CFG5_SRC_H2SEL_Msk = 0x200
	// Bit SRC_H2SEL.
	DMAC_CFG5_SRC_H2SEL = 0x200
	// Software handshaking interface is used to trigger a transfer request.
	DMAC_CFG5_SRC_H2SEL_SW = 0x0
	// Hardware handshaking interface is used to trigger a transfer request.
	DMAC_CFG5_SRC_H2SEL_HW = 0x1
	// Position of DST_H2SEL field.
	DMAC_CFG5_DST_H2SEL_Pos = 0xd
	// Bit mask of DST_H2SEL field.
	DMAC_CFG5_DST_H2SEL_Msk = 0x2000
	// Bit DST_H2SEL.
	DMAC_CFG5_DST_H2SEL = 0x2000
	// Software handshaking interface is used to trigger a transfer request.
	DMAC_CFG5_DST_H2SEL_SW = 0x0
	// Hardware handshaking interface is used to trigger a transfer request.
	DMAC_CFG5_DST_H2SEL_HW = 0x1
	// Position of SOD field.
	DMAC_CFG5_SOD_Pos = 0x10
	// Bit mask of SOD field.
	DMAC_CFG5_SOD_Msk = 0x10000
	// Bit SOD.
	DMAC_CFG5_SOD = 0x10000
	// STOP ON DONE disabled, the descriptor fetch operation ignores DONE Field of CTRLA register.
	DMAC_CFG5_SOD_DISABLE = 0x0
	// STOP ON DONE activated, the DMAC module is automatically disabled if DONE FIELD is set to 1.
	DMAC_CFG5_SOD_ENABLE = 0x1
	// Position of LOCK_IF field.
	DMAC_CFG5_LOCK_IF_Pos = 0x14
	// Bit mask of LOCK_IF field.
	DMAC_CFG5_LOCK_IF_Msk = 0x100000
	// Bit LOCK_IF.
	DMAC_CFG5_LOCK_IF = 0x100000
	// Interface Lock capability is disabled
	DMAC_CFG5_LOCK_IF_DISABLE = 0x0
	// Interface Lock capability is enabled
	DMAC_CFG5_LOCK_IF_ENABLE = 0x1
	// Position of LOCK_B field.
	DMAC_CFG5_LOCK_B_Pos = 0x15
	// Bit mask of LOCK_B field.
	DMAC_CFG5_LOCK_B_Msk = 0x200000
	// Bit LOCK_B.
	DMAC_CFG5_LOCK_B = 0x200000
	// AHB Bus Locking capability is disabled.
	DMAC_CFG5_LOCK_B_DISABLE = 0x0
	// Position of LOCK_IF_L field.
	DMAC_CFG5_LOCK_IF_L_Pos = 0x16
	// Bit mask of LOCK_IF_L field.
	DMAC_CFG5_LOCK_IF_L_Msk = 0x400000
	// Bit LOCK_IF_L.
	DMAC_CFG5_LOCK_IF_L = 0x400000
	// The Master Interface Arbiter is locked by the channel x for a chunk transfer.
	DMAC_CFG5_LOCK_IF_L_CHUNK = 0x0
	// The Master Interface Arbiter is locked by the channel x for a buffer transfer.
	DMAC_CFG5_LOCK_IF_L_BUFFER = 0x1
	// Position of AHB_PROT field.
	DMAC_CFG5_AHB_PROT_Pos = 0x18
	// Bit mask of AHB_PROT field.
	DMAC_CFG5_AHB_PROT_Msk = 0x7000000
	// Position of FIFOCFG field.
	DMAC_CFG5_FIFOCFG_Pos = 0x1c
	// Bit mask of FIFOCFG field.
	DMAC_CFG5_FIFOCFG_Msk = 0x30000000
	// The largest defined length AHB burst is performed on the destination AHB interface.
	DMAC_CFG5_FIFOCFG_ALAP_CFG = 0x0
	// When half FIFO size is available/filled, a source/destination request is serviced.
	DMAC_CFG5_FIFOCFG_HALF_CFG = 0x1
	// When there is enough space/data available to perform a single AHB access, then the request is serviced.
	DMAC_CFG5_FIFOCFG_ASAP_CFG = 0x2

	// WPMR: DMAC Write Protect Mode Register
	// Position of WPEN field.
	DMAC_WPMR_WPEN_Pos = 0x0
	// Bit mask of WPEN field.
	DMAC_WPMR_WPEN_Msk = 0x1
	// Bit WPEN.
	DMAC_WPMR_WPEN = 0x1
	// Position of WPKEY field.
	DMAC_WPMR_WPKEY_Pos = 0x8
	// Bit mask of WPKEY field.
	DMAC_WPMR_WPKEY_Msk = 0xffffff00
	// Writing any other value in this field aborts the write operation of the WPEN bit.Always reads as 0.
	DMAC_WPMR_WPKEY_PASSWD = 0x444d41

	// WPSR: DMAC Write Protect Status Register
	// Position of WPVS field.
	DMAC_WPSR_WPVS_Pos = 0x0
	// Bit mask of WPVS field.
	DMAC_WPSR_WPVS_Msk = 0x1
	// Bit WPVS.
	DMAC_WPSR_WPVS = 0x1
	// Position of WPVSRC field.
	DMAC_WPSR_WPVSRC_Pos = 0x8
	// Bit mask of WPVSRC field.
	DMAC_WPSR_WPVSRC_Msk = 0xffff00
)

// Bitfields for DACC: Digital-to-Analog Converter Controller
const (
	// CR: Control Register
	// Position of SWRST field.
	DACC_CR_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	DACC_CR_SWRST_Msk = 0x1
	// Bit SWRST.
	DACC_CR_SWRST = 0x1

	// MR: Mode Register
	// Position of TRGEN field.
	DACC_MR_TRGEN_Pos = 0x0
	// Bit mask of TRGEN field.
	DACC_MR_TRGEN_Msk = 0x1
	// Bit TRGEN.
	DACC_MR_TRGEN = 0x1
	// External trigger mode disabled. DACC in free running mode.
	DACC_MR_TRGEN_DIS = 0x0
	// External trigger mode enabled.
	DACC_MR_TRGEN_EN = 0x1
	// Position of TRGSEL field.
	DACC_MR_TRGSEL_Pos = 0x1
	// Bit mask of TRGSEL field.
	DACC_MR_TRGSEL_Msk = 0xe
	// Position of WORD field.
	DACC_MR_WORD_Pos = 0x4
	// Bit mask of WORD field.
	DACC_MR_WORD_Msk = 0x10
	// Bit WORD.
	DACC_MR_WORD = 0x10
	// Half-Word transfer
	DACC_MR_WORD_HALF = 0x0
	// Word Transfer
	DACC_MR_WORD_WORD = 0x1
	// Position of SLEEP field.
	DACC_MR_SLEEP_Pos = 0x5
	// Bit mask of SLEEP field.
	DACC_MR_SLEEP_Msk = 0x20
	// Bit SLEEP.
	DACC_MR_SLEEP = 0x20
	// Position of FASTWKUP field.
	DACC_MR_FASTWKUP_Pos = 0x6
	// Bit mask of FASTWKUP field.
	DACC_MR_FASTWKUP_Msk = 0x40
	// Bit FASTWKUP.
	DACC_MR_FASTWKUP = 0x40
	// Position of REFRESH field.
	DACC_MR_REFRESH_Pos = 0x8
	// Bit mask of REFRESH field.
	DACC_MR_REFRESH_Msk = 0xff00
	// Position of USER_SEL field.
	DACC_MR_USER_SEL_Pos = 0x10
	// Bit mask of USER_SEL field.
	DACC_MR_USER_SEL_Msk = 0x30000
	// Channel 0
	DACC_MR_USER_SEL_CHANNEL0 = 0x0
	// Channel 1
	DACC_MR_USER_SEL_CHANNEL1 = 0x1
	// Position of TAG field.
	DACC_MR_TAG_Pos = 0x14
	// Bit mask of TAG field.
	DACC_MR_TAG_Msk = 0x100000
	// Bit TAG.
	DACC_MR_TAG = 0x100000
	// Tag selection mode disabled. Using USER_SEL to select the channel for the conversion.
	DACC_MR_TAG_DIS = 0x0
	// Tag selection mode enabled
	DACC_MR_TAG_EN = 0x1
	// Position of MAXS field.
	DACC_MR_MAXS_Pos = 0x15
	// Bit mask of MAXS field.
	DACC_MR_MAXS_Msk = 0x200000
	// Bit MAXS.
	DACC_MR_MAXS = 0x200000
	// Normal Mode
	DACC_MR_MAXS_NORMAL = 0x0
	// Max Speed Mode enabled
	DACC_MR_MAXS_MAXIMUM = 0x1
	// Position of STARTUP field.
	DACC_MR_STARTUP_Pos = 0x18
	// Bit mask of STARTUP field.
	DACC_MR_STARTUP_Msk = 0x3f000000
	// 0 periods of DACClock
	DACC_MR_STARTUP_0 = 0x0
	// 8 periods of DACClock
	DACC_MR_STARTUP_8 = 0x1
	// 16 periods of DACClock
	DACC_MR_STARTUP_16 = 0x2
	// 24 periods of DACClock
	DACC_MR_STARTUP_24 = 0x3
	// 64 periods of DACClock
	DACC_MR_STARTUP_64 = 0x4
	// 80 periods of DACClock
	DACC_MR_STARTUP_80 = 0x5
	// 96 periods of DACClock
	DACC_MR_STARTUP_96 = 0x6
	// 112 periods of DACClock
	DACC_MR_STARTUP_112 = 0x7
	// 512 periods of DACClock
	DACC_MR_STARTUP_512 = 0x8
	// 576 periods of DACClock
	DACC_MR_STARTUP_576 = 0x9
	// 640 periods of DACClock
	DACC_MR_STARTUP_640 = 0xa
	// 704 periods of DACClock
	DACC_MR_STARTUP_704 = 0xb
	// 768 periods of DACClock
	DACC_MR_STARTUP_768 = 0xc
	// 832 periods of DACClock
	DACC_MR_STARTUP_832 = 0xd
	// 896 periods of DACClock
	DACC_MR_STARTUP_896 = 0xe
	// 960 periods of DACClock
	DACC_MR_STARTUP_960 = 0xf
	// 1024 periods of DACClock
	DACC_MR_STARTUP_1024 = 0x10
	// 1088 periods of DACClock
	DACC_MR_STARTUP_1088 = 0x11
	// 1152 periods of DACClock
	DACC_MR_STARTUP_1152 = 0x12
	// 1216 periods of DACClock
	DACC_MR_STARTUP_1216 = 0x13
	// 1280 periods of DACClock
	DACC_MR_STARTUP_1280 = 0x14
	// 1344 periods of DACClock
	DACC_MR_STARTUP_1344 = 0x15
	// 1408 periods of DACClock
	DACC_MR_STARTUP_1408 = 0x16
	// 1472 periods of DACClock
	DACC_MR_STARTUP_1472 = 0x17
	// 1536 periods of DACClock
	DACC_MR_STARTUP_1536 = 0x18
	// 1600 periods of DACClock
	DACC_MR_STARTUP_1600 = 0x19
	// 1664 periods of DACClock
	DACC_MR_STARTUP_1664 = 0x1a
	// 1728 periods of DACClock
	DACC_MR_STARTUP_1728 = 0x1b
	// 1792 periods of DACClock
	DACC_MR_STARTUP_1792 = 0x1c
	// 1856 periods of DACClock
	DACC_MR_STARTUP_1856 = 0x1d
	// 1920 periods of DACClock
	DACC_MR_STARTUP_1920 = 0x1e
	// 1984 periods of DACClock
	DACC_MR_STARTUP_1984 = 0x1f

	// CHER: Channel Enable Register
	// Position of CH0 field.
	DACC_CHER_CH0_Pos = 0x0
	// Bit mask of CH0 field.
	DACC_CHER_CH0_Msk = 0x1
	// Bit CH0.
	DACC_CHER_CH0 = 0x1
	// Position of CH1 field.
	DACC_CHER_CH1_Pos = 0x1
	// Bit mask of CH1 field.
	DACC_CHER_CH1_Msk = 0x2
	// Bit CH1.
	DACC_CHER_CH1 = 0x2

	// CHDR: Channel Disable Register
	// Position of CH0 field.
	DACC_CHDR_CH0_Pos = 0x0
	// Bit mask of CH0 field.
	DACC_CHDR_CH0_Msk = 0x1
	// Bit CH0.
	DACC_CHDR_CH0 = 0x1
	// Position of CH1 field.
	DACC_CHDR_CH1_Pos = 0x1
	// Bit mask of CH1 field.
	DACC_CHDR_CH1_Msk = 0x2
	// Bit CH1.
	DACC_CHDR_CH1 = 0x2

	// CHSR: Channel Status Register
	// Position of CH0 field.
	DACC_CHSR_CH0_Pos = 0x0
	// Bit mask of CH0 field.
	DACC_CHSR_CH0_Msk = 0x1
	// Bit CH0.
	DACC_CHSR_CH0 = 0x1
	// Position of CH1 field.
	DACC_CHSR_CH1_Pos = 0x1
	// Bit mask of CH1 field.
	DACC_CHSR_CH1_Msk = 0x2
	// Bit CH1.
	DACC_CHSR_CH1 = 0x2

	// CDR: Conversion Data Register
	// Position of DATA field.
	DACC_CDR_DATA_Pos = 0x0
	// Bit mask of DATA field.
	DACC_CDR_DATA_Msk = 0xffffffff

	// IER: Interrupt Enable Register
	// Position of TXRDY field.
	DACC_IER_TXRDY_Pos = 0x0
	// Bit mask of TXRDY field.
	DACC_IER_TXRDY_Msk = 0x1
	// Bit TXRDY.
	DACC_IER_TXRDY = 0x1
	// Position of EOC field.
	DACC_IER_EOC_Pos = 0x1
	// Bit mask of EOC field.
	DACC_IER_EOC_Msk = 0x2
	// Bit EOC.
	DACC_IER_EOC = 0x2
	// Position of ENDTX field.
	DACC_IER_ENDTX_Pos = 0x2
	// Bit mask of ENDTX field.
	DACC_IER_ENDTX_Msk = 0x4
	// Bit ENDTX.
	DACC_IER_ENDTX = 0x4
	// Position of TXBUFE field.
	DACC_IER_TXBUFE_Pos = 0x3
	// Bit mask of TXBUFE field.
	DACC_IER_TXBUFE_Msk = 0x8
	// Bit TXBUFE.
	DACC_IER_TXBUFE = 0x8

	// IDR: Interrupt Disable Register
	// Position of TXRDY field.
	DACC_IDR_TXRDY_Pos = 0x0
	// Bit mask of TXRDY field.
	DACC_IDR_TXRDY_Msk = 0x1
	// Bit TXRDY.
	DACC_IDR_TXRDY = 0x1
	// Position of EOC field.
	DACC_IDR_EOC_Pos = 0x1
	// Bit mask of EOC field.
	DACC_IDR_EOC_Msk = 0x2
	// Bit EOC.
	DACC_IDR_EOC = 0x2
	// Position of ENDTX field.
	DACC_IDR_ENDTX_Pos = 0x2
	// Bit mask of ENDTX field.
	DACC_IDR_ENDTX_Msk = 0x4
	// Bit ENDTX.
	DACC_IDR_ENDTX = 0x4
	// Position of TXBUFE field.
	DACC_IDR_TXBUFE_Pos = 0x3
	// Bit mask of TXBUFE field.
	DACC_IDR_TXBUFE_Msk = 0x8
	// Bit TXBUFE.
	DACC_IDR_TXBUFE = 0x8

	// IMR: Interrupt Mask Register
	// Position of TXRDY field.
	DACC_IMR_TXRDY_Pos = 0x0
	// Bit mask of TXRDY field.
	DACC_IMR_TXRDY_Msk = 0x1
	// Bit TXRDY.
	DACC_IMR_TXRDY = 0x1
	// Position of EOC field.
	DACC_IMR_EOC_Pos = 0x1
	// Bit mask of EOC field.
	DACC_IMR_EOC_Msk = 0x2
	// Bit EOC.
	DACC_IMR_EOC = 0x2
	// Position of ENDTX field.
	DACC_IMR_ENDTX_Pos = 0x2
	// Bit mask of ENDTX field.
	DACC_IMR_ENDTX_Msk = 0x4
	// Bit ENDTX.
	DACC_IMR_ENDTX = 0x4
	// Position of TXBUFE field.
	DACC_IMR_TXBUFE_Pos = 0x3
	// Bit mask of TXBUFE field.
	DACC_IMR_TXBUFE_Msk = 0x8
	// Bit TXBUFE.
	DACC_IMR_TXBUFE = 0x8

	// ISR: Interrupt Status Register
	// Position of TXRDY field.
	DACC_ISR_TXRDY_Pos = 0x0
	// Bit mask of TXRDY field.
	DACC_ISR_TXRDY_Msk = 0x1
	// Bit TXRDY.
	DACC_ISR_TXRDY = 0x1
	// Position of EOC field.
	DACC_ISR_EOC_Pos = 0x1
	// Bit mask of EOC field.
	DACC_ISR_EOC_Msk = 0x2
	// Bit EOC.
	DACC_ISR_EOC = 0x2
	// Position of ENDTX field.
	DACC_ISR_ENDTX_Pos = 0x2
	// Bit mask of ENDTX field.
	DACC_ISR_ENDTX_Msk = 0x4
	// Bit ENDTX.
	DACC_ISR_ENDTX = 0x4
	// Position of TXBUFE field.
	DACC_ISR_TXBUFE_Pos = 0x3
	// Bit mask of TXBUFE field.
	DACC_ISR_TXBUFE_Msk = 0x8
	// Bit TXBUFE.
	DACC_ISR_TXBUFE = 0x8

	// ACR: Analog Current Register
	// Position of IBCTLCH0 field.
	DACC_ACR_IBCTLCH0_Pos = 0x0
	// Bit mask of IBCTLCH0 field.
	DACC_ACR_IBCTLCH0_Msk = 0x3
	// Position of IBCTLCH1 field.
	DACC_ACR_IBCTLCH1_Pos = 0x2
	// Bit mask of IBCTLCH1 field.
	DACC_ACR_IBCTLCH1_Msk = 0xc
	// Position of IBCTLDACCORE field.
	DACC_ACR_IBCTLDACCORE_Pos = 0x8
	// Bit mask of IBCTLDACCORE field.
	DACC_ACR_IBCTLDACCORE_Msk = 0x300

	// WPMR: Write Protect Mode register
	// Position of WPEN field.
	DACC_WPMR_WPEN_Pos = 0x0
	// Bit mask of WPEN field.
	DACC_WPMR_WPEN_Msk = 0x1
	// Bit WPEN.
	DACC_WPMR_WPEN = 0x1
	// Position of WPKEY field.
	DACC_WPMR_WPKEY_Pos = 0x8
	// Bit mask of WPKEY field.
	DACC_WPMR_WPKEY_Msk = 0xffffff00

	// WPSR: Write Protect Status register
	// Position of WPROTERR field.
	DACC_WPSR_WPROTERR_Pos = 0x0
	// Bit mask of WPROTERR field.
	DACC_WPSR_WPROTERR_Msk = 0x1
	// Bit WPROTERR.
	DACC_WPSR_WPROTERR = 0x1
	// Position of WPROTADDR field.
	DACC_WPSR_WPROTADDR_Pos = 0x8
	// Bit mask of WPROTADDR field.
	DACC_WPSR_WPROTADDR_Msk = 0xff00

	// TPR: Transmit Pointer Register
	// Position of TXPTR field.
	DACC_TPR_TXPTR_Pos = 0x0
	// Bit mask of TXPTR field.
	DACC_TPR_TXPTR_Msk = 0xffffffff

	// TCR: Transmit Counter Register
	// Position of TXCTR field.
	DACC_TCR_TXCTR_Pos = 0x0
	// Bit mask of TXCTR field.
	DACC_TCR_TXCTR_Msk = 0xffff

	// TNPR: Transmit Next Pointer Register
	// Position of TXNPTR field.
	DACC_TNPR_TXNPTR_Pos = 0x0
	// Bit mask of TXNPTR field.
	DACC_TNPR_TXNPTR_Msk = 0xffffffff

	// TNCR: Transmit Next Counter Register
	// Position of TXNCTR field.
	DACC_TNCR_TXNCTR_Pos = 0x0
	// Bit mask of TXNCTR field.
	DACC_TNCR_TXNCTR_Msk = 0xffff

	// PTCR: Transfer Control Register
	// Position of RXTEN field.
	DACC_PTCR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	DACC_PTCR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	DACC_PTCR_RXTEN = 0x1
	// Position of RXTDIS field.
	DACC_PTCR_RXTDIS_Pos = 0x1
	// Bit mask of RXTDIS field.
	DACC_PTCR_RXTDIS_Msk = 0x2
	// Bit RXTDIS.
	DACC_PTCR_RXTDIS = 0x2
	// Position of TXTEN field.
	DACC_PTCR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	DACC_PTCR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	DACC_PTCR_TXTEN = 0x100
	// Position of TXTDIS field.
	DACC_PTCR_TXTDIS_Pos = 0x9
	// Bit mask of TXTDIS field.
	DACC_PTCR_TXTDIS_Msk = 0x200
	// Bit TXTDIS.
	DACC_PTCR_TXTDIS = 0x200

	// PTSR: Transfer Status Register
	// Position of RXTEN field.
	DACC_PTSR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	DACC_PTSR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	DACC_PTSR_RXTEN = 0x1
	// Position of TXTEN field.
	DACC_PTSR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	DACC_PTSR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	DACC_PTSR_TXTEN = 0x100
)

// Bitfields for MATRIX: AHB Bus Matrix
const (
	// MATRIX_MCFG: Master Configuration Register
	// Position of ULBT field.
	MATRIX_MATRIX_MCFG_ULBT_Pos = 0x0
	// Bit mask of ULBT field.
	MATRIX_MATRIX_MCFG_ULBT_Msk = 0x7

	// MATRIX_SCFG: Slave Configuration Register
	// Position of SLOT_CYCLE field.
	MATRIX_MATRIX_SCFG_SLOT_CYCLE_Pos = 0x0
	// Bit mask of SLOT_CYCLE field.
	MATRIX_MATRIX_SCFG_SLOT_CYCLE_Msk = 0xff
	// Position of DEFMSTR_TYPE field.
	MATRIX_MATRIX_SCFG_DEFMSTR_TYPE_Pos = 0x10
	// Bit mask of DEFMSTR_TYPE field.
	MATRIX_MATRIX_SCFG_DEFMSTR_TYPE_Msk = 0x30000
	// Position of FIXED_DEFMSTR field.
	MATRIX_MATRIX_SCFG_FIXED_DEFMSTR_Pos = 0x12
	// Bit mask of FIXED_DEFMSTR field.
	MATRIX_MATRIX_SCFG_FIXED_DEFMSTR_Msk = 0x1c0000
	// Position of ARBT field.
	MATRIX_MATRIX_SCFG_ARBT_Pos = 0x18
	// Bit mask of ARBT field.
	MATRIX_MATRIX_SCFG_ARBT_Msk = 0x3000000

	// MATRIX_PRAS0: Priority Register A for Slave 0
	// Position of M0PR field.
	MATRIX_MATRIX_PRAS0_M0PR_Pos = 0x0
	// Bit mask of M0PR field.
	MATRIX_MATRIX_PRAS0_M0PR_Msk = 0x3
	// Position of M1PR field.
	MATRIX_MATRIX_PRAS0_M1PR_Pos = 0x4
	// Bit mask of M1PR field.
	MATRIX_MATRIX_PRAS0_M1PR_Msk = 0x30
	// Position of M2PR field.
	MATRIX_MATRIX_PRAS0_M2PR_Pos = 0x8
	// Bit mask of M2PR field.
	MATRIX_MATRIX_PRAS0_M2PR_Msk = 0x300
	// Position of M3PR field.
	MATRIX_MATRIX_PRAS0_M3PR_Pos = 0xc
	// Bit mask of M3PR field.
	MATRIX_MATRIX_PRAS0_M3PR_Msk = 0x3000
	// Position of M4PR field.
	MATRIX_MATRIX_PRAS0_M4PR_Pos = 0x10
	// Bit mask of M4PR field.
	MATRIX_MATRIX_PRAS0_M4PR_Msk = 0x30000
	// Position of M5PR field.
	MATRIX_MATRIX_PRAS0_M5PR_Pos = 0x14
	// Bit mask of M5PR field.
	MATRIX_MATRIX_PRAS0_M5PR_Msk = 0x300000

	// MATRIX_PRAS1: Priority Register A for Slave 1
	// Position of M0PR field.
	MATRIX_MATRIX_PRAS1_M0PR_Pos = 0x0
	// Bit mask of M0PR field.
	MATRIX_MATRIX_PRAS1_M0PR_Msk = 0x3
	// Position of M1PR field.
	MATRIX_MATRIX_PRAS1_M1PR_Pos = 0x4
	// Bit mask of M1PR field.
	MATRIX_MATRIX_PRAS1_M1PR_Msk = 0x30
	// Position of M2PR field.
	MATRIX_MATRIX_PRAS1_M2PR_Pos = 0x8
	// Bit mask of M2PR field.
	MATRIX_MATRIX_PRAS1_M2PR_Msk = 0x300
	// Position of M3PR field.
	MATRIX_MATRIX_PRAS1_M3PR_Pos = 0xc
	// Bit mask of M3PR field.
	MATRIX_MATRIX_PRAS1_M3PR_Msk = 0x3000
	// Position of M4PR field.
	MATRIX_MATRIX_PRAS1_M4PR_Pos = 0x10
	// Bit mask of M4PR field.
	MATRIX_MATRIX_PRAS1_M4PR_Msk = 0x30000
	// Position of M5PR field.
	MATRIX_MATRIX_PRAS1_M5PR_Pos = 0x14
	// Bit mask of M5PR field.
	MATRIX_MATRIX_PRAS1_M5PR_Msk = 0x300000

	// MATRIX_PRAS2: Priority Register A for Slave 2
	// Position of M0PR field.
	MATRIX_MATRIX_PRAS2_M0PR_Pos = 0x0
	// Bit mask of M0PR field.
	MATRIX_MATRIX_PRAS2_M0PR_Msk = 0x3
	// Position of M1PR field.
	MATRIX_MATRIX_PRAS2_M1PR_Pos = 0x4
	// Bit mask of M1PR field.
	MATRIX_MATRIX_PRAS2_M1PR_Msk = 0x30
	// Position of M2PR field.
	MATRIX_MATRIX_PRAS2_M2PR_Pos = 0x8
	// Bit mask of M2PR field.
	MATRIX_MATRIX_PRAS2_M2PR_Msk = 0x300
	// Position of M3PR field.
	MATRIX_MATRIX_PRAS2_M3PR_Pos = 0xc
	// Bit mask of M3PR field.
	MATRIX_MATRIX_PRAS2_M3PR_Msk = 0x3000
	// Position of M4PR field.
	MATRIX_MATRIX_PRAS2_M4PR_Pos = 0x10
	// Bit mask of M4PR field.
	MATRIX_MATRIX_PRAS2_M4PR_Msk = 0x30000
	// Position of M5PR field.
	MATRIX_MATRIX_PRAS2_M5PR_Pos = 0x14
	// Bit mask of M5PR field.
	MATRIX_MATRIX_PRAS2_M5PR_Msk = 0x300000

	// MATRIX_PRAS3: Priority Register A for Slave 3
	// Position of M0PR field.
	MATRIX_MATRIX_PRAS3_M0PR_Pos = 0x0
	// Bit mask of M0PR field.
	MATRIX_MATRIX_PRAS3_M0PR_Msk = 0x3
	// Position of M1PR field.
	MATRIX_MATRIX_PRAS3_M1PR_Pos = 0x4
	// Bit mask of M1PR field.
	MATRIX_MATRIX_PRAS3_M1PR_Msk = 0x30
	// Position of M2PR field.
	MATRIX_MATRIX_PRAS3_M2PR_Pos = 0x8
	// Bit mask of M2PR field.
	MATRIX_MATRIX_PRAS3_M2PR_Msk = 0x300
	// Position of M3PR field.
	MATRIX_MATRIX_PRAS3_M3PR_Pos = 0xc
	// Bit mask of M3PR field.
	MATRIX_MATRIX_PRAS3_M3PR_Msk = 0x3000
	// Position of M4PR field.
	MATRIX_MATRIX_PRAS3_M4PR_Pos = 0x10
	// Bit mask of M4PR field.
	MATRIX_MATRIX_PRAS3_M4PR_Msk = 0x30000
	// Position of M5PR field.
	MATRIX_MATRIX_PRAS3_M5PR_Pos = 0x14
	// Bit mask of M5PR field.
	MATRIX_MATRIX_PRAS3_M5PR_Msk = 0x300000

	// MATRIX_PRAS4: Priority Register A for Slave 4
	// Position of M0PR field.
	MATRIX_MATRIX_PRAS4_M0PR_Pos = 0x0
	// Bit mask of M0PR field.
	MATRIX_MATRIX_PRAS4_M0PR_Msk = 0x3
	// Position of M1PR field.
	MATRIX_MATRIX_PRAS4_M1PR_Pos = 0x4
	// Bit mask of M1PR field.
	MATRIX_MATRIX_PRAS4_M1PR_Msk = 0x30
	// Position of M2PR field.
	MATRIX_MATRIX_PRAS4_M2PR_Pos = 0x8
	// Bit mask of M2PR field.
	MATRIX_MATRIX_PRAS4_M2PR_Msk = 0x300
	// Position of M3PR field.
	MATRIX_MATRIX_PRAS4_M3PR_Pos = 0xc
	// Bit mask of M3PR field.
	MATRIX_MATRIX_PRAS4_M3PR_Msk = 0x3000
	// Position of M4PR field.
	MATRIX_MATRIX_PRAS4_M4PR_Pos = 0x10
	// Bit mask of M4PR field.
	MATRIX_MATRIX_PRAS4_M4PR_Msk = 0x30000
	// Position of M5PR field.
	MATRIX_MATRIX_PRAS4_M5PR_Pos = 0x14
	// Bit mask of M5PR field.
	MATRIX_MATRIX_PRAS4_M5PR_Msk = 0x300000

	// MATRIX_PRAS5: Priority Register A for Slave 5
	// Position of M0PR field.
	MATRIX_MATRIX_PRAS5_M0PR_Pos = 0x0
	// Bit mask of M0PR field.
	MATRIX_MATRIX_PRAS5_M0PR_Msk = 0x3
	// Position of M1PR field.
	MATRIX_MATRIX_PRAS5_M1PR_Pos = 0x4
	// Bit mask of M1PR field.
	MATRIX_MATRIX_PRAS5_M1PR_Msk = 0x30
	// Position of M2PR field.
	MATRIX_MATRIX_PRAS5_M2PR_Pos = 0x8
	// Bit mask of M2PR field.
	MATRIX_MATRIX_PRAS5_M2PR_Msk = 0x300
	// Position of M3PR field.
	MATRIX_MATRIX_PRAS5_M3PR_Pos = 0xc
	// Bit mask of M3PR field.
	MATRIX_MATRIX_PRAS5_M3PR_Msk = 0x3000
	// Position of M4PR field.
	MATRIX_MATRIX_PRAS5_M4PR_Pos = 0x10
	// Bit mask of M4PR field.
	MATRIX_MATRIX_PRAS5_M4PR_Msk = 0x30000
	// Position of M5PR field.
	MATRIX_MATRIX_PRAS5_M5PR_Pos = 0x14
	// Bit mask of M5PR field.
	MATRIX_MATRIX_PRAS5_M5PR_Msk = 0x300000

	// MATRIX_PRAS6: Priority Register A for Slave 6
	// Position of M0PR field.
	MATRIX_MATRIX_PRAS6_M0PR_Pos = 0x0
	// Bit mask of M0PR field.
	MATRIX_MATRIX_PRAS6_M0PR_Msk = 0x3
	// Position of M1PR field.
	MATRIX_MATRIX_PRAS6_M1PR_Pos = 0x4
	// Bit mask of M1PR field.
	MATRIX_MATRIX_PRAS6_M1PR_Msk = 0x30
	// Position of M2PR field.
	MATRIX_MATRIX_PRAS6_M2PR_Pos = 0x8
	// Bit mask of M2PR field.
	MATRIX_MATRIX_PRAS6_M2PR_Msk = 0x300
	// Position of M3PR field.
	MATRIX_MATRIX_PRAS6_M3PR_Pos = 0xc
	// Bit mask of M3PR field.
	MATRIX_MATRIX_PRAS6_M3PR_Msk = 0x3000
	// Position of M4PR field.
	MATRIX_MATRIX_PRAS6_M4PR_Pos = 0x10
	// Bit mask of M4PR field.
	MATRIX_MATRIX_PRAS6_M4PR_Msk = 0x30000
	// Position of M5PR field.
	MATRIX_MATRIX_PRAS6_M5PR_Pos = 0x14
	// Bit mask of M5PR field.
	MATRIX_MATRIX_PRAS6_M5PR_Msk = 0x300000

	// MATRIX_PRAS7: Priority Register A for Slave 7
	// Position of M0PR field.
	MATRIX_MATRIX_PRAS7_M0PR_Pos = 0x0
	// Bit mask of M0PR field.
	MATRIX_MATRIX_PRAS7_M0PR_Msk = 0x3
	// Position of M1PR field.
	MATRIX_MATRIX_PRAS7_M1PR_Pos = 0x4
	// Bit mask of M1PR field.
	MATRIX_MATRIX_PRAS7_M1PR_Msk = 0x30
	// Position of M2PR field.
	MATRIX_MATRIX_PRAS7_M2PR_Pos = 0x8
	// Bit mask of M2PR field.
	MATRIX_MATRIX_PRAS7_M2PR_Msk = 0x300
	// Position of M3PR field.
	MATRIX_MATRIX_PRAS7_M3PR_Pos = 0xc
	// Bit mask of M3PR field.
	MATRIX_MATRIX_PRAS7_M3PR_Msk = 0x3000
	// Position of M4PR field.
	MATRIX_MATRIX_PRAS7_M4PR_Pos = 0x10
	// Bit mask of M4PR field.
	MATRIX_MATRIX_PRAS7_M4PR_Msk = 0x30000
	// Position of M5PR field.
	MATRIX_MATRIX_PRAS7_M5PR_Pos = 0x14
	// Bit mask of M5PR field.
	MATRIX_MATRIX_PRAS7_M5PR_Msk = 0x300000

	// MATRIX_PRAS8: Priority Register A for Slave 8
	// Position of M0PR field.
	MATRIX_MATRIX_PRAS8_M0PR_Pos = 0x0
	// Bit mask of M0PR field.
	MATRIX_MATRIX_PRAS8_M0PR_Msk = 0x3
	// Position of M1PR field.
	MATRIX_MATRIX_PRAS8_M1PR_Pos = 0x4
	// Bit mask of M1PR field.
	MATRIX_MATRIX_PRAS8_M1PR_Msk = 0x30
	// Position of M2PR field.
	MATRIX_MATRIX_PRAS8_M2PR_Pos = 0x8
	// Bit mask of M2PR field.
	MATRIX_MATRIX_PRAS8_M2PR_Msk = 0x300
	// Position of M3PR field.
	MATRIX_MATRIX_PRAS8_M3PR_Pos = 0xc
	// Bit mask of M3PR field.
	MATRIX_MATRIX_PRAS8_M3PR_Msk = 0x3000
	// Position of M4PR field.
	MATRIX_MATRIX_PRAS8_M4PR_Pos = 0x10
	// Bit mask of M4PR field.
	MATRIX_MATRIX_PRAS8_M4PR_Msk = 0x30000
	// Position of M5PR field.
	MATRIX_MATRIX_PRAS8_M5PR_Pos = 0x14
	// Bit mask of M5PR field.
	MATRIX_MATRIX_PRAS8_M5PR_Msk = 0x300000

	// MATRIX_MRCR: Master Remap Control Register
	// Position of RCB0 field.
	MATRIX_MATRIX_MRCR_RCB0_Pos = 0x0
	// Bit mask of RCB0 field.
	MATRIX_MATRIX_MRCR_RCB0_Msk = 0x1
	// Bit RCB0.
	MATRIX_MATRIX_MRCR_RCB0 = 0x1
	// Position of RCB1 field.
	MATRIX_MATRIX_MRCR_RCB1_Pos = 0x1
	// Bit mask of RCB1 field.
	MATRIX_MATRIX_MRCR_RCB1_Msk = 0x2
	// Bit RCB1.
	MATRIX_MATRIX_MRCR_RCB1 = 0x2
	// Position of RCB2 field.
	MATRIX_MATRIX_MRCR_RCB2_Pos = 0x2
	// Bit mask of RCB2 field.
	MATRIX_MATRIX_MRCR_RCB2_Msk = 0x4
	// Bit RCB2.
	MATRIX_MATRIX_MRCR_RCB2 = 0x4
	// Position of RCB3 field.
	MATRIX_MATRIX_MRCR_RCB3_Pos = 0x3
	// Bit mask of RCB3 field.
	MATRIX_MATRIX_MRCR_RCB3_Msk = 0x8
	// Bit RCB3.
	MATRIX_MATRIX_MRCR_RCB3 = 0x8
	// Position of RCB4 field.
	MATRIX_MATRIX_MRCR_RCB4_Pos = 0x4
	// Bit mask of RCB4 field.
	MATRIX_MATRIX_MRCR_RCB4_Msk = 0x30
	// Position of RCB5 field.
	MATRIX_MATRIX_MRCR_RCB5_Pos = 0x6
	// Bit mask of RCB5 field.
	MATRIX_MATRIX_MRCR_RCB5_Msk = 0x40
	// Bit RCB5.
	MATRIX_MATRIX_MRCR_RCB5 = 0x40

	// CCFG_SYSIO: System I/O Configuration register
	// Position of SYSIO12 field.
	MATRIX_CCFG_SYSIO_SYSIO12_Pos = 0xc
	// Bit mask of SYSIO12 field.
	MATRIX_CCFG_SYSIO_SYSIO12_Msk = 0x1000
	// Bit SYSIO12.
	MATRIX_CCFG_SYSIO_SYSIO12 = 0x1000

	// MATRIX_WPMR: Write Protect Mode Register
	// Position of WPEN field.
	MATRIX_MATRIX_WPMR_WPEN_Pos = 0x0
	// Bit mask of WPEN field.
	MATRIX_MATRIX_WPMR_WPEN_Msk = 0x1
	// Bit WPEN.
	MATRIX_MATRIX_WPMR_WPEN = 0x1
	// Position of WPKEY field.
	MATRIX_MATRIX_WPMR_WPKEY_Pos = 0x8
	// Bit mask of WPKEY field.
	MATRIX_MATRIX_WPMR_WPKEY_Msk = 0xffffff00

	// MATRIX_WPSR: Write Protect Status Register
	// Position of WPVS field.
	MATRIX_MATRIX_WPSR_WPVS_Pos = 0x0
	// Bit mask of WPVS field.
	MATRIX_MATRIX_WPSR_WPVS_Msk = 0x1
	// Bit WPVS.
	MATRIX_MATRIX_WPSR_WPVS = 0x1
	// Position of WPVSRC field.
	MATRIX_MATRIX_WPSR_WPVSRC_Pos = 0x8
	// Bit mask of WPVSRC field.
	MATRIX_MATRIX_WPSR_WPVSRC_Msk = 0xffff00
)

// Bitfields for PMC: Power Management Controller
const (
	// PMC_SCER: System Clock Enable Register
	// Position of UOTGCLK field.
	PMC_PMC_SCER_UOTGCLK_Pos = 0x5
	// Bit mask of UOTGCLK field.
	PMC_PMC_SCER_UOTGCLK_Msk = 0x20
	// Bit UOTGCLK.
	PMC_PMC_SCER_UOTGCLK = 0x20
	// Position of PCK0 field.
	PMC_PMC_SCER_PCK0_Pos = 0x8
	// Bit mask of PCK0 field.
	PMC_PMC_SCER_PCK0_Msk = 0x100
	// Bit PCK0.
	PMC_PMC_SCER_PCK0 = 0x100
	// Position of PCK1 field.
	PMC_PMC_SCER_PCK1_Pos = 0x9
	// Bit mask of PCK1 field.
	PMC_PMC_SCER_PCK1_Msk = 0x200
	// Bit PCK1.
	PMC_PMC_SCER_PCK1 = 0x200
	// Position of PCK2 field.
	PMC_PMC_SCER_PCK2_Pos = 0xa
	// Bit mask of PCK2 field.
	PMC_PMC_SCER_PCK2_Msk = 0x400
	// Bit PCK2.
	PMC_PMC_SCER_PCK2 = 0x400

	// PMC_SCDR: System Clock Disable Register
	// Position of UOTGCLK field.
	PMC_PMC_SCDR_UOTGCLK_Pos = 0x5
	// Bit mask of UOTGCLK field.
	PMC_PMC_SCDR_UOTGCLK_Msk = 0x20
	// Bit UOTGCLK.
	PMC_PMC_SCDR_UOTGCLK = 0x20
	// Position of PCK0 field.
	PMC_PMC_SCDR_PCK0_Pos = 0x8
	// Bit mask of PCK0 field.
	PMC_PMC_SCDR_PCK0_Msk = 0x100
	// Bit PCK0.
	PMC_PMC_SCDR_PCK0 = 0x100
	// Position of PCK1 field.
	PMC_PMC_SCDR_PCK1_Pos = 0x9
	// Bit mask of PCK1 field.
	PMC_PMC_SCDR_PCK1_Msk = 0x200
	// Bit PCK1.
	PMC_PMC_SCDR_PCK1 = 0x200
	// Position of PCK2 field.
	PMC_PMC_SCDR_PCK2_Pos = 0xa
	// Bit mask of PCK2 field.
	PMC_PMC_SCDR_PCK2_Msk = 0x400
	// Bit PCK2.
	PMC_PMC_SCDR_PCK2 = 0x400

	// PMC_SCSR: System Clock Status Register
	// Position of UOTGCLK field.
	PMC_PMC_SCSR_UOTGCLK_Pos = 0x5
	// Bit mask of UOTGCLK field.
	PMC_PMC_SCSR_UOTGCLK_Msk = 0x20
	// Bit UOTGCLK.
	PMC_PMC_SCSR_UOTGCLK = 0x20
	// Position of PCK0 field.
	PMC_PMC_SCSR_PCK0_Pos = 0x8
	// Bit mask of PCK0 field.
	PMC_PMC_SCSR_PCK0_Msk = 0x100
	// Bit PCK0.
	PMC_PMC_SCSR_PCK0 = 0x100
	// Position of PCK1 field.
	PMC_PMC_SCSR_PCK1_Pos = 0x9
	// Bit mask of PCK1 field.
	PMC_PMC_SCSR_PCK1_Msk = 0x200
	// Bit PCK1.
	PMC_PMC_SCSR_PCK1 = 0x200
	// Position of PCK2 field.
	PMC_PMC_SCSR_PCK2_Pos = 0xa
	// Bit mask of PCK2 field.
	PMC_PMC_SCSR_PCK2_Msk = 0x400
	// Bit PCK2.
	PMC_PMC_SCSR_PCK2 = 0x400

	// PMC_PCER0: Peripheral Clock Enable Register 0
	// Position of PID8 field.
	PMC_PMC_PCER0_PID8_Pos = 0x8
	// Bit mask of PID8 field.
	PMC_PMC_PCER0_PID8_Msk = 0x100
	// Bit PID8.
	PMC_PMC_PCER0_PID8 = 0x100
	// Position of PID9 field.
	PMC_PMC_PCER0_PID9_Pos = 0x9
	// Bit mask of PID9 field.
	PMC_PMC_PCER0_PID9_Msk = 0x200
	// Bit PID9.
	PMC_PMC_PCER0_PID9 = 0x200
	// Position of PID10 field.
	PMC_PMC_PCER0_PID10_Pos = 0xa
	// Bit mask of PID10 field.
	PMC_PMC_PCER0_PID10_Msk = 0x400
	// Bit PID10.
	PMC_PMC_PCER0_PID10 = 0x400
	// Position of PID11 field.
	PMC_PMC_PCER0_PID11_Pos = 0xb
	// Bit mask of PID11 field.
	PMC_PMC_PCER0_PID11_Msk = 0x800
	// Bit PID11.
	PMC_PMC_PCER0_PID11 = 0x800
	// Position of PID12 field.
	PMC_PMC_PCER0_PID12_Pos = 0xc
	// Bit mask of PID12 field.
	PMC_PMC_PCER0_PID12_Msk = 0x1000
	// Bit PID12.
	PMC_PMC_PCER0_PID12 = 0x1000
	// Position of PID13 field.
	PMC_PMC_PCER0_PID13_Pos = 0xd
	// Bit mask of PID13 field.
	PMC_PMC_PCER0_PID13_Msk = 0x2000
	// Bit PID13.
	PMC_PMC_PCER0_PID13 = 0x2000
	// Position of PID14 field.
	PMC_PMC_PCER0_PID14_Pos = 0xe
	// Bit mask of PID14 field.
	PMC_PMC_PCER0_PID14_Msk = 0x4000
	// Bit PID14.
	PMC_PMC_PCER0_PID14 = 0x4000
	// Position of PID15 field.
	PMC_PMC_PCER0_PID15_Pos = 0xf
	// Bit mask of PID15 field.
	PMC_PMC_PCER0_PID15_Msk = 0x8000
	// Bit PID15.
	PMC_PMC_PCER0_PID15 = 0x8000
	// Position of PID16 field.
	PMC_PMC_PCER0_PID16_Pos = 0x10
	// Bit mask of PID16 field.
	PMC_PMC_PCER0_PID16_Msk = 0x10000
	// Bit PID16.
	PMC_PMC_PCER0_PID16 = 0x10000
	// Position of PID17 field.
	PMC_PMC_PCER0_PID17_Pos = 0x11
	// Bit mask of PID17 field.
	PMC_PMC_PCER0_PID17_Msk = 0x20000
	// Bit PID17.
	PMC_PMC_PCER0_PID17 = 0x20000
	// Position of PID18 field.
	PMC_PMC_PCER0_PID18_Pos = 0x12
	// Bit mask of PID18 field.
	PMC_PMC_PCER0_PID18_Msk = 0x40000
	// Bit PID18.
	PMC_PMC_PCER0_PID18 = 0x40000
	// Position of PID19 field.
	PMC_PMC_PCER0_PID19_Pos = 0x13
	// Bit mask of PID19 field.
	PMC_PMC_PCER0_PID19_Msk = 0x80000
	// Bit PID19.
	PMC_PMC_PCER0_PID19 = 0x80000
	// Position of PID20 field.
	PMC_PMC_PCER0_PID20_Pos = 0x14
	// Bit mask of PID20 field.
	PMC_PMC_PCER0_PID20_Msk = 0x100000
	// Bit PID20.
	PMC_PMC_PCER0_PID20 = 0x100000
	// Position of PID21 field.
	PMC_PMC_PCER0_PID21_Pos = 0x15
	// Bit mask of PID21 field.
	PMC_PMC_PCER0_PID21_Msk = 0x200000
	// Bit PID21.
	PMC_PMC_PCER0_PID21 = 0x200000
	// Position of PID22 field.
	PMC_PMC_PCER0_PID22_Pos = 0x16
	// Bit mask of PID22 field.
	PMC_PMC_PCER0_PID22_Msk = 0x400000
	// Bit PID22.
	PMC_PMC_PCER0_PID22 = 0x400000
	// Position of PID23 field.
	PMC_PMC_PCER0_PID23_Pos = 0x17
	// Bit mask of PID23 field.
	PMC_PMC_PCER0_PID23_Msk = 0x800000
	// Bit PID23.
	PMC_PMC_PCER0_PID23 = 0x800000
	// Position of PID24 field.
	PMC_PMC_PCER0_PID24_Pos = 0x18
	// Bit mask of PID24 field.
	PMC_PMC_PCER0_PID24_Msk = 0x1000000
	// Bit PID24.
	PMC_PMC_PCER0_PID24 = 0x1000000
	// Position of PID25 field.
	PMC_PMC_PCER0_PID25_Pos = 0x19
	// Bit mask of PID25 field.
	PMC_PMC_PCER0_PID25_Msk = 0x2000000
	// Bit PID25.
	PMC_PMC_PCER0_PID25 = 0x2000000
	// Position of PID26 field.
	PMC_PMC_PCER0_PID26_Pos = 0x1a
	// Bit mask of PID26 field.
	PMC_PMC_PCER0_PID26_Msk = 0x4000000
	// Bit PID26.
	PMC_PMC_PCER0_PID26 = 0x4000000
	// Position of PID27 field.
	PMC_PMC_PCER0_PID27_Pos = 0x1b
	// Bit mask of PID27 field.
	PMC_PMC_PCER0_PID27_Msk = 0x8000000
	// Bit PID27.
	PMC_PMC_PCER0_PID27 = 0x8000000
	// Position of PID28 field.
	PMC_PMC_PCER0_PID28_Pos = 0x1c
	// Bit mask of PID28 field.
	PMC_PMC_PCER0_PID28_Msk = 0x10000000
	// Bit PID28.
	PMC_PMC_PCER0_PID28 = 0x10000000
	// Position of PID29 field.
	PMC_PMC_PCER0_PID29_Pos = 0x1d
	// Bit mask of PID29 field.
	PMC_PMC_PCER0_PID29_Msk = 0x20000000
	// Bit PID29.
	PMC_PMC_PCER0_PID29 = 0x20000000
	// Position of PID30 field.
	PMC_PMC_PCER0_PID30_Pos = 0x1e
	// Bit mask of PID30 field.
	PMC_PMC_PCER0_PID30_Msk = 0x40000000
	// Bit PID30.
	PMC_PMC_PCER0_PID30 = 0x40000000
	// Position of PID31 field.
	PMC_PMC_PCER0_PID31_Pos = 0x1f
	// Bit mask of PID31 field.
	PMC_PMC_PCER0_PID31_Msk = 0x80000000
	// Bit PID31.
	PMC_PMC_PCER0_PID31 = 0x80000000

	// PMC_PCDR0: Peripheral Clock Disable Register 0
	// Position of PID8 field.
	PMC_PMC_PCDR0_PID8_Pos = 0x8
	// Bit mask of PID8 field.
	PMC_PMC_PCDR0_PID8_Msk = 0x100
	// Bit PID8.
	PMC_PMC_PCDR0_PID8 = 0x100
	// Position of PID9 field.
	PMC_PMC_PCDR0_PID9_Pos = 0x9
	// Bit mask of PID9 field.
	PMC_PMC_PCDR0_PID9_Msk = 0x200
	// Bit PID9.
	PMC_PMC_PCDR0_PID9 = 0x200
	// Position of PID10 field.
	PMC_PMC_PCDR0_PID10_Pos = 0xa
	// Bit mask of PID10 field.
	PMC_PMC_PCDR0_PID10_Msk = 0x400
	// Bit PID10.
	PMC_PMC_PCDR0_PID10 = 0x400
	// Position of PID11 field.
	PMC_PMC_PCDR0_PID11_Pos = 0xb
	// Bit mask of PID11 field.
	PMC_PMC_PCDR0_PID11_Msk = 0x800
	// Bit PID11.
	PMC_PMC_PCDR0_PID11 = 0x800
	// Position of PID12 field.
	PMC_PMC_PCDR0_PID12_Pos = 0xc
	// Bit mask of PID12 field.
	PMC_PMC_PCDR0_PID12_Msk = 0x1000
	// Bit PID12.
	PMC_PMC_PCDR0_PID12 = 0x1000
	// Position of PID13 field.
	PMC_PMC_PCDR0_PID13_Pos = 0xd
	// Bit mask of PID13 field.
	PMC_PMC_PCDR0_PID13_Msk = 0x2000
	// Bit PID13.
	PMC_PMC_PCDR0_PID13 = 0x2000
	// Position of PID14 field.
	PMC_PMC_PCDR0_PID14_Pos = 0xe
	// Bit mask of PID14 field.
	PMC_PMC_PCDR0_PID14_Msk = 0x4000
	// Bit PID14.
	PMC_PMC_PCDR0_PID14 = 0x4000
	// Position of PID15 field.
	PMC_PMC_PCDR0_PID15_Pos = 0xf
	// Bit mask of PID15 field.
	PMC_PMC_PCDR0_PID15_Msk = 0x8000
	// Bit PID15.
	PMC_PMC_PCDR0_PID15 = 0x8000
	// Position of PID16 field.
	PMC_PMC_PCDR0_PID16_Pos = 0x10
	// Bit mask of PID16 field.
	PMC_PMC_PCDR0_PID16_Msk = 0x10000
	// Bit PID16.
	PMC_PMC_PCDR0_PID16 = 0x10000
	// Position of PID17 field.
	PMC_PMC_PCDR0_PID17_Pos = 0x11
	// Bit mask of PID17 field.
	PMC_PMC_PCDR0_PID17_Msk = 0x20000
	// Bit PID17.
	PMC_PMC_PCDR0_PID17 = 0x20000
	// Position of PID18 field.
	PMC_PMC_PCDR0_PID18_Pos = 0x12
	// Bit mask of PID18 field.
	PMC_PMC_PCDR0_PID18_Msk = 0x40000
	// Bit PID18.
	PMC_PMC_PCDR0_PID18 = 0x40000
	// Position of PID19 field.
	PMC_PMC_PCDR0_PID19_Pos = 0x13
	// Bit mask of PID19 field.
	PMC_PMC_PCDR0_PID19_Msk = 0x80000
	// Bit PID19.
	PMC_PMC_PCDR0_PID19 = 0x80000
	// Position of PID20 field.
	PMC_PMC_PCDR0_PID20_Pos = 0x14
	// Bit mask of PID20 field.
	PMC_PMC_PCDR0_PID20_Msk = 0x100000
	// Bit PID20.
	PMC_PMC_PCDR0_PID20 = 0x100000
	// Position of PID21 field.
	PMC_PMC_PCDR0_PID21_Pos = 0x15
	// Bit mask of PID21 field.
	PMC_PMC_PCDR0_PID21_Msk = 0x200000
	// Bit PID21.
	PMC_PMC_PCDR0_PID21 = 0x200000
	// Position of PID22 field.
	PMC_PMC_PCDR0_PID22_Pos = 0x16
	// Bit mask of PID22 field.
	PMC_PMC_PCDR0_PID22_Msk = 0x400000
	// Bit PID22.
	PMC_PMC_PCDR0_PID22 = 0x400000
	// Position of PID23 field.
	PMC_PMC_PCDR0_PID23_Pos = 0x17
	// Bit mask of PID23 field.
	PMC_PMC_PCDR0_PID23_Msk = 0x800000
	// Bit PID23.
	PMC_PMC_PCDR0_PID23 = 0x800000
	// Position of PID24 field.
	PMC_PMC_PCDR0_PID24_Pos = 0x18
	// Bit mask of PID24 field.
	PMC_PMC_PCDR0_PID24_Msk = 0x1000000
	// Bit PID24.
	PMC_PMC_PCDR0_PID24 = 0x1000000
	// Position of PID25 field.
	PMC_PMC_PCDR0_PID25_Pos = 0x19
	// Bit mask of PID25 field.
	PMC_PMC_PCDR0_PID25_Msk = 0x2000000
	// Bit PID25.
	PMC_PMC_PCDR0_PID25 = 0x2000000
	// Position of PID26 field.
	PMC_PMC_PCDR0_PID26_Pos = 0x1a
	// Bit mask of PID26 field.
	PMC_PMC_PCDR0_PID26_Msk = 0x4000000
	// Bit PID26.
	PMC_PMC_PCDR0_PID26 = 0x4000000
	// Position of PID27 field.
	PMC_PMC_PCDR0_PID27_Pos = 0x1b
	// Bit mask of PID27 field.
	PMC_PMC_PCDR0_PID27_Msk = 0x8000000
	// Bit PID27.
	PMC_PMC_PCDR0_PID27 = 0x8000000
	// Position of PID28 field.
	PMC_PMC_PCDR0_PID28_Pos = 0x1c
	// Bit mask of PID28 field.
	PMC_PMC_PCDR0_PID28_Msk = 0x10000000
	// Bit PID28.
	PMC_PMC_PCDR0_PID28 = 0x10000000
	// Position of PID29 field.
	PMC_PMC_PCDR0_PID29_Pos = 0x1d
	// Bit mask of PID29 field.
	PMC_PMC_PCDR0_PID29_Msk = 0x20000000
	// Bit PID29.
	PMC_PMC_PCDR0_PID29 = 0x20000000
	// Position of PID30 field.
	PMC_PMC_PCDR0_PID30_Pos = 0x1e
	// Bit mask of PID30 field.
	PMC_PMC_PCDR0_PID30_Msk = 0x40000000
	// Bit PID30.
	PMC_PMC_PCDR0_PID30 = 0x40000000
	// Position of PID31 field.
	PMC_PMC_PCDR0_PID31_Pos = 0x1f
	// Bit mask of PID31 field.
	PMC_PMC_PCDR0_PID31_Msk = 0x80000000
	// Bit PID31.
	PMC_PMC_PCDR0_PID31 = 0x80000000

	// PMC_PCSR0: Peripheral Clock Status Register 0
	// Position of PID8 field.
	PMC_PMC_PCSR0_PID8_Pos = 0x8
	// Bit mask of PID8 field.
	PMC_PMC_PCSR0_PID8_Msk = 0x100
	// Bit PID8.
	PMC_PMC_PCSR0_PID8 = 0x100
	// Position of PID9 field.
	PMC_PMC_PCSR0_PID9_Pos = 0x9
	// Bit mask of PID9 field.
	PMC_PMC_PCSR0_PID9_Msk = 0x200
	// Bit PID9.
	PMC_PMC_PCSR0_PID9 = 0x200
	// Position of PID10 field.
	PMC_PMC_PCSR0_PID10_Pos = 0xa
	// Bit mask of PID10 field.
	PMC_PMC_PCSR0_PID10_Msk = 0x400
	// Bit PID10.
	PMC_PMC_PCSR0_PID10 = 0x400
	// Position of PID11 field.
	PMC_PMC_PCSR0_PID11_Pos = 0xb
	// Bit mask of PID11 field.
	PMC_PMC_PCSR0_PID11_Msk = 0x800
	// Bit PID11.
	PMC_PMC_PCSR0_PID11 = 0x800
	// Position of PID12 field.
	PMC_PMC_PCSR0_PID12_Pos = 0xc
	// Bit mask of PID12 field.
	PMC_PMC_PCSR0_PID12_Msk = 0x1000
	// Bit PID12.
	PMC_PMC_PCSR0_PID12 = 0x1000
	// Position of PID13 field.
	PMC_PMC_PCSR0_PID13_Pos = 0xd
	// Bit mask of PID13 field.
	PMC_PMC_PCSR0_PID13_Msk = 0x2000
	// Bit PID13.
	PMC_PMC_PCSR0_PID13 = 0x2000
	// Position of PID14 field.
	PMC_PMC_PCSR0_PID14_Pos = 0xe
	// Bit mask of PID14 field.
	PMC_PMC_PCSR0_PID14_Msk = 0x4000
	// Bit PID14.
	PMC_PMC_PCSR0_PID14 = 0x4000
	// Position of PID15 field.
	PMC_PMC_PCSR0_PID15_Pos = 0xf
	// Bit mask of PID15 field.
	PMC_PMC_PCSR0_PID15_Msk = 0x8000
	// Bit PID15.
	PMC_PMC_PCSR0_PID15 = 0x8000
	// Position of PID16 field.
	PMC_PMC_PCSR0_PID16_Pos = 0x10
	// Bit mask of PID16 field.
	PMC_PMC_PCSR0_PID16_Msk = 0x10000
	// Bit PID16.
	PMC_PMC_PCSR0_PID16 = 0x10000
	// Position of PID17 field.
	PMC_PMC_PCSR0_PID17_Pos = 0x11
	// Bit mask of PID17 field.
	PMC_PMC_PCSR0_PID17_Msk = 0x20000
	// Bit PID17.
	PMC_PMC_PCSR0_PID17 = 0x20000
	// Position of PID18 field.
	PMC_PMC_PCSR0_PID18_Pos = 0x12
	// Bit mask of PID18 field.
	PMC_PMC_PCSR0_PID18_Msk = 0x40000
	// Bit PID18.
	PMC_PMC_PCSR0_PID18 = 0x40000
	// Position of PID19 field.
	PMC_PMC_PCSR0_PID19_Pos = 0x13
	// Bit mask of PID19 field.
	PMC_PMC_PCSR0_PID19_Msk = 0x80000
	// Bit PID19.
	PMC_PMC_PCSR0_PID19 = 0x80000
	// Position of PID20 field.
	PMC_PMC_PCSR0_PID20_Pos = 0x14
	// Bit mask of PID20 field.
	PMC_PMC_PCSR0_PID20_Msk = 0x100000
	// Bit PID20.
	PMC_PMC_PCSR0_PID20 = 0x100000
	// Position of PID21 field.
	PMC_PMC_PCSR0_PID21_Pos = 0x15
	// Bit mask of PID21 field.
	PMC_PMC_PCSR0_PID21_Msk = 0x200000
	// Bit PID21.
	PMC_PMC_PCSR0_PID21 = 0x200000
	// Position of PID22 field.
	PMC_PMC_PCSR0_PID22_Pos = 0x16
	// Bit mask of PID22 field.
	PMC_PMC_PCSR0_PID22_Msk = 0x400000
	// Bit PID22.
	PMC_PMC_PCSR0_PID22 = 0x400000
	// Position of PID23 field.
	PMC_PMC_PCSR0_PID23_Pos = 0x17
	// Bit mask of PID23 field.
	PMC_PMC_PCSR0_PID23_Msk = 0x800000
	// Bit PID23.
	PMC_PMC_PCSR0_PID23 = 0x800000
	// Position of PID24 field.
	PMC_PMC_PCSR0_PID24_Pos = 0x18
	// Bit mask of PID24 field.
	PMC_PMC_PCSR0_PID24_Msk = 0x1000000
	// Bit PID24.
	PMC_PMC_PCSR0_PID24 = 0x1000000
	// Position of PID25 field.
	PMC_PMC_PCSR0_PID25_Pos = 0x19
	// Bit mask of PID25 field.
	PMC_PMC_PCSR0_PID25_Msk = 0x2000000
	// Bit PID25.
	PMC_PMC_PCSR0_PID25 = 0x2000000
	// Position of PID26 field.
	PMC_PMC_PCSR0_PID26_Pos = 0x1a
	// Bit mask of PID26 field.
	PMC_PMC_PCSR0_PID26_Msk = 0x4000000
	// Bit PID26.
	PMC_PMC_PCSR0_PID26 = 0x4000000
	// Position of PID27 field.
	PMC_PMC_PCSR0_PID27_Pos = 0x1b
	// Bit mask of PID27 field.
	PMC_PMC_PCSR0_PID27_Msk = 0x8000000
	// Bit PID27.
	PMC_PMC_PCSR0_PID27 = 0x8000000
	// Position of PID28 field.
	PMC_PMC_PCSR0_PID28_Pos = 0x1c
	// Bit mask of PID28 field.
	PMC_PMC_PCSR0_PID28_Msk = 0x10000000
	// Bit PID28.
	PMC_PMC_PCSR0_PID28 = 0x10000000
	// Position of PID29 field.
	PMC_PMC_PCSR0_PID29_Pos = 0x1d
	// Bit mask of PID29 field.
	PMC_PMC_PCSR0_PID29_Msk = 0x20000000
	// Bit PID29.
	PMC_PMC_PCSR0_PID29 = 0x20000000
	// Position of PID30 field.
	PMC_PMC_PCSR0_PID30_Pos = 0x1e
	// Bit mask of PID30 field.
	PMC_PMC_PCSR0_PID30_Msk = 0x40000000
	// Bit PID30.
	PMC_PMC_PCSR0_PID30 = 0x40000000
	// Position of PID31 field.
	PMC_PMC_PCSR0_PID31_Pos = 0x1f
	// Bit mask of PID31 field.
	PMC_PMC_PCSR0_PID31_Msk = 0x80000000
	// Bit PID31.
	PMC_PMC_PCSR0_PID31 = 0x80000000

	// CKGR_UCKR: UTMI Clock Register
	// Position of UPLLEN field.
	PMC_CKGR_UCKR_UPLLEN_Pos = 0x10
	// Bit mask of UPLLEN field.
	PMC_CKGR_UCKR_UPLLEN_Msk = 0x10000
	// Bit UPLLEN.
	PMC_CKGR_UCKR_UPLLEN = 0x10000
	// Position of UPLLCOUNT field.
	PMC_CKGR_UCKR_UPLLCOUNT_Pos = 0x14
	// Bit mask of UPLLCOUNT field.
	PMC_CKGR_UCKR_UPLLCOUNT_Msk = 0xf00000

	// CKGR_MOR: Main Oscillator Register
	// Position of MOSCXTEN field.
	PMC_CKGR_MOR_MOSCXTEN_Pos = 0x0
	// Bit mask of MOSCXTEN field.
	PMC_CKGR_MOR_MOSCXTEN_Msk = 0x1
	// Bit MOSCXTEN.
	PMC_CKGR_MOR_MOSCXTEN = 0x1
	// Position of MOSCXTBY field.
	PMC_CKGR_MOR_MOSCXTBY_Pos = 0x1
	// Bit mask of MOSCXTBY field.
	PMC_CKGR_MOR_MOSCXTBY_Msk = 0x2
	// Bit MOSCXTBY.
	PMC_CKGR_MOR_MOSCXTBY = 0x2
	// Position of MOSCRCEN field.
	PMC_CKGR_MOR_MOSCRCEN_Pos = 0x3
	// Bit mask of MOSCRCEN field.
	PMC_CKGR_MOR_MOSCRCEN_Msk = 0x8
	// Bit MOSCRCEN.
	PMC_CKGR_MOR_MOSCRCEN = 0x8
	// Position of MOSCRCF field.
	PMC_CKGR_MOR_MOSCRCF_Pos = 0x4
	// Bit mask of MOSCRCF field.
	PMC_CKGR_MOR_MOSCRCF_Msk = 0x70
	// The Fast RC Oscillator Frequency is at 4 MHz (default)
	PMC_CKGR_MOR_MOSCRCF_4_MHz = 0x0
	// The Fast RC Oscillator Frequency is at 8 MHz
	PMC_CKGR_MOR_MOSCRCF_8_MHz = 0x1
	// The Fast RC Oscillator Frequency is at 12 MHz
	PMC_CKGR_MOR_MOSCRCF_12_MHz = 0x2
	// Position of MOSCXTST field.
	PMC_CKGR_MOR_MOSCXTST_Pos = 0x8
	// Bit mask of MOSCXTST field.
	PMC_CKGR_MOR_MOSCXTST_Msk = 0xff00
	// Position of KEY field.
	PMC_CKGR_MOR_KEY_Pos = 0x10
	// Bit mask of KEY field.
	PMC_CKGR_MOR_KEY_Msk = 0xff0000
	// Writing any other value in this field aborts the write operation.Always reads as 0.
	PMC_CKGR_MOR_KEY_PASSWD = 0x37
	// Position of MOSCSEL field.
	PMC_CKGR_MOR_MOSCSEL_Pos = 0x18
	// Bit mask of MOSCSEL field.
	PMC_CKGR_MOR_MOSCSEL_Msk = 0x1000000
	// Bit MOSCSEL.
	PMC_CKGR_MOR_MOSCSEL = 0x1000000
	// Position of CFDEN field.
	PMC_CKGR_MOR_CFDEN_Pos = 0x19
	// Bit mask of CFDEN field.
	PMC_CKGR_MOR_CFDEN_Msk = 0x2000000
	// Bit CFDEN.
	PMC_CKGR_MOR_CFDEN = 0x2000000

	// CKGR_MCFR: Main Clock Frequency Register
	// Position of MAINF field.
	PMC_CKGR_MCFR_MAINF_Pos = 0x0
	// Bit mask of MAINF field.
	PMC_CKGR_MCFR_MAINF_Msk = 0xffff
	// Position of MAINFRDY field.
	PMC_CKGR_MCFR_MAINFRDY_Pos = 0x10
	// Bit mask of MAINFRDY field.
	PMC_CKGR_MCFR_MAINFRDY_Msk = 0x10000
	// Bit MAINFRDY.
	PMC_CKGR_MCFR_MAINFRDY = 0x10000

	// CKGR_PLLAR: PLLA Register
	// Position of DIVA field.
	PMC_CKGR_PLLAR_DIVA_Pos = 0x0
	// Bit mask of DIVA field.
	PMC_CKGR_PLLAR_DIVA_Msk = 0xff
	// Position of PLLACOUNT field.
	PMC_CKGR_PLLAR_PLLACOUNT_Pos = 0x8
	// Bit mask of PLLACOUNT field.
	PMC_CKGR_PLLAR_PLLACOUNT_Msk = 0x3f00
	// Position of MULA field.
	PMC_CKGR_PLLAR_MULA_Pos = 0x10
	// Bit mask of MULA field.
	PMC_CKGR_PLLAR_MULA_Msk = 0x7ff0000
	// Position of ONE field.
	PMC_CKGR_PLLAR_ONE_Pos = 0x1d
	// Bit mask of ONE field.
	PMC_CKGR_PLLAR_ONE_Msk = 0x20000000
	// Bit ONE.
	PMC_CKGR_PLLAR_ONE = 0x20000000

	// PMC_MCKR: Master Clock Register
	// Position of CSS field.
	PMC_PMC_MCKR_CSS_Pos = 0x0
	// Bit mask of CSS field.
	PMC_PMC_MCKR_CSS_Msk = 0x3
	// Slow Clock is selected
	PMC_PMC_MCKR_CSS_SLOW_CLK = 0x0
	// Main Clock is selected
	PMC_PMC_MCKR_CSS_MAIN_CLK = 0x1
	// PLLA Clock is selected
	PMC_PMC_MCKR_CSS_PLLA_CLK = 0x2
	// UPLL Clock is selected
	PMC_PMC_MCKR_CSS_UPLL_CLK = 0x3
	// Position of PRES field.
	PMC_PMC_MCKR_PRES_Pos = 0x4
	// Bit mask of PRES field.
	PMC_PMC_MCKR_PRES_Msk = 0x70
	// Selected clock
	PMC_PMC_MCKR_PRES_CLK_1 = 0x0
	// Selected clock divided by 2
	PMC_PMC_MCKR_PRES_CLK_2 = 0x1
	// Selected clock divided by 4
	PMC_PMC_MCKR_PRES_CLK_4 = 0x2
	// Selected clock divided by 8
	PMC_PMC_MCKR_PRES_CLK_8 = 0x3
	// Selected clock divided by 16
	PMC_PMC_MCKR_PRES_CLK_16 = 0x4
	// Selected clock divided by 32
	PMC_PMC_MCKR_PRES_CLK_32 = 0x5
	// Selected clock divided by 64
	PMC_PMC_MCKR_PRES_CLK_64 = 0x6
	// Selected clock divided by 3
	PMC_PMC_MCKR_PRES_CLK_3 = 0x7
	// Position of PLLADIV2 field.
	PMC_PMC_MCKR_PLLADIV2_Pos = 0xc
	// Bit mask of PLLADIV2 field.
	PMC_PMC_MCKR_PLLADIV2_Msk = 0x1000
	// Bit PLLADIV2.
	PMC_PMC_MCKR_PLLADIV2 = 0x1000
	// Position of UPLLDIV2 field.
	PMC_PMC_MCKR_UPLLDIV2_Pos = 0xd
	// Bit mask of UPLLDIV2 field.
	PMC_PMC_MCKR_UPLLDIV2_Msk = 0x2000
	// Bit UPLLDIV2.
	PMC_PMC_MCKR_UPLLDIV2 = 0x2000

	// PMC_USB: USB Clock Register
	// Position of USBS field.
	PMC_PMC_USB_USBS_Pos = 0x0
	// Bit mask of USBS field.
	PMC_PMC_USB_USBS_Msk = 0x1
	// Bit USBS.
	PMC_PMC_USB_USBS = 0x1
	// Position of USBDIV field.
	PMC_PMC_USB_USBDIV_Pos = 0x8
	// Bit mask of USBDIV field.
	PMC_PMC_USB_USBDIV_Msk = 0xf00

	// PMC_PCK: Programmable Clock 0 Register
	// Position of CSS field.
	PMC_PMC_PCK_CSS_Pos = 0x0
	// Bit mask of CSS field.
	PMC_PMC_PCK_CSS_Msk = 0x7
	// Slow Clock is selected
	PMC_PMC_PCK_CSS_SLOW_CLK = 0x0
	// Main Clock is selected
	PMC_PMC_PCK_CSS_MAIN_CLK = 0x1
	// PLLA Clock is selected
	PMC_PMC_PCK_CSS_PLLA_CLK = 0x2
	// UPLL Clock is selected
	PMC_PMC_PCK_CSS_UPLL_CLK = 0x3
	// Master Clock is selected
	PMC_PMC_PCK_CSS_MCK = 0x4
	// Position of PRES field.
	PMC_PMC_PCK_PRES_Pos = 0x4
	// Bit mask of PRES field.
	PMC_PMC_PCK_PRES_Msk = 0x70
	// Selected clock
	PMC_PMC_PCK_PRES_CLK_1 = 0x0
	// Selected clock divided by 2
	PMC_PMC_PCK_PRES_CLK_2 = 0x1
	// Selected clock divided by 4
	PMC_PMC_PCK_PRES_CLK_4 = 0x2
	// Selected clock divided by 8
	PMC_PMC_PCK_PRES_CLK_8 = 0x3
	// Selected clock divided by 16
	PMC_PMC_PCK_PRES_CLK_16 = 0x4
	// Selected clock divided by 32
	PMC_PMC_PCK_PRES_CLK_32 = 0x5
	// Selected clock divided by 64
	PMC_PMC_PCK_PRES_CLK_64 = 0x6

	// PMC_IER: Interrupt Enable Register
	// Position of MOSCXTS field.
	PMC_PMC_IER_MOSCXTS_Pos = 0x0
	// Bit mask of MOSCXTS field.
	PMC_PMC_IER_MOSCXTS_Msk = 0x1
	// Bit MOSCXTS.
	PMC_PMC_IER_MOSCXTS = 0x1
	// Position of LOCKA field.
	PMC_PMC_IER_LOCKA_Pos = 0x1
	// Bit mask of LOCKA field.
	PMC_PMC_IER_LOCKA_Msk = 0x2
	// Bit LOCKA.
	PMC_PMC_IER_LOCKA = 0x2
	// Position of MCKRDY field.
	PMC_PMC_IER_MCKRDY_Pos = 0x3
	// Bit mask of MCKRDY field.
	PMC_PMC_IER_MCKRDY_Msk = 0x8
	// Bit MCKRDY.
	PMC_PMC_IER_MCKRDY = 0x8
	// Position of LOCKU field.
	PMC_PMC_IER_LOCKU_Pos = 0x6
	// Bit mask of LOCKU field.
	PMC_PMC_IER_LOCKU_Msk = 0x40
	// Bit LOCKU.
	PMC_PMC_IER_LOCKU = 0x40
	// Position of PCKRDY0 field.
	PMC_PMC_IER_PCKRDY0_Pos = 0x8
	// Bit mask of PCKRDY0 field.
	PMC_PMC_IER_PCKRDY0_Msk = 0x100
	// Bit PCKRDY0.
	PMC_PMC_IER_PCKRDY0 = 0x100
	// Position of PCKRDY1 field.
	PMC_PMC_IER_PCKRDY1_Pos = 0x9
	// Bit mask of PCKRDY1 field.
	PMC_PMC_IER_PCKRDY1_Msk = 0x200
	// Bit PCKRDY1.
	PMC_PMC_IER_PCKRDY1 = 0x200
	// Position of PCKRDY2 field.
	PMC_PMC_IER_PCKRDY2_Pos = 0xa
	// Bit mask of PCKRDY2 field.
	PMC_PMC_IER_PCKRDY2_Msk = 0x400
	// Bit PCKRDY2.
	PMC_PMC_IER_PCKRDY2 = 0x400
	// Position of MOSCSELS field.
	PMC_PMC_IER_MOSCSELS_Pos = 0x10
	// Bit mask of MOSCSELS field.
	PMC_PMC_IER_MOSCSELS_Msk = 0x10000
	// Bit MOSCSELS.
	PMC_PMC_IER_MOSCSELS = 0x10000
	// Position of MOSCRCS field.
	PMC_PMC_IER_MOSCRCS_Pos = 0x11
	// Bit mask of MOSCRCS field.
	PMC_PMC_IER_MOSCRCS_Msk = 0x20000
	// Bit MOSCRCS.
	PMC_PMC_IER_MOSCRCS = 0x20000
	// Position of CFDEV field.
	PMC_PMC_IER_CFDEV_Pos = 0x12
	// Bit mask of CFDEV field.
	PMC_PMC_IER_CFDEV_Msk = 0x40000
	// Bit CFDEV.
	PMC_PMC_IER_CFDEV = 0x40000

	// PMC_IDR: Interrupt Disable Register
	// Position of MOSCXTS field.
	PMC_PMC_IDR_MOSCXTS_Pos = 0x0
	// Bit mask of MOSCXTS field.
	PMC_PMC_IDR_MOSCXTS_Msk = 0x1
	// Bit MOSCXTS.
	PMC_PMC_IDR_MOSCXTS = 0x1
	// Position of LOCKA field.
	PMC_PMC_IDR_LOCKA_Pos = 0x1
	// Bit mask of LOCKA field.
	PMC_PMC_IDR_LOCKA_Msk = 0x2
	// Bit LOCKA.
	PMC_PMC_IDR_LOCKA = 0x2
	// Position of MCKRDY field.
	PMC_PMC_IDR_MCKRDY_Pos = 0x3
	// Bit mask of MCKRDY field.
	PMC_PMC_IDR_MCKRDY_Msk = 0x8
	// Bit MCKRDY.
	PMC_PMC_IDR_MCKRDY = 0x8
	// Position of LOCKU field.
	PMC_PMC_IDR_LOCKU_Pos = 0x6
	// Bit mask of LOCKU field.
	PMC_PMC_IDR_LOCKU_Msk = 0x40
	// Bit LOCKU.
	PMC_PMC_IDR_LOCKU = 0x40
	// Position of PCKRDY0 field.
	PMC_PMC_IDR_PCKRDY0_Pos = 0x8
	// Bit mask of PCKRDY0 field.
	PMC_PMC_IDR_PCKRDY0_Msk = 0x100
	// Bit PCKRDY0.
	PMC_PMC_IDR_PCKRDY0 = 0x100
	// Position of PCKRDY1 field.
	PMC_PMC_IDR_PCKRDY1_Pos = 0x9
	// Bit mask of PCKRDY1 field.
	PMC_PMC_IDR_PCKRDY1_Msk = 0x200
	// Bit PCKRDY1.
	PMC_PMC_IDR_PCKRDY1 = 0x200
	// Position of PCKRDY2 field.
	PMC_PMC_IDR_PCKRDY2_Pos = 0xa
	// Bit mask of PCKRDY2 field.
	PMC_PMC_IDR_PCKRDY2_Msk = 0x400
	// Bit PCKRDY2.
	PMC_PMC_IDR_PCKRDY2 = 0x400
	// Position of MOSCSELS field.
	PMC_PMC_IDR_MOSCSELS_Pos = 0x10
	// Bit mask of MOSCSELS field.
	PMC_PMC_IDR_MOSCSELS_Msk = 0x10000
	// Bit MOSCSELS.
	PMC_PMC_IDR_MOSCSELS = 0x10000
	// Position of MOSCRCS field.
	PMC_PMC_IDR_MOSCRCS_Pos = 0x11
	// Bit mask of MOSCRCS field.
	PMC_PMC_IDR_MOSCRCS_Msk = 0x20000
	// Bit MOSCRCS.
	PMC_PMC_IDR_MOSCRCS = 0x20000
	// Position of CFDEV field.
	PMC_PMC_IDR_CFDEV_Pos = 0x12
	// Bit mask of CFDEV field.
	PMC_PMC_IDR_CFDEV_Msk = 0x40000
	// Bit CFDEV.
	PMC_PMC_IDR_CFDEV = 0x40000

	// PMC_SR: Status Register
	// Position of MOSCXTS field.
	PMC_PMC_SR_MOSCXTS_Pos = 0x0
	// Bit mask of MOSCXTS field.
	PMC_PMC_SR_MOSCXTS_Msk = 0x1
	// Bit MOSCXTS.
	PMC_PMC_SR_MOSCXTS = 0x1
	// Position of LOCKA field.
	PMC_PMC_SR_LOCKA_Pos = 0x1
	// Bit mask of LOCKA field.
	PMC_PMC_SR_LOCKA_Msk = 0x2
	// Bit LOCKA.
	PMC_PMC_SR_LOCKA = 0x2
	// Position of MCKRDY field.
	PMC_PMC_SR_MCKRDY_Pos = 0x3
	// Bit mask of MCKRDY field.
	PMC_PMC_SR_MCKRDY_Msk = 0x8
	// Bit MCKRDY.
	PMC_PMC_SR_MCKRDY = 0x8
	// Position of LOCKU field.
	PMC_PMC_SR_LOCKU_Pos = 0x6
	// Bit mask of LOCKU field.
	PMC_PMC_SR_LOCKU_Msk = 0x40
	// Bit LOCKU.
	PMC_PMC_SR_LOCKU = 0x40
	// Position of OSCSELS field.
	PMC_PMC_SR_OSCSELS_Pos = 0x7
	// Bit mask of OSCSELS field.
	PMC_PMC_SR_OSCSELS_Msk = 0x80
	// Bit OSCSELS.
	PMC_PMC_SR_OSCSELS = 0x80
	// Position of PCKRDY0 field.
	PMC_PMC_SR_PCKRDY0_Pos = 0x8
	// Bit mask of PCKRDY0 field.
	PMC_PMC_SR_PCKRDY0_Msk = 0x100
	// Bit PCKRDY0.
	PMC_PMC_SR_PCKRDY0 = 0x100
	// Position of PCKRDY1 field.
	PMC_PMC_SR_PCKRDY1_Pos = 0x9
	// Bit mask of PCKRDY1 field.
	PMC_PMC_SR_PCKRDY1_Msk = 0x200
	// Bit PCKRDY1.
	PMC_PMC_SR_PCKRDY1 = 0x200
	// Position of PCKRDY2 field.
	PMC_PMC_SR_PCKRDY2_Pos = 0xa
	// Bit mask of PCKRDY2 field.
	PMC_PMC_SR_PCKRDY2_Msk = 0x400
	// Bit PCKRDY2.
	PMC_PMC_SR_PCKRDY2 = 0x400
	// Position of MOSCSELS field.
	PMC_PMC_SR_MOSCSELS_Pos = 0x10
	// Bit mask of MOSCSELS field.
	PMC_PMC_SR_MOSCSELS_Msk = 0x10000
	// Bit MOSCSELS.
	PMC_PMC_SR_MOSCSELS = 0x10000
	// Position of MOSCRCS field.
	PMC_PMC_SR_MOSCRCS_Pos = 0x11
	// Bit mask of MOSCRCS field.
	PMC_PMC_SR_MOSCRCS_Msk = 0x20000
	// Bit MOSCRCS.
	PMC_PMC_SR_MOSCRCS = 0x20000
	// Position of CFDEV field.
	PMC_PMC_SR_CFDEV_Pos = 0x12
	// Bit mask of CFDEV field.
	PMC_PMC_SR_CFDEV_Msk = 0x40000
	// Bit CFDEV.
	PMC_PMC_SR_CFDEV = 0x40000
	// Position of CFDS field.
	PMC_PMC_SR_CFDS_Pos = 0x13
	// Bit mask of CFDS field.
	PMC_PMC_SR_CFDS_Msk = 0x80000
	// Bit CFDS.
	PMC_PMC_SR_CFDS = 0x80000
	// Position of FOS field.
	PMC_PMC_SR_FOS_Pos = 0x14
	// Bit mask of FOS field.
	PMC_PMC_SR_FOS_Msk = 0x100000
	// Bit FOS.
	PMC_PMC_SR_FOS = 0x100000

	// PMC_IMR: Interrupt Mask Register
	// Position of MOSCXTS field.
	PMC_PMC_IMR_MOSCXTS_Pos = 0x0
	// Bit mask of MOSCXTS field.
	PMC_PMC_IMR_MOSCXTS_Msk = 0x1
	// Bit MOSCXTS.
	PMC_PMC_IMR_MOSCXTS = 0x1
	// Position of LOCKA field.
	PMC_PMC_IMR_LOCKA_Pos = 0x1
	// Bit mask of LOCKA field.
	PMC_PMC_IMR_LOCKA_Msk = 0x2
	// Bit LOCKA.
	PMC_PMC_IMR_LOCKA = 0x2
	// Position of MCKRDY field.
	PMC_PMC_IMR_MCKRDY_Pos = 0x3
	// Bit mask of MCKRDY field.
	PMC_PMC_IMR_MCKRDY_Msk = 0x8
	// Bit MCKRDY.
	PMC_PMC_IMR_MCKRDY = 0x8
	// Position of LOCKU field.
	PMC_PMC_IMR_LOCKU_Pos = 0x6
	// Bit mask of LOCKU field.
	PMC_PMC_IMR_LOCKU_Msk = 0x40
	// Bit LOCKU.
	PMC_PMC_IMR_LOCKU = 0x40
	// Position of PCKRDY0 field.
	PMC_PMC_IMR_PCKRDY0_Pos = 0x8
	// Bit mask of PCKRDY0 field.
	PMC_PMC_IMR_PCKRDY0_Msk = 0x100
	// Bit PCKRDY0.
	PMC_PMC_IMR_PCKRDY0 = 0x100
	// Position of PCKRDY1 field.
	PMC_PMC_IMR_PCKRDY1_Pos = 0x9
	// Bit mask of PCKRDY1 field.
	PMC_PMC_IMR_PCKRDY1_Msk = 0x200
	// Bit PCKRDY1.
	PMC_PMC_IMR_PCKRDY1 = 0x200
	// Position of PCKRDY2 field.
	PMC_PMC_IMR_PCKRDY2_Pos = 0xa
	// Bit mask of PCKRDY2 field.
	PMC_PMC_IMR_PCKRDY2_Msk = 0x400
	// Bit PCKRDY2.
	PMC_PMC_IMR_PCKRDY2 = 0x400
	// Position of MOSCSELS field.
	PMC_PMC_IMR_MOSCSELS_Pos = 0x10
	// Bit mask of MOSCSELS field.
	PMC_PMC_IMR_MOSCSELS_Msk = 0x10000
	// Bit MOSCSELS.
	PMC_PMC_IMR_MOSCSELS = 0x10000
	// Position of MOSCRCS field.
	PMC_PMC_IMR_MOSCRCS_Pos = 0x11
	// Bit mask of MOSCRCS field.
	PMC_PMC_IMR_MOSCRCS_Msk = 0x20000
	// Bit MOSCRCS.
	PMC_PMC_IMR_MOSCRCS = 0x20000
	// Position of CFDEV field.
	PMC_PMC_IMR_CFDEV_Pos = 0x12
	// Bit mask of CFDEV field.
	PMC_PMC_IMR_CFDEV_Msk = 0x40000
	// Bit CFDEV.
	PMC_PMC_IMR_CFDEV = 0x40000

	// PMC_FSMR: Fast Start-up Mode Register
	// Position of FSTT0 field.
	PMC_PMC_FSMR_FSTT0_Pos = 0x0
	// Bit mask of FSTT0 field.
	PMC_PMC_FSMR_FSTT0_Msk = 0x1
	// Bit FSTT0.
	PMC_PMC_FSMR_FSTT0 = 0x1
	// Position of FSTT1 field.
	PMC_PMC_FSMR_FSTT1_Pos = 0x1
	// Bit mask of FSTT1 field.
	PMC_PMC_FSMR_FSTT1_Msk = 0x2
	// Bit FSTT1.
	PMC_PMC_FSMR_FSTT1 = 0x2
	// Position of FSTT2 field.
	PMC_PMC_FSMR_FSTT2_Pos = 0x2
	// Bit mask of FSTT2 field.
	PMC_PMC_FSMR_FSTT2_Msk = 0x4
	// Bit FSTT2.
	PMC_PMC_FSMR_FSTT2 = 0x4
	// Position of FSTT3 field.
	PMC_PMC_FSMR_FSTT3_Pos = 0x3
	// Bit mask of FSTT3 field.
	PMC_PMC_FSMR_FSTT3_Msk = 0x8
	// Bit FSTT3.
	PMC_PMC_FSMR_FSTT3 = 0x8
	// Position of FSTT4 field.
	PMC_PMC_FSMR_FSTT4_Pos = 0x4
	// Bit mask of FSTT4 field.
	PMC_PMC_FSMR_FSTT4_Msk = 0x10
	// Bit FSTT4.
	PMC_PMC_FSMR_FSTT4 = 0x10
	// Position of FSTT5 field.
	PMC_PMC_FSMR_FSTT5_Pos = 0x5
	// Bit mask of FSTT5 field.
	PMC_PMC_FSMR_FSTT5_Msk = 0x20
	// Bit FSTT5.
	PMC_PMC_FSMR_FSTT5 = 0x20
	// Position of FSTT6 field.
	PMC_PMC_FSMR_FSTT6_Pos = 0x6
	// Bit mask of FSTT6 field.
	PMC_PMC_FSMR_FSTT6_Msk = 0x40
	// Bit FSTT6.
	PMC_PMC_FSMR_FSTT6 = 0x40
	// Position of FSTT7 field.
	PMC_PMC_FSMR_FSTT7_Pos = 0x7
	// Bit mask of FSTT7 field.
	PMC_PMC_FSMR_FSTT7_Msk = 0x80
	// Bit FSTT7.
	PMC_PMC_FSMR_FSTT7 = 0x80
	// Position of FSTT8 field.
	PMC_PMC_FSMR_FSTT8_Pos = 0x8
	// Bit mask of FSTT8 field.
	PMC_PMC_FSMR_FSTT8_Msk = 0x100
	// Bit FSTT8.
	PMC_PMC_FSMR_FSTT8 = 0x100
	// Position of FSTT9 field.
	PMC_PMC_FSMR_FSTT9_Pos = 0x9
	// Bit mask of FSTT9 field.
	PMC_PMC_FSMR_FSTT9_Msk = 0x200
	// Bit FSTT9.
	PMC_PMC_FSMR_FSTT9 = 0x200
	// Position of FSTT10 field.
	PMC_PMC_FSMR_FSTT10_Pos = 0xa
	// Bit mask of FSTT10 field.
	PMC_PMC_FSMR_FSTT10_Msk = 0x400
	// Bit FSTT10.
	PMC_PMC_FSMR_FSTT10 = 0x400
	// Position of FSTT11 field.
	PMC_PMC_FSMR_FSTT11_Pos = 0xb
	// Bit mask of FSTT11 field.
	PMC_PMC_FSMR_FSTT11_Msk = 0x800
	// Bit FSTT11.
	PMC_PMC_FSMR_FSTT11 = 0x800
	// Position of FSTT12 field.
	PMC_PMC_FSMR_FSTT12_Pos = 0xc
	// Bit mask of FSTT12 field.
	PMC_PMC_FSMR_FSTT12_Msk = 0x1000
	// Bit FSTT12.
	PMC_PMC_FSMR_FSTT12 = 0x1000
	// Position of FSTT13 field.
	PMC_PMC_FSMR_FSTT13_Pos = 0xd
	// Bit mask of FSTT13 field.
	PMC_PMC_FSMR_FSTT13_Msk = 0x2000
	// Bit FSTT13.
	PMC_PMC_FSMR_FSTT13 = 0x2000
	// Position of FSTT14 field.
	PMC_PMC_FSMR_FSTT14_Pos = 0xe
	// Bit mask of FSTT14 field.
	PMC_PMC_FSMR_FSTT14_Msk = 0x4000
	// Bit FSTT14.
	PMC_PMC_FSMR_FSTT14 = 0x4000
	// Position of FSTT15 field.
	PMC_PMC_FSMR_FSTT15_Pos = 0xf
	// Bit mask of FSTT15 field.
	PMC_PMC_FSMR_FSTT15_Msk = 0x8000
	// Bit FSTT15.
	PMC_PMC_FSMR_FSTT15 = 0x8000
	// Position of RTTAL field.
	PMC_PMC_FSMR_RTTAL_Pos = 0x10
	// Bit mask of RTTAL field.
	PMC_PMC_FSMR_RTTAL_Msk = 0x10000
	// Bit RTTAL.
	PMC_PMC_FSMR_RTTAL = 0x10000
	// Position of RTCAL field.
	PMC_PMC_FSMR_RTCAL_Pos = 0x11
	// Bit mask of RTCAL field.
	PMC_PMC_FSMR_RTCAL_Msk = 0x20000
	// Bit RTCAL.
	PMC_PMC_FSMR_RTCAL = 0x20000
	// Position of USBAL field.
	PMC_PMC_FSMR_USBAL_Pos = 0x12
	// Bit mask of USBAL field.
	PMC_PMC_FSMR_USBAL_Msk = 0x40000
	// Bit USBAL.
	PMC_PMC_FSMR_USBAL = 0x40000
	// Position of LPM field.
	PMC_PMC_FSMR_LPM_Pos = 0x14
	// Bit mask of LPM field.
	PMC_PMC_FSMR_LPM_Msk = 0x100000
	// Bit LPM.
	PMC_PMC_FSMR_LPM = 0x100000

	// PMC_FSPR: Fast Start-up Polarity Register
	// Position of FSTP0 field.
	PMC_PMC_FSPR_FSTP0_Pos = 0x0
	// Bit mask of FSTP0 field.
	PMC_PMC_FSPR_FSTP0_Msk = 0x1
	// Bit FSTP0.
	PMC_PMC_FSPR_FSTP0 = 0x1
	// Position of FSTP1 field.
	PMC_PMC_FSPR_FSTP1_Pos = 0x1
	// Bit mask of FSTP1 field.
	PMC_PMC_FSPR_FSTP1_Msk = 0x2
	// Bit FSTP1.
	PMC_PMC_FSPR_FSTP1 = 0x2
	// Position of FSTP2 field.
	PMC_PMC_FSPR_FSTP2_Pos = 0x2
	// Bit mask of FSTP2 field.
	PMC_PMC_FSPR_FSTP2_Msk = 0x4
	// Bit FSTP2.
	PMC_PMC_FSPR_FSTP2 = 0x4
	// Position of FSTP3 field.
	PMC_PMC_FSPR_FSTP3_Pos = 0x3
	// Bit mask of FSTP3 field.
	PMC_PMC_FSPR_FSTP3_Msk = 0x8
	// Bit FSTP3.
	PMC_PMC_FSPR_FSTP3 = 0x8
	// Position of FSTP4 field.
	PMC_PMC_FSPR_FSTP4_Pos = 0x4
	// Bit mask of FSTP4 field.
	PMC_PMC_FSPR_FSTP4_Msk = 0x10
	// Bit FSTP4.
	PMC_PMC_FSPR_FSTP4 = 0x10
	// Position of FSTP5 field.
	PMC_PMC_FSPR_FSTP5_Pos = 0x5
	// Bit mask of FSTP5 field.
	PMC_PMC_FSPR_FSTP5_Msk = 0x20
	// Bit FSTP5.
	PMC_PMC_FSPR_FSTP5 = 0x20
	// Position of FSTP6 field.
	PMC_PMC_FSPR_FSTP6_Pos = 0x6
	// Bit mask of FSTP6 field.
	PMC_PMC_FSPR_FSTP6_Msk = 0x40
	// Bit FSTP6.
	PMC_PMC_FSPR_FSTP6 = 0x40
	// Position of FSTP7 field.
	PMC_PMC_FSPR_FSTP7_Pos = 0x7
	// Bit mask of FSTP7 field.
	PMC_PMC_FSPR_FSTP7_Msk = 0x80
	// Bit FSTP7.
	PMC_PMC_FSPR_FSTP7 = 0x80
	// Position of FSTP8 field.
	PMC_PMC_FSPR_FSTP8_Pos = 0x8
	// Bit mask of FSTP8 field.
	PMC_PMC_FSPR_FSTP8_Msk = 0x100
	// Bit FSTP8.
	PMC_PMC_FSPR_FSTP8 = 0x100
	// Position of FSTP9 field.
	PMC_PMC_FSPR_FSTP9_Pos = 0x9
	// Bit mask of FSTP9 field.
	PMC_PMC_FSPR_FSTP9_Msk = 0x200
	// Bit FSTP9.
	PMC_PMC_FSPR_FSTP9 = 0x200
	// Position of FSTP10 field.
	PMC_PMC_FSPR_FSTP10_Pos = 0xa
	// Bit mask of FSTP10 field.
	PMC_PMC_FSPR_FSTP10_Msk = 0x400
	// Bit FSTP10.
	PMC_PMC_FSPR_FSTP10 = 0x400
	// Position of FSTP11 field.
	PMC_PMC_FSPR_FSTP11_Pos = 0xb
	// Bit mask of FSTP11 field.
	PMC_PMC_FSPR_FSTP11_Msk = 0x800
	// Bit FSTP11.
	PMC_PMC_FSPR_FSTP11 = 0x800
	// Position of FSTP12 field.
	PMC_PMC_FSPR_FSTP12_Pos = 0xc
	// Bit mask of FSTP12 field.
	PMC_PMC_FSPR_FSTP12_Msk = 0x1000
	// Bit FSTP12.
	PMC_PMC_FSPR_FSTP12 = 0x1000
	// Position of FSTP13 field.
	PMC_PMC_FSPR_FSTP13_Pos = 0xd
	// Bit mask of FSTP13 field.
	PMC_PMC_FSPR_FSTP13_Msk = 0x2000
	// Bit FSTP13.
	PMC_PMC_FSPR_FSTP13 = 0x2000
	// Position of FSTP14 field.
	PMC_PMC_FSPR_FSTP14_Pos = 0xe
	// Bit mask of FSTP14 field.
	PMC_PMC_FSPR_FSTP14_Msk = 0x4000
	// Bit FSTP14.
	PMC_PMC_FSPR_FSTP14 = 0x4000
	// Position of FSTP15 field.
	PMC_PMC_FSPR_FSTP15_Pos = 0xf
	// Bit mask of FSTP15 field.
	PMC_PMC_FSPR_FSTP15_Msk = 0x8000
	// Bit FSTP15.
	PMC_PMC_FSPR_FSTP15 = 0x8000

	// PMC_FOCR: Fault Output Clear Register
	// Position of FOCLR field.
	PMC_PMC_FOCR_FOCLR_Pos = 0x0
	// Bit mask of FOCLR field.
	PMC_PMC_FOCR_FOCLR_Msk = 0x1
	// Bit FOCLR.
	PMC_PMC_FOCR_FOCLR = 0x1

	// PMC_WPMR: Write Protect Mode Register
	// Position of WPEN field.
	PMC_PMC_WPMR_WPEN_Pos = 0x0
	// Bit mask of WPEN field.
	PMC_PMC_WPMR_WPEN_Msk = 0x1
	// Bit WPEN.
	PMC_PMC_WPMR_WPEN = 0x1
	// Position of WPKEY field.
	PMC_PMC_WPMR_WPKEY_Pos = 0x8
	// Bit mask of WPKEY field.
	PMC_PMC_WPMR_WPKEY_Msk = 0xffffff00
	// Writing any other value in this field aborts the write operation of the WPEN bit. Always reads as 0.
	PMC_PMC_WPMR_WPKEY_PASSWD = 0x504d43

	// PMC_WPSR: Write Protect Status Register
	// Position of WPVS field.
	PMC_PMC_WPSR_WPVS_Pos = 0x0
	// Bit mask of WPVS field.
	PMC_PMC_WPSR_WPVS_Msk = 0x1
	// Bit WPVS.
	PMC_PMC_WPSR_WPVS = 0x1
	// Position of WPVSRC field.
	PMC_PMC_WPSR_WPVSRC_Pos = 0x8
	// Bit mask of WPVSRC field.
	PMC_PMC_WPSR_WPVSRC_Msk = 0xffff00

	// PMC_PCER1: Peripheral Clock Enable Register 1
	// Position of PID32 field.
	PMC_PMC_PCER1_PID32_Pos = 0x0
	// Bit mask of PID32 field.
	PMC_PMC_PCER1_PID32_Msk = 0x1
	// Bit PID32.
	PMC_PMC_PCER1_PID32 = 0x1
	// Position of PID33 field.
	PMC_PMC_PCER1_PID33_Pos = 0x1
	// Bit mask of PID33 field.
	PMC_PMC_PCER1_PID33_Msk = 0x2
	// Bit PID33.
	PMC_PMC_PCER1_PID33 = 0x2
	// Position of PID34 field.
	PMC_PMC_PCER1_PID34_Pos = 0x2
	// Bit mask of PID34 field.
	PMC_PMC_PCER1_PID34_Msk = 0x4
	// Bit PID34.
	PMC_PMC_PCER1_PID34 = 0x4
	// Position of PID35 field.
	PMC_PMC_PCER1_PID35_Pos = 0x3
	// Bit mask of PID35 field.
	PMC_PMC_PCER1_PID35_Msk = 0x8
	// Bit PID35.
	PMC_PMC_PCER1_PID35 = 0x8
	// Position of PID36 field.
	PMC_PMC_PCER1_PID36_Pos = 0x4
	// Bit mask of PID36 field.
	PMC_PMC_PCER1_PID36_Msk = 0x10
	// Bit PID36.
	PMC_PMC_PCER1_PID36 = 0x10
	// Position of PID37 field.
	PMC_PMC_PCER1_PID37_Pos = 0x5
	// Bit mask of PID37 field.
	PMC_PMC_PCER1_PID37_Msk = 0x20
	// Bit PID37.
	PMC_PMC_PCER1_PID37 = 0x20
	// Position of PID38 field.
	PMC_PMC_PCER1_PID38_Pos = 0x6
	// Bit mask of PID38 field.
	PMC_PMC_PCER1_PID38_Msk = 0x40
	// Bit PID38.
	PMC_PMC_PCER1_PID38 = 0x40
	// Position of PID39 field.
	PMC_PMC_PCER1_PID39_Pos = 0x7
	// Bit mask of PID39 field.
	PMC_PMC_PCER1_PID39_Msk = 0x80
	// Bit PID39.
	PMC_PMC_PCER1_PID39 = 0x80
	// Position of PID40 field.
	PMC_PMC_PCER1_PID40_Pos = 0x8
	// Bit mask of PID40 field.
	PMC_PMC_PCER1_PID40_Msk = 0x100
	// Bit PID40.
	PMC_PMC_PCER1_PID40 = 0x100
	// Position of PID41 field.
	PMC_PMC_PCER1_PID41_Pos = 0x9
	// Bit mask of PID41 field.
	PMC_PMC_PCER1_PID41_Msk = 0x200
	// Bit PID41.
	PMC_PMC_PCER1_PID41 = 0x200
	// Position of PID42 field.
	PMC_PMC_PCER1_PID42_Pos = 0xa
	// Bit mask of PID42 field.
	PMC_PMC_PCER1_PID42_Msk = 0x400
	// Bit PID42.
	PMC_PMC_PCER1_PID42 = 0x400
	// Position of PID43 field.
	PMC_PMC_PCER1_PID43_Pos = 0xb
	// Bit mask of PID43 field.
	PMC_PMC_PCER1_PID43_Msk = 0x800
	// Bit PID43.
	PMC_PMC_PCER1_PID43 = 0x800
	// Position of PID44 field.
	PMC_PMC_PCER1_PID44_Pos = 0xc
	// Bit mask of PID44 field.
	PMC_PMC_PCER1_PID44_Msk = 0x1000
	// Bit PID44.
	PMC_PMC_PCER1_PID44 = 0x1000

	// PMC_PCDR1: Peripheral Clock Disable Register 1
	// Position of PID32 field.
	PMC_PMC_PCDR1_PID32_Pos = 0x0
	// Bit mask of PID32 field.
	PMC_PMC_PCDR1_PID32_Msk = 0x1
	// Bit PID32.
	PMC_PMC_PCDR1_PID32 = 0x1
	// Position of PID33 field.
	PMC_PMC_PCDR1_PID33_Pos = 0x1
	// Bit mask of PID33 field.
	PMC_PMC_PCDR1_PID33_Msk = 0x2
	// Bit PID33.
	PMC_PMC_PCDR1_PID33 = 0x2
	// Position of PID34 field.
	PMC_PMC_PCDR1_PID34_Pos = 0x2
	// Bit mask of PID34 field.
	PMC_PMC_PCDR1_PID34_Msk = 0x4
	// Bit PID34.
	PMC_PMC_PCDR1_PID34 = 0x4
	// Position of PID35 field.
	PMC_PMC_PCDR1_PID35_Pos = 0x3
	// Bit mask of PID35 field.
	PMC_PMC_PCDR1_PID35_Msk = 0x8
	// Bit PID35.
	PMC_PMC_PCDR1_PID35 = 0x8
	// Position of PID36 field.
	PMC_PMC_PCDR1_PID36_Pos = 0x4
	// Bit mask of PID36 field.
	PMC_PMC_PCDR1_PID36_Msk = 0x10
	// Bit PID36.
	PMC_PMC_PCDR1_PID36 = 0x10
	// Position of PID37 field.
	PMC_PMC_PCDR1_PID37_Pos = 0x5
	// Bit mask of PID37 field.
	PMC_PMC_PCDR1_PID37_Msk = 0x20
	// Bit PID37.
	PMC_PMC_PCDR1_PID37 = 0x20
	// Position of PID38 field.
	PMC_PMC_PCDR1_PID38_Pos = 0x6
	// Bit mask of PID38 field.
	PMC_PMC_PCDR1_PID38_Msk = 0x40
	// Bit PID38.
	PMC_PMC_PCDR1_PID38 = 0x40
	// Position of PID39 field.
	PMC_PMC_PCDR1_PID39_Pos = 0x7
	// Bit mask of PID39 field.
	PMC_PMC_PCDR1_PID39_Msk = 0x80
	// Bit PID39.
	PMC_PMC_PCDR1_PID39 = 0x80
	// Position of PID40 field.
	PMC_PMC_PCDR1_PID40_Pos = 0x8
	// Bit mask of PID40 field.
	PMC_PMC_PCDR1_PID40_Msk = 0x100
	// Bit PID40.
	PMC_PMC_PCDR1_PID40 = 0x100
	// Position of PID41 field.
	PMC_PMC_PCDR1_PID41_Pos = 0x9
	// Bit mask of PID41 field.
	PMC_PMC_PCDR1_PID41_Msk = 0x200
	// Bit PID41.
	PMC_PMC_PCDR1_PID41 = 0x200
	// Position of PID42 field.
	PMC_PMC_PCDR1_PID42_Pos = 0xa
	// Bit mask of PID42 field.
	PMC_PMC_PCDR1_PID42_Msk = 0x400
	// Bit PID42.
	PMC_PMC_PCDR1_PID42 = 0x400
	// Position of PID43 field.
	PMC_PMC_PCDR1_PID43_Pos = 0xb
	// Bit mask of PID43 field.
	PMC_PMC_PCDR1_PID43_Msk = 0x800
	// Bit PID43.
	PMC_PMC_PCDR1_PID43 = 0x800
	// Position of PID44 field.
	PMC_PMC_PCDR1_PID44_Pos = 0xc
	// Bit mask of PID44 field.
	PMC_PMC_PCDR1_PID44_Msk = 0x1000
	// Bit PID44.
	PMC_PMC_PCDR1_PID44 = 0x1000

	// PMC_PCSR1: Peripheral Clock Status Register 1
	// Position of PID32 field.
	PMC_PMC_PCSR1_PID32_Pos = 0x0
	// Bit mask of PID32 field.
	PMC_PMC_PCSR1_PID32_Msk = 0x1
	// Bit PID32.
	PMC_PMC_PCSR1_PID32 = 0x1
	// Position of PID33 field.
	PMC_PMC_PCSR1_PID33_Pos = 0x1
	// Bit mask of PID33 field.
	PMC_PMC_PCSR1_PID33_Msk = 0x2
	// Bit PID33.
	PMC_PMC_PCSR1_PID33 = 0x2
	// Position of PID34 field.
	PMC_PMC_PCSR1_PID34_Pos = 0x2
	// Bit mask of PID34 field.
	PMC_PMC_PCSR1_PID34_Msk = 0x4
	// Bit PID34.
	PMC_PMC_PCSR1_PID34 = 0x4
	// Position of PID35 field.
	PMC_PMC_PCSR1_PID35_Pos = 0x3
	// Bit mask of PID35 field.
	PMC_PMC_PCSR1_PID35_Msk = 0x8
	// Bit PID35.
	PMC_PMC_PCSR1_PID35 = 0x8
	// Position of PID36 field.
	PMC_PMC_PCSR1_PID36_Pos = 0x4
	// Bit mask of PID36 field.
	PMC_PMC_PCSR1_PID36_Msk = 0x10
	// Bit PID36.
	PMC_PMC_PCSR1_PID36 = 0x10
	// Position of PID37 field.
	PMC_PMC_PCSR1_PID37_Pos = 0x5
	// Bit mask of PID37 field.
	PMC_PMC_PCSR1_PID37_Msk = 0x20
	// Bit PID37.
	PMC_PMC_PCSR1_PID37 = 0x20
	// Position of PID38 field.
	PMC_PMC_PCSR1_PID38_Pos = 0x6
	// Bit mask of PID38 field.
	PMC_PMC_PCSR1_PID38_Msk = 0x40
	// Bit PID38.
	PMC_PMC_PCSR1_PID38 = 0x40
	// Position of PID39 field.
	PMC_PMC_PCSR1_PID39_Pos = 0x7
	// Bit mask of PID39 field.
	PMC_PMC_PCSR1_PID39_Msk = 0x80
	// Bit PID39.
	PMC_PMC_PCSR1_PID39 = 0x80
	// Position of PID40 field.
	PMC_PMC_PCSR1_PID40_Pos = 0x8
	// Bit mask of PID40 field.
	PMC_PMC_PCSR1_PID40_Msk = 0x100
	// Bit PID40.
	PMC_PMC_PCSR1_PID40 = 0x100
	// Position of PID41 field.
	PMC_PMC_PCSR1_PID41_Pos = 0x9
	// Bit mask of PID41 field.
	PMC_PMC_PCSR1_PID41_Msk = 0x200
	// Bit PID41.
	PMC_PMC_PCSR1_PID41 = 0x200
	// Position of PID42 field.
	PMC_PMC_PCSR1_PID42_Pos = 0xa
	// Bit mask of PID42 field.
	PMC_PMC_PCSR1_PID42_Msk = 0x400
	// Bit PID42.
	PMC_PMC_PCSR1_PID42 = 0x400
	// Position of PID43 field.
	PMC_PMC_PCSR1_PID43_Pos = 0xb
	// Bit mask of PID43 field.
	PMC_PMC_PCSR1_PID43_Msk = 0x800
	// Bit PID43.
	PMC_PMC_PCSR1_PID43 = 0x800
	// Position of PID44 field.
	PMC_PMC_PCSR1_PID44_Pos = 0xc
	// Bit mask of PID44 field.
	PMC_PMC_PCSR1_PID44_Msk = 0x1000
	// Bit PID44.
	PMC_PMC_PCSR1_PID44 = 0x1000

	// PMC_PCR: Peripheral Control Register
	// Position of PID field.
	PMC_PMC_PCR_PID_Pos = 0x0
	// Bit mask of PID field.
	PMC_PMC_PCR_PID_Msk = 0x3f
	// Position of CMD field.
	PMC_PMC_PCR_CMD_Pos = 0xc
	// Bit mask of CMD field.
	PMC_PMC_PCR_CMD_Msk = 0x1000
	// Bit CMD.
	PMC_PMC_PCR_CMD = 0x1000
	// Position of DIV field.
	PMC_PMC_PCR_DIV_Pos = 0x10
	// Bit mask of DIV field.
	PMC_PMC_PCR_DIV_Msk = 0x30000
	// Peripheral clock is MCK
	PMC_PMC_PCR_DIV_PERIPH_DIV_MCK = 0x0
	// Peripheral clock is MCK/2
	PMC_PMC_PCR_DIV_PERIPH_DIV2_MCK = 0x1
	// Peripheral clock is MCK/4
	PMC_PMC_PCR_DIV_PERIPH_DIV4_MCK = 0x2
	// Position of EN field.
	PMC_PMC_PCR_EN_Pos = 0x1c
	// Bit mask of EN field.
	PMC_PMC_PCR_EN_Msk = 0x10000000
	// Bit EN.
	PMC_PMC_PCR_EN = 0x10000000
)

// Bitfields for UART: Universal Asynchronous Receiver Transmitter
const (
	// CR: Control Register
	// Position of RSTRX field.
	UART_CR_RSTRX_Pos = 0x2
	// Bit mask of RSTRX field.
	UART_CR_RSTRX_Msk = 0x4
	// Bit RSTRX.
	UART_CR_RSTRX = 0x4
	// Position of RSTTX field.
	UART_CR_RSTTX_Pos = 0x3
	// Bit mask of RSTTX field.
	UART_CR_RSTTX_Msk = 0x8
	// Bit RSTTX.
	UART_CR_RSTTX = 0x8
	// Position of RXEN field.
	UART_CR_RXEN_Pos = 0x4
	// Bit mask of RXEN field.
	UART_CR_RXEN_Msk = 0x10
	// Bit RXEN.
	UART_CR_RXEN = 0x10
	// Position of RXDIS field.
	UART_CR_RXDIS_Pos = 0x5
	// Bit mask of RXDIS field.
	UART_CR_RXDIS_Msk = 0x20
	// Bit RXDIS.
	UART_CR_RXDIS = 0x20
	// Position of TXEN field.
	UART_CR_TXEN_Pos = 0x6
	// Bit mask of TXEN field.
	UART_CR_TXEN_Msk = 0x40
	// Bit TXEN.
	UART_CR_TXEN = 0x40
	// Position of TXDIS field.
	UART_CR_TXDIS_Pos = 0x7
	// Bit mask of TXDIS field.
	UART_CR_TXDIS_Msk = 0x80
	// Bit TXDIS.
	UART_CR_TXDIS = 0x80
	// Position of RSTSTA field.
	UART_CR_RSTSTA_Pos = 0x8
	// Bit mask of RSTSTA field.
	UART_CR_RSTSTA_Msk = 0x100
	// Bit RSTSTA.
	UART_CR_RSTSTA = 0x100

	// MR: Mode Register
	// Position of PAR field.
	UART_MR_PAR_Pos = 0x9
	// Bit mask of PAR field.
	UART_MR_PAR_Msk = 0xe00
	// Even Parity
	UART_MR_PAR_EVEN = 0x0
	// Odd Parity
	UART_MR_PAR_ODD = 0x1
	// Space: parity forced to 0
	UART_MR_PAR_SPACE = 0x2
	// Mark: parity forced to 1
	UART_MR_PAR_MARK = 0x3
	// No Parity
	UART_MR_PAR_NO = 0x4
	// Position of CHMODE field.
	UART_MR_CHMODE_Pos = 0xe
	// Bit mask of CHMODE field.
	UART_MR_CHMODE_Msk = 0xc000
	// Normal Mode
	UART_MR_CHMODE_NORMAL = 0x0
	// Automatic Echo
	UART_MR_CHMODE_AUTOMATIC = 0x1
	// Local Loopback
	UART_MR_CHMODE_LOCAL_LOOPBACK = 0x2
	// Remote Loopback
	UART_MR_CHMODE_REMOTE_LOOPBACK = 0x3

	// IER: Interrupt Enable Register
	// Position of RXRDY field.
	UART_IER_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	UART_IER_RXRDY_Msk = 0x1
	// Bit RXRDY.
	UART_IER_RXRDY = 0x1
	// Position of TXRDY field.
	UART_IER_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	UART_IER_TXRDY_Msk = 0x2
	// Bit TXRDY.
	UART_IER_TXRDY = 0x2
	// Position of ENDRX field.
	UART_IER_ENDRX_Pos = 0x3
	// Bit mask of ENDRX field.
	UART_IER_ENDRX_Msk = 0x8
	// Bit ENDRX.
	UART_IER_ENDRX = 0x8
	// Position of ENDTX field.
	UART_IER_ENDTX_Pos = 0x4
	// Bit mask of ENDTX field.
	UART_IER_ENDTX_Msk = 0x10
	// Bit ENDTX.
	UART_IER_ENDTX = 0x10
	// Position of OVRE field.
	UART_IER_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	UART_IER_OVRE_Msk = 0x20
	// Bit OVRE.
	UART_IER_OVRE = 0x20
	// Position of FRAME field.
	UART_IER_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	UART_IER_FRAME_Msk = 0x40
	// Bit FRAME.
	UART_IER_FRAME = 0x40
	// Position of PARE field.
	UART_IER_PARE_Pos = 0x7
	// Bit mask of PARE field.
	UART_IER_PARE_Msk = 0x80
	// Bit PARE.
	UART_IER_PARE = 0x80
	// Position of TXEMPTY field.
	UART_IER_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	UART_IER_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	UART_IER_TXEMPTY = 0x200
	// Position of TXBUFE field.
	UART_IER_TXBUFE_Pos = 0xb
	// Bit mask of TXBUFE field.
	UART_IER_TXBUFE_Msk = 0x800
	// Bit TXBUFE.
	UART_IER_TXBUFE = 0x800
	// Position of RXBUFF field.
	UART_IER_RXBUFF_Pos = 0xc
	// Bit mask of RXBUFF field.
	UART_IER_RXBUFF_Msk = 0x1000
	// Bit RXBUFF.
	UART_IER_RXBUFF = 0x1000

	// IDR: Interrupt Disable Register
	// Position of RXRDY field.
	UART_IDR_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	UART_IDR_RXRDY_Msk = 0x1
	// Bit RXRDY.
	UART_IDR_RXRDY = 0x1
	// Position of TXRDY field.
	UART_IDR_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	UART_IDR_TXRDY_Msk = 0x2
	// Bit TXRDY.
	UART_IDR_TXRDY = 0x2
	// Position of ENDRX field.
	UART_IDR_ENDRX_Pos = 0x3
	// Bit mask of ENDRX field.
	UART_IDR_ENDRX_Msk = 0x8
	// Bit ENDRX.
	UART_IDR_ENDRX = 0x8
	// Position of ENDTX field.
	UART_IDR_ENDTX_Pos = 0x4
	// Bit mask of ENDTX field.
	UART_IDR_ENDTX_Msk = 0x10
	// Bit ENDTX.
	UART_IDR_ENDTX = 0x10
	// Position of OVRE field.
	UART_IDR_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	UART_IDR_OVRE_Msk = 0x20
	// Bit OVRE.
	UART_IDR_OVRE = 0x20
	// Position of FRAME field.
	UART_IDR_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	UART_IDR_FRAME_Msk = 0x40
	// Bit FRAME.
	UART_IDR_FRAME = 0x40
	// Position of PARE field.
	UART_IDR_PARE_Pos = 0x7
	// Bit mask of PARE field.
	UART_IDR_PARE_Msk = 0x80
	// Bit PARE.
	UART_IDR_PARE = 0x80
	// Position of TXEMPTY field.
	UART_IDR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	UART_IDR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	UART_IDR_TXEMPTY = 0x200
	// Position of TXBUFE field.
	UART_IDR_TXBUFE_Pos = 0xb
	// Bit mask of TXBUFE field.
	UART_IDR_TXBUFE_Msk = 0x800
	// Bit TXBUFE.
	UART_IDR_TXBUFE = 0x800
	// Position of RXBUFF field.
	UART_IDR_RXBUFF_Pos = 0xc
	// Bit mask of RXBUFF field.
	UART_IDR_RXBUFF_Msk = 0x1000
	// Bit RXBUFF.
	UART_IDR_RXBUFF = 0x1000

	// IMR: Interrupt Mask Register
	// Position of RXRDY field.
	UART_IMR_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	UART_IMR_RXRDY_Msk = 0x1
	// Bit RXRDY.
	UART_IMR_RXRDY = 0x1
	// Position of TXRDY field.
	UART_IMR_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	UART_IMR_TXRDY_Msk = 0x2
	// Bit TXRDY.
	UART_IMR_TXRDY = 0x2
	// Position of ENDRX field.
	UART_IMR_ENDRX_Pos = 0x3
	// Bit mask of ENDRX field.
	UART_IMR_ENDRX_Msk = 0x8
	// Bit ENDRX.
	UART_IMR_ENDRX = 0x8
	// Position of ENDTX field.
	UART_IMR_ENDTX_Pos = 0x4
	// Bit mask of ENDTX field.
	UART_IMR_ENDTX_Msk = 0x10
	// Bit ENDTX.
	UART_IMR_ENDTX = 0x10
	// Position of OVRE field.
	UART_IMR_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	UART_IMR_OVRE_Msk = 0x20
	// Bit OVRE.
	UART_IMR_OVRE = 0x20
	// Position of FRAME field.
	UART_IMR_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	UART_IMR_FRAME_Msk = 0x40
	// Bit FRAME.
	UART_IMR_FRAME = 0x40
	// Position of PARE field.
	UART_IMR_PARE_Pos = 0x7
	// Bit mask of PARE field.
	UART_IMR_PARE_Msk = 0x80
	// Bit PARE.
	UART_IMR_PARE = 0x80
	// Position of TXEMPTY field.
	UART_IMR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	UART_IMR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	UART_IMR_TXEMPTY = 0x200
	// Position of TXBUFE field.
	UART_IMR_TXBUFE_Pos = 0xb
	// Bit mask of TXBUFE field.
	UART_IMR_TXBUFE_Msk = 0x800
	// Bit TXBUFE.
	UART_IMR_TXBUFE = 0x800
	// Position of RXBUFF field.
	UART_IMR_RXBUFF_Pos = 0xc
	// Bit mask of RXBUFF field.
	UART_IMR_RXBUFF_Msk = 0x1000
	// Bit RXBUFF.
	UART_IMR_RXBUFF = 0x1000

	// SR: Status Register
	// Position of RXRDY field.
	UART_SR_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	UART_SR_RXRDY_Msk = 0x1
	// Bit RXRDY.
	UART_SR_RXRDY = 0x1
	// Position of TXRDY field.
	UART_SR_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	UART_SR_TXRDY_Msk = 0x2
	// Bit TXRDY.
	UART_SR_TXRDY = 0x2
	// Position of ENDRX field.
	UART_SR_ENDRX_Pos = 0x3
	// Bit mask of ENDRX field.
	UART_SR_ENDRX_Msk = 0x8
	// Bit ENDRX.
	UART_SR_ENDRX = 0x8
	// Position of ENDTX field.
	UART_SR_ENDTX_Pos = 0x4
	// Bit mask of ENDTX field.
	UART_SR_ENDTX_Msk = 0x10
	// Bit ENDTX.
	UART_SR_ENDTX = 0x10
	// Position of OVRE field.
	UART_SR_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	UART_SR_OVRE_Msk = 0x20
	// Bit OVRE.
	UART_SR_OVRE = 0x20
	// Position of FRAME field.
	UART_SR_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	UART_SR_FRAME_Msk = 0x40
	// Bit FRAME.
	UART_SR_FRAME = 0x40
	// Position of PARE field.
	UART_SR_PARE_Pos = 0x7
	// Bit mask of PARE field.
	UART_SR_PARE_Msk = 0x80
	// Bit PARE.
	UART_SR_PARE = 0x80
	// Position of TXEMPTY field.
	UART_SR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	UART_SR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	UART_SR_TXEMPTY = 0x200
	// Position of TXBUFE field.
	UART_SR_TXBUFE_Pos = 0xb
	// Bit mask of TXBUFE field.
	UART_SR_TXBUFE_Msk = 0x800
	// Bit TXBUFE.
	UART_SR_TXBUFE = 0x800
	// Position of RXBUFF field.
	UART_SR_RXBUFF_Pos = 0xc
	// Bit mask of RXBUFF field.
	UART_SR_RXBUFF_Msk = 0x1000
	// Bit RXBUFF.
	UART_SR_RXBUFF = 0x1000

	// RHR: Receive Holding Register
	// Position of RXCHR field.
	UART_RHR_RXCHR_Pos = 0x0
	// Bit mask of RXCHR field.
	UART_RHR_RXCHR_Msk = 0xff

	// THR: Transmit Holding Register
	// Position of TXCHR field.
	UART_THR_TXCHR_Pos = 0x0
	// Bit mask of TXCHR field.
	UART_THR_TXCHR_Msk = 0xff

	// BRGR: Baud Rate Generator Register
	// Position of CD field.
	UART_BRGR_CD_Pos = 0x0
	// Bit mask of CD field.
	UART_BRGR_CD_Msk = 0xffff

	// RPR: Receive Pointer Register
	// Position of RXPTR field.
	UART_RPR_RXPTR_Pos = 0x0
	// Bit mask of RXPTR field.
	UART_RPR_RXPTR_Msk = 0xffffffff

	// RCR: Receive Counter Register
	// Position of RXCTR field.
	UART_RCR_RXCTR_Pos = 0x0
	// Bit mask of RXCTR field.
	UART_RCR_RXCTR_Msk = 0xffff

	// TPR: Transmit Pointer Register
	// Position of TXPTR field.
	UART_TPR_TXPTR_Pos = 0x0
	// Bit mask of TXPTR field.
	UART_TPR_TXPTR_Msk = 0xffffffff

	// TCR: Transmit Counter Register
	// Position of TXCTR field.
	UART_TCR_TXCTR_Pos = 0x0
	// Bit mask of TXCTR field.
	UART_TCR_TXCTR_Msk = 0xffff

	// RNPR: Receive Next Pointer Register
	// Position of RXNPTR field.
	UART_RNPR_RXNPTR_Pos = 0x0
	// Bit mask of RXNPTR field.
	UART_RNPR_RXNPTR_Msk = 0xffffffff

	// RNCR: Receive Next Counter Register
	// Position of RXNCTR field.
	UART_RNCR_RXNCTR_Pos = 0x0
	// Bit mask of RXNCTR field.
	UART_RNCR_RXNCTR_Msk = 0xffff

	// TNPR: Transmit Next Pointer Register
	// Position of TXNPTR field.
	UART_TNPR_TXNPTR_Pos = 0x0
	// Bit mask of TXNPTR field.
	UART_TNPR_TXNPTR_Msk = 0xffffffff

	// TNCR: Transmit Next Counter Register
	// Position of TXNCTR field.
	UART_TNCR_TXNCTR_Pos = 0x0
	// Bit mask of TXNCTR field.
	UART_TNCR_TXNCTR_Msk = 0xffff

	// PTCR: Transfer Control Register
	// Position of RXTEN field.
	UART_PTCR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	UART_PTCR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	UART_PTCR_RXTEN = 0x1
	// Position of RXTDIS field.
	UART_PTCR_RXTDIS_Pos = 0x1
	// Bit mask of RXTDIS field.
	UART_PTCR_RXTDIS_Msk = 0x2
	// Bit RXTDIS.
	UART_PTCR_RXTDIS = 0x2
	// Position of TXTEN field.
	UART_PTCR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	UART_PTCR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	UART_PTCR_TXTEN = 0x100
	// Position of TXTDIS field.
	UART_PTCR_TXTDIS_Pos = 0x9
	// Bit mask of TXTDIS field.
	UART_PTCR_TXTDIS_Msk = 0x200
	// Bit TXTDIS.
	UART_PTCR_TXTDIS = 0x200

	// PTSR: Transfer Status Register
	// Position of RXTEN field.
	UART_PTSR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	UART_PTSR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	UART_PTSR_RXTEN = 0x1
	// Position of TXTEN field.
	UART_PTSR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	UART_PTSR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	UART_PTSR_TXTEN = 0x100
)

// Bitfields for CHIPID: Chip Identifier
const (
	// CIDR: Chip ID Register
	// Position of VERSION field.
	CHIPID_CIDR_VERSION_Pos = 0x0
	// Bit mask of VERSION field.
	CHIPID_CIDR_VERSION_Msk = 0x1f
	// Position of EPROC field.
	CHIPID_CIDR_EPROC_Pos = 0x5
	// Bit mask of EPROC field.
	CHIPID_CIDR_EPROC_Msk = 0xe0
	// ARM946ES
	CHIPID_CIDR_EPROC_ARM946ES = 0x1
	// ARM7TDMI
	CHIPID_CIDR_EPROC_ARM7TDMI = 0x2
	// Cortex-M3
	CHIPID_CIDR_EPROC_CM3 = 0x3
	// ARM920T
	CHIPID_CIDR_EPROC_ARM920T = 0x4
	// ARM926EJS
	CHIPID_CIDR_EPROC_ARM926EJS = 0x5
	// Cortex-A5
	CHIPID_CIDR_EPROC_CA5 = 0x6
	// Cortex-M4
	CHIPID_CIDR_EPROC_CM4 = 0x7
	// Position of NVPSIZ field.
	CHIPID_CIDR_NVPSIZ_Pos = 0x8
	// Bit mask of NVPSIZ field.
	CHIPID_CIDR_NVPSIZ_Msk = 0xf00
	// None
	CHIPID_CIDR_NVPSIZ_NONE = 0x0
	// 8 Kbytes
	CHIPID_CIDR_NVPSIZ_8K = 0x1
	// 16 Kbytes
	CHIPID_CIDR_NVPSIZ_16K = 0x2
	// 32 Kbytes
	CHIPID_CIDR_NVPSIZ_32K = 0x3
	// 64 Kbytes
	CHIPID_CIDR_NVPSIZ_64K = 0x5
	// 128 Kbytes
	CHIPID_CIDR_NVPSIZ_128K = 0x7
	// 256 Kbytes
	CHIPID_CIDR_NVPSIZ_256K = 0x9
	// 512 Kbytes
	CHIPID_CIDR_NVPSIZ_512K = 0xa
	// 1024 Kbytes
	CHIPID_CIDR_NVPSIZ_1024K = 0xc
	// 2048 Kbytes
	CHIPID_CIDR_NVPSIZ_2048K = 0xe
	// Position of NVPSIZ2 field.
	CHIPID_CIDR_NVPSIZ2_Pos = 0xc
	// Bit mask of NVPSIZ2 field.
	CHIPID_CIDR_NVPSIZ2_Msk = 0xf000
	// None
	CHIPID_CIDR_NVPSIZ2_NONE = 0x0
	// 8 Kbytes
	CHIPID_CIDR_NVPSIZ2_8K = 0x1
	// 16 Kbytes
	CHIPID_CIDR_NVPSIZ2_16K = 0x2
	// 32 Kbytes
	CHIPID_CIDR_NVPSIZ2_32K = 0x3
	// 64 Kbytes
	CHIPID_CIDR_NVPSIZ2_64K = 0x5
	// 128 Kbytes
	CHIPID_CIDR_NVPSIZ2_128K = 0x7
	// 256 Kbytes
	CHIPID_CIDR_NVPSIZ2_256K = 0x9
	// 512 Kbytes
	CHIPID_CIDR_NVPSIZ2_512K = 0xa
	// 1024 Kbytes
	CHIPID_CIDR_NVPSIZ2_1024K = 0xc
	// 2048 Kbytes
	CHIPID_CIDR_NVPSIZ2_2048K = 0xe
	// Position of SRAMSIZ field.
	CHIPID_CIDR_SRAMSIZ_Pos = 0x10
	// Bit mask of SRAMSIZ field.
	CHIPID_CIDR_SRAMSIZ_Msk = 0xf0000
	// 48 Kbytes
	CHIPID_CIDR_SRAMSIZ_48K = 0x0
	// 192 Kbytes
	CHIPID_CIDR_SRAMSIZ_192K = 0x1
	// 2 Kbytes
	CHIPID_CIDR_SRAMSIZ_2K = 0x2
	// 6 Kbytes
	CHIPID_CIDR_SRAMSIZ_6K = 0x3
	// 24 Kbytes
	CHIPID_CIDR_SRAMSIZ_24K = 0x4
	// 4 Kbytes
	CHIPID_CIDR_SRAMSIZ_4K = 0x5
	// 80 Kbytes
	CHIPID_CIDR_SRAMSIZ_80K = 0x6
	// 160 Kbytes
	CHIPID_CIDR_SRAMSIZ_160K = 0x7
	// 8 Kbytes
	CHIPID_CIDR_SRAMSIZ_8K = 0x8
	// 16 Kbytes
	CHIPID_CIDR_SRAMSIZ_16K = 0x9
	// 32 Kbytes
	CHIPID_CIDR_SRAMSIZ_32K = 0xa
	// 64 Kbytes
	CHIPID_CIDR_SRAMSIZ_64K = 0xb
	// 128 Kbytes
	CHIPID_CIDR_SRAMSIZ_128K = 0xc
	// 256 Kbytes
	CHIPID_CIDR_SRAMSIZ_256K = 0xd
	// 96 Kbytes
	CHIPID_CIDR_SRAMSIZ_96K = 0xe
	// 512 Kbytes
	CHIPID_CIDR_SRAMSIZ_512K = 0xf
	// Position of ARCH field.
	CHIPID_CIDR_ARCH_Pos = 0x14
	// Bit mask of ARCH field.
	CHIPID_CIDR_ARCH_Msk = 0xff00000
	// SAM3AxC (100-pin version)
	CHIPID_CIDR_ARCH_SAM3AxC = 0x83
	// SAM3XxC (100-pin version)
	CHIPID_CIDR_ARCH_SAM3XxC = 0x84
	// SAM3XxE (144-pin version)
	CHIPID_CIDR_ARCH_SAM3XxE = 0x85
	// SAM3XxG (208/217-pin version)
	CHIPID_CIDR_ARCH_SAM3XxG = 0x86
	// Position of NVPTYP field.
	CHIPID_CIDR_NVPTYP_Pos = 0x1c
	// Bit mask of NVPTYP field.
	CHIPID_CIDR_NVPTYP_Msk = 0x70000000
	// ROM
	CHIPID_CIDR_NVPTYP_ROM = 0x0
	// ROMless or on-chip Flash
	CHIPID_CIDR_NVPTYP_ROMLESS = 0x1
	// Embedded Flash Memory
	CHIPID_CIDR_NVPTYP_FLASH = 0x2
	// ROM and Embedded Flash Memory- NVPSIZ is ROM size- NVPSIZ2 is Flash size
	CHIPID_CIDR_NVPTYP_ROM_FLASH = 0x3
	// SRAM emulating ROM
	CHIPID_CIDR_NVPTYP_SRAM = 0x4
	// Position of EXT field.
	CHIPID_CIDR_EXT_Pos = 0x1f
	// Bit mask of EXT field.
	CHIPID_CIDR_EXT_Msk = 0x80000000
	// Bit EXT.
	CHIPID_CIDR_EXT = 0x80000000

	// EXID: Chip ID Extension Register
	// Position of EXID field.
	CHIPID_EXID_EXID_Pos = 0x0
	// Bit mask of EXID field.
	CHIPID_EXID_EXID_Msk = 0xffffffff
)

// Bitfields for EFC0: Embedded Flash Controller 0
const (
	// FMR: EEFC Flash Mode Register
	// Position of FRDY field.
	EFC_FMR_FRDY_Pos = 0x0
	// Bit mask of FRDY field.
	EFC_FMR_FRDY_Msk = 0x1
	// Bit FRDY.
	EFC_FMR_FRDY = 0x1
	// Position of FWS field.
	EFC_FMR_FWS_Pos = 0x8
	// Bit mask of FWS field.
	EFC_FMR_FWS_Msk = 0xf00
	// Position of SCOD field.
	EFC_FMR_SCOD_Pos = 0x10
	// Bit mask of SCOD field.
	EFC_FMR_SCOD_Msk = 0x10000
	// Bit SCOD.
	EFC_FMR_SCOD = 0x10000
	// Position of FAM field.
	EFC_FMR_FAM_Pos = 0x18
	// Bit mask of FAM field.
	EFC_FMR_FAM_Msk = 0x1000000
	// Bit FAM.
	EFC_FMR_FAM = 0x1000000

	// FCR: EEFC Flash Command Register
	// Position of FCMD field.
	EFC_FCR_FCMD_Pos = 0x0
	// Bit mask of FCMD field.
	EFC_FCR_FCMD_Msk = 0xff
	// Get Flash Descriptor
	EFC_FCR_FCMD_GETD = 0x0
	// Write page
	EFC_FCR_FCMD_WP = 0x1
	// Write page and lock
	EFC_FCR_FCMD_WPL = 0x2
	// Erase page and write page
	EFC_FCR_FCMD_EWP = 0x3
	// Erase page and write page then lock
	EFC_FCR_FCMD_EWPL = 0x4
	// Erase all
	EFC_FCR_FCMD_EA = 0x5
	// Set Lock Bit
	EFC_FCR_FCMD_SLB = 0x8
	// Clear Lock Bit
	EFC_FCR_FCMD_CLB = 0x9
	// Get Lock Bit
	EFC_FCR_FCMD_GLB = 0xa
	// Set GPNVM Bit
	EFC_FCR_FCMD_SGPB = 0xb
	// Clear GPNVM Bit
	EFC_FCR_FCMD_CGPB = 0xc
	// Get GPNVM Bit
	EFC_FCR_FCMD_GGPB = 0xd
	// Start Read Unique Identifier
	EFC_FCR_FCMD_STUI = 0xe
	// Stop Read Unique Identifier
	EFC_FCR_FCMD_SPUI = 0xf
	// Get CALIB Bit
	EFC_FCR_FCMD_GCALB = 0x10
	// Position of FARG field.
	EFC_FCR_FARG_Pos = 0x8
	// Bit mask of FARG field.
	EFC_FCR_FARG_Msk = 0xffff00
	// Position of FKEY field.
	EFC_FCR_FKEY_Pos = 0x18
	// Bit mask of FKEY field.
	EFC_FCR_FKEY_Msk = 0xff000000
	// The 0x5A value enables the command defined by the bits of the register. If the field is written with a different value, the write is not performed and no action is started.
	EFC_FCR_FKEY_PASSWD = 0x5a

	// FSR: EEFC Flash Status Register
	// Position of FRDY field.
	EFC_FSR_FRDY_Pos = 0x0
	// Bit mask of FRDY field.
	EFC_FSR_FRDY_Msk = 0x1
	// Bit FRDY.
	EFC_FSR_FRDY = 0x1
	// Position of FCMDE field.
	EFC_FSR_FCMDE_Pos = 0x1
	// Bit mask of FCMDE field.
	EFC_FSR_FCMDE_Msk = 0x2
	// Bit FCMDE.
	EFC_FSR_FCMDE = 0x2
	// Position of FLOCKE field.
	EFC_FSR_FLOCKE_Pos = 0x2
	// Bit mask of FLOCKE field.
	EFC_FSR_FLOCKE_Msk = 0x4
	// Bit FLOCKE.
	EFC_FSR_FLOCKE = 0x4

	// FRR: EEFC Flash Result Register
	// Position of FVALUE field.
	EFC_FRR_FVALUE_Pos = 0x0
	// Bit mask of FVALUE field.
	EFC_FRR_FVALUE_Msk = 0xffffffff
)

// Bitfields for PIOA: Parallel Input/Output Controller A
const (
	// PER: PIO Enable Register
	// Position of P0 field.
	PIO_PER_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_PER_P0_Msk = 0x1
	// Bit P0.
	PIO_PER_P0 = 0x1
	// Position of P1 field.
	PIO_PER_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_PER_P1_Msk = 0x2
	// Bit P1.
	PIO_PER_P1 = 0x2
	// Position of P2 field.
	PIO_PER_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_PER_P2_Msk = 0x4
	// Bit P2.
	PIO_PER_P2 = 0x4
	// Position of P3 field.
	PIO_PER_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_PER_P3_Msk = 0x8
	// Bit P3.
	PIO_PER_P3 = 0x8
	// Position of P4 field.
	PIO_PER_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_PER_P4_Msk = 0x10
	// Bit P4.
	PIO_PER_P4 = 0x10
	// Position of P5 field.
	PIO_PER_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_PER_P5_Msk = 0x20
	// Bit P5.
	PIO_PER_P5 = 0x20
	// Position of P6 field.
	PIO_PER_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_PER_P6_Msk = 0x40
	// Bit P6.
	PIO_PER_P6 = 0x40
	// Position of P7 field.
	PIO_PER_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_PER_P7_Msk = 0x80
	// Bit P7.
	PIO_PER_P7 = 0x80
	// Position of P8 field.
	PIO_PER_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_PER_P8_Msk = 0x100
	// Bit P8.
	PIO_PER_P8 = 0x100
	// Position of P9 field.
	PIO_PER_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_PER_P9_Msk = 0x200
	// Bit P9.
	PIO_PER_P9 = 0x200
	// Position of P10 field.
	PIO_PER_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_PER_P10_Msk = 0x400
	// Bit P10.
	PIO_PER_P10 = 0x400
	// Position of P11 field.
	PIO_PER_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_PER_P11_Msk = 0x800
	// Bit P11.
	PIO_PER_P11 = 0x800
	// Position of P12 field.
	PIO_PER_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_PER_P12_Msk = 0x1000
	// Bit P12.
	PIO_PER_P12 = 0x1000
	// Position of P13 field.
	PIO_PER_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_PER_P13_Msk = 0x2000
	// Bit P13.
	PIO_PER_P13 = 0x2000
	// Position of P14 field.
	PIO_PER_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_PER_P14_Msk = 0x4000
	// Bit P14.
	PIO_PER_P14 = 0x4000
	// Position of P15 field.
	PIO_PER_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_PER_P15_Msk = 0x8000
	// Bit P15.
	PIO_PER_P15 = 0x8000
	// Position of P16 field.
	PIO_PER_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_PER_P16_Msk = 0x10000
	// Bit P16.
	PIO_PER_P16 = 0x10000
	// Position of P17 field.
	PIO_PER_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_PER_P17_Msk = 0x20000
	// Bit P17.
	PIO_PER_P17 = 0x20000
	// Position of P18 field.
	PIO_PER_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_PER_P18_Msk = 0x40000
	// Bit P18.
	PIO_PER_P18 = 0x40000
	// Position of P19 field.
	PIO_PER_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_PER_P19_Msk = 0x80000
	// Bit P19.
	PIO_PER_P19 = 0x80000
	// Position of P20 field.
	PIO_PER_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_PER_P20_Msk = 0x100000
	// Bit P20.
	PIO_PER_P20 = 0x100000
	// Position of P21 field.
	PIO_PER_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_PER_P21_Msk = 0x200000
	// Bit P21.
	PIO_PER_P21 = 0x200000
	// Position of P22 field.
	PIO_PER_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_PER_P22_Msk = 0x400000
	// Bit P22.
	PIO_PER_P22 = 0x400000
	// Position of P23 field.
	PIO_PER_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_PER_P23_Msk = 0x800000
	// Bit P23.
	PIO_PER_P23 = 0x800000
	// Position of P24 field.
	PIO_PER_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_PER_P24_Msk = 0x1000000
	// Bit P24.
	PIO_PER_P24 = 0x1000000
	// Position of P25 field.
	PIO_PER_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_PER_P25_Msk = 0x2000000
	// Bit P25.
	PIO_PER_P25 = 0x2000000
	// Position of P26 field.
	PIO_PER_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_PER_P26_Msk = 0x4000000
	// Bit P26.
	PIO_PER_P26 = 0x4000000
	// Position of P27 field.
	PIO_PER_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_PER_P27_Msk = 0x8000000
	// Bit P27.
	PIO_PER_P27 = 0x8000000
	// Position of P28 field.
	PIO_PER_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_PER_P28_Msk = 0x10000000
	// Bit P28.
	PIO_PER_P28 = 0x10000000
	// Position of P29 field.
	PIO_PER_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_PER_P29_Msk = 0x20000000
	// Bit P29.
	PIO_PER_P29 = 0x20000000
	// Position of P30 field.
	PIO_PER_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_PER_P30_Msk = 0x40000000
	// Bit P30.
	PIO_PER_P30 = 0x40000000
	// Position of P31 field.
	PIO_PER_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_PER_P31_Msk = 0x80000000
	// Bit P31.
	PIO_PER_P31 = 0x80000000

	// PDR: PIO Disable Register
	// Position of P0 field.
	PIO_PDR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_PDR_P0_Msk = 0x1
	// Bit P0.
	PIO_PDR_P0 = 0x1
	// Position of P1 field.
	PIO_PDR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_PDR_P1_Msk = 0x2
	// Bit P1.
	PIO_PDR_P1 = 0x2
	// Position of P2 field.
	PIO_PDR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_PDR_P2_Msk = 0x4
	// Bit P2.
	PIO_PDR_P2 = 0x4
	// Position of P3 field.
	PIO_PDR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_PDR_P3_Msk = 0x8
	// Bit P3.
	PIO_PDR_P3 = 0x8
	// Position of P4 field.
	PIO_PDR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_PDR_P4_Msk = 0x10
	// Bit P4.
	PIO_PDR_P4 = 0x10
	// Position of P5 field.
	PIO_PDR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_PDR_P5_Msk = 0x20
	// Bit P5.
	PIO_PDR_P5 = 0x20
	// Position of P6 field.
	PIO_PDR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_PDR_P6_Msk = 0x40
	// Bit P6.
	PIO_PDR_P6 = 0x40
	// Position of P7 field.
	PIO_PDR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_PDR_P7_Msk = 0x80
	// Bit P7.
	PIO_PDR_P7 = 0x80
	// Position of P8 field.
	PIO_PDR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_PDR_P8_Msk = 0x100
	// Bit P8.
	PIO_PDR_P8 = 0x100
	// Position of P9 field.
	PIO_PDR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_PDR_P9_Msk = 0x200
	// Bit P9.
	PIO_PDR_P9 = 0x200
	// Position of P10 field.
	PIO_PDR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_PDR_P10_Msk = 0x400
	// Bit P10.
	PIO_PDR_P10 = 0x400
	// Position of P11 field.
	PIO_PDR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_PDR_P11_Msk = 0x800
	// Bit P11.
	PIO_PDR_P11 = 0x800
	// Position of P12 field.
	PIO_PDR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_PDR_P12_Msk = 0x1000
	// Bit P12.
	PIO_PDR_P12 = 0x1000
	// Position of P13 field.
	PIO_PDR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_PDR_P13_Msk = 0x2000
	// Bit P13.
	PIO_PDR_P13 = 0x2000
	// Position of P14 field.
	PIO_PDR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_PDR_P14_Msk = 0x4000
	// Bit P14.
	PIO_PDR_P14 = 0x4000
	// Position of P15 field.
	PIO_PDR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_PDR_P15_Msk = 0x8000
	// Bit P15.
	PIO_PDR_P15 = 0x8000
	// Position of P16 field.
	PIO_PDR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_PDR_P16_Msk = 0x10000
	// Bit P16.
	PIO_PDR_P16 = 0x10000
	// Position of P17 field.
	PIO_PDR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_PDR_P17_Msk = 0x20000
	// Bit P17.
	PIO_PDR_P17 = 0x20000
	// Position of P18 field.
	PIO_PDR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_PDR_P18_Msk = 0x40000
	// Bit P18.
	PIO_PDR_P18 = 0x40000
	// Position of P19 field.
	PIO_PDR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_PDR_P19_Msk = 0x80000
	// Bit P19.
	PIO_PDR_P19 = 0x80000
	// Position of P20 field.
	PIO_PDR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_PDR_P20_Msk = 0x100000
	// Bit P20.
	PIO_PDR_P20 = 0x100000
	// Position of P21 field.
	PIO_PDR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_PDR_P21_Msk = 0x200000
	// Bit P21.
	PIO_PDR_P21 = 0x200000
	// Position of P22 field.
	PIO_PDR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_PDR_P22_Msk = 0x400000
	// Bit P22.
	PIO_PDR_P22 = 0x400000
	// Position of P23 field.
	PIO_PDR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_PDR_P23_Msk = 0x800000
	// Bit P23.
	PIO_PDR_P23 = 0x800000
	// Position of P24 field.
	PIO_PDR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_PDR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_PDR_P24 = 0x1000000
	// Position of P25 field.
	PIO_PDR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_PDR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_PDR_P25 = 0x2000000
	// Position of P26 field.
	PIO_PDR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_PDR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_PDR_P26 = 0x4000000
	// Position of P27 field.
	PIO_PDR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_PDR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_PDR_P27 = 0x8000000
	// Position of P28 field.
	PIO_PDR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_PDR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_PDR_P28 = 0x10000000
	// Position of P29 field.
	PIO_PDR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_PDR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_PDR_P29 = 0x20000000
	// Position of P30 field.
	PIO_PDR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_PDR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_PDR_P30 = 0x40000000
	// Position of P31 field.
	PIO_PDR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_PDR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_PDR_P31 = 0x80000000

	// PSR: PIO Status Register
	// Position of P0 field.
	PIO_PSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_PSR_P0_Msk = 0x1
	// Bit P0.
	PIO_PSR_P0 = 0x1
	// Position of P1 field.
	PIO_PSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_PSR_P1_Msk = 0x2
	// Bit P1.
	PIO_PSR_P1 = 0x2
	// Position of P2 field.
	PIO_PSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_PSR_P2_Msk = 0x4
	// Bit P2.
	PIO_PSR_P2 = 0x4
	// Position of P3 field.
	PIO_PSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_PSR_P3_Msk = 0x8
	// Bit P3.
	PIO_PSR_P3 = 0x8
	// Position of P4 field.
	PIO_PSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_PSR_P4_Msk = 0x10
	// Bit P4.
	PIO_PSR_P4 = 0x10
	// Position of P5 field.
	PIO_PSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_PSR_P5_Msk = 0x20
	// Bit P5.
	PIO_PSR_P5 = 0x20
	// Position of P6 field.
	PIO_PSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_PSR_P6_Msk = 0x40
	// Bit P6.
	PIO_PSR_P6 = 0x40
	// Position of P7 field.
	PIO_PSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_PSR_P7_Msk = 0x80
	// Bit P7.
	PIO_PSR_P7 = 0x80
	// Position of P8 field.
	PIO_PSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_PSR_P8_Msk = 0x100
	// Bit P8.
	PIO_PSR_P8 = 0x100
	// Position of P9 field.
	PIO_PSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_PSR_P9_Msk = 0x200
	// Bit P9.
	PIO_PSR_P9 = 0x200
	// Position of P10 field.
	PIO_PSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_PSR_P10_Msk = 0x400
	// Bit P10.
	PIO_PSR_P10 = 0x400
	// Position of P11 field.
	PIO_PSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_PSR_P11_Msk = 0x800
	// Bit P11.
	PIO_PSR_P11 = 0x800
	// Position of P12 field.
	PIO_PSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_PSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_PSR_P12 = 0x1000
	// Position of P13 field.
	PIO_PSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_PSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_PSR_P13 = 0x2000
	// Position of P14 field.
	PIO_PSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_PSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_PSR_P14 = 0x4000
	// Position of P15 field.
	PIO_PSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_PSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_PSR_P15 = 0x8000
	// Position of P16 field.
	PIO_PSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_PSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_PSR_P16 = 0x10000
	// Position of P17 field.
	PIO_PSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_PSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_PSR_P17 = 0x20000
	// Position of P18 field.
	PIO_PSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_PSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_PSR_P18 = 0x40000
	// Position of P19 field.
	PIO_PSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_PSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_PSR_P19 = 0x80000
	// Position of P20 field.
	PIO_PSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_PSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_PSR_P20 = 0x100000
	// Position of P21 field.
	PIO_PSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_PSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_PSR_P21 = 0x200000
	// Position of P22 field.
	PIO_PSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_PSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_PSR_P22 = 0x400000
	// Position of P23 field.
	PIO_PSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_PSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_PSR_P23 = 0x800000
	// Position of P24 field.
	PIO_PSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_PSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_PSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_PSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_PSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_PSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_PSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_PSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_PSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_PSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_PSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_PSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_PSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_PSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_PSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_PSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_PSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_PSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_PSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_PSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_PSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_PSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_PSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_PSR_P31 = 0x80000000

	// OER: Output Enable Register
	// Position of P0 field.
	PIO_OER_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_OER_P0_Msk = 0x1
	// Bit P0.
	PIO_OER_P0 = 0x1
	// Position of P1 field.
	PIO_OER_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_OER_P1_Msk = 0x2
	// Bit P1.
	PIO_OER_P1 = 0x2
	// Position of P2 field.
	PIO_OER_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_OER_P2_Msk = 0x4
	// Bit P2.
	PIO_OER_P2 = 0x4
	// Position of P3 field.
	PIO_OER_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_OER_P3_Msk = 0x8
	// Bit P3.
	PIO_OER_P3 = 0x8
	// Position of P4 field.
	PIO_OER_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_OER_P4_Msk = 0x10
	// Bit P4.
	PIO_OER_P4 = 0x10
	// Position of P5 field.
	PIO_OER_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_OER_P5_Msk = 0x20
	// Bit P5.
	PIO_OER_P5 = 0x20
	// Position of P6 field.
	PIO_OER_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_OER_P6_Msk = 0x40
	// Bit P6.
	PIO_OER_P6 = 0x40
	// Position of P7 field.
	PIO_OER_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_OER_P7_Msk = 0x80
	// Bit P7.
	PIO_OER_P7 = 0x80
	// Position of P8 field.
	PIO_OER_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_OER_P8_Msk = 0x100
	// Bit P8.
	PIO_OER_P8 = 0x100
	// Position of P9 field.
	PIO_OER_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_OER_P9_Msk = 0x200
	// Bit P9.
	PIO_OER_P9 = 0x200
	// Position of P10 field.
	PIO_OER_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_OER_P10_Msk = 0x400
	// Bit P10.
	PIO_OER_P10 = 0x400
	// Position of P11 field.
	PIO_OER_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_OER_P11_Msk = 0x800
	// Bit P11.
	PIO_OER_P11 = 0x800
	// Position of P12 field.
	PIO_OER_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_OER_P12_Msk = 0x1000
	// Bit P12.
	PIO_OER_P12 = 0x1000
	// Position of P13 field.
	PIO_OER_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_OER_P13_Msk = 0x2000
	// Bit P13.
	PIO_OER_P13 = 0x2000
	// Position of P14 field.
	PIO_OER_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_OER_P14_Msk = 0x4000
	// Bit P14.
	PIO_OER_P14 = 0x4000
	// Position of P15 field.
	PIO_OER_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_OER_P15_Msk = 0x8000
	// Bit P15.
	PIO_OER_P15 = 0x8000
	// Position of P16 field.
	PIO_OER_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_OER_P16_Msk = 0x10000
	// Bit P16.
	PIO_OER_P16 = 0x10000
	// Position of P17 field.
	PIO_OER_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_OER_P17_Msk = 0x20000
	// Bit P17.
	PIO_OER_P17 = 0x20000
	// Position of P18 field.
	PIO_OER_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_OER_P18_Msk = 0x40000
	// Bit P18.
	PIO_OER_P18 = 0x40000
	// Position of P19 field.
	PIO_OER_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_OER_P19_Msk = 0x80000
	// Bit P19.
	PIO_OER_P19 = 0x80000
	// Position of P20 field.
	PIO_OER_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_OER_P20_Msk = 0x100000
	// Bit P20.
	PIO_OER_P20 = 0x100000
	// Position of P21 field.
	PIO_OER_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_OER_P21_Msk = 0x200000
	// Bit P21.
	PIO_OER_P21 = 0x200000
	// Position of P22 field.
	PIO_OER_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_OER_P22_Msk = 0x400000
	// Bit P22.
	PIO_OER_P22 = 0x400000
	// Position of P23 field.
	PIO_OER_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_OER_P23_Msk = 0x800000
	// Bit P23.
	PIO_OER_P23 = 0x800000
	// Position of P24 field.
	PIO_OER_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_OER_P24_Msk = 0x1000000
	// Bit P24.
	PIO_OER_P24 = 0x1000000
	// Position of P25 field.
	PIO_OER_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_OER_P25_Msk = 0x2000000
	// Bit P25.
	PIO_OER_P25 = 0x2000000
	// Position of P26 field.
	PIO_OER_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_OER_P26_Msk = 0x4000000
	// Bit P26.
	PIO_OER_P26 = 0x4000000
	// Position of P27 field.
	PIO_OER_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_OER_P27_Msk = 0x8000000
	// Bit P27.
	PIO_OER_P27 = 0x8000000
	// Position of P28 field.
	PIO_OER_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_OER_P28_Msk = 0x10000000
	// Bit P28.
	PIO_OER_P28 = 0x10000000
	// Position of P29 field.
	PIO_OER_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_OER_P29_Msk = 0x20000000
	// Bit P29.
	PIO_OER_P29 = 0x20000000
	// Position of P30 field.
	PIO_OER_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_OER_P30_Msk = 0x40000000
	// Bit P30.
	PIO_OER_P30 = 0x40000000
	// Position of P31 field.
	PIO_OER_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_OER_P31_Msk = 0x80000000
	// Bit P31.
	PIO_OER_P31 = 0x80000000

	// ODR: Output Disable Register
	// Position of P0 field.
	PIO_ODR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_ODR_P0_Msk = 0x1
	// Bit P0.
	PIO_ODR_P0 = 0x1
	// Position of P1 field.
	PIO_ODR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_ODR_P1_Msk = 0x2
	// Bit P1.
	PIO_ODR_P1 = 0x2
	// Position of P2 field.
	PIO_ODR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_ODR_P2_Msk = 0x4
	// Bit P2.
	PIO_ODR_P2 = 0x4
	// Position of P3 field.
	PIO_ODR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_ODR_P3_Msk = 0x8
	// Bit P3.
	PIO_ODR_P3 = 0x8
	// Position of P4 field.
	PIO_ODR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_ODR_P4_Msk = 0x10
	// Bit P4.
	PIO_ODR_P4 = 0x10
	// Position of P5 field.
	PIO_ODR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_ODR_P5_Msk = 0x20
	// Bit P5.
	PIO_ODR_P5 = 0x20
	// Position of P6 field.
	PIO_ODR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_ODR_P6_Msk = 0x40
	// Bit P6.
	PIO_ODR_P6 = 0x40
	// Position of P7 field.
	PIO_ODR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_ODR_P7_Msk = 0x80
	// Bit P7.
	PIO_ODR_P7 = 0x80
	// Position of P8 field.
	PIO_ODR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_ODR_P8_Msk = 0x100
	// Bit P8.
	PIO_ODR_P8 = 0x100
	// Position of P9 field.
	PIO_ODR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_ODR_P9_Msk = 0x200
	// Bit P9.
	PIO_ODR_P9 = 0x200
	// Position of P10 field.
	PIO_ODR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_ODR_P10_Msk = 0x400
	// Bit P10.
	PIO_ODR_P10 = 0x400
	// Position of P11 field.
	PIO_ODR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_ODR_P11_Msk = 0x800
	// Bit P11.
	PIO_ODR_P11 = 0x800
	// Position of P12 field.
	PIO_ODR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_ODR_P12_Msk = 0x1000
	// Bit P12.
	PIO_ODR_P12 = 0x1000
	// Position of P13 field.
	PIO_ODR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_ODR_P13_Msk = 0x2000
	// Bit P13.
	PIO_ODR_P13 = 0x2000
	// Position of P14 field.
	PIO_ODR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_ODR_P14_Msk = 0x4000
	// Bit P14.
	PIO_ODR_P14 = 0x4000
	// Position of P15 field.
	PIO_ODR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_ODR_P15_Msk = 0x8000
	// Bit P15.
	PIO_ODR_P15 = 0x8000
	// Position of P16 field.
	PIO_ODR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_ODR_P16_Msk = 0x10000
	// Bit P16.
	PIO_ODR_P16 = 0x10000
	// Position of P17 field.
	PIO_ODR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_ODR_P17_Msk = 0x20000
	// Bit P17.
	PIO_ODR_P17 = 0x20000
	// Position of P18 field.
	PIO_ODR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_ODR_P18_Msk = 0x40000
	// Bit P18.
	PIO_ODR_P18 = 0x40000
	// Position of P19 field.
	PIO_ODR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_ODR_P19_Msk = 0x80000
	// Bit P19.
	PIO_ODR_P19 = 0x80000
	// Position of P20 field.
	PIO_ODR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_ODR_P20_Msk = 0x100000
	// Bit P20.
	PIO_ODR_P20 = 0x100000
	// Position of P21 field.
	PIO_ODR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_ODR_P21_Msk = 0x200000
	// Bit P21.
	PIO_ODR_P21 = 0x200000
	// Position of P22 field.
	PIO_ODR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_ODR_P22_Msk = 0x400000
	// Bit P22.
	PIO_ODR_P22 = 0x400000
	// Position of P23 field.
	PIO_ODR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_ODR_P23_Msk = 0x800000
	// Bit P23.
	PIO_ODR_P23 = 0x800000
	// Position of P24 field.
	PIO_ODR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_ODR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_ODR_P24 = 0x1000000
	// Position of P25 field.
	PIO_ODR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_ODR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_ODR_P25 = 0x2000000
	// Position of P26 field.
	PIO_ODR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_ODR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_ODR_P26 = 0x4000000
	// Position of P27 field.
	PIO_ODR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_ODR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_ODR_P27 = 0x8000000
	// Position of P28 field.
	PIO_ODR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_ODR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_ODR_P28 = 0x10000000
	// Position of P29 field.
	PIO_ODR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_ODR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_ODR_P29 = 0x20000000
	// Position of P30 field.
	PIO_ODR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_ODR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_ODR_P30 = 0x40000000
	// Position of P31 field.
	PIO_ODR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_ODR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_ODR_P31 = 0x80000000

	// OSR: Output Status Register
	// Position of P0 field.
	PIO_OSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_OSR_P0_Msk = 0x1
	// Bit P0.
	PIO_OSR_P0 = 0x1
	// Position of P1 field.
	PIO_OSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_OSR_P1_Msk = 0x2
	// Bit P1.
	PIO_OSR_P1 = 0x2
	// Position of P2 field.
	PIO_OSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_OSR_P2_Msk = 0x4
	// Bit P2.
	PIO_OSR_P2 = 0x4
	// Position of P3 field.
	PIO_OSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_OSR_P3_Msk = 0x8
	// Bit P3.
	PIO_OSR_P3 = 0x8
	// Position of P4 field.
	PIO_OSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_OSR_P4_Msk = 0x10
	// Bit P4.
	PIO_OSR_P4 = 0x10
	// Position of P5 field.
	PIO_OSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_OSR_P5_Msk = 0x20
	// Bit P5.
	PIO_OSR_P5 = 0x20
	// Position of P6 field.
	PIO_OSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_OSR_P6_Msk = 0x40
	// Bit P6.
	PIO_OSR_P6 = 0x40
	// Position of P7 field.
	PIO_OSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_OSR_P7_Msk = 0x80
	// Bit P7.
	PIO_OSR_P7 = 0x80
	// Position of P8 field.
	PIO_OSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_OSR_P8_Msk = 0x100
	// Bit P8.
	PIO_OSR_P8 = 0x100
	// Position of P9 field.
	PIO_OSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_OSR_P9_Msk = 0x200
	// Bit P9.
	PIO_OSR_P9 = 0x200
	// Position of P10 field.
	PIO_OSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_OSR_P10_Msk = 0x400
	// Bit P10.
	PIO_OSR_P10 = 0x400
	// Position of P11 field.
	PIO_OSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_OSR_P11_Msk = 0x800
	// Bit P11.
	PIO_OSR_P11 = 0x800
	// Position of P12 field.
	PIO_OSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_OSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_OSR_P12 = 0x1000
	// Position of P13 field.
	PIO_OSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_OSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_OSR_P13 = 0x2000
	// Position of P14 field.
	PIO_OSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_OSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_OSR_P14 = 0x4000
	// Position of P15 field.
	PIO_OSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_OSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_OSR_P15 = 0x8000
	// Position of P16 field.
	PIO_OSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_OSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_OSR_P16 = 0x10000
	// Position of P17 field.
	PIO_OSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_OSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_OSR_P17 = 0x20000
	// Position of P18 field.
	PIO_OSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_OSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_OSR_P18 = 0x40000
	// Position of P19 field.
	PIO_OSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_OSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_OSR_P19 = 0x80000
	// Position of P20 field.
	PIO_OSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_OSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_OSR_P20 = 0x100000
	// Position of P21 field.
	PIO_OSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_OSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_OSR_P21 = 0x200000
	// Position of P22 field.
	PIO_OSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_OSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_OSR_P22 = 0x400000
	// Position of P23 field.
	PIO_OSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_OSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_OSR_P23 = 0x800000
	// Position of P24 field.
	PIO_OSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_OSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_OSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_OSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_OSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_OSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_OSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_OSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_OSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_OSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_OSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_OSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_OSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_OSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_OSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_OSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_OSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_OSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_OSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_OSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_OSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_OSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_OSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_OSR_P31 = 0x80000000

	// IFER: Glitch Input Filter Enable Register
	// Position of P0 field.
	PIO_IFER_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_IFER_P0_Msk = 0x1
	// Bit P0.
	PIO_IFER_P0 = 0x1
	// Position of P1 field.
	PIO_IFER_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_IFER_P1_Msk = 0x2
	// Bit P1.
	PIO_IFER_P1 = 0x2
	// Position of P2 field.
	PIO_IFER_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_IFER_P2_Msk = 0x4
	// Bit P2.
	PIO_IFER_P2 = 0x4
	// Position of P3 field.
	PIO_IFER_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_IFER_P3_Msk = 0x8
	// Bit P3.
	PIO_IFER_P3 = 0x8
	// Position of P4 field.
	PIO_IFER_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_IFER_P4_Msk = 0x10
	// Bit P4.
	PIO_IFER_P4 = 0x10
	// Position of P5 field.
	PIO_IFER_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_IFER_P5_Msk = 0x20
	// Bit P5.
	PIO_IFER_P5 = 0x20
	// Position of P6 field.
	PIO_IFER_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_IFER_P6_Msk = 0x40
	// Bit P6.
	PIO_IFER_P6 = 0x40
	// Position of P7 field.
	PIO_IFER_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_IFER_P7_Msk = 0x80
	// Bit P7.
	PIO_IFER_P7 = 0x80
	// Position of P8 field.
	PIO_IFER_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_IFER_P8_Msk = 0x100
	// Bit P8.
	PIO_IFER_P8 = 0x100
	// Position of P9 field.
	PIO_IFER_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_IFER_P9_Msk = 0x200
	// Bit P9.
	PIO_IFER_P9 = 0x200
	// Position of P10 field.
	PIO_IFER_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_IFER_P10_Msk = 0x400
	// Bit P10.
	PIO_IFER_P10 = 0x400
	// Position of P11 field.
	PIO_IFER_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_IFER_P11_Msk = 0x800
	// Bit P11.
	PIO_IFER_P11 = 0x800
	// Position of P12 field.
	PIO_IFER_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_IFER_P12_Msk = 0x1000
	// Bit P12.
	PIO_IFER_P12 = 0x1000
	// Position of P13 field.
	PIO_IFER_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_IFER_P13_Msk = 0x2000
	// Bit P13.
	PIO_IFER_P13 = 0x2000
	// Position of P14 field.
	PIO_IFER_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_IFER_P14_Msk = 0x4000
	// Bit P14.
	PIO_IFER_P14 = 0x4000
	// Position of P15 field.
	PIO_IFER_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_IFER_P15_Msk = 0x8000
	// Bit P15.
	PIO_IFER_P15 = 0x8000
	// Position of P16 field.
	PIO_IFER_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_IFER_P16_Msk = 0x10000
	// Bit P16.
	PIO_IFER_P16 = 0x10000
	// Position of P17 field.
	PIO_IFER_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_IFER_P17_Msk = 0x20000
	// Bit P17.
	PIO_IFER_P17 = 0x20000
	// Position of P18 field.
	PIO_IFER_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_IFER_P18_Msk = 0x40000
	// Bit P18.
	PIO_IFER_P18 = 0x40000
	// Position of P19 field.
	PIO_IFER_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_IFER_P19_Msk = 0x80000
	// Bit P19.
	PIO_IFER_P19 = 0x80000
	// Position of P20 field.
	PIO_IFER_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_IFER_P20_Msk = 0x100000
	// Bit P20.
	PIO_IFER_P20 = 0x100000
	// Position of P21 field.
	PIO_IFER_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_IFER_P21_Msk = 0x200000
	// Bit P21.
	PIO_IFER_P21 = 0x200000
	// Position of P22 field.
	PIO_IFER_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_IFER_P22_Msk = 0x400000
	// Bit P22.
	PIO_IFER_P22 = 0x400000
	// Position of P23 field.
	PIO_IFER_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_IFER_P23_Msk = 0x800000
	// Bit P23.
	PIO_IFER_P23 = 0x800000
	// Position of P24 field.
	PIO_IFER_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_IFER_P24_Msk = 0x1000000
	// Bit P24.
	PIO_IFER_P24 = 0x1000000
	// Position of P25 field.
	PIO_IFER_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_IFER_P25_Msk = 0x2000000
	// Bit P25.
	PIO_IFER_P25 = 0x2000000
	// Position of P26 field.
	PIO_IFER_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_IFER_P26_Msk = 0x4000000
	// Bit P26.
	PIO_IFER_P26 = 0x4000000
	// Position of P27 field.
	PIO_IFER_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_IFER_P27_Msk = 0x8000000
	// Bit P27.
	PIO_IFER_P27 = 0x8000000
	// Position of P28 field.
	PIO_IFER_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_IFER_P28_Msk = 0x10000000
	// Bit P28.
	PIO_IFER_P28 = 0x10000000
	// Position of P29 field.
	PIO_IFER_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_IFER_P29_Msk = 0x20000000
	// Bit P29.
	PIO_IFER_P29 = 0x20000000
	// Position of P30 field.
	PIO_IFER_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_IFER_P30_Msk = 0x40000000
	// Bit P30.
	PIO_IFER_P30 = 0x40000000
	// Position of P31 field.
	PIO_IFER_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_IFER_P31_Msk = 0x80000000
	// Bit P31.
	PIO_IFER_P31 = 0x80000000

	// IFDR: Glitch Input Filter Disable Register
	// Position of P0 field.
	PIO_IFDR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_IFDR_P0_Msk = 0x1
	// Bit P0.
	PIO_IFDR_P0 = 0x1
	// Position of P1 field.
	PIO_IFDR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_IFDR_P1_Msk = 0x2
	// Bit P1.
	PIO_IFDR_P1 = 0x2
	// Position of P2 field.
	PIO_IFDR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_IFDR_P2_Msk = 0x4
	// Bit P2.
	PIO_IFDR_P2 = 0x4
	// Position of P3 field.
	PIO_IFDR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_IFDR_P3_Msk = 0x8
	// Bit P3.
	PIO_IFDR_P3 = 0x8
	// Position of P4 field.
	PIO_IFDR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_IFDR_P4_Msk = 0x10
	// Bit P4.
	PIO_IFDR_P4 = 0x10
	// Position of P5 field.
	PIO_IFDR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_IFDR_P5_Msk = 0x20
	// Bit P5.
	PIO_IFDR_P5 = 0x20
	// Position of P6 field.
	PIO_IFDR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_IFDR_P6_Msk = 0x40
	// Bit P6.
	PIO_IFDR_P6 = 0x40
	// Position of P7 field.
	PIO_IFDR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_IFDR_P7_Msk = 0x80
	// Bit P7.
	PIO_IFDR_P7 = 0x80
	// Position of P8 field.
	PIO_IFDR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_IFDR_P8_Msk = 0x100
	// Bit P8.
	PIO_IFDR_P8 = 0x100
	// Position of P9 field.
	PIO_IFDR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_IFDR_P9_Msk = 0x200
	// Bit P9.
	PIO_IFDR_P9 = 0x200
	// Position of P10 field.
	PIO_IFDR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_IFDR_P10_Msk = 0x400
	// Bit P10.
	PIO_IFDR_P10 = 0x400
	// Position of P11 field.
	PIO_IFDR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_IFDR_P11_Msk = 0x800
	// Bit P11.
	PIO_IFDR_P11 = 0x800
	// Position of P12 field.
	PIO_IFDR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_IFDR_P12_Msk = 0x1000
	// Bit P12.
	PIO_IFDR_P12 = 0x1000
	// Position of P13 field.
	PIO_IFDR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_IFDR_P13_Msk = 0x2000
	// Bit P13.
	PIO_IFDR_P13 = 0x2000
	// Position of P14 field.
	PIO_IFDR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_IFDR_P14_Msk = 0x4000
	// Bit P14.
	PIO_IFDR_P14 = 0x4000
	// Position of P15 field.
	PIO_IFDR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_IFDR_P15_Msk = 0x8000
	// Bit P15.
	PIO_IFDR_P15 = 0x8000
	// Position of P16 field.
	PIO_IFDR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_IFDR_P16_Msk = 0x10000
	// Bit P16.
	PIO_IFDR_P16 = 0x10000
	// Position of P17 field.
	PIO_IFDR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_IFDR_P17_Msk = 0x20000
	// Bit P17.
	PIO_IFDR_P17 = 0x20000
	// Position of P18 field.
	PIO_IFDR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_IFDR_P18_Msk = 0x40000
	// Bit P18.
	PIO_IFDR_P18 = 0x40000
	// Position of P19 field.
	PIO_IFDR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_IFDR_P19_Msk = 0x80000
	// Bit P19.
	PIO_IFDR_P19 = 0x80000
	// Position of P20 field.
	PIO_IFDR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_IFDR_P20_Msk = 0x100000
	// Bit P20.
	PIO_IFDR_P20 = 0x100000
	// Position of P21 field.
	PIO_IFDR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_IFDR_P21_Msk = 0x200000
	// Bit P21.
	PIO_IFDR_P21 = 0x200000
	// Position of P22 field.
	PIO_IFDR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_IFDR_P22_Msk = 0x400000
	// Bit P22.
	PIO_IFDR_P22 = 0x400000
	// Position of P23 field.
	PIO_IFDR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_IFDR_P23_Msk = 0x800000
	// Bit P23.
	PIO_IFDR_P23 = 0x800000
	// Position of P24 field.
	PIO_IFDR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_IFDR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_IFDR_P24 = 0x1000000
	// Position of P25 field.
	PIO_IFDR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_IFDR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_IFDR_P25 = 0x2000000
	// Position of P26 field.
	PIO_IFDR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_IFDR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_IFDR_P26 = 0x4000000
	// Position of P27 field.
	PIO_IFDR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_IFDR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_IFDR_P27 = 0x8000000
	// Position of P28 field.
	PIO_IFDR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_IFDR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_IFDR_P28 = 0x10000000
	// Position of P29 field.
	PIO_IFDR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_IFDR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_IFDR_P29 = 0x20000000
	// Position of P30 field.
	PIO_IFDR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_IFDR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_IFDR_P30 = 0x40000000
	// Position of P31 field.
	PIO_IFDR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_IFDR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_IFDR_P31 = 0x80000000

	// IFSR: Glitch Input Filter Status Register
	// Position of P0 field.
	PIO_IFSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_IFSR_P0_Msk = 0x1
	// Bit P0.
	PIO_IFSR_P0 = 0x1
	// Position of P1 field.
	PIO_IFSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_IFSR_P1_Msk = 0x2
	// Bit P1.
	PIO_IFSR_P1 = 0x2
	// Position of P2 field.
	PIO_IFSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_IFSR_P2_Msk = 0x4
	// Bit P2.
	PIO_IFSR_P2 = 0x4
	// Position of P3 field.
	PIO_IFSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_IFSR_P3_Msk = 0x8
	// Bit P3.
	PIO_IFSR_P3 = 0x8
	// Position of P4 field.
	PIO_IFSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_IFSR_P4_Msk = 0x10
	// Bit P4.
	PIO_IFSR_P4 = 0x10
	// Position of P5 field.
	PIO_IFSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_IFSR_P5_Msk = 0x20
	// Bit P5.
	PIO_IFSR_P5 = 0x20
	// Position of P6 field.
	PIO_IFSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_IFSR_P6_Msk = 0x40
	// Bit P6.
	PIO_IFSR_P6 = 0x40
	// Position of P7 field.
	PIO_IFSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_IFSR_P7_Msk = 0x80
	// Bit P7.
	PIO_IFSR_P7 = 0x80
	// Position of P8 field.
	PIO_IFSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_IFSR_P8_Msk = 0x100
	// Bit P8.
	PIO_IFSR_P8 = 0x100
	// Position of P9 field.
	PIO_IFSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_IFSR_P9_Msk = 0x200
	// Bit P9.
	PIO_IFSR_P9 = 0x200
	// Position of P10 field.
	PIO_IFSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_IFSR_P10_Msk = 0x400
	// Bit P10.
	PIO_IFSR_P10 = 0x400
	// Position of P11 field.
	PIO_IFSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_IFSR_P11_Msk = 0x800
	// Bit P11.
	PIO_IFSR_P11 = 0x800
	// Position of P12 field.
	PIO_IFSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_IFSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_IFSR_P12 = 0x1000
	// Position of P13 field.
	PIO_IFSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_IFSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_IFSR_P13 = 0x2000
	// Position of P14 field.
	PIO_IFSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_IFSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_IFSR_P14 = 0x4000
	// Position of P15 field.
	PIO_IFSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_IFSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_IFSR_P15 = 0x8000
	// Position of P16 field.
	PIO_IFSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_IFSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_IFSR_P16 = 0x10000
	// Position of P17 field.
	PIO_IFSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_IFSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_IFSR_P17 = 0x20000
	// Position of P18 field.
	PIO_IFSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_IFSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_IFSR_P18 = 0x40000
	// Position of P19 field.
	PIO_IFSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_IFSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_IFSR_P19 = 0x80000
	// Position of P20 field.
	PIO_IFSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_IFSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_IFSR_P20 = 0x100000
	// Position of P21 field.
	PIO_IFSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_IFSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_IFSR_P21 = 0x200000
	// Position of P22 field.
	PIO_IFSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_IFSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_IFSR_P22 = 0x400000
	// Position of P23 field.
	PIO_IFSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_IFSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_IFSR_P23 = 0x800000
	// Position of P24 field.
	PIO_IFSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_IFSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_IFSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_IFSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_IFSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_IFSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_IFSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_IFSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_IFSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_IFSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_IFSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_IFSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_IFSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_IFSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_IFSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_IFSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_IFSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_IFSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_IFSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_IFSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_IFSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_IFSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_IFSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_IFSR_P31 = 0x80000000

	// SODR: Set Output Data Register
	// Position of P0 field.
	PIO_SODR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_SODR_P0_Msk = 0x1
	// Bit P0.
	PIO_SODR_P0 = 0x1
	// Position of P1 field.
	PIO_SODR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_SODR_P1_Msk = 0x2
	// Bit P1.
	PIO_SODR_P1 = 0x2
	// Position of P2 field.
	PIO_SODR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_SODR_P2_Msk = 0x4
	// Bit P2.
	PIO_SODR_P2 = 0x4
	// Position of P3 field.
	PIO_SODR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_SODR_P3_Msk = 0x8
	// Bit P3.
	PIO_SODR_P3 = 0x8
	// Position of P4 field.
	PIO_SODR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_SODR_P4_Msk = 0x10
	// Bit P4.
	PIO_SODR_P4 = 0x10
	// Position of P5 field.
	PIO_SODR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_SODR_P5_Msk = 0x20
	// Bit P5.
	PIO_SODR_P5 = 0x20
	// Position of P6 field.
	PIO_SODR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_SODR_P6_Msk = 0x40
	// Bit P6.
	PIO_SODR_P6 = 0x40
	// Position of P7 field.
	PIO_SODR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_SODR_P7_Msk = 0x80
	// Bit P7.
	PIO_SODR_P7 = 0x80
	// Position of P8 field.
	PIO_SODR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_SODR_P8_Msk = 0x100
	// Bit P8.
	PIO_SODR_P8 = 0x100
	// Position of P9 field.
	PIO_SODR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_SODR_P9_Msk = 0x200
	// Bit P9.
	PIO_SODR_P9 = 0x200
	// Position of P10 field.
	PIO_SODR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_SODR_P10_Msk = 0x400
	// Bit P10.
	PIO_SODR_P10 = 0x400
	// Position of P11 field.
	PIO_SODR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_SODR_P11_Msk = 0x800
	// Bit P11.
	PIO_SODR_P11 = 0x800
	// Position of P12 field.
	PIO_SODR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_SODR_P12_Msk = 0x1000
	// Bit P12.
	PIO_SODR_P12 = 0x1000
	// Position of P13 field.
	PIO_SODR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_SODR_P13_Msk = 0x2000
	// Bit P13.
	PIO_SODR_P13 = 0x2000
	// Position of P14 field.
	PIO_SODR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_SODR_P14_Msk = 0x4000
	// Bit P14.
	PIO_SODR_P14 = 0x4000
	// Position of P15 field.
	PIO_SODR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_SODR_P15_Msk = 0x8000
	// Bit P15.
	PIO_SODR_P15 = 0x8000
	// Position of P16 field.
	PIO_SODR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_SODR_P16_Msk = 0x10000
	// Bit P16.
	PIO_SODR_P16 = 0x10000
	// Position of P17 field.
	PIO_SODR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_SODR_P17_Msk = 0x20000
	// Bit P17.
	PIO_SODR_P17 = 0x20000
	// Position of P18 field.
	PIO_SODR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_SODR_P18_Msk = 0x40000
	// Bit P18.
	PIO_SODR_P18 = 0x40000
	// Position of P19 field.
	PIO_SODR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_SODR_P19_Msk = 0x80000
	// Bit P19.
	PIO_SODR_P19 = 0x80000
	// Position of P20 field.
	PIO_SODR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_SODR_P20_Msk = 0x100000
	// Bit P20.
	PIO_SODR_P20 = 0x100000
	// Position of P21 field.
	PIO_SODR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_SODR_P21_Msk = 0x200000
	// Bit P21.
	PIO_SODR_P21 = 0x200000
	// Position of P22 field.
	PIO_SODR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_SODR_P22_Msk = 0x400000
	// Bit P22.
	PIO_SODR_P22 = 0x400000
	// Position of P23 field.
	PIO_SODR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_SODR_P23_Msk = 0x800000
	// Bit P23.
	PIO_SODR_P23 = 0x800000
	// Position of P24 field.
	PIO_SODR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_SODR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_SODR_P24 = 0x1000000
	// Position of P25 field.
	PIO_SODR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_SODR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_SODR_P25 = 0x2000000
	// Position of P26 field.
	PIO_SODR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_SODR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_SODR_P26 = 0x4000000
	// Position of P27 field.
	PIO_SODR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_SODR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_SODR_P27 = 0x8000000
	// Position of P28 field.
	PIO_SODR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_SODR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_SODR_P28 = 0x10000000
	// Position of P29 field.
	PIO_SODR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_SODR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_SODR_P29 = 0x20000000
	// Position of P30 field.
	PIO_SODR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_SODR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_SODR_P30 = 0x40000000
	// Position of P31 field.
	PIO_SODR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_SODR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_SODR_P31 = 0x80000000

	// CODR: Clear Output Data Register
	// Position of P0 field.
	PIO_CODR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_CODR_P0_Msk = 0x1
	// Bit P0.
	PIO_CODR_P0 = 0x1
	// Position of P1 field.
	PIO_CODR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_CODR_P1_Msk = 0x2
	// Bit P1.
	PIO_CODR_P1 = 0x2
	// Position of P2 field.
	PIO_CODR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_CODR_P2_Msk = 0x4
	// Bit P2.
	PIO_CODR_P2 = 0x4
	// Position of P3 field.
	PIO_CODR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_CODR_P3_Msk = 0x8
	// Bit P3.
	PIO_CODR_P3 = 0x8
	// Position of P4 field.
	PIO_CODR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_CODR_P4_Msk = 0x10
	// Bit P4.
	PIO_CODR_P4 = 0x10
	// Position of P5 field.
	PIO_CODR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_CODR_P5_Msk = 0x20
	// Bit P5.
	PIO_CODR_P5 = 0x20
	// Position of P6 field.
	PIO_CODR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_CODR_P6_Msk = 0x40
	// Bit P6.
	PIO_CODR_P6 = 0x40
	// Position of P7 field.
	PIO_CODR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_CODR_P7_Msk = 0x80
	// Bit P7.
	PIO_CODR_P7 = 0x80
	// Position of P8 field.
	PIO_CODR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_CODR_P8_Msk = 0x100
	// Bit P8.
	PIO_CODR_P8 = 0x100
	// Position of P9 field.
	PIO_CODR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_CODR_P9_Msk = 0x200
	// Bit P9.
	PIO_CODR_P9 = 0x200
	// Position of P10 field.
	PIO_CODR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_CODR_P10_Msk = 0x400
	// Bit P10.
	PIO_CODR_P10 = 0x400
	// Position of P11 field.
	PIO_CODR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_CODR_P11_Msk = 0x800
	// Bit P11.
	PIO_CODR_P11 = 0x800
	// Position of P12 field.
	PIO_CODR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_CODR_P12_Msk = 0x1000
	// Bit P12.
	PIO_CODR_P12 = 0x1000
	// Position of P13 field.
	PIO_CODR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_CODR_P13_Msk = 0x2000
	// Bit P13.
	PIO_CODR_P13 = 0x2000
	// Position of P14 field.
	PIO_CODR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_CODR_P14_Msk = 0x4000
	// Bit P14.
	PIO_CODR_P14 = 0x4000
	// Position of P15 field.
	PIO_CODR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_CODR_P15_Msk = 0x8000
	// Bit P15.
	PIO_CODR_P15 = 0x8000
	// Position of P16 field.
	PIO_CODR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_CODR_P16_Msk = 0x10000
	// Bit P16.
	PIO_CODR_P16 = 0x10000
	// Position of P17 field.
	PIO_CODR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_CODR_P17_Msk = 0x20000
	// Bit P17.
	PIO_CODR_P17 = 0x20000
	// Position of P18 field.
	PIO_CODR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_CODR_P18_Msk = 0x40000
	// Bit P18.
	PIO_CODR_P18 = 0x40000
	// Position of P19 field.
	PIO_CODR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_CODR_P19_Msk = 0x80000
	// Bit P19.
	PIO_CODR_P19 = 0x80000
	// Position of P20 field.
	PIO_CODR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_CODR_P20_Msk = 0x100000
	// Bit P20.
	PIO_CODR_P20 = 0x100000
	// Position of P21 field.
	PIO_CODR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_CODR_P21_Msk = 0x200000
	// Bit P21.
	PIO_CODR_P21 = 0x200000
	// Position of P22 field.
	PIO_CODR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_CODR_P22_Msk = 0x400000
	// Bit P22.
	PIO_CODR_P22 = 0x400000
	// Position of P23 field.
	PIO_CODR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_CODR_P23_Msk = 0x800000
	// Bit P23.
	PIO_CODR_P23 = 0x800000
	// Position of P24 field.
	PIO_CODR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_CODR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_CODR_P24 = 0x1000000
	// Position of P25 field.
	PIO_CODR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_CODR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_CODR_P25 = 0x2000000
	// Position of P26 field.
	PIO_CODR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_CODR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_CODR_P26 = 0x4000000
	// Position of P27 field.
	PIO_CODR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_CODR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_CODR_P27 = 0x8000000
	// Position of P28 field.
	PIO_CODR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_CODR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_CODR_P28 = 0x10000000
	// Position of P29 field.
	PIO_CODR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_CODR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_CODR_P29 = 0x20000000
	// Position of P30 field.
	PIO_CODR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_CODR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_CODR_P30 = 0x40000000
	// Position of P31 field.
	PIO_CODR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_CODR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_CODR_P31 = 0x80000000

	// ODSR: Output Data Status Register
	// Position of P0 field.
	PIO_ODSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_ODSR_P0_Msk = 0x1
	// Bit P0.
	PIO_ODSR_P0 = 0x1
	// Position of P1 field.
	PIO_ODSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_ODSR_P1_Msk = 0x2
	// Bit P1.
	PIO_ODSR_P1 = 0x2
	// Position of P2 field.
	PIO_ODSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_ODSR_P2_Msk = 0x4
	// Bit P2.
	PIO_ODSR_P2 = 0x4
	// Position of P3 field.
	PIO_ODSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_ODSR_P3_Msk = 0x8
	// Bit P3.
	PIO_ODSR_P3 = 0x8
	// Position of P4 field.
	PIO_ODSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_ODSR_P4_Msk = 0x10
	// Bit P4.
	PIO_ODSR_P4 = 0x10
	// Position of P5 field.
	PIO_ODSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_ODSR_P5_Msk = 0x20
	// Bit P5.
	PIO_ODSR_P5 = 0x20
	// Position of P6 field.
	PIO_ODSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_ODSR_P6_Msk = 0x40
	// Bit P6.
	PIO_ODSR_P6 = 0x40
	// Position of P7 field.
	PIO_ODSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_ODSR_P7_Msk = 0x80
	// Bit P7.
	PIO_ODSR_P7 = 0x80
	// Position of P8 field.
	PIO_ODSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_ODSR_P8_Msk = 0x100
	// Bit P8.
	PIO_ODSR_P8 = 0x100
	// Position of P9 field.
	PIO_ODSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_ODSR_P9_Msk = 0x200
	// Bit P9.
	PIO_ODSR_P9 = 0x200
	// Position of P10 field.
	PIO_ODSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_ODSR_P10_Msk = 0x400
	// Bit P10.
	PIO_ODSR_P10 = 0x400
	// Position of P11 field.
	PIO_ODSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_ODSR_P11_Msk = 0x800
	// Bit P11.
	PIO_ODSR_P11 = 0x800
	// Position of P12 field.
	PIO_ODSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_ODSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_ODSR_P12 = 0x1000
	// Position of P13 field.
	PIO_ODSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_ODSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_ODSR_P13 = 0x2000
	// Position of P14 field.
	PIO_ODSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_ODSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_ODSR_P14 = 0x4000
	// Position of P15 field.
	PIO_ODSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_ODSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_ODSR_P15 = 0x8000
	// Position of P16 field.
	PIO_ODSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_ODSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_ODSR_P16 = 0x10000
	// Position of P17 field.
	PIO_ODSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_ODSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_ODSR_P17 = 0x20000
	// Position of P18 field.
	PIO_ODSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_ODSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_ODSR_P18 = 0x40000
	// Position of P19 field.
	PIO_ODSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_ODSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_ODSR_P19 = 0x80000
	// Position of P20 field.
	PIO_ODSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_ODSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_ODSR_P20 = 0x100000
	// Position of P21 field.
	PIO_ODSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_ODSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_ODSR_P21 = 0x200000
	// Position of P22 field.
	PIO_ODSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_ODSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_ODSR_P22 = 0x400000
	// Position of P23 field.
	PIO_ODSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_ODSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_ODSR_P23 = 0x800000
	// Position of P24 field.
	PIO_ODSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_ODSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_ODSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_ODSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_ODSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_ODSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_ODSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_ODSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_ODSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_ODSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_ODSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_ODSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_ODSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_ODSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_ODSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_ODSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_ODSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_ODSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_ODSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_ODSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_ODSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_ODSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_ODSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_ODSR_P31 = 0x80000000

	// PDSR: Pin Data Status Register
	// Position of P0 field.
	PIO_PDSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_PDSR_P0_Msk = 0x1
	// Bit P0.
	PIO_PDSR_P0 = 0x1
	// Position of P1 field.
	PIO_PDSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_PDSR_P1_Msk = 0x2
	// Bit P1.
	PIO_PDSR_P1 = 0x2
	// Position of P2 field.
	PIO_PDSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_PDSR_P2_Msk = 0x4
	// Bit P2.
	PIO_PDSR_P2 = 0x4
	// Position of P3 field.
	PIO_PDSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_PDSR_P3_Msk = 0x8
	// Bit P3.
	PIO_PDSR_P3 = 0x8
	// Position of P4 field.
	PIO_PDSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_PDSR_P4_Msk = 0x10
	// Bit P4.
	PIO_PDSR_P4 = 0x10
	// Position of P5 field.
	PIO_PDSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_PDSR_P5_Msk = 0x20
	// Bit P5.
	PIO_PDSR_P5 = 0x20
	// Position of P6 field.
	PIO_PDSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_PDSR_P6_Msk = 0x40
	// Bit P6.
	PIO_PDSR_P6 = 0x40
	// Position of P7 field.
	PIO_PDSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_PDSR_P7_Msk = 0x80
	// Bit P7.
	PIO_PDSR_P7 = 0x80
	// Position of P8 field.
	PIO_PDSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_PDSR_P8_Msk = 0x100
	// Bit P8.
	PIO_PDSR_P8 = 0x100
	// Position of P9 field.
	PIO_PDSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_PDSR_P9_Msk = 0x200
	// Bit P9.
	PIO_PDSR_P9 = 0x200
	// Position of P10 field.
	PIO_PDSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_PDSR_P10_Msk = 0x400
	// Bit P10.
	PIO_PDSR_P10 = 0x400
	// Position of P11 field.
	PIO_PDSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_PDSR_P11_Msk = 0x800
	// Bit P11.
	PIO_PDSR_P11 = 0x800
	// Position of P12 field.
	PIO_PDSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_PDSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_PDSR_P12 = 0x1000
	// Position of P13 field.
	PIO_PDSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_PDSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_PDSR_P13 = 0x2000
	// Position of P14 field.
	PIO_PDSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_PDSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_PDSR_P14 = 0x4000
	// Position of P15 field.
	PIO_PDSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_PDSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_PDSR_P15 = 0x8000
	// Position of P16 field.
	PIO_PDSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_PDSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_PDSR_P16 = 0x10000
	// Position of P17 field.
	PIO_PDSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_PDSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_PDSR_P17 = 0x20000
	// Position of P18 field.
	PIO_PDSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_PDSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_PDSR_P18 = 0x40000
	// Position of P19 field.
	PIO_PDSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_PDSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_PDSR_P19 = 0x80000
	// Position of P20 field.
	PIO_PDSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_PDSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_PDSR_P20 = 0x100000
	// Position of P21 field.
	PIO_PDSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_PDSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_PDSR_P21 = 0x200000
	// Position of P22 field.
	PIO_PDSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_PDSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_PDSR_P22 = 0x400000
	// Position of P23 field.
	PIO_PDSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_PDSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_PDSR_P23 = 0x800000
	// Position of P24 field.
	PIO_PDSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_PDSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_PDSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_PDSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_PDSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_PDSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_PDSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_PDSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_PDSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_PDSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_PDSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_PDSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_PDSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_PDSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_PDSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_PDSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_PDSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_PDSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_PDSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_PDSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_PDSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_PDSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_PDSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_PDSR_P31 = 0x80000000

	// IER: Interrupt Enable Register
	// Position of P0 field.
	PIO_IER_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_IER_P0_Msk = 0x1
	// Bit P0.
	PIO_IER_P0 = 0x1
	// Position of P1 field.
	PIO_IER_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_IER_P1_Msk = 0x2
	// Bit P1.
	PIO_IER_P1 = 0x2
	// Position of P2 field.
	PIO_IER_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_IER_P2_Msk = 0x4
	// Bit P2.
	PIO_IER_P2 = 0x4
	// Position of P3 field.
	PIO_IER_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_IER_P3_Msk = 0x8
	// Bit P3.
	PIO_IER_P3 = 0x8
	// Position of P4 field.
	PIO_IER_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_IER_P4_Msk = 0x10
	// Bit P4.
	PIO_IER_P4 = 0x10
	// Position of P5 field.
	PIO_IER_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_IER_P5_Msk = 0x20
	// Bit P5.
	PIO_IER_P5 = 0x20
	// Position of P6 field.
	PIO_IER_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_IER_P6_Msk = 0x40
	// Bit P6.
	PIO_IER_P6 = 0x40
	// Position of P7 field.
	PIO_IER_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_IER_P7_Msk = 0x80
	// Bit P7.
	PIO_IER_P7 = 0x80
	// Position of P8 field.
	PIO_IER_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_IER_P8_Msk = 0x100
	// Bit P8.
	PIO_IER_P8 = 0x100
	// Position of P9 field.
	PIO_IER_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_IER_P9_Msk = 0x200
	// Bit P9.
	PIO_IER_P9 = 0x200
	// Position of P10 field.
	PIO_IER_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_IER_P10_Msk = 0x400
	// Bit P10.
	PIO_IER_P10 = 0x400
	// Position of P11 field.
	PIO_IER_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_IER_P11_Msk = 0x800
	// Bit P11.
	PIO_IER_P11 = 0x800
	// Position of P12 field.
	PIO_IER_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_IER_P12_Msk = 0x1000
	// Bit P12.
	PIO_IER_P12 = 0x1000
	// Position of P13 field.
	PIO_IER_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_IER_P13_Msk = 0x2000
	// Bit P13.
	PIO_IER_P13 = 0x2000
	// Position of P14 field.
	PIO_IER_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_IER_P14_Msk = 0x4000
	// Bit P14.
	PIO_IER_P14 = 0x4000
	// Position of P15 field.
	PIO_IER_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_IER_P15_Msk = 0x8000
	// Bit P15.
	PIO_IER_P15 = 0x8000
	// Position of P16 field.
	PIO_IER_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_IER_P16_Msk = 0x10000
	// Bit P16.
	PIO_IER_P16 = 0x10000
	// Position of P17 field.
	PIO_IER_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_IER_P17_Msk = 0x20000
	// Bit P17.
	PIO_IER_P17 = 0x20000
	// Position of P18 field.
	PIO_IER_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_IER_P18_Msk = 0x40000
	// Bit P18.
	PIO_IER_P18 = 0x40000
	// Position of P19 field.
	PIO_IER_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_IER_P19_Msk = 0x80000
	// Bit P19.
	PIO_IER_P19 = 0x80000
	// Position of P20 field.
	PIO_IER_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_IER_P20_Msk = 0x100000
	// Bit P20.
	PIO_IER_P20 = 0x100000
	// Position of P21 field.
	PIO_IER_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_IER_P21_Msk = 0x200000
	// Bit P21.
	PIO_IER_P21 = 0x200000
	// Position of P22 field.
	PIO_IER_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_IER_P22_Msk = 0x400000
	// Bit P22.
	PIO_IER_P22 = 0x400000
	// Position of P23 field.
	PIO_IER_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_IER_P23_Msk = 0x800000
	// Bit P23.
	PIO_IER_P23 = 0x800000
	// Position of P24 field.
	PIO_IER_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_IER_P24_Msk = 0x1000000
	// Bit P24.
	PIO_IER_P24 = 0x1000000
	// Position of P25 field.
	PIO_IER_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_IER_P25_Msk = 0x2000000
	// Bit P25.
	PIO_IER_P25 = 0x2000000
	// Position of P26 field.
	PIO_IER_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_IER_P26_Msk = 0x4000000
	// Bit P26.
	PIO_IER_P26 = 0x4000000
	// Position of P27 field.
	PIO_IER_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_IER_P27_Msk = 0x8000000
	// Bit P27.
	PIO_IER_P27 = 0x8000000
	// Position of P28 field.
	PIO_IER_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_IER_P28_Msk = 0x10000000
	// Bit P28.
	PIO_IER_P28 = 0x10000000
	// Position of P29 field.
	PIO_IER_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_IER_P29_Msk = 0x20000000
	// Bit P29.
	PIO_IER_P29 = 0x20000000
	// Position of P30 field.
	PIO_IER_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_IER_P30_Msk = 0x40000000
	// Bit P30.
	PIO_IER_P30 = 0x40000000
	// Position of P31 field.
	PIO_IER_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_IER_P31_Msk = 0x80000000
	// Bit P31.
	PIO_IER_P31 = 0x80000000

	// IDR: Interrupt Disable Register
	// Position of P0 field.
	PIO_IDR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_IDR_P0_Msk = 0x1
	// Bit P0.
	PIO_IDR_P0 = 0x1
	// Position of P1 field.
	PIO_IDR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_IDR_P1_Msk = 0x2
	// Bit P1.
	PIO_IDR_P1 = 0x2
	// Position of P2 field.
	PIO_IDR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_IDR_P2_Msk = 0x4
	// Bit P2.
	PIO_IDR_P2 = 0x4
	// Position of P3 field.
	PIO_IDR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_IDR_P3_Msk = 0x8
	// Bit P3.
	PIO_IDR_P3 = 0x8
	// Position of P4 field.
	PIO_IDR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_IDR_P4_Msk = 0x10
	// Bit P4.
	PIO_IDR_P4 = 0x10
	// Position of P5 field.
	PIO_IDR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_IDR_P5_Msk = 0x20
	// Bit P5.
	PIO_IDR_P5 = 0x20
	// Position of P6 field.
	PIO_IDR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_IDR_P6_Msk = 0x40
	// Bit P6.
	PIO_IDR_P6 = 0x40
	// Position of P7 field.
	PIO_IDR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_IDR_P7_Msk = 0x80
	// Bit P7.
	PIO_IDR_P7 = 0x80
	// Position of P8 field.
	PIO_IDR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_IDR_P8_Msk = 0x100
	// Bit P8.
	PIO_IDR_P8 = 0x100
	// Position of P9 field.
	PIO_IDR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_IDR_P9_Msk = 0x200
	// Bit P9.
	PIO_IDR_P9 = 0x200
	// Position of P10 field.
	PIO_IDR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_IDR_P10_Msk = 0x400
	// Bit P10.
	PIO_IDR_P10 = 0x400
	// Position of P11 field.
	PIO_IDR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_IDR_P11_Msk = 0x800
	// Bit P11.
	PIO_IDR_P11 = 0x800
	// Position of P12 field.
	PIO_IDR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_IDR_P12_Msk = 0x1000
	// Bit P12.
	PIO_IDR_P12 = 0x1000
	// Position of P13 field.
	PIO_IDR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_IDR_P13_Msk = 0x2000
	// Bit P13.
	PIO_IDR_P13 = 0x2000
	// Position of P14 field.
	PIO_IDR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_IDR_P14_Msk = 0x4000
	// Bit P14.
	PIO_IDR_P14 = 0x4000
	// Position of P15 field.
	PIO_IDR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_IDR_P15_Msk = 0x8000
	// Bit P15.
	PIO_IDR_P15 = 0x8000
	// Position of P16 field.
	PIO_IDR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_IDR_P16_Msk = 0x10000
	// Bit P16.
	PIO_IDR_P16 = 0x10000
	// Position of P17 field.
	PIO_IDR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_IDR_P17_Msk = 0x20000
	// Bit P17.
	PIO_IDR_P17 = 0x20000
	// Position of P18 field.
	PIO_IDR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_IDR_P18_Msk = 0x40000
	// Bit P18.
	PIO_IDR_P18 = 0x40000
	// Position of P19 field.
	PIO_IDR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_IDR_P19_Msk = 0x80000
	// Bit P19.
	PIO_IDR_P19 = 0x80000
	// Position of P20 field.
	PIO_IDR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_IDR_P20_Msk = 0x100000
	// Bit P20.
	PIO_IDR_P20 = 0x100000
	// Position of P21 field.
	PIO_IDR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_IDR_P21_Msk = 0x200000
	// Bit P21.
	PIO_IDR_P21 = 0x200000
	// Position of P22 field.
	PIO_IDR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_IDR_P22_Msk = 0x400000
	// Bit P22.
	PIO_IDR_P22 = 0x400000
	// Position of P23 field.
	PIO_IDR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_IDR_P23_Msk = 0x800000
	// Bit P23.
	PIO_IDR_P23 = 0x800000
	// Position of P24 field.
	PIO_IDR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_IDR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_IDR_P24 = 0x1000000
	// Position of P25 field.
	PIO_IDR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_IDR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_IDR_P25 = 0x2000000
	// Position of P26 field.
	PIO_IDR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_IDR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_IDR_P26 = 0x4000000
	// Position of P27 field.
	PIO_IDR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_IDR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_IDR_P27 = 0x8000000
	// Position of P28 field.
	PIO_IDR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_IDR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_IDR_P28 = 0x10000000
	// Position of P29 field.
	PIO_IDR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_IDR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_IDR_P29 = 0x20000000
	// Position of P30 field.
	PIO_IDR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_IDR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_IDR_P30 = 0x40000000
	// Position of P31 field.
	PIO_IDR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_IDR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_IDR_P31 = 0x80000000

	// IMR: Interrupt Mask Register
	// Position of P0 field.
	PIO_IMR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_IMR_P0_Msk = 0x1
	// Bit P0.
	PIO_IMR_P0 = 0x1
	// Position of P1 field.
	PIO_IMR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_IMR_P1_Msk = 0x2
	// Bit P1.
	PIO_IMR_P1 = 0x2
	// Position of P2 field.
	PIO_IMR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_IMR_P2_Msk = 0x4
	// Bit P2.
	PIO_IMR_P2 = 0x4
	// Position of P3 field.
	PIO_IMR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_IMR_P3_Msk = 0x8
	// Bit P3.
	PIO_IMR_P3 = 0x8
	// Position of P4 field.
	PIO_IMR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_IMR_P4_Msk = 0x10
	// Bit P4.
	PIO_IMR_P4 = 0x10
	// Position of P5 field.
	PIO_IMR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_IMR_P5_Msk = 0x20
	// Bit P5.
	PIO_IMR_P5 = 0x20
	// Position of P6 field.
	PIO_IMR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_IMR_P6_Msk = 0x40
	// Bit P6.
	PIO_IMR_P6 = 0x40
	// Position of P7 field.
	PIO_IMR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_IMR_P7_Msk = 0x80
	// Bit P7.
	PIO_IMR_P7 = 0x80
	// Position of P8 field.
	PIO_IMR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_IMR_P8_Msk = 0x100
	// Bit P8.
	PIO_IMR_P8 = 0x100
	// Position of P9 field.
	PIO_IMR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_IMR_P9_Msk = 0x200
	// Bit P9.
	PIO_IMR_P9 = 0x200
	// Position of P10 field.
	PIO_IMR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_IMR_P10_Msk = 0x400
	// Bit P10.
	PIO_IMR_P10 = 0x400
	// Position of P11 field.
	PIO_IMR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_IMR_P11_Msk = 0x800
	// Bit P11.
	PIO_IMR_P11 = 0x800
	// Position of P12 field.
	PIO_IMR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_IMR_P12_Msk = 0x1000
	// Bit P12.
	PIO_IMR_P12 = 0x1000
	// Position of P13 field.
	PIO_IMR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_IMR_P13_Msk = 0x2000
	// Bit P13.
	PIO_IMR_P13 = 0x2000
	// Position of P14 field.
	PIO_IMR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_IMR_P14_Msk = 0x4000
	// Bit P14.
	PIO_IMR_P14 = 0x4000
	// Position of P15 field.
	PIO_IMR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_IMR_P15_Msk = 0x8000
	// Bit P15.
	PIO_IMR_P15 = 0x8000
	// Position of P16 field.
	PIO_IMR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_IMR_P16_Msk = 0x10000
	// Bit P16.
	PIO_IMR_P16 = 0x10000
	// Position of P17 field.
	PIO_IMR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_IMR_P17_Msk = 0x20000
	// Bit P17.
	PIO_IMR_P17 = 0x20000
	// Position of P18 field.
	PIO_IMR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_IMR_P18_Msk = 0x40000
	// Bit P18.
	PIO_IMR_P18 = 0x40000
	// Position of P19 field.
	PIO_IMR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_IMR_P19_Msk = 0x80000
	// Bit P19.
	PIO_IMR_P19 = 0x80000
	// Position of P20 field.
	PIO_IMR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_IMR_P20_Msk = 0x100000
	// Bit P20.
	PIO_IMR_P20 = 0x100000
	// Position of P21 field.
	PIO_IMR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_IMR_P21_Msk = 0x200000
	// Bit P21.
	PIO_IMR_P21 = 0x200000
	// Position of P22 field.
	PIO_IMR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_IMR_P22_Msk = 0x400000
	// Bit P22.
	PIO_IMR_P22 = 0x400000
	// Position of P23 field.
	PIO_IMR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_IMR_P23_Msk = 0x800000
	// Bit P23.
	PIO_IMR_P23 = 0x800000
	// Position of P24 field.
	PIO_IMR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_IMR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_IMR_P24 = 0x1000000
	// Position of P25 field.
	PIO_IMR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_IMR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_IMR_P25 = 0x2000000
	// Position of P26 field.
	PIO_IMR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_IMR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_IMR_P26 = 0x4000000
	// Position of P27 field.
	PIO_IMR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_IMR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_IMR_P27 = 0x8000000
	// Position of P28 field.
	PIO_IMR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_IMR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_IMR_P28 = 0x10000000
	// Position of P29 field.
	PIO_IMR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_IMR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_IMR_P29 = 0x20000000
	// Position of P30 field.
	PIO_IMR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_IMR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_IMR_P30 = 0x40000000
	// Position of P31 field.
	PIO_IMR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_IMR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_IMR_P31 = 0x80000000

	// ISR: Interrupt Status Register
	// Position of P0 field.
	PIO_ISR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_ISR_P0_Msk = 0x1
	// Bit P0.
	PIO_ISR_P0 = 0x1
	// Position of P1 field.
	PIO_ISR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_ISR_P1_Msk = 0x2
	// Bit P1.
	PIO_ISR_P1 = 0x2
	// Position of P2 field.
	PIO_ISR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_ISR_P2_Msk = 0x4
	// Bit P2.
	PIO_ISR_P2 = 0x4
	// Position of P3 field.
	PIO_ISR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_ISR_P3_Msk = 0x8
	// Bit P3.
	PIO_ISR_P3 = 0x8
	// Position of P4 field.
	PIO_ISR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_ISR_P4_Msk = 0x10
	// Bit P4.
	PIO_ISR_P4 = 0x10
	// Position of P5 field.
	PIO_ISR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_ISR_P5_Msk = 0x20
	// Bit P5.
	PIO_ISR_P5 = 0x20
	// Position of P6 field.
	PIO_ISR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_ISR_P6_Msk = 0x40
	// Bit P6.
	PIO_ISR_P6 = 0x40
	// Position of P7 field.
	PIO_ISR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_ISR_P7_Msk = 0x80
	// Bit P7.
	PIO_ISR_P7 = 0x80
	// Position of P8 field.
	PIO_ISR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_ISR_P8_Msk = 0x100
	// Bit P8.
	PIO_ISR_P8 = 0x100
	// Position of P9 field.
	PIO_ISR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_ISR_P9_Msk = 0x200
	// Bit P9.
	PIO_ISR_P9 = 0x200
	// Position of P10 field.
	PIO_ISR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_ISR_P10_Msk = 0x400
	// Bit P10.
	PIO_ISR_P10 = 0x400
	// Position of P11 field.
	PIO_ISR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_ISR_P11_Msk = 0x800
	// Bit P11.
	PIO_ISR_P11 = 0x800
	// Position of P12 field.
	PIO_ISR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_ISR_P12_Msk = 0x1000
	// Bit P12.
	PIO_ISR_P12 = 0x1000
	// Position of P13 field.
	PIO_ISR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_ISR_P13_Msk = 0x2000
	// Bit P13.
	PIO_ISR_P13 = 0x2000
	// Position of P14 field.
	PIO_ISR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_ISR_P14_Msk = 0x4000
	// Bit P14.
	PIO_ISR_P14 = 0x4000
	// Position of P15 field.
	PIO_ISR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_ISR_P15_Msk = 0x8000
	// Bit P15.
	PIO_ISR_P15 = 0x8000
	// Position of P16 field.
	PIO_ISR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_ISR_P16_Msk = 0x10000
	// Bit P16.
	PIO_ISR_P16 = 0x10000
	// Position of P17 field.
	PIO_ISR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_ISR_P17_Msk = 0x20000
	// Bit P17.
	PIO_ISR_P17 = 0x20000
	// Position of P18 field.
	PIO_ISR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_ISR_P18_Msk = 0x40000
	// Bit P18.
	PIO_ISR_P18 = 0x40000
	// Position of P19 field.
	PIO_ISR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_ISR_P19_Msk = 0x80000
	// Bit P19.
	PIO_ISR_P19 = 0x80000
	// Position of P20 field.
	PIO_ISR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_ISR_P20_Msk = 0x100000
	// Bit P20.
	PIO_ISR_P20 = 0x100000
	// Position of P21 field.
	PIO_ISR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_ISR_P21_Msk = 0x200000
	// Bit P21.
	PIO_ISR_P21 = 0x200000
	// Position of P22 field.
	PIO_ISR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_ISR_P22_Msk = 0x400000
	// Bit P22.
	PIO_ISR_P22 = 0x400000
	// Position of P23 field.
	PIO_ISR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_ISR_P23_Msk = 0x800000
	// Bit P23.
	PIO_ISR_P23 = 0x800000
	// Position of P24 field.
	PIO_ISR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_ISR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_ISR_P24 = 0x1000000
	// Position of P25 field.
	PIO_ISR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_ISR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_ISR_P25 = 0x2000000
	// Position of P26 field.
	PIO_ISR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_ISR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_ISR_P26 = 0x4000000
	// Position of P27 field.
	PIO_ISR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_ISR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_ISR_P27 = 0x8000000
	// Position of P28 field.
	PIO_ISR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_ISR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_ISR_P28 = 0x10000000
	// Position of P29 field.
	PIO_ISR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_ISR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_ISR_P29 = 0x20000000
	// Position of P30 field.
	PIO_ISR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_ISR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_ISR_P30 = 0x40000000
	// Position of P31 field.
	PIO_ISR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_ISR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_ISR_P31 = 0x80000000

	// MDER: Multi-driver Enable Register
	// Position of P0 field.
	PIO_MDER_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_MDER_P0_Msk = 0x1
	// Bit P0.
	PIO_MDER_P0 = 0x1
	// Position of P1 field.
	PIO_MDER_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_MDER_P1_Msk = 0x2
	// Bit P1.
	PIO_MDER_P1 = 0x2
	// Position of P2 field.
	PIO_MDER_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_MDER_P2_Msk = 0x4
	// Bit P2.
	PIO_MDER_P2 = 0x4
	// Position of P3 field.
	PIO_MDER_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_MDER_P3_Msk = 0x8
	// Bit P3.
	PIO_MDER_P3 = 0x8
	// Position of P4 field.
	PIO_MDER_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_MDER_P4_Msk = 0x10
	// Bit P4.
	PIO_MDER_P4 = 0x10
	// Position of P5 field.
	PIO_MDER_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_MDER_P5_Msk = 0x20
	// Bit P5.
	PIO_MDER_P5 = 0x20
	// Position of P6 field.
	PIO_MDER_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_MDER_P6_Msk = 0x40
	// Bit P6.
	PIO_MDER_P6 = 0x40
	// Position of P7 field.
	PIO_MDER_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_MDER_P7_Msk = 0x80
	// Bit P7.
	PIO_MDER_P7 = 0x80
	// Position of P8 field.
	PIO_MDER_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_MDER_P8_Msk = 0x100
	// Bit P8.
	PIO_MDER_P8 = 0x100
	// Position of P9 field.
	PIO_MDER_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_MDER_P9_Msk = 0x200
	// Bit P9.
	PIO_MDER_P9 = 0x200
	// Position of P10 field.
	PIO_MDER_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_MDER_P10_Msk = 0x400
	// Bit P10.
	PIO_MDER_P10 = 0x400
	// Position of P11 field.
	PIO_MDER_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_MDER_P11_Msk = 0x800
	// Bit P11.
	PIO_MDER_P11 = 0x800
	// Position of P12 field.
	PIO_MDER_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_MDER_P12_Msk = 0x1000
	// Bit P12.
	PIO_MDER_P12 = 0x1000
	// Position of P13 field.
	PIO_MDER_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_MDER_P13_Msk = 0x2000
	// Bit P13.
	PIO_MDER_P13 = 0x2000
	// Position of P14 field.
	PIO_MDER_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_MDER_P14_Msk = 0x4000
	// Bit P14.
	PIO_MDER_P14 = 0x4000
	// Position of P15 field.
	PIO_MDER_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_MDER_P15_Msk = 0x8000
	// Bit P15.
	PIO_MDER_P15 = 0x8000
	// Position of P16 field.
	PIO_MDER_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_MDER_P16_Msk = 0x10000
	// Bit P16.
	PIO_MDER_P16 = 0x10000
	// Position of P17 field.
	PIO_MDER_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_MDER_P17_Msk = 0x20000
	// Bit P17.
	PIO_MDER_P17 = 0x20000
	// Position of P18 field.
	PIO_MDER_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_MDER_P18_Msk = 0x40000
	// Bit P18.
	PIO_MDER_P18 = 0x40000
	// Position of P19 field.
	PIO_MDER_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_MDER_P19_Msk = 0x80000
	// Bit P19.
	PIO_MDER_P19 = 0x80000
	// Position of P20 field.
	PIO_MDER_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_MDER_P20_Msk = 0x100000
	// Bit P20.
	PIO_MDER_P20 = 0x100000
	// Position of P21 field.
	PIO_MDER_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_MDER_P21_Msk = 0x200000
	// Bit P21.
	PIO_MDER_P21 = 0x200000
	// Position of P22 field.
	PIO_MDER_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_MDER_P22_Msk = 0x400000
	// Bit P22.
	PIO_MDER_P22 = 0x400000
	// Position of P23 field.
	PIO_MDER_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_MDER_P23_Msk = 0x800000
	// Bit P23.
	PIO_MDER_P23 = 0x800000
	// Position of P24 field.
	PIO_MDER_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_MDER_P24_Msk = 0x1000000
	// Bit P24.
	PIO_MDER_P24 = 0x1000000
	// Position of P25 field.
	PIO_MDER_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_MDER_P25_Msk = 0x2000000
	// Bit P25.
	PIO_MDER_P25 = 0x2000000
	// Position of P26 field.
	PIO_MDER_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_MDER_P26_Msk = 0x4000000
	// Bit P26.
	PIO_MDER_P26 = 0x4000000
	// Position of P27 field.
	PIO_MDER_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_MDER_P27_Msk = 0x8000000
	// Bit P27.
	PIO_MDER_P27 = 0x8000000
	// Position of P28 field.
	PIO_MDER_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_MDER_P28_Msk = 0x10000000
	// Bit P28.
	PIO_MDER_P28 = 0x10000000
	// Position of P29 field.
	PIO_MDER_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_MDER_P29_Msk = 0x20000000
	// Bit P29.
	PIO_MDER_P29 = 0x20000000
	// Position of P30 field.
	PIO_MDER_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_MDER_P30_Msk = 0x40000000
	// Bit P30.
	PIO_MDER_P30 = 0x40000000
	// Position of P31 field.
	PIO_MDER_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_MDER_P31_Msk = 0x80000000
	// Bit P31.
	PIO_MDER_P31 = 0x80000000

	// MDDR: Multi-driver Disable Register
	// Position of P0 field.
	PIO_MDDR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_MDDR_P0_Msk = 0x1
	// Bit P0.
	PIO_MDDR_P0 = 0x1
	// Position of P1 field.
	PIO_MDDR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_MDDR_P1_Msk = 0x2
	// Bit P1.
	PIO_MDDR_P1 = 0x2
	// Position of P2 field.
	PIO_MDDR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_MDDR_P2_Msk = 0x4
	// Bit P2.
	PIO_MDDR_P2 = 0x4
	// Position of P3 field.
	PIO_MDDR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_MDDR_P3_Msk = 0x8
	// Bit P3.
	PIO_MDDR_P3 = 0x8
	// Position of P4 field.
	PIO_MDDR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_MDDR_P4_Msk = 0x10
	// Bit P4.
	PIO_MDDR_P4 = 0x10
	// Position of P5 field.
	PIO_MDDR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_MDDR_P5_Msk = 0x20
	// Bit P5.
	PIO_MDDR_P5 = 0x20
	// Position of P6 field.
	PIO_MDDR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_MDDR_P6_Msk = 0x40
	// Bit P6.
	PIO_MDDR_P6 = 0x40
	// Position of P7 field.
	PIO_MDDR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_MDDR_P7_Msk = 0x80
	// Bit P7.
	PIO_MDDR_P7 = 0x80
	// Position of P8 field.
	PIO_MDDR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_MDDR_P8_Msk = 0x100
	// Bit P8.
	PIO_MDDR_P8 = 0x100
	// Position of P9 field.
	PIO_MDDR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_MDDR_P9_Msk = 0x200
	// Bit P9.
	PIO_MDDR_P9 = 0x200
	// Position of P10 field.
	PIO_MDDR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_MDDR_P10_Msk = 0x400
	// Bit P10.
	PIO_MDDR_P10 = 0x400
	// Position of P11 field.
	PIO_MDDR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_MDDR_P11_Msk = 0x800
	// Bit P11.
	PIO_MDDR_P11 = 0x800
	// Position of P12 field.
	PIO_MDDR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_MDDR_P12_Msk = 0x1000
	// Bit P12.
	PIO_MDDR_P12 = 0x1000
	// Position of P13 field.
	PIO_MDDR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_MDDR_P13_Msk = 0x2000
	// Bit P13.
	PIO_MDDR_P13 = 0x2000
	// Position of P14 field.
	PIO_MDDR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_MDDR_P14_Msk = 0x4000
	// Bit P14.
	PIO_MDDR_P14 = 0x4000
	// Position of P15 field.
	PIO_MDDR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_MDDR_P15_Msk = 0x8000
	// Bit P15.
	PIO_MDDR_P15 = 0x8000
	// Position of P16 field.
	PIO_MDDR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_MDDR_P16_Msk = 0x10000
	// Bit P16.
	PIO_MDDR_P16 = 0x10000
	// Position of P17 field.
	PIO_MDDR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_MDDR_P17_Msk = 0x20000
	// Bit P17.
	PIO_MDDR_P17 = 0x20000
	// Position of P18 field.
	PIO_MDDR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_MDDR_P18_Msk = 0x40000
	// Bit P18.
	PIO_MDDR_P18 = 0x40000
	// Position of P19 field.
	PIO_MDDR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_MDDR_P19_Msk = 0x80000
	// Bit P19.
	PIO_MDDR_P19 = 0x80000
	// Position of P20 field.
	PIO_MDDR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_MDDR_P20_Msk = 0x100000
	// Bit P20.
	PIO_MDDR_P20 = 0x100000
	// Position of P21 field.
	PIO_MDDR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_MDDR_P21_Msk = 0x200000
	// Bit P21.
	PIO_MDDR_P21 = 0x200000
	// Position of P22 field.
	PIO_MDDR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_MDDR_P22_Msk = 0x400000
	// Bit P22.
	PIO_MDDR_P22 = 0x400000
	// Position of P23 field.
	PIO_MDDR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_MDDR_P23_Msk = 0x800000
	// Bit P23.
	PIO_MDDR_P23 = 0x800000
	// Position of P24 field.
	PIO_MDDR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_MDDR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_MDDR_P24 = 0x1000000
	// Position of P25 field.
	PIO_MDDR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_MDDR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_MDDR_P25 = 0x2000000
	// Position of P26 field.
	PIO_MDDR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_MDDR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_MDDR_P26 = 0x4000000
	// Position of P27 field.
	PIO_MDDR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_MDDR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_MDDR_P27 = 0x8000000
	// Position of P28 field.
	PIO_MDDR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_MDDR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_MDDR_P28 = 0x10000000
	// Position of P29 field.
	PIO_MDDR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_MDDR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_MDDR_P29 = 0x20000000
	// Position of P30 field.
	PIO_MDDR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_MDDR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_MDDR_P30 = 0x40000000
	// Position of P31 field.
	PIO_MDDR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_MDDR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_MDDR_P31 = 0x80000000

	// MDSR: Multi-driver Status Register
	// Position of P0 field.
	PIO_MDSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_MDSR_P0_Msk = 0x1
	// Bit P0.
	PIO_MDSR_P0 = 0x1
	// Position of P1 field.
	PIO_MDSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_MDSR_P1_Msk = 0x2
	// Bit P1.
	PIO_MDSR_P1 = 0x2
	// Position of P2 field.
	PIO_MDSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_MDSR_P2_Msk = 0x4
	// Bit P2.
	PIO_MDSR_P2 = 0x4
	// Position of P3 field.
	PIO_MDSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_MDSR_P3_Msk = 0x8
	// Bit P3.
	PIO_MDSR_P3 = 0x8
	// Position of P4 field.
	PIO_MDSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_MDSR_P4_Msk = 0x10
	// Bit P4.
	PIO_MDSR_P4 = 0x10
	// Position of P5 field.
	PIO_MDSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_MDSR_P5_Msk = 0x20
	// Bit P5.
	PIO_MDSR_P5 = 0x20
	// Position of P6 field.
	PIO_MDSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_MDSR_P6_Msk = 0x40
	// Bit P6.
	PIO_MDSR_P6 = 0x40
	// Position of P7 field.
	PIO_MDSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_MDSR_P7_Msk = 0x80
	// Bit P7.
	PIO_MDSR_P7 = 0x80
	// Position of P8 field.
	PIO_MDSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_MDSR_P8_Msk = 0x100
	// Bit P8.
	PIO_MDSR_P8 = 0x100
	// Position of P9 field.
	PIO_MDSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_MDSR_P9_Msk = 0x200
	// Bit P9.
	PIO_MDSR_P9 = 0x200
	// Position of P10 field.
	PIO_MDSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_MDSR_P10_Msk = 0x400
	// Bit P10.
	PIO_MDSR_P10 = 0x400
	// Position of P11 field.
	PIO_MDSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_MDSR_P11_Msk = 0x800
	// Bit P11.
	PIO_MDSR_P11 = 0x800
	// Position of P12 field.
	PIO_MDSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_MDSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_MDSR_P12 = 0x1000
	// Position of P13 field.
	PIO_MDSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_MDSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_MDSR_P13 = 0x2000
	// Position of P14 field.
	PIO_MDSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_MDSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_MDSR_P14 = 0x4000
	// Position of P15 field.
	PIO_MDSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_MDSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_MDSR_P15 = 0x8000
	// Position of P16 field.
	PIO_MDSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_MDSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_MDSR_P16 = 0x10000
	// Position of P17 field.
	PIO_MDSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_MDSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_MDSR_P17 = 0x20000
	// Position of P18 field.
	PIO_MDSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_MDSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_MDSR_P18 = 0x40000
	// Position of P19 field.
	PIO_MDSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_MDSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_MDSR_P19 = 0x80000
	// Position of P20 field.
	PIO_MDSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_MDSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_MDSR_P20 = 0x100000
	// Position of P21 field.
	PIO_MDSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_MDSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_MDSR_P21 = 0x200000
	// Position of P22 field.
	PIO_MDSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_MDSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_MDSR_P22 = 0x400000
	// Position of P23 field.
	PIO_MDSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_MDSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_MDSR_P23 = 0x800000
	// Position of P24 field.
	PIO_MDSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_MDSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_MDSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_MDSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_MDSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_MDSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_MDSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_MDSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_MDSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_MDSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_MDSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_MDSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_MDSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_MDSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_MDSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_MDSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_MDSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_MDSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_MDSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_MDSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_MDSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_MDSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_MDSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_MDSR_P31 = 0x80000000

	// PUDR: Pull-up Disable Register
	// Position of P0 field.
	PIO_PUDR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_PUDR_P0_Msk = 0x1
	// Bit P0.
	PIO_PUDR_P0 = 0x1
	// Position of P1 field.
	PIO_PUDR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_PUDR_P1_Msk = 0x2
	// Bit P1.
	PIO_PUDR_P1 = 0x2
	// Position of P2 field.
	PIO_PUDR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_PUDR_P2_Msk = 0x4
	// Bit P2.
	PIO_PUDR_P2 = 0x4
	// Position of P3 field.
	PIO_PUDR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_PUDR_P3_Msk = 0x8
	// Bit P3.
	PIO_PUDR_P3 = 0x8
	// Position of P4 field.
	PIO_PUDR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_PUDR_P4_Msk = 0x10
	// Bit P4.
	PIO_PUDR_P4 = 0x10
	// Position of P5 field.
	PIO_PUDR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_PUDR_P5_Msk = 0x20
	// Bit P5.
	PIO_PUDR_P5 = 0x20
	// Position of P6 field.
	PIO_PUDR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_PUDR_P6_Msk = 0x40
	// Bit P6.
	PIO_PUDR_P6 = 0x40
	// Position of P7 field.
	PIO_PUDR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_PUDR_P7_Msk = 0x80
	// Bit P7.
	PIO_PUDR_P7 = 0x80
	// Position of P8 field.
	PIO_PUDR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_PUDR_P8_Msk = 0x100
	// Bit P8.
	PIO_PUDR_P8 = 0x100
	// Position of P9 field.
	PIO_PUDR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_PUDR_P9_Msk = 0x200
	// Bit P9.
	PIO_PUDR_P9 = 0x200
	// Position of P10 field.
	PIO_PUDR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_PUDR_P10_Msk = 0x400
	// Bit P10.
	PIO_PUDR_P10 = 0x400
	// Position of P11 field.
	PIO_PUDR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_PUDR_P11_Msk = 0x800
	// Bit P11.
	PIO_PUDR_P11 = 0x800
	// Position of P12 field.
	PIO_PUDR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_PUDR_P12_Msk = 0x1000
	// Bit P12.
	PIO_PUDR_P12 = 0x1000
	// Position of P13 field.
	PIO_PUDR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_PUDR_P13_Msk = 0x2000
	// Bit P13.
	PIO_PUDR_P13 = 0x2000
	// Position of P14 field.
	PIO_PUDR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_PUDR_P14_Msk = 0x4000
	// Bit P14.
	PIO_PUDR_P14 = 0x4000
	// Position of P15 field.
	PIO_PUDR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_PUDR_P15_Msk = 0x8000
	// Bit P15.
	PIO_PUDR_P15 = 0x8000
	// Position of P16 field.
	PIO_PUDR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_PUDR_P16_Msk = 0x10000
	// Bit P16.
	PIO_PUDR_P16 = 0x10000
	// Position of P17 field.
	PIO_PUDR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_PUDR_P17_Msk = 0x20000
	// Bit P17.
	PIO_PUDR_P17 = 0x20000
	// Position of P18 field.
	PIO_PUDR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_PUDR_P18_Msk = 0x40000
	// Bit P18.
	PIO_PUDR_P18 = 0x40000
	// Position of P19 field.
	PIO_PUDR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_PUDR_P19_Msk = 0x80000
	// Bit P19.
	PIO_PUDR_P19 = 0x80000
	// Position of P20 field.
	PIO_PUDR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_PUDR_P20_Msk = 0x100000
	// Bit P20.
	PIO_PUDR_P20 = 0x100000
	// Position of P21 field.
	PIO_PUDR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_PUDR_P21_Msk = 0x200000
	// Bit P21.
	PIO_PUDR_P21 = 0x200000
	// Position of P22 field.
	PIO_PUDR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_PUDR_P22_Msk = 0x400000
	// Bit P22.
	PIO_PUDR_P22 = 0x400000
	// Position of P23 field.
	PIO_PUDR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_PUDR_P23_Msk = 0x800000
	// Bit P23.
	PIO_PUDR_P23 = 0x800000
	// Position of P24 field.
	PIO_PUDR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_PUDR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_PUDR_P24 = 0x1000000
	// Position of P25 field.
	PIO_PUDR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_PUDR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_PUDR_P25 = 0x2000000
	// Position of P26 field.
	PIO_PUDR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_PUDR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_PUDR_P26 = 0x4000000
	// Position of P27 field.
	PIO_PUDR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_PUDR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_PUDR_P27 = 0x8000000
	// Position of P28 field.
	PIO_PUDR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_PUDR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_PUDR_P28 = 0x10000000
	// Position of P29 field.
	PIO_PUDR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_PUDR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_PUDR_P29 = 0x20000000
	// Position of P30 field.
	PIO_PUDR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_PUDR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_PUDR_P30 = 0x40000000
	// Position of P31 field.
	PIO_PUDR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_PUDR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_PUDR_P31 = 0x80000000

	// PUER: Pull-up Enable Register
	// Position of P0 field.
	PIO_PUER_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_PUER_P0_Msk = 0x1
	// Bit P0.
	PIO_PUER_P0 = 0x1
	// Position of P1 field.
	PIO_PUER_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_PUER_P1_Msk = 0x2
	// Bit P1.
	PIO_PUER_P1 = 0x2
	// Position of P2 field.
	PIO_PUER_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_PUER_P2_Msk = 0x4
	// Bit P2.
	PIO_PUER_P2 = 0x4
	// Position of P3 field.
	PIO_PUER_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_PUER_P3_Msk = 0x8
	// Bit P3.
	PIO_PUER_P3 = 0x8
	// Position of P4 field.
	PIO_PUER_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_PUER_P4_Msk = 0x10
	// Bit P4.
	PIO_PUER_P4 = 0x10
	// Position of P5 field.
	PIO_PUER_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_PUER_P5_Msk = 0x20
	// Bit P5.
	PIO_PUER_P5 = 0x20
	// Position of P6 field.
	PIO_PUER_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_PUER_P6_Msk = 0x40
	// Bit P6.
	PIO_PUER_P6 = 0x40
	// Position of P7 field.
	PIO_PUER_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_PUER_P7_Msk = 0x80
	// Bit P7.
	PIO_PUER_P7 = 0x80
	// Position of P8 field.
	PIO_PUER_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_PUER_P8_Msk = 0x100
	// Bit P8.
	PIO_PUER_P8 = 0x100
	// Position of P9 field.
	PIO_PUER_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_PUER_P9_Msk = 0x200
	// Bit P9.
	PIO_PUER_P9 = 0x200
	// Position of P10 field.
	PIO_PUER_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_PUER_P10_Msk = 0x400
	// Bit P10.
	PIO_PUER_P10 = 0x400
	// Position of P11 field.
	PIO_PUER_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_PUER_P11_Msk = 0x800
	// Bit P11.
	PIO_PUER_P11 = 0x800
	// Position of P12 field.
	PIO_PUER_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_PUER_P12_Msk = 0x1000
	// Bit P12.
	PIO_PUER_P12 = 0x1000
	// Position of P13 field.
	PIO_PUER_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_PUER_P13_Msk = 0x2000
	// Bit P13.
	PIO_PUER_P13 = 0x2000
	// Position of P14 field.
	PIO_PUER_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_PUER_P14_Msk = 0x4000
	// Bit P14.
	PIO_PUER_P14 = 0x4000
	// Position of P15 field.
	PIO_PUER_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_PUER_P15_Msk = 0x8000
	// Bit P15.
	PIO_PUER_P15 = 0x8000
	// Position of P16 field.
	PIO_PUER_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_PUER_P16_Msk = 0x10000
	// Bit P16.
	PIO_PUER_P16 = 0x10000
	// Position of P17 field.
	PIO_PUER_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_PUER_P17_Msk = 0x20000
	// Bit P17.
	PIO_PUER_P17 = 0x20000
	// Position of P18 field.
	PIO_PUER_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_PUER_P18_Msk = 0x40000
	// Bit P18.
	PIO_PUER_P18 = 0x40000
	// Position of P19 field.
	PIO_PUER_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_PUER_P19_Msk = 0x80000
	// Bit P19.
	PIO_PUER_P19 = 0x80000
	// Position of P20 field.
	PIO_PUER_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_PUER_P20_Msk = 0x100000
	// Bit P20.
	PIO_PUER_P20 = 0x100000
	// Position of P21 field.
	PIO_PUER_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_PUER_P21_Msk = 0x200000
	// Bit P21.
	PIO_PUER_P21 = 0x200000
	// Position of P22 field.
	PIO_PUER_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_PUER_P22_Msk = 0x400000
	// Bit P22.
	PIO_PUER_P22 = 0x400000
	// Position of P23 field.
	PIO_PUER_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_PUER_P23_Msk = 0x800000
	// Bit P23.
	PIO_PUER_P23 = 0x800000
	// Position of P24 field.
	PIO_PUER_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_PUER_P24_Msk = 0x1000000
	// Bit P24.
	PIO_PUER_P24 = 0x1000000
	// Position of P25 field.
	PIO_PUER_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_PUER_P25_Msk = 0x2000000
	// Bit P25.
	PIO_PUER_P25 = 0x2000000
	// Position of P26 field.
	PIO_PUER_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_PUER_P26_Msk = 0x4000000
	// Bit P26.
	PIO_PUER_P26 = 0x4000000
	// Position of P27 field.
	PIO_PUER_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_PUER_P27_Msk = 0x8000000
	// Bit P27.
	PIO_PUER_P27 = 0x8000000
	// Position of P28 field.
	PIO_PUER_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_PUER_P28_Msk = 0x10000000
	// Bit P28.
	PIO_PUER_P28 = 0x10000000
	// Position of P29 field.
	PIO_PUER_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_PUER_P29_Msk = 0x20000000
	// Bit P29.
	PIO_PUER_P29 = 0x20000000
	// Position of P30 field.
	PIO_PUER_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_PUER_P30_Msk = 0x40000000
	// Bit P30.
	PIO_PUER_P30 = 0x40000000
	// Position of P31 field.
	PIO_PUER_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_PUER_P31_Msk = 0x80000000
	// Bit P31.
	PIO_PUER_P31 = 0x80000000

	// PUSR: Pad Pull-up Status Register
	// Position of P0 field.
	PIO_PUSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_PUSR_P0_Msk = 0x1
	// Bit P0.
	PIO_PUSR_P0 = 0x1
	// Position of P1 field.
	PIO_PUSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_PUSR_P1_Msk = 0x2
	// Bit P1.
	PIO_PUSR_P1 = 0x2
	// Position of P2 field.
	PIO_PUSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_PUSR_P2_Msk = 0x4
	// Bit P2.
	PIO_PUSR_P2 = 0x4
	// Position of P3 field.
	PIO_PUSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_PUSR_P3_Msk = 0x8
	// Bit P3.
	PIO_PUSR_P3 = 0x8
	// Position of P4 field.
	PIO_PUSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_PUSR_P4_Msk = 0x10
	// Bit P4.
	PIO_PUSR_P4 = 0x10
	// Position of P5 field.
	PIO_PUSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_PUSR_P5_Msk = 0x20
	// Bit P5.
	PIO_PUSR_P5 = 0x20
	// Position of P6 field.
	PIO_PUSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_PUSR_P6_Msk = 0x40
	// Bit P6.
	PIO_PUSR_P6 = 0x40
	// Position of P7 field.
	PIO_PUSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_PUSR_P7_Msk = 0x80
	// Bit P7.
	PIO_PUSR_P7 = 0x80
	// Position of P8 field.
	PIO_PUSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_PUSR_P8_Msk = 0x100
	// Bit P8.
	PIO_PUSR_P8 = 0x100
	// Position of P9 field.
	PIO_PUSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_PUSR_P9_Msk = 0x200
	// Bit P9.
	PIO_PUSR_P9 = 0x200
	// Position of P10 field.
	PIO_PUSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_PUSR_P10_Msk = 0x400
	// Bit P10.
	PIO_PUSR_P10 = 0x400
	// Position of P11 field.
	PIO_PUSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_PUSR_P11_Msk = 0x800
	// Bit P11.
	PIO_PUSR_P11 = 0x800
	// Position of P12 field.
	PIO_PUSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_PUSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_PUSR_P12 = 0x1000
	// Position of P13 field.
	PIO_PUSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_PUSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_PUSR_P13 = 0x2000
	// Position of P14 field.
	PIO_PUSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_PUSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_PUSR_P14 = 0x4000
	// Position of P15 field.
	PIO_PUSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_PUSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_PUSR_P15 = 0x8000
	// Position of P16 field.
	PIO_PUSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_PUSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_PUSR_P16 = 0x10000
	// Position of P17 field.
	PIO_PUSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_PUSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_PUSR_P17 = 0x20000
	// Position of P18 field.
	PIO_PUSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_PUSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_PUSR_P18 = 0x40000
	// Position of P19 field.
	PIO_PUSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_PUSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_PUSR_P19 = 0x80000
	// Position of P20 field.
	PIO_PUSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_PUSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_PUSR_P20 = 0x100000
	// Position of P21 field.
	PIO_PUSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_PUSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_PUSR_P21 = 0x200000
	// Position of P22 field.
	PIO_PUSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_PUSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_PUSR_P22 = 0x400000
	// Position of P23 field.
	PIO_PUSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_PUSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_PUSR_P23 = 0x800000
	// Position of P24 field.
	PIO_PUSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_PUSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_PUSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_PUSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_PUSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_PUSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_PUSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_PUSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_PUSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_PUSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_PUSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_PUSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_PUSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_PUSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_PUSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_PUSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_PUSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_PUSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_PUSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_PUSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_PUSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_PUSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_PUSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_PUSR_P31 = 0x80000000

	// ABSR: Peripheral AB Select Register
	// Position of P0 field.
	PIO_ABSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_ABSR_P0_Msk = 0x1
	// Bit P0.
	PIO_ABSR_P0 = 0x1
	// Position of P1 field.
	PIO_ABSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_ABSR_P1_Msk = 0x2
	// Bit P1.
	PIO_ABSR_P1 = 0x2
	// Position of P2 field.
	PIO_ABSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_ABSR_P2_Msk = 0x4
	// Bit P2.
	PIO_ABSR_P2 = 0x4
	// Position of P3 field.
	PIO_ABSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_ABSR_P3_Msk = 0x8
	// Bit P3.
	PIO_ABSR_P3 = 0x8
	// Position of P4 field.
	PIO_ABSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_ABSR_P4_Msk = 0x10
	// Bit P4.
	PIO_ABSR_P4 = 0x10
	// Position of P5 field.
	PIO_ABSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_ABSR_P5_Msk = 0x20
	// Bit P5.
	PIO_ABSR_P5 = 0x20
	// Position of P6 field.
	PIO_ABSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_ABSR_P6_Msk = 0x40
	// Bit P6.
	PIO_ABSR_P6 = 0x40
	// Position of P7 field.
	PIO_ABSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_ABSR_P7_Msk = 0x80
	// Bit P7.
	PIO_ABSR_P7 = 0x80
	// Position of P8 field.
	PIO_ABSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_ABSR_P8_Msk = 0x100
	// Bit P8.
	PIO_ABSR_P8 = 0x100
	// Position of P9 field.
	PIO_ABSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_ABSR_P9_Msk = 0x200
	// Bit P9.
	PIO_ABSR_P9 = 0x200
	// Position of P10 field.
	PIO_ABSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_ABSR_P10_Msk = 0x400
	// Bit P10.
	PIO_ABSR_P10 = 0x400
	// Position of P11 field.
	PIO_ABSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_ABSR_P11_Msk = 0x800
	// Bit P11.
	PIO_ABSR_P11 = 0x800
	// Position of P12 field.
	PIO_ABSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_ABSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_ABSR_P12 = 0x1000
	// Position of P13 field.
	PIO_ABSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_ABSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_ABSR_P13 = 0x2000
	// Position of P14 field.
	PIO_ABSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_ABSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_ABSR_P14 = 0x4000
	// Position of P15 field.
	PIO_ABSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_ABSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_ABSR_P15 = 0x8000
	// Position of P16 field.
	PIO_ABSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_ABSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_ABSR_P16 = 0x10000
	// Position of P17 field.
	PIO_ABSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_ABSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_ABSR_P17 = 0x20000
	// Position of P18 field.
	PIO_ABSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_ABSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_ABSR_P18 = 0x40000
	// Position of P19 field.
	PIO_ABSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_ABSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_ABSR_P19 = 0x80000
	// Position of P20 field.
	PIO_ABSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_ABSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_ABSR_P20 = 0x100000
	// Position of P21 field.
	PIO_ABSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_ABSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_ABSR_P21 = 0x200000
	// Position of P22 field.
	PIO_ABSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_ABSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_ABSR_P22 = 0x400000
	// Position of P23 field.
	PIO_ABSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_ABSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_ABSR_P23 = 0x800000
	// Position of P24 field.
	PIO_ABSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_ABSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_ABSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_ABSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_ABSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_ABSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_ABSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_ABSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_ABSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_ABSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_ABSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_ABSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_ABSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_ABSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_ABSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_ABSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_ABSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_ABSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_ABSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_ABSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_ABSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_ABSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_ABSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_ABSR_P31 = 0x80000000

	// SCIFSR: System Clock Glitch Input Filter Select Register
	// Position of P0 field.
	PIO_SCIFSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_SCIFSR_P0_Msk = 0x1
	// Bit P0.
	PIO_SCIFSR_P0 = 0x1
	// Position of P1 field.
	PIO_SCIFSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_SCIFSR_P1_Msk = 0x2
	// Bit P1.
	PIO_SCIFSR_P1 = 0x2
	// Position of P2 field.
	PIO_SCIFSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_SCIFSR_P2_Msk = 0x4
	// Bit P2.
	PIO_SCIFSR_P2 = 0x4
	// Position of P3 field.
	PIO_SCIFSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_SCIFSR_P3_Msk = 0x8
	// Bit P3.
	PIO_SCIFSR_P3 = 0x8
	// Position of P4 field.
	PIO_SCIFSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_SCIFSR_P4_Msk = 0x10
	// Bit P4.
	PIO_SCIFSR_P4 = 0x10
	// Position of P5 field.
	PIO_SCIFSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_SCIFSR_P5_Msk = 0x20
	// Bit P5.
	PIO_SCIFSR_P5 = 0x20
	// Position of P6 field.
	PIO_SCIFSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_SCIFSR_P6_Msk = 0x40
	// Bit P6.
	PIO_SCIFSR_P6 = 0x40
	// Position of P7 field.
	PIO_SCIFSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_SCIFSR_P7_Msk = 0x80
	// Bit P7.
	PIO_SCIFSR_P7 = 0x80
	// Position of P8 field.
	PIO_SCIFSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_SCIFSR_P8_Msk = 0x100
	// Bit P8.
	PIO_SCIFSR_P8 = 0x100
	// Position of P9 field.
	PIO_SCIFSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_SCIFSR_P9_Msk = 0x200
	// Bit P9.
	PIO_SCIFSR_P9 = 0x200
	// Position of P10 field.
	PIO_SCIFSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_SCIFSR_P10_Msk = 0x400
	// Bit P10.
	PIO_SCIFSR_P10 = 0x400
	// Position of P11 field.
	PIO_SCIFSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_SCIFSR_P11_Msk = 0x800
	// Bit P11.
	PIO_SCIFSR_P11 = 0x800
	// Position of P12 field.
	PIO_SCIFSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_SCIFSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_SCIFSR_P12 = 0x1000
	// Position of P13 field.
	PIO_SCIFSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_SCIFSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_SCIFSR_P13 = 0x2000
	// Position of P14 field.
	PIO_SCIFSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_SCIFSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_SCIFSR_P14 = 0x4000
	// Position of P15 field.
	PIO_SCIFSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_SCIFSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_SCIFSR_P15 = 0x8000
	// Position of P16 field.
	PIO_SCIFSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_SCIFSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_SCIFSR_P16 = 0x10000
	// Position of P17 field.
	PIO_SCIFSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_SCIFSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_SCIFSR_P17 = 0x20000
	// Position of P18 field.
	PIO_SCIFSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_SCIFSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_SCIFSR_P18 = 0x40000
	// Position of P19 field.
	PIO_SCIFSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_SCIFSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_SCIFSR_P19 = 0x80000
	// Position of P20 field.
	PIO_SCIFSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_SCIFSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_SCIFSR_P20 = 0x100000
	// Position of P21 field.
	PIO_SCIFSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_SCIFSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_SCIFSR_P21 = 0x200000
	// Position of P22 field.
	PIO_SCIFSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_SCIFSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_SCIFSR_P22 = 0x400000
	// Position of P23 field.
	PIO_SCIFSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_SCIFSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_SCIFSR_P23 = 0x800000
	// Position of P24 field.
	PIO_SCIFSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_SCIFSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_SCIFSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_SCIFSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_SCIFSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_SCIFSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_SCIFSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_SCIFSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_SCIFSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_SCIFSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_SCIFSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_SCIFSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_SCIFSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_SCIFSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_SCIFSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_SCIFSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_SCIFSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_SCIFSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_SCIFSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_SCIFSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_SCIFSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_SCIFSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_SCIFSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_SCIFSR_P31 = 0x80000000

	// DIFSR: Debouncing Input Filter Select Register
	// Position of P0 field.
	PIO_DIFSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_DIFSR_P0_Msk = 0x1
	// Bit P0.
	PIO_DIFSR_P0 = 0x1
	// Position of P1 field.
	PIO_DIFSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_DIFSR_P1_Msk = 0x2
	// Bit P1.
	PIO_DIFSR_P1 = 0x2
	// Position of P2 field.
	PIO_DIFSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_DIFSR_P2_Msk = 0x4
	// Bit P2.
	PIO_DIFSR_P2 = 0x4
	// Position of P3 field.
	PIO_DIFSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_DIFSR_P3_Msk = 0x8
	// Bit P3.
	PIO_DIFSR_P3 = 0x8
	// Position of P4 field.
	PIO_DIFSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_DIFSR_P4_Msk = 0x10
	// Bit P4.
	PIO_DIFSR_P4 = 0x10
	// Position of P5 field.
	PIO_DIFSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_DIFSR_P5_Msk = 0x20
	// Bit P5.
	PIO_DIFSR_P5 = 0x20
	// Position of P6 field.
	PIO_DIFSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_DIFSR_P6_Msk = 0x40
	// Bit P6.
	PIO_DIFSR_P6 = 0x40
	// Position of P7 field.
	PIO_DIFSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_DIFSR_P7_Msk = 0x80
	// Bit P7.
	PIO_DIFSR_P7 = 0x80
	// Position of P8 field.
	PIO_DIFSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_DIFSR_P8_Msk = 0x100
	// Bit P8.
	PIO_DIFSR_P8 = 0x100
	// Position of P9 field.
	PIO_DIFSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_DIFSR_P9_Msk = 0x200
	// Bit P9.
	PIO_DIFSR_P9 = 0x200
	// Position of P10 field.
	PIO_DIFSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_DIFSR_P10_Msk = 0x400
	// Bit P10.
	PIO_DIFSR_P10 = 0x400
	// Position of P11 field.
	PIO_DIFSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_DIFSR_P11_Msk = 0x800
	// Bit P11.
	PIO_DIFSR_P11 = 0x800
	// Position of P12 field.
	PIO_DIFSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_DIFSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_DIFSR_P12 = 0x1000
	// Position of P13 field.
	PIO_DIFSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_DIFSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_DIFSR_P13 = 0x2000
	// Position of P14 field.
	PIO_DIFSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_DIFSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_DIFSR_P14 = 0x4000
	// Position of P15 field.
	PIO_DIFSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_DIFSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_DIFSR_P15 = 0x8000
	// Position of P16 field.
	PIO_DIFSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_DIFSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_DIFSR_P16 = 0x10000
	// Position of P17 field.
	PIO_DIFSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_DIFSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_DIFSR_P17 = 0x20000
	// Position of P18 field.
	PIO_DIFSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_DIFSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_DIFSR_P18 = 0x40000
	// Position of P19 field.
	PIO_DIFSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_DIFSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_DIFSR_P19 = 0x80000
	// Position of P20 field.
	PIO_DIFSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_DIFSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_DIFSR_P20 = 0x100000
	// Position of P21 field.
	PIO_DIFSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_DIFSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_DIFSR_P21 = 0x200000
	// Position of P22 field.
	PIO_DIFSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_DIFSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_DIFSR_P22 = 0x400000
	// Position of P23 field.
	PIO_DIFSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_DIFSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_DIFSR_P23 = 0x800000
	// Position of P24 field.
	PIO_DIFSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_DIFSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_DIFSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_DIFSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_DIFSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_DIFSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_DIFSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_DIFSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_DIFSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_DIFSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_DIFSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_DIFSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_DIFSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_DIFSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_DIFSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_DIFSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_DIFSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_DIFSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_DIFSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_DIFSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_DIFSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_DIFSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_DIFSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_DIFSR_P31 = 0x80000000

	// IFDGSR: Glitch or Debouncing Input Filter Clock Selection Status Register
	// Position of P0 field.
	PIO_IFDGSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_IFDGSR_P0_Msk = 0x1
	// Bit P0.
	PIO_IFDGSR_P0 = 0x1
	// Position of P1 field.
	PIO_IFDGSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_IFDGSR_P1_Msk = 0x2
	// Bit P1.
	PIO_IFDGSR_P1 = 0x2
	// Position of P2 field.
	PIO_IFDGSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_IFDGSR_P2_Msk = 0x4
	// Bit P2.
	PIO_IFDGSR_P2 = 0x4
	// Position of P3 field.
	PIO_IFDGSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_IFDGSR_P3_Msk = 0x8
	// Bit P3.
	PIO_IFDGSR_P3 = 0x8
	// Position of P4 field.
	PIO_IFDGSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_IFDGSR_P4_Msk = 0x10
	// Bit P4.
	PIO_IFDGSR_P4 = 0x10
	// Position of P5 field.
	PIO_IFDGSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_IFDGSR_P5_Msk = 0x20
	// Bit P5.
	PIO_IFDGSR_P5 = 0x20
	// Position of P6 field.
	PIO_IFDGSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_IFDGSR_P6_Msk = 0x40
	// Bit P6.
	PIO_IFDGSR_P6 = 0x40
	// Position of P7 field.
	PIO_IFDGSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_IFDGSR_P7_Msk = 0x80
	// Bit P7.
	PIO_IFDGSR_P7 = 0x80
	// Position of P8 field.
	PIO_IFDGSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_IFDGSR_P8_Msk = 0x100
	// Bit P8.
	PIO_IFDGSR_P8 = 0x100
	// Position of P9 field.
	PIO_IFDGSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_IFDGSR_P9_Msk = 0x200
	// Bit P9.
	PIO_IFDGSR_P9 = 0x200
	// Position of P10 field.
	PIO_IFDGSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_IFDGSR_P10_Msk = 0x400
	// Bit P10.
	PIO_IFDGSR_P10 = 0x400
	// Position of P11 field.
	PIO_IFDGSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_IFDGSR_P11_Msk = 0x800
	// Bit P11.
	PIO_IFDGSR_P11 = 0x800
	// Position of P12 field.
	PIO_IFDGSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_IFDGSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_IFDGSR_P12 = 0x1000
	// Position of P13 field.
	PIO_IFDGSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_IFDGSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_IFDGSR_P13 = 0x2000
	// Position of P14 field.
	PIO_IFDGSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_IFDGSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_IFDGSR_P14 = 0x4000
	// Position of P15 field.
	PIO_IFDGSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_IFDGSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_IFDGSR_P15 = 0x8000
	// Position of P16 field.
	PIO_IFDGSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_IFDGSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_IFDGSR_P16 = 0x10000
	// Position of P17 field.
	PIO_IFDGSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_IFDGSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_IFDGSR_P17 = 0x20000
	// Position of P18 field.
	PIO_IFDGSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_IFDGSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_IFDGSR_P18 = 0x40000
	// Position of P19 field.
	PIO_IFDGSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_IFDGSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_IFDGSR_P19 = 0x80000
	// Position of P20 field.
	PIO_IFDGSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_IFDGSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_IFDGSR_P20 = 0x100000
	// Position of P21 field.
	PIO_IFDGSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_IFDGSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_IFDGSR_P21 = 0x200000
	// Position of P22 field.
	PIO_IFDGSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_IFDGSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_IFDGSR_P22 = 0x400000
	// Position of P23 field.
	PIO_IFDGSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_IFDGSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_IFDGSR_P23 = 0x800000
	// Position of P24 field.
	PIO_IFDGSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_IFDGSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_IFDGSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_IFDGSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_IFDGSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_IFDGSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_IFDGSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_IFDGSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_IFDGSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_IFDGSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_IFDGSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_IFDGSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_IFDGSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_IFDGSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_IFDGSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_IFDGSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_IFDGSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_IFDGSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_IFDGSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_IFDGSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_IFDGSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_IFDGSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_IFDGSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_IFDGSR_P31 = 0x80000000

	// SCDR: Slow Clock Divider Debouncing Register
	// Position of DIV field.
	PIO_SCDR_DIV_Pos = 0x0
	// Bit mask of DIV field.
	PIO_SCDR_DIV_Msk = 0x3fff

	// OWER: Output Write Enable
	// Position of P0 field.
	PIO_OWER_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_OWER_P0_Msk = 0x1
	// Bit P0.
	PIO_OWER_P0 = 0x1
	// Position of P1 field.
	PIO_OWER_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_OWER_P1_Msk = 0x2
	// Bit P1.
	PIO_OWER_P1 = 0x2
	// Position of P2 field.
	PIO_OWER_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_OWER_P2_Msk = 0x4
	// Bit P2.
	PIO_OWER_P2 = 0x4
	// Position of P3 field.
	PIO_OWER_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_OWER_P3_Msk = 0x8
	// Bit P3.
	PIO_OWER_P3 = 0x8
	// Position of P4 field.
	PIO_OWER_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_OWER_P4_Msk = 0x10
	// Bit P4.
	PIO_OWER_P4 = 0x10
	// Position of P5 field.
	PIO_OWER_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_OWER_P5_Msk = 0x20
	// Bit P5.
	PIO_OWER_P5 = 0x20
	// Position of P6 field.
	PIO_OWER_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_OWER_P6_Msk = 0x40
	// Bit P6.
	PIO_OWER_P6 = 0x40
	// Position of P7 field.
	PIO_OWER_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_OWER_P7_Msk = 0x80
	// Bit P7.
	PIO_OWER_P7 = 0x80
	// Position of P8 field.
	PIO_OWER_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_OWER_P8_Msk = 0x100
	// Bit P8.
	PIO_OWER_P8 = 0x100
	// Position of P9 field.
	PIO_OWER_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_OWER_P9_Msk = 0x200
	// Bit P9.
	PIO_OWER_P9 = 0x200
	// Position of P10 field.
	PIO_OWER_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_OWER_P10_Msk = 0x400
	// Bit P10.
	PIO_OWER_P10 = 0x400
	// Position of P11 field.
	PIO_OWER_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_OWER_P11_Msk = 0x800
	// Bit P11.
	PIO_OWER_P11 = 0x800
	// Position of P12 field.
	PIO_OWER_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_OWER_P12_Msk = 0x1000
	// Bit P12.
	PIO_OWER_P12 = 0x1000
	// Position of P13 field.
	PIO_OWER_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_OWER_P13_Msk = 0x2000
	// Bit P13.
	PIO_OWER_P13 = 0x2000
	// Position of P14 field.
	PIO_OWER_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_OWER_P14_Msk = 0x4000
	// Bit P14.
	PIO_OWER_P14 = 0x4000
	// Position of P15 field.
	PIO_OWER_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_OWER_P15_Msk = 0x8000
	// Bit P15.
	PIO_OWER_P15 = 0x8000
	// Position of P16 field.
	PIO_OWER_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_OWER_P16_Msk = 0x10000
	// Bit P16.
	PIO_OWER_P16 = 0x10000
	// Position of P17 field.
	PIO_OWER_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_OWER_P17_Msk = 0x20000
	// Bit P17.
	PIO_OWER_P17 = 0x20000
	// Position of P18 field.
	PIO_OWER_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_OWER_P18_Msk = 0x40000
	// Bit P18.
	PIO_OWER_P18 = 0x40000
	// Position of P19 field.
	PIO_OWER_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_OWER_P19_Msk = 0x80000
	// Bit P19.
	PIO_OWER_P19 = 0x80000
	// Position of P20 field.
	PIO_OWER_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_OWER_P20_Msk = 0x100000
	// Bit P20.
	PIO_OWER_P20 = 0x100000
	// Position of P21 field.
	PIO_OWER_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_OWER_P21_Msk = 0x200000
	// Bit P21.
	PIO_OWER_P21 = 0x200000
	// Position of P22 field.
	PIO_OWER_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_OWER_P22_Msk = 0x400000
	// Bit P22.
	PIO_OWER_P22 = 0x400000
	// Position of P23 field.
	PIO_OWER_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_OWER_P23_Msk = 0x800000
	// Bit P23.
	PIO_OWER_P23 = 0x800000
	// Position of P24 field.
	PIO_OWER_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_OWER_P24_Msk = 0x1000000
	// Bit P24.
	PIO_OWER_P24 = 0x1000000
	// Position of P25 field.
	PIO_OWER_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_OWER_P25_Msk = 0x2000000
	// Bit P25.
	PIO_OWER_P25 = 0x2000000
	// Position of P26 field.
	PIO_OWER_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_OWER_P26_Msk = 0x4000000
	// Bit P26.
	PIO_OWER_P26 = 0x4000000
	// Position of P27 field.
	PIO_OWER_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_OWER_P27_Msk = 0x8000000
	// Bit P27.
	PIO_OWER_P27 = 0x8000000
	// Position of P28 field.
	PIO_OWER_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_OWER_P28_Msk = 0x10000000
	// Bit P28.
	PIO_OWER_P28 = 0x10000000
	// Position of P29 field.
	PIO_OWER_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_OWER_P29_Msk = 0x20000000
	// Bit P29.
	PIO_OWER_P29 = 0x20000000
	// Position of P30 field.
	PIO_OWER_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_OWER_P30_Msk = 0x40000000
	// Bit P30.
	PIO_OWER_P30 = 0x40000000
	// Position of P31 field.
	PIO_OWER_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_OWER_P31_Msk = 0x80000000
	// Bit P31.
	PIO_OWER_P31 = 0x80000000

	// OWDR: Output Write Disable
	// Position of P0 field.
	PIO_OWDR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_OWDR_P0_Msk = 0x1
	// Bit P0.
	PIO_OWDR_P0 = 0x1
	// Position of P1 field.
	PIO_OWDR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_OWDR_P1_Msk = 0x2
	// Bit P1.
	PIO_OWDR_P1 = 0x2
	// Position of P2 field.
	PIO_OWDR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_OWDR_P2_Msk = 0x4
	// Bit P2.
	PIO_OWDR_P2 = 0x4
	// Position of P3 field.
	PIO_OWDR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_OWDR_P3_Msk = 0x8
	// Bit P3.
	PIO_OWDR_P3 = 0x8
	// Position of P4 field.
	PIO_OWDR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_OWDR_P4_Msk = 0x10
	// Bit P4.
	PIO_OWDR_P4 = 0x10
	// Position of P5 field.
	PIO_OWDR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_OWDR_P5_Msk = 0x20
	// Bit P5.
	PIO_OWDR_P5 = 0x20
	// Position of P6 field.
	PIO_OWDR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_OWDR_P6_Msk = 0x40
	// Bit P6.
	PIO_OWDR_P6 = 0x40
	// Position of P7 field.
	PIO_OWDR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_OWDR_P7_Msk = 0x80
	// Bit P7.
	PIO_OWDR_P7 = 0x80
	// Position of P8 field.
	PIO_OWDR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_OWDR_P8_Msk = 0x100
	// Bit P8.
	PIO_OWDR_P8 = 0x100
	// Position of P9 field.
	PIO_OWDR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_OWDR_P9_Msk = 0x200
	// Bit P9.
	PIO_OWDR_P9 = 0x200
	// Position of P10 field.
	PIO_OWDR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_OWDR_P10_Msk = 0x400
	// Bit P10.
	PIO_OWDR_P10 = 0x400
	// Position of P11 field.
	PIO_OWDR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_OWDR_P11_Msk = 0x800
	// Bit P11.
	PIO_OWDR_P11 = 0x800
	// Position of P12 field.
	PIO_OWDR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_OWDR_P12_Msk = 0x1000
	// Bit P12.
	PIO_OWDR_P12 = 0x1000
	// Position of P13 field.
	PIO_OWDR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_OWDR_P13_Msk = 0x2000
	// Bit P13.
	PIO_OWDR_P13 = 0x2000
	// Position of P14 field.
	PIO_OWDR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_OWDR_P14_Msk = 0x4000
	// Bit P14.
	PIO_OWDR_P14 = 0x4000
	// Position of P15 field.
	PIO_OWDR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_OWDR_P15_Msk = 0x8000
	// Bit P15.
	PIO_OWDR_P15 = 0x8000
	// Position of P16 field.
	PIO_OWDR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_OWDR_P16_Msk = 0x10000
	// Bit P16.
	PIO_OWDR_P16 = 0x10000
	// Position of P17 field.
	PIO_OWDR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_OWDR_P17_Msk = 0x20000
	// Bit P17.
	PIO_OWDR_P17 = 0x20000
	// Position of P18 field.
	PIO_OWDR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_OWDR_P18_Msk = 0x40000
	// Bit P18.
	PIO_OWDR_P18 = 0x40000
	// Position of P19 field.
	PIO_OWDR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_OWDR_P19_Msk = 0x80000
	// Bit P19.
	PIO_OWDR_P19 = 0x80000
	// Position of P20 field.
	PIO_OWDR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_OWDR_P20_Msk = 0x100000
	// Bit P20.
	PIO_OWDR_P20 = 0x100000
	// Position of P21 field.
	PIO_OWDR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_OWDR_P21_Msk = 0x200000
	// Bit P21.
	PIO_OWDR_P21 = 0x200000
	// Position of P22 field.
	PIO_OWDR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_OWDR_P22_Msk = 0x400000
	// Bit P22.
	PIO_OWDR_P22 = 0x400000
	// Position of P23 field.
	PIO_OWDR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_OWDR_P23_Msk = 0x800000
	// Bit P23.
	PIO_OWDR_P23 = 0x800000
	// Position of P24 field.
	PIO_OWDR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_OWDR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_OWDR_P24 = 0x1000000
	// Position of P25 field.
	PIO_OWDR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_OWDR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_OWDR_P25 = 0x2000000
	// Position of P26 field.
	PIO_OWDR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_OWDR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_OWDR_P26 = 0x4000000
	// Position of P27 field.
	PIO_OWDR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_OWDR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_OWDR_P27 = 0x8000000
	// Position of P28 field.
	PIO_OWDR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_OWDR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_OWDR_P28 = 0x10000000
	// Position of P29 field.
	PIO_OWDR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_OWDR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_OWDR_P29 = 0x20000000
	// Position of P30 field.
	PIO_OWDR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_OWDR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_OWDR_P30 = 0x40000000
	// Position of P31 field.
	PIO_OWDR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_OWDR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_OWDR_P31 = 0x80000000

	// OWSR: Output Write Status Register
	// Position of P0 field.
	PIO_OWSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_OWSR_P0_Msk = 0x1
	// Bit P0.
	PIO_OWSR_P0 = 0x1
	// Position of P1 field.
	PIO_OWSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_OWSR_P1_Msk = 0x2
	// Bit P1.
	PIO_OWSR_P1 = 0x2
	// Position of P2 field.
	PIO_OWSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_OWSR_P2_Msk = 0x4
	// Bit P2.
	PIO_OWSR_P2 = 0x4
	// Position of P3 field.
	PIO_OWSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_OWSR_P3_Msk = 0x8
	// Bit P3.
	PIO_OWSR_P3 = 0x8
	// Position of P4 field.
	PIO_OWSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_OWSR_P4_Msk = 0x10
	// Bit P4.
	PIO_OWSR_P4 = 0x10
	// Position of P5 field.
	PIO_OWSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_OWSR_P5_Msk = 0x20
	// Bit P5.
	PIO_OWSR_P5 = 0x20
	// Position of P6 field.
	PIO_OWSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_OWSR_P6_Msk = 0x40
	// Bit P6.
	PIO_OWSR_P6 = 0x40
	// Position of P7 field.
	PIO_OWSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_OWSR_P7_Msk = 0x80
	// Bit P7.
	PIO_OWSR_P7 = 0x80
	// Position of P8 field.
	PIO_OWSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_OWSR_P8_Msk = 0x100
	// Bit P8.
	PIO_OWSR_P8 = 0x100
	// Position of P9 field.
	PIO_OWSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_OWSR_P9_Msk = 0x200
	// Bit P9.
	PIO_OWSR_P9 = 0x200
	// Position of P10 field.
	PIO_OWSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_OWSR_P10_Msk = 0x400
	// Bit P10.
	PIO_OWSR_P10 = 0x400
	// Position of P11 field.
	PIO_OWSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_OWSR_P11_Msk = 0x800
	// Bit P11.
	PIO_OWSR_P11 = 0x800
	// Position of P12 field.
	PIO_OWSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_OWSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_OWSR_P12 = 0x1000
	// Position of P13 field.
	PIO_OWSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_OWSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_OWSR_P13 = 0x2000
	// Position of P14 field.
	PIO_OWSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_OWSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_OWSR_P14 = 0x4000
	// Position of P15 field.
	PIO_OWSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_OWSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_OWSR_P15 = 0x8000
	// Position of P16 field.
	PIO_OWSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_OWSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_OWSR_P16 = 0x10000
	// Position of P17 field.
	PIO_OWSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_OWSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_OWSR_P17 = 0x20000
	// Position of P18 field.
	PIO_OWSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_OWSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_OWSR_P18 = 0x40000
	// Position of P19 field.
	PIO_OWSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_OWSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_OWSR_P19 = 0x80000
	// Position of P20 field.
	PIO_OWSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_OWSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_OWSR_P20 = 0x100000
	// Position of P21 field.
	PIO_OWSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_OWSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_OWSR_P21 = 0x200000
	// Position of P22 field.
	PIO_OWSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_OWSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_OWSR_P22 = 0x400000
	// Position of P23 field.
	PIO_OWSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_OWSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_OWSR_P23 = 0x800000
	// Position of P24 field.
	PIO_OWSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_OWSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_OWSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_OWSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_OWSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_OWSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_OWSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_OWSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_OWSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_OWSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_OWSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_OWSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_OWSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_OWSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_OWSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_OWSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_OWSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_OWSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_OWSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_OWSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_OWSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_OWSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_OWSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_OWSR_P31 = 0x80000000

	// AIMER: Additional Interrupt Modes Enable Register
	// Position of P0 field.
	PIO_AIMER_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_AIMER_P0_Msk = 0x1
	// Bit P0.
	PIO_AIMER_P0 = 0x1
	// Position of P1 field.
	PIO_AIMER_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_AIMER_P1_Msk = 0x2
	// Bit P1.
	PIO_AIMER_P1 = 0x2
	// Position of P2 field.
	PIO_AIMER_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_AIMER_P2_Msk = 0x4
	// Bit P2.
	PIO_AIMER_P2 = 0x4
	// Position of P3 field.
	PIO_AIMER_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_AIMER_P3_Msk = 0x8
	// Bit P3.
	PIO_AIMER_P3 = 0x8
	// Position of P4 field.
	PIO_AIMER_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_AIMER_P4_Msk = 0x10
	// Bit P4.
	PIO_AIMER_P4 = 0x10
	// Position of P5 field.
	PIO_AIMER_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_AIMER_P5_Msk = 0x20
	// Bit P5.
	PIO_AIMER_P5 = 0x20
	// Position of P6 field.
	PIO_AIMER_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_AIMER_P6_Msk = 0x40
	// Bit P6.
	PIO_AIMER_P6 = 0x40
	// Position of P7 field.
	PIO_AIMER_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_AIMER_P7_Msk = 0x80
	// Bit P7.
	PIO_AIMER_P7 = 0x80
	// Position of P8 field.
	PIO_AIMER_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_AIMER_P8_Msk = 0x100
	// Bit P8.
	PIO_AIMER_P8 = 0x100
	// Position of P9 field.
	PIO_AIMER_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_AIMER_P9_Msk = 0x200
	// Bit P9.
	PIO_AIMER_P9 = 0x200
	// Position of P10 field.
	PIO_AIMER_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_AIMER_P10_Msk = 0x400
	// Bit P10.
	PIO_AIMER_P10 = 0x400
	// Position of P11 field.
	PIO_AIMER_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_AIMER_P11_Msk = 0x800
	// Bit P11.
	PIO_AIMER_P11 = 0x800
	// Position of P12 field.
	PIO_AIMER_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_AIMER_P12_Msk = 0x1000
	// Bit P12.
	PIO_AIMER_P12 = 0x1000
	// Position of P13 field.
	PIO_AIMER_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_AIMER_P13_Msk = 0x2000
	// Bit P13.
	PIO_AIMER_P13 = 0x2000
	// Position of P14 field.
	PIO_AIMER_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_AIMER_P14_Msk = 0x4000
	// Bit P14.
	PIO_AIMER_P14 = 0x4000
	// Position of P15 field.
	PIO_AIMER_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_AIMER_P15_Msk = 0x8000
	// Bit P15.
	PIO_AIMER_P15 = 0x8000
	// Position of P16 field.
	PIO_AIMER_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_AIMER_P16_Msk = 0x10000
	// Bit P16.
	PIO_AIMER_P16 = 0x10000
	// Position of P17 field.
	PIO_AIMER_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_AIMER_P17_Msk = 0x20000
	// Bit P17.
	PIO_AIMER_P17 = 0x20000
	// Position of P18 field.
	PIO_AIMER_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_AIMER_P18_Msk = 0x40000
	// Bit P18.
	PIO_AIMER_P18 = 0x40000
	// Position of P19 field.
	PIO_AIMER_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_AIMER_P19_Msk = 0x80000
	// Bit P19.
	PIO_AIMER_P19 = 0x80000
	// Position of P20 field.
	PIO_AIMER_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_AIMER_P20_Msk = 0x100000
	// Bit P20.
	PIO_AIMER_P20 = 0x100000
	// Position of P21 field.
	PIO_AIMER_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_AIMER_P21_Msk = 0x200000
	// Bit P21.
	PIO_AIMER_P21 = 0x200000
	// Position of P22 field.
	PIO_AIMER_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_AIMER_P22_Msk = 0x400000
	// Bit P22.
	PIO_AIMER_P22 = 0x400000
	// Position of P23 field.
	PIO_AIMER_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_AIMER_P23_Msk = 0x800000
	// Bit P23.
	PIO_AIMER_P23 = 0x800000
	// Position of P24 field.
	PIO_AIMER_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_AIMER_P24_Msk = 0x1000000
	// Bit P24.
	PIO_AIMER_P24 = 0x1000000
	// Position of P25 field.
	PIO_AIMER_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_AIMER_P25_Msk = 0x2000000
	// Bit P25.
	PIO_AIMER_P25 = 0x2000000
	// Position of P26 field.
	PIO_AIMER_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_AIMER_P26_Msk = 0x4000000
	// Bit P26.
	PIO_AIMER_P26 = 0x4000000
	// Position of P27 field.
	PIO_AIMER_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_AIMER_P27_Msk = 0x8000000
	// Bit P27.
	PIO_AIMER_P27 = 0x8000000
	// Position of P28 field.
	PIO_AIMER_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_AIMER_P28_Msk = 0x10000000
	// Bit P28.
	PIO_AIMER_P28 = 0x10000000
	// Position of P29 field.
	PIO_AIMER_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_AIMER_P29_Msk = 0x20000000
	// Bit P29.
	PIO_AIMER_P29 = 0x20000000
	// Position of P30 field.
	PIO_AIMER_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_AIMER_P30_Msk = 0x40000000
	// Bit P30.
	PIO_AIMER_P30 = 0x40000000
	// Position of P31 field.
	PIO_AIMER_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_AIMER_P31_Msk = 0x80000000
	// Bit P31.
	PIO_AIMER_P31 = 0x80000000

	// AIMDR: Additional Interrupt Modes Disables Register
	// Position of P0 field.
	PIO_AIMDR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_AIMDR_P0_Msk = 0x1
	// Bit P0.
	PIO_AIMDR_P0 = 0x1
	// Position of P1 field.
	PIO_AIMDR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_AIMDR_P1_Msk = 0x2
	// Bit P1.
	PIO_AIMDR_P1 = 0x2
	// Position of P2 field.
	PIO_AIMDR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_AIMDR_P2_Msk = 0x4
	// Bit P2.
	PIO_AIMDR_P2 = 0x4
	// Position of P3 field.
	PIO_AIMDR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_AIMDR_P3_Msk = 0x8
	// Bit P3.
	PIO_AIMDR_P3 = 0x8
	// Position of P4 field.
	PIO_AIMDR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_AIMDR_P4_Msk = 0x10
	// Bit P4.
	PIO_AIMDR_P4 = 0x10
	// Position of P5 field.
	PIO_AIMDR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_AIMDR_P5_Msk = 0x20
	// Bit P5.
	PIO_AIMDR_P5 = 0x20
	// Position of P6 field.
	PIO_AIMDR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_AIMDR_P6_Msk = 0x40
	// Bit P6.
	PIO_AIMDR_P6 = 0x40
	// Position of P7 field.
	PIO_AIMDR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_AIMDR_P7_Msk = 0x80
	// Bit P7.
	PIO_AIMDR_P7 = 0x80
	// Position of P8 field.
	PIO_AIMDR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_AIMDR_P8_Msk = 0x100
	// Bit P8.
	PIO_AIMDR_P8 = 0x100
	// Position of P9 field.
	PIO_AIMDR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_AIMDR_P9_Msk = 0x200
	// Bit P9.
	PIO_AIMDR_P9 = 0x200
	// Position of P10 field.
	PIO_AIMDR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_AIMDR_P10_Msk = 0x400
	// Bit P10.
	PIO_AIMDR_P10 = 0x400
	// Position of P11 field.
	PIO_AIMDR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_AIMDR_P11_Msk = 0x800
	// Bit P11.
	PIO_AIMDR_P11 = 0x800
	// Position of P12 field.
	PIO_AIMDR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_AIMDR_P12_Msk = 0x1000
	// Bit P12.
	PIO_AIMDR_P12 = 0x1000
	// Position of P13 field.
	PIO_AIMDR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_AIMDR_P13_Msk = 0x2000
	// Bit P13.
	PIO_AIMDR_P13 = 0x2000
	// Position of P14 field.
	PIO_AIMDR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_AIMDR_P14_Msk = 0x4000
	// Bit P14.
	PIO_AIMDR_P14 = 0x4000
	// Position of P15 field.
	PIO_AIMDR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_AIMDR_P15_Msk = 0x8000
	// Bit P15.
	PIO_AIMDR_P15 = 0x8000
	// Position of P16 field.
	PIO_AIMDR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_AIMDR_P16_Msk = 0x10000
	// Bit P16.
	PIO_AIMDR_P16 = 0x10000
	// Position of P17 field.
	PIO_AIMDR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_AIMDR_P17_Msk = 0x20000
	// Bit P17.
	PIO_AIMDR_P17 = 0x20000
	// Position of P18 field.
	PIO_AIMDR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_AIMDR_P18_Msk = 0x40000
	// Bit P18.
	PIO_AIMDR_P18 = 0x40000
	// Position of P19 field.
	PIO_AIMDR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_AIMDR_P19_Msk = 0x80000
	// Bit P19.
	PIO_AIMDR_P19 = 0x80000
	// Position of P20 field.
	PIO_AIMDR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_AIMDR_P20_Msk = 0x100000
	// Bit P20.
	PIO_AIMDR_P20 = 0x100000
	// Position of P21 field.
	PIO_AIMDR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_AIMDR_P21_Msk = 0x200000
	// Bit P21.
	PIO_AIMDR_P21 = 0x200000
	// Position of P22 field.
	PIO_AIMDR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_AIMDR_P22_Msk = 0x400000
	// Bit P22.
	PIO_AIMDR_P22 = 0x400000
	// Position of P23 field.
	PIO_AIMDR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_AIMDR_P23_Msk = 0x800000
	// Bit P23.
	PIO_AIMDR_P23 = 0x800000
	// Position of P24 field.
	PIO_AIMDR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_AIMDR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_AIMDR_P24 = 0x1000000
	// Position of P25 field.
	PIO_AIMDR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_AIMDR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_AIMDR_P25 = 0x2000000
	// Position of P26 field.
	PIO_AIMDR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_AIMDR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_AIMDR_P26 = 0x4000000
	// Position of P27 field.
	PIO_AIMDR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_AIMDR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_AIMDR_P27 = 0x8000000
	// Position of P28 field.
	PIO_AIMDR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_AIMDR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_AIMDR_P28 = 0x10000000
	// Position of P29 field.
	PIO_AIMDR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_AIMDR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_AIMDR_P29 = 0x20000000
	// Position of P30 field.
	PIO_AIMDR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_AIMDR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_AIMDR_P30 = 0x40000000
	// Position of P31 field.
	PIO_AIMDR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_AIMDR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_AIMDR_P31 = 0x80000000

	// AIMMR: Additional Interrupt Modes Mask Register
	// Position of P0 field.
	PIO_AIMMR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_AIMMR_P0_Msk = 0x1
	// Bit P0.
	PIO_AIMMR_P0 = 0x1
	// Position of P1 field.
	PIO_AIMMR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_AIMMR_P1_Msk = 0x2
	// Bit P1.
	PIO_AIMMR_P1 = 0x2
	// Position of P2 field.
	PIO_AIMMR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_AIMMR_P2_Msk = 0x4
	// Bit P2.
	PIO_AIMMR_P2 = 0x4
	// Position of P3 field.
	PIO_AIMMR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_AIMMR_P3_Msk = 0x8
	// Bit P3.
	PIO_AIMMR_P3 = 0x8
	// Position of P4 field.
	PIO_AIMMR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_AIMMR_P4_Msk = 0x10
	// Bit P4.
	PIO_AIMMR_P4 = 0x10
	// Position of P5 field.
	PIO_AIMMR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_AIMMR_P5_Msk = 0x20
	// Bit P5.
	PIO_AIMMR_P5 = 0x20
	// Position of P6 field.
	PIO_AIMMR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_AIMMR_P6_Msk = 0x40
	// Bit P6.
	PIO_AIMMR_P6 = 0x40
	// Position of P7 field.
	PIO_AIMMR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_AIMMR_P7_Msk = 0x80
	// Bit P7.
	PIO_AIMMR_P7 = 0x80
	// Position of P8 field.
	PIO_AIMMR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_AIMMR_P8_Msk = 0x100
	// Bit P8.
	PIO_AIMMR_P8 = 0x100
	// Position of P9 field.
	PIO_AIMMR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_AIMMR_P9_Msk = 0x200
	// Bit P9.
	PIO_AIMMR_P9 = 0x200
	// Position of P10 field.
	PIO_AIMMR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_AIMMR_P10_Msk = 0x400
	// Bit P10.
	PIO_AIMMR_P10 = 0x400
	// Position of P11 field.
	PIO_AIMMR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_AIMMR_P11_Msk = 0x800
	// Bit P11.
	PIO_AIMMR_P11 = 0x800
	// Position of P12 field.
	PIO_AIMMR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_AIMMR_P12_Msk = 0x1000
	// Bit P12.
	PIO_AIMMR_P12 = 0x1000
	// Position of P13 field.
	PIO_AIMMR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_AIMMR_P13_Msk = 0x2000
	// Bit P13.
	PIO_AIMMR_P13 = 0x2000
	// Position of P14 field.
	PIO_AIMMR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_AIMMR_P14_Msk = 0x4000
	// Bit P14.
	PIO_AIMMR_P14 = 0x4000
	// Position of P15 field.
	PIO_AIMMR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_AIMMR_P15_Msk = 0x8000
	// Bit P15.
	PIO_AIMMR_P15 = 0x8000
	// Position of P16 field.
	PIO_AIMMR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_AIMMR_P16_Msk = 0x10000
	// Bit P16.
	PIO_AIMMR_P16 = 0x10000
	// Position of P17 field.
	PIO_AIMMR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_AIMMR_P17_Msk = 0x20000
	// Bit P17.
	PIO_AIMMR_P17 = 0x20000
	// Position of P18 field.
	PIO_AIMMR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_AIMMR_P18_Msk = 0x40000
	// Bit P18.
	PIO_AIMMR_P18 = 0x40000
	// Position of P19 field.
	PIO_AIMMR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_AIMMR_P19_Msk = 0x80000
	// Bit P19.
	PIO_AIMMR_P19 = 0x80000
	// Position of P20 field.
	PIO_AIMMR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_AIMMR_P20_Msk = 0x100000
	// Bit P20.
	PIO_AIMMR_P20 = 0x100000
	// Position of P21 field.
	PIO_AIMMR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_AIMMR_P21_Msk = 0x200000
	// Bit P21.
	PIO_AIMMR_P21 = 0x200000
	// Position of P22 field.
	PIO_AIMMR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_AIMMR_P22_Msk = 0x400000
	// Bit P22.
	PIO_AIMMR_P22 = 0x400000
	// Position of P23 field.
	PIO_AIMMR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_AIMMR_P23_Msk = 0x800000
	// Bit P23.
	PIO_AIMMR_P23 = 0x800000
	// Position of P24 field.
	PIO_AIMMR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_AIMMR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_AIMMR_P24 = 0x1000000
	// Position of P25 field.
	PIO_AIMMR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_AIMMR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_AIMMR_P25 = 0x2000000
	// Position of P26 field.
	PIO_AIMMR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_AIMMR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_AIMMR_P26 = 0x4000000
	// Position of P27 field.
	PIO_AIMMR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_AIMMR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_AIMMR_P27 = 0x8000000
	// Position of P28 field.
	PIO_AIMMR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_AIMMR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_AIMMR_P28 = 0x10000000
	// Position of P29 field.
	PIO_AIMMR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_AIMMR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_AIMMR_P29 = 0x20000000
	// Position of P30 field.
	PIO_AIMMR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_AIMMR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_AIMMR_P30 = 0x40000000
	// Position of P31 field.
	PIO_AIMMR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_AIMMR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_AIMMR_P31 = 0x80000000

	// ESR: Edge Select Register
	// Position of P0 field.
	PIO_ESR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_ESR_P0_Msk = 0x1
	// Bit P0.
	PIO_ESR_P0 = 0x1
	// Position of P1 field.
	PIO_ESR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_ESR_P1_Msk = 0x2
	// Bit P1.
	PIO_ESR_P1 = 0x2
	// Position of P2 field.
	PIO_ESR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_ESR_P2_Msk = 0x4
	// Bit P2.
	PIO_ESR_P2 = 0x4
	// Position of P3 field.
	PIO_ESR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_ESR_P3_Msk = 0x8
	// Bit P3.
	PIO_ESR_P3 = 0x8
	// Position of P4 field.
	PIO_ESR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_ESR_P4_Msk = 0x10
	// Bit P4.
	PIO_ESR_P4 = 0x10
	// Position of P5 field.
	PIO_ESR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_ESR_P5_Msk = 0x20
	// Bit P5.
	PIO_ESR_P5 = 0x20
	// Position of P6 field.
	PIO_ESR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_ESR_P6_Msk = 0x40
	// Bit P6.
	PIO_ESR_P6 = 0x40
	// Position of P7 field.
	PIO_ESR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_ESR_P7_Msk = 0x80
	// Bit P7.
	PIO_ESR_P7 = 0x80
	// Position of P8 field.
	PIO_ESR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_ESR_P8_Msk = 0x100
	// Bit P8.
	PIO_ESR_P8 = 0x100
	// Position of P9 field.
	PIO_ESR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_ESR_P9_Msk = 0x200
	// Bit P9.
	PIO_ESR_P9 = 0x200
	// Position of P10 field.
	PIO_ESR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_ESR_P10_Msk = 0x400
	// Bit P10.
	PIO_ESR_P10 = 0x400
	// Position of P11 field.
	PIO_ESR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_ESR_P11_Msk = 0x800
	// Bit P11.
	PIO_ESR_P11 = 0x800
	// Position of P12 field.
	PIO_ESR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_ESR_P12_Msk = 0x1000
	// Bit P12.
	PIO_ESR_P12 = 0x1000
	// Position of P13 field.
	PIO_ESR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_ESR_P13_Msk = 0x2000
	// Bit P13.
	PIO_ESR_P13 = 0x2000
	// Position of P14 field.
	PIO_ESR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_ESR_P14_Msk = 0x4000
	// Bit P14.
	PIO_ESR_P14 = 0x4000
	// Position of P15 field.
	PIO_ESR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_ESR_P15_Msk = 0x8000
	// Bit P15.
	PIO_ESR_P15 = 0x8000
	// Position of P16 field.
	PIO_ESR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_ESR_P16_Msk = 0x10000
	// Bit P16.
	PIO_ESR_P16 = 0x10000
	// Position of P17 field.
	PIO_ESR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_ESR_P17_Msk = 0x20000
	// Bit P17.
	PIO_ESR_P17 = 0x20000
	// Position of P18 field.
	PIO_ESR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_ESR_P18_Msk = 0x40000
	// Bit P18.
	PIO_ESR_P18 = 0x40000
	// Position of P19 field.
	PIO_ESR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_ESR_P19_Msk = 0x80000
	// Bit P19.
	PIO_ESR_P19 = 0x80000
	// Position of P20 field.
	PIO_ESR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_ESR_P20_Msk = 0x100000
	// Bit P20.
	PIO_ESR_P20 = 0x100000
	// Position of P21 field.
	PIO_ESR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_ESR_P21_Msk = 0x200000
	// Bit P21.
	PIO_ESR_P21 = 0x200000
	// Position of P22 field.
	PIO_ESR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_ESR_P22_Msk = 0x400000
	// Bit P22.
	PIO_ESR_P22 = 0x400000
	// Position of P23 field.
	PIO_ESR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_ESR_P23_Msk = 0x800000
	// Bit P23.
	PIO_ESR_P23 = 0x800000
	// Position of P24 field.
	PIO_ESR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_ESR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_ESR_P24 = 0x1000000
	// Position of P25 field.
	PIO_ESR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_ESR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_ESR_P25 = 0x2000000
	// Position of P26 field.
	PIO_ESR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_ESR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_ESR_P26 = 0x4000000
	// Position of P27 field.
	PIO_ESR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_ESR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_ESR_P27 = 0x8000000
	// Position of P28 field.
	PIO_ESR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_ESR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_ESR_P28 = 0x10000000
	// Position of P29 field.
	PIO_ESR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_ESR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_ESR_P29 = 0x20000000
	// Position of P30 field.
	PIO_ESR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_ESR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_ESR_P30 = 0x40000000
	// Position of P31 field.
	PIO_ESR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_ESR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_ESR_P31 = 0x80000000

	// LSR: Level Select Register
	// Position of P0 field.
	PIO_LSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_LSR_P0_Msk = 0x1
	// Bit P0.
	PIO_LSR_P0 = 0x1
	// Position of P1 field.
	PIO_LSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_LSR_P1_Msk = 0x2
	// Bit P1.
	PIO_LSR_P1 = 0x2
	// Position of P2 field.
	PIO_LSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_LSR_P2_Msk = 0x4
	// Bit P2.
	PIO_LSR_P2 = 0x4
	// Position of P3 field.
	PIO_LSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_LSR_P3_Msk = 0x8
	// Bit P3.
	PIO_LSR_P3 = 0x8
	// Position of P4 field.
	PIO_LSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_LSR_P4_Msk = 0x10
	// Bit P4.
	PIO_LSR_P4 = 0x10
	// Position of P5 field.
	PIO_LSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_LSR_P5_Msk = 0x20
	// Bit P5.
	PIO_LSR_P5 = 0x20
	// Position of P6 field.
	PIO_LSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_LSR_P6_Msk = 0x40
	// Bit P6.
	PIO_LSR_P6 = 0x40
	// Position of P7 field.
	PIO_LSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_LSR_P7_Msk = 0x80
	// Bit P7.
	PIO_LSR_P7 = 0x80
	// Position of P8 field.
	PIO_LSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_LSR_P8_Msk = 0x100
	// Bit P8.
	PIO_LSR_P8 = 0x100
	// Position of P9 field.
	PIO_LSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_LSR_P9_Msk = 0x200
	// Bit P9.
	PIO_LSR_P9 = 0x200
	// Position of P10 field.
	PIO_LSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_LSR_P10_Msk = 0x400
	// Bit P10.
	PIO_LSR_P10 = 0x400
	// Position of P11 field.
	PIO_LSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_LSR_P11_Msk = 0x800
	// Bit P11.
	PIO_LSR_P11 = 0x800
	// Position of P12 field.
	PIO_LSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_LSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_LSR_P12 = 0x1000
	// Position of P13 field.
	PIO_LSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_LSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_LSR_P13 = 0x2000
	// Position of P14 field.
	PIO_LSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_LSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_LSR_P14 = 0x4000
	// Position of P15 field.
	PIO_LSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_LSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_LSR_P15 = 0x8000
	// Position of P16 field.
	PIO_LSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_LSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_LSR_P16 = 0x10000
	// Position of P17 field.
	PIO_LSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_LSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_LSR_P17 = 0x20000
	// Position of P18 field.
	PIO_LSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_LSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_LSR_P18 = 0x40000
	// Position of P19 field.
	PIO_LSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_LSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_LSR_P19 = 0x80000
	// Position of P20 field.
	PIO_LSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_LSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_LSR_P20 = 0x100000
	// Position of P21 field.
	PIO_LSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_LSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_LSR_P21 = 0x200000
	// Position of P22 field.
	PIO_LSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_LSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_LSR_P22 = 0x400000
	// Position of P23 field.
	PIO_LSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_LSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_LSR_P23 = 0x800000
	// Position of P24 field.
	PIO_LSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_LSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_LSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_LSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_LSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_LSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_LSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_LSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_LSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_LSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_LSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_LSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_LSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_LSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_LSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_LSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_LSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_LSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_LSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_LSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_LSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_LSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_LSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_LSR_P31 = 0x80000000

	// ELSR: Edge/Level Status Register
	// Position of P0 field.
	PIO_ELSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_ELSR_P0_Msk = 0x1
	// Bit P0.
	PIO_ELSR_P0 = 0x1
	// Position of P1 field.
	PIO_ELSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_ELSR_P1_Msk = 0x2
	// Bit P1.
	PIO_ELSR_P1 = 0x2
	// Position of P2 field.
	PIO_ELSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_ELSR_P2_Msk = 0x4
	// Bit P2.
	PIO_ELSR_P2 = 0x4
	// Position of P3 field.
	PIO_ELSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_ELSR_P3_Msk = 0x8
	// Bit P3.
	PIO_ELSR_P3 = 0x8
	// Position of P4 field.
	PIO_ELSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_ELSR_P4_Msk = 0x10
	// Bit P4.
	PIO_ELSR_P4 = 0x10
	// Position of P5 field.
	PIO_ELSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_ELSR_P5_Msk = 0x20
	// Bit P5.
	PIO_ELSR_P5 = 0x20
	// Position of P6 field.
	PIO_ELSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_ELSR_P6_Msk = 0x40
	// Bit P6.
	PIO_ELSR_P6 = 0x40
	// Position of P7 field.
	PIO_ELSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_ELSR_P7_Msk = 0x80
	// Bit P7.
	PIO_ELSR_P7 = 0x80
	// Position of P8 field.
	PIO_ELSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_ELSR_P8_Msk = 0x100
	// Bit P8.
	PIO_ELSR_P8 = 0x100
	// Position of P9 field.
	PIO_ELSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_ELSR_P9_Msk = 0x200
	// Bit P9.
	PIO_ELSR_P9 = 0x200
	// Position of P10 field.
	PIO_ELSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_ELSR_P10_Msk = 0x400
	// Bit P10.
	PIO_ELSR_P10 = 0x400
	// Position of P11 field.
	PIO_ELSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_ELSR_P11_Msk = 0x800
	// Bit P11.
	PIO_ELSR_P11 = 0x800
	// Position of P12 field.
	PIO_ELSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_ELSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_ELSR_P12 = 0x1000
	// Position of P13 field.
	PIO_ELSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_ELSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_ELSR_P13 = 0x2000
	// Position of P14 field.
	PIO_ELSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_ELSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_ELSR_P14 = 0x4000
	// Position of P15 field.
	PIO_ELSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_ELSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_ELSR_P15 = 0x8000
	// Position of P16 field.
	PIO_ELSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_ELSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_ELSR_P16 = 0x10000
	// Position of P17 field.
	PIO_ELSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_ELSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_ELSR_P17 = 0x20000
	// Position of P18 field.
	PIO_ELSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_ELSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_ELSR_P18 = 0x40000
	// Position of P19 field.
	PIO_ELSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_ELSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_ELSR_P19 = 0x80000
	// Position of P20 field.
	PIO_ELSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_ELSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_ELSR_P20 = 0x100000
	// Position of P21 field.
	PIO_ELSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_ELSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_ELSR_P21 = 0x200000
	// Position of P22 field.
	PIO_ELSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_ELSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_ELSR_P22 = 0x400000
	// Position of P23 field.
	PIO_ELSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_ELSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_ELSR_P23 = 0x800000
	// Position of P24 field.
	PIO_ELSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_ELSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_ELSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_ELSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_ELSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_ELSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_ELSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_ELSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_ELSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_ELSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_ELSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_ELSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_ELSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_ELSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_ELSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_ELSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_ELSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_ELSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_ELSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_ELSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_ELSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_ELSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_ELSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_ELSR_P31 = 0x80000000

	// FELLSR: Falling Edge/Low Level Select Register
	// Position of P0 field.
	PIO_FELLSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_FELLSR_P0_Msk = 0x1
	// Bit P0.
	PIO_FELLSR_P0 = 0x1
	// Position of P1 field.
	PIO_FELLSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_FELLSR_P1_Msk = 0x2
	// Bit P1.
	PIO_FELLSR_P1 = 0x2
	// Position of P2 field.
	PIO_FELLSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_FELLSR_P2_Msk = 0x4
	// Bit P2.
	PIO_FELLSR_P2 = 0x4
	// Position of P3 field.
	PIO_FELLSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_FELLSR_P3_Msk = 0x8
	// Bit P3.
	PIO_FELLSR_P3 = 0x8
	// Position of P4 field.
	PIO_FELLSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_FELLSR_P4_Msk = 0x10
	// Bit P4.
	PIO_FELLSR_P4 = 0x10
	// Position of P5 field.
	PIO_FELLSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_FELLSR_P5_Msk = 0x20
	// Bit P5.
	PIO_FELLSR_P5 = 0x20
	// Position of P6 field.
	PIO_FELLSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_FELLSR_P6_Msk = 0x40
	// Bit P6.
	PIO_FELLSR_P6 = 0x40
	// Position of P7 field.
	PIO_FELLSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_FELLSR_P7_Msk = 0x80
	// Bit P7.
	PIO_FELLSR_P7 = 0x80
	// Position of P8 field.
	PIO_FELLSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_FELLSR_P8_Msk = 0x100
	// Bit P8.
	PIO_FELLSR_P8 = 0x100
	// Position of P9 field.
	PIO_FELLSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_FELLSR_P9_Msk = 0x200
	// Bit P9.
	PIO_FELLSR_P9 = 0x200
	// Position of P10 field.
	PIO_FELLSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_FELLSR_P10_Msk = 0x400
	// Bit P10.
	PIO_FELLSR_P10 = 0x400
	// Position of P11 field.
	PIO_FELLSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_FELLSR_P11_Msk = 0x800
	// Bit P11.
	PIO_FELLSR_P11 = 0x800
	// Position of P12 field.
	PIO_FELLSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_FELLSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_FELLSR_P12 = 0x1000
	// Position of P13 field.
	PIO_FELLSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_FELLSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_FELLSR_P13 = 0x2000
	// Position of P14 field.
	PIO_FELLSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_FELLSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_FELLSR_P14 = 0x4000
	// Position of P15 field.
	PIO_FELLSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_FELLSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_FELLSR_P15 = 0x8000
	// Position of P16 field.
	PIO_FELLSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_FELLSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_FELLSR_P16 = 0x10000
	// Position of P17 field.
	PIO_FELLSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_FELLSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_FELLSR_P17 = 0x20000
	// Position of P18 field.
	PIO_FELLSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_FELLSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_FELLSR_P18 = 0x40000
	// Position of P19 field.
	PIO_FELLSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_FELLSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_FELLSR_P19 = 0x80000
	// Position of P20 field.
	PIO_FELLSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_FELLSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_FELLSR_P20 = 0x100000
	// Position of P21 field.
	PIO_FELLSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_FELLSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_FELLSR_P21 = 0x200000
	// Position of P22 field.
	PIO_FELLSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_FELLSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_FELLSR_P22 = 0x400000
	// Position of P23 field.
	PIO_FELLSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_FELLSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_FELLSR_P23 = 0x800000
	// Position of P24 field.
	PIO_FELLSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_FELLSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_FELLSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_FELLSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_FELLSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_FELLSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_FELLSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_FELLSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_FELLSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_FELLSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_FELLSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_FELLSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_FELLSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_FELLSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_FELLSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_FELLSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_FELLSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_FELLSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_FELLSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_FELLSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_FELLSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_FELLSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_FELLSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_FELLSR_P31 = 0x80000000

	// REHLSR: Rising Edge/ High Level Select Register
	// Position of P0 field.
	PIO_REHLSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_REHLSR_P0_Msk = 0x1
	// Bit P0.
	PIO_REHLSR_P0 = 0x1
	// Position of P1 field.
	PIO_REHLSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_REHLSR_P1_Msk = 0x2
	// Bit P1.
	PIO_REHLSR_P1 = 0x2
	// Position of P2 field.
	PIO_REHLSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_REHLSR_P2_Msk = 0x4
	// Bit P2.
	PIO_REHLSR_P2 = 0x4
	// Position of P3 field.
	PIO_REHLSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_REHLSR_P3_Msk = 0x8
	// Bit P3.
	PIO_REHLSR_P3 = 0x8
	// Position of P4 field.
	PIO_REHLSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_REHLSR_P4_Msk = 0x10
	// Bit P4.
	PIO_REHLSR_P4 = 0x10
	// Position of P5 field.
	PIO_REHLSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_REHLSR_P5_Msk = 0x20
	// Bit P5.
	PIO_REHLSR_P5 = 0x20
	// Position of P6 field.
	PIO_REHLSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_REHLSR_P6_Msk = 0x40
	// Bit P6.
	PIO_REHLSR_P6 = 0x40
	// Position of P7 field.
	PIO_REHLSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_REHLSR_P7_Msk = 0x80
	// Bit P7.
	PIO_REHLSR_P7 = 0x80
	// Position of P8 field.
	PIO_REHLSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_REHLSR_P8_Msk = 0x100
	// Bit P8.
	PIO_REHLSR_P8 = 0x100
	// Position of P9 field.
	PIO_REHLSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_REHLSR_P9_Msk = 0x200
	// Bit P9.
	PIO_REHLSR_P9 = 0x200
	// Position of P10 field.
	PIO_REHLSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_REHLSR_P10_Msk = 0x400
	// Bit P10.
	PIO_REHLSR_P10 = 0x400
	// Position of P11 field.
	PIO_REHLSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_REHLSR_P11_Msk = 0x800
	// Bit P11.
	PIO_REHLSR_P11 = 0x800
	// Position of P12 field.
	PIO_REHLSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_REHLSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_REHLSR_P12 = 0x1000
	// Position of P13 field.
	PIO_REHLSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_REHLSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_REHLSR_P13 = 0x2000
	// Position of P14 field.
	PIO_REHLSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_REHLSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_REHLSR_P14 = 0x4000
	// Position of P15 field.
	PIO_REHLSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_REHLSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_REHLSR_P15 = 0x8000
	// Position of P16 field.
	PIO_REHLSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_REHLSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_REHLSR_P16 = 0x10000
	// Position of P17 field.
	PIO_REHLSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_REHLSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_REHLSR_P17 = 0x20000
	// Position of P18 field.
	PIO_REHLSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_REHLSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_REHLSR_P18 = 0x40000
	// Position of P19 field.
	PIO_REHLSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_REHLSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_REHLSR_P19 = 0x80000
	// Position of P20 field.
	PIO_REHLSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_REHLSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_REHLSR_P20 = 0x100000
	// Position of P21 field.
	PIO_REHLSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_REHLSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_REHLSR_P21 = 0x200000
	// Position of P22 field.
	PIO_REHLSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_REHLSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_REHLSR_P22 = 0x400000
	// Position of P23 field.
	PIO_REHLSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_REHLSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_REHLSR_P23 = 0x800000
	// Position of P24 field.
	PIO_REHLSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_REHLSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_REHLSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_REHLSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_REHLSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_REHLSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_REHLSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_REHLSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_REHLSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_REHLSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_REHLSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_REHLSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_REHLSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_REHLSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_REHLSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_REHLSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_REHLSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_REHLSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_REHLSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_REHLSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_REHLSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_REHLSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_REHLSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_REHLSR_P31 = 0x80000000

	// FRLHSR: Fall/Rise - Low/High Status Register
	// Position of P0 field.
	PIO_FRLHSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_FRLHSR_P0_Msk = 0x1
	// Bit P0.
	PIO_FRLHSR_P0 = 0x1
	// Position of P1 field.
	PIO_FRLHSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_FRLHSR_P1_Msk = 0x2
	// Bit P1.
	PIO_FRLHSR_P1 = 0x2
	// Position of P2 field.
	PIO_FRLHSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_FRLHSR_P2_Msk = 0x4
	// Bit P2.
	PIO_FRLHSR_P2 = 0x4
	// Position of P3 field.
	PIO_FRLHSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_FRLHSR_P3_Msk = 0x8
	// Bit P3.
	PIO_FRLHSR_P3 = 0x8
	// Position of P4 field.
	PIO_FRLHSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_FRLHSR_P4_Msk = 0x10
	// Bit P4.
	PIO_FRLHSR_P4 = 0x10
	// Position of P5 field.
	PIO_FRLHSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_FRLHSR_P5_Msk = 0x20
	// Bit P5.
	PIO_FRLHSR_P5 = 0x20
	// Position of P6 field.
	PIO_FRLHSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_FRLHSR_P6_Msk = 0x40
	// Bit P6.
	PIO_FRLHSR_P6 = 0x40
	// Position of P7 field.
	PIO_FRLHSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_FRLHSR_P7_Msk = 0x80
	// Bit P7.
	PIO_FRLHSR_P7 = 0x80
	// Position of P8 field.
	PIO_FRLHSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_FRLHSR_P8_Msk = 0x100
	// Bit P8.
	PIO_FRLHSR_P8 = 0x100
	// Position of P9 field.
	PIO_FRLHSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_FRLHSR_P9_Msk = 0x200
	// Bit P9.
	PIO_FRLHSR_P9 = 0x200
	// Position of P10 field.
	PIO_FRLHSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_FRLHSR_P10_Msk = 0x400
	// Bit P10.
	PIO_FRLHSR_P10 = 0x400
	// Position of P11 field.
	PIO_FRLHSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_FRLHSR_P11_Msk = 0x800
	// Bit P11.
	PIO_FRLHSR_P11 = 0x800
	// Position of P12 field.
	PIO_FRLHSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_FRLHSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_FRLHSR_P12 = 0x1000
	// Position of P13 field.
	PIO_FRLHSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_FRLHSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_FRLHSR_P13 = 0x2000
	// Position of P14 field.
	PIO_FRLHSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_FRLHSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_FRLHSR_P14 = 0x4000
	// Position of P15 field.
	PIO_FRLHSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_FRLHSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_FRLHSR_P15 = 0x8000
	// Position of P16 field.
	PIO_FRLHSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_FRLHSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_FRLHSR_P16 = 0x10000
	// Position of P17 field.
	PIO_FRLHSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_FRLHSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_FRLHSR_P17 = 0x20000
	// Position of P18 field.
	PIO_FRLHSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_FRLHSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_FRLHSR_P18 = 0x40000
	// Position of P19 field.
	PIO_FRLHSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_FRLHSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_FRLHSR_P19 = 0x80000
	// Position of P20 field.
	PIO_FRLHSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_FRLHSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_FRLHSR_P20 = 0x100000
	// Position of P21 field.
	PIO_FRLHSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_FRLHSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_FRLHSR_P21 = 0x200000
	// Position of P22 field.
	PIO_FRLHSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_FRLHSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_FRLHSR_P22 = 0x400000
	// Position of P23 field.
	PIO_FRLHSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_FRLHSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_FRLHSR_P23 = 0x800000
	// Position of P24 field.
	PIO_FRLHSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_FRLHSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_FRLHSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_FRLHSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_FRLHSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_FRLHSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_FRLHSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_FRLHSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_FRLHSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_FRLHSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_FRLHSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_FRLHSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_FRLHSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_FRLHSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_FRLHSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_FRLHSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_FRLHSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_FRLHSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_FRLHSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_FRLHSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_FRLHSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_FRLHSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_FRLHSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_FRLHSR_P31 = 0x80000000

	// LOCKSR: Lock Status
	// Position of P0 field.
	PIO_LOCKSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_LOCKSR_P0_Msk = 0x1
	// Bit P0.
	PIO_LOCKSR_P0 = 0x1
	// Position of P1 field.
	PIO_LOCKSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_LOCKSR_P1_Msk = 0x2
	// Bit P1.
	PIO_LOCKSR_P1 = 0x2
	// Position of P2 field.
	PIO_LOCKSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_LOCKSR_P2_Msk = 0x4
	// Bit P2.
	PIO_LOCKSR_P2 = 0x4
	// Position of P3 field.
	PIO_LOCKSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_LOCKSR_P3_Msk = 0x8
	// Bit P3.
	PIO_LOCKSR_P3 = 0x8
	// Position of P4 field.
	PIO_LOCKSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_LOCKSR_P4_Msk = 0x10
	// Bit P4.
	PIO_LOCKSR_P4 = 0x10
	// Position of P5 field.
	PIO_LOCKSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_LOCKSR_P5_Msk = 0x20
	// Bit P5.
	PIO_LOCKSR_P5 = 0x20
	// Position of P6 field.
	PIO_LOCKSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_LOCKSR_P6_Msk = 0x40
	// Bit P6.
	PIO_LOCKSR_P6 = 0x40
	// Position of P7 field.
	PIO_LOCKSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_LOCKSR_P7_Msk = 0x80
	// Bit P7.
	PIO_LOCKSR_P7 = 0x80
	// Position of P8 field.
	PIO_LOCKSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_LOCKSR_P8_Msk = 0x100
	// Bit P8.
	PIO_LOCKSR_P8 = 0x100
	// Position of P9 field.
	PIO_LOCKSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_LOCKSR_P9_Msk = 0x200
	// Bit P9.
	PIO_LOCKSR_P9 = 0x200
	// Position of P10 field.
	PIO_LOCKSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_LOCKSR_P10_Msk = 0x400
	// Bit P10.
	PIO_LOCKSR_P10 = 0x400
	// Position of P11 field.
	PIO_LOCKSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_LOCKSR_P11_Msk = 0x800
	// Bit P11.
	PIO_LOCKSR_P11 = 0x800
	// Position of P12 field.
	PIO_LOCKSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_LOCKSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_LOCKSR_P12 = 0x1000
	// Position of P13 field.
	PIO_LOCKSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_LOCKSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_LOCKSR_P13 = 0x2000
	// Position of P14 field.
	PIO_LOCKSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_LOCKSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_LOCKSR_P14 = 0x4000
	// Position of P15 field.
	PIO_LOCKSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_LOCKSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_LOCKSR_P15 = 0x8000
	// Position of P16 field.
	PIO_LOCKSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_LOCKSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_LOCKSR_P16 = 0x10000
	// Position of P17 field.
	PIO_LOCKSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_LOCKSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_LOCKSR_P17 = 0x20000
	// Position of P18 field.
	PIO_LOCKSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_LOCKSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_LOCKSR_P18 = 0x40000
	// Position of P19 field.
	PIO_LOCKSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_LOCKSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_LOCKSR_P19 = 0x80000
	// Position of P20 field.
	PIO_LOCKSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_LOCKSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_LOCKSR_P20 = 0x100000
	// Position of P21 field.
	PIO_LOCKSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_LOCKSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_LOCKSR_P21 = 0x200000
	// Position of P22 field.
	PIO_LOCKSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_LOCKSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_LOCKSR_P22 = 0x400000
	// Position of P23 field.
	PIO_LOCKSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_LOCKSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_LOCKSR_P23 = 0x800000
	// Position of P24 field.
	PIO_LOCKSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_LOCKSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_LOCKSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_LOCKSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_LOCKSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_LOCKSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_LOCKSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_LOCKSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_LOCKSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_LOCKSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_LOCKSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_LOCKSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_LOCKSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_LOCKSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_LOCKSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_LOCKSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_LOCKSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_LOCKSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_LOCKSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_LOCKSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_LOCKSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_LOCKSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_LOCKSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_LOCKSR_P31 = 0x80000000

	// WPMR: Write Protect Mode Register
	// Position of WPEN field.
	PIO_WPMR_WPEN_Pos = 0x0
	// Bit mask of WPEN field.
	PIO_WPMR_WPEN_Msk = 0x1
	// Bit WPEN.
	PIO_WPMR_WPEN = 0x1
	// Position of WPKEY field.
	PIO_WPMR_WPKEY_Pos = 0x8
	// Bit mask of WPKEY field.
	PIO_WPMR_WPKEY_Msk = 0xffffff00

	// WPSR: Write Protect Status Register
	// Position of WPVS field.
	PIO_WPSR_WPVS_Pos = 0x0
	// Bit mask of WPVS field.
	PIO_WPSR_WPVS_Msk = 0x1
	// Bit WPVS.
	PIO_WPSR_WPVS = 0x1
	// Position of WPVSRC field.
	PIO_WPSR_WPVSRC_Pos = 0x8
	// Bit mask of WPVSRC field.
	PIO_WPSR_WPVSRC_Msk = 0xffff00
)

// Bitfields for RSTC: Reset Controller
const (
	// CR: Control Register
	// Position of PROCRST field.
	SYSC_CR_PROCRST_Pos = 0x0
	// Bit mask of PROCRST field.
	SYSC_CR_PROCRST_Msk = 0x1
	// Bit PROCRST.
	SYSC_CR_PROCRST = 0x1
	// Position of PERRST field.
	SYSC_CR_PERRST_Pos = 0x2
	// Bit mask of PERRST field.
	SYSC_CR_PERRST_Msk = 0x4
	// Bit PERRST.
	SYSC_CR_PERRST = 0x4
	// Position of EXTRST field.
	SYSC_CR_EXTRST_Pos = 0x3
	// Bit mask of EXTRST field.
	SYSC_CR_EXTRST_Msk = 0x8
	// Bit EXTRST.
	SYSC_CR_EXTRST = 0x8
	// Position of KEY field.
	SYSC_CR_KEY_Pos = 0x18
	// Bit mask of KEY field.
	SYSC_CR_KEY_Msk = 0xff000000
	// Writing any other value in this field aborts the write operation.
	SYSC_CR_KEY_PASSWD = 0xa5

	// SR: Status Register
	// Position of URSTS field.
	SYSC_SR_URSTS_Pos = 0x0
	// Bit mask of URSTS field.
	SYSC_SR_URSTS_Msk = 0x1
	// Bit URSTS.
	SYSC_SR_URSTS = 0x1
	// Position of RSTTYP field.
	SYSC_SR_RSTTYP_Pos = 0x8
	// Bit mask of RSTTYP field.
	SYSC_SR_RSTTYP_Msk = 0x700
	// First power-up Reset
	SYSC_SR_RSTTYP_GeneralReset = 0x0
	// Return from Backup Mode
	SYSC_SR_RSTTYP_BackupReset = 0x1
	// Watchdog fault occurred
	SYSC_SR_RSTTYP_WatchdogReset = 0x2
	// Processor reset required by the software
	SYSC_SR_RSTTYP_SoftwareReset = 0x3
	// NRST pin detected low
	SYSC_SR_RSTTYP_UserReset = 0x4
	// Position of NRSTL field.
	SYSC_SR_NRSTL_Pos = 0x10
	// Bit mask of NRSTL field.
	SYSC_SR_NRSTL_Msk = 0x10000
	// Bit NRSTL.
	SYSC_SR_NRSTL = 0x10000
	// Position of SRCMP field.
	SYSC_SR_SRCMP_Pos = 0x11
	// Bit mask of SRCMP field.
	SYSC_SR_SRCMP_Msk = 0x20000
	// Bit SRCMP.
	SYSC_SR_SRCMP = 0x20000

	// MR: Mode Register
	// Position of URSTEN field.
	SYSC_MR_URSTEN_Pos = 0x0
	// Bit mask of URSTEN field.
	SYSC_MR_URSTEN_Msk = 0x1
	// Bit URSTEN.
	SYSC_MR_URSTEN = 0x1
	// Position of URSTIEN field.
	SYSC_MR_URSTIEN_Pos = 0x4
	// Bit mask of URSTIEN field.
	SYSC_MR_URSTIEN_Msk = 0x10
	// Bit URSTIEN.
	SYSC_MR_URSTIEN = 0x10
	// Position of ERSTL field.
	SYSC_MR_ERSTL_Pos = 0x8
	// Bit mask of ERSTL field.
	SYSC_MR_ERSTL_Msk = 0xf00
	// Position of KEY field.
	SYSC_MR_KEY_Pos = 0x18
	// Bit mask of KEY field.
	SYSC_MR_KEY_Msk = 0xff000000
	// Writing any other value in this field aborts the write operation.Always reads as 0.
	SYSC_MR_KEY_PASSWD = 0xa5
)
